# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['shift15m', 'shift15m.datasets']

package_data = \
{'': ['*']}

install_requires = \
['Sphinx>=4.0.2,<5.0.0',
 'furo>=2021.6.24-beta.37,<2022.0.0',
 'matplotlib>=3.4.2,<4.0.0',
 'pandas>=1.2.4,<2.0.0',
 'requests>=2.26.0,<3.0.0',
 'seaborn>=0.11.1,<0.12.0',
 'sklearn>=0.0,<0.1',
 'tqdm>=4.62.0,<5.0.0']

setup_kwargs = {
    'name': 'shift15m',
    'version': '0.1.3',
    'description': 'Large-scale multiobective dataset with dataset shift.',
    'long_description': '<p align="center">\n  <img src="./assets/shift15m.png" width="70%" style="display: block; margin: 0 auto" />\n</p>\n\n[![License: MIT](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT)\n[![Python](https://img.shields.io/badge/python-3.6%20%7C%203.7%20%7C%203.8%20%7C%203.9-blue)](https://www.python.org)\n![GitHub code size in bytes](https://img.shields.io/github/languages/code-size/st-tech/zozo-shift15m)\n[![Downloads](https://static.pepy.tech/personalized-badge/shift15m?period=month&units=international_system&left_color=grey&right_color=blue&left_text=Downloads)](https://pepy.tech/project/shift15m)\n![GitHub Workflow Status](https://img.shields.io/github/workflow/status/st-tech/zozo-shift15m/tests)\n[![PyPI version](https://badge.fury.io/py/shift15m.svg)](https://badge.fury.io/py/shift15m)\n![GitHub issues](https://img.shields.io/github/issues/st-tech/zozo-shift15m)\n![GitHub commit activity](https://img.shields.io/github/commit-activity/m/st-tech/zozo-shift15m)\n![GitHub last commit](https://img.shields.io/github/last-commit/st-tech/zozo-shift15m)\n[![arXiv](https://img.shields.io/badge/arXiv-2108.12992-b31b1b.svg)](https://arxiv.org/abs/2108.12992)\n\n[[arXiv]](https://arxiv.org/abs/2108.12992)\n\nThe main motivation of the SHIFT15M project is to provide a dataset that contains natural dataset shifts collected from a web service IQON, which was actually in operation for a decade.\nIn addition, the SHIFT15M dataset has several types of dataset shifts, allowing us to evaluate the robustness of the model to different types of shifts (e.g., covariate shift and target shift).\n\nWe provide the [Datasheet for SHIFT15M](./DATASHEET.md).\nThis datasheet is based on the [Datasheets for Datasets](https://arxiv.org/abs/1803.09010) [1] template.\n\n| System      | Python 3.6 | Python 3.7 | Python 3.8 |\n| :---:              | :---:             | :---:            | :--:              |\n| Linux CPU    |  <img src="https://img.shields.io/badge/build-success-brightgreen" /> | <img src="https://img.shields.io/badge/build-success-brightgreen" /> | <img src="https://img.shields.io/badge/build-success-brightgreen" /> |\n| Linux GPU    |   <img src="https://img.shields.io/badge/build-success-brightgreen" />  | <img src="https://img.shields.io/badge/build-success-brightgreen" /> | <img src="https://img.shields.io/badge/build-success-brightgreen" /> |\n| Windows CPU / GPU | <center>Status Currently Unavailable</center> | <center>Status Currently Unavailable</center> |  <center>Status Currently Unavailable</center> |\n| Mac OS CPU|   <img src="https://img.shields.io/badge/build-success-brightgreen" /> |  <img src="https://img.shields.io/badge/build-success-brightgreen" />   |  <img src="https://img.shields.io/badge/build-success-brightgreen" /> |\n\nSHIFT15M is a large-scale dataset based on approximately 15 million items accumulated by the fashion search service IQON.\n\n![](./assets/iqon.png)\n\n## Installation\n\n### From PyPi\n\n```bash\n$ pip install shift15m\n```\n\n### From source\n\n```bash\n$ git clone https://github.com/st-tech/zozo-shift15m.git\n$ cd zozo-shift15m\n$ poetry build\n$ pip install dist/shift15m-xxxx-py3-none-any.whl\n```\n\n## Download SHIFT15M dataset\n\n### Use Dataset class\n\nYou can download SHIFT15M dataset as follows:\n\n```python\nfrom shift15m.datasets import NumLikesRegression\n\ndataset = NumLikesRegression(root="./data", download=True)\n```\n\n### Download directly by using download scripts\n\nPlease download the dataset as follows:\n\n```bash\n$ bash scripts/download_all.sh\n```\n\nTo avoid downloading the test dataset for set matching (80GB), which is not required in training, you can use the following script.\n\n```bash\n$ bash scripts/download_all_wo_set_testdata.sh\n```\n\n## Tasks\n\nThe following tasks are now available:\n\n| Tasks                      | Task type           | Shift type   | # of input dim | # of output dim |\n|----------------------------|---------------------|--------------|----------------|-----------------|\n| [NumLikesRegression](https://github.com/st-tech/zozo-shift15m/tree/main/benchmarks#regression-for-the-number-of-likes) | regression     | target shift |     (N, 25)                       | (N, 1)               |\n| [SumPricesRegression](https://github.com/st-tech/zozo-shift15m/tree/main/benchmarks#regression-for-the-sum-of-prices) | regression    | covariate shift, target shift | (N, 1) | (N, 1)|\n| ItemPriceRegression        | regression          | target shift | (N, 4096)      | (N, 1)          |\n| [ItemCategoryClassification](https://github.com/st-tech/zozo-shift15m/tree/main/benchmarks/item_category_prediction) | classification      | target shift| (N, 4096)      | (N, 7)          |\n| [Set2SetMatching](https://github.com/st-tech/zozo-shift15m/tree/main/benchmarks/set_matching)      | set-to-set matching | covariate shift | (N, 4096)x(M, 4096)| (1)          |\n\n## Benchmarks\n\nAs templates for numerical experiments on the SHIFT15M dataset, we have published [experimental results for each task with several models](./benchmarks).\n\n## Original Dataset Structure\n\nThe original dataset is maintained in json format, and a row consists of the following:\n\n```\n{\n  "user":{"user_id":"xxxx", "fav_brand_ids":"xxxx,xx,..."},\n  "like_num":"xx",\n  "set_id":"xxx",\n  "items":[\n    {"price":"xxxx","item_id":"xxxxxx","category_id1":"xx","category_id2":"xxxxx"},\n    ...\n  ],\n  "publish_date":"yyyy-mm-dd"\n}\n```\n\n## Contributing\nTo learn more about making a contribution to SHIFT15M, please see the following materials:\n- [Developers Guide](./DEVELOPMENT.md)\n- [Task Proposal Guide](./TASK_PROPOSAL.md)\n- [Benchmark Proposal Guide](./BENCHMARK.md)\n\n## License\nThe dataset itself is provided under a [CC BY-NC 4.0 license](./LICENSE.CC).\nOn the other hand, the software in this repository is provided under the [MIT license](./LICENSE.MIT).\n\n## Dataset metadata\nThe following table is necessary for this dataset to be indexed by search engines such as [Google Dataset Search](https://datasetsearch.research.google.com/).\n\n<div itemscope itemtype="http://schema.org/Dataset">\n<table>\n  <tr>\n    <th>property</th>\n    <th>value</th>\n  </tr>\n  <tr>\n    <td>name</td>\n    <td><code itemprop="name">SHIFT15M Dataset</code></td>\n  </tr>\n  <tr>\n    <td>alternateName</td>\n    <td><code itemprop="alternateName">SHIFT15M</code></td>\n  </tr>\n  <tr>\n    <td>alternateName</td>\n    <td><code itemprop="alternateName">shift15m-dataset</code></td>\n  </tr>\n  <tr>\n    <td>url</td>\n    <td><code itemprop="url">https://github.com/st-tech/zozo-shift15m</code></td>\n  </tr>\n  <tr>\n    <td>sameAs</td>\n    <td><code itemprop="sameAs">https://github.com/st-tech/zozo-shift15m</code></td>\n  </tr>\n  <tr>\n    <td>description</td>\n    <td><code itemprop="description">SHIFT15M is a multi-objective, multi-domain dataset which includes multiple dataset shifts.</code></td>\n  </tr>\n  <tr>\n    <td>provider</td>\n    <td>\n      <div itemscope itemtype="http://schema.org/Organization" itemprop="provider">\n        <table>\n          <tr>\n            <th>property</th>\n            <th>value</th>\n          </tr>\n          <tr>\n            <td>name</td>\n            <td><code itemprop="name">ZOZO Research</code></td>\n          </tr>\n          <tr>\n            <td>sameAs</td>\n            <td><code itemprop="sameAs">https://ja.wikipedia.org/wiki/ZOZO</code></td>\n          </tr>\n        </table>\n      </div>\n    </td>\n  </tr>\n  <tr>\n    <td>license</td>\n    <td>\n      <div itemscope itemtype="http://schema.org/CreativeWork" itemprop="license">\n        <table>\n          <tr>\n            <th>property</th>\n            <th>value</th>\n          </tr>\n          <tr>\n            <td>name</td>\n            <td><code itemprop="name">CC BY-NC 4.0</code></td>\n          </tr>\n          <tr>\n            <td>url</td>\n            <td><code itemprop="url">https://github.com/st-tech/zozo-shift15m/blob/main/LICENSE.CC</code></td>\n          </tr>\n        </table>\n      </div>\n    </td>\n  </tr>\n</table>\n</div>\n\n\n## Errata\nNo errata are currently available.\n\n## References\n- [1] Gebru, Timnit, et al. "Datasheets for datasets." arXiv preprint arXiv:1803.09010 (2018).\n',
    'author': 'ZOZO Research SHIFT15M Team',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7.1,<4.0',
}


setup(**setup_kwargs)
