# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class ImagingServicesFeeEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'imaging_request_billing_item_id': 'str',
        'asin': 'str',
        'posted_date': 'ModelDate',
        'fee_list': 'FeeComponentList'
    }

    attribute_map = {
        'imaging_request_billing_item_id': 'ImagingRequestBillingItemID',
        'asin': 'ASIN',
        'posted_date': 'PostedDate',
        'fee_list': 'FeeList'
    }

    def __init__(self, imaging_request_billing_item_id=None, asin=None, posted_date=None, fee_list=None):  # noqa: E501
        """ImagingServicesFeeEvent - a model defined in Swagger"""  # noqa: E501
        self._imaging_request_billing_item_id = None
        self._asin = None
        self._posted_date = None
        self._fee_list = None
        self.discriminator = None
        if imaging_request_billing_item_id is not None:
            self.imaging_request_billing_item_id = imaging_request_billing_item_id
        if asin is not None:
            self.asin = asin
        if posted_date is not None:
            self.posted_date = posted_date
        if fee_list is not None:
            self.fee_list = fee_list

    @property
    def imaging_request_billing_item_id(self):
        """Gets the imaging_request_billing_item_id of this ImagingServicesFeeEvent.  # noqa: E501

        The identifier for the imaging services request.  # noqa: E501

        :return: The imaging_request_billing_item_id of this ImagingServicesFeeEvent.  # noqa: E501
        :rtype: str
        """
        return self._imaging_request_billing_item_id

    @imaging_request_billing_item_id.setter
    def imaging_request_billing_item_id(self, imaging_request_billing_item_id):
        """Sets the imaging_request_billing_item_id of this ImagingServicesFeeEvent.

        The identifier for the imaging services request.  # noqa: E501

        :param imaging_request_billing_item_id: The imaging_request_billing_item_id of this ImagingServicesFeeEvent.  # noqa: E501
        :type: str
        """

        self._imaging_request_billing_item_id = imaging_request_billing_item_id

    @property
    def asin(self):
        """Gets the asin of this ImagingServicesFeeEvent.  # noqa: E501

        The Amazon Standard Identification Number (ASIN) of the item for which the imaging service was requested.  # noqa: E501

        :return: The asin of this ImagingServicesFeeEvent.  # noqa: E501
        :rtype: str
        """
        return self._asin

    @asin.setter
    def asin(self, asin):
        """Sets the asin of this ImagingServicesFeeEvent.

        The Amazon Standard Identification Number (ASIN) of the item for which the imaging service was requested.  # noqa: E501

        :param asin: The asin of this ImagingServicesFeeEvent.  # noqa: E501
        :type: str
        """

        self._asin = asin

    @property
    def posted_date(self):
        """Gets the posted_date of this ImagingServicesFeeEvent.  # noqa: E501


        :return: The posted_date of this ImagingServicesFeeEvent.  # noqa: E501
        :rtype: ModelDate
        """
        return self._posted_date

    @posted_date.setter
    def posted_date(self, posted_date):
        """Sets the posted_date of this ImagingServicesFeeEvent.


        :param posted_date: The posted_date of this ImagingServicesFeeEvent.  # noqa: E501
        :type: ModelDate
        """

        self._posted_date = posted_date

    @property
    def fee_list(self):
        """Gets the fee_list of this ImagingServicesFeeEvent.  # noqa: E501


        :return: The fee_list of this ImagingServicesFeeEvent.  # noqa: E501
        :rtype: FeeComponentList
        """
        return self._fee_list

    @fee_list.setter
    def fee_list(self, fee_list):
        """Sets the fee_list of this ImagingServicesFeeEvent.


        :param fee_list: The fee_list of this ImagingServicesFeeEvent.  # noqa: E501
        :type: FeeComponentList
        """

        self._fee_list = fee_list

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ImagingServicesFeeEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ImagingServicesFeeEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
