"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_eks_1 = require("monocdk/aws-eks");
const monocdk_1 = require("monocdk");
const nag_rules_1 = require("../../nag-rules");
/**
 * EKS Cluster Kubernetes API server endpoints have public access disabled
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    var _a, _b;
    if (node instanceof aws_eks_1.CfnCluster) {
        const resourcesVpcConfig = monocdk_1.Stack.of(node).resolve(node.resourcesVpcConfig);
        const endpointPublicAccess = nag_rules_1.NagRules.resolveIfPrimitive(node, resourcesVpcConfig.endpointPublicAccess);
        if (endpointPublicAccess !== false) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else if (node.cfnResourceType === 'Custom::AWSCDK-EKS-Cluster') {
        // The CDK uses a Custom Resource with AWS SDK calls to create EKS Clusters
        const props = monocdk_1.Stack.of(node).resolve(node._cfnProperties);
        const endpointPublicAccess = nag_rules_1.NagRules.resolveIfPrimitive(node, (_b = (_a = props === null || props === void 0 ? void 0 : props.Config) === null || _a === void 0 ? void 0 : _a.resourcesVpcConfig) === null || _b === void 0 ? void 0 : _b.endpointPublicAccess);
        if (endpointPublicAccess !== false) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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