"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NagRules = exports.NagRuleCompliance = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
/**
 * The compliance level of a resource in relation to a rule.
 */
var NagRuleCompliance;
(function (NagRuleCompliance) {
    NagRuleCompliance["COMPLIANT"] = "Compliant";
    NagRuleCompliance["NON_COMPLIANT"] = "Non-Compliant";
    NagRuleCompliance["NOT_APPLICABLE"] = "N/A";
})(NagRuleCompliance = exports.NagRuleCompliance || (exports.NagRuleCompliance = {}));
/**
 * Helper class with methods for rule creation
 */
class NagRules {
    /**
     * Use in cases where a primitive value must be known to pass a rule.
     * https://developer.mozilla.org/en-US/docs/Glossary/Primitive
     * @param node The CfnResource to check.
     * @param parameter The value to attempt to resolve.
     * @returns Return a value if resolves to a primitive data type, otherwise throw an error.
     */
    static resolveIfPrimitive(node, parameter) {
        const resolvedValue = monocdk_1.Stack.of(node).resolve(parameter);
        if (resolvedValue === Object(resolvedValue)) {
            throw Error(`The parameter resolved to to a non-primitive value "${JSON.stringify(resolvedValue)}", therefore the rule could not be validated.`);
        }
        else {
            return resolvedValue;
        }
    }
    /**
     * Use in cases where a token resolves to an intrinsic function and the referenced resource must be known to pass a rule.
     * @param node The CfnResource to check.
     * @param parameter The value to attempt to resolve.
     * @returns Return the Logical resource Id if resolves to a intrinsic function, otherwise the resolved provided value.
     */
    static resolveResourceFromInstrinsic(node, parameter) {
        const resolvedValue = monocdk_1.Stack.of(node).resolve(parameter);
        const ref = resolvedValue === null || resolvedValue === void 0 ? void 0 : resolvedValue.Ref;
        const getAtt = resolvedValue === null || resolvedValue === void 0 ? void 0 : resolvedValue['Fn::GetAtt'];
        if (ref != undefined) {
            return ref;
        }
        else if (Array.isArray(getAtt) && getAtt.length > 0) {
            return getAtt[0];
        }
        return resolvedValue;
    }
}
exports.NagRules = NagRules;
_a = JSII_RTTI_SYMBOL_1;
NagRules[_a] = { fqn: "monocdk-nag.NagRules", version: "1.12.46" };
//# sourceMappingURL=data:application/json;base64,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