YARP 3.4.0 (2020-07-31)                                                {#v3_4_0}
=======================

[TOC]

YARP 3.4.0 Release Notes
========================


A (partial) list of bug fixed and issues resolved in this release can be found
[here](https://github.com/robotology/yarp/issues?q=label%3A%22Fixed+in%3A+YARP+v3.4.0%22).


Important Changes
-----------------

* [YCM](https://github.com/robotology/ycm/) 0.11 or later is now a hard
  dependency and must be installed on the system before installing YARP.
* Python 2 is no longer supported.


Deprecation and Behaviour Changes
---------------------------------

* The `scripts/WindowsPowerShell` files are now in `data/WindowsPowerShell`.
* The `scripts/yarp_completion` file is now in `data/bash-completion/yarp`.

### Build System

##### `yarp_prepare_plugin`

* `INCLUDE` must now be an existing file, either using a path relative to
  current directory, or an absolute path. Using a path relative to one of the
  include directories is deprecated.

#### os

* The method `yarp::os::getenv()` is deprecated in favour of `std::getenv()`

##### `yarp::os::ConnectionState`

* The `yarp::os::ConnectionState::getLog()` method was removed without
  deprecation, due to the changes to the logging system, that made it impossible
  to preserve this method.

##### `yarp::os::NetworkBase`

* The `yarp::os::NetworkBase::setVerbosity` method is deprecated in favor of Log
  Components.
* The `yarp::os::NetworkBase::getEnvironment()` method is deprecated in favour
  of `yarp::conf::environment::getEnvironment()`
* The `yarp::os::NetworkBase::setEnvironment()` method is deprecated in favour
  of `yarp::conf::environment::setEnvironment()`
* The `yarp::os::NetworkBase::unsetEnvironment()` method is deprecated in favour
  of `yarp::conf::environment::unsetEnvironment()`

##### `yarp::os::Port`

* The `yarp::os::Port::setVerbosity` method is deprecated in favour of Log
  Components.
* The `yarp::os::Port::getVerbosity` method is deprecated in favour of Log
  Components.

##### `yarp::os::ResourceFinder`

* The `yarp::os::ResourceFinder::setVerbose()` method is deprecated in favour of
  Log Components.
* The `yarp::os::ResourceFinder::setQuiet()` method is deprecated in favour of
  Log Components.

##### `yarp::os::YarpPluginSettings`

* The `yarp::os::YarpPluginSettings::setVerboseMode()`  method is deprecated in
  favour of Log Components.

##### `yarp::os::Log`

* The `yarp::os::Log::setLogCallback()` method is deprecated in favour of
  `setPrintCallback()`

#### dev

* The following classes were moved from the `yarp::dev` namespace to the
  `yarp::dev::Nav2D` namespace
  * `yarp::dev::Nav2D::Map2DArea`
  * `yarp::dev::Nav2D::Map2DPath`
  * `yarp::dev::Nav2D::Map2DLocation`
  * `yarp::dev::Nav2D::MapGrid2D`
  * `yarp::dev::Nav2D::MapGrid2DInfo`
* `yarp::dev::Nav2D::Map2DPath` is now replacing `std::vector<yarp::dev::Nav2D::Map2DLocation>` in all
  APIs.
* The following functions have been moved from `yarp::dev::Nav2D::MapGrid2D`
  into `yarp::dev::Nav2D::MapGrid2DInfo`:
  * `yarp::dev::Nav2D::XYWorld yarp::dev::Nav2D::MapGrid2DInfo::cell2World(yarp::dev::Nav2D::XYCell cell) const;`
  * `yarp::dev::Nav2D::Map2DLocation yarp::dev::Nav2D::MapGrid2DInfo::toLocation(yarp::dev::Nav2D::XYCell cell) const;`
  * `yarp::dev::Nav2D::XYCell yarp::dev::Nav2D::MapGrid2DInfo::toXYCell(yarp::dev::Nav2D::Nav2D::Map2DLocation loc) const;`
  * `yarp::dev::Nav2D::XYCell yarp::dev::Nav2D::MapGrid2DInfo::world2Cell(yarp::dev::Nav2D::XYWorld world) const;`
  * `yarp::dev::Nav2D::Nav2D::Map2DLocation yarp::dev::Nav2D::MapGrid2DInfo::toLocation(yarp::dev::Nav2D::XYWorld cell) const;`
  * `yarp::dev::Nav2D::XYWorld yarp::dev::Nav2D::MapGrid2DInfo::toXYWorld(yarp::dev::Nav2D::Map2DLocation loc) const;`
* modified signature of the `yarp::dev::Nav2D::INavigation2D::getAllNavigationWaypoints` method.
* The format of .map file loaded by `yarp::dev::Nav2D::MapGrid2D` has been
  changed. It can now include the parameters `resolution <double>` and
  `orientation <bottle>` to adjust the map reference frame.

### Devices

* The `test_grabber` device was renamed `fakeFrameGrabber`.
  The old name is kept for compatibility, but it will be deprecated and removed
  in a future release.
* The `test_motor` was renamed `fakeMotor`.
  The old name is kept for compatibility, but it will be deprecated and removed
  in a future release.

### Tools

##### `yarp`

* The `regression` subcommand was removed.


New Features
------------

### Build System

* The `bash-completion` file is now installed automatically (#1101).
* It is now possible to build some of the examples in the main build using the
  `YARP_COMPILE_EXAMPLES` CMake Option
* It is now possible to build some of the YARP examples as test using the
  `YARP_ENABLE_EXAMPLES_AS_TESTS` CMake Option

##### `yarp_add_idl`

 * It's now possible to pass options to the commands using CMake variables (for
   example `YARP_ADD_IDL_THRIFT_INCLUDE_PREFIX` and
   `YARP_ADD_IDL_THRIFT_NO_NAMESPACE_PREFIX`.

##### `yarp_prepare_plugin`

* Including current directory (either explicitly, or using
  `CMAKE_INCLUDE_CURRENT_DIR`) is no longer required by the generated files.

### Libraries

#### conf

* Added `yarp::conf::clamp`. Will be replaced by `std::clamp` as soon as c++17
  is required in YARP.
* Added the `yarp/conf/environment.h` header.
* Added the following functions:
  * `yarp::conf::environment::getEnvironment()`
  * `yarp::conf::environment::setEnvironment()`
  * `yarp::conf::environment::unsetEnvironment()`

#### os

* Add `yarp::os::gethostname()` overload to return a `std::string`

##### `yarp::os::NetworkBase`

* Added `bool yarp::os::NetworkBase::isNetworkInitialized()` method.

##### `yarp::os::NetType`

* The following methods were added:
    * `static std::string yarp::os::NetType::toString(yarp::conf::float32_t)`
    * `static std::string yarp::os::NetType::toString(yarp::conf::float64_t)`
    * `static yarp::conf::float32_t yarp::os::NetType::toFloat32(const std::string&)`
    * `static yarp::conf::float64_t yarp::os::NetType::toFloat64(const std::string&)`
    * `static yarp::conf::float32_t yarp::os::NetType::toFloat32(std::string&&)`
    * `static yarp::conf::float64_t yarp::os::NetType::toFloat64(std::string&&)`
    * `static std::string yarp::os::NetType::toHexString(long)`
    * `static std::string yarp::os::NetType::toHexString(unsigned int)`

##### `yarp::os::Time`

* Added `bool yarp::os::Time::isClockInitialized()` method.

##### `yarp::os::Log`

* The yarp logging system was heavily refactored, please check out the
  [documentation](\ref yarp_logging).
* The name of the port used to forward the output no longer contains the full
  path, but only the executable name.
* Added `yarp::os::LogComponent` to define log components:
  * A log component can be declared using the `YARP_LOG_COMPONENT()` macro (in
    a `.cpp` file) and eventually forward declared using
    ` YARP_DECLARE_LOG_COMPONENT()`.
  * It is possible to set custom printing and forwarding macros for each
    component, and it is possible to enable and disable specific levels for each
    component.
  * At the moment it is not yet possible to change the defaults set in the code,
    but this will be enabled in the future.
* The output forwarded is now a property and contains several useful
  information including component and system/network time, file, line,
  function.
* The logger is now able to detect if it is running in yarprun and
  eventually change the output format.
* Logging is now protected by a mutex to avoid garbled output.
* The `YARP_DEBUG_LOG_ENABLE` environment variable can be set to debug
  the log of the application.
* When color is enabled, the loglevel can be represented by a single colored
  character by setting the `YARP_COMPACT_OUTPUT` environment variable to `1`.
* The limit of 1024 characters for the c-style `yDebug()` macro family was
  removed. A dynamic allocation is now used, but only when the size of the
  output exceeds this size.
* Trace should no longer generate code when building in release mode.
  When building with `-DYARP_NO_DEBUG_OUTPUT` debug should not generate any code
  as well. See https://godbolt.org/z/hSAC56
* Added the `yCDebug` macro family to pass a component to the logger (This
  macro is also available for all log levels, and assert).
* Added the following new debug macro families limiting the log output (all
  these macros are available for all log levels, except for `[FATAL]`, and in
  the *component* version):
  * `yDebugOnce()`: Printed only once in the execution of the program.
  * `yDebugThreadOnce()`: Printed at most once by every thread during the
    execution of the program.
  * `yDebugThrottle()`: Printed at most once every `period` seconds.
  * `yDebugThreadThrottle()`: Printed at most once by every thread every `period`
    seconds.
* Added the `yDebugExternalTime()` macro family to pass a timestamp generated by
  an external source (This macros is also available for all log levels, in the
  *component* version, and in the *limited* version):

##### `yarp::os::ManagedBytes`

* Added move semantics.

##### `yarp::os::Portable`

* The first argument of `yarp::os::Portable::copyPortable()` is now `const`.
  The new signature is:
  ```
    bool yarp::os::Portable::copyPortable(const PortWriter& writer, PortReader& reader)
  ```

##### `yarp::os::Port`

* It's now possible to try to fix any issues by entrusting a Superior Entity.


#### sig

##### `yarp::sig::ImageOf`

* Added support to load a PNG file into a `yarp::sig::ImageOf<yarp::sig::PixelRgb>`

##### `yarp::sig::VectorOf`

* Added `const_iterator yarp::sig::VectorOf::begin() const` and
  `const_iterator yarp::sig::VectorOf::end() const` in `yarp::sig::VectorOf`
  class.
* Added move semantics.

#### math

* Added `yarp::math::Vec2D<size_t>` datatype.

#### dev

* Added `yarp::dev::LaserScan2D` datatype.
* Added `yarp::dev::MobileBaseVelocity` datatype.
* Added `yarp::dev::OdometryData` datatype.
* Added `yarp::dev::OdometryData6D` datatype.
* Added `yarp::dev::IPositionSensors` interface.
* Added `yarp::dev::Lidar2DDeviceBase` class to use as a base class for all lidar devices.
* Added `yarp::dev::Nav2D::TrajectoryTypeEnum`
* Added the following methods to `yarp::dev::Nav2D::ILocalization2D` interface
  * `yarp::dev::Nav2D::ILocalization2D::startLocalizationService();`
  * `yarp::dev::Nav2D::ILocalization2D::stopLocalizationService();`
  * `yarp::dev::Nav2D::ILocalization2D::getCurrentPosition(yarp::dev::Nav2D::Map2DLocation& loc, yarp::sig::Matrix& cov);`
  * `yarp::dev::Nav2D::ILocalization2D::setInitialPose(const yarp::dev::Nav2D::Map2DLocation& loc, const yarp::sig::Matrix& cov);`
* Added new class `yarp::dev::Nav2D::MapGrid2DInfo` which contains infos about
  the name, the resolution and the origin of the map (e.g.
  `yarp::dev::Nav2D::MapGrid2DOrigin`) etc.
* Added new path-related methods to `yarp::dev::Nav2D::IMap2D` interface:
  * `virtual bool yarp::dev::Nav2D::IMap2D::storePath(std::string path_name, Nav2D::Map2DPath path) = 0;`
  * `virtual bool yarp::dev::Nav2D::IMap2D::getPath(std::string path_name, Nav2D::Map2DPath& path) = 0;`
  * `virtual bool yarp::dev::Nav2D::IMap2D::getPathsList(std::vector<std::string>& paths) = 0;`
  * `virtual bool yarp::dev::Nav2D::IMap2D::deletePath(std::string path_name) = 0;`
  * `virtual bool yarp::dev::Nav2D::IMap2D::renamePath(std::string original_name, std::string new_name) = 0;`
  * `virtual bool yarp::dev::Nav2D::IMap2D::clearAllPaths() = 0;`
* Added method `yarp::dev::Nav2D::ILocalization2D::getEstimatedOdometry()` to
  the interface `yarp::dev::Nav2D::ILocalization2D`.
* `yarp::dev::Nav2D::MapGrid2DOrigin` can now handle a generic orientation.
  Previously only the translational part was handled by methods `world2Cell` and
  `cell2World`
* The terminator port now tries to use the default value for `--name` accepted
  by the device.
  For example `yarpdev --device fakeFrameGrabber` will open the port
  `/grabber/quit` instead of `/fakeFrameGrabber/quit`.

#### logger

* Interpret the new message format containing extra info.


### Carriers

* Added `depthimage2` portmonitor to transform a depth image
  (`VOCAB_PIXEL_FLOAT` format) into a rgb image, using a precomputed colormap.
* Added `segmentationimage` portmonitor to transform a segmentation image
  (`VOCAB_PIXEL_MONO` or `VOCAB_PIXEL_MONO16`) into a rgb image, using a
  precomputed colormap.


### Devices

* Added `laserFromExternalPort` device, which is able to receive a `LaserScan2D`
  datatype from a YARP port, and expose it as a device driver through the
  `IRangefinder2D` interface.
* Added `laserFromPointCloud` device, which receives a depth stream through an
  `IRGBDSensor` sensor a produces a laser compatible stream of data from the
  computed point cloud.
* Added `IMURosPublisher` device. This wrapper connects to a device and
  publishes a ROS topic of type `sensor_msgs::Imu`.
* Added `MagneticFieldRosPublisher` device. This wrapper connects to a device and
  publishes a ROS topic of type `sensor_msgs::MagneticField`.
* Added `PoseStampedRosPublisher` device. This wrapper connects to a device and
  publishes a ROS topic of type `geometry_msgs::PoseStamped`.
* Added `TemperatureRosPublisher` device. This wrapper connects to a device and
  publishes a ROS topic of type `sensor_msgs::Temperature`.
* Added `WrenchStampedRosPublisher` device. This wrapper connects to a device and
  publishes a ROS topic of type `geometry_msgs::WrenchStamped`.
* Added `upowerBattery` device to view the battery
  of a linux laptop in YARP using the `yarp::dev::IBattery` interface.

##### `fakeBattery`

* Added a new port `<name>/control/rpc:i` to retrieve and change the values
  reported by the fake battery.
* The battery is now charged or discharged depending on the sign of the current.
* The default values for voltage and current are now more realistic.
* It is now possible to change the starting values as device options.

##### `fakeLaser`

* Added `--use_constant` option.
* The device is now derived from `yarp::dev::Lidar2DDeviceBase`

##### `laserFromDepth`

* The device is now derived from `yarp::dev::Lidar2DDeviceBase`

##### `Localization2DServer`

* Added missing ROS initialization. It will now publish odometry data on ROS
  topic.

##### `multipleAnalogSensorsMsgs`

* `multipleAnalogSensorsSerializations.thrift` have been extended to handle
  position sensors.

##### `multipleanalogsensorsserver`

* Added handlers for `yarp::dev::IPositionSensors` interface.
* Added support for wrapped subdevices, i.e. those explicitly instantiated via
  `--subdevice` option on initial device configuration. (#2154)

##### `multipleanalogsensorsclient`

* Added handlers for `yarp::dev::IPositionSensors` interface.

##### `multipleanalogsensorsremapper`

* Added handlers for `yarp::dev::IPositionSensors` interface.
* Update `MAS_NrOfSensorTypes`. This avoids segfaults due to uninitialized
  `yarp::dev::IPositionSensors` interfaces.

##### `ovrheadset`

* Port to the new rendering API and make it focus aware (SDK 1.19 is required).
* Add `P` command to print current settings.

##### `Rangefinder2DClient`

* `Rangefinder2DClient` now use `yarp::dev::LaserScan2D` datatype.

##### `Rangefinder2DWrapper`

* `Rangefinder2DWrapper` now use `yarp::dev::LaserScan2D` datatype.

##### `rpLidar2`

* The device is now derived from `yarp::dev::Lidar2DDeviceBase`

##### `transformClient`

* Added support for identical frame transforms.

##### `transformServer`

* Cleanup of `--USER_TF` option.


### Tools

##### `yarp`

* The `--help`, `-h` and `--version` arguments are now accepted.
* Added the `priority-qos` subcommand that allows to set/get the packet priority
  value of both the source and the destination port.
* Added the `priority-sched` subcommand that allows to set/get the thread
  priority and policy values of both the source and the destination port.
* Added the `env` subcommand to print one or the full list of environment
  variables.
* The `qos` subcommand is accepted as an alias to `priority-qos`.
* The `sched` subcommand is accepted as an alias to `priority-sched`.
* When logic fails, it's time to `yarp pray`. Watch out for palindrome mode.

##### `yarprun`

* The name of the port used to forward the output no longer contains the full
  path, but only the executable name.
* The following enviromnent variables are now set in the child processes:
  * `YARP_IS_YARPRUN` is set to `1` for all child processes
  * `YARPRUN_IS_FORWARDING_LOG` is set to `1` when yarprun is forwarding the
    log and to `0` otherwise

### GUIs

* Added new `yarpmobilebasegui` GUI which allows the user to control the
  mobile base of the robot via keyboard or mouse and sends
  `yarp::dev::MobileBaseVelocity` commands on a yarp port.

##### `yarpmanager`

* Moved the builder, from the hidden place to a tab in the application view.

##### `yarplaserscannergui`

* Multiple instances are now allowed with `--local` option.
* Added `--debug` option.

##### `yarpdataplayer`

* It's now possible to reproduce several ROS types, i.e.
  * `sensor_msgs/LaserScan`
  * `nav_msgs/Odometry`
  * `tf/tfMessage`
  * `tf2_msgs/tfMessage`
  * `geometry_msgs/Pose`
  * `geometry_msgs/Pose2D`
* Added `getSliderPercentage` method to the rpc port.
  This method returns the progress percentage of the seek bar while playing a
  dataset. (#2148)

##### `yarpview`

* Added a checkable menu item that, if checked, shows an additional line in the
  `status bar` that displays the color value of the pixel pointed by the mouse
  cursor.
  The string has the following format
  ```
  Pixel("x","y") = "hexstring"
  ```
  Where  `x` and `y` are the coordinates of the pixel and `hexstring` is the
  hexadecimal (in the ARGB format) string representing the pixel color.
  The additional line on the `status bar` contains also a little rectangle that
  will turn the same color of the currently selected pixel.

##### `yarplogger`

* The new info from yarp log (component, time, etc.) are now displayed (the
  columns that are not shown by default can be enabled from the `Options` menu).
* Cleaned up interface, removed status bar and improved colors.

### Bindings

* Several previously inaccessible methods from motor interfaces are now
  correctly wrapped.
  This covers pretty much everything the pair
  `remote_controlboard`/`controlboardwrapper2` wraps and implements, only
  excluding calibration interfaces.
  In addition, two more interfaces can be accessed through the `PolyDriver`
  idiom: `IEncodersTimed` and `IMotor`.


New Experimental Features
-------------------------

**EXPERIMENTAL** means that the software is under development, provided with
incomplete documentation and it may be modified/renamed/removed without any
notice.

### Libraries

#### os

* The following **EXPERIMENTAL** environment variables can be enabled to enable
  forwarding of some extra log information:
  - `YARP_FORWARD_CODEINFO_ENABLE` (file name, line number and function name)
  - `YARP_FORWARD_HOSTNAME_ENABLE` (hostname)
  - `YARP_FORWARD_PROCESSINFO_ENABLE` (command, arguments, pid and thread id)
  - `YARP_FORWARD_BACKTRACE_ENABLE` (stack trace)
  These environment variables could be removed in the future.

#### robotinterface

* Created the new **EXPERIMENTAL** `YARP_robotinterface` library by refactoring
  as a library the logic of the `yarprobotinterface` tool, including support for
  attaching devices created by the library to external devices created in some
  other way.

### Carriers

* Added the new **EXPERIMENTAL** `unix_stream` carriers to communicate with a
  process on the same machine using a unix socket.
  It's possible to use the `ack` option (`unix_stream+ack`) in case you need
  flow control.

### Devices

* Added `Realsense2WithIMU` **EXPERIMENTAL** device.
  This is a driver for Realsense D435i.
* Added `Relasense2Tracking` **EXPERIMENTAL** device.
  This is a driver for Realsense T265.
* added `laserFromRosTopic` **EXPERIMENTAL** device.
  It exposes a lidar ROS topic (dataype `sensor_msgs::LaserScan`) on YARP,
  using the `yarp::dev::IRangefinder2D` interface.


Bug Fixes
---------

### Libraries

#### os

##### `Port`

* Passing an invalid string when setting the QoS by DSCP no longer sets it to 0.

#### sig

##### `Image`

* Fixed pixel type and the orientation settings when using the move constructor
  and the move assignment operator.


Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v3.3.0..v3.4.0`):
```
   470	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
    75	Marco Randazzo <marco.randazzo@iit.it>
    27	Nicolò Genesio <nicolo.genesio@iit.it>
    18	Silvio Traversaro <silvio.traversaro@iit.it>
     8	Ettore Landini <ettore.landini@iit.it>
     7	Bartek Łukawski <bwmn.peter@gmail.com>
     4	Prashanth Ramadoss <prashanth.ramadoss@iit.it>
     3	Alexandre Gomes Pereira Antunes <alexandre.gomespereira@iit.it>
     3	Giulio Romualdi <giulio.romualdi@iit.it>
     2	Andrea Ruzzenenti <andrea.ruzzenenti@iit.it>
     1	Alessandro Roncone <alessandro.roncone@iit.it>
     1	Paul Fitzpatrick <paulfitz@alum.mit.edu>
     1	Ugo Pattacini <ugo.pattacini@iit.it>
     1	Valentina Gaggero <valentina.gaggero@iit.it>
```
