from enum import Enum
from typing import List


class LoggerInstances(Enum):
    ASKLORAXALPACA = "askloraxalpaca"
    LEDGER = "ledger"
    SCHEDULER = "scheduler"
    OTHER = "other"

    @classmethod
    def keys(cls) -> List[str]:
        """Returns a list of all the enum keys."""
        return cls._member_names_

    @classmethod
    def values(cls) -> List[str]:
        """Returns a list of all the enum values."""
        return list(cls._value2member_map_.keys())

    @classmethod
    def has_value(cls, key) -> bool:
        return isinstance(key, cls) or key.upper() in cls.__members__

    @staticmethod
    def from_str(label):
        if not isinstance(label, str):
            raise TypeError("Invalid label")

        if label.lower() in ["askloraxalpaca", "asklora", "alpaca", "apca"]:
            return LoggerInstances.ASKLORAXALPACA
        elif label.lower() in ["ledger", "paymentservice", "payment"]:
            return LoggerInstances.LEDGER
        elif label.lower() in ["scheduler", "celery"]:
            return LoggerInstances.SCHEDULER
        else:
            return LoggerInstances.OTHER
