from .context import gpytoolbox
from .context import numpy as np
from .context import unittest

class TestPerVertexNormals(unittest.TestCase):
    # TODO WRITE THIS WITHOUT IGL
    def test_bunny(self):
        self.assertTrue(True)
        # Trying several meshes against the libigl per_vertex_normals
        v,f = gpytoolbox.read_mesh("test/unit_tests_data/bunny_oded.obj")
        n = gpytoolbox.per_vertex_normals(v,f)
        n_gt = np.array([[0.013503,0.033396,0.99935],[0.13535,0.23786,0.96182],[0.54227,-0.21297,0.81276],[0.0046353,0.24175,0.97033],[0.71218,-0.14504,0.68685],[0.046208,-0.12425,0.99117],[0.27458,-0.11978,0.95407],[0.16181,0.35936,0.91906],[0.76184,-0.30812,0.5698],[0.17186,-0.23013,0.95786],[0.55935,-0.37278,0.74038],[0.3212,0.025795,0.94666],[-0.031178,0.41338,0.91003],[0.77095,-0.050267,0.63491],[0.6619,-0.40099,0.63332],[0.83845,-0.16701,0.51876],[0.043934,-0.38165,0.92326],[0.17907,-0.33263,0.9259],[0.54979,-0.3658,0.75095],[0.50327,-0.47622,0.72107],[0.20501,0.44923,0.86958],[0.60963,-0.26549,0.7469],[0.68013,-0.14472,0.71866],[0.40605,-0.61858,0.67267],[0.6019,-0.42301,0.67734],[0.62717,-0.43365,0.647],[0.59601,-0.21478,0.77372],[0.34342,0.21305,0.9147],[-0.036094,0.55476,0.83122],[0.79653,0.0079307,0.60455],[0.85519,-0.070677,0.51348],[0.55136,-0.39274,0.73605],[0.773,-0.024096,0.63395],[0.27477,-0.73487,0.62006],[0.05784,-0.5272,0.84777],[0.46083,-0.47062,0.75243],[0.64238,-0.46687,0.60777],[0.59606,-0.55747,0.57787],[0.51609,-0.67272,0.53019],[0.23953,0.5296,0.81372],[0.55353,-0.076554,0.82931],[0.55067,-0.21037,0.80778],[0.58572,0.011972,0.81043],[0.42172,-0.78064,0.46125],[0.51427,-0.421,0.74719],[0.59233,-0.34771,0.72681],[0.70018,-0.44394,0.55917],[0.74383,-0.30513,0.59466],[0.67106,-0.013841,0.74128],[0.38082,0.40126,0.83305],[-0.001984,0.70336,0.71083],[0.82973,0.06517,0.55434],[0.85933,-0.053915,0.50858],[0.8122,-0.047091,0.58147],[0.55017,-0.37211,0.74757],[0.67767,-0.026242,0.7349],[0.22149,-0.77246,0.59519],[0.35425,-0.83152,0.42787],[0.3233,-0.63047,0.70568],[0.64029,-0.55479,0.53127],[0.64291,-0.6336,0.43036],[0.74746,-0.50275,0.43422],[0.58555,-0.69753,0.41301],[0.48905,-0.80576,0.33404],[0.42363,0.56883,0.70497],[0.55106,-0.023562,0.83414],[0.52478,0.027025,0.85081],[0.58281,-0.15658,0.79738],[0.53827,-0.039821,0.84183],[0.41775,-0.8592,0.29541],[0.53561,-0.26443,0.802],[0.5636,-0.48077,0.67173],[0.68612,-0.26324,0.6782],[0.73351,-0.50648,0.45326],[0.84934,-0.12817,0.51205],[0.88165,-0.28921,0.3729],[0.74714,0.17218,0.64198],[0.41731,0.59997,0.68256],[0.033196,0.84911,0.52717],[0.86208,0.078112,0.50071],[0.88431,-0.025039,0.46623],[0.84731,-0.031353,0.53017],[0.75821,-0.041649,0.65068],[0.60948,-0.32047,0.72514],[0.6332,-0.11369,0.76559],[0.30216,-0.86626,0.39787],[0.30497,-0.81203,0.4976],[0.3817,-0.88661,0.2612],[0.4793,-0.75374,0.44961],[0.62269,-0.70459,0.34032],[0.59304,-0.77485,0.21888],[0.7191,-0.65736,0.22532],[0.86126,-0.47321,0.18521],[0.48114,-0.85854,0.17722],[0.20838,0.86276,0.46067],[0.90897,0.23368,0.34521],[0.5641,-0.037989,0.82483],[0.56159,-0.030871,0.82684],[0.52327,-0.098027,0.84651],[0.55463,-0.20714,0.8059],[0.26508,-0.88343,0.38636],[0.42507,-0.89073,0.16097],[0.58073,-0.054589,0.81226],[0.5377,-0.35505,0.76473],[0.48915,-0.51789,0.7018],[0.74012,-0.35809,0.56921],[0.68124,-0.6656,0.30477],[0.94332,-0.12443,0.30767],[0.91055,0.017124,0.41305],[0.94827,-0.26172,0.17967],[0.80804,0.35451,0.47053],[0.42333,0.80635,0.41302],[0.085109,0.94648,0.31135],[0.9045,-0.030647,0.42538],[0.93585,0.069689,0.34543],[0.8674,-0.030606,0.49666],[0.8066,-0.028184,0.59043],[0.7464,-0.056416,0.6631],[0.60588,-0.078961,0.79163],[0.41522,-0.29917,0.85912],[0.65202,-0.14579,0.74405],[0.31911,-0.91456,0.24847],[0.32381,-0.89627,0.30306],[0.24035,-0.91977,0.31025],[0.38581,-0.90857,0.16019],[0.42803,-0.87537,0.22476],[0.46269,-0.87309,0.15373],[0.66726,-0.74154,0.069857],[0.80459,-0.59203,0.046294],[0.91256,-0.4082,0.024849],[0.54823,-0.83296,0.074998],[0.46434,-0.88321,0.065827],[0.67678,0.71025,0.19367],[0.97904,0.16389,0.12094],[0.61289,-0.23254,0.75518],[0.60085,-0.1757,0.77981],[0.5256,-0.10194,0.8446],[0.40637,-0.1488,0.90151],[0.59953,-0.21127,0.77196],[0.25586,-0.93601,0.24168],[0.43733,-0.89693,0.065173],[0.43523,-0.063911,0.89805],[0.558,-0.1376,0.81835],[0.45376,-0.45697,0.76504],[0.41726,-0.45723,0.78539],[0.66308,-0.58457,0.46754],[0.43901,-0.8865,0.14625],[0.97429,-0.1069,0.19834],[0.96339,0.11495,0.24223],[0.97106,-0.23453,0.045076],[0.80235,0.56237,0.19991],[0.41087,0.89929,0.14986],[0.14461,0.98612,0.081538],[0.93458,0.019729,0.35519],[0.88613,-0.0026509,0.46342],[0.98155,0.061267,0.18111],[0.83883,-0.0097268,0.54431],[0.7774,-0.010667,0.62892],[0.72469,-0.0282,0.68849],[0.65017,-0.23355,0.72301],[0.46834,-0.241,0.85004],[0.61263,-0.021569,0.79007],[0.31093,-0.93755,0.15595],[0.17061,-0.97014,0.17237],[0.22018,-0.96741,0.12504],[0.1437,-0.97319,0.17961],[0.37564,-0.92518,0.054163],[0.20921,-0.97519,0.072361],[0.15097,-0.98806,0.030837],[0.62239,-0.78112,-0.04985],[0.73653,-0.67142,-0.082027],[0.85316,-0.51212,-0.099224],[0.93165,-0.3455,-0.11253],[0.51648,-0.8551,-0.045339],[0.47328,-0.87998,-0.040467],[0.7287,0.68481,0.005435],[0.98957,0.13618,0.047046],[0.99349,0.086742,0.073808],[0.6322,-0.20818,0.74631],[0.53896,-0.19237,0.82007],[0.5573,-0.23068,0.79762],[0.47062,-0.22071,0.85428],[0.44767,-0.16374,0.87908],[0.62602,-0.01857,0.77959],[0.19744,-0.9731,0.11869],[0.41967,-0.9056,-0.061418],[0.37779,-0.23182,0.8964],[0.34931,-0.0072295,0.93698],[0.50233,-0.36914,0.78192],[0.46366,-0.51346,0.72207],[0.49991,-0.4119,0.76186],[0.37978,-0.88157,0.28035],[0.085535,-0.99618,0.01762],[0.99845,-0.018896,0.052318],[0.962,0.27062,0.036231],[0.97836,-0.13344,-0.15815],[0.74242,0.66986,0.010074],[0.33481,0.93751,-0.094727],[0.19523,0.95742,-0.2127],[0.96053,0.10264,0.25853],[0.90757,0.097117,0.40853],[0.86257,0.078679,0.49978],[0.99027,0.094123,0.10255],[0.80601,0.037586,0.5907],[0.76139,0.0031516,0.64829],[0.64397,0.0053575,0.76503],[0.5919,-0.16987,0.78791],[0.4001,-0.17918,0.89879],[0.59387,0.0273,0.8041],[0.26752,-0.96338,0.018006],[0.00065991,-0.99881,-0.048753],[-0.083362,-0.99627,-0.022397],[0.050611,-0.99862,-0.014182],[-0.070316,-0.99751,0.0048119],[0.32981,-0.93724,-0.11317],[0.0050312,-0.99983,0.017913],[-0.25386,-0.96709,-0.017157],[0.5724,-0.80361,-0.16299],[0.69313,-0.70064,-0.16932],[0.78116,-0.58612,-0.21506],[0.86954,-0.40805,-0.27819],[0.91535,-0.20098,-0.34892],[0.49945,-0.84486,-0.19172],[0.46198,-0.86113,-0.21218],[0.99563,0.088139,-0.030746],[0.8606,0.49224,-0.13066],[0.99644,0.076725,0.035079],[0.99384,0.08915,0.06585],[0.59557,-0.010284,0.80324],[0.45195,-0.16969,0.87575],[0.44292,-0.1734,0.87963],[0.45805,-0.13771,0.8782],[0.43906,-0.23857,0.86621],[0.38801,-0.21351,0.89659],[0.59184,0.071353,0.80289],[0.077051,-0.99697,-0.010717],[0.36651,-0.89981,-0.23667],[0.37085,-0.47486,0.79811],[0.19473,-0.069012,0.97843],[0.29011,-0.12737,0.94848],[0.31023,-0.79485,0.52151],[0.42665,-0.54789,0.71957],[0.33921,-0.35436,0.87141],[0.059708,-0.99466,0.084228],[-0.37474,-0.90216,-0.21371],[0.97669,0.082324,-0.19824],[0.91729,0.36002,-0.17019],[0.92192,0.042636,-0.38502],[0.65668,0.69392,-0.29537],[0.18397,0.90162,-0.39146],[0.32581,0.81933,-0.47174],[0.92394,0.14091,0.35564],[0.97324,0.13385,0.18681],[0.8793,0.14308,0.45426],[0.85404,0.11288,0.50781],[0.98922,0.1217,0.081509],[0.79487,0.056718,0.60412],[0.69355,0.056324,0.71821],[0.5709,0.054744,0.81919],[0.4893,0.042842,0.87106],[0.243,-0.19232,0.95077],[0.57361,0.081932,0.81502],[0.23223,-0.96385,-0.13059],[0.071256,-0.99309,-0.093287],[0.00066619,-0.99553,-0.094481],[-0.12383,-0.9922,-0.014466],[0.0060556,-0.99997,0.004877],[-0.13721,-0.99002,0.032142],[0.2881,-0.92096,-0.26237],[-0.35381,-0.90529,0.23511],[-0.53091,-0.84673,0.03432],[0.50119,-0.78732,-0.35907],[0.62016,-0.71318,-0.32677],[0.73517,-0.5976,-0.31999],[0.80395,-0.43295,-0.4077],[0.84151,-0.25018,-0.47883],[0.835,0.0018409,-0.55025],[0.46571,-0.79034,-0.39809],[0.4287,-0.79971,-0.42034],[0.99065,0.076309,-0.11312],[0.99727,0.049235,-0.0551],[0.92171,0.1964,-0.33449],[0.99744,0.069175,0.017937],[0.99148,0.11348,0.064012],[0.4632,0.14596,0.87415],[0.37857,-0.096551,0.92052],[0.38408,-0.11796,0.91573],[0.33844,-0.12836,0.93219],[0.37524,0.045188,0.92582],[0.34551,-0.16305,0.92414],[0.20949,-0.32602,0.92186],[0.44091,0.15036,0.88487],[0.038839,-0.99723,-0.0635],[0.30883,-0.83614,-0.45331],[0.22727,-0.67923,0.69785],[0.15268,-0.26759,0.95136],[0.13855,-0.013425,0.99026],[0.2495,-0.49115,0.83458],[0.083521,-0.97549,0.20357],[0.1815,-0.58409,0.79114],[0.21346,-0.30707,0.92744],[-0.19604,-0.89462,-0.40152],[-0.36454,-0.80915,-0.46085],[0.86905,0.2718,-0.41337],[0.73304,0.26659,-0.62577],[0.49472,0.63016,-0.59846],[0.083904,0.78625,-0.61219],[0.44737,0.55383,-0.70223],[0.93735,0.21448,0.27454],[0.89092,0.19077,0.41216],[0.96816,0.21618,0.12626],[0.85915,0.18467,0.47724],[0.81179,0.1995,0.54881],[0.97725,0.19669,0.079313],[0.70814,0.21145,0.67366],[0.59001,0.19572,0.78331],[0.55107,0.1706,0.81684],[0.40477,0.20229,0.89176],[0.10069,-0.15342,0.98302],[0.42352,0.21755,0.87938],[0.21711,-0.93219,-0.28962],[0.14487,-0.98892,-0.032373],[0.070612,-0.9975,0.0003617],[0.091995,-0.99575,0.0048163],[-0.037262,-0.99727,0.063723],[-0.23409,-0.93753,0.25735],[-0.065091,-0.99622,0.057563],[0.23746,-0.83064,-0.50364],[-0.35588,-0.87485,0.32862],[-0.038702,-0.99808,-0.048436],[-0.12589,-0.99135,0.037089],[0.54354,-0.67881,-0.49374],[0.43862,-0.73984,-0.51015],[0.63263,-0.60661,-0.48146],[0.7052,-0.4589,-0.54046],[0.74653,-0.28621,-0.60064],[0.74043,-0.016894,-0.67193],[0.56667,0.33418,-0.75313],[0.41445,-0.71899,-0.55792],[0.31348,-0.70151,-0.64001],[0.98311,0.038803,-0.17886],[0.96167,0.0039524,-0.27418],[0.9909,0.046159,-0.12645],[0.89788,-0.027907,-0.43936],[0.9933,0.10874,-0.039043],[0.97981,0.19925,0.016288],[0.37942,0.21047,0.90097],[0.32773,-0.054016,0.94323],[0.30564,0.062355,0.9501],[0.1828,-0.083422,0.97961],[0.1715,-0.020722,0.98497],[0.34148,0.14047,0.92933],[0.12301,-0.1176,0.98541],[-0.0196,-0.34003,0.94021],[0.33513,0.26993,0.90267],[0.14185,-0.96666,-0.2132],[0.2128,-0.67403,-0.70739],[-0.015975,-0.7188,0.69504],[0.097748,-0.38173,0.91909],[0.1603,0.038285,0.98633],[0.15479,-0.538,0.82861],[0.037668,-0.98546,0.16566],[-0.0031447,-0.66562,0.74628],[-0.045475,-0.29026,0.95587],[-0.19593,-0.75768,-0.62252],[-0.16556,-0.87076,-0.463],[0.31421,0.55269,-0.77189],[0.034374,0.68266,-0.72993],[0.61953,0.3611,-0.69699],[0.92909,0.31778,0.18924],[0.89226,0.30238,0.33531],[0.84631,0.28183,0.45202],[0.94407,0.31142,0.1084],[0.79365,0.30283,0.52765],[0.7103,0.32915,0.62221],[0.95039,0.30635,0.053886],[0.60164,0.32375,0.73022],[0.55087,0.30909,0.77525],[0.44378,0.28241,0.85047],[0.43685,0.19016,0.87921],[-0.01719,-0.1703,0.98524],[0.30702,0.27345,0.91157],[0.24578,-0.83261,-0.49633],[0.12767,-0.98861,-0.079682],[0.10857,-0.99406,-0.0073645],[-0.018366,-0.9965,0.081495],[0.028147,-0.99959,0.0046218],[-0.014191,-0.98894,0.14764],[-0.27988,-0.86996,0.406],[0.082695,-0.99425,-0.068042],[0.24672,-0.64751,-0.72101],[-0.053497,-0.98931,0.1357],[-0.097618,-0.97578,-0.19577],[0.020765,-0.99837,0.053191],[0.59648,-0.50919,-0.62043],[0.46975,-0.57525,-0.66965],[0.32854,-0.60638,-0.72413],[0.61214,-0.30241,-0.73064],[0.56272,-0.068425,-0.82381],[0.37173,0.36691,-0.85276],[0.1554,0.55735,-0.81561],[0.25435,-0.55014,-0.7954],[0.13682,-0.50949,-0.84953],[0.95423,0.026968,-0.29786],[0.97375,0.024871,-0.22624],[0.93371,-0.093832,-0.34552],[0.98028,0.093911,-0.17386],[0.91981,-0.10559,-0.37789],[0.96888,0.20702,-0.13573],[0.95015,0.3042,-0.068342],[0.46149,0.21863,0.85978],[0.24173,0.020892,0.97012],[0.35154,0.046716,0.93501],[0.2151,-0.11406,0.96991],[0.12872,-0.058158,0.98997],[0.4081,0.10547,0.90682],[-0.043921,-0.14958,0.98777],[-0.025864,-0.27039,0.9624],[0.39722,0.32619,0.8578],[0.24478,-0.8683,-0.43144],[-0.30915,-0.88099,0.35816],[0.18904,-0.49551,-0.84778],[0.11749,-0.30764,0.94422],[-0.04273,-0.68928,0.72324],[0.2049,0.053501,0.97732],[0.15595,-0.50856,0.84679],[0.022033,-0.9884,0.15027],[-0.15062,-0.61519,0.77386],[-0.20442,-0.32709,0.92262],[-0.2154,-0.74553,-0.63071],[-0.088977,-0.93012,-0.35631],[0.12564,0.57289,-0.80995],[0.92874,-0.032497,-0.3693],[0.82736,0.042005,-0.5601],[0.91791,0.37218,0.13756],[0.90377,0.35308,0.24195],[0.85605,0.33087,0.39713],[0.7807,0.35317,0.51554],[0.92331,0.37544,0.080855],[0.71073,0.38394,0.58946],[0.61185,0.39567,0.6849],[0.92374,0.38303,-0.0021218],[0.5375,0.3822,0.75167],[0.52712,0.38366,0.75826],[0.36252,0.36541,0.85736],[0.45555,0.15836,0.87601],[0.19548,-0.063195,0.97867],[-0.10915,-0.30775,0.94518],[0.29398,0.30099,0.90718],[0.35697,-0.67195,-0.64889],[0.10355,-0.98873,-0.10814],[0.079664,-0.99552,-0.050839],[-0.043009,-0.99828,0.039943],[-0.32956,-0.92017,0.21136],[0.0038775,-0.98147,0.19155],[0.094831,-0.99333,0.065656],[-0.088383,-0.9824,0.16453],[-0.36161,-0.87521,0.32131],[0.28879,-0.936,-0.20126],[0.40922,-0.56073,-0.71981],[0.03692,-0.99789,0.053476],[-0.11315,-0.94744,-0.29925],[0.024831,-0.99572,0.088978],[0.45016,-0.29028,-0.84445],[0.24858,-0.27254,-0.92948],[0.13889,-0.25161,-0.95781],[0.35193,-0.0079599,-0.93599],[0.20767,0.28118,-0.93692],[0.021459,0.49613,-0.86799],[0.13651,-0.29198,-0.94663],[0.40475,-0.50015,-0.76552],[0.94797,-0.015175,-0.31799],[0.91707,-0.03479,-0.3972],[0.95849,0.079857,-0.27372],[0.90552,-0.062471,-0.41969],[0.88738,-0.026047,-0.46031],[0.93993,0.23148,-0.25091],[0.91045,-0.1496,-0.38562],[0.93152,0.28786,-0.2223],[0.92329,0.36114,-0.13083],[0.39885,0.4035,0.82347],[0.24117,-0.017002,0.97033],[0.31233,0.11269,0.94327],[0.10487,-0.19949,0.97427],[0.2323,-0.031646,0.97213],[-0.067862,-0.16985,0.98313],[0.29342,0.34007,0.89345],[-0.14106,-0.12825,0.98166],[-0.19125,-0.17145,0.96645],[0.30358,0.418,0.85623],[0.51967,-0.75594,-0.39813],[0.15171,-0.17602,0.97263],[0.26211,0.097765,0.96007],[-0.057942,-0.59713,0.80005],[0.2123,-0.48808,0.84659],[0.024912,-0.99237,0.12078],[-0.21375,-0.45991,0.86185],[-0.30444,-0.37265,0.87661],[-0.17236,-0.77441,-0.60875],[-0.05334,-0.961,-0.27135],[0.459,0.24674,-0.85349],[0.87776,-0.16752,-0.44886],[0.90132,0.40285,0.15917],[0.90123,0.42202,0.098359],[0.87703,0.37261,0.30327],[0.787,0.36414,0.49804],[0.7191,0.38299,0.57984],[0.89708,0.44078,0.030857],[0.6208,0.4135,0.66605],[0.51148,0.4594,0.72619],[0.88891,0.45424,-0.059192],[0.49432,0.46595,0.73386],[0.28492,0.46255,0.83957],[0.18075,0.014762,0.98342],[-0.33281,-0.33408,0.88183],[0.19625,0.42435,0.88398],[0.60288,-0.65499,-0.45555],[-0.10893,-0.99323,-0.040277],[0.12063,-0.99242,-0.023621],[0.075795,-0.98213,0.17227],[-0.42472,-0.8992,0.10515],[-0.42065,-0.89088,0.17142],[0.0039113,-0.99325,0.11593],[0.14864,-0.98791,-0.043954],[0.026811,-0.99879,0.041257],[-0.13368,-0.9828,0.12738],[0.44713,-0.89222,-0.063378],[0.62514,-0.67745,-0.38764],[0.024714,-0.99815,0.055545],[-0.11481,-0.92801,-0.35442],[0.023636,-0.99449,0.10213],[0.13586,0.043393,-0.98978],[0.076963,0.035231,-0.99641],[0.24896,-0.14708,-0.95728],[0.020794,0.33761,-0.94106],[0.51858,-0.4386,-0.73397],[0.92143,-0.053997,-0.38478],[0.92646,0.072417,-0.36937],[0.86639,-0.12156,-0.48434],[0.89704,0.25923,-0.35793],[0.85446,-0.020203,-0.51913],[0.84229,-0.0021886,-0.53902],[0.89524,0.2782,-0.34807],[0.85787,-0.16421,-0.48693],[0.88528,0.35365,-0.30202],[0.84995,0.46206,-0.25315],[0.39867,0.55329,0.73139],[0.24955,0.52269,0.81518],[0.14992,0.11058,0.9825],[0.20646,0.28379,0.93639],[-0.15495,-0.23547,0.95945],[-0.012859,-0.051356,0.9986],[0.068335,0.095319,0.9931],[-0.20834,-0.17263,0.9627],[-0.25188,-0.086121,0.96392],[-0.38624,-0.13953,0.91179],[0.12019,0.53908,0.83363],[0.74346,-0.6296,-0.22554],[0.7468,-0.56843,-0.34523],[0.20107,-0.0092542,0.97953],[0.27818,0.14506,0.94951],[0.23715,-0.49199,0.83768],[-0.072631,-0.36795,0.927],[0.010616,-0.99588,0.090071],[-0.301,-0.31944,0.89853],[-0.37637,-0.34777,0.85872],[-0.13838,-0.80725,-0.57375],[-0.023897,-0.97913,-0.20184],[0.37975,0.29142,-0.87799],[0.82237,-0.25834,-0.50692],[0.86413,0.49319,0.10022],[0.85954,0.47467,0.18943],[0.85432,0.51814,0.040862],[0.80154,0.44711,0.39702],[0.72839,0.40327,0.55391],[0.65493,0.38609,0.64961],[0.84543,0.53311,-0.032419],[0.51752,0.39557,0.75875],[0.43538,0.49498,0.75195],[0.8268,0.53889,-0.16123],[0.26755,0.61748,0.73969],[0.11137,0.61743,0.77871],[0.28008,0.48731,0.82709],[0.042861,0.11711,0.99219],[-0.50216,-0.22889,0.83393],[-0.068681,0.59049,0.80412],[0.65986,-0.70572,-0.25796],[0.76237,-0.59255,-0.26015],[-0.52402,-0.85163,-0.011098],[-0.35079,-0.92926,-0.11583],[-0.23636,-0.96368,-0.12429],[-0.26349,-0.95099,-0.16183],[-0.40616,-0.91223,0.053571],[-0.099805,-0.99391,0.046791],[-0.20028,-0.95791,-0.20564],[-0.0075122,-0.99859,-0.052476],[0.023511,-0.99892,0.040053],[0.019181,-0.99906,0.03888],[0.49959,-0.86134,-0.09216],[0.69633,-0.661,-0.27966],[0.022687,-0.99822,0.055162],[-0.10498,-0.91744,-0.38377],[0.028463,-0.9945,0.10083],[0.18407,0.21897,-0.95821],[0.47396,-0.1507,-0.86755],[0.64415,-0.4145,-0.64285],[0.76706,-0.47209,-0.43445],[0.75802,-0.11692,-0.64167],[0.86534,-0.12305,-0.48584],[0.86862,0.093237,-0.48664],[0.82987,0.27515,-0.48539],[0.81555,-0.16607,-0.55435],[0.8351,0.30296,-0.45916],[0.75464,0.00081649,-0.65614],[0.76897,0.013572,-0.63915],[0.85405,0.33149,-0.4009],[0.7689,-0.16022,-0.61897],[0.8149,0.46216,-0.34978],[0.81146,0.49006,-0.3184],[0.35213,0.53045,0.77112],[0.19095,0.65812,0.72829],[0.076609,0.21747,0.97305],[0.16807,0.39745,0.9021],[-0.17719,-0.14784,0.97301],[-0.23002,-0.25026,0.94046],[-0.045226,0.064622,0.99688],[0.017644,0.14108,0.98984],[-0.2969,-0.20896,0.93177],[-0.49325,-0.20922,0.84435],[-0.040837,0.70696,0.70607],[0.79063,-0.5723,-0.21766],[0.81562,-0.43293,-0.38384],[0.29712,0.16373,0.9407],[0.25954,0.19853,0.9451],[0.22345,-0.52466,0.82146],[0.033595,0.0058555,0.99942],[0.012409,-0.99757,0.06858],[-0.45209,-0.094752,0.88693],[-0.63555,-0.22605,0.73823],[-0.11388,-0.83926,-0.53166],[0.00025409,-0.97508,-0.22184],[0.75706,-0.33194,-0.56274],[0.77446,-0.2727,-0.57084],[0.82327,0.56609,0.042176],[0.82996,0.54606,0.11391],[0.80444,0.53593,0.25624],[0.81574,0.57842,-0.0010267],[0.73958,0.49104,0.46033],[0.67628,0.45095,0.58248],[0.54169,0.42356,0.72606],[0.81544,0.57304,-0.081789],[0.37646,0.41845,0.82655],[0.81215,0.54226,-0.21531],[0.06821,0.6326,0.77147],[0.23184,0.52833,0.81677],[-0.066441,0.65755,0.75048],[0.22334,0.64392,0.73177],[0.041032,0.14909,0.98797],[-0.7114,-0.18845,0.67706],[-0.16013,0.62737,0.76208],[0.62281,-0.66714,-0.40869],[0.74652,-0.59106,-0.30556],[-0.44989,-0.88001,-0.15226],[-0.26697,-0.96345,-0.02242],[-0.48038,-0.83046,-0.2821],[-0.47961,-0.80457,-0.3502],[-0.48228,-0.8067,-0.34153],[-0.03504,-0.99909,-0.024167],[0.011289,-0.99991,0.0069973],[-0.4805,-0.86918,-0.11683],[-0.15812,-0.98607,0.051659],[0.023133,-0.99899,0.038591],[0.019196,-0.99942,0.028205],[0.71853,-0.65281,-0.23991],[0.70906,-0.50246,-0.49473],[0.023794,-0.99812,0.056498],[-0.091162,-0.9118,-0.40038],[0.054527,-0.99244,-0.10993],[0.74812,-0.3907,-0.53634],[0.79166,-0.35187,-0.49946],[0.77571,-0.18385,-0.60372],[0.81035,0.097816,-0.57773],[0.75893,0.30958,-0.57287],[0.75706,0.29921,-0.5808],[0.76347,-0.18223,-0.6196],[0.81325,0.25549,-0.52283],[0.75559,-0.0085984,-0.65499],[0.72748,-0.010662,-0.68604],[0.81339,0.41559,-0.40705],[0.69854,-0.137,-0.70233],[0.81482,0.46518,-0.34594],[0.80162,0.50602,-0.31834],[0.28237,0.47405,0.83399],[0.14504,0.82367,0.54821],[0.08601,0.3019,0.94945],[0.077687,0.57319,0.81573],[-0.17003,-0.039412,0.98465],[-0.22063,-0.17132,0.96019],[-0.27807,-0.25617,0.92577],[-0.058755,0.064795,0.99617],[0.031915,0.097816,0.99469],[-0.44856,-0.29371,0.84411],[-0.69377,-0.30009,0.6547],[0.025665,0.7549,0.65534],[0.7907,-0.5456,-0.27771],[0.25756,-0.96379,-0.069087],[0.79727,-0.25822,-0.5456],[0.026914,-0.99659,0.077953],[0.32936,0.1385,0.93399],[0.24476,-0.56319,0.78925],[0.31845,0.3135,0.8946],[-0.048285,0.50908,0.85937],[0.017499,-0.9985,0.051907],[-0.74609,-0.064816,0.66268],[-0.8105,-0.11104,0.57512],[-0.043391,-0.8729,-0.48597],[0.72308,-0.23563,-0.64934],[0.79096,0.61179,0.009478],[0.79245,0.60792,0.049567],[0.78937,0.59501,0.15118],[0.74569,0.57683,0.33348],[0.78573,0.61745,-0.037353],[0.66124,0.55596,0.50366],[0.52826,0.54722,0.64922],[0.36098,0.51994,0.77418],[0.77604,0.61583,-0.13609],[0.7455,0.6109,-0.26651],[0.11098,0.46629,0.87764],[0.057806,0.47887,0.87598],[0.232,0.46576,0.85396],[-0.0015442,0.45683,0.88955],[0.11172,0.79494,0.59632],[0.05044,0.24364,0.96855],[-0.81214,-0.24218,0.53083],[0.081119,0.4752,0.87613],[0.68333,-0.4704,-0.55838],[0.52673,-0.57544,-0.62564],[0.74441,-0.48882,-0.45489],[-0.066154,-0.99705,-0.039023],[-0.15154,-0.98087,-0.12215],[0.012324,-0.99962,-0.024848],[-0.2033,-0.96297,-0.17708],[-0.23871,-0.95658,-0.16725],[-0.38963,-0.92068,0.02304],[0.015545,-0.99971,-0.018435],[0.011813,-0.99993,0.0015722],[-0.4136,-0.85873,0.30253],[-0.035703,-0.99537,0.089216],[0.021889,-0.9996,0.017765],[0.027378,-0.99895,0.036842],[0.64816,-0.58478,-0.48776],[0.37764,-0.87082,-0.31474],[0.70606,-0.33843,-0.62204],[0.024935,-0.99804,0.05735],[-0.47295,0.56684,0.67454],[0.00065618,-0.92298,-0.38484],[0.057389,-0.8899,-0.45253],[0.07171,-0.99053,-0.11707],[0.73916,-0.31397,-0.59587],[0.68474,0.033115,-0.72804],[0.67869,-0.14918,-0.71911],[0.69268,0.30959,-0.65142],[0.69442,0.3358,-0.63641],[0.71992,0.22912,-0.65515],[0.75278,-0.092667,-0.65172],[0.73181,0.33062,-0.59594],[0.75524,-0.05078,-0.65348],[0.677,-0.11881,-0.72633],[0.72418,0.47555,-0.49942],[0.66743,-0.095159,-0.73856],[0.72434,0.50696,-0.46724],[0.67889,0.6136,-0.40324],[0.33674,0.46043,0.82135],[0.026516,0.87818,0.47759],[0.01059,0.55641,0.83084],[-0.031372,0.83517,0.5491],[-0.081115,-0.044848,0.9957],[-0.21255,-0.27861,0.93659],[-0.47328,-0.32514,0.81871],[-0.1099,0.11566,0.98719],[-0.052556,0.20852,0.97661],[-0.70789,-0.31522,0.63209],[-0.80923,-0.29886,0.5058],[0.06683,0.62936,0.77423],[0.75741,-0.21373,-0.61696],[0.044424,-0.99741,0.056654],[0.21997,-0.60679,0.76382],[0.24935,0.10332,0.96288],[0.062379,0.43071,0.90033],[-0.17291,0.7453,0.64392],[0.029476,-0.99699,0.071765],[-0.8296,-0.049651,0.55615],[-0.6509,0.42852,0.62666],[-0.82318,-0.14283,0.54953],[0.71601,-0.15958,-0.67961],[0.73841,0.67401,0.021573],[0.73534,0.67743,-0.019065],[0.7296,0.67998,0.072803],[0.71374,0.67113,0.20039],[0.64751,0.64436,0.40684],[0.71847,0.68974,-0.089754],[0.53998,0.61541,0.57419],[0.44495,0.54588,0.70996],[0.68536,0.69668,-0.21192],[0.63228,0.69269,-0.34698],[0.16774,0.43712,0.88362],[0.18524,0.37097,0.90998],[0.22387,0.27784,0.93418],[0.2243,0.46682,0.85544],[0.20259,0.21462,0.95546],[-0.091418,0.52591,0.84561],[-0.82481,-0.25318,0.50556],[0.14209,0.28708,0.94731],[0.58543,-0.30582,-0.75083],[0.51124,-0.45112,-0.73152],[0.49126,-0.48742,-0.72186],[0.42465,-0.50957,-0.74834],[0.028512,-0.99912,-0.030819],[0.024925,-0.99948,-0.020646],[0.022392,-0.99911,-0.035707],[0.020506,-0.99963,-0.017813],[0.0085767,-0.99912,-0.041134],[-0.12962,-0.96891,0.21076],[-0.263,-0.79967,0.53977],[0.018459,-0.99973,-0.013801],[0.026339,-0.99965,-0.0015789],[-0.087558,-0.94907,0.30266],[0.18123,-0.93125,-0.31612],[0.044335,-0.99889,0.015864],[0.060603,-0.99696,0.049008],[0.37352,-0.58209,-0.72226],[0.65698,-0.19767,-0.72753],[0.099832,-0.99189,0.07871],[-0.22642,0.84959,0.47637],[0.099028,-0.93351,-0.34459],[0.19454,-0.87141,-0.45033],[0.22769,-0.95758,-0.17661],[0.57491,0.22066,-0.7879],[0.55352,0.00733,-0.8328],[0.61663,-0.020271,-0.78699],[0.62641,0.3654,-0.68855],[0.64308,0.27545,-0.71455],[0.60321,0.28469,-0.74504],[0.68356,0.00060547,-0.7299],[0.58878,0.42452,-0.68784],[0.68217,-0.094531,-0.72505],[0.64122,-0.15207,-0.75214],[0.58796,0.5119,-0.62631],[0.65628,-0.027236,-0.75403],[0.57688,0.57535,-0.57981],[0.56955,0.65999,-0.48993],[0.3884,0.55151,0.73823],[-0.07371,0.83875,0.5395],[-0.12476,0.75352,0.64548],[-0.21684,0.16795,0.96165],[-0.21314,-0.12699,0.96873],[-0.50493,-0.34173,0.79263],[-0.70128,-0.38811,0.59797],[-0.19383,0.40731,0.89248],[-0.81024,-0.33946,0.47779],[-0.83158,-0.29433,0.471],[-0.069427,0.3909,0.91781],[-0.023757,-0.99972,0.0019639],[0.67384,-0.10597,-0.73123],[0.23395,-0.9718,0.029617],[0.040112,-0.6541,0.75534],[-0.084795,0.09332,0.99202],[-0.27136,0.50582,0.81885],[-0.38826,0.70462,0.59394],[0.0031263,-0.99033,0.13871],[-0.67322,0.22816,0.70337],[-0.7237,-0.10116,0.68266],[-0.31554,0.80937,0.49533],[-0.64185,-0.20574,0.73871],[0.67182,0.73925,0.046464],[0.66936,0.7429,-0.0082054],[0.66828,0.74039,-0.072208],[0.65657,0.74678,0.10603],[0.62544,0.73695,0.25638],[0.56856,0.68824,0.45062],[0.62373,0.76473,-0.16171],[0.49773,0.62905,0.59713],[0.59327,0.75532,-0.27842],[0.55622,0.72403,-0.40792],[0.22969,0.47805,0.84777],[0.22151,0.4168,0.8816],[0.25511,0.39173,0.88401],[0.19733,0.29207,0.93582],[0.26032,0.62453,0.73634],[0.093579,0.26134,0.9607],[-0.068641,0.9013,0.42771],[-0.1931,0.70623,0.68114],[-0.31098,0.32722,0.89231],[-0.56766,-0.23895,0.78783],[-0.0034579,0.24116,0.97048],[0.44461,-0.33265,-0.83166],[0.24217,-0.36592,-0.89859],[0.38055,-0.49578,-0.78063],[0.4599,-0.27368,-0.84474],[0.17997,-0.36096,-0.91505],[0.029091,-0.99922,-0.026753],[0.032408,-0.99905,-0.029123],[0.025813,-0.99953,-0.016381],[0.034596,-0.99909,-0.024932],[0.02565,-0.99958,-0.013728],[0.03261,-0.99932,0.016944],[-0.036796,-0.96954,0.24213],[-0.16011,-0.7803,0.60457],[-0.096557,-0.91096,0.40102],[0.034353,-0.99932,-0.013021],[0.075316,-0.99711,-0.010267],[0.1059,-0.9412,-0.32083],[0.26207,-0.50672,-0.82131],[0.14612,-0.98894,0.025384],[0.26403,-0.96074,0.08528],[0.54668,-0.065531,-0.83477],[0.3827,-0.9121,0.147],[-0.38337,0.7876,0.48241],[0.1502,-0.95303,-0.26301],[0.31779,-0.86193,-0.39509],[0.41724,-0.88811,-0.1928],[0.5115,0.10968,-0.85226],[0.55994,0.28835,-0.77674],[0.55592,0.072542,-0.82807],[0.60827,0.072059,-0.79045],[0.58195,0.33443,-0.74127],[0.57307,0.31084,-0.75827],[0.48553,0.38431,-0.78522],[0.60441,0.015065,-0.79653],[0.44395,0.48369,-0.75429],[0.61331,-0.12912,-0.77921],[0.65981,-0.11791,-0.74213],[0.48135,0.51391,-0.71007],[0.6126,-0.049442,-0.78885],[0.50863,0.59646,-0.62092],[0.50258,0.67447,-0.54084],[0.35784,0.7311,0.5809],[-0.070058,0.68113,0.72881],[-0.23653,0.84732,0.4755],[-0.52336,0.28316,0.80369],[-0.5743,0.017383,0.81846],[-0.76466,-0.229,0.60238],[-0.82213,-0.3458,0.45225],[-0.35396,0.61742,0.70249],[-0.82856,-0.34009,0.44478],[-0.50265,-0.31497,0.80507],[-0.06542,0.25785,0.96397],[0.4758,-0.87855,0.041971],[-0.26274,-0.60382,0.75257],[-0.36732,0.17833,0.91284],[-0.52686,0.50619,0.68278],[-0.57152,0.5952,0.56489],[-0.099244,-0.98164,0.16289],[-0.25359,-0.02535,0.96698],[-0.33102,0.60223,0.72646],[-0.088592,-0.24367,0.9658],[-0.2723,0.78239,0.56011],[0.03854,-0.22741,0.97304],[0.61993,0.78172,0.067804],[0.61008,0.79229,0.0090959],[0.59783,0.79647,-0.09075],[0.60912,0.77809,0.15345],[0.5468,0.78156,0.30031],[0.4477,0.76326,0.46584],[0.57772,0.79028,-0.20421],[0.53402,0.77376,-0.34076],[0.47305,0.74884,-0.46418],[0.1586,0.541,0.82593],[0.27483,0.6374,0.71985],[0.14849,0.53687,0.8305],[0.14353,0.52251,0.84046],[0.014753,0.42166,0.90663],[0.3477,0.7266,0.59259],[-0.043223,0.36616,0.92955],[-0.13809,0.62967,0.76449],[-0.28937,0.81888,0.49569],[-0.52439,0.50852,0.68296],[0.12463,-0.21575,0.96846],[-0.10181,0.28466,0.95321],[0.22351,-0.43123,-0.87412],[0.35568,-0.41499,-0.83742],[0.078323,-0.4195,-0.90437],[0.33436,-0.28547,-0.89817],[0.37522,-0.091186,-0.92244],[0.16852,-0.21616,-0.9617],[0.032063,-0.99903,-0.030175],[0.030861,-0.99926,-0.023165],[0.027247,-0.99916,-0.030645],[0.022633,-0.99963,-0.014908],[0.01955,-0.99954,0.02335],[0.033659,-0.9992,-0.021435],[-0.003018,-0.97338,0.22918],[-0.098814,-0.77772,0.6208],[-0.076944,-0.89569,0.43798],[0.069401,-0.93887,-0.33721],[0.17897,-0.98339,-0.030111],[0.41708,-0.9082,0.034754],[0.17611,-0.44987,-0.87556],[0.50939,-0.85103,0.12754],[0.48923,-0.86055,0.14183],[0.45615,-0.095519,-0.88476],[0.38948,-0.90997,0.14234],[-0.50376,0.65255,0.56604],[0.060935,-0.99026,-0.12522],[0.15419,-0.98513,-0.075795],[0.324,-0.94419,-0.059392],[0.51651,0.13765,-0.84514],[0.46159,0.22743,-0.85744],[0.46688,0.34901,-0.81253],[0.54321,0.11505,-0.83168],[0.49907,0.063391,-0.86424],[0.49476,0.34168,-0.79904],[0.34742,0.48293,-0.80379],[0.54769,0.021692,-0.8364],[0.37528,0.45161,-0.80946],[0.5869,-0.045242,-0.8084],[0.558,-0.11652,-0.82162],[0.43545,0.49088,-0.7546],[0.45659,0.61478,-0.6431],[0.42815,0.69073,-0.58273],[0.38603,0.80378,0.45268],[-0.19177,0.73973,0.64499],[-0.77579,0.085578,0.62516],[-0.71018,0.35551,0.60767],[-0.87368,-0.12284,0.47074],[-0.85916,-0.26622,0.437],[-0.491,0.69208,0.5291],[-0.50868,-0.29571,0.80858],[0.11456,-0.17063,0.97865],[-0.11974,0.27134,0.95501],[0.21102,-0.97668,0.039679],[-0.60003,0.081083,0.79586],[-0.75003,0.28232,0.59812],[-0.66717,0.46154,0.5847],[-0.56158,-0.58546,0.5847],[-0.22652,-0.96291,0.14661],[0.11623,0.23993,0.96381],[0.3221,-0.19053,0.92733],[0.34447,-0.21128,0.91471],[-0.069955,0.42943,0.90039],[0.29587,-0.12879,0.94651],[0.42831,0.43349,-0.79287],[0.53755,0.84292,0.022914],[0.53361,0.83929,0.10415],[0.52952,0.84757,-0.034952],[0.52503,0.84058,-0.13333],[0.50676,0.83165,0.22704],[0.40673,0.85103,0.33214],[0.50024,0.82357,-0.26738],[0.44112,0.79493,-0.41654],[0.40498,0.76465,-0.50129],[0.11351,0.72268,0.6818],[0.05279,0.64368,0.76347],[0.24018,0.7829,0.57392],[0.11355,0.626,0.77151],[-0.0063725,0.56474,0.82524],[-0.091604,0.4963,0.86331],[0.36266,0.82617,0.43118],[-0.12765,0.43712,0.8903],[-0.31279,0.71641,0.62363],[-0.1175,0.33401,0.93522],[-0.59066,0.58944,0.55107],[0.19642,-0.15529,0.96814],[-0.17298,0.36517,0.91473],[0.14558,-0.50371,-0.85152],[0.17679,-0.42008,-0.8901],[0.25396,-0.22327,-0.94109],[0.13399,-0.43352,-0.89113],[0.25329,-0.10503,-0.96167],[0.32479,-0.10136,-0.94034],[0.13866,-0.1539,-0.97831],[0.033672,-0.99897,-0.030513],[0.031849,-0.99884,-0.036181],[0.017583,-0.99969,-0.017735],[0.011545,-0.99971,0.021268],[0.0045059,-0.9996,-0.027815],[-0.025396,-0.97194,0.23386],[0.24153,-0.96109,-0.13403],[-0.08631,-0.78829,0.60922],[-0.069416,-0.89474,0.44116],[0.057959,-0.92675,-0.37119],[0.10733,-0.41346,-0.90418],[0.4788,-0.86846,-0.12854],[0.38598,-0.9225,0.0024227],[0.1211,-0.99119,0.053677],[0.014852,-0.99984,0.010066],[0.37664,-0.1306,-0.91711],[0.0070044,-0.99962,-0.026569],[-0.23773,0.39678,0.88659],[0.039161,-0.99444,0.097702],[0.018798,-0.99968,0.016642],[0.47803,0.19389,-0.85667],[0.41674,0.2618,-0.87051],[0.36564,0.33085,-0.86997],[0.43513,0.30099,-0.84857],[0.45685,0.081328,-0.88582],[0.46832,0.070013,-0.88078],[0.31782,0.4441,-0.83772],[0.28432,0.5473,-0.78716],[0.38058,0.40382,-0.83192],[0.43383,-0.0092069,-0.90095],[0.40717,0.56286,-0.7193],[0.39113,0.70002,-0.59748],[0.41302,0.8623,0.29302],[-0.093675,0.42439,0.90062],[-0.8441,0.11652,0.52337],[-0.71776,0.34945,0.60226],[-0.86519,-0.086418,0.49394],[-0.56626,-0.1925,0.80143],[-0.44864,0.60266,0.65994],[0.049503,-0.10274,0.99348],[0.1403,-0.1014,0.9849],[-0.1386,0.32767,0.93457],[0.031687,-0.99921,0.024096],[-0.54421,0.34585,0.76435],[-0.17063,0.40372,0.89883],[-0.64161,-0.41143,0.64735],[-0.089939,-0.9563,0.27822],[0.28797,-0.11131,0.95115],[0.2355,-0.2289,0.94453],[0.1582,-0.16205,0.97402],[0.089481,0.037325,0.99529],[0.076721,-0.088796,0.99309],[0.44483,0.07242,-0.89268],[0.32781,0.40174,-0.85507],[0.44162,0.8924,0.092749],[0.4605,0.88764,0.0061208],[0.40258,0.89006,0.21385],[0.46078,0.88489,-0.068156],[0.4545,0.87377,-0.17306],[0.41072,0.84322,-0.34683],[0.36669,0.81314,-0.45203],[0.33111,0.78441,-0.52446],[0.032061,0.77052,0.63661],[0.10427,0.84023,0.53211],[0.052751,0.72344,0.68837],[0.22191,0.88479,0.40975],[-0.011475,0.67313,0.73943],[-0.10631,0.58955,0.80071],[-0.15809,0.53233,0.83164],[0.34978,0.89783,0.26751],[-0.2073,0.48683,0.84854],[-0.21933,0.38532,0.89634],[-0.081008,0.34261,0.93598],[-0.4412,0.40234,0.80216],[0.026517,-0.12185,0.99219],[-0.19798,0.46124,0.8649],[0.21054,-0.56685,-0.79646],[0.22088,-0.42063,-0.87993],[0.16193,-0.2391,-0.9574],[0.21901,-0.13903,-0.96577],[0.11406,-0.49514,-0.8613],[0.27574,-0.17526,-0.94512],[0.31651,-0.13853,-0.93842],[0.13693,-0.15845,-0.97783],[0.017098,-0.99957,-0.024011],[0.034218,-0.99873,-0.036958],[0.019733,-0.99975,0.010124],[-0.0003327,-0.99997,-0.0078187],[-0.04174,-0.96165,0.2711],[0.19538,-0.96899,-0.15129],[-0.080561,-0.78655,0.61224],[0.41498,-0.8752,-0.24863],[-0.069744,-0.90359,0.42267],[0.066168,-0.90843,-0.41277],[0.09517,-0.38708,-0.91712],[0.19671,-0.97711,-0.081026],[-0.18791,-0.9813,0.041586],[-0.10909,-0.98945,-0.095351],[-0.031926,-0.99038,-0.13467],[0.35079,-0.063624,-0.93429],[0.087611,-0.99228,-0.08775],[0.11227,0.32342,0.93957],[-0.064592,0.21113,0.97532],[0.029511,-0.95636,0.29069],[-0.0084888,-0.99848,0.054439],[0.0037626,-0.99689,0.078702],[0.4862,0.11702,-0.86597],[0.485,0.30471,-0.81971],[0.37643,0.36343,-0.85218],[0.33131,0.27958,-0.90115],[0.45462,0.059219,-0.88871],[0.42525,0.056833,-0.90329],[0.22673,0.44778,-0.86492],[0.32834,0.34964,-0.87746],[0.08352,0.52159,-0.8491],[0.35702,0.4255,-0.83156],[0.35136,0.59492,-0.72292],[0.28379,0.73474,-0.61614],[0.40669,0.89356,0.19014],[-0.11031,0.30877,0.94472],[-0.72424,0.052796,0.68752],[-0.34267,0.12687,0.93085],[-0.48803,-0.19559,0.85063],[0.072356,-0.1064,0.99169],[-0.13179,0.38534,0.91331],[0.12683,-0.1061,0.98623],[-0.031575,-0.078839,0.99639],[-0.18083,0.44789,0.87561],[0.038784,-0.99862,0.035308],[0.12934,0.34336,0.93026],[-0.1101,-0.34568,0.93187],[0.20331,0.4042,0.89179],[0.017795,-0.15661,0.9875],[-0.13716,-0.17881,0.97428],[-0.22671,-0.15157,0.9621],[-0.28786,-0.023133,0.95739],[-0.15785,-0.16894,0.9729],[-0.014715,-0.9997,0.019747],[0.44884,0.058048,-0.89172],[0.21837,0.3325,-0.91747],[0.40161,0.913,0.071665],[0.39814,0.91725,-0.011718],[0.39246,0.91529,-0.090624],[0.35534,0.90044,-0.25089],[0.30709,0.8603,-0.40692],[0.25645,0.83322,-0.48988],[0.18517,0.80858,-0.55849],[0.019946,0.8662,0.49931],[-0.0018312,0.81875,0.57415],[0.10111,0.91779,0.38399],[-0.049822,0.78292,0.62013],[0.22096,0.94255,0.25057],[-0.13473,0.71762,0.68327],[-0.17322,0.63496,0.75287],[-0.24518,0.55571,0.7944],[0.33655,0.93,0.14774],[-0.24219,0.54434,0.80314],[-0.10545,0.29076,0.95097],[-0.19121,0.46105,0.86653],[-0.10187,0.2267,0.96862],[-0.067542,-0.13951,0.98791],[-0.25806,0.55969,0.7875],[0.13167,-0.6005,-0.78871],[0.19016,-0.3629,-0.91222],[0.20412,-0.20644,-0.95693],[0.28291,-0.24738,-0.92669],[0.10981,-0.52065,-0.84668],[0.31976,-0.15522,-0.9347],[0.31797,-0.098539,-0.94297],[0.12058,-0.19825,-0.97271],[-0.0019568,-0.99975,-0.022239],[0.013219,-0.99926,-0.036216],[0.019382,-0.99981,-0.003256],[-0.047418,-0.95279,0.29991],[0.098235,-0.99117,-0.08905],[-0.086957,-0.76984,0.63228],[0.38019,-0.86537,-0.32648],[-0.056918,-0.92419,0.37767],[0.29182,-0.94328,-0.15833],[0.093395,-0.88936,-0.44756],[0.12448,-0.34449,-0.9305],[-0.10377,-0.97538,0.19458],[-0.11746,-0.98917,0.088047],[0.094385,-0.98735,-0.12743],[0.3749,-0.033971,-0.92644],[0.073495,-0.99203,-0.10236],[-0.030766,0.5005,0.86519],[-0.29071,0.34031,0.89425],[0.035044,-0.98801,0.15037],[0.18385,-0.54002,0.82133],[0.0068983,-0.99925,0.038189],[-0.011398,-0.99626,0.08562],[0.51305,0.24464,-0.82276],[0.42941,0.040119,-0.90222],[0.45718,0.46537,-0.75791],[0.33062,0.39488,-0.85718],[0.445,0.086891,-0.89131],[0.10488,0.37563,-0.92081],[0.23805,0.28918,-0.9272],[0.311,0.33162,-0.89068],[0.13699,0.51544,-0.84591],[0.30912,0.47327,-0.8249],[0.22916,0.63469,-0.73801],[0.12033,0.75262,-0.64736],[-0.19087,0.42664,0.88405],[-0.24638,-0.16896,0.95433],[-0.1454,0.053158,0.98794],[-0.012199,-0.12943,0.99151],[0.017509,-0.0085176,0.99981],[-0.06452,-0.062246,0.99597],[0.070006,-0.11249,0.99118],[-0.26089,0.54069,0.79974],[0.2405,-0.23492,-0.94179],[0.078405,-0.99144,-0.1044],[0.00021831,-0.99968,0.025407],[0.29669,0.29595,0.90796],[0.16724,0.59782,0.78399],[-0.43007,-0.10787,0.89633],[-0.49053,-0.13107,0.86151],[-0.40515,-0.29451,0.86551],[-0.6461,0.098055,0.75693],[-0.21985,-0.33124,0.91758],[0.0073626,-0.99994,0.0086574],[0.43258,-0.008131,-0.90156],[0.033602,0.54854,-0.83545],[0.31105,0.94968,0.036777],[0.28717,0.95728,-0.033817],[0.24621,0.95781,-0.14827],[0.21398,0.92612,-0.31067],[0.18696,0.87683,-0.44297],[0.096314,0.83547,-0.54103],[0.00060634,0.8053,-0.59287],[-0.0057943,0.94962,0.31335],[-0.029014,0.9049,0.42464],[-0.08087,0.85123,0.51853],[0.076965,0.97701,0.19881],[-0.15946,0.80061,0.57757],[0.1949,0.97427,0.11315],[-0.21012,0.76253,0.61188],[-0.25839,0.66767,0.69817],[-0.27573,0.58281,0.7644],[-0.13571,0.40364,0.9048],[-0.22559,0.5211,0.82314],[-0.19718,0.32402,0.92527],[0.044413,-0.29524,0.95439],[-0.29432,0.61489,0.73164],[0.1422,-0.34859,-0.92643],[0.079749,-0.60124,-0.79508],[0.17638,-0.2388,-0.95492],[0.26652,-0.15434,-0.95139],[0.25559,-0.25708,-0.93198],[0.048907,-0.51059,-0.85843],[0.30706,-0.10957,-0.94536],[0.35746,-0.12215,-0.92591],[0.13717,-0.18296,-0.9735],[0.030322,-0.99838,-0.048128],[0.0045741,-0.9997,-0.024207],[0.018733,-0.99981,0.0056088],[-0.013734,-0.94972,0.3128],[-0.079845,-0.76222,0.64237],[0.34578,-0.89176,-0.2919],[-0.05372,-0.94535,0.32161],[0.3779,-0.88489,-0.27232],[0.10073,-0.87555,-0.47251],[-0.023223,-0.99504,0.096757],[0.18392,-0.30291,-0.9351],[-0.039864,-0.98135,0.18806],[0.12341,-0.98228,-0.14102],[0.077299,-0.99557,-0.053593],[-0.022588,0.67803,0.73469],[-0.47743,0.62722,0.61535],[0.062259,-0.96784,0.24374],[0.02279,-0.99947,0.023181],[0.0050819,-0.99693,0.078136],[0.44552,0.47885,-0.75645],[0.38656,0.14639,-0.91057],[0.39958,0.088109,-0.91245],[0.37755,0.56191,-0.73601],[0.39214,0.10612,-0.91376],[0.1287,0.25601,-0.95807],[0.13451,0.39367,-0.90936],[0.20088,0.20673,-0.95756],[0.2707,0.38505,-0.8823],[0.20112,0.72254,-0.66143],[0.21791,0.55105,-0.80552],[0.081351,0.6651,-0.74231],[-0.060599,0.74479,-0.66454],[-0.32608,0.62856,0.70611],[-0.1903,0.49925,0.8453],[-0.20755,-0.08894,0.97417],[-0.21775,0.14423,0.96529],[-0.081501,0.020109,0.99647],[0.10587,-0.0060734,0.99436],[0.26463,-0.16688,0.9498],[0.20655,-0.20591,0.95652],[-0.21693,0.58878,0.77864],[0.21367,-0.29483,-0.93136],[0.16219,-0.9867,-0.010995],[-0.002498,-0.99963,0.027252],[0.20191,-0.37465,0.90491],[0.21102,0.39708,0.8932],[0.11012,0.72861,0.67601],[-0.69671,-0.10311,0.70991],[-0.54325,-0.33757,0.76872],[-0.3123,-0.47839,0.82074],[-0.834,0.35485,0.42253],[-0.13793,-0.51235,0.84763],[0.020145,-0.99915,0.035833],[0.0082298,-0.99911,0.041257],[0.3356,-0.042881,-0.94103],[0.19512,0.71909,-0.66696],[0.17351,0.9848,0.00743],[0.13755,0.98757,-0.076033],[0.10997,0.97324,-0.20179],[0.087308,0.93363,-0.34744],[0.033582,0.86835,-0.49482],[0.0093017,0.82392,-0.56663],[-0.025699,0.75622,-0.65381],[-0.035417,0.98732,0.15472],[-0.071282,0.97213,0.22335],[-0.10431,0.93788,0.33092],[-0.19813,0.87136,0.44887],[0.054712,0.99503,0.083162],[-0.26966,0.82017,0.50459],[-0.28763,0.7988,0.52838],[-0.32269,0.70942,0.62657],[-0.19244,0.47092,0.86093],[-0.15796,0.53974,0.82688],[-0.079443,0.35075,0.93309],[-0.012422,-0.42821,0.90359],[-0.28633,0.68543,0.66947],[-0.17173,0.65012,0.74017],[0.10985,-0.38642,-0.91576],[0.18863,-0.28361,-0.94021],[-0.021657,-0.60405,-0.79665],[0.18471,-0.10618,-0.97704],[0.2096,-0.10676,-0.97194],[0.21759,-0.21052,-0.95307],[0.054572,-0.44734,-0.8927],[0.25848,-0.16469,-0.95187],[0.20784,-0.13544,-0.96874],[0.082195,-0.99659,0.007506],[0.37935,-0.91265,-0.15217],[0.057174,-0.99628,0.064541],[0.063401,-0.9315,0.35818],[-0.0096165,-0.77469,0.63227],[-0.036402,-0.95947,0.27945],[0.43256,-0.85705,-0.27993],[0.094867,-0.86743,-0.48843],[0.092822,-0.99261,-0.078121],[0.21388,-0.30152,-0.92916],[-0.0093261,-0.97819,0.2075],[0.15899,-0.97372,0.1631],[0.17801,-0.9829,-0.047208],[0.042621,-0.99908,0.0042342],[-0.15165,0.88371,0.44279],[-0.82621,-0.090148,0.55611],[-0.51986,0.84538,0.12276],[0.024828,-0.93029,0.36599],[0.016545,-0.99982,0.0088681],[-0.0099083,-0.99813,0.060285],[0.37525,0.38255,-0.8443],[0.38525,0.64582,-0.65917],[0.33838,0.12959,-0.93204],[0.3376,0.12422,-0.93306],[0.27673,0.079655,-0.95764],[0.13327,0.31447,-0.93986],[0.10371,0.18904,-0.97648],[0.20178,0.61458,-0.76261],[0.084133,0.28441,-0.955],[0.098987,0.57417,-0.81273],[0.26047,0.81665,-0.51501],[-0.07539,0.68104,-0.72835],[-0.091915,0.71426,-0.69382],[-0.36025,0.73873,0.56964],[-0.16892,0.48605,0.85745],[-0.053812,0.026242,0.99821],[0.048534,0.15549,0.98665],[0.21513,0.060583,0.9747],[0.28874,0.0097072,0.95736],[0.12978,-0.15046,0.98006],[-0.041121,-0.22283,0.97399],[-0.092942,0.5993,0.79511],[0.16846,-0.31659,-0.93348],[0.19698,-0.97998,0.02886],[-0.12955,-0.99039,0.048406],[-0.0077,-0.20305,0.97914],[-0.080374,0.49689,0.86408],[-0.15105,0.80014,0.58048],[-0.66253,-0.37382,0.64908],[-0.31927,-0.61116,0.72426],[-0.12766,-0.57366,0.80908],[-0.94163,-0.07864,0.32732],[-0.90483,0.40517,0.13083],[-0.070595,-0.55615,0.82808],[0.0024955,-0.99551,0.094626],[-0.0011912,-0.99968,0.025174],[-0.13411,-0.99096,0.0028338],[0.24246,-0.059104,-0.96836],[0.20728,0.79115,-0.57543],[0.036836,0.99906,-0.022849],[0.01599,0.99324,-0.11494],[-0.0014279,0.96873,-0.24812],[-0.014507,0.90711,-0.42063],[0.029299,0.79698,-0.6033],[0.0092511,0.69074,-0.72304],[-0.055993,0.99725,0.04864],[-0.09608,0.98954,0.10758],[-0.12135,0.97968,0.15967],[-0.21058,0.94123,0.26408],[-0.30609,0.87465,0.37589],[-0.334,0.83987,0.42785],[-0.33252,0.81858,0.46836],[-0.091249,0.46587,0.88014],[-0.043505,0.49892,0.86555],[0.11446,0.27028,0.95595],[-0.15358,-0.3666,0.91761],[-0.21281,0.79426,0.5691],[-0.071321,0.69925,0.71131],[0.0021339,0.62315,0.7821],[-0.03419,-0.41332,-0.90995],[0.10155,-0.29308,-0.95068],[-0.094186,-0.54452,-0.83344],[0.18792,-0.06969,-0.97971],[0.19297,-0.13637,-0.97168],[0.20343,-0.18481,-0.96149],[0.18171,-0.19694,-0.96343],[0.029655,-0.28736,-0.95736],[0.16771,-0.032872,-0.98529],[0.53849,-0.83587,0.10652],[0.38006,-0.88996,0.25204],[0.51476,-0.8529,-0.087066],[0.26038,-0.86261,0.43371],[0.07641,-0.80469,0.58875],[0.02541,-0.96732,0.25228],[0.077773,-0.90896,-0.40956],[0.19012,-0.9772,-0.094549],[0.17334,-0.27954,-0.94436],[0.054526,-0.9981,0.028583],[0.066012,-0.99024,0.12274],[0.086508,-0.99295,0.081037],[0.087947,-0.99608,0.009875],[-0.045904,-0.99817,0.039328],[-0.27681,0.94563,0.17076],[-0.74403,-0.46784,0.47701],[-0.59497,0.78814,-0.15762],[-0.067363,-0.80266,0.59262],[-0.02279,-0.99956,0.018794],[-0.078336,-0.99659,0.026009],[0.26853,0.34888,-0.89787],[0.24655,0.64281,-0.72527],[0.31913,0.14926,-0.93588],[0.33706,0.083226,-0.9378],[0.30335,0.023718,-0.95258],[0.14801,0.4051,-0.90221],[0.18524,0.27021,-0.94481],[0.047471,0.29253,-0.95508],[0.12372,0.78386,-0.60849],[-0.063106,0.5327,-0.84395],[-0.10899,0.67702,-0.72785],[-0.016427,0.8994,-0.43681],[-0.034164,0.67204,-0.73973],[-0.33064,0.83546,0.43895],[0.056301,0.42293,0.90441],[0.22457,0.04366,0.97348],[0.19118,0.38281,0.90383],[0.1504,0.28481,0.94671],[0.20361,0.091183,0.9748],[0.041086,0.079023,0.99603],[-0.092989,-0.083549,0.99216],[-0.14432,-0.20472,0.96812],[0.047101,0.58064,0.81279],[0.11835,-0.35028,-0.92914],[0.0861,-0.99624,0.0095338],[-0.59422,-0.74854,0.29427],[-0.86056,-0.3149,-0.40033],[-0.33606,0.082493,0.93822],[-0.50305,0.49643,0.70746],[-0.50807,0.74553,0.43133],[-0.39616,0.90871,-0.13153],[-0.33473,-0.7319,0.59353],[-0.1619,-0.71473,0.68041],[-0.12565,-0.61701,0.77686],[-0.67809,-0.65774,0.32798],[-0.99272,-0.088681,0.081533],[-0.92121,0.3718,-0.11464],[-0.15899,-0.49224,0.85581],[-0.12495,-0.97207,0.19868],[-0.063993,-0.99793,0.0058993],[-0.33005,-0.94185,-0.063179],[0.2598,-0.11796,-0.95843],[0.18376,0.78368,-0.59336],[0.21497,0.62748,-0.74837],[-0.065012,0.99671,-0.04831],[-0.073451,0.98616,-0.14863],[-0.07017,0.95401,-0.29143],[-0.10908,0.76776,-0.63139],[-0.11459,0.88908,-0.44318],[-0.060019,0.68535,-0.72573],[-0.11674,0.99306,0.014135],[-0.14027,0.98836,0.0589],[-0.1951,0.97311,0.12247],[-0.28822,0.92744,0.23828],[-0.34687,0.87382,0.34077],[-0.34371,0.85868,0.38017],[0.10072,0.50838,0.85522],[0.073702,0.36035,0.9299],[-0.02588,0.3291,0.94394],[-0.1608,-0.33674,0.92777],[-0.14298,0.88791,0.43723],[0.048315,0.82423,0.5642],[0.070233,0.68456,0.72557],[0.044893,0.6131,0.78873],[-0.17658,-0.41442,-0.89279],[-0.011228,-0.37142,-0.9284],[-0.26703,-0.40694,-0.87355],[0.23258,-0.20223,-0.95132],[0.25076,-0.10506,-0.96233],[0.24208,-0.21552,-0.94602],[0.13455,-0.23713,-0.96212],[-0.18188,-0.016177,-0.98319],[0.06163,0.12906,-0.98972],[0.40594,-0.90978,0.086725],[0.47942,-0.84549,0.23515],[0.42034,-0.84596,0.32813],[0.17722,-0.98367,0.031401],[0.19706,-0.89573,0.39854],[0.032433,-0.98055,0.19359],[0.11584,-0.93847,-0.32535],[0.24704,-0.46631,-0.84943],[0.054971,-0.99849,-0.0018899],[0.0040527,-0.99994,0.010521],[0.020924,-0.99933,0.030184],[0.021416,-0.99955,0.020778],[-0.0072932,-0.99987,0.014664],[-0.10448,-0.99328,0.049807],[-0.62684,0.77508,0.079574],[-0.30993,-0.83568,0.45341],[-0.62743,0.70015,-0.34078],[-0.44927,0.82947,-0.33188],[-0.41883,-0.46593,0.77942],[-0.17035,-0.97941,0.10831],[-0.43252,-0.89732,-0.087972],[0.30674,0.37513,-0.87475],[0.34503,0.16359,-0.92423],[0.3073,0.04851,-0.95037],[0.25376,-0.014882,-0.96715],[0.094388,0.52816,-0.84388],[0.16084,0.24141,-0.957],[0.15211,0.36564,-0.91824],[0.0076007,0.54608,-0.8377],[0.045809,0.84832,-0.52749],[-0.062763,0.67986,-0.73065],[-0.11923,0.94423,-0.30694],[-0.051199,0.64426,-0.76309],[-0.29757,0.87604,0.37948],[0.20806,0.47464,0.85524],[0.092335,0.17153,0.98084],[-0.0027962,0.39455,0.91887],[0.031777,0.099235,0.99456],[-0.00038002,0.0058368,0.99998],[-0.028379,-0.1519,0.98799],[-0.087799,-0.26392,0.96054],[0.019569,0.61209,0.79054],[-0.031254,-0.3716,-0.92787],[0.12957,0.011108,-0.99151],[-0.84283,0.53816,0.0040643],[-0.58549,-0.60648,0.53794],[-0.88446,-0.40156,-0.23766],[-0.71889,0.27031,0.64041],[-0.78476,0.46816,0.40618],[-0.63371,0.75259,-0.17895],[-0.20686,-0.8053,0.55561],[-0.2352,-0.70741,0.66652],[-0.25043,-0.60818,0.75327],[-0.26174,-0.88469,0.38576],[-0.77631,-0.59917,0.19577],[-0.9917,-0.05039,-0.11831],[-0.88229,0.3977,-0.25177],[-0.26497,-0.46816,0.84298],[-0.68931,-0.50066,0.52363],[-0.65113,-0.75726,-0.050867],[0.20291,-0.1097,-0.97303],[0.22091,0.60742,-0.76305],[0.072253,0.79088,-0.60769],[-0.12547,0.9893,-0.074452],[-0.13194,0.97423,-0.18296],[-0.24082,0.74835,-0.61804],[-0.2402,0.83851,-0.48908],[-0.21111,0.91665,-0.33939],[-0.14456,0.72014,-0.67861],[-0.15912,0.987,-0.022662],[-0.18691,0.9821,0.023512],[-0.25351,0.96127,0.10812],[-0.32283,0.92014,0.22165],[-0.33785,0.88337,0.32483],[0.042363,0.62096,0.78269],[-0.11925,0.40403,0.90694],[-0.0016283,0.5636,0.82605],[0.042096,0.4127,0.90989],[-0.26596,-0.37969,0.88606],[-0.050124,0.89224,0.44877],[0.16696,0.86968,0.46452],[0.1502,0.79101,0.59308],[0.02286,0.7002,0.71358],[-0.056397,0.68183,0.72933],[-0.39975,-0.38531,-0.83171],[-0.24673,-0.41496,-0.87575],[-0.49917,-0.27808,-0.82067],[0.25527,-0.18768,-0.94848],[0.21338,-0.17754,-0.9607],[0.15654,-0.19815,-0.96759],[-0.11478,-0.28414,-0.95189],[-0.049592,0.41825,-0.90698],[-0.00034876,0.29224,-0.95634],[0.048033,-0.99881,-0.0083446],[0.10839,-0.99403,0.012123],[0.14362,-0.98522,0.093347],[0.12844,-0.98191,0.1391],[0.024488,-0.99966,-0.0085347],[0.015811,-0.99567,0.091562],[0.0052139,-0.94083,-0.33885],[0.17703,-0.35629,-0.91745],[0.015088,-0.99981,0.01204],[0.013026,-0.99986,0.010957],[-0.04313,-0.99819,0.041795],[-0.6456,0.54031,-0.53969],[-0.66578,0.32959,0.66941],[-0.10903,-0.98744,0.11433],[-0.79505,0.44373,-0.41352],[-0.84864,0.51701,0.11189],[-0.26647,-0.8597,0.43579],[-0.2996,-0.8821,0.36351],[-0.66284,0.69837,-0.27006],[-0.483,0.73727,-0.47239],[-0.62394,0.67665,-0.39096],[-0.89113,-0.39172,0.22898],[-0.98614,-0.060928,-0.15431],[0.22205,0.38081,-0.89759],[0.22234,0.16467,-0.96096],[0.2051,0.032152,-0.97821],[0.17601,-0.038018,-0.98365],[-0.0017642,0.64421,-0.76485],[0.061737,0.25986,-0.96367],[0.015929,0.3643,-0.93114],[-0.038902,0.57055,-0.82034],[-0.056504,0.87462,-0.48151],[-0.10812,0.6422,-0.75887],[-0.18354,0.9585,-0.21817],[-0.055078,0.63401,-0.77136],[-0.22208,0.91552,0.33541],[-0.033068,0.28667,0.95746],[0.048417,0.3217,0.9456],[0.04565,0.1975,0.97924],[-0.037026,0.018426,0.99914],[-0.1401,-0.11917,0.98294],[-0.32802,-0.27639,0.90334],[-0.011403,0.65578,0.75487],[-0.50421,0.18515,-0.8435],[-0.32164,-0.34511,-0.88173],[0.028873,0.26517,-0.96377],[0.011952,-0.99993,-8.6108e-05],[1.0849e-05,-0.99984,0.017831],[-0.64673,0.73692,-0.19668],[-0.5455,0.67199,0.50085],[-0.62456,-0.49167,0.60679],[-0.64521,0.33453,0.68687],[-0.86992,0.31518,0.37934],[-0.84602,0.5061,-0.16767],[-0.29567,-0.78492,0.5445],[-0.31688,-0.68201,0.65913],[-0.34313,-0.56975,0.74676],[-0.25114,-0.9007,0.35448],[-0.2955,-0.86366,0.40839],[-0.38914,-0.8882,0.24428],[-0.85203,-0.52098,0.051185],[-0.96367,0.067985,-0.25831],[-0.74985,0.6587,0.062031],[-0.37338,-0.45347,0.80929],[-0.97806,0.20148,0.052955],[0.13984,-0.06834,-0.98781],[0.108,0.59103,-0.79938],[0.0079732,0.78706,-0.61683],[-0.17044,0.97932,-0.109],[-0.23601,0.80498,-0.54434],[-0.19079,0.78391,-0.59084],[-0.26396,0.87909,-0.3969],[-0.24795,0.92924,-0.27392],[-0.13061,0.75419,-0.64353],[-0.19801,0.97844,-0.058631],[-0.23885,0.97105,-0.0046706],[-0.29851,0.95039,0.087483],[-0.30509,0.93162,0.19749],[0.0029927,0.65346,0.75696],[-0.080506,0.52535,0.84707],[0.026923,0.4866,0.87321],[0.068891,0.44101,0.89485],[-0.4218,-0.35412,0.83468],[0.036906,0.94714,0.3187],[0.19964,0.88234,0.42616],[0.1331,0.87832,0.45918],[-0.064752,0.83762,0.5424],[-0.17368,0.75122,0.63679],[0.30752,0.53581,0.78635],[-0.46594,-0.37236,-0.80265],[-0.5951,-0.33765,-0.72928],[-0.76647,-0.18909,-0.61382],[0.18095,-0.075903,-0.98056],[0.12133,-0.1565,-0.9802],[-0.11741,-0.28283,-0.95196],[-0.34865,-0.3347,-0.87545],[-0.17018,0.65498,-0.73624],[-0.20102,0.54714,-0.81255],[-0.57739,-0.74231,-0.33998],[-0.21944,-0.75517,-0.61771],[-0.5587,-0.79998,-0.21885],[0.004898,-0.99983,0.017569],[-0.025632,-0.99959,-0.012419],[-0.017291,-0.99788,-0.06272],[-0.1697,-0.85566,-0.48892],[-0.19118,-0.21108,-0.95859],[0.0093557,-0.99996,-0.0009169],[-0.0060716,-0.99998,0.00077729],[-0.029127,-0.99814,0.053569],[-0.47711,0.63708,0.60539],[-0.16559,-0.97612,0.1406],[-0.36467,-0.82118,0.43896],[-0.26323,-0.92871,0.26116],[-0.54015,0.78617,0.3003],[0.12194,0.38477,-0.91492],[0.17136,0.1824,-0.96818],[0.16985,-0.018027,-0.98531],[-0.10361,0.75222,-0.65072],[-0.057174,0.31912,-0.94599],[-0.070125,0.37605,-0.92394],[-0.13794,0.52896,-0.83736],[-0.11228,0.89191,-0.43805],[-0.065374,0.58568,-0.8079],[-0.2187,0.96362,-0.15367],[-0.066643,0.63336,-0.77098],[-0.15796,0.97408,0.1619],[-0.019436,0.30758,0.95132],[-0.054972,0.32328,0.94471],[-0.1464,0.27513,0.9502],[-0.28555,0.15504,0.94574],[-0.41553,-0.019988,0.90936],[-0.49208,-0.20121,0.84698],[0.31472,0.6128,0.72487],[0.3121,0.44002,0.84201],[-0.85993,0.12653,-0.49448],[-0.51402,-0.3377,-0.78851],[-0.49629,0.71634,-0.49046],[-0.35511,0.43343,-0.82827],[-0.028786,-0.99624,-0.081761],[-0.01781,-0.99982,0.0065108],[-0.39524,0.7477,0.5336],[-0.76383,0.42572,0.48511],[-0.88541,-0.30299,0.3525],[-0.56681,0.687,0.45471],[-0.39686,-0.75114,0.52754],[-0.39136,-0.65726,0.64409],[-0.41558,-0.51921,0.7468],[-0.31517,-0.91753,0.24248],[-0.37755,-0.85886,0.34614],[-0.45516,-0.79861,0.39376],[-0.32938,-0.92834,0.17229],[-0.57072,-0.77458,0.2726],[-0.94192,-0.22369,0.2505],[-0.93753,0.31641,0.14467],[-0.51991,0.69072,0.50259],[-0.47541,-0.42315,0.77132],[0.1098,-0.05516,-0.99242],[0.072481,0.56885,-0.81924],[-0.065462,0.78524,-0.61572],[-0.11644,0.81485,-0.56785],[-0.1941,0.88456,-0.42413],[-0.077894,0.798,-0.59761],[-0.23606,0.9164,-0.32324],[-0.24381,0.94635,-0.21206],[-0.11555,0.71729,-0.68713],[-0.2377,0.96639,-0.097971],[-0.27171,0.96219,-0.018879],[-0.26782,0.96104,0.068333],[0.16439,0.42334,0.89093],[0.054361,0.46041,0.88604],[-0.044705,0.48612,0.87275],[-0.52742,-0.31579,0.78874],[0.18753,0.94773,0.25813],[0.099351,0.9907,0.09293],[0.098271,0.92478,0.36761],[0.1782,0.84103,0.5108],[0.23849,0.69432,0.679],[0.68526,0.032541,0.72757],[0.76578,0.13256,0.62929],[-0.651,-0.32615,-0.68544],[-0.823,-0.26737,-0.50117],[-0.91515,-0.14874,-0.37466],[0.094356,-0.018937,-0.99536],[-0.13011,-0.20217,-0.97067],[-0.37496,-0.32137,-0.86956],[-0.54834,-0.34828,-0.76028],[-0.32622,0.82339,-0.46434],[-0.49442,0.67444,-0.54835],[-0.91777,0.23332,-0.32135],[-0.61896,0.2356,-0.74926],[-0.23811,-0.50978,-0.8267],[-0.69994,-0.62701,-0.34197],[-0.51574,-0.54834,-0.65828],[-0.55746,0.09796,-0.82441],[-0.057611,-0.99306,-0.10256],[-0.17554,-0.96341,-0.20257],[-0.088286,-0.99568,0.028683],[-0.38543,0.82337,0.41654],[-0.75596,-0.65378,-0.033157],[-0.47314,-0.78191,0.40589],[-0.2752,-0.95659,0.095977],[-0.72562,0.41576,0.54828],[0.12255,0.38607,-0.91429],[0.15034,0.19188,-0.96984],[0.070492,-0.048325,-0.99634],[-0.077334,0.4169,-0.90566],[-0.14613,0.83674,-0.52774],[-0.059417,0.33957,-0.9387],[-0.084302,0.49741,-0.86341],[-0.17865,0.8824,-0.43526],[-0.025091,0.54915,-0.83535],[-0.10665,0.64603,-0.75582],[-0.14396,0.98917,0.028601],[-0.14424,0.28294,0.94823],[-0.17237,0.35903,0.91727],[-0.26414,0.22404,0.9381],[-0.36724,0.12205,0.92208],[-0.49299,-0.042292,0.86901],[-0.53789,-0.16652,0.8264],[0.79046,0.24514,0.56132],[0.52102,-0.042428,0.85249],[-0.80016,0.48024,-0.35932],[-0.93993,-0.028693,-0.34016],[-0.68121,-0.31809,-0.65937],[-0.38493,0.8775,-0.28605],[-0.64369,0.52042,-0.56109],[-0.89688,0.2313,-0.37696],[-0.23261,0.21719,-0.94801],[-0.32726,-0.45775,-0.82666],[-0.37361,-0.87207,-0.3161],[-0.46483,0.76864,0.43946],[-0.93083,0.36525,0.012328],[-0.72545,0.68538,0.063069],[-0.49238,0.86482,0.098217],[-0.47731,-0.72482,0.49679],[-0.50826,-0.5846,0.63239],[-0.53765,-0.45796,0.70796],[-0.445,-0.86443,0.23396],[-0.37158,-0.92441,0.086014],[-0.55157,-0.75838,0.34732],[-0.55385,-0.76905,0.31907],[-0.38343,-0.92356,-0.003444],[-0.59619,-0.75518,0.27252],[-0.80168,-0.20931,0.55991],[-0.69411,0.45261,0.55978],[-0.57134,-0.41782,0.7064],[0.052714,-0.023462,-0.99833],[-0.0026433,0.57228,-0.82006],[-0.16438,0.75963,-0.62924],[-0.065167,0.8327,-0.54988],[-0.12817,0.89029,-0.43699],[-0.1766,0.92539,-0.33535],[-0.03412,0.75498,-0.65486],[-0.22115,0.94367,-0.24615],[-0.24734,0.96039,-0.12832],[-0.064776,0.65981,-0.74863],[-0.24205,0.96953,-0.037778],[0.27695,-0.030626,0.9604],[0.19537,0.14913,0.96932],[-0.055112,0.24004,0.9692],[-0.59845,-0.33237,0.72896],[0.25081,0.96423,0.085724],[0.15615,0.95904,0.23635],[0.15478,0.9876,-0.026122],[0.27319,0.89204,0.36004],[0.7173,0.42807,0.54976],[0.65669,-0.11721,0.74499],[0.76117,0.03525,0.6476],[0.82472,0.16033,0.54233],[-0.8407,-0.29169,-0.45624],[-0.91823,-0.23307,-0.32022],[-0.9228,-0.19877,-0.33004],[-0.14828,-0.057178,-0.98729],[-0.41863,-0.20525,-0.88466],[-0.57774,-0.31332,-0.75369],[-0.7149,-0.33259,-0.61506],[-0.3881,0.84613,-0.36529],[-0.61979,0.6307,-0.46699],[-0.76284,0.39106,-0.51493],[-0.83531,0.46778,-0.28886],[-0.37311,0.30066,-0.87772],[-0.30158,0.30446,-0.90352],[-0.7879,0.3161,-0.52848],[-0.50554,-0.3451,-0.79078],[-0.71953,-0.11833,-0.68431],[-0.73073,-0.61986,-0.28602],[-0.44903,0.87931,0.15872],[-0.95777,0.12133,-0.2607],[-0.56086,-0.7412,0.36885],[-0.2984,-0.95222,-0.065076],[0.0082029,0.38993,-0.92081],[-0.0033184,0.19113,-0.98156],[-0.077785,0.073622,-0.99425],[-0.070869,0.49649,-0.86514],[0.043191,0.29307,-0.95511],[-0.23316,0.85308,-0.46678],[0.0080078,0.4612,-0.88726],[-0.27599,0.85417,-0.4407],[-0.05233,0.56852,-0.821],[-0.1012,0.62416,-0.77471],[-0.10846,0.99212,-0.062737],[-0.24216,0.29438,0.9245],[-0.29636,0.3739,0.87885],[-0.35137,0.19871,0.91491],[-0.49668,0.084322,0.86383],[-0.60976,-0.0063934,0.79256],[-0.68374,-0.11707,0.72028],[0.68205,0.64143,0.35124],[0.85181,0.29018,0.43614],[0.53322,-0.29627,0.79241],[-0.60914,0.73845,-0.2892],[-0.93796,0.12766,-0.32238],[-0.93072,-0.17368,-0.32186],[-0.84698,-0.28802,-0.44684],[-0.32365,0.92399,-0.20367],[-0.7486,0.4971,-0.43874],[-0.3138,0.39548,-0.86321],[-0.35918,0.34516,-0.8671],[-0.86625,0.09728,-0.49005],[-0.75963,0.54502,0.35484],[-0.79892,0.54179,-0.26114],[-0.60919,0.75111,-0.25441],[-0.45823,0.86738,-0.19409],[-0.6223,-0.62106,0.47648],[-0.62444,-0.48748,0.61028],[-0.5544,-0.83068,0.051107],[-0.65815,-0.72802,0.1919],[-0.4094,-0.91019,-0.062874],[-0.63482,-0.72508,0.26695],[-0.63342,-0.72305,0.27566],[-0.75987,-0.6356,0.13643],[-0.37311,-0.92231,-0.10062],[-0.8736,-0.095148,0.47726],[-0.64574,-0.45657,0.61202],[-0.19455,0.020375,-0.98068],[-0.17383,0.51168,-0.84141],[-0.31982,0.66398,-0.6759],[-0.042819,0.82206,-0.5678],[-0.049577,0.88631,-0.46044],[-0.093739,0.93544,-0.34082],[-0.15029,0.95609,-0.25161],[-0.020925,0.71617,-0.69761],[-0.20512,0.96712,-0.15036],[0.013279,0.62163,-0.7832],[0.51265,-0.40569,0.7567],[0.45298,-0.49255,0.7431],[-0.14072,0.047018,0.98893],[-0.72122,-0.28007,0.63356],[0.22181,0.97191,0.078648],[0.2958,0.95421,-0.044488],[0.28271,0.93459,0.2159],[0.19727,0.97561,-0.096279],[0.67193,0.71526,0.19212],[0.84554,0.40608,0.34665],[0.66903,0.13989,0.72995],[0.62066,-0.065379,0.78135],[0.70961,0.28316,0.64519],[0.76851,0.36736,0.52387],[-0.91352,-0.28126,-0.29388],[-0.90753,-0.25613,-0.33285],[-0.88636,-0.28502,-0.36486],[-0.45443,-0.10294,-0.88482],[-0.60273,-0.18418,-0.77639],[-0.73652,-0.29864,-0.60692],[-0.84232,-0.32008,-0.43365],[-0.50773,0.81607,-0.27611],[-0.73221,0.62979,-0.25929],[-0.46442,0.39433,-0.79298],[-0.68444,0.60044,-0.41353],[-0.37325,0.30865,-0.87488],[-0.32987,0.49096,-0.80631],[-0.51252,0.44526,-0.73422],[-0.68196,0.54108,-0.4921],[-0.69968,0.70741,-0.1001],[-0.69706,-0.62766,0.34661],[-0.31329,-0.93328,-0.17559],[-0.1813,0.32743,-0.92732],[-0.27358,0.25402,-0.9277],[0.0002127,0.22596,-0.97414],[-0.16567,0.49262,-0.85433],[0.0075367,0.43782,-0.89903],[-0.33913,0.8224,-0.45677],[-0.46076,0.7559,-0.4651],[-0.12962,0.56301,-0.81622],[-0.075889,0.53023,-0.84445],[-0.040448,0.98541,-0.16534],[-0.39296,0.33187,0.85758],[0.18477,-0.65875,0.72932],[-0.31417,0.15591,0.93648],[-0.54195,0.23112,0.808],[-0.66129,0.11263,0.74162],[-0.72638,0.040748,0.68609],[-0.78995,-0.06645,0.60956],[0.85012,0.48389,0.20771],[0.81108,0.43822,0.38744],[0.56993,-0.29161,0.76821],[-0.65042,0.34702,-0.67567],[-0.27264,0.72209,-0.63581],[-0.64849,-0.14189,-0.74788],[-0.59124,-0.3552,-0.72406],[-0.90084,-0.307,-0.30697],[-0.48372,0.77275,-0.41093],[-0.43686,0.38586,-0.81257],[-0.40266,0.63707,-0.65727],[-0.98427,0.053417,0.1684],[-0.50146,0.73794,-0.45164],[-0.49794,0.77148,-0.39607],[-0.69832,-0.54029,0.4695],[-0.70497,-0.70835,0.035449],[-0.62134,-0.78138,-0.058097],[-0.67511,-0.72658,0.12771],[-0.46095,-0.85829,-0.22554],[-0.68125,-0.69925,0.21667],[-0.75489,-0.60289,0.2582],[-0.76912,-0.63385,-0.081738],[-0.35788,-0.91144,-0.20296],[-0.73589,-0.4044,0.54308],[-0.49396,0.074687,-0.86627],[-0.30575,0.42698,-0.851],[-0.52598,0.543,-0.6546],[0.043949,0.8453,-0.53248],[-0.0014518,0.77866,-0.62744],[0.065429,0.92071,-0.38473],[0.028141,0.96429,-0.26335],[-0.011183,0.69989,-0.71416],[-0.0010528,0.54092,-0.84108],[0.70798,-0.5464,0.44745],[0.47697,-0.80175,0.36015],[-0.027625,-0.64185,0.76633],[-0.81855,-0.21206,0.53386],[0.24351,0.96791,-0.062049],[0.29808,0.95404,0.030754],[0.30517,0.94402,-0.12529],[0.63491,0.76889,0.075527],[0.24295,0.95039,-0.19423],[0.8616,0.50193,0.075596],[0.82122,0.49826,0.27811],[0.54043,0.29034,0.7897],[0.58302,0.37917,0.71855],[0.64879,0.12366,0.75085],[0.64997,0.42769,0.62819],[0.74103,0.45945,0.48967],[-0.89327,-0.30798,-0.32744],[-0.83672,-0.33201,-0.43551],[-0.5028,-0.43539,-0.74674],[-0.6697,-0.049982,-0.74094],[-0.76038,-0.13843,-0.63456],[-0.8776,-0.20735,-0.43223],[-0.91161,-0.27221,-0.308],[-0.34743,0.15872,-0.92418],[-0.44406,0.39193,-0.80573],[-0.46757,0.13566,-0.87349],[-0.50492,0.58816,-0.63176],[-0.93674,0.26324,-0.2307],[-0.76874,0.49601,-0.40374],[-0.76091,-0.56887,0.3121],[-0.72923,-0.54447,0.41446],[-0.3897,-0.88828,-0.2431],[-0.51492,0.33308,-0.78989],[-0.12831,0.1756,-0.97606],[-0.13516,0.37447,-0.91734],[-0.24923,0.48682,-0.83719],[-0.53125,0.66798,-0.52112],[-0.69398,0.56001,-0.45252],[-0.16869,0.49239,-0.85387],[-0.036207,0.4404,-0.89707],[0.73889,-0.39115,0.54867],[-0.52811,0.24864,0.81196],[0.26558,-0.91699,0.29766],[-0.53893,-0.069795,0.83945],[-0.63688,0.20777,0.74244],[-0.70375,0.083336,0.70554],[-0.76676,-0.025074,0.64145],[-0.82472,-0.10699,0.55534],[0.85379,0.48727,0.18335],[0.81596,0.47347,0.33171],[0.81474,-0.092753,0.57236],[-0.080514,0.089859,-0.99269],[-0.16706,0.31013,-0.9359],[-0.062388,-0.19215,-0.97938],[-0.043648,-0.36036,-0.93179],[-0.89448,-0.29984,-0.33166],[-0.70311,0.17848,-0.68832],[-0.95718,-0.20666,-0.20275],[-0.68393,-0.72952,0.0064716],[-0.70143,-0.70939,-0.069044],[-0.6216,-0.7459,-0.23927],[-0.73825,-0.66721,0.099088],[-0.53852,-0.7739,-0.33327],[-0.80864,-0.55126,0.20545],[-0.78993,-0.57325,0.2177],[-0.61021,-0.74669,-0.26478],[-0.32411,-0.88699,-0.32893],[-0.8382,-0.40471,0.36556],[-0.74625,0.17506,-0.64223],[-0.75885,0.38473,-0.52548],[0.2168,0.73275,-0.64504],[0.28654,0.82511,-0.48692],[0.10796,0.69603,-0.70985],[0.28513,0.90743,-0.30867],[0.004641,0.63859,-0.76953],[-0.0080155,0.48197,-0.87615],[0.61909,-0.68373,0.38632],[0.84939,-0.32172,0.41836],[0.31239,-0.86069,0.40202],[0.020135,-0.96037,0.27799],[-0.27531,-0.81457,0.51057],[-0.88428,-0.24906,0.39499],[0.23077,0.9621,-0.14529],[0.3055,0.94492,-0.11747],[0.61651,0.78321,-0.080664],[0.31044,0.9266,-0.21222],[0.85721,0.51215,-0.053775],[0.90574,0.42097,0.049253],[0.84582,0.4548,0.27884],[0.49651,0.42393,0.75747],[0.61798,0.39101,0.68206],[0.52243,0.46867,0.71233],[0.78049,0.27415,0.56186],[0.64487,0.40368,0.64899],[0.83607,0.31804,0.44704],[-0.79132,-0.36164,-0.49298],[-0.38948,-0.45076,-0.80319],[-0.016479,-0.43338,-0.90106],[-0.86095,0.040673,-0.50706],[-0.94076,-0.092675,-0.32618],[-0.90478,-0.19801,-0.37706],[-0.24045,0.0093669,-0.97062],[-0.3703,-0.087187,-0.92481],[-0.55715,-0.10684,-0.82351],[-0.93343,0.02744,-0.3577],[-0.79737,-0.52942,0.28967],[-0.42662,-0.81111,-0.40013],[-0.17012,0.18382,-0.96813],[-0.1859,0.27683,-0.94277],[-0.29796,0.3575,-0.88511],[-0.57924,0.41274,-0.70294],[-0.79669,0.40834,-0.44559],[-0.1229,0.37239,-0.9199],[-0.02659,0.35795,-0.93336],[-0.65753,0.1951,0.72773],[-0.031594,-0.8952,0.44454],[-0.7389,-0.27804,0.61377],[-0.68604,0.20775,0.69727],[-0.75485,0.075095,0.65158],[-0.80648,-0.058763,0.58834],[-0.85367,-0.19969,0.48102],[0.89241,0.39362,0.22061],[0.91049,0.31002,0.27365],[0.82188,0.06935,0.56543],[-0.030095,-0.059804,-0.99776],[0.022267,-0.25247,-0.96735],[-0.015554,-0.35552,-0.93454],[-0.7359,-0.3293,-0.59161],[-0.80171,-0.10264,-0.58884],[-0.85621,-0.35867,-0.37184],[-0.76963,-0.63785,-0.028536],[-0.71678,-0.68494,-0.13069],[-0.69535,-0.67958,-0.23381],[-0.616,-0.71392,-0.33296],[-0.83745,-0.53751,0.098768],[-0.54861,-0.68225,-0.48329],[-0.80752,-0.57199,0.14401],[-0.83126,-0.51038,0.22027],[-0.48329,-0.72978,-0.48358],[-0.27724,-0.77302,-0.57059],[-0.8857,-0.37019,0.28017],[-0.83527,0.27837,-0.47417],[0.24307,0.62255,-0.74387],[0.30904,0.74192,-0.59502],[0.3233,0.87607,-0.35773],[0.13469,0.57184,-0.80923],[-0.020751,0.52059,-0.85355],[-0.096186,0.42953,-0.89792],[0.66636,-0.32707,0.67007],[0.31636,-0.66747,0.67409],[-0.1259,-0.77177,0.62332],[-0.1985,-0.95779,0.20793],[-0.16002,-0.87937,0.44845],[-0.4148,-0.88146,0.22576],[-0.88684,-0.3459,0.30639],[0.26154,0.93555,-0.23736],[0.1914,0.94919,-0.24982],[0.59231,0.76941,-0.23911],[0.84011,0.51045,-0.18345],[0.94059,0.32832,-0.086576],[0.94991,0.29757,0.095496],[0.91505,0.28536,0.28507],[0.59589,0.38131,0.70676],[0.67837,0.3613,0.63975],[0.74777,0.39398,0.53444],[0.65695,0.18782,0.73017],[0.72251,0.37148,0.58308],[0.7631,0.15127,0.62833],[0.91251,0.18563,0.36451],[-0.29958,-0.39585,-0.86807],[-0.023579,-0.39818,-0.91701],[-0.10688,-0.40608,-0.90757],[-0.91745,0.078397,-0.39006],[-0.87192,-0.11141,-0.4768],[-0.62498,-0.27742,-0.72968],[-0.17891,-0.20674,-0.9619],[-0.40324,-0.25868,-0.87777],[-0.62212,-0.24758,-0.74275],[-0.58205,-0.70525,-0.40478],[-0.40898,-0.6949,-0.59149],[-0.14937,0.20085,-0.96817],[-0.1631,0.21557,-0.96277],[-0.21,0.20309,-0.95638],[-0.77764,0.27148,-0.56708],[-0.10465,0.2373,-0.96578],[-0.047221,0.28702,-0.95676],[-0.70733,0.23446,0.66686],[-0.2789,-0.68851,0.66946],[-0.54094,-0.83334,0.11369],[-0.74816,0.21561,0.62751],[-0.82207,0.1066,0.55931],[-0.87174,-0.017563,0.48966],[-0.92224,-0.21972,0.31813],[0.9438,0.2537,0.21184],[0.95585,0.13247,0.26232],[0.62148,0.24642,0.74366],[0.64336,0.30431,0.70248],[-0.19721,-0.29155,-0.93601],[-0.27335,-0.34864,-0.89651],[-0.22387,-0.33605,-0.91485],[-0.68991,-0.40385,-0.60077],[-0.83235,-0.5542,-0.0070373],[-0.75969,-0.63378,-0.14559],[-0.70174,-0.66426,-0.25753],[-0.674,-0.66769,-0.31609],[-0.83501,-0.54606,0.067636],[-0.50663,-0.71674,-0.47918],[-0.47716,-0.68995,-0.54432],[-0.87527,-0.46744,0.12411],[-0.91098,-0.35247,0.2142],[-0.38734,-0.64485,-0.65889],[-0.35888,-0.73022,-0.58136],[-0.4651,0.050403,-0.88382],[0.12864,0.71985,-0.68211],[0.11678,0.57917,-0.8068],[0.14764,0.88375,-0.44405],[0.029901,0.44701,-0.89403],[-0.035205,0.44146,-0.89659],[-0.063129,0.38912,-0.91902],[0.48736,0.011717,0.87312],[-0.78637,0.088157,0.61143],[0.15641,-0.29697,0.94199],[-0.11203,-0.49834,0.85971],[-0.38658,-0.53562,0.75078],[-0.29213,-0.92394,0.24698],[-0.32428,-0.94528,0.035826],[-0.22934,-0.73273,0.64071],[-0.7545,-0.5494,0.35901],[-0.92175,-0.34754,0.17199],[0.55729,0.7369,-0.38264],[0.1675,0.89738,-0.40824],[0.83442,0.45184,-0.31557],[0.95087,0.23186,-0.20516],[0.99752,0.069701,-0.0099492],[0.95571,0.020243,0.29361],[0.95968,0.1382,0.24479],[0.72557,0.021265,0.68782],[0.8082,0.16878,0.56421],[0.81106,0.22302,0.54079],[0.7276,0.33131,0.60069],[0.78552,-0.028134,0.6182],[0.71497,-0.092234,0.69304],[0.56353,0.37536,0.7359],[0.86892,0.078185,0.48873],[0.93989,0.11718,0.32076],[-0.075301,-0.32189,-0.94378],[-0.18449,-0.33931,-0.92241],[-0.28756,-0.39835,-0.87099],[-0.75212,-0.075918,-0.65464],[-0.46547,-0.26811,-0.84348],[-0.1542,-0.32674,-0.93245],[-0.44681,-0.29401,-0.84493],[-0.55594,-0.40606,-0.72529],[-0.59922,-0.72066,-0.3487],[-0.22735,-0.77255,-0.59286],[-0.12776,0.17556,-0.97614],[-0.11749,0.20874,-0.97089],[-0.20768,-0.032232,-0.97767],[-0.02689,0.19096,-0.98123],[-0.018372,0.29038,-0.95674],[-0.76963,0.28614,0.57078],[-0.24939,-0.54302,0.80183],[-0.55951,-0.82844,0.025352],[-0.40518,-0.90765,-0.10957],[-0.82571,0.25697,0.50217],[-0.89568,0.15545,0.41664],[-0.9597,0.034819,0.27887],[-0.98377,-0.13894,0.11356],[0.93054,0.064664,0.36043],[0.9486,0.19932,0.24582],[0.26325,0.24006,0.93438],[-0.39932,-0.41422,-0.8179],[-0.062674,-0.31917,-0.94562],[-0.89624,-0.431,-0.10486],[-0.86072,-0.47294,-0.18837],[-0.76078,-0.58604,-0.27889],[-0.69607,-0.66494,-0.27082],[-0.92877,-0.36985,-0.024575],[-0.4626,-0.70705,-0.53487],[-0.55329,-0.65069,-0.52007],[-0.43096,-0.70814,-0.55929],[-0.93806,-0.33696,0.080642],[-0.29935,-0.64493,-0.70317],[-0.31684,-0.73086,-0.60453],[-0.32277,-0.24394,-0.9145],[-0.023034,0.68512,-0.72807],[-0.0085128,0.82824,-0.56031],[-0.036618,0.50868,-0.86018],[-0.0037152,0.43583,-0.90002],[0.001165,0.38483,-0.92299],[-0.10412,0.33879,-0.93508],[-0.072135,-0.029867,0.99695],[-0.87746,-0.025904,0.47895],[-0.27956,-0.2453,0.92826],[-0.3513,-0.31308,0.88236],[-0.42964,-0.90067,0.064756],[-0.46357,-0.79283,0.39563],[-0.39275,-0.55415,0.73394],[-0.75722,-0.59277,0.27429],[-0.9567,-0.28749,0.045443],[0.74599,0.394,-0.5369],[0.45695,0.60484,-0.6522],[0.85639,0.26236,-0.44471],[0.91893,-0.15627,-0.36213],[0.89067,-0.40615,0.20434],[0.7642,-0.2319,0.60185],[0.93951,0.21458,0.267],[0.66296,-0.031426,0.74799],[0.78542,0.079845,0.61379],[0.80049,0.16095,0.57733],[0.7067,0.21999,0.67244],[0.53612,0.30232,0.78815],[0.79005,0.12501,0.60016],[0.71657,0.066965,0.69429],[0.27087,0.2614,0.92644],[0.8936,0.16815,0.41618],[0.92933,0.24023,0.28043],[-0.11494,-0.38038,-0.91766],[-0.11139,-0.45844,-0.88172],[-0.13865,-0.55812,-0.8181],[-0.10114,-0.31496,-0.9437],[0.0195,-0.33836,-0.94081],[-0.70346,-0.57429,-0.41873],[-0.14537,-0.76128,-0.63192],[-0.082616,0.16741,-0.98242],[-0.17421,0.032331,-0.98418],[-0.15499,-0.16981,-0.97321],[0.014572,0.12283,-0.99232],[-0.099418,0.27421,-0.95652],[-0.84754,0.30693,0.43298],[-0.35612,-0.2928,0.88738],[-0.61882,-0.77882,0.10245],[-0.57026,-0.80628,-0.1572],[-0.64641,-0.7594,-0.073953],[-0.89261,0.30211,0.33463],[-0.94992,0.16846,0.26319],[-0.99488,0.043376,0.091228],[-0.99958,-0.027691,-0.0081678],[0.060109,0.7391,-0.67091],[0.80931,0.14492,0.56922],[0.79037,0.58494,0.18212],[-0.049268,0.019868,0.99859],[0.75862,0.62172,0.1948],[-0.15354,-0.67772,-0.71911],[0.043365,-0.41679,-0.90797],[-0.9166,-0.38366,-0.11251],[-0.89231,-0.40503,-0.19932],[-0.86268,-0.42469,-0.27464],[-0.80494,-0.4989,-0.3212],[-0.93546,-0.35276,-0.021891],[-0.46741,-0.60086,-0.64845],[-0.57738,-0.51848,-0.63072],[-0.66956,-0.40673,-0.6215],[-0.37054,-0.62287,-0.68901],[-0.2354,-0.63678,-0.73423],[-0.16381,0.6382,-0.75224],[-0.14711,0.75166,-0.64294],[-0.1009,0.50341,-0.85814],[-0.091858,0.43935,-0.89361],[-0.13308,0.2856,-0.94906],[-0.20151,0.30607,-0.93044],[-0.27764,-0.15325,0.94838],[-0.91337,-0.19377,0.35805],[-0.39974,-0.18611,0.89754],[-0.69342,-0.69918,0.17413],[-0.6794,-0.53894,0.49796],[-0.61968,-0.23614,0.74849],[-0.67038,-0.70756,0.22348],[-0.98682,-0.13282,-0.09245],[0.53969,0.32201,-0.77785],[0.66192,0.31375,-0.68075],[0.34795,0.37794,-0.85796],[0.71139,0.091463,-0.69682],[0.60884,-0.76412,-0.21317],[0.6594,-0.65619,0.36688],[0.60274,0.039387,0.79696],[0.74884,0.54141,0.38225],[0.52315,0.32347,0.78847],[0.58613,0.23705,0.77477],[0.65466,0.31557,0.6869],[0.54676,0.35818,0.75681],[0.40108,0.37842,0.83423],[0.19245,0.36054,0.91267],[0.54434,0.44481,0.71122],[0.59164,0.57095,0.56919],[-0.071221,0.19451,0.97831],[0.67787,0.67257,0.29688],[0.067901,-0.48161,-0.87375],[0.050833,-0.55141,-0.83269],[-0.032104,-0.66462,-0.7465],[-0.014709,-0.18093,-0.98339],[0.053023,-0.27564,-0.9598],[-0.7616,-0.35401,-0.54281],[-0.071291,0.027082,-0.99709],[-0.10089,-0.045059,-0.99388],[-0.045575,0.043061,-0.99803],[-0.23122,0.22424,-0.94671],[-0.90487,0.20708,0.37191],[-0.5728,-0.017363,0.81951],[-0.77253,-0.6343,0.029441],[-0.66251,-0.71224,0.23194],[-0.86052,-0.48649,-0.1511],[-0.91543,-0.40157,-0.02687],[-0.97444,0.19251,0.11576],[-0.99588,0.071884,-0.055188],[-0.98679,0.032289,-0.15873],[0.051277,0.57183,-0.81877],[0.48422,-0.53905,-0.68917],[0.63061,-0.24836,0.73529],[0.56189,0.39328,0.72775],[0.39914,0.89778,0.18622],[0.41382,0.90414,0.10625],[-0.31077,-0.08897,0.94631],[0.3121,0.93628,0.16116],[0.03384,-0.38778,-0.92113],[-0.95922,-0.22921,-0.16543],[-0.91676,-0.32074,-0.23806],[-0.86731,-0.38193,-0.31922],[-0.8294,-0.3664,-0.42172],[-0.53091,-0.42456,-0.7334],[-0.40106,-0.46229,-0.79085],[-0.64892,-0.39193,-0.65214],[-0.71984,-0.34975,-0.59958],[-0.27334,-0.48008,-0.83355],[-0.1074,-0.51146,-0.85257],[-0.23022,0.61612,-0.75326],[-0.18492,0.67226,-0.71685],[-0.21895,0.49586,-0.84035],[-0.22769,0.37034,-0.90056],[-0.20442,0.248,-0.94695],[-0.27183,0.24095,-0.93169],[-0.84169,-0.43114,0.32507],[-0.61553,-0.004884,0.7881],[-0.87305,-0.40719,0.26827],[-0.85967,-0.19135,0.47366],[-0.76169,0.092727,0.64127],[-0.63624,-0.74854,0.18679],[-0.95517,0.26126,0.13927],[-0.96273,0.0056131,-0.27041],[0.42527,0.227,-0.87614],[0.53019,0.24636,-0.81129],[0.55509,0.27155,-0.78621],[0.31166,0.23563,-0.92051],[0.3249,-0.12399,-0.93758],[0.19663,-0.81771,-0.54101],[0.4459,-0.89059,-0.089593],[0.611,-0.66308,0.43243],[0.51702,0.05341,0.85431],[0.46235,0.26083,0.84747],[0.27478,0.85427,0.44126],[0.24091,0.73022,0.63933],[0.28127,0.60537,0.74459],[0.36034,0.54888,0.75425],[0.32406,0.51428,0.79404],[0.19933,0.51596,0.8331],[0.0086959,0.50552,0.86277],[-0.24994,0.41951,0.87267],[0.21122,0.83917,0.50118],[0.23107,0.9307,0.28355],[-0.49384,0.22223,0.84067],[-0.019147,-0.44282,-0.89641],[0.0010083,-0.06085,-0.99815],[-0.061077,-0.16401,-0.98457],[-0.78134,-0.26995,-0.56271],[-0.011034,-0.0081374,-0.99991],[-0.14285,0.061147,-0.98785],[-0.35853,0.15533,-0.92051],[-0.97635,-0.089024,0.19704],[-0.75175,0.15789,0.64027],[-0.95864,-0.27414,0.076544],[-0.86594,-0.43452,0.24767],[-0.84086,-0.5194,0.15222],[-0.9901,-0.093999,-0.10422],[-0.97255,-0.12585,0.19575],[-0.96727,0.24659,-0.05979],[-0.97831,0.12751,-0.16323],[-0.96477,0.041977,-0.25972],[0.11143,0.4096,-0.90543],[0.022723,-0.52791,-0.849],[0.54671,-0.28043,0.78896],[0.095756,0.61834,0.78005],[0.078812,0.98195,0.17195],[0.17255,0.98453,0.030565],[0.14338,0.98613,0.083657],[0.12041,0.97782,0.1714],[-0.12714,-0.26104,-0.95692],[-0.94739,-0.029351,-0.31872],[-0.91351,-0.14879,-0.37863],[-0.82285,-0.25787,-0.50638],[-0.42207,-0.2546,-0.87008],[-0.53031,-0.23549,-0.81444],[-0.2921,-0.30419,-0.90672],[-0.64914,-0.25675,-0.71603],[-0.77072,-0.19205,-0.60754],[-0.18094,-0.35396,-0.91759],[-0.32035,0.57144,-0.75553],[-0.18455,0.5449,-0.81794],[-0.34201,0.44123,-0.82966],[-0.35404,0.34423,-0.86958],[-0.30533,0.2221,-0.92598],[-0.31615,0.12306,-0.9407],[-0.78177,-0.61148,0.12216],[-0.73972,0.20571,0.6407],[-0.93819,0.07337,0.33825],[-0.85022,0.2645,0.45515],[-0.80836,-0.58847,-0.016079],[-0.99939,0.017174,0.030468],[-0.98807,0.10366,-0.11385],[-0.94909,-0.0052943,-0.31496],[0.3154,0.1528,-0.93658],[0.40965,0.16989,-0.89628],[0.53772,0.26535,-0.80028],[0.54996,0.30862,-0.77608],[0.2229,0.16043,-0.96155],[-0.14816,-0.17539,-0.97329],[0.14772,-0.81296,-0.56328],[-0.12428,-0.55046,-0.82556],[0.46081,-0.8833,-0.086221],[0.59499,-0.66716,0.44821],[0.49555,0.24722,0.83265],[0.38015,0.17106,0.90897],[0.18283,0.46434,0.86658],[-0.24733,0.87892,0.40783],[0.031252,0.83081,0.55567],[0.034957,0.90498,0.42401],[0.026689,0.7711,0.63615],[0.037505,0.71339,0.69976],[0.0049645,0.62549,0.78022],[-0.15063,0.59002,0.79321],[-0.3761,0.53558,0.75611],[-0.57327,0.40446,0.71258],[0.055821,0.95582,0.28861],[-0.10155,-0.093228,-0.99045],[-0.21117,-0.097139,-0.97261],[-0.77772,-0.18434,-0.60097],[-0.088748,0.00404,-0.99605],[-0.35332,0.076727,-0.93235],[-0.36147,0.099197,-0.92709],[-0.89281,-0.42971,-0.13502],[-0.84566,0.23289,0.48023],[-0.99466,0.010247,0.10267],[-0.96227,-0.1021,0.25223],[-0.98021,-0.17028,0.10095],[-0.97561,-0.212,-0.056881],[-0.98675,0.15887,-0.033007],[-0.94858,0.2729,-0.1604],[-0.93545,0.20952,-0.28465],[-0.92719,0.14195,-0.34665],[0.22031,0.041742,-0.97454],[0.041624,0.21648,-0.9754],[-0.28146,-0.30742,-0.909],[0.53172,-0.30433,0.79036],[-0.27119,0.71919,0.63971],[-0.10946,0.99389,0.014233],[0.030656,0.99952,0.0036265],[0.068658,0.99764,-0.00066668],[0.059166,0.99616,0.064465],[0.018847,0.98157,0.19019],[-0.22877,-0.147,-0.96232],[-0.9332,-0.01869,-0.35888],[-0.85865,-0.1124,-0.50009],[-0.40265,-0.034653,-0.9147],[-0.3017,-0.077515,-0.95025],[-0.48096,-0.020596,-0.8765],[-0.67726,-0.066973,-0.73269],[-0.73896,-0.080046,-0.66898],[-0.38517,0.48654,-0.78417],[-0.23559,0.39039,-0.89],[-0.44152,0.37121,-0.81686],[-0.43512,0.35012,-0.82951],[-0.3817,0.21083,-0.89992],[-0.31965,0.12085,-0.9398],[-0.80583,-0.56706,-0.17056],[-0.77281,0.32697,0.54393],[-0.95763,0.24699,0.14811],[-0.9214,0.30208,0.24447],[-0.92865,-0.28932,-0.23218],[-0.95482,-0.1205,-0.27166],[-0.90907,0.090374,-0.40673],[0.1709,0.10336,-0.97985],[0.2522,0.12695,-0.95931],[0.35547,0.10004,-0.92932],[0.56513,0.20904,-0.79808],[0.73727,0.32702,-0.59118],[0.059247,0.075709,-0.99537],[-0.12231,0.23902,-0.96328],[-0.45322,-0.021122,-0.89115],[-0.15101,-0.55063,-0.82098],[0.1692,-0.79217,-0.58638],[-0.33136,-0.35151,-0.87558],[0.44811,-0.88767,-0.10604],[0.55712,-0.68593,0.4681],[0.47298,0.27942,0.83559],[0.31971,0.29107,0.9017],[0.32893,0.40226,0.85439],[-0.22955,0.69195,0.68448],[-0.61706,0.7724,0.15044],[-0.3629,0.92691,-0.095627],[-0.064008,0.91042,0.40871],[-0.11122,0.84255,0.52701],[-0.021446,0.9543,0.29808],[-0.16623,0.79562,0.58254],[-0.24133,0.72453,0.64562],[-0.28663,0.64555,0.70789],[-0.44363,0.5932,0.6718],[-0.60001,0.49382,0.62939],[-0.30094,-0.019132,-0.95345],[-0.2754,0.01808,-0.96116],[-0.77557,-0.039805,-0.63],[-0.32872,0.087332,-0.94038],[-0.28979,0.1209,-0.94942],[-0.77191,-0.52959,-0.3517],[-0.90771,0.24535,0.3404],[-0.97375,0.20099,0.10682],[-0.96129,0.14948,0.23146],[-0.98821,0.10382,0.11255],[-0.99656,0.03917,-0.073062],[-0.9773,-0.015577,-0.21128],[-0.95833,0.28142,0.049115],[-0.93357,0.21889,-0.28379],[-0.90554,0.23621,-0.35242],[-0.88064,0.19441,-0.43206],[0.85967,0.028892,-0.51003],[-0.074092,0.059549,-0.99547],[-0.51031,-0.088991,-0.85537],[0.45605,-0.21137,0.86449],[-0.60069,0.77726,0.18719],[-0.046454,0.99444,-0.094488],[0.030898,0.99765,-0.061218],[0.018646,0.99976,-0.011644],[-0.028995,0.9969,0.073154],[-0.08105,0.97727,0.19587],[-0.8611,0.071308,-0.50342],[-0.29233,0.069066,-0.95382],[-0.36507,0.090433,-0.92658],[-0.61815,0.031153,-0.78544],[-0.71299,0.071769,-0.69749],[-0.25044,0.27983,-0.92681],[-0.40918,0.37635,-0.83122],[-0.43007,0.36188,-0.82709],[-0.44152,0.3285,-0.83495],[-0.4156,0.20244,-0.88673],[-0.36308,0.14884,-0.91979],[-0.86204,-0.3512,-0.36545],[-0.7751,0.38965,0.49738],[-0.96742,0.23245,0.10028],[-0.93041,-0.070254,-0.35972],[-0.90051,-0.23081,-0.36852],[-0.8216,0.17296,-0.54319],[-0.008735,0.049656,-0.99873],[0.073551,0.1018,-0.99208],[0.18455,0.036045,-0.98216],[0.42097,-0.13734,-0.89662],[0.98576,0.14997,-0.076091],[0.14944,0.6996,-0.69873],[-0.083476,-0.0013283,-0.99651],[-0.52122,0.30111,-0.79854],[-0.6463,0.19022,-0.73899],[-0.33117,-0.35424,-0.87455],[-0.12239,-0.5604,-0.81913],[0.15855,-0.78767,-0.59534],[-0.52244,-0.087914,-0.84813],[0.40519,-0.9046,-0.13239],[0.48845,-0.74545,0.45357],[0.4404,0.1607,0.8833],[0.53091,0.27085,0.80298],[-0.19104,0.66651,0.72061],[0.25178,0.61468,0.74751],[-0.58927,0.78317,0.19851],[-0.59766,0.67173,-0.43771],[-0.73852,0.53144,-0.41492],[0.056585,0.9846,-0.16539],[-0.13029,0.94667,0.29468],[-0.20165,0.88895,0.41123],[-0.2982,0.80446,0.51374],[-0.39137,0.72493,0.56684],[-0.45275,0.65178,0.60843],[-0.58595,0.55646,0.58908],[-0.76928,0.16647,-0.61684],[-0.43402,0.11409,-0.89365],[-0.78151,-0.38365,-0.492],[-0.94771,0.21542,0.23548],[-0.93381,0.31153,0.17591],[-0.95914,0.27267,0.075574],[-0.9402,0.31281,0.13477],[-0.96905,0.24569,-0.024023],[-0.97585,0.15026,-0.15853],[-0.94948,0.066403,-0.30674],[-0.72439,-0.49565,-0.47916],[-0.91194,0.14713,-0.38303],[-0.86509,0.25746,-0.43051],[-0.80294,0.21704,-0.55514],[0.60428,-0.63364,-0.48306],[0.94241,-0.27263,-0.19376],[0.83223,0.54451,-0.10444],[-0.15842,-0.015491,-0.98725],[-0.65689,0.1859,-0.73071],[0.42401,-0.093632,0.9008],[-0.74839,0.53265,-0.39521],[0.028258,0.95076,-0.30862],[0.02798,0.9944,-0.10193],[0.0014921,0.99831,-0.05812],[-0.057494,0.99832,0.0075633],[-0.11867,0.98882,0.090285],[-0.17111,0.96319,0.20735],[-0.58095,0.16792,-0.79643],[-0.69441,0.21732,-0.68598],[-0.32309,0.14236,-0.9356],[-0.43354,0.36627,-0.82334],[-0.43924,0.3519,-0.82658],[-0.44769,0.29193,-0.84519],[-0.4281,0.21959,-0.87665],[-0.88025,-0.11981,-0.45914],[-0.76248,0.45991,0.45509],[-0.98866,0.14759,0.02765],[-0.88941,0.02739,-0.45628],[-0.80106,-0.22725,-0.55378],[-0.74148,0.2019,-0.63987],[-0.14199,0.096629,-0.98514],[-0.18717,0.020541,-0.98211],[-0.097298,0.061307,-0.99337],[0.073401,-0.42857,-0.90052],[0.99589,0.075239,0.05049],[0.88062,0.44041,0.17479],[0.49131,0.86844,-0.066502],[-0.22735,-0.035413,-0.97317],[-0.50322,-0.068168,-0.86147],[-0.31198,-0.34075,-0.88688],[-0.10913,-0.5697,-0.81457],[0.13324,-0.78587,-0.60386],[-0.64894,0.19745,-0.73477],[0.34785,-0.91786,-0.19113],[0.47993,-0.79566,0.36959],[0.56373,0.096933,0.82025],[-0.12099,0.66307,0.73871],[0.63553,0.16922,0.75331],[-0.57992,0.78992,0.1993],[0.18113,0.74945,0.6368],[-0.73979,0.54767,-0.39086],[0.2568,0.96608,-0.027121],[0.039188,0.99893,-0.024538],[-0.2502,0.91301,0.32221],[-0.35206,0.82874,0.43503],[-0.4957,0.7028,0.51025],[-0.55233,0.62861,0.54753],[-0.48116,0.28913,-0.82758],[-0.80549,-0.22926,-0.54647],[-0.62639,-0.40825,-0.66405],[-0.95755,0.23073,0.17282],[-0.96027,0.26918,0.073602],[-0.91509,0.38181,0.12973],[-0.92306,0.38347,0.030221],[-0.93834,0.33174,-0.097308],[-0.94982,0.22641,-0.21582],[-0.89745,0.092646,-0.43128],[-0.82354,0.1799,-0.53798],[-0.75801,0.29857,-0.5799],[-0.69691,0.28743,-0.65704],[0.15603,-0.91341,-0.37594],[0.66904,-0.70301,-0.24117],[0.95655,-0.27251,-0.10364],[0.65274,0.7271,0.21275],[-0.3255,-0.10939,-0.93919],[0.56149,0.022516,0.82718],[0.27598,0.69233,0.66672],[-0.039605,0.99371,-0.10476],[-0.098178,0.99374,-0.05331],[-0.15961,0.98702,0.017851],[-0.2143,0.97157,0.10062],[-0.29049,0.92754,0.23512],[-0.55942,0.27028,-0.78358],[-0.65277,0.26485,-0.70975],[-0.50259,-0.0016606,-0.86452],[-0.51015,0.38142,-0.77089],[-0.52486,0.32169,-0.78806],[-0.8912,0.015231,-0.45336],[-0.7284,0.53557,0.42731],[-0.99624,-0.0017523,0.086598],[-0.87085,0.091835,-0.4829],[-0.67805,-0.1599,-0.71741],[-0.34447,0.10246,-0.93319],[-0.30028,0.12683,-0.94538],[-0.3522,0.029028,-0.93548],[-0.29821,-0.1111,-0.94801],[-0.37188,-0.72841,-0.57543],[0.99792,0.0054647,0.064201],[0.89957,0.3592,0.24848],[0.7092,0.61299,0.34825],[0.43033,0.87769,0.21088],[-0.39949,-0.10867,-0.91027],[-0.48806,-0.063033,-0.87053],[-0.62683,0.20726,-0.75109],[-0.30806,-0.33769,-0.88941],[-0.095326,-0.56688,-0.81826],[0.11895,-0.76414,-0.63398],[-0.72077,0.56295,-0.40446],[0.30079,-0.90687,-0.29514],[0.52767,-0.81,0.25586],[0.64528,0.037938,0.763],[-0.045035,0.66363,0.7467],[-0.55193,0.81451,0.17876],[0.47856,0.4212,0.77043],[0.22975,0.75114,0.61888],[0.26454,0.69123,0.67247],[-0.054441,0.98404,0.16941],[-0.15485,0.98746,-0.030654],[-0.38902,0.84789,0.3602],[-0.49402,0.74251,0.45235],[-0.58371,0.28808,-0.75914],[-0.78469,-0.061634,-0.61682],[-0.57614,-0.28517,-0.76599],[-0.92423,0.2741,0.26585],[-0.99102,-0.0040711,0.13368],[-0.97847,0.18578,0.089865],[-0.96009,0.26876,-0.077476],[-0.91506,0.36332,-0.1751],[-0.90269,0.31543,-0.29267],[-0.86341,0.21544,-0.4562],[-0.52547,-0.33734,-0.78108],[-0.73279,0.23379,-0.63903],[-0.63783,0.31827,-0.70134],[-0.60604,0.3546,-0.71202],[-0.39365,-0.88686,-0.24189],[0.2078,-0.9404,-0.2692],[0.71632,-0.66607,-0.20794],[0.94892,-0.30605,-0.076743],[0.53441,0.7509,0.38802],[-0.49101,-0.22537,-0.8415],[0.63885,0.18986,0.74554],[0.73339,-0.13263,0.66675],[-0.17808,0.97524,-0.1311],[-0.23295,0.9692,-0.079881],[-0.26989,0.96289,0.0013997],[-0.34356,0.93041,0.12771],[-0.68967,0.58018,0.4333],[-0.46793,0.83947,0.27628],[-0.62245,-0.015884,-0.7825],[-0.89122,0.1066,-0.44087],[-0.95118,0.094772,0.29373],[-0.82584,0.19178,-0.53028],[-0.47489,0.134,-0.86978],[-0.44738,0.13668,-0.88384],[-0.44351,0.077926,-0.89288],[-0.44226,-0.0095813,-0.89683],[-0.61681,-0.26401,-0.74152],[-0.75448,-0.56685,-0.33082],[0.91768,0.31398,0.24347],[0.99744,-0.052158,0.048821],[0.71534,0.5933,0.36918],[0.53466,0.73612,0.41506],[-0.032249,0.91357,0.4054],[-0.47508,-0.20785,-0.85504],[-0.60348,0.21998,-0.76644],[-0.46551,-0.047097,-0.88379],[-0.68781,0.58104,-0.4351],[-0.2716,-0.31568,-0.90916],[-0.063763,-0.53758,-0.8408],[0.10165,-0.72513,-0.68107],[0.27042,-0.88765,-0.37275],[0.71816,-0.5443,0.43358],[0.68625,-0.021392,0.72705],[0.014404,0.66125,0.75003],[-0.52305,0.84082,0.13944],[0.5252,0.30041,0.79619],[0.38271,0.64532,0.66113],[0.28022,0.67235,0.68514],[-0.37317,0.92748,0.022996],[-0.31829,0.9321,-0.17284],[-0.59952,0.70165,0.38504],[-0.54079,-0.066039,-0.83856],[-0.71757,0.16413,-0.67687],[-0.83821,0.41817,0.35005],[-0.9694,-0.13866,0.20257],[-0.97686,-0.19872,0.079124],[-0.99721,-0.073342,-0.014015],[-0.92942,0.22271,-0.29425],[-0.89577,0.35662,-0.26538],[-0.77062,0.24439,-0.58857],[-0.86974,-0.47584,-0.1309],[-0.42879,-0.87198,-0.2362],[0.20744,-0.94463,-0.25426],[0.73054,-0.65956,-0.17687],[0.94448,-0.32024,-0.07351],[-0.021147,0.88403,0.46695],[0.70023,-0.075478,0.70992],[-0.64407,0.75169,0.14193],[-0.33019,0.92449,-0.19051],[-0.35573,0.92254,-0.1496],[-0.38062,0.92422,0.030574],[-0.55883,0.80547,0.1973],[-0.72712,0.61387,0.30734],[-0.91585,0.27394,0.29354],[-0.958,-0.029582,-0.28524],[-0.86201,0.35131,-0.3654],[-0.67949,0.27345,-0.68082],[-0.57074,0.21557,-0.79233],[-0.62514,0.16843,-0.76212],[-0.53127,0.16885,-0.83021],[-0.65641,0.1217,-0.74452],[-0.89279,-0.22693,-0.38914],[-0.93991,-0.26297,-0.21777],[0.93381,0.30287,0.19046],[0.71865,0.60001,0.35148],[0.99822,-0.058666,0.010695],[0.51888,0.74791,0.414],[-0.0094183,0.8843,0.46682],[-0.68559,0.64809,0.33159],[-0.56296,0.24664,-0.78882],[-0.64568,0.59515,-0.47843],[-0.42892,-0.021315,-0.90309],[-0.24148,-0.29756,-0.92366],[-0.067201,-0.51672,-0.85351],[0.033838,-0.69751,-0.71577],[0.23024,-0.86614,-0.4436],[0.41258,0.53779,0.73523],[0.69915,-0.096873,0.70838],[0.06337,0.66134,0.74741],[-0.51539,0.85307,0.081527],[0.5263,0.2808,0.80259],[0.31266,0.63257,0.70859],[-0.62357,0.7312,-0.27659],[-0.50946,0.77827,-0.36708],[-0.98987,0.070079,0.1235],[-0.99033,-0.10956,-0.085066],[-0.88076,-0.062221,-0.46945],[-0.89986,0.26026,-0.35003],[-0.74799,0.35879,-0.55837],[-0.67102,0.24584,-0.6995],[-0.78572,-0.0089634,-0.61852],[-0.92055,-0.38059,-0.088003],[-0.96581,-0.21559,-0.14398],[-0.45271,-0.86228,-0.22699],[0.20848,-0.94779,-0.2413],[0.73879,-0.64815,-0.18465],[0.94252,-0.318,-0.1026],[-0.68496,0.6289,0.36785],[0.80544,-0.44725,0.38888],[0.68774,-0.045338,0.72454],[-0.95907,0.28313,0.0037658],[-0.83041,0.48434,-0.27538],[-0.56987,0.73277,-0.37188],[-0.5157,0.84644,-0.13263],[-0.69736,0.71382,0.064409],[-0.84668,0.48172,0.22601],[-0.95173,-0.054606,-0.30203],[-0.84381,0.29816,-0.4462],[-0.72987,0.255,-0.63424],[-0.79133,0.13196,-0.59698],[-0.98584,-0.079385,-0.14772],[-0.93344,0.10548,-0.34286],[-0.96379,-0.23849,-0.11932],[0.94074,0.3129,0.13076],[0.72984,0.61834,0.29151],[0.50194,0.77395,0.38608],[0.9985,-0.050515,-0.021023],[-0.0046701,0.89783,0.44031],[-0.67726,0.64035,0.36231],[-0.98212,0.14636,0.11845],[-0.54855,0.24689,-0.79884],[-0.62258,0.58533,-0.51941],[-0.41631,-0.024908,-0.90888],[-0.24292,-0.30543,-0.92071],[-0.11708,-0.51481,-0.84927],[-0.036574,-0.68277,-0.72972],[0.16545,-0.84127,-0.51467],[0.34298,0.56152,0.75304],[0.49694,0.5132,0.69977],[0.71686,-0.12993,0.685],[0.1009,0.66184,0.74282],[-0.527,0.84975,0.014047],[0.52378,0.26254,0.81039],[-0.69309,0.51752,-0.5018],[-0.76229,0.3869,-0.51886],[-0.62745,0.67307,-0.39152],[-0.97262,0.23208,-0.01192],[-0.83689,0.011409,-0.54725],[-0.8394,0.081666,-0.53735],[-0.81255,0.22413,-0.53808],[-0.80009,0.22777,-0.55496],[-0.98234,-0.13707,-0.12736],[-0.95298,-0.27994,-0.11603],[-0.92086,-0.3511,-0.16953],[-0.46022,-0.86928,-0.18039],[0.25845,-0.94012,-0.22221],[0.75544,-0.61908,-0.2146],[0.93567,-0.31973,-0.14931],[-0.98722,0.095527,0.12759],[0.8265,-0.53927,0.16149],[0.67621,-0.020867,0.73641],[-0.76297,0.26254,-0.59072],[-0.84802,0.48557,-0.21234],[-0.84347,0.089288,-0.5297],[-0.81108,0.15976,-0.5627],[0.94347,0.31747,0.095324],[0.74249,0.6249,0.24127],[0.50194,0.79451,0.34179],[0.011592,0.91173,0.41063],[0.99702,-0.045365,-0.06242],[-0.67311,0.66466,0.32428],[-0.99497,0.066998,0.074429],[-0.61837,0.56023,-0.55114],[-0.53823,0.23676,-0.80886],[-0.42025,-0.035861,-0.9067],[-0.27983,-0.31908,-0.90547],[-0.20054,-0.51843,-0.83127],[-0.075321,-0.73559,-0.67322],[0.389,0.49973,0.77392],[0.53247,0.24252,0.81096],[0.58951,0.40353,0.69975],[0.15318,0.66613,0.72993],[0.72684,-0.13623,0.67316],[-0.55147,0.83244,-0.054033],[-0.88042,-0.42659,-0.20708],[-0.96092,-0.19705,-0.19444],[-0.94463,-0.27024,-0.18612],[-0.49869,-0.84613,-0.18809],[0.32748,-0.91105,-0.25049],[0.77805,-0.5791,-0.24348],[0.92956,-0.31934,-0.18421],[0.74423,-0.66559,-0.055783],[0.66444,0.00074816,0.74734],[-0.98668,0.13511,-0.090566],[0.94586,0.31845,0.062797],[0.75592,0.62095,0.20739],[0.51502,0.79902,0.31036],[0.059637,0.91711,0.39416],[-0.61611,0.69644,0.36794],[0.99465,-0.04438,-0.093322],[-0.99374,0.065748,0.090314],[-0.62102,0.52348,-0.58336],[-0.54915,0.21248,-0.80826],[-0.45948,-0.056253,-0.88641],[-0.34899,-0.32886,-0.87753],[-0.3048,-0.51903,-0.79857],[-0.20486,-0.70452,-0.67948],[0.56034,0.22513,0.79708],[0.4663,0.45018,0.76151],[0.7396,0.3392,0.58132],[0.20753,0.6648,0.71762],[-0.57901,0.80578,-0.12439],[0.73319,-0.11581,0.67009],[-0.84525,-0.48511,-0.22411],[-0.9081,-0.34843,-0.23228],[-0.97659,-0.094727,-0.19312],[-0.98931,0.041145,-0.13989],[-0.58376,-0.77254,-0.24979],[0.38306,-0.8865,-0.25958],[0.82484,-0.52878,-0.20005],[0.93996,-0.29922,-0.16414],[0.91338,-0.39657,-0.092057],[0.67979,0.033436,0.73264],[0.94602,0.32065,0.047097],[0.75889,0.62821,0.17157],[0.52571,0.80692,0.26929],[0.10383,0.92596,0.36307],[-0.52675,0.76321,0.37424],[-0.98464,0.099976,0.14312],[0.99639,-0.039303,-0.075196],[-0.64272,0.46946,-0.60541],[-0.58867,0.18029,-0.78801],[-0.52451,-0.079037,-0.84773],[-0.45616,-0.3315,-0.82585],[-0.38296,-0.51185,-0.769],[0.2375,-0.60659,-0.75871],[0.61627,0.22579,0.75447],[0.59647,0.39629,0.69798],[0.91256,0.23476,0.33485],[0.28076,0.70236,0.65411],[-0.6207,0.76381,-0.17701],[0.76885,-0.013349,0.6393],[-0.82148,-0.51109,-0.25291],[-0.88514,-0.39588,-0.24457],[-0.98114,-0.06734,-0.1812],[-0.98568,0.0024915,-0.16859],[-0.67229,-0.65993,-0.33544],[0.40814,-0.86345,-0.29643],[0.87643,-0.45855,-0.14701],[0.95878,-0.26695,-0.097402],[0.72761,0.098842,0.67883],[0.75018,0.63789,0.17413],[0.94328,0.32259,0.078452],[0.52411,0.81956,0.23156],[0.13812,0.93766,0.31894],[-0.47625,0.80752,0.348],[-0.98468,0.13666,0.10829],[0.9998,-0.018368,-0.0083493],[-0.68961,0.38949,-0.61052],[-0.66201,0.13336,-0.73753],[-0.61509,-0.10361,-0.78162],[-0.48948,-0.31808,-0.81194],[-0.35697,-0.43141,-0.82853],[0.87361,-0.077204,-0.48047],[0.69588,0.25214,0.67244],[0.8445,0.31959,0.42975],[0.1179,0.96688,0.22635],[-0.60421,0.75278,-0.26124],[0.80537,0.18799,0.56217],[-0.79817,-0.52426,-0.29677],[-0.8741,-0.39975,-0.27594],[-0.96973,-0.12561,-0.2094],[-0.98312,0.026599,-0.18101],[-0.71974,-0.534,-0.44364],[0.40774,-0.83237,-0.37537],[0.90282,-0.42012,-0.091707],[0.9742,-0.22477,-0.02036],[0.80632,0.31463,0.50087],[0.74251,0.63023,0.22691],[0.51787,0.81625,0.25601],[0.93705,0.32194,0.13529],[0.17896,0.93597,0.30322],[-0.43626,0.83545,0.33422],[-0.98948,0.12159,0.078433],[0.99759,0.018565,0.066829],[-0.67028,0.51652,-0.53285],[-0.65643,0.25551,-0.70979],[-0.56372,-0.0071977,-0.82594],[-0.38085,-0.25734,-0.8881],[0.93326,0.26614,-0.24123],[0.84041,0.39701,0.3689],[-0.077444,0.95818,-0.27549],[-0.75443,-0.56061,-0.34139],[-0.85758,-0.40118,-0.32189],[-0.95377,-0.14876,-0.26114],[-0.97367,0.017734,-0.22727],[-0.75124,-0.43532,-0.49612],[0.39135,-0.78706,-0.47685],[0.916,-0.39696,-0.058053],[0.98273,-0.1796,0.044512],[0.10362,0.81533,-0.56965],[0.74327,0.59992,0.29604],[0.51807,0.78983,0.32828],[0.24688,0.90195,0.35431],[0.92864,0.30875,0.20568],[-0.37418,0.84998,0.37085],[-0.99369,0.10847,0.028498],[0.98983,0.040253,0.13642],[0.069672,0.35578,-0.93197],[-0.70649,-0.57484,-0.41284],[-0.83871,-0.39945,-0.37013],[-0.9332,-0.17881,-0.31171],[-0.96067,-0.0066747,-0.27761],[-0.71742,-0.36978,-0.5904],[0.36332,-0.70205,-0.61247],[0.79375,-0.49379,-0.35516],[0.96534,-0.25211,-0.067451],[0.75564,0.54002,0.37067],[0.53751,0.72831,0.42503],[0.32154,0.84311,0.43103],[-0.29094,0.86076,0.41767],[0.92528,0.27797,0.25806],[-0.9944,0.10234,-0.026264],[0.99356,0.044445,0.10425],[-0.67317,-0.57203,-0.46864],[-0.8195,-0.39338,-0.41674],[-0.90655,-0.19303,-0.37538],[-0.93037,-0.025352,-0.36575],[-0.52849,-0.38518,-0.75653],[-0.032759,-0.49746,-0.86687],[0.69557,-0.33495,-0.6356],[0.51312,0.70957,0.48293],[0.77617,0.48479,0.40315],[0.32435,0.83343,0.44743],[-0.23206,0.87432,0.42628],[-0.98771,0.11177,-0.10924],[0.94979,0.25428,0.18234],[0.58802,0.028531,-0.80834],[-0.64957,-0.56141,-0.51272],[-0.79323,-0.37777,-0.47756],[-0.8723,-0.18926,-0.45085],[-0.85524,-0.074159,-0.5129],[-0.59847,-0.13446,-0.78978],[0.423,0.8252,0.37433],[0.17418,0.89147,0.41827],[0.74814,0.66257,0.035911],[-0.19029,0.91951,0.34393],[-0.97213,0.094688,-0.21448],[0.54693,0.44649,-0.70818],[-0.56546,-0.063417,-0.82234],[-0.62923,-0.55033,-0.54882],[-0.76358,-0.36072,-0.53557],[-0.83269,-0.18333,-0.52252],[-0.22418,0.97274,-0.059381],[0.11943,0.85648,-0.50217],[-0.67006,0.6031,-0.43277],[-0.31733,0.20311,-0.92631],[-0.83346,-0.020366,-0.5522],[-0.72198,-0.25116,-0.64473],[-0.65088,-0.36898,-0.66348],[-0.65842,-0.16406,-0.73455]])
        self.assertTrue(np.isclose(n-n_gt,0.0,atol=1e-5).all())
        

        v,f = gpytoolbox.read_mesh("test/unit_tests_data/armadillo.obj")
        n_gt =np.array([[-0.51015,-0.71336,0.48049],[0.39923,-0.34015,0.85142],[-0.993,-0.01772,-0.11681],[-0.79082,0.24063,-0.56277],[0.34063,-0.34709,0.87379],[0.39251,-0.495,0.77518],[-0.051949,-0.40458,0.91302],[-0.45007,-0.24415,-0.85897],[0.56782,0.056669,0.8212],[-0.98828,0.12499,0.087657],[-0.04964,-0.33943,-0.93932],[0.2898,-0.53237,-0.79536],[0.27392,-0.38494,-0.88136],[-0.89967,0.11543,0.42103],[-0.79752,0.54376,-0.26133],[0.89657,0.4428,-0.0092296],[-0.27455,-0.059564,-0.95973],[0.059706,-0.017236,-0.99807],[-0.36208,0.75189,-0.55097],[0.61382,-0.24494,-0.75049],[0.19912,-0.36145,0.91088],[-0.32075,-0.25122,0.91324],[0.91378,-0.32007,-0.25012],[-0.24433,0.33971,-0.90824],[0.27014,0.59401,-0.75775],[-0.0093834,-0.17274,0.98492],[0.84147,0.20962,-0.49798],[-0.26024,-0.45435,0.85196],[-0.38129,0.058434,0.92261],[-0.32737,0.058717,0.94307],[-0.34031,-0.67619,-0.65341],[0.12107,-0.91834,-0.37682],[-0.0654,-0.64283,-0.76322],[0.57338,-0.73307,-0.36585],[0.1691,-0.25646,0.95165],[-0.16403,0.50415,-0.8479],[-0.22965,-0.41532,0.88021],[0.97957,-0.13544,-0.14869],[0.36844,-0.43522,0.82148],[-0.50517,-0.49847,-0.70451],[-0.60526,-0.12295,-0.78648],[-0.48527,0.1433,-0.86254],[0.54607,-0.36521,0.75394],[-0.80311,-0.54978,-0.2297],[0.84906,0.49699,-0.17915],[0.46479,0.26404,0.84513],[-0.41324,-0.30511,0.85799],[-0.40463,-0.30402,0.86246],[-0.30895,0.63805,-0.70529],[0.0012798,0.82837,-0.56018],[0.9389,0.10925,0.32639],[-0.44749,-0.49238,-0.74654],[0.18316,0.93763,-0.29546],[0.40845,0.86167,-0.30116],[-0.46378,-0.59602,-0.65549],[0.69544,0.080283,0.71408],[-0.18573,-0.91652,-0.35427],[0.27811,-0.9601,0.02943],[0.56083,-0.82579,0.059565],[-0.57315,-0.37317,-0.72955],[0.2894,-0.21627,0.93246],[0.57866,-0.60927,-0.54216],[0.76651,-0.59756,0.23533],[-0.63536,0.12463,-0.7621],[0.86369,0.039115,-0.5025],[0.94848,0.26131,0.17917],[0.72576,0.19792,-0.65886],[0.46769,-0.31538,0.82571],[-0.39056,0.5446,-0.74221],[0.75501,0.64291,0.12895],[-0.4649,0.5378,-0.70331],[0.66191,0.23673,-0.71122],[-0.98179,-0.13629,0.13235],[0.88696,-0.33726,-0.31552],[-0.24192,-0.96189,0.12747],[0.11758,-0.22808,0.96652],[0.056602,-0.11029,0.99229],[0.18576,-0.79823,-0.573],[-0.52584,-0.5697,-0.63161],[-0.46767,-0.63839,-0.61135],[-0.21845,-0.89256,-0.39448],[0.19825,-0.97937,-0.039127],[0.63189,-0.71205,0.3061],[0.19274,0.63077,0.75165],[-0.66352,-0.25583,-0.70306],[-0.42818,-0.23018,0.87389],[0.74484,-0.46554,0.47801],[0.87511,-0.17511,0.45113],[0.57244,0.75051,0.3302],[-0.24726,-0.96335,0.10405],[0.60612,-0.65367,-0.45313],[-0.48248,0.53046,-0.69701],[-0.36267,0.76184,-0.53671],[-0.19009,-0.28285,0.94014],[-0.17921,0.84043,-0.51143],[-0.14436,0.83076,-0.53759],[0.10129,0.95481,-0.27941],[0.35138,0.15011,0.92412],[0.29327,0.95046,-0.10307],[0.5018,0.86492,0.010749],[0.0092388,0.1379,0.9904],[0.62185,-0.09349,0.77753],[-0.1161,-0.96081,-0.25171],[0.60347,-0.64616,-0.46723],[0.11404,-0.98097,-0.15716],[-0.90737,0.25004,0.33787],[-0.37527,-0.80817,-0.45391],[-0.02812,-0.72663,0.68645],[0.54638,-0.79844,0.2529],[0.24787,-0.62338,0.74159],[-0.70478,-0.016188,-0.70924],[0.024206,-0.082989,0.99626],[-0.96785,-0.21143,0.13624],[-0.26682,-0.9466,0.18096],[-0.036357,-0.99927,-0.011564],[-0.18029,0.49561,-0.84962],[0.85409,0.19556,0.48196],[-0.59845,0.41658,-0.68434],[0.76954,0.54277,0.33647],[-0.55017,-0.38898,-0.73892],[-0.057638,0.94605,-0.31887],[-0.43638,-0.39258,0.8096],[-0.37487,0.52951,-0.76098],[0.16157,-0.98624,-0.034989],[0.49076,-0.85225,0.18119],[-0.6144,-0.52721,-0.587],[-0.40557,-0.32497,0.85435],[0.73905,-0.4884,0.46397],[0.61061,-0.62352,-0.48824],[0.76146,-0.45383,-0.46284],[-0.52344,-0.55461,0.64685],[0.76781,-0.22882,0.59842],[0.89578,0.29878,0.32911],[-0.69356,0.17059,-0.69991],[-0.28158,0.1115,0.95304],[-0.53335,0.6247,-0.57034],[0.42315,0.28665,0.85952],[0.84566,-0.48025,-0.23284],[0.92496,-0.34532,0.15873],[0.71771,0.2203,-0.66057],[-0.36834,-0.49592,0.78637],[0.18922,0.97045,-0.14974],[0.3628,0.93187,0.00032914],[-0.95292,-0.28721,-0.097251],[-0.18104,-0.51578,-0.83738],[-0.74614,0.62889,-0.21856],[0.27402,-0.54713,-0.79092],[-0.67775,0.67916,-0.28177],[-0.30327,-0.6985,0.64818],[0.77478,-0.055711,0.62977],[-0.54683,0.027914,-0.83678],[-0.25888,0.13761,-0.95606],[0.26297,0.06313,-0.96274],[-0.083035,-0.63681,0.76654],[-0.34434,-0.11268,0.93206],[0.72112,-0.13468,-0.6796],[0.052924,0.55407,-0.83079],[-0.11273,-0.26629,0.95728],[0.6683,0.43058,-0.60661],[0.76816,-0.41321,-0.48907],[-0.49664,0.20923,0.84236],[-0.96281,-0.26231,-0.064741],[-0.17602,-0.94311,-0.28208],[0.099014,-0.98964,-0.10393],[0.34879,0.045541,0.93609],[-0.36357,-0.84338,-0.39563],[0.71268,-0.39,0.58309],[0.15908,-0.54065,0.82607],[-0.2666,0.83698,0.47791],[-0.77628,-0.1869,-0.60205],[-0.15587,-0.42277,0.89273],[0.3543,-0.063562,0.93297],[0.88076,-0.4139,-0.23008],[-0.6782,-0.50089,-0.53773],[-0.019886,-0.27437,0.96142],[0.794,-0.20557,0.57211],[-0.58203,0.53055,-0.61624],[-0.21746,-0.26255,0.9401],[-0.4017,-0.55094,0.73151],[0.61882,0.75098,0.2304],[0.70736,0.63921,0.30175],[-0.95376,-0.15219,0.25918],[-0.3014,-0.55893,0.7725],[-0.16033,0.91388,-0.37298],[0.9322,-0.36166,-0.014079],[0.43484,0.8986,0.058497],[0.098759,0.98054,-0.16964],[-0.024819,-0.31871,0.94753],[-0.11905,-0.83355,-0.53947],[0.1681,0.10329,0.98034],[0.58776,-0.21183,0.78081],[-0.15869,0.40491,-0.90048],[-0.47602,-0.55977,-0.67828],[-0.37113,-0.68234,0.62982],[-0.8627,-0.44579,-0.2388],[0.55721,-0.73047,-0.39487],[0.97081,-0.19046,-0.14579],[0.63954,-0.65114,-0.40867],[0.9844,0.16314,-0.065843],[-0.41039,0.45238,-0.79179],[-0.65596,0.2175,-0.72278],[0.7448,-0.34924,0.5686],[0.040377,-0.41722,0.90791],[-0.19964,0.65806,-0.72602],[0.39142,0.10912,0.91372],[0.39688,0.6972,-0.59699],[0.12845,0.73529,-0.66547],[-0.59411,-0.18451,0.78294],[0.12703,-0.78099,0.61149],[0.38272,-0.91892,0.095451],[-0.84579,0.35604,0.39734],[0.94935,-0.2423,0.20007],[0.73728,-0.58258,0.34207],[0.84767,-0.26056,0.46214],[0.70703,-0.65266,-0.27229],[-0.6645,0.58531,-0.46461],[0.8592,0.49411,-0.13278],[0.76954,0.063462,0.63544],[-0.78009,-0.006721,-0.62563],[-0.77908,0.1185,-0.61563],[-0.99992,0.0051786,0.011117],[-0.75218,-0.19361,0.62988],[-0.67464,0.34737,-0.6513],[0.57665,0.37308,0.72684],[0.81031,0.27587,0.517],[0.26138,-0.4656,0.84552],[-0.51424,-0.039064,0.85676],[0.16531,-0.47854,0.86237],[0.30318,-0.25158,0.91913],[0.072692,-0.76152,0.64405],[-0.36478,0.78761,-0.4966],[0.93992,-0.33925,-0.038245],[-0.81021,0.58614,-0.0015558],[0.45082,0.87144,0.19326],[0.035413,0.61349,-0.78891],[-0.079043,0.94847,-0.30686],[0.27141,0.96147,-0.04369],[0.72385,-0.084086,0.68482],[-0.050083,-0.55514,-0.83025],[-0.66556,0.027141,0.74585],[-0.50501,-0.39347,0.76821],[0.24322,-0.56821,-0.78612],[-0.16499,-0.16687,-0.97208],[0.16541,-0.16027,0.97312],[-0.70866,0.20159,0.67614],[0.41614,-0.11186,-0.9024],[0.3458,0.80424,-0.48335],[-0.61906,-0.70747,-0.34096],[-0.30136,0.26472,-0.91602],[0.030512,0.31416,-0.94888],[0.62187,0.3734,-0.68837],[0.42003,-0.40936,0.80994],[0.22391,0.64665,-0.72918],[0.24748,0.91778,-0.31055],[-0.22898,-0.89847,-0.3746],[0.43083,-0.57081,0.69897],[0.18841,-0.98208,-0.0042306],[0.96494,-0.21212,0.15458],[-0.66758,-0.56793,-0.48145],[0.17968,-0.48575,0.85543],[0.66056,0.74394,-0.10108],[0.68428,-0.64388,0.34233],[0.94455,-0.12721,0.30274],[-0.7673,-0.27094,-0.58124],[-0.63772,-0.22266,0.73739],[-0.71184,-0.36058,-0.60271],[0.79774,0.53199,-0.2839],[-0.53,0.44341,-0.72283],[-0.4044,0.82328,0.39833],[-0.33163,0.62711,-0.70481],[-0.18709,-0.3995,0.89744],[-0.18506,-0.47143,0.86227],[0.92512,-0.30409,-0.22733],[-0.65414,-0.73277,-0.18748],[-0.19051,-0.73915,0.64604],[-0.14052,-0.58306,0.80018],[0.38263,-0.92368,0.020233],[-0.29033,0.192,0.93747],[-0.58789,-0.6315,-0.50557],[-0.99952,-0.009922,-0.029394],[0.85655,-0.20284,-0.47453],[0.84567,-0.22753,0.48278],[0.62262,0.12837,-0.77192],[-0.99447,0.063951,0.083304],[-0.65619,0.41282,-0.63166],[0.88072,0.067614,0.46878],[0.83339,0.41661,0.36318],[-0.13326,-0.55392,0.82184],[-0.60617,0.63234,-0.4824],[0.1149,-0.78457,0.60931],[0.56716,0.81253,0.13462],[-0.09477,0.96106,-0.25959],[-0.91512,0.37168,-0.15623],[-0.05483,-0.77473,-0.62991],[0.77524,0.058047,0.62899],[0.18324,-0.85877,-0.47847],[0.75734,0.63712,-0.14326],[0.62102,-0.59666,-0.50826],[-0.24667,-0.50816,-0.82518],[-0.042239,0.80004,-0.59845],[-0.31459,-0.67279,0.66961],[-0.21115,-0.70372,-0.67838],[0.21671,-0.61788,0.75581],[-0.55101,-0.25524,0.79451],[0.80123,0.051872,-0.59611],[0.98285,-0.073734,0.16905],[-0.45887,-0.11012,-0.88165],[-0.34801,-0.11683,-0.93018],[0.3826,-0.66315,0.64332],[-0.98571,-0.075623,0.15053],[0.99598,-0.05056,0.073922],[0.20658,0.1565,0.96583],[-0.44726,0.26362,-0.85467],[-0.32838,0.57481,-0.74951],[-0.16976,0.64095,-0.74857],[0.84228,0.46269,0.27655],[-0.76626,-0.25297,-0.59063],[0.042811,0.59724,-0.80092],[0.076386,-0.66125,0.74626],[0.2722,-0.15419,0.94981],[-0.16451,0.83404,-0.52661],[0.079944,0.83764,-0.54034],[0.59443,0.67001,-0.44468],[-0.51254,-0.80524,-0.29816],[-0.43891,-0.88863,-0.133],[-0.057736,-0.59845,0.79907],[-0.16478,-0.98319,-0.078638],[0.23104,-0.96481,0.12552],[0.91418,-0.21534,-0.34337],[0.80092,-0.40634,0.43979],[0.28669,0.1399,0.94775],[0.95062,-0.1811,0.25202],[-0.75322,-0.3067,-0.58189],[-0.80748,-0.0078434,-0.58985],[0.46185,-0.52192,0.71714],[0.97573,0.21197,-0.054924],[0.068663,0.71405,-0.69672],[-0.93084,-0.24475,0.27136],[-0.27445,-0.6914,0.66831],[0.99803,0.015646,0.060684],[0.20958,0.80839,-0.55008],[0.38819,0.76076,-0.52014],[-0.011308,0.76951,-0.63853],[-0.71682,-0.32736,-0.61564],[-0.69551,0.18679,0.69382],[0.33897,-0.42824,0.83768],[0.068924,-0.98343,-0.16768],[0.65646,0.1326,0.74262],[-0.40014,-0.04267,0.91546],[0.80697,-0.4575,-0.3735],[-0.36953,-0.86149,-0.34825],[-0.19836,-0.94241,-0.2693],[0.44226,0.58609,0.6789],[0.20134,0.11598,0.97263],[-0.80585,0.50677,0.30625],[-0.73236,-0.41064,-0.54316],[0.83996,-0.25224,0.48046],[0.11556,-0.63003,0.76793],[-0.84535,0.11083,-0.5226],[0.57539,0.21763,0.7884],[0.48885,-0.64986,0.58198],[-0.81547,0.28828,-0.50189],[0.98746,-0.15616,0.023134],[-0.42163,0.57157,-0.70394],[-0.39593,0.84536,-0.35862],[0.27693,-0.51478,0.81136],[0.14043,0.98228,-0.12415],[0.29374,0.95588,0.0021445],[-0.36249,-0.045499,0.93088],[0.24602,-0.95768,-0.14942],[-0.34671,-0.44934,0.82334],[-0.24677,-0.72437,-0.64373],[0.78498,-0.43093,-0.44509],[-0.84298,0.037248,-0.53666],[-0.11398,-0.82121,-0.55912],[0.044986,-0.9394,-0.33987],[0.65066,-0.71395,0.25868],[-0.40426,-0.42872,-0.80794],[0.072229,0.43646,0.89682],[0.42586,-0.33515,0.84043],[-0.15445,-0.55356,0.81836],[0.93963,0.2988,-0.16679],[0.86161,0.12167,0.49277],[-0.31939,-0.74716,-0.58287],[0.89816,0.37212,0.23415],[-0.28254,0.77408,-0.56655],[0.99192,-0.092994,0.086261],[-0.76795,-0.20893,-0.60548],[0.16244,-0.98534,0.052053],[0.11977,-0.54127,0.83227],[0.44605,0.88755,-0.1153],[0.16295,0.94525,-0.28275],[-0.105,-0.99388,0.034258],[0.081765,-0.99058,0.10987],[0.61181,-0.73502,0.2923],[-0.45077,-0.49418,0.74337],[-0.67711,-0.67018,-0.30393],[-0.88853,-0.4509,-0.084913],[0.88522,-0.46327,0.042102],[-0.42119,-0.87919,0.22276],[-0.81683,-0.44665,-0.3651],[0.23974,-0.56879,0.78677],[0.42126,-0.40102,0.81347],[-0.8986,-0.23453,-0.37084],[-0.86205,-0.08716,-0.49928],[0.99264,-0.12047,0.012575],[-0.50537,-0.47046,0.72338],[0.90347,-0.2536,-0.34557],[-0.40469,-0.38063,0.83147],[-0.6686,0.27529,-0.69079],[-0.84844,0.52104,-0.093064],[-0.76171,0.42401,-0.48992],[0.090361,-0.0020547,0.99591],[-0.29597,-0.48312,0.82401],[0.41105,-0.80005,0.43698],[0.75545,0.57664,0.31111],[-0.46621,0.5676,-0.67859],[-0.76828,0.22839,0.59799],[-0.23289,0.7207,-0.65296],[0.98991,0.11088,0.088254],[0.63533,0.71602,-0.28926],[0.76457,-0.11792,0.63366],[0.71547,0.61042,-0.33984],[-0.52115,-0.54866,0.65374],[0.28365,0.83218,-0.47646],[0.17545,-0.97892,-0.10454],[-0.42557,-0.50272,0.75243],[0.69187,-0.61373,0.38032],[0.60696,-0.77013,0.1962],[0.83607,-0.38506,0.39079],[0.95142,-0.20215,-0.23223],[0.85768,-0.2347,0.45749],[-0.93985,-0.30745,-0.14886],[0.49475,-0.13047,0.85918],[0.44269,-0.22303,0.8685],[-0.6523,0.73762,0.1744],[0.58143,0.77976,0.23221],[0.6422,0.17765,0.74567],[0.76538,0.22732,0.6021],[-0.40508,-0.26031,0.87644],[-0.24834,0.91573,-0.31585],[0.47049,-0.7918,0.38949],[0.25006,-0.96163,-0.11285],[0.41494,-0.80675,0.42069],[0.32825,-0.79276,-0.51359],[-0.33198,0.92941,-0.16122],[-0.44459,-0.53713,-0.71682],[0.22748,-0.97374,0.0089024],[0.58335,0.19523,0.78841],[-0.94935,-0.23641,-0.20701],[-0.58795,-0.26272,-0.76504],[0.99951,0.027971,0.014212],[-0.60488,-0.066741,-0.79352],[0.74862,-0.059542,0.66032],[-0.63589,0.29102,-0.71481],[-0.84872,-0.088472,-0.5214],[0.95889,-0.28067,-0.041847],[0.36086,-0.15499,0.91965],[-0.97863,-0.17142,-0.11354],[-0.45645,0.5954,-0.66118],[0.45407,-0.11961,0.8829],[0.46323,0.12173,0.87784],[-0.54983,-0.17521,0.81669],[-0.44498,-0.11179,0.88853],[0.49582,0.84265,0.21],[0.66085,0.63776,0.39565],[0.50815,0.58272,-0.63421],[0.024381,0.95565,-0.29349],[0.34658,0.93788,0.016049],[0.56964,-0.21961,0.79201],[-0.26851,0.95017,-0.15839],[-0.54839,-0.82401,-0.14238],[0.82316,-0.51227,0.24493],[-0.26271,0.96338,0.053702],[-0.87367,0.12177,-0.47104],[0.92751,-0.3693,0.057886],[0.99299,0.056024,0.10411],[0.4419,-0.16402,0.88194],[-0.54455,0.059486,0.83662],[0.89762,0.36773,-0.243],[-0.52943,-0.45398,0.71666],[-0.43255,-0.29547,0.85182],[-0.97885,0.20334,0.022417],[-0.45355,0.69983,-0.55184],[0.9828,-0.16001,-0.092179],[-0.98794,0.15405,-0.015664],[0.43899,0.76892,-0.46482],[-0.32826,-0.88963,-0.3175],[0.99495,-0.021569,0.098023],[-0.20522,-0.94753,-0.24509],[-0.47901,-0.093575,0.87281],[-0.84485,0.25279,-0.47152],[-0.5312,-0.73153,-0.42742],[-0.57568,-0.58317,0.57315],[0.52544,0.089006,0.84616],[0.88423,-0.14281,0.44469],[-0.84928,-0.030683,-0.52704],[-0.56488,-0.3992,0.72219],[0.87667,-0.24313,0.41514],[0.44442,-0.28162,0.8504],[0.89309,-0.017332,0.44954],[-0.83919,0.29496,-0.45691],[0.83,0.38381,0.40471],[0.6565,0.71699,-0.23436],[-0.73342,0.5484,-0.40169],[0.66439,0.68648,0.29553],[0.98086,0.15034,0.12373],[0.24486,0.96928,0.02342],[-0.47487,0.8795,-0.031227],[-0.16243,0.96473,-0.20716],[0.083424,0.99301,-0.083515],[0.72361,0.6762,-0.13833],[-0.0031624,-0.87999,-0.47498],[0.49591,-0.74014,0.45416],[0.10924,-0.91129,-0.39701],[0.3883,-0.92089,-0.034443],[0.97349,0.015704,0.22818],[0.41495,-0.44053,0.79608],[-0.2981,-0.15282,0.94222],[0.36325,-0.92027,0.14545],[0.39687,0.76849,-0.50192],[0.51281,0.14783,0.84568],[0.58846,-0.037174,0.80767],[0.559,-0.64889,0.51619],[0.62638,-0.39547,0.67175],[0.15394,-0.98583,0.066718],[-0.83928,0.30539,-0.44983],[-0.66108,-0.47519,0.58067],[-0.92571,0.37265,0.064812],[-0.096022,0.9952,-0.018825],[0.7317,0.15482,0.66382],[0.99734,-0.069997,0.020287],[-0.99548,0.088499,0.034375],[-0.43443,-0.388,0.81285],[0.66229,0.62792,0.40877],[-0.30222,0.81021,-0.50222],[-0.0024945,0.99898,-0.045167],[0.080273,0.98702,-0.13908],[0.68975,-0.38449,0.61353],[0.856,-0.2928,0.42606],[0.30764,-0.93419,0.18068],[-0.97839,0.0055399,0.2067],[-0.71745,-0.6575,-0.23012],[0.66655,-0.72731,0.16351],[0.95565,0.21696,0.19915],[0.82359,-0.5662,0.03361],[-0.45051,-0.21148,0.86736],[-0.4576,-0.16554,0.87361],[-0.39064,-0.10572,0.91445],[-0.74849,0.64545,0.15214],[-0.83348,0.2362,-0.49952],[0.99343,0.067542,-0.092352],[-0.41829,-0.21218,0.88318],[-0.84559,0.32909,-0.42034],[0.3257,0.93618,-0.13227],[0.81093,-0.30755,0.49779],[-0.48427,0.8667,-0.11958],[-0.36783,0.92661,-0.078056],[-0.10541,0.86551,-0.48968],[0.090725,0.84909,-0.5204],[-0.58377,0.79589,-0.16057],[-0.16123,-0.037166,0.98622],[0.23223,-0.97202,0.035274],[0.70043,-0.63682,0.32226],[-0.99516,0.098214,0.0009479],[-0.97387,-0.079836,0.2126],[0.42097,-0.47997,0.76968],[-0.2722,0.95451,-0.12175],[-0.86034,0.21692,-0.46126],[0.69185,-0.5214,0.49948],[-0.91716,-0.20075,0.34425],[0.73136,0.60723,0.31048],[-0.50787,0.81305,-0.28464],[0.45074,0.88005,0.1495],[0.073125,0.99623,-0.046655],[0.37682,-0.1481,0.91437],[-0.86354,0.1087,-0.49243],[-0.19973,-0.77812,-0.59551],[0.10494,-0.99414,0.025805],[-0.31944,-0.12693,0.93907],[0.51993,-0.60579,0.60224],[-0.48725,-0.4447,0.75155],[0.96855,0.21766,0.12058],[-0.30055,-0.71311,-0.63335],[0.52477,0.79535,0.30337],[0.57691,-0.65335,0.49022],[-0.48857,-0.50756,-0.70971],[0.59323,-0.12021,0.79601],[0.46362,0.69029,-0.55548],[-0.62193,-0.27053,-0.73486],[0.73388,-0.14937,0.66265],[-0.71893,0.041101,-0.69386],[-0.71268,0.36812,-0.59714],[0.69791,-0.15513,0.69919],[-0.22342,-0.16462,0.96072],[-0.57896,0.60213,-0.54977],[0.54557,0.028331,0.83759],[0.96602,0.23624,0.10491],[0.62762,-0.35373,0.69352],[-0.40043,0.83003,-0.38821],[-0.12926,0.96098,-0.24456],[-0.17284,-0.11397,0.97833],[-0.17817,0.97242,-0.15048],[-0.48824,-0.48747,0.72387],[0.43025,0.88172,0.19351],[0.44139,-0.46462,0.76766],[-0.88037,0.35443,-0.31516],[-0.19556,-0.97982,0.041426],[0.78529,0.27302,0.55568],[-0.18376,0.9661,-0.18135],[0.31012,-0.0638,0.94855],[0.41696,0.84255,0.34095],[-0.0030814,0.48787,0.87291],[-0.95283,-0.019941,-0.30285],[0.9848,-0.16242,-0.061586],[-0.93351,0.15841,-0.32166],[-0.75302,0.36126,0.54996],[-0.69204,-0.30851,0.65261],[0.6467,-0.08911,0.75753],[-0.53471,0.79435,0.28826],[0.97243,0.17469,-0.15451],[0.80572,0.52344,-0.27718],[-0.68903,0.55852,-0.46184],[0.45271,-0.32933,0.82861],[0.95962,0.26687,0.088991],[0.47295,-0.1438,0.86928],[-0.45525,0.77065,-0.44592],[-0.27,0.8537,-0.44531],[-0.92915,-0.1693,0.32866],[0.045166,0.93554,-0.35032],[0.21665,0.9146,-0.34142],[-0.16149,-0.95562,-0.24641],[0.18985,-0.98166,-0.017421],[0.056374,-0.99713,0.050511],[0.6437,-0.72394,0.24813],[-0.66075,-0.58592,-0.46915],[-0.46369,-0.80166,-0.37727],[0.92357,0.38206,0.032392],[0.88082,-0.30298,0.36382],[0.89639,0.034953,0.44188],[-0.78043,-0.34725,-0.51995],[-0.82258,0.47275,-0.31602],[0.88547,-0.23493,0.40093],[-0.52034,-0.33152,0.78698],[-0.49898,0.85604,0.13495],[0.87539,0.28218,0.39251],[0.33272,0.48893,-0.80638],[0.84761,-0.51192,-0.13958],[0.73578,0.58731,0.33718],[0.37617,-0.71361,0.59098],[-0.19571,0.97027,-0.14241],[0.41613,0.90514,0.086888],[-0.3118,-0.70617,-0.6357],[0.39987,-0.71483,0.57369],[-0.76936,-0.23489,0.59407],[0.40237,0.61012,-0.68254],[0.20905,-0.93014,-0.30188],[0.52325,-0.84931,0.06986],[-0.77135,0.52489,-0.35989],[0.28063,0.73576,-0.61637],[0.75349,-0.55444,0.35334],[-0.94772,-0.3188,-0.014013],[0.85533,-0.24336,0.45737],[-0.13949,0.97023,-0.19798],[0.99456,0.10404,-0.0043672],[-0.82173,-0.54394,0.16996],[0.9163,0.38047,0.12506],[-0.79205,-0.016252,0.61024],[0.89466,-0.16029,0.417],[-0.099321,0.91509,-0.39082],[-0.66959,0.62056,-0.40811],[-0.59859,-0.34042,0.72513],[0.7998,0.13486,0.58492],[0.81858,0.0076277,0.57435],[-0.6709,-0.68172,0.29182],[-0.50005,0.85638,0.1287],[-0.66018,0.089596,0.74575],[-0.60738,-0.18849,0.77173],[-0.027529,0.79851,-0.60135],[-0.22743,0.95798,-0.1748],[0.2429,0.95706,0.15823],[0.19683,-0.97106,0.13531],[-0.023694,0.79221,-0.60978],[-0.53189,-0.84399,-0.069037],[0.086803,0.60956,-0.78798],[0.49536,-0.86059,0.11833],[0.54081,-0.14861,0.82791],[0.91952,0.39026,-0.046616],[-0.79743,-0.57249,-0.19066],[-0.74864,0.62989,-0.20683],[0.69113,-0.7196,0.067233],[-0.87731,-0.43064,-0.21186],[0.91061,-0.41278,-0.019838],[-0.94869,-0.20991,-0.23649],[-0.25295,0.75978,0.59895],[0.4537,-0.66243,0.5961],[0.41187,-0.29804,0.86113],[0.93975,0.23542,0.2479],[-0.78469,0.48619,-0.38456],[0.5421,0.6985,0.46716],[0.43783,-0.6299,0.6415],[0.59536,0.72436,-0.34764],[-0.7022,-0.29035,0.65008],[-0.10331,-0.17617,0.97892],[0.44419,0.62631,-0.64064],[0.58588,-0.24733,0.77173],[0.32365,-0.18107,0.92869],[-0.80044,-0.5817,0.14466],[-0.91415,0.40277,0.045853],[0.24872,-0.50141,0.82869],[0.31179,-0.93697,-0.15773],[-0.56929,-0.20001,0.79744],[0.99129,0.13168,-0.00049706],[-0.19537,0.86481,-0.46253],[-0.56397,-0.6935,-0.44833],[-0.5492,-0.45594,0.70035],[-0.70669,0.63658,-0.30879],[0.99738,0.071645,-0.0098992],[-0.93735,-0.27998,-0.20734],[0.53223,-0.16831,0.8297],[0.87451,0.3982,0.2769],[0.99698,0.072375,0.028001],[0.90103,-0.23164,0.36674],[0.93162,-0.055407,0.35918],[-0.81713,0.47252,-0.33019],[-0.83114,0.49977,-0.24381],[0.87899,0.47323,-0.058608],[-0.77867,0.53685,-0.32476],[-0.96383,0.044774,-0.26274],[-0.60174,0.76675,-0.22361],[0.97334,0.22923,0.0073909],[0.086678,-0.47635,0.87497],[-0.34866,0.9237,-0.1588],[-0.13741,-0.81956,-0.55627],[-0.98016,-0.057381,-0.18973],[0.098576,0.82845,-0.55132],[-0.14507,0.15615,0.97702],[0.92103,0.36311,-0.14093],[0.4311,-0.9017,0.033133],[-0.90818,0.41834,-0.013923],[0.82475,0.56499,0.024187],[-0.60957,-0.42517,-0.66907],[-0.62566,0.047365,0.77865],[0.73149,-0.63793,0.24077],[-0.6759,-0.22212,-0.70272],[0.86596,-0.3515,0.35575],[-0.78246,0.2658,-0.56312],[0.0080817,-0.99971,0.02253],[-0.65566,-0.33256,0.67788],[0.67095,0.65005,0.35675],[0.44438,-0.58067,0.68216],[0.84409,0.21655,0.49052],[-0.78105,0.61488,0.10904],[-0.53919,0.77589,-0.32752],[0.74328,0.4884,0.45717],[-0.61403,-0.71106,0.34258],[-0.36483,0.90404,-0.22273],[0.44643,-0.39648,0.80219],[-0.32073,-0.5383,-0.77934],[0.61613,0.67793,0.40099],[-0.054454,0.99821,0.02476],[0.11244,0.98229,0.14986],[-0.03428,-0.35133,-0.93562],[0.55454,-0.060121,0.82998],[-0.25559,-0.96634,0.029391],[0.98949,-0.057565,0.13262],[-0.52751,-0.050574,0.84804],[-0.98603,-0.1517,0.068813],[0.98499,-0.15623,-0.073334],[0.20463,-0.44437,0.87216],[0.84424,0.18164,-0.50425],[-0.80205,0.53988,0.25544],[0.96563,0.20179,-0.16385],[-0.98602,-0.1613,-0.041802],[0.28388,-0.39031,-0.87582],[0.97594,-0.14883,0.15932],[-0.95806,0.1798,0.22313],[-0.27778,0.87242,-0.40216],[0.040279,0.9416,-0.33432],[0.22073,0.94009,-0.25984],[0.52075,-0.40105,0.75364],[-0.22607,-0.87588,-0.4263],[0.27863,0.20031,0.93928],[-0.03992,-0.95777,-0.28474],[0.26095,-0.92132,-0.28822],[0.73642,-0.6465,0.19932],[-0.62123,-0.028863,0.7831],[0.69857,0.71554,0.00048539],[0.68686,-0.42132,0.59221],[-0.7561,-0.4737,-0.45157],[-0.81721,0.52211,0.24408],[-0.961,-0.26773,-0.069334],[0.98124,0.049089,0.18643],[-0.89028,-0.14608,-0.43135],[0.91944,-0.22684,0.32121],[-0.61206,-0.5968,-0.51886],[-0.02222,-0.99964,0.015082],[-0.89527,0.12963,-0.42625],[0.57957,0.81411,-0.036264],[-0.56975,-0.21647,0.7928],[0.6565,0.75421,0.013431],[-0.80341,-0.41442,0.42753],[0.58946,-0.35294,0.72661],[0.62278,0.75372,0.20988],[-0.91923,0.053825,0.39003],[-0.57807,-0.15151,0.8018],[0.055309,0.99764,-0.040625],[0.26871,0.96272,0.031184],[-0.18807,-0.7942,-0.57782],[0.89363,0.42214,0.15241],[0.4548,0.79909,0.39321],[0.42315,-0.88603,-0.18944],[0.58168,-0.81335,-0.010039],[-0.25273,-0.73396,-0.63042],[-0.24483,-0.42837,-0.8698],[-0.42321,-0.63564,-0.64564],[-0.35034,0.089958,0.93229],[-0.6453,-0.28358,-0.70935],[0.33011,0.2205,0.91783],[0.85001,-0.40427,0.33771],[0.17784,-0.61226,-0.77039],[-0.781,0.031143,-0.62375],[0.70713,0.13962,0.69317],[0.55335,-0.32087,0.76866],[0.90323,-0.22679,0.36433],[-0.87264,0.1524,0.46397],[0.25973,-0.37924,-0.8881],[-0.72733,0.5003,-0.46977],[-0.76611,-0.23782,0.5971],[0.71249,-0.21728,0.66719],[-0.15439,0.98784,-0.018574],[-0.58195,-0.06528,0.8106],[0.7014,-0.44877,0.55376],[0.33043,0.89515,0.29919],[0.94546,-0.12052,0.30262],[0.21983,0.72714,0.65034],[-0.49613,-0.86774,0.029575],[0.032975,-0.99898,0.030726],[0.33395,-0.93788,0.094106],[-0.54034,-0.12,0.83284],[-0.9672,-0.21936,-0.12804],[0.96767,0.12455,0.21933],[0.88737,-0.46059,0.020828],[-0.022969,-0.22293,-0.97456],[-0.41693,0.85648,0.30434],[0.85405,0.47754,-0.20628],[0.53482,0.81663,-0.21699],[-0.81018,0.37703,0.44883],[-0.54918,0.71793,-0.42775],[-0.53878,-0.27376,0.79672],[0.48074,0.84378,-0.2386],[-0.73364,0.63378,-0.24513],[0.21449,-0.51738,0.82844],[0.13088,0.95605,-0.26236],[0.58402,-0.70111,0.40911],[-0.084782,-0.29554,-0.95156],[-0.48089,-0.6763,-0.558],[-0.17585,-0.93383,-0.3115],[0.65448,-0.71337,0.25051],[-0.59905,-0.5871,0.54448],[-0.32539,-0.88846,-0.32365],[0.89229,-0.26511,0.36543],[0.68198,-0.090755,0.72572],[0.81497,-0.47747,0.32841],[0.93485,-0.17484,0.30902],[0.44095,-0.21483,0.87144],[-0.83533,0.49535,-0.23843],[0.37572,-0.48898,0.78723],[-0.86073,0.36482,0.35505],[-0.88792,0.29264,-0.35491],[0.97528,-0.18404,0.12226],[-0.6318,-0.3656,0.6835],[0.80563,0.53963,0.24447],[-0.24146,0.96638,-0.088296],[0.16254,0.98538,0.051107],[0.38335,0.91395,0.13317],[-0.57852,-0.28384,0.76469],[-0.30872,-0.74981,-0.58521],[0.023487,-0.86416,-0.50266],[0.24679,-0.92309,-0.29497],[-0.53019,-0.27438,0.80225],[-0.21103,-0.52256,-0.82607],[-0.13471,-0.38563,-0.91277],[-0.79592,0.44094,0.41483],[0.45105,-0.33107,0.82882],[-0.64158,-0.67122,0.37126],[-0.59902,-0.44614,-0.66493],[-0.67444,0.62753,0.38902],[-0.53028,-0.74695,0.40109],[-0.99506,-0.095759,-0.026342],[-0.051431,-0.31036,-0.94923],[-0.97545,-0.20353,-0.084122],[-0.65903,-0.3739,0.6526],[-0.78097,0.25603,-0.56967],[-0.54729,-0.23446,0.80343],[0.92842,-0.026185,0.37061],[0.15633,-0.43367,-0.88741],[-0.63247,0.72301,0.27794],[-0.63829,0.6755,-0.36916],[-0.47799,-0.10626,0.87191],[0.54218,-0.019168,0.84004],[0.85973,0.33508,0.38547],[-0.60074,-0.083333,0.79509],[-0.53304,0.8004,-0.27427],[0.65456,0.66795,0.35412],[-0.38801,0.9117,-0.1351],[-0.073915,0.26382,0.96174],[0.95719,-0.26554,0.11525],[-0.38034,-0.05923,0.92295],[0.68289,-0.61784,0.38979],[-0.65813,-0.75173,-0.042049],[-0.17982,-0.97793,0.1064],[0.52653,-0.84771,0.064401],[-0.73539,-0.67574,-0.050656],[0.10531,0.34736,0.9318],[0.72458,-0.6869,0.056131],[-0.89143,-0.44203,-0.099866],[0.93688,0.14403,0.3186],[-0.84571,-0.37994,0.37474],[-0.76126,-0.23224,-0.60544],[-0.97089,-0.15226,-0.18492],[0.98341,-0.17638,-0.042271],[-0.78671,0.48426,0.38285],[-0.90804,0.29197,-0.30037],[0.76839,-0.0023503,0.63997],[-0.72941,0.57256,-0.37434],[0.94227,0.2958,-0.15694],[0.75281,0.62265,-0.21351],[-0.29787,0.24405,0.92288],[0.10878,0.96639,-0.23294],[0.50886,0.79932,-0.3196],[-0.096348,0.94273,-0.31934],[-0.3028,-0.91482,-0.26725],[0.47976,-0.75117,-0.45339],[0.24209,-0.96899,0.049483],[0.56389,-0.079964,0.82197],[-0.50534,-0.7695,-0.39051],[-0.38015,-0.87909,-0.28753],[-0.61271,-0.35981,0.70365],[-0.87564,0.20156,0.43889],[0.91375,-0.39809,0.081198],[-0.93296,0.098041,-0.34637],[-0.7353,-0.37623,0.56373],[-0.76238,-0.22128,0.60813],[0.93084,0.21721,0.29387],[-0.56377,-0.1042,0.81933],[-0.69322,0.70272,-0.16009],[-0.46517,0.88076,-0.088827],[0.60573,0.78505,0.12956],[0.61436,-0.026606,0.78858],[0.40576,-0.88756,-0.21816],[0.60296,0.60137,0.5242],[-0.48158,-0.62817,-0.61113],[0.58904,-0.8077,-0.025339],[-0.51914,0.10766,0.84788],[-0.077364,-0.25923,-0.96271],[0.76864,-0.6263,0.13017],[0.87064,-0.39882,0.28797],[0.74283,-0.36609,0.56052],[-0.77173,-0.16168,-0.61506],[-0.86979,-0.21132,0.44587],[-0.037236,-0.99922,0.012937],[-0.95504,-0.29463,-0.032982],[-0.093925,-0.26077,-0.96082],[0.91645,0.15067,0.37071],[0.29117,0.87979,0.37576],[-0.77419,0.37617,-0.50904],[0.45697,0.7823,0.4233],[-0.559,0.19478,0.80597],[0.92452,0.11526,0.36328],[-0.12742,0.99166,0.019126],[-0.83255,0.20118,0.51613],[0.10593,0.97797,0.17987],[0.62983,-0.77514,0.049648],[0.50681,-0.81982,-0.26654],[0.8346,-0.55083,0.004527],[0.15109,-0.062767,0.98653],[-0.86039,-0.50741,0.047515],[0.94844,-0.31477,-0.037123],[-0.97319,0.048619,-0.22482],[0.99508,0.071214,-0.068835],[0.71237,-0.38005,0.59],[-0.65606,-0.61526,0.43708],[0.25335,-0.84639,-0.46844],[-0.35358,0.86832,-0.34785],[0.062818,0.908,-0.41423],[0.17555,0.92178,-0.3457],[0.22244,0.90785,-0.35542],[0.064149,0.32794,0.94252],[0.10499,-0.99356,0.042719],[-0.3045,-0.93364,-0.18867],[0.68498,-0.69272,0.22569],[-0.15192,0.13782,0.97874],[-0.71165,-0.59132,-0.37932],[0.29359,-0.67446,-0.67743],[-0.25552,0.90867,0.3302],[0.78371,-0.5446,0.2987],[-0.51241,0.21269,0.83199],[-0.63464,0.20814,0.74425],[0.20996,-0.39858,-0.89278],[-0.88186,-0.26907,-0.38721],[0.42885,-0.76073,-0.48722],[0.96542,-0.25175,0.067734],[0.65398,-0.091152,0.751],[-0.56478,-0.018451,0.82504],[0.96622,-0.19954,0.1631],[-0.92582,0.29848,-0.23188],[-0.28281,0.90574,0.31567],[0.74727,0.132,0.65128],[-0.77596,-0.017554,0.63053],[0.90648,0.021023,0.42172],[0.11052,0.99354,-0.025959],[0.31007,0.9505,-0.019922],[0.081098,-0.9175,-0.38938],[-0.079878,0.17437,0.98143],[0.87848,-0.081815,-0.47072],[-0.41914,-0.71172,-0.56372],[0.36335,-0.61498,-0.69984],[-0.60529,-0.51349,-0.60824],[-0.38557,-0.84904,0.36121],[0.64545,-0.66872,-0.36905],[-0.86042,-0.50958,-0.0012441],[0.86661,-0.47271,0.15977],[-0.14561,-0.30719,0.94044],[-0.85206,0.17669,-0.49271],[0.75879,-0.52329,0.38781],[0.92657,-0.26097,0.27087],[0.33938,-0.11487,-0.93361],[-0.77664,0.50971,-0.37017],[0.93837,-0.03243,0.3441],[-0.6315,0.69206,-0.34965],[0.84112,0.4227,0.3374],[0.6151,-0.51528,0.59678],[0.0032713,-0.28166,-0.95951],[0.46948,0.8134,0.34347],[-0.33854,0.93146,-0.13332],[-0.23088,0.97278,-0.019567],[0.3206,0.89981,0.29589],[0.069186,-0.99026,0.1208],[-0.86186,0.11044,0.49498],[-0.27298,-0.51891,-0.81007],[0.66164,-0.50206,0.55693],[0.47537,-0.49633,-0.72642],[0.80803,-0.066677,0.58536],[-0.82045,0.47557,-0.31731],[0.83673,0.44769,-0.31537],[-0.54241,0.036832,0.8393],[0.4973,0.090561,0.86284],[-0.6006,0.73593,-0.31255],[-0.88,-0.45643,0.13143],[-0.2053,-0.033125,0.97814],[0.27885,-0.57464,-0.76943],[0.56154,-0.62603,0.54107],[-0.086137,-0.33293,0.93901],[0.72898,-0.58888,0.34901],[-0.38875,-0.88744,0.24762],[-0.052561,-0.94038,-0.33605],[-0.34164,-0.90008,-0.27045],[0.65441,-0.72718,-0.20726],[0.12327,-0.43682,0.89106],[-0.28139,-0.94571,0.16264],[0.82984,-0.55061,-0.090513],[0.57286,-0.33681,0.74725],[0.92676,-0.36894,0.07076],[-0.94551,0.088824,-0.31325],[0.23128,-0.37035,-0.89964],[-0.9403,0.2224,-0.25762],[0.83748,0.0084389,0.54641],[-0.78114,0.044676,0.62275],[0.61741,0.06958,0.78356],[0.96548,0.10304,0.23924],[-0.58762,0.10284,0.80257],[-0.80254,0.5701,-0.17584],[0.9277,0.3311,0.17248],[0.831,-0.30206,0.46712],[-0.92277,0.21931,0.31687],[-0.615,0.78556,-0.068315],[-0.38301,0.92349,-0.021913],[-0.059714,0.99807,-0.017293],[0.052846,0.99806,0.033006],[0.61767,0.16245,0.76948],[0.52091,-0.69881,0.49022],[0.32617,0.85756,0.39775],[-0.40129,-0.77472,-0.48864],[-0.53765,0.255,0.80368],[-0.34607,-0.80274,-0.48565],[-0.067296,-0.92189,-0.38157],[0.45638,-0.87853,-0.14107],[0.69096,0.17674,0.70095],[0.082395,0.36182,0.9286],[-0.45226,-0.69733,-0.55605],[0.64015,-0.76807,0.01683],[0.063051,0.33576,0.93983],[-0.14468,-0.58632,-0.79705],[0.71249,-0.69733,0.07797],[0.6871,-0.65077,0.32309],[-0.29301,-0.94478,0.14676],[-0.86789,-0.014285,-0.49655],[0.58799,-0.2663,0.76377],[0.92351,-0.33141,0.19312],[0.73554,-0.60396,0.30694],[-0.86106,0.019638,0.50813],[0.59742,-0.71233,-0.36834],[0.43838,-0.54737,-0.71289],[-0.80764,-0.10174,0.58083],[0.67975,0.58018,0.4487],[-0.91241,-0.40869,-0.021927],[-0.65756,-0.08364,-0.74875],[-0.090277,-0.99496,0.04363],[0.042397,0.98676,0.15654],[0.2263,0.92685,0.29955],[-0.27443,-0.95977,0.059364],[-0.69,-0.72362,-0.016477],[0.6879,-0.72547,0.022012],[-0.58006,-0.71427,-0.39159],[-0.93582,-0.34193,-0.085576],[0.81393,-0.4797,0.32773],[0.99104,-0.062728,-0.11795],[-0.21954,0.41027,-0.88515],[-0.89075,0.43791,0.12168],[0.32409,-0.58456,-0.74381],[0.10137,-0.50226,-0.85875],[-0.45635,-0.71977,0.52314],[0.14928,-0.32649,-0.93334],[-0.49931,-0.77139,0.39451],[-0.46244,-0.82092,0.33504],[-0.30005,-0.51027,0.80597],[0.034382,-0.33195,-0.94267],[0.52709,0.80143,-0.28263],[0.15082,0.91521,0.37369],[-0.24087,0.35285,-0.90415],[0.060102,0.14244,-0.98798],[0.22294,0.25902,-0.93979],[-0.84531,0.15734,0.51058],[-0.71587,0.57375,-0.39791],[0.69274,0.43802,-0.57293],[0.57119,-0.68581,-0.451],[-0.35157,0.86772,-0.35138],[-0.13241,0.93661,-0.32438],[0.039535,0.77008,-0.63673],[0.63731,0.1351,0.75867],[0.69405,0.11098,0.71132],[0.3906,0.64585,-0.65598],[-0.56821,0.28159,0.7732],[-0.14598,0.7831,0.60451],[-0.21115,-0.40136,0.89125],[-0.14229,-0.64949,-0.74694],[0.52265,-0.57259,-0.63164],[-0.29738,-0.84444,-0.44552],[-0.51347,-0.72132,-0.46481],[0.54821,-0.70103,0.4561],[0.77852,-0.51255,0.36221],[-0.54631,-0.77044,-0.32858],[0.91711,-0.28948,-0.27406],[-0.85914,0.070134,0.50691],[0.5319,-0.41569,-0.73775],[0.97916,-0.089225,-0.18242],[0.9997,0.021216,0.012303],[-0.48364,0.10754,-0.86864],[-0.87653,0.17659,-0.44779],[-0.2581,0.29241,-0.92081],[0.73212,0.67915,-0.05249],[0.1604,0.97959,-0.12113],[0.82457,0.21943,0.52148],[-0.89693,-0.43963,0.047292],[0.15654,-0.9081,-0.3884],[0.75727,0.15504,0.63443],[-0.27383,0.00098857,0.96178],[0.53734,-0.73316,-0.41684],[0.57502,-0.71696,0.3941],[-0.80315,-0.27328,-0.5294],[0.051717,0.0028466,-0.99866],[0.80216,-0.57128,0.1737],[-0.78088,0.16142,0.60346],[0.67206,0.18379,0.71733],[-0.4371,-0.74801,0.49943],[-0.030005,0.26489,0.96381],[-0.89141,0.14893,-0.42803],[0.47049,-0.33082,-0.81805],[-0.50863,0.14204,0.84919],[-0.86358,0.33665,-0.37535],[0.92152,-0.3007,0.24571],[0.93085,-0.12694,0.34265],[0.69935,-0.55564,-0.44964],[-0.79728,0.51989,-0.30669],[0.90931,0.083695,0.40761],[-0.64023,0.73313,-0.22941],[0.57759,0.67319,0.46174],[-0.4504,0.86939,-0.20324],[0.76304,-0.56382,0.31602],[-0.82125,0.054194,0.56798],[-0.17278,0.98496,-0.0023519],[-0.10975,0.99177,0.06599],[-0.039481,-0.99654,0.073204],[0.17719,-0.97595,0.12698],[0.41757,-0.90681,0.057733],[0.78137,-0.18137,0.59713],[-0.49501,-0.86889,5.7988e-05],[0.49364,0.70929,0.50322],[-0.068359,-0.51406,-0.85503],[-0.8777,-0.47805,0.033373],[-0.8113,-0.57585,-0.10092],[-0.35589,-0.25995,-0.89765],[-0.80725,-0.37455,-0.45614],[-0.43403,-0.57224,-0.69582],[0.26854,-0.25247,-0.92959],[-0.60424,0.61754,0.50352],[-0.87844,-0.054583,-0.47473],[0.31012,-0.39842,-0.86318],[-0.26418,-0.10816,-0.95839],[0.65094,-0.17854,0.73784],[0.66763,0.16273,0.72649],[-0.17871,-0.2534,-0.95071],[-0.49426,-0.19365,0.84747],[0.55828,-0.2548,-0.78956],[0.88722,-0.35872,-0.2901],[-0.35596,0.19716,-0.91347],[-0.84173,0.46807,-0.26908],[0.086071,-0.051623,-0.99495],[0.25148,-0.31577,-0.9149],[-0.25222,0.13515,-0.95819],[0.8605,-0.35985,0.36062],[0.51695,-0.45626,0.72428],[-0.1893,-0.53297,-0.82469],[-0.85225,-0.26848,0.44897],[-0.093228,-0.50437,-0.85844],[-0.28206,-0.48099,-0.83012],[0.11231,-0.12807,-0.98538],[-0.22083,-0.030071,-0.97485],[-0.95338,-0.141,-0.26679],[0.74373,-0.50872,-0.43366],[0.38758,0.6581,-0.64552],[0.84784,0.40675,-0.34018],[0.96249,-0.18048,0.20259],[-0.4241,0.88235,-0.20394],[-0.23123,0.95804,-0.16937],[-0.18505,-0.9754,0.11984],[-0.026849,0.74769,-0.66351],[-0.60219,0.06005,0.79609],[0.14849,0.89494,-0.42075],[0.32985,0.92022,-0.2107],[0.041781,0.31226,0.94908],[-0.94422,0.18851,-0.27003],[0.95076,0.092842,-0.29569],[0.034453,0.99938,-0.0069859],[-0.030552,-0.31849,0.94743],[-0.53037,-0.58389,-0.61464],[0.072076,0.31615,0.94597],[-0.87697,-0.26447,0.40123],[0.76268,0.084907,-0.64117],[-0.51953,0.73388,-0.43762],[0.55843,-0.81245,0.16757],[-0.25304,-0.25556,0.93309],[-0.25356,-0.11347,0.96064],[0.50888,0.17251,-0.84337],[-0.21658,0.78969,-0.574],[0.55288,-0.36998,-0.74662],[-0.057746,0.67197,-0.73833],[-0.14454,0.40204,-0.90414],[0.042452,0.29651,-0.95409],[-0.84107,-0.53865,0.049657],[-0.43151,-0.8667,0.25028],[-0.3149,-0.53628,-0.7831],[-0.17926,-0.23265,-0.9559],[0.37818,-0.18964,-0.9061],[-0.18378,-0.52198,-0.83293],[-0.30865,-0.24237,-0.91978],[0.66509,-0.28914,-0.68851],[0.070359,-0.50831,-0.85829],[-0.85827,-0.25258,0.44673],[0.36677,0.58018,0.72724],[0.83678,0.21439,0.50383],[-0.015367,-0.40205,-0.91549],[-0.24041,-0.38775,-0.88986],[-0.36866,-0.72641,-0.58001],[0.75219,-0.41823,-0.50921],[-0.79637,-0.40303,-0.45095],[-0.51121,-0.67971,-0.52599],[0.80457,-0.23077,-0.54719],[-0.83282,0.2112,0.51167],[0.88199,-0.075391,-0.4652],[-0.91251,0.20629,-0.35323],[-0.89743,0.35589,-0.26067],[-0.22452,0.21161,0.95122],[-0.12266,-0.94106,-0.31521],[0.98752,0.1421,-0.067833],[-0.73385,0.65489,-0.18053],[0.90838,0.24671,-0.3376],[-0.53245,0.84342,-0.071662],[-0.25069,0.95383,-0.16542],[0.0061993,0.9989,-0.046526],[0.84021,-0.033958,0.5412],[0.49457,-0.48305,-0.72254],[-0.3817,-0.73862,-0.55566],[-0.12607,-0.7697,-0.62583],[0.56342,-0.7908,-0.23915],[0.98143,0.056278,0.18338],[-0.89301,-0.27056,0.35963],[0.69327,-0.71881,-0.051803],[-0.63567,-0.55703,-0.53445],[0.88474,-0.37687,0.27422],[-0.15521,-0.97008,-0.18671],[-0.037606,-0.55609,-0.83027],[0.79677,0.29281,0.5286],[-0.50449,-0.48052,0.71735],[0.53812,-0.52832,0.65674],[-0.46542,0.090537,0.88045],[-0.53622,-0.37474,-0.75633],[0.39433,-0.29919,-0.8689],[-0.024618,0.15004,0.98837],[0.8957,0.14316,0.42098],[0.48963,0.77713,0.39539],[-0.84505,0.012982,0.53453],[-0.33344,0.94218,-0.033211],[0.38995,-0.91854,0.064995],[0.11545,0.96036,0.25371],[0.52453,-0.40153,-0.75076],[0.35538,-0.93472,-0.00083724],[-0.31045,-0.76443,-0.56504],[-0.83328,-0.54468,0.094705],[0.98212,0.09413,0.16302],[-0.16195,-0.88511,-0.4363],[-0.037361,-0.5517,-0.83321],[-0.52905,0.050624,0.84708],[0.14215,-0.27858,-0.94983],[0.018804,-0.67636,-0.73634],[0.084754,-0.10443,-0.99091],[0.42252,-0.54663,-0.72296],[0.53272,-0.54433,-0.64801],[-0.067417,-0.088639,-0.99378],[0.21765,-0.72571,-0.65267],[0.4484,-0.62769,-0.63635],[0.56802,-0.81432,-0.11932],[-0.77358,-0.49581,-0.39463],[-0.53528,-0.73291,-0.4199],[0.27219,-0.17998,-0.94526],[-0.054343,-0.11384,-0.99201],[0.59483,-0.48091,0.64414],[0.32386,-0.39961,-0.85757],[-0.23687,-0.94254,-0.23562],[0.032553,0.18263,0.98264],[-0.18862,-0.96015,-0.20623],[0.77863,-0.61924,-0.1014],[-0.83068,-0.45874,-0.31547],[-0.85864,-0.15541,0.48845],[0.31501,-0.0067535,-0.94906],[0.091092,0.031927,-0.99533],[-0.1411,-0.94466,-0.29616],[-0.12748,0.033631,-0.99127],[0.44546,-0.30079,-0.84326],[0.82595,-0.37805,-0.4182],[0.1754,-0.47186,-0.86405],[0.47959,0.24599,0.84231],[0.95611,0.076433,-0.28286],[-0.42316,-0.65553,0.62547],[0.062051,-0.64313,-0.76324],[0.73307,0.27655,0.62139],[0.81451,-0.40592,0.4145],[-0.83479,-0.55005,0.023952],[0.5744,-0.038247,0.81768],[-0.80028,-0.3799,-0.46392],[0.43112,0.90224,0.009945],[0.85952,-0.085605,-0.50388],[-0.55494,0.83181,-0.011656],[0.66884,-0.37021,0.64467],[0.98406,0.11077,0.13915],[0.13985,0.98877,0.052642],[0.66385,-0.46964,-0.58202],[-0.88525,0.044828,0.46296],[0.35224,-0.90367,0.24353],[0.8664,0.051514,-0.49669],[-0.49502,0.71748,0.49008],[0.46445,-0.26152,-0.8461],[-0.84324,-0.10515,-0.52715],[0.66621,-0.0079981,-0.74572],[-0.35357,0.64818,-0.67443],[-0.13547,-0.96552,-0.22231],[0.97721,0.012387,-0.21193],[-0.28533,0.38834,-0.87623],[-0.32941,-0.19178,-0.9245],[-0.8688,-0.028003,0.49437],[0.50244,-0.26075,-0.82435],[0.82786,-0.33326,-0.4512],[0.65505,-0.47686,-0.5861],[-0.42685,-0.43185,-0.79455],[-0.33523,0.04535,0.94104],[-0.83098,-0.54663,0.10328],[0.91084,-0.29822,0.28535],[-0.58852,0.20672,0.78161],[0.78904,-0.39442,-0.47102],[0.13422,0.76021,0.63566],[-0.91976,-0.036185,-0.39082],[0.70269,-0.16885,0.69117],[0.80647,0.049851,-0.58918],[0.54688,-0.78925,0.27929],[0.48835,0.72763,0.48173],[0.45443,-0.20162,-0.86767],[0.22167,-0.25072,0.94234],[0.83931,0.067677,-0.53943],[-0.79239,-0.019454,-0.60971],[0.17248,0.13921,0.97513],[0.67045,-0.46897,-0.57494],[-0.11563,0.73092,-0.6726],[-0.38677,0.69034,-0.61142],[0.56358,0.36468,-0.74121],[-0.34073,-0.16193,-0.92611],[0.58224,-0.37895,-0.7193],[0.83905,-0.12875,0.52861],[0.46171,0.7744,0.43258],[0.46345,-0.66818,-0.58202],[-0.72945,-0.12678,-0.67219],[-0.8434,0.085392,0.53046],[-0.45302,-0.6812,-0.5751],[-0.40442,-0.65593,-0.63734],[-0.3055,-0.088921,0.94803],[-0.82018,-0.31642,-0.47663],[0.15758,-0.37389,0.91399],[0.80599,-0.58896,0.059223],[0.93336,-0.19494,0.30138],[-0.8805,-0.25556,0.39925],[0.83527,0.01908,0.54952],[0.87412,-0.39757,0.279],[-0.76732,0.15781,0.62154],[-0.96619,-0.22183,0.1314],[0.91499,-0.18937,0.35627],[0.1095,-0.10392,0.98854],[-0.59016,-0.28618,0.75486],[0.80042,0.42221,0.42552],[0.69854,0.22743,0.67847],[0.77695,0.021715,0.62919],[-0.025373,0.98683,0.15978],[0.033146,-0.94085,-0.3372],[-0.081859,-0.24816,0.96525],[0.06427,-0.74967,-0.65868],[0.19839,-0.91651,-0.34735],[-0.93948,-0.16236,0.3017],[0.0028963,-0.28503,0.95851],[0.25111,-0.94154,-0.22458],[-0.070142,-0.98148,-0.17827],[0.28348,-0.95759,-0.051545],[0.0055673,-0.056558,0.99838],[0.72829,0.34813,0.59026],[-0.37887,-0.84125,-0.38569],[0.4443,-0.82607,-0.34671],[-0.66182,-0.32315,-0.67644],[0.73362,-0.57797,-0.35743],[0.69159,0.31218,0.65134],[-0.075357,0.97321,0.21721],[-0.42943,-0.31943,0.84472],[0.60273,-0.38852,-0.69697],[-0.90647,-0.22959,-0.35441],[-0.74576,0.2066,0.63337],[-0.89611,-0.36587,-0.25123],[-0.83655,-0.54752,-0.020094],[0.14064,0.041287,0.9892],[0.67579,-0.65619,-0.33575],[-0.94253,0.23602,-0.23651],[0.83979,0.52152,-0.15093],[0.16583,0.81402,0.55666],[0.89794,-0.18395,-0.39983],[-0.76597,0.63589,-0.09457],[0.65823,0.44128,0.60992],[0.53136,0.84714,-0.0044723],[0.7165,-0.59619,-0.3622],[-0.84898,0.015854,-0.52819],[-0.36865,0.92949,0.012083],[-0.19958,0.97939,0.030985],[-0.64565,0.053701,0.76174],[0.67113,0.55797,0.48812],[0.65378,0.46546,0.59659],[0.27167,0.96154,0.04049],[0.081801,-0.98758,-0.13415],[-0.035257,0.99888,0.031532],[0.73732,-0.48299,-0.47231],[0.62272,-0.29837,0.72332],[0.95521,0.040815,-0.29309],[-0.7498,0.28831,-0.59555],[-0.72084,-0.42271,-0.54927],[0.94843,-0.0082845,0.31688],[-0.61917,0.34185,0.70694],[0.8542,-0.51131,-0.09438],[0.21386,-0.13211,0.96789],[0.97449,0.22352,-0.020049],[-0.51339,0.487,-0.70658],[-0.24052,0.8415,0.48377],[0.99487,0.10035,-0.01277],[-0.39159,0.22352,-0.89258],[0.72945,-0.32501,-0.60189],[-0.3317,-0.0015603,-0.94338],[-0.80752,-0.58792,-0.04759],[0.88819,-0.45449,-0.067548],[-0.49662,-0.051459,-0.86644],[-0.92874,-0.0025616,0.37072],[0.58797,0.46284,0.66338],[-0.59495,-0.40728,-0.69293],[-0.68716,-0.16074,-0.7085],[0.84461,-0.44221,-0.3018],[-0.77678,0.055826,-0.62729],[-0.17475,0.88363,0.43436],[0.86012,-0.37396,-0.34693],[0.90265,0.19719,0.38254],[0.80973,-0.0067256,-0.58676],[0.32553,0.58474,0.74304],[-0.78505,0.24697,-0.56808],[0.76249,0.086062,-0.64125],[0.28787,0.64479,0.70808],[-0.79733,0.38058,-0.46842],[-0.15437,0.12863,0.97961],[-0.67353,0.29408,0.67814],[-0.99543,-0.012046,-0.09473],[0.79978,0.03936,-0.59901],[-0.59188,0.50535,0.62793],[-0.79653,-0.40467,-0.4492],[0.39666,0.16693,0.90266],[-0.60394,0.66965,-0.43222],[0.61706,0.62314,0.48055],[0.7408,0.096675,-0.66473],[0.7377,-0.038343,-0.67404],[-0.43736,0.86157,-0.25772],[0.9651,0.095573,0.24382],[-0.92119,0.19095,0.33904],[-0.088591,-0.95686,0.27672],[-0.20643,0.64948,-0.73182],[0.54035,0.67333,0.50463],[0.41029,-0.27382,-0.86988],[-0.24616,0.74332,-0.62199],[-0.56129,0.63251,0.53375],[0.75245,0.59994,-0.27182],[-0.49771,0.1264,-0.85808],[0.66349,-0.398,-0.63354],[-0.4562,0.18573,0.87028],[0.54926,0.44997,0.70416],[0.29967,0.64251,0.70525],[0.7553,-0.53641,-0.37654],[0.70469,-0.64896,-0.28681],[0.75384,-0.47787,-0.45096],[-0.46018,-0.45284,-0.76366],[-0.8947,0.056956,-0.44302],[-0.67108,-0.44793,-0.59077],[-0.65256,-0.71046,0.26346],[-0.8279,-0.55981,-0.034565],[-0.89233,-0.05848,-0.44758],[0.90305,-0.42882,0.024668],[0.72027,-0.31858,-0.61621],[0.95009,-0.22781,0.21314],[-0.89085,0.22135,-0.39672],[0.63848,0.40438,0.65484],[-0.28658,0.9285,0.23613],[-0.55726,0.48476,0.67415],[-0.22594,0.90155,0.36898],[-0.83719,0.45344,-0.30578],[0.90587,0.14026,0.39966],[-0.71121,0.67784,-0.18634],[0.60451,0.38403,0.69791],[-0.27061,-0.79783,-0.53874],[-0.38326,0.92335,-0.022988],[0.16914,0.95125,0.25791],[-0.42655,0.66929,0.60837],[0.91653,0.38052,-0.1232],[0.24244,0.92247,0.30046],[0.3251,0.87172,0.36663],[0.73825,-0.58896,-0.32881],[-0.43772,0.72785,0.52786],[-0.26445,-0.87919,-0.39636],[0.2636,0.62186,0.73743],[0.58581,-0.17807,0.79064],[0.4946,0.72029,0.48636],[-0.26804,-0.91925,-0.28833],[0.20358,-0.55385,-0.80735],[0.17714,-0.95195,-0.24981],[-0.63838,-0.62615,-0.44767],[-0.41318,-0.76817,-0.48907],[-0.78588,0.59993,0.14995],[-0.52326,-0.77133,-0.3623],[0.30418,0.6332,0.71171],[0.45083,-0.86016,-0.23851],[-0.83131,-0.54064,-0.12898],[-0.78901,-0.39294,-0.4723],[0.47066,0.70411,0.5317],[0.8576,-0.41061,-0.30972],[-0.70684,-0.52771,-0.47106],[0.039017,-0.9874,-0.15334],[-0.13379,-0.66562,-0.7342],[-0.77916,-0.32412,-0.53653],[-0.90573,0.2953,-0.30407],[0.85743,-0.40457,-0.31803],[0.75025,-0.5801,-0.31718],[0.11829,-0.99021,-0.074118],[-0.63792,0.41345,0.64971],[-0.42123,-0.57315,-0.70289],[0.13831,0.85187,0.50516],[0.64794,0.42121,0.63463],[-0.55314,0.57639,0.60151],[-0.87146,-0.14677,-0.468],[0.99133,-0.10273,0.0819],[0.17378,0.4938,0.85203],[0.30883,0.4177,0.85449],[0.75357,-0.38899,-0.52992],[0.14189,0.98962,-0.022842],[-0.90433,0.2577,0.34026],[-0.8168,0.072592,-0.57234],[0.18665,0.725,0.66297],[0.99897,0.014191,-0.043207],[-0.15905,-0.56038,-0.81282],[0.8624,0.39402,-0.31782],[-0.72948,0.3776,-0.57033],[0.98713,0.1252,0.09949],[0.112,0.72787,0.67651],[-0.84382,-0.078443,0.53086],[0.98733,0.15587,0.029695],[-0.63754,0.24239,-0.73129],[0.87569,-0.47921,-0.059262],[0.68823,0.62948,0.36068],[-0.73557,-0.02065,-0.67713],[-0.72528,-0.061708,-0.68569],[0.97975,0.12849,0.15353],[-0.98229,0.041449,0.18273],[-0.012409,-0.99871,-0.049228],[-0.61675,0.0032825,0.78715],[0.82626,-0.53935,-0.16246],[-0.72422,0.37617,0.57793],[-0.85227,0.11059,-0.51128],[-0.81723,-0.55412,-0.15839],[0.81998,-0.54305,-0.18092],[0.95091,-0.074666,-0.30033],[-0.14992,-0.77365,-0.61562],[0.92404,0.10494,-0.36762],[-0.69669,0.33166,-0.6361],[0.41528,0.61697,0.6685],[0.023152,-0.79619,-0.6046],[0.97868,0.082252,-0.1882],[0.79583,-0.57571,-0.18763],[-0.4892,0.5464,-0.6798],[-0.010332,-0.99804,-0.061775],[-0.22018,0.43243,0.87437],[0.52089,0.58252,0.62398],[0.89472,-0.34477,-0.28391],[-0.30867,0.67466,-0.67049],[-0.33185,0.71525,-0.61506],[-0.34966,0.056021,0.9352],[-0.44994,0.44314,-0.77536],[0.74326,-0.49263,-0.45265],[-0.50894,-0.25918,-0.82086],[0.73268,0.12685,0.66865],[0.17535,-0.21447,0.96086],[0.65415,-0.65069,-0.3856],[0.9515,-0.30708,-0.018551],[0.85736,-0.3661,-0.3618],[-0.81815,-0.23161,-0.52629],[0.45167,0.63738,0.62429],[-0.59375,0.68797,0.41733],[0.92703,-0.37405,0.026629],[-0.48752,-0.31871,0.81286],[0.51374,-0.60058,0.61268],[0.94877,-0.091684,0.30236],[0.40223,-0.68869,-0.60325],[-0.98229,0.12461,0.13995],[0.58591,-0.70259,-0.40383],[-0.62975,-0.0086528,0.77675],[0.42023,-0.76075,-0.49464],[0.59192,0.69099,0.41493],[-0.11733,0.98311,0.14043],[-0.013186,-0.13733,0.99044],[-0.80035,-0.59259,-0.091005],[0.45331,-0.70091,0.55067],[0.58834,-0.0078454,0.80858],[0.10143,-0.93375,-0.34324],[0.97094,0.20372,0.12559],[-0.1027,-0.92623,-0.3627],[-0.85531,-0.453,-0.25146],[0.21194,-0.91288,-0.3489],[0.42724,-0.79369,-0.43304],[0.4043,-0.77157,-0.49114],[0.45294,-0.78102,-0.42995],[0.86825,0.36371,0.33742],[-0.011409,-0.95292,-0.30301],[-0.21,-0.12321,0.96991],[0.89232,-0.07362,-0.44536],[0.73395,-0.51082,-0.44764],[-0.57723,-0.68952,-0.43746],[-0.94972,0.27669,0.14656],[0.56575,-0.71716,-0.40696],[0.58657,-0.75222,-0.30016],[-0.49348,-0.40694,0.76869],[-0.14627,0.86588,0.4784],[-0.77059,-0.3858,-0.5073],[-0.51138,0.74895,0.42139],[0.76751,-0.63982,-0.03934],[-0.93944,-0.027478,-0.3416],[-0.43009,-0.39185,0.81332],[0.91255,-0.163,-0.37509],[0.94037,-0.32131,0.11169],[0.80814,0.44744,0.38303],[0.97743,-0.16751,0.12875],[-0.54035,0.67653,0.50033],[-0.76626,0.6208,-0.16567],[-0.48216,0.87131,-0.091293],[-0.23314,-0.96996,-0.069499],[0.43777,-0.72799,0.52762],[-0.12237,-0.97313,-0.19504],[-0.50875,-0.13514,0.85024],[-0.951,0.020069,-0.30852],[0.023664,0.72639,0.68688],[-0.094074,0.98935,-0.11105],[-0.96481,0.22463,-0.13666],[-0.085027,0.22015,0.97175],[0.97869,0.17707,-0.10394],[-0.18099,0.0086081,0.98345],[-0.2829,-0.9344,-0.2165],[-0.5749,-0.40907,0.70862],[-0.90148,0.42953,0.05336],[0.99026,0.080303,-0.11372],[0.68413,-0.15573,0.71254],[-0.8895,0.42902,-0.15724],[-0.60696,-0.40531,0.68361],[-0.97203,-0.064524,-0.2258],[0.82742,-0.44534,-0.34212],[0.72476,-0.56001,-0.40139],[-0.95478,-0.14712,-0.25837],[0.25016,-0.2226,0.94227],[0.57389,-0.72423,-0.38228],[0.91203,-0.33667,-0.2342],[-0.42583,-0.89533,-0.13059],[-0.77721,0.25143,-0.57682],[-0.61097,0.73904,0.2838],[0.87102,0.28764,0.39823],[-0.46327,0.6775,0.57129],[0.28738,-0.1304,0.9489],[0.15222,0.50655,0.84867],[0.92587,0.19855,-0.32147],[-0.8058,0.28235,-0.52054],[0.9419,0.25519,-0.21841],[-0.38955,-0.92061,-0.027002],[-0.7026,0.41422,-0.57859],[-0.33107,-0.56647,-0.75465],[0.94206,0.095774,-0.32147],[-0.46704,0.6056,-0.6443],[0.93292,-0.31169,-0.1803],[0.35477,-0.76462,0.53805],[-0.69683,0.65679,0.2882],[0.9215,0.2991,0.24775],[-0.3152,0.53433,-0.78431],[-0.40266,0.28429,-0.87008],[0.71341,-0.63275,-0.30113],[-0.53261,-0.024166,-0.84602],[-0.2929,-0.48313,-0.82511],[0.75472,-0.48091,-0.44622],[0.84973,-0.36125,-0.38401],[-0.48288,-0.14139,0.8642],[-0.70657,0.65931,0.25704],[-0.44903,-0.88524,-0.12131],[0.95962,-0.17566,-0.2197],[-0.8856,-0.0032423,-0.46443],[-0.34303,-0.55056,-0.76106],[0.48992,-0.49369,-0.7185],[0.99759,-0.065072,0.024044],[-0.62165,0.56065,0.54702],[-0.85558,0.3875,-0.34326],[-0.78568,0.54029,-0.30132],[0.89181,0.41322,0.18419],[0.18696,0.42884,0.88382],[0.92848,0.34152,0.14588],[-0.66815,0.61809,0.41417],[-0.72056,0.28517,0.63204],[-0.68885,0.68201,-0.24565],[-0.87567,0.47565,0.083413],[0.93676,0.23293,0.26119],[0.43545,0.87857,0.19621],[-0.50788,0.85489,-0.10592],[0.11848,0.97093,0.20799],[-0.87727,0.0062029,-0.47995],[0.31551,-0.52362,-0.79138],[0.016086,-0.902,-0.43143],[-0.35316,-0.35429,0.86589],[-0.70339,0.56116,0.43628],[0.48541,-0.80849,-0.33276],[-0.95891,-0.12586,-0.25428],[0.91278,0.2194,0.34452],[-0.47449,-0.87125,-0.12564],[-0.95743,0.13019,-0.25765],[-0.44407,-0.31063,0.84042],[0.70256,-0.30907,-0.641],[-0.63982,0.65404,0.40356],[-0.29978,-0.86793,-0.39602],[0.33682,-0.93449,-0.11526],[0.53935,-0.84196,-0.014596],[0.30278,-0.78694,0.53763],[0.9844,0.14525,0.099255],[0.93856,0.20713,0.27606],[-0.77731,-0.56684,-0.27293],[-0.69825,0.6605,0.27602],[-0.87086,0.45762,0.17938],[0.63998,-0.15836,0.7519],[-0.86237,-0.027559,-0.50553],[-0.9054,-0.42455,0.0026597],[-0.87459,0.33742,-0.3482],[0.86356,0.37043,-0.34212],[-0.98748,-0.15323,-0.037368],[0.98887,-0.10921,0.10103],[0.65656,0.73237,-0.18045],[-0.68035,-0.73109,-0.05127],[-0.42129,-0.50145,0.75569],[0.39947,0.91647,-0.022579],[-0.9954,0.058568,0.075868],[0.99512,-0.077566,0.060997],[-0.351,0.92119,-0.16797],[0.31417,-0.74857,0.5839],[-0.83296,0.27566,0.47977],[0.33151,0.93093,-0.1532],[0.035839,-0.16888,0.98498],[0.92967,-0.0074019,-0.36833],[-0.91271,0.40532,-0.051697],[0.94368,0.1518,-0.29399],[-0.92068,0.3882,0.040666],[0.88357,-0.22686,-0.40968],[-0.99921,0.037249,-0.014203],[0.9023,0.28235,0.32577],[-0.44627,-0.40759,-0.79669],[-0.98282,-0.16501,-0.082718],[0.71496,-0.56047,-0.41798],[-0.99969,-0.017833,0.017371],[0.51025,-0.82952,-0.22703],[0.83879,-0.29707,-0.45627],[-0.5727,0.6543,0.49387],[-0.76836,-0.12871,0.62695],[0.28534,0.31121,0.9065],[0.88685,0.34717,0.30491],[-0.98006,0.16628,-0.10875],[-0.61712,0.61799,0.48709],[0.9363,-0.018338,-0.35073],[-0.92507,0.36297,-0.11179],[-0.75083,-0.65998,0.026091],[0.56325,-0.30001,0.7699],[-0.80946,0.5729,-0.12866],[0.92137,0.27869,0.27093],[-0.58551,0.70218,-0.40511],[-0.93394,0.34093,-0.10736],[0.53754,-0.5133,-0.66901],[-0.6157,0.56003,-0.55432],[0.57864,-0.43555,0.68955],[0.88343,0.26589,0.38581],[0.75053,-0.60532,-0.26514],[0.47608,-0.87168,-0.11627],[-0.56515,0.21986,-0.79515],[-0.44849,-0.77449,0.44612],[-0.64493,-0.078814,-0.76016],[-0.55448,-0.56088,0.61479],[0.40187,-0.67302,0.62092],[-0.88027,0.46001,0.11627],[0.90922,-0.20534,-0.36216],[0.90519,0.29814,0.3029],[-0.73202,0.022216,-0.68092],[-0.65396,0.3606,0.66506],[0.98515,0.16413,-0.050328],[0.91159,0.019504,-0.41065],[-0.94345,0.30092,-0.13911],[-0.89477,0.27,0.35566],[-0.82754,0.2066,-0.52201],[0.38761,-0.6731,0.62983],[0.99923,-0.0088229,0.038287],[0.24298,0.39892,0.88421],[-0.87189,0.037163,-0.48829],[0.69814,0.09456,0.70969],[0.95376,0.19316,0.23028],[0.23321,0.96464,0.12277],[0.48185,-0.87461,0.053714],[0.75861,0.65154,-0.00187],[0.075441,0.99633,0.040399],[-0.95492,-0.16058,0.24966],[0.09006,-0.1138,0.98941],[-0.13502,-0.80189,-0.58202],[-0.1787,-0.96807,0.17582],[-0.83426,-0.5236,0.17278],[0.080971,-0.86166,-0.50098],[0.27726,-0.73066,-0.6239],[0.88614,0.33964,0.31526],[-0.96226,-0.20711,0.17653],[-0.97341,-0.16458,0.15932],[-0.049156,-0.99524,0.084178],[-0.44524,-0.53889,-0.7151],[-0.5289,-0.38997,0.75378],[0.50709,-0.40071,-0.76308],[0.21562,-0.95631,0.19742],[-0.6987,-0.70522,0.12033],[0.71753,0.53622,0.44455],[-0.40601,-0.90675,0.11381],[0.17765,-0.97842,0.10552],[0.40017,-0.91617,0.022154],[-0.57838,-0.29739,-0.75962],[-0.21865,0.30772,0.92601],[0.63462,-0.76932,-0.073562],[0.76593,-0.62831,0.13632],[-0.58494,-0.058091,-0.80899],[-0.24991,-0.94789,0.19763],[0.7242,-0.27335,-0.6331],[-0.32287,-0.70324,-0.63341],[0.17008,-0.91835,0.35737],[0.14931,-0.92214,0.35689],[0.47364,0.36495,0.80155],[-0.66054,0.19789,-0.72425],[0.015261,-0.83168,-0.55504],[0.73308,0.067104,-0.67683],[-0.97401,-0.21914,-0.057278],[0.87475,-0.48159,0.053679],[-0.92256,0.18963,0.33605],[0.91569,-0.2749,-0.29315],[0.62308,0.70748,0.33354],[-0.9939,-0.005006,0.11013],[-0.82751,0.46521,0.31432],[-0.58139,0.51542,0.62955],[0.69071,0.56899,0.44628],[-0.072798,0.84771,-0.52545],[0.75083,0.092584,0.65397],[-0.14383,0.35326,0.9244],[-0.97528,0.21172,0.063255],[0.81888,-0.21904,-0.53053],[-0.65492,-0.66477,0.35938],[0.14818,0.93166,-0.33174],[0.93565,0.34816,-0.057878],[-0.6793,0.66891,0.30185],[0.87582,0.13778,-0.46255],[0.90425,0.11275,-0.41184],[0.9246,0.21662,0.31336],[0.090728,0.031941,0.99536],[-0.30466,-0.89881,0.31517],[0.75055,-0.49497,-0.43781],[-0.99964,0.019822,0.017873],[0.21048,-0.87678,0.43238],[0.88819,-0.12853,-0.44114],[-0.97935,0.18492,-0.081741],[0.94182,0.14103,-0.30508],[-0.236,-0.93633,0.25999],[-0.91419,0.37629,-0.15057],[0.11367,-0.099736,0.9885],[-0.87827,0.47618,-0.043506],[0.25046,-0.67543,-0.69358],[0.18083,-0.18586,0.96579],[-0.28248,-0.91065,0.30155],[-0.77272,0.63387,-0.033239],[0.054264,-0.99568,-0.075302],[-0.72832,-0.055969,0.68295],[0.90249,0.22658,-0.3663],[-0.40823,-0.49377,-0.76781],[0.80012,-0.51482,-0.30785],[-0.90424,0.2472,-0.34821],[-0.73006,-0.022431,-0.68301],[-0.87637,0.46614,-0.12116],[0.13368,-0.88156,0.45275],[-0.69179,0.66305,0.286],[0.67229,-0.12911,0.72895],[0.36089,-0.51188,-0.77957],[0.97864,-0.0045875,0.20554],[0.86753,-0.05306,-0.49454],[-0.73443,0.37318,-0.56688],[0.84472,0.11232,-0.52329],[0.056105,-0.12954,0.98999],[0.44445,-0.43461,-0.78331],[0.076377,-0.37621,0.92338],[0.90511,0.40965,-0.11388],[0.72537,0.59911,-0.33898],[-0.71058,-0.61722,-0.33781],[-0.79499,0.49448,0.3514],[0.98096,-0.02226,0.19294],[0.34193,0.92344,-0.1742],[-0.084088,0.98651,-0.14045],[-0.23175,-0.6678,-0.70734],[-0.86334,0.21675,-0.4557],[-0.89349,0.34893,0.2827],[-0.021036,-0.84936,-0.5274],[0.74302,-0.35044,-0.57019],[-0.95367,0.29988,0.024191],[0.066426,-0.91926,-0.38801],[-0.49929,-0.35956,-0.7883],[-0.0043409,-0.8297,-0.55819],[0.23349,-0.61807,-0.75065],[0.11764,-0.70262,-0.70177],[-0.84983,0.50974,-0.13399],[-0.52918,-0.67779,0.51046],[-0.47278,-0.36218,-0.80331],[0.3086,-0.53198,-0.78852],[-0.26307,0.89002,0.37238],[-0.48008,-0.29841,-0.82491],[-0.12319,-0.65096,-0.74905],[-0.90741,0.21922,0.35855],[0.97086,-0.042991,0.23574],[0.8987,-0.4212,-0.12216],[-0.26131,-0.52015,-0.81312],[-0.059335,-0.98394,0.16832],[0.11976,-0.97816,0.16986],[-0.94242,-0.14178,0.3029],[0.69433,0.18607,0.69518],[0.97199,-0.0087771,0.23487],[-0.96044,-0.10387,0.25841],[0.56681,-0.11965,-0.81511],[-0.76843,0.63506,-0.078819],[-0.54864,-0.83464,0.048612],[0.71188,-0.61918,-0.33142],[-0.78991,-0.6131,0.012302],[0.65724,-0.73404,0.17094],[0.82455,0.5235,-0.2146],[0.61247,0.20194,-0.76426],[-0.65165,-0.7126,0.2599],[0.78454,-0.43222,-0.44463],[-0.61145,0.49679,-0.61589],[0.66608,0.19362,0.72031],[0.60147,0.46453,-0.64996],[-0.52725,0.45647,-0.71669],[-0.71212,-0.29378,0.63763],[-0.57303,0.74009,-0.35201],[0.37465,-0.18509,0.9085],[0.64121,0.74817,-0.17055],[-0.7799,0.6259,-0.0012829],[0.36761,0.89311,-0.25926],[0.6896,0.72009,-0.07698],[-0.93013,-0.085478,-0.35715],[-0.95479,0.16208,0.24923],[-0.45599,0.8369,-0.30278],[-0.74158,-0.047884,0.66915],[0.92907,0.095165,0.35745],[0.48383,0.77076,-0.41454],[0.86189,-0.098192,-0.49749],[-0.36513,0.73713,-0.56861],[-0.92074,0.33189,0.20515],[-0.90441,0.41254,-0.10887],[0.87731,-0.067507,0.47516],[-0.61977,-0.30559,0.72284],[0.26329,0.79948,-0.53991],[0.86076,0.48432,-0.15659],[-0.82979,0.15798,-0.53525],[0.68547,-0.19526,0.70143],[-0.11798,0.7842,-0.60919],[-0.89787,0.32918,0.29234],[0.87007,-0.31516,0.37903],[0.79601,-0.46092,0.39232],[0.69453,0.1103,0.71096],[0.94357,0.216,-0.25105],[-0.78404,0.43369,-0.44407],[0.94066,0.26031,-0.2177],[0.91266,-0.24829,-0.32466],[-0.95736,-0.064611,-0.28157],[-0.90615,0.41802,-0.064357],[0.70773,-0.64975,-0.27737],[0.79671,-0.46762,0.38287],[-0.94536,0.19703,-0.25976],[0.15902,-0.1726,0.97207],[-0.89848,0.29183,0.32799],[-0.89877,-0.042518,-0.43636],[-0.80637,0.5908,0.026953],[0.81948,0.48109,-0.31145],[0.92644,-0.20047,0.31861],[-0.93125,-0.13718,0.33758],[0.96247,0.11329,0.24663],[-0.80683,0.37687,-0.45497],[-0.84695,-0.42766,0.31589],[0.088726,-0.42005,0.90315],[-0.74629,0.37674,0.54874],[-0.40022,-0.33321,-0.85369],[0.93665,0.21506,-0.27648],[-0.89753,-0.33713,0.28423],[0.77552,-0.45028,-0.44251],[-0.74882,0.63824,-0.17866],[-0.81334,0.54746,-0.19689],[-0.39294,-0.25126,-0.88457],[0.70574,-0.5424,-0.45579],[-0.74552,0.66515,0.042118],[0.6874,-0.37999,0.61894],[0.95427,0.11026,0.27788],[-0.92144,-0.22953,-0.31347],[-0.61115,0.72601,0.31528],[0.65097,-0.43172,0.62439],[0.87646,-0.37664,-0.29993],[0.78813,0.60455,-0.11562],[-0.90061,-0.062885,-0.43005],[0.95685,-0.19134,-0.21869],[-0.76792,0.22337,-0.60033],[0.61187,-0.46176,-0.64218],[0.93924,-0.14947,-0.309],[0.38721,0.58991,0.70857],[0.81936,0.09523,-0.56532],[-0.7405,0.34003,0.57968],[-0.60803,0.52084,-0.59919],[-0.91914,-0.20984,-0.33338],[0.13794,0.15287,0.97857],[0.6838,0.36524,-0.63168],[-0.95677,0.021089,0.29009],[0.93208,0.26351,0.24858],[0.76845,-0.43861,-0.46594],[0.95671,-0.14901,0.25],[0.79625,-0.42832,-0.42723],[-0.10893,-0.40063,-0.90974],[-0.61485,0.78119,0.10813],[-0.53068,0.66998,-0.51915],[-0.92454,0.32667,0.19627],[-0.26869,0.88388,-0.38285],[0.59666,-0.53147,0.60128],[0.15705,0.93428,-0.3201],[0.33957,0.77698,-0.53009],[-0.20075,-0.19267,-0.96051],[0.69041,-0.5173,0.5057],[0.69765,0.71537,0.039099],[0.10707,-0.37947,-0.91899],[0.91644,0.26699,-0.29807],[-0.31262,0.00065667,-0.94988],[0.95055,-0.17783,0.25462],[-0.55973,0.8265,-0.06005],[0.55032,-0.55168,-0.62674],[-0.72696,0.063875,0.6837],[-0.2818,0.056956,-0.95778],[0.07247,-0.19752,-0.97762],[0.66557,0.74263,0.074366],[-0.9561,0.096746,-0.2766],[-0.42278,0.37026,-0.82714],[0.71708,0.69664,-0.021937],[-0.27551,0.22181,-0.93536],[0.13956,-0.061936,-0.98827],[0.3846,-0.042448,-0.92211],[0.76369,-0.18783,-0.61766],[-0.82817,0.54694,0.12246],[-0.092055,0.41916,-0.90324],[0.35748,0.38381,-0.85141],[0.75608,0.35376,-0.55063],[-0.35586,0.54931,-0.75606],[-0.11448,0.24262,0.96334],[-0.84787,0.5118,0.13849],[-0.076236,0.78719,-0.61198],[-0.16177,-0.76829,-0.61932],[-0.58868,-0.30262,0.74959],[-0.78248,0.62186,-0.031835],[0.8896,0.45513,-0.038484],[-0.83463,0.54498,-0.079935],[-0.95211,0.21717,0.21524],[-0.51696,-0.3591,0.77704],[0.984,0.053326,0.17001],[-0.95022,-0.10568,0.2931],[-0.039954,-0.79079,-0.61078],[-0.00065187,-0.15432,0.98802],[0.11824,-0.66258,-0.7396],[0.54927,0.43815,0.71157],[-0.39175,-0.58617,-0.70918],[-0.72674,0.68674,-0.015501],[-0.92038,-0.24928,0.30125],[0.98911,0.097354,0.11037],[0.7616,0.64578,0.054054],[-0.070965,-0.92348,-0.37702],[-0.070408,-0.35089,-0.93377],[0.3156,-0.53954,-0.78057],[0.78639,-0.38298,0.48468],[0.44807,-0.37927,-0.80956],[-0.55571,-0.43896,-0.70605],[0.70263,-0.075855,0.7075],[0.28356,0.77956,0.55846],[0.98512,-0.036332,0.16796],[-0.57749,-0.25594,-0.77524],[-0.33531,-0.12539,-0.93373],[0.6687,-0.31047,-0.67561],[-0.8864,-0.41683,-0.20137],[0.55064,-0.24758,-0.79718],[-0.88964,-0.26133,0.3745],[-0.34987,-0.93659,-0.019824],[0.089881,-0.98357,-0.15657],[0.14547,-0.96412,-0.22205],[0.42688,-0.85475,-0.29526],[0.97,-0.17201,0.17179],[-0.58657,0.808,-0.055403],[0.012586,-0.99968,0.022122],[0.58866,-0.72562,-0.35629],[-0.61391,-0.48232,0.62488],[0.13774,0.033595,0.9899],[-0.70869,0.66992,0.22128],[-0.61707,-0.017449,-0.78671],[-0.60829,0.75173,0.25473],[0.92298,0.1826,-0.33878],[-0.5796,0.23648,-0.77983],[0.89384,-0.3802,0.23769],[-0.83329,-0.39087,-0.39097],[-0.31573,0.94335,-0.10204],[0.57222,0.48927,-0.65816],[0.60643,0.79444,-0.033286],[-0.91684,-0.17785,-0.35745],[0.77935,-0.48821,-0.39278],[-0.86272,-0.35688,0.35827],[-0.0065394,-0.99902,-0.043759],[-0.39093,0.71091,-0.58463],[0.49191,0.71553,-0.49602],[0.82474,-0.48533,0.29027],[0.8236,-0.29175,-0.48637],[-0.39332,0.727,-0.56282],[-0.26418,0.93741,-0.22687],[-0.79693,-0.51712,0.31223],[-0.26296,0.8872,-0.3791],[-0.5474,0.14595,0.82404],[0.30451,0.89293,-0.33158],[-0.62471,0.64102,-0.4459],[-0.45806,0.85508,-0.24294],[-0.33545,-0.47172,0.81545],[0.33258,0.88846,-0.31628],[0.25861,0.96582,-0.017717],[0.94533,-0.066133,-0.31935],[0.0065334,-0.81039,-0.58586],[0.31008,0.8103,-0.49726],[-0.89395,0.013028,-0.44798],[0.95992,0.19518,-0.20113],[-0.36967,0.76186,-0.53189],[0.34237,0.93947,0.0132],[0.78273,-0.51853,0.34419],[0.13279,0.81352,-0.56617],[-0.73297,-0.22478,0.64205],[-0.78401,0.31588,-0.53436],[-0.77634,-0.55606,0.2968],[-0.71868,0.41608,-0.55711],[-0.05243,-0.39399,-0.91762],[-0.42605,0.86705,-0.25826],[0.54365,0.83682,-0.064578],[-0.65243,0.53012,-0.54158],[-0.69633,0.54021,-0.47255],[0.76732,-0.59931,0.22814],[0.88821,-0.38512,-0.25055],[-0.59702,0.23272,0.76773],[-0.91061,0.049636,-0.41029],[0.6508,-0.69412,-0.30766],[-0.897,-0.23354,-0.37531],[-0.75707,-0.59043,0.27971],[0.14726,0.27218,0.95091],[0.78519,-0.56129,-0.26159],[-0.48906,0.81196,-0.31866],[-0.049486,-0.47138,-0.88054],[0.91043,-0.30666,-0.27762],[0.18683,-0.32404,0.92741],[0.96405,-0.081591,-0.2529],[0.82386,-0.32593,0.4637],[-0.80489,0.1337,-0.57817],[-0.85113,0.1215,-0.51071],[0.62557,0.78016,-0.0036295],[-0.25118,-0.48454,-0.83793],[-0.823,0.40843,-0.39479],[0.56678,0.82329,-0.03103],[0.35372,-0.93493,-0.027902],[-0.80326,0.44811,-0.39239],[0.79871,-0.37309,-0.47209],[-0.70619,0.15268,0.69136],[-0.85994,0.061515,-0.50667],[-0.75608,0.55141,-0.35255],[0.64169,-0.54366,-0.54099],[-0.099265,0.10967,0.989],[-0.94381,-0.32249,-0.072215],[-0.40403,-0.3392,0.84953],[0.76362,-0.44681,-0.4661],[-0.95573,-0.0003732,-0.29423],[0.233,-0.9705,-0.061964],[0.86743,-0.27482,-0.41478],[-0.90487,-0.15507,-0.39645],[-0.98808,0.012076,-0.15347],[0.24974,-0.96711,-0.048162],[-0.97348,0.13703,-0.18318],[0.93508,-0.2196,-0.27821],[-0.79422,0.30589,-0.52501],[0.99081,-0.051613,-0.12503],[-0.22215,0.46803,0.85534],[0.23165,-0.10697,0.9669],[-0.70047,0.40505,-0.5876],[0.91068,0.2945,-0.28971],[-0.4156,-0.37785,-0.82735],[-0.59715,0.61296,-0.5174],[0.55437,0.71168,-0.43148],[-0.83835,0.46858,-0.27859],[0.80157,0.59697,0.03334],[0.026875,-0.1673,0.98554],[-0.31655,-0.29054,-0.90298],[0.78459,-0.28487,0.5507],[-0.32859,0.71313,-0.61925],[0.53955,0.8419,-0.0098316],[-0.026829,0.84498,-0.53413],[0.058007,0.82452,-0.56285],[0.12083,0.79006,-0.601],[0.6818,-0.72657,0.085186],[-0.28745,-0.28728,-0.9137],[0.92707,0.35527,-0.1197],[-0.031754,-0.44866,-0.89314],[-0.21471,-0.2424,-0.94612],[0.10538,-0.4948,-0.8626],[0.45389,-0.65634,-0.60267],[-0.47902,-0.049821,-0.87639],[0.54373,0.6688,0.50701],[0.4149,-0.62215,-0.66392],[-0.40655,0.036329,-0.91291],[0.63336,-0.67385,-0.3805],[-0.4624,0.17131,-0.86997],[-0.75471,-0.21806,0.61876],[0.017263,0.37372,0.92738],[0.77547,-0.5803,-0.24881],[0.98309,0.14746,0.1086],[0.93527,-0.31273,0.16573],[-0.46332,0.71452,-0.52421],[-0.29174,0.87008,-0.3973],[-0.67347,-0.71156,0.2003],[0.35352,0.71691,-0.60088],[0.49664,0.86233,-0.098644],[0.0077512,0.99362,-0.11247],[-0.85606,0.48143,-0.18812],[-0.062941,-0.86568,-0.49662],[0.14825,-0.7446,-0.65084],[0.91049,0.24375,0.33406],[0.48508,0.77714,0.40094],[-0.38576,-0.73331,-0.55987],[-0.41311,-0.90965,0.043375],[0.098942,0.90789,0.40736],[-0.21849,-0.83133,-0.51104],[-0.78532,0.57731,0.22356],[0.082866,-0.94809,-0.30702],[0.058851,-0.96841,-0.2423],[0.018561,-0.93872,-0.34418],[-0.15452,-0.93325,-0.32429],[-0.62525,0.65392,0.42596],[-0.67414,0.65318,0.34481],[0.88957,0.33891,0.30627],[0.64233,-0.25156,0.72397],[0.9013,0.38656,-0.19553],[-0.77137,0.6269,-0.10953],[-0.37887,-0.92545,-0.00075794],[-0.3377,-0.79157,-0.50929],[0.024125,-0.92883,-0.36971],[-0.013458,-0.33351,0.94265],[-0.66128,-0.2515,0.70672],[0.73751,-0.16423,-0.65507],[-0.5094,-0.71536,-0.4783],[-0.39197,-0.91968,0.023341],[0.1029,-0.96016,-0.25982],[0.242,-0.93027,-0.27573],[-0.61329,0.78048,-0.12135],[-0.93239,-0.27808,-0.23091],[0.53523,-0.82098,-0.1988],[0.88998,0.34555,0.29753],[-0.5041,-0.79612,-0.33478],[0.83141,0.54143,-0.12494],[-0.57766,0.80488,-0.13591],[0.62762,0.020625,-0.77825],[-0.8217,-0.50349,-0.26702],[-0.020275,-0.33546,0.94184],[-0.69784,0.22768,-0.67911],[-0.85916,-0.4606,0.22292],[0.76748,-0.25091,0.58992],[-0.94909,-0.12951,-0.28714],[-0.2548,-0.31775,-0.9133],[-0.58247,-0.80667,0.10005],[-0.61001,0.42773,-0.66703],[0.62816,-0.75672,0.18108],[0.9665,-0.20068,0.15999],[0.37963,-0.30839,0.87222],[-0.17654,0.94228,0.28451],[-0.79338,0.58919,-0.15298],[-0.48709,0.60328,-0.6315],[0.88866,-0.45823,0.017729],[-0.25861,-0.95965,0.1104],[0.97199,-0.0060412,0.23496],[0.94758,-0.22704,-0.22481],[0.50599,0.045667,0.86133],[-0.28745,0.8182,-0.49792],[0.35423,-0.31169,0.88169],[-0.31985,0.86895,-0.37765],[-0.92581,-0.23427,-0.29663],[-0.69858,0.59977,-0.3902],[-0.93092,0.11116,0.34789],[0.59173,0.68569,-0.4239],[-0.75691,-0.2351,0.60977],[0.98341,0.033575,-0.17825],[0.60906,0.77472,-0.16985],[-0.67543,0.61972,-0.39968],[-0.68748,-0.68629,-0.23743],[0.44675,-0.5858,-0.67621],[0.5424,0.7934,-0.27627],[0.074161,0.90303,-0.42314],[0.47893,-0.33559,0.81118],[0.93806,0.30143,-0.17084],[-0.64389,0.71124,0.28205],[0.96714,0.0077945,-0.25412],[0.33382,0.21244,0.91839],[0.91567,-0.39882,-0.049976],[0.28314,-0.3034,0.90982],[-0.75119,0.089581,0.65398],[-0.79823,-0.23477,0.55473],[-0.93557,-0.039107,-0.35096],[-0.91358,0.17745,0.36589],[0.69708,-0.66303,-0.27288],[-0.45561,0.84006,0.29448],[-0.93459,-0.1954,0.29725],[-0.84595,-0.19537,-0.49618],[0.97062,-0.15975,-0.17994],[0.98418,-0.14398,-0.10324],[-0.82365,0.37101,-0.4289],[0.95007,0.28588,-0.12505],[-0.78984,0.47086,-0.393],[0.87928,0.15304,-0.45104],[0.96223,0.19001,-0.19493],[0.82016,-0.44246,-0.36272],[-0.78568,-0.60825,0.1129],[-0.81045,-0.55494,0.18764],[-0.76914,0.53773,-0.34535],[-0.84503,-0.52337,0.1096],[0.71452,-0.56292,-0.41544],[-0.95386,0.14186,-0.26464],[0.99163,-0.07144,-0.10758],[-0.070723,0.24774,0.96624],[0.77695,-0.40435,-0.48255],[-0.70059,0.65285,-0.28804],[-0.80681,0.40455,-0.43057],[-0.89277,-0.32514,0.31185],[-0.81884,-0.051521,-0.5717],[0.88221,-0.0724,-0.46526],[-0.64484,-0.2241,-0.73072],[-0.92546,-0.32619,0.19269],[-0.86294,0.088838,-0.49743],[0.92773,-0.10603,-0.35786],[0.99636,-0.077417,-0.035612],[-0.28792,-0.29701,-0.91043],[0.73982,-0.26526,0.61831],[0.98547,0.0046084,0.16976],[-0.93663,0.29298,-0.19204],[0.96963,0.18781,0.15664],[-0.73573,0.49403,-0.46328],[0.81059,0.56098,0.16805],[0.89909,0.33597,0.28064],[0.52997,-0.33666,-0.77832],[-0.44827,0.799,-0.40083],[-0.87083,0.45632,-0.18284],[-0.92757,-0.29342,0.23136],[-0.15868,0.82582,-0.54115],[-0.10876,0.80599,-0.58185],[0.90412,0.11073,-0.41268],[0.79808,-0.60163,-0.033216],[-0.96519,-0.23698,-0.11065],[0.2408,0.84168,-0.4833],[-0.78788,-0.078425,0.61082],[0.57769,0.80831,-0.11362],[-0.035663,0.82056,-0.57045],[0.95004,-0.054934,-0.30726],[0.11444,0.83087,-0.54457],[-0.66085,-0.037921,0.74956],[-0.14945,-0.43147,-0.88966],[0.23337,-0.56804,-0.78922],[0.53884,-0.47672,-0.69454],[-0.95662,0.19109,-0.21992],[0.42701,-0.17529,0.88709],[0.58424,-0.62065,-0.52292],[0.67739,-0.22084,-0.70169],[0.98695,-0.010705,-0.16068],[0.60735,0.033021,0.79375],[-0.93926,0.26135,-0.22245],[-0.57125,0.03083,-0.8202],[0.69666,-0.26632,-0.66613],[0.72746,-0.34758,-0.59159],[0.70784,-0.6498,-0.27699],[-0.57624,0.16825,-0.79977],[-0.60623,-0.2312,0.76094],[-0.90056,-0.15172,-0.4074],[-0.94003,0.26292,-0.2173],[0.91708,-0.20801,0.34013],[-0.58994,0.5255,-0.61304],[0.90444,-0.2683,0.33168],[0.75967,-0.14919,-0.63296],[-0.28551,0.94978,-0.12804],[-0.76238,0.14712,0.63019],[0.7404,0.36685,0.56323],[0.32097,0.83586,0.44533],[-0.12313,0.99109,0.050715],[0.2312,0.83969,0.4914],[-0.94499,-0.274,0.17866],[-0.93695,0.27658,-0.2136],[-0.16316,-0.97018,-0.17927],[-0.044216,-0.95355,-0.29798],[0.25469,-0.85432,-0.45307],[0.35515,-0.668,-0.65395],[0.12028,-0.37612,0.91873],[-0.075384,-0.93467,-0.34744],[0.7669,-0.079973,-0.63677],[-0.0033788,-0.9774,-0.21136],[-0.026454,-0.92581,-0.37706],[-0.14836,-0.97206,-0.18191],[0.53579,-0.42737,-0.7282],[0.18482,-0.40262,0.89652],[0.86073,-0.2283,0.45499],[0.64395,-0.33936,-0.68569],[-0.49313,-0.083351,-0.86595],[-0.11945,-0.80923,-0.57522],[0.25719,-0.9204,-0.29447],[-0.48673,-0.37503,0.78895],[-0.61503,-0.08843,0.78353],[-0.95934,-0.27715,-0.053417],[0.81497,0.014067,-0.57934],[0.76208,-0.27901,0.58428],[-0.60959,-0.72374,-0.32343],[0.40113,-0.91599,-0.0073811],[0.90143,-0.21624,0.37506],[-0.67305,0.00604,-0.73957],[-0.91529,0.36193,-0.17677],[-0.9495,-0.23909,0.2032],[-0.59319,-0.73239,-0.33426],[-0.96588,0.24976,-0.068518],[0.67393,-0.4497,-0.58617],[0.7052,-0.64091,-0.30319],[0.72467,0.15574,-0.67127],[0.64972,-0.21099,-0.73031],[0.89531,-0.13064,0.42586],[-0.12131,0.0728,0.98994],[0.90703,-0.2058,-0.36735],[-0.65844,0.012091,-0.75253],[-0.79019,-0.26161,0.55423],[-0.94276,-0.32283,-0.083592],[-0.97362,-0.19917,0.11134],[0.86683,-0.21268,0.45097],[0.58549,0.60698,-0.53738],[-0.9602,-0.20102,-0.19392],[0.86136,-0.48821,-0.14041],[-0.99335,-0.0047547,-0.11504],[0.39353,-0.27254,0.87798],[-0.93034,0.32371,-0.1723],[-0.3495,0.76605,-0.53946],[0.0056741,0.52898,0.84861],[0.95135,0.28556,-0.1157],[-0.17713,0.89283,-0.41411],[-0.80381,-0.19622,0.5616],[0.58332,0.70319,-0.40653],[0.97054,-0.031163,-0.23892],[-0.9412,0.30487,-0.14557],[-0.98606,-0.11006,-0.1248],[-0.98606,-0.16506,0.021232],[0.93473,-0.22738,0.27308],[0.97829,-0.15615,-0.13626],[-0.98815,-0.1293,-0.082722],[-0.97782,0.16627,-0.1274],[0.95438,0.25422,-0.15665],[0.90087,-0.30666,0.30725],[0.6997,-0.22139,0.67927],[0.95881,-0.2342,0.16072],[-0.79791,0.54927,-0.24827],[-0.99475,0.090327,0.048151],[0.15268,-0.007053,0.98825],[0.75617,-0.59797,-0.26578],[0.81426,-0.36648,-0.4502],[-0.96873,-0.2349,-0.079917],[-0.84563,0.43303,-0.31209],[0.83338,-0.55096,-0.043715],[-0.52452,-0.62971,0.57302],[-0.89944,-0.26322,-0.34889],[-0.9248,-0.27592,-0.26194],[0.92647,-0.32654,-0.18716],[-0.97984,0.18592,0.073156],[-0.9334,0.026885,-0.35783],[-0.87336,0.12188,-0.47157],[0.98567,0.10092,-0.13518],[0.96879,-0.2368,-0.073317],[-0.81542,-0.21013,0.53938],[0.71711,-0.27891,0.63872],[-0.92288,-0.38177,0.050362],[0.82392,-0.56411,-0.054271],[-0.82944,-0.15604,0.53635],[-0.9354,-0.34704,0.067708],[-0.74825,0.5877,-0.30779],[-0.95407,-0.28073,0.1046],[0.88643,-0.46277,-0.0091513],[-0.81164,-0.58315,0.034384],[-0.89786,-0.44029,0.00022195],[0.95651,-0.25914,-0.13395],[-0.91845,-0.39289,-0.045657],[-0.28308,0.91058,0.30117],[0.98843,-0.037897,0.14686],[0.88691,-0.24406,-0.3922],[0.72227,-0.25283,0.64373],[0.20655,0.78472,0.58442],[0.95001,-0.050835,-0.30805],[-0.8666,0.1815,-0.46483],[0.97235,0.10288,-0.20964],[-0.94548,0.23201,-0.22856],[0.97368,0.16614,0.156],[-0.93131,0.3503,-0.099768],[-0.85571,0.51602,-0.038397],[0.91073,0.275,0.30813],[-0.77517,-0.62135,0.11418],[-0.31478,-0.0010244,0.94916],[-0.47446,0.8698,0.13539],[-0.20652,0.96227,-0.17717],[0.89387,-0.44833,-0.00024735],[0.28386,0.95078,-0.12428],[0.97764,-0.20402,0.050988],[0.077875,0.98031,-0.18147],[-0.18382,-0.2953,-0.93756],[-0.083853,-0.39538,-0.91468],[0.16507,-0.49466,-0.85326],[-0.94876,-0.29296,-0.11845],[-0.43851,-0.12322,-0.89024],[-0.37553,-0.22221,-0.89978],[0.71322,0.65303,0.2547],[0.42099,-0.58624,-0.69216],[0.49797,-0.5978,-0.62822],[-0.8567,-0.094245,0.50713],[0.78289,-0.15421,0.60275],[0.70388,-0.55771,-0.43989],[-0.53299,-0.044708,-0.84494],[0.8868,-0.46209,0.0075122],[0.72408,-0.59817,-0.34337],[-0.78957,-0.60851,0.079317],[0.87944,-0.47591,-0.0098628],[-0.60026,-0.37873,0.70445],[0.83138,-0.54025,-0.13016],[-0.67763,0.23381,-0.69724],[0.85875,-0.51235,0.0073505],[-0.79878,-0.5925,0.1044],[-0.68688,0.46012,-0.56257],[-0.8546,-0.1586,0.49447],[0.78448,-0.61762,0.055919],[0.82909,-0.55712,-0.047303],[0.85573,-0.03358,0.51634],[0.73328,-0.64607,0.21186],[-0.63179,0.70375,-0.32491],[-0.79801,-0.5948,0.096968],[-0.95379,-0.096555,-0.28454],[0.81335,0.05056,0.57958],[-0.46639,0.86762,-0.17236],[-0.23199,0.97035,0.067858],[0.06454,-0.37177,0.92608],[0.87944,-0.058457,-0.47241],[0.52413,0.44448,0.72645],[0.84674,-0.52677,-0.074399],[-0.98813,-0.11539,0.10138],[-0.77716,-0.0098801,-0.62923],[0.98602,-0.070879,0.15082],[0.92523,0.33093,0.18556],[-0.19479,-0.78092,-0.59349],[0.72601,-0.31732,0.6101],[-0.045257,-0.66961,-0.74134],[0.76256,-0.18268,0.62059],[0.7978,-0.59729,-0.082248],[-0.83341,-0.29719,0.46595],[0.78944,0.25572,0.55802],[-0.17849,-0.95283,-0.24549],[-0.035606,-0.96801,-0.24838],[0.88964,0.08663,0.44836],[0.78099,-0.34626,-0.51976],[0.59502,-0.53717,-0.59784],[-0.46887,-0.68001,-0.5637],[-0.96597,0.04237,0.25518],[-0.32296,-0.86574,-0.38235],[-0.845,-0.53184,0.055793],[0.12037,-0.96319,-0.24038],[-0.82351,-0.55879,0.097919],[-0.62287,-0.34593,0.70169],[-0.11258,0.08712,0.98982],[-0.82654,-0.5488,0.12508],[-0.57037,-0.55913,-0.60171],[0.84008,0.16965,0.51525],[-0.52769,-0.70814,-0.46914],[-0.63826,-0.46918,0.61033],[0.78478,-0.60778,-0.12131],[0.16725,-0.97182,-0.16611],[-0.70758,-0.68227,0.18393],[-0.90298,-0.41127,-0.12448],[-0.90229,-0.40992,0.13354],[-0.69689,-0.37307,-0.6125],[-0.79694,-0.60143,0.056311],[0.93279,0.21405,-0.28997],[0.60347,-0.79409,-0.072428],[0.74177,-0.31054,-0.59442],[-0.0031432,0.096857,0.99529],[0.14789,-0.98867,-0.025697],[0.16588,-0.98497,-0.048166],[0.53572,-0.50537,0.67647],[-0.69195,-0.20964,-0.69083],[-0.92225,-0.36805,0.1183],[0.81738,-0.12098,-0.56325],[0.95157,0.14353,0.27188],[-0.87696,-0.46016,0.13854],[-0.76418,-0.64129,0.069183],[0.72386,-0.68822,-0.048796],[-0.76369,-0.021214,-0.64523],[0.57339,-0.80968,-0.12503],[-0.95294,-0.27839,0.12003],[0.89053,0.064777,-0.45029],[0.064179,0.53182,0.84442],[0.72068,-0.67791,-0.1451],[-0.75463,0.27487,0.5958],[-0.76782,-0.63701,0.068321],[0.85398,-0.49173,-0.17005],[-0.49711,-0.86769,0.00034039],[-0.98513,-0.17152,-0.0099666],[0.86369,0.45187,0.22328],[-0.1008,0.21026,0.97243],[0.66242,0.28456,0.69299],[0.96609,-0.25632,0.031106],[0.92433,-0.34999,-0.15205],[-0.4767,0.65427,-0.5871],[-0.4328,-0.901,-0.029711],[-0.88905,0.42057,0.18083],[0.33158,0.89562,-0.29651],[0.41922,0.82356,-0.3821],[0.966,0.24315,-0.087854],[0.96829,-0.16898,-0.18401],[0.86793,0.24222,0.43361],[-0.28023,0.84083,-0.46311],[0.88923,0.4573,-0.012462],[-0.97845,0.19754,0.060176],[0.78098,0.24233,0.57563],[-0.8712,-0.27061,0.4096],[-0.96076,0.13018,0.24495],[-0.64553,-0.76277,-0.038268],[0.94432,-0.31299,0.10147],[-0.92704,-0.37356,-0.032238],[-0.71739,0.61696,-0.32359],[0.76267,0.21905,0.60857],[0.16881,0.18158,0.96878],[0.9638,0.20302,-0.17286],[0.78554,0.17934,0.59226],[-0.59784,0.76448,-0.24117],[-0.23956,0.91555,-0.32308],[-0.80499,-0.59309,-0.015465],[0.93261,0.33367,0.13751],[0.20496,0.93147,-0.30058],[-0.77947,0.068209,-0.62271],[0.04525,0.96305,-0.2655],[-0.91449,0.40449,0.0094199],[-0.98185,-0.18829,-0.022615],[0.98022,-0.11122,-0.16371],[0.87112,-0.4628,0.16423],[-0.93062,0.35841,0.07411],[0.69473,-0.69786,-0.17419],[-0.84786,-0.38615,-0.36336],[0.71987,-0.24555,-0.64922],[0.8318,-0.52138,-0.19046],[0.37228,-0.46125,0.80539],[0.73664,-0.027352,0.67573],[0.75803,-0.15837,-0.63271],[0.87544,-0.0073281,0.48327],[0.23885,-0.32535,0.91493],[-0.97773,0.10992,-0.17881],[0.98329,0.12897,-0.12847],[-0.98561,-0.16897,-0.0037066],[-0.31334,-0.86468,-0.39262],[-0.91528,-0.40065,0.041865],[-0.92866,0.36433,-0.069611],[0.96705,0.24341,-0.074611],[-0.88141,-0.062335,0.46822],[0.98252,0.023456,-0.18468],[0.8386,-0.42721,-0.33799],[0.87118,-0.45688,0.17972],[0.78558,0.55695,0.26958],[0.93626,0.13766,-0.32321],[-0.80569,0.53887,-0.24594],[-0.98971,-0.10875,0.09301],[0.87349,-0.37792,-0.30692],[-0.86934,0.14544,-0.47233],[-0.86873,-0.075252,-0.48954],[0.22366,0.92651,0.30258],[0.65231,-0.24506,0.71725],[-0.9325,-0.19025,0.30701],[0.94278,-0.14861,0.29847],[-0.83269,0.46607,-0.299],[-0.88547,0.46358,-0.032127],[-0.81324,0.58047,0.041093],[0.75781,-0.12693,0.64001],[0.95623,-0.19636,0.21693],[0.93759,0.34222,0.06172],[-0.70821,0.21866,-0.67128],[-0.71622,0.69726,0.029361],[0.62808,-0.41694,0.65702],[0.72577,0.68789,-0.0078877],[-0.89565,-0.35588,0.26675],[0.79908,-0.18649,-0.57157],[0.75047,-0.6384,0.17099],[0.49679,-0.83116,0.24974],[0.49135,0.87086,-0.013365],[-0.38488,0.91234,0.13962],[-0.037992,-0.99917,0.014933],[0.18628,0.949,-0.25434],[-0.072256,0.98519,-0.1555],[-0.12348,-0.27755,-0.95274],[0.37059,0.85282,0.36791],[0.63049,0.029448,0.77564],[-0.24262,-0.27674,-0.92981],[-0.99697,-0.013669,0.076631],[-0.87608,0.48167,-0.021914],[0.11999,-0.45144,-0.8842],[0.37651,-0.52674,-0.76209],[-0.42886,-0.12808,-0.89424],[0.31005,0.21589,0.92588],[0.58857,-0.59081,-0.55184],[0.63534,-0.30352,0.71009],[-0.072228,0.93137,0.35683],[-0.88512,0.15954,0.43717],[-0.61939,0.039815,-0.78407],[0.61223,-0.70458,0.3588],[0.8055,-0.51281,-0.29696],[-0.88456,0.11185,0.45282],[0.4169,-0.82271,0.38645],[0.99135,-0.05796,0.11778],[0.21306,-0.85853,0.46641],[0.71103,-0.42388,0.56104],[-0.36393,0.094477,-0.92662],[0.75533,-0.058309,0.65274],[-0.72506,0.23509,-0.64731],[0.67494,-0.13436,0.72554],[-0.86403,0.15702,0.47833],[-0.98731,-0.1578,0.017937],[-0.70551,-0.51513,0.48671],[0.89962,-0.31427,0.30318],[-0.7375,0.44665,-0.50655],[-0.67206,0.72045,-0.17112],[0.79616,0.03429,0.60411],[0.011451,-0.86409,0.5032],[-0.86089,0.1198,0.49448],[0.61505,0.30051,0.72897],[-0.48504,0.87132,0.074369],[-0.20765,0.93803,0.27744],[0.073148,-0.85433,0.51456],[-0.76012,-0.45454,0.46435],[-0.035257,0.9504,0.30902],[0.15569,0.81569,0.55714],[0.90685,0.12962,0.40103],[0.052398,-0.53208,-0.84507],[-0.43906,-0.56579,-0.69793],[-0.52906,-0.30127,0.79331],[0.35964,-0.70514,-0.61109],[0.067627,-0.83307,0.54902],[0.028468,-0.84564,0.53299],[-0.04922,-0.8801,-0.47223],[0.1282,-0.97169,-0.19845],[0.074424,0.0094284,0.99718],[0.25901,-0.92975,-0.26169],[0.75927,0.035648,0.6498],[0.87045,0.26637,0.41396],[-0.45836,-0.84169,-0.28541],[-0.27112,-0.837,-0.47533],[0.025484,-0.83521,-0.54935],[0.21593,-0.90987,-0.35428],[0.14581,-0.92122,-0.36068],[-0.21369,-0.86332,-0.45718],[0.20755,-0.85474,0.47576],[-0.98607,-0.15396,0.062926],[0.63584,-0.66647,-0.38926],[-0.90029,0.25633,0.35181],[-0.47452,-0.80984,-0.34495],[0.12036,0.46423,0.8775],[0.80777,-0.3987,-0.43422],[-0.55999,-0.62991,0.53816],[0.89802,0.34856,0.26844],[-0.57496,-0.80557,-0.14311],[0.35432,-0.93512,0.00085322],[0.15408,-0.88178,0.44579],[0.69811,-0.11938,0.70596],[0.070426,0.52661,0.84719],[-0.75905,-0.64783,-0.064514],[0.036269,-0.019443,0.99915],[0.13167,-0.98883,-0.069885],[0.19814,-0.97899,-0.048183],[-0.80706,-0.26285,0.52874],[0.076407,-0.85893,0.50636],[-0.84041,-0.15787,-0.51844],[0.61914,0.49608,0.60875],[0.86615,-0.18794,-0.4631],[0.38408,-0.92296,-0.024997],[0.56228,-0.82695,0.0013421],[0.87021,-0.061412,-0.48884],[0.32008,-0.74019,0.59132],[0.586,-0.77303,0.24294],[-0.91005,0.045641,-0.41198],[0.802,0.1502,-0.57813],[-0.52395,-0.53415,0.66345],[0.82028,-0.56455,-0.091829],[0.086089,0.54556,0.83364],[-0.81065,0.34988,-0.4695],[0.75031,0.47351,-0.46133],[0.94694,0.14809,-0.28525],[-0.96941,-0.215,0.11841],[0.96877,0.2221,0.11023],[-0.6726,-0.32073,0.66689],[0.64839,0.57177,0.50266],[-0.12899,-0.24885,0.95991],[-0.96061,0.23735,0.14456],[-0.67411,0.57662,-0.46162],[-0.64694,0.54688,0.53141],[0.92238,0.30433,0.2379],[0.5778,-0.59042,0.56351],[-0.46097,0.77525,-0.43185],[-0.73583,0.22568,-0.63845],[-0.43907,-0.5497,0.71067],[0.35625,0.8636,-0.35676],[0.021197,0.9418,0.33549],[0.9878,0.028334,-0.15313],[-0.13389,0.90867,-0.39547],[-0.14757,0.90873,-0.39044],[0.75525,0.5854,0.29478],[0.99161,0.072915,-0.10672],[0.61501,0.72025,-0.32095],[-0.60072,0.56845,0.56213],[0.88501,-0.25534,-0.38931],[-0.98521,0.095851,0.14206],[0.47152,-0.096004,0.87661],[-0.077159,-0.34245,0.93636],[0.7642,0.10037,0.63712],[0.97555,0.056978,-0.21227],[0.67342,-0.5557,0.48754],[0.60464,0.74981,-0.26869],[-0.4021,-0.4757,0.78232],[-0.897,0.42983,-0.10314],[0.75897,-0.61414,-0.21632],[-0.88127,0.47115,-0.037073],[-0.67839,0.5677,0.46638],[-0.9678,-0.15196,-0.20066],[-0.92498,-0.35967,-0.12266],[-0.79279,0.083533,0.60374],[-0.99806,-0.053289,-0.032281],[0.67123,-0.53917,0.50866],[-0.72772,-0.12937,0.67356],[-0.92409,0.36985,0.096244],[-0.91691,0.38862,-0.090813],[-0.99352,-0.11367,-0.0027329],[0.37506,-0.49004,0.78689],[-0.77052,0.60344,-0.20532],[0.96548,-0.035743,-0.25801],[0.72214,-0.61111,-0.32413],[-0.75011,0.61461,-0.24411],[-0.95068,0.25562,0.17571],[-0.26157,-0.47254,0.8416],[-0.80864,0.040659,0.58689],[-0.96721,-0.0053002,-0.25393],[0.92419,-0.26767,-0.27243],[-0.94989,0.29786,0.094822],[0.9701,0.16768,-0.17545],[-0.76533,0.12512,0.63136],[-0.89292,0.16532,-0.41876],[-0.057539,-0.99745,0.042136],[0.95881,0.25446,-0.12621],[-0.90088,0.30256,-0.31125],[0.15563,0.20034,0.96729],[0.94674,0.30866,-0.091662],[-0.60958,-0.64638,-0.45892],[-0.73859,0.64074,-0.2096],[0.67612,-0.4547,0.57975],[0.90281,0.39336,0.17381],[0.8472,0.35546,-0.39484],[-0.58806,0.80083,0.11337],[0.76609,0.12109,0.63123],[-0.017794,-0.27752,0.96056],[-0.55536,-0.23469,-0.79781],[-0.092465,-0.30844,-0.94674],[-0.12627,0.067172,-0.98972],[0.2964,-0.089829,-0.95083],[-0.82999,0.47302,0.29559],[0.30332,-0.47467,0.82625],[-0.47242,0.86599,0.16397],[0.23225,-0.28073,0.93126],[0.20382,0.37733,-0.90337],[-0.34787,0.9341,-0.080322],[0.20646,0.65567,-0.72627],[0.46354,0.71911,-0.5177],[-0.31898,-0.035779,0.94708],[-0.046721,-0.99826,-0.035906],[-0.20534,0.54445,-0.81327],[0.86877,0.37765,-0.32035],[-0.76432,0.23102,-0.60204],[0.12663,0.96199,-0.24195],[-0.065672,-0.40382,-0.91248],[0.86373,0.46902,0.18437],[-0.40017,-0.24574,-0.88288],[-0.10127,-0.10162,0.98966],[0.43229,-0.39247,0.81184],[0.24006,-0.46759,-0.85072],[-0.6944,0.4273,0.57899],[-0.80943,0.48114,0.33664],[-0.75406,0.54263,0.37006],[0.91459,-0.18537,-0.3594],[-0.55816,-0.062346,-0.82739],[-0.73623,0.54467,0.40162],[0.55063,-0.54117,-0.63556],[-0.23442,-0.45847,0.85724],[-0.67729,0.26141,0.6877],[-0.97372,-0.1873,-0.12958],[0.22544,-0.40415,0.88647],[0.8602,-0.14059,-0.49019],[-0.74576,0.11927,-0.65545],[0.72392,0.12723,0.67805],[-0.7301,0.58449,0.354],[0.1404,0.67449,0.72481],[-0.24298,-0.79383,-0.55748],[0.8916,0.45168,-0.032138],[0.17626,-0.55157,-0.81529],[0.84377,-0.42736,0.32469],[-0.63204,-0.59363,-0.49813],[0.44924,0.65518,0.60739],[0.41156,-0.21533,0.88558],[-0.14663,-0.37144,-0.91681],[0.2592,-0.28561,-0.92263],[0.83787,0.53382,0.11402],[0.53508,-0.021378,-0.84453],[-0.79902,0.2601,-0.54214],[0.59505,-0.19128,0.78059],[-0.39833,-0.38271,0.83359],[-0.64881,0.32902,0.68615],[0.92791,-0.36962,0.048615],[-0.88117,-0.090456,-0.46406],[0.22175,0.17433,-0.95939],[0.4984,0.15798,-0.85243],[-0.80263,0.43396,-0.40922],[-0.60977,0.50164,-0.61363],[-0.14522,0.45635,-0.87787],[0.16834,0.57275,-0.80226],[0.41258,0.38059,-0.8276],[0.27544,0.85484,0.43976],[-0.30738,-0.41923,0.85426],[-0.76484,0.57953,-0.28138],[0.83093,0.019088,0.55605],[-0.089687,-0.0099612,0.99592],[-0.82747,0.49543,0.26429],[-0.11948,0.94861,0.29303],[0.46275,-0.27888,0.84148],[0.59296,0.717,0.36647],[0.49322,0.54008,0.68194],[-0.24559,0.90699,0.34214],[0.71675,-0.33613,0.61097],[0.9267,0.29577,-0.23184],[-0.79619,0.53398,0.2845],[-0.078577,-0.68964,-0.71988],[0.098388,0.22225,0.97001],[-0.61745,-0.57287,-0.53905],[0.53862,0.75291,0.37818],[0.50004,-0.53811,-0.67853],[0.64795,-0.57761,-0.49651],[-0.65759,0.3142,0.68473],[0.15538,-0.68978,-0.70715],[-0.74353,0.64089,0.19086],[-0.37663,-0.34904,0.85809],[0.90194,0.37592,-0.21259],[0.31886,-0.61315,-0.72276],[0.67498,0.72381,0.14321],[0.9581,0.27881,0.065658],[-0.54474,-0.65465,-0.5241],[0.71044,-0.63024,0.31317],[0.84792,0.52897,-0.034901],[-0.31407,-0.68194,-0.66054],[0.0076273,0.23454,0.97208],[0.34215,-0.81475,-0.46809],[0.16889,-0.98563,-0.0018916],[0.6082,0.12879,0.78327],[0.60506,-0.25329,0.75481],[0.38015,-0.68724,-0.61902],[0.0065277,-0.84221,-0.53911],[-0.28084,-0.84229,-0.46008],[0.14001,-0.80863,-0.57142],[-0.75499,0.57137,0.32176],[0.28894,-0.9572,-0.016889],[-0.78207,0.22629,0.58065],[-0.75876,-0.54535,-0.35618],[0.89225,0.33546,0.30224],[-0.73817,-0.65605,0.15718],[-0.05478,-0.94804,0.3134],[0.24154,-0.96223,0.12555],[0.12312,0.20887,0.97016],[-0.99983,-0.0088641,-0.016218],[0.73127,0.13526,0.66854],[-0.66049,-0.28403,0.69504],[0.17225,-0.98068,0.092752],[-0.92143,-0.16734,-0.35067],[-0.82476,-0.53948,0.1695],[-0.96806,-0.21922,-0.12164],[0.70696,-0.70479,-0.058978],[-0.75211,0.32312,-0.57439],[0.90629,0.0084441,-0.42257],[-0.86988,-0.46409,0.16709],[-0.56729,-0.31802,0.75963],[-0.90796,0.26289,-0.32634],[-0.48171,0.72898,0.48636],[0.62113,-0.18521,0.76151],[-0.8028,0.42459,-0.41862],[0.48468,0.82239,-0.29792],[-0.82447,0.37783,-0.42131],[-0.58068,-0.29937,0.75709],[-0.67759,0.70463,0.21061],[-0.63525,0.65502,-0.40916],[0.42566,-0.49477,-0.75764],[-0.98078,-0.13168,0.14399],[-0.48822,0.73911,-0.46407],[0.9456,0.32477,-0.019394],[0.97323,-0.037016,0.22682],[-0.45036,0.78498,0.42543],[-0.33941,0.83903,-0.42524],[0.7589,0.15874,0.63157],[-0.54212,0.75208,-0.37481],[-0.61562,0.70859,0.34484],[-0.86937,0.45751,0.18678],[-0.69113,0.32185,0.64711],[0.92058,0.24892,-0.30095],[0.95722,0.221,-0.18681],[-0.63136,0.71727,-0.29481],[0.82291,0.44579,-0.35227],[0.94665,0.21424,-0.24074],[0.67484,0.72296,0.14806],[-0.21289,0.90768,-0.36164],[-0.8395,-0.022615,0.54289],[0.079589,0.9094,-0.40824],[0.18683,0.89324,-0.40892],[0.47553,0.83578,-0.27449],[0.78261,0.58958,0.19978],[-0.95072,0.30648,0.046922],[0.97814,-0.031802,-0.20549],[-0.91456,0.39126,0.10247],[0.97405,0.034397,-0.22372],[-0.99839,-0.056744,-0.0022581],[-0.99752,0.029147,0.063993],[-0.97891,0.17243,0.10955],[0.95233,0.26742,-0.14678],[-0.56017,-0.18104,0.80836],[0.97722,-0.046589,0.20703],[0.98457,-0.033766,-0.17172],[0.93564,-0.30577,0.1763],[0.71109,-0.101,0.69581],[0.83575,-0.46106,-0.29824],[0.73087,0.67161,0.1215],[-0.77726,0.20024,-0.59646],[0.96578,-0.24873,-0.07342],[0.85225,-0.43488,-0.29077],[-0.9899,0.011095,-0.14135],[0.69846,-0.0252,0.7152],[0.93841,-0.25203,-0.23637],[0.99178,-0.054002,-0.11604],[0.99622,0.086401,-0.0090891],[-0.35122,-0.18618,0.9176],[-0.96867,0.15516,-0.19393],[0.15895,0.74996,0.6421],[0.95489,0.24994,-0.16034],[0.73705,0.66604,0.11469],[-0.87307,0.40313,-0.27431],[-0.74947,0.5464,-0.37383],[-0.94832,0.25797,0.18477],[-0.89895,0.42088,0.12145],[0.93069,0.10447,-0.35057],[-0.28293,-0.57815,-0.76531],[0.97226,0.020841,0.23295],[-0.22694,-0.089997,0.96974],[0.063065,-0.54119,-0.83853],[-0.40273,-0.83078,-0.38421],[-0.51805,0.81429,-0.26184],[-0.15625,0.75571,0.636],[-0.41027,-0.045143,0.91085],[-0.54753,-0.54628,-0.63388],[-0.90848,-0.2985,-0.29252],[0.43659,-0.28911,-0.85194],[-0.46461,0.88544,0.012101],[-0.50924,-0.0174,0.86045],[0.64263,0.082944,-0.76168],[-0.6477,-0.20047,0.73505],[-0.085998,0.14794,0.98525],[0.68648,0.023916,-0.72675],[-0.56512,0.8227,-0.061726],[0.59513,0.42934,-0.67933],[-0.79228,-0.12103,-0.59803],[0.77838,0.00067545,0.6278],[0.55906,0.26347,-0.78615],[-0.59498,0.76133,-0.25763],[-0.026696,0.60156,0.79838],[0.2418,0.25371,-0.93657],[0.47583,-0.048279,-0.87821],[-0.9266,0.18714,-0.32618],[0.66203,0.69843,0.27186],[0.51493,0.66871,-0.53636],[-0.21105,0.7967,-0.56633],[-0.031757,0.78939,-0.61307],[0.72184,-0.27836,0.63361],[-0.34557,0.025844,-0.93804],[-0.12379,-0.20238,-0.97145],[0.17274,-0.38297,-0.90747],[0.71638,0.665,0.21113],[0.42185,-0.46468,-0.77854],[-0.16039,0.69078,0.70505],[0.20125,0.73172,-0.65121],[-0.67324,-0.042237,0.73822],[-0.52549,-0.16801,-0.83405],[-0.30386,-0.12527,0.94445],[0.73043,0.66504,0.15554],[-0.63576,0.3577,0.68401],[0.69852,-0.48545,-0.52575],[-0.46689,0.063934,0.882],[-0.67681,-0.00416,-0.73615],[0.69592,-0.035814,0.71723],[0.74675,-0.53354,-0.39712],[0.71972,0.47742,-0.50406],[-0.25601,0.054343,0.96515],[0.87887,-0.45579,-0.14086],[0.65165,0.71978,0.23931],[-0.48301,-0.87254,-0.073247],[-0.20995,-0.88585,-0.41374],[0.10481,-0.77048,-0.62879],[0.43516,-0.40109,-0.80608],[-0.70687,0.24899,0.66207],[-0.71033,-0.69981,-0.075434],[-0.65332,0.68012,0.33259],[0.93853,-0.3452,-0.0022605],[0.95635,-0.12098,0.26601],[-0.82973,-0.35609,0.42982],[0.91719,0.035813,0.39683],[-0.020289,0.64629,0.76282],[-0.92921,0.36297,-0.069363],[0.54251,0.38905,-0.74453],[-0.27064,0.032472,0.96213],[-0.77192,0.62934,-0.089844],[-0.67702,0.71089,-0.19048],[-0.23605,0.79219,-0.56278],[0.3513,0.62276,-0.69911],[0.60938,0.75559,0.24027],[-0.35865,0.016335,0.93333],[-0.6863,0.7259,0.045545],[0.66225,0.3183,0.67832],[0.62499,0.32577,0.70941],[-0.27753,0.94453,-0.17563],[0.010247,0.84521,-0.53433],[0.71732,0.15622,0.67901],[-0.62594,0.77487,0.088196],[-0.48071,0.85329,0.20202],[0.41099,0.5784,0.70465],[-0.27054,0.13454,0.95326],[-0.21127,0.879,0.42746],[0.027549,0.84516,0.53381],[-0.9861,-0.16618,-0.00022366],[-0.50114,0.036577,0.86459],[0.76731,-0.037445,0.64018],[0.10738,-0.89481,-0.43334],[0.97423,0.012312,0.22523],[-0.69046,-0.60079,-0.40288],[0.6799,-0.60695,-0.41152],[-0.33005,-0.64901,-0.68546],[0.083255,-0.66906,-0.73853],[0.70001,0.15757,0.69653],[-0.17308,-0.67857,-0.71385],[0.53778,0.816,0.21197],[-0.31557,0.042373,0.94796],[-0.41586,-0.67865,-0.60539],[-0.3622,0.019719,0.93189],[0.69895,-0.65738,-0.28165],[-0.98296,-0.0095486,0.18359],[-0.12284,-0.92928,-0.34835],[-0.62931,0.13172,0.76591],[-0.82445,-0.10573,-0.55597],[-0.66895,0.27708,0.68974],[0.34728,-0.010345,0.9377],[0.1122,-0.31665,0.94188],[0.97554,-0.21714,-0.034295],[0.5082,-0.8448,-0.16747],[-0.41651,-0.8905,-0.18312],[0.67,-0.71242,-0.20873],[0.41117,0.90518,0.10766],[-0.49692,-0.85224,-0.16358],[0.52186,0.84555,0.11275],[0.79487,-0.57429,-0.19588],[-0.88579,-0.39036,-0.25101],[0.81167,0.38683,-0.43767],[0.90537,-0.16966,-0.38926],[0.062885,-0.9961,-0.061941],[0.4473,-0.2706,0.85246],[-0.59438,0.77295,0.22194],[0.43526,-0.90018,-0.014922],[-0.019002,-0.3834,0.92339],[-0.45848,0.86929,0.18474],[0.68234,-0.43193,0.58979],[0.57473,-0.81417,-0.082531],[0.97028,-0.011068,-0.24171],[-0.89228,-0.41077,-0.18735],[0.8287,-0.53647,-0.15954],[-0.27507,0.96042,0.043975],[0.85994,0.11848,0.49644],[-0.59418,0.51261,0.61982],[-0.97951,-0.10813,-0.16988],[0.50546,0.37463,0.77728],[-0.23533,0.94462,0.22874],[0.48898,0.79831,-0.35156],[-0.63652,0.045219,0.76993],[-0.61149,0.59476,0.52187],[0.62666,0.25669,0.73581],[0.38098,0.83855,-0.38949],[0.69519,0.17186,0.69798],[-0.080073,0.95693,-0.27905],[-0.18818,0.9295,-0.3172],[0.66551,0.47538,0.57542],[0.35582,0.88308,-0.30589],[0.29882,0.89713,-0.32538],[0.30032,0.7238,0.62122],[-0.12154,0.93874,-0.32247],[-0.99111,0.085951,-0.10159],[-0.81048,0.05707,0.58298],[0.77095,0.56112,-0.3013],[0.62237,0.70227,-0.34565],[-0.98969,0.09499,0.10722],[-0.71619,0.29259,0.63361],[0.97476,0.20946,0.077276],[-0.34388,0.19742,0.91803],[-0.7082,0.41861,0.56853],[0.35626,-0.06774,0.93193],[-0.42533,0.71487,-0.55502],[0.59948,0.67493,0.43023],[-0.48444,0.17284,0.85758],[-0.70029,-0.49347,0.51582],[-0.31264,0.35722,0.88014],[-0.42894,0.33092,0.84054],[0.58414,0.35881,0.72804],[0.99284,-0.11748,0.021534],[0.71342,-0.66715,-0.21436],[-0.97574,0.02118,-0.21792],[0.79116,-0.54488,-0.27779],[0.64164,0.39149,0.65958],[-0.88604,-0.29706,0.35592],[0.97633,0.050399,0.21031],[-0.65176,-0.29771,0.69755],[0.89285,-0.39913,-0.20861],[0.90875,-0.26971,-0.31847],[0.95886,-0.11476,-0.25965],[0.97552,0.057148,-0.21236],[0.6278,0.76216,-0.15801],[-0.95248,0.29416,0.079088],[0.95215,0.213,-0.2192],[-0.79009,0.36942,0.48916],[0.1429,-0.9612,-0.23597],[0.76344,-0.55981,-0.32215],[-0.8252,0.56481,0.004692],[-0.81589,-0.28803,-0.50135],[-0.76998,0.63682,-0.039954],[-0.98498,-0.075494,0.15531],[-0.12241,-0.28975,0.94924],[-0.96707,0.22558,-0.11784],[-0.97956,-0.1009,-0.17403],[-0.98065,0.04498,-0.19055],[0.9861,0.15952,0.046486],[0.99222,0.072918,0.10092],[0.56147,0.39236,0.72856],[0.54226,0.768,0.34078],[0.30315,-0.89351,-0.33127],[0.84367,0.11432,-0.52455],[-0.44969,-0.68039,-0.57866],[-0.48845,0.39178,0.7797],[0.97648,-0.098221,0.19195],[-0.22293,-0.74266,-0.63148],[0.99892,0.01108,0.045048],[0.2488,-0.61273,-0.75011],[-0.98247,0.17983,-0.049211],[-0.81107,-0.52523,-0.25748],[0.65656,0.37203,0.65614],[0.61922,-0.3103,-0.7213],[0.68352,0.70064,-0.20471],[0.61102,0.3594,0.70532],[-0.75012,-0.007952,0.66125],[-0.6946,0.33753,0.63529],[0.77608,-0.057549,-0.62801],[-0.96773,-0.23003,0.10286],[-0.37229,0.92246,-0.1023],[-0.52074,0.36539,0.77157],[0.54164,0.79267,0.27984],[-0.066372,0.69635,0.71463],[0.72524,0.39997,-0.5604],[0.68476,-0.099415,-0.72195],[-0.99653,-0.074617,-0.036913],[0.6934,-0.39835,0.60043],[-0.76176,0.45722,-0.45898],[0.73461,0.22926,0.63859],[-0.54431,0.74553,0.38459],[-0.5774,0.46196,-0.6732],[0.49909,0.82653,0.2603],[-0.65906,0.35157,0.66486],[-0.082508,0.66192,-0.74502],[0.6044,-0.39468,-0.69204],[-0.5393,0.47366,0.69628],[-0.11334,0.97296,-0.20123],[-0.8094,0.57899,0.098163],[0.3346,0.90595,-0.25943],[-0.51304,0.77546,0.36804],[-0.13596,0.66191,-0.73715],[-0.63613,-0.54937,0.54178],[-0.46818,0.062295,-0.88144],[0.87744,0.4365,-0.19891],[-0.51551,0.44737,0.73083],[-0.12386,0.34319,0.93106],[0.69886,0.39591,0.59569],[-0.26852,0.96261,0.035818],[0.57934,-0.7849,0.21977],[-0.64309,0.069454,-0.76263],[-0.31,-0.94025,-0.14084],[-0.70609,-0.68716,0.17101],[-0.77763,0.14848,-0.61094],[-0.51625,0.090385,0.85166],[0.82997,-0.44407,-0.33757],[-0.4589,0.82172,0.33791],[-0.76348,0.48077,-0.43123],[0.85891,-0.46861,-0.20659],[0.76109,0.3221,0.56302],[-0.26446,-0.91693,-0.29883],[-0.1544,-0.91324,-0.37704],[0.27924,-0.67471,-0.68322],[0.27521,-0.30948,0.91021],[-0.85047,0.2589,-0.45791],[-0.54117,-0.84062,0.022206],[0.57295,-0.21751,-0.7902],[-0.97102,0.20015,0.1306],[0.99441,-0.024441,0.10269],[-0.851,0.46189,-0.2499],[-0.70897,-0.57081,0.41417],[0.89216,-0.35629,0.27769],[0.37305,-0.23008,0.89883],[-0.83291,0.51263,-0.20853],[0.79488,0.018369,0.60649],[-0.98916,0.098383,-0.10901],[-0.95696,0.24401,0.15715],[0.67677,0.40886,0.61222],[-0.88198,0.3388,0.32761],[0.59766,0.1761,-0.78217],[-0.28101,-0.26159,0.92337],[0.40296,0.87828,0.25738],[0.64802,0.25108,0.71905],[0.63627,0.31244,0.70536],[0.8835,-0.42954,0.18685],[0.48286,0.57283,-0.66236],[-0.64384,0.40916,0.64657],[0.89001,0.29856,-0.34459],[-0.52082,0.8371,0.16737],[0.050817,0.92774,-0.36976],[-0.61314,0.44811,0.65058],[0.36035,0.77464,-0.51969],[0.51723,0.62429,0.58544],[-0.39744,0.85173,0.34148],[-0.82985,-0.55443,-0.062876],[0.56242,0.43329,0.70423],[0.76297,-0.15505,0.62757],[-0.1321,-0.97373,-0.18549],[0.18427,0.73083,0.65722],[0.43583,0.62157,0.65093],[-0.97943,-0.10078,0.17483],[-0.84368,-0.29659,-0.44747],[-0.57664,-0.71399,-0.39712],[-0.012376,-0.27917,0.96016],[0.22302,-0.95999,-0.16936],[0.59957,-0.78198,-0.17035],[-0.8,-0.012667,0.59986],[0.60645,-0.72256,-0.33184],[0.59535,-0.62538,0.50445],[-0.99166,0.10346,-0.076802],[-0.5689,-0.67165,-0.47459],[-0.40725,-0.75739,-0.5104],[0.21246,-0.65277,-0.72716],[0.46655,-0.64877,-0.60119],[0.30874,0.71639,0.62567],[0.74648,0.66475,0.029648],[0.32117,0.90729,0.27145],[-0.86408,0.46346,0.19642],[0.23398,0.83529,0.49754],[-0.71248,-0.63991,-0.28789],[0.38568,-0.56511,-0.72932],[0.48354,0.72322,0.49308],[0.62353,-0.68384,-0.37891],[-0.15018,-0.2431,0.9583],[0.21684,-0.80219,-0.5563],[0.035547,0.78507,0.61838],[0.59896,-0.77909,-0.18511],[-0.56092,-0.77209,-0.29873],[0.90937,-0.26016,-0.32459],[0.2236,0.63055,0.74325],[0.91402,-0.31275,0.25835],[0.28312,-0.95495,-0.089],[-0.36201,0.87776,0.31382],[0.2651,-0.96351,-0.037133],[0.57639,-0.81716,-0.0049627],[0.28897,-0.39331,0.87281],[0.61391,0.65333,0.44302],[-0.72109,-0.68186,-0.12289],[-0.34455,0.89276,0.29027],[0.90138,-0.32775,-0.28301],[-0.52717,-0.108,0.84287],[-0.66128,-0.68978,0.29482],[-0.33402,-0.8353,0.43669],[-0.02621,-0.94908,0.31394],[-0.082324,-0.99158,0.09998],[0.31557,-0.9485,0.027661],[-0.97706,0.20745,-0.048163],[0.70827,0.013608,0.70581],[0.39067,0.88812,0.24212],[-0.91645,-0.061058,-0.39545],[-0.75057,-0.65635,0.076458],[-0.73778,-0.65586,-0.1598],[0.9717,-0.040523,0.23271],[-0.90469,0.16304,-0.39365],[0.93633,0.22841,-0.26668],[-0.95662,0.27496,-0.096326],[-0.94432,-0.29807,0.13936],[0.68734,-0.71569,-0.12389],[0.52816,0.68591,0.50057],[0.77643,0.55752,-0.29381],[-0.93934,-0.274,-0.20631],[-0.66792,0.42887,0.60824],[0.51979,0.57473,0.63206],[0.89636,-0.27195,-0.35012],[-0.98035,-0.068408,-0.18505],[0.91073,-0.36362,-0.19586],[-0.7202,0.42534,0.54808],[-0.050181,0.93135,0.36065],[-0.94149,-0.14715,-0.30323],[-0.6631,0.55595,-0.50122],[-0.73765,-0.44973,0.50361],[0.29913,0.93165,0.20628],[-0.8376,-0.2927,-0.46124],[-0.31242,0.87009,-0.38123],[0.52785,0.67081,0.52095],[-0.66103,-0.36104,0.65779],[0.79291,0.40491,0.45535],[0.96389,0.05303,-0.26098],[0.76233,0.082681,0.64188],[0.28036,0.92128,0.26952],[-0.99061,0.018316,-0.1355],[-0.63484,0.61506,-0.46763],[0.96999,0.10906,0.21732],[-0.31745,0.876,0.36312],[-0.9206,-0.29633,0.25433],[0.86429,-0.46562,0.1903],[-0.6452,0.64221,-0.41386],[-0.047698,0.65683,0.75253],[-0.31604,0.88473,0.3426],[-0.70187,-0.58641,0.40436],[0.31654,0.76965,-0.55447],[0.52163,0.6753,-0.52142],[-0.96228,0.21181,-0.17073],[0.92127,-0.18134,-0.34405],[-0.30848,0.79293,-0.52545],[-0.065373,0.87114,-0.48666],[-0.6279,0.66996,0.39611],[-0.13193,0.53015,0.83758],[0.13657,0.82051,-0.55508],[0.99531,-0.036205,0.089708],[0.57713,0.80117,0.15827],[0.75836,-0.55433,-0.34295],[0.54553,0.81472,0.19656],[-0.98115,-0.059038,-0.18401],[-0.83177,0.53381,-0.15234],[0.71403,0.37125,0.59357],[-0.88571,-0.3209,-0.33547],[-0.9836,0.17954,0.017139],[-0.18918,0.92922,0.31744],[0.088981,-0.16312,0.98259],[-0.9486,0.30492,-0.08472],[0.17149,0.96333,0.20637],[0.88511,-0.25397,-0.38998],[-0.44369,0.79819,0.40747],[-0.18771,0.92287,0.33628],[0.96983,-0.078656,-0.23076],[0.76549,-0.55024,-0.33356],[-0.93272,-0.30085,0.19881],[0.62027,0.62887,0.46882],[-0.90346,0.42143,-0.078504],[0.91712,-0.30429,-0.2575],[0.025345,0.91872,0.3941],[-0.96418,0.081823,-0.2523],[0.99475,-0.049897,-0.0893],[0.9957,0.091205,-0.016311],[-0.9722,0.16884,-0.16223],[0.99918,0.016227,0.036992],[-0.11247,0.82018,0.56094],[0.935,-0.073729,-0.34691],[-0.99726,-0.0062531,-0.073761],[0.77379,-0.58769,0.23636],[-0.052988,-0.78259,-0.62028],[-0.80658,-0.37768,-0.45473],[0.50713,-0.54531,-0.66742],[-0.88137,0.39372,-0.26109],[-0.99198,0.12634,0.0038516],[0.96826,0.076773,0.23787],[-0.691,-0.61445,-0.38074],[-0.29629,0.75933,0.57933],[0.71569,-0.064286,-0.69545],[0.074881,0.92268,0.37823],[-0.97829,-0.19915,-0.05741],[0.76443,-0.19454,-0.61466],[0.59,0.15953,0.79149],[-0.66141,0.66424,-0.34831],[0.70085,-0.1099,-0.70479],[-0.99442,-0.098513,0.037665],[0.80362,0.076607,-0.59019],[-0.42156,0.90678,0.0061478],[0.77474,0.54772,0.31589],[0.13553,0.90475,0.4038],[-0.18867,0.90058,0.39162],[0.4078,0.1486,0.9009],[-0.00057266,-0.18498,0.98274],[-0.63583,0.75892,-0.14059],[-0.95124,0.072725,0.29977],[0.96246,-0.074478,-0.26101],[0.3154,0.91559,0.24945],[-0.89537,0.21455,-0.39024],[-0.22515,0.64123,0.73358],[-0.96249,0.27128,-0.0044865],[-0.98496,-0.02644,0.17076],[-0.79535,0.12516,-0.59309],[0.79855,-0.25629,-0.54465],[-0.13966,0.12414,0.98239],[-0.40382,0.49718,-0.76795],[-0.21889,0.5422,-0.81124],[0.94902,0.29715,0.10521],[0.15242,0.98793,-0.02752],[-0.2586,0.62491,-0.73662],[-0.47432,0.23885,-0.84733],[-0.85226,-0.34979,-0.38897],[-0.92185,0.38609,0.033579],[-0.75242,0.34793,-0.55928],[-0.47495,0.81694,0.32716],[-0.67533,-0.11138,0.72906],[-0.19707,0.90278,0.38229],[0.79578,0.51867,0.31259],[0.94317,0.33129,0.026032],[-0.96971,0.16256,0.18231],[0.92769,-0.37008,0.049368],[0.92683,-0.35331,0.12711],[-0.081289,0.49251,0.8665],[0.15293,-0.82764,-0.54002],[0.93664,0.34981,0.018124],[-0.87898,0.36876,-0.30233],[-0.60111,-0.79908,-0.011968],[-0.36129,-0.91471,-0.18102],[0.4271,-0.56363,-0.70704],[0.084467,0.9095,0.40702],[0.85689,0.035782,0.51426],[-0.7922,-0.55863,0.24568],[0.5566,-0.4421,-0.70338],[0.99149,0.05673,0.11715],[-0.22091,0.14419,0.96458],[-0.86468,-0.39,0.31657],[0.71043,0.084316,-0.6987],[-0.85414,0.50623,0.11903],[0.66782,0.28061,0.6894],[-0.73131,-0.49753,0.46653],[0.55467,-0.74501,0.37055],[0.64535,0.33541,0.68632],[-0.86839,-0.053264,0.49301],[0.93083,-0.21839,-0.29303],[0.25542,-0.66093,0.70564],[-0.16301,0.24674,0.95527],[0.16999,0.92609,0.33684],[-0.12545,0.78445,0.60737],[0.31072,0.92244,0.22925],[-0.062323,0.93422,0.35122],[-0.7799,0.55633,-0.28681],[-0.52781,0.80053,0.28384],[-0.32164,0.93588,0.14378],[-0.85865,0.42722,0.28321],[0.98866,-0.051911,0.1409],[-0.33494,0.83764,0.43148],[-0.025294,0.92899,0.36924],[0.4311,0.52571,0.73334],[0.82911,0.52793,-0.18404],[0.76063,0.24422,0.60149],[0.012561,0.97656,-0.21488],[-0.61478,0.58017,-0.53427],[-0.055065,0.81484,0.57706],[-0.082273,0.055307,0.99507],[-0.04654,-0.86077,-0.50686],[-0.83172,0.55504,-0.012836],[-0.3485,-0.92249,-0.166],[-0.5712,-0.6723,-0.4709],[0.70432,0.64428,-0.29804],[0.035605,0.92161,0.38649],[-0.72317,-0.64156,-0.25578],[0.38704,-0.72292,-0.57235],[-0.66368,0.6126,-0.42925],[-0.26775,-0.76617,-0.5842],[-0.58607,-0.76253,-0.27397],[-0.061738,-0.18648,0.98052],[-0.016587,-0.87412,-0.48543],[0.78229,-0.61491,-0.099561],[-0.22763,-0.97372,-0.007878],[0.89099,-0.34273,-0.29779],[-0.4302,-0.81258,-0.39324],[-0.88477,-0.3582,-0.29813],[-0.6313,-0.76088,-0.15004],[-0.97292,0.11575,0.20007],[0.77513,-0.63144,-0.021244],[-0.78864,-0.59912,-0.13825],[-0.15359,-0.20574,0.96648],[0.69012,0.66444,-0.28681],[0.88758,-0.3583,-0.28953],[-0.086556,-0.99109,0.10126],[-0.90492,-0.26065,-0.33642],[0.013935,-0.9999,-0.001184],[0.5223,-0.85147,-0.046957],[0.19377,-0.9806,0.029502],[0.9798,-0.15119,-0.1309],[0.40808,-0.91162,-0.049134],[-0.83831,0.092221,-0.53734],[0.96486,-0.26133,-0.027476],[-0.85877,-0.36124,-0.36335],[0.86595,0.44897,-0.22038],[0.8491,-0.48717,-0.2042],[-0.96046,-0.27644,0.033243],[-0.77256,0.31071,-0.55372],[-0.18825,-0.96424,-0.18658],[0.74836,0.54079,-0.38405],[-0.16207,-0.97372,-0.16003],[-0.80067,0.42594,0.42132],[0.98861,0.021811,0.14891],[-0.78993,0.61312,-0.0091852],[0.93081,-0.22545,-0.28769],[-0.62764,0.55284,-0.54812],[-0.0023177,-0.99962,0.02732],[-0.75258,0.15907,0.639],[0.20465,-0.93082,0.30281],[0.42042,0.81739,-0.39385],[-0.98408,-0.024792,-0.17601],[0.56859,-0.5441,0.61698],[-0.13174,0.16172,0.978],[-0.66965,0.1063,0.73503],[-0.50227,0.72677,-0.46854],[0.99758,0.057209,0.039515],[0.3099,0.91267,-0.26646],[0.59528,-0.77045,-0.22814],[0.75464,0.060234,0.65337],[-0.92163,0.38479,0.050345],[-0.060504,0.95838,-0.27901],[-0.78601,0.01848,0.61794],[-0.30539,-0.89074,0.33663],[0.74693,0.64593,-0.15768],[0.55056,0.76641,-0.33091],[0.76009,0.16901,0.62745],[-0.70795,0.609,-0.35766],[0.39104,-0.75508,0.52625],[0.67724,0.62463,-0.38883],[-0.11155,-0.9783,0.17461],[0.9226,0.02723,-0.38481],[0.1495,-0.98356,-0.10125],[0.68984,0.18551,0.69979],[0.21255,-0.94859,-0.23452],[0.84832,0.50763,0.15058],[-0.59321,-0.7125,-0.37476],[-0.68869,0.37915,-0.61802],[0.21343,0.81429,-0.53979],[0.44562,0.7355,-0.51035],[-0.61713,0.18265,0.76537],[-0.97516,0.20788,-0.076537],[-0.98112,0.039092,-0.18939],[0.87336,0.46589,0.14205],[-0.73068,0.075293,0.67855],[0.82059,-0.4153,-0.39263],[0.66708,0.36079,0.6518],[-0.98573,0.025697,-0.16637],[-0.9882,0.070332,-0.13609],[-0.97754,0.090538,-0.1903],[0.86614,-0.39651,-0.30429],[-0.57324,-0.16441,0.80272],[-0.93747,0.16572,-0.30607],[-0.87931,0.329,-0.34433],[0.74085,-0.54599,-0.39119],[-0.15258,-0.98644,0.060426],[0.80143,-0.047726,0.59618],[-0.7787,0.58667,-0.22236],[0.8833,-0.36461,-0.29469],[-0.87572,-0.39577,-0.27654],[-0.76245,0.631,-0.1432],[-0.18101,-0.97873,-0.096587],[-0.060265,-0.036088,0.99753],[0.97976,-0.13552,-0.1473],[-0.81436,0.36142,-0.45409],[-0.97897,0.055235,-0.19639],[0.9921,0.12517,0.0088927],[0.98355,0.15048,-0.099887],[-0.94504,0.30683,-0.11297],[0.94074,-0.20412,-0.27084],[0.76711,-0.40335,-0.49884],[-0.42598,-0.73897,-0.52198],[-0.11121,-0.99378,-0.005639],[0.8325,0.55162,-0.051598],[-0.93829,0.32779,-0.11028],[-0.77779,0.58014,-0.24184],[0.9944,0.040887,0.097502],[0.85724,0.5149,0.0021457],[0.68292,-0.1571,-0.7134],[0.75003,-0.13996,-0.64642],[-0.91303,-0.35459,-0.20158],[-0.2551,-0.966,0.042081],[-0.93312,0.19422,0.30261],[-0.21391,-0.9718,-0.099285],[0.62,-0.77774,-0.10357],[-0.84047,0.53754,0.068252],[0.80531,-0.060271,-0.58978],[-0.61606,-0.70833,-0.34459],[-0.28126,-0.946,-0.1612],[-0.98087,0.026609,0.19282],[0.085049,-0.99636,0.0048885],[-0.98761,-0.099336,0.1215],[-0.62575,0.37542,0.68374],[-0.37695,0.92213,-0.087125],[0.81277,0.55498,-0.17719],[0.81777,-0.080392,-0.5699],[-0.075206,-0.99691,-0.022524],[-0.41041,0.82878,-0.38037],[0.15876,-0.98422,0.078189],[0.5999,0.51517,0.61214],[-0.72132,0.65138,-0.23539],[0.43135,-0.092535,0.89743],[0.56069,0.77697,-0.28626],[0.74457,0.61652,-0.25596],[0.72862,0.6208,-0.28934],[0.7838,-0.61735,-0.067398],[-0.88743,0.099638,-0.45004],[-0.84697,0.46034,0.26595],[0.13262,-0.98776,0.082067],[0.7613,-0.57422,-0.30116],[0.33454,0.94035,-0.061817],[-0.64174,0.37747,-0.66759],[0.86528,-0.29233,-0.40722],[-0.33225,0.92856,0.16551],[-0.52231,0.65168,-0.55],[-0.31268,0.67877,-0.66446],[-0.67487,0.20537,0.70878],[-0.060942,-0.99707,-0.046315],[-0.59465,0.54041,0.59527],[-0.71788,0.68372,-0.13106],[0.91655,-0.38584,-0.10521],[-0.84176,0.3622,-0.40032],[-0.016089,-0.11304,0.99346],[0.90557,-0.13436,0.40236],[-0.22383,-0.9159,-0.33322],[0.25619,-0.76871,-0.58605],[-0.042919,-0.99855,-0.032349],[0.39908,-0.67176,-0.62408],[0.80732,-0.030596,-0.58932],[0.75997,-0.025946,0.64945],[-0.047287,-0.99744,-0.053652],[-0.81508,0.57553,-0.066407],[0.70157,0.12716,0.70116],[0.70393,-0.14334,-0.69566],[-0.15422,-0.97687,-0.1481],[-0.75669,0.65229,0.044059],[0.68388,0.3048,0.66288],[0.64967,0.37744,-0.6599],[-0.034649,0.12228,0.99189],[-0.66902,0.73022,0.13856],[0.99235,0.10515,0.064683],[-0.52872,0.77649,0.34281],[0.55904,0.56375,-0.608],[0.62457,0.24264,0.74232],[-0.56813,0.57414,0.58957],[-0.58611,-0.17558,0.79098],[0.25084,0.64513,0.72172],[-0.58096,-0.53622,0.61234],[-0.71657,0.68476,-0.13278],[0.4065,0.81277,-0.41734],[-0.92603,-0.3309,0.1816],[0.67561,-0.22371,0.7025],[0.98217,-0.053547,0.18021],[-0.041832,0.77984,0.62458],[0.80111,-0.15331,0.57855],[0.52445,0.73897,-0.42293],[-0.07527,0.99713,-0.0084468],[0.52556,0.53504,0.66145],[-0.94341,0.16086,0.29],[-0.08278,-0.85977,-0.50393],[-0.41998,-0.82665,-0.37453],[0.46222,-0.87971,-0.11163],[0.76408,-0.63987,-0.082161],[-0.5898,-0.79693,-0.13051],[0.4248,-0.84044,-0.33647],[0.51686,-0.78641,-0.33824],[0.1214,-0.98292,-0.13833],[0.16668,-0.98221,-0.086519],[0.42774,-0.89564,-0.12192],[-0.069516,-0.99638,0.048897],[0.027684,-0.99897,-0.035818],[-0.010655,-0.91966,-0.39257],[0.31869,-0.90896,-0.26875],[0.061395,-0.99161,-0.11378],[0.030601,-0.99946,0.011706],[-0.65705,-0.6832,-0.31861],[-0.10659,-0.99095,0.081636],[-0.3597,-0.76362,-0.53618],[0.53634,0.74862,-0.38975],[-0.095316,-0.98676,0.13122],[0.32117,-0.85629,-0.4045],[0.49577,0.75554,-0.42822],[0.43246,-0.82028,-0.37433],[-0.75747,-0.53958,-0.36755],[0.55005,-0.82438,-0.13358],[-0.77416,-0.62975,-0.063948],[0.7286,-0.68493,-0.0040467],[-0.85625,-0.4054,-0.32013],[0.92268,-0.38538,0.012226],[-0.29673,-0.88014,0.37055],[-0.22844,-0.9666,0.1162],[0.18127,-0.97164,0.15184],[-0.61261,0.75872,-0.22147],[0.92865,-0.34662,0.13217],[-0.46573,-0.87795,0.11094],[-0.76908,-0.48097,-0.42093],[-0.79092,-0.47823,-0.38176],[0.77711,-0.57729,-0.25066],[0.98287,-0.062351,-0.17341],[-0.55465,-0.83207,0.0038569],[0.096595,-0.99267,0.072693],[0.75664,-0.61976,-0.20832],[-0.74036,-0.65874,-0.13392],[0.74041,0.63442,-0.22205],[0.59195,-0.79611,-0.12574],[-0.0061122,-0.99975,0.021359],[0.9342,0.15354,-0.32202],[-0.92575,-0.37461,-0.051582],[-0.42285,0.81111,-0.40409],[0.025455,-0.99966,-0.0058352],[0.010363,-0.99888,-0.046148],[-0.50211,-0.59326,0.62923],[0.39488,-0.30031,0.86827],[-0.052952,-0.99621,-0.069061],[0.56468,0.73161,-0.38196],[-0.56514,0.58364,0.58308],[0.94732,0.32011,0.010382],[0.93166,-0.055597,-0.35905],[0.38924,-0.085835,0.91713],[-0.59423,0.71478,-0.36874],[0.31108,0.92027,-0.23734],[0.62011,0.29595,0.72655],[-0.33316,0.89182,-0.30603],[-0.0033799,-0.95937,-0.28215],[-0.72451,-0.20164,0.65911],[-0.71502,0.63264,-0.29751],[0.78003,-0.56549,-0.26791],[0.7013,0.60245,-0.38108],[-0.98577,0.12891,-0.1079],[0.98045,-0.16545,0.10654],[-0.71746,0.65808,-0.22844],[-0.87316,-0.22256,-0.43366],[0.7576,-0.43232,-0.48902],[0.96765,0.24228,0.070349],[0.62607,0.045644,0.77843],[0.70052,-0.12412,0.70276],[-0.9275,-0.32368,0.18703],[-0.80937,0.58066,-0.088057],[-0.8671,0.47755,0.14171],[0.72103,-0.53831,-0.43628],[-0.7122,-0.14361,0.68713],[-0.8886,-0.43911,0.13256],[-0.24454,0.95668,-0.15801],[0.84694,0.5213,-0.10457],[0.12634,0.94055,-0.31528],[0.26869,0.9361,-0.227],[-0.015561,0.98985,-0.14126],[0.91113,-0.37855,-0.16289],[-0.88397,0.43244,0.17775],[-0.84971,-0.093681,-0.51886],[0.92696,0.1732,-0.3328],[-0.97716,0.027204,-0.21075],[0.7962,0.55464,-0.24173],[-0.73516,0.44156,-0.51436],[0.71731,0.69019,-0.09539],[-0.93253,0.31053,0.18427],[0.21291,0.73254,0.64657],[-0.87329,0.35633,-0.33226],[-0.75004,0.60288,0.27201],[0.39402,0.91751,-0.054004],[-0.51606,0.59303,0.61806],[0.90014,-0.4017,0.16846],[-0.60092,0.79926,-0.0088879],[0.43906,0.89845,0.0039828],[-0.92227,0.25282,-0.29239],[-0.96374,0.021765,-0.26594],[-0.94086,-0.12722,-0.31399],[0.99521,0.087342,-0.043886],[0.98617,0.16552,0.0088681],[-0.80237,0.19137,0.56531],[0.17899,-0.96854,-0.17288],[0.9908,0.1352,-0.0065545],[0.85505,-0.37016,-0.36314],[0.84175,0.53668,-0.058529],[0.7292,-0.59667,-0.33503],[0.23226,-0.74676,-0.62322],[-0.084195,-0.9946,0.060687],[-0.83846,-0.3774,-0.39314],[0.71161,-0.49643,-0.49716],[0.73309,-0.034761,0.67925],[-0.74003,-0.084702,0.66722],[-0.71054,-0.58057,-0.39758],[0.45767,-0.64498,-0.61199],[0.80383,-0.5607,0.19867],[0.83993,-0.53516,0.090163],[-0.61667,0.78722,0.0013669],[0.71713,-0.37412,-0.58801],[0.92052,0.37442,-0.1116],[-0.903,-0.061788,-0.42518],[0.81807,-0.27946,-0.50266],[0.83397,-0.13963,-0.53385],[-0.99981,-0.015392,-0.011711],[-0.036648,-0.41947,0.90703],[-0.95794,0.11498,0.26293],[0.8938,0.14922,-0.4229],[-0.39602,0.9025,0.16932],[0.41796,0.64829,0.63642],[0.85291,-0.14196,-0.50238],[-0.68301,-0.11275,0.72165],[0.8269,0.35379,-0.4371],[-0.89414,0.427,-0.13485],[-0.84344,0.38184,-0.37789],[-0.85561,0.41674,-0.30701],[-0.96483,0.18882,0.18292],[0.86956,0.47783,-0.12466],[-0.62019,0.399,0.6754],[0.47633,0.62956,0.61381],[-0.88982,0.013912,-0.4561],[-0.23428,0.5401,0.80833],[-0.53801,-0.75463,0.3756],[-0.87926,0.35593,-0.31658],[0.90288,0.040506,-0.42798],[0.096393,-0.038835,0.99459],[0.92013,0.28548,-0.26807],[-0.39619,-0.23419,0.8878],[-0.83433,-0.41642,-0.36122],[-0.77648,0.62931,-0.0323],[0.71886,0.13758,0.6814],[-0.026906,-0.78237,0.62223],[0.65874,0.75079,-0.048687],[0.95623,-0.19586,-0.21741],[-0.42754,0.64478,0.63361],[0.96914,-0.19039,0.15661],[-0.45806,0.67356,-0.58008],[0.72752,0.20827,0.65371],[-0.72852,-0.048667,0.68329],[0.61477,0.20293,0.76215],[0.095797,-0.43155,0.89699],[0.95797,0.27403,-0.084845],[-0.87271,0.046986,-0.48598],[-0.012267,-0.88926,-0.45723],[0.72168,-0.64876,-0.24142],[0.44629,0.67454,0.58807],[-0.87347,0.38563,-0.29723],[-0.48667,-0.86311,-0.13487],[-0.48946,-0.85333,-0.17963],[0.69767,0.70832,-0.10743],[-0.72836,0.67784,-0.10016],[0.7848,0.13538,0.60478],[-0.84786,-0.49549,0.18871],[-0.69523,-0.034308,0.71797],[0.96402,0.23492,-0.12442],[0.69898,-0.30707,-0.64586],[-0.23431,0.14636,0.96108],[-0.68736,0.71231,-0.14193],[-0.29748,-0.11678,0.94756],[0.64402,0.76206,-0.067113],[-0.53751,0.78524,0.30737],[-0.10406,0.74968,0.65357],[0.83437,-0.48546,0.26108],[-0.91551,-0.044877,0.39977],[0.72609,0.4157,-0.54771],[-0.33694,0.80297,0.49164],[0.49919,0.48657,0.71698],[0.72035,0.1455,0.67818],[0.83629,-0.54708,-0.036379],[-0.66395,0.063787,0.74505],[-0.67724,0.67271,0.29801],[0.26159,0.70236,0.66202],[0.59002,0.66867,-0.4525],[-0.18312,0.70553,0.68461],[-0.21142,0.80347,0.55654],[0.15013,0.69706,0.70112],[0.99036,0.11061,-0.083326],[0.32632,0.92034,-0.21562],[-0.25316,-0.27152,0.92854],[-0.12923,-0.99049,-0.047259],[0.28581,-0.95232,-0.10676],[-0.085379,0.68955,0.71919],[-0.63604,0.75535,-0.15777],[0.57974,-0.79183,-0.19212],[-0.62423,-0.76647,-0.15121],[-0.49195,-0.43228,-0.75573],[-0.29048,-0.92657,-0.23895],[-0.32234,-0.93543,-0.14513],[-0.58517,-0.67952,-0.44252],[-0.30806,-0.8368,-0.45262],[0.76072,-0.62464,-0.17647],[0.6237,0.78015,-0.048521],[-0.73335,-0.016072,0.67966],[-0.031962,0.70345,0.71003],[-0.3076,-0.7079,-0.63582],[-0.2449,-0.8033,-0.54289],[-0.91843,-0.35632,0.17181],[0.62074,-0.75326,-0.21745],[0.37096,-0.79494,-0.48007],[0.98234,0.18663,0.013727],[-0.87416,0.15528,-0.46014],[0.69539,0.70749,0.12608],[-0.60325,0.78525,-0.13956],[-0.96218,0.14611,0.22993],[0.84484,-0.53502,0.0023375],[-0.75969,-0.61345,-0.21575],[0.52925,0.24383,0.81268],[-0.095653,-0.98925,0.11057],[0.36978,-0.92654,0.069164],[0.56414,0.82553,0.015736],[0.9537,-0.2929,-0.068298],[-0.81821,-0.46394,-0.33953],[-0.78334,0.072853,0.6173],[0.6977,0.15933,0.69845],[0.73903,0.10445,0.66553],[0.36253,-0.9307,-0.048729],[-0.90213,-0.19019,-0.38728],[0.70146,0.52396,0.48314],[0.90233,-0.41724,0.1082],[0.38887,0.92063,0.034853],[-0.89543,-0.041149,-0.4433],[0.73247,-0.66397,-0.15047],[0.81541,-0.57575,0.060119],[0.16612,0.97849,0.1223],[-0.72229,0.096414,0.68483],[0.0098969,-0.1959,0.98057],[-0.99369,-0.11181,0.0084291],[-0.43469,0.6677,0.60434],[0.88847,-0.45455,-0.063219],[0.78199,0.46411,-0.41605],[-0.69054,0.51462,-0.50825],[-0.88062,-0.41187,0.23424],[0.93185,0.3523,-0.086893],[-0.57766,0.81075,-0.094884],[0.76849,0.63481,-0.080284],[0.78926,0.096392,0.60644],[0.41254,0.87653,-0.24801],[-0.99989,-0.0073683,0.013071],[0.89177,-0.032987,-0.45129],[-0.32515,0.90494,-0.27452],[-0.72845,0.5319,0.4318],[-0.17253,0.94433,-0.28012],[0.74008,0.2508,0.624],[0.66546,0.55972,0.49384],[-0.72404,-0.099118,0.68259],[0.19588,0.97426,0.11156],[0.1491,0.98357,0.10177],[0.71743,0.66814,-0.19717],[0.91597,0.39699,0.058382],[0.70502,-0.6554,-0.27092],[0.70022,-0.64978,-0.29577],[0.80569,-0.32716,-0.49379],[-0.60292,0.60618,0.51868],[0.55347,0.81547,-0.16936],[-0.57747,0.8106,-0.097186],[-0.36164,0.91955,-0.15377],[-0.20273,0.97053,-0.13027],[0.061616,-0.18932,0.97998],[0.17472,0.98125,-0.081347],[-0.017805,-0.25532,0.96669],[-0.99921,0.027521,-0.028713],[0.67286,0.42969,0.60218],[-0.99997,-0.0075434,0.0028231],[-0.38523,0.92157,0.048068],[-0.99768,0.022835,0.064102],[-0.88507,0.17347,-0.43191],[0.90631,-0.017257,-0.42227],[0.78609,-0.39861,-0.4724],[0.79922,0.59522,-0.083448],[-0.41183,-0.11818,0.90357],[0.81491,-0.41842,-0.40107],[-0.12457,0.98515,0.11818],[0.79187,0.3158,0.5227],[-0.11111,0.9895,0.092424],[-0.63692,0.070868,0.76767],[-0.70898,0.69321,-0.12967],[0.46127,0.64736,0.60676],[-0.96563,0.18038,-0.18714],[0.97589,-0.11218,-0.18721],[-0.66354,0.74139,-0.10031],[0.061137,-0.23325,0.97049],[0.96237,-0.18311,-0.20079],[-0.89098,0.1499,-0.42859],[0.75074,-0.52105,-0.40608],[0.49852,0.86677,-0.013225],[-0.89281,-0.42761,-0.14154],[-0.76018,0.63274,-0.14757],[0.7033,-0.56653,-0.42943],[-0.91965,0.39195,-0.024974],[0.83416,-0.43205,-0.34281],[-0.81412,-0.4555,-0.36019],[0.81463,-0.27393,-0.51122],[0.40124,0.91581,0.017541],[-0.7426,-0.2908,0.60331],[-0.67077,0.12526,0.73102],[-0.75216,0.6569,0.052322],[-0.69163,0.01621,0.72207],[0.78738,0.5988,0.14652],[-0.97747,0.16281,0.13433],[0.8965,-0.1277,-0.42424],[-0.55133,0.83147,-0.068598],[-0.55594,0.80007,0.22543],[0.28423,0.12786,0.95019],[0.72474,-0.56057,-0.40065],[-0.98835,0.11724,0.097018],[0.34231,0.93731,0.065423],[-0.49686,0.8616,0.10378],[-0.50592,0.85854,0.083444],[-0.84493,0.15575,0.51169],[-0.010633,0.12355,0.99228],[0.8469,0.45697,-0.27192],[-0.7503,0.65013,-0.11995],[0.19475,0.71423,0.67227],[-0.92229,0.10854,-0.37095],[-0.48497,0.80434,0.34329],[-0.75997,0.58706,0.27893],[-0.39185,0.91987,0.017024],[0.051772,0.98407,0.17009],[0.23425,0.96869,0.082236],[-0.32977,0.9439,0.017696],[-0.84754,0.42966,-0.31155],[0.99928,-0.0070951,-0.037232],[-0.53222,0.7361,-0.41821],[0.84991,0.52557,-0.037761],[0.23332,0.97079,0.056037],[-0.6927,0.61531,-0.37623],[0.90269,0.073499,0.42398],[0.29049,0.95135,0.10274],[-0.37424,-0.87905,-0.29531],[0.2148,-0.82193,-0.52753],[0.41588,-0.70727,-0.57168],[-0.73792,-0.67391,0.036228],[0.61655,-0.47683,-0.6265],[0.97908,-0.13053,-0.1561],[0.86964,0.29377,0.39676],[0.28981,0.95634,0.037858],[0.84179,0.20238,0.50043],[0.22949,0.69391,0.68251],[-0.88087,-0.41455,0.22851],[-0.34299,0.70723,0.6182],[0.85429,-0.28508,-0.43464],[0.78142,0.19774,0.59184],[0.80323,-0.10521,-0.58631],[-0.28218,0.95738,0.061642],[-0.61911,0.73822,0.26783],[-0.90938,-0.33751,0.24313],[0.7963,0.07989,-0.5996],[-0.43737,0.89724,0.060573],[-0.59166,0.7488,0.29872],[0.61729,0.44759,0.64701],[0.21784,0.7669,0.60366],[0.79148,0.32517,-0.51752],[0.21842,0.96344,0.15517],[-0.51282,0.76552,0.38858],[0.95155,0.12824,0.27947],[0.37824,0.60285,0.7025],[0.16709,0.98403,0.06142],[-0.32769,0.91692,0.22778],[-0.4202,0.86921,0.26057],[0.24162,0.96089,0.13534],[0.028137,0.99935,0.022399],[-0.41346,-0.90984,-0.035149],[-0.88553,0.21455,-0.41207],[-0.70389,0.12339,0.69951],[0.86094,0.26385,0.43494],[-0.59922,-0.73261,-0.32284],[-0.26188,0.96221,0.074618],[-0.095013,-0.99444,-0.045475],[0.40015,-0.91611,-0.025044],[0.1506,-0.9568,-0.24872],[-0.8011,-0.45615,-0.3875],[-0.39616,-0.88023,-0.26123],[0.79773,0.58167,0.15903],[-0.30241,0.95318,0.002507],[-0.26391,-0.87428,-0.40742],[-0.16794,0.98286,0.076097],[0.29544,-0.76774,-0.56859],[0.1006,-0.70688,-0.70014],[-0.77467,-0.59404,-0.2168],[-0.29943,-0.86176,-0.40953],[0.30153,-0.69548,-0.65222],[0.63843,-0.57985,-0.50614],[0.081692,0.19776,0.97684],[0.66279,0.74868,0.013723],[0.15335,0.80075,0.57903],[-0.90289,-0.42562,-0.060303],[0.79787,-0.58614,-0.14086],[-0.78376,0.27043,0.55909],[-0.98707,-0.16025,-0.0024537],[-0.64435,-0.76256,-0.057515],[-0.37724,-0.92493,0.046898],[-0.30585,0.95065,0.052154],[-0.83573,-0.50223,-0.2221],[0.24548,-0.96103,0.12711],[-0.003884,0.99898,0.045034],[0.74203,-0.62013,-0.25463],[-0.52898,-0.83269,0.16376],[-0.98489,-0.16169,-0.062068],[0.92639,-0.21086,-0.312],[-0.791,-0.58185,0.18913],[0.95019,0.23946,0.19949],[-0.92932,-0.3115,0.19832],[0.94715,0.071682,-0.31268],[-0.96514,-0.23451,0.11621],[-0.84274,0.25055,-0.47646],[0.85063,-0.45312,0.26667],[-0.77894,0.56861,-0.26446],[0.86124,-0.41402,-0.2947],[-0.82492,0.52732,-0.20358],[-0.77128,0.54613,-0.3269],[0.53369,0.64855,0.54273],[0.59825,0.75044,-0.28095],[-0.13077,0.98965,0.05917],[-0.5642,0.762,-0.31785],[0.97828,0.10038,-0.18135],[-0.13467,0.7462,0.65196],[-0.064087,0.99398,0.088845],[0.063775,0.99791,0.010785],[0.27244,0.96212,0.01011],[-0.43793,0.83017,-0.34502],[-0.078473,0.80321,0.5905],[0.99407,0.049004,-0.097106],[-0.98953,0.12758,-0.067547],[-0.70977,0.65532,-0.25843],[0.59955,0.8003,0.0072141],[-0.07299,-0.99716,-0.018682],[-0.19446,0.048787,0.9797],[-0.80158,0.2207,-0.55566],[0.035463,0.029716,0.99893],[-0.043704,-0.99896,0.012916],[0.27799,0.95436,-0.10913],[-0.86041,0.45814,-0.22315],[0.15127,0.98406,-0.093507],[0.62291,0.76595,0.1591],[0.84092,-0.35267,-0.41046],[0.89983,-0.20106,-0.38715],[0.59187,0.6434,0.48552],[0.93114,0.032256,-0.36325],[-0.8974,-0.37139,-0.23823],[0.88093,-0.090612,-0.46449],[-0.97636,0.20904,-0.054976],[-0.66572,0.3802,0.64208],[0.010987,-0.99796,0.06292],[-0.87143,0.49019,0.01792],[-0.78749,0.60195,-0.13234],[-0.63094,0.1964,0.75056],[-0.94013,0.18356,-0.28717],[0.089059,-0.99248,0.084003],[0.98612,0.16168,-0.037726],[-0.98668,0.13347,-0.09305],[0.21316,-0.96089,0.17676],[-0.35603,-0.76561,-0.5358],[0.014706,-0.82063,-0.57126],[-0.67933,0.18617,0.70982],[0.973,0.13051,0.19037],[-0.71378,-0.69421,0.092693],[-0.99211,0.092391,-0.084732],[-0.92703,0.30485,-0.21834],[-0.35223,-0.92773,0.12348],[-0.022417,-0.99673,-0.077595],[0.60936,-0.55511,-0.56616],[0.12365,-0.98884,-0.083096],[-0.72908,-0.014933,0.68427],[0.94193,-0.032481,0.33423],[0.2158,-0.95353,-0.21025],[-0.95078,-0.028199,-0.30859],[0.74648,0.17799,0.64116],[-0.95195,-0.206,-0.22662],[0.22543,-0.16765,0.95973],[-0.79866,0.49109,-0.34781],[0.92217,0.030194,-0.3856],[-0.32306,-0.3054,0.89575],[0.91487,-0.074227,-0.39687],[0.7034,-0.65443,-0.2774],[-0.95397,0.27575,0.11792],[-0.93377,0.096352,-0.34466],[0.95832,-0.28529,0.0151],[0.72853,0.66422,-0.16753],[0.97302,-0.20164,-0.11215],[-0.90685,0.10797,-0.4074],[0.86119,0.044178,-0.50635],[0.37993,0.23368,0.89501],[-0.8879,0.38575,0.25067],[-0.20725,-0.9698,0.1286],[0.91099,-0.047534,0.40968],[0.50737,0.8602,-0.051248],[-0.92646,0.35151,-0.13459],[-0.079986,0.73256,0.67598],[-0.1377,-0.98722,0.08017],[0.96798,0.18932,-0.16484],[-0.81766,0.55873,-0.13872],[0.90839,0.23673,0.34465],[-0.0031915,-0.89402,-0.44802],[-0.50679,0.7955,-0.33217],[0.10387,0.78282,0.61352],[-0.89903,-0.095009,-0.42746],[0.053952,-0.99853,-0.0042982],[0.95847,-0.23399,-0.16305],[-0.21186,0.098676,0.97231],[-0.60455,0.062385,0.79412],[0.23372,-0.96105,-0.14751],[-0.7133,0.6903,-0.12117],[0.28185,-0.2624,0.92288],[-0.69708,0.70955,0.10307],[0.7177,0.68755,-0.11041],[0.83343,0.044279,0.55085],[0.28897,-0.32879,0.89911],[-0.40953,-0.90732,-0.095136],[-0.24219,-0.96947,-0.038425],[0.07291,-0.99357,0.086598],[0.11099,0.73804,0.66556],[0.16066,-0.98223,0.09698],[0.97295,0.16513,-0.16157],[-0.9874,-0.071655,-0.14112],[-0.76293,-0.61688,0.19336],[-0.18151,0.7498,0.63628],[-0.0067806,0.75004,0.66136],[-0.18988,-0.97394,0.12402],[0.98564,0.1483,0.080745],[-0.63184,-0.41225,0.65638],[0.83458,-0.19891,0.51372],[0.67798,0.6483,-0.34648],[-0.86234,-0.41524,-0.28974],[-0.20122,-0.97276,0.11513],[0.46786,0.8556,-0.22149],[-0.77188,-0.47516,-0.42241],[0.45325,-0.753,0.47703],[0.030463,-0.99666,-0.075714],[0.86296,-0.46471,-0.19834],[-0.43534,-0.89176,-0.12343],[0.30988,-0.8916,0.33019],[-0.49822,-0.82938,-0.25281],[0.018734,-0.97635,-0.21538],[0.33223,-0.79953,-0.50038],[-0.054252,-0.74944,-0.65985],[-0.76519,-0.56028,0.31714],[-0.65143,-0.73694,0.18046],[-0.63899,0.081069,0.76493],[0.41485,-0.68231,-0.60196],[-0.33587,-0.88911,-0.31094],[0.48848,-0.59855,-0.63492],[-0.19748,-0.90035,-0.38777],[0.11709,0.77144,0.62544],[-0.91953,-0.37855,0.10571],[-0.81368,-0.5631,0.14441],[0.8943,-0.41079,-0.17742],[0.72246,-0.5311,0.4427],[-0.66075,0.64244,0.38819],[-0.86998,-0.44001,0.22254],[-0.79571,-0.6016,-0.070117],[-0.93402,0.34,-0.10955],[0.65272,-0.69548,-0.30044],[0.86917,-0.45768,-0.18727],[-0.65489,-0.70564,-0.27053],[-0.66632,-0.74272,-0.066262],[0.975,-0.21461,-0.057667],[-0.77922,-0.56236,0.27671],[-0.18223,-0.95407,0.23779],[-0.042438,-0.98019,0.19348],[0.89485,-0.41265,-0.17016],[0.082182,0.70207,0.70735],[-0.43657,-0.84828,0.2997],[0.28158,-0.95419,-0.10116],[0.13016,-0.96003,-0.2478],[-0.93513,-0.29272,-0.1996],[0.87961,-0.35484,-0.31682],[0.97826,-0.1561,-0.13654],[0.65677,-0.7239,-0.21125],[0.91862,-0.21548,-0.33121],[0.27598,-0.1881,0.94258],[-0.96378,-0.1261,-0.23501],[-0.99114,0.12844,0.033791],[0.96334,0.16642,0.21042],[-0.97243,0.23252,0.017979],[0.29177,-0.39577,0.87077],[0.85021,0.46257,-0.25135],[0.80791,-0.33522,0.48467],[-0.76134,-0.63236,-0.14312],[0.67912,-0.61962,-0.39353],[-0.087229,-0.99534,0.04105],[-0.98308,-0.13689,0.12172],[0.78903,-0.17185,0.58983],[-0.14302,-0.32055,0.93637],[0.8756,-0.1962,-0.4414],[-0.044497,0.80809,0.58738],[0.54818,0.11129,0.82892],[0.8888,0.30616,-0.34103],[0.0019696,0.75365,0.65728],[-0.99865,-0.051129,-0.0088366],[-0.36312,0.88637,-0.28722],[-0.12639,-0.98996,0.063358],[-0.93893,0.33641,-0.072435],[0.34997,0.92694,-0.1353],[0.34077,0.92949,-0.14114],[-0.075362,0.94548,-0.31684],[-0.90094,-0.40507,-0.15567],[0.10311,0.76369,0.6373],[-0.61124,0.29173,0.73571],[0.58851,0.78939,-0.17469],[-0.14989,-0.95427,0.25864],[0.36329,-0.8982,-0.2475],[0.46527,-0.8281,-0.3127],[0.86441,-0.32027,0.3876],[-0.75021,-0.63195,-0.19446],[0.99402,-0.10629,-0.025137],[0.92491,-0.29628,-0.23824],[-0.98741,0.14486,-0.063582],[-0.38798,0.88142,-0.26938],[-0.6506,-0.20737,0.73056],[-0.16946,-0.45335,0.87508],[-0.012463,0.97404,-0.22602],[0.8743,-0.10056,0.47486],[-0.99507,0.088064,0.045596],[0.17171,-0.98006,0.099943],[0.89759,-0.028662,-0.43989],[-0.99079,-0.02201,0.13359],[0.79179,-0.39145,-0.46886],[-0.921,0.29181,0.25808],[0.074508,-0.99369,0.083871],[-0.81918,0.51903,0.24405],[0.97709,-0.20867,-0.041942],[0.93842,-0.17347,-0.29879],[-0.84942,0.52177,0.079036],[-0.040834,-0.99295,0.11132],[-0.97659,0.15872,-0.14522],[0.97647,0.16436,-0.13959],[-0.98502,0.11438,-0.12907],[0.97337,0.16988,-0.15391],[0.98847,0.010775,-0.15104],[-0.62765,0.77848,0.0057453],[-0.98277,0.10267,-0.15372],[0.38308,-0.73742,-0.55629],[0.27112,0.25856,0.92717],[-0.021908,-0.99807,0.058058],[0.77852,-0.45017,-0.43732],[-0.8793,0.10789,0.46389],[0.72886,-0.60427,-0.32191],[-0.049943,-0.9981,0.036123],[0.7583,-0.50183,-0.41611],[0.77507,-0.40288,-0.48679],[-0.96615,0.034597,-0.25566],[-0.71622,-0.00083347,0.69787],[-0.9604,-0.26123,-0.096932],[-0.8908,0.24978,-0.37958],[0.94051,-0.32106,-0.11117],[0.87215,-0.37609,-0.3129],[-0.99036,-0.036776,-0.13353],[-0.077285,-0.99681,0.019896],[-0.77441,0.55678,-0.30047],[-0.62237,-0.45871,0.63423],[-0.15883,-0.016652,0.98717],[0.9386,-0.24846,-0.23936],[-0.47739,0.87572,-0.072165],[0.018026,-0.96186,0.27293],[-0.12923,-0.98767,0.08836],[0.98211,-0.072748,-0.17367],[0.58418,-0.50802,0.63297],[-0.69837,0.69993,-0.14958],[0.95821,-0.23607,-0.1616],[0.99814,-0.012908,-0.059616],[-0.80323,0.54317,0.24453],[-0.94535,0.22246,-0.23837],[-0.98247,0.071551,-0.17215],[0.94753,-0.052897,-0.31527],[-0.59855,0.69799,0.39312],[0.52468,-0.56797,0.63414],[0.10128,-0.94564,0.30903],[-0.93514,0.34294,-0.088907],[-0.25029,0.88924,0.38289],[0.026798,0.97203,0.23331],[0.21853,-0.034849,0.97521],[-0.60305,-0.48775,0.63121],[0.87837,0.32152,-0.35369],[-0.88824,0.44948,0.094844],[0.35638,-0.17109,0.91854],[-0.91341,0.40378,0.051491],[0.88671,0.10381,0.45053],[0.85519,0.50664,0.10938],[-0.96902,-0.19551,0.15089],[-0.31413,-0.89278,-0.3229],[0.36468,-0.76865,-0.52553],[-0.57215,0.78193,-0.24746],[0.92218,-0.32056,-0.21641],[0.052076,-0.99459,-0.089927],[-0.61064,-0.77719,-0.15198],[0.58078,-0.58029,-0.57093],[-0.47695,0.84507,-0.24163],[0.73301,-0.3582,-0.57827],[-0.41776,0.90855,-0.0026971],[-0.63103,-0.47077,0.61658],[0.81595,0.29693,0.49604],[0.67371,-0.45019,0.58604],[-0.89759,-0.39347,0.19878],[0.82225,0.086025,0.56259],[-0.76652,-0.48492,-0.42106],[0.044023,-0.99685,-0.066033],[-0.38566,0.7845,0.48562],[-0.7275,-0.29899,0.61754],[-0.0013113,-0.99966,-0.025933],[-0.94899,-0.23997,0.20451],[0.8539,0.2424,-0.46053],[-0.28786,0.77127,0.5677],[-0.96342,-0.25013,-0.09622],[0.22423,0.6766,0.70138],[-0.027631,-0.99895,0.036614],[0.77203,0.62697,-0.10429],[0.72978,0.59381,-0.33883],[-0.63593,0.75028,0.18077],[-0.3543,0.91495,0.19324],[-0.078851,-0.99577,0.047223],[-0.27945,0.93862,0.20223],[0.25196,0.96771,-0.0075826],[0.14478,-0.53637,-0.83147],[-0.66062,-0.50851,-0.55226],[-0.27553,-0.72914,-0.62645],[-0.24867,-0.39857,-0.88279],[0.26366,-0.28917,-0.92025],[0.65502,-0.58737,-0.47535],[0.46167,-0.049713,-0.88566],[-0.60186,0.031502,-0.79798],[-0.97662,-0.12595,-0.17423],[-0.027875,0.044064,-0.99864],[0.4051,0.14357,-0.90293],[-0.057318,-0.40812,0.91113],[-0.96411,-0.10403,-0.24427],[0.78248,-0.08317,0.61709],[-0.1066,0.5166,-0.84957],[0.36812,0.51309,-0.77539],[0.813,-0.17009,0.55686],[-0.70209,0.48806,-0.51852],[0.34006,0.81866,0.46278],[-0.98454,-0.0073211,0.17499],[0.090812,-0.98152,-0.16842],[-0.33452,-0.90055,0.27766],[-0.15574,-0.97595,-0.15253],[0.029073,-0.99564,-0.088618],[0.74275,-0.56026,-0.36664],[0.28175,-0.95546,-0.087841],[-0.40215,-0.89394,-0.19785],[0.049865,-0.99854,-0.020937],[0.1776,-0.97885,-0.10152],[-0.2834,-0.8715,0.40021],[0.28614,-0.93474,-0.21069],[-0.0080061,-0.30575,0.95208],[0.087063,-0.74868,-0.65719],[-0.94935,-0.26325,-0.17155],[0.93463,-0.2968,-0.19588],[0.21439,-0.89275,0.39628],[0.31222,-0.85514,0.41384],[0.73183,-0.40885,-0.54522],[-0.31539,-0.93327,-0.17188],[-0.80823,-0.013641,0.58871],[0.74272,0.041581,0.66831],[0.14937,-0.97942,-0.13573],[-0.75305,-0.05282,0.65584],[0.89954,-0.43169,-0.066898],[-0.72373,-0.58104,0.37229],[-0.4524,-0.75303,0.47778],[0.9142,-0.40089,0.059371],[-0.81622,-0.49772,0.29335],[0.91382,-0.046376,-0.40345],[0.63178,-0.50006,0.59228],[-0.89537,-0.10272,0.43332],[0.73557,-0.66633,0.12221],[-0.79913,-0.59991,-0.038697],[-0.79475,-0.46792,-0.38654],[0.71041,-0.70272,-0.038713],[-0.69893,-0.71088,-0.078444],[-0.98678,-0.15624,-0.043004],[-0.78934,-0.55566,0.26112],[0.75417,-0.62997,-0.18539],[0.7775,-0.23049,-0.58512],[-0.96354,-0.091439,-0.25147],[0.031389,-0.99903,0.030865],[-0.79187,-0.60516,-0.082052],[-0.27403,-0.92392,0.267],[0.97953,0.19005,0.066347],[0.77772,0.065498,0.6252],[0.072108,-0.98791,-0.13727],[0.37191,-0.91894,-0.13127],[-0.4767,-0.80926,0.34331],[-0.97865,-0.03886,-0.20184],[-0.61077,-0.70691,0.3567],[0.84451,0.068619,0.53112],[0.85312,-0.48939,-0.18079],[-0.93915,-0.038353,0.34137],[-0.69576,-0.4038,0.59402],[-0.96297,0.081482,-0.257],[0.16866,-0.34568,0.92307],[0.75681,-0.59752,-0.26497],[0.84706,-0.045088,-0.52959],[-0.88078,0.39511,-0.261],[0.73399,0.6581,-0.16782],[0.85423,-0.14052,0.50054],[0.87567,-0.31147,-0.36903],[0.95212,0.30515,-0.018481],[-0.97976,-0.1908,-0.06059],[-0.66798,0.66625,-0.33154],[0.68366,-0.037596,0.72883],[0.45556,0.87818,-0.1458],[0.94532,-0.32369,0.039831],[-0.71682,0.33271,0.61275],[-0.50051,0.27452,0.82105],[-0.80243,-0.11622,0.58532],[-0.98897,0.052669,-0.1384],[-0.25964,0.89784,-0.35564],[-0.96386,-0.26492,-0.028198],[0.72189,-0.5946,-0.354],[-0.13721,0.93224,-0.33481],[-0.47634,0.80862,-0.34531],[-0.76725,-0.52183,-0.37285],[0.75744,0.60648,-0.24179],[-0.71111,0.53593,-0.45509],[-0.64704,0.733,-0.2099],[0.66542,0.70129,-0.25573],[-0.97231,0.19943,-0.12182],[-0.83288,-0.14586,0.53389],[-0.9648,-0.17786,-0.19371],[0.21212,0.88057,-0.4238],[-0.95208,-0.29134,-0.093054],[0.85238,-0.31389,-0.41824],[-0.18002,0.87463,-0.45013],[0.16636,0.92912,-0.33025],[0.21017,-0.42301,0.88141],[-0.98874,0.12847,0.076738],[-0.9539,0.013477,0.29982],[-0.90891,0.09027,0.40711],[0.98189,-0.18941,-0.0049292],[0.73359,-0.11615,0.66959],[0.41703,0.11535,0.90154],[0.88524,-0.26318,-0.38351],[-0.86402,-0.058698,-0.50003],[0.81093,0.019154,0.58484],[0.67014,-0.0041142,0.74223],[-0.88033,-0.035993,0.47299],[0.9733,-0.00079742,-0.22955],[-0.97855,-0.16313,0.12584],[0.70073,-0.4877,-0.52069],[-0.96597,0.25766,-0.022552],[0.88758,-0.14928,-0.43578],[-0.19433,-0.8282,-0.52567],[-0.91451,0.1106,0.38915],[0.9371,0.33935,0.081811],[-0.9767,0.20827,0.051838],[-0.95887,0.17926,0.22009],[0.65389,0.085347,0.75176],[-0.62641,-0.63159,-0.45684],[0.83076,-0.098295,-0.54789],[0.59707,-0.60925,-0.52184],[-0.9859,0.04306,-0.16168],[-0.86815,-0.343,-0.35871],[-0.80585,0.056221,0.58944],[0.7477,0.3775,0.5463],[0.92169,-0.12449,-0.36741],[0.82771,-0.52548,0.19687],[0.94614,-0.32125,-0.040188],[0.99551,-0.0028973,0.094632],[-0.48582,0.86439,-0.12968],[-0.5729,0.76323,-0.29878],[0.95498,0.15811,-0.25104],[-0.40836,0.89451,-0.18194],[0.84967,-0.24576,-0.46654],[-0.9657,0.25958,-0.005638],[0.91639,0.26343,-0.3014],[-0.62524,-0.51641,0.58514],[0.97895,-0.12868,-0.1584],[0.85576,0.50273,-0.12218],[0.67358,0.73877,-0.022382],[0.75241,-0.03915,0.65753],[-0.96261,0.27016,0.019967],[0.228,0.96422,0.13525],[-0.88405,0.46662,0.026907],[0.64728,0.13029,0.75103],[0.99195,0.008636,-0.12631],[-0.81221,0.19825,0.54865],[-0.32337,0.88987,0.32181],[0.84987,-0.17022,-0.49875],[-0.94627,0.3038,-0.1108],[0.90806,-0.39492,0.13951],[-0.74018,0.023325,0.672],[0.76049,0.62657,-0.17047],[0.94876,-0.31524,-0.021778],[0.15515,-0.57354,0.80435],[0.044799,-0.8794,-0.47397],[0.69715,0.026606,0.71643],[0.79588,0.54279,0.26824],[-0.77469,0.232,0.58824],[-0.069184,-0.23401,0.96977],[0.71199,-0.67719,0.18571],[0.28767,-0.76764,-0.57269],[0.83084,-0.12139,-0.54311],[-0.54962,-0.59728,0.5841],[-0.83458,-0.55078,-0.01082],[-0.9168,0.28244,-0.28232],[0.79105,0.55376,0.26],[0.94752,0.17379,0.26832],[0.83829,0.31966,0.44169],[-0.84856,-0.5206,0.094481],[-0.7941,0.29832,0.52954],[-0.40066,0.85016,0.34161],[0.80786,-0.13648,-0.57336],[-0.92546,-0.35373,0.13567],[0.95474,-0.24827,0.1638],[0.42712,-0.90416,-0.007883],[-0.74186,0.35149,0.57105],[0.8507,0.047498,-0.52351],[0.56948,0.14582,0.80897],[0.039108,0.73883,0.67275],[0.70835,-0.59771,-0.37548],[-0.20643,-0.17328,0.963],[-0.9826,-0.018773,-0.18476],[0.77521,0.63104,0.028956],[-0.64146,0.47129,0.60532],[-0.58526,-0.36232,0.7254],[0.80631,0.46972,-0.35948],[-0.99892,-0.041884,0.020286],[-0.99073,-0.019651,0.13439],[-0.58411,-0.095334,0.80606],[-0.35992,0.90526,0.22575],[0.94932,-0.15238,0.27489],[0.57424,0.80042,-0.17201],[0.25909,-0.96584,-0.0051146],[-0.34273,0.91568,0.2099],[-0.79269,-0.013448,0.60947],[0.076232,-0.11178,0.9908],[0.082975,-0.70836,-0.70095],[-0.98816,-0.088999,0.12501],[-0.29785,-0.83191,-0.4682],[0.4226,-0.26573,-0.86649],[-0.7466,-0.66349,-0.048683],[0.80128,-0.18237,-0.56981],[-0.79323,-0.50241,-0.34404],[0.99595,0.046809,-0.076758],[0.52989,0.31001,-0.78938],[0.66844,-0.074223,0.74005],[-0.96481,0.15054,0.21557],[-0.9511,0.16316,-0.26227],[0.713,-0.5502,-0.43464],[-0.73518,0.66373,0.13778],[-0.10529,0.89304,-0.43749],[0.32583,0.78676,-0.52426],[0.6516,-0.47736,0.58953],[0.48611,0.60239,-0.6331],[-0.73679,0.45479,0.5003],[0.11906,-0.57371,0.81036],[-0.21128,-0.86575,-0.4537],[0.86536,-0.18162,-0.46709],[0.32171,-0.84587,-0.42546],[-0.71568,-0.22021,0.66281],[-0.2017,-0.977,-0.069155],[-0.51974,0.78809,-0.32983],[0.68298,0.69923,-0.21122],[-0.7266,0.45092,0.51838],[-0.15646,-0.98518,-0.070285],[-0.037109,-0.89937,-0.43562],[0.74992,-0.64772,0.13447],[0.71653,-0.26406,-0.64565],[-0.5288,-0.84659,0.060514],[-0.96032,-0.2148,0.1779],[-0.2775,-0.95668,-0.08806],[0.80072,-0.26461,-0.53743],[-0.76156,-0.48824,-0.42621],[-0.73521,-0.60152,0.31247],[-0.67949,-0.68595,0.26032],[0.81669,-0.34697,0.46111],[-0.97472,-0.14831,0.16711],[-0.84186,0.35402,-0.40735],[0.80687,-0.35001,0.47587],[-0.74118,-0.6619,0.11198],[0.9856,0.16615,-0.031272],[0.99095,-0.094521,0.095258],[-0.65341,-0.73237,-0.19154],[0.16567,-0.98569,-0.031],[-0.16052,-0.8856,0.43583],[0.39678,0.80333,-0.44411],[-0.57133,-0.60324,-0.5565],[-0.67932,-0.67606,-0.28543],[0.56599,0.7146,-0.4111],[-0.76098,0.53778,0.36291],[-0.92962,0.30503,0.20682],[-0.681,0.63513,0.36449],[0.89859,-0.36144,-0.24878],[-0.87511,0.41922,0.24173],[0.030591,-0.13206,0.99077],[-0.021315,-0.98574,-0.16691],[0.66119,-0.047449,0.74871],[-0.065993,-0.073261,0.99513],[-0.98219,0.00084493,0.18787],[-0.43653,-0.86203,0.25759],[-0.23108,-0.9674,0.10368],[0.76473,-0.30021,-0.57015],[0.35408,-0.93186,-0.079202],[0.028126,-0.15118,0.98811],[-0.87314,-0.46952,-0.13109],[0.61847,0.17596,0.76585],[0.45089,-0.88633,-0.10547],[-0.77603,-0.5844,0.23718],[-0.43487,-0.86676,0.24416],[0.97271,-0.11345,-0.20241],[-0.76476,-0.25188,0.59304],[0.73925,-0.50081,-0.45022],[-0.5449,-0.78704,0.28922],[0.44154,0.25416,0.86049],[-0.81504,-0.48153,0.32224],[-0.71281,-0.64434,0.27701],[0.95915,-0.28212,0.021109],[-0.61761,-0.041174,0.7854],[0.83583,-0.43839,-0.33046],[-0.96897,0.14338,-0.20135],[0.89566,0.41826,-0.15118],[-0.93651,-0.33525,0.10279],[0.28798,0.70928,-0.64342],[0.41038,-0.42729,0.80561],[0.12918,0.75881,-0.63837],[-0.9773,0.086948,0.19318],[0.97241,-0.16071,0.1691],[0.35234,0.92307,-0.15427],[-0.4902,0.76128,-0.42444],[0.31468,0.81233,-0.49102],[0.27783,0.93405,-0.22442],[0.84549,-0.27984,-0.45479],[-0.35416,0.84598,-0.39861],[0.75145,0.066227,0.65646],[0.63066,0.74614,-0.21341],[0.35999,0.91433,-0.18549],[-0.97061,-0.04272,0.23683],[0.60448,-0.47494,0.63956],[0.75583,-0.53149,-0.38242],[-0.56857,0.57472,0.58858],[0.95354,-0.1635,0.25306],[-0.35348,-0.7752,-0.52357],[-0.85565,0.27989,-0.43534],[-0.74963,0.0039945,0.66184],[-0.66251,0.030712,0.74842],[0.5761,0.59549,-0.55991],[0.7492,-0.22108,0.62435],[0.46074,0.63436,-0.62073],[-0.2561,0.61287,-0.74753],[0.95474,-0.22605,0.19331],[0.0033033,0.71182,-0.70235],[-0.48602,0.68162,0.54697],[-0.40108,0.62219,0.67233],[0.14117,0.67433,-0.72481],[-0.53286,0.81613,0.2236],[0.91161,-0.24818,-0.32767],[0.81605,-0.283,-0.50396],[0.7713,-0.22408,0.59572],[0.39732,-0.91751,-0.017698],[-0.78628,-0.5012,-0.36133],[0.86165,-0.17835,-0.47513],[0.44981,0.81048,-0.37523],[-0.90552,0.20912,0.36919],[0.31523,0.087115,0.94501],[0.57374,0.33934,0.74544],[0.41918,0.7476,-0.51515],[0.74116,-0.67064,0.030491],[-0.91778,0.38688,0.089499],[-0.32711,0.87109,0.36633],[-0.95639,0.29208,0.0030228],[-0.9967,0.079602,0.016065],[-0.98065,0.10153,-0.16737],[0.94833,0.10115,-0.30074],[-0.90355,0.36193,0.22936],[-0.95346,0.20773,0.21855],[0.74491,-0.41683,-0.52093],[-0.33014,-0.79205,-0.51349],[-0.74332,0.42195,-0.51907],[-0.8985,0.096359,0.42827],[-0.050813,-0.83678,-0.54517],[0.20075,-0.81269,-0.54703],[0.61625,0.027329,0.78707],[-0.77769,-0.067577,0.625],[-0.94743,0.29691,0.11923],[0.73499,-0.52962,-0.42343],[0.53158,0.82257,-0.20202],[-0.73229,-0.52113,-0.43837],[0.84909,-0.34073,-0.40367],[0.80077,0.032858,0.59807],[-0.35894,0.85633,0.37129],[-0.90796,0.23444,0.34735],[0.7209,-0.50468,-0.47497],[0.64012,-0.032287,0.7676],[0.95608,-0.1733,0.2364],[-0.95169,-0.13014,-0.27814],[0.85885,-0.31182,-0.40637],[-0.97162,0.1178,-0.20515],[0.9167,-0.28724,-0.27777],[-0.71795,0.06908,0.69266],[-0.97456,-0.015513,-0.2236],[0.7857,0.096832,0.61098],[-0.28972,0.056555,0.95544],[0.80729,0.10251,0.58119],[-0.97426,0.20321,-0.097579],[0.93429,-0.30931,-0.17729],[-0.51858,0.81853,-0.24713],[-0.8349,0.52894,0.15219],[0.68,0.39199,-0.61963],[-0.78952,0.46026,-0.40598],[-0.61953,0.55776,-0.55235],[-0.99172,0.1031,0.076589],[-0.90584,0.18041,0.38329],[-0.85946,0.31776,-0.40045],[-0.73775,-0.57991,0.34558],[-0.46068,0.79595,0.39273],[-0.34974,0.66761,0.65725],[-0.32128,0.63719,0.70055],[0.3901,0.91073,0.13563],[0.93391,0.35656,-0.025843],[0.61177,0.7905,-0.029211],[0.15935,0.52394,0.83671],[-0.88327,0.44781,0.1389],[0.64502,0.76275,0.046488],[0.66014,0.75077,0.023397],[0.96268,-0.055498,0.26489],[-0.53555,-0.81739,-0.21229],[-0.73334,-0.0061729,0.67983],[0.10117,0.53991,0.83562],[-0.8281,0.55634,0.068906],[0.54006,-0.63433,-0.55314],[-0.97398,0.052451,0.22048],[0.98259,-0.15013,0.10942],[-0.45435,0.82802,0.32855],[0.71115,-0.38733,0.58673],[-0.74071,-0.58729,-0.32626],[-0.37391,0.92615,-0.049277],[0.42401,0.50072,0.75465],[0.62308,0.53065,0.57462],[-0.63989,-0.7561,0.13729],[-0.20329,0.97586,0.079872],[0.66903,0.43373,-0.60356],[-0.71875,0.0018898,0.69527],[0.48087,0.59177,0.64697],[-0.66936,-0.44507,0.59487],[-0.92393,0.10673,0.36737],[0.9951,-0.026571,0.095254],[-0.22304,0.84452,0.48686],[-0.12126,0.79233,0.59792],[-0.43721,0.62123,-0.65032],[0.32589,0.67343,0.66354],[-0.32337,-0.48866,0.81034],[-0.90612,-0.34049,0.25104],[0.87955,0.097382,-0.46574],[-0.061028,0.027366,0.99776],[-0.51582,0.47808,0.7109],[-0.66852,-0.55889,0.49063],[0.78993,-0.23539,0.56622],[-0.92592,-0.15617,0.34393],[-0.81431,-0.55662,0.16455],[-0.025273,0.57501,0.81775],[0.15628,0.57221,0.80508],[0.72999,0.65451,-0.1968],[0.74117,-0.496,-0.45238],[0.97352,0.12533,0.19118],[-0.64365,0.75142,-0.1452],[0.39567,0.91479,0.081282],[0.25299,0.96636,0.046278],[-0.26779,0.9372,0.22348],[-0.55811,-0.82242,-0.11019],[-0.16326,-0.85158,-0.49815],[-0.46242,0.86687,0.18629],[-0.73619,0.1213,0.66581],[0.29032,-0.60818,-0.73881],[-0.8488,-0.31321,-0.42596],[0.54917,-0.22238,-0.80558],[-0.89082,-0.29467,0.34583],[0.59046,0.051004,-0.80545],[0.62715,0.48659,-0.6082],[0.79752,0.46752,0.38129],[0.65001,0.4613,-0.6039],[0.53243,0.69848,-0.47818],[0.72021,0.53116,0.44628],[-0.99685,0.078529,-0.011046],[0.43828,0.82312,-0.36109],[-0.089941,-0.71353,-0.69483],[-0.26508,0.95886,0.10158],[0.14769,0.9713,-0.18644],[-0.48583,0.5125,-0.70803],[-0.20387,-0.95334,-0.22268],[-0.10415,-0.99228,-0.067263],[0.56624,-0.80684,0.16847],[-0.082116,-0.99276,-0.087654],[0.0082539,-0.99057,-0.13679],[0.35652,0.93359,0.036143],[-0.20322,-0.97082,-0.12732],[0.061361,-0.99408,-0.089669],[-0.56729,-0.062708,0.82112],[0.81928,-0.382,0.42762],[-0.77347,-0.36306,-0.51955],[0.77296,0.14348,0.61802],[-0.40156,-0.91485,0.042483],[-0.70148,-0.63365,0.3262],[0.74205,-0.2621,0.61699],[-0.50745,0.85585,0.10008],[-0.7871,0.011452,0.61672],[-0.66864,-0.70655,0.23173],[-0.5974,0.0069033,0.80192],[-0.55489,-0.83117,0.035396],[0.94257,0.21456,0.256],[0.66744,-0.59073,0.45339],[-0.45568,-0.84011,-0.29422],[-0.11675,-0.80711,-0.57874],[0.73621,0.085934,-0.67128],[-0.74138,-0.41929,-0.52397],[0.9871,-0.0012541,0.16008],[0.68228,-0.65557,0.32361],[0.5307,-0.84652,-0.042091],[0.054748,-0.14496,0.98792],[-0.84002,-0.45437,-0.29649],[0.6413,-0.76646,-0.035782],[0.72798,-0.48269,0.48688],[-0.63775,-0.036424,0.76939],[-0.87518,-0.4812,-0.050031],[-0.47033,0.73008,-0.49576],[-0.1443,-0.98916,-0.027118],[-0.45837,-0.88512,0.080368],[0.96075,0.27508,-0.035904],[0.18601,0.88153,-0.43394],[-0.72903,-0.68333,-0.039582],[0.019639,-0.46973,0.88259],[-0.94945,0.31326,-0.020388],[0.039913,-0.60146,0.79791],[0.76914,0.13361,0.62495],[0.00055977,-0.60012,0.79991],[-0.48393,-0.85404,0.19083],[-0.75274,-0.12875,0.6456],[0.81579,0.025432,0.57779],[-0.93801,0.21191,0.27427],[-0.96174,-0.19478,-0.19267],[0.10377,0.98942,-0.10142],[-0.012041,-0.6617,0.74967],[0.59607,-0.77514,-0.20942],[0.22791,0.96965,-0.088526],[0.065648,-0.62333,0.7792],[0.68055,-0.68119,-0.26988],[-0.97252,-0.064077,-0.22384],[-0.87509,-0.47781,0.076893],[0.7712,-0.3231,-0.54851],[-0.35369,0.93371,-0.055554],[-0.49602,0.83637,-0.23334],[0.60537,0.097812,0.78991],[-0.29784,-0.8844,-0.35935],[0.96768,0.087298,0.23658],[-0.34532,-0.46107,0.81742],[0.75387,-0.64116,0.14351],[-0.74756,0.037392,0.66314],[0.64938,-0.17398,-0.74029],[0.44132,0.83309,-0.33347],[-0.95866,-0.28382,0.020188],[0.6843,-0.27415,-0.6757],[0.58721,0.042454,0.80832],[0.022975,-0.93299,-0.35917],[0.67245,0.19177,0.71486],[-0.9963,-0.072947,0.045464],[-0.88871,0.30385,0.34332],[-0.27318,0.79667,-0.53916],[0.097874,0.91376,-0.3943],[-0.99541,0.092368,0.025187],[-0.007616,-0.97089,-0.2394],[-0.32573,-0.94341,0.062302],[0.22413,0.90795,-0.3541],[-0.15681,0.93747,-0.31073],[-0.84477,0.24567,0.4754],[0.092646,0.94005,-0.32821],[-0.9711,0.23448,0.044571],[0.021291,0.90153,-0.43219],[-0.54856,0.59177,-0.59067],[0.3966,0.66353,-0.63438],[0.62039,0.3832,-0.6843],[-0.50401,0.4907,-0.71077],[0.17359,0.50975,-0.84263],[-0.97774,0.19823,0.068786],[-0.9134,0.2109,0.34817],[0.56467,0.10393,0.81875],[-0.2104,0.58113,-0.78615],[0.058604,0.5109,-0.85764],[0.090529,0.52196,-0.84815],[0.22369,0.44292,-0.8682],[0.15052,-0.57262,0.80589],[0.3684,-0.64357,0.6709],[-0.4982,-0.057586,0.86515],[0.016508,0.63857,-0.76939],[0.90191,-0.1308,-0.41164],[-0.87919,0.32271,0.35053],[-0.9609,0.19328,0.19827],[0.88998,-0.15269,-0.42967],[-0.98395,0.16325,0.071998],[0.91371,-0.13741,-0.38243],[0.93727,-0.037523,-0.34659],[0.87115,0.36644,0.32684],[0.72192,0.48548,0.4931],[-0.96567,0.21229,0.14971],[0.89737,-0.041351,-0.43934],[0.4599,-0.30086,0.83545],[0.78798,-0.43309,-0.43763],[-0.17054,0.89073,-0.42134],[0.97126,0.21437,0.10346],[0.54757,0.070093,0.83382],[0.84225,-0.22988,-0.48762],[0.26935,0.88637,-0.37656],[0.35774,-0.72356,-0.59032],[0.53863,-0.65751,-0.52684],[-0.88502,0.31663,0.34131],[-0.44145,0.86081,-0.25326],[0.9694,0.026683,0.24402],[-0.98268,0.17774,0.052366],[-0.9966,-0.068198,0.046167],[-0.91233,-0.24371,-0.32903],[-0.99692,-0.078422,0.0021609],[-0.5212,0.16722,0.83689],[0.63427,-0.28229,-0.71973],[-0.41488,-0.8271,-0.37919],[0.95764,-0.078311,-0.27713],[0.94502,-0.18391,-0.2704],[0.97219,0.08258,-0.21913],[-0.81074,0.55164,0.19592],[-0.29469,-0.1812,0.93825],[-0.45566,0.86677,-0.2027],[-0.40133,-0.83355,-0.37965],[0.98449,-0.099449,-0.14451],[-0.88862,0.28744,0.3574],[0.92045,0.3882,-0.045445],[-0.69411,-0.64704,-0.31551],[-0.58645,0.80986,0.014189],[-0.78775,0.4443,0.42667],[0.94596,0.079454,0.31441],[0.44317,-0.093966,0.8915],[0.99876,-0.021854,-0.044627],[-0.00195,-0.3253,0.94561],[0.80996,0.58637,0.011367],[-0.46352,0.85837,-0.2199],[-0.82702,0.38325,-0.41127],[-0.49634,0.78552,-0.36959],[0.67389,0.73491,0.076],[0.58502,-0.46112,-0.66717],[-0.77247,0.10498,0.62631],[-0.11453,0.95192,0.28414],[-0.00073216,0.96502,0.26219],[-0.76005,0.62608,-0.1742],[0.52517,0.28996,0.80007],[0.8676,0.45251,-0.20617],[0.081729,-0.15373,0.98473],[-0.81939,0.32109,0.47487],[0.73866,0.6086,0.2898],[0.41694,-0.05064,0.90752],[-0.28155,-0.85995,-0.42569],[-0.84732,0.50162,0.17442],[0.58472,0.79323,0.16995],[0.42804,-0.80546,-0.40989],[-0.28681,-0.89431,-0.34345],[0.7366,0.59022,0.33025],[0.51388,-0.61704,-0.59598],[-0.6939,0.46069,-0.55341],[0.51247,0.34236,0.78751],[0.92455,0.14386,0.35287],[0.6969,0.6477,0.30793],[-0.73719,-0.67103,-0.079238],[0.5503,-0.66978,-0.49855],[-0.8657,0.37993,0.32591],[-0.89306,-0.44965,0.015891],[-0.70534,0.26165,-0.65881],[0.75602,-0.12646,0.64222],[0.34553,-0.81628,-0.46291],[-0.68199,0.63311,0.36614],[-0.70748,0.64781,0.28253],[-0.81424,0.31432,0.48807],[0.84506,-0.15418,-0.51195],[-0.050456,0.96152,0.27007],[0.52769,-0.55168,-0.64591],[-0.38684,0.21739,0.89616],[0.17555,0.74376,0.64499],[-0.51136,0.35,0.78486],[-0.65864,-0.74947,-0.067],[-0.7857,0.05952,-0.61574],[-0.68244,-0.16642,-0.71174],[0.61569,0.71021,0.34137],[0.58168,-0.52768,-0.61903],[0.86835,0.38815,-0.30872],[-0.80548,0.38904,0.44703],[-0.30421,0.92078,0.24418],[-0.924,-0.29224,0.2466],[-0.71991,-0.37681,-0.58288],[0.31092,0.95043,-0.0038298],[-0.74158,-0.64212,0.1943],[-0.36147,-0.86332,-0.35216],[0.026698,-0.8031,-0.59525],[0.34791,-0.5961,-0.72362],[0.84608,0.44048,0.30021],[-0.57716,-0.80199,-0.15395],[0.85136,0.51387,0.10543],[-0.78765,-0.54827,0.28107],[0.77349,-0.47831,-0.41586],[0.68734,0.087216,-0.72108],[-0.85265,-0.44401,-0.27538],[0.69197,0.24471,-0.67919],[-0.86188,-0.0055069,0.50709],[0.66932,-0.42353,-0.61044],[-0.8056,0.34826,0.47929],[0.89585,0.2461,0.36998],[0.35677,0.7249,0.58927],[-0.53319,0.70097,0.47365],[0.94662,0.29165,-0.13734],[0.066863,-0.3006,0.95141],[-0.083395,0.97634,0.19949],[0.2893,0.95187,-0.1012],[0.77308,-0.36369,-0.51969],[0.5237,-0.62385,0.58013],[0.92124,-0.028355,0.38796],[-0.3717,0.71225,0.59543],[-0.5073,-0.15407,0.84788],[-0.29466,0.2824,0.91292],[-0.20816,-0.97611,-0.062334],[0.4784,0.29618,0.82668],[0.021572,-0.99454,-0.10213],[0.11505,-0.99022,-0.078969],[0.71171,-0.26622,0.65008],[0.60159,-0.4592,-0.65362],[0.49713,0.27624,0.82253],[-0.62153,-0.71021,0.3306],[0.11814,-0.054998,0.99147],[0.90733,0.33179,0.25822],[0.74111,-0.26884,0.6152],[-0.77182,0.63583,0.0021175],[-0.57303,-0.11535,0.81138],[-0.59938,0.45372,0.65946],[0.44303,-0.74603,-0.49716],[-0.30566,-0.67982,-0.66664],[-0.96017,-0.12865,-0.24802],[-0.372,-0.90044,-0.22544],[0.72454,-0.48906,0.48565],[-0.97544,0.1286,0.17882],[-0.65022,-0.46895,-0.59774],[-0.92008,-0.28713,-0.26647],[0.34614,-0.027915,0.93777],[0.52516,-0.85074,0.021173],[0.68696,-0.53253,-0.49446],[-0.9852,-0.055417,-0.16221],[-0.90878,0.18255,0.37523],[-0.91234,-0.378,-0.15734],[0.82001,-0.57233,-0.0039413],[0.75221,-0.44295,-0.48782],[-0.96002,-0.013869,-0.27958],[-0.0055911,-0.99603,0.088832],[-0.78149,0.151,0.60537],[0.93901,-0.34352,0.016096],[-0.50227,-0.86125,0.077357],[-0.41665,-0.83307,-0.36386],[-0.35613,-0.93185,0.069422],[-0.39256,-0.23897,0.88814],[0.33756,-0.93751,-0.084417],[0.44387,-0.88262,-0.15483],[-0.84219,0.13713,0.52145],[-0.94534,-0.044543,-0.32303],[0.75995,-0.46495,-0.45419],[0.98269,-0.18472,-0.013868],[-0.50256,-0.86425,0.022575],[-0.71548,0.55876,0.41937],[-0.74042,-0.66007,-0.12683],[0.98801,0.087517,-0.1272],[-0.99767,-0.028278,-0.062085],[-0.87299,0.3778,0.30847],[-0.9503,0.059248,-0.30566],[0.69442,0.50594,0.51168],[-0.93362,-0.35544,0.044875],[-0.89234,0.29922,-0.33793],[-0.35245,0.28871,0.89018],[0.71698,0.66197,-0.21848],[-0.26053,-0.95675,0.1294],[-0.75738,0.50806,-0.41018],[-0.93705,-0.15588,-0.31248],[0.54265,0.80205,-0.2495],[0.87915,-0.32552,-0.34804],[-0.51562,0.75926,-0.39706],[0.19613,-0.0189,0.9804],[0.37122,0.8384,-0.39911],[0.45986,0.22081,0.8601],[-0.93474,-0.0036018,0.3553],[0.86812,-0.27339,-0.41427],[0.5578,0.75687,-0.3406],[0.27719,0.90918,-0.31073],[-0.84988,-0.30896,-0.4269],[-0.34408,0.85856,-0.3801],[-0.30673,-0.23758,0.92167],[0.40266,-0.75578,-0.51639],[0.95121,-0.061653,0.30233],[-0.065343,0.96047,-0.2706],[-0.71923,0.098454,0.68776],[-0.5287,0.82635,-0.19396],[-0.1717,0.93088,-0.32245],[0.77002,-0.57485,0.27681],[0.80613,0.32348,-0.4955],[-0.77862,0.51534,-0.35802],[-0.49057,-0.49785,-0.71518],[-0.72559,0.50917,-0.46288],[-0.90161,0.34537,0.26043],[0.37315,0.38897,-0.8423],[0.67448,0.45094,-0.58457],[0.27745,-0.82143,-0.49828],[0.45761,-0.021035,0.88891],[0.059627,-0.78457,-0.61717],[0.014427,-0.47954,-0.8774],[0.42148,-0.62448,-0.65755],[0.86527,0.47254,0.1674],[0.1281,0.66833,-0.73275],[0.38812,0.71779,-0.57805],[0.75615,0.45093,0.47423],[-0.30637,0.22528,0.92487],[-0.39858,0.81674,-0.41722],[-0.12455,0.84375,-0.52208],[-0.44461,-0.85542,-0.26567],[-0.2951,0.24435,0.92369],[-0.62236,0.22989,0.74821],[0.70368,0.46525,0.53701],[0.048504,0.74123,-0.6695],[0.13122,0.90979,-0.39378],[0.67664,0.091138,0.73065],[-0.96302,0.21738,0.15917],[0.44264,0.35894,0.82172],[0.18311,0.16496,0.96915],[0.81555,-0.31824,-0.48333],[0.90285,-0.17435,-0.39301],[-0.9966,0.048163,0.066876],[0.30225,0.22686,0.92584],[0.25108,-0.049929,0.96668],[-0.947,0.31665,0.054061],[0.86346,-0.16997,-0.47491],[-0.39465,-0.04151,0.91789],[-0.94527,0.32504,0.028636],[-0.98246,0.118,0.14442],[-0.36761,-0.71313,-0.59692],[0.91055,0.036351,-0.41179],[-0.94851,0.28132,0.14556],[-0.47386,-0.6959,-0.53961],[-0.17447,-0.73781,-0.65207],[-0.91468,0.16894,0.36718],[-0.65924,0.36787,0.6558],[-0.14362,0.29263,0.94538],[-0.16527,-0.8027,-0.57303],[-0.96588,0.24738,0.076718],[-0.79837,0.5909,0.11594],[-0.79262,-0.37371,-0.48175],[0.8038,-0.39062,-0.44869],[-0.96849,0.049363,0.24413],[0.92025,-0.23373,-0.31387],[0.00032331,0.23402,0.97223],[-0.97496,-0.11718,0.18899],[-0.76279,0.58679,0.27172],[0.12177,0.27426,0.95392],[0.2902,-0.83973,-0.45895],[0.094987,-0.86598,-0.49097],[0.11288,0.2043,0.97238],[-0.854,0.25872,0.45138],[-0.62323,0.3252,0.71122],[0.97125,-0.13123,-0.19862],[-0.72672,0.54599,0.41686],[-0.96101,0.1654,-0.22159],[-0.59221,0.76759,0.24514],[0.48358,-0.60908,-0.62863],[-0.82746,0.56017,-0.038912],[0.21058,0.18414,0.96008],[-0.67955,0.68948,0.25066],[-0.95512,-0.22962,-0.18714],[0.99302,-0.014377,0.11704],[-0.52113,-0.40766,-0.74983],[0.18494,-0.89729,-0.40082],[-0.62511,0.74847,0.22145],[-0.27183,-0.036578,0.96165],[-0.80379,0.39943,-0.44088],[-0.48602,-0.2299,0.84317],[0.41202,0.32149,0.85258],[-0.68252,0.694,-0.22918],[0.99037,0.0086226,0.13821],[-0.70054,0.70267,-0.12451],[0.86963,0.40457,0.28296],[0.43613,-0.56398,-0.70122],[0.69935,0.34165,0.62784],[-0.51203,0.69142,0.50967],[-0.95399,-0.047029,-0.29614],[0.015423,-0.85376,-0.52044],[0.37592,-0.73075,-0.56981],[-0.18442,-0.9687,0.16616],[-0.50491,-0.56233,-0.65487],[0.60183,0.68273,0.41435],[0.59955,-0.60382,-0.5253],[-0.84019,0.46353,0.28148],[0.55473,0.73742,0.38534],[-0.63846,-0.39989,-0.65762],[-0.90593,0.21904,0.36236],[0.655,-0.26181,0.70882],[0.53867,-0.4922,-0.68379],[0.72061,-0.4471,-0.52993],[-0.52419,-0.31677,-0.79049],[-0.57693,0.72425,0.37764],[0.46769,0.70149,0.53775],[0.94477,-0.1321,0.29992],[0.90124,-0.30769,-0.30512],[0.61304,0.62044,0.48912],[-0.97654,-0.1538,0.15073],[-0.84122,0.19794,0.50315],[-0.32947,0.91694,0.22508],[-0.1259,0.97834,0.16433],[0.13144,0.82984,0.5423],[0.4316,-0.67019,-0.6038],[-0.93232,-0.26421,0.24691],[0.28042,0.43284,0.85675],[0.91164,0.16089,-0.37818],[0.13165,-0.34615,0.9289],[-0.1996,-0.050972,0.97855],[0.92177,-0.16841,-0.34925],[-0.92097,-0.1832,0.34387],[-0.78233,0.36435,0.50518],[0.06382,-0.98584,0.15504],[-0.16265,0.27381,0.94793],[0.0088115,-0.26344,0.96464],[-0.34756,-0.60046,-0.72018],[0.015693,0.98626,0.16444],[0.56385,0.82174,-0.082594],[-0.63615,0.65824,0.40253],[0.95778,-0.2131,0.19298],[-0.25811,-0.55757,-0.78898],[0.032909,-0.80324,-0.59474],[-0.75628,-0.63385,0.16206],[-0.62129,-0.77872,-0.08716],[0.59014,0.69913,0.40367],[0.45019,-0.48436,-0.75015],[0.13811,-0.51986,-0.84301],[0.47188,-0.41998,-0.77521],[0.74284,0.54282,0.39183],[0.57614,-0.27676,-0.76906],[0.69446,0.16132,0.70121],[-0.022449,0.29562,0.95504],[-0.87935,-0.24405,0.40889],[-0.79251,0.12916,0.59603],[-0.07249,-0.67373,-0.73541],[-0.029286,0.23374,0.97186],[0.5834,0.72302,-0.36998],[-0.56111,0.49837,0.66089],[0.65838,0.60102,-0.45311],[-0.67865,0.47546,0.5598],[0.46987,0.86556,-0.1733],[0.026605,0.98629,0.16289],[0.20799,-0.29563,0.93238],[-0.13176,-0.99119,-0.013781],[0.40172,-0.80005,0.44558],[-0.59713,-0.74797,0.28979],[0.42021,0.46755,0.7777],[-0.051069,-0.96998,-0.23775],[-0.15907,-0.97568,-0.15083],[-0.15328,-0.98676,-0.053051],[-0.062218,-0.99709,-0.043979],[0.71613,-0.29005,0.63484],[-0.11721,-0.6252,-0.77161],[-0.2461,0.27358,0.92983],[0.54927,-0.82175,-0.15176],[0.2695,0.40901,0.87183],[0.70249,-0.4657,0.53817],[-0.28712,-0.56272,-0.77518],[-0.73802,-0.62958,-0.24283],[-0.47192,-0.78192,-0.40729],[0.021094,-0.85282,-0.52178],[0.18731,-0.85007,-0.49224],[-0.4129,-0.3067,-0.85758],[0.0047873,-0.9654,-0.26071],[-0.44515,-0.88951,0.10302],[0.72714,-0.47041,0.49998],[-0.70938,-0.48836,-0.50822],[-0.96162,-0.23725,0.13784],[0.21218,-0.96541,0.15153],[0.64588,-0.75617,0.10515],[0.20388,-0.96151,0.18421],[0.35236,-0.90105,-0.25289],[0.52401,-0.81717,-0.2401],[0.20053,0.42598,0.88223],[0.28958,-0.35811,0.88764],[-0.95398,-0.24902,0.1671],[-0.98394,0.14462,-0.10468],[0.6153,-0.78812,0.016589],[-0.69892,-0.6982,0.15501],[0.58902,0.79895,0.12139],[0.75931,-0.64522,0.084451],[-0.59066,0.67733,0.43858],[0.036662,-0.96845,0.24651],[-0.63798,-0.71698,0.28093],[-0.65993,-0.75108,-0.019569],[-0.12885,-0.97758,0.16653],[0.1956,-0.96755,0.15993],[-0.42919,-0.90063,-0.068337],[-0.83608,-0.5374,-0.11031],[-0.5063,-0.85643,0.10093],[-0.74726,-0.27395,0.60544],[-0.9198,-0.35246,-0.17243],[-0.95195,-0.11703,0.28303],[0.59326,0.67399,0.44021],[0.92276,-0.31373,-0.22382],[-0.39435,0.58886,0.7055],[0.93074,0.2987,-0.21096],[-0.84394,-0.5362,0.015961],[-0.44859,-0.41584,-0.7911],[0.22019,0.89262,0.39337],[0.31715,0.45498,0.83211],[-0.88223,-0.46481,-0.074976],[0.78612,-0.51872,-0.33606],[-0.085752,0.25886,0.9621],[0.8709,-0.3579,-0.3368],[0.88378,0.3955,-0.25003],[-0.96033,0.27858,-0.012622],[-0.68893,-0.59399,-0.4154],[-0.93359,-0.14851,0.32613],[0.4911,-0.67121,-0.55524],[-0.5623,0.6871,0.46012],[0.94425,-0.19318,0.26659],[0.88362,-0.42113,-0.20462],[0.23916,-0.90336,-0.356],[0.17054,0.074436,0.98253],[-0.85263,-0.51507,0.087921],[-0.95259,0.082027,0.29298],[0.90184,-0.30194,-0.30906],[-0.47424,0.81431,-0.33465],[0.71386,-0.55652,-0.42508],[0.83992,0.44608,-0.30911],[0.42369,0.75963,0.4934],[-0.17106,0.95924,-0.22494],[-0.98271,0.17984,0.043997],[-0.44126,0.85503,-0.27242],[-0.52596,-0.46508,-0.71209],[-0.39087,0.61449,0.68528],[0.081117,-0.37554,0.92325],[0.91441,0.27928,-0.29303],[-0.8555,0.45559,-0.24609],[-0.9569,0.20886,0.20178],[0.78685,0.5781,-0.21604],[0.75429,0.039108,0.65537],[0.05174,-0.97462,-0.2178],[-0.86117,-0.49487,-0.11616],[0.91956,-0.22457,0.32245],[0.001706,0.19674,0.98046],[0.50061,0.84623,-0.18242],[0.90976,-0.25365,-0.32862],[-0.61676,0.75981,-0.20568],[-0.34688,0.92823,-0.13437],[-0.2102,0.96466,-0.15891],[0.18934,0.48463,0.85398],[0.63792,-0.48364,-0.5993],[-0.24838,-0.96835,0.024497],[0.26081,0.92439,-0.27835],[0.060063,0.95581,-0.28777],[-0.58154,0.6347,0.50889],[-0.97213,0.18238,0.14731],[0.19532,0.16233,0.96721],[0.84558,-0.45673,-0.2764],[-0.99397,0.090767,0.061486],[0.90856,-0.067551,-0.41225],[0.44821,0.16193,0.87914],[0.25208,0.88651,0.38803],[-0.23016,-0.96008,0.15898],[-0.85185,-0.17578,0.49341],[-0.045482,-0.55649,0.82961],[0.19046,0.88327,0.42843],[0.88491,-0.23616,-0.40146],[-0.58835,-0.53272,-0.60832],[0.66085,-0.56984,-0.48841],[-0.28554,0.6179,0.73257],[0.65738,-0.54103,-0.52454],[-0.9042,0.40678,-0.13017],[-0.2272,0.58788,0.77639],[0.86289,0.3985,-0.31082],[0.88719,-0.18544,-0.4225],[-0.87916,0.037038,0.47509],[-0.83231,-0.13946,-0.53648],[0.11424,0.45673,0.88224],[-0.91557,0.091228,-0.39166],[0.96249,0.14915,-0.22666],[0.98283,0.13996,-0.12027],[0.23054,0.51465,0.82582],[-0.74346,0.53653,0.39924],[-0.71364,-0.34584,0.60919],[-0.91922,0.39293,-0.025414],[0.98552,0.12125,0.11854],[-0.69532,0.7172,-0.046405],[-0.94395,-0.26248,0.20015],[-0.9097,0.38677,-0.15116],[-0.91849,-0.34391,-0.19521],[-0.30224,0.92078,0.2466],[0.095275,-0.5839,-0.80622],[0.54068,0.8317,0.12626],[0.98659,0.059461,0.15199],[0.21136,0.47463,0.85443],[0.41117,0.91129,0.022179],[0.14066,-0.65237,-0.74473],[0.049737,-0.76598,-0.64094],[-0.58176,-0.35323,-0.73266],[0.81715,0.47839,-0.32157],[0.89633,-0.24008,0.37276],[-0.50758,-0.78854,-0.34721],[0.6207,-0.59024,-0.51609],[0.3026,0.87235,0.38399],[-0.30462,-0.60096,-0.73896],[-0.72833,0.68331,-0.051244],[0.082418,-0.48281,0.87184],[0.52327,0.71591,0.46223],[-0.16761,-0.52806,0.8325],[-0.56308,0.77197,0.29495],[0.21131,-0.23123,0.94967],[0.60569,0.078836,0.79178],[0.3103,0.70605,0.63655],[-0.95211,-0.28481,0.11117],[-0.68527,-0.36411,-0.63073],[-0.35573,0.77002,0.52964],[-0.4365,-0.006952,0.89968],[-0.88203,0.4675,-0.0589],[0.92977,0.088122,-0.35744],[-0.8557,0.50022,-0.13248],[0.035946,0.88319,0.46764],[0.11953,0.92633,0.35724],[-0.10748,0.58424,0.80443],[-0.91085,-0.097529,0.40105],[-0.48473,0.42825,0.76265],[-0.89445,0.23504,0.38041],[-0.83285,0.18658,0.5211],[-0.73569,0.57542,0.35728],[-0.37726,0.8684,0.32179],[-0.3701,-0.85093,-0.37276],[0.15288,-0.69746,-0.70013],[0.29394,-0.56884,-0.76813],[0.83739,-0.13596,-0.52943],[-0.086266,0.51861,0.85065],[0.81233,-0.32874,0.48172],[-0.84299,-0.46195,0.27563],[0.08946,0.59599,0.798],[0.72938,0.07741,-0.67971],[0.82162,0.52458,0.22308],[0.75445,0.29005,-0.58879],[-0.0088341,0.5992,0.80055],[0.78373,-0.59723,-0.17055],[0.72001,0.44658,-0.53118],[0.74354,0.60356,-0.28786],[-0.87959,0.15097,0.45115],[0.95389,-0.26674,0.13761],[-0.34649,0.85003,0.39672],[-0.74591,-0.17406,0.6429],[0.42292,-0.52134,-0.74118],[0.26617,0.96374,0.019012],[-0.42629,-0.54595,-0.72125],[0.20267,-0.91385,0.35185],[-0.77447,0.57429,-0.26531],[-0.44804,-0.89387,-0.016393],[0.082856,-0.97142,-0.22242],[0.66922,-0.41857,0.61396],[0.0094722,0.49394,0.86945],[-0.7061,-0.67617,-0.21027],[0.71714,-0.3749,0.58751],[-0.70177,0.70618,-0.094014],[0.39353,-0.84272,-0.36738],[-0.6166,-0.72035,0.31764],[-0.33258,0.1077,0.9369],[-0.98451,-0.04519,0.1694],[-0.90732,-0.42041,-0.0042629],[-0.16969,-0.98545,-0.0093395],[0.54467,-0.78272,0.30115],[-0.93469,-0.23175,0.26952],[0.37969,-0.91453,-0.13952],[-0.68018,-0.40256,0.61262],[-0.70555,-0.41785,-0.57236],[0.35015,-0.86048,-0.37009],[0.14618,-0.19363,0.97012],[0.77444,-0.62434,-0.10217],[-0.47655,-0.20178,0.85568],[-0.44442,0.35558,0.82223],[-0.84065,-0.37187,0.39372],[0.70305,-0.70563,0.088324],[-0.39162,0.57916,0.71499],[-0.50692,-0.43424,-0.74462],[0.83394,-0.55185,0.0015082],[0.56302,-0.4297,-0.70595],[-0.52447,-0.82743,0.20073],[-0.30986,-0.888,0.33976],[0.010844,-0.98408,0.1774],[0.44177,-0.81149,0.38252],[0.22481,0.78267,0.58042],[0.13306,-0.072822,0.98843],[0.98371,-0.17517,-0.040289],[-0.53429,-0.84528,-0.0064898],[-0.32568,-0.94321,0.065513],[-0.68816,0.71441,-0.12672],[0.54414,-0.81318,-0.2065],[0.97425,-0.22541,0.0049714],[0.43909,0.64039,0.63016],[-0.94985,-0.23481,-0.20653],[0.98856,0.058794,-0.13889],[-0.91247,-0.22981,0.33851],[-0.083019,0.57345,0.81503],[-0.6021,-0.394,-0.69444],[-0.91216,0.23151,-0.33818],[-0.057274,0.64892,0.7587],[-0.49382,0.032521,0.86896],[-0.48134,0.19138,0.85539],[0.6284,0.70585,-0.32694],[-0.68305,0.62891,-0.37137],[0.49979,0.81416,-0.29555],[-0.981,-0.1198,-0.1526],[0.78638,-0.40887,-0.46307],[0.32931,0.94169,0.069173],[0.29025,0.21358,0.93281],[0.23159,0.932,-0.27883],[0.30448,0.88514,-0.35188],[-0.60519,-0.34196,-0.7189],[0.41066,0.19301,0.89112],[0.92223,-0.35835,-0.14516],[0.63035,0.72005,-0.29016],[0.32256,0.89403,-0.31091],[-0.050304,0.96958,-0.23955],[-0.092841,0.95865,-0.26901],[0.66165,-0.34501,-0.66573],[0.98616,-0.059767,0.15462],[0.92342,-0.26145,-0.28098],[-0.53676,0.79296,-0.28827],[0.93285,0.2881,-0.21629],[-0.68122,0.41896,0.60035],[-0.82818,0.51175,-0.22854],[0.89674,0.39761,-0.19433],[0.90906,-0.24188,-0.33928],[-0.48898,0.84792,0.20478],[0.90005,0.087959,0.42682],[-0.37847,0.063082,0.92346],[0.78181,0.56384,-0.26618],[-0.97373,0.22262,0.047838],[-0.95512,-0.17004,-0.24257],[-0.71658,0.63652,-0.28523],[-0.28687,0.94986,-0.1244],[0.016766,0.99323,-0.11499],[0.11246,0.98106,-0.15773],[-0.92994,-0.2307,-0.28634],[-0.97935,0.070933,0.18931],[0.89394,-0.20128,-0.40044],[0.91694,-0.08763,-0.38929],[0.82059,0.29366,0.49031],[-0.93691,0.32489,0.129],[-0.63735,-0.30031,-0.70965],[-0.9881,0.15378,-0.0035036],[-0.77555,-0.48795,-0.40054],[-0.36974,-0.58548,-0.72146],[-0.96098,-0.20719,-0.18328],[-0.12346,-0.76203,-0.63566],[0.22125,-0.53111,0.8179],[0.08678,-0.71662,-0.69204],[0.14487,-0.70688,-0.69234],[0.31607,-0.65328,-0.68799],[0.78511,0.5268,-0.32571],[-0.96708,0.2365,-0.093943],[0.2104,-0.92847,0.30606],[0.49545,-0.55764,-0.66601],[0.741,-0.31568,-0.59268],[0.68266,-0.43176,-0.58954],[-0.72208,-0.3068,-0.62006],[0.72679,-0.34782,-0.59228],[-0.69437,0.67474,-0.25016],[-0.92774,0.36929,-0.054088],[0.87195,-0.44057,-0.21355],[-0.8788,0.22392,0.42139],[-0.3387,0.099359,0.93563],[-0.73363,0.032707,-0.67876],[-0.65591,-0.49725,-0.56792],[0.31008,0.034378,0.95009],[-0.77771,0.25178,-0.576],[0.91574,0.37457,-0.14531],[0.99557,0.0092867,-0.093605],[-0.85178,0.51899,0.071611],[0.99268,0.10229,-0.064166],[0.43338,0.035336,0.90052],[-0.84771,-0.5108,-0.14308],[-0.47278,0.12751,0.8719],[0.82969,0.5578,0.021611],[0.94417,0.17838,0.27701],[0.8913,0.40284,0.20809],[-0.6434,0.63222,-0.43167],[-0.54444,0.69337,-0.47204],[-0.9335,0.35317,0.062002],[0.93896,0.15356,0.30784],[0.96279,-0.055124,0.26455],[-0.17474,0.98428,0.025686],[-0.51113,0.85397,-0.097369],[-0.090085,0.98168,0.16787],[-0.65659,0.068315,0.75115],[0.98892,-0.054653,0.13802],[0.24708,0.9484,0.19874],[-0.79613,0.60322,0.047936],[0.79162,0.49741,0.35486],[0.80014,-0.47202,-0.3701],[-0.72608,0.68516,-0.057979],[-0.99267,-0.11418,-0.039702],[0.099047,-0.30838,0.94609],[-0.2553,-0.7662,-0.58971],[0.58761,-0.58433,-0.55972],[-0.78195,-0.40902,-0.47038],[-0.65841,0.7168,-0.22957],[-0.66294,-0.73292,-0.1528],[-0.53846,0.76559,-0.35203],[0.98114,-0.028172,0.19124],[-0.32677,-0.015049,0.94499],[0.64181,-0.52672,-0.55735],[-0.93404,0.34892,0.076343],[0.40198,0.042361,0.91467],[-0.78399,0.16212,0.59923],[0.29961,0.75025,0.58937],[-0.91244,-0.40214,0.075783],[-0.30328,0.66807,0.67949],[0.90906,-0.28514,-0.30381],[-0.84848,-0.088183,-0.52183],[0.67425,0.59359,-0.43937],[0.21686,0.75766,0.61557],[0.98164,-0.095973,-0.16484],[0.89819,-0.12342,-0.42192],[-0.88286,-0.39352,-0.2563],[0.23447,0.049279,0.97087],[-0.18373,0.68191,0.70798],[-0.85265,-0.48546,-0.19318],[-0.97574,-0.071954,0.20675],[-0.91599,-0.013207,0.40099],[0.91454,0.31621,-0.25225],[-0.39369,0.15353,0.90633],[-0.9316,-0.19799,-0.30484],[0.85244,0.50042,-0.15141],[-0.8054,-0.37725,-0.45717],[-0.24569,0.93195,0.26667],[0.0010377,0.98322,0.18243],[0.37204,0.92773,0.030085],[-0.27564,-0.81223,-0.5141],[-0.069524,-0.75216,-0.65531],[0.35157,-0.55324,-0.7552],[-0.81272,-0.57908,0.064426],[0.51345,-0.4075,-0.75519],[-0.42905,0.034668,0.90261],[0.59106,-0.21485,-0.77749],[0.98653,-0.12575,-0.10459],[-0.82837,0.52524,0.19475],[-0.97327,-0.1359,-0.18516],[-0.22449,0.11751,0.96737],[0.99564,0.00030539,0.093286],[-0.42584,0.83701,-0.34362],[0.69108,0.26029,0.67428],[0.28098,0.2073,0.93706],[-0.23575,-0.047032,0.97068],[0.70434,0.60995,-0.36314],[0.99875,0.0018963,0.049993],[0.22817,-0.93819,0.26027],[0.57267,0.79239,-0.21016],[0.90357,-0.11342,-0.41317],[-0.86644,-0.062009,-0.49542],[-0.31366,-0.86451,-0.39273],[0.26604,-0.89674,-0.35366],[0.63847,0.67122,-0.37659],[-0.99486,0.005091,-0.10109],[0.97686,0.076642,0.19967],[0.17227,-0.98177,-0.080351],[-0.0072607,-0.99226,-0.124],[-0.0587,-0.98357,-0.17072],[0.19947,-0.97987,0.0076817],[0.028284,-0.99358,0.10958],[0.998,-0.057927,-0.025204],[-0.32248,-0.031379,0.94606],[-0.68728,-0.72252,0.074957],[-0.31812,-0.94757,-0.030083],[0.23059,-0.95584,-0.18222],[-0.9931,0.086701,0.07898],[0.98725,-0.045781,0.15247],[-0.624,-0.72968,0.27963],[-0.16705,0.0067338,0.98592],[-0.82956,-0.12006,0.54535],[0.22488,-0.93143,-0.28612],[0.48026,-0.83331,0.27374],[0.19802,-0.98002,0.018469],[0.084116,-0.97378,-0.21137],[0.17056,-0.92866,-0.32938],[-0.88258,-0.10882,0.4574],[0.82074,-0.52834,0.21735],[-0.62012,-0.73426,0.27624],[-0.43542,0.81588,-0.38047],[-0.99542,0.037881,-0.087797],[-0.52062,-0.85308,0.034882],[0.92945,-0.36888,-0.0068083],[0.97339,0.014907,0.22865],[-0.06185,-0.97119,0.23014],[0.099004,-0.99487,-0.02064],[-0.9109,0.074978,-0.40575],[0.42341,-0.89608,-0.13329],[0.93366,-0.30684,0.18475],[-0.98194,0.008279,0.18902],[0.95131,0.089203,0.29505],[-0.38108,-0.87271,0.3052],[-0.43488,-0.84422,0.31333],[0.96533,-0.0091733,0.26088],[-0.86602,0.25341,0.43105],[0.6649,-0.6774,-0.31472],[0.87513,-0.26107,0.40742],[-0.95888,-0.087386,-0.27001],[-0.80116,-0.46838,0.37251],[0.91457,0.090091,0.39427],[-0.8548,0.23953,0.46037],[0.98072,-0.1944,0.020128],[-0.9709,0.041924,-0.23581],[-0.83298,-0.40239,0.37978],[-0.86139,-0.14369,0.48719],[0.15637,-0.94139,0.2989],[-0.85077,0.51506,0.10442],[0.27179,-0.81957,0.50442],[0.095622,0.23344,0.96766],[-0.87362,-0.17975,0.45219],[-0.81437,0.5125,-0.27229],[0.87185,-0.25759,0.41656],[-0.90131,-0.11166,0.41853],[0.079577,0.0051455,0.99682],[-0.6254,0.72352,-0.29223],[0.81908,0.17543,0.5462],[-0.94176,0.011843,0.33608],[0.88318,-0.24215,-0.40169],[-0.28767,-0.39492,0.87251],[0.47327,0.78363,-0.40242],[-0.96563,-0.20742,-0.15661],[-0.35809,0.88623,-0.29387],[-0.18501,0.95483,-0.23254],[0.49352,0.77186,-0.40085],[0.86173,0.43359,-0.26349],[-0.84117,0.077463,0.5352],[-0.93679,0.059381,0.34483],[-0.083643,0.06786,0.99418],[-0.98521,-0.10886,0.13236],[0.95748,0.14015,0.25216],[0.28009,-0.84036,0.46406],[-0.99347,0.10108,-0.05287],[-0.80793,0.56345,-0.17255],[0.68208,0.70455,-0.19592],[0.12631,0.10983,0.98589],[-0.44125,0.88173,-0.1669],[0.26301,0.95199,-0.15663],[-0.63952,0.66041,-0.39354],[0.11493,0.95306,-0.28014],[-0.96792,0.24047,0.072829],[0.94,0.047887,0.3378],[-0.93499,0.22561,0.27368],[0.91024,-0.11044,-0.39907],[0.069809,-0.26058,0.96292],[0.90562,-0.10593,-0.41065],[-0.42859,-0.69481,-0.57754],[0.23303,0.22849,0.94525],[0.23284,-0.87945,-0.41515],[0.60756,-0.42066,0.67373],[0.34608,-0.78337,-0.51629],[0.95673,0.045538,0.28738],[-0.99463,0.050762,-0.090186],[0.44213,-0.38591,0.80968],[-0.5799,-0.55992,-0.59178],[0.57819,-0.56456,-0.58904],[0.89679,-0.13956,-0.41988],[-0.95955,0.26716,-0.088817],[-0.9895,-0.11475,-0.087869],[0.85902,-0.31688,-0.40208],[0.94245,-0.14064,-0.30333],[-0.38851,-0.47179,0.7915],[0.75193,0.18079,0.63396],[-0.773,-0.1642,-0.61278],[0.67055,-0.16444,0.72341],[0.93982,0.036884,-0.33968],[-0.95161,0.28814,0.10683],[-0.67057,0.10981,0.73367],[-0.8745,0.42352,-0.23638],[0.97184,-0.11221,-0.2072],[-0.69811,-0.017414,-0.71577],[0.84004,-0.15155,0.52093],[0.92244,0.27718,-0.26885],[-0.92979,0.36284,0.061874],[-0.036411,-0.36364,0.93083],[-0.97777,-0.033344,-0.20703],[-0.62399,0.58462,-0.51851],[0.30051,-0.20033,0.9325],[-0.27592,0.14584,-0.95005],[0.36208,0.0081139,0.93211],[-0.90343,0.42556,0.052019],[-0.193,0.43085,-0.88155],[0.93322,-0.10407,0.34391],[0.67516,0.54005,-0.5025],[-0.225,-0.014473,-0.97425],[0.03417,0.067065,-0.99716],[-0.25323,0.65067,-0.71589],[-0.47993,0.76574,-0.42815],[0.20478,-0.065943,-0.97658],[0.89606,-0.13489,-0.42295],[-0.12206,0.94445,-0.30514],[0.84291,0.22637,0.48812],[-0.079354,-0.44979,-0.8896],[-0.99325,-0.099663,-0.059345],[0.21256,-0.49798,-0.84073],[0.66949,0.22265,0.70866],[-0.79931,0.53073,0.28182],[0.19321,-0.16911,0.96647],[0.58474,0.57375,0.57349],[-0.5545,-0.56053,-0.61508],[0.31068,-0.72777,-0.61141],[0.43889,-0.54841,-0.71178],[0.60136,0.65071,0.46363],[-0.94282,-0.10258,-0.31714],[-0.69668,-0.60143,-0.39106],[0.67223,-0.38088,0.63486],[0.92366,0.38322,-0.00028075],[0.14773,-0.2063,0.96727],[0.5837,0.63861,0.50148],[0.57766,-0.4617,-0.67316],[0.64251,-0.35204,0.68063],[0.6823,-0.23803,-0.69123],[0.67333,0.18327,0.71627],[-0.68312,0.70871,-0.17628],[0.33667,-0.12574,0.93319],[-0.39667,-0.43407,0.80885],[0.28604,0.69429,0.66041],[-0.39423,0.91397,0.096113],[-0.06046,0.96634,0.25007],[-0.11436,0.86385,0.49059],[0.6933,0.57104,-0.4396],[-0.82404,-0.51748,0.23062],[0.30942,0.7135,0.62863],[-0.85728,-0.50835,-0.081549],[0.81966,-0.2936,-0.49189],[-0.18354,0.67669,0.71303],[-0.30161,0.84101,-0.44915],[-0.026751,0.77557,0.63069],[-0.65706,0.23005,0.71788],[-0.98217,-0.16042,0.098028],[-0.099978,0.87041,-0.48206],[-0.7233,0.58666,-0.36424],[0.3984,-0.095435,0.91223],[-0.36864,0.50233,0.78215],[0.16825,0.24084,0.95587],[0.75518,0.65314,-0.055775],[-0.56968,0.52593,0.63156],[0.65868,0.75226,-0.015726],[-0.32311,0.89917,0.29511],[0.95598,0.2916,0.032726],[-0.40643,0.84122,-0.3566],[0.11319,-0.69763,-0.70746],[-0.67685,-0.43085,0.59686],[0.012303,0.36488,0.93097],[-0.66915,-0.71868,-0.18903],[0.49672,-0.42261,-0.75807],[-0.88299,-0.45935,0.096568],[-0.89995,-0.40227,0.16815],[0.68474,-0.11968,-0.71889],[-0.99679,-0.024825,0.07611],[0.25671,-0.44027,0.86039],[-0.91509,-0.2283,0.33238],[-0.90958,-0.34252,0.23525],[0.99574,0.090072,0.019502],[0.77888,0.4234,-0.46268],[-0.73922,0.65436,-0.15925],[-0.97092,-0.049425,0.23423],[-0.68324,0.56707,0.46001],[-0.64656,0.65029,0.39885],[-0.95193,0.15861,0.26205],[-0.453,0.76543,0.45707],[-0.15319,0.93077,0.33196],[0.080894,0.97319,0.2153],[-0.53266,0.109,0.83928],[-0.70777,-0.69987,-0.096142],[0.2988,-0.9385,-0.17301],[-0.98332,0.13494,-0.12194],[-0.75919,-0.61507,0.2129],[-0.95649,-0.13295,-0.2597],[0.56655,-0.60714,0.55714],[0.53236,0.78761,-0.31025],[0.70045,-0.32947,0.63311],[-0.43937,-0.34144,0.83089],[-0.73468,-0.39189,0.55378],[-0.27395,-0.92995,0.24523],[0.82591,0.55138,0.11775],[0.86335,0.45909,0.20942],[-0.73574,0.49187,0.46556],[0.37929,-0.87706,-0.29478],[-0.24918,-0.96205,-0.11124],[0.75903,0.053939,0.64882],[0.072769,-0.98679,-0.14475],[0.15534,-0.95387,-0.25689],[0.64906,-0.7457,0.15047],[0.38117,-0.76023,0.52608],[0.096955,-0.42621,0.89942],[0.87173,-0.44133,0.21286],[-0.86764,-0.26758,0.41905],[-0.84859,-0.43142,0.30623],[0.48236,-0.84294,0.23827],[-0.63488,-0.66482,0.39362],[-0.62946,-0.77677,-0.020309],[0.031833,0.36434,0.93072],[0.55928,-0.82734,0.052085],[0.74291,-0.66905,-0.021404],[0.73904,0.67302,0.029386],[-0.18628,-0.98137,0.047092],[0.012952,-0.994,-0.10857],[0.11586,-0.98592,-0.12056],[-0.65404,-0.75596,0.02745],[0.93427,-0.30457,-0.18542],[-0.99648,-0.080902,-0.021986],[-0.4383,-0.79597,0.41753],[0.3904,-0.90025,-0.19274],[0.075842,-0.99616,-0.043757],[-0.88125,-0.46128,-0.10301],[0.53196,0.76038,-0.37261],[-0.32091,-0.85013,0.41748],[0.46141,-0.81368,-0.35358],[0.94107,-0.19282,-0.27785],[0.97449,-0.038996,0.22101],[-0.50686,-0.64548,0.57136],[-0.52011,0.81404,-0.25851],[0.82027,-0.35068,-0.45187],[-0.41477,0.84048,-0.34864],[0.91069,0.33195,-0.24585],[-0.94831,0.26169,-0.17953],[0.76589,0.58483,-0.26719],[0.844,-0.30553,-0.44081],[0.523,0.26866,0.80888],[-0.75562,-0.65392,0.037794],[0.037357,0.92085,0.38812],[0.68921,-0.2667,0.6737],[0.33896,-0.23741,0.91035],[0.36051,0.90927,-0.20799],[0.40939,0.8524,-0.3253],[0.27507,0.91027,-0.30944],[0.28957,0.33798,0.8955],[-0.20349,-0.42381,0.8826],[0.33348,0.3561,0.87291],[-0.82238,-0.43654,-0.36486],[-0.10037,0.95507,-0.27886],[-0.27336,0.90189,-0.33448],[-0.66921,0.66438,-0.3328],[0.57436,0.8186,-0.0038806],[-0.83827,0.4718,-0.27334],[-0.99104,0.12781,-0.038668],[0.43513,-0.17986,0.88222],[-0.37061,0.1832,0.91054],[-0.80109,-0.1914,0.56712],[0.96793,0.13775,0.2101],[0.85529,-0.2848,-0.43285],[-0.33126,0.84752,-0.41471],[0.34034,0.93689,-0.080102],[0.46191,0.82598,-0.32309],[-0.83639,0.20664,0.50769],[-0.41771,-0.38701,0.82204],[-0.93333,0.35799,-0.027132],[-0.85302,0.48101,0.20245],[0.9485,0.17583,0.2635],[-0.97296,-0.22979,0.023289],[-0.97026,0.10472,0.21824],[-0.67138,-0.49667,0.55006],[0.17693,0.37453,0.91018],[0.41308,0.85807,-0.3051],[-0.027679,-0.90538,-0.4237],[-0.50553,-0.62225,-0.5977],[-0.22663,-0.81629,-0.53133],[0.24481,-0.831,-0.4995],[0.3945,-0.84902,-0.35148],[-0.13904,0.062452,0.98832],[-0.9852,-0.0040211,0.17135],[0.35605,0.29258,0.88748],[0.94851,0.20001,0.24562],[-0.23251,0.19815,0.95219],[0.74929,-0.62355,-0.22305],[-0.74293,-0.22729,0.62959],[-0.4128,-0.61216,0.67442],[-0.79516,-0.44206,-0.4151],[-0.84026,-0.32474,-0.43418],[-0.9748,-0.21644,0.054068],[-0.61294,0.61018,-0.50199],[-0.96635,-0.11818,-0.22847],[0.57967,-0.22449,0.78332],[0.96537,-0.07213,-0.2507],[-0.89031,0.45334,0.042851],[0.93115,0.2492,0.2662],[-0.72565,0.65025,0.22496],[0.81502,-0.39432,0.42457],[-0.076425,0.34512,0.93544],[0.97541,0.11257,-0.18948],[-0.91671,0.35834,0.17673],[-0.94649,-0.18909,-0.26153],[0.91185,0.14996,0.38216],[-0.16805,-0.41928,0.89217],[0.92221,0.36147,0.13735],[-0.048428,-0.47794,0.87706],[0.81407,0.069119,0.57665],[-0.49053,-0.087221,-0.86705],[-0.81724,-0.36906,-0.44262],[-0.019616,-0.57661,0.81678],[0.19572,-0.62595,0.7549],[-0.79745,-0.43942,-0.41349],[0.80084,0.57192,-0.17769],[-0.91347,-0.25331,0.31846],[0.86421,0.33652,0.37402],[-0.58578,-0.028622,-0.80996],[0.21859,0.16635,-0.96153],[0.66999,0.73724,-0.087144],[0.41529,0.90688,-0.071382],[0.25271,0.12874,-0.95894],[0.047323,0.96767,-0.24774],[0.15932,0.49195,-0.85592],[0.17497,0.98453,-0.0091616],[0.49414,-0.60462,0.62471],[-0.39817,-0.49402,0.77292],[0.79357,0.12212,0.5961],[0.6286,0.46277,0.62506],[-0.55194,-0.15159,-0.81999],[0.12996,0.32281,0.9375],[0.29157,-0.31158,-0.90438],[0.34206,-0.26803,-0.90064],[0.15826,-0.020754,-0.98718],[0.54873,0.094,-0.8307],[-0.80786,0.51481,0.28695],[0.090583,0.99554,-0.026318],[-0.67911,-0.28126,-0.67801],[0.19918,0.30264,0.93206],[-0.84086,-0.41077,-0.35245],[0.67566,-0.3746,-0.63495],[-0.38117,0.098383,0.91926],[-0.73573,0.62406,0.26315],[-0.73842,0.65239,0.17069],[0.41866,0.66783,0.61541],[-0.1847,-0.43567,0.88095],[-0.88461,-0.35583,-0.30139],[0.139,0.88317,0.44798],[-0.058518,0.8717,0.48654],[-0.96823,-0.15124,-0.19912],[-0.80925,0.31453,0.49618],[-0.95491,-0.24019,-0.17451],[-0.75763,0.34876,-0.55169],[0.94643,0.1099,-0.30363],[-0.98338,0.18141,0.007086],[0.93978,0.25395,-0.22872],[-0.93323,0.18342,0.30894],[0.69012,-0.24102,0.68238],[0.90106,0.40109,-0.16498],[-0.13901,-0.39034,0.91012],[0.75354,0.60661,-0.25337],[-0.6626,0.6593,0.35537],[-0.86144,0.27928,0.42418],[0.041988,-0.75777,0.65117],[-0.23523,0.93446,0.26729],[0.87658,-0.45366,0.16065],[0.47219,0.87816,0.076555],[0.34274,0.93425,0.098522],[0.92614,0.2321,0.2973],[-0.81839,0.2152,0.53285],[-0.38093,-0.8118,-0.44258],[-0.054198,-0.78277,-0.61994],[0.96778,-0.034182,0.24946],[0.30043,-0.58395,-0.75415],[0.18447,0.22718,0.95622],[0.93951,0.011699,0.34232],[0.55181,-0.37555,-0.74462],[0.87533,-0.10998,0.47085],[-0.013127,0.34894,0.93705],[0.15228,-0.79363,0.58904],[0.24301,0.02867,0.9696],[0.80853,0.26242,-0.5267],[-0.81702,0.26727,0.51092],[-0.76905,0.63792,0.040269],[0.60441,0.79034,-0.10022],[0.72084,0.65753,-0.21921],[0.40454,0.23572,0.88362],[0.31741,0.94473,0.082072],[0.40704,0.91218,0.047451],[0.48011,-0.80792,-0.34171],[0.26553,-0.96384,-0.022624],[-0.86691,-0.46383,-0.18256],[0.23482,-0.9426,-0.2374],[0.44306,-0.86809,-0.22389],[-0.077454,-0.90087,-0.42713],[0.26178,-0.96431,-0.039607],[0.64316,-0.75846,-0.10528],[-0.93428,-0.3422,-0.1001],[0.15309,-0.96325,-0.22071],[-0.79855,0.31511,-0.51285],[0.65467,-0.47847,0.58521],[-0.93835,-0.3442,0.032139],[-0.81912,0.3266,-0.47157],[0.64217,-0.19779,0.7406],[0.12337,-0.94861,-0.2914],[0.65359,-0.41112,0.63545],[-0.29889,-0.94769,-0.11206],[0.66091,-0.43635,0.61057],[0.49531,-0.86661,-0.060384],[-0.80442,-0.15371,0.57383],[0.069786,-0.92624,-0.37042],[0.56931,-0.71775,0.40091],[-0.2102,0.10995,0.97146],[0.194,-0.98083,-0.018602],[0.64473,-0.47366,0.59997],[-0.86374,-0.21869,0.45401],[0.70039,-0.4132,0.58199],[-0.81479,0.074058,0.575],[-0.74239,-0.6667,-0.066022],[-0.065064,0.21211,0.97508],[-0.55345,-0.70503,-0.44343],[0.71299,-0.69979,0.044071],[-0.57776,-0.78693,-0.21663],[0.65829,-0.34257,0.6703],[-0.36373,-0.9002,0.23945],[-0.19332,-0.98112,0.0061253],[0.080367,-0.99652,0.022075],[0.014191,0.18667,0.98232],[0.87946,-0.40895,-0.24355],[0.80554,0.49864,-0.32011],[-0.45897,-0.82618,0.32675],[-0.1305,-0.46797,0.87406],[-0.44042,-0.76216,0.47448],[0.71622,-0.55988,-0.41662],[0.6223,-0.2004,0.75669],[-0.98191,-0.1306,-0.13712],[-0.85296,-0.49538,0.1645],[-0.69918,-0.335,0.63161],[-0.087209,-0.55449,0.82761],[-0.4089,0.85594,-0.31649],[0.11793,-0.046943,0.99191],[0.95929,0.050399,-0.27788],[-0.79981,-0.2379,0.55109],[-0.96118,-0.24672,0.12355],[0.63594,-0.77171,0.0064494],[-0.40864,-0.85068,0.3307],[-0.01584,-0.94823,0.31719],[0.69121,-0.59537,0.40959],[-0.9124,-0.24464,0.32815],[-0.88523,0.42357,-0.19225],[0.5786,0.74521,-0.33148],[-0.72357,0.66345,-0.19049],[-0.78835,0.12449,0.6025],[0.13236,-0.64826,0.74983],[-0.87483,-0.30289,-0.37807],[0.34944,-0.66192,0.66314],[-0.26155,-0.95586,0.13388],[-0.3542,-0.8935,0.27602],[-0.51896,-0.7498,0.41046],[-0.17599,-0.10552,0.97872],[0.82573,-0.23234,-0.514],[0.44239,-0.29419,0.8472],[-0.052257,-0.094373,0.99416],[0.60267,-0.77331,-0.19692],[0.80231,-0.22497,-0.55289],[-0.86917,-0.49408,0.020706],[-0.94938,-0.071979,0.30577],[0.87591,0.39766,-0.27322],[-0.96677,-0.14848,0.20813],[0.17527,-0.86156,0.47645],[0.080899,-0.25078,0.96466],[0.026147,-0.23329,0.97205],[-0.74185,0.56639,-0.35898],[0.94414,-0.0033109,0.32952],[-0.27232,-0.29461,0.916],[0.74535,-0.070016,0.66299],[-0.38335,0.67336,-0.63216],[-0.2574,0.51553,-0.8173],[0.84815,-0.028533,-0.52898],[-0.28255,0.79833,-0.53182],[0.0040023,0.88795,-0.45993],[-0.35743,-0.70055,0.61764],[0.17148,0.73994,-0.65045],[-0.0049731,-0.19437,0.98092],[0.3126,0.76889,-0.55775],[0.87403,-0.17002,-0.45515],[0.15038,0.51057,-0.84659],[-0.90597,0.32431,0.2721],[0.73603,-0.65494,-0.17123],[-0.96464,0.14031,0.22313],[-0.92467,0.23404,0.30036],[0.75255,0.57083,-0.32837],[0.90502,-0.087143,-0.41635],[-0.97235,0.2014,0.11817],[0.81254,0.51599,-0.27115],[0.027821,-0.73195,-0.68079],[-0.096277,0.19731,0.9756],[-0.4288,-0.53516,0.72783],[0.63859,-0.14303,0.75614],[0.29008,-0.75165,-0.59235],[0.35311,-0.1924,0.91558],[0.49796,-0.69509,-0.51854],[-0.72682,-0.50072,-0.47011],[0.75856,-0.5112,-0.40406],[0.043012,-0.38303,0.92273],[-0.75777,0.36737,-0.53928],[0.81904,0.025441,0.57317],[-0.93459,0.28231,0.21645],[-0.88187,-0.3464,-0.31985],[0.8799,-0.45475,-0.13777],[0.95562,-0.28449,-0.076484],[0.34429,-0.46783,0.814],[0.96188,-0.074692,-0.26306],[-0.94153,-0.23004,-0.24617],[0.067932,-0.521,0.85085],[-0.92649,0.33706,0.16736],[-0.96935,-0.029883,-0.24386],[-0.8965,-0.44201,-0.030157],[-0.86932,-0.48979,-0.066207],[-0.099945,-0.38618,0.91699],[0.99979,0.020329,-0.0024428],[-0.97524,-0.17559,-0.13442],[-0.032073,-0.50488,0.86259],[-0.86674,-0.47958,-0.13694],[-0.037778,-0.40659,0.91283],[0.23033,-0.79363,0.56312],[0.3315,-0.8042,0.49333],[-0.72553,0.42338,0.54255],[0.7741,0.53591,-0.33701],[-0.80161,0.55199,0.22963],[0.80419,0.55958,0.20039],[-0.76213,-0.19285,-0.61803],[-0.081673,-0.47944,0.87377],[0.86869,-0.37479,-0.3239],[-0.43929,-0.48351,0.75713],[-0.19688,-0.9782,0.066106],[0.75516,0.35037,0.55405],[-0.68998,0.44787,-0.56863],[0.10405,0.14003,0.98467],[-0.69602,-0.10314,-0.71058],[0.7078,-0.642,-0.29472],[0.3951,0.60871,-0.68802],[0.13714,-0.50921,0.84964],[0.32063,0.87369,-0.36586],[0.60748,-0.15708,0.77865],[0.68425,0.45744,0.56794],[0.5925,0.35021,-0.72547],[-0.41283,-0.16017,0.89661],[-0.75075,0.56157,0.34788],[-0.77275,-0.12015,-0.62324],[0.69938,0.045774,-0.71329],[-0.73194,0.50917,0.45279],[-0.18525,-0.98139,0.050541],[0.30965,0.80842,0.50057],[-0.032853,-0.43954,0.89762],[0.22951,0.79969,0.55481],[0.51891,-0.71619,0.4667],[0.72333,-0.33293,-0.60494],[0.76948,0.51551,-0.37703],[-0.1686,-0.98568,0.00033719],[0.035611,-0.39439,0.91825],[-0.89488,-0.29232,-0.33724],[0.44037,0.19934,0.87541],[0.74623,0.20751,0.63251],[0.86855,-0.17051,-0.46535],[-0.63041,-0.50494,0.5896],[0.0042429,0.83508,0.55011],[0.31323,0.81026,0.49534],[0.92718,-0.015471,-0.37429],[-0.98405,-0.026914,-0.17583],[-0.90855,0.072643,-0.41141],[-0.12665,-0.47456,0.87106],[-0.93938,0.34003,0.043988],[0.74893,-0.18451,0.63644],[0.50809,0.85794,0.076057],[0.65285,0.70189,0.28485],[0.87749,0.46961,-0.097369],[0.80121,0.59786,-0.025118],[-0.39615,0.8453,0.35851],[-0.17192,-0.82826,-0.53332],[-0.88959,-0.45599,0.026397],[-0.71321,0.50662,-0.48444],[0.020663,-0.76052,-0.64898],[0.9083,-0.18537,0.37499],[0.76828,-0.63817,-0.049764],[-0.70737,-0.69218,-0.14323],[-0.49273,-0.80262,-0.33618],[0.46245,-0.48073,-0.74501],[0.60519,-0.12862,0.78562],[0.19015,-0.25228,0.94879],[-0.87104,-0.47632,0.12003],[0.7631,-0.066187,-0.64289],[-0.93475,-0.32013,0.15416],[0.028339,-0.43049,0.90215],[-0.91571,-0.14103,0.37628],[-0.48476,0.0648,0.87224],[0.78352,0.55706,-0.27529],[-0.60885,0.58614,-0.53455],[-0.49974,0.81736,-0.28669],[-0.0057602,-0.5546,0.8321],[0.092776,-0.54923,0.8305],[-0.30591,0.8109,0.49886],[-0.13875,0.89786,0.41786],[0.21393,-0.16464,0.96287],[-0.84956,-0.52408,0.059891],[-0.34354,-0.84997,-0.39941],[0.25192,-0.45966,0.85162],[0.15614,-0.21657,0.9637],[0.99553,-0.022512,0.091689],[0.67567,-0.63647,-0.37197],[0.89567,-0.18968,0.40224],[-0.68412,-0.72517,0.078187],[0.44061,-0.10895,0.89106],[0.73096,-0.34664,0.58782],[-0.7775,-0.50067,0.38056],[-0.43002,-0.89532,-0.11615],[-0.12812,-0.94335,-0.30605],[-0.85619,-0.085748,0.5095],[0.56887,-0.688,0.45061],[0.63167,-0.60148,-0.48909],[-0.85417,-0.31324,0.41506],[0.55749,-0.50088,0.66206],[0.12877,-0.99091,-0.039027],[0.081663,-0.99492,-0.058784],[0.27892,-0.90805,0.31249],[-0.46094,-0.26816,0.84595],[0.68518,-0.34549,0.64122],[-0.48605,-0.83023,-0.2729],[-0.30377,0.0099446,0.95269],[-0.44208,0.057101,0.89516],[0.66769,0.61543,-0.41886],[-0.50501,-0.7291,-0.46194],[0.65712,-0.51733,0.54824],[-0.81524,-0.5338,-0.22459],[-0.19431,-0.34329,0.91891],[0.31103,-0.83432,0.45516],[0.10243,-0.98281,0.15357],[0.48714,-0.87231,0.042093],[0.75054,-0.64357,-0.15002],[-0.48087,0.76634,-0.426],[-0.98764,-0.12656,0.092484],[-0.46289,-0.85102,0.248],[0.24855,-0.96776,0.040794],[-0.80446,-0.58998,0.069006],[0.13172,-0.25919,0.9568],[0.37755,-0.81118,-0.44659],[0.56998,-0.64317,0.51133],[-0.38785,-0.90831,0.15664],[-0.69705,-0.71702,-0.00055482],[0.91962,0.1508,0.3627],[-0.42496,-0.88806,0.17538],[-0.77868,0.23121,0.58326],[0.4919,-0.61131,-0.61995],[-0.27987,0.12875,0.95136],[-0.84372,-0.11065,0.52526],[-0.93248,-0.34677,-0.10119],[0.65947,-0.29198,0.69271],[-0.59093,-0.79105,0.15823],[0.7294,-0.36778,-0.57681],[0.96855,-0.084833,-0.23392],[-0.7153,-0.47611,0.51153],[-0.065801,-0.46159,0.88465],[-0.54292,0.76255,-0.35178],[-0.43401,-0.51619,0.73837],[-0.82887,-0.40029,0.39081],[0.96173,-0.20467,0.18215],[-0.5456,0.63122,-0.55126],[0.75641,-0.29357,-0.58451],[-0.98722,0.058201,-0.14835],[0.78812,0.54655,-0.28312],[-0.8506,-0.15689,0.50186],[-0.96062,0.22802,-0.15878],[-0.83404,-0.32666,0.4446],[0.44343,-0.21652,-0.86976],[0.76433,-0.23343,-0.60108],[0.5808,-0.66099,0.47515],[0.33797,0.85379,-0.39601],[0.6124,0.69607,-0.37476],[-0.93025,-0.00044544,0.36692],[-0.51586,0.83597,-0.1872],[0.52329,0.76905,-0.36706],[-0.25822,0.95735,-0.12966],[0.54148,0.73365,-0.41056],[0.30638,0.87575,-0.37309],[-0.55056,-0.46208,0.69524],[-0.65031,0.5858,-0.48367],[0.78038,-0.21835,-0.58594],[-0.17653,0.97691,-0.12035],[-0.1811,0.9558,-0.23164],[0.32515,0.18578,0.92723],[0.81852,0.40484,-0.40759],[-0.84869,-0.094987,0.52029],[-0.94928,-0.1486,0.27711],[-0.83894,0.27188,-0.47144],[0.70311,0.2897,0.64939],[0.55837,0.37398,-0.74052],[-0.0030831,-0.53354,0.84577],[-0.87755,0.28226,0.3876],[0.77017,-0.20939,-0.60249],[-0.67109,0.40259,-0.62254],[-0.95977,-0.25555,-0.11638],[0.94605,-0.21306,0.24413],[-0.39436,0.39421,-0.8301],[0.54514,-0.22862,0.80657],[0.2418,0.42504,-0.87228],[-0.15884,0.35135,-0.92267],[-0.040825,0.4411,-0.89653],[-0.67138,0.36544,-0.64475],[0.15407,0.34165,-0.92711],[0.14671,0.30641,-0.94053],[0.61412,0.061423,0.78682],[-0.81435,-0.556,0.16643],[-0.75997,-0.418,0.49772],[0.05573,0.44051,-0.89602],[0.1559,0.33372,-0.92969],[0.53551,-0.088786,-0.83985],[0.90518,-0.096496,-0.41393],[-0.33152,0.49566,-0.80276],[-0.65252,-0.67708,0.34027],[-0.97691,0.21354,-0.0066178],[-0.16159,0.62973,-0.75982],[0.9358,-0.084469,0.34227],[-0.13822,0.058422,0.98868],[-0.41727,-0.53354,-0.73568],[0.49623,-0.72736,0.47402],[-0.24855,-0.60925,-0.75302],[-0.075401,-0.64414,-0.76118],[0.77872,0.44894,-0.43823],[0.18155,-0.71373,-0.67648],[0.82125,0.34625,0.45349],[0.20694,-0.70637,-0.67692],[0.030369,-0.49547,0.8681],[-0.58908,-0.38146,-0.71238],[0.71353,-0.13093,0.68828],[-0.65434,0.016187,-0.75603],[-0.87841,-0.35886,-0.31561],[-0.95682,-0.0073138,0.2906],[0.16643,-0.21152,0.9631],[0.33669,-0.032861,0.94104],[-0.034357,0.78549,0.61792],[-0.087277,0.067125,0.99392],[0.94214,-0.075005,-0.32673],[-0.44655,0.20315,-0.87139],[0.8764,-0.2969,-0.37916],[-0.7864,-0.27286,-0.55418],[-0.75127,-0.64593,0.13556],[-0.3271,-0.023258,0.9447],[0.97768,-0.1674,-0.12694],[0.70042,0.24399,0.67073],[-0.84757,0.43734,0.30062],[-0.89046,0.38797,0.23781],[0.86647,0.33603,0.36921],[0.97316,-0.012401,-0.22979],[0.98562,0.13579,-0.1006],[-0.94748,0.24543,0.20506],[0.97104,0.23861,-0.011918],[0.9696,0.24468,0.0026018],[0.56363,-0.23684,-0.79135],[0.85728,0.49187,-0.15209],[0.78082,0.54836,0.29936],[0.30903,0.166,0.93645],[0.70533,0.69521,-0.13853],[-0.82462,0.48026,0.29892],[-0.83608,-0.54819,-0.02153],[-0.82365,-0.41706,-0.38426],[0.66006,0.7497,-0.04762],[0.93835,-0.27555,-0.20872],[0.72604,0.54609,0.41792],[-0.64214,0.35658,-0.67861],[0.5551,0.045377,0.83054],[0.51308,-0.17597,0.84011],[0.55551,0.61897,-0.55523],[0.70325,-0.52095,-0.48379],[0.603,0.60153,0.52398],[-0.78098,-0.1092,-0.61494],[-0.77711,0.28851,0.55934],[0.45915,0.5597,-0.68987],[-0.82855,0.00010982,0.55991],[0.44124,-0.57169,0.69172],[-0.55115,0.61875,0.5598],[0.29776,0.86144,0.41141],[-0.32797,0.12282,0.93667],[0.11239,-0.33511,0.93545],[0.8379,0.30904,-0.44992],[-0.82439,-0.082021,-0.56004],[0.25112,-0.36491,0.89654],[-0.3798,0.65295,0.65529],[-0.32422,0.14465,-0.93486],[-0.05659,0.82052,0.56881],[-0.077066,0.88279,0.46341],[-0.94294,0.19286,-0.27141],[0.91321,0.0069288,0.40744],[0.68981,0.72177,0.056583],[-0.72486,0.65078,0.22596],[-0.67821,-0.13549,0.72227],[0.53273,0.83279,0.15052],[-0.18652,0.92828,0.32172],[0.11747,0.9551,0.27201],[-0.080244,-0.74809,-0.65873],[-0.85274,0.18307,0.4892],[-0.92922,-0.23991,0.28104],[0.95784,-0.12725,0.25757],[0.33802,-0.4873,-0.80516],[0.53323,-0.39678,0.74715],[-0.42906,-0.81477,-0.38995],[-0.26144,-0.80583,-0.53131],[-0.82077,-0.5712,-0.0078426],[-0.52328,-0.25451,0.81327],[0.66169,-0.29836,-0.68786],[-0.063854,-0.0061387,-0.99794],[0.84259,0.10273,-0.52866],[-0.90089,-0.39524,0.17939],[0.12741,-0.087861,0.98795],[-0.48232,-0.83174,0.27491],[0.8241,0.48607,-0.29086],[-0.4455,0.17947,-0.87711],[0.41216,0.29062,0.86352],[-0.96137,-0.083385,0.26231],[0.898,0.085813,-0.43155],[-0.23757,0.052355,0.96996],[0.69539,0.70814,-0.12233],[-0.4584,0.02191,-0.88848],[-0.76409,0.48905,0.4207],[-0.54742,0.64516,0.53301],[0.51223,0.85762,0.045864],[-0.76311,0.40095,0.50686],[0.10259,0.95628,0.27386],[-0.34415,-0.84168,-0.41609],[-0.55939,-0.70895,-0.42951],[0.43397,-0.79275,-0.42804],[-0.59409,-0.66564,0.45164],[-0.90041,-0.31624,-0.29877],[-0.50739,-0.67611,-0.53426],[-0.86676,0.21723,0.44893],[0.79024,0.38566,0.47622],[-0.18093,-0.73572,-0.65267],[0.77458,-0.51702,-0.3643],[0.48019,-0.84408,-0.23862],[-0.51045,-0.74033,-0.43745],[0.96984,-0.19148,0.15081],[-0.069882,-0.78247,-0.61876],[-0.21309,0.1746,0.9613],[0.71402,-0.0044539,0.70011],[-0.94282,-0.33302,0.013819],[0.58558,-0.021614,0.81032],[-0.053931,-0.78194,-0.62101],[-0.94737,0.24776,0.20273],[0.68045,-0.70553,0.19805],[0.071464,0.027493,-0.99706],[-0.94032,-0.32659,0.095562],[0.30687,-0.947,-0.095027],[0.24265,-0.94899,-0.20133],[0.97617,-0.05148,0.21084],[-0.76406,0.41305,0.49559],[0.42432,-0.81959,0.38499],[0.44718,-0.47263,0.75938],[-0.96316,-0.040429,0.26586],[0.45861,-0.45152,0.76538],[-0.73167,-0.68053,-0.039104],[0.58053,-0.54629,0.60378],[-0.4393,-0.83225,-0.33818],[-0.49516,-0.75301,0.43335],[-0.27996,0.18401,0.94221],[0.71663,-0.6632,0.21587],[-0.72325,-0.66041,-0.20192],[0.36793,-0.92823,0.054945],[0.81371,-0.56529,-0.1354],[0.014297,-0.70557,-0.7085],[-0.58353,-0.082026,0.80794],[-0.074125,-0.93675,0.34205],[0.075063,-0.97098,0.22708],[0.2144,-0.97029,-0.11216],[-0.070535,-0.038097,-0.99678],[-0.64242,-0.76188,0.082655],[0.92209,-0.31038,-0.23112],[-0.43775,-0.85257,0.28547],[0.21397,-0.89246,-0.39716],[-0.043866,-0.5822,-0.81186],[-0.39677,-0.90105,0.17519],[-0.2029,-0.9708,0.12798],[0.47043,-0.3733,-0.79959],[-0.47981,0.10004,-0.87165],[0.25724,-0.13536,0.95682],[-0.8037,-0.22231,0.55194],[0.57781,-0.16935,0.79841],[0.57673,-0.2053,0.79071],[0.77248,0.24581,0.58553],[0.97652,0.1606,-0.14361],[0.9672,0.12572,0.22071],[-0.86402,-0.41884,0.27937],[-0.84571,-0.28725,0.44974],[-0.58578,-0.06775,0.80763],[0.6423,-0.2421,-0.72722],[0.5164,-0.46272,0.72057],[-0.090465,-0.50223,0.85999],[-0.85509,-0.1581,0.49378],[-0.7748,-0.11694,0.62129],[-0.033763,-0.10105,-0.99431],[-0.18697,-0.24076,0.9524],[0.26254,0.90799,-0.32653],[-0.88831,-0.012663,0.45907],[-0.69166,-0.30776,0.65337],[-0.78394,0.281,0.5536],[-0.78892,-0.19426,0.58299],[0.72081,-0.3219,0.61385],[-0.53773,0.74013,-0.40379],[-0.99911,-0.034685,0.024017],[0.17046,0.15391,0.97327],[0.68256,-0.24741,-0.68767],[-0.77646,0.44805,-0.44312],[0.76861,0.19428,-0.6095],[-0.96399,0.14707,0.22156],[0.41835,-0.84775,-0.32604],[0.90708,-0.030621,-0.41984],[-0.82862,0.055368,0.55707],[-0.79226,0.28053,-0.54187],[0.66811,0.28425,-0.68763],[-0.90099,0.20177,0.38406],[0.75633,-0.1131,-0.64434],[0.80285,0.42533,0.41777],[0.39244,0.48509,-0.78146],[0.49713,-0.68401,0.53385],[-0.60076,-0.7875,-0.13761],[-0.86412,-0.39791,-0.30817],[-0.66664,0.40811,-0.62373],[0.28771,0.32659,-0.90031],[0.49678,0.34342,-0.79704],[-0.99911,0.036101,-0.021978],[-0.49539,0.5048,-0.70695],[0.49354,0.60481,-0.625],[0.80136,-0.029301,-0.59746],[0.019083,-0.14827,-0.98876],[-0.79818,0.36779,0.47712],[0.20819,0.54132,-0.81463],[-0.67528,0.0082685,-0.73752],[0.5115,-0.49686,0.70107],[0.30307,0.65671,-0.69057],[-0.98866,0.074294,-0.13047],[-0.0056038,0.74032,-0.67223],[0.1803,0.73026,-0.65895],[0.13446,-0.59654,0.79124],[0.8988,-0.22266,-0.3776],[0.52559,-0.56407,0.63685],[0.19372,-0.73068,-0.65466],[-0.68866,0.04904,-0.72343],[0.59943,-0.733,-0.32156],[-0.036477,0.27461,0.96086],[-0.94531,0.27844,-0.16987],[-0.95677,-0.1265,0.26188],[-0.53667,-0.52249,-0.66257],[0.15555,-0.64874,0.74495],[0.28839,-0.73327,-0.61574],[0.58923,-0.61792,-0.52056],[-0.15144,-0.15957,-0.9755],[-0.90049,0.41188,-0.13955],[-0.70228,-0.31936,-0.63625],[-0.34812,0.30991,0.88474],[-0.61127,-0.14092,0.77878],[0.72669,-0.45603,-0.51376],[0.63114,-0.45704,0.62672],[-0.31946,-0.044059,-0.94657],[-0.87896,0.17634,0.44309],[-0.91872,-0.046299,0.39219],[-0.84895,-0.101,-0.51873],[-0.76502,-0.21217,0.60805],[-0.85746,0.32894,0.39567],[-0.86524,0.027414,-0.5006],[0.56183,-0.17384,0.80878],[0.44139,-0.10825,0.89076],[-0.95389,0.21373,0.21074],[0.91442,0.26815,-0.3032],[-0.87996,-0.03505,-0.47374],[0.92126,0.37642,-0.097914],[0.68027,0.11623,0.72369],[-0.69476,-0.45097,-0.5603],[0.86838,0.4593,0.18699],[-0.87732,0.39464,0.27308],[0.88631,0.42318,0.18808],[-0.78181,-0.54931,-0.29501],[-0.65919,-0.46619,-0.59003],[0.50809,-0.25853,0.82159],[0.72577,0.63745,0.25868],[-0.61625,-0.084071,-0.78305],[-0.57015,-0.81947,-0.058387],[0.70606,0.60781,0.36338],[0.89462,-0.34397,-0.2852],[-0.62103,-0.33039,0.71075],[0.91688,0.33329,0.21966],[-0.80033,-0.3535,-0.48426],[0.26873,0.91516,0.30045],[-0.66341,0.60308,0.44293],[0.49041,-0.28064,0.82507],[0.68484,0.36821,-0.62882],[0.4727,0.7342,0.48735],[-0.19985,-0.098923,-0.97482],[-0.88469,-0.28606,-0.3681],[0.61171,0.13267,-0.77988],[-0.37846,0.60014,0.7047],[0.3015,0.82736,0.47389],[-0.94487,-0.035603,-0.3255],[0.74155,0.11304,-0.6613],[-0.098465,0.78421,0.61264],[-0.015045,0.79335,0.60858],[0.21542,0.74666,0.62936],[0.57862,-0.81242,-0.071939],[0.11452,-0.67733,0.72671],[-0.033956,0.80729,0.58917],[-0.92448,0.010247,-0.38108],[-0.75045,-0.65812,0.060813],[-0.24544,-0.93023,-0.27282],[-0.97614,0.20257,0.078175],[-0.86516,0.29562,-0.40509],[-0.36269,0.85659,0.36703],[-0.4196,0.80009,0.42871],[-0.69725,-0.43208,0.57197],[0.26816,0.92324,0.27517],[-0.21686,-0.73217,-0.64568],[0.98174,0.16548,0.093856],[0.67756,0.13246,0.72344],[0.163,-0.58654,-0.79335],[-0.63125,0.0745,-0.77199],[-0.96931,0.24502,0.020304],[0.8599,-0.17014,0.48128],[-0.33121,0.6527,0.68139],[-0.73364,-0.66398,-0.14459],[-0.69049,-0.063957,0.72051],[0.59269,-0.31936,-0.73941],[0.79792,-0.14213,-0.58576],[-0.48584,-0.1266,0.86483],[-0.88883,-0.24045,0.39009],[-0.86118,0.18713,0.4726],[0.96957,-0.16094,-0.1845],[-0.35179,0.78188,0.51468],[0.22042,0.94099,0.25682],[-0.23406,-0.79797,-0.55539],[-0.026238,-0.82195,-0.56896],[0.42627,-0.88703,0.17739],[0.59538,-0.68105,-0.42625],[0.69867,-0.64776,-0.30377],[0.61214,-0.54233,0.57546],[-0.58614,-0.62905,-0.51062],[-0.93078,0.22302,0.28968],[-0.30967,-0.21545,-0.92611],[0.39437,-0.67692,-0.62149],[0.88439,-0.40672,-0.22901],[-0.24703,-0.91106,0.33007],[-0.69382,-0.48297,-0.53418],[-0.22298,-0.92256,0.31489],[0.99993,-0.0010412,-0.011647],[-0.16963,-0.90259,-0.39568],[0.99889,-0.0179,-0.043634],[-0.39945,-0.72137,-0.56573],[0.98981,0.0082758,-0.14213],[-0.74621,-0.58825,-0.31165],[-0.77853,-0.0033632,-0.62759],[0.12457,-0.78636,-0.60507],[-0.033987,0.2823,0.95872],[-0.65539,-0.65965,-0.36786],[0.85804,-0.3979,-0.32471],[0.3918,-0.82273,-0.41182],[-0.92625,-0.27345,0.2594],[0.51191,-0.79847,0.31686],[-0.68456,-0.72795,0.038295],[0.61911,-0.72103,0.31116],[0.69124,-0.64304,0.32968],[0.97855,-0.1003,-0.17992],[-0.27062,-0.29088,-0.91769],[-0.69619,-0.50324,0.51193],[-0.70099,-0.48236,0.5253],[0.016653,-0.26395,-0.96439],[-0.36646,-0.92242,-0.12182],[0.21651,0.33583,0.9167],[0.37946,-0.34515,0.85842],[0.58971,0.098218,0.80162],[0.40878,-0.060236,-0.91064],[-0.83701,-0.19872,-0.50983],[0.96633,-0.19344,-0.16964],[-0.83763,-0.52862,0.13761],[0.49938,-0.82772,-0.25591],[-0.71703,-0.68588,0.12421],[0.60847,0.07299,-0.79021],[0.32412,-0.94577,0.021599],[-0.19104,-0.18709,-0.96359],[0.74702,-0.07384,0.66068],[0.18578,-0.00057006,-0.98259],[0.68803,0.25517,-0.67934],[-0.91252,0.40564,0.052529],[0.83604,-0.54578,0.056169],[-0.075784,-0.91063,0.4062],[0.031575,-0.99808,-0.05335],[-0.041956,-0.8307,-0.55513],[-0.33645,-0.79579,0.50351],[0.11214,-0.15002,-0.9823],[0.65402,0.077372,-0.75251],[-0.83256,-0.40553,-0.37735],[-0.35412,-0.84677,0.39696],[0.72343,0.092032,0.68424],[-0.65139,0.44772,0.61256],[-0.34574,-0.83981,0.41855],[0.03257,0.23593,0.97122],[0.93336,-0.35895,-0.00079328],[0.76608,-0.23244,-0.59924],[-0.83565,-0.41017,-0.36532],[0.93125,0.36292,0.032474],[-0.66411,-0.67744,0.31628],[-0.97774,-0.17222,-0.11984],[-0.823,-0.47975,0.30417],[0.72284,-0.35599,-0.59226],[-0.77936,-0.27843,0.56131],[-0.97408,-0.15315,-0.16649],[-0.87398,0.48543,-0.022846],[0.91841,0.33569,-0.20936],[-0.87635,-0.34213,0.33906],[0.71263,-0.35323,0.60613],[0.58012,-0.3941,-0.71285],[0.50985,-0.2288,-0.82928],[0.89268,0.45001,0.024607],[-0.94881,0.25725,-0.18326],[0.72788,0.60385,-0.3249],[-0.81236,0.58216,-0.034128],[0.63062,-0.076183,-0.77235],[-0.79784,0.57083,-0.19391],[0.46512,0.79023,-0.39899],[0.61301,0.6799,-0.40244],[0.93108,-0.31546,-0.18323],[-0.60085,0.78056,-0.17237],[0.57915,-0.21652,0.78594],[-0.94317,-0.026302,0.33128],[0.68654,-0.18591,-0.70292],[-0.82696,-0.13607,0.54555],[-0.41158,0.90636,-0.095467],[-0.98497,0.16948,0.03325],[0.30947,0.88306,-0.35276],[-0.79487,0.59941,-0.094283],[0.50782,-0.72564,0.4643],[-0.27665,0.94074,-0.19614],[0.71907,-0.20542,0.66389],[0.56382,-0.7593,-0.32492],[-0.57903,-0.65235,0.48904],[-0.87307,-0.043123,0.48568],[0.42146,-0.83174,-0.36135],[-0.2383,0.92562,-0.294],[0.61065,-0.13358,0.78055],[0.85247,0.18564,-0.4887],[0.64129,0.76005,-0.1052],[0.74502,-0.087278,-0.6613],[-0.83245,0.15639,-0.53158],[0.82226,0.27431,-0.49864],[-0.18432,0.010077,0.98281],[0.65263,-0.73216,-0.19499],[0.75535,-0.18653,-0.62821],[-0.9932,0.1123,0.030757],[-0.93958,0.040829,0.33989],[-0.89777,0.42351,-0.12103],[-0.72098,0.26178,-0.6416],[-0.99726,-0.058948,-0.044751],[0.40094,-0.10548,0.91001],[-0.72804,0.21703,0.65027],[0.50316,-0.7506,0.42828],[-0.98712,-0.15927,0.015023],[0.90573,-0.070529,0.41794],[-0.4834,0.24238,-0.84118],[0.97044,0.1715,-0.1698],[0.72088,0.48829,-0.49185],[-0.86314,-0.49747,-0.086655],[0.76348,0.016853,-0.64561],[0.95029,0.17932,0.25456],[-0.99259,-0.07449,-0.095975],[-0.37352,0.58599,-0.7191],[0.31094,0.73132,-0.60703],[0.80558,0.52653,-0.27168],[-0.75387,0.59107,-0.28691],[-0.24242,-0.78885,-0.56476],[-0.75533,-0.63209,-0.17301],[-0.98669,0.15672,-0.043432],[-0.12464,0.59292,-0.79556],[-0.33863,-0.10772,0.93473],[0.066648,0.71506,-0.69588],[0.19694,0.70425,-0.68209],[0.51943,-0.76149,0.38772],[-0.49556,-0.62822,-0.59979],[0.34175,-0.77209,-0.5358],[0.9899,-0.13376,0.046951],[0.83679,0.068712,-0.54319],[-0.78884,-0.61085,-0.067744],[-0.68341,-0.60317,-0.41126],[0.28285,-0.83819,-0.46629],[0.56889,0.28119,0.77285],[0.46268,-0.83223,-0.30548],[-0.35305,-0.8249,0.44147],[-0.40651,-0.797,0.4467],[-0.33086,0.89632,-0.29521],[0.5624,-0.72192,-0.40316],[-0.84234,-0.39318,-0.36862],[-0.66153,0.65367,-0.36755],[-0.90317,0.41697,0.10207],[0.79309,-0.56978,-0.21531],[0.67117,-0.017964,0.74109],[-0.78192,-0.62246,0.033885],[-0.64165,0.74732,-0.1726],[-0.90281,0.17851,0.39124],[0.65483,0.72043,-0.22841],[-0.80016,-0.2157,-0.55966],[-0.56428,-0.67109,0.48085],[0.82599,-0.21919,-0.51932],[0.98463,0.070264,-0.15989],[0.98054,-0.087431,-0.17575],[-0.80984,0.29897,0.50474],[0.89554,-0.12513,-0.42703],[-0.69795,0.51569,0.49692],[-0.88374,-0.0507,-0.46522],[0.95804,-0.096842,-0.26977],[0.92985,0.18045,-0.32066],[-0.8821,-0.056743,-0.46763],[0.51645,-0.8114,0.27368],[0.85856,0.43651,-0.26895],[0.73817,-0.65874,-0.14551],[0.78627,-0.0010384,0.61788],[-0.39169,-0.15793,0.90644],[0.80046,0.5842,-0.13408],[0.7946,0.60617,0.034221],[0.96105,-0.13916,-0.23878],[-0.98117,-0.048897,0.18687],[-0.70182,-0.27818,-0.65579],[0.73863,0.58664,0.33209],[0.74411,-0.65268,-0.14255],[-0.79907,0.49045,0.34779],[0.6977,0.65918,0.28052],[-0.78339,-0.62153,-0.0027583],[-0.66044,-0.5114,-0.54982],[-0.74358,-0.21672,0.63255],[0.12909,-0.43147,0.89285],[0.16059,-0.44388,0.88158],[-0.76761,-0.22476,-0.60022],[0.87217,0.48914,0.0076018],[0.73538,0.16091,0.65827],[0.35564,-0.15402,0.92184],[0.28513,-0.30205,0.90965],[-0.82717,0.56112,-0.03066],[0.73269,0.62108,0.27826],[-0.11835,-0.60277,0.78909],[-0.62946,0.7685,-0.11488],[0.96793,0.23299,-0.093987],[-0.52754,0.69186,0.49299],[0.86687,-0.49836,0.013188],[-0.52628,0.84979,-0.029683],[-0.91146,-0.19439,-0.36256],[0.36685,-0.84478,0.38957],[0.87473,0.0065998,-0.48456],[-0.41663,0.77952,0.46772],[-0.39964,-0.74562,0.53323],[0.42398,0.85486,0.29909],[-0.12222,-0.95868,-0.25689],[0.64769,0.24388,-0.72181],[-0.90056,-0.037211,0.43314],[0.76185,-0.35849,0.53951],[0.41242,-0.47366,0.77817],[0.61259,0.7642,0.20183],[0.14722,0.78191,0.60576],[0.040752,0.85167,0.52249],[0.11001,0.92685,0.35896],[0.44087,-0.13567,0.88726],[0.0075427,0.78395,0.62078],[0.88855,0.12577,-0.44121],[-0.93026,0.14975,-0.33494],[0.93789,0.19574,-0.28644],[-0.34309,-0.39634,0.85159],[0.89968,0.40448,-0.16421],[-0.06728,-0.98868,-0.13411],[-0.89473,0.40282,-0.19284],[0.83616,0.54331,-0.075189],[-0.32905,0.9398,-0.092225],[-0.46364,0.8835,-0.066755],[0.88965,-0.45614,-0.021214],[0.53514,0.5193,0.6663],[-0.28529,0.86436,0.41412],[-0.061469,-0.99726,0.041201],[-0.074439,0.92006,0.38463],[0.25706,-0.58442,-0.76966],[-0.41287,0.90954,-0.047633],[-0.32519,-0.75045,-0.57539],[0.4918,-0.44436,-0.74878],[0.40422,-0.07849,0.91129],[0.60433,-0.3969,-0.69084],[0.75023,-0.23423,-0.6183],[-0.87086,-0.49152,-0.0032164],[-0.81186,-0.58291,0.033237],[-0.44289,-0.38423,0.81007],[-0.92783,-0.35502,0.11439],[0.8916,0.078088,-0.44605],[-0.92519,-0.26014,0.2763],[0.88283,0.30765,-0.3549],[-0.81434,-0.5772,0.060696],[0.6732,-0.59897,-0.43364],[-0.65401,0.51326,0.55573],[0.48437,0.84391,0.23067],[0.81974,-0.32315,0.47286],[0.89971,-0.4364,-0.0092731],[0.29353,0.90442,0.30963],[0.59367,0.80471,0.00038455],[-0.19683,0.85828,0.47394],[-0.27532,-0.87162,-0.40555],[0.77823,0.027264,0.62739],[-0.53884,0.84147,-0.039674],[0.76286,-0.605,-0.22809],[-0.7881,-0.5262,-0.3194],[-0.054985,-0.99337,-0.10094],[-0.62717,-0.63023,-0.45768],[0.99585,-0.090426,0.010491],[-0.72727,-0.49909,-0.47116],[0.31458,-0.068485,0.94676],[-0.52002,-0.21675,0.8262],[0.98514,-0.17057,-0.020144],[-0.84484,-0.5342,0.029507],[-0.077194,-0.72629,-0.68304],[0.70053,-0.57562,-0.4218],[-0.97628,-0.10634,0.18862],[0.68334,-0.51574,-0.51678],[0.28396,-0.70615,-0.64862],[-0.5396,0.83704,-0.090536],[0.36458,-0.76059,-0.5372],[0.83805,-0.54091,-0.071379],[0.72035,-0.66831,-0.18562],[-0.0023538,-0.42118,-0.90697],[-0.36511,0.31082,0.87755],[-0.27798,-0.6067,-0.74475],[-0.91888,-0.30893,-0.24541],[-0.055648,-0.51784,-0.85366],[-0.75772,-0.18696,0.62522],[0.23316,-0.31542,-0.91986],[0.27745,-0.15509,-0.94814],[0.45407,-0.090954,0.88631],[-0.78151,-0.4824,0.39563],[0.061864,0.25607,0.96468],[-0.88036,0.03255,0.47319],[-0.33665,-0.34681,-0.87544],[-0.52821,-0.14535,0.83658],[-0.75573,0.6,-0.26242],[-0.4905,-0.73232,0.47235],[-0.44776,-0.81698,0.36338],[0.56728,-0.80795,-0.15943],[0.78914,0.29897,0.53654],[-0.19969,0.31935,0.92636],[-0.32708,0.54154,0.77443],[0.61232,0.18732,-0.7681],[-0.83016,-0.55482,-0.054878],[0.42487,-0.8954,-0.13322],[0.54049,0.83059,0.13418],[0.45911,0.87889,0.12955],[-0.26815,-0.27495,-0.92331],[-0.29634,-0.25911,-0.91926],[0.81768,0.38195,-0.43072],[-0.74811,-0.59164,0.3005],[0.80814,0.11639,0.57738],[0.87957,0.011101,0.47564],[-0.24303,-0.41229,-0.87804],[-0.84223,0.27371,0.46448],[0.78771,-0.60207,-0.13047],[-0.82029,-0.56506,0.088456],[0.64364,-0.75747,0.10938],[-0.80256,0.54715,-0.23774],[-0.23139,-0.94003,-0.25059],[-0.32814,-0.66456,-0.67133],[0.85162,0.28957,-0.43692],[0.84775,0.35344,-0.39548],[-0.83224,-0.5513,0.058699],[-0.10812,-0.99014,0.089086],[-0.62243,-0.78109,0.049871],[-0.59882,-0.79956,0.046107],[0.82636,-0.56079,0.051421],[-0.28757,-0.934,0.212],[0.78959,-0.23318,-0.56761],[0.58863,-0.094173,0.8029],[-0.87348,-0.48677,0.009129],[0.99465,-0.093982,-0.042777],[0.94645,0.32247,0.015424],[-0.80087,0.27182,0.5336],[0.83091,0.2666,0.48838],[-0.82983,-0.25539,0.49614],[0.46644,-0.13552,0.87411],[0.49032,-0.22112,-0.84302],[0.67166,-0.14105,-0.72731],[0.085004,0.29193,0.95265],[0.9499,-0.062475,-0.30625],[-0.8432,-0.24431,0.47888],[-0.94027,-0.3402,-0.012704],[0.93378,-0.215,-0.28605],[-0.87564,-0.4825,0.021367],[0.66572,-0.34611,0.66108],[0.71103,-0.67058,-0.21155],[-0.27577,-0.94628,0.16883],[-0.64781,-0.71021,-0.27558],[0.95771,0.28749,-0.011706],[-0.94128,-0.25216,0.22451],[-0.6984,0.20232,0.68651],[-0.84236,0.52417,-0.1252],[0.61413,0.64349,-0.4569],[0.93387,0.35397,-0.05098],[-0.9592,0.05699,0.27693],[-0.73298,0.50666,-0.45391],[0.93276,0.19138,-0.30551],[-0.98413,0.095513,0.14954],[-0.46548,-0.018439,0.88486],[-0.81525,0.23426,-0.52962],[0.91538,0.22165,-0.33608],[0.68879,-0.71021,-0.14547],[-0.72947,0.68401,6.0526e-07],[-0.74652,0.46479,0.47611],[-0.63346,0.024925,-0.77337],[0.80667,0.37649,-0.45557],[-0.96628,-0.20611,0.15438],[-0.68881,-0.71074,-0.14278],[-0.61899,-0.78363,-0.052613],[0.93116,-0.20994,0.29809],[0.73684,-0.19327,-0.64785],[-0.38063,0.10557,-0.91868],[0.82052,-0.557,-0.12844],[0.63501,0.50422,-0.58526],[-0.14273,0.14376,-0.97926],[-0.47563,0.39428,-0.78633],[0.50419,0.7454,0.43609],[0.73058,-0.6629,-0.16377],[-0.25382,0.32164,-0.91221],[-0.25081,0.34393,-0.90488],[0.43916,0.098001,0.89305],[0.36804,0.75618,0.54106],[-0.61444,-0.77625,-0.14104],[-0.5842,-0.70879,-0.39539],[0.41393,-0.83127,-0.37102],[-0.04527,-0.18482,-0.98173],[-0.70957,0.70408,-0.028067],[0.69556,-0.71846,0.004021],[0.20418,-0.056745,-0.97729],[-0.75467,-0.59988,-0.26575],[0.22926,0.55329,-0.80082],[0.40612,0.48859,-0.77223],[0.089332,0.25531,0.96272],[0.43285,-0.84808,-0.30562],[-0.91884,0.38235,-0.097692],[-0.3534,-0.34387,-0.86998],[0.2705,-0.66993,-0.69139],[-0.049265,0.080334,0.99555],[0.12546,0.24696,0.96087],[0.065978,0.57002,-0.81898],[0.1461,0.57955,-0.80173],[0.68068,-0.73023,0.05858],[0.92392,0.025772,-0.38173],[-0.64924,-0.53807,-0.53756],[-0.61368,0.77009,-0.17426],[0.47431,0.49509,0.72795],[0.43388,0.1599,-0.88667],[-0.22296,0.48082,-0.848],[0.0094962,0.56152,-0.82741],[0.59158,-0.10867,0.79889],[0.72466,0.52775,0.44311],[0.4255,-0.8567,-0.29156],[-0.98412,0.1466,0.10011],[-0.60104,0.096196,0.79341],[-0.32909,-0.20692,-0.92135],[0.17611,0.026449,-0.98402],[0.52706,0.82553,-0.20175],[-0.82907,-0.54692,-0.11633],[0.65302,-0.75724,0.012187],[-0.12622,0.046231,-0.99092],[0.81138,-0.12298,-0.57144],[-0.91289,-0.2349,-0.33385],[0.83915,-0.31108,-0.44616],[-0.92578,0.33333,-0.17837],[-0.49936,-0.1329,-0.85614],[0.35609,0.34266,-0.86936],[0.46136,-0.70209,0.54242],[-0.91791,0.17126,0.35792],[0.98774,-0.073769,-0.13756],[-0.18642,0.22193,-0.95708],[0.13858,0.48556,-0.86315],[-0.36438,0.60098,0.71137],[0.48508,-0.35002,0.80136],[-0.68277,-0.10164,0.72353],[-0.89458,0.25588,0.3664],[-0.081336,0.075123,0.99385],[0.87353,-0.16694,-0.45725],[0.5288,-0.84869,0.010154],[0.89301,0.10088,-0.43858],[-0.91888,0.20693,0.33592],[0.98613,-0.14176,-0.086346],[-0.97017,-0.24095,0.026754],[-0.36281,-0.15089,0.91957],[0.903,0.37859,-0.20311],[-0.9363,0.22727,0.26777],[-0.74513,-0.35619,-0.56383],[0.38357,0.78215,0.49104],[0.6059,0.79528,0.020244],[-0.77314,-0.63381,0.023375],[0.76436,-0.28629,0.57775],[0.80107,0.10617,-0.58908],[-0.84982,0.49912,-0.16934],[0.45679,-0.86916,-0.18948],[0.71148,0.70263,0.010626],[-0.74828,0.5406,0.38448],[0.32209,-0.94394,0.072425],[0.41132,-0.88261,0.22761],[-0.69481,-0.39176,-0.60312],[0.79388,0.076547,0.60324],[-0.70289,0.55603,0.44358],[0.71794,0.58518,0.377],[0.93282,-0.013891,0.36006],[-0.2378,-0.86933,0.43327],[-0.61567,0.59684,0.51452],[-0.047469,-0.9714,0.23266],[0.78253,0.58101,0.22376],[0.25632,0.8361,0.48502],[0.94452,0.322,-0.064808],[0.67911,0.6956,0.23441],[-0.85373,-0.13375,-0.50325],[0.99587,-0.038205,-0.082415],[-0.041921,-0.97006,0.23924],[-0.88518,0.41933,-0.20157],[0.96905,-0.20442,-0.1384],[-0.2969,0.73544,0.60907],[-0.66687,-0.50836,-0.54484],[-0.9377,0.027829,-0.34633],[-0.094589,0.87566,0.47358],[-0.036035,0.79265,0.60861],[-0.097861,-0.93008,0.35407],[0.2958,0.79714,0.52638],[-0.73319,-0.20392,0.64873],[0.84131,0.20775,-0.49904],[-0.98045,0.033406,-0.19391],[0.72305,0.40677,-0.55834],[-0.72832,0.57994,0.36498],[-0.96744,0.039211,-0.25005],[0.79797,0.44889,-0.40217],[0.15107,-0.93192,0.3297],[-0.51332,0.4893,-0.70505],[-0.65034,0.17689,-0.73876],[0.28691,-0.89447,0.34295],[0.70286,-0.11709,0.70163],[-0.161,0.10691,0.98115],[0.058097,0.92377,-0.37852],[-0.55208,0.58353,0.59557],[0.72433,0.68872,0.031797],[0.18369,0.48583,-0.85453],[-0.15848,0.98715,-0.020684],[-0.3607,0.85173,0.38006],[0.63814,-0.21593,-0.73902],[0.56191,0.81423,0.14591],[0.58525,0.55081,0.59505],[-0.30215,-0.36805,-0.87934],[0.7904,-0.036658,-0.61149],[0.39139,0.89817,0.20026],[-0.96882,-0.22821,-0.096475],[-0.20999,-0.58197,-0.78563],[-0.67488,-0.73488,0.067087],[0.37308,-0.4565,-0.80773],[0.73228,0.66757,-0.1346],[-0.35098,-0.58252,-0.73313],[0.65321,-0.28183,-0.70277],[0.86837,-0.39494,-0.29992],[-0.69009,-0.65511,-0.30757],[0.79994,0.39619,0.45071],[0.88098,0.076727,0.46689],[0.82571,-0.11321,-0.55261],[-0.47288,0.73011,0.49328],[0.43049,-0.85564,0.28731],[0.92134,0.12252,-0.36894],[0.91541,0.31926,-0.24514],[0.86371,0.036835,-0.50264],[0.7654,-0.01367,0.64341],[0.83564,0.53388,-0.12914],[-0.87808,-0.095577,0.46887],[-0.97716,-0.11288,-0.18003],[0.12233,-0.98892,0.08409],[-0.21886,-0.97171,-0.088805],[-0.96164,0.19664,-0.19124],[-0.28236,0.81972,0.49833],[-0.20702,0.75548,0.62161],[0.43709,0.89166,0.11788],[-0.43567,-0.037658,0.89932],[0.87452,0.095613,-0.47547],[0.37395,-0.82604,-0.42169],[0.12217,-0.94173,-0.31341],[-0.97824,-0.18015,-0.10293],[0.71629,-0.53037,-0.45347],[-0.1575,0.77406,0.61321],[-0.5896,-0.61042,-0.52893],[-0.3693,-0.83637,-0.4051],[0.89401,0.050948,-0.44514],[0.64256,-0.56966,-0.51244],[-0.34357,-0.72982,-0.59103],[-0.096426,0.28863,0.95257],[0.35137,-0.75777,-0.54984],[0.36021,-0.85518,-0.37271],[0.99744,-0.071384,-0.0038002],[-0.90549,-0.40983,-0.11009],[-0.5139,-0.75202,-0.41276],[0.057565,-0.73134,-0.67958],[0.79947,-0.45501,-0.3922],[0.36097,-0.81962,0.44489],[-0.55309,0.58473,0.59345],[-0.8602,0.36166,-0.35952],[0.48524,-0.57166,-0.66162],[-0.22506,-0.64605,-0.72936],[-0.72696,-0.22418,0.64906],[0.058849,-0.70287,-0.70888],[-0.43886,0.60201,0.66707],[0.42955,-0.63777,-0.63932],[-0.94881,-0.154,0.27576],[0.91346,0.19778,-0.35562],[-0.29015,-0.054097,0.95545],[0.95138,-0.086545,0.2956],[0.3685,-0.18366,-0.9113],[-0.88579,-0.41577,0.20619],[-0.23078,-0.517,-0.82429],[0.41026,-0.77954,0.47329],[-0.20202,-0.60617,-0.76925],[0.70051,0.35113,-0.62129],[0.56324,-0.14673,0.81316],[0.55681,-0.79484,-0.24124],[0.48094,-0.81013,-0.33525],[-0.44732,-0.25948,-0.8559],[-0.52122,-0.7363,0.4315],[-0.54417,-0.83195,0.10839],[0.7349,0.46154,-0.4969],[-0.97542,-0.16508,0.14593],[-0.59019,-0.8065,-0.035116],[-0.98028,-0.1961,0.024399],[-0.36478,-0.92994,0.04638],[0.59744,-0.78366,-0.17014],[-0.41761,-0.26876,-0.86797],[-0.42486,0.61401,0.66519],[-0.83322,-0.53543,-0.13806],[0.59482,-0.0078092,0.80382],[0.45233,-0.88069,0.14066],[0.069414,0.36174,0.92969],[-0.46118,-0.40306,-0.79048],[-0.40501,-0.72988,-0.55067],[0.87933,-0.47238,0.060366],[-0.41579,-0.89193,0.17772],[-0.27329,-0.96184,-0.013045],[-0.76284,-0.62895,0.14998],[-0.4511,-0.70065,0.55281],[-0.7789,-0.12739,0.61408],[-0.41003,-0.87286,0.26456],[-0.66566,0.54228,0.51267],[0.58269,-0.4787,-0.65675],[-0.97953,-0.15733,-0.12561],[0.45745,-0.26598,0.84853],[-0.73181,-0.46791,0.4955],[-0.65172,-0.62625,0.42787],[0.46456,-0.53703,-0.70412],[-0.72059,0.49109,0.48947],[0.99257,0.098687,-0.071237],[-0.63639,-0.10437,0.76427],[0.90054,0.22486,0.37211],[0.58188,-0.3692,-0.72465],[0.54155,-0.43191,-0.72123],[-0.97969,0.12787,-0.15443],[0.47672,-0.76422,0.43441],[-0.92542,0.27503,-0.26067],[-0.67419,-0.70882,-0.20746],[0.8099,-0.079614,-0.58114],[0.8749,0.41295,-0.25303],[-0.84435,-0.25915,0.46896],[-0.4623,0.022926,0.88643],[0.71315,0.013554,-0.70088],[0.73811,-0.62889,0.24433],[0.69274,-0.20214,-0.69228],[-0.42822,0.87182,-0.23781],[0.75232,-0.27763,0.59744],[0.87104,0.25589,0.4193],[0.31164,0.90491,-0.28987],[-0.87647,-0.16108,0.4537],[-0.65297,0.19151,0.73277],[0.47412,0.81954,-0.32183],[-0.967,0.032975,0.25263],[-0.28902,0.91129,-0.29329],[0.79727,0.48892,-0.35401],[-0.35632,-0.89352,0.27323],[-0.5804,0.62903,-0.51716],[0.83756,0.25059,0.48548],[-0.95931,0.2661,-0.094438],[-0.51607,-0.83234,0.20219],[-0.66043,-0.53215,-0.52977],[0.73549,-0.67602,-0.045275],[-0.6933,-0.060568,0.7181],[0.73389,-0.13261,-0.6662],[-0.8223,-0.068692,-0.5649],[0.91809,0.18663,-0.34969],[-0.95097,0.090415,0.29576],[-0.83194,-0.34791,-0.43223],[-0.89618,-0.15381,0.41618],[-0.54062,-0.17504,-0.82286],[-0.9599,-0.042428,0.27711],[-0.49989,-0.075115,0.86283],[0.77472,0.11285,-0.62215],[-0.65409,-0.40982,-0.63577],[-0.14454,-0.02291,0.98923],[-0.19115,-0.11348,-0.97498],[-0.15042,-0.88378,0.44307],[-0.55339,-0.41948,-0.71958],[0.49242,0.23789,-0.83722],[-0.38137,-0.87794,-0.28945],[0.12048,-0.8953,-0.42887],[0.78825,0.16144,-0.59381],[-0.60008,-0.5002,-0.62427],[-0.32171,-0.88417,0.33875],[-0.63086,-0.45189,-0.63073],[0.82104,-0.56597,-0.074599],[0.21938,0.085769,-0.97186],[0.70355,-0.65835,0.26755],[-0.69954,0.54701,0.45981],[-0.60068,-0.72981,-0.32645],[0.87613,-0.39246,-0.27995],[-0.95757,-0.018317,0.28761],[0.65382,0.60062,0.46019],[-0.18085,-0.78999,0.58584],[-0.88879,0.39992,0.22387],[0.82897,0.18088,-0.52924],[-0.68651,-0.45819,-0.56459],[0.0846,0.32,-0.94363],[0.18523,0.6185,-0.76364],[0.32858,0.48161,-0.81246],[0.54481,-0.28068,0.79019],[0.61803,-0.78465,-0.048657],[-0.17127,-0.76784,0.61732],[0.46375,0.28946,-0.83735],[-0.14877,-0.85623,0.4947],[0.12427,0.67333,-0.72882],[-0.79983,-0.47876,-0.36203],[-0.17202,-0.92422,0.34091],[0.53196,-0.72005,-0.44559],[-0.68937,-0.53049,-0.49331],[-0.12453,0.57527,-0.80843],[-0.035061,0.71172,-0.70159],[-0.93405,0.043945,0.35444],[-0.18803,-0.68012,0.70858],[-0.8233,0.48545,0.29415],[-0.58433,-0.46278,-0.66663],[-0.39051,-0.66328,0.6384],[0.514,0.32797,-0.79261],[0.81322,0.29896,0.4993],[-0.53536,0.24682,0.80776],[-0.88553,-0.35118,-0.30416],[0.88498,0.23875,-0.39976],[-0.71043,-0.52166,-0.4724],[-0.84636,-0.52965,0.056036],[0.96904,0.17809,-0.17099],[-0.95002,-0.12839,0.28457],[-0.74752,-0.44559,-0.49261],[-0.047794,0.5641,0.82432],[-0.59084,0.13142,-0.79601],[-0.29029,0.32173,-0.90124],[0.42996,-0.67618,0.59825],[0.36663,0.62083,-0.69293],[-0.95676,-0.10211,-0.27238],[0.71401,0.54414,0.44056],[-0.1667,0.59766,-0.78423],[0.68081,0.50103,0.53429],[0.60882,-0.11415,0.78505],[0.45971,-0.56458,0.6855],[-0.44989,-0.17437,0.8759],[0.98146,-0.14158,-0.12918],[0.17228,0.67345,-0.71888],[-0.40612,-0.63754,0.65468],[0.88775,-0.45823,-0.043924],[0.8923,0.3976,-0.2138],[0.98145,0.19141,0.010982],[0.62887,0.55024,0.54933],[0.81763,0.31351,0.4829],[0.8999,0.22766,0.37196],[0.53803,0.81946,0.1975],[0.74444,0.65688,-0.11966],[-0.57712,-0.81665,0.0044572],[-0.95168,-0.27448,-0.13768],[0.50458,0.79432,0.33831],[-0.73921,-0.49627,-0.45528],[-0.70753,0.60067,0.37229],[-0.40044,-0.91558,-0.03685],[0.76778,0.53684,0.34974],[-0.95884,-0.28318,0.020926],[0.96918,-0.090781,0.229],[0.76672,0.63872,-0.064626],[0.069696,-0.99566,-0.061684],[0.8262,0.46771,0.31407],[-0.83048,-0.21527,-0.51376],[-0.49916,0.65788,0.56394],[0.63559,0.72487,0.2657],[-0.010568,0.35103,0.9363],[0.61239,-0.44592,0.65279],[-0.531,0.60234,0.59601],[-0.43814,-0.50933,0.74069],[-0.68127,0.63355,0.36672],[-0.86383,0.33218,0.37877],[0.93942,-0.24508,-0.23964],[-0.96289,-0.061711,0.26275],[0.088343,0.82551,0.55743],[-0.015092,0.90523,0.42466],[0.9787,-0.14695,-0.14336],[-0.71325,-0.15475,0.68361],[0.0026011,0.44303,0.8965],[0.79466,0.47424,-0.37897],[0.96335,0.0070482,0.26816],[-0.99045,-0.13788,0.00097675],[-0.073521,0.47688,0.87589],[-0.89946,-0.19989,-0.3886],[-0.81933,-0.034053,-0.57231],[0.69162,0.55926,0.45705],[0.84508,-0.50985,0.16093],[-0.51809,-0.091327,-0.85044],[-0.27294,0.056179,-0.96039],[0.55069,0.23744,-0.80023],[-0.59722,-0.039063,0.80113],[0.24057,0.8622,-0.44579],[-0.047526,0.97837,-0.20134],[-0.74358,-0.63037,-0.223],[0.54743,-0.48434,0.68245],[-0.53642,-0.32188,-0.78016],[0.73183,-0.67951,0.051905],[0.40951,-0.218,-0.88588],[0.62007,-0.32435,-0.71436],[-0.38966,-0.60991,0.69005],[0.96045,0.021105,0.27764],[0.081608,0.96829,0.23614],[-0.93486,-0.048472,0.35169],[-0.76429,-0.53701,0.35705],[0.7275,-0.24326,-0.64154],[-0.86465,-0.47088,-0.17508],[0.92755,-0.035668,0.37198],[0.05353,0.41465,0.90841],[-0.97584,-0.10865,0.18957],[0.34271,-0.92516,0.16317],[0.5792,0.047134,0.81382],[0.76755,0.62541,-0.1405],[0.61966,-0.7653,0.17421],[-0.6846,0.50555,0.52511],[-0.43725,0.75886,0.48264],[-0.9813,-0.18739,-0.044087],[0.54943,0.82867,0.10691],[-0.18221,0.86508,0.46737],[0.17643,0.93434,0.30964],[-0.31119,-0.23232,0.92151],[0.56796,0.60817,0.55458],[0.67724,-0.15547,0.71914],[-0.6582,-0.68611,-0.30987],[0.52264,-0.6902,-0.50048],[0.55945,-0.74448,0.36436],[0.46193,-0.86981,-0.17335],[-0.65933,-0.6122,-0.43647],[0.91838,-0.097258,-0.38355],[-0.64335,0.59375,0.48329],[0.66649,-0.24584,0.70381],[0.94465,-0.32805,-0.0049577],[0.89824,0.18162,0.40023],[0.33628,-0.65375,-0.67788],[0.99748,-0.069186,0.015704],[-0.11513,-0.81677,-0.56536],[-0.9181,-0.39591,-0.018612],[0.9125,-0.36646,-0.18178],[-0.98488,-0.062204,0.16166],[0.43642,-0.81318,-0.38507],[0.33529,-0.056017,0.94045],[0.12738,-0.77755,-0.61579],[0.25916,-0.59294,-0.7624],[-0.94743,-0.16252,0.27563],[0.053317,-0.82053,0.56912],[-0.11628,-0.84573,-0.52079],[-0.97712,-0.18878,-0.097971],[0.23411,-0.79778,-0.55565],[-0.52728,-0.49468,0.69084],[-0.62869,-0.26258,0.73198],[-0.98036,-0.08259,0.17909],[0.84774,-0.44649,-0.28634],[-0.26022,-0.68463,-0.68086],[-0.97854,0.20597,0.0055661],[0.79045,-0.61217,-0.020911],[0.68258,-0.49995,-0.53304],[0.72526,-0.010677,0.6884],[-0.25002,-0.69984,-0.66911],[-0.16521,-0.65614,-0.73634],[0.81703,-0.063774,-0.57306],[0.18084,-0.84889,0.49668],[-0.73415,-0.3622,0.57432],[0.10859,-0.75767,0.64354],[-0.47937,-0.58224,-0.65666],[0.84922,0.44619,-0.28238],[0.45975,-0.88203,0.10322],[0.61688,-0.25614,0.74421],[0.76065,-0.1682,0.627],[-0.37601,-0.90168,-0.21351],[0.6083,-0.76178,0.22285],[-0.66094,-0.4021,0.63362],[0.79773,0.53581,-0.27663],[-0.73298,-0.58617,-0.34517],[-0.40131,-0.76652,-0.50139],[0.60498,-0.76035,0.23634],[0.010902,-0.36779,0.92984],[-0.4574,-0.27486,-0.84572],[0.78043,-0.15378,-0.60604],[-0.95218,-0.30529,0.012183],[0.90368,-0.42485,0.053524],[-0.46466,-0.29264,-0.83573],[0.87741,0.38937,-0.28025],[-0.85443,-0.50749,0.1114],[0.73405,-0.29601,0.61118],[0.89089,0.27265,-0.36328],[0.82895,-0.55088,0.096845],[-0.57238,-0.74114,-0.35085],[-0.48334,-0.06652,0.8729],[-0.69539,-0.45656,0.55497],[-0.35599,0.93394,-0.031936],[-0.3269,0.94442,0.0348],[0.73652,-0.25503,0.62649],[-0.38989,-0.92083,0.0073371],[0.80574,-0.2088,-0.55424],[0.99905,0.036701,-0.023519],[0.95403,-0.29784,0.033308],[0.93136,-0.14291,0.33488],[-0.90622,-0.33569,0.25705],[0.99594,-0.088439,-0.01667],[-0.79324,-0.43847,0.42251],[-0.61593,-0.51491,0.59623],[0.42814,-0.4772,-0.76745],[-0.16613,0.29354,0.9414],[-0.55591,-0.47395,0.68289],[-0.93905,0.23819,0.24788],[0.75006,-0.18623,-0.63461],[-0.90405,-0.30528,0.29915],[0.96737,0.22175,-0.12256],[0.70538,-0.48501,0.51692],[-0.93432,0.322,-0.15282],[0.73993,-0.10693,-0.66412],[-0.76737,-0.26677,0.58308],[0.51041,0.73079,0.45324],[-0.64364,0.74459,-0.17696],[-0.82947,-0.33517,0.4468],[0.94078,-0.20871,0.26714],[0.71138,-0.36464,0.60081],[-0.9472,0.20449,0.24696],[0.94964,-0.15787,0.27068],[0.5173,0.81528,-0.26024],[0.07803,0.72051,0.68904],[-0.4362,0.8649,-0.24833],[-0.32493,0.89751,-0.29817],[0.58499,0.76668,-0.26455],[0.27868,0.9224,-0.26741],[0.53448,-0.10792,0.83826],[0.71871,-0.13418,-0.68224],[-0.29325,0.87344,-0.38872],[0.73669,-0.28828,0.61171],[0.44298,-0.3313,0.83307],[0.68636,0.60613,-0.40189],[0.50112,0.75411,0.42451],[0.75533,-0.022729,-0.65495],[-0.33993,0.748,-0.57004],[0.89486,0.23392,-0.38014],[-0.47158,-0.41715,0.77691],[-0.85647,0.13208,-0.499],[0.68613,-0.15489,-0.7108],[0.76034,-0.25246,0.59846],[-0.74255,-0.55384,-0.37667],[0.76079,-0.029684,-0.64831],[0.61885,0.11566,-0.77695],[0.69917,0.55635,0.44904],[0.31829,0.023247,-0.94771],[0.7428,-0.27206,0.61175],[0.42483,-0.23247,-0.87492],[-0.8929,-0.14784,0.42529],[0.19384,-0.96126,-0.19597],[0.50357,-0.28464,0.81572],[0.74379,-0.087088,0.66272],[-0.7874,-0.096826,0.60879],[-0.75138,0.65542,0.076413],[0.80336,0.15747,-0.5743],[-0.86714,0.35887,-0.34538],[-0.70831,0.70586,0.0074307],[0.76334,-0.043004,0.64456],[0.46786,-0.85968,-0.20506],[-0.48516,-0.36273,-0.79565],[0.35954,0.31438,-0.87858],[-0.11787,0.2185,-0.96869],[-0.37339,-0.33198,0.86624],[-0.085959,-0.092307,-0.99201],[0.17713,-0.37641,-0.90936],[-0.043802,-0.27846,-0.95945],[0.31873,-0.52873,-0.78667],[-0.707,-0.59676,-0.3795],[-0.83624,-0.0063132,0.54832],[0.97025,0.15304,-0.18761],[0.24163,0.50707,-0.82734],[-0.12006,0.26078,0.9579],[-0.070849,-0.088184,-0.99358],[0.077943,-0.051076,-0.99565],[0.54159,-0.3529,-0.76298],[-0.71495,-0.14189,0.68462],[0.42545,-0.87391,-0.23509],[0.84007,-0.40517,0.36072],[-0.45904,-0.17641,0.87072],[0.75439,0.052375,0.65433],[-0.71363,0.48458,0.50588],[0.48788,-0.34893,0.80014],[0.78747,-0.51703,0.33551],[-0.75545,-0.57425,0.31548],[-0.19755,0.13389,-0.97111],[-0.93739,0.2459,0.24663],[0.24345,0.092856,-0.96546],[0.41864,-0.88653,-0.19701],[0.68083,-0.72182,-0.12427],[-0.83575,-0.091242,0.54147],[-0.787,-0.56032,0.25823],[-0.48066,-0.27783,0.83173],[0.13427,0.80851,-0.57297],[0.18644,0.79775,-0.57344],[-0.036291,0.243,-0.96935],[0.90516,-0.41413,-0.095811],[0.60312,0.38241,-0.7],[0.31396,0.51461,-0.79787],[0.77704,-0.032279,0.62862],[0.61817,-0.75998,0.20072],[-0.17082,0.16268,0.97178],[0.46826,-0.24893,0.8478],[0.17085,0.80365,-0.57005],[0.94065,-0.32934,0.081925],[-0.74964,0.20171,0.63036],[0.82592,-0.23538,0.51231],[-0.54179,0.1079,0.83356],[0.93915,-0.27095,-0.21116],[-0.86346,0.27789,0.42097],[0.61238,-0.32139,0.72228],[0.24582,-0.96914,-0.018488],[-0.084337,0.43172,-0.89805],[0.61969,0.69822,0.35843],[-0.92293,0.16959,0.34559],[0.82026,0.39677,-0.412],[-0.78783,-0.46334,-0.40576],[-0.47547,-0.17153,0.86285],[-0.93429,-0.16577,-0.31562],[0.98391,-0.011492,-0.17828],[-0.78796,-0.054584,-0.61331],[0.59548,0.48151,-0.64308],[0.93634,-0.105,-0.33504],[-0.52799,0.4562,-0.71632],[0.80504,-0.042912,0.59167],[-0.87919,0.34565,0.32796],[0.95933,0.063312,0.27511],[-0.50613,0.66298,-0.55162],[0.042041,0.80783,-0.58791],[0.23994,0.80256,-0.5462],[0.94338,0.26304,-0.20212],[-0.86244,0.20474,0.46291],[-0.1955,0.79416,-0.57541],[-0.90845,0.29889,0.29222],[-0.94402,-0.11052,-0.31082],[-0.44258,-0.27889,0.85226],[-0.74358,0.3485,0.57064],[0.93744,0.23598,0.25596],[0.45712,-0.88876,0.033877],[0.73787,0.49402,0.45988],[-0.78127,-0.43929,-0.44345],[0.8751,0.47156,-0.10875],[-0.78738,0.18853,0.58694],[-0.74032,-0.55434,-0.38031],[-0.72118,-0.63878,0.26805],[-0.66511,0.53281,0.52321],[-0.16748,0.2131,0.96257],[-0.038756,0.32774,0.94397],[0.59169,0.64563,0.48276],[0.38489,0.74395,0.54625],[0.68233,0.72389,-0.10198],[0.03282,-0.99806,-0.052824],[0.86483,-0.46414,0.19141],[-0.92041,-0.099991,-0.37794],[0.61232,0.0025644,0.79061],[0.93567,-0.25101,0.24802],[0.98044,-0.015625,-0.19618],[0.78806,0.22555,0.57278],[-0.63395,-0.75304,0.17614],[0.56269,0.22565,0.79528],[-0.098177,0.79992,0.59202],[-0.97758,-0.21056,0.00043583],[0.38978,0.84359,0.36937],[0.73018,0.22029,0.64677],[0.96315,-0.18014,-0.19972],[-0.043817,0.93612,0.34895],[-0.79767,0.034206,0.60213],[0.99024,-0.091098,-0.10545],[0.95065,0.23688,-0.20037],[-0.92472,0.020774,-0.38009],[-0.98202,0.00029018,-0.18879],[0.82683,0.5262,-0.19865],[0.97405,-0.09114,0.20718],[0.74518,0.61634,-0.25462],[0.93241,0.33528,-0.1349],[-0.92051,0.27601,0.27657],[0.69584,0.33536,0.63508],[-0.60391,-0.38849,-0.69596],[-0.78149,-0.21356,0.58623],[-0.48786,-0.2568,0.83429],[-0.4557,-0.21061,-0.86486],[-0.57156,-0.81662,0.080327],[-0.39942,-0.47128,0.78636],[0.32642,0.46182,-0.82473],[0.5,0.59172,-0.63235],[-0.78693,0.20408,0.58231],[-0.14195,0.23987,0.96037],[-0.05925,0.99811,0.016348],[0.31334,0.34074,0.88641],[-0.54284,0.085055,0.83552],[0.62953,-0.0104,-0.77691],[0.62872,-0.04376,0.7764],[-0.51659,0.02789,0.85578],[-0.59904,-0.54936,-0.58254],[0.69716,-0.24216,-0.67478],[-0.82467,-0.36766,-0.42982],[0.85037,-0.11488,-0.51349],[0.4081,-0.7255,0.55418],[-0.9232,-0.34894,-0.16108],[0.91686,0.031397,-0.39798],[-0.95284,-0.27291,0.13271],[-0.97149,-0.17802,0.15655],[-0.6111,-0.74484,-0.26789],[-0.37613,0.92108,0.10064],[0.94738,0.041643,0.31738],[-0.63304,-0.58838,0.50306],[-0.17913,-0.33819,0.92387],[-0.77083,0.49474,0.40131],[0.92711,0.02775,0.37376],[0.93695,-0.17855,-0.30042],[0.30469,0.90938,0.28319],[0.63779,0.012689,0.77011],[-0.92087,0.15545,0.35755],[-0.25655,-0.87674,-0.40682],[0.86744,-0.48621,0.1056],[-0.27685,-0.79696,-0.53686],[0.043805,-0.93246,-0.35862],[0.8323,-0.54978,-0.070874],[-0.22382,-0.70772,-0.67011],[-0.27928,-0.82909,-0.48437],[0.54186,0.37515,0.7521],[-0.20634,-0.78199,-0.58814],[0.44697,0.82382,-0.34864],[-0.97719,-0.20234,0.064549],[-0.77001,-0.61083,-0.1843],[0.92021,-0.35534,-0.16412],[0.024527,-0.86317,-0.50432],[-0.079498,-0.87952,-0.46918],[-0.53496,0.045433,0.84366],[0.83058,-0.29768,-0.47066],[0.81906,-0.22104,-0.52941],[0.99744,0.04008,0.0592],[-0.43228,-0.51333,0.74137],[-0.17176,-0.67679,-0.71586],[-0.64823,0.27454,0.71023],[-0.11099,-0.7777,-0.61876],[0.96658,-0.22069,0.13046],[-0.082995,-0.86526,-0.49441],[-0.066574,-0.85895,-0.50771],[-0.31775,-0.64206,-0.6977],[0.60037,0.3873,0.69968],[0.50336,-0.60132,-0.62052],[0.98614,-0.13096,0.10189],[0.87954,-0.43426,0.19449],[-0.5062,-0.67675,-0.53458],[0.91043,0.13268,-0.39181],[-0.94062,-0.33808,0.03068],[-0.93977,-0.28001,0.19604],[0.70703,-0.65322,0.27095],[0.85715,0.45418,-0.24293],[-0.43477,-0.77576,-0.45736],[0.5227,-0.71407,0.46571],[-0.86539,0.44146,0.23711],[-0.48745,-0.4013,-0.77547],[-0.82167,-0.5319,0.2048],[-0.43543,-0.065118,0.89786],[0.81272,0.55143,-0.18817],[-0.16834,-0.78407,-0.59741],[-0.393,0.29435,0.87115],[0.45753,-0.79898,0.39025],[0.67754,0.27472,0.68225],[-0.96411,0.25579,0.071142],[-0.99701,0.046626,0.061592],[0.48487,-0.86601,0.12217],[-0.89432,-0.29168,0.33928],[-0.22486,-0.3445,0.91146],[0.53819,-0.82474,0.17366],[-0.47032,-0.68018,-0.56228],[-0.59097,-0.2892,-0.75307],[-0.5252,-0.41314,0.74396],[-0.54578,-0.63163,-0.55061],[-0.40018,-0.5753,0.71336],[-0.63515,-0.71724,0.28662],[-0.62737,-0.71782,0.30189],[-0.48191,-0.83498,-0.26565],[0.98755,-0.030217,-0.15436],[-0.67964,-0.72948,0.07716],[0.3436,-0.73242,0.5878],[-0.50962,0.28506,0.8118],[0.38793,-0.59063,-0.70757],[0.35403,-0.57145,-0.74034],[-0.89443,-0.31738,0.31507],[0.68503,-0.36087,-0.63286],[-0.71396,0.34055,0.61179],[0.99825,0.044895,-0.038486],[0.7849,-0.56938,-0.24441],[0.82221,-0.093689,-0.56142],[-0.99633,-0.023167,-0.082451],[0.73917,0.35839,0.57026],[0.83343,-0.53749,-0.12845],[0.80848,-0.12739,-0.57457],[0.3597,-0.67936,0.63959],[-0.85613,-0.21227,0.47116],[0.97916,0.03399,-0.20022],[-0.93184,-0.26134,0.25174],[0.047841,0.3101,0.9495],[-0.53551,0.63082,0.56152],[0.2334,-0.34572,0.90885],[-0.84096,0.52648,-0.1249],[0.82957,0.51235,-0.22207],[-0.58663,0.4965,0.6398],[0.96293,-0.16927,0.21002],[0.86254,0.49686,0.095724],[0.70472,-0.15689,-0.69192],[0.51136,-0.25124,0.82182],[0.30163,0.91948,-0.25215],[-0.47218,0.85481,0.21529],[0.70299,-0.16201,-0.6925],[-0.71316,-0.15047,0.68466],[0.36013,0.88019,-0.30916],[-0.9133,0.29054,0.28543],[-0.44014,0.68498,-0.58058],[0.95744,-0.078665,0.27772],[-0.88882,0.11462,0.44368],[-0.34476,0.68635,-0.64037],[0.91011,-0.10265,0.40145],[-0.45162,0.52297,-0.72288],[0.67413,0.425,0.60409],[0.67646,-0.17083,-0.7164],[0.91576,0.045971,-0.39909],[-0.85748,0.17098,0.48528],[-0.28844,-0.85306,0.43485],[-0.84821,-0.31181,-0.42815],[-0.87579,0.089403,0.47434],[-0.61404,-0.58596,-0.52878],[0.78877,-0.35553,-0.50143],[-0.68765,-0.033736,0.72526],[0.73183,0.1418,-0.66657],[-0.27262,-0.61099,-0.74322],[-0.50035,0.33486,0.79844],[0.85523,0.058129,0.51498],[0.61001,-0.57762,-0.54244],[-0.28226,-0.42244,-0.86132],[0.44936,-0.090893,0.88872],[0.48513,-0.60113,-0.63505],[-0.18055,-0.64779,0.74011],[-0.40233,-0.91459,-0.04072],[-0.23238,-0.96888,-0.085228],[0.4271,-0.89307,-0.14147],[0.61211,0.37693,0.69515],[0.64499,0.57329,0.5053],[0.54589,-0.68621,-0.48075],[0.17091,-0.40604,0.89773],[-0.95767,-0.15739,0.24103],[-0.4973,0.56417,0.65909],[-0.87227,0.489,-0.0045151],[-0.67398,0.059666,0.73634],[-0.4674,-0.25387,-0.84681],[0.65569,-0.65223,-0.38035],[-0.87376,0.10966,0.47384],[-0.78132,0.22516,0.5821],[0.82019,-0.57041,-0.043778],[-0.48663,-0.095274,-0.8684],[0.51971,0.29356,0.80233],[0.78879,-0.50998,-0.34312],[0.43861,-0.88402,-0.16162],[-0.58845,-0.19377,-0.78497],[0.19921,0.67235,-0.71292],[-0.22464,0.3687,-0.902],[-0.85927,-0.31846,-0.4003],[-0.28348,0.55607,0.7813],[-0.51055,0.39934,0.76149],[0.95438,-0.27916,0.10601],[-0.27869,0.68243,0.67574],[-0.20739,-0.95531,0.21064],[0.0052463,0.75346,-0.65748],[-0.29341,-0.19889,0.93507],[-0.30947,0.31276,-0.898],[0.61934,-0.095533,-0.77929],[0.78597,-0.21592,-0.57933],[-0.31536,-0.91326,0.25789],[-0.88474,0.27556,0.37591],[0.5348,0.54424,0.64637],[-0.75993,-0.39629,-0.51523],[-0.06018,0.68741,-0.72377],[0.55304,-0.43672,0.70952],[0.2796,0.30573,-0.91014],[0.58354,0.47656,-0.65755],[0.096025,0.71169,-0.6959],[0.42334,0.56813,-0.7057],[-0.89697,0.32759,0.29686],[0.068765,0.78568,-0.6148],[-0.32489,0.47047,-0.82043],[0.40109,0.71407,0.57378],[-0.36253,-0.81845,0.44577],[-0.12942,0.59863,-0.7905],[0.10807,0.55724,-0.82329],[-0.9566,0.012099,0.29116],[0.46417,0.40928,-0.78552],[0.39407,0.52427,0.75489],[0.64874,0.5329,-0.54329],[-0.22252,0.20965,0.95212],[0.9633,-0.24536,0.1089],[-0.17932,0.19552,0.96417],[-0.85823,-0.35924,-0.36658],[-0.78998,0.29893,0.53532],[0.28963,-0.9091,0.29943],[0.96961,-0.24295,-0.028737],[0.99915,-0.031597,0.026476],[-0.80829,0.23992,-0.53768],[0.57189,0.63388,-0.52071],[0.18671,0.33538,0.9234],[-0.95814,-0.24069,0.15501],[-0.88448,0.31427,0.34487],[0.64407,-0.14519,0.75107],[0.43824,0.77108,-0.46192],[-0.76493,0.48502,0.42383],[0.43137,0.65904,0.61611],[-0.11188,0.90954,-0.40027],[0.025142,0.9039,-0.42701],[-0.85737,-0.33546,-0.39037],[0.91369,-0.088978,0.39656],[-0.74279,0.42157,0.52013],[0.82922,0.054158,0.5563],[0.084248,0.72727,0.68116],[0.19196,0.64507,0.73962],[0.42526,0.75651,0.49684],[-0.78726,-0.47719,-0.39053],[-0.4431,0.53788,0.71718],[-0.43319,0.59478,0.67718],[0.79914,0.4417,0.40777],[-0.89199,-0.31846,-0.32083],[-0.95631,-0.013621,0.29203],[0.53146,-0.20053,0.82301],[0.4461,0.027229,0.89457],[0.49301,-0.054274,0.86833],[0.81601,0.5422,-0.20035],[-0.52487,0.62811,0.57445],[0.95883,-0.27549,-0.068957],[0.065969,0.8718,-0.48539],[0.92409,0.32863,-0.19511],[-0.3393,0.70116,0.62709],[-0.10166,0.72888,0.67705],[0.60906,0.77151,-0.18391],[0.51285,0.66647,0.54111],[-0.96329,0.058777,-0.26196],[-0.21628,0.80648,0.55029],[-0.95842,0.041938,-0.28226],[-0.32878,0.7032,0.6304],[-0.44823,0.44772,0.77371],[0.36837,-0.10428,0.92381],[-0.94362,0.059402,-0.32565],[0.89574,0.43231,-0.1037],[0.72538,0.31275,0.6132],[0.76782,0.19273,0.61099],[-0.59922,-0.52095,-0.6079],[-0.66002,-0.29852,0.68939],[0.7801,0.53515,0.32413],[0.52061,0.85043,-0.075701],[-0.53824,-0.30274,-0.78654],[-0.67334,-0.14398,-0.72517],[-0.9466,-0.24752,-0.20659],[-0.84061,0.43058,0.3286],[-0.76033,0.016424,0.64933],[0.7422,-0.11185,0.66078],[0.30545,0.95209,-0.014636],[0.72441,0.32586,0.60749],[0.81327,-0.58164,-0.017065],[0.80098,0.30762,0.51362],[0.70805,0.20312,-0.67632],[-0.75362,-0.14934,-0.64012],[0.81536,-0.11217,-0.56799],[-0.85374,-0.056344,-0.51764],[0.86705,0.042008,-0.49644],[-0.9957,-0.085332,-0.036117],[0.94095,0.24164,-0.23713],[-0.98091,-0.18872,-0.046819],[0.87643,0.22263,0.42697],[0.65142,0.51939,0.55308],[-0.92009,-0.033358,0.39028],[0.66733,0.74136,0.07108],[0.41664,0.82936,-0.37226],[-0.60374,0.63054,0.48778],[-0.30606,0.80997,0.50028],[-0.99802,0.029403,-0.055621],[-0.25183,-0.6469,-0.71979],[-0.93502,0.17422,0.30884],[-0.1372,-0.64545,-0.75137],[0.47737,-0.20364,-0.85478],[0.40019,0.80594,0.43623],[-0.60703,-0.55843,-0.56539],[-0.073213,-0.30621,-0.94915],[-0.38432,0.10693,-0.91699],[0.34142,0.22141,-0.91346],[0.67066,0.2628,-0.69365],[-0.30598,0.64521,-0.70006],[0.32595,0.60183,-0.72908],[0.96162,0.092413,0.25837],[0.88151,0.28418,0.37707],[0.15834,-0.79744,-0.58225],[0.23725,-0.68719,-0.68664],[-0.93815,0.23731,0.2521],[-0.0016511,-0.68324,-0.73019],[0.52608,-0.76601,-0.36941],[0.63659,-0.3033,0.70905],[-0.73778,-0.11165,0.66574],[0.96955,-0.22363,-0.099772],[0.97307,-0.073303,0.21855],[0.55611,-0.54572,0.62684],[0.92802,-0.30544,-0.21327],[0.002738,-0.85871,-0.51246],[-0.15946,0.71918,0.67628],[0.77873,-0.52964,-0.33623],[-0.20889,0.7754,0.59592],[-0.98719,-0.15713,0.027615],[0.9955,0.094409,-0.0082214],[-0.71994,0.50458,0.47653],[0.048949,-0.87299,-0.48528],[0.9466,-0.025681,0.32139],[0.13138,0.73901,0.66075],[-0.39278,-0.69252,-0.6051],[-0.70528,0.45915,0.54016],[-0.11641,0.80028,0.58822],[-0.9632,0.25112,0.095858],[-0.14849,-0.80957,-0.56793],[0.93337,0.30509,0.18904],[0.88055,-0.25111,0.40198],[0.66672,-0.45148,-0.593],[-0.98781,-0.14596,-0.05413],[-0.47288,0.3496,0.8088],[-0.30142,0.78464,0.54175],[-0.82171,0.48865,0.29327],[0.83927,-0.080644,-0.53771],[-0.86398,0.50136,-0.046778],[-0.40621,-0.69399,-0.59445],[0.23267,-0.24642,0.94082],[0.91948,-0.28798,0.26763],[-0.43405,-0.69508,-0.57312],[-0.17045,0.83879,0.51708],[-0.3049,-0.68297,-0.66377],[-0.97787,-0.20247,-0.052606],[-0.21152,0.68086,0.7012],[-0.097986,-0.70176,-0.70564],[0.43027,0.81768,0.38246],[-0.84421,0.53563,-0.020369],[-0.39426,-0.55204,-0.73472],[0.80279,-0.072532,0.59184],[-0.92914,-0.3589,-0.088793],[0.43802,-0.78564,0.43693],[-0.86206,0.49925,0.087167],[-0.53382,-0.24527,-0.80925],[-0.60254,-0.067109,0.79527],[-0.98294,-0.18177,0.028044],[0.58482,-0.77254,0.24732],[0.25352,-0.064488,0.96518],[0.46195,0.88513,0.056146],[0.85054,0.41869,-0.31824],[-0.95314,-0.2457,0.1765],[0.96276,-0.27004,-0.013441],[0.88481,0.26844,-0.38086],[-0.22078,0.13871,0.96541],[-0.87519,0.48349,0.016835],[0.68704,-0.34433,-0.63986],[-0.73922,-0.63424,0.2265],[0.6203,-0.76897,0.15464],[0.8988,0.43445,0.058382],[-0.61178,-0.70622,0.35633],[-0.64981,-0.64391,-0.40389],[0.34308,-0.24148,0.90773],[0.45377,-0.57329,-0.68223],[-0.83193,0.10459,0.54494],[-0.56029,0.66589,0.49261],[-0.87418,-0.46762,-0.13092],[0.5424,-0.60418,-0.58376],[-0.72437,-0.62823,0.28393],[-0.68225,0.56168,-0.46803],[-0.95365,-0.2963,0.052626],[0.63468,0.24495,0.73293],[-0.94008,-0.33973,0.028796],[-0.86961,-0.31926,0.37664],[0.78512,-0.19727,0.58709],[-0.39415,0.81123,0.43191],[0.69111,-0.32632,-0.64489],[0.26074,-0.19154,0.94622],[0.6777,-0.33547,0.65436],[-0.92683,-0.22384,0.30148],[0.69684,-0.11912,-0.70727],[-0.54221,0.71808,0.43631],[-0.50362,-0.40465,0.7633],[-0.78015,0.12118,0.61374],[-0.86586,-0.24811,0.43443],[0.61933,0.7585,-0.20276],[0.42884,-0.16564,0.88806],[0.48848,0.8223,0.29192],[-0.54348,0.83939,0.0080307],[0.71738,0.28593,0.63531],[0.22035,0.67189,0.70711],[-0.46647,0.85149,-0.23955],[-0.89356,-0.31258,0.32225],[-0.62819,-0.77722,-0.036149],[0.54911,0.66206,-0.51006],[-0.84499,0.001882,0.53478],[-0.92942,0.010277,0.36889],[-0.80755,0.31116,0.50104],[-0.63471,0.52714,-0.56504],[0.63682,0.41169,0.6519],[0.91912,0.22446,0.32379],[0.62811,0.71458,-0.30798],[-0.51076,0.16838,-0.84307],[0.86331,0.17325,-0.474],[0.92716,0.20334,0.31469],[0.71037,-0.14038,-0.68968],[-0.74062,0.48169,0.46846],[0.86123,-0.22433,-0.45603],[-0.18883,-0.5265,-0.82894],[-0.46941,-0.39944,-0.78746],[0.29614,0.88538,0.35834],[0.77745,0.62779,-0.038036],[-0.77248,-0.12549,0.62251],[-0.59221,0.62556,0.5079],[-0.24499,-0.58855,-0.77045],[-0.60325,0.4625,-0.64976],[-0.25601,-0.58439,-0.77003],[-0.41197,-0.27145,-0.86982],[0.75317,0.43897,0.48994],[0.7903,-0.33336,0.5141],[-0.78174,-0.18499,0.59553],[-0.88122,0.33268,0.33581],[0.48298,0.87434,0.047605],[-0.37618,-0.8979,-0.22861],[-0.025575,-0.99702,-0.072784],[0.13113,0.97709,0.16765],[-0.73269,0.12475,0.66903],[0.12151,0.92662,0.35584],[0.79251,0.23639,-0.56218],[-0.66797,0.44455,0.59681],[0.17175,0.9706,0.16862],[-0.6916,-0.35436,-0.62938],[0.41951,-0.88878,-0.18458],[0.4108,-0.86027,-0.30198],[0.89075,0.44763,0.078604],[-0.98034,0.055587,0.18934],[-0.70802,0.61361,-0.34955],[-0.65192,-0.054515,-0.75633],[0.7531,-0.62733,-0.19824],[0.34638,0.070519,0.93544],[0.44641,-0.85782,-0.25467],[-0.039856,0.11797,0.99222],[-0.76121,0.60479,-0.23409],[0.71823,0.032572,-0.69504],[0.75903,0.58453,0.28671],[0.83596,-0.31358,0.45038],[0.92731,0.3736,-0.022696],[0.40487,-0.38433,0.82969],[-0.72233,0.34847,0.59733],[-0.43739,0.041081,0.89833],[-0.67502,-0.18319,0.71469],[-0.67308,0.015106,-0.73942],[-0.99866,0.0099101,0.050852],[0.80146,-0.56667,-0.19119],[0.90289,0.30703,0.30087],[0.57214,-0.81976,-0.025378],[0.75202,-0.65837,0.031837],[0.72237,0.17327,-0.66945],[0.49829,-0.22764,-0.83659],[-0.44025,0.48416,-0.75615],[0.52243,0.85247,-0.018933],[0.85265,-0.44274,-0.27744],[-0.78319,-0.10724,0.61247],[0.38416,0.20556,-0.90009],[-0.81931,0.41588,0.39469],[-0.44323,0.40436,0.80003],[0.98533,0.17016,0.012645],[-0.97694,-0.10839,0.18397],[0.14685,0.82042,-0.55258],[0.090725,0.80709,-0.58341],[0.72585,0.023145,-0.68747],[0.87424,-0.31792,-0.36692],[-0.96706,-0.25188,-0.036785],[0.94301,-0.33217,-0.019752],[-0.73221,0.66573,-0.14381],[0.49404,0.86939,0.0094918],[0.49238,0.86964,-0.03588],[0.072571,0.72171,-0.68839],[-0.97354,0.20444,0.10206],[0.16646,0.80951,-0.56301],[-0.4258,0.56862,-0.70382],[0.76408,0.15955,-0.62508],[-0.8151,-0.48536,-0.31629],[0.88181,-0.24305,0.40416],[0.38629,0.6808,-0.62232],[0.23628,0.65689,-0.71601],[0.4811,0.57614,-0.66076],[-0.91997,0.20391,0.33477],[0.98467,-0.13288,-0.11301],[0.45738,0.79583,-0.39681],[0.89793,-0.049308,0.43737],[-0.83381,-0.15255,0.53056],[0.94376,0.32636,-0.052989],[-0.93758,-0.1067,-0.33101],[0.98695,0.136,0.08626],[0.83875,0.29996,0.45445],[-0.8081,0.45536,0.37366],[-0.69202,0.5706,-0.44218],[0.57918,0.67578,-0.45593],[-0.58683,0.66332,0.46437],[-0.86894,0.37847,0.31891],[0.71026,0.42909,0.55804],[-0.38135,0.8449,-0.37513],[0.2073,0.89485,-0.3953],[0.36898,0.87667,-0.3087],[0.63636,0.76423,-0.10489],[0.92393,0.3765,0.067815],[0.72168,0.35592,0.59372],[0.97371,-0.058823,0.22005],[0.93494,0.35065,0.054171],[0.57897,0.80454,-0.1323],[-0.48132,0.80404,-0.34908],[0.90621,0.42013,0.047742],[0.45134,0.59172,0.66795],[0.45679,0.62827,0.62977],[0.95389,-0.012956,0.29989],[0.8498,0.44886,0.27636],[0.50458,0.41209,0.75867],[0.88048,0.47404,0.0059436],[-0.27999,0.069333,0.9575],[0.71272,-0.218,0.66672],[0.6994,0.7031,-0.1284],[0.8862,-0.46289,0.019801],[-0.63768,0.55137,0.53793],[0.64509,0.45534,0.61362],[0.29445,-0.19484,0.93559],[-0.19087,0.13602,0.97215],[-0.82466,0.48214,0.29576],[-0.91459,-0.28259,-0.28926],[0.68078,0.70422,-0.20151],[0.69751,0.70753,-0.11353],[-0.80043,0.52605,0.28738],[-0.42165,0.68923,0.58922],[0.80132,0.35817,0.47917],[-0.1612,0.83667,0.52344],[0.63551,-0.1856,0.74946],[0.34655,-0.21589,0.91285],[0.88499,0.31425,0.34356],[-0.96367,-0.13611,-0.22981],[0.87944,0.013233,-0.47583],[0.86993,0.47458,-0.13418],[-0.20751,0.72582,0.65584],[-0.13242,0.79414,0.59313],[0.77984,-0.26684,0.56625],[-0.71873,0.66769,0.19392],[0.27882,0.76827,0.57622],[0.85623,-0.039842,-0.51505],[0.96692,0.18247,-0.17822],[-0.83367,-0.19545,-0.51652],[0.89418,0.44771,0.0020129],[-0.73394,-0.26136,-0.62691],[-0.80933,0.35517,-0.4678],[0.80309,0.57505,0.1561],[0.79944,0.56446,-0.20562],[-0.55143,-0.41433,-0.72406],[-0.82239,0.48375,0.29943],[0.81961,0.50615,0.26842],[-0.73472,-0.028246,0.67778],[0.68691,0.69499,-0.21248],[0.34368,0.93318,0.10515],[-0.78429,-0.40922,-0.4663],[-0.8723,0.47921,0.097248],[0.62955,0.77332,-0.075176],[0.91357,0.30417,-0.26993],[-0.76267,-0.1443,-0.63048],[0.93546,0.18563,-0.30076],[0.28022,0.81534,-0.50666],[-0.81289,0.5063,0.28787],[-0.96797,-0.035386,0.24855],[0.65739,0.22748,-0.71839],[0.37953,0.82339,-0.42188],[-0.90699,0.36923,-0.20256],[-0.93437,-0.11358,-0.33771],[-0.7354,0.6741,0.06913],[0.28555,-0.075665,0.95537],[-0.81988,0.55401,-0.14449],[0.92508,0.33442,-0.17996],[-0.77757,0.054291,0.62644],[0.20703,-0.9782,0.016117],[0.86488,0.49785,-0.064288],[0.71201,0.69572,0.094976],[0.48461,0.84807,0.21433],[-0.16431,0.85392,0.49378],[-0.00047354,0.89766,0.44069],[0.046718,0.89831,0.43687],[0.38294,0.83519,0.39473],[0.11824,-0.61926,-0.77624],[-0.46418,-0.88263,-0.074151],[-0.44485,-0.68798,-0.5734],[-0.78485,0.24304,0.57003],[-0.85345,-0.39443,-0.34065],[0.7013,-0.26748,-0.66078],[0.74456,-0.057643,-0.66506],[-0.85902,0.0078469,-0.51188],[-0.81839,0.52032,0.24394],[-0.70122,0.68026,-0.21337],[0.8183,0.50434,0.27572],[0.64547,0.60054,-0.47193],[0.1352,-0.66861,-0.73122],[0.9396,0.082232,0.33226],[-0.54029,-0.64593,-0.53931],[-0.42101,-0.63271,-0.64995],[0.099125,-0.68418,-0.72255],[0.22322,-0.79035,-0.57054],[0.47336,-0.32756,0.8177],[0.38778,-0.047354,0.92053],[-0.61979,-0.71801,-0.31674],[0.78063,0.61596,-0.10586],[-0.29244,-0.77291,-0.56311],[0.33814,-0.037604,0.94035],[-0.9859,-0.12937,-0.10615],[-0.97585,-0.066694,0.20803],[0.63744,-0.63818,-0.43175],[0.14934,-0.92706,-0.34389],[0.6086,0.7933,-0.016672],[0.81302,-0.57508,-0.090953],[-0.41361,-0.81372,-0.40839],[0.95568,0.28149,0.086253],[-0.18615,-0.78951,-0.58482],[-0.017313,-0.78832,-0.61502],[-0.067768,-0.82199,-0.56546],[0.43912,-0.30598,0.84472],[0.39103,-0.72662,-0.5649],[-0.71375,0.62551,0.31511],[-0.51762,-0.71538,-0.46937],[0.74707,-0.30492,-0.59069],[0.91017,-0.39403,0.12782],[0.98049,0.17922,0.080726],[-0.38344,-0.63067,-0.67471],[-0.36509,0.85956,-0.35758],[0.97909,-0.19759,-0.048372],[0.87191,0.24879,-0.42177],[0.83555,0.46151,-0.29809],[-0.59335,-0.65183,-0.47229],[-0.22294,-0.72966,-0.64645],[-0.13402,-0.70704,-0.69436],[-0.67349,-0.62198,-0.39944],[-0.92956,0.31878,0.18522],[-0.40667,-0.72155,-0.56035],[-0.31372,0.86445,-0.39281],[0.66256,-0.6981,0.27142],[-0.56028,-0.68508,-0.46557],[0.82322,0.50412,-0.2611],[0.90972,0.38968,-0.14335],[-0.50847,-0.24826,0.82451],[0.3867,-0.91989,-0.065321],[-0.73291,-0.38587,-0.56031],[-0.95885,-0.1367,0.24883],[0.48799,-0.84265,-0.2276],[-0.33847,-0.32674,0.88243],[-0.55653,0.8094,-0.18749],[-0.77997,-0.24761,-0.57475],[-0.97014,0.2341,0.063375],[0.34548,-0.28966,0.8926],[0.57859,-0.81412,0.049514],[-0.58724,-0.32376,-0.74184],[0.091501,0.97771,0.18898],[-0.73915,0.60946,0.28672],[-0.38493,-0.23855,0.89159],[0.53008,-0.80757,0.25856],[0.71193,-0.19705,-0.67403],[0.22721,0.95859,0.17172],[-0.53061,-0.52372,-0.66646],[-0.67165,0.65258,0.35076],[0.68177,0.71361,-0.16112],[-0.70272,-0.26865,-0.65879],[-0.71845,-0.65928,0.22176],[-0.957,-0.017602,0.28954],[-0.50253,0.86435,0.019039],[0.68004,-0.43912,-0.58712],[0.67168,-0.28017,0.68582],[-0.8619,-0.22675,-0.45355],[0.10407,0.73204,-0.67327],[-0.24134,0.95995,0.14231],[-0.97127,-0.14495,-0.18876],[0.78335,-0.18664,-0.5929],[-0.96304,-0.23474,0.13208],[-0.79694,-0.49652,0.34403],[0.99995,-0.0021674,-0.010006],[0.71236,-0.29437,-0.6371],[-0.98274,-0.16338,0.08676],[-0.99447,0.098505,-0.03634],[0.69541,-0.30548,-0.65045],[0.81468,-0.50229,-0.28983],[0.73506,-0.1853,-0.65218],[-0.38266,0.92376,-0.015633],[0.69911,-0.18037,-0.69189],[-0.64008,0.7663,-0.055508],[0.58617,0.80776,0.062695],[0.66574,0.69816,0.26335],[0.71175,-0.18914,0.67649],[-0.64686,0.75443,-0.11141],[0.38049,0.87254,-0.30643],[-0.27378,0.090335,0.95754],[-0.82748,0.5539,0.09204],[0.548,0.77943,-0.30361],[0.44255,0.893,0.081859],[-0.61632,0.78564,-0.054105],[0.46924,0.71944,-0.51207],[0.75232,-0.011728,-0.65869],[-0.48619,0.42355,-0.76435],[0.77769,0.39986,0.48509],[-0.3603,0.53278,-0.76572],[0.70002,0.35332,-0.6206],[0.77896,-0.14962,-0.60897],[0.55545,0.8117,-0.18061],[0.84955,-0.299,0.43458],[-0.88193,0.11938,0.45602],[0.84245,-0.10933,-0.52756],[-0.37418,0.18624,-0.90846],[0.15869,0.65589,-0.73798],[0.35841,0.9228,0.14138],[-0.3079,0.95003,0.051429],[-0.3227,-0.37073,-0.87088],[-0.87871,-0.25162,0.40565],[-0.84846,0.47413,0.23518],[0.87505,0.085639,-0.47639],[-0.5431,-0.58147,-0.60575],[-0.68201,0.69036,-0.24139],[0.84595,0.18943,-0.49848],[0.83252,0.52407,0.17964],[-0.4882,-0.60816,-0.62594],[-0.71627,0.61127,-0.3366],[0.75474,0.65126,0.078936],[0.66728,-0.55331,-0.49857],[-0.72609,-0.0031538,0.68759],[-0.90948,0.12827,0.39548],[0.65196,0.73747,0.1763],[-0.78114,-0.22286,-0.58322],[-0.63215,0.66884,-0.3912],[-0.60533,-0.6771,-0.41846],[-0.80969,0.50203,0.30391],[-0.16083,0.98571,0.050177],[-0.40794,0.91042,0.068788],[-0.91206,0.027531,0.40912],[-0.37133,0.92493,0.081382],[0.77439,-0.55881,-0.29674],[-0.72383,-0.51064,-0.46402],[0.56073,0.80532,0.19248],[0.62209,-0.74052,-0.25424],[0.78641,-0.042534,-0.61624],[-0.83116,0.006744,-0.55599],[0.17399,0.77846,-0.6031],[-0.91975,0.18397,0.34673],[-0.82478,-0.32451,-0.46307],[0.52175,-0.46515,-0.71513],[0.87788,-0.47707,-0.041667],[-0.73077,0.67164,0.12195],[-0.91192,0.20506,0.35547],[0.4207,-0.011648,-0.90713],[0.17661,-0.36634,0.91357],[-0.819,0.064701,-0.57014],[0.73655,0.046142,0.67481],[-0.49841,0.61126,-0.61477],[-0.81627,0.49327,0.30065],[-0.11394,0.99186,0.056937],[-0.59947,0.72037,0.34887],[0.27956,0.53611,-0.79651],[0.2945,0.51896,-0.80247],[0.65473,0.48052,0.58346],[-0.83923,-0.33219,-0.43051],[0.75929,0.64209,-0.10581],[0.12798,0.79835,-0.58844],[0.1622,0.98327,0.082833],[0.24167,0.9172,0.31678],[-0.4107,0.74552,-0.52491],[0.41518,-0.3014,0.85836],[0.95662,-0.28888,-0.037643],[-0.19143,-0.95936,-0.20732],[0.34712,0.64005,-0.68545],[0.20125,0.80204,-0.56235],[0.73719,0.60011,0.31051],[0.7755,0.27829,-0.5667],[-0.61755,0.61256,0.49336],[0.4775,0.55631,-0.68008],[-0.85343,-0.40851,-0.32369],[-0.28437,0.92232,0.26166],[0.1411,0.75823,-0.63653],[-0.46445,0.70018,-0.54225],[0.52252,-0.037658,0.85179],[-0.19901,0.71641,-0.66869],[0.042615,0.74778,-0.66258],[-0.30707,0.76308,-0.5687],[-0.71709,0.59806,0.35792],[0.65615,0.62003,-0.43015],[-0.91932,0.041098,-0.39136],[-0.18497,0.83742,-0.51431],[0.25957,0.78284,-0.5655],[0.11659,-0.98639,0.1159],[0.69542,0.71594,-0.061886],[0.78341,0.56637,0.25592],[0.075277,-0.99708,0.012961],[-0.88539,0.41496,0.20951],[-0.40119,0.83842,0.36892],[0.17718,-0.96304,0.20287],[0.11488,-0.43739,0.8919],[-0.32972,0.049926,0.94276],[-0.49833,0.71885,-0.48468],[0.86347,0.23927,-0.44403],[-0.68223,0.45127,0.57525],[-0.58405,0.055213,0.80984],[0.57164,0.64322,0.5094],[-0.089829,0.96455,-0.24813],[0.058286,0.96869,-0.24132],[0.20692,0.94634,-0.24826],[-0.012566,-0.99816,0.059236],[-0.71386,0.6451,0.27248],[0.50967,0.64455,0.56991],[-0.76051,-0.49147,-0.42435],[0.86888,0.44098,-0.22489],[0.23973,0.1344,0.96149],[0.422,-0.90511,-0.051902],[-0.71488,0.62577,-0.31203],[0.60698,0.52073,0.60035],[-0.71961,0.4076,0.56216],[0.12308,-0.98734,-0.10003],[-0.9996,-0.017093,-0.02269],[0.87587,0.27632,-0.3956],[0.80542,0.58973,-0.059277],[-0.023701,0.8673,0.49722],[-0.016279,0.80121,0.59816],[0.53318,0.078894,0.84232],[0.27914,0.58631,0.76048],[0.37407,-0.88746,-0.26922],[-0.35585,-0.33923,0.8708],[-0.06082,0.59949,0.79807],[-0.34637,-0.3497,0.87048],[0.82893,-0.13115,-0.54377],[-0.96506,0.25583,-0.056682],[-0.98828,0.0058005,-0.15256],[0.54528,-0.21812,0.80938],[0.85419,0.28354,-0.43586],[0.8017,0.47413,-0.36398],[-0.59901,-0.41758,-0.68324],[0.50964,-0.25368,0.82214],[-0.90472,0.083677,0.41771],[-0.63406,-0.32829,-0.70014],[-0.61654,0.66454,0.4222],[0.81643,0.54991,0.17619],[-0.70776,-0.28609,-0.64594],[-0.94247,0.30825,-0.12938],[0.56445,0.80142,0.19778],[-0.90174,-0.19436,-0.38612],[0.95097,-0.19654,-0.2388],[0.4216,0.90381,-0.073299],[0.48002,0.50482,-0.71745],[0.4066,0.15677,0.90005],[-0.87352,0.0094522,-0.4867],[0.64097,0.29624,-0.70809],[-0.82421,0.51076,-0.24452],[0.75623,0.54711,-0.35888],[0.5003,-0.70107,0.50814],[-0.91528,0.088575,-0.39296],[0.92588,0.1922,-0.32527],[-0.95042,-0.0096775,-0.31081],[-0.094512,-0.99258,0.076476],[0.81754,-0.053439,0.57339],[-0.70981,0.64208,0.28966],[0.51202,0.62597,0.58821],[-0.62187,-0.69022,0.36996],[-0.82728,0.5149,0.22468],[-0.90274,0.31399,0.29406],[-0.88226,0.046784,0.46843],[0.26157,0.90103,0.34601],[0.50641,0.83474,0.21623],[0.21472,0.74756,-0.62853],[0.050266,0.10577,0.99312],[0.38027,-0.43805,-0.81456],[0.49583,0.80833,0.31742],[0.12892,-0.95942,-0.25078],[-0.35826,-0.24306,0.90143],[0.81457,-0.042627,-0.5785],[-0.97143,-0.20364,-0.12189],[-0.82063,-0.49021,-0.29371],[-0.99455,0.10427,0.0025854],[0.76613,0.35665,-0.53465],[0.39229,-0.18573,0.9009],[0.24166,0.90886,-0.33996],[0.41897,-0.13848,0.89738],[-0.489,0.87228,-0.0019701],[-0.10537,0.97974,0.17031],[-0.075794,-0.83835,-0.53984],[-0.96451,-0.24232,-0.10492],[-0.73662,0.60242,-0.30738],[0.16249,-0.80428,-0.5716],[-0.3941,-0.62013,-0.67833],[-0.27506,-0.72318,-0.63352],[-0.80541,-0.20518,0.55607],[-0.44036,-0.62045,-0.64894],[0.44824,-0.68268,-0.57708],[-0.52533,-0.57729,-0.62511],[0.81315,-0.34027,-0.47223],[-0.73503,-0.53611,-0.41511],[-0.88572,-0.38759,-0.25548],[0.64603,-0.41358,-0.64155],[0.54135,0.73065,0.41605],[0.0098636,-0.87656,-0.4812],[0.43287,-0.83523,-0.33914],[-0.71111,0.61692,-0.33724],[0.83352,-0.54514,-0.089796],[0.031103,-0.87775,-0.47812],[0.067845,-0.77421,-0.62928],[0.034855,-0.89828,-0.43804],[0.76845,0.52349,-0.36803],[-0.45789,-0.88535,-0.080607],[-0.023742,-0.8883,-0.45865],[0.16623,-0.82315,-0.54295],[0.99414,0.086079,0.065327],[-0.7183,-0.50023,0.48354],[0.70021,0.01256,0.71382],[-0.37739,-0.80656,-0.45502],[-0.72283,-0.47547,0.50145],[0.60468,-0.54371,-0.58202],[-0.75442,0.55856,0.34475],[-0.9495,-0.22644,-0.21718],[0.83984,-0.15042,-0.52157],[0.61258,-0.78507,-0.091723],[-0.34627,-0.72792,-0.5918],[-0.3292,0.86575,0.37696],[-0.65632,-0.64745,-0.38735],[-0.14442,-0.69955,-0.69983],[0.77496,0.55663,-0.29933],[-0.45758,-0.72587,-0.51355],[0.85235,0.48148,-0.20416],[-0.98486,-0.15382,0.079931],[0.9411,0.052617,0.33401],[-0.67284,-0.65382,-0.34613],[-0.96614,-0.15799,0.20401],[0.85475,-0.51421,-0.070688],[-0.80413,-0.54719,-0.2323],[-0.98268,0.012648,0.18487],[0.81579,0.50717,-0.27795],[-0.95324,-0.20169,0.22506],[0.37653,-0.84358,-0.38289],[-0.78323,-0.1923,0.59124],[0.45073,-0.8372,-0.30974],[-0.61721,0.65048,0.44265],[0.73346,-0.66489,-0.14129],[-0.70155,-0.57608,-0.41947],[0.80722,-0.023356,-0.58979],[-0.96314,-0.24592,0.109],[0.8428,0.02234,0.53776],[-0.57875,0.65471,0.48622],[-0.56163,-0.4477,-0.6958],[0.49905,0.8337,0.23642],[-0.56322,-0.4501,-0.69296],[0.54097,-0.46206,-0.70275],[-0.82236,-0.5584,-0.10915],[0.54384,-0.53257,-0.64854],[-0.79606,-0.59682,-0.10046],[-0.72615,0.59777,-0.33967],[0.92685,-0.37041,0.061211],[-0.67303,-0.64927,0.35424],[0.99336,-0.10886,0.037226],[-0.86246,-0.042788,-0.50431],[0.48343,0.7869,0.38352],[0.67613,-0.31353,-0.66674],[-0.77632,-0.4375,0.4538],[0.77212,0.54384,-0.32875],[-0.98221,-0.064292,-0.17644],[0.99189,0.10467,-0.072111],[0.055325,0.95113,0.3038],[-0.84324,0.52872,-0.09697],[0.95289,0.28273,-0.1098],[-0.98941,-0.038753,-0.13986],[0.48281,-0.68254,0.54867],[0.92898,-0.22931,-0.29053],[0.80551,0.58348,-0.10349],[0.52101,-0.041041,0.85257],[0.40644,0.69568,0.59231],[0.66964,-0.20054,-0.7151],[0.27446,-0.41745,0.86626],[-0.57587,0.81656,-0.04015],[0.13658,0.76446,0.63004],[0.50897,0.80298,-0.31013],[-0.87577,-0.070697,0.47752],[-0.78452,0.58138,-0.21569],[-0.81493,0.12276,-0.56641],[-0.63918,0.42992,-0.63766],[-0.7763,-0.1319,0.61641],[0.84093,0.52036,-0.14856],[0.66952,0.68717,-0.28202],[-0.66885,0.029769,-0.7428],[-0.70867,0.58057,-0.40091],[-0.52395,0.18705,-0.83096],[0.82346,-0.080469,-0.56164],[0.35841,0.79363,-0.49162],[0.45135,0.82678,0.33572],[-0.47941,-0.36833,-0.79655],[-0.95864,0.073622,0.27493],[-0.7239,-0.36466,-0.58566],[0.48611,0.85442,-0.18347],[0.49585,-0.57704,-0.64896],[0.7241,0.080835,0.68494],[-0.34932,-0.36563,0.86272],[0.4601,0.8705,-0.17478],[-0.83159,-0.40173,-0.3835],[-0.43602,-0.78093,-0.44725],[-0.238,-0.84299,-0.48241],[-0.098491,-0.92566,-0.36531],[0.24062,-0.89604,-0.37311],[0.85665,0.1663,-0.48835],[-0.91162,-0.20213,-0.35791],[0.72183,-0.54902,-0.42134],[-0.50839,0.8039,0.30867],[-0.56716,-0.64262,-0.51514],[0.4459,-0.82634,-0.34399],[0.54506,-0.74084,-0.3925],[-0.52805,0.82885,-0.18486],[0.81993,0.12995,-0.55752],[0.59047,-0.28348,-0.75563],[0.69741,-0.15115,0.70055],[0.64861,-0.32291,-0.68923],[0.94087,0.24536,-0.23359],[-0.79343,-0.047937,0.60676],[-0.92387,0.074875,0.37531],[-0.70132,0.19863,0.68461],[0.7684,-0.44701,-0.45798],[-0.54507,0.79647,-0.26179],[0.72485,-0.68182,-0.09855],[0.61537,-0.51926,-0.59303],[0.36353,-0.48969,-0.79249],[0.038838,-0.71422,-0.69885],[0.099128,-0.48357,-0.86968],[0.79045,-0.22494,0.56973],[-0.95553,-0.060765,-0.28856],[-0.89542,0.28778,0.33972],[0.19037,-0.085646,-0.97797],[0.45425,0.13825,-0.88008],[0.90369,-0.37268,-0.21082],[-0.8691,-0.19734,-0.45357],[0.21131,0.6246,-0.75181],[0.71928,0.12659,0.68309],[-0.73155,-0.16975,0.66032],[0.91351,-0.20407,-0.35192],[-0.90937,-0.090053,-0.40613],[0.2304,0.2367,0.94387],[0.28957,0.70576,-0.64657],[-0.87694,-0.32306,-0.35581],[-0.77932,0.021311,0.62626],[0.8614,0.25279,-0.44056],[0.62985,0.099183,0.77036],[0.1325,0.75044,-0.64752],[-0.86062,0.18518,-0.47438],[0.091235,0.77378,-0.62685],[-0.48008,0.69424,-0.53624],[0.97165,-0.088816,-0.21912],[-0.45617,-0.12398,0.88121],[0.393,0.55976,-0.72953],[0.87784,0.27514,-0.39203],[0.1695,0.75691,-0.63116],[-0.92006,-0.33578,-0.20187],[0.44481,0.78801,0.42566],[0.75206,0.45868,-0.47331],[0.99793,0.026525,-0.058602],[-0.90784,0.10235,0.40663],[-0.086262,0.36083,0.92863],[-0.72091,0.24346,0.64886],[0.088527,0.90991,0.40526],[0.34383,0.73076,-0.58972],[-0.44656,0.75369,-0.48221],[-0.85974,0.20788,-0.4665],[0.49395,0.69475,-0.52281],[0.97527,0.1727,0.13794],[-0.92026,0.27624,0.27716],[0.32382,0.79809,-0.50812],[0.13907,0.93702,0.32041],[0.31823,0.69123,-0.64879],[0.44634,0.80626,-0.38823],[0.014615,0.8846,-0.46612],[0.93466,0.34192,0.097533],[0.68603,0.7263,-0.042988],[0.46646,0.80699,0.36219],[-0.56511,0.76753,-0.30257],[-0.20364,0.079036,0.97585],[-0.26509,-0.95476,-0.13472],[-0.97751,-0.041401,-0.2068],[-0.74769,0.57372,0.33437],[0.6617,0.73118,0.16595],[0.50126,0.83363,0.23194],[-0.19806,0.9535,-0.22717],[0.76859,0.29268,0.56886],[0.56577,0.70083,0.43444],[-0.78944,-0.43915,-0.42888],[-0.46582,0.78003,0.41782],[0.58821,0.62695,0.51083],[-0.86993,-0.35803,-0.33917],[0.78446,0.53107,-0.32028],[-0.51311,0.6315,0.58132],[-0.72214,-0.68418,-0.10204],[0.24771,0.19916,0.94814],[0.76801,0.61211,0.18833],[-0.17816,-0.96868,-0.17298],[-0.044211,-0.99902,0.0033548],[-0.69472,0.25491,0.6726],[0.3958,0.45856,0.79566],[-0.98107,0.14786,-0.12507],[-0.41208,0.66882,0.61876],[-0.30659,0.77993,0.54564],[0.072353,-0.98758,0.1395],[-0.69631,0.65113,-0.30196],[0.07713,0.73537,0.67326],[-0.074357,0.61696,0.78348],[0.15631,0.523,0.83788],[0.77381,0.44198,0.45374],[-0.98371,-0.05734,-0.17035],[-0.76565,-0.64063,-0.057983],[0.88823,-0.45749,0.041738],[0.81294,0.01696,-0.5821],[-0.89682,-0.21894,-0.38443],[0.71069,0.65814,-0.24854],[-0.77263,-0.36812,-0.51724],[0.85275,0.48829,-0.18544],[0.67927,0.58474,0.44348],[0.81402,0.57186,-0.10177],[0.64502,-0.76364,0.028431],[-0.048421,-0.99867,0.017451],[0.76768,0.6298,-0.11839],[-0.64551,0.738,-0.19666],[0.14975,0.95048,-0.27234],[-0.77632,0.11495,0.61977],[-0.82127,-0.25713,-0.50932],[0.66066,0.72474,-0.19568],[0.99315,0.047977,0.10658],[-0.95469,-0.231,-0.18763],[0.79219,0.6017,-0.10195],[-0.986,-0.1412,-0.0887],[-0.52855,0.83256,0.16579],[0.64079,0.47038,-0.60674],[0.59642,0.42679,-0.6798],[-0.65666,0.70689,-0.26287],[0.70253,0.35444,-0.61711],[-0.94241,-0.039524,0.33211],[-0.973,0.082132,-0.21572],[-0.9843,-0.079161,-0.15778],[0.60329,0.29295,0.74176],[0.87121,0.4795,-0.10524],[0.098025,-0.10052,0.99009],[-0.62595,0.75855,-0.18107],[-0.62295,0.42634,0.65587],[-0.94733,0.26543,-0.1792],[-0.070162,0.87944,0.47082],[0.40909,-0.40467,-0.81785],[-0.41238,-0.66486,-0.62282],[-0.25508,-0.7035,-0.66334],[0.73832,0.35463,0.57369],[-0.97405,-0.21901,-0.057086],[0.53545,-0.78881,-0.30177],[-0.77858,0.21244,0.5905],[-0.98033,0.072687,0.18347],[0.81927,0.22797,-0.52613],[-0.85039,0.45466,0.2648],[-0.92177,0.3871,-0.022112],[0.79264,0.52094,-0.31677],[0.62399,0.74819,-0.22551],[-0.63644,0.68944,0.34585],[-0.9959,0.067038,0.060673],[-0.62248,0.42157,0.65939],[-0.2988,-0.90747,-0.29533],[-0.022737,-0.99886,-0.04198],[0.10082,-0.98859,-0.11194],[-0.39121,-0.21166,0.89563],[0.2724,-0.87372,-0.40301],[0.87235,-0.074428,0.48319],[-0.37749,-0.63304,-0.67584],[-0.61204,-0.78894,-0.054615],[0.60259,-0.45171,-0.65791],[0.96956,-0.15957,-0.18572],[0.6166,-0.23162,-0.75243],[-0.70809,-0.3159,-0.63152],[-0.043009,-0.99844,-0.035603],[-0.8425,-0.10052,-0.52924],[-0.7756,0.55214,0.30593],[0.31224,-0.69,-0.65299],[-0.29418,-0.83722,-0.461],[0.73495,0.67218,-0.089563],[-0.76111,-0.13398,-0.63463],[0.82668,-0.42022,-0.37418],[0.99253,-0.068283,-0.1011],[0.67106,0.59883,0.43713],[-0.6507,0.74669,-0.13799],[0.31467,-0.70876,-0.63138],[0.97533,0.20254,-0.087754],[-0.4309,-0.77565,-0.46119],[0.64993,-0.32449,-0.68724],[-0.17693,-0.96596,-0.18873],[-0.40099,-0.53523,-0.74346],[0.58944,0.78597,-0.18659],[-0.36832,-0.74378,-0.55779],[0.29441,0.13823,0.94563],[-0.51415,0.60297,0.60998],[0.85818,0.31903,-0.40218],[-0.71999,-0.6244,-0.30288],[-0.53874,-0.61983,-0.57059],[0.56598,0.81083,-0.14911],[0.47936,-0.50869,0.71516],[0.94582,0.022546,0.3239],[-0.68555,-0.19573,0.70122],[0.61319,-0.6671,-0.42304],[-0.97876,-0.15325,0.13619],[-0.99705,0.02642,0.072104],[-0.7473,-0.58594,-0.3134],[0.035806,-0.99171,-0.12344],[0.3926,-0.78874,-0.47303],[0.37369,-0.82796,-0.41813],[0.41369,0.8537,-0.31631],[0.8629,0.21093,-0.45925],[0.92348,-0.37065,0.09905],[0.1964,0.98018,-0.026061],[0.36808,0.35205,0.86057],[-0.72245,0.26581,0.63829],[0.77759,-0.55654,0.2926],[-0.98859,0.14308,0.047065],[0.7795,0.62471,0.045912],[-0.87071,-0.46369,-0.16389],[0.45331,0.81453,0.36201],[-0.73562,-0.5063,-0.45001],[0.84077,-0.24945,0.4805],[0.5914,-0.40973,-0.69452],[-0.33394,0.1308,0.93348],[0.23919,0.72374,-0.64729],[-0.79141,-0.5558,-0.25447],[0.38786,-0.75039,0.53524],[-0.45477,0.09847,0.88515],[-0.75961,-0.26772,-0.59272],[0.35738,0.64302,-0.67735],[-0.90466,-0.42605,-0.0088184],[0.44938,-0.82764,0.33628],[0.21407,0.97635,-0.030134],[0.63525,-0.4208,-0.64761],[0.43355,0.89776,-0.077865],[-0.94196,-0.29164,0.16634],[0.78812,-0.58296,0.19755],[-0.811,-0.014232,-0.58487],[0.68532,-0.31646,-0.65589],[-0.73864,-0.52392,0.42416],[0.9535,-0.23611,0.1873],[0.9887,-0.071123,-0.13199],[-0.65296,0.72248,-0.22729],[0.9862,-0.12754,0.10554],[-0.8744,0.013809,-0.485],[0.352,-0.19688,0.91506],[0.71043,-0.24334,-0.66036],[0.43629,0.89529,-0.090077],[-0.67462,-0.55375,0.48811],[0.79049,0.57709,-0.20517],[-0.61628,0.7749,-0.1405],[-0.81651,0.00034982,-0.57733],[0.71784,-0.24564,-0.65143],[0.99195,0.12245,-0.032364],[0.038039,-0.99899,0.023813],[0.71956,-0.22175,-0.65807],[0.47513,-0.02193,0.87964],[0.39869,0.10104,0.9115],[-0.93244,-0.097889,0.34781],[-0.57358,0.77127,-0.27595],[0.63163,0.75694,-0.1676],[-0.99689,-0.046104,0.063988],[-0.89339,0.27269,-0.35705],[0.82596,-0.055561,-0.56098],[-0.70784,0.39614,-0.58484],[0.46293,0.085521,0.88226],[-0.037849,-0.99919,-0.013676],[-0.98241,0.055843,0.17818],[0.53965,0.45085,-0.71099],[0.31626,0.83291,-0.45413],[0.55097,0.19199,-0.81214],[0.63933,-0.14433,0.75527],[-0.61298,-0.052737,-0.78833],[-0.78757,0.54647,0.28479],[0.74207,-0.018947,-0.67005],[-0.52698,0.70238,0.47848],[0.42292,0.12961,0.89685],[0.39832,-0.46795,-0.7889],[0.46573,-0.52235,-0.71431],[0.63614,0.28229,0.71808],[-0.47893,0.087446,0.87349],[0.79431,0.12078,-0.59539],[0.89034,0.43621,-0.13048],[0.4903,-0.55415,-0.6727],[-0.81608,-0.22113,0.53396],[-0.43676,0.89842,-0.045654],[-0.083406,0.99617,0.026183],[-0.01076,-0.88239,-0.47039],[0.94214,0.24254,0.2314],[0.11169,-0.83942,-0.53188],[-0.77302,0.47574,-0.41967],[0.78827,-0.61194,-0.064428],[-0.072021,0.99179,-0.10563],[0.5492,-0.26816,-0.7915],[-0.91114,-0.40737,0.062176],[-0.42463,-0.66925,-0.60975],[0.41499,-0.83025,-0.37211],[-0.93691,0.13674,0.3217],[0.82301,0.089248,0.56098],[-0.37173,0.80534,0.46179],[0.91951,0.019958,0.39255],[0.6698,-0.16507,-0.72397],[0.53224,-0.20902,0.82038],[0.66956,-0.73266,-0.12202],[-0.748,0.62387,0.22644],[0.76715,-0.64132,0.013814],[-0.81478,0.00060489,0.57977],[-0.83643,-0.02257,0.54761],[0.34356,-0.62465,-0.70127],[0.12551,-0.84154,-0.52541],[0.79374,0.57794,-0.18963],[-0.56554,0.28234,0.77489],[-0.93085,0.025264,-0.36452],[0.4734,0.19946,0.85796],[0.31612,-0.80259,-0.50588],[0.39433,-0.62876,-0.6702],[0.60522,-0.38123,-0.69883],[0.86665,-0.23293,-0.4412],[-0.89283,-0.40518,0.19668],[-0.93861,0.032505,-0.34344],[0.36657,0.28134,0.88683],[0.90703,-0.30938,-0.28563],[-0.89311,0.20873,0.39848],[0.45667,0.58647,-0.66895],[-0.66142,0.70693,0.25054],[0.71943,0.25043,-0.64785],[-0.89527,-0.083317,-0.43766],[-0.20347,0.72516,-0.65783],[0.68397,0.46708,-0.56038],[-0.60642,0.78084,-0.15015],[-0.70126,0.68944,-0.18139],[0.24419,0.84655,-0.47299],[0.51923,0.82606,0.21914],[-0.71055,-0.69907,-0.080141],[0.50755,0.854,-0.11433],[0.23534,0.79891,-0.5535],[0.99793,-0.036905,-0.052655],[-0.85181,-0.43169,-0.29677],[0.40524,0.81703,0.41016],[-0.65551,0.37731,0.65418],[-0.52657,-0.16636,0.83369],[0.3381,0.9398,-0.049657],[-0.84203,-0.21307,-0.49556],[-0.93219,-0.14196,-0.33297],[0.49344,0.014894,0.86965],[0.22434,0.77109,-0.5959],[0.27229,0.35131,0.89579],[-0.528,0.82238,0.21192],[0.35393,0.93247,-0.072342],[0.40462,0.10287,0.90868],[-0.94863,0.0010754,-0.31638],[0.21127,0.82084,-0.53064],[-0.84408,0.3916,-0.36631],[-0.44035,0.88909,-0.12498],[-0.52947,0.82358,-0.20341],[0.28853,0.589,0.75487],[0.21728,0.89558,-0.38824],[-0.80794,-0.35591,-0.46964],[0.90895,-0.41646,0.019348],[0.87123,0.47405,-0.12738],[-0.7038,0.040491,0.70924],[0.5092,0.82252,-0.25333],[-0.33738,0.93457,-0.11297],[0.11235,0.95115,-0.28757],[0.31127,0.89109,-0.33027],[-0.40496,-0.024523,0.914],[0.88895,0.44,0.12713],[0.28785,0.95718,-0.030667],[0.43872,0.88901,-0.13106],[-0.51336,0.45524,-0.72747],[-0.45047,0.79398,0.40825],[0.47255,0.88121,0.012523],[-0.37304,0.74096,0.55841],[0.33666,0.89545,0.29126],[0.58765,0.8068,0.061211],[0.81216,0.56942,0.1271],[0.74332,0.079859,0.66415],[-0.66551,0.74638,-0.0011544],[0.26461,0.60433,0.75151],[0.48672,0.4822,0.72841],[0.86319,-0.41879,0.28198],[0.99041,0.098533,0.096822],[-0.93265,0.14917,-0.32849],[-0.41019,0.42922,-0.80469],[0.16421,0.70109,0.69391],[-0.33639,0.50195,-0.7968],[0.92545,0.3661,-0.097497],[0.070419,0.80711,0.58619],[-0.11924,0.69577,0.7083],[0.94787,-0.070258,-0.31081],[0.95345,-0.13124,-0.27149],[0.88005,0.38129,-0.28309],[-0.67039,-0.46163,-0.58093],[-0.25622,0.96228,-0.091516],[-0.69809,-0.078182,0.71173],[0.68386,0.4748,0.55399],[-0.68831,-0.43482,-0.58066],[-0.65705,-0.50864,-0.55639],[-0.79947,-0.30632,-0.51674],[0.73458,0.076843,0.67416],[-0.90556,-0.13711,-0.40144],[0.51514,0.85085,-0.10338],[0.68289,0.7262,0.079339],[-0.89949,0.0013607,-0.43695],[0.49016,0.84229,0.22425],[0.16898,0.98339,-0.06633],[0.588,0.75527,0.28952],[-0.29841,0.95414,-0.023669],[0.94008,0.26229,-0.21784],[-0.98427,-0.16327,0.067433],[-0.99968,0.020685,-0.014429],[0.76435,0.49036,-0.4187],[0.71168,0.48312,-0.51001],[-0.97406,0.14197,0.1762],[-0.35877,0.92965,-0.083927],[0.75722,0.65179,0.042336],[0.58722,0.79356,0.15949],[0.92791,0.36386,0.081177],[-0.19158,0.84979,0.49107],[0.18596,0.98059,-0.062223],[0.23937,0.90109,0.36157],[0.45119,0.84578,0.28475],[0.24846,0.90497,-0.3454],[-0.19606,-0.97329,0.11947],[0.023352,-0.72004,-0.69354],[0.13034,-0.98809,0.081786],[-0.64979,-0.59665,-0.47093],[-0.046669,0.96097,-0.2727],[-0.016366,-0.55085,0.83444],[-0.93343,-0.3393,-0.11653],[0.7284,-0.39032,0.5631],[-0.98924,0.058279,0.13422],[-0.94406,0.067803,0.32272],[-0.55507,0.0065381,0.83178],[0.85159,0.39791,-0.34125],[0.034329,0.98838,-0.14807],[-0.89158,0.33472,0.30505],[-0.16736,0.97278,-0.16026],[0.36836,0.92017,-0.13268],[-0.33978,0.85723,0.38693],[0.27617,0.95867,0.068369],[0.36988,0.91486,0.1619],[-0.10421,-0.4386,-0.89262],[0.39048,0.89031,-0.23423],[-0.95238,-0.30137,-0.046407],[-0.1914,-0.39356,-0.89915],[0.23932,0.3113,-0.91968],[-0.28357,-0.48108,-0.82955],[0.046209,-0.0047043,-0.99892],[0.97149,0.10068,0.21466],[0.94695,-0.31895,0.039502],[0.86849,0.38039,0.31785],[-0.46372,0.040405,-0.88506],[0.070211,0.42295,-0.90343],[0.22587,0.4825,-0.84627],[-0.043989,0.56692,-0.8226],[-0.94708,0.2927,0.13176],[-0.29065,-0.95425,0.070247],[-0.091989,-0.96227,0.25607],[0.073652,-0.97387,0.21482],[-0.99266,0.058713,0.1057],[0.91745,0.39334,0.059762],[0.12407,-0.97641,0.17673],[-0.41805,-0.87857,-0.23096],[0.29021,-0.94692,-0.1383],[0.46475,-0.7037,-0.53742],[0.40317,0.89446,-0.1934],[-0.53661,-0.60326,-0.59002],[0.79814,0.19107,0.57137],[-0.3184,0.94731,0.034943],[0.5544,-0.41704,-0.72022],[-0.63706,-0.40815,-0.65389],[-0.15759,0.57885,-0.80006],[0.47572,-0.32624,-0.81686],[-0.033722,0.99888,-0.033164],[-0.6205,-0.16741,-0.76613],[0.12295,0.99238,0.0086154],[0.096132,0.84545,-0.52533],[0.50932,-0.56925,-0.64541],[0.1,0.98665,-0.12855],[-0.20333,0.60084,0.77307],[0.89295,0.19819,0.40419],[-0.34707,-0.83717,-0.42271],[-0.18358,-0.94321,-0.27688],[0.093425,-0.88635,-0.4535],[-0.29584,0.93037,0.21654],[-0.084579,-0.89072,-0.44661],[0.20127,-0.74752,-0.63301],[-0.40997,0.88898,-0.20405],[-0.40714,-0.27924,-0.86963],[0.43231,-0.60549,-0.6682],[-0.28308,-0.56358,-0.77605],[-0.18643,0.97864,-0.086621],[-0.84833,0.36504,-0.38352],[-0.31089,-0.72762,-0.61149],[0.69739,0.17578,0.6948],[0.79663,-0.022265,-0.60406],[0.99238,0.039708,-0.11664],[-0.64299,0.34794,0.68227],[-0.46422,-0.68482,-0.56172],[0.74117,0.66152,0.11428],[-0.051505,0.99299,-0.10641],[0.84136,0.4025,-0.36071],[-0.94606,-0.29086,-0.14273],[0.77647,0.52745,-0.34479],[-0.65463,-0.59937,-0.46066],[0.40795,0.15688,0.89942],[0.82817,0.48194,-0.28612],[-0.98262,-0.10292,-0.1545],[0.82895,-0.44219,-0.3425],[-0.091428,0.65844,0.74706],[0.5122,-0.64318,-0.56918],[-0.7482,-0.54992,-0.37119],[0.76509,-0.30986,-0.56446],[-0.62733,0.70887,-0.32243],[0.23526,0.24293,0.94108],[0.88019,0.32457,-0.3463],[0.74349,-0.66744,-0.041866],[-0.55842,-0.62176,-0.54916],[0.7221,0.41849,0.55084],[-0.87509,-0.29737,-0.38181],[-0.74393,-0.16282,0.64812],[0.93596,-0.24891,0.24904],[-0.60637,0.62976,0.48551],[0.80022,0.1172,0.58814],[0.64711,-0.44528,-0.61885],[0.90703,0.0098313,0.42095],[-0.58295,-0.65354,-0.48276],[0.61363,-0.50687,-0.60543],[0.067733,0.99014,-0.12261],[0.70089,-0.32939,0.63266],[-0.69781,-0.15981,0.69823],[-0.78972,-0.44974,-0.41723],[-0.74283,0.49414,0.45169],[-0.46643,0.81204,0.35076],[-0.86692,-0.39936,-0.29827],[-0.97581,-0.19443,-0.1],[0.3213,-0.77634,0.54227],[0.25918,-0.81014,0.52583],[0.46473,-0.73095,0.49974],[-0.95551,-0.11091,-0.2733],[0.8932,0.37292,0.25125],[-0.47198,0.77218,0.42541],[0.066681,-0.98351,0.16811],[0.49206,-0.72908,-0.47573],[0.53844,-0.59866,-0.59302],[0.51779,-0.66528,-0.53786],[-0.33602,0.39242,0.85621],[0.7443,-0.23414,-0.62546],[0.61109,-0.45978,-0.64434],[-0.69964,-0.49752,0.51282],[-0.91796,0.014409,-0.39641],[0.54668,0.055069,0.83553],[-0.49019,0.1703,0.85481],[-0.78628,-0.18938,-0.58813],[-0.23088,-0.96079,0.15355],[0.68253,-0.25316,-0.68561],[-0.46715,0.4288,0.77324],[-0.87041,-0.032939,-0.49122],[-0.70143,-0.10514,-0.70494],[-0.26372,-0.94771,0.17971],[-0.97675,-0.19795,0.082253],[-0.72418,0.19888,-0.66031],[0.76209,-0.31894,-0.56347],[-0.97486,0.13634,-0.17623],[0.70888,0.56473,0.42258],[0.30445,0.14995,0.94065],[-0.7986,0.11049,-0.59163],[-0.024617,-0.9947,0.099861],[-0.68596,0.67269,-0.27739],[-0.94788,0.060532,-0.31282],[0.81586,-0.10377,-0.56886],[-0.26788,0.3084,0.91276],[0.80503,0.57289,-0.15402],[0.019115,-0.99704,0.074478],[0.2563,-0.96472,-0.060213],[0.86856,-0.051496,-0.4929],[-0.60619,0.50181,-0.61702],[-0.77143,0.54736,0.32448],[0.68663,0.6407,-0.34358],[-0.001638,0.28521,0.95847],[-0.92108,0.058219,-0.385],[0.3437,-0.93535,-0.083574],[-0.70741,-0.032053,-0.70607],[0.6966,0.18351,0.6936],[0.82401,-0.054375,-0.56397],[0.67749,0.26049,-0.68786],[0.72511,0.34009,-0.59879],[-0.9708,0.13906,-0.1955],[0.62281,0.12675,-0.77203],[-0.64464,0.053216,-0.76263],[-0.97083,0.17016,0.16894],[-0.53643,0.064931,0.84145],[-0.093249,-0.9913,0.092933],[0.50611,-0.42348,-0.75134],[0.83459,0.18075,-0.52038],[0.77364,-0.10514,-0.62484],[0.9401,0.064753,0.33469],[-0.27715,-0.95952,-0.050017],[-0.0018293,-0.99998,0.0053274],[0.079372,0.36817,0.92637],[-0.17865,-0.79185,-0.584],[-0.11624,-0.87066,-0.47795],[0.38861,-0.79401,-0.46748],[0.035007,-0.99884,0.033056],[-0.81665,-0.28394,-0.50245],[0.71669,-0.27882,-0.63923],[0.19369,-0.97229,0.13094],[0.51454,-0.84281,-0.15787],[-0.89544,-0.22958,-0.38143],[0.79516,-0.16576,-0.58331],[-0.68842,-0.48568,-0.5387],[-0.67114,0.5385,0.5095],[0.97908,-0.096272,-0.17927],[0.85802,-0.10388,-0.503],[0.71867,-0.68817,-0.09963],[-0.63644,0.01063,0.77125],[-0.17524,-0.97854,0.10843],[0.15656,-0.72122,-0.67478],[0.34806,-0.7813,-0.51809],[0.16966,-0.92674,-0.33522],[-0.54226,0.0072148,0.84018],[-0.94202,-0.12157,-0.31277],[0.53475,0.15051,0.8315],[0.98666,-0.1316,0.095829],[0.8924,0.0063538,-0.4512],[0.11434,0.39186,0.91289],[0.74376,-0.62489,-0.23733],[-0.86521,0.28022,0.4158],[-0.4201,-0.68871,-0.59093],[0.52537,0.60848,-0.59476],[-0.61836,0.0466,0.78451],[0.92468,-0.26355,-0.27478],[-0.8548,0.20257,0.47779],[-0.10085,-0.99487,-0.0081489],[0.35459,0.81055,-0.46612],[0.87504,-0.25631,-0.41061],[0.045884,-0.99856,-0.02797],[-0.97444,-0.22404,0.016178],[0.15662,-0.97959,-0.12601],[0.95851,-0.23889,0.15557],[0.37832,0.54903,-0.74528],[0.34905,-0.8986,-0.26586],[0.13683,0.6943,-0.70656],[0.40642,-0.69066,-0.59817],[-0.021356,0.74651,-0.66503],[-0.46736,0.70968,-0.52719],[-0.6061,0.18104,0.77451],[0.92058,0.29216,-0.25919],[-0.94904,-0.25328,-0.18755],[-0.88364,0.46365,0.064865],[0.96087,-0.14176,-0.23796],[0.3684,0.56432,-0.7388],[-0.31368,-0.77624,-0.54686],[-0.33036,0.70723,-0.62505],[-0.77556,0.18605,0.60324],[0.93587,0.022138,0.35165],[0.1087,0.72326,-0.68197],[-0.22933,-0.90636,-0.35486],[0.087565,-0.87121,-0.48304],[0.87002,-0.49213,0.029369],[0.96857,0.20442,-0.14169],[-0.35562,-0.73449,-0.57798],[0.19586,-0.85892,-0.47319],[0.83446,-0.47394,0.28117],[-0.87149,0.33169,-0.36124],[0.23139,0.68573,-0.69009],[-0.42021,0.72542,-0.54516],[-0.075063,-0.99246,-0.096918],[-0.45828,-0.57422,-0.67842],[0.46519,0.81196,-0.35258],[-0.77231,0.27532,0.57248],[0.40141,0.76255,-0.50733],[0.31492,0.75684,-0.57272],[0.06406,-0.98943,0.13009],[0.74412,0.64053,-0.18975],[0.23539,0.71041,-0.66326],[-0.24669,0.87038,-0.42613],[-0.089845,0.91465,-0.39414],[-0.66075,-0.16614,0.73199],[0.87192,0.45966,-0.16874],[0.41269,0.88099,-0.23139],[0.982,0.053696,0.18108],[0.30321,0.71065,-0.63485],[0.54654,0.3245,0.772],[-0.40338,0.86311,-0.30387],[-0.98227,-0.18615,-0.022167],[-0.63945,-0.073923,0.76527],[-0.034771,0.95514,-0.29412],[-0.92122,0.34716,0.17557],[0.63329,-0.54475,0.54971],[0.20262,0.83059,-0.51872],[0.71769,-0.26439,0.64422],[-0.85118,-0.31409,-0.42052],[-0.7554,-0.63389,-0.16596],[-0.29447,-0.54466,-0.78526],[-0.30914,-0.5815,-0.75252],[0.18629,0.8265,-0.53122],[0.30724,-0.62109,-0.72101],[-0.38342,0.64264,0.66333],[0.55582,0.44624,0.70138],[-0.90876,0.41731,-0.00070224],[0.29138,0.76133,0.57919],[0.78206,-0.24482,0.57311],[0.045784,-0.43472,-0.8994],[0.24114,0.86643,0.43722],[0.29396,0.95051,-0.10059],[-0.9515,-0.18116,-0.24865],[0.8365,0.53748,-0.10671],[-0.096819,-0.97733,-0.18826],[0.98262,-0.063404,-0.17449],[0.18713,0.34017,0.92156],[-0.91444,-0.21038,-0.34576],[0.97275,0.22597,0.051854],[0.49251,-0.61997,-0.61079],[0.86051,0.50927,0.01263],[-0.090683,-0.97088,-0.22174],[0.79461,0.14068,0.59059],[0.72339,-0.18129,0.66622],[0.85385,0.51717,-0.058943],[-0.016105,-0.99106,-0.13247],[0.72781,0.68573,0.0081516],[-0.96466,0.12381,-0.2326],[0.54602,0.83704,0.034917],[0.79549,0.59557,0.11174],[-0.97703,0.040516,-0.2092],[0.9593,0.2694,-0.08468],[-0.97729,0.16729,0.13008],[0.94905,0.24506,-0.19814],[-0.98271,0.0046722,0.18509],[0.95001,0.28222,-0.13352],[0.19906,-0.97989,0.014169],[-0.079282,-0.99539,-0.054056],[-0.57585,0.48218,0.66022],[0.72614,0.077498,0.68316],[-0.95892,-0.21091,-0.18972],[-0.97461,0.15769,0.15898],[0.089054,0.031097,0.99554],[0.72638,0.59007,-0.3524],[-0.96953,0.23466,0.070381],[0.71632,0.65067,-0.252],[0.17976,-0.98122,0.069903],[0.24964,-0.94769,0.1989],[-0.0114,-0.99962,0.025012],[0.65143,-0.582,0.48674],[0.076584,-0.6593,-0.74797],[-0.2853,-0.69795,-0.65686],[-0.21726,0.94834,-0.23119],[-0.56682,-0.63066,-0.53008],[-0.79167,-0.5085,-0.33866],[-0.92751,-0.33762,-0.16042],[-0.43638,-0.032668,0.89917],[0.80093,-0.09128,-0.59176],[0.042612,-0.46604,-0.88374],[-0.73234,-0.033414,0.68012],[-0.95188,0.083078,0.295],[0.8752,0.33217,-0.35168],[0.13351,-0.97347,0.18585],[-0.9148,0.2924,0.27863],[-0.42741,0.76059,0.4887],[-0.99457,-0.022749,0.10151],[-0.72477,0.56215,0.39837],[0.51536,0.84953,0.11271],[-0.28681,-0.35058,-0.89153],[0.91569,-0.40119,0.023722],[0.15745,0.06443,-0.98542],[-0.058777,0.91072,0.40882],[-0.42122,-0.39075,-0.81847],[-0.75378,0.14099,0.64182],[0.81302,-0.10911,0.57192],[0.18431,0.089459,-0.97879],[-0.75634,0.63167,0.17013],[-0.92142,0.30113,0.24557],[-0.51359,-0.53575,-0.67023],[-0.97598,0.15451,0.15356],[0.92432,-0.33686,0.1793],[-0.53825,-0.51125,-0.67],[-0.36095,0.83608,0.41314],[0.72187,0.59745,-0.34923],[-0.63827,-0.7257,-0.25687],[-0.051661,-0.15299,-0.98688],[0.27072,0.19683,-0.94232],[0.96705,0.15373,0.20292],[-0.25233,-0.41669,-0.87333],[-0.56486,-0.75852,-0.32494],[0.58471,-0.60585,-0.5395],[-0.10292,-0.99157,0.078737],[0.27167,0.20958,-0.93929],[0.21949,0.14842,-0.96426],[0.74798,0.02714,0.66317],[-0.50023,-0.73399,-0.45938],[-0.97407,-0.19414,0.11621],[-0.15327,-0.28891,-0.94501],[0.95613,-0.28247,-0.077686],[-0.39518,-0.843,-0.36494],[0.33364,0.32138,-0.88623],[-0.32689,-0.83523,-0.4422],[-0.5462,-0.46748,-0.69507],[0.27032,0.35531,-0.89481],[-0.53567,0.53564,0.6528],[0.50707,0.13658,0.85102],[-0.44263,-0.66373,-0.60294],[0.4466,0.13488,0.88451],[0.47107,0.57148,0.67194],[0.25461,0.6002,-0.75824],[0.50261,-0.83796,-0.21263],[-0.63953,0.20977,-0.73959],[0.94508,-0.32504,-0.034171],[-0.1373,0.80785,-0.57318],[-0.96938,0.19657,0.14718],[0.10922,0.75252,-0.64945],[0.18268,0.70899,-0.68114],[-0.29472,0.85876,0.41912],[0.019317,-0.99331,0.11387],[-0.57343,-0.39162,-0.7196],[0.089046,-0.97735,0.19197],[-0.23953,-0.83687,0.49222],[-0.23931,-0.8695,0.43209],[0.076298,-0.95936,0.27168],[0.12587,-0.96618,0.22504],[0.41322,-0.9061,-0.090686],[-0.6498,-0.7326,-0.20265],[-0.39378,-0.89728,0.19955],[0.65513,-0.64212,-0.3981],[-0.74264,-0.43665,-0.50775],[0.70639,-0.17161,0.68671],[0.55394,-0.3671,-0.74725],[0.34027,0.02888,0.93989],[0.74454,-0.45055,-0.49262],[-0.7858,-0.3953,-0.47566],[-0.073624,-0.85102,-0.51995],[0.14377,-0.84984,-0.50706],[-0.48598,0.40431,0.77483],[0.85654,-0.23461,-0.45966],[-0.18608,-0.94349,-0.27425],[0.61342,0.68313,-0.39629],[0.01854,-0.88068,-0.47335],[0.43678,0.01601,0.89943],[0.34887,-0.78064,-0.51855],[-0.66026,0.047218,0.74955],[-0.55297,-0.28701,-0.78221],[0.77784,-0.55993,-0.2854],[-0.73445,-0.64328,-0.21627],[0.88556,0.048253,-0.46202],[-0.38483,-0.70927,-0.59063],[-0.97855,-0.13475,0.1558],[-0.28096,-0.82477,-0.49073],[-0.99994,0.0017999,0.010363],[0.77763,-0.26815,-0.56867],[0.93514,-0.34354,0.086513],[-0.77582,-0.42435,-0.46694],[0.90054,0.21398,-0.37848],[-0.89683,-0.37081,-0.24124],[-0.61271,-0.48901,-0.62085],[0.82868,-0.051744,-0.55733],[0.18243,-0.97209,0.14753],[0.69286,0.00058742,0.72107],[0.68172,-0.15081,0.71591],[0.9883,-0.14907,-0.03234],[-0.93299,-0.21978,-0.285],[0.88812,-0.33462,-0.31508],[0.35067,-0.86946,0.34795],[0.95548,-0.29283,0.036249],[0.4765,-0.75318,-0.45351],[-0.69434,-0.44307,-0.56708],[-0.92506,-0.24713,-0.28843],[0.6824,-0.71101,-0.16968],[-0.63392,-0.59457,-0.4946],[0.069251,-0.99459,0.077486],[0.92841,-0.35145,0.12055],[0.64055,-0.014368,0.76779],[0.84038,0.033684,-0.54094],[-0.76326,-0.11383,0.63599],[-0.014174,-0.99954,0.026947],[-0.60066,-0.57035,-0.56028],[0.66763,-0.50982,-0.54255],[-0.70409,-0.05376,0.70807],[-0.83441,-0.36589,-0.41218],[-0.9715,-0.0025306,0.23704],[-0.52925,0.17607,0.83],[0.81928,-0.07215,0.56884],[-0.10691,-0.98488,0.13634],[0.64035,-0.53813,-0.54806],[-0.33731,-0.92177,-0.19119],[-0.67771,0.6985,0.22978],[0.055424,-0.90373,0.42449],[0.55183,-0.59745,0.58184],[0.97347,-0.22685,0.029841],[-0.75158,-0.07233,0.65566],[-0.90066,-0.28488,-0.32811],[0.63406,-0.46425,-0.61842],[0.72563,-0.37356,-0.57785],[-0.97873,-0.11638,0.16897],[-0.99546,-0.094675,-0.010271],[-0.886,-0.26446,-0.38089],[0.73927,-0.51963,0.42832],[0.93595,-0.25574,0.24206],[-0.25975,0.25441,0.93156],[-0.56359,-0.68426,0.46277],[-0.73439,-0.57763,0.35639],[-0.93902,0.17558,0.29566],[-0.47423,-0.70477,0.52764],[0.98969,-0.1073,0.09486],[0.92093,-0.18527,0.34289],[0.42552,0.65435,0.6251],[-0.75982,0.14302,-0.63421],[0.53174,-0.79127,-0.30189],[0.42429,0.90412,-0.050485],[0.73015,-0.1993,-0.65358],[0.13461,0.23917,0.9616],[-0.87495,0.44947,-0.18012],[0.94214,0.33516,0.0059927],[-0.78113,0.20853,-0.58851],[-0.69417,0.35464,-0.62638],[0.72995,-0.43773,-0.52494],[-0.42793,-0.53581,-0.72786],[0.78241,-0.39189,-0.484],[0.81463,0.57349,-0.086588],[0.98336,-0.17526,-0.047799],[0.52603,-0.27374,0.8052],[0.68584,0.010429,0.72768],[-0.5734,0.27449,-0.77193],[-0.96184,-0.12856,0.24152],[0.79303,0.51234,-0.32956],[-0.72528,0.068545,-0.68503],[0.79791,-0.27635,0.53569],[0.7702,0.17782,-0.61251],[-0.728,0.23498,-0.64404],[0.82311,-0.025082,-0.56732],[-0.70214,-0.10387,-0.70442],[-0.92503,0.21125,-0.31573],[-0.96368,-0.20516,0.17094],[-0.66341,-0.012189,-0.74815],[-0.76635,-0.39551,-0.50623],[0.76334,-0.55478,-0.33095],[-0.93875,0.29735,-0.17416],[-0.6806,-0.028972,-0.73208],[0.71932,-0.46572,-0.51544],[0.35032,0.91549,-0.19786],[-0.17061,-0.84287,-0.51035],[-0.15194,0.20291,0.96734],[-0.031855,-0.80022,-0.59885],[0.83428,0.13337,-0.53497],[0.87115,0.092487,0.48224],[0.45954,0.86011,0.22144],[0.80286,-0.44907,-0.39211],[-0.46593,-0.4679,-0.75099],[0.93219,-0.19335,0.30602],[-0.16921,0.69566,0.69816],[0.62697,-0.71565,-0.30781],[-0.5242,-0.70826,0.47285],[0.7817,-0.073343,0.61933],[-0.64399,-0.43977,-0.626],[-0.32914,-0.92526,0.18857],[0.68969,0.54297,0.47908],[-0.976,0.19844,0.089668],[0.88271,-0.46721,-0.050287],[-0.17706,-0.98405,0.016935],[0.59995,-0.78443,-0.15727],[-0.38684,0.45801,0.80036],[0.65552,-0.030696,0.75456],[-0.45128,0.28311,0.84628],[-0.79371,-0.31477,-0.52053],[0.050578,-0.98513,0.16417],[0.69575,-0.71094,-0.10247],[-0.94719,0.064366,0.31414],[-0.94274,-0.107,-0.3159],[0.9493,0.075424,-0.30519],[0.2093,-0.90409,-0.37258],[0.37141,-0.77248,-0.5151],[-0.41785,0.22324,0.88066],[-0.82047,-0.34942,-0.45248],[0.040539,-0.99704,0.0653],[0.76462,-0.26353,-0.58815],[-0.93924,0.032584,-0.34172],[0.94024,0.0025897,-0.34051],[0.82417,-0.55807,-0.096387],[-0.83925,-0.1742,-0.51508],[-0.57771,0.61019,0.54214],[-0.17915,0.42231,0.88857],[0.51801,0.73427,-0.43876],[0.97683,-0.16282,-0.13891],[0.99898,-0.014134,-0.042841],[-0.9693,-0.18985,-0.15627],[-0.9024,-0.30381,-0.30558],[0.97118,-0.11855,0.20676],[0.34394,0.84273,-0.41415],[-0.87568,-0.38826,-0.28712],[0.99026,0.12328,-0.064732],[0.40083,0.51254,-0.75936],[0.49817,0.64797,-0.57616],[-0.89482,-0.26824,-0.35686],[-0.65409,-0.0034595,0.75641],[0.10083,0.66024,-0.74425],[0.0098386,0.63719,-0.77065],[-0.87064,-0.26786,-0.4126],[0.74484,0.59032,-0.31101],[-0.03373,-0.99632,0.078856],[0.63608,-0.053022,0.7698],[0.18034,0.79531,-0.57876],[0.45905,0.74018,-0.49133],[-0.94061,0.28318,0.18724],[0.16738,0.61723,-0.76877],[0.13583,0.34928,-0.92712],[0.10899,0.43432,-0.89414],[-0.3722,0.74347,-0.55562],[-0.96863,-0.10007,-0.22747],[0.97802,-0.10881,0.17786],[-0.81196,-0.27168,-0.51664],[0.79243,0.59385,0.13926],[0.91797,-0.39653,-0.0098757],[0.32275,0.81361,-0.48359],[-0.66061,0.66772,-0.34315],[0.15404,0.42459,-0.89219],[0.13717,0.074049,-0.98778],[-0.83304,-0.30977,-0.45835],[-0.20878,0.49016,0.84626],[0.097647,0.9367,-0.33624],[-0.20611,0.41746,0.88501],[-0.47548,0.63886,0.60479],[0.31149,0.65062,-0.69258],[-0.024877,-0.99399,0.1066],[-0.14814,0.93539,-0.32109],[0.036382,0.50421,-0.86281],[-0.070741,0.16518,-0.98372],[0.011352,-0.062662,-0.99797],[0.073058,-0.12079,-0.98999],[-0.90517,-0.20207,-0.37394],[0.09664,-0.18694,-0.97761],[-0.032694,-0.99694,0.070985],[0.16459,0.70131,0.6936],[-0.62156,-0.04441,0.78211],[0.79325,0.17728,0.58251],[0.88492,-0.46528,0.020681],[-0.018179,-0.99534,0.094678],[-0.44989,0.65246,0.60983],[0.24008,0.71076,-0.6612],[-0.060737,0.64559,-0.76127],[-0.12932,-0.022254,-0.99135],[0.068307,-0.1765,-0.98193],[-0.91437,-0.10443,-0.39118],[-0.90372,-0.16132,-0.39656],[0.51446,0.16417,0.84165],[0.088366,-0.21468,-0.97268],[-0.91262,-0.16888,-0.37231],[0.81793,0.52725,-0.2302],[-0.96709,0.12048,0.22412],[0.1555,0.83707,0.52453],[-0.70652,-0.04645,0.70617],[-0.0553,-0.99686,0.056605],[0.19775,0.96192,0.18871],[0.047128,0.99887,0.0065622],[0.07509,0.87953,-0.46988],[-0.29269,-0.027772,-0.9558],[-0.14719,0.025617,-0.98878],[0.02595,0.12333,-0.99203],[0.06842,0.088183,-0.99375],[0.057496,0.10988,-0.99228],[0.29024,-0.1524,0.94474],[0.80077,0.57417,-0.17058],[0.98718,-0.14156,0.07374],[-0.07761,0.8105,0.58058],[0.12537,0.73511,0.66625],[-0.38639,-0.09946,-0.91696],[0.094818,0.42509,-0.90017],[0.043052,0.40592,-0.91289],[0.90141,-0.19525,-0.38645],[0.69697,-0.095233,0.71075],[0.93165,0.23522,-0.27694],[0.69025,0.07308,0.71987],[-0.8907,-0.38252,-0.24563],[0.035456,0.39784,-0.91677],[0.23242,0.7404,0.63071],[0.95925,-0.12788,0.25196],[-0.151,0.30423,-0.94055],[0.9568,0.035796,0.28852],[-0.60364,-0.77378,-0.19207],[-0.95343,-0.12575,-0.27415],[-0.99866,0.011353,0.050578],[-0.44574,-0.39029,-0.8056],[-0.37918,0.2478,0.89152],[-0.51226,-0.16583,0.84267],[0.080647,0.95236,0.29414],[0.87973,0.23762,0.41185],[0.55394,-0.59785,-0.57942],[-0.80429,-0.17375,0.56827],[0.853,0.51824,0.061884],[-0.84228,-0.38138,-0.38094],[-0.24304,0.71319,0.65749],[-0.92562,-0.262,-0.27309],[0.72865,0.67741,0.10094],[0.50799,-0.31049,0.80346],[-0.99577,0.026489,-0.087998],[0.56308,0.82623,0.01698],[-0.6475,-0.28182,0.70804],[0.85381,0.4502,-0.26139],[0.8012,-0.23084,0.55208],[-0.98254,0.13623,-0.12672],[-0.9607,-0.1018,-0.25825],[0.63129,-0.68388,-0.36575],[-0.9023,0.081555,0.42333],[0.91381,0.40451,0.036376],[0.97644,-0.19436,-0.093719],[-0.49452,-0.14899,-0.8563],[0.62859,0.77618,-0.049218],[-0.68529,0.50912,0.52074],[-0.95823,0.23001,0.16996],[-0.61385,-0.67922,0.4023],[-0.77046,0.12874,0.62436],[-0.032247,0.91356,0.40543],[-0.74844,-0.017977,0.66296],[-0.49762,-0.14897,-0.85451],[0.30071,0.91455,0.27051],[0.97973,0.14957,0.13325],[0.92163,0.082118,0.37927],[-0.28567,-0.70242,-0.65192],[-0.14317,0.71937,0.67971],[-0.16697,-0.55073,-0.81781],[-0.36455,0.073675,0.92827],[-0.15137,0.70885,0.68893],[-0.030149,-0.51992,-0.85368],[0.16326,0.74767,0.64368],[0.033804,-0.2326,-0.97199],[-0.53636,-0.65002,-0.53832],[0.55119,0.021849,-0.8341],[-0.91556,0.039826,0.4002],[-0.90151,0.14493,0.40777],[0.067747,-0.98399,0.16485],[0.31674,0.10779,-0.94237],[0.18083,0.74235,0.64515],[0.31929,0.056935,0.94594],[0.79516,-0.14041,-0.58993],[-0.68836,-0.60809,-0.39546],[-0.72009,0.30519,0.62316],[-0.27617,-0.34221,-0.89812],[0.24077,0.15933,-0.95741],[-0.59424,-0.62945,0.50066],[0.47668,0.12908,-0.86955],[-0.99609,0.087485,0.011945],[0.93331,0.17085,0.31583],[-0.98636,0.092285,0.13631],[0.89115,0.16981,-0.42073],[-0.40267,-0.36672,-0.83867],[-0.72472,-0.63648,-0.26396],[0.18731,0.10861,-0.97628],[0.34756,0.13864,-0.92735],[-0.88091,0.27781,-0.38317],[-0.96115,0.1193,0.24893],[-0.32988,-0.33777,-0.88153],[-0.74651,-0.66253,-0.06142],[0.25323,0.13651,-0.95772],[0.14542,0.054329,-0.98788],[0.74347,0.66233,-0.092627],[-0.025446,0.90396,0.42685],[-0.51317,-0.44602,-0.73329],[-0.7726,-0.61872,-0.14241],[0.88504,-0.071316,-0.46001],[0.25511,0.1262,-0.95864],[-0.73509,-0.61858,-0.27747],[0.70444,-0.7096,0.015356],[0.27458,0.15012,-0.94977],[-0.78325,-0.61023,0.11894],[0.25617,0.17015,-0.95154],[-0.11892,-0.32102,0.93958],[-0.74097,-0.67152,-0.0047149],[0.94531,0.091391,0.31312],[-0.49123,0.079922,-0.86736],[0.35435,0.27205,-0.89467],[-0.98221,0.18312,-0.041633],[-0.71405,-0.69785,0.056023],[0.85487,0.44407,0.26833],[-0.98293,-0.15764,-0.09483],[-0.5191,0.077233,-0.85122],[0.9105,0.17956,0.37249],[0.83625,0.027619,0.54765],[-0.97777,-0.16164,-0.13356],[-0.35288,0.93514,-0.031347],[-0.56089,-0.82679,-0.042727],[0.95771,0.12894,0.25723],[-0.53092,-0.83107,-0.16569],[-0.30635,-0.8882,-0.34241],[0.89079,0.3344,0.30768],[-0.26701,-0.87279,-0.40858],[-0.66534,0.10482,0.73914],[-0.90444,0.3807,0.19249],[0.73283,0.20287,0.64946],[0.31558,0.46471,-0.82732],[-0.95914,0.13502,0.24865],[-0.79135,0.0081925,0.61131],[0.28171,0.86341,0.41853],[-0.78381,0.39006,-0.48321],[-0.70022,0.63875,0.31889],[0.92278,-0.2178,0.31788],[-0.38731,0.86807,-0.31054],[-0.061534,0.90877,-0.41273],[0.10833,0.83318,-0.54228],[-0.10228,0.70767,0.6991],[0.81594,0.21906,0.53503],[-0.25845,-0.8962,0.36059],[-0.076985,-0.96212,0.26153],[0.15137,-0.90742,0.39203],[-0.51666,-0.16441,0.84026],[0.97206,0.15894,0.17272],[0.22687,-0.91133,0.34354],[-0.33639,-0.73404,0.58994],[-0.46824,0.25137,-0.84709],[0.21619,0.60922,0.76296],[-0.29528,-0.77893,0.55324],[0.52567,-0.82923,0.18984],[-0.063017,0.96387,0.25882],[0.67658,-0.73637,-0.0023958],[-0.78956,-0.59195,0.1618],[-0.56276,0.11654,0.81836],[0.82315,-0.56337,-0.071042],[0.91729,0.045231,0.39565],[-0.22882,-0.89828,-0.37514],[0.91745,0.20966,0.33811],[-0.0029368,-0.83871,-0.54456],[-0.67176,-0.063035,0.73808],[-0.019017,-0.91325,-0.40696],[-0.84798,-0.51978,-0.10372],[-0.91445,0.341,-0.21794],[0.75775,0.14585,0.63604],[0.54373,-0.64166,-0.54095],[-0.19635,-0.14642,0.96954],[0.98406,0.12488,0.12663],[0.9172,0.055108,-0.39461],[0.74969,-0.032877,-0.66097],[0.99238,-0.042409,0.11571],[-0.58128,-0.61147,-0.53686],[0.9719,0.22326,0.074605],[0.86641,0.42308,-0.26521],[0.6072,-0.30073,-0.73544],[0.73697,0.13967,0.66134],[-0.93339,0.20514,0.29444],[-0.91593,0.27475,0.29253],[0.6015,-0.52657,-0.60077],[0.80906,-0.13023,-0.57311],[0.8139,0.49313,-0.30722],[-0.68214,-0.070304,0.72783],[-0.54036,-0.66669,-0.51335],[-0.96747,-0.023197,-0.25192],[0.8176,0.43321,-0.37928],[0.80453,-0.27384,0.52702],[0.78215,-0.5326,-0.32338],[-0.50589,-0.67638,-0.53534],[0.92519,-0.25461,-0.28143],[-0.98775,-0.11746,0.10269],[0.82277,0.28247,-0.49321],[-0.85475,-0.23941,-0.46052],[-0.0089535,0.93441,0.35608],[-0.62264,-0.56574,-0.54061],[0.63609,-0.11284,0.76332],[0.84206,-0.26898,-0.46753],[0.94684,0.24434,0.20926],[-0.77614,0.41255,0.47687],[0.94794,0.090623,0.30528],[0.7669,0.62554,-0.1434],[-0.75473,-0.46984,0.45785],[-0.64284,-0.073733,0.76244],[0.92684,0.33014,0.17881],[-0.8996,-0.24216,-0.36343],[0.98608,-0.079315,0.14611],[0.68814,-0.72432,-0.04269],[0.80793,-0.5624,0.17594],[-0.71759,-0.27428,0.64018],[0.86227,0.4318,0.26466],[0.5059,-0.75879,0.41026],[0.21981,-0.83033,0.51208],[-0.95419,-0.13127,-0.26887],[-0.64748,0.71381,-0.2669],[-0.96918,0.041258,-0.24288],[0.32647,-0.71724,0.61561],[0.94769,0.078423,0.30941],[0.63805,-0.34758,-0.68708],[0.42763,-0.60651,0.67028],[0.60202,-0.53657,0.59132],[-0.71095,-0.40192,0.57706],[-0.99628,-0.083412,-0.021649],[0.89814,0.35908,-0.25379],[-0.88441,-0.43764,0.16216],[0.97162,-0.16383,0.17062],[-0.82952,-0.26047,-0.49403],[-0.53252,-0.70608,0.46677],[0.78342,0.61338,0.1001],[-0.48157,0.27813,-0.8311],[-0.58474,-0.78619,0.19997],[-0.029856,0.72018,0.69314],[0.77863,-0.17693,-0.60202],[-0.92757,-0.13699,-0.34764],[0.99417,0.048242,0.096472],[-0.85249,0.19493,-0.48503],[0.89343,0.44325,0.072949],[0.80609,-0.09756,-0.58369],[-0.78482,0.10111,-0.61143],[0.90326,0.40661,-0.13704],[-0.75168,-0.0015964,-0.65952],[-0.76425,0.22471,0.6045],[-0.859,0.33784,0.38468],[-0.30798,0.87736,0.36795],[0.82858,-0.039728,-0.55846],[-0.84128,-0.24061,0.48411],[-0.52997,0.13953,-0.83646],[-0.78203,0.5844,-0.21657],[0.86229,0.40613,0.3025],[0.8992,0.28261,-0.33403],[-0.68034,0.15411,0.71651],[-0.5736,0.043172,-0.81799],[-0.8946,0.38572,-0.22564],[0.87519,0.077828,-0.47748],[-0.71206,0.52476,0.46647],[0.73363,-0.4937,0.46696],[-0.62248,0.0094788,-0.78258],[-0.98282,0.12841,-0.13261],[0.79068,0.57762,0.20294],[0.91164,0.40154,-0.087594],[-0.74165,0.014167,0.67064],[0.77037,-0.029066,-0.63693],[-0.75217,0.29233,-0.59057],[0.58735,0.20611,0.78265],[-0.1538,-0.83153,-0.53377],[0.17941,-0.81545,-0.55032],[0.88263,-0.21087,0.42011],[0.85575,0.1807,-0.4848],[-0.74231,0.5266,0.41433],[-0.66607,0.0071105,-0.74586],[0.86138,-0.42019,-0.28544],[-0.074306,-0.69681,-0.71339],[-0.45244,0.38491,-0.80446],[-0.016516,-0.85519,-0.51806],[0.2999,0.73518,-0.60793],[-0.76629,0.39409,-0.50744],[0.576,0.80516,0.14124],[-0.35306,0.56276,-0.74743],[-0.67222,-0.31648,-0.6693],[0.71177,0.68543,0.15349],[-0.74558,-0.029706,-0.66576],[-0.72854,-0.30306,0.61432],[0.91723,-0.38247,-0.11139],[-0.92994,0.2623,-0.25769],[-0.75447,0.038699,-0.65519],[0.94582,-0.21986,-0.23893],[-0.80073,-0.24431,-0.54693],[-0.62586,0.091525,0.77455],[0.75241,-0.38314,-0.5358],[-0.96733,0.19716,-0.15941],[0.99911,-0.027592,-0.03176],[0.60153,-0.63817,-0.48051],[0.74843,-0.6622,-0.036621],[0.18022,-0.91614,-0.35805],[0.51532,-0.74408,-0.42519],[0.74144,-0.66472,0.091666],[-0.93557,0.34103,0.091685],[0.53922,0.19922,0.81826],[-0.93939,0.29097,0.18132],[-0.88586,0.38943,0.25218],[0.60632,0.78945,0.095672],[-0.83381,0.45354,0.31475],[-0.93848,0.030291,0.34401],[-0.67175,0.25957,0.69382],[-0.91125,-0.12347,-0.39292],[0.91718,-0.082145,0.38991],[0.98255,-0.031092,0.1834],[0.99172,-0.01602,0.12742],[0.79963,0.15265,-0.58077],[0.75004,0.51954,-0.40929],[0.97382,-0.20977,-0.087625],[0.97006,0.039529,0.23964],[0.35064,0.87226,-0.34091],[-0.66984,0.32265,0.66874],[0.96472,0.18366,-0.18864],[0.74526,0.65332,0.13329],[-0.73989,0.30198,0.60114],[0.86023,0.43773,0.26152],[0.88476,0.4253,-0.19055],[-0.37172,0.91635,0.14877],[-0.65388,0.6989,0.28978],[-0.92345,0.23913,0.30009],[0.1177,0.39152,-0.91261],[0.92232,0.15412,0.35436],[-0.81771,0.51424,0.25867],[0.81417,0.45534,0.36026],[-0.63719,0.16429,0.75299],[0.19551,0.87215,-0.44848],[0.79652,0.59226,0.12158],[0.16117,0.079316,-0.98373],[0.10485,-0.17027,-0.9798],[0.24657,-0.15002,-0.95744],[-0.70108,0.45311,0.55062],[-0.29124,0.83813,-0.46122],[-0.98062,-0.15847,0.11518],[0.97407,0.18674,-0.12773],[-0.47496,0.61237,0.63199],[-0.28239,0.75735,0.5888],[-0.055167,-0.92792,0.36867],[0.44205,0.7609,-0.475],[0.43505,-0.20875,0.87587],[0.26887,0.85524,-0.44303],[-0.47828,0.79634,-0.37025],[0.17559,-0.25745,-0.9502],[-0.74345,0.42529,0.51614],[-0.1504,0.89166,-0.42698],[-0.33432,0.76377,0.55216],[0.84294,0.22898,0.48685],[-0.94464,0.29671,-0.14004],[-0.34874,0.25405,0.90213],[-0.18813,0.67689,-0.71164],[0.52941,0.84807,-0.022477],[-0.33651,0.2287,-0.91349],[0.33027,-0.15804,-0.93056],[-0.54789,0.77586,0.31283],[-0.6127,0.75683,0.22761],[0.47557,0.39606,0.78548],[-0.27499,0.69548,0.66384],[-0.028881,0.95566,0.29305],[0.80258,-0.41151,0.43189],[0.061778,0.99689,0.048891],[-0.030963,0.99476,-0.097466],[-0.014383,0.968,-0.25052],[0.10817,0.85808,-0.502],[-0.41061,0.097427,-0.90659],[0.14556,0.04083,-0.98851],[0.72327,-0.43873,0.53328],[-0.57146,0.76446,0.2984],[0.05572,0.34802,-0.93583],[0.22582,0.2099,-0.95129],[0.88873,0.30538,0.34192],[-0.34889,-0.048093,-0.93593],[0.013429,0.56615,-0.8242],[-0.63432,-0.7417,0.21799],[0.015872,0.53075,-0.84738],[-0.15635,0.73788,-0.65657],[0.19089,0.43785,-0.87855],[-0.95442,-0.053022,-0.29372],[-0.28614,0.32694,-0.90069],[-0.15682,0.48082,-0.86268],[0.0025984,0.57021,-0.8215],[0.10341,0.54156,-0.83428],[0.10756,0.60886,-0.78595],[-0.14888,0.64617,-0.74853],[0.32483,0.92389,0.20226],[0.71967,-0.0093713,0.69425],[0.3703,0.13082,0.91965],[-0.65879,0.16677,0.73361],[0.92331,-0.026531,-0.38314],[-0.95508,-0.28512,0.080791],[0.23807,-0.65083,0.72093],[0.0092131,0.63479,-0.77263],[0.93383,0.15257,-0.32356],[0.52776,0.37627,0.76151],[-0.68405,-0.50124,-0.52994],[0.96427,0.26489,-0.0045761],[0.89615,0.42747,0.11913],[0.43605,-0.64454,0.62803],[-0.72518,0.49055,0.48319],[-0.87301,0.32126,0.36693],[-0.49973,0.80094,0.32979],[0.78173,0.59521,0.18607],[-0.97639,-0.12853,-0.17359],[0.77837,0.1426,-0.6114],[0.57965,-0.81438,0.028151],[0.60382,0.78981,-0.10774],[-0.96143,0.13895,-0.23737],[-0.87263,-0.21978,0.43614],[0.93537,0.35057,-0.046829],[-0.96847,0.13544,-0.20911],[0.4699,0.15517,0.86897],[0.68189,0.72049,-0.1262],[-0.94255,0.044713,-0.33106],[-0.79202,-0.21193,0.57253],[0.064413,-0.83442,0.54735],[-0.5252,0.69257,-0.49448],[-0.76643,0.21408,0.60561],[-0.077736,-0.26477,-0.96117],[-0.1611,0.98061,-0.11155],[0.25726,-0.96126,-0.098974],[0.49551,0.84967,-0.18037],[0.086258,-0.42459,0.90127],[-0.44054,-0.65326,-0.61577],[-0.37306,-0.57622,-0.72718],[0.27346,-0.95999,0.060295],[0.61621,-0.17162,0.76866],[-0.26051,0.91191,0.31711],[0.43683,0.28738,0.8524],[-0.60822,-0.68214,-0.40591],[-0.59047,0.66951,0.45067],[0.79385,0.39281,0.46422],[-0.80484,-0.50367,-0.31392],[0.74891,0.5178,0.41353],[-0.88695,0.4224,-0.18683],[-0.75044,-0.65882,0.052859],[0.42759,-0.80277,0.41559],[0.56052,0.029632,-0.82761],[-0.91491,-0.37431,-0.15112],[-0.85031,0.4917,0.18762],[0.59669,-0.6602,0.45618],[0.87217,0.020452,-0.48878],[-0.74915,-0.64222,0.16228],[-0.86633,-0.48604,0.11503],[-0.64735,-0.014781,0.76205],[0.42594,9.0388e-05,-0.90475],[-0.79173,-0.58351,0.18077],[0.27862,0.14288,-0.94971],[0.75042,-0.29567,0.59114],[0.83183,0.54562,-0.10178],[-0.73994,-0.60392,0.29626],[0.77444,-0.070404,-0.62871],[0.46012,0.26692,-0.84679],[-0.83118,0.42055,0.36369],[0.78117,0.61957,-0.076883],[0.78773,-0.61601,-0.003973],[0.7699,0.35223,0.53216],[-0.6846,0.31368,0.65797],[0.2809,0.14765,-0.94831],[0.83159,0.25507,0.49336],[0.45917,0.32522,-0.82668],[-0.51766,0.69658,0.4968],[0.90935,0.3967,-0.12538],[0.14988,0.90866,0.3897],[0.2711,0.89159,0.36272],[0.48498,0.82893,0.27869],[-0.73727,-0.60173,0.30716],[-0.72077,-0.66311,0.20195],[-0.67381,0.18136,0.7163],[-0.73793,-0.63632,0.22482],[-0.10367,-0.99335,0.050161],[0.41065,0.33354,-0.8486],[0.31308,0.34497,0.88486],[-0.69262,-0.69894,0.17822],[0.80931,-0.30543,0.50173],[-0.9853,0.042912,0.16534],[0.40813,0.37677,-0.83155],[-0.64155,-0.76497,0.056919],[0.50126,0.48711,-0.71517],[0.63408,-0.65981,0.40322],[0.49904,0.48509,-0.71808],[-0.5101,0.82488,0.24366],[-0.7228,-0.13416,0.67791],[-0.14825,0.98893,0.0064129],[-0.10816,0.18941,0.97592],[-0.75392,0.61428,0.23296],[-0.68462,0.53918,0.49049],[0.45682,0.50292,-0.73375],[-0.9088,0.36465,-0.20275],[-0.25344,-0.8397,-0.48029],[-0.62654,-0.15062,0.7647],[0.96818,0.24041,-0.069514],[-0.56053,0.7905,0.2468],[-0.86695,-0.48229,0.12567],[-0.74899,-0.3909,-0.53498],[0.62615,-0.59439,0.50461],[0.78213,-0.092615,0.61619],[0.7788,-0.28341,0.5596],[-0.86617,0.49484,-0.069834],[0.742,0.0076654,-0.67036],[0.37049,0.67296,-0.6402],[0.47839,-0.82994,0.28696],[-0.57708,0.81631,0.024819],[-0.2823,0.94142,-0.18449],[0.48682,-0.85945,0.15605],[0.66322,-0.018781,0.74819],[0.067197,0.93961,-0.33558],[0.17056,0.86253,-0.4764],[0.27792,0.84023,-0.46559],[-0.065697,0.94038,-0.33373],[0.54434,0.7728,0.32631],[-0.90916,0.38461,-0.15968],[0.59537,-0.80288,0.030316],[0.099518,-0.97185,0.21355],[0.93751,0.33351,-0.099225],[-0.34691,-0.88113,0.32135],[-0.34249,-0.84554,0.40959],[0.23179,-0.90122,0.36617],[0.41009,-0.7408,0.53201],[-0.45944,0.88812,-0.012746],[-0.31545,-0.78856,0.52789],[-0.31421,-0.83269,0.45596],[0.71212,0.13939,0.68808],[-0.47892,-0.70392,0.52452],[0.62405,-0.70957,0.32721],[-0.053304,-0.83548,-0.54693],[-0.028298,-0.9254,-0.37794],[-0.21581,0.91756,0.33394],[0.37096,0.46894,0.80155],[0.16127,-0.91658,-0.36588],[-0.90667,-0.010105,0.42172],[-0.78121,0.10587,0.61523],[0.71276,-0.69779,0.071084],[-0.033938,-0.8551,0.51736],[-0.23046,-0.93236,-0.27854],[0.44322,-0.78067,-0.44058],[-0.047564,0.17945,0.98262],[-0.876,-0.46076,0.14258],[-0.76973,-0.57871,0.26947],[0.90314,-0.22337,-0.36667],[-0.5228,0.66431,0.5342],[-0.25517,-0.9303,-0.2635],[-0.21461,-0.8919,-0.39808],[0.71587,-0.4968,-0.49062],[-0.4113,-0.82019,-0.39764],[0.80304,0.079144,0.59064],[-0.75569,-0.059848,0.65218],[-0.68905,0.036555,0.72379],[-0.90995,-0.40645,0.082354],[0.88538,0.39392,-0.24683],[0.82882,-0.21693,-0.51575],[-0.72427,-0.15495,0.67188],[0.70117,0.079093,0.70859],[0.87319,0.43469,-0.22043],[0.69656,-0.2533,-0.67131],[-0.74072,-0.51312,-0.43365],[-0.64377,0.5932,-0.4834],[0.80243,-0.28747,0.52293],[0.13081,0.90341,0.40834],[-0.89484,-0.31549,-0.31581],[-0.53473,-0.63217,-0.56073],[-0.71558,0.34169,0.60925],[0.82234,0.17802,-0.54043],[0.90209,-0.35555,-0.24456],[0.50127,0.86248,0.069646],[-0.42074,0.25097,0.87178],[0.98294,-0.088479,-0.16127],[-0.74158,-0.59645,0.30709],[-0.74287,-0.61335,-0.26822],[-0.681,-0.6041,-0.41387],[0.76142,-0.21261,-0.61241],[0.75377,-0.65675,0.022656],[-0.82632,-0.38107,-0.4147],[0.57578,-0.51673,-0.63361],[0.58111,0.14627,0.80058],[0.94945,-0.083839,-0.30251],[0.60806,-0.47887,-0.6332],[0.47393,0.49006,0.7316],[0.22553,-0.97132,-0.075339],[-0.93848,-0.26944,-0.216],[0.77136,-0.46957,0.42955],[0.62204,-0.42039,-0.66056],[-0.90185,-0.022087,-0.43148],[-0.84665,-0.24252,0.47368],[0.83074,-0.55586,-0.029859],[0.82221,0.3971,0.40777],[0.54324,-0.79745,0.26261],[0.47268,-0.65167,0.59321],[0.77826,0.57322,-0.25639],[0.64192,-0.41728,-0.64328],[-0.44835,0.83906,0.30814],[0.65991,-0.23484,-0.7137],[0.78942,-0.31588,-0.52634],[-0.88362,0.081544,-0.46105],[0.42844,-0.58856,0.68559],[0.37464,-0.61793,0.69124],[-0.32686,0.53043,0.78218],[0.78762,-0.10785,-0.60665],[-0.89125,-0.014381,-0.45328],[0.40056,0.91519,0.044462],[0.78241,-0.41607,0.46337],[0.68907,-0.72432,-0.023198],[-0.6663,-0.72372,0.17965],[-0.96226,0.081515,-0.25962],[0.8039,-0.13808,-0.57852],[-0.76683,-0.56648,-0.30177],[-0.70589,-0.27918,-0.65099],[0.77808,0.58418,0.23091],[0.97812,0.19984,-0.057863],[-0.93053,0.15547,-0.33159],[-0.35029,0.29511,0.88893],[-0.61875,-0.02082,-0.78531],[-0.77872,0.023216,-0.62694],[0.65741,-0.74045,-0.13982],[-0.59155,0.38684,0.7074],[-0.74779,0.22984,-0.62288],[-0.84085,-0.54121,0.0077762],[0.84113,-0.086598,-0.53386],[0.26099,-0.30716,0.91517],[0.23858,0.96472,0.11133],[0.5179,0.6608,0.54325],[-0.54012,0.11654,-0.83348],[0.51916,0.63514,0.5719],[0.93008,0.012166,0.36716],[-0.68417,0.3395,-0.64548],[0.90589,0.026205,-0.42271],[-0.37633,0.66698,-0.64305],[-0.27195,0.56647,0.77791],[0.59046,0.16715,0.78957],[-0.70913,-0.038537,-0.70403],[0.843,0.010383,-0.53781],[-0.402,-0.48614,-0.77593],[-0.73015,-0.39732,-0.5559],[0.18054,-0.81163,-0.55557],[-0.60362,0.030496,0.79669],[-0.76168,-0.57062,0.30697],[0.48505,-0.7433,-0.46068],[-0.70536,-0.24857,0.66383],[-0.30974,0.52418,-0.79328],[0.15002,0.54685,0.82368],[0.9237,0.010797,0.38296],[-0.84493,-0.098057,0.52582],[0.70253,-0.63449,-0.32229],[0.70337,-0.6435,-0.30196],[0.24615,0.96033,0.13103],[0.59754,-0.48098,-0.64157],[0.71421,-0.67348,-0.1906],[-0.76186,0.014939,0.64756],[-0.8206,-0.56568,0.081343],[0.8242,0.039127,-0.56494],[-0.72697,0.01792,-0.68644],[-0.76998,-0.22109,-0.59854],[0.63626,0.052081,-0.76972],[-0.82367,0.24201,-0.51283],[-0.76627,0.020116,-0.64221],[0.99801,-0.059833,-0.019686],[0.99933,0.035569,0.0085579],[-0.36539,0.84766,0.38465],[0.39942,-0.77437,-0.49073],[-0.28086,0.79953,0.53091],[0.31036,0.81235,0.49373],[0.98774,0.08251,-0.13255],[-0.83438,-0.15562,-0.52877],[-0.84164,0.31084,-0.44162],[0.3901,-0.83718,-0.38335],[-0.76783,0.075626,-0.63618],[-0.38747,0.91558,0.10757],[-0.81859,0.29121,-0.49508],[0.9456,-0.046216,-0.32205],[0.9868,0.13236,-0.093309],[0.79196,-0.59674,0.12926],[-0.84085,0.49139,-0.22694],[0.89395,0.27361,-0.35496],[-0.79698,0.11064,-0.59379],[-0.91228,-0.307,0.27112],[0.8115,-0.3106,0.49497],[0.91804,-0.32807,0.22265],[-0.22446,0.59198,0.77407],[0.96984,-0.24374,0.0030915],[-0.89939,0.42447,0.10451],[0.56501,0.78936,-0.24014],[0.10655,0.54822,0.82952],[0.73615,-0.34333,-0.58328],[0.20026,-0.58778,0.78384],[0.49561,0.73685,0.45981],[-0.89088,0.34139,0.29963],[0.51763,0.82101,-0.24084],[0.54729,0.67896,-0.48937],[-0.92591,-0.16861,-0.33803],[0.9868,-0.020026,0.16069],[-0.75381,0.53558,0.38069],[0.54489,0.66387,-0.51223],[0.21051,0.35395,-0.91127],[-0.17016,0.30494,-0.93705],[0.76471,0.60664,0.21728],[0.98135,0.13207,0.13969],[-0.94321,0.33023,0.036004],[0.22867,0.94124,-0.24857],[0.56967,0.15281,0.80754],[-0.86338,0.32234,-0.38818],[0.68574,-0.14188,-0.71388],[0.12275,0.28594,-0.95035],[-0.0090831,0.59664,-0.80246],[0.35575,0.88324,-0.30551],[0.70219,0.66005,-0.26696],[0.81302,-0.16979,0.55693],[-0.77748,0.44028,-0.44908],[-0.47948,0.81356,0.32897],[-0.91379,-0.090074,0.39606],[0.13694,0.98155,-0.13341],[0.14359,0.95827,-0.2472],[-0.56943,0.67623,-0.4674],[0.60002,-0.15158,-0.78549],[0.38091,-0.13526,-0.91467],[0.87747,-0.1113,0.46655],[0.014869,0.9232,-0.38403],[-0.87361,-0.22414,-0.43194],[0.98969,0.11782,-0.081454],[0.85557,0.51602,0.041491],[-0.39759,0.86955,0.29293],[0.46636,0.79005,-0.3979],[-0.34259,0.81503,-0.46729],[-0.3918,0.56335,0.72742],[-0.2262,0.76628,-0.60137],[-0.21383,0.97637,0.031229],[-0.1487,0.9589,-0.24165],[0.14333,0.91837,-0.36886],[-0.070187,0.98802,-0.13742],[-0.1697,0.94365,-0.28412],[0.9475,0.095263,0.30524],[0.019447,0.92436,-0.38102],[-0.44202,0.79667,0.41224],[0.2102,0.95422,-0.21279],[-0.41072,0.18033,-0.89375],[-0.91388,-0.035012,0.40446],[-0.36446,0.057053,-0.92947],[0.47702,-0.18705,-0.85876],[-0.71059,0.41804,0.56595],[-0.18536,0.39428,0.9001],[0.81709,0.43827,-0.37454],[0.36904,0.20989,-0.9054],[-0.79978,-0.22737,0.55557],[0.87134,0.49034,-0.018132],[0.93635,0.096971,-0.33742],[-0.36547,0.56086,0.74287],[-0.38896,-0.14922,-0.90909],[0.22905,0.57678,-0.78413],[-0.56125,0.6299,0.53687],[-0.42241,0.033271,-0.90579],[0.17916,0.67532,-0.71543],[-0.39043,0.68372,0.61652],[-0.80896,-0.24965,-0.53222],[-0.52203,0.62647,0.57881],[0.40811,0.81131,-0.41859],[-0.32229,0.39252,-0.86142],[-0.86678,0.1009,0.48838],[-0.23802,0.74134,0.6275],[0.025761,0.71483,-0.69882],[-0.37499,0.46691,-0.80086],[0.1731,0.64321,-0.74587],[0.25722,0.68839,-0.6782],[-0.10616,0.74502,-0.65854],[-0.041256,0.67167,-0.7397],[0.34323,0.27041,0.89949],[0.77233,0.57546,0.269],[-0.74451,-0.41496,-0.52299],[0.31478,0.86751,0.38515],[-0.20316,0.59706,-0.77604],[0.91827,0.18062,0.35236],[-0.3928,0.60786,0.69009],[0.90028,0.37578,-0.21974],[0.11671,0.68655,-0.71765],[-0.47289,0.41457,0.7775],[-0.78876,-0.43124,-0.43806],[0.58041,-0.29656,-0.75841],[-0.17477,0.83725,0.51814],[-0.32759,0.54752,0.77],[-0.93853,-0.33352,-0.088991],[0.84249,0.51283,0.165],[0.21971,0.68621,0.69343],[0.21889,0.73207,0.6451],[0.70332,0.65261,0.28184],[0.080262,0.90119,0.42594],[0.70809,0.69928,0.098099],[-0.69387,0.4734,0.54262],[-0.94812,0.095747,0.30314],[-0.98632,0.06048,-0.15338],[0.89336,0.36677,-0.2596],[0.8959,0.37757,-0.23411],[0.1795,0.883,0.43369],[0.078929,0.31994,-0.94414],[0.82339,-0.040173,0.56605],[0.7374,-0.67082,0.079077],[-0.38735,0.2568,0.88544],[-0.64016,-0.38317,-0.66587],[-0.48572,-0.50018,-0.71687],[0.52015,0.84813,-0.1006],[-0.093164,0.52825,0.84397],[0.12224,-0.51189,-0.85031],[-0.049307,0.47708,-0.87747],[-0.51921,0.7533,-0.40368],[0.36632,0.92965,0.039591],[-0.072725,-0.60187,-0.79528],[-0.73529,-0.57416,-0.36013],[-0.0096268,0.38769,0.92174],[0.41912,-0.3542,-0.83599],[-0.66418,-0.57751,-0.47471],[0.72505,-0.44129,-0.52875],[-0.070513,0.99552,-0.063038],[-0.050552,0.9753,0.21502],[0.078471,0.98659,0.14311],[0.66648,0.58709,-0.4595],[0.56512,-0.17967,-0.80521],[0.7724,-0.10133,-0.627],[-0.82983,-0.54092,-0.13707],[0.9002,-0.13991,0.41239],[0.17076,-0.86213,-0.47705],[-0.83488,-0.53854,0.11382],[0.88247,-0.0099464,-0.47027],[-0.82763,-0.56123,-0.0065938],[-0.0696,-0.54447,0.83589],[-0.98669,-0.14794,0.067496],[-0.051453,-0.55757,0.82853],[0.61512,0.19013,-0.76517],[-0.78889,-0.55145,0.27121],[0.037214,0.39711,0.91702],[0.60161,-0.030043,-0.79823],[-0.98964,0.0094604,0.14326],[0.92485,0.19495,-0.32656],[-0.72223,-0.57917,0.37807],[-0.89508,0.34905,0.27747],[0.89902,0.37285,-0.22968],[-0.35224,0.92605,0.13546],[0.66348,0.26733,-0.69881],[-0.9842,0.1679,0.056183],[-0.89153,-0.44825,-0.065143],[0.5384,0.56635,0.624],[-0.65076,0.57359,0.4975],[0.87069,0.12801,0.47488],[0.56977,0.77853,0.26314],[-0.74408,-0.54547,0.38575],[0.23712,0.14328,0.96086],[-0.924,0.36116,0.12566],[-0.39104,-0.017689,0.9202],[0.56992,0.40289,-0.71615],[-0.13576,0.77836,-0.61296],[0.79193,0.20464,0.5753],[-0.69177,-0.61018,0.38618],[-0.12496,-0.32705,0.93671],[-0.13951,0.21595,0.96639],[0.56097,0.46193,-0.68697],[-0.04104,0.10417,0.99371],[0.041378,0.022446,0.99889],[0.040556,0.99618,0.077316],[0.19233,0.29413,0.93622],[-0.014811,-0.61418,0.78903],[-0.82867,-0.099217,0.55087],[-0.49441,-0.84134,-0.21841],[-0.41995,-0.87353,-0.24613],[-0.10782,0.010404,0.99412],[0.50833,0.55627,-0.65739],[0.52814,0.52447,-0.66783],[-0.26292,-0.86797,-0.42131],[-0.65629,-0.63373,-0.40948],[-0.085738,0.7471,-0.65916],[0.2151,0.66588,-0.71438],[0.22714,-0.27674,0.93371],[-0.99031,0.13371,0.037638],[0.1694,0.29698,0.93974],[0.44365,0.73042,-0.51929],[-0.75676,0.58056,0.30043],[0.26825,0.76435,-0.58636],[-0.053592,0.022578,0.99831],[-0.77494,-0.63169,0.02075],[0.14173,-0.38225,0.91313],[-0.286,0.94154,-0.17804],[-0.39724,-0.11857,0.91002],[0.95168,0.13814,0.27425],[-0.25062,-0.88349,0.39578],[0.19846,-0.90984,0.36442],[0.74437,0.59444,0.30423],[0.30163,-0.84331,0.44481],[-0.077196,0.98961,0.12133],[0.34492,0.48401,0.80422],[-0.18947,0.032778,0.98134],[0.60075,-0.74105,-0.29991],[-0.34666,-0.86581,0.36083],[0.25161,-0.80039,0.54412],[0.19453,-0.18661,0.96298],[-0.44901,-0.83013,0.33057],[0.54252,-0.66524,0.51296],[0.46844,0.16884,0.86721],[0.20338,0.014228,0.979],[-0.27458,-0.8764,-0.39564],[0.14216,-0.90184,-0.40801],[-0.020676,0.79048,-0.61214],[-0.63804,-0.65299,0.40806],[0.69969,-0.60331,0.38269],[-0.25102,-0.016958,0.96783],[-0.24542,-0.8534,-0.45986],[0.50249,-0.67631,-0.53861],[0.18778,0.98193,0.023609],[0.29229,0.9563,0.007762],[0.75517,-0.35153,-0.5533],[-0.062141,0.03043,0.9976],[-0.33018,-0.94391,0.002876],[0.92353,-0.36256,-0.12505],[-0.78539,0.205,0.58407],[-0.42307,-0.89439,-0.14516],[0.25847,-0.14028,0.95578],[-0.76206,-0.48511,0.42888],[-0.65857,-0.70548,-0.26188],[-0.28026,-0.95827,-0.056377],[0.83833,-0.39556,-0.37514],[-0.81598,-0.46798,0.33938],[-0.48035,0.64493,0.59441],[0.88376,0.17572,0.4337],[-0.55823,-0.65338,-0.51134],[-0.88951,-0.44223,0.11489],[-0.88357,0.39126,0.25734],[-0.33178,0.20022,0.92186],[-0.017965,0.79282,-0.60919],[-0.91934,-0.39174,-0.036815],[-0.81231,-0.54803,-0.19956],[0.9178,0.31632,0.23998],[-0.91598,-0.2916,-0.27558],[0.87295,-0.10083,-0.47728],[0.46788,-0.44243,-0.76507],[0.12751,0.011626,0.99177],[0.57856,-0.33282,-0.74464],[0.97079,0.09822,0.2189],[0.85339,-0.17232,-0.49196],[-0.51427,0.61428,0.59849],[-0.889,-0.13219,-0.43842],[0.86091,-0.3167,-0.39815],[-0.87772,-0.30532,-0.36931],[0.32191,0.61877,0.71659],[0.83419,-0.50968,0.21062],[-0.83054,0.07433,-0.55198],[0.67758,-0.51957,0.52052],[-0.91552,-0.22396,0.33417],[-0.79185,-0.36108,-0.49253],[-0.94248,-0.042494,-0.33154],[0.82254,-0.16559,-0.54407],[-0.75637,-0.47858,-0.44595],[0.25148,0.024008,0.96757],[-0.41201,-0.91002,-0.045888],[0.97255,-0.21548,0.087811],[-0.95998,0.1205,-0.25281],[-0.58355,-0.73606,-0.34306],[-0.43352,-0.89878,-0.065216],[-0.68784,-0.44777,-0.57129],[-0.91859,-0.056827,-0.3911],[0.66091,-0.14176,-0.73695],[0.92703,0.17245,-0.33298],[-0.67213,-0.24676,-0.69811],[0.051212,0.094981,0.99416],[-0.9617,0.055368,-0.26845],[0.54348,0.83669,0.067736],[0.89912,0.21539,-0.38103],[0.88896,0.050803,-0.45517],[-0.85952,0.43156,0.27383],[-0.56279,0.13737,-0.8151],[0.88183,-0.030822,-0.47055],[-0.85299,0.26026,-0.45242],[-0.26756,0.28874,0.91926],[-0.47899,-0.76876,-0.42377],[0.06572,-0.94357,-0.3246],[-0.078781,-0.73966,-0.66835],[0.16003,-0.9169,-0.36563],[0.016952,0.90927,-0.41587],[-0.21148,-0.92885,-0.30415],[0.1294,-0.91525,-0.38153],[0.45032,-0.85676,-0.25134],[0.63791,-0.75135,-0.16896],[-0.67055,0.10981,-0.7337],[-0.28777,0.94769,-0.13808],[-0.22886,-0.87554,-0.42551],[-0.49003,-0.13454,0.86126],[0.49093,0.76978,-0.40796],[-0.78634,0.45853,-0.41403],[-0.09846,0.13234,0.9863],[0.89907,0.090553,-0.42833],[-0.77924,0.020898,-0.62638],[-0.73646,0.49266,-0.46359],[0.95266,-0.28056,-0.11714],[-0.8083,0.28863,-0.51317],[0.77118,-0.24403,-0.58799],[0.98218,-0.18159,0.048386],[0.20463,0.084848,0.97516],[-0.81893,0.21224,-0.53321],[0.40952,-0.7488,-0.52115],[0.17751,-0.90547,-0.3855],[-0.84566,-0.52616,0.089479],[-0.80074,0.15191,0.57943],[-0.73526,0.10884,-0.66899],[0.2016,0.15427,0.96724],[-0.9525,0.27563,0.12946],[-0.31619,0.8746,-0.36757],[-0.7375,0.40189,-0.54276],[0.69664,-0.5842,-0.41642],[-0.69832,0.16314,-0.69695],[0.99377,0.099481,0.050315],[0.82288,-0.55082,-0.1395],[0.99458,0.10176,0.021476],[-0.69464,0.52871,-0.48779],[-0.66619,0.65328,-0.35974],[0.84084,0.52382,-0.1364],[-0.4166,0.27822,0.86547],[-0.83424,-0.14281,-0.53258],[0.97422,-0.16103,0.15799],[-0.83863,0.48369,-0.2505],[0.055716,-0.37185,0.92662],[-0.85209,-0.17422,-0.49355],[0.53363,0.71699,-0.44852],[-0.058445,0.3064,0.95011],[-0.36404,0.27193,0.8908],[-0.29603,-0.3484,0.88937],[0.96296,-0.25896,-0.075145],[-0.89082,0.45432,0.0054974],[0.95435,0.28319,0.095006],[-0.1336,-0.39764,0.90776],[-0.81321,0.40275,-0.4201],[-0.025545,0.95017,-0.3107],[0.84081,0.10478,0.53109],[0.25953,-0.31588,0.91261],[0.45617,0.82269,-0.33925],[0.56799,0.71235,-0.41224],[-0.83579,0.32319,-0.44385],[0.2628,-0.90725,0.32839],[-0.44944,0.89003,-0.076497],[0.4714,0.83124,-0.29465],[-0.87551,-0.084805,0.4757],[0.19532,0.50926,-0.83815],[0.074627,0.97359,-0.21575],[0.85229,0.47944,0.20916],[-0.48692,0.86234,-0.13882],[0.0045442,-0.3392,0.9407],[0.46045,0.81833,-0.34398],[-0.25252,0.82987,-0.49754],[0.45613,0.0027069,-0.88991],[0.11854,0.6894,-0.71462],[0.69697,0.12053,0.7069],[-0.89606,-0.11656,-0.42836],[0.049689,-0.96277,0.26571],[0.19778,-0.31301,0.92893],[-0.27412,0.90432,-0.3272],[0.14097,-0.37371,0.91677],[0.13456,-0.416,0.89935],[-0.084811,0.9942,-0.06613],[0.16173,0.15943,0.97387],[0.20879,0.95704,-0.20122],[0.34117,0.89551,-0.28578],[-0.29977,-0.44902,-0.84173],[-0.46355,0.42408,-0.778],[-0.096183,0.91679,-0.38761],[-0.32212,0.91912,-0.22682],[-0.50598,-0.16654,-0.84631],[0.52008,-0.033848,-0.85345],[0.31282,0.8217,0.4764],[-0.4712,-0.11149,-0.87495],[0.8912,0.42092,-0.1691],[-0.75492,0.51968,-0.40004],[0.12573,-0.24806,0.96055],[-0.19871,-0.66169,-0.72296],[-0.47046,-0.12525,0.87349],[0.93162,0.074714,-0.35566],[-0.46649,0.22125,-0.85641],[0.10371,0.67992,-0.72592],[-0.32759,0.93173,0.15672],[0.25611,0.73846,-0.62376],[0.16236,0.77286,-0.61346],[-0.28772,0.93823,-0.19221],[0.345,0.37847,-0.85891],[0.40175,0.19538,0.89466],[-0.10417,0.61663,-0.78033],[0.80724,0.19287,0.55782],[-0.019157,0.71317,-0.70073],[0.0013903,-0.32093,0.9471],[0.18179,0.74612,-0.64051],[-0.065766,-0.72635,-0.68417],[-0.96808,0.24117,-0.068223],[-0.31714,0.78062,0.53856],[-0.75751,-0.3624,-0.543],[-0.59386,0.76572,0.24699],[0.89494,0.37836,-0.23647],[-0.038898,0.79511,-0.60521],[0.65502,0.036532,0.75473],[0.86559,0.50052,-0.015183],[0.72122,0.69257,-0.013814],[0.99384,0.083987,-0.07227],[0.29348,-0.63452,-0.71502],[0.83947,0.50857,0.19142],[-0.92153,-0.2964,-0.25086],[0.71927,0.63661,0.27815],[0.73163,0.62259,0.27766],[-0.99526,0.03369,0.091221],[-0.93377,0.35743,0.017553],[-0.55409,0.81213,0.18284],[0.67344,0.63568,0.37734],[0.31429,-0.19476,0.92913],[-0.99941,-0.031027,-0.014819],[-0.83628,-0.17861,-0.5184],[-0.93297,0.34957,-0.085834],[0.86527,0.4498,-0.22136],[-0.8431,0.075674,-0.53241],[-0.1917,0.91474,-0.35567],[-0.83965,0.031543,-0.54222],[0.86591,0.49732,-0.053558],[-0.28623,-0.1531,-0.94585],[0.68914,0.056398,0.72243],[-0.41945,-0.61165,0.67079],[0.20388,0.77319,0.6005],[-0.75646,-0.2072,-0.62035],[0.7674,0.63989,0.040495],[-0.51991,0.10644,-0.84756],[0.82882,0.55583,-0.064182],[0.48904,-0.31837,-0.81209],[0.81376,0.55984,0.15613],[0.010209,-0.11273,-0.99357],[0.65186,-0.37928,-0.65667],[0.97393,0.041851,0.22294],[-0.14414,-0.98382,0.1064],[0.38378,-0.44735,0.80783],[-0.42231,-0.57689,-0.69918],[-0.80301,0.53309,-0.26643],[-0.19102,-0.26521,0.94508],[-0.61126,-0.52187,-0.59498],[0.96948,0.20893,-0.12828],[0.64323,0.75933,0.09837],[-0.86926,-0.43968,-0.22596],[0.47954,-0.38518,-0.78846],[-0.60053,0.20361,-0.77324],[0.12803,-0.13072,-0.98312],[-0.21892,0.8693,-0.44316],[-0.46552,-0.49384,0.73444],[-0.93211,0.11866,0.34219],[0.38684,0.92207,-0.011683],[-0.1666,0.84146,-0.51399],[-0.44866,-0.89247,0.046993],[0.669,-0.10946,-0.73516],[-0.55408,-0.5274,-0.64408],[0.85492,-0.39755,-0.33326],[0.31772,-0.12319,-0.94015],[0.27946,-0.36874,0.88653],[0.69579,0.21809,-0.68433],[0.1941,0.8657,-0.46139],[0.016944,0.99756,-0.067681],[0.89938,0.10608,0.42411],[-0.90686,-0.4213,-0.010368],[-0.44355,0.20034,0.87357],[0.63746,0.013244,-0.77037],[-0.5369,0.26105,-0.80224],[0.8345,0.15377,-0.52912],[0.10191,0.98346,0.14974],[0.083763,-0.054999,-0.99497],[0.75146,-0.39672,-0.52719],[-0.79971,0.56953,0.19001],[-0.78376,0.55053,-0.28746],[0.68602,-0.01547,-0.72741],[-0.57236,0.33558,-0.74819],[0.1983,-0.032958,-0.97959],[0.56603,-0.5107,-0.64714],[0.79861,-0.40186,-0.44803],[-0.99162,-0.12731,0.022117],[-0.35034,0.92924,0.11734],[0.19666,-0.1146,-0.97375],[0.75196,-0.4869,-0.44439],[-0.044825,0.78645,-0.61602],[-0.54284,0.39086,-0.74334],[-0.8325,0.13404,0.53757],[0.87606,0.11426,0.46847],[-0.7895,-0.59252,0.16003],[0.67529,0.68943,-0.26206],[0.7414,0.093974,-0.66445],[-0.50859,0.25315,-0.82295],[0.056898,-0.029535,-0.99794],[0.87615,0.47573,-0.077737],[0.52929,0.84815,-0.022397],[0.80191,-0.56366,-0.19805],[0.36371,-0.12691,-0.92283],[0.069399,-0.63813,0.7668],[0.33466,0.67478,-0.65778],[0.66165,0.72805,0.17934],[-0.75569,-0.61494,0.22533],[0.78225,0.37211,-0.49962],[0.056074,-0.81188,0.58112],[-0.57847,0.36674,-0.72861],[-0.53058,0.76092,-0.37349],[0.63658,-0.4491,-0.62696],[0.83644,-0.033664,0.54702],[0.51383,-0.25425,0.81935],[-0.11625,0.98473,0.12956],[0.75764,0.61899,-0.20697],[-0.5579,0.41624,-0.71798],[-0.32892,0.3174,-0.88942],[0.53139,0.81613,-0.22704],[0.078258,-0.07748,-0.99392],[-0.56048,0.73691,-0.37794],[-0.21682,0.82633,0.51978],[-0.074693,0.854,0.51488],[-0.48496,-0.36902,0.79287],[0.20577,0.86433,0.4589],[0.6533,0.44925,-0.60941],[-0.081382,0.1514,-0.98512],[0.13658,0.98322,0.12094],[0.60916,-0.41462,-0.67603],[-0.72896,0.54538,-0.41374],[-0.74975,-0.65915,0.058276],[0.17179,0.84176,0.5118],[-0.05377,0.89396,0.44492],[-0.25027,-0.15045,0.95641],[0.68046,0.71978,0.13746],[-0.36573,0.93066,-0.010401],[0.58844,-0.41559,-0.69356],[0.056046,0.013469,-0.99834],[-0.71363,-0.70052,0.00090678],[0.65358,0.49221,-0.57494],[-0.26106,-0.58838,0.76528],[-0.39819,0.34292,-0.85079],[-0.87192,0.45814,0.1728],[0.53378,-0.10494,-0.83909],[-0.13404,-0.48748,-0.86278],[0.50323,0.85267,0.14043],[-0.042851,-0.77151,0.63478],[0.62449,0.49641,-0.60298],[0.26146,0.0019823,-0.96521],[0.29933,-0.43249,-0.85051],[-0.61918,-0.76641,-0.17099],[0.22517,0.95269,0.20418],[0.5591,0.51803,-0.64734],[0.8023,-0.5144,-0.30282],[0.22169,-0.60324,0.76613],[-0.27544,0.25046,-0.92812],[-0.58666,0.75147,0.30187],[0.72159,-0.35755,-0.59284],[0.60681,-0.22621,0.76198],[-0.27686,0.96068,-0.021239],[0.14921,-0.027502,-0.98842],[-0.63585,-0.33505,-0.69529],[-0.35284,-0.84392,-0.40411],[-0.053675,-0.40977,0.91061],[0.3231,0.93704,0.13251],[-0.16966,-0.45717,0.87305],[-0.20357,-0.84735,-0.49046],[0.53892,0.60025,-0.59099],[0.11772,-0.47746,0.87073],[-0.88986,-0.44863,-0.082975],[-0.6783,-0.69784,-0.23007],[0.69978,0.69662,0.15818],[0.96108,0.27538,-0.022194],[0.30949,-0.57413,0.75802],[0.35954,0.90486,0.22793],[0.092017,-0.58623,-0.8049],[0.50278,0.72354,-0.47296],[0.44473,0.83722,-0.31824],[-0.51552,0.84177,0.16018],[-0.53871,0.84228,-0.018785],[0.35736,0.86913,-0.34192],[-0.025242,0.98559,-0.16728],[0.064908,0.98023,-0.18693],[0.19196,0.94015,-0.28153],[0.06106,-0.65501,0.75315],[0.67349,0.72107,0.16271],[-0.0015963,-0.9265,0.37629],[-0.33231,-0.89355,0.30187],[-0.80225,0.16252,0.57444],[-0.34773,-0.82749,0.44085],[0.36669,-0.74014,0.56367],[-0.23354,-0.36315,0.90199],[-0.92966,0.15434,0.33453],[-0.16261,-0.94209,-0.29329],[0.11494,-0.87821,-0.46426],[-0.39686,-0.77112,0.49787],[-0.13485,-0.61724,0.77513],[-0.13502,0.98849,0.068205],[0.24665,-0.82641,0.50617],[0.8173,-0.32824,-0.47358],[-0.19137,-0.91385,-0.35813],[0.070302,-0.93556,-0.34609],[0.16705,-0.8196,-0.54804],[-0.64106,-0.33394,-0.69103],[-0.073254,0.97796,0.19551],[-0.12593,-0.65331,0.74654],[-0.60307,-0.58591,0.54131],[0.82484,0.53935,0.16955],[0.10787,-0.533,-0.83921],[0.50588,-0.63656,0.58214],[0.62181,-0.59244,0.51221],[-0.014481,-0.48203,-0.87604],[-0.3368,-0.91651,-0.21581],[0.89525,0.13962,-0.42312],[-0.64674,-0.65586,-0.38932],[-0.5992,-0.79678,-0.078118],[-0.64956,-0.30785,-0.6952],[0.90018,0.36054,-0.24431],[-0.95247,-0.041986,-0.30171],[-0.75303,-0.49894,0.42896],[0.76767,-0.55022,0.32854],[-0.029283,0.9144,0.40375],[-0.62354,0.52218,0.58183],[0.88851,-0.42147,-0.1814],[-0.69249,-0.67594,-0.25212],[0.8996,0.37481,-0.22415],[0.76181,0.29252,0.578],[-0.42334,-0.55172,0.7186],[-0.13466,-0.42585,-0.89471],[-0.65947,-0.60693,-0.44355],[0.88334,0.13984,-0.44739],[-0.82449,-0.47981,0.30001],[-0.095104,-0.46851,-0.87833],[0.90635,-0.31778,-0.27846],[-0.77734,-0.52139,-0.35199],[0.55275,-0.36489,-0.74922],[0.56013,-0.40697,-0.72154],[0.43616,-0.21135,0.8747],[-0.91442,-0.39542,0.086489],[0.49513,-0.5465,-0.67541],[0.82948,-0.19392,-0.5238],[-0.32407,-0.2296,0.91775],[-0.91176,-0.35562,-0.20548],[0.5699,-0.34741,-0.74466],[-0.90457,-0.3731,-0.2063],[0.86284,0.50508,0.0201],[-0.93165,-0.32666,-0.15914],[0.9796,-0.11791,-0.16271],[0.66844,-0.30612,-0.67785],[0.82844,-0.13997,-0.54231],[-0.99673,0.079621,-0.01377],[-0.15775,-0.16967,0.97279],[0.84951,-0.065546,-0.52349],[0.99642,0.084445,-0.0029723],[0.79274,-0.30476,-0.52791],[-0.91278,-0.14224,-0.38289],[-0.84573,-0.40656,-0.34561],[-0.96984,0.21013,0.1235],[0.95021,-0.30437,-0.066778],[0.87675,-0.12955,-0.46317],[0.79248,-0.5277,0.3058],[-0.91867,-0.11733,-0.37721],[-0.031418,-0.47257,-0.88073],[0.53797,-0.66452,0.51866],[0.79103,0.61172,-0.0078952],[0.95176,0.14136,0.27234],[0.97971,0.17791,0.092229],[-0.63259,0.15026,0.75977],[0.48554,-0.64252,0.59281],[-0.6414,-0.73197,-0.22984],[0.6339,-0.67129,0.3841],[0.82908,-0.16178,-0.53521],[-0.41316,-0.45429,0.78925],[-0.94929,0.023454,-0.31351],[0.82117,0.024066,-0.57017],[-0.91449,-0.051296,-0.40135],[-0.93479,0.051939,-0.35138],[0.69617,-0.45667,0.55389],[-0.012712,0.97531,0.22049],[-0.64197,-0.14489,-0.75292],[0.8553,0.055351,-0.51517],[-0.63045,0.069793,-0.77309],[-0.93312,0.22865,0.27752],[-0.6422,0.13066,0.75532],[0.38335,-0.52665,0.75874],[-0.96411,0.18558,-0.18986],[-0.5868,0.20003,-0.78464],[-0.0081544,-0.99516,-0.097888],[-0.80891,0.5649,-0.16295],[0.85413,0.10089,-0.51019],[-0.82786,-0.15217,0.5399],[0.62601,0.048728,0.77829],[0.22656,-0.96199,-0.15249],[0.039354,-0.35614,0.9336],[-0.098608,-0.9932,0.061873],[0.89006,0.15455,-0.42885],[0.88706,0.032661,-0.46049],[0.8143,0.4895,0.31193],[0.75686,-0.6505,-0.063373],[-0.93461,0.31926,-0.15679],[-0.58364,0.18641,-0.79032],[0.70692,0.70518,-0.054596],[-0.73157,-0.40734,-0.54671],[-0.4339,0.23548,0.86964],[0.66529,-0.72577,-0.17506],[0.78412,0.45408,-0.42304],[-0.19813,-0.69541,-0.69076],[-0.74849,0.25704,0.6113],[-0.58577,0.049887,0.80894],[-0.77145,0.066148,-0.63285],[0.88269,0.088189,-0.4616],[0.73854,-0.64269,-0.20373],[0.13967,0.9581,0.25005],[0.80212,-0.013055,-0.59701],[0.32454,-0.76733,-0.55306],[0.89042,-0.44191,-0.10893],[0.7009,0.3593,0.61615],[-0.77852,0.44447,-0.44312],[0.89483,-0.20596,-0.39606],[-0.009165,0.90599,0.42319],[0.92948,-0.34847,0.12097],[0.63079,-0.15551,-0.76021],[0.91318,0.31972,-0.25274],[-0.76582,0.14208,0.62717],[0.14995,-0.36091,-0.92047],[0.87676,0.47546,0.072324],[-0.89676,0.16743,0.40962],[-0.77907,0.21827,-0.58772],[0.62398,0.7796,-0.053684],[0.16437,-0.35247,-0.92128],[-0.81432,0.45218,-0.3639],[-0.90273,-0.10894,-0.41619],[-0.84785,-0.19879,-0.49156],[0.67943,0.2621,0.68533],[-0.59806,0.16111,0.78509],[0.98434,0.019791,0.17517],[-0.97254,0.17835,-0.14954],[-0.72529,0.66352,-0.18356],[0.7378,0.59775,0.3136],[-0.95759,0.0067735,-0.28804],[0.84261,0.44392,-0.30485],[-0.5222,0.82217,-0.2266],[-0.73171,-0.22348,0.64394],[0.59128,0.73422,-0.33363],[0.39684,0.25629,0.88138],[-0.61074,-0.43193,-0.66365],[0.15573,0.97223,-0.1747],[-0.70755,-0.46046,0.53605],[-0.61793,0.61781,-0.48628],[-0.62514,0.24076,0.74245],[0.57193,0.26538,0.77619],[-0.61752,0.7777,-0.1177],[-0.49919,0.60351,-0.62176],[0.38782,0.45051,-0.80413],[0.32316,0.7394,-0.59064],[0.17429,0.92926,-0.32573],[-0.27552,-0.95628,0.098084],[0.90761,0.40937,0.093014],[0.25181,0.904,-0.34551],[-0.12855,0.9906,-0.046851],[-0.47937,-0.47335,0.73902],[0.28788,-0.57228,0.76787],[0.55344,-0.13787,-0.8214],[0.19407,-0.18599,0.9632],[0.99934,-0.0078662,-0.035484],[0.28834,0.93681,-0.19813],[-0.1689,0.98492,-0.037447],[0.12325,0.98157,-0.14602],[-0.40647,0.2034,0.89073],[-0.52084,-0.21899,-0.82509],[0.69919,0.47273,0.53634],[0.59894,0.032017,-0.80015],[-0.81199,-0.17703,-0.55618],[0.98652,-0.085256,-0.13967],[-0.56165,-0.26604,-0.78343],[0.84048,0.45246,0.29813],[0.556,-0.025375,-0.8308],[0.47966,-0.38373,-0.7891],[0.58755,-0.097797,-0.80326],[0.99688,-0.0058327,-0.078716],[0.67563,-0.52248,0.52013],[-0.034313,0.68711,-0.72575],[0.14299,0.56929,-0.80961],[-0.48602,0.30991,0.81715],[0.86613,0.46377,0.18639],[0.85012,0.047527,-0.52444],[0.43599,0.30659,0.84612],[-0.94017,0.27485,-0.20135],[0.48877,-0.67457,0.55322],[-0.14095,0.7934,-0.59216],[0.25964,0.80854,-0.52806],[0.33357,0.44208,-0.83265],[-0.34917,0.44377,-0.82532],[-0.20538,0.58288,-0.78617],[0.65214,0.74129,-0.15873],[-0.0012869,-0.36095,0.93258],[0.72626,-0.032964,0.68663],[0.069196,0.82319,0.56353],[0.21197,0.75061,-0.62583],[0.0054429,-0.99997,-0.0046245],[0.3387,0.77581,-0.53236],[-0.84978,0.17126,0.49855],[-0.18009,0.77423,-0.60674],[0.24639,0.814,-0.52602],[-0.45185,-0.48543,0.74846],[-0.089528,0.69875,-0.70974],[-0.31281,0.31824,0.89492],[-0.070875,0.72802,-0.68188],[0.25595,0.75255,-0.60676],[0.19766,0.76441,-0.61368],[-0.066183,0.83369,-0.54825],[0.3554,-0.91873,-0.17214],[-0.99719,-0.032693,0.067468],[-0.97864,-0.17417,-0.10923],[-0.21141,0.25502,0.94354],[0.69741,0.65551,0.2897],[-0.5852,-0.31303,0.74803],[0.86226,0.35842,0.35784],[0.16861,-0.19392,0.96642],[0.88065,0.46697,0.080034],[0.91078,0.30638,-0.27678],[-0.8363,-0.35311,-0.41943],[-0.75482,0.16577,0.63464],[-0.71998,-0.034689,-0.69313],[-0.43672,0.34681,0.83006],[-0.5392,-0.26977,-0.7978],[0.5561,-0.73044,0.39651],[0.46628,-0.47855,-0.74402],[-0.72444,0.087015,-0.68382],[0.46725,-0.27537,-0.84015],[0.073739,-0.4008,-0.91319],[0.83532,-0.36331,-0.4126],[-0.66506,-0.0020577,-0.74679],[0.88452,-0.39332,-0.25086],[-0.89771,0.39756,-0.1899],[0.66418,0.63939,0.38737],[-0.99837,0.047113,-0.032342],[0.97437,0.042669,-0.22085],[-0.6459,-0.54694,-0.53261],[-0.14318,-0.60573,-0.78268],[-0.94705,0.2666,-0.17895],[0.43423,-0.47022,-0.76833],[-0.99253,-0.12184,0.0068767],[-0.61805,0.17435,-0.76656],[-0.79497,-0.0073336,-0.6066],[0.92272,-0.38407,0.032958],[-0.89006,-0.38206,-0.24863],[0.5815,-0.35058,-0.73414],[0.977,-0.16096,-0.13988],[0.91571,-0.40052,0.032518],[-0.68685,-0.49653,0.53075],[-0.20441,-0.95587,-0.21104],[-0.1285,-0.98482,-0.11665],[-0.57672,0.3639,0.73142],[-0.017772,0.33774,0.94107],[-0.58858,0.2632,-0.76439],[-0.71169,-0.51034,-0.48276],[0.89146,-0.34345,0.29554],[-0.93172,-0.32855,-0.15478],[-0.61439,-0.16076,-0.77245],[0.52724,0.75749,-0.38499],[0.1448,0.97212,-0.18445],[0.15488,0.98573,0.065961],[-0.44908,0.26241,0.85409],[-0.4531,-0.58496,0.6727],[0.75954,-0.33319,0.55864],[0.85374,-0.43115,0.29193],[-0.68,-0.29648,0.6706],[-0.89518,-0.42205,0.14325],[-0.60317,0.38153,-0.70045],[-0.54862,0.82934,0.10586],[0.84457,-0.46997,0.25659],[-0.85437,-0.49891,0.14541],[-0.42876,-0.20572,0.87968],[0.098141,0.35898,0.92817],[0.92176,0.20409,-0.3297],[0.915,0.39844,-0.063348],[0.8826,-0.47005,0.0082445],[0.73899,-0.0096575,-0.67365],[0.60586,-0.62325,0.49446],[0.85335,-0.46109,0.24327],[0.93395,0.30433,-0.1874],[0.42247,0.52421,0.73941],[-0.9298,0.20461,0.30595],[-0.68981,0.44131,0.57393],[-0.48946,-0.64537,0.58646],[0.82892,0.29183,-0.47721],[0.79324,-0.54106,0.27932],[-0.72241,0.53007,0.44402],[0.14338,0.83679,0.52842],[-0.59555,0.40183,-0.69559],[0.31107,-0.03545,0.94973],[-0.82582,-0.55417,0.10449],[0.86182,0.018637,0.50687],[-0.73902,-0.67368,-0.0011374],[0.51316,-0.34715,0.78495],[0.7746,-0.60314,0.19033],[-0.46123,0.71513,0.52522],[0.31038,0.85765,0.40999],[-0.41129,0.13598,0.90131],[-0.359,0.1076,0.92712],[-0.57474,0.44258,-0.68833],[-0.76276,-0.63777,0.10695],[-0.87371,0.47612,0.099671],[0.80414,-0.56808,-0.17505],[-0.73844,-0.67235,-0.051489],[0.47833,-0.41185,-0.77562],[0.77072,0.49435,-0.40199],[-0.14515,-0.97865,-0.14554],[0.77043,0.014786,0.63735],[-0.71038,-0.45914,-0.53343],[-0.44348,0.39073,-0.80663],[0.7826,-0.62111,-0.042035],[-0.68129,-0.71912,-0.1368],[0.27672,-0.54992,0.78804],[0.27944,-0.91203,0.30018],[0.82123,-0.51688,-0.24171],[0.72544,0.50858,-0.46378],[-0.55074,0.42357,-0.71922],[0.81305,-0.58037,-0.046113],[-0.79571,-0.57777,0.18174],[-0.4973,-0.14422,0.85551],[0.54391,-0.42881,0.72131],[0.7809,-0.54207,-0.3104],[-0.48142,-0.79444,-0.37026],[-0.49416,0.53412,-0.68595],[-0.22738,0.15557,-0.9613],[0.69153,-0.67459,-0.25828],[-0.41366,-0.83741,-0.35727],[-0.731,-0.18034,0.65811],[0.56757,-0.52633,-0.63313],[0.60184,-0.19707,0.77392],[-0.31742,0.45526,-0.83186],[-0.0044804,0.14741,-0.98907],[0.69514,-0.54901,-0.46407],[0.28333,-0.032711,-0.95846],[-0.82229,-0.55371,0.13132],[-0.14182,0.35394,-0.92445],[-0.39428,0.6289,-0.6701],[0.086874,0.17629,-0.9805],[0.80948,-0.58623,0.03285],[-0.48186,-0.70331,0.52265],[-0.63137,-0.36094,0.68636],[-0.18934,-0.78387,-0.59135],[0.88545,-0.44932,-0.11875],[-0.99272,0.019908,-0.11879],[0.46056,-0.6446,0.61022],[-0.034147,-0.57874,-0.81479],[0.12583,0.19019,-0.97365],[-0.041495,-0.89434,0.44546],[0.55804,-0.82238,-0.11083],[0.36418,-0.50535,-0.7823],[-0.6954,-0.69218,-0.19312],[-0.30788,-0.83096,-0.46339],[0.71057,0.010693,-0.70354],[-0.87768,-0.1739,-0.44659],[-0.87278,0.21365,0.43886],[-0.74279,-0.078775,0.66487],[0.5377,-0.41657,0.73304],[0.55923,0.66125,-0.50001],[-0.30662,0.347,0.88633],[-0.77416,0.37423,0.51052],[-0.488,0.30055,0.81946],[-0.1809,-0.47306,0.86226],[-0.70903,0.57414,0.40943],[-0.8633,-0.11881,0.49051],[0.17328,0.60205,0.77943],[0.080007,-0.85266,0.5163],[-0.1435,0.96998,0.19631],[-0.0080057,0.99988,-0.012994],[-0.24709,-0.83109,0.49823],[-0.08508,-0.8653,0.49398],[0.36648,-0.84794,0.383],[0.39418,-0.81374,0.42714],[-0.13322,-0.98108,-0.14048],[-0.69648,-0.15147,0.70141],[-0.64069,-0.5882,0.4935],[-0.079472,-0.43546,0.89669],[0.092668,-0.93507,-0.34214],[0.10569,-0.90151,-0.41965],[-0.92062,0.18376,0.3445],[-0.70102,-0.26552,0.66187],[0.48042,-0.47669,0.73618],[-0.56347,-0.47609,0.67516],[-0.16258,-0.85783,-0.48754],[0.42544,-0.56548,-0.70656],[0.54869,-0.45078,-0.70409],[-0.44022,-0.66949,0.59833],[-0.40101,-0.75798,0.51444],[0.44328,-0.69678,0.56392],[0.42064,-0.67788,0.60295],[0.97471,-0.17262,0.1419],[-0.40036,-0.79507,-0.4556],[0.38627,0.057611,0.92058],[-0.59635,-0.49081,0.6352],[0.77737,-0.034105,-0.62811],[-0.29383,-0.88024,0.37262],[-0.84911,-0.15236,-0.50576],[0.90364,-0.35729,0.23617],[0.32418,-0.60114,0.73043],[-0.61108,0.53809,0.58056],[-0.49989,-0.85234,-0.15372],[0.83789,0.40679,-0.36394],[-0.17639,0.61305,0.7701],[-0.82175,-0.5694,-0.022783],[0.85517,0.21065,0.47362],[-0.52862,-0.84274,-0.10173],[0.87354,0.3495,0.3388],[-0.85423,0.32529,0.40556],[-0.04055,0.22682,0.97309],[-0.50053,-0.80929,-0.30744],[-0.19612,-0.94255,0.27044],[0.85694,0.45261,-0.24657],[0.7451,-0.55208,0.37422],[0.023346,-0.99972,-0.0043897],[0.03539,-0.99935,0.0061219],[-0.79071,-0.46988,0.39242],[0.89268,-0.44937,0.034598],[0.53086,-0.45341,-0.71597],[0.6066,-0.52146,-0.6001],[-0.79695,-0.48036,-0.36622],[-0.98991,-0.13237,0.050552],[0.24032,-0.94841,-0.20679],[0.908,-0.39451,-0.14106],[0.64626,-0.56913,-0.50837],[-0.81628,-0.43752,0.37718],[0.16554,-0.97296,0.1611],[0.90591,-0.33641,-0.25719],[0.81417,-0.24683,-0.52556],[-0.88038,-0.43941,0.17844],[-0.86203,-0.40256,0.30797],[0.21002,-0.96133,-0.17815],[-0.94146,-0.32236,-0.098721],[0.81526,-0.014948,-0.5789],[0.42186,0.52084,0.74213],[-0.60644,-0.35361,0.71217],[0.82549,0.36877,0.42729],[-0.949,-0.11064,-0.29524],[0.83982,-0.061102,-0.53942],[-0.79373,0.48437,0.36794],[0.81923,0.40055,0.4104],[-0.99019,-0.1007,-0.096847],[-0.85721,-0.11896,-0.50103],[0.92907,-0.23944,-0.28196],[-0.98187,0.077998,-0.17278],[0.85579,-0.15644,-0.4931],[0.36279,-0.80566,0.4683],[-0.056835,-0.80631,0.58876],[-0.86636,0.42763,-0.25796],[0.74155,0.5202,0.42365],[0.60841,-0.38921,-0.69163],[-0.43559,-0.89723,-0.072449],[-0.38053,-0.92235,-0.06678],[0.042717,-0.85597,0.51526],[-0.18237,-0.23153,0.95558],[-0.31569,-0.095145,0.94408],[-0.60511,-0.74093,-0.29132],[0.91811,0.010981,-0.39618],[0.70867,0.70248,0.065579],[-0.70637,-0.53097,-0.46809],[0.82797,-0.028736,-0.56004],[-0.053776,-0.35234,0.93432],[-0.68086,-0.34448,-0.64635],[-0.74639,-0.16131,-0.64566],[-0.95065,0.19394,-0.24217],[0.81041,-0.045246,-0.58411],[0.85986,-0.070535,-0.50563],[-0.52657,-0.22997,-0.81843],[0.7549,-0.30455,-0.58084],[-0.41716,-0.041825,0.90787],[0.8861,-0.15632,-0.43633],[-0.3846,0.87611,0.29071],[0.11702,-0.94079,-0.31814],[0.00029504,-0.34366,0.93909],[0.58206,0.0077193,0.81311],[-0.8117,-0.16713,0.55965],[0.24459,-0.96003,0.13612],[0.063084,-0.74587,0.6631],[-0.25997,-0.92318,-0.28311],[-0.083223,-0.99612,0.028778],[0.10361,-0.89721,-0.42927],[-0.19046,-0.94508,-0.26561],[0.47686,-0.86334,0.16504],[-0.68534,-0.51537,-0.5145],[-0.072541,-0.99608,0.050589],[-0.83836,0.47076,0.27485],[-0.87373,0.45873,-0.16174],[0.77874,-0.41136,-0.47365],[-0.38326,-0.5274,-0.75826],[0.19001,-0.80669,0.5596],[0.30568,0.56174,0.76877],[0.23847,-0.72568,0.64539],[-0.8657,0.48294,-0.13165],[0.84112,0.0065726,-0.54081],[0.017428,-0.32964,0.94395],[0.91487,0.029824,-0.40264],[0.74426,-0.66787,0.0057847],[0.32473,-0.87667,0.35498],[0.21512,-0.052035,0.9752],[-0.67107,-0.28865,-0.68289],[0.64867,-0.757,0.07862],[0.68254,-0.44074,0.58299],[-0.93279,0.27868,-0.22856],[0.72322,-0.36291,-0.58759],[-0.12299,-0.99118,0.049294],[0.9843,-0.0040964,-0.17645],[-0.78843,-0.095356,-0.60769],[-0.23373,-0.48723,-0.84141],[0.43551,-0.59592,-0.67469],[0.26984,-0.80037,-0.53534],[0.1913,-0.77431,-0.60319],[0.35917,-0.62155,0.69618],[0.99698,-0.020978,0.074802],[0.69598,-0.71673,0.043662],[0.95155,0.1101,0.2871],[0.18978,-0.68913,0.69935],[0.65325,-0.42821,-0.62443],[0.64085,0.28493,0.71283],[0.99499,0.038106,0.092479],[-0.95837,0.24938,-0.13908],[0.84928,0.15609,-0.50435],[-0.20207,-0.52833,-0.82464],[0.94784,-0.29516,0.12032],[-0.78144,0.18687,-0.59535],[0.99671,-0.067172,0.045288],[0.90966,0.41524,0.0095319],[-0.72169,0.63771,-0.26925],[-0.20924,0.13502,0.9685],[-0.25333,-0.96007,0.11868],[0.8144,0.57114,-0.10272],[0.087383,-0.41501,-0.90561],[-0.83727,-0.16242,-0.52211],[-0.71692,0.66663,-0.20406],[-0.85337,0.43777,-0.28306],[0.78073,0.32846,0.53158],[-0.1025,-0.037325,0.99403],[0.73681,0.67314,-0.063189],[-0.90461,0.013415,-0.42602],[0.86515,-0.50142,-0.009566],[0.91989,-0.35775,-0.16067],[0.992,0.028567,0.12296],[-0.83917,0.4498,-0.30575],[0.71676,0.64852,-0.25629],[-0.21217,-0.67344,0.70813],[0.97095,0.024148,-0.23808],[-0.74537,0.58737,-0.31531],[-0.44606,-0.78355,-0.43252],[-0.17346,0.24588,0.95365],[0.72227,-0.067466,0.68831],[-0.62798,0.76641,-0.13514],[0.73689,-0.29908,0.60625],[0.70456,0.69242,-0.15542],[-0.79709,0.45976,0.39151],[0.91778,0.35589,0.17615],[-0.37534,0.91973,-0.11493],[-0.46756,0.87636,-0.11563],[0.081614,0.98992,-0.11572],[0.25433,0.95125,-0.1745],[-0.88042,0.3092,-0.35952],[-0.55474,-0.52132,-0.64845],[-0.83331,-0.17822,-0.52329],[0.63472,-0.7352,-0.23795],[0.74053,-0.49444,-0.45513],[-0.68758,0.46827,-0.55494],[0.79752,0.13344,0.58835],[-0.24806,0.61088,0.75186],[-0.57816,-0.43932,0.68756],[-0.17148,-0.63209,-0.75568],[0.71322,0.13784,0.68726],[0.34868,0.86397,-0.3633],[-0.50709,0.85661,-0.095279],[0.26489,0.95619,-0.12464],[-0.17111,-0.90034,0.40013],[0.5733,-0.69311,0.43696],[-0.36386,-0.91417,-0.17859],[0.28019,0.94071,-0.19123],[0.3894,0.8901,-0.23684],[0.11632,0.16778,0.97894],[-0.23618,0.93818,-0.25306],[-0.1206,0.98175,-0.14705],[-0.32175,-0.78959,0.52251],[0.0022433,0.99981,-0.019603],[0.2008,0.97107,-0.12923],[-0.60059,-0.089356,-0.79455],[-0.82427,0.032493,0.56527],[0.99493,-0.094585,0.034275],[0.26997,0.24314,0.93166],[-0.67317,-0.2623,-0.6914],[-0.76085,-0.27995,-0.58544],[-0.63405,-0.16791,-0.75484],[0.5039,0.081035,-0.85995],[-0.82784,-0.23055,-0.5114],[0.92735,0.19613,0.31869],[-0.64671,0.06064,-0.76032],[0.40223,0.2858,-0.86978],[0.055535,-0.99656,0.061474],[-0.51643,0.30437,-0.80041],[-0.11336,0.77529,-0.62135],[0.95869,-0.20603,0.19615],[-0.86325,-0.24103,-0.44351],[0.7481,0.50746,0.42759],[-0.61561,0.518,0.59389],[0.7105,-0.35264,0.60896],[0.33128,0.83636,-0.43675],[-0.063433,-0.54819,-0.83395],[-0.090556,0.17386,0.9806],[-0.90687,-0.23533,-0.34959],[0.81349,0.48572,0.31987],[0.05097,0.17901,0.98253],[-0.17556,0.63314,-0.75386],[-0.19956,0.78589,-0.58528],[-0.074048,0.83103,-0.55127],[-0.37961,-0.30616,0.87302],[0.22324,0.8039,-0.55129],[-0.78129,-0.27089,0.56232],[-0.6956,0.089857,0.71278],[-0.95835,-0.16526,-0.23291],[0.097611,-0.99224,0.077079],[0.54026,-0.63958,0.54686],[-0.26482,0.8342,-0.48372],[0.79476,0.14816,0.58857],[0.25074,-0.36477,-0.8967],[-0.99321,-0.070803,-0.092284],[0.84115,0.47559,0.25745],[-0.82402,-0.069018,0.56234],[0.51803,-0.29515,-0.80283],[-0.99808,-0.061954,-0.0025365],[0.58557,-0.20001,0.78556],[-0.59434,-0.76637,-0.24382],[-0.40493,-0.72502,0.55712],[0.83961,0.5308,0.11536],[0.98053,0.16176,-0.11137],[-0.33434,-0.22632,0.91488],[0.94723,0.20277,-0.24829],[-0.63967,-0.37374,-0.67167],[0.89547,0.42547,-0.13081],[-0.52636,-0.41297,-0.74323],[-0.0055824,0.26825,0.96333],[0.40439,-0.54139,-0.73713],[0.91545,-0.33317,-0.22571],[-0.75279,0.10286,-0.65017],[0.8595,0.49675,-0.1204],[-0.019508,0.21353,0.97674],[0.80442,0.55306,-0.21686],[-0.73875,-0.10334,-0.66601],[0.7083,0.47203,0.52488],[0.93954,-0.28956,0.18281],[-0.43473,-0.58275,-0.6866],[-0.36278,-0.15337,0.91917],[0.40406,-0.48307,-0.77678],[0.93969,-0.29368,0.17529],[0.11117,-0.99066,0.078906],[-0.75373,-0.03284,-0.65637],[0.66844,0.2029,-0.71556],[-0.68134,0.020604,-0.73168],[0.55047,-0.4039,-0.73065],[-0.11255,-0.59347,-0.79695],[-0.75212,-0.33692,-0.56639],[-0.89873,0.42183,0.11972],[0.97053,0.24094,-0.0051701],[-0.95387,-0.29954,0.020341],[-0.067851,0.11371,0.99119],[0.87499,-0.37935,-0.30081],[0.64699,-0.034141,0.76174],[0.88271,-0.28578,0.37303],[0.53605,0.68285,0.49636],[0.054876,0.24562,0.96781],[0.76105,-0.16733,-0.62674],[-0.63878,0.20392,-0.74188],[0.081748,0.21231,0.97378],[-0.85363,-0.41944,-0.30883],[-0.34151,-0.71304,0.61233],[0.37313,0.92759,0.018857],[-0.79287,0.053832,0.60701],[0.26313,0.9154,0.30463],[-0.89638,0.3323,0.2934],[0.76258,-0.00099121,-0.64689],[0.84738,0.36922,-0.38161],[-0.89943,-0.11538,0.42156],[-0.14798,-0.98332,0.10573],[-0.61202,0.37179,-0.698],[-0.86917,0.39333,0.29972],[-0.99165,-0.1287,0.0083581],[-0.18881,-0.96564,-0.17859],[-0.59114,0.40094,-0.69985],[0.82452,0.12978,-0.55076],[-0.92121,0.27433,0.2759],[0.67241,0.064087,0.7374],[-0.14243,-0.14742,0.97877],[0.86158,0.40646,0.30408],[-0.091406,-0.6535,0.75139],[0.81109,-0.45541,0.36707],[0.45053,0.34567,0.82313],[0.71619,0.17464,0.67571],[-0.5691,-0.68388,0.45655],[0.72264,0.67341,0.1559],[0.0095022,-0.66923,0.74299],[-0.019152,-0.064432,0.99774],[0.75567,-0.6199,0.21139],[0.44489,0.82626,0.34549],[0.5542,-0.71627,0.42405],[0.48426,0.80548,0.3416],[-0.7648,-0.2608,0.58912],[-0.41791,-0.39111,-0.81999],[0.59448,-0.040463,0.80309],[0.87629,0.37923,0.29716],[-0.27078,0.80077,0.53427],[-0.0162,0.85361,0.52066],[0.81144,0.46344,-0.35608],[0.42885,-0.55815,0.71032],[-0.75621,0.39779,0.51953],[-0.039898,0.43584,0.89914],[0.037305,-0.060501,0.99747],[0.70689,-0.56869,0.42058],[-0.54317,0.423,-0.72529],[0.032752,-0.27702,0.96031],[0.059013,-0.42542,0.90307],[0.749,-0.58564,0.30988],[0.58789,-0.64029,0.49438],[-0.5198,0.024909,0.85392],[0.65677,0.35201,0.66689],[-0.61464,-0.74582,-0.25686],[0.4649,-0.57487,-0.67334],[0.14844,-0.74935,0.64533],[-0.24246,-0.90772,0.34244],[-0.44337,-0.75524,-0.48274],[0.68568,0.53143,-0.49741],[-0.53389,0.44996,-0.71589],[-0.93569,-0.18649,0.29952],[0.70305,-0.67754,0.21602],[0.96487,-0.2094,0.15866],[0.10345,0.24549,0.96386],[0.88621,0.4116,0.21266],[-0.61068,-0.68273,0.40119],[-0.80748,0.57446,-0.13403],[0.69506,-0.71867,0.01994],[-0.77167,0.072017,0.63193],[-0.3319,-0.80487,-0.49196],[-0.48311,0.56846,-0.66593],[-0.19591,-0.73175,-0.65281],[0.68123,0.082448,0.72741],[-0.42964,0.64767,-0.62923],[0.39084,-0.71047,0.58522],[-0.083392,-0.99373,-0.074502],[-0.72541,-0.56338,-0.39546],[0.75453,-0.3566,-0.55092],[-0.31822,0.29063,0.90237],[0.6704,0.6106,-0.42158],[0.17738,-0.80664,0.5638],[0.5904,-0.80378,-0.073188],[0.66486,0.18328,0.72414],[0.60768,-0.69568,-0.38308],[-0.90635,0.22885,0.35519],[-0.82298,0.15664,0.54604],[0.6111,0.21905,0.76064],[-0.34205,0.7034,-0.62308],[-0.051681,-0.83656,-0.54543],[-0.19283,0.54932,-0.81305],[0.22024,0.20362,-0.95396],[0.58493,-0.52934,-0.61454],[0.67103,0.59091,0.44782],[-0.1637,-0.95043,-0.26437],[0.15309,0.38885,-0.90849],[0.49596,-0.34095,-0.7986],[-0.074483,-0.50677,0.85886],[-0.77427,0.55609,0.30212],[0.54913,0.77325,-0.31707],[-0.24514,0.70541,-0.66506],[-0.10163,0.71285,-0.69392],[-0.54997,0.075103,0.8318],[-0.7634,0.30801,0.56776],[0.0053145,-0.99205,-0.12571],[-0.048253,-0.40433,0.91334],[0.35594,0.91361,-0.19653],[-0.30949,0.86475,0.39551],[0.15113,0.98628,-0.066356],[-0.057229,-0.99594,0.069458],[0.68222,-0.11229,0.72248],[-0.077486,-0.99517,-0.06024],[0.67242,0.54398,0.50194],[0.91864,-0.39248,-0.045474],[-0.25293,-0.8432,0.47439],[-0.35739,0.89147,0.27848],[0.42344,-0.54963,0.72014],[0.12524,-0.90603,0.40426],[0.39093,0.046884,0.91923],[-0.15798,-0.96118,-0.22621],[-0.14438,-0.96638,-0.21275],[-0.032335,-0.81589,-0.57731],[-0.014449,-0.81054,-0.58551],[0.29471,-0.67499,-0.67642],[0.10929,-0.76158,-0.63879],[-0.00061887,-0.97018,0.24238],[0.58988,-0.53389,-0.60581],[-0.42021,-0.77957,0.46443],[0.49188,-0.71489,0.49698],[-0.43153,-0.79995,-0.41697],[-0.30861,-0.8561,-0.41456],[-0.37167,0.34926,0.86016],[0.023833,-0.32365,0.94587],[-0.40443,-0.43942,-0.80209],[0.7486,0.062582,0.66007],[0.70211,0.39085,0.59521],[-0.015592,-0.44287,0.89645],[-0.72266,-0.37795,0.57871],[-0.64022,0.57629,0.50795],[-0.55204,0.41541,0.72297],[-0.0030072,-0.45877,0.88855],[0.033762,-0.52982,0.84744],[-0.53562,-0.84417,0.022042],[-0.63811,-0.55471,0.53396],[0.60475,-0.43664,0.66605],[0.67548,0.18584,0.71357],[-0.7758,-0.36102,0.51749],[0.070458,-0.574,0.81582],[-0.4912,-0.87105,-0.0020636],[0.8706,0.49181,0.013282],[0.88974,0.28216,-0.35881],[0.65599,-0.54036,0.52696],[-0.24472,0.39878,0.88379],[-0.67281,-0.72451,-0.14971],[0.2096,-0.58062,-0.78673],[0.92062,0.12488,-0.36996],[0.43124,-0.47546,-0.76679],[0.68774,-0.56764,0.45254],[-0.78467,-0.59666,-0.16823],[0.86414,-0.16937,-0.47389],[0.70806,-0.50254,-0.49608],[0.82157,-0.55035,0.14878],[-0.99027,0.11881,-0.072432],[0.59331,-0.57669,-0.56162],[0.54071,0.43505,0.71997],[0.12879,-0.65467,0.74486],[0.89637,-0.44167,-0.037961],[-0.90931,-0.34288,-0.23577],[-0.78857,-0.46533,0.40204],[0.87737,0.093913,0.47054],[-0.80803,0.20132,0.55367],[0.51383,0.2696,0.81443],[0.91702,-0.39081,-0.07968],[-0.9306,-0.31516,-0.18614],[0.31982,-0.82839,0.45988],[0.76563,-0.25804,-0.58926],[-0.79327,-0.52174,0.31386],[-0.14601,0.34818,0.92599],[0.92427,-0.18728,-0.33265],[-0.81762,-0.45952,-0.34688],[-0.088667,-0.56819,0.81811],[0.024203,0.30767,0.95118],[0.50125,0.4266,0.75283],[-0.89563,-0.42692,0.12484],[-0.90107,-0.32716,-0.28468],[-0.96921,-0.16867,-0.17943],[0.57086,-0.23483,0.78675],[0.54745,-0.57675,0.60635],[0.87191,-0.060435,-0.48593],[0.57711,0.61082,0.54207],[-0.99903,0.010629,-0.042845],[0.80494,-0.038145,0.59213],[-0.94112,-0.25099,-0.22647],[0.88019,-0.35191,-0.31847],[-0.98585,-0.051901,-0.15937],[0.81429,-0.27302,-0.51224],[-0.047586,-0.16714,-0.98478],[0.56755,-0.80036,0.19314],[0.76998,0.36173,0.52563],[-0.64941,0.33184,0.68421],[-0.022242,-0.33438,-0.94217],[-0.45095,-0.89042,-0.061663],[-0.098713,-0.44291,0.89111],[0.65518,-0.75319,0.05866],[-0.17623,-0.010065,-0.9843],[0.22541,-0.11262,-0.96773],[0.40375,0.86592,0.29525],[-0.93985,-0.12294,-0.31869],[-0.7049,0.35825,0.61219],[-0.45758,-0.88795,-0.046447],[0.91917,-0.30993,-0.24305],[0.21435,-0.95408,0.20925],[-0.57861,0.25804,0.77371],[0.019884,0.24769,-0.96864],[0.29455,-0.0036368,-0.95563],[0.6642,0.61268,0.42832],[0.84785,-0.052199,-0.52766],[-0.27788,0.29701,0.91355],[-0.35357,0.40502,-0.84318],[-0.37191,-0.60345,-0.70536],[-0.94723,-0.0096129,-0.32041],[-0.73593,-0.44893,-0.50683],[0.55096,0.70476,0.44694],[-0.93583,0.17806,-0.30416],[-0.79242,0.098457,-0.60198],[0.87373,0.15826,-0.45995],[-0.72336,0.16766,-0.6698],[0.24371,-0.93512,0.25721],[-0.336,-0.5754,0.74567],[0.89878,0.31118,0.30882],[-0.19797,-0.75847,-0.62091],[0.086932,-0.84312,-0.53065],[-0.51425,0.83954,-0.17525],[-0.012587,-0.9994,-0.032313],[0.38186,-0.0086207,0.92418],[-0.91325,0.2975,-0.27832],[0.86967,0.11372,-0.48035],[0.46961,0.76984,0.43222],[-0.9379,0.24416,0.24645],[-0.46877,-0.72944,-0.49817],[-0.51544,0.35274,0.78096],[0.45771,0.62221,0.6351],[0.74785,-0.6575,0.091752],[0.37494,0.84071,0.39068],[-0.5805,0.58934,0.56187],[0.69861,0.52328,0.48798],[-0.87165,0.44954,-0.19532],[-0.6782,0.71884,0.1527],[-0.60507,0.1888,-0.77346],[0.58636,0.56932,0.57624],[0.87213,0.16455,-0.46076],[0.56062,0.54493,0.6235],[-0.4799,0.58703,0.65199],[-0.98946,0.14399,0.015443],[-0.99411,-0.10482,-0.027505],[-0.18399,0.49853,0.84712],[-0.94136,0.25972,-0.21539],[-0.62139,0.16116,-0.76675],[-0.62632,0.17513,-0.75964],[0.3457,-0.91845,0.19221],[0.41827,0.10259,0.90251],[0.50375,-0.59679,-0.62456],[0.4692,-0.3615,0.80571],[0.6625,0.74193,0.1031],[0.55652,0.66827,0.49366],[-0.28,-0.27691,-0.9192],[0.64769,0.63728,0.41757],[0.77036,-0.20353,-0.60425],[-0.67664,-0.0045815,0.7363],[-0.80957,-0.071995,-0.58259],[0.89869,-0.35618,0.2559],[-0.89454,0.44246,-0.063389],[-0.45694,0.59353,0.66252],[0.81609,0.46432,-0.3441],[-0.93519,-0.23481,-0.26511],[-0.71698,0.25368,-0.64929],[0.75521,0.58925,-0.28714],[-0.56095,-0.82583,-0.057815],[0.14078,-0.46236,0.87544],[0.95456,-0.24059,0.17589],[-0.72597,0.35781,0.58731],[0.61958,0.7826,-0.060475],[-0.10734,-0.99355,0.036579],[0.24693,0.82228,0.51272],[0.22983,-0.42653,0.87478],[-0.31232,-0.94926,-0.036933],[0.62309,0.63922,0.45073],[0.012079,0.4364,0.89967],[-0.94168,-0.022868,-0.33575],[0.67566,-0.28401,-0.68031],[0.62651,0.77681,-0.063622],[0.97005,0.21372,0.11543],[0.47192,0.63168,0.61504],[0.37969,0.92497,-0.01629],[-0.92753,0.1176,-0.35478],[0.77811,0.49404,-0.38791],[0.12078,0.84875,0.51482],[0.099848,0.89165,0.44158],[0.41558,0.86025,-0.29541],[0.24024,0.96443,0.11023],[0.53077,0.84322,-0.085283],[-0.75277,-0.43841,0.49106],[0.40575,-0.90754,0.1083],[-0.59027,0.80277,0.08445],[0.79373,0.52326,0.31016],[-0.015256,-0.99945,-0.029455],[0.4321,0.68837,-0.58262],[-0.22438,-0.36764,0.90249],[0.94163,0.3335,0.045929],[-0.62927,0.43642,0.64309],[0.4518,-0.88762,0.089453],[0.66448,0.21474,-0.71579],[0.98771,0.10777,0.11317],[-0.24398,0.96961,0.018209],[-0.08039,0.99604,-0.037896],[0.24519,0.96442,-0.098841],[0.5329,0.53985,0.6516],[-0.70444,0.09813,-0.70295],[0.65434,-0.23319,-0.71935],[0.30099,0.43726,0.84747],[0.75946,0.52185,0.38846],[-0.6921,-0.27519,-0.66728],[0.58871,-0.21962,-0.77794],[0.63137,-0.2931,-0.71796],[-0.46082,-0.41736,-0.78323],[0.96061,0.25074,0.11987],[-0.73188,-0.018079,-0.6812],[0.52939,0.063658,-0.84599],[0.17228,-0.98372,-0.051158],[0.78006,0.38336,0.49452],[-0.22386,0.94656,0.23218],[0.39709,0.41672,-0.81772],[-0.20797,-0.50958,-0.83491],[-0.66316,0.23605,-0.71028],[-0.93156,0.33267,0.14674],[-0.88409,0.43655,0.16674],[0.75683,-0.65345,-0.014447],[-0.23785,0.70641,-0.66665],[0.030652,0.69787,-0.71557],[0.27679,0.60933,-0.74303],[-0.13931,0.41196,0.90049],[0.36194,-0.27917,0.88942],[-0.43041,0.46728,-0.77227],[0.22158,-0.9736,0.054763],[0.26687,0.75286,-0.60166],[-0.12995,0.7812,-0.61061],[0.028253,0.8627,-0.50492],[0.2672,0.85409,-0.44625],[0.26504,-0.95957,0.094768],[-0.84527,0.49294,0.20623],[0.82595,0.47084,0.31001],[-0.93921,0.090913,0.33108],[0.11119,0.75534,-0.64583],[-0.38123,0.88685,0.26107],[-0.22284,0.84216,-0.49103],[0.86674,0.49591,0.053199],[-0.84256,0.53794,-0.026776],[0.24227,0.77055,-0.58954],[-0.12111,0.83374,-0.53871],[-0.19865,-0.20086,0.95927],[0.27588,0.74165,-0.61143],[0.27349,0.84684,-0.45614],[-0.71462,0.66808,0.20732],[0.19124,0.77708,-0.59964],[-0.98328,-0.031685,-0.17934],[0.98187,0.17247,-0.078687],[-0.41917,0.58652,0.69303],[-0.64705,-0.41555,-0.63926],[0.96682,0.25027,0.051123],[-0.061248,-0.6431,-0.76333],[0.77861,0.61125,-0.14193],[-0.72207,-0.28993,-0.62813],[0.80227,0.30681,0.51208],[-0.61722,-0.35951,-0.69985],[0.97401,-0.22285,-0.040529],[-0.71935,-0.20698,-0.6631],[-0.75872,-0.21748,-0.61405],[0.98806,-0.083309,0.1296],[0.30511,-0.94413,0.12462],[-0.77908,0.58195,-0.23319],[0.14146,-0.90976,-0.39029],[-0.43591,-0.40366,-0.80439],[-0.75999,-0.52291,-0.38598],[0.76627,0.63579,-0.092767],[-0.84197,-0.44564,-0.30413],[0.66118,0.0926,0.74449],[0.64539,0.6187,0.44798],[0.1625,-0.97976,-0.11691],[-0.96353,-0.26682,0.020607],[-0.27996,-0.11629,0.95294],[-0.91645,-0.2843,-0.2816],[0.89513,-0.42051,-0.14805],[-0.7724,-0.094738,-0.62804],[0.85012,-0.26646,0.4542],[0.42752,0.87726,0.21827],[0.61505,0.78698,0.048755],[-0.14184,0.47205,0.87009],[-0.81147,-0.0035754,0.58438],[-0.65205,0.46839,0.59618],[0.87426,-0.23945,0.42229],[0.66377,0.70846,-0.23976],[0.5274,0.70875,0.46854],[-0.63546,-0.59189,0.49583],[-0.73952,0.62132,-0.25897],[0.67348,-0.32653,-0.66318],[-0.91322,-0.26094,-0.31294],[0.51273,-0.73007,0.45178],[0.8617,-0.30542,0.40521],[-0.96536,-0.23712,-0.10889],[0.6906,0.71015,-0.13699],[0.45538,0.80788,0.37412],[-0.91531,-0.34942,0.2003],[0.32169,0.77978,0.53709],[0.060663,-0.99779,0.027239],[-0.92245,-0.38234,0.053802],[0.65585,-0.53107,0.5365],[-0.73972,0.65019,-0.17341],[0.74273,0.64658,-0.17405],[-0.65275,0.57598,0.4921],[0.83939,-0.40546,0.36197],[0.44904,0.61528,0.64791],[0.91342,0.36142,-0.1872],[0.80566,0.095117,-0.58469],[-0.041473,-0.33887,0.93992],[0.27553,-0.44376,0.85274],[-0.97135,0.16577,0.17026],[-0.82958,-0.55837,0.003641],[0.958,-0.12748,0.25688],[0.048474,-0.3802,0.92363],[0.85929,0.51149,-0.00070905],[0.85688,0.27622,-0.43526],[-0.60982,0.40168,-0.68321],[0.79303,-0.56411,0.22997],[0.038127,-0.62878,-0.77665],[-0.67017,0.59619,0.44206],[-0.55203,0.63201,0.5439],[0.013678,-0.9999,-0.0017681],[-0.35931,0.0935,0.92852],[-0.75283,-0.65417,-0.072821],[0.77976,-0.56114,0.27765],[-0.40368,0.21146,0.89013],[0.18729,0.8692,0.45761],[-0.046137,0.39184,0.91888],[0.8471,0.41105,-0.33682],[-0.56319,0.39728,-0.72456],[0.80422,0.56328,-0.18959],[-0.69437,-0.70409,-0.14872],[-0.94419,0.2619,0.19979],[-0.4739,-0.81065,0.34389],[0.74338,-0.21,0.63504],[0.47323,-0.62423,-0.6216],[0.76805,-0.58545,0.2595],[-0.074805,-0.9952,-0.063175],[0.71959,0.65912,-0.21852],[0.70755,-0.58877,0.3908],[-0.61164,-0.73664,-0.28855],[0.81186,0.50145,-0.29907],[0.53479,0.66479,0.5216],[-0.4708,-0.78951,0.39372],[-0.41386,-0.15504,0.89704],[-0.96568,-0.1944,-0.17223],[0.78359,0.51261,-0.35103],[-0.55227,0.42376,-0.71793],[0.50702,0.77696,-0.37319],[0.23582,-0.18735,0.95357],[-0.5162,-0.75173,-0.41042],[-0.33693,-0.76593,-0.54757],[0.51232,-0.45523,-0.72822],[0.74682,0.54696,-0.37828],[-0.53336,0.46715,-0.7052],[0.71359,-0.67422,0.19034],[0.64948,-0.72875,0.21701],[-0.29927,0.93524,0.18913],[-0.046616,-0.99878,-0.016312],[0.33995,-0.45986,0.82034],[-0.37071,-0.72879,-0.57572],[-0.52494,0.30825,0.79336],[-0.082306,-0.69137,-0.71779],[-0.57796,0.78447,-0.22488],[0.65177,0.75057,0.1088],[-0.20154,-0.76139,-0.61617],[0.94774,0.31205,0.06637],[-0.96874,0.20837,0.13465],[0.59163,0.53158,-0.60613],[-0.67404,-0.62291,-0.39704],[-0.47002,0.64107,-0.60672],[-0.90964,0.097944,0.40368],[-0.35589,-0.38048,0.85357],[0.95178,0.28721,0.10778],[0.5628,-0.82606,-0.02982],[-0.52552,0.8274,-0.19808],[-0.86555,0.22393,0.44798],[0.68387,0.6798,-0.26495],[-0.54367,0.75151,0.37371],[-0.56085,0.63221,0.53457],[-0.54306,0.61754,0.56897],[-0.67468,0.7345,0.072894],[0.49277,-0.85558,-0.1586],[0.66811,-0.50773,-0.54391],[-0.33387,0.70425,-0.62655],[0.28916,0.34654,-0.89235],[0.76068,0.39951,0.51162],[0.68095,-0.20252,-0.70377],[0.38938,-0.22369,0.8935],[-0.92926,-0.21748,0.29862],[-0.2047,0.77605,-0.59653],[0.86985,0.4876,0.074901],[0.56162,0.071347,-0.82432],[0.71975,0.062569,0.69141],[0.47308,0.85203,-0.22416],[-0.49134,0.71528,0.49696],[0.41271,0.89713,-0.15757],[-0.002738,0.98789,0.15513],[0.30442,0.95043,-0.063303],[-0.20401,-0.91906,-0.3372],[-0.054652,-0.82953,-0.55578],[-0.73241,-0.011997,0.68076],[0.67142,0.69946,0.24484],[-0.018718,-0.84198,-0.53918],[0.03402,-0.9048,-0.42447],[0.34218,-0.77439,-0.53219],[-0.19616,-0.97295,0.12202],[0.39839,0.89922,0.18079],[-0.14489,-0.90331,0.40377],[-0.11398,-0.94578,-0.30414],[0.080654,0.35259,0.93229],[0.74085,-0.57788,-0.34235],[0.40296,-0.078154,0.91187],[-0.4584,-0.67911,0.5733],[-0.27528,-0.90473,0.3251],[0.80094,-0.44037,-0.40568],[0.83659,-0.048931,-0.54564],[0.56621,0.82418,-0.012022],[0.79481,-0.17656,-0.5806],[0.86715,0.039419,-0.49649],[-0.853,-0.16987,-0.49349],[0.57414,-0.70052,0.42384],[0.83634,0.52438,-0.15989],[-0.56689,-0.72942,-0.38285],[0.84733,0.35618,-0.3939],[-0.65569,0.59691,0.46236],[-0.52238,-0.64008,0.5634],[-0.73355,0.45181,0.50771],[-0.080602,-0.99583,-0.042838],[-0.4073,-0.24251,0.88051],[0.93076,0.2602,-0.25687],[0.81261,0.50805,-0.28556],[0.46735,-0.632,0.61819],[0.84359,0.50594,-0.17996],[-0.63874,-0.75311,-0.15764],[0.92748,-0.044567,0.3712],[0.72967,0.66948,-0.1392],[-0.5041,-0.86135,-0.062975],[-0.75183,-0.33917,0.56543],[0.84889,-0.32161,-0.41946],[0.82531,0.48735,-0.28524],[-0.61138,0.015781,-0.79118],[-0.66009,-0.64615,0.38311],[0.54219,-0.61064,0.57719],[-0.71105,-0.55892,0.42664],[0.47242,0.71792,0.51128],[0.53988,-0.62629,0.5624],[0.63269,0.77274,-0.050714],[0.64898,-0.61636,-0.44602],[-0.67848,0.73127,-0.07013],[0.58018,-0.65622,0.48245],[-0.11422,-0.98938,-0.089937],[-0.91011,-0.41412,-0.014193],[0.086033,0.53494,0.8405],[0.72774,-0.4027,-0.55519],[-0.92925,-0.18514,0.31973],[-0.81534,-0.46012,0.35143],[0.83666,-0.0015528,0.54772],[-0.92213,-0.18127,0.34179],[0.9239,-0.38218,0.018758],[-0.81235,-0.44777,-0.3736],[0.87669,-0.23256,-0.42109],[0.79117,-0.25429,-0.55622],[-0.9276,0.15412,0.34031],[-0.52335,0.65501,0.54504],[0.94836,-0.14471,-0.28228],[-0.29765,-0.59741,0.74465],[0.90143,-0.021961,-0.43237],[0.45352,0.13424,0.88108],[-0.20527,-0.37644,-0.90341],[0.77272,0.24988,0.58349],[0.19216,-0.4834,-0.85405],[-0.97548,-0.04357,-0.21571],[0.75644,-0.16828,-0.63205],[-0.85379,0.38154,0.35423],[-0.62239,-0.18732,-0.75996],[0.22688,-0.27131,-0.93537],[-0.65582,-0.0011592,-0.75491],[-0.57361,0.069274,-0.81619],[-0.32171,-0.063034,-0.94474],[0.017984,-0.059533,-0.99806],[0.29316,-0.30374,-0.90653],[-0.61037,0.79055,-0.04983],[0.24663,-0.2285,-0.94179],[0.0052153,-0.20181,-0.97941],[0.035542,-0.1481,-0.98833],[0.14795,-0.1916,0.97026],[-0.79172,-0.60458,-0.08749],[-0.82351,0.24771,-0.51037],[-0.3427,-0.0056675,-0.93943],[-0.18818,-0.1875,0.96407],[0.27079,-0.2182,-0.93758],[-0.64192,0.68549,0.34358],[0.35217,-0.078074,-0.93267],[0.8143,-0.12045,-0.56781],[0.77017,-0.60254,-0.20926],[0.76853,-0.48237,-0.42034],[-0.9932,-0.083067,0.081618],[0.14375,-0.048496,-0.98843],[-0.0011294,0.035529,-0.99937],[0.45392,0.88296,0.11975],[-0.92662,-0.083994,-0.36649],[-0.61199,-0.76346,-0.20639],[-0.56146,0.82658,-0.039024],[0.75458,-0.63477,-0.16635],[-0.58939,0.19669,-0.78354],[-0.73188,0.58602,-0.34776],[0.10961,0.033283,-0.99342],[0.064255,0.06326,-0.99593],[-0.97931,-0.15508,-0.13003],[0.83747,-0.34876,-0.42071],[0.49373,0.86427,0.096308],[0.016819,0.2653,-0.96402],[0.24031,0.070922,-0.9681],[0.074436,0.051575,-0.99589],[0.31305,-0.061396,-0.94775],[-0.69029,-0.63041,-0.35508],[0.80586,-0.069896,-0.58797],[-0.50206,0.57882,-0.64258],[0.96506,0.11909,0.2334],[0.84012,-0.034867,-0.54127],[-0.81765,-0.35112,-0.45625],[-0.58872,0.45905,0.66534],[-0.14668,0.20873,-0.96691],[0.14057,0.059409,-0.98829],[0.97908,0.075831,0.18884],[-0.36198,-0.0024203,0.93218],[-0.86539,-0.1192,-0.48671],[0.74713,-0.00054762,-0.66468],[-0.51609,0.46947,-0.71641],[0.029685,0.18717,-0.98188],[0.049392,0.069891,-0.99633],[0.38254,-0.35207,0.85423],[0.093097,-0.69453,-0.71342],[0.12049,-0.99271,-0.0021846],[0.19562,-0.75588,-0.62481],[0.806,0.59133,-0.026433],[0.80492,0.026759,-0.59278],[-0.2819,-0.25814,-0.92407],[-0.087899,-0.27408,-0.95768],[-0.29624,-0.46834,-0.8324],[-0.23134,-0.53327,-0.8137],[0.8378,-0.24359,-0.48862],[0.096667,-0.89887,-0.42742],[0.3217,-0.93732,-0.13395],[-0.49956,0.65078,0.57177],[-0.8321,0.50906,0.22014],[0.70343,-0.0901,0.70503],[-0.8045,0.13418,-0.57859],[0.98978,-0.076049,-0.12063],[-0.47174,-0.41966,-0.77546],[0.30823,-0.93506,0.17507],[-0.79066,0.17293,-0.58732],[0.69393,0.68873,0.21004],[-0.18199,0.97276,0.14356],[0.6911,-0.71377,0.11361],[-0.95624,-0.26205,0.1301],[0.36318,0.93153,-0.018679],[0.77322,-0.24144,-0.58638],[0.82393,0.56385,-0.056699],[0.80349,0.19603,-0.56212],[-0.51285,-0.20481,-0.83369],[0.85308,-0.24435,-0.46103],[-0.72947,0.67141,-0.1307],[0.63896,-0.40056,-0.65672],[-0.74176,0.15934,-0.65146],[-0.80901,-0.34686,0.47455],[0.72361,-0.68909,-0.039175],[0.38693,-0.35252,0.85207],[0.4399,-0.66275,-0.60601],[-0.84326,0.4835,0.23482],[-0.84657,-0.078968,-0.52639],[-0.6821,-0.014393,-0.73111],[0.21946,-0.82539,-0.52017],[0.94945,-0.0094076,0.31377],[0.22859,-0.79481,-0.56217],[-0.27841,-0.9545,0.10686],[-0.75635,0.016815,-0.65395],[-0.097162,-0.9914,-0.08762],[0.73658,-0.66806,0.10554],[0.61048,-0.54623,-0.57355],[-0.5789,0.15368,-0.80079],[-0.7698,0.16973,-0.6153],[0.98205,0.12521,-0.14106],[0.42162,-0.18787,0.8871],[0.75921,-0.56242,0.32755],[-0.90149,-0.26953,0.33864],[0.88504,0.0089372,-0.46542],[-0.86646,-0.35691,0.3491],[-0.93632,0.33336,-0.11036],[0.86455,0.2408,-0.44109],[-0.71332,0.22252,-0.66457],[0.91241,-0.35619,0.20159],[-0.84409,0.51779,-0.1393],[0.73937,0.030947,0.67259],[0.8699,0.22321,0.43984],[0.85096,-0.032852,0.5242],[-0.80274,-0.1089,-0.5863],[-0.72451,0.68138,-0.10398],[0.56731,0.82111,-0.062649],[-0.75238,0.26392,-0.60354],[-0.8411,-0.4351,0.32131],[-0.8283,-0.16318,-0.536],[0.96309,0.035133,0.26687],[-0.88058,0.47334,0.023067],[0.83098,-0.54922,-0.08845],[-0.83869,0.54427,0.01921],[0.4277,-0.010898,0.90385],[0.73625,0.67151,-0.083747],[0.93473,0.1315,-0.33015],[-0.83904,0.45971,0.29101],[-0.1441,-0.97843,-0.14801],[-0.8307,-0.20463,-0.51774],[0.97787,0.15038,0.14544],[-0.70294,-0.087045,0.70591],[-0.43349,-0.064355,0.89886],[-0.39827,-0.24428,0.88414],[0.21408,0.97459,-0.065943],[-0.94146,0.2274,-0.24889],[0.21335,0.31932,0.92332],[0.56724,0.7007,-0.43274],[-0.3655,0.92629,-0.091597],[0.52422,0.85147,0.014344],[0.45079,0.86703,-0.21226],[-0.85366,0.31343,-0.41596],[-0.75383,-0.58882,0.29159],[0.49443,0.0023777,0.86921],[-0.45019,0.88874,0.086455],[0.29286,-0.95546,0.036331],[0.18168,0.97718,-0.11009],[-0.2034,0.97906,0.0083807],[0.27683,0.94383,-0.18042],[-0.10455,0.99442,-0.014216],[0.46071,-0.40568,0.78941],[0.85623,0.31729,0.40766],[-0.95033,-0.22022,0.21994],[-0.75394,-0.60081,0.2657],[-0.19041,-0.96706,-0.16896],[0.81617,0.37639,0.4384],[-0.4122,0.14366,0.8997],[0.061396,0.8359,-0.54544],[0.96977,0.24109,-0.037778],[0.32264,0.75595,-0.56959],[-0.60451,-0.70671,0.36759],[0.34058,0.52601,-0.77931],[-0.95525,-0.064795,-0.28862],[0.85904,0.40089,0.31835],[-0.7137,0.30885,-0.62868],[0.87578,0.0038358,-0.48269],[-0.98019,-0.17497,0.092762],[0.47285,-0.17637,0.86331],[0.64386,0.6229,0.44434],[-0.4394,0.67613,0.59142],[-0.52402,-0.27127,0.80735],[0.27157,0.81349,-0.51428],[-0.55065,0.45179,-0.7019],[-0.34043,0.59401,-0.72888],[0.063991,0.82115,-0.56712],[-0.11598,0.98541,0.12458],[-0.27844,0.73842,-0.61417],[-0.41847,0.22745,0.87929],[-0.085037,0.73522,-0.67247],[-0.33929,-0.94039,0.023685],[0.030554,0.99062,0.13317],[-0.22774,0.86437,-0.44834],[-0.43497,-0.89443,0.1039],[-0.18376,0.85904,-0.4778],[0.78745,0.058618,0.61358],[0.53628,-0.68333,0.49544],[-0.67907,0.63504,0.36822],[-0.98237,-0.049295,-0.18034],[0.58602,0.80974,0.029959],[-0.413,-0.91061,0.015103],[0.7471,0.615,0.25223],[0.54009,-0.11542,0.83365],[0.82303,0.55857,0.1031],[0.93583,-0.13823,-0.32421],[-0.57052,-0.50008,-0.65148],[0.38413,0.13627,0.91317],[0.89875,0.41973,-0.12678],[-0.60039,-0.43828,-0.66891],[0.87524,0.3338,0.35004],[0.72733,-0.32874,0.60243],[-0.36279,-0.46127,-0.8097],[0.15283,-0.61024,-0.77734],[0.62096,-0.59235,-0.51335],[0.94365,0.3283,-0.041756],[0.84831,-0.49592,0.18555],[0.9595,-0.0052025,0.28167],[0.72282,0.67035,0.16782],[0.9053,0.41123,0.1064],[0.012973,-0.99619,0.086243],[-0.65601,-0.54226,-0.52498],[0.0023897,-0.62044,-0.78425],[0.37708,-0.50356,-0.77733],[-0.89113,-0.13176,-0.43419],[-0.83937,0.19072,-0.50901],[-0.96935,-0.23792,-0.061304],[0.48021,-0.44286,-0.75715],[0.88999,-0.10125,0.4446],[-0.21171,-0.91828,0.33457],[-0.684,0.2672,-0.67878],[0.49227,-0.40297,-0.77154],[-0.90941,-0.047289,-0.4132],[0.053849,-0.9983,-0.022279],[0.93855,0.06568,-0.33883],[-0.9711,-0.22955,0.065297],[0.18957,-0.94344,-0.27199],[0.87066,-0.31597,0.37699],[-0.95856,-0.27878,0.058651],[-0.77489,0.2596,-0.57632],[0.1374,0.7889,0.59897],[0.45198,0.75108,0.48125],[-0.68279,-0.07454,0.7268],[0.83362,-0.078476,-0.54673],[-0.4684,-0.098733,0.87798],[0.99411,-0.09005,-0.060311],[0.70582,0.70627,0.054737],[-0.9017,-0.43154,-0.026766],[0.86863,-0.41734,0.26703],[-0.99347,-0.067342,0.092151],[0.87085,0.46192,-0.16807],[0.84455,0.093583,-0.52724],[-0.71966,0.3709,-0.58696],[0.97489,0.11905,-0.1882],[0.41413,0.76275,0.4967],[-0.96378,0.13453,0.23026],[-0.66263,0.42551,-0.61633],[0.84031,-0.51219,0.1776],[-0.97817,-0.19633,-0.068058],[-0.38228,0.61377,0.69076],[0.80386,0.58699,0.09617],[-0.12943,-0.99132,0.02324],[0.46825,0.1792,0.86524],[-0.83804,0.41231,0.35733],[-0.77963,-0.6123,-0.13141],[0.98428,-0.13875,0.10932],[-0.68567,-0.12278,0.71748],[0.58654,0.74946,0.30706],[-0.09479,-0.99429,0.048959],[0.72861,-0.17171,0.66306],[-0.21375,-0.96999,0.11594],[-0.47049,0.71755,0.51357],[0.24428,0.8497,0.46726],[-0.070359,0.66776,-0.74104],[0.32444,-0.87585,0.35725],[0.798,0.11506,0.59157],[-0.37693,-0.18339,0.90791],[-0.88859,-0.27571,0.36659],[0.54877,-0.16186,0.82016],[-0.62489,-0.71921,-0.30373],[0.83539,0.47486,-0.27681],[-0.63299,0.45614,-0.6255],[0.9291,0.19818,-0.31224],[-0.77304,0.30248,0.55759],[0.76181,-0.6368,0.11885],[-0.99726,0.056958,-0.047258],[-0.48845,0.0086712,0.87255],[0.14676,-0.97138,-0.18675],[-0.24779,0.32622,0.91224],[0.59211,0.70203,0.39569],[-0.39034,-0.61567,0.68453],[-0.041676,-0.23684,0.97065],[0.74284,0.61546,-0.26344],[-0.42791,0.90265,0.046046],[-0.68212,0.29071,0.67097],[-0.48844,-0.67624,-0.55147],[-0.77712,0.31462,-0.54507],[-0.38215,-0.28831,0.87797],[-0.09693,-0.67102,-0.73507],[0.99425,-0.043034,0.098009],[0.30041,-0.95381,0.0025332],[-0.63664,0.53474,-0.55564],[0.62916,-0.77723,-0.0083743],[-0.85924,-0.21823,0.46268],[0.9076,-0.075616,0.41296],[-0.50703,0.6098,-0.60916],[0.53834,-0.83978,-0.070393],[0.85876,-0.12596,0.49666],[0.69078,0.054251,0.72102],[-0.79308,0.28193,-0.53995],[-0.69739,0.49474,0.51854],[-0.48235,0.20166,0.85245],[-0.75084,0.21982,0.62283],[-0.85018,-0.47567,-0.22568],[-0.44237,0.6767,-0.58854],[-0.99897,-0.037771,0.024986],[0.52852,-0.80982,-0.25467],[0.86046,0.32618,-0.39144],[0.81116,-0.33955,0.47615],[0.16159,-0.97954,0.11992],[-0.33724,0.76353,-0.55072],[0.63326,-0.39266,-0.66693],[0.55918,0.080075,0.82517],[-0.011462,-0.99772,0.066455],[-0.04218,0.84566,-0.53205],[0.61462,-0.5316,0.58278],[-0.9283,-0.23525,0.28796],[0.40311,0.57971,-0.70812],[-0.51925,0.63357,0.57356],[-0.36104,0.77563,0.51773],[-0.21582,0.90637,0.3632],[0.23239,0.9707,0.061137],[0.051562,-0.7887,-0.61261],[-0.063976,-0.99766,0.023961],[0.16318,-0.84098,-0.51588],[0.81007,-0.32257,0.48963],[-0.0044132,0.79621,0.605],[-0.11956,-0.9516,-0.28313],[0.98835,-0.15045,-0.023074],[0.036705,-0.90455,-0.42479],[0.58747,-0.62419,-0.51504],[-0.26977,0.15932,0.94965],[0.8327,-0.29965,0.46564],[-0.96005,0.15882,0.23038],[0.2543,-0.89831,0.35828],[-0.31548,-0.91194,-0.26235],[-0.1117,-0.97647,-0.18448],[-0.39117,-0.034312,0.91968],[0.81244,-0.24868,-0.52736],[-0.33524,0.73787,0.58579],[-0.17451,-0.93597,0.3058],[0.52389,-0.76651,0.37149],[0.87264,-0.26558,0.40984],[-0.50016,-0.80742,-0.31292],[-0.67032,-0.12517,0.73144],[0.89928,0.089779,-0.42806],[-0.86341,-0.027607,-0.50375],[-0.40074,0.011504,0.91612],[0.58773,-0.65918,0.4691],[0.50691,-0.64322,0.57385],[-0.70329,-0.64793,-0.29253],[-0.57271,-0.71607,0.39906],[0.065817,-0.99665,-0.048493],[0.47518,-0.68202,0.55593],[0.75575,0.54011,-0.3703],[0.058044,-0.99831,-0.00126],[0.86446,0.29049,-0.41028],[-0.88539,-0.41432,0.21076],[-0.6882,-0.72137,0.077509],[0.79688,-0.2854,-0.53248],[0.83347,-0.16031,0.5288],[0.6709,-0.56702,0.47789],[-0.81659,-0.52567,0.23842],[0.03161,-0.83535,0.5488],[0.02594,-0.30531,0.9519],[0.53301,-0.68997,0.48974],[-0.32464,-0.62529,0.70966],[0.66915,-0.56814,-0.47902],[-0.81336,-0.47677,0.33338],[0.75341,-0.54175,0.37267],[-0.90138,-0.43249,0.021513],[0.8852,-0.45218,0.10937],[0.60497,0.63386,0.4819],[0.69772,0.63252,-0.33632],[-0.79177,-0.57187,-0.21462],[0.4337,-0.56878,0.69885],[0.88821,-0.45298,0.076742],[-0.88143,-0.032042,-0.47122],[0.76469,-0.25472,-0.59192],[0.78219,0.0016218,0.62304],[-0.95661,-0.09846,0.27423],[-0.74896,-0.54256,0.38038],[-0.94304,-0.21235,-0.25611],[-0.77263,-0.57804,0.26252],[0.83255,0.053572,0.55135],[-0.35003,-0.52909,-0.77301],[0.72728,-0.51399,-0.45484],[-0.86561,-0.14319,-0.47981],[0.046178,-0.61127,-0.79007],[0.99656,-0.055122,0.061893],[0.099955,-0.55369,-0.8267],[0.81667,-0.27872,-0.50534],[0.74416,-0.14019,-0.65313],[-0.70498,-0.31048,-0.63766],[0.43724,0.063049,0.89713],[-0.0090636,-0.37566,-0.92672],[0.072404,-0.32814,-0.94185],[0.39816,-0.31891,-0.8601],[-0.96475,-0.080036,-0.25071],[-0.98233,0.17556,0.064919],[-0.85643,0.0087114,-0.51619],[0.13248,0.063889,0.98912],[0.16664,-0.23622,-0.9573],[0.15968,-0.28317,-0.94569],[0.39911,-0.36112,-0.84279],[0.82082,-0.15983,-0.54838],[-0.93113,-0.36435,0.015603],[0.92972,-0.10335,-0.35346],[-0.79783,0.49435,0.34509],[0.36778,-0.28839,-0.88407],[0.30063,-0.8641,0.40368],[-0.95118,-0.036379,-0.30649],[0.77254,-0.053967,0.63267],[0.99448,0.097675,-0.038417],[-0.4063,-0.57966,0.70634],[0.5929,0.76578,-0.24912],[-0.94424,0.081371,0.31905],[-0.89092,0.20931,-0.40306],[0.69057,0.13603,0.71036],[0.76496,-0.22102,-0.60497],[-0.74608,-0.053376,0.66372],[0.97575,0.131,-0.17537],[-0.86831,0.49594,-0.0089063],[0.39694,-0.13797,-0.90742],[0.82067,-0.057165,-0.56853],[-0.41778,-0.90827,0.022694],[0.88078,-0.044233,-0.47145],[0.52604,-0.83127,0.17963],[0.58924,-0.80143,-0.10249],[-0.84457,0.52088,0.12405],[0.15686,-0.14955,-0.97623],[-0.019505,0.7359,0.67681],[0.82542,-0.2992,-0.47871],[-0.93778,-0.0038965,-0.34722],[-0.56619,-0.81281,-0.13699],[0.63212,-0.56702,0.52813],[0.66453,-0.17807,0.72574],[0.16004,-0.15997,-0.97406],[-0.99318,0.064168,-0.097334],[-0.69714,-0.6583,-0.28396],[0.85,-0.12276,-0.51227],[-0.77187,0.63396,-0.048054],[0.14312,-0.22548,-0.96368],[0.083804,-0.087751,-0.99261],[0.31802,-0.08734,-0.94405],[0.89287,0.031609,-0.4492],[0.88121,-0.060108,0.46888],[0.90539,0.14306,-0.39976],[-0.80529,0.47959,-0.34858],[0.81108,0.039238,0.58361],[-0.86634,-0.24499,-0.43525],[0.052994,-0.0026856,-0.99859],[0.13678,-0.44351,-0.88577],[-0.96885,0.23917,-0.064183],[0.84147,-0.039484,-0.53886],[-0.019455,0.069882,-0.99737],[-0.10799,-0.093623,-0.98973],[-0.79376,0.1973,0.57535],[0.35306,-0.44737,-0.82171],[-0.86698,0.49803,0.017807],[0.3686,-0.79888,-0.47532],[0.68594,0.041761,-0.72646],[-0.54929,0.4035,-0.73175],[-0.37891,0.24466,-0.89251],[-0.50559,-0.28466,0.81446],[0.77318,-0.008323,0.63413],[-0.73388,-0.6772,-0.053101],[-0.74486,7.8683e-05,0.66722],[0.66861,0.1952,-0.71753],[0.68141,0.15864,-0.7145],[-0.40156,-0.01079,-0.91577],[0.46844,-0.85698,0.21484],[-0.85554,0.51475,0.055533],[0.63011,-0.34731,0.69451],[-0.63653,0.14359,-0.75777],[0.47309,-0.87513,0.10162],[-0.90544,0.41139,-0.10463],[-0.97442,0.073742,0.21228],[0.70601,0.15781,0.69039],[0.72494,0.11896,0.67847],[0.60144,-0.78235,-0.16188],[-0.90641,0.37435,-0.19565],[0.29181,-0.81969,-0.49291],[0.96419,-0.10711,-0.24263],[-0.77521,0.14111,-0.61574],[0.35552,-0.7803,0.51452],[-0.9024,0.32443,0.28358],[0.8116,-0.56797,-0.13681],[0.88874,0.22971,0.39671],[0.35072,-0.78498,-0.51068],[-0.27014,-0.86486,-0.42313],[0.89145,0.20466,-0.40426],[-0.72969,0.057659,-0.68134],[0.70579,-0.43111,-0.56215],[0.84036,-0.53329,0.096925],[0.99582,-0.017165,0.08972],[-0.79534,0.24591,0.55404],[-0.27093,0.73521,0.62134],[-0.96208,0.1102,0.2495],[-0.74944,0.17521,-0.63847],[-0.72931,0.19721,-0.65514],[0.9606,0.16651,-0.22254],[0.65629,0.34863,0.66913],[0.91024,0.36649,0.19274],[0.87564,0.165,-0.45391],[0.93054,-0.24451,0.27261],[0.56856,0.81462,-0.11461],[-0.50687,0.58559,0.63259],[0.92837,-0.27235,-0.25287],[0.97116,-0.14257,-0.19112],[-0.69088,0.3127,-0.65185],[0.81681,-0.57685,0.0074469],[0.96416,-0.053876,0.25979],[-0.76038,0.64036,-0.10844],[-0.8281,-0.24529,0.50406],[-0.77201,0.2359,0.59022],[0.3786,0.075949,0.92244],[0.42285,-0.20652,0.88235],[0.91867,0.19425,0.34397],[0.73031,0.67733,-0.088696],[0.90721,0.42054,-0.010736],[-0.64896,0.29152,0.70275],[0.66248,0.62485,0.41313],[0.89536,0.26672,0.35665],[-0.80586,0.59116,-0.03345],[-0.72414,0.66809,0.17109],[0.99584,0.058516,-0.069787],[-0.61744,0.78459,-0.056423],[-0.39461,0.91005,-0.12689],[-0.39949,0.89392,-0.20324],[-0.78696,0.55474,0.2701],[0.29997,0.95041,0.082122],[-0.51066,0.59313,0.62243],[0.85029,-0.24845,-0.46398],[-0.53647,-0.19456,0.82119],[0.46303,0.86129,-0.20923],[-0.51797,0.23375,0.82284],[-0.41577,-0.32661,0.8488],[-0.51031,0.85944,0.030923],[0.19698,0.9604,-0.19706],[-0.61393,0.39581,0.68295],[0.753,0.60106,0.26779],[0.50148,0.67282,-0.54391],[0.68825,-0.15293,0.70917],[0.76531,-0.37477,0.5233],[0.24445,0.96639,-0.079611],[0.19804,0.97587,-0.092028],[-0.0095466,0.99849,-0.054183],[-0.50974,0.40648,0.75824],[0.71135,-0.20314,-0.67284],[-0.72594,-0.51404,0.45692],[-0.57662,0.66628,0.47285],[0.85839,0.37363,0.35152],[-0.028893,0.99902,0.033423],[-0.78374,-0.19556,-0.5895],[0.59964,-0.7977,0.06413],[0.53984,-0.028865,0.84127],[0.99673,0.052693,-0.061324],[-0.96293,0.25021,0.10081],[0.10941,-0.046191,0.99292],[-0.86398,-0.19539,-0.46407],[0.58292,0.064067,-0.81],[0.65648,-0.29392,-0.69473],[0.94572,0.25367,0.20314],[0.66212,0.63409,0.3994],[-0.90838,-0.091408,-0.40804],[-0.47941,-0.10737,0.871],[-0.88805,-0.45881,-0.029516],[-0.68221,0.33297,-0.65093],[-0.30542,0.35756,0.88254],[0.75808,-0.28506,0.58656],[0.14792,-0.12163,0.98149],[0.30283,-0.56351,0.7686],[0.091985,0.80068,-0.59198],[0.70244,-0.29525,0.64762],[0.59054,0.75687,-0.28002],[0.88692,0.37806,0.26541],[-0.81295,0.52541,0.2511],[-0.026318,0.6323,-0.77428],[0.76258,-0.12848,0.63401],[0.34407,0.70082,-0.62487],[-0.069768,0.71813,-0.6924],[-0.099411,0.82106,-0.56212],[0.28708,0.89966,-0.32894],[0.2617,0.87532,-0.40661],[-0.95213,-0.062002,-0.29933],[0.031422,-0.34174,0.93927],[-0.35373,0.61652,-0.70341],[0.034167,-0.99416,-0.10233],[-0.051231,0.43811,-0.89746],[-0.10491,0.69755,-0.70882],[0.25658,0.46608,-0.84672],[0.22059,0.57002,-0.79147],[-0.1749,0.673,-0.71866],[0.038576,-0.99898,0.023418],[0.12033,0.71641,-0.68722],[0.32627,-0.13605,0.93543],[-0.77855,0.5072,0.3696],[0.17939,0.61123,-0.77085],[-0.068158,-0.99688,-0.039735],[-0.10084,0.15355,-0.98298],[0.079438,0.13168,-0.9881],[-0.29898,0.77488,-0.55693],[-0.034692,0.10765,-0.99358],[-0.78682,0.5547,0.27059],[0.069866,0.32606,-0.94276],[0.07731,0.082392,-0.9936],[0.075954,0.070579,-0.99461],[-0.94104,0.096831,0.32415],[-0.8222,-0.3362,0.45931],[-0.81329,-0.27266,-0.51401],[0.36206,-0.65777,0.66049],[0.69131,0.15121,0.70655],[0.064742,0.50284,-0.86195],[-0.11916,-0.23822,0.96387],[0.95195,0.2778,-0.12889],[0.24607,-0.58634,-0.77179],[0.18901,0.84987,-0.49194],[0.94482,-0.28007,-0.16991],[-0.59516,-0.15206,0.78909],[-0.58067,-0.30111,-0.75641],[0.63643,-0.76265,-0.1154],[0.95343,-0.30138,0.011923],[-0.72214,-0.17761,-0.66855],[-0.38914,0.65639,0.64632],[-0.87042,-0.16291,-0.46457],[0.89752,0.40433,0.17598],[-0.30169,-0.54683,-0.781],[0.58909,0.014694,0.80794],[0.49051,0.69862,0.5209],[-0.91831,0.15127,0.36582],[-0.64159,-0.53961,-0.54515],[0.63216,0.63383,0.44569],[0.8449,0.10426,0.52467],[-0.87103,0.10957,-0.47886],[-0.80339,-0.14378,-0.57784],[-0.78435,0.45121,-0.42569],[0.81694,0.56909,0.093522],[0.37804,0.77679,-0.50367],[0.89541,-0.089914,0.43607],[0.62239,-0.33076,-0.70938],[-0.90385,-0.37048,-0.21402],[0.83907,-0.27084,0.47182],[0.67741,0.18301,0.71248],[0.78476,0.57674,0.22699],[0.31229,0.85277,-0.41864],[-0.98594,0.10819,-0.12732],[0.32595,0.8642,0.3833],[0.24715,0.90682,0.34146],[0.95152,0.29245,0.095302],[-0.8857,-0.046631,-0.46191],[0.93512,-0.31035,-0.17099],[-0.98932,-0.10636,-0.099654],[-0.68702,0.071665,0.72309],[0.79425,-0.17647,-0.5814],[-0.8775,0.12848,-0.46204],[-0.04616,0.065926,0.99676],[0.63055,0.73344,0.25392],[-0.94845,-0.3169,0.0037954],[-0.37204,-0.084934,0.92432],[-0.55048,0.73318,0.39928],[0.91344,-0.11043,-0.3917],[-0.7967,0.29514,-0.52741],[0.38044,0.83452,-0.39856],[0.83492,0.5499,0.02268],[0.44378,-0.40067,-0.80158],[0.78932,-0.28399,0.54436],[-0.70404,0.61297,0.35859],[-0.52637,0.70125,0.48082],[0.90919,0.073604,0.40982],[-0.45441,-0.1141,0.88345],[0.9376,-0.12613,0.32405],[0.7134,0.4898,-0.50115],[0.52097,0.72984,0.44263],[0.83724,-0.54429,0.052815],[0.80425,0.52031,0.28717],[-0.93979,0.32301,0.11159],[0.93974,-0.22609,0.25647],[-0.69553,-0.68156,-0.22741],[-0.78468,0.046787,0.61813],[-0.77554,0.51038,-0.37155],[0.81048,-0.58182,0.067868],[-0.29928,0.76955,0.56412],[0.38341,0.92222,0.05017],[0.81005,-0.54866,-0.20689],[0.14725,0.98909,0.0032285],[-0.65761,0.45922,-0.59722],[0.66876,-0.51817,-0.53315],[-0.83598,0.49598,0.23483],[0.73257,-0.62508,-0.26947],[-0.71987,0.6712,0.17684],[-0.63378,0.73176,0.2507],[0.81078,-0.56732,0.14416],[-0.33063,-0.047063,0.94259],[0.79259,-0.60947,-0.01856],[-0.76237,0.43128,-0.48248],[0.77896,-0.62236,0.076758],[-0.36597,0.88782,0.27902],[0.43091,-0.18128,0.884],[0.52124,-0.23508,0.8204],[-0.67699,0.51357,-0.52719],[-0.83358,-0.2862,0.47248],[0.20981,0.76649,0.60702],[-0.4756,-0.75151,-0.4572],[-0.28753,-0.073598,0.95494],[0.4018,0.9129,-0.071928],[0.76037,-0.64848,-0.036277],[-0.68242,0.44406,-0.58061],[0.73128,-0.68166,-0.023875],[0.0053,0.85796,-0.51368],[0.15429,0.8094,0.56663],[-0.18414,-0.69884,-0.69116],[-0.89113,0.24448,0.38224],[-0.99121,-0.12716,0.0366],[0.68375,0.096482,0.72331],[-0.28036,-0.68529,-0.67214],[-0.021702,-0.63899,-0.76891],[0.94524,0.20005,-0.25789],[0.64945,-0.74241,-0.16442],[-0.79692,-0.59918,0.076869],[-0.91647,0.15719,0.36792],[0.78087,-0.24904,-0.5729],[0.5876,-0.77367,-0.23698],[-0.83724,-0.2404,0.49115],[-0.74292,-0.032086,0.66861],[-0.60248,0.61942,-0.50333],[0.25565,0.81634,0.51792],[-0.51408,0.70526,-0.48818],[0.30883,0.95019,-0.042005],[0.45061,-0.8594,-0.24163],[-0.78716,0.16745,0.59358],[0.64923,0.74111,-0.17102],[-0.67795,0.73506,-0.0078096],[-0.91431,-0.28388,0.28887],[0.03636,-0.90964,-0.41381],[-0.38245,0.73049,-0.56578],[0.04771,0.77335,-0.63218],[0.49232,-0.84493,-0.2091],[0.70968,0.049404,0.70279],[-0.70321,0.32301,0.63337],[0.72249,0.35775,0.59163],[-0.82596,-0.55967,-0.067511],[0.055532,0.1087,0.99252],[-0.62648,0.50202,0.59624],[0.91195,-0.22986,0.33988],[0.53564,0.83882,-0.097301],[-0.19358,-0.9439,0.26756],[0.77876,0.003899,-0.62731],[0.33047,0.80051,-0.49998],[0.32957,0.80305,0.49648],[-0.1987,0.8101,-0.55159],[-0.055721,0.88482,-0.4626],[0.85165,-0.524,0.010679],[0.14051,0.94918,-0.28162],[0.65057,0.58929,-0.47906],[-0.088723,0.95428,0.28546],[0.15832,0.93801,-0.30832],[-0.26492,-0.85761,-0.44082],[-0.0059349,-0.86386,-0.5037],[0.081246,-0.36018,0.92934],[0.18753,-0.91427,-0.35909],[0.19185,-0.9171,-0.34946],[0.10304,0.92669,-0.36143],[0.43852,0.89618,0.067478],[-0.22123,-0.96828,-0.11618],[0.44261,-0.58366,0.68076],[-0.027496,-0.96316,-0.26751],[-0.34989,-0.83799,-0.41875],[0.46987,-0.76557,-0.43945],[0.8997,-0.25528,0.35408],[-0.025444,-0.94098,0.33751],[-0.42027,-0.8921,-0.1659],[-0.18973,-0.94812,0.25507],[0.41275,-0.85417,0.31628],[-0.60317,-0.79586,-0.052867],[0.86102,0.2053,-0.4653],[-0.88469,-0.23859,0.4005],[-0.61436,0.67903,0.40184],[-0.46828,-0.86479,0.18124],[0.63606,-0.72683,0.25913],[-0.9228,0.059891,0.3806],[0.11768,-0.29036,0.94965],[0.80457,0.4637,-0.37101],[-0.72013,0.65486,-0.2293],[0.72647,-0.62802,0.27899],[-0.056348,-0.094721,0.99391],[-0.67968,-0.70407,-0.20574],[0.57965,0.60686,0.54381],[0.79569,0.51372,-0.3209],[-0.65723,-0.69263,-0.29716],[-0.07979,0.70436,-0.70535],[-0.6328,-0.72508,0.27171],[0.28441,0.94207,0.17779],[0.60931,-0.66519,0.43158],[-0.88618,-0.38762,-0.25382],[-0.33074,-0.84069,0.42878],[-0.23418,-0.92256,0.30666],[0.69043,-0.31521,0.65111],[-0.55813,-0.82459,0.092482],[0.19868,-0.89707,-0.3947],[0.51668,-0.68512,0.51347],[0.88667,-0.27616,0.37089],[-0.76784,-0.59007,0.24948],[0.68274,0.35333,0.63956],[0.65022,-0.63219,0.42137],[-0.62882,-0.69599,-0.34666],[0.12241,0.95026,-0.28639],[0.63891,-0.56982,-0.51682],[-0.87663,0.11182,-0.46799],[0.53986,-0.6858,0.48808],[0.72606,0.23794,0.64515],[-0.84804,-0.50374,0.16451],[0.85225,-0.48338,0.20002],[0.56263,-0.55253,0.61494],[-0.34247,0.25715,0.90365],[-0.84693,-0.49423,0.19608],[0.59636,-0.52605,0.60632],[0.61269,-0.62677,-0.48142],[-0.97501,-0.20337,0.08948],[0.7585,-0.2593,-0.59786],[-0.79218,0.36135,-0.49181],[0.67982,-0.626,0.38206],[-0.85553,-0.48809,-0.17273],[-0.68458,-0.061419,0.72635],[-0.84932,-0.48104,0.2174],[0.31246,0.084698,0.94615],[0.62999,-0.031811,0.77595],[-0.81273,0.27214,-0.51518],[0.55515,-0.65293,-0.51526],[-0.47169,-0.48712,-0.735],[0.89713,0.11514,-0.42649],[-0.12191,-0.64124,-0.75759],[0.1294,-0.6635,-0.7369],[-0.075806,-0.63016,-0.77276],[0.56016,-0.54114,0.62721],[-0.052447,-0.62047,-0.78248],[0.16428,-0.54338,-0.82326],[0.76015,-0.51605,-0.3948],[0.39431,-0.50593,-0.76717],[-0.94577,-0.32233,-0.040256],[-0.50254,0.69856,0.50938],[0.45271,0.34463,0.82236],[-0.82587,-0.12154,0.55061],[-0.6193,0.60726,0.49769],[-0.92732,0.0011783,-0.37427],[-0.88252,-0.39274,-0.25869],[0.95504,-0.2898,-0.06251],[-0.90281,0.034043,-0.42869],[-0.88763,-0.27913,0.36634],[-0.95125,0.24944,-0.18137],[0.30404,-0.30681,-0.9019],[0.78222,-0.30715,-0.54203],[0.94491,-0.23192,-0.23098],[-0.87355,0.48657,0.012942],[0.60096,0.60677,0.52027],[0.1022,-0.99292,0.060515],[0.23517,-0.39544,-0.88788],[-0.7914,-0.1053,-0.60217],[-0.84881,-0.30173,-0.43415],[0.12479,-0.27613,-0.95298],[0.38028,-0.3502,-0.85601],[0.6241,0.1249,0.7713],[0.80538,-0.38396,-0.45159],[-0.72195,-0.13989,0.67766],[0.63536,-0.19662,0.74676],[0.87578,-0.46149,0.14154],[-0.79586,0.55375,0.24489],[0.76082,-0.62056,0.18989],[-0.28882,0.79155,0.53855],[-0.50869,0.74359,0.43394],[-0.74002,0.25877,0.62082],[0.55651,-0.52702,0.6423],[0.92513,-0.27893,0.25753],[0.46585,-0.19136,-0.86392],[-0.83241,0.16894,0.52777],[0.69656,-0.19743,0.6898],[-0.90168,-0.042861,-0.43027],[0.68686,-0.62739,-0.36688],[-0.851,0.0011244,0.52516],[-0.81437,0.55036,0.18415],[-0.44399,-0.062838,0.89383],[0.49992,-0.09984,-0.8603],[-0.84967,-0.47961,-0.21916],[-0.33956,0.0042235,0.94057],[0.69907,-0.10986,-0.70656],[0.87377,-0.36356,-0.32304],[-0.88704,0.40867,-0.2148],[-0.2964,-0.72412,-0.62273],[0.60639,0.42863,0.66976],[-0.96758,0.24271,-0.069822],[0.055845,-0.77635,-0.62783],[-0.68491,0.38389,0.6193],[0.90223,0.14453,-0.40631],[0.61101,-0.40547,0.6799],[-0.75683,0.25297,-0.60267],[0.58042,-0.71974,-0.3809],[-0.8929,-0.023296,-0.44965],[-0.77336,-0.039202,0.63276],[0.47249,-0.87023,-0.13945],[0.64895,0.21223,0.73063],[-0.81327,0.08482,-0.57568],[0.63195,-0.39152,0.66884],[0.58191,-0.75867,-0.29292],[0.85698,-0.11755,-0.50176],[-0.12653,-0.51231,-0.84943],[-0.69822,0.10531,-0.7081],[0.50512,-0.85773,-0.095682],[-0.40671,0.82391,0.39466],[-0.67269,0.087072,-0.73478],[0.45505,-0.88366,-0.10985],[0.045869,-0.50178,-0.86378],[0.69895,-0.70144,-0.13948],[0.026997,0.96068,-0.27636],[0.52949,0.10718,0.84152],[-0.56844,-0.29853,0.76665],[0.82558,0.24567,-0.508],[0.71857,-0.18113,0.67146],[0.62432,-0.54829,-0.55642],[0.20532,0.75266,0.62557],[0.86168,-0.50735,0.010261],[-0.89857,0.36705,-0.24052],[0.87895,-0.091262,-0.46809],[0.9012,-0.41824,0.11363],[0.91261,0.34892,-0.21306],[-0.46132,-0.40065,0.79162],[-0.98288,-0.11285,0.14565],[0.97867,-0.19934,0.049647],[-0.22149,-0.1373,0.96545],[-0.8003,-0.035443,-0.59856],[0.37495,0.86773,0.32627],[-0.87699,0.48021,0.016903],[0.84757,0.50942,-0.14871],[-0.10906,-0.29889,0.94804],[0.21729,0.76298,0.60881],[0.95891,-0.21405,0.18622],[-0.72751,0.67328,-0.132],[0.70608,0.69532,-0.13412],[-0.70036,0.2935,-0.65066],[-0.959,-0.2294,0.1664],[0.62038,0.76728,-0.16252],[0.00063565,0.99636,-0.085259],[-0.53449,0.071364,0.84215],[0.72836,0.63475,-0.25803],[0.19049,-0.6262,-0.75603],[0.89814,-0.22707,0.37654],[-0.014056,0.94484,0.32723],[-0.75379,0.3222,-0.5727],[-0.68261,0.41324,-0.60272],[0.89082,-0.45156,-0.050219],[0.91906,0.22478,0.32375],[0.41143,0.89346,0.18017],[0.62912,-0.33899,0.69949],[0.82727,0.3858,-0.40839],[-0.072352,-0.72811,-0.68164],[0.96412,-0.014763,-0.26506],[0.58712,0.80945,0.0088773],[0.68064,0.59872,-0.42221],[-0.85252,-0.19843,-0.48357],[0.97949,-0.20134,-0.0081224],[-0.33489,0.94078,-0.052843],[-0.29577,0.95451,-0.037706],[-0.02742,-0.66638,-0.74511],[-0.8546,0.22549,-0.46777],[-0.52935,0.67845,0.5094],[0.90234,0.2911,0.31787],[0.65343,-0.01588,0.75682],[0.30168,0.9532,-0.019847],[-0.054655,-0.49393,-0.86778],[0.67919,0.43306,-0.59259],[-0.21081,0.97245,0.09952],[-0.10625,0.99203,-0.067743],[-0.11101,0.98868,-0.10093],[0.092588,0.99239,-0.081146],[-0.8965,-0.014735,-0.4428],[-0.8712,-0.37961,-0.31129],[0.50396,-0.67657,-0.53691],[-0.16552,0.78242,0.60035],[-0.72217,-0.32025,-0.61311],[0.65802,-0.43547,-0.6143],[0.89619,0.36404,0.25361],[-0.2355,0.88894,0.39285],[0.89265,0.41221,0.18238],[-0.75254,0.17808,-0.63402],[0.40084,0.38889,-0.82951],[0.59068,0.13909,-0.79483],[-0.93344,0.013846,-0.35846],[-0.46867,-0.52771,-0.70843],[-0.93467,-0.19574,0.29679],[0.017875,0.70294,-0.71102],[0.14537,0.59556,-0.79005],[0.11715,0.92054,0.37268],[0.83544,0.46454,0.29367],[-0.032727,0.1967,0.97992],[0.22848,0.63317,-0.73952],[-0.18639,0.91969,0.34558],[0.37439,0.36565,0.85213],[-0.068123,0.81319,-0.578],[-0.17865,0.84377,0.5061],[-0.49888,0.44374,-0.74445],[0.98547,-0.083996,-0.14765],[0.014888,0.22261,-0.97479],[-0.20999,-0.11819,0.97053],[0.37287,0.39794,-0.83822],[0.59678,-0.40133,0.69483],[0.69131,0.52567,0.49575],[0.30132,0.87646,-0.37552],[-0.80264,-0.12047,-0.58417],[0.94459,-0.29662,0.14062],[-0.94984,0.029928,0.31131],[-0.68291,-0.25353,0.6851],[0.52005,-0.021174,0.85388],[-0.10465,0.70299,-0.70345],[0.15466,0.72994,-0.66579],[-0.26877,0.76434,-0.58613],[-0.11257,0.20842,-0.97154],[0.22951,0.010478,-0.97325],[0.28219,0.051717,-0.95796],[-0.81082,-0.48629,-0.32572],[0.79977,0.53283,0.27653],[-0.26066,0.4408,-0.85893],[-0.070747,0.53972,-0.83886],[-0.80494,-0.21214,0.55414],[0.94715,-0.17036,-0.27183],[-0.24616,0.45728,-0.85458],[-0.14533,0.17813,-0.97321],[-0.1508,0.19308,-0.96952],[0.1088,0.15107,-0.98252],[0.32773,0.015145,-0.94465],[-0.66482,-0.39992,-0.63094],[0.93199,0.35053,0.092314],[-0.33278,0.09377,-0.93833],[0.057108,-0.56358,0.82408],[0.049565,0.47976,-0.876],[0.096699,0.60644,-0.78923],[0.28851,0.46794,-0.83534],[0.053244,-0.34239,0.93805],[0.068036,0.91445,0.39895],[0.93033,0.29135,-0.22271],[-0.19307,0.17078,-0.96621],[-0.99459,-0.10365,0.0065496],[-0.030467,0.46304,-0.88581],[0.031649,0.63691,-0.77029],[0.9026,-0.26228,0.34136],[0.01663,0.99868,0.048563],[0.080324,0.72773,-0.68114],[-0.17783,-0.50547,-0.84432],[0.30666,-0.1939,0.93186],[-0.95877,0.13253,0.25137],[0.74728,-0.47851,-0.46108],[-0.66519,-0.48777,-0.56533],[0.63981,0.1775,0.74775],[-0.49801,-0.30674,-0.81111],[-0.91394,-0.0035521,-0.40584],[-0.62085,-0.20847,-0.7557],[0.13508,0.92883,0.34499],[0.92117,0.036117,0.38748],[0.97126,-0.20433,0.12211],[-0.85029,-0.29223,-0.43772],[0.18048,0.80263,0.56851],[0.83837,0.5373,-0.091897],[-0.02003,0.91161,0.41056],[0.88449,-0.22797,0.40707],[-0.79544,-0.37419,-0.47672],[0.22542,-0.43423,-0.87214],[-0.7601,-0.079215,-0.64495],[0.90157,0.045333,0.43024],[-0.96843,-0.244,-0.051059],[-0.035561,0.91519,0.40145],[0.79163,0.45239,0.41068],[0.02161,0.92322,0.38366],[-0.62062,-0.40607,-0.67077],[0.9051,0.089192,0.41575],[0.98187,-0.17715,0.067377],[0.84325,0.44058,0.30792],[0.17868,0.079095,0.98072],[0.71108,-0.53194,-0.4598],[-0.83837,0.29519,-0.45825],[0.85936,-0.38954,-0.33129],[0.87655,-0.43147,-0.2133],[0.64159,0.70362,0.30541],[0.66455,-0.25917,-0.70086],[-0.96862,-0.23032,0.093367],[-0.80657,-0.29647,0.51141],[-0.88595,0.287,-0.36432],[0.86796,-0.24099,0.43425],[-0.24596,-0.94593,-0.21145],[0.88218,-0.34064,0.32514],[0.90279,-0.23019,0.36329],[0.17932,-0.37271,0.91046],[0.11342,0.85214,0.51087],[0.8693,-0.099685,-0.48413],[-0.18918,0.59237,0.78314],[-0.054115,-0.99811,-0.029036],[0.69669,0.68703,0.20643],[0.88093,-0.39074,0.267],[0.057404,-0.99818,0.018291],[0.91967,-0.16626,0.35575],[0.90615,0.010188,-0.42283],[-0.98313,0.064006,0.17136],[0.74207,0.66137,-0.10921],[0.78376,0.60216,-0.15209],[0.78157,-0.24544,0.57351],[0.86312,-0.495,0.10001],[-0.84028,-0.26415,0.47345],[-0.91967,0.22708,0.32036],[0.50252,0.71189,0.4906],[0.74093,0.63901,0.20663],[0.90591,0.16517,-0.38992],[0.82686,-0.56191,0.02361],[0.68309,-0.27724,0.67566],[-0.86713,-0.19899,0.4566],[0.58472,0.74382,0.32377],[0.092832,-0.98054,0.17296],[-0.99701,-0.072864,-0.025556],[-0.57249,0.61708,0.53988],[0.98603,-0.13921,-0.091514],[-0.049377,0.82631,0.56104],[0.39839,-0.70945,0.58135],[0.98339,-0.1171,0.13867],[0.40266,0.80541,0.43495],[-0.69561,0.49874,-0.5171],[0.063121,-0.23688,0.96949],[0.92773,0.33745,-0.1595],[0.76162,-0.22891,0.60625],[-0.94675,-0.15113,0.2843],[-0.97521,-0.21374,0.057208],[0.98991,-0.063404,-0.12675],[-0.51892,-0.66334,0.53916],[-0.33481,-0.89322,0.30011],[0.99223,-0.1179,-0.039692],[-0.68818,0.52581,-0.49992],[-0.7904,-0.40665,-0.45816],[-0.91147,-0.17779,0.37097],[0.60241,-0.67007,-0.43371],[0.19802,-0.9352,-0.29359],[0.20787,0.9757,-0.069255],[-0.27015,-0.72342,-0.63536],[-0.36864,-0.73544,-0.56854],[0.97208,-0.22066,-0.079825],[0.69869,-0.64556,-0.30837],[-0.8286,-0.43887,-0.34757],[0.54884,-0.83533,0.031428],[-0.96922,-0.24001,-0.054778],[-0.68777,-0.48154,-0.54323],[-0.84418,-0.20219,0.49647],[-0.21658,-0.56558,-0.79575],[-0.075452,-0.60165,-0.79519],[0.030362,-0.55916,-0.82851],[0.69225,-0.614,-0.37922],[-0.036534,-0.59805,-0.80063],[-0.83015,-0.36228,-0.42381],[-0.67983,0.56101,-0.47232],[0.99727,0.03529,-0.064842],[-0.55406,-0.79196,-0.25654],[0.7903,0.56887,-0.22761],[-0.36395,-0.072099,0.92862],[-0.95005,-0.25962,0.1732],[-0.89046,0.049022,0.45242],[-0.98423,-0.13797,0.11069],[0.28499,-0.16472,0.94427],[-0.14161,-0.98658,-0.08124],[0.76558,0.62229,-0.1632],[-0.9067,-0.15361,0.39281],[-0.77634,0.10104,0.62216],[-0.33211,-0.36889,0.86812],[0.50483,-0.80424,-0.3136],[0.86537,-0.31835,-0.38702],[0.71731,0.6828,-0.13872],[-0.072011,-0.99588,-0.055104],[0.35159,0.087628,0.93204],[-0.9788,0.12918,-0.15897],[-0.080728,-0.99326,-0.083206],[-0.4564,0.81312,-0.36128],[0.4166,-0.83371,-0.36245],[0.89447,-0.40321,-0.19326],[0.62589,-0.61952,-0.47376],[-0.57145,0.52047,0.63447],[0.23134,0.78816,0.57034],[0.53703,-0.11883,0.83515],[0.80356,0.18426,-0.56599],[-0.4028,0.83764,-0.36893],[-0.26741,0.90395,-0.33371],[0.19048,-0.14412,0.97106],[0.09374,0.94973,-0.29871],[0.18742,0.96496,-0.18364],[0.38836,0.91153,-0.13524],[0.061276,-0.98298,-0.17318],[0.34584,0.93829,-0.00030949],[-0.22023,-0.96429,-0.14713],[0.098966,0.9787,0.17987],[-0.20954,-0.90978,-0.35833],[-0.0027751,-0.92188,-0.38747],[0.71724,-0.69613,0.03115],[0.35041,-0.87868,-0.32425],[-0.20834,-0.91164,-0.35428],[-0.23434,-0.87327,-0.42717],[-0.01896,-0.99917,0.036166],[-0.29355,-0.95364,-0.066316],[0.83413,-0.036383,0.55036],[-0.62464,-0.76673,0.14819],[0.67339,0.15526,0.7228],[-0.66319,-0.1534,0.73257],[0.4642,0.21658,0.85885],[-0.095687,0.80018,0.59208],[-0.59449,-0.72458,-0.34866],[0.92248,-0.3795,-0.07074],[-0.87551,-0.31469,0.36667],[-0.95529,-0.24417,-0.16674],[0.73317,-0.64385,0.21891],[0.8281,0.20674,0.52107],[0.98026,-0.16121,0.11448],[-0.90719,-0.28686,-0.30777],[0.8,0.39942,-0.44773],[0.71201,0.17647,0.67963],[-0.1748,0.081608,0.98122],[-0.66299,-0.68993,-0.29059],[0.99471,0.10216,-0.010949],[-0.96098,-0.17482,-0.21436],[0.81589,0.028845,-0.57749],[-0.71047,-0.67903,0.18483],[0.53195,-0.736,0.41872],[-0.77074,-0.60139,0.21047],[-0.92497,-0.12702,-0.35818],[-0.26549,0.11202,0.95758],[-0.28986,-0.29031,0.91198],[-0.079115,0.84379,0.53081],[0.56292,-0.10882,0.81932],[0.69983,-0.57797,0.41975],[-0.041144,-0.24854,0.96775],[0.95181,-0.27301,0.13976],[0.65568,-0.12416,0.74476],[0.54004,-0.52561,-0.65733],[0.66349,-0.16997,0.72863],[-0.71137,-0.70282,0.00014367],[0.68213,-0.4886,-0.54403],[-0.98113,0.054962,0.1854],[0.98862,0.1382,-0.059437],[0.66323,-0.51916,0.53908],[-0.8909,-0.21428,0.40049],[-0.97449,0.051358,-0.21849],[-0.88656,-0.12461,0.44552],[-0.28687,0.22051,0.93225],[0.39799,0.27112,0.87641],[-0.90887,-0.40497,0.099811],[0.36402,-0.62835,0.6875],[0.55503,-0.71637,0.42279],[0.83648,-0.18189,-0.51693],[0.80971,-0.54364,0.22097],[-0.30392,-0.41234,-0.85884],[-0.17455,-0.53055,-0.82949],[0.97544,0.050949,0.21429],[-0.013583,-0.67506,-0.73764],[0.88207,-0.43165,0.18876],[0.88446,0.44176,-0.15029],[0.29809,-0.69017,-0.6594],[0.84142,-0.24549,-0.48139],[0.9827,0.021646,0.18394],[0.90738,-0.38274,0.17372],[0.98731,0.15335,0.041244],[-0.93661,-0.34998,0.016627],[0.039649,-0.3341,0.9417],[-0.77346,-0.57237,0.27231],[-0.79138,-0.13532,-0.59617],[-0.81489,-0.49104,-0.30793],[0.34337,-0.41067,-0.84466],[0.51621,0.073702,0.85329],[0.87239,-0.24397,-0.42358],[0.43247,-0.14525,0.88987],[-0.90627,0.29916,-0.29863],[-0.92966,0.35948,-0.080712],[0.33631,-0.39258,-0.85603],[0.22243,-0.24106,0.94468],[-0.85945,-0.22029,-0.46133],[0.91262,0.39786,-0.093959],[-0.86543,-0.49892,0.046012],[0.96721,-0.23168,0.10408],[0.4215,-0.44381,-0.7908],[0.89565,-0.12848,-0.42579],[-0.90089,0.2009,-0.38476],[0.91182,-0.0073593,0.41053],[0.98638,-0.10843,0.12372],[-0.88674,-0.44619,-0.12083],[-0.52374,-0.84428,0.11348],[0.96102,0.0088963,0.27635],[-0.77502,0.61979,0.12332],[0.58021,-0.37276,-0.72416],[-0.43694,-0.89949,0.0010656],[0.41643,-0.85665,0.30452],[-0.85328,0.51559,0.077995],[0.72567,-0.30088,-0.61878],[0.99041,-0.033146,0.1341],[-0.77348,0.0088228,-0.63376],[0.25369,-0.95747,0.13748],[0.28396,-0.95625,-0.07031],[0.59356,-0.72059,-0.35838],[-0.89976,0.40762,-0.15579],[0.62339,-0.10049,-0.77543],[-0.79033,0.21882,-0.57228],[0.88988,-0.09216,-0.4468],[-0.60386,-0.79081,-0.09986],[-0.94848,-0.31403,0.042046],[0.71984,-0.43405,-0.54169],[-0.70327,0.11087,0.70222],[0.72351,-0.097033,-0.68346],[0.86664,0.19814,-0.4579],[0.45289,-0.21088,0.86627],[0.95595,0.029864,0.29202],[-0.80887,0.36745,-0.45902],[-0.92581,-0.1998,-0.32088],[0.86637,0.071784,0.49422],[0.97208,0.22974,0.047694],[0.57554,-0.4833,-0.65968],[-0.009379,-0.40093,0.91606],[0.72331,0.13482,0.67724],[0.69292,0.045989,-0.71955],[0.94693,-0.098853,0.30587],[0.89684,-0.18541,0.40162],[-0.75983,0.074239,-0.64586],[-0.94356,0.33117,0.0049062],[-0.98898,-0.10937,0.09974],[0.89412,0.066875,-0.44281],[0.97025,0.20894,-0.12232],[-0.77962,-0.37264,0.50332],[0.49317,-0.8616,-0.1201],[-0.93384,0.35559,0.03865],[0.72901,-0.18163,0.65997],[-0.083949,0.82123,0.56439],[-0.88652,-0.069466,-0.45745],[-0.94539,0.28807,-0.15246],[-0.69087,0.0307,0.72233],[0.95022,0.26685,0.16084],[0.47852,-0.69704,-0.534],[-0.92416,0.17186,-0.34117],[-0.84224,-0.025216,0.53851],[-0.7587,0.12752,-0.63884],[0.86007,0.024914,0.50957],[0.90126,-0.26262,0.34462],[0.4752,-0.72652,-0.49635],[-0.9871,0.15794,0.026085],[0.94697,0.12317,0.29676],[-0.58917,-0.0074888,0.80798],[0.70311,0.22616,-0.67415],[0.83493,-0.55033,0.0050654],[-0.94733,0.31529,-0.056161],[0.75367,-0.44376,-0.48483],[-0.93409,0.18472,-0.30555],[-0.71358,0.13615,-0.68722],[0.95495,0.18414,-0.23274],[0.66835,0.26642,-0.6945],[-0.772,0.043801,-0.63411],[0.92577,-0.26109,0.27345],[0.43779,0.68185,0.58602],[0.69549,0.32201,-0.64234],[0.90515,-0.34862,-0.24325],[-0.90558,0.33383,0.26168],[-0.84785,0.16302,0.50456],[-0.73154,0.23197,-0.64112],[0.69369,-0.56059,0.45225],[0.85059,0.16935,-0.49781],[0.63839,0.76638,-0.071589],[-0.80041,0.58764,-0.1184],[0.91802,0.085284,0.38726],[0.065546,-0.41278,0.90847],[0.89978,-0.26896,-0.34359],[0.78587,-0.61336,-0.078785],[-0.29081,-0.44669,0.84611],[-0.78138,0.61942,0.075933],[0.72228,0.62944,-0.28656],[0.97626,-0.10866,-0.18737],[-0.83873,-0.10623,-0.53408],[-0.55195,0.82676,-0.10873],[0.34988,0.91847,0.18438],[-0.74298,0.3629,-0.5624],[0.97269,0.12719,0.19417],[0.52943,0.84411,0.084751],[-0.78859,0.089116,-0.60843],[-0.8476,0.48692,-0.2109],[0.97213,0.17573,-0.1552],[-0.38171,0.91592,0.12405],[-0.40183,0.90108,0.16302],[-0.60482,0.1044,0.78949],[0.11432,0.99283,-0.03501],[-0.86571,0.14506,0.47907],[0.72591,-0.13136,-0.67513],[0.93371,0.35061,0.072468],[-0.72067,-0.34989,-0.59851],[-0.97097,-0.21723,-0.10017],[0.78171,0.61726,0.088979],[-0.93168,0.35736,0.065282],[-0.94503,0.19583,-0.26184],[0.66316,-0.47424,-0.57906],[-0.86127,-0.15534,-0.48382],[-0.76648,-0.095651,0.63511],[-0.77577,-0.062786,-0.62788],[0.73414,-0.34452,-0.5851],[-0.85706,0.49515,-0.14239],[0.69561,-0.065892,-0.71539],[0.63185,0.051022,0.77341],[-0.8253,0.31042,-0.47171],[-0.87088,-0.037673,-0.49004],[0.59658,0.11295,-0.79457],[0.9329,0.35383,-0.067128],[-0.74766,0.28999,-0.59742],[-0.97278,-0.031272,-0.22961],[-0.93189,0.28013,-0.23046],[0.8864,-0.19149,0.42147],[0.099593,0.48393,-0.86942],[0.33342,0.31288,-0.88935],[0.83579,-0.11963,0.53586],[0.90417,-0.23317,0.35792],[0.068938,0.40545,-0.91152],[-0.043856,0.85033,-0.52442],[0.31987,-0.23122,0.91882],[0.32308,0.92556,-0.19735],[0.22781,0.92514,-0.30367],[-0.26872,0.71088,-0.64995],[-0.11564,0.6194,-0.77651],[-0.88232,0.28522,0.37437],[-0.75537,0.0046341,0.65528],[-0.39068,0.2823,-0.87617],[0.34467,0.066722,-0.93635],[0.22465,0.30254,-0.92628],[0.22875,0.63333,-0.7393],[-0.98761,0.083207,-0.13308],[0.16403,0.58883,-0.79144],[0.8232,0.45767,0.33596],[0.013976,0.88509,0.46522],[-0.2492,0.27606,-0.92827],[0.97162,0.16007,0.17414],[-0.038385,-0.34117,-0.93922],[-0.8648,0.15356,0.47807],[0.99366,0.079243,-0.079797],[-0.51741,0.34221,0.78433],[0.77159,0.61361,0.16775],[0.055378,0.50136,-0.86346],[-0.44722,0.050654,-0.89299],[0.39314,0.2451,-0.88621],[0.66334,0.10121,0.74144],[-0.39843,-0.26261,-0.8788],[-0.79521,0.57184,-0.20159],[-0.26918,-0.43364,-0.85994],[0.25129,-0.56391,-0.78667],[-0.9826,0.081873,0.16669],[0.75764,0.53031,0.38047],[0.90204,0.39256,0.17949],[0.04769,0.21476,-0.9755],[-0.37615,0.0814,-0.92298],[-0.84866,0.49612,-0.18343],[0.060856,0.82959,-0.55504],[0.15932,0.76897,-0.61911],[-0.45042,0.30527,0.83901],[-0.99998,-0.0066444,0.00070703],[0.97222,0.017758,0.23338],[-0.83192,-0.35431,-0.42706],[0.9659,0.22199,-0.13329],[0.0026863,-0.27107,-0.96255],[0.72672,-0.57844,-0.37052],[0.23877,-0.12769,-0.96264],[-0.29185,0.17749,-0.93985],[-0.10047,0.50574,-0.85682],[0.068319,0.78102,-0.62076],[0.10433,0.82311,-0.55822],[0.084811,0.9082,-0.40986],[-0.84993,-0.0086836,0.52682],[0.96731,0.0097076,0.25343],[0.86364,0.48157,-0.14905],[-0.51757,-0.33916,-0.78555],[-0.98168,0.033621,0.18753],[0.35921,-0.31363,-0.87898],[-0.59719,0.72547,-0.34213],[0.063537,0.75976,-0.6471],[-0.71633,-0.11427,-0.68835],[0.59151,-0.014316,0.80617],[-0.94932,-0.1901,-0.2503],[-0.51296,-0.017637,0.85823],[-0.89202,-0.25886,-0.37053],[-0.74491,0.646,-0.16672],[-0.81366,-0.25868,0.52062],[0.5005,-0.28136,-0.81874],[0.96871,0.24305,-0.050235],[-0.94923,-0.17286,-0.26283],[0.75192,0.65133,0.10195],[-0.57836,0.74496,-0.33247],[0.80416,0.48815,0.33917],[-0.9796,-0.1454,0.13876],[0.61133,0.16774,0.77339],[0.93181,0.09391,0.3506],[-0.67666,-0.072622,0.73271],[-0.95511,-0.13331,-0.26455],[0.8286,0.2442,0.50377],[-0.94575,-0.21422,0.24425],[0.63127,-0.26781,-0.72786],[-0.83953,0.0051877,-0.54329],[0.73846,-0.50002,-0.45238],[0.00024379,0.022633,0.99974],[0.65826,-0.20255,-0.72503],[-0.67882,0.66381,-0.31393],[0.70889,-0.22005,0.67011],[-0.9607,-0.25816,0.10205],[0.77495,-0.18986,-0.60284],[-0.87455,-0.11103,0.47205],[0.96674,-0.070765,0.24578],[-0.90499,0.38938,-0.1714],[0.97223,-0.031375,0.2319],[0.87849,0.1277,0.46038],[-0.88373,-0.051645,-0.46514],[-0.53398,0.03586,0.84474],[0.37855,0.76551,0.52029],[0.014234,0.83771,0.54593],[0.30331,0.74097,0.59914],[-0.0027911,-0.97168,-0.2363],[-0.69375,0.19054,0.69456],[0.89126,-0.32683,0.31439],[0.83037,0.04922,0.55503],[0.98061,0.15801,0.11592],[0.61117,0.71712,0.33498],[-0.9639,-0.26623,-0.0040376],[-0.92025,0.059067,-0.38684],[-0.68784,0.259,0.67808],[0.14675,0.16411,0.97546],[-0.52314,0.15381,0.83825],[-0.97574,0.21835,0.016208],[0.90451,0.42014,-0.073021],[0.93344,0.32212,0.15789],[-0.77657,0.20827,0.59461],[-0.38565,0.73122,0.56266],[0.89109,-0.44766,0.074641],[-0.98002,0.15748,0.12149],[-0.71051,0.41318,0.56961],[0.5746,0.81733,-0.042423],[-0.84133,-0.49087,-0.22629],[-0.98712,0.13065,-0.092349],[0.9371,0.10314,-0.33347],[0.72248,0.67357,0.15594],[0.94922,0.31374,0.023619],[-0.78656,0.33053,-0.5216],[-0.93864,0.2491,0.23855],[-0.80941,-0.55242,-0.19924],[0.84916,0.50331,0.16002],[-0.74616,0.48866,0.45216],[0.19246,0.27434,0.94218],[-0.24608,-0.67299,0.69752],[0.91431,0.31597,-0.25337],[-0.87688,0.4708,0.097133],[-0.69475,-0.66524,-0.27347],[-0.72248,0.46347,-0.51305],[-0.0016676,0.14546,0.98936],[0.088307,0.82391,0.5598],[-0.92885,0.24208,0.28042],[-0.72169,0.4888,-0.49014],[0.82116,-0.56464,-0.082919],[0.95927,-0.27374,0.069775],[-0.62748,-0.028502,0.77811],[-0.60429,-0.69091,-0.39683],[0.95212,0.045767,0.30227],[-0.97903,0.13647,0.15127],[-0.53024,-0.73114,-0.42927],[-0.13961,-0.14869,0.97898],[0.40722,0.10516,0.90726],[0.38421,-0.77095,-0.50796],[0.15677,0.24261,0.95737],[0.7311,-0.63702,-0.24433],[0.58107,0.80673,0.10744],[0.50658,0.12603,0.85293],[-0.35913,0.85215,-0.3806],[0.81198,0.55497,-0.18081],[-0.98987,-0.13963,0.025893],[0.71044,-0.6729,-0.2061],[0.20375,0.79459,0.57194],[-0.64038,-0.51205,-0.57246],[-0.84388,0.15118,0.5148],[0.015666,-0.50015,-0.8658],[-0.17132,0.88371,-0.43556],[-0.12029,-0.66471,-0.73736],[-0.97793,-0.19365,0.078408],[-0.83097,-0.18279,0.52543],[0.61947,-0.7183,-0.31669],[0.32143,0.18285,0.92911],[-0.947,-0.28919,0.13984],[0.61613,-0.046713,0.78626],[-0.73096,0.16439,0.66233],[0.88806,0.33268,0.31728],[0.25538,0.82242,0.50834],[-0.63145,0.63322,-0.44754],[0.56007,-0.74875,-0.35454],[0.97477,-0.22314,0.0059255],[-0.87957,0.27447,0.38862],[0.92965,0.032575,0.36701],[0.85321,0.022102,0.52111],[0.029087,-0.37235,0.92764],[-0.75753,0.13014,0.6397],[0.13654,0.8563,-0.49811],[0.83459,-0.24975,0.491],[0.43349,-0.78626,-0.44031],[0.59753,0.1637,0.78496],[-0.95701,-0.15182,-0.24716],[0.38427,-0.81121,-0.44076],[-0.50794,0.83328,-0.21826],[0.59291,0.12991,0.79472],[0.38684,-0.76658,-0.51255],[-0.5842,0.49782,0.64101],[-0.41297,0.075627,0.9076],[0.37455,0.20102,0.90515],[-0.73858,0.55968,0.37584],[-0.62863,-0.28797,0.72242],[-0.95787,-0.23324,0.16757],[0.75004,-0.5172,-0.41224],[0.44317,0.89644,-0.00016509],[-0.45616,0.86872,-0.193],[-0.4143,0.88523,-0.21149],[0.70858,0.70546,-0.015586],[0.76005,0.6425,0.097605],[0.18135,0.80436,0.56579],[-0.21447,0.87037,0.44325],[0.75391,-0.20181,0.62521],[-0.76708,-0.60419,-0.21576],[0.91668,-0.39681,0.047204],[-0.14392,0.98287,-0.11513],[0.08582,0.97107,-0.22283],[0.68623,-0.16654,0.70806],[0.38533,-0.78711,-0.48164],[0.16545,-0.92552,-0.34065],[-0.26156,-0.85788,-0.44231],[0.16869,-0.94386,-0.28402],[-0.23446,-0.96917,-0.075703],[0.69071,-0.53966,-0.48134],[0.95713,-0.049195,0.28544],[0.79985,-0.005112,-0.60018],[-0.041834,-0.96567,0.25637],[0.23185,-0.93419,0.27117],[-0.6709,-0.098276,0.73501],[-0.47689,-0.83056,-0.28766],[0.77015,0.40623,-0.49178],[-0.40391,-0.9059,0.12732],[-0.26605,-0.95036,0.16135],[-0.058204,-0.97107,0.23159],[0.47432,-0.84615,0.24299],[0.66235,0.10147,0.74229],[-0.53183,-0.84169,-0.09332],[-0.5951,0.71498,0.36696],[0.10197,-0.34829,0.93182],[-0.63376,-0.7735,0.006846],[0.69522,-0.70157,0.15642],[-0.91581,-0.38165,-0.12508],[0.76612,0.49003,-0.41586],[-0.69005,-0.71757,0.094449],[-0.67596,-0.67508,-0.29555],[0.88718,-0.39756,0.23422],[-0.79601,-0.57356,-0.1934],[0.7025,-0.67814,0.21589],[-0.86507,-0.49213,-0.097231],[0.72896,0.009273,0.68449],[0.59288,-0.45401,-0.66511],[-0.97075,0.22959,0.070279],[0.60334,-0.42441,-0.67517],[-0.77876,-0.31854,0.54043],[0.60752,-0.0070705,0.79427],[0.32458,-0.82576,-0.46127],[0.59129,-0.52388,-0.61312],[-0.81363,0.43751,-0.38286],[-0.82033,-0.56413,0.093869],[0.62298,-0.6957,0.35764],[-0.74473,-0.65183,0.14319],[0.35266,0.15067,0.92354],[-0.98311,-0.067601,-0.1701],[0.75017,-0.5486,0.36915],[0.97684,-0.21099,0.035464],[0.65502,-0.46471,-0.59582],[0.91689,0.24042,0.3186],[-0.27007,0.79822,0.53844],[-0.75032,0.24568,0.61373],[-0.86061,-0.50218,0.084679],[-0.55422,-0.48986,0.67296],[-0.74223,-0.67004,0.011482],[0.78855,-0.38621,-0.47858],[0.77429,-0.15926,0.61247],[-0.98988,-0.13296,-0.04953],[-0.11558,-0.54837,-0.82821],[-0.63742,-0.76549,-0.087881],[0.94784,-0.020705,0.31808],[0.12473,-0.61018,-0.78238],[0.65153,0.2134,0.72799],[-0.29117,0.23062,0.92846],[0.30517,-0.61774,0.72476],[-0.35826,-0.30214,-0.88338],[0.71873,0.041077,0.69407],[0.090194,-0.63781,-0.76489],[-0.89228,-0.44564,-0.072441],[0.048494,-0.99697,0.060839],[0.56709,-0.51697,0.64121],[-0.64476,-0.12429,-0.75422],[0.32746,-0.69412,-0.64107],[0.29115,0.14797,0.94516],[-0.97651,-0.20809,0.055928],[-0.8797,-0.46716,0.088853],[-0.55618,-0.18363,-0.81052],[0.016398,-0.21705,0.97602],[0.30257,-0.5583,-0.7725],[0.31768,-0.57665,-0.7527],[-0.72193,0.2834,0.63127],[-0.22903,-0.9677,0.10532],[0.88949,-0.43298,0.14604],[0.69573,0.1938,0.69166],[-0.82207,0.17999,-0.54018],[-0.63675,-0.39691,0.66107],[0.33116,-0.39483,-0.857],[0.5058,-0.72778,0.46315],[0.28415,-0.41867,-0.86254],[0.42038,0.080907,0.90373],[0.72632,0.13648,0.67367],[-0.78485,0.60153,0.14892],[0.56969,-0.81877,0.071221],[0.47304,-0.43117,-0.76832],[-0.51754,-0.81355,0.26514],[-0.83398,-0.47107,-0.28735],[0.8898,-0.26735,-0.36984],[-0.86811,0.45002,0.20947],[0.59274,-0.402,-0.69789],[-0.83475,-0.44625,-0.32256],[-0.81575,-0.17813,-0.5503],[0.92241,-0.0058709,-0.38616],[0.53204,-0.75754,0.37824],[0.057151,-0.98793,0.14395],[0.74486,-0.014916,0.66705],[-0.79661,-0.60057,0.068752],[-0.80195,0.57389,-0.16589],[-0.39993,-0.27444,0.87449],[0.75294,-0.30952,-0.58075],[-0.14326,0.29413,0.94497],[0.90715,-0.048855,-0.41797],[-0.33759,-0.92122,0.19334],[0.44451,-0.89554,0.020518],[-0.95269,0.28419,-0.1078],[-0.78137,0.15814,-0.60369],[0.50543,-0.84379,-0.18044],[-0.29462,-0.22335,0.92915],[-0.95115,0.096484,-0.29328],[-0.46858,0.22247,0.85495],[-0.76486,0.08793,0.63817],[0.71817,-0.13531,0.68259],[-0.31569,-0.92671,0.20382],[0.57968,-0.69884,0.41903],[-0.86367,0.2635,-0.4297],[0.90396,0.40165,0.14672],[0.72128,-0.20448,-0.66177],[-0.12234,-0.99125,0.049497],[0.74262,-0.36347,-0.56251],[-0.60325,-0.068448,0.79461],[-0.80854,0.25704,-0.52933],[0.90112,0.12386,-0.4155],[0.76385,-0.16417,-0.62416],[-0.87665,0.13668,-0.4613],[-0.79773,0.44921,-0.40228],[-0.70906,0.29823,0.63898],[0.61269,0.090521,0.78512],[0.61047,-0.61902,-0.49411],[-0.92325,-0.12693,-0.36262],[-0.75567,0.039523,-0.65376],[0.66199,-0.71571,-0.22256],[-0.40958,-0.18895,0.89249],[0.69214,0.72144,0.021489],[0.81855,-0.24636,-0.51892],[-0.74059,0.10749,-0.6633],[-0.61448,-0.081424,0.78472],[0.7753,0.13022,0.61803],[0.23785,-0.93332,-0.26898],[0.61543,-0.78681,0.046677],[-0.98726,-0.12982,0.091963],[0.36956,0.055445,0.92755],[-0.92355,0.37283,-0.08971],[0.70803,-0.48769,-0.51074],[0.38107,-0.73675,-0.55856],[0.23408,-0.81587,-0.52874],[-0.027757,-0.99742,-0.066164],[0.66749,0.25372,-0.70005],[-0.84149,0.47453,0.25829],[-0.596,-0.24575,0.76445],[0.56923,-0.60682,-0.55475],[-0.7087,0.14839,-0.68972],[0.63975,-0.03116,0.76795],[-0.92696,0.37071,0.057559],[0.89466,-0.088423,-0.4379],[-0.79619,0.12998,-0.59092],[0.16371,0.030369,0.98604],[0.88703,-0.4111,0.21019],[-0.72643,-0.18507,0.66185],[0.81293,0.46705,-0.34788],[0.066888,-0.98941,-0.1288],[0.90847,0.40454,-0.10502],[-0.75243,0.19633,-0.62873],[0.87066,-0.34655,0.34907],[-0.8602,0.50597,0.063543],[0.82283,0.56769,0.026285],[0.46367,-0.841,0.2788],[-0.93567,0.34067,-0.092038],[0.90987,-0.24025,0.33825],[-0.40729,-0.13632,0.90307],[0.68459,0.72683,0.055289],[-0.76755,0.62107,0.15859],[0.86848,0.44451,-0.21945],[0.68069,0.19621,-0.70581],[0.61658,0.031446,0.78667],[0.97174,-0.17126,0.16248],[-0.67287,0.38698,0.63047],[-0.7575,0.63898,0.13381],[0.62389,-0.58871,0.51398],[0.5838,-0.54696,0.60002],[-0.6961,0.31815,-0.64361],[0.86531,-0.20359,-0.45803],[0.74615,0.60137,-0.28568],[-0.77816,-0.14486,0.61113],[0.97838,0.074398,0.19296],[-0.21567,0.25583,0.94236],[0.89165,-0.4115,-0.18877],[-0.92911,-0.082028,0.3606],[0.5713,0.79944,-0.18578],[0.98432,-0.17117,0.042638],[0.8267,0.50836,-0.24112],[0.87774,0.25131,0.40794],[-0.67361,0.30681,0.67239],[0.27435,0.96136,0.022783],[0.59739,-0.73907,0.31131],[0.53845,0.16643,0.82606],[0.982,0.033763,-0.18583],[-0.53334,0.82244,0.19785],[0.58733,0.79573,0.14781],[0.5804,-0.050145,0.81279],[-0.41947,0.87915,-0.22615],[0.93123,0.2059,0.3007],[0.31791,0.31407,0.89459],[-0.28467,-0.20512,0.93642],[0.50804,-0.0016715,0.86133],[0.31582,0.93467,0.16323],[-0.91667,-0.036656,0.39796],[-0.86232,-0.16646,-0.47821],[-0.097046,0.99366,0.056773],[0.042044,0.99825,-0.04151],[-0.061168,0.9952,0.076406],[0.18153,0.97465,0.13076],[-0.24526,0.15754,0.95657],[0.97817,0.17766,0.10783],[-0.62036,-0.07954,0.78027],[-0.20823,-0.20346,0.95668],[0.68834,-0.57383,0.44375],[0.72487,0.049308,0.68712],[-0.8601,-0.18569,-0.47512],[0.91606,0.37819,0.13345],[-0.75596,-0.30334,-0.5801],[0.68417,-0.52104,0.51032],[0.98437,-0.035866,0.17244],[-0.86087,0.21504,-0.46114],[0.55555,0.23913,0.79636],[-0.11676,0.84708,0.51849],[-0.85946,-0.17231,0.48129],[0.17249,-0.74764,0.64131],[0.044158,-0.97348,-0.22449],[-0.78048,-0.15619,-0.60536],[0.79935,0.50242,0.32957],[-0.85042,0.38321,-0.36046],[0.68436,-0.10492,-0.72155],[-0.79664,-0.083845,0.59861],[-0.153,-0.75398,0.63883],[0.99825,-0.014462,0.057259],[-0.11602,0.8541,-0.507],[0.71798,-0.59406,0.36277],[-0.8854,0.17565,-0.43036],[0.63593,0.43786,0.63551],[0.78115,-0.06822,0.6206],[0.36678,0.82254,-0.43462],[0.67442,-0.59896,0.43174],[0.074856,0.8692,0.48876],[0.28963,-0.082771,-0.95355],[-0.67391,-0.28226,-0.68277],[0.92137,0.35559,0.15694],[-0.8458,-0.42613,-0.321],[-0.3351,0.5545,-0.76173],[-0.10862,0.15939,-0.98122],[0.7066,0.0059912,0.70759],[0.59981,-0.36065,-0.71425],[0.94933,0.027509,0.31306],[0.97569,0.10369,0.19305],[-0.60296,-0.0158,-0.79761],[-0.92226,-0.028217,-0.38553],[0.087061,0.42838,-0.8994],[0.4585,0.2667,-0.84773],[0.63739,-0.74081,0.21197],[-0.44639,0.075243,-0.89167],[-0.4664,-0.15651,0.87062],[0.84211,-0.42098,-0.33708],[0.8547,-0.27992,0.43719],[-0.70433,-0.37039,-0.60559],[-0.21823,0.069849,-0.97339],[0.93647,-0.1092,0.33331],[-0.8678,-0.30249,0.39424],[0.34272,0.44202,-0.82895],[-0.63059,-0.17603,-0.75589],[0.96835,-0.24486,0.04848],[0.85485,0.32719,0.40272],[0.82636,-0.013189,0.56299],[-0.90725,-0.10583,-0.40705],[0.18617,0.11865,-0.97533],[0.06869,0.30069,-0.95124],[-0.1514,0.16233,-0.97505],[-0.89367,-0.41643,-0.16716],[-0.98641,-0.10623,0.12531],[0.13074,0.16582,-0.97745],[0.2507,0.89868,-0.35991],[0.83354,0.50339,-0.22762],[-0.020851,0.92561,-0.3779],[0.44189,0.67117,0.5952],[0.12289,0.92125,-0.36906],[0.058036,0.93254,-0.35638],[-0.9969,0.0031026,0.078555],[0.3333,-0.12439,-0.93458],[0.37804,-0.010583,-0.92573],[-0.75164,0.039946,0.65837],[-0.80218,0.52419,-0.28589],[-0.14047,0.52016,-0.84244],[0.28319,0.88611,-0.36689],[0.065124,0.92595,-0.372],[0.1017,0.90323,-0.41694],[0.93384,0.099005,0.34373],[-0.91704,-0.10452,0.38484],[-0.97503,0.022969,0.2209],[-0.85191,-0.35569,-0.38437],[0.7115,-0.012692,0.70257],[-0.10959,0.33855,-0.93454],[-0.020553,0.67733,-0.73539],[-0.95962,0.27532,-0.057719],[0.16018,0.84879,-0.50389],[0.62487,-0.77547,0.090484],[0.61822,0.58431,0.52572],[-0.82942,-0.47911,-0.28727],[0.4325,0.024833,-0.90129],[-0.60846,0.72768,-0.31665],[0.84594,0.44245,0.29768],[0.67946,-0.12226,-0.72345],[-0.29751,0.32068,0.89925],[0.96564,0.013567,0.25954],[-0.96929,-0.24589,0.0044613],[0.76259,0.4855,0.42748],[0.0089165,-0.97736,-0.21141],[-0.88663,-0.0337,-0.46126],[0.97586,-0.0068787,0.21827],[-0.62775,0.036047,0.77758],[-0.85373,0.010305,0.52062],[0.56153,-0.030947,0.82687],[-0.59044,0.10813,0.7998],[-0.89415,0.28064,-0.34891],[-0.96124,0.14311,0.23566],[0.10044,0.81884,0.56517],[-0.51634,0.3677,0.77343],[0.67175,0.55599,0.48952],[0.84539,-0.065169,-0.53017],[0.89776,-0.43968,-0.026615],[-0.88071,0.4338,-0.19019],[0.74963,0.60028,-0.27877],[0.88909,-6.7948e-05,-0.45774],[-0.92554,-0.3561,-0.12873],[0.87954,0.46941,-0.077901],[-0.87503,0.17949,-0.44955],[0.87351,-0.48087,-0.075763],[0.70782,0.69339,-0.1349],[0.45256,-0.82675,-0.33417],[0.14041,0.15827,0.97736],[-0.45679,0.45371,0.76518],[-0.83228,0.39633,0.3876],[-0.5012,0.81041,-0.30338],[0.80668,-0.57096,-0.15252],[-0.098246,-0.96861,-0.22833],[0.95606,-0.068999,0.28492],[0.55636,0.8117,0.17775],[-0.47142,0.83017,-0.29762],[0.80372,-0.58722,-0.095978],[0.60626,0.29754,0.73751],[-0.13864,0.79472,0.59093],[-0.94628,0.14127,0.29086],[0.98308,0.032861,0.1802],[-0.48596,-0.018894,0.87377],[-0.16242,0.41893,0.89338],[0.87219,0.43551,-0.22275],[-0.83563,-0.48083,0.26557],[-0.23522,0.48567,0.8419],[-0.49032,-0.68309,-0.54127],[0.62462,0.23838,0.74366],[0.93671,-0.32536,0.12927],[-0.42465,0.85411,-0.30028],[0.84291,0.4951,-0.21066],[-0.30042,-0.15972,0.94034],[0.76657,-0.58366,-0.26778],[0.78234,0.55775,0.27724],[-0.33646,-0.68327,-0.64802],[0.74035,-0.031488,0.67148],[0.95727,-0.1462,0.24954],[-0.70592,0.55066,-0.44548],[-0.21914,0.24075,0.94552],[-0.42796,-0.61011,-0.6668],[-0.862,-0.50634,-0.023854],[0.077691,-0.46807,-0.88027],[-0.83732,0.37008,-0.40242],[-0.67954,0.11546,0.7245],[-0.21216,-0.67382,-0.70778],[-0.85678,-0.44183,0.26591],[0.51878,0.7802,-0.34951],[-0.95513,-0.29541,0.021618],[-0.46147,0.85625,-0.23214],[0.63732,0.15138,0.75558],[-0.87199,-0.47429,0.12119],[-0.97003,0.035551,0.24038],[-0.68668,0.54083,-0.48577],[0.062032,0.86449,0.49881],[0.64743,0.59307,-0.47864],[0.95063,-0.030903,0.30878],[0.93428,-0.25343,0.25078],[-0.84289,0.078679,0.53231],[-0.69508,0.58989,-0.41096],[0.85098,0.3952,0.3459],[0.83586,-0.41384,-0.36066],[0.54226,-0.70477,0.45743],[-0.53384,0.64939,0.54159],[0.18523,0.82465,0.53445],[-0.7645,0.075649,0.64017],[0.20704,-0.17022,0.96341],[0.98363,-0.0065851,0.18006],[0.45853,0.42878,0.7784],[-0.67245,0.66333,-0.32833],[0.76841,0.6381,-0.048752],[0.80027,-0.39813,-0.44839],[-0.77239,-0.61807,0.1463],[-0.6104,0.75339,-0.24455],[0.65284,0.57724,-0.4905],[-0.6742,0.31333,0.66879],[-0.76953,0.34038,0.54033],[0.63383,0.77344,0.0067594],[-0.95732,-0.20853,0.20012],[-0.73485,0.016382,0.67804],[0.60326,-0.39126,-0.69498],[0.78719,-0.55549,-0.26789],[0.54428,0.10739,0.832],[-0.88123,0.29107,0.37243],[-0.87862,0.3019,0.36999],[0.98837,-0.14848,0.032923],[-0.49412,0.60239,0.62688],[0.73747,0.58961,0.32939],[-0.8527,0.14783,0.50104],[0.43072,0.88972,0.15126],[0.0082614,0.956,0.29327],[0.75499,-0.0050435,0.65571],[-0.017824,0.31379,0.94933],[-0.31315,0.94669,-0.075621],[0.2258,0.97383,-0.025928],[-0.11901,-0.97337,-0.19591],[-0.17748,-0.16203,0.9707],[-0.88558,0.18128,0.42765],[-0.17663,-0.89636,-0.40662],[0.30228,-0.86429,-0.40202],[-0.41493,-0.82144,-0.39124],[-0.83572,0.049903,-0.54688],[-0.35213,-0.83019,-0.43219],[0.20039,-0.91063,-0.36138],[0.42342,-0.69378,-0.58257],[0.79696,0.60375,-0.018578],[0.4295,-0.40731,0.806],[-0.11418,0.87479,-0.47086],[0.53962,0.26156,0.80025],[0.52002,-0.24408,-0.81854],[0.57539,-0.31694,-0.75398],[-0.4458,-0.89505,0.012397],[-0.26771,-0.96244,-0.045217],[-0.63604,-0.035925,0.77082],[-0.50161,-0.86472,0.025395],[-0.78943,-0.59843,0.13669],[-0.17778,0.83312,-0.52374],[-0.061021,-0.9741,0.21774],[0.60839,0.2106,0.76519],[-0.42196,-0.39654,0.81529],[-0.54876,-0.82469,-0.13695],[-0.70012,-0.714,0.0058481],[0.73388,0.36573,-0.57242],[-0.55045,0.74157,0.38351],[0.77412,-0.6325,0.026042],[0.93569,0.31339,-0.16209],[0.79973,0.0048038,-0.60034],[-0.74438,-0.059391,0.66511],[-0.56341,0.67749,0.47285],[-0.72171,-0.69139,0.033518],[-0.76318,0.056251,0.64374],[0.46134,0.15943,0.87278],[-0.56607,0.43738,0.69876],[-0.83203,-0.55396,-0.02906],[0.92613,-0.35604,0.12454],[0.71736,-0.47498,-0.50969],[0.99302,0.069955,0.094962],[0.57601,-0.7617,0.29668],[-0.30066,0.87765,-0.37327],[-0.58272,0.33548,0.7402],[0.60973,-0.15721,-0.77687],[0.46784,0.11714,0.87602],[-0.81983,-0.55991,0.11991],[0.78985,-0.39706,-0.46741],[0.31056,0.14892,0.93882],[0.93085,-0.22618,0.28699],[0.79489,-0.55192,0.25205],[-0.26396,-0.51575,-0.81506],[-0.12007,-0.16776,0.97849],[-0.94351,-0.25872,0.20701],[-0.057993,-0.71639,-0.69528],[0.10628,-0.67297,-0.732],[0.067881,-0.59621,-0.79995],[-0.56964,0.20047,0.79707],[-0.062071,-0.56819,-0.82055],[-0.84527,0.39743,0.35717],[-0.96691,0.25492,-0.010209],[-0.34359,0.79829,-0.49465],[-0.50729,-0.40237,-0.76207],[-0.91552,-0.10779,0.38756],[0.019547,-0.53305,-0.84586],[0.92029,0.21138,-0.32922],[0.37028,-0.69641,-0.61474],[-0.87131,-0.4709,0.13808],[0.71894,-0.57716,0.38732],[0.37945,-0.61337,0.69267],[0.93138,0.0071411,0.36397],[-0.81024,-0.0037307,-0.58609],[0.71388,-0.16146,0.68139],[0.15595,-0.74216,-0.65183],[-0.54617,0.11957,0.8291],[0.83986,-0.10815,-0.53192],[0.64346,-0.63963,-0.4205],[0.77397,-0.26232,0.57633],[-0.88561,0.35477,-0.29973],[-0.87097,-0.49065,0.025989],[0.55092,-0.60293,0.57702],[0.92702,0.029257,0.37387],[0.50612,-0.43777,-0.7431],[-0.81258,-0.51009,-0.28201],[-0.72133,-0.67218,0.16689],[-0.95877,0.00080189,0.28418],[0.6756,-0.58972,0.44249],[-0.81404,0.58025,-0.025451],[-0.56549,0.31762,0.76114],[-0.98942,0.13252,-0.058994],[0.58915,-0.38225,-0.71189],[0.82344,-0.36302,0.43607],[-0.99266,-0.062557,0.10352],[-0.90223,0.23247,0.36323],[-0.75385,-0.63494,0.169],[0.79759,0.51194,-0.31902],[-0.81212,0.55532,0.17913],[-0.13472,-0.26603,0.9545],[-0.89155,0.43763,0.11667],[0.66985,-0.38982,-0.63193],[0.74551,-0.35404,-0.56469],[-0.9414,-0.19431,-0.27571],[-0.80452,0.32518,0.497],[0.95116,-0.27074,0.14832],[0.9818,0.0079207,0.18977],[-0.94107,-0.0052649,-0.33818],[0.8835,0.079359,0.46167],[-0.91346,0.15724,-0.37533],[-0.51504,0.73513,-0.44081],[0.72292,-0.35154,-0.59482],[-0.46326,-0.87633,0.13204],[0.21264,-0.97713,0.0023367],[-0.093761,0.27585,0.95662],[-0.67119,-0.73909,0.056923],[0.70313,-0.58508,-0.40409],[0.66618,0.67249,-0.32243],[0.20331,0.95521,-0.21501],[0.13076,0.97027,-0.20365],[-0.75979,0.45645,-0.463],[-0.75981,0.029878,0.64946],[-0.7755,0.40374,-0.48538],[0.70727,0.09418,0.70064],[-0.9244,-0.31244,-0.21879],[-0.65015,0.59384,-0.47398],[0.76801,0.54273,-0.33999],[-0.75581,0.0036778,-0.65478],[0.62584,-0.33352,-0.70504],[0.51197,-0.28056,-0.81189],[0.61654,-0.29102,-0.73156],[-0.69182,0.11023,0.7136],[0.5201,0.40322,0.75293],[-0.18539,0.34069,0.92172],[-0.73685,-0.014306,-0.67591],[0.56907,0.25221,0.78266],[0.73023,-0.51982,-0.44334],[-0.72001,0.31613,-0.61778],[0.79358,-0.1981,-0.57531],[0.69399,0.22376,-0.68433],[0.80672,0.04342,-0.58934],[0.95397,0.20985,0.21426],[-0.50064,-0.15153,0.85229],[-0.1108,0.26428,0.95806],[0.65004,-0.75723,-0.063692],[-0.82501,0.52273,-0.21473],[-0.56746,-0.8234,-0.0023479],[-0.7889,0.47894,0.38503],[0.39391,-0.58628,-0.70789],[0.7493,0.24088,-0.61687],[0.74211,-0.64591,0.17911],[0.7009,-0.17848,-0.69057],[-0.58844,0.061521,0.80619],[-0.049062,0.86418,0.50078],[-0.80491,0.1748,-0.56707],[0.88268,-0.39782,0.25022],[0.79582,0.24722,-0.55276],[0.51003,0.46961,0.72065],[0.68633,0.23651,-0.68776],[0.45938,0.82152,0.33776],[-0.50982,0.55464,0.65762],[-0.81528,0.21452,-0.53786],[0.89746,-0.35668,0.25951],[0.92152,-0.13745,0.36319],[-0.85351,-0.01348,-0.52091],[-0.55677,0.12961,0.82049],[0.68614,0.26689,-0.67674],[0.7379,-0.24459,0.62903],[0.45438,0.38434,0.80363],[-0.99084,-0.015688,0.13414],[0.91293,-0.064642,0.40296],[-0.74747,0.65991,0.076203],[-0.033657,-0.13067,0.99085],[0.79979,0.59123,-0.10382],[-0.85221,-0.065415,-0.51909],[-0.74279,0.31787,-0.58925],[-0.50844,0.19056,0.83975],[0.85064,-0.26342,-0.455],[-0.010702,0.31573,0.94879],[-0.93995,0.20033,0.27633],[0.64034,-0.71583,-0.27848],[-0.7649,0.63841,0.085745],[-0.52075,-0.84721,0.10515],[-0.82696,0.38561,0.4092],[0.55541,0.83031,-0.045924],[-0.7022,0.4539,-0.54854],[0.047309,0.31511,0.94788],[0.95851,-0.24858,-0.13951],[-0.72663,0.6679,0.161],[0.29056,0.95661,0.021719],[0.22072,0.9739,-0.052886],[-0.71323,0.39646,-0.57803],[-0.47872,0.57888,0.6601],[0.48277,0.40556,0.77618],[-0.53331,0.83342,0.14486],[-0.73698,0.26462,-0.62196],[0.71544,-0.10999,0.68996],[-0.32724,0.93959,0.10045],[0.9879,0.043821,0.14877],[0.40555,0.85396,0.32599],[0.29768,0.53704,0.78929],[0.66533,0.52947,0.52631],[-0.26367,0.95951,0.099084],[-0.062226,-0.39075,0.91839],[-0.3397,0.92846,0.15019],[-0.93424,0.25294,0.25145],[0.92134,-0.14337,-0.36137],[0.79239,0.28618,-0.53872],[-0.0024423,0.99913,0.041739],[0.15622,0.98063,-0.11815],[-0.70854,-0.35495,-0.6099],[-0.99729,0.05192,0.052123],[0.73719,-0.43251,-0.51912],[0.58946,0.15544,0.7927],[0.98207,0.049968,0.18176],[0.7878,-0.35809,-0.50114],[-0.89789,0.3968,0.19064],[0.63764,-0.77008,-0.019793],[0.80706,-0.10801,-0.58051],[0.97833,0.069382,0.19509],[-0.79383,0.41133,-0.44794],[-0.9861,0.072971,0.14926],[0.86113,0.42519,0.27868],[0.90482,-0.083219,-0.41759],[-0.79574,-0.24909,-0.55204],[-0.92358,0.31402,0.21997],[-0.94913,0.27077,-0.16075],[0.53268,0.57211,-0.62365],[0.034436,0.15938,0.98662],[-0.10319,0.81324,-0.57271],[-0.29444,0.5604,-0.77412],[0.56799,-0.82114,0.055783],[-0.88896,-0.2563,-0.37955],[-0.98392,0.037106,-0.17473],[0.53647,0.15265,-0.83],[-0.84935,-0.5141,0.11961],[-0.40489,0.44388,-0.7994],[-0.58657,0.11886,-0.80113],[0.97772,0.049825,0.20393],[-0.12479,0.68236,0.72029],[0.46115,0.0030179,-0.88732],[0.47973,0.14886,0.8647],[0.99295,0.11077,0.042126],[-0.99955,-0.024365,-0.017526],[0.36197,0.31537,-0.87722],[0.79529,0.54636,-0.2627],[-0.9766,0.1449,0.15892],[-0.65156,0.30242,0.69571],[-0.37458,-0.12183,0.91916],[0.16878,0.95689,-0.23639],[-0.075856,0.95354,-0.29157],[0.049856,0.87361,-0.48406],[0.17636,0.74125,-0.64764],[0.38708,0.44308,0.80861],[-0.64719,-0.028929,-0.76178],[0.85954,0.45881,0.22514],[-0.54024,0.25178,0.80296],[0.73686,0.14527,0.66025],[0.27855,0.88945,-0.36233],[0.23517,0.91307,-0.33316],[-0.09725,0.93206,-0.34901],[-0.76389,0.032354,-0.64454],[0.98615,0.056171,0.15604],[0.82732,0.43073,-0.36056],[0.68721,0.70591,0.17157],[-0.94018,0.048404,0.33721],[0.13768,0.43113,-0.89172],[-0.85154,-0.26936,-0.4498],[0.48073,-0.86306,0.15502],[-0.99739,-0.068357,-0.023421],[0.69827,0.65406,0.2909],[0.37294,0.44541,-0.81396],[0.2022,0.76488,-0.61161],[-0.87767,-0.027123,0.47849],[0.64451,0.69439,0.32005],[-0.94446,-0.17535,0.27794],[0.60293,0.16978,-0.77952],[-0.67662,-0.72814,0.1095],[0.93488,0.32344,0.14624],[-0.98056,-0.19615,-0.0052603],[0.23776,-0.93905,0.24829],[0.17871,0.8093,0.55955],[-0.37288,0.62585,0.68504],[-0.54732,0.19527,0.81382],[-0.68308,0.24712,0.68726],[-0.92723,-0.0227,-0.3738],[0.96066,-0.27078,-0.061735],[0.5,0.75103,0.43122],[0.62488,0.71564,0.31204],[-0.44533,-0.88745,0.11883],[-0.036627,0.65627,0.75364],[0.92027,-0.27747,-0.2759],[-0.27901,0.62433,0.72963],[-0.92623,-0.37687,-0.0086355],[-0.66077,0.61009,0.43723],[-0.76964,0.58583,-0.25389],[-0.5779,0.71872,0.38661],[0.88451,0.46651,-0.0034917],[0.87166,-0.47441,-0.12306],[-0.21315,-0.96078,0.17738],[-0.94613,0.3159,0.070992],[0.9289,0.1449,-0.3408],[-0.77548,-0.047869,0.62956],[0.5786,0.65313,0.48851],[-0.065475,0.22975,0.97104],[0.1164,-0.98993,0.080514],[-0.63827,0.58375,0.50185],[-0.6578,0.69297,-0.2951],[0.90923,0.39587,0.12882],[-0.47735,0.31292,0.82111],[0.37832,0.88145,0.28268],[0.3229,0.50828,0.79836],[-0.68518,-0.6125,-0.39417],[-0.97125,-0.2163,0.099431],[-0.60977,0.34803,0.71208],[-0.43857,0.68214,0.5851],[-0.6439,-0.60246,-0.47163],[-0.78774,0.61181,0.071829],[0.29034,0.82013,0.49304],[-0.24818,0.88728,-0.38877],[0.92558,0.35382,-0.13458],[-0.80654,0.40144,-0.43398],[0.77072,-0.57674,-0.27085],[-0.6952,0.58078,0.42354],[0.70755,0.69845,0.1074],[-0.51033,-0.65614,-0.55592],[0.087235,-0.15844,0.98351],[0.028447,-0.34839,0.93692],[0.15071,0.37024,0.91663],[0.7765,-0.51213,0.36711],[-0.46068,-0.63997,-0.61499],[0.026288,-0.46031,-0.88737],[0.86844,0.49528,-0.022382],[0.13997,0.48794,0.86158],[-0.72563,0.54423,0.42105],[-0.82085,-0.5156,-0.24566],[0.98443,0.062329,0.16436],[0.1243,-0.46926,-0.87427],[0.70853,-0.056854,0.70339],[0.66386,0.52656,0.53106],[0.045848,0.50467,0.8621],[-0.078399,-0.58045,-0.81052],[-0.18565,-0.60041,-0.77784],[0.08325,0.70292,0.70638],[-0.72172,0.55219,-0.41737],[-0.87094,-0.23327,0.43249],[0.57317,0.77955,-0.25254],[-0.83752,-0.41972,-0.34986],[0.104,0.4467,0.88862],[0.82669,0.5429,-0.14778],[-0.45912,0.73585,0.49774],[-0.74986,0.63151,-0.19724],[0.65303,-0.64425,-0.39813],[-0.69484,0.079872,0.71471],[-0.87505,-0.085208,0.47648],[0.41648,0.80466,0.42317],[0.79564,0.60394,-0.047036],[-0.76125,0.37442,-0.52944],[0.57483,-0.66443,-0.4776],[-0.7084,0.14423,0.69092],[0.98973,0.13405,0.049595],[0.018214,0.57224,0.81988],[0.49814,-0.70112,-0.51018],[-0.46332,0.28479,0.83919],[0.70007,0.70763,-0.095737],[0.82747,0.45688,-0.32643],[-0.23582,0.86359,-0.44565],[0.060643,0.58652,0.80766],[0.46597,-0.72525,-0.50684],[-0.78764,0.1426,-0.59941],[0.59649,-0.3643,-0.71518],[0.16615,0.45256,0.87612],[0.53926,0.82034,-0.19038],[-0.75603,-0.074722,-0.65026],[0.3314,-0.73207,-0.59519],[0.27298,-0.74447,-0.60929],[-0.5758,0.8105,-0.10742],[0.49179,-0.71413,-0.49816],[-0.83843,0.054925,0.54223],[-0.55402,0.75856,-0.343],[0.79845,-0.57746,-0.17034],[-0.54782,0.46503,0.69544],[0.38511,0.63719,0.66759],[-0.81109,0.12356,0.57171],[-0.38437,-0.032203,-0.92262],[-0.44594,0.89461,-0.028519],[0.86984,0.16859,0.46362],[0.50012,0.85042,0.16334],[0.59686,0.64505,0.47715],[-0.43091,0.63034,0.64574],[-0.58715,0.70305,-0.40122],[-0.34112,0.75075,0.56569],[0.33386,0.93674,0.10513],[-0.41266,0.91089,-0.00078321],[-0.53902,0.30578,0.78483],[0.63012,-0.72037,0.28987],[-0.062115,0.91432,0.4002],[0.13579,0.96066,0.24226],[-0.27108,0.95533,0.11771],[-0.066368,0.98771,0.14154],[0.10652,-0.94091,-0.32147],[0.733,0.66248,-0.15439],[-0.22153,-0.92842,-0.29827],[0.17588,-0.842,-0.51001],[0.14981,-0.86815,-0.47315],[0.4666,-0.57435,-0.67261],[-0.90115,0.32538,0.28646],[0.24005,-0.94144,0.2368],[0.54079,-0.82385,0.16972],[0.96005,0.20247,0.19315],[0.68245,0.50514,-0.52829],[0.52383,0.41202,-0.74555],[0.76618,0.19204,0.61327],[-0.53613,-0.83727,0.10748],[0.63437,-0.76081,0.13688],[-0.56588,0.66893,-0.48199],[-0.84143,0.50821,0.18361],[-0.71507,-0.69807,-0.037034],[-0.75393,-0.65551,-0.043475],[0.65906,-0.7517,0.024405],[-0.86354,-0.50405,0.015555],[-0.39278,-0.043517,-0.9186],[0.58027,0.81096,-0.074972],[0.91228,0.14453,-0.38321],[-0.89247,-0.44975,-0.034952],[0.67339,-0.50738,-0.53769],[-0.81487,0.080179,-0.57408],[-0.13688,0.71105,0.68969],[-0.72425,-0.68952,0.0047603],[0.80721,-0.58887,-0.040487],[-0.80372,-0.21216,0.5559],[-0.47679,0.78025,-0.40483],[-0.39874,0.72703,-0.55896],[0.35568,0.82604,0.43721],[-0.48266,0.6746,0.55853],[-0.43216,0.65369,0.62123],[0.17457,0.089534,0.98057],[0.36295,0.86717,0.341],[0.73096,-0.62445,0.27524],[-0.76886,-0.63678,-0.057931],[-0.64057,0.084905,0.76319],[-0.35069,0.87407,-0.33619],[-0.30833,-0.61292,-0.7275],[-0.0036172,-0.72224,-0.69164],[-0.038521,-0.65108,-0.75803],[0.7241,-0.32431,0.60869],[0.26791,-0.61639,-0.74046],[-0.86504,0.10838,-0.48986],[-0.85695,-0.51381,-0.040357],[-0.56324,-0.39675,-0.72481],[0.27738,0.95406,0.11324],[0.4316,-0.55843,-0.70844],[-0.40158,0.14336,0.90454],[0.19596,0.42345,0.88447],[0.74045,-0.46102,-0.48908],[-0.24493,0.9401,-0.2371],[-0.83566,-0.10524,-0.53907],[0.93089,0.017976,-0.36485],[-0.32612,0.73795,0.59082],[0.77945,-0.22428,-0.58494],[0.78712,-0.21182,-0.57929],[-0.30248,0.93856,-0.16619],[-0.92475,0.15358,-0.34822],[0.0017859,0.80689,0.5907],[0.33052,-0.76135,-0.55776],[-0.8111,-0.57662,-0.098122],[-0.87525,-0.48118,-0.048991],[0.50563,-0.61556,-0.60451],[-0.77408,-0.58611,-0.23934],[0.85271,-0.056702,-0.51929],[0.67572,-0.64016,0.36552],[0.81962,-0.28084,0.49935],[-0.0099216,0.80099,0.5986],[-0.8682,0.49619,0.0042114],[-0.85362,0.32804,0.40462],[-0.74716,0.62451,-0.22744],[0.59275,-0.67643,0.43713],[0.61013,-0.43436,-0.66262],[-0.066802,0.88804,0.45489],[0.93763,-0.095021,-0.3344],[0.84526,-0.14509,-0.51428],[0.59065,-0.58501,0.55578],[-0.81388,-0.3198,0.48511],[-0.81023,0.57665,0.10484],[0.12084,0.046529,0.99158],[-0.80625,-0.51318,-0.2943],[-0.67255,0.73797,0.055529],[0.20099,0.89982,0.38721],[0.91442,-0.13513,-0.38154],[-0.76283,-0.64052,0.088473],[0.9474,-0.16036,0.27697],[-0.94691,0.2488,-0.2036],[0.76137,-0.30049,-0.57448],[-0.090393,0.70483,0.7036],[-0.89442,0.37605,-0.24208],[-0.98957,-0.10738,-0.095984],[0.36567,0.90832,0.2031],[-0.80625,-0.57106,0.15446],[0.97732,-0.11152,0.18002],[0.63374,-0.31512,-0.70645],[0.73432,-0.32562,-0.5956],[0.90135,-0.1071,-0.41964],[-0.74885,-0.64151,0.1664],[0.78721,-0.61668,0.0024879],[-0.87182,0.11745,-0.47553],[0.67566,-0.15347,0.72106],[-0.78347,0.57928,-0.22498],[0.96971,0.2241,0.097167],[-0.057317,0.7145,0.69728],[-0.039001,0.67933,0.73279],[-0.48464,-0.83457,0.26196],[0.54517,-0.83808,-0.020231],[0.26377,-0.95996,0.094403],[-0.158,0.28125,0.94654],[0.34093,-0.13885,0.92978],[-0.77898,0.61302,-0.13187],[-0.98087,0.14523,-0.12961],[0.94232,-0.23981,-0.23352],[0.089173,0.76823,0.63394],[0.7015,-0.54884,0.45461],[-0.32074,-0.88055,0.34893],[0.15229,-0.98827,0.011558],[-0.83732,-0.049811,-0.54444],[0.51097,-0.42663,-0.74626],[0.90345,-0.12173,-0.41105],[-0.090548,-0.25841,0.96178],[0.47758,-0.42074,-0.77129],[-0.84956,0.25335,-0.46267],[0.87593,0.14545,-0.45999],[-0.80135,-0.5981,-0.010523],[-0.7648,0.022757,-0.64386],[0.60003,-0.14634,-0.78648],[-0.88349,-0.45862,-0.095502],[0.8205,-0.4366,-0.369],[-0.7971,0.50831,-0.32597],[0.85861,0.13912,-0.49339],[0.86876,-0.070646,-0.49017],[0.76376,0.010239,-0.64541],[0.90757,0.39943,0.12948],[-0.94051,-0.17996,-0.28819],[0.18475,-0.18086,0.966],[-0.072597,0.24483,0.96684],[-0.75963,0.051919,-0.64828],[0.77019,-0.5448,-0.33166],[-0.22073,-0.3109,0.92446],[0.97306,-0.12912,-0.19101],[0.19158,-0.70703,-0.68074],[0.16698,-0.66701,-0.72609],[0.064684,-0.30414,0.95043],[-0.63916,0.76269,-0.098856],[0.46125,-0.41222,-0.7857],[-0.89229,0.093029,-0.44178],[0.72774,0.21615,-0.6509],[0.79579,0.022594,-0.60515],[0.86998,-0.448,0.206],[0.9284,-0.30742,-0.20871],[-0.92887,0.33401,-0.16016],[-0.87657,0.4615,-0.13651],[0.73842,0.64366,-0.2011],[0.7232,0.19732,0.66185],[-0.67163,0.7354,-0.090041],[-0.81445,0.26319,-0.5171],[-0.99699,-0.043123,-0.064418],[0.035995,0.7198,0.69325],[-0.83938,0.033086,-0.54254],[0.95263,-0.25443,0.16659],[0.84236,-0.53294,-0.080035],[-0.83979,-0.040051,-0.54143],[-0.557,0.41613,0.71874],[0.79614,0.60251,0.05608],[0.47099,0.20753,0.85738],[0.66231,0.22158,-0.71571],[0.86225,0.25943,0.435],[-0.9167,0.38034,-0.12252],[0.61757,-0.68224,-0.39135],[0.69982,0.66777,-0.25363],[-0.49265,0.50693,-0.70733],[0.94548,-0.10171,0.3094],[0.83377,-0.14813,0.53186],[-0.56486,0.45964,-0.68532],[-0.012006,-0.41501,0.90974],[0.67078,-0.70601,-0.22717],[0.59493,-0.0011741,0.80377],[-0.97767,0.079575,-0.1945],[-0.3595,-0.17943,0.91573],[0.70215,0.15081,-0.69587],[0.93644,-0.3485,0.04032],[0.80641,0.13968,0.57462],[0.74022,0.66105,-0.12283],[-0.15867,-0.86517,0.47571],[-0.56526,0.29921,0.76874],[0.8917,0.020947,-0.45214],[0.13264,-0.36765,0.92045],[-0.69826,0.45827,-0.54993],[0.97522,-0.058502,-0.21337],[0.85616,0.10809,0.50528],[0.19952,0.97409,0.10647],[0.80028,0.25858,0.54101],[-0.0043387,-0.51535,0.85697],[-0.98694,-0.059432,0.14973],[0.46014,0.88015,0.11665],[0.78756,-0.2095,-0.57953],[0.96441,-0.2119,0.15813],[0.16606,-0.30849,0.93662],[0.35612,0.87915,0.31666],[0.073199,-0.91435,0.39826],[-0.24526,-0.55729,0.79327],[0.88478,0.32553,-0.33347],[-0.93301,-0.3492,-0.086868],[0.93483,0.12019,0.33415],[-0.32085,0.93583,0.14589],[-0.15477,-0.53303,0.83182],[0.26672,0.90549,0.33008],[-0.74792,-0.025416,-0.6633],[-0.86771,0.48698,-0.099641],[-0.99084,0.11603,0.069145],[-0.18922,0.97814,0.086203],[0.82369,-0.10822,-0.55662],[-0.91372,-0.40439,-0.039733],[0.22002,0.97437,0.046826],[0.035219,0.95535,0.29339],[0.093782,0.9397,0.32888],[0.9601,0.13864,0.24286],[0.89661,-0.098131,-0.4318],[-0.74851,-0.24006,-0.61814],[0.72922,-0.55662,-0.39801],[0.71622,-0.56494,-0.40972],[0.80526,0.5154,0.29311],[0.99072,-0.12754,0.046965],[-0.96996,0.2285,-0.083406],[0.90509,-0.088629,-0.41588],[-0.8255,-0.20061,-0.52754],[0.30587,-0.73187,0.60894],[-0.80114,0.44928,-0.39537],[0.9909,-0.12915,0.037885],[-0.91595,0.36927,0.15708],[-0.81503,-0.5779,-0.041849],[0.94112,0.017542,-0.33763],[-0.88972,-0.2243,-0.3976],[0.93345,0.31757,0.16678],[-0.85242,0.46557,-0.23796],[0.97958,0.16618,-0.11319],[0.93101,0.33226,0.15107],[0.41813,0.44942,-0.78942],[-0.17744,-0.14554,0.97331],[0.98018,0.18109,0.08031],[-0.50054,0.11591,0.85792],[-0.94939,0.29282,-0.11363],[-0.99058,0.065651,0.12017],[0.18863,-0.53758,0.82184],[-0.23866,0.2543,-0.93722],[-0.47226,0.13251,-0.87144],[-0.74907,-0.13624,0.64833],[0.9396,0.17716,0.29287],[0.94664,-0.30056,-0.11634],[0.92774,0.16036,0.33701],[0.26046,0.056135,-0.96385],[0.86215,0.41408,0.29197],[0.60944,-0.21982,0.76175],[-0.98202,0.056037,-0.18028],[0.17314,0.71591,-0.67638],[-0.99902,-0.034506,-0.027775],[-0.92763,0.19295,0.31981],[0.35022,-0.50655,0.78788],[-0.77034,0.51767,0.37228],[0.13396,0.92878,-0.34557],[-0.96877,-0.22517,-0.10388],[0.01877,0.95974,-0.28028],[0.01467,0.94377,-0.33028],[0.18514,0.36408,0.91278],[0.8842,0.085872,-0.45915],[0.24521,0.90308,-0.3526],[-0.058743,0.93118,-0.35981],[-0.0082114,0.93566,-0.35282],[-0.85809,0.14687,-0.49206],[0.95528,0.07479,0.28609],[-0.62186,-0.33889,0.70601],[-0.76551,-0.63704,0.090387],[0.90563,0.13207,-0.40298],[0.27016,0.83427,-0.48064],[0.37816,0.82217,-0.42547],[-0.98451,0.099817,-0.14416],[0.60736,-0.057446,0.79235],[0.48132,0.49983,-0.72007],[-0.16235,-0.66006,0.73346],[-0.021159,-0.73024,0.68286],[-0.92355,0.043827,-0.38096],[-0.89666,0.41022,-0.16647],[-0.54959,-0.063171,0.83305],[0.64696,0.60581,0.46308],[-0.91815,-0.35859,0.16854],[0.77353,-0.065596,-0.63035],[0.76429,0.11266,-0.63495],[-0.88071,-0.15147,0.44879],[0.2996,0.79827,0.5225],[-0.92177,0.32817,0.2065],[0.23093,-0.61406,0.75472],[0.98082,-0.19154,0.036247],[-0.053383,0.95699,0.28516],[0.8444,-0.035901,-0.53451],[-0.74278,-0.66647,0.064047],[-0.95623,0.24711,-0.15669],[0.77953,0.61538,0.11676],[-0.50856,-0.43113,0.74532],[0.45868,-0.27088,0.84631],[0.86466,-0.45979,-0.20238],[-0.7943,0.59362,-0.12924],[0.90202,0.43167,-0.0035915],[-0.91707,-0.37126,-0.1454],[-0.88169,0.20998,-0.42252],[0.85036,-0.5252,-0.0325],[-0.31449,-0.55798,0.76796],[0.63066,0.77459,0.047739],[0.9627,-0.26968,0.021862],[-0.71487,-0.55901,-0.42009],[0.53418,0.0018909,0.84537],[0.78057,-0.52861,-0.33357],[-0.85216,-0.51903,0.066531],[0.47293,0.86506,0.16737],[-0.98448,-0.17203,0.034831],[-0.57285,-0.59949,-0.55897],[0.22853,0.92246,0.31118],[-0.029381,-0.98073,0.19312],[0.51378,-0.61295,-0.60026],[0.80137,-0.57901,0.15018],[-0.52123,-0.62331,-0.58293],[-0.42648,-0.57984,0.69419],[0.74196,-0.55817,-0.37139],[0.46182,0.10293,0.88098],[0.62654,-0.038201,0.77846],[-0.32954,-0.62078,-0.71137],[-0.28234,-0.58227,0.7624],[0.8672,-0.49791,-0.0074072],[-0.78099,-0.51051,-0.35977],[-0.80429,-0.59182,0.053572],[0.96171,-0.26917,-0.051537],[0.07778,-0.46823,-0.88018],[0.18294,-0.4173,-0.89017],[0.34875,0.34067,0.87311],[0.33862,-0.18498,0.92256],[-0.78295,-0.61597,0.087034],[0.88403,-0.46741,-0.0051066],[-0.74011,0.52878,-0.41548],[0.30661,-0.58906,0.74766],[0.82603,0.55857,0.075279],[0.39368,0.20108,0.89698],[0.039432,-0.51267,-0.85768],[-0.91783,0.37692,0.12461],[0.82406,-0.56458,-0.046664],[0.71248,-0.57029,-0.40883],[0.20871,-0.68654,0.6965],[-0.64162,0.29269,0.70898],[-0.81294,-0.3752,-0.44537],[0.72253,0.17001,0.67011],[-0.8533,-0.49228,0.17188],[0.38397,0.2186,0.8971],[-0.85713,0.028918,0.51428],[-0.78808,-0.60962,0.085429],[0.90614,-0.4214,-0.036604],[0.017919,0.73838,0.67415],[-0.66282,0.17359,0.72838],[-0.82438,-0.56386,0.049606],[-0.70784,0.093463,0.70016],[0.80493,0.58007,-0.12497],[-0.95487,0.29592,-0.025793],[-0.77985,0.50576,0.36884],[-0.35251,0.3534,0.86651],[0.76528,0.64369,-0.0031652],[0.8515,0.51005,0.12161],[0.60904,0.3268,0.72269],[0.77241,-0.0036711,0.63511],[-0.13598,-0.080149,0.98746],[-0.50144,0.34773,0.79224],[-0.74603,0.088233,0.66004],[0.33419,0.012594,0.94242],[0.56402,-0.038687,0.82486],[-0.35672,-0.59108,0.72345],[0.97231,-0.19191,-0.13336],[-0.69592,0.13641,0.70504],[0.72705,0.68514,0.04448],[-0.67434,0.72275,-0.15131],[-0.63692,0.76082,-0.12449],[-0.75472,-0.43754,0.48883],[-0.042213,-0.091362,0.99492],[0.37292,-0.71204,-0.59492],[0.28157,-0.64721,-0.70841],[0.25008,-0.67515,-0.694],[0.19213,0.22072,0.95623],[-0.63408,0.28217,0.71995],[-0.67474,-0.34229,0.65389],[0.53737,-0.83325,-0.13013],[-0.872,-0.48504,0.06597],[0.58735,-0.65934,-0.46936],[0.58988,0.78351,0.19532],[-0.40583,0.41282,0.8154],[0.94968,-0.043343,0.31022],[-0.5196,0.85281,-0.052313],[0.72582,-0.24819,0.64155],[0.12509,-0.68627,0.71651],[0.72329,-0.684,-0.094846],[0.88866,-0.4578,-0.026721],[0.70058,0.030473,0.71292],[0.69693,0.35546,0.62285],[-0.41132,0.64403,0.64501],[0.50834,0.42102,0.75122],[0.97062,-0.24017,0.0144],[-0.42865,-0.90286,-0.033317],[0.34445,0.31657,0.88382],[0.11886,-0.71633,0.68756],[0.50489,0.79606,0.33372],[-0.47933,-0.8776,-0.0075552],[0.99031,-0.11949,0.070713],[0.20861,0.93393,0.29025],[0.48465,0.44704,0.75184],[0.38296,-0.67989,0.62537],[-0.1535,-0.98152,-0.11425],[-0.16865,-0.98514,-0.032633],[0.014057,-0.98636,-0.16401],[-0.40944,-0.82608,-0.38724],[-0.24647,-0.92705,-0.28254],[-0.074487,-0.96133,-0.26515],[0.16349,-0.89712,-0.41042],[0.28733,-0.78671,-0.54637],[-0.6561,-0.75439,-0.020597],[-0.45782,-0.79714,-0.39366],[-0.42426,-0.87736,-0.22414],[0.57528,-0.27099,-0.77176],[-0.56956,0.04065,0.82094],[-0.57185,-0.82035,-0.0043386],[0.56689,0.095116,-0.81828],[0.54611,0.10823,-0.83069],[0.54036,0.18616,-0.82058],[0.26657,0.42728,0.86393],[0.26789,-0.52372,0.80867],[-0.069316,-0.96374,0.2577],[-0.46723,-0.88304,-0.043908],[-0.49309,-0.48201,0.72424],[0.90946,0.37091,0.18793],[0.32599,0.45551,-0.8284],[0.85997,-0.39475,0.32345],[-0.64065,0.64021,0.42392],[-0.62263,-0.77968,0.066504],[0.38236,0.46619,-0.79779],[0.76165,-0.54647,0.34822],[-0.79131,-0.58307,0.18399],[-0.73794,-0.67339,-0.044629],[0.77122,-0.60771,0.18952],[0.67217,0.028512,-0.73985],[0.77389,-0.62043,-0.12714],[0.2422,0.40383,0.88219],[-0.16787,-0.7626,-0.62471],[0.69256,-0.66024,0.2906],[0.15859,0.39168,0.90633],[0.71363,0.45078,0.53622],[-0.7786,-0.5978,-0.19081],[0.81923,-0.3635,-0.44354],[0.67181,-0.73011,0.12494],[0.073781,0.3254,0.9427],[0.028752,-0.70899,-0.70463],[-0.84438,-0.5256,-0.10377],[0.18484,-0.58239,0.79162],[-0.10209,0.49511,0.86281],[-0.11328,-0.6982,-0.70688],[-0.49049,0.24318,0.83683],[-0.13798,-0.65933,-0.73909],[0.46928,-0.58797,-0.65883],[0.59427,-0.69518,0.40444],[0.78436,-0.42974,-0.44732],[0.73243,-0.67863,0.054897],[-0.36402,-0.54712,-0.75376],[0.46252,-0.57363,0.67604],[-0.62895,0.25054,0.73597],[0.0098992,0.45738,0.88922],[0.47603,-0.58629,-0.65549],[-0.82669,0.56231,0.019451],[-0.49426,-0.44631,0.746],[0.55128,-0.32763,0.7673],[0.26237,-0.67273,-0.69181],[-0.53196,-0.84635,-0.026741],[0.27372,-0.79177,-0.54605],[0.83155,-0.53992,0.13041],[-0.55901,-0.69818,0.44727],[-0.94065,0.26025,-0.21782],[-0.24128,0.43728,0.86635],[0.44302,-0.7702,-0.45884],[-0.2028,0.5322,0.82197],[-0.78365,-0.55777,-0.27347],[0.49551,-0.51884,0.69662],[0.80724,-0.13043,-0.57564],[0.067036,-0.81445,0.57635],[-0.813,0.56296,0.14866],[-0.068882,-0.3434,0.93666],[-0.84719,-0.53069,-0.025337],[-0.47224,-0.4885,0.73373],[0.31957,-0.75057,0.57838],[0.72958,-0.33917,-0.59387],[0.83425,-0.061241,-0.54797],[0.48536,0.8549,-0.18323],[-0.85877,0.50727,-0.072106],[-0.91377,-0.36294,-0.18247],[0.75477,-0.41972,0.50415],[-0.27092,-0.96227,0.025305],[-0.86316,-0.47447,-0.17274],[-0.29711,0.3212,0.8992],[-0.012053,0.31233,0.9499],[-0.84962,0.18564,-0.49364],[0.92698,0.013274,0.37487],[0.069061,-0.65262,0.75453],[-0.7211,-0.49669,0.48302],[0.82273,-0.012784,0.56829],[0.50976,-0.20855,0.83466],[-0.16086,-0.20663,0.9651],[0.74176,-0.31973,-0.58955],[0.50945,-0.43939,-0.73986],[-0.99943,-0.00067731,-0.033748],[-0.76813,-0.48219,0.42127],[-0.79641,0.17681,-0.57834],[-0.5943,-0.53078,0.60422],[0.11267,-0.97687,0.18172],[-0.93901,-0.31898,-0.12848],[0.53226,0.34396,0.77356],[-0.4665,-0.84497,0.26153],[-0.27918,-0.90868,0.3104],[0.71961,-0.65384,-0.2338],[-0.80122,-0.1636,-0.57558],[0.73091,-0.31512,-0.60537],[-0.99406,0.10836,0.0097165],[0.95001,0.030406,-0.31073],[-0.59875,-0.78276,0.16967],[0.1688,-0.58308,0.79469],[0.51093,-0.63032,-0.5845],[-0.68443,0.72633,0.063275],[0.75291,0.0012108,-0.65812],[0.33856,-0.46929,0.81556],[0.53934,-0.4913,0.68391],[-0.79531,-0.036165,-0.60513],[0.81395,0.063164,-0.57749],[-0.63303,0.74869,0.19682],[-0.94505,0.3101,-0.10357],[-0.76835,0.02047,-0.63971],[-0.13914,0.11988,0.98299],[-0.93905,-0.29369,-0.17872],[0.8864,0.043434,-0.46087],[0.66663,-0.099842,0.73868],[0.83306,-0.2271,-0.50442],[-0.66754,-0.39577,0.63067],[0.58999,-0.53526,-0.6045],[0.11793,-0.74695,-0.65433],[0.18771,-0.71983,-0.66829],[-0.95289,-0.17501,-0.24774],[0.82147,-0.56979,0.022898],[0.6686,-0.48094,0.56716],[0.372,-0.57928,-0.72529],[0.95583,-0.11236,-0.27159],[-0.86089,0.39681,-0.31844],[0.0066291,-0.76894,0.63929],[-0.96348,-0.11216,-0.24314],[0.65673,-0.32033,0.68271],[-0.80407,-0.42847,0.41217],[-0.61316,-0.27628,0.74007],[-0.74974,0.22193,-0.62341],[-0.74293,0.27155,-0.61182],[-0.29984,-0.71847,-0.62762],[-0.61164,0.78203,0.11966],[0.5142,0.034435,0.85698],[0.8232,-0.52716,0.21083],[-0.50994,-0.24698,0.82399],[0.81476,0.33132,-0.47581],[0.56966,-0.070297,0.81887],[0.62922,0.73433,-0.25463],[0.81295,0.47161,-0.34162],[0.78221,-0.35637,0.51103],[-0.51475,-0.72565,-0.45658],[0.89903,-0.43365,-0.060789],[-0.0025124,0.26323,0.96473],[0.11358,-0.95469,0.27506],[0.12171,-0.72114,-0.68201],[-0.072286,-0.9192,0.38709],[-0.89645,0.13478,-0.42214],[0.78995,0.026738,0.61258],[-0.11579,-0.8278,0.54895],[0.72865,-0.25843,0.63426],[-0.77913,0.60719,-0.15579],[0.99867,-0.03898,0.033886],[-0.74459,0.25126,0.61842],[0.81831,0.57312,-0.043531],[0.64277,0.76593,-0.014322],[-0.79948,0.25259,-0.54501],[-0.10838,-0.92434,0.36585],[-0.69022,0.71858,-0.085077],[-0.34989,-0.32307,0.87932],[0.83616,-0.0118,0.54836],[0.8275,0.08553,0.55491],[0.84953,0.52692,-0.025663],[0.91878,0.014488,0.39451],[0.77831,0.11918,0.61647],[-0.37314,-0.17612,0.91091],[-0.6607,0.64063,0.39124],[-0.49114,-0.68163,-0.54237],[0.53205,-0.30342,0.79048],[0.47861,0.85855,0.18392],[-0.58336,-0.1984,0.78761],[0.59827,0.79185,0.12268],[-0.70794,0.39983,-0.5822],[-0.023846,-0.81415,0.58017],[0.24564,0.96927,0.013627],[-0.85668,-0.14769,-0.49426],[-0.59941,0.78445,0.15919],[-0.92282,-0.21848,-0.31729],[0.17826,0.23161,0.95634],[0.47082,0.87052,-0.14327],[-0.73798,0.23355,-0.63312],[0.95613,0.12098,-0.26679],[0.23136,0.47365,0.84978],[-0.45446,0.88468,0.10398],[-0.22528,0.96585,0.12799],[0.23869,0.97061,-0.030676],[0.080368,-0.68758,0.72165],[-0.057439,0.0053022,0.99833],[0.41083,-0.67943,-0.60794],[0.32135,-0.086929,0.94296],[0.94043,0.17878,-0.28919],[0.85004,0.010983,0.5266],[-0.38458,0.91408,0.12868],[0.16513,0.97116,0.172],[0.28977,0.9292,0.22938],[0.64418,-0.25873,0.71979],[-0.80179,0.45348,0.38921],[0.91656,-0.30766,-0.25547],[-0.47108,-0.2994,0.82972],[0.77945,-0.12381,0.61411],[0.8184,0.22097,0.53046],[0.6697,-0.55798,0.49006],[0.71396,0.43087,0.55192],[-0.83143,-0.031674,-0.55473],[-0.0055606,-0.91373,0.40629],[-0.34692,-0.16876,0.92259],[-0.85283,0.26642,-0.44912],[0.86057,0.37119,0.34877],[-0.85687,0.35308,-0.37564],[0.93473,0.0057478,-0.35531],[-0.42946,-0.034213,0.90244],[0.68455,-0.26272,0.67997],[-0.95733,0.28778,-0.026522],[0.9674,0.23751,-0.087927],[0.89329,0.39606,0.21253],[-0.97313,-0.14042,-0.18246],[-0.6176,-0.77015,0.15952],[0.74755,0.17797,0.63992],[0.91933,0.3833,0.088911],[-0.57083,-0.47145,0.67223],[-0.97393,-0.16796,-0.15249],[-0.92348,0.37517,-0.080153],[0.21814,0.031177,-0.97542],[0.9386,0.26802,0.21722],[0.85124,0.35245,0.38881],[-0.95436,0.2353,0.18392],[0.0021251,0.15024,-0.98865],[-0.93078,-0.23653,0.27877],[-0.70701,-0.68198,0.18719],[0.83645,0.24618,0.48963],[-0.92021,0.14793,0.3624],[-0.29605,0.14485,-0.94413],[-0.81823,0.204,0.53748],[0.21474,0.49769,-0.84035],[0.048639,0.28171,-0.95826],[0.94571,0.15573,0.28528],[0.67407,0.5746,0.46418],[-0.55102,-0.40034,0.7322],[0.27077,0.91483,-0.29962],[-0.08072,0.95039,-0.30042],[-0.020982,0.97755,-0.20965],[-0.029553,0.81287,-0.5817],[-0.025735,0.62861,-0.7773],[-0.44313,0.3348,-0.83159],[-0.44908,-0.042399,0.89248],[-0.92948,0.048136,0.36572],[-0.6245,-0.2443,0.74184],[0.047531,0.88597,-0.46129],[0.55927,-0.75893,-0.33352],[0.2228,-0.82505,0.51927],[-0.65145,0.38715,-0.65248],[0.99005,0.016664,0.13969],[-0.99193,0.019958,0.12524],[0.70955,0.5874,0.38923],[0.95424,-0.29511,0.048299],[-0.96421,-0.18942,0.18553],[-0.14874,0.36719,0.91817],[-0.89005,0.15961,-0.42701],[0.98969,-0.1036,0.098896],[-0.95839,-0.16285,0.23445],[0.67426,0.65373,0.34353],[0.17253,-0.32257,0.93069],[0.65501,-0.4673,0.5938],[-0.84338,0.3805,0.37939],[-0.51602,-0.010698,0.85651],[0.64697,-0.10471,0.7553],[0.41567,0.84147,0.34519],[0.35931,0.82128,0.44316],[-0.90964,-0.41531,-0.0081303],[0.088112,0.38941,0.91684],[-0.08836,-0.08054,0.99283],[0.89165,-0.39023,-0.22951],[-0.95983,-0.16301,0.22836],[0.91565,-0.29508,-0.27298],[0.24975,-0.7743,0.58145],[-0.79107,0.60017,-0.11835],[-0.88509,-0.4622,-0.054575],[0.63838,-0.096482,0.76365],[0.87642,0.11073,-0.46863],[-0.96788,0.027908,-0.24987],[0.069077,-0.79622,0.60105],[0.89895,0.43013,-0.082932],[-0.79454,0.5735,0.19952],[0.81163,0.55466,0.18335],[-0.94514,0.099176,-0.31125],[-0.73947,-0.51885,-0.42893],[0.17473,0.44936,0.8761],[0.28338,-0.80805,0.51647],[0.77743,0.60824,0.16017],[0.69157,-0.48794,-0.53259],[0.93276,0.31093,-0.18243],[-0.52495,0.70121,0.48242],[0.76218,-0.0080793,0.64731],[0.2492,0.94265,0.22205],[-0.65097,-0.36117,0.66767],[-0.7574,0.27744,0.59108],[0.53714,-0.27862,0.79615],[-0.80646,0.11675,0.57965],[-0.1667,0.86044,0.48152],[0.012749,0.85367,0.52066],[0.53225,-0.084941,0.84231],[-0.52638,0.21461,0.82272],[-0.59938,-0.49743,0.62714],[-0.03613,0.26223,0.96433],[-0.76124,-0.57234,-0.30486],[-0.43779,-0.87046,0.22505],[0.16733,-0.37753,-0.91075],[-0.17268,-0.55161,-0.81604],[-0.40698,-0.61143,-0.67861],[0.4676,-0.60313,0.6462],[-0.74149,0.50026,-0.44714],[-0.47656,-0.59339,-0.64868],[0.44475,-0.53185,0.72065],[0.60703,-0.74244,0.28336],[0.86352,-0.43503,-0.25512],[0.10648,-0.423,-0.89985],[-0.039791,-0.49316,-0.86903],[0.81767,0.12164,0.56269],[0.54135,0.18016,0.82127],[-0.54152,0.2789,0.79308],[-0.35334,-0.9017,0.24919],[-0.58929,-0.57512,0.56743],[-0.89226,-0.1987,0.40546],[-0.9068,-0.27089,0.323],[-0.5532,0.32725,0.76607],[-0.86079,-0.49852,0.10256],[-0.84979,-0.01724,0.52684],[0.90449,0.091974,0.41646],[-0.53722,-0.57985,0.6125],[0.61244,-0.5704,-0.54732],[-0.79961,-0.10698,0.59092],[-0.62516,0.097809,0.77435],[-0.18028,-0.16378,0.96988],[0.53719,-0.52212,-0.66243],[0.83311,-0.53474,0.14136],[0.63619,-0.014958,0.77139],[-0.92731,0.19318,0.3206],[-0.58126,-0.57735,0.57341],[0.41162,-0.56479,0.71525],[0.45802,-0.63703,-0.62001],[-0.77285,0.072329,0.63045],[-0.72012,0.65456,-0.23015],[0.41037,-0.65834,-0.63101],[-0.1797,-0.15442,0.97153],[0.44911,0.50166,0.73935],[0.56776,-0.47457,0.67263],[-0.79677,0.23948,0.55481],[0.14792,0.46522,0.87275],[-0.75869,-0.1851,0.6246],[0.81684,0.28094,0.50383],[-0.60714,-0.49662,-0.62029],[0.89536,-0.2548,-0.36525],[0.57525,-0.63882,-0.51088],[0.68153,0.71116,0.17253],[-0.57576,0.8176,0.0051402],[0.36754,-0.69383,-0.61929],[0.60109,0.0391,0.79822],[-0.95048,-0.28599,-0.12164],[-0.5689,-0.76985,0.28929],[-0.29577,-0.88547,0.35843],[0.45743,0.65459,0.60188],[0.94428,-0.26692,0.19259],[-0.58028,-0.21565,0.78535],[0.13933,0.2618,0.95501],[-0.77851,-0.23021,-0.58388],[-0.70008,0.18838,0.68877],[-0.46371,0.87375,0.14676],[0.68883,0.29046,0.66419],[0.34374,0.51093,0.7879],[-0.23435,-0.67026,0.70415],[-0.50782,0.46004,0.72834],[0.19776,0.5153,0.83388],[-0.86698,0.15443,0.47382],[0.27125,0.88781,0.37178],[-0.37376,0.90448,0.20547],[-0.92788,0.11152,0.35581],[-0.44957,0.85045,-0.27316],[0.54607,0.56455,0.61894],[-0.23386,0.78129,0.5787],[0.81823,-0.37415,-0.43648],[0.16725,0.63234,0.75642],[-0.07182,0.43458,0.89776],[0.28876,0.76765,0.57213],[-0.27438,0.90529,0.32428],[-0.090044,0.91578,0.39146],[0.083931,0.80825,0.58283],[0.030834,-0.82786,-0.56008],[0.94841,-0.21248,-0.23531],[-0.21934,-0.73967,0.63622],[-0.17568,-0.89099,-0.41866],[0.77439,-0.50163,0.38559],[-0.92753,-0.13794,-0.34736],[0.34669,-0.8062,-0.47943],[-0.99068,0.053013,0.1255],[-0.99298,-0.031855,-0.11389],[-0.56085,-0.15806,0.81269],[0.26368,-0.88444,-0.38501],[0.52066,-0.80002,-0.29812],[0.59794,0.55381,0.57945],[0.64855,-0.57597,-0.49764],[0.7588,-0.311,-0.57228],[-0.39938,-0.57005,0.71801],[-0.48987,-0.87169,-0.013949],[-0.71756,-0.50961,0.47477],[-0.99638,-0.039739,-0.075123],[-0.63351,-0.55192,-0.54226],[0.49643,-0.49499,0.71313],[-0.0023991,-0.95936,0.28216],[0.30419,-0.91621,0.26082],[0.57004,-0.81588,0.096932],[0.88476,-0.16818,0.43465],[-0.7446,0.18063,0.64261],[-0.55454,-0.83031,0.055442],[-0.39987,-0.90631,0.13673],[-0.49073,-0.50043,0.71328],[-0.97872,-0.19736,-0.056101],[0.33306,0.42306,-0.84267],[0.61571,0.67156,0.4122],[-0.94588,-0.2252,-0.23368],[-0.84773,-0.5097,0.14686],[0.80441,-0.55902,-0.20107],[-0.71849,-0.69514,-0.02377],[0.71389,-0.46588,-0.52279],[-0.99793,-0.018506,0.061603],[0.85348,-0.49379,-0.16655],[-0.50233,-0.6076,0.61521],[-0.0037029,-0.71731,-0.69675],[-0.71358,0.41016,0.56795],[-0.12779,-0.65334,-0.7462],[-0.40954,-0.29811,-0.86221],[0.32027,-0.70883,-0.62848],[-0.80146,-0.59046,-0.094983],[0.1514,-0.15113,0.97685],[0.82063,-0.27504,-0.50091],[-0.73547,-0.67755,-0.0032212],[0.89638,0.40776,0.17388],[-0.34777,-0.33406,-0.87605],[-0.80599,-0.58426,-0.094997],[-0.61903,0.29887,0.72627],[-0.657,-0.26018,-0.70757],[0.76635,0.47821,0.42898],[0.73244,-0.51592,-0.44425],[0.53679,-0.30468,0.78678],[0.94935,0.2976,0.1008],[0.83577,-0.54712,0.046248],[-0.89011,0.19099,-0.4138],[0.36512,-0.59774,-0.71371],[0.78577,-0.47575,-0.39527],[0.46892,-0.58971,-0.65754],[-0.089633,-0.83415,0.5442],[-0.68991,-0.64618,-0.32632],[0.87796,-0.30573,-0.3684],[-0.54773,-0.3898,0.7403],[0.4411,-0.79907,-0.40857],[-0.49936,-0.32867,0.80164],[0.57014,-0.75501,-0.32389],[-0.63578,-0.047096,0.77043],[-0.89581,-0.44362,0.027114],[0.80644,-0.3059,0.50603],[0.70201,-0.5724,-0.42371],[0.90638,0.3646,0.21338],[-0.03557,0.5292,0.84775],[-0.86742,-0.4336,-0.24408],[0.82693,0.0015218,-0.56231],[-0.31238,-0.82265,0.47505],[0.77543,-0.3053,-0.55272],[-0.83549,0.32555,0.44269],[0.72296,-0.42679,0.5433],[-0.96578,-0.23328,-0.11331],[0.71147,0.050318,0.70091],[-0.90113,0.071515,-0.42762],[0.63521,-0.40089,-0.66015],[-0.92176,0.36359,0.13479],[-0.82591,0.56326,-0.024653],[-0.99361,-0.079267,-0.08034],[0.88877,-0.012173,-0.4582],[-0.63059,-0.55496,-0.54256],[0.786,-0.58917,0.18732],[-0.2068,-0.29529,0.93276],[-0.84763,-0.05024,-0.52821],[0.80862,0.58822,0.011622],[0.49538,-0.41117,-0.7652],[-0.80926,0.30314,0.50319],[-0.7944,-0.55013,0.25745],[-0.49117,-0.39208,0.77784],[-0.66188,0.13638,-0.7371],[0.52741,-0.12462,0.84042],[0.47603,-0.43119,-0.76647],[0.91755,-0.16118,-0.3635],[0.97242,-0.19702,0.12487],[0.23819,-0.71617,0.65602],[0.65013,-0.75025,0.12023],[-0.38167,-0.69949,0.60419],[0.65669,-0.38924,-0.64595],[0.70048,-0.69139,0.17695],[0.83613,-0.1207,0.53508],[0.85706,0.26008,0.44476],[-0.61081,-0.7307,0.30495],[0.42359,-0.8785,0.22093],[0.33476,-0.94025,0.062132],[0.61902,-0.22487,0.75249],[-0.72711,-0.00076063,-0.68652],[0.77705,-0.31947,-0.54234],[0.63692,-0.76439,-0.10022],[-0.78096,0.6241,-0.024453],[0.78964,-0.56871,-0.2303],[-0.71193,-0.48682,0.50612],[0.83249,-0.19804,-0.51743],[-0.97669,0.21453,-0.0070872],[0.79098,0.047172,0.61003],[-0.73968,-0.66683,0.090568],[0.61205,0.77817,-0.14087],[0.93775,-0.16888,-0.3035],[-0.76511,-0.0011067,-0.6439],[0.75689,0.43459,0.48811],[0.89852,0.099566,-0.42749],[0.82218,-0.27896,-0.49619],[-0.85159,-0.52195,-0.048535],[0.82548,0.010231,-0.56434],[0.64488,0.74951,-0.14955],[0.52165,-0.47331,-0.70983],[0.17287,-0.5083,0.84365],[0.55187,-0.38392,0.7403],[0.94878,-0.051058,-0.31179],[0.72484,0.37873,0.57548],[0.82775,-0.39946,-0.39404],[-0.29662,-0.711,0.63757],[0.22234,-0.73194,-0.64407],[0.59718,0.32952,0.7313],[0.94982,0.31218,-0.019773],[-0.8015,0.12687,-0.58438],[0.91513,-0.24874,-0.31729],[-0.69632,0.57657,-0.42744],[-0.70456,0.63103,-0.32464],[0.71094,0.10509,0.69536],[0.54921,-0.53899,-0.63865],[0.80436,-0.26027,-0.53409],[-0.93555,0.35319,0.00048654],[0.8684,0.12963,-0.47861],[0.060726,-0.0034327,0.99815],[0.9342,-0.32587,-0.14519],[0.92093,0.25216,-0.29715],[-0.7734,0.22874,-0.59121],[-0.96039,0.070294,0.26966],[0.2622,-0.12102,0.9574],[-0.6069,-0.3527,0.71223],[-0.74165,0.24107,-0.62597],[-0.84656,-0.20536,0.49109],[0.28928,-0.20621,0.93477],[-0.96286,0.025658,-0.26876],[-0.70985,-0.16365,0.68508],[0.93679,0.30851,-0.16506],[-0.70219,0.2732,-0.65749],[0.81218,-0.5834,-0.0017161],[-0.80073,0.3849,-0.45901],[0.75257,0.23519,-0.61508],[-0.50642,0.83514,-0.21467],[-0.71281,-0.67838,0.17806],[0.67236,0.68807,-0.27293],[-0.90936,0.10822,-0.40169],[0.90527,-0.41188,-0.10409],[-0.77191,0.48667,-0.40904],[0.9967,-0.064767,0.04896],[-0.049644,0.27178,0.96108],[0.55144,0.82657,-0.1127],[-0.36137,0.28436,0.88801],[0.70802,0.22248,-0.67023],[0.9909,-0.071417,0.11405],[-0.70336,0.71083,-0.00083839],[-0.95436,-0.27189,-0.12357],[0.93141,0.23184,0.28059],[0.32366,-0.045013,0.9451],[0.78734,0.57761,-0.21554],[-0.8911,0.18362,-0.415],[0.88658,0.18923,0.42211],[-0.19594,-0.15118,0.96889],[0.69947,0.69827,0.1522],[0.70979,0.20953,-0.67254],[-0.44247,-0.76531,0.46746],[-0.73661,0.67193,0.076971],[-0.77223,0.36996,-0.51653],[0.67963,0.27526,-0.67995],[0.48717,0.36157,0.79494],[-0.81391,-0.061151,-0.57777],[0.86924,0.12587,0.4781],[-0.71143,0.70168,0.038828],[-0.024717,0.42047,0.90697],[-0.72832,0.40288,-0.55429],[-0.67673,0.090979,0.73059],[0.78801,0.094392,0.60838],[0.49764,0.86586,0.051421],[0.29174,0.92114,0.25766],[0.5408,0.78522,-0.30161],[0.80493,0.18284,-0.5645],[0.84877,-0.15495,0.50555],[0.84679,0.081541,0.52563],[0.56155,-0.55155,-0.61681],[0.69523,0.65568,-0.29452],[0.33607,0.93885,-0.074953],[0.52542,-0.60283,0.60044],[0.20075,0.93188,0.30217],[0.14076,0.98924,0.039889],[-0.69419,-0.12661,0.70857],[-0.81629,-0.1595,-0.55518],[0.0025238,-0.95981,-0.28063],[-0.29057,0.91981,0.26364],[0.077238,0.9133,0.39989],[-0.7378,-0.017432,-0.6748],[0.92091,0.17287,-0.34934],[-0.051253,0.9674,0.248],[0.8469,-0.35629,-0.39475],[-0.34575,0.087689,0.93422],[0.71103,-0.6087,-0.35202],[-0.85003,-0.16953,-0.4987],[0.02855,-0.99887,0.038],[-0.49234,0.85873,-0.14207],[0.86767,-0.26936,-0.41784],[-0.88612,-0.16298,-0.43386],[0.6885,0.43795,0.57807],[-0.77121,-0.10464,0.62793],[-0.92881,-0.14614,-0.34053],[0.47592,-0.43814,0.76258],[-0.27229,-0.93987,-0.20617],[-0.7759,0.36656,-0.51344],[0.95414,0.22936,-0.1924],[-0.7459,0.54519,-0.38263],[0.7212,0.50468,0.47452],[-0.68075,0.48954,0.54491],[0.755,0.34137,0.55986],[-0.19179,-0.72193,0.66485],[-0.73471,0.62412,0.26586],[-0.93311,0.25739,0.25112],[0.92324,0.33558,0.18712],[-0.96852,0.051993,0.24345],[0.79693,0.49317,0.34885],[0.090068,-0.9626,-0.25553],[0.066499,0.11793,0.99079],[-0.040666,0.86904,-0.49306],[0.022899,0.99059,-0.13495],[-0.25746,0.92816,-0.26875],[-0.15957,0.14906,0.97587],[-0.16288,-0.96607,0.20043],[-0.99022,0.088404,0.10796],[0.68206,0.53002,0.50386],[0.79283,-0.30491,-0.52768],[-0.68248,0.08844,0.72553],[0.26927,0.79165,-0.54844],[0.69422,0.17431,0.69834],[-0.061492,0.81293,-0.57911],[-0.80467,0.51464,0.29605],[-0.28499,0.73181,-0.61907],[-0.77459,-0.019827,0.63215],[0.29335,0.7716,-0.56443],[-0.68506,-0.5462,-0.48204],[0.66284,0.61526,0.42673],[0.40192,0.67373,-0.62012],[-0.51409,0.80769,-0.2887],[-0.7866,0.33125,-0.52109],[0.2318,-0.50466,0.83162],[-0.14557,0.48127,0.8644],[0.5634,0.42959,-0.70572],[0.084162,-0.85264,0.51568],[-0.97,-0.12506,-0.20849],[0.39813,0.84751,0.35103],[0.65443,0.24058,-0.71683],[-0.95155,0.30476,0.040855],[-0.31037,-0.94329,0.11774],[-0.89162,-0.25828,0.3719],[0.88188,0.45997,-0.10351],[0.68954,0.0071937,0.72421],[-0.25513,-0.96685,-0.010338],[0.79742,0.10109,-0.5949],[0.1875,0.49639,0.84761],[-0.90276,-0.17517,0.39286],[-0.96607,0.25609,-0.033503],[-0.90369,-0.2109,0.37264],[0.13591,0.43294,0.89112],[-0.95233,0.087611,-0.29223],[0.67716,0.65357,-0.33809],[-0.90669,0.39296,0.15331],[-0.92914,0.36956,-0.011234],[0.29781,0.4234,0.85559],[-0.72962,0.68363,-0.017442],[-0.81958,-0.34202,0.45968],[0.80507,-0.46934,-0.36276],[-0.11377,0.3141,0.94255],[-0.66165,0.74291,0.1015],[-0.70696,0.1454,0.69214],[0.15738,-0.77743,0.60895],[-0.81278,0.58226,-0.019003],[0.88977,0.36151,-0.27859],[-0.25911,-0.90576,0.33534],[0.70472,-0.52565,-0.47651],[0.73648,0.57114,0.36248],[-0.025371,0.40003,0.91615],[-0.74257,-0.29891,0.59937],[-0.62373,0.68534,0.37587],[0.69626,0.6182,0.36475],[0.81694,0.031797,0.57585],[0.67397,0.73647,-0.058133],[-0.96771,0.11102,-0.22629],[-0.44246,-0.33643,0.83129],[-0.5142,-0.5872,-0.62514],[0.68759,-0.53213,-0.49403],[-0.35822,0.78286,0.50873],[0.47476,0.23496,0.84817],[-0.41339,-0.57335,-0.70737],[-0.9268,0.2536,-0.27699],[-0.71901,0.69481,-0.015959],[0.0099379,0.93921,0.3432],[0.56291,-0.5914,0.57739],[-0.82742,-0.4839,-0.28497],[-0.2872,-0.49102,-0.82244],[0.82165,0.20173,0.53311],[-0.23295,-0.54621,-0.8046],[-0.34767,-0.57101,-0.74369],[0.12042,-0.37992,-0.91715],[-0.8093,0.32644,0.48833],[-0.081185,-0.46802,-0.87998],[0.91046,0.40137,-0.099871],[-0.81981,0.49722,-0.28407],[-0.97305,-0.20602,-0.10355],[-0.7902,-0.03452,0.61188],[0.88739,0.45959,-0.036209],[0.88239,0.1856,-0.43237],[-0.64327,0.10138,0.7589],[0.7532,0.42189,0.50468],[0.51909,-0.59805,-0.61064],[-0.44397,0.29372,0.84654],[0.81137,0.58396,-0.026002],[0.57554,0.81678,0.040258],[-0.71547,0.53217,0.45266],[-0.76286,-0.01124,0.64646],[-0.76033,0.59362,-0.26366],[-0.68381,0.075924,0.7257],[0.7323,-0.46468,0.4978],[-0.73558,0.64685,-0.20129],[0.38877,-0.59586,-0.70272],[-0.72677,0.10127,0.67937],[0.74182,0.66775,0.061759],[0.59569,0.66531,0.45002],[0.37259,0.019814,0.92778],[-0.74988,-0.35518,0.55814],[-0.94287,-0.018295,0.33266],[0.72297,-0.45818,-0.51708],[-0.9228,-0.12114,0.36575],[0.68298,0.53769,0.4944],[0.64041,-0.31855,0.69885],[0.5329,0.35467,0.76826],[0.27998,-0.61878,-0.73397],[-0.02303,-0.040297,0.99892],[0.43173,-0.66894,0.60508],[-0.63115,0.77509,0.02985],[0.94944,-0.31348,0.017076],[0.066378,-0.034596,0.99719],[0.77331,-0.61982,-0.13345],[0.90309,-0.2669,0.33645],[0.83494,-0.010052,0.55025],[-0.50917,0.70287,0.49671],[-0.534,0.83209,0.14989],[0.80571,0.10828,0.58233],[0.14982,0.96103,0.23231],[0.024172,0.52033,0.85362],[0.60304,0.73831,0.30206],[0.43865,0.78848,0.43114],[0.48308,0.77686,0.40388],[-0.45286,0.89054,0.043062],[-0.76181,0.49531,0.4175],[-0.73114,0.68093,0.042044],[0.44306,0.80922,0.38583],[-0.54703,0.36377,0.75394],[-0.57608,0.81545,-0.056422],[0.52151,-0.022694,0.85295],[0.28572,0.78457,0.55029],[0.45067,-0.47838,0.75369],[-0.8143,0.34576,0.46622],[-0.065934,0.90863,0.41237],[0.046988,0.83671,0.54563],[-0.085142,0.82477,0.55901],[0.91928,-0.23772,-0.31372],[-0.8012,0.06328,0.59504],[0.25271,0.64104,0.72472],[0.40785,-0.62155,0.66883],[0.28891,0.72836,0.62131],[-0.047953,-0.89386,-0.44577],[0.23779,-0.83246,-0.50046],[-0.56594,0.82443,-0.0061737],[-0.67542,-0.26391,-0.68859],[-0.85104,0.079144,0.51909],[-0.22839,-0.96523,-0.12715],[-0.063081,-0.98405,-0.16632],[-0.042217,-0.9867,-0.15698],[-0.19718,-0.97597,-0.092768],[0.34491,-0.92939,-0.1314],[0.16587,-0.59872,0.7836],[-0.38814,-0.90224,-0.18792],[0.080967,0.83275,0.5477],[-0.60329,-0.78795,-0.12319],[0.67786,-0.66811,-0.30681],[0.77814,0.1492,0.61011],[-0.70816,-0.22983,0.6676],[0.74085,-0.53254,-0.40932],[-0.58989,-0.79013,-0.16651],[-0.35935,0.92872,0.091373],[0.80473,-0.31718,-0.50181],[0.75045,-0.084403,-0.65551],[0.49871,0.028245,0.86631],[-0.53145,-0.84709,0.0019785],[0.62593,0.18794,-0.75689],[0.72624,-0.16363,-0.66769],[-0.23958,-0.94759,0.21136],[0.0049924,-0.9748,0.223],[0.031792,-0.96306,0.26739],[0.67824,0.42823,0.59718],[-0.70047,-0.66988,0.24617],[-0.028458,-0.45981,0.88756],[0.36658,0.34757,-0.86303],[0.31989,0.43895,-0.83964],[-0.75085,-0.6593,0.039473],[0.64971,-0.75669,-0.072756],[-0.70822,0.69351,0.1322],[0.6424,-0.22396,-0.73291],[-0.98933,0.024444,-0.14361],[0.47226,0.19092,-0.86053],[-0.78987,-0.61325,0.0061664],[0.76144,-0.21022,-0.6132],[-0.68256,-0.72761,0.068537],[-0.57797,0.61077,0.54121],[0.27361,0.94251,0.19188],[-0.23309,-0.44267,-0.86586],[-0.0091692,-0.54299,-0.83969],[-0.053764,-0.70698,-0.70518],[-0.9077,0.20728,0.36485],[-0.33283,0.52657,0.78227],[0.0038146,-0.43967,0.89815],[0.21422,-0.78605,-0.57985],[0.36832,-0.7953,-0.4815],[0.50622,-0.5325,0.67836],[0.78396,-0.58318,-0.21287],[-0.55857,-0.007221,-0.82942],[0.41075,-0.65899,-0.63009],[0.70437,-0.70492,-0.083381],[-0.00042861,-0.4271,0.90421],[0.65839,-0.69561,-0.28747],[0.23244,-0.65126,-0.72237],[0.031438,0.38106,0.92401],[0.35702,-0.5512,-0.75414],[0.23143,0.96379,0.13251],[0.76425,-0.63545,-0.11013],[-0.031878,-0.38586,0.922],[-0.64972,-0.011341,-0.76009],[-0.7399,0.39042,-0.54783],[-0.39733,0.69415,0.60024],[-0.15857,0.97696,0.14285],[-0.87205,-0.48201,-0.084883],[0.58118,-0.34069,0.73903],[-0.79775,0.46944,-0.37845],[-0.80389,0.58808,0.089004],[0.86024,-0.49819,-0.1086],[-0.70591,-0.47886,-0.5219],[-0.72218,-0.090594,0.68575],[0.86942,-0.2762,-0.40965],[0.87291,-0.45778,-0.1687],[-0.097104,0.80229,0.58899],[-0.8664,0.49343,-0.07671],[0.1013,-0.46895,0.87739],[-0.78894,-0.42445,-0.44433],[0.82988,-0.18897,-0.52496],[0.87233,-0.47379,0.12068],[0.75408,-0.49166,-0.43547],[0.7006,0.58212,0.41267],[-0.8487,-0.50747,0.14893],[0.72951,-0.58488,0.35458],[-0.85022,0.37178,-0.37271],[0.1944,0.19859,0.96061],[-0.28083,-0.13638,0.95002],[-0.43683,0.58904,0.67986],[-0.90098,0.17213,-0.39825],[-0.59328,0.071679,0.8018],[0.8637,0.2274,0.44978],[0.85082,-0.464,0.24661],[-0.078819,0.98463,0.15583],[0.56099,-0.47891,-0.67523],[0.79017,-0.56164,0.24533],[-0.8023,0.015132,-0.59672],[0.64252,-0.44578,-0.62326],[-0.063343,-0.42318,0.90383],[0.18573,0.96986,0.1577],[-0.99849,0.052431,-0.016503],[-0.17341,-0.98097,0.087322],[-0.50371,0.61048,0.61122],[0.92303,-0.03999,-0.38264],[0.16673,-0.92218,0.34899],[-0.73934,0.045476,-0.67179],[-0.72166,0.37736,0.58035],[-0.33249,0.61194,0.71762],[-0.22186,-0.86968,0.44094],[-0.26667,-0.83042,0.48917],[0.40346,-0.87185,0.27765],[-0.55034,-0.64323,0.53233],[-0.63519,0.57488,0.51579],[-0.36519,-0.65575,0.66078],[0.63493,-0.1219,0.76289],[-0.80371,0.025853,-0.59445],[-0.083646,-0.97898,0.18602],[0.7706,-0.27819,-0.5734],[0.95745,-0.18812,-0.21887],[-0.89496,0.44185,0.061699],[0.41219,-0.61061,-0.6762],[-0.91333,-0.39304,-0.1065],[-0.65769,0.50498,0.55897],[-0.96636,0.24436,-0.080281],[-0.45135,0.49493,0.74251],[0.30775,-0.5486,-0.77739],[1.041e-05,-0.26682,0.96375],[-0.84032,0.42849,-0.33205],[-0.43474,0.04981,0.89918],[0.2432,0.25387,0.93616],[-0.79948,-0.26973,0.53673],[0.058861,-0.23729,0.96965],[0.93513,0.12402,-0.33188],[0.83404,-0.54982,0.045647],[0.85372,0.13154,-0.50384],[-0.017957,-0.99981,-0.0071782],[0.81665,-0.56133,0.13411],[0.60047,0.70553,0.37638],[-0.63042,0.35534,-0.69015],[0.71546,-0.31628,-0.62297],[0.3573,-0.8449,0.3981],[0.58338,0.59205,0.55602],[0.14299,-0.14922,0.97841],[0.21157,-0.12608,0.9692],[-0.33282,0.56819,0.75259],[-0.65012,0.090236,0.75445],[0.93844,-0.27344,0.21111],[-0.94735,-0.096938,0.30516],[-0.64451,0.55221,-0.52883],[0.70373,-0.11813,0.70058],[-0.71813,0.031972,-0.69518],[-0.65737,0.62682,-0.41829],[0.57467,0.80335,-0.15617],[0.75414,0.63542,-0.16586],[-0.61985,0.72774,-0.29356],[0.71251,0.70058,0.038988],[-0.10961,-0.19994,0.97366],[-0.88206,0.2206,-0.41631],[0.85884,0.23997,0.45256],[-0.62958,0.7673,-0.12196],[0.81332,-0.018073,0.58153],[0.54387,0.81338,0.20644],[0.69783,0.33093,-0.63523],[0.79857,0.27279,0.53654],[0.40159,0.81102,0.42542],[0.88639,-0.31878,-0.33568],[0.34232,0.88282,0.32164],[-0.60371,-0.1652,0.7799],[-0.74601,-0.19599,-0.63644],[-0.61498,0.77904,0.12206],[-0.51686,0.80293,0.29692],[0.018438,-0.29162,0.95636],[-0.55523,0.58023,0.59587],[0.87471,0.13317,0.46599],[-0.43214,0.83905,0.33052],[0.5609,0.82355,0.084625],[-0.76751,0.21512,-0.60386],[-0.0039226,-0.25258,0.96757],[-0.63778,0.52643,0.56224],[0.76148,0.41498,0.49793],[0.19543,0.97983,0.04165],[-0.29898,0.67975,0.66974],[-0.095849,-0.99474,0.036085],[0.82239,0.33699,-0.45838],[-0.25368,0.91541,0.31251],[0.27167,0.90403,0.33002],[0.29765,0.89665,0.32776],[0.15688,0.922,0.35398],[0.36214,0.80892,0.46314],[-0.80848,-0.051575,-0.58626],[-0.1504,-0.98677,0.06052],[0.64541,-0.50629,0.57194],[-0.82568,-0.083024,-0.55799],[0.82991,0.27097,0.48767],[-0.85297,0.17419,-0.49204],[0.69787,-0.59432,-0.39969],[-0.89029,-0.080028,-0.44831],[0.4022,-0.86989,-0.28552],[0.87299,0.32387,0.3647],[0.57815,-0.70257,-0.4149],[0.91861,0.22639,-0.32389],[0.88054,0.22255,0.41847],[-0.98001,-0.035733,-0.19572],[0.80999,0.39211,0.43607],[-0.6585,0.49536,-0.56656],[0.96765,-0.25047,-0.030138],[-0.66137,0.49675,-0.56199],[0.83004,0.3486,0.43533],[-0.85242,0.39753,-0.33962],[-0.99818,-0.057652,-0.017459],[-0.93704,-0.1258,0.32576],[0.027461,-0.12179,0.99218],[-0.9709,0.11939,-0.2076],[0.97758,0.023357,0.20928],[-0.11217,0.011586,0.99362],[0.19339,0.78809,-0.5844],[0.86413,0.22471,0.45032],[-0.37087,0.2496,0.89452],[0.6464,-0.088899,0.75781],[-0.97084,0.057781,0.23266],[-0.34174,0.92246,-0.17967],[0.76757,0.52183,0.3722],[0.030766,0.5917,-0.80557],[0.54042,0.76942,0.34051],[0.29411,0.67931,-0.67234],[0.074808,0.94708,-0.31216],[-0.40943,0.82887,-0.38124],[0.75348,-0.30367,0.58314],[0.19359,-0.011456,0.98102],[0.6663,0.46676,0.58154],[-0.98147,-0.15433,-0.11353],[-0.83255,-0.021454,0.55354],[-0.063904,-0.99493,0.077607],[-0.071431,0.79621,-0.60078],[0.13257,0.60996,-0.78127],[-0.53805,0.62559,-0.56492],[-0.98037,0.055416,0.18921],[0.63207,0.48269,0.60621],[-0.8455,0.3097,0.43499],[-0.99433,-0.097025,-0.043462],[-0.10089,0.72828,-0.67781],[0.93353,-0.32684,-0.14732],[-0.3844,-0.58303,0.71576],[0.85645,0.10137,0.50617],[-0.93661,-0.014542,0.35008],[0.83253,0.55398,0.00087786],[0.48525,0.46586,-0.73994],[-0.89129,0.21038,-0.40166],[0.78665,-0.4403,-0.43281],[-0.82343,-0.1982,0.53167],[-0.84415,-0.50207,-0.18799],[-0.17508,-0.097312,0.97973],[-0.85838,0.16825,0.48464],[-0.66095,0.56787,0.49058],[-0.77263,0.57088,0.27773],[0.52011,-0.70737,0.47867],[0.75428,0.63141,0.17997],[0.65134,-0.39776,0.64618],[0.92589,-0.22329,0.30475],[0.84483,0.216,-0.4895],[-0.5757,0.13896,0.80577],[0.66128,0.65296,0.36927],[0.90355,-0.145,-0.4032],[-0.5865,-0.5436,-0.60042],[-0.69954,-0.053429,0.7126],[0.94962,-0.022793,0.31257],[0.31051,0.86555,0.39295],[0.7429,0.011438,0.6693],[0.10289,-0.98983,-0.098228],[-0.46902,0.74072,0.481],[0.073091,-0.094681,0.99282],[0.14601,-0.14373,0.97879],[0.23196,-0.16493,0.95864],[-0.89065,0.23932,0.3866],[0.50444,0.63866,0.58108],[0.023805,-0.99969,-0.0078176],[-0.28837,0.84691,0.44676],[-0.090646,0.89755,0.43149],[0.27479,0.84307,0.4623],[-0.45504,-0.62585,-0.63345],[-0.3417,-0.52108,-0.78212],[-0.89454,0.37582,0.24198],[0.12208,-0.37942,-0.91713],[-0.083706,-0.99563,0.041448],[0.14686,-0.35445,-0.92347],[-0.93395,-0.0005822,0.3574],[0.89611,0.41577,-0.15527],[0.67877,0.56189,0.47281],[-0.89213,-0.29333,-0.3436],[0.69555,-0.27991,-0.66172],[0.035826,-0.41243,-0.91028],[0.011412,-0.99821,0.05867],[-0.16547,-0.3398,0.92582],[0.91563,0.39819,-0.055425],[-0.91651,-0.39838,-0.035935],[-0.90893,0.38514,-0.15974],[-0.72677,0.09589,0.68015],[0.55809,0.79775,0.22835],[-0.23011,0.66149,0.71378],[0.79763,-0.15655,0.58248],[-0.74925,0.0085257,0.66223],[0.58643,-0.48359,-0.6498],[0.7936,0.067851,0.60465],[0.7023,-0.4604,-0.54296],[0.52301,-0.49012,-0.69731],[-0.94376,0.052213,-0.32648],[-0.62565,0.095125,0.77428],[-0.71807,-0.064075,0.69301],[-0.95448,-0.28218,0.096645],[0.48164,-0.52536,-0.70144],[-0.97536,-0.049109,0.21508],[-0.76283,-0.049934,0.64467],[-0.32864,0.65569,0.67976],[0.9067,0.23102,0.35288],[-0.77396,-0.047536,0.63145],[0.7584,0.64936,0.056224],[0.65655,0.73662,0.16229],[-0.99809,-0.059683,-0.016145],[0.42226,-0.55556,-0.71628],[-0.72743,0.68493,-0.04149],[0.38258,0.68421,0.62088],[0.29976,-0.57044,-0.76468],[0.53044,-0.61504,0.58341],[-0.67083,0.1577,0.72465],[-0.69116,0.72269,0.0049306],[0.16636,-0.54361,-0.82269],[-0.92969,-0.31407,0.19243],[0.9032,-0.065519,0.42419],[0.18026,-0.54699,-0.8175],[-0.56987,0.23093,0.78862],[0.77137,-0.46179,0.43788],[0.61072,-0.55806,-0.56177],[-0.89625,-0.17027,0.40956],[0.18558,-0.40897,0.89348],[-0.62804,0.22468,0.74504],[0.61072,0.72645,0.3151],[0.81731,0.10109,-0.56726],[0.58032,-0.062154,0.81201],[-0.9007,0.28881,0.32455],[-0.54324,0.34499,0.76542],[0.62379,0.23807,0.74445],[-0.24166,-0.38521,0.89063],[-0.46513,0.84,0.27938],[0.49996,0.22464,0.83641],[0.73146,0.56496,0.38182],[-0.39701,0.57964,0.71162],[-0.36407,0.85932,0.35919],[0.79666,-0.23215,0.55807],[0.53857,0.3678,0.75807],[-0.93843,0.13393,-0.31846],[-0.18521,-0.26518,0.94624],[-0.18749,0.46402,0.86575],[0.22813,-0.42006,0.87835],[0.11105,0.6716,0.73255],[0.59917,0.79847,-0.058638],[-0.14815,0.69533,0.70326],[0.15183,0.72577,0.67097],[-0.26846,0.85435,0.445],[-0.91762,-0.3011,0.25943],[0.23085,0.64589,0.72769],[0.86756,-0.14042,-0.4771],[0.22613,-0.26155,0.93833],[0.092502,0.68911,0.71873],[-0.22257,-0.90593,-0.36021],[-0.0044874,-0.96253,-0.27113],[0.18054,-0.95344,-0.24157],[-0.26256,-0.88657,-0.38087],[0.3959,-0.89662,-0.19832],[-0.29485,-0.40775,0.86418],[0.33686,-0.91018,-0.24102],[0.84168,-0.17588,-0.51053],[-0.49436,-0.86694,0.063516],[-0.28937,-0.95651,-0.036724],[-0.23578,-0.3016,0.92382],[-0.49357,0.082637,0.86577],[-0.94056,0.21099,-0.26612],[-0.61597,-0.78762,-0.015502],[-0.77478,0.1629,0.61089],[0.26249,-0.26848,0.92683],[0.93257,-0.098622,0.34725],[0.51652,-0.64376,0.56461],[-0.40806,-0.90704,0.10373],[0.072096,-0.96558,0.24991],[0.6199,-0.1006,0.7782],[-0.74182,-0.63692,0.20985],[0.53776,0.063398,-0.84071],[-0.44053,-0.86854,0.22707],[0.40857,-0.89866,0.15963],[0.48482,0.36573,-0.79448],[-0.60793,-0.79076,0.071531],[0.52491,-0.85051,0.033243],[-0.725,-0.63964,0.25541],[-0.98307,0.047127,0.17709],[0.4895,0.26306,-0.83138],[-0.025369,-0.73176,-0.68108],[0.86428,-0.49142,0.10738],[0.96837,0.24923,-0.012169],[-0.79661,0.48962,0.35452],[-0.84778,-0.52541,-0.072205],[-0.91303,0.15639,0.37671],[-0.052078,-0.4572,-0.88784],[0.070661,-0.55617,-0.82806],[-0.71998,-0.68435,0.11525],[-0.93104,0.0035545,-0.36489],[0.34914,0.37004,-0.86091],[-0.44749,-0.51562,-0.73068],[-0.22317,-0.10774,0.96881],[-0.30923,-0.64109,-0.70241],[0.0576,-0.56068,-0.82603],[0.043236,-0.61868,-0.78445],[-0.027222,-0.51131,-0.85897],[0.20029,-0.77327,-0.60161],[-0.91105,-0.21901,0.34933],[-0.66506,-0.74469,0.055941],[0.55208,0.16019,-0.81826],[-0.89079,0.098768,0.44354],[0.93203,-0.01596,0.36203],[-0.47549,-0.29645,-0.82827],[-0.5555,0.51172,0.65541],[-0.86365,-0.23768,0.44454],[-0.76151,-0.64514,0.062347],[0.70244,-0.20683,-0.68103],[-0.71124,0.025661,-0.70248],[0.23493,-0.809,-0.53882],[0.28883,-0.72957,-0.61992],[-0.29771,0.068826,0.95217],[-0.87397,0.20866,-0.4389],[-0.78043,-0.62249,-0.058641],[0.78992,0.61013,-0.06131],[-0.68924,-0.68626,0.23234],[0.63833,0.081083,0.76548],[-0.74868,0.4039,-0.52568],[0.8937,-0.26481,0.36219],[0.75018,-0.42206,-0.50902],[-0.87268,-0.48727,0.031637],[0.8298,-0.040668,0.55657],[-0.73257,0.51116,-0.4495],[0.5004,-0.54044,-0.6764],[-0.65592,-0.7162,-0.23839],[-0.61968,-0.64061,0.45345],[0.79806,0.53896,0.26948],[-0.66507,0.74581,-0.038199],[0.83314,-0.33887,-0.43708],[-0.44461,-0.76966,-0.4582],[-0.85342,-0.41907,0.30993],[0.88164,-0.31283,-0.35332],[0.83396,-0.41862,0.35953],[0.60989,0.79073,0.05273],[-0.6051,-0.63022,-0.48649],[-0.43357,0.60679,0.6662],[-0.90706,0.41417,0.075564],[-0.88621,0.41189,0.21206],[0.53625,-0.076211,0.84061],[0.56725,-0.7768,-0.2735],[-0.34681,0.57301,0.74256],[-0.87387,0.48604,-0.011044],[0.9048,-0.27505,-0.3251],[-0.8068,-0.4218,-0.41372],[0.39601,-0.41036,0.82145],[-0.86668,0.36213,-0.3431],[0.77254,-0.33355,-0.5403],[-0.037708,0.0084983,0.99925],[-0.89235,0.2105,-0.39926],[-0.85262,-0.3516,-0.38653],[0.90876,-0.4064,-0.094865],[0.57959,-0.5215,-0.62619],[-0.30479,-0.26488,0.91485],[0.50369,-0.84599,0.17493],[0.73135,0.67824,-0.071492],[-0.47615,-0.8793,-0.010669],[0.61305,-0.44928,-0.64985],[-0.95529,-0.17332,-0.23954],[0.85029,0.044129,-0.52445],[-0.77095,-0.53103,0.35162],[0.90364,-0.42344,-0.064332],[-0.80379,0.015029,-0.59472],[-0.82466,0.49562,0.27257],[0.65089,-0.40603,-0.64147],[0.24482,-0.96619,0.080861],[0.85348,0.49384,0.16642],[-0.86078,-0.02342,-0.50844],[0.7924,-0.38523,-0.47296],[-0.78739,-0.52371,0.3252],[0.27242,0.94278,0.19224],[0.77175,-0.63307,0.060208],[0.32155,-0.72463,-0.60952],[0.61609,0.7508,-0.23821],[0.27315,-0.96197,-0.0021597],[0.16836,-0.89808,0.40632],[0.26693,-0.21709,0.93895],[-0.87572,-0.048348,-0.48039],[0.32873,-0.05297,0.94294],[0.9305,0.0016166,-0.36628],[-0.49005,-0.73254,0.47249],[0.14138,-0.82521,0.54685],[0.088457,-0.82746,0.55451],[-0.36872,0.29713,0.88077],[-0.36324,0.60582,0.70784],[0.85893,-0.25728,-0.44278],[-0.23471,-0.84402,0.48223],[-0.14736,-0.82463,0.54615],[0.52614,0.020119,0.85016],[0.76211,-0.6464,-0.036704],[-0.84242,0.034901,-0.53769],[0.94714,-0.13178,-0.29251],[-0.098633,-0.0648,0.99301],[-0.3376,-0.87354,0.35064],[0.90129,-0.42897,-0.060535],[0.59248,-0.40172,-0.69828],[0.8235,-0.51167,0.24503],[0.9466,0.066681,-0.31543],[-0.96248,0.26982,-0.028739],[0.195,-0.69596,-0.6911],[-0.52,0.23441,0.82137],[-0.77485,0.034364,-0.63121],[0.35326,-0.13129,0.92627],[0.56991,-0.32872,-0.75309],[-0.62491,0.59607,0.50417],[-0.84399,0.10563,-0.52585],[0.93281,-0.022403,-0.35968],[-0.335,-0.092817,0.93763],[0.45173,0.41007,0.79233],[0.82482,0.063383,-0.56182],[0.95009,0.028292,-0.3107],[-0.89112,-0.06503,0.44908],[-0.75525,0.26226,-0.60068],[-0.61625,0.78754,-0.003661],[0.92409,0.33146,-0.19025],[-0.97461,-0.082869,-0.20799],[0.88926,-0.015056,-0.45715],[-0.81275,0.13528,-0.56668],[0.96496,-0.25203,-0.072966],[0.92824,0.35339,-0.11609],[-0.68057,-0.68095,0.27042],[-0.54837,0.82746,-0.12084],[0.79824,-0.59036,0.11956],[-0.62781,0.29433,0.72058],[0.64854,0.61745,0.44513],[0.1205,0.96217,-0.24434],[-0.7399,0.18621,-0.64643],[0.25689,-0.08354,0.96282],[-0.70612,0.30211,-0.64041],[0.87532,0.46519,-0.13195],[-0.95643,-0.082968,-0.27994],[0.16356,0.97842,-0.12629],[0.66354,-0.3644,-0.65339],[0.71052,0.70264,0.038248],[0.91353,0.13395,-0.38407],[-0.69783,0.10614,-0.70835],[0.7516,0.65636,-0.065497],[0.69947,0.71148,-0.067326],[-0.9027,0.080905,-0.4226],[0.81924,0.16166,-0.5502],[-0.6082,0.084127,-0.78931],[0.88445,0.036308,0.46523],[0.89962,-0.43296,-0.056867],[0.71296,0.59948,-0.36374],[0.42921,0.78695,-0.44328],[0.81243,-0.21912,0.54032],[-0.61172,0.66659,-0.42598],[0.5081,0.77943,-0.3665],[-0.5478,0.69266,0.4692],[-0.48545,-0.37861,0.78803],[-0.70548,0.036344,-0.7078],[0.79388,0.23507,0.5608],[-0.54085,0.78051,0.3135],[-0.51982,-0.43198,0.73701],[0.28014,-0.33963,0.89787],[0.818,0.21914,-0.53184],[-0.34887,0.85739,-0.37839],[-0.87192,0.30143,-0.38588],[-0.31791,0.85426,-0.4113],[0.72478,-0.13383,0.67585],[-0.97877,0.093647,0.18233],[-0.28654,-0.030111,0.9576],[-0.71239,0.0022226,-0.70178],[-0.13541,0.96523,-0.22362],[0.1647,0.89447,-0.4157],[0.60754,0.76005,0.23067],[-0.79808,0.33658,-0.49979],[0.76265,0.4259,-0.48679],[-0.60016,0.76434,-0.23578],[0.53156,0.21794,0.8185],[0.89077,0.059831,0.45049],[0.53546,0.6733,0.50986],[-0.85578,0.50681,-0.10388],[0.39619,0.90652,0.14583],[0.7738,0.46114,-0.43427],[-0.20968,0.90841,0.3617],[-0.13991,0.95099,0.27578],[-0.90272,-0.31089,0.2974],[0.23532,0.95725,0.16822],[0.0069322,0.97212,0.23438],[-0.044119,0.99253,0.11371],[0.00063186,0.99619,0.087226],[0.81152,-0.0035876,-0.58432],[0.96416,0.053485,0.25988],[-0.23386,0.84961,0.47273],[0.99531,-0.058988,0.07662],[-0.94711,0.27998,-0.1568],[0.8371,0.22326,-0.49942],[0.34592,0.93363,-0.093105],[-0.81657,-0.042873,-0.57565],[-0.38141,-0.13374,0.91468],[0.02775,0.87979,0.47455],[0.77859,-0.30039,-0.55097],[0.93434,-0.34829,-0.075479],[-0.88965,0.19373,0.4135],[0.66539,-0.60054,-0.4434],[0.90878,0.39667,0.1295],[0.89116,0.42373,0.16211],[-0.85644,0.35918,-0.37082],[0.90189,0.21455,0.37492],[-0.9569,-0.05073,-0.28595],[0.38988,0.79892,-0.45795],[0.42463,0.79032,-0.44168],[-0.98839,0.080885,0.1286],[-0.90691,0.1505,0.39351],[-0.94462,0.20465,-0.25655],[0.90488,0.42199,-0.055838],[0.28217,0.95849,0.041011],[0.88514,0.46527,0.0074141],[0.82711,0.39801,0.39683],[0.36394,0.92974,-0.055998],[-0.84824,-0.43723,0.29885],[-0.99854,-0.049831,-0.020749],[-0.51248,0.35655,-0.78117],[-0.99509,-0.099014,-0.00080385],[-0.98931,0.11347,0.091583],[-0.81153,-0.14288,0.56658],[-0.44647,0.33665,-0.82906],[0.77743,-0.26059,-0.57245],[0.98107,0.17441,0.084185],[0.83696,0.40127,0.37213],[-0.75723,0.58157,-0.29727],[0.30591,-0.34633,0.88683],[-0.68121,0.077964,0.72792],[-0.78864,0.29262,-0.54077],[-0.80564,-0.52338,0.27752],[-0.95956,0.15431,0.23545],[-0.45527,0.5608,-0.69154],[0.15556,0.94265,-0.29532],[0.31068,-0.18895,0.93154],[0.99992,-0.0036258,-0.012511],[-0.97219,0.10429,0.20969],[-0.8462,-0.074906,-0.52758],[0.39818,0.71201,-0.57836],[0.24714,0.53565,-0.80747],[0.66835,0.72268,-0.1762],[0.10732,0.73685,-0.66748],[0.44441,0.84836,-0.28771],[0.94635,-0.25642,-0.19666],[0.77391,-0.14186,0.6172],[0.073479,0.30907,-0.9482],[0.089671,0.38568,-0.91827],[0.3008,0.19613,-0.9333],[-0.50789,0.72911,-0.45875],[0.6469,0.080252,0.75834],[-0.95787,0.093872,0.27141],[0.14745,0.97849,-0.14428],[0.48025,0.76724,0.42509],[0.39591,0.59944,-0.69565],[0.4987,0.72639,0.47293],[-0.042649,0.39896,-0.91598],[-0.084774,0.34237,-0.93573],[0.061584,0.19412,-0.97904],[0.2679,0.14866,-0.95191],[-0.72374,0.48275,-0.49311],[0.98229,-0.17312,0.071711],[-0.67434,-0.39508,-0.62384],[0.36104,0.35246,-0.86338],[-0.83811,0.017496,0.54523],[-0.032395,0.37826,-0.92513],[0.067211,0.44186,-0.89457],[-0.45439,0.81976,-0.34859],[0.31664,0.44517,-0.83759],[-0.06826,0.94172,-0.3294],[-0.027252,0.59149,0.80585],[0.014358,0.65644,-0.75424],[0.0040145,0.84634,-0.53263],[0.86265,0.49912,-0.081937],[0.62104,0.77211,-0.13474],[0.51782,0.31546,-0.7952],[-0.93834,0.20664,-0.27717],[-0.54433,-0.4432,-0.71223],[0.68186,-0.48336,-0.54902],[-0.58013,0.62074,0.52738],[-0.98754,-0.036323,0.15311],[-0.52008,-0.73785,0.43024],[-0.70392,0.14721,0.69486],[0.23731,-0.2603,0.93591],[0.68942,0.43667,-0.57795],[0.74678,0.23366,0.62267],[-0.64925,0.62261,0.43684],[-0.41948,-0.49297,-0.76224],[0.95031,0.13359,-0.28117],[0.3608,0.72428,-0.58757],[-0.99529,0.013087,0.096052],[0.97376,0.14319,-0.17691],[0.86031,0.34214,-0.37791],[-0.55029,0.72976,0.40575],[0.60072,0.57417,0.55629],[-0.49471,0.86359,-0.097393],[-0.92081,-0.011675,0.38983],[0.59823,-0.48898,-0.63484],[0.80157,-0.32027,-0.5049],[0.97663,-0.12584,0.17421],[0.85728,0.42132,-0.29592],[-0.79502,-0.47222,-0.38072],[-0.20842,-0.62102,-0.75557],[0.060406,-0.42708,-0.90219],[0.86032,0.0089144,0.50968],[0.062396,-0.37841,-0.92353],[-0.30793,-0.50165,-0.80841],[-0.62893,0.66943,-0.39536],[-0.10019,0.84364,-0.52748],[-0.69929,0.64957,-0.29843],[-0.8283,-0.55801,0.050403],[0.096162,-0.38999,-0.91578],[0.89915,0.2298,-0.37244],[-0.1005,-0.4521,-0.88628],[-0.3331,0.794,-0.50853],[-0.98734,0.13121,-0.089104],[-0.7742,-0.40088,0.4898],[-0.89744,-0.41538,0.14855],[-0.96679,0.25411,-0.027497],[0.86622,-0.12049,0.48492],[-0.6067,0.072244,0.79164],[0.89985,0.2769,-0.33703],[0.59741,-0.73457,-0.32174],[-0.84111,0.53213,-0.096795],[-0.33143,0.79795,-0.50342],[0.68357,-0.44514,0.57843],[-0.75853,0.64494,-0.093171],[-0.30998,-0.94585,0.096368],[0.82728,0.55153,0.10682],[-0.1499,-0.98867,0.0079011],[0.61977,-0.10449,0.7778],[-0.95157,0.30234,-0.055732],[0.86655,-0.34515,-0.3605],[0.79523,0.50337,-0.33797],[-0.62529,0.3195,0.71199],[-0.96714,0.085313,0.23952],[0.67985,0.70398,0.20546],[0.92769,-0.32215,0.18873],[0.88632,-0.41276,-0.20994],[0.91653,-0.12798,0.37895],[0.82442,-0.36274,-0.43446],[-0.81773,-0.45168,-0.35678],[-0.83413,-0.25807,-0.48748],[0.82518,0.11396,0.55326],[-0.9841,-0.039526,0.17314],[-0.547,0.81494,0.19149],[0.98724,-0.12234,-0.10196],[0.53617,0.29657,0.7903],[0.88138,-0.25126,0.40005],[0.47964,0.72699,0.49136],[-0.86815,-0.41901,0.26598],[-0.46676,0.83289,0.29736],[0.69879,0.14497,0.70048],[0.31863,0.73422,0.59949],[-0.88535,-0.034047,-0.46368],[0.50197,0.32446,0.80172],[0.10292,0.52961,0.84197],[-0.49859,0.32463,0.80375],[-0.92937,-0.26035,0.2617],[0.29288,0.51161,0.80776],[0.026531,0.64458,0.76407],[0.82,-0.01621,0.57213],[0.62576,0.19216,0.75597],[0.45769,0.77415,0.43728],[-0.35618,0.17956,0.917],[-0.11512,0.75223,0.64876],[0.12288,-0.52653,-0.84123],[0.51089,-0.69627,0.50419],[0.55646,-0.52158,0.64677],[-0.25863,-0.89915,-0.35305],[0.39383,-0.91635,-0.072083],[-0.081023,-0.96847,-0.23557],[0.4005,-0.91257,-0.082545],[0.40288,-0.86238,-0.30657],[-0.49284,-0.49443,-0.716],[-0.33233,-0.47333,-0.81579],[-0.478,-0.8714,-0.11031],[0.62662,-0.37952,-0.68067],[-0.70831,-0.70164,-0.077404],[-0.58056,-0.79763,-0.16354],[-0.89482,-0.41356,0.1681],[0.29763,-0.51068,-0.80661],[0.072822,-0.26436,-0.96167],[0.21649,-0.49427,-0.84192],[0.94591,0.046928,0.32102],[-0.94874,0.040051,0.3135],[-0.2644,-0.89911,0.34884],[0.0020008,-0.96062,0.27785],[0.99335,-0.078336,0.084391],[-0.046045,-0.61429,-0.78774],[0.1277,0.19866,-0.97171],[0.12054,-0.15652,-0.98029],[-0.31093,-0.86544,-0.39286],[0.54247,-0.37874,-0.74985],[-0.66877,-0.54604,0.50456],[-0.98596,-0.099205,0.13433],[-0.37156,-0.071396,0.92566],[-0.24416,-0.61596,-0.74899],[-0.13599,-0.12265,0.98309],[-0.11815,-0.55517,-0.8233],[0.15503,-0.57907,-0.8004],[-0.98545,0.14609,-0.086837],[0.97957,0.032981,0.19839],[-0.11993,0.12895,-0.98437],[0.55456,-0.11944,-0.82353],[0.94785,-0.2146,-0.23564],[-0.4124,-0.40802,-0.81452],[0.3737,-0.57661,-0.72654],[-0.36015,-0.11463,0.92582],[0.52378,0.023126,0.85154],[-0.9024,-0.061055,0.42656],[0.73183,0.021908,0.68113],[-0.034712,0.24247,-0.96954],[-0.062868,0.23495,-0.96997],[0.39014,0.078536,-0.9174],[0.70423,-0.70941,0.028237],[0.49026,-0.66913,-0.55848],[0.34714,-0.55427,-0.75649],[-0.8021,0.076541,0.59227],[0.29299,0.25802,-0.92064],[-0.16958,-0.70116,-0.69254],[0.97856,-0.035761,-0.20284],[-0.90168,0.41972,-0.10397],[0.11193,0.27709,-0.9543],[-0.72777,-0.1514,-0.6689],[0.72745,0.30053,0.61685],[0.41932,-0.78659,-0.45326],[0.20304,-0.82813,-0.52247],[0.45547,0.10089,-0.88452],[-0.60625,-0.59261,-0.53035],[-0.0088492,0.33476,-0.94226],[0.81709,-0.53942,-0.20345],[0.53096,0.22176,0.81787],[-0.85913,0.23089,-0.45672],[-0.93732,-0.13448,0.32149],[-0.063134,-0.64335,-0.76296],[-0.65244,-0.73035,0.20229],[0.94067,0.27562,-0.19792],[-0.80061,0.5718,-0.17907],[0.44901,-0.66974,-0.59147],[0.61441,-0.57592,-0.53928],[0.5473,-0.16471,-0.82057],[0.72063,-0.68232,-0.12303],[-0.67477,0.73547,-0.061387],[-0.42876,-0.056691,0.90164],[0.51394,0.1211,0.84923],[0.73257,0.62534,-0.26886],[0.73232,-0.19684,-0.65189],[0.82302,-0.5488,-0.14651],[0.78115,0.10083,0.61615],[0.57688,-0.53091,-0.62076],[0.95648,0.28613,-0.057295],[-0.47525,-0.80212,-0.36159],[0.77502,-0.21799,0.59315],[-0.62244,0.78153,-0.042259],[-0.7128,0.70117,0.016958],[0.72101,-0.5145,-0.46415],[-0.75378,0.133,0.64353],[-0.56677,0.79771,-0.206],[-0.89276,-0.41764,0.16902],[0.98311,-0.18215,-0.017583],[0.80222,-0.30253,-0.5147],[0.14292,-0.08172,0.98635],[0.081876,-0.75426,-0.65145],[-0.90902,0.23918,-0.3413],[-0.76269,0.44919,-0.46533],[-0.41279,0.17613,0.89364],[0.57885,-0.75896,-0.29818],[-0.85331,-0.36174,-0.3755],[-0.90952,-0.37801,0.17285],[-0.80848,0.23531,-0.53943],[0.60883,-0.63246,-0.47888],[-0.33922,0.26773,0.9018],[-0.84498,0.28768,-0.45082],[0.75875,-0.12903,-0.63848],[0.9298,0.26949,0.25068],[0.43782,-0.69061,-0.57565],[0.93153,0.15992,-0.32661],[-0.94033,-0.21686,-0.26219],[0.76694,0.073154,-0.63754],[-0.87308,-0.42079,0.24632],[-0.99182,-0.010743,-0.1272],[-0.99408,0.10496,-0.028071],[-0.97275,0.11726,0.20001],[-0.39887,0.31988,0.85941],[-0.86492,0.31552,-0.39033],[0.94543,-0.21685,-0.24319],[-0.74517,-0.019429,-0.6666],[0.7739,-0.40312,-0.48844],[0.84242,0.44294,-0.30679],[-0.84243,0.53848,0.018834],[0.72647,-0.15693,0.66904],[0.90479,-0.32127,-0.27953],[0.83574,-0.0051655,-0.5491],[-0.74327,-0.55444,0.37436],[0.64466,-0.74934,0.15134],[0.7537,0.6123,-0.2388],[0.66105,-0.72022,0.21044],[-0.98989,0.13718,0.036037],[0.71447,-0.11141,-0.69074],[0.69039,0.035429,0.72257],[0.42109,-0.81972,0.38825],[0.15698,-0.059425,0.98581],[0.48107,-0.84952,0.21651],[0.089841,-0.84454,0.5279],[-0.17357,-0.84258,0.50983],[-0.36757,-0.77119,0.51977],[0.14975,-0.84135,0.51934],[0.42137,-0.85622,0.29889],[0.49767,-0.53726,-0.68094],[-0.059498,-0.33529,-0.94024],[-0.44667,0.19603,0.87296],[-0.87166,0.48068,-0.095648],[-0.49804,-0.79888,0.33726],[-0.97093,0.024836,0.23807],[0.93946,-0.14764,-0.30922],[-0.89019,-0.089518,0.44672],[0.032574,-0.58037,-0.8137],[-0.015285,-0.39371,-0.91911],[0.14411,0.83642,0.5288],[0.26889,-0.23264,-0.93465],[0.4702,-0.13844,-0.87163],[0.68117,0.22199,0.69765],[-0.34997,-0.02682,0.93638],[0.44207,-0.77063,0.45902],[0.6013,0.048216,-0.79757],[0.64796,-0.39726,-0.64987],[0.98462,-0.068705,-0.16061],[0.44479,0.31873,0.837],[0.58116,0.036571,-0.81297],[0.37163,-0.81455,0.44541],[0.404,0.80599,0.43262],[-0.84068,-0.5402,0.037815],[0.9372,-0.0028259,-0.34878],[-0.9364,-0.30999,-0.16448],[0.81128,0.37544,-0.44818],[-0.94453,0.19449,-0.26465],[-0.90608,0.29237,-0.30585],[0.13129,-0.18397,0.97412],[0.97805,0.028015,-0.20648],[0.85409,0.51829,0.043572],[-0.73658,0.047426,-0.67468],[0.81878,-0.4556,0.34934],[0.92623,0.15118,0.34532],[-0.97452,0.010743,0.22404],[-0.81115,0.50409,-0.29653],[0.66941,0.72045,-0.18121],[-0.6453,0.28425,0.70908],[0.79325,-0.22783,0.56467],[-0.8193,-0.27241,0.50452],[0.92824,0.035383,-0.37029],[0.4416,-0.34797,0.82699],[0.99933,-0.0013272,0.036582],[-0.72341,0.68518,-0.084856],[-0.40073,-0.40867,0.82],[-0.667,0.080695,-0.74068],[-0.62999,0.73894,-0.23891],[0.70162,0.62702,-0.33849],[0.79364,0.53288,-0.29356],[0.41777,0.84919,0.32303],[-0.99892,-0.046473,-0.00071455],[0.37293,0.010054,0.92781],[0.55695,0.81114,0.17847],[0.99589,-0.0013075,-0.090528],[0.62668,0.76615,-0.14243],[0.5634,0.80664,-0.17865],[-0.86481,0.21212,0.45508],[0.85173,0.25966,-0.45512],[0.88546,0.14997,0.43985],[-0.55503,0.78301,-0.28077],[0.45926,0.88746,-0.038721],[-0.45306,0.84132,-0.29483],[0.34546,0.89304,0.28834],[-0.11286,-0.95209,-0.28425],[0.88431,0.16952,0.43504],[-0.44464,0.88926,0.10731],[-0.93135,0.2276,0.28422],[0.35567,0.86922,0.34345],[0.37921,-0.59077,0.71217],[-0.76137,-0.11041,-0.63885],[0.5576,0.82572,-0.085224],[0.90142,0.069397,0.42735],[-0.40465,0.84496,0.3497],[0.90916,0.031699,0.41523],[-0.75058,-0.068534,-0.65721],[-0.3298,0.82645,0.4563],[-0.28417,-0.14676,0.94747],[0.030113,-0.56408,-0.82517],[0.81235,0.36131,-0.45777],[0.66082,-0.64498,-0.38381],[0.99981,-0.01544,-0.011513],[-0.18113,0.87111,0.45647],[0.21222,0.96168,0.17359],[0.040966,0.99623,0.07649],[0.059021,0.91772,0.39282],[0.013073,-0.99521,-0.096832],[0.97638,0.18463,0.11226],[-0.99804,-0.055891,-0.028069],[-0.84715,0.48414,-0.21896],[-0.57745,0.16657,0.79925],[0.19815,-0.93876,-0.28189],[0.86421,-0.18145,-0.46927],[-0.36094,-0.60814,0.70703],[0.93747,-0.045523,-0.34508],[0.96123,0.14451,0.23485],[-0.78887,0.50901,0.34436],[0.99221,-0.11341,0.051615],[0.78069,0.46309,0.4196],[-0.91565,0.36951,-0.15829],[0.79606,0.51344,-0.32041],[-0.084165,0.87216,0.48192],[-0.99689,0.078331,0.0090526],[0.87248,-0.19675,-0.44729],[0.53699,-0.38053,0.75289],[-0.87737,-0.35782,-0.31967],[-0.81723,0.14645,-0.55739],[-0.60416,-0.084631,-0.79236],[-0.93108,-0.20039,-0.30485],[0.94426,0.28975,-0.15628],[-0.39031,0.11879,-0.91299],[0.84351,0.4074,0.35002],[0.86978,-0.36986,-0.32662],[0.80505,0.50077,0.31802],[0.40707,-0.84811,-0.33911],[0.99057,-0.12232,0.061753],[-0.25437,0.17293,-0.95152],[-0.29914,0.1662,-0.93962],[0.91987,-0.13765,-0.36728],[-0.80668,0.49935,0.31609],[0.75448,0.64062,-0.14271],[-0.4876,0.14893,-0.86027],[-0.0031421,0.84491,0.5349],[-0.487,-0.27719,0.82825],[0.36323,0.69684,-0.61845],[-0.89303,0.32306,0.31326],[-0.3677,0.83845,-0.40224],[0.68744,0.63078,0.35992],[0.5019,0.68501,0.52807],[-0.42717,-0.083205,-0.90033],[0.35234,0.27423,-0.8948],[0.58439,0.62437,0.51831],[0.52489,0.097866,0.84553],[0.71896,-0.38367,-0.57957],[-0.76957,0.52843,0.3585],[0.74036,0.65601,0.14667],[-0.69136,-0.26688,-0.67142],[0.89317,0.44054,0.090425],[0.13572,0.22466,-0.96494],[-0.081943,0.25427,-0.96366],[0.39423,0.42111,-0.81685],[-0.89381,0.0075358,0.44839],[-0.86768,0.27187,0.41619],[-0.90177,-0.29732,-0.31372],[-0.025488,0.99967,0.0011123],[0.87576,0.40541,0.26206],[0.22599,0.31369,-0.92224],[0.069321,0.20884,-0.97549],[0.0035684,0.56152,-0.82746],[-0.23695,0.97024,-0.049862],[0.089309,0.75354,-0.65131],[0.2572,0.75811,-0.59926],[0.61081,-0.45226,-0.64991],[0.63517,0.090678,0.76703],[0.90597,0.41904,0.060296],[-0.35895,-0.22105,-0.9068],[0.14939,0.56051,-0.81456],[0.062508,0.77367,-0.6305],[0.025688,0.81166,-0.58356],[-0.50681,0.67837,0.53194],[-0.73357,0.15791,0.66102],[0.91466,0.028272,0.40324],[0.69399,0.64435,0.32124],[0.98443,-0.040185,0.17111],[-0.24605,-0.32578,-0.91287],[0.29157,0.61673,-0.73118],[-0.22999,-0.22089,0.94779],[0.3943,0.91814,-0.039444],[-0.22306,0.85617,0.46606],[0.59564,0.73684,0.31982],[-0.97854,0.10258,-0.17871],[0.38697,0.11539,0.91485],[-0.5499,-0.12395,0.82598],[-0.51931,0.40312,0.75353],[-0.3857,0.29245,0.87505],[0.97091,-0.23848,-0.021636],[0.82139,0.48339,-0.30273],[-0.96122,-0.15317,-0.22932],[0.95319,-0.0011668,0.30237],[0.49697,0.76339,0.41262],[0.47006,0.87532,0.11341],[0.86838,-0.26969,0.41616],[-0.77631,-0.63032,0.0066746],[-0.2693,-0.59577,-0.75666],[-0.17262,-0.46399,-0.86886],[0.09662,-0.36696,-0.92521],[0.037294,-0.3112,-0.94961],[-0.55768,0.10688,0.82315],[-0.78322,0.55618,0.2779],[-0.090748,-0.26142,-0.96095],[-0.86016,-0.14794,-0.4881],[-0.15645,-0.40017,-0.90299],[0.83222,-0.13528,0.53769],[0.4051,0.59548,0.69376],[0.74314,0.60519,0.28546],[0.026354,-0.33896,-0.94043],[0.59227,0.54124,0.59689],[-0.54743,0.38286,0.74414],[0.5041,-0.43458,-0.74634],[-0.35083,0.72007,0.59867],[-0.48179,0.19685,0.85389],[0.3381,0.57649,0.74387],[-0.79,-0.14829,0.5949],[0.84761,0.48409,-0.2173],[-0.96606,-0.24554,0.080224],[-0.10427,0.75051,0.65258],[0.083946,0.74051,0.66678],[-0.54305,0.80439,0.24093],[-0.5356,0.84185,0.066578],[-0.68839,-0.02975,0.72473],[0.70684,0.6374,0.30677],[0.49955,-0.42994,-0.75207],[-0.59175,0.037716,0.80524],[-0.91167,0.0036744,-0.4109],[0.46487,-0.43294,-0.77231],[-0.72756,0.59949,0.33356],[0.9143,0.12573,0.38503],[-0.91051,0.40778,0.068505],[0.57386,0.6933,0.4359],[0.24943,0.96055,0.12296],[0.87349,-0.33289,0.35525],[-0.74109,-0.12651,0.65938],[0.88287,0.46834,0.034534],[0.42329,-0.47689,-0.77032],[-0.81631,0.57079,0.088541],[0.32071,-0.50259,-0.80284],[-0.76775,-0.073509,0.63652],[-0.73594,0.006299,0.67702],[-0.72113,0.68138,0.12527],[-0.48252,0.87457,0.048031],[0.16379,-0.4744,-0.86494],[-0.5707,-0.7869,-0.23471],[0.98832,-0.14454,0.048245],[-0.70205,0.69685,0.14672],[0.45643,-0.42725,0.78046],[0.14094,-0.443,-0.88537],[-0.48102,0.018295,0.87652],[0.48281,-0.60034,-0.63756],[-0.66665,0.13545,0.73296],[0.67562,0.58665,0.44652],[0.26915,-0.49957,-0.8234],[0.76508,-0.46289,-0.44764],[0.9949,0.095012,0.033944],[0.87675,-0.038169,0.47943],[-0.90732,0.38842,0.16096],[0.97426,-0.14317,-0.1741],[-0.61401,0.21327,0.75994],[0.67463,0.67963,0.28804],[-0.44221,0.60697,0.66033],[0.44838,-0.69475,0.56239],[-0.61628,0.7577,0.21466],[-0.5639,0.30544,0.76728],[0.54788,0.73528,0.39899],[0.70925,0.19874,0.67636],[-0.25717,0.96599,0.026995],[0.51642,0.72672,0.45297],[-0.5717,-0.13031,0.81005],[-0.47546,0.81894,0.32137],[-0.89893,0.26876,0.34598],[0.53607,0.27932,0.79663],[0.56725,0.28007,0.77446],[-0.64816,0.65921,0.38123],[0.986,-0.10662,-0.12821],[-0.42149,0.45195,0.78618],[-0.99134,0.12015,-0.053045],[-0.84521,-0.021485,0.53401],[0.28667,0.69407,0.66037],[-0.38251,0.80969,0.44507],[-0.81075,0.57967,0.081664],[0.90254,0.1643,0.39802],[0.6156,0.7502,0.24133],[0.16031,0.68479,0.71089],[0.19467,-0.9806,-0.023174],[-0.97657,-0.16948,-0.13263],[0.36892,0.43135,0.8233],[-0.9927,-0.11428,0.038667],[-0.1622,0.56169,0.81129],[-0.41116,-0.48492,-0.77188],[-0.69287,0.58555,-0.42079],[-0.25289,0.7807,0.57145],[0.76465,-0.11846,0.63347],[0.45928,0.51842,0.72132],[0.21357,0.54625,0.80993],[0.5695,0.7898,0.22778],[0.032764,0.64872,0.76032],[0.97643,-0.05727,0.20812],[-0.30276,-0.93336,-0.1928],[-0.44497,0.49679,0.74512],[-0.12238,-0.98259,-0.13975],[0.074648,-0.99402,-0.079702],[0.28783,-0.95763,-0.010471],[-0.22314,-0.95354,-0.20239],[0.39589,0.90809,-0.13659],[-0.16254,-0.91416,-0.37135],[-0.047631,0.99457,-0.092524],[0.14937,0.076136,0.98585],[0.23504,0.90744,0.34829],[0.38147,-0.9179,-0.10927],[0.31499,0.17668,0.93251],[-0.38233,0.031174,0.9235],[0.036081,0.53154,0.84626],[0.56397,-0.69295,-0.44918],[0.65731,-0.50352,-0.56072],[0.97389,0.1623,0.15874],[0.50027,-0.52432,-0.68907],[-0.81495,-0.57805,0.041498],[0.36575,-0.40165,-0.83959],[0.45472,-0.6962,-0.55546],[0.11635,0.69819,0.70639],[-0.0015188,-0.90904,0.41671],[0.02498,-0.75151,-0.65924],[0.61283,-0.60059,-0.51355],[-0.050288,-0.94735,0.31623],[-0.22658,-0.67821,-0.69907],[0.39163,-0.91991,-0.019749],[0.22149,0.95348,0.2045],[-0.51126,0.064238,0.85702],[-0.19538,0.9281,0.31696],[0.2642,-0.66883,-0.69488],[-0.70013,-0.69892,0.14608],[0.37755,0.13034,0.91677],[0.77655,-0.35786,-0.51856],[0.4064,0.09082,0.90917],[-0.42132,0.87596,0.23493],[-0.53502,-0.78622,0.30922],[-0.34673,-0.60961,-0.71285],[-0.11606,-0.7559,-0.64432],[-0.65253,0.63534,0.41297],[-0.12182,-0.72119,-0.68195],[-0.93899,0.33142,-0.091935],[-0.73214,-0.63539,0.24547],[0.50585,-0.85904,0.078479],[-0.66092,-0.46627,-0.58803],[-0.51122,-0.41572,-0.75222],[0.65768,0.48148,0.57933],[-0.64613,-0.74891,0.1471],[-0.94908,0.29961,-0.09735],[0.88436,0.056746,0.46334],[0.37559,-0.03768,0.92602],[-0.67896,-0.27692,-0.67995],[0.23193,0.19044,0.95391],[0.7512,-0.12308,-0.6485],[-0.773,-0.59817,0.21135],[0.61262,0.53852,0.57853],[0.84016,-0.542,-0.019254],[-0.85346,0.10714,-0.51003],[0.18693,-0.82705,-0.53014],[0.47901,-0.75067,-0.45502],[-0.70288,0.52939,0.47508],[0.081466,-0.0080452,0.99664],[-0.088146,0.28763,-0.95368],[-0.044022,0.36536,0.92982],[0.37066,0.25189,-0.89396],[-0.84035,0.5185,-0.15802],[0.57085,0.64645,0.50619],[0.29687,0.06338,-0.95281],[0.14932,0.1702,-0.97403],[-0.47179,-0.23973,0.84849],[0.84402,0.26837,0.46433],[-0.99007,0.13997,0.012937],[0.92789,0.3281,0.1771],[-0.65991,-0.75098,0.023445],[0.011921,0.29152,-0.95649],[-0.060493,0.99801,0.01754],[-0.79843,-0.46057,0.38779],[-0.77988,0.44085,0.44434],[0.33725,-0.26722,0.90269],[0.73824,-0.67454,-0.0011598],[-0.24298,0.96871,0.050535],[-0.13586,-0.21808,0.96643],[-0.25407,-0.44434,0.85908],[0.55059,-0.021214,-0.8345],[0.29766,0.13519,-0.94505],[0.60866,0.64846,0.45721],[-0.032935,0.19677,-0.9799],[0.17105,0.1909,-0.96659],[-0.13243,0.98868,0.070583],[-0.63332,0.76827,-0.093088],[0.86672,0.23485,0.44005],[-0.56321,-0.723,-0.40008],[-0.83816,-0.43142,0.33372],[-0.7839,0.065349,0.61744],[-0.83758,-0.51521,-0.18171],[0.45489,0.22502,0.86165],[0.53687,0.74119,0.403],[-0.43542,-0.32747,0.83855],[0.34655,0.01995,0.93782],[0.82052,-0.55139,-0.15069],[-0.96641,0.21144,-0.1461],[-0.70628,-0.56774,0.42289],[0.56527,-0.16932,-0.80734],[-0.86567,-0.47213,0.16646],[-0.20918,-0.96447,0.16136],[-0.99292,-0.0255,-0.11603],[-0.145,0.941,0.30577],[0.55399,-0.20546,-0.80677],[0.45017,-0.25745,0.85502],[0.89669,-0.43176,-0.097596],[0.57976,-0.60814,-0.54226],[0.97837,0.013628,0.20642],[-0.9815,0.15067,0.1181],[0.91083,-0.39612,-0.11614],[-0.89948,-0.06335,-0.43234],[-0.13652,0.70688,0.69403],[-0.58758,0.0021602,-0.80916],[-0.827,-0.25006,0.50353],[-0.93278,-0.35386,0.068629],[0.91399,-0.40276,-0.049044],[0.76977,-0.43275,-0.46923],[0.93997,0.076869,0.33249],[-0.58332,0.027853,-0.81176],[-0.54716,0.11125,-0.8296],[-0.74746,0.61586,-0.24904],[-0.38128,-0.91894,-0.10088],[-0.96313,0.21537,0.16121],[-0.78286,-0.51636,0.34713],[-0.7097,0.12352,-0.69359],[0.88345,-0.34338,-0.31877],[-0.74283,-0.53995,0.39579],[0.85231,-0.51114,0.11093],[0.6287,-0.065763,-0.77486],[-0.2374,0.89614,0.37494],[0.038631,-0.24622,-0.96844],[0.029463,-0.29256,-0.95579],[0.79966,0.19335,0.56847],[-0.99417,-0.095423,0.050122],[0.64503,-0.73818,0.19755],[0.93792,-0.19954,-0.2837],[0.46902,-0.18609,-0.86336],[0.54588,0.11644,0.82973],[-0.019693,-0.26576,-0.96384],[0.12606,-0.29466,-0.94725],[0.3495,-0.30273,-0.88668],[0.94688,0.31107,0.081565],[-0.96022,0.04037,0.2763],[-0.86409,0.016936,-0.50305],[0.76602,-0.049349,-0.64092],[0.47018,-0.80821,0.35459],[0.3898,-0.7842,0.48279],[0.70129,0.68853,0.18473],[0.30577,-0.86012,0.40829],[-0.89891,0.32955,0.28871],[0.30933,-0.44004,-0.84302],[0.98384,0.10164,0.14737],[-0.079078,-0.89192,0.44522],[-0.15063,-0.84365,0.51533],[0.05575,-0.85128,0.52174],[-0.48508,0.3476,0.80242],[0.76926,-0.62279,0.14277],[0.93406,-0.074533,-0.34925],[0.72699,-0.37189,0.57722],[0.56399,0.79254,0.23195],[0.69471,0.68903,0.20646],[0.96715,-0.2489,-0.051623],[0.79595,0.10504,-0.59618],[-0.74604,-0.65089,0.14057],[-0.67033,-0.69494,0.26023],[-0.84942,0.041549,-0.52608],[0.79142,0.34906,-0.50181],[-0.86942,0.36529,0.33268],[-0.047141,-0.99884,-0.0097477],[0.87238,-0.0046419,-0.48881],[0.25267,0.90006,0.35504],[-0.81843,0.085654,-0.56819],[0.63686,0.73333,0.23798],[-0.94521,-0.14018,-0.29483],[0.9931,-0.058302,-0.10175],[0.92323,0.055674,-0.3802],[-0.97414,0.2246,0.024673],[-0.91028,0.017902,0.41361],[0.76693,0.50887,-0.39099],[0.036725,0.89528,0.44398],[-0.9548,-0.10165,-0.27932],[0.94953,0.21939,-0.22418],[0.76573,0.63735,-0.086199],[0.8693,-0.16764,0.465],[0.24116,-0.92116,-0.30546],[-0.93978,-0.20346,-0.27462],[-0.89219,0.31924,0.3195],[-0.91248,0.40007,0.085605],[0.19104,0.89022,0.41353],[0.77965,0.62552,0.029531],[0.96677,0.02492,-0.25443],[-0.69028,0.051881,-0.72168],[0.65763,-0.057143,0.75117],[-0.4556,0.84101,0.29176],[0.86074,0.50241,-0.081931],[-0.92371,-0.068247,-0.37696],[0.34744,0.88803,0.30113],[0.78302,0.021811,0.62161],[0.56898,-0.49475,0.65687],[-0.23609,-0.86481,-0.44314],[0.78644,0.18523,0.58923],[-0.67795,0.73487,-0.018556],[-0.94746,0.24291,0.20811],[0.78993,0.61316,-0.0070189],[0.65264,0.71659,0.24608],[0.89651,0.20075,-0.39492],[0.62423,0.77787,-0.072442],[-0.90852,0.23054,-0.34848],[-0.68891,0.72474,0.012503],[-0.13688,-0.9578,-0.25276],[-0.26442,-0.54915,0.79279],[0.4844,0.86713,-0.11595],[-0.88186,0.22986,-0.41169],[0.88054,0.29137,-0.37382],[-0.73389,0.12442,-0.66777],[0.32279,0.94647,-0.0012836],[-0.98451,-0.14675,0.095984],[-0.73194,0.04181,-0.68008],[0.061473,-0.99723,0.041857],[0.90886,0.055341,0.41342],[0.15481,0.98067,0.11968],[-0.88353,0.2561,-0.39216],[0.47467,-0.78843,0.39123],[0.9536,0.17612,0.24419],[-0.59743,0.76689,-0.23443],[-0.27548,0.85691,-0.43567],[-0.23793,0.96354,-0.12241],[0.54688,0.78499,0.29105],[-0.84353,0.22354,-0.48836],[0.11434,0.92068,0.37319],[0.89641,-0.14724,0.41806],[-0.164,0.87623,0.45313],[0.31205,0.92412,0.22052],[0.088464,0.94883,0.30315],[-0.82867,0.036765,-0.55853],[0.95148,-0.12399,0.28162],[-0.26125,-0.96527,-0.00065343],[-0.15111,0.85946,0.48836],[-0.084389,0.84032,0.53548],[-0.13003,-0.97887,-0.1578],[0.15272,0.96482,0.21399],[-0.84204,0.064425,-0.53556],[0.77957,-0.39665,0.48471],[-0.88059,0.12642,-0.45671],[0.9573,-0.051445,0.28449],[-0.8688,0.13773,-0.47562],[-0.94697,0.019487,-0.32074],[0.92194,0.35227,0.16103],[-0.98108,-0.15402,0.11726],[-0.83651,0.47929,-0.26557],[0.86975,-0.33243,-0.36473],[-0.18715,-0.97165,-0.14447],[0.83188,0.51878,0.19707],[0.033195,-0.99066,-0.13227],[-0.99438,0.081961,-0.067049],[0.84254,0.27406,-0.4637],[0.81987,0.29529,0.49053],[-0.99225,0.078779,-0.096081],[0.61366,0.56112,-0.55548],[0.69796,-0.69336,-0.17919],[-0.97033,-0.097238,-0.22135],[0.36958,-0.92867,0.031339],[0.77627,0.44644,-0.44508],[0.85758,0.33117,0.39356],[-0.88877,-0.38636,-0.2466],[-0.98197,0.0030572,0.18902],[-0.62175,-0.44165,-0.64682],[0.87865,0.35329,0.3212],[-0.52596,-0.30176,-0.79518],[0.90732,0.26066,0.32989],[-0.95885,0.051264,0.27923],[-0.14005,-0.98207,-0.12621],[-0.18642,0.055051,-0.98093],[0.80304,0.11154,-0.58539],[-0.90509,0.21443,0.36719],[0.82168,0.47615,0.31326],[0.024636,-0.99931,0.027871],[0.76975,-0.21331,-0.60165],[0.23018,-0.9204,0.31605],[-0.2601,-0.11635,-0.95855],[0.44955,-0.65102,0.61162],[-0.19592,0.08387,-0.97703],[0.83751,-0.042487,0.54477],[0.19251,0.93331,0.3031],[-0.89135,0.10302,0.44145],[0.76802,0.62556,0.13716],[0.32103,-0.68509,0.6539],[-0.050059,-0.01892,-0.99857],[-0.26754,0.17846,0.94688],[-0.27862,0.036247,-0.95972],[0.25283,0.60178,-0.75759],[0.63962,-0.71373,0.28545],[-0.16284,0.69539,-0.69994],[-0.86246,0.045842,0.50404],[0.59261,-0.3333,-0.7333],[-0.61346,-0.54152,0.57482],[-0.95407,-0.2516,0.16263],[0.75638,0.64473,0.1105],[0.79353,0.091741,0.60158],[0.35937,0.36885,-0.85721],[0.44573,0.33864,-0.82864],[-0.27499,0.63817,0.71911],[-0.41771,0.68691,-0.59471],[0.14014,-0.95996,-0.24258],[-0.033451,-0.038944,-0.99868],[-0.68572,0.50517,0.52401],[-0.1903,-0.048421,-0.98053],[-0.11407,0.66109,0.74158],[0.23865,-0.95192,0.1921],[0.82779,-0.5593,-0.044111],[-0.091445,0.2949,0.95114],[-0.3327,-0.80843,0.48554],[-0.15453,-0.15138,-0.97632],[-0.20491,-0.94992,-0.23594],[-0.12091,-0.16097,-0.97953],[-0.18272,-0.95796,-0.22118],[-0.67311,0.55929,-0.48387],[0.52446,-0.38643,-0.75869],[-0.016426,-0.083842,-0.99634],[0.27005,0.79111,-0.54883],[0.87013,-0.49238,-0.021007],[-0.92669,-0.32676,0.18567],[0.30405,0.48075,-0.82246],[-0.82276,0.39706,-0.40671],[-0.58236,0.4772,0.65813],[-0.13277,-0.23166,-0.96369],[0.35124,-0.73587,0.5789],[-0.0041765,-0.12932,-0.99159],[0.22245,0.80806,-0.54548],[-0.93975,0.33081,0.086252],[0.047512,0.83617,-0.5464],[0.14597,0.82787,-0.5416],[0.8655,0.36514,0.34289],[-0.4905,0.21423,0.8447],[-0.14475,-0.98548,-0.088729],[0.64948,0.68108,0.33809],[-0.21987,-0.34596,-0.91212],[-0.32808,-0.80267,0.49808],[-0.23008,-0.92596,0.29943],[0.22612,0.77709,-0.58737],[0.17932,-0.98259,0.04862],[0.46785,-0.38745,-0.79436],[0.25527,-0.96686,-0.0041591],[0.33144,0.20167,0.92167],[-0.42781,-0.52881,-0.73303],[-0.5286,-0.59316,-0.60724],[-0.78408,-0.56318,-0.26086],[0.42753,0.70875,-0.56116],[0.23297,0.80558,-0.54476],[0.50519,0.033272,0.86237],[-0.92904,-0.3498,0.12055],[-0.36672,0.36098,0.85744],[-0.73641,0.20568,0.64451],[-0.84069,-0.52399,0.13669],[-0.64969,-0.64034,-0.40971],[0.63385,0.6177,-0.4655],[0.18453,0.82393,0.53581],[0.56395,-0.80897,-0.16593],[-0.87008,-0.48952,-0.057716],[0.62738,0.041046,0.77763],[0.14745,0.4928,0.85756],[0.17272,0.57159,0.80215],[0.91105,0.15405,0.38244],[0.76988,-0.10172,0.63002],[-0.13397,0.48928,0.86177],[-0.45365,-0.30505,0.83734],[-0.66594,-0.23628,0.70759],[-0.66666,-0.72205,-0.18497],[-0.73345,-0.056899,0.67736],[-0.52431,0.082822,0.84749],[0.98336,0.15623,0.09273],[0.049312,-0.97389,-0.22159],[-0.60582,0.011119,0.79552],[0.095763,-0.99516,0.02195],[0.90255,-0.20163,0.38047],[0.033386,-0.99867,0.039313],[0.074202,0.75425,0.65238],[-0.75867,0.60692,0.2368],[-0.89017,0.078073,0.44889],[0.13358,-0.39679,-0.90814],[0.36994,-0.44535,-0.81536],[0.97071,-0.058912,0.23292],[0.74649,-0.65653,0.10824],[0.9198,-0.23257,-0.31603],[-0.68466,-0.13537,0.71618],[0.68794,0.68119,0.25043],[0.91077,-0.36773,0.18779],[-0.64867,0.15645,0.74482],[0.056008,0.75236,0.65637],[0.84413,0.055306,0.53328],[-0.7744,0.067367,0.6291],[-0.15882,-0.97795,0.13564],[0.51549,-0.84535,0.14021],[0.59699,0.72041,0.35301],[0.86511,-0.47291,0.16713],[0.43157,-0.78439,-0.44551],[0.5422,-0.30737,0.78201],[-0.81053,-0.55577,-0.18482],[0.44472,0.27114,0.85364],[-0.53049,-0.53694,0.65596],[-0.85996,-0.23454,-0.45327],[0.76972,-0.52297,0.36611],[0.60628,0.34059,0.71863],[0.45418,-0.88072,0.13438],[-0.47263,0.3793,0.79545],[0.15228,0.78748,0.59723],[0.40548,0.7154,0.56902],[-0.3835,-0.59738,-0.70432],[0.30276,0.68837,0.65915],[0.15212,0.63696,0.75574],[-0.45782,-0.64319,0.61376],[-0.32985,0.7975,0.50516],[-0.67295,-0.18858,0.71525],[-0.92655,0.27884,0.25248],[-0.30499,0.47745,0.82403],[-0.14714,0.55033,0.82188],[-0.02429,0.60209,0.79806],[0.94132,0.18315,0.2835],[0.99472,-0.01316,0.10177],[0.68662,-0.037108,0.72607],[-0.73758,-0.65174,-0.17667],[-0.11116,0.70677,0.69865],[0.2221,0.54062,0.81142],[-0.75961,-0.53376,-0.37162],[-0.15471,-0.98754,0.028709],[0.072883,-0.99687,0.030645],[0.93244,0.28741,0.21896],[-0.35885,-0.91215,-0.19799],[-0.94032,-0.02593,-0.33931],[-0.14243,-0.9854,-0.093319],[-0.49726,-0.8676,-0.00076411],[0.35061,-0.91155,-0.21483],[-0.56652,-0.61154,0.55233],[0.30807,-0.89255,-0.32932],[0.49608,-0.74658,-0.44331],[-0.67519,-0.079391,0.73336],[-0.79427,0.11775,0.59605],[0.57624,0.048233,0.81585],[-0.53251,-0.83799,0.11918],[0.59394,-0.61111,-0.52325],[-0.96728,0.040691,-0.25041],[-0.44619,-0.89142,-0.079258],[-0.7922,-0.609,0.039256],[0.64313,-0.65646,-0.39426],[0.77877,0.12003,0.61572],[0.69401,0.022619,0.71961],[-0.038573,-0.77282,-0.63346],[0.167,-0.8111,-0.56056],[0.54256,0.019132,0.8398],[0.4179,-0.67572,-0.60726],[-0.83456,-0.54417,0.086019],[0.69348,-0.65498,-0.30014],[-0.30879,0.43011,0.84832],[0.9587,0.27996,0.050087],[-0.16764,-0.94367,0.28526],[-0.031034,-0.97965,0.19831],[0.30817,-0.92041,0.24057],[-0.056399,-0.60137,-0.79698],[-0.018636,-0.67734,-0.73544],[-0.9507,0.29058,0.10828],[-0.011013,-0.99961,0.025695],[0.84987,-0.40164,-0.34119],[-0.52165,0.18497,0.83287],[-0.40728,-0.84864,0.33753],[0.41946,-0.87277,0.24964],[-0.42082,-0.23381,-0.8765],[-0.25622,-0.44029,-0.86052],[0.58305,-0.61096,-0.53552],[0.035952,-0.99924,0.015345],[-0.59609,-0.71708,0.36121],[-0.9113,-0.14602,0.38498],[0.55498,-0.60168,-0.57443],[-0.86001,-0.37846,0.34229],[-0.77936,0.0085227,-0.62652],[-0.9514,0.11338,-0.28633],[0.2207,-0.8769,-0.42701],[0.38093,-0.87348,-0.30317],[-0.72538,-0.65387,0.2151],[0.88683,-0.27427,-0.3719],[-0.82581,0.45251,-0.33656],[0.6598,-0.57714,0.48122],[0.86118,0.0017668,-0.5083],[-0.87484,-0.042149,0.48257],[-0.73767,-0.25136,-0.62663],[0.7262,0.13417,0.67427],[0.53651,0.15357,-0.8298],[0.79313,-0.60894,-0.011817],[-0.76142,0.64025,-0.10161],[0.6542,-0.68282,-0.32525],[-0.65347,0.49486,0.57279],[-0.35776,-0.90073,-0.24636],[0.83756,-0.045361,0.54445],[0.78663,-0.011676,-0.61732],[0.54616,-0.73607,0.39988],[0.74382,-0.51337,-0.428],[-0.15265,0.68645,0.71098],[-0.3457,-0.86125,-0.37247],[0.1551,-0.08092,-0.98458],[0.53564,-0.23794,-0.81023],[-0.70969,0.38777,0.58819],[-0.83315,-0.45859,0.30912],[0.11641,0.18171,-0.97644],[0.86879,-0.010496,0.49507],[-0.8079,-0.4658,0.361],[-0.73906,0.57403,-0.35253],[0.57014,-0.75612,0.32128],[0.65381,-0.59774,-0.46393],[0.2554,-0.08619,-0.96299],[-0.068138,0.010404,-0.99762],[-0.071538,-0.0038151,-0.99743],[0.19307,-0.14536,-0.97036],[0.68214,-0.2312,-0.69371],[-0.77818,0.4156,-0.47086],[0.55705,-0.75837,-0.33849],[-0.91404,-0.39589,-0.088335],[0.19895,-0.075197,-0.97712],[0.46203,-0.10099,-0.88109],[-0.95454,-0.005185,-0.29805],[0.46789,-0.79413,-0.38785],[0.013912,0.82198,0.56935],[0.47821,-0.65052,-0.59004],[-0.040211,0.084981,-0.99557],[0.0029813,0.070048,-0.99754],[0.95108,-0.30146,0.067552],[0.67555,-0.67085,-0.30593],[0.40437,0.014298,-0.91448],[0.35482,0.070638,-0.93226],[0.76205,0.013597,-0.64738],[-0.85838,0.074254,0.50762],[-0.99662,-0.050446,0.064831],[0.04489,0.14748,-0.98805],[-0.89739,-0.42794,-0.10755],[-0.73653,-0.33613,-0.58698],[0.21624,0.47491,0.85305],[0.77775,-0.54972,-0.30482],[0.56301,0.20901,-0.79959],[-0.69892,-0.15861,-0.69739],[0.89055,-0.40347,-0.21008],[0.8693,0.083613,0.48716],[0.36456,0.038739,-0.93037],[-0.00074127,-0.043901,-0.99904],[-0.018965,0.044836,-0.99881],[-0.94669,0.21136,-0.24312],[-0.75367,0.012432,-0.65714],[0.87753,-0.24946,-0.40953],[-0.99726,0.073057,0.011498],[0.65918,-0.0037443,-0.75197],[0.88799,-0.067551,0.45488],[-0.86302,-0.50513,0.0067495],[-0.63688,0.041343,0.76986],[-0.79986,-0.29068,0.5251],[-0.96019,-0.11469,-0.25474],[0.43542,-0.25327,-0.86386],[-0.096975,0.33426,0.93748],[-0.78865,-0.61484,-0.00014687],[0.51919,-0.67317,0.52658],[-0.41366,-0.2841,-0.86497],[-0.6332,0.29166,-0.71694],[-0.81495,0.069384,-0.57536],[0.72029,-0.27119,-0.63846],[-0.8558,-0.51624,-0.033359],[0.93064,-0.050496,-0.36242],[-0.68483,-0.69611,0.21549],[-0.82057,-0.52779,-0.21934],[-0.047862,0.28244,0.95809],[0.85541,0.50964,0.092384],[0.67958,-0.66321,0.31356],[0.093181,-0.33528,-0.9375],[0.90214,-0.015283,0.43118],[0.90698,0.21911,-0.35968],[-0.28476,-0.85791,0.42767],[-0.21582,-0.8281,0.51736],[-0.37175,-0.29496,-0.88023],[-0.40856,-0.85466,0.32036],[0.073024,-0.79627,0.60051],[0.058792,-0.82623,0.56026],[-0.90626,-0.029485,0.42169],[0.59569,-0.79968,0.075241],[-0.09101,-0.93483,0.34323],[0.67893,-0.68104,0.27431],[-0.69787,-0.0479,0.71462],[-0.79701,0.065762,-0.60037],[-0.83998,-0.53688,-0.078651],[0.99399,-0.10947,0.0026607],[0.69354,-0.71339,-0.10038],[0.929,0.14316,0.34128],[0.89754,-0.088929,-0.43186],[-0.81584,-0.51631,-0.26045],[-0.98204,0.1883,0.012176],[-0.76777,-0.39819,0.50197],[0.59768,-0.30157,0.74285],[0.93022,0.16026,-0.33017],[0.82921,0.44335,-0.34037],[-0.029349,0.3595,0.93268],[-0.45172,-0.79193,-0.41084],[0.67744,0.702,-0.21972],[-0.77044,-0.050182,-0.63554],[-0.43773,-0.36169,0.82314],[0.94926,0.19353,0.2479],[0.79075,-0.24885,-0.55927],[0.70523,0.67437,0.21883],[-0.80075,0.5797,0.15081],[0.55171,0.81938,0.15566],[-0.75985,-0.018037,-0.64984],[-0.51296,0.19564,0.83582],[0.33657,-0.48757,-0.8056],[-0.91344,0.34184,-0.22085],[0.7776,-0.51433,-0.36167],[0.091696,0.41043,0.90727],[-0.69711,0.69948,0.15737],[0.9818,0.11636,-0.15008],[-0.79445,-0.48366,0.36731],[0.56419,-0.3329,0.75556],[-0.52729,0.3266,0.78441],[-0.85327,0.26147,-0.45119],[-0.72471,0.078846,-0.68453],[0.88767,0.068979,0.45529],[-0.1956,-0.071343,0.97809],[0.70235,0.58414,0.4068],[-0.93906,-0.20428,0.27647],[-0.42941,0.50536,0.74848],[-0.43256,0.013708,-0.9015],[0.9071,0.16863,0.38567],[0.83279,-0.54654,-0.088098],[0.48141,0.85722,0.18281],[0.48397,-0.4185,-0.76852],[0.045982,0.32334,0.94516],[0.87703,0.35092,-0.32813],[-0.92345,0.30995,0.22622],[-0.2294,0.84412,-0.48459],[0.12409,0.87322,-0.47125],[0.87229,0.060962,0.48517],[-0.95287,-0.0065915,0.30331],[0.34452,-0.0040791,0.93877],[0.018757,0.27883,0.96016],[-0.79513,0.10059,-0.59804],[-0.10042,0.067331,0.99266],[-0.10483,0.9875,-0.11767],[-0.058694,0.97416,0.2181],[0.74921,-0.59839,-0.28391],[-0.31764,0.81864,0.47847],[0.34284,0.20376,0.91703],[-0.85875,0.1724,-0.48253],[0.79492,0.43214,-0.42586],[-0.31413,0.84822,0.42644],[-0.83129,-0.54395,-0.11435],[-0.12423,0.62414,0.77138],[-0.46891,0.43424,0.76913],[-0.94495,0.12788,0.30121],[0.33435,0.85249,0.40184],[0.57562,-0.46833,0.67032],[-0.11727,0.27135,0.95531],[-0.193,0.93389,0.30099],[-0.053851,0.98613,0.15703],[0.16236,0.98146,0.10192],[0.2459,0.95402,0.1714],[-0.036432,0.96274,0.26798],[0.08139,0.92307,0.37592],[0.6865,0.5542,0.47072],[0.95083,0.17857,0.25304],[0.81507,0.25214,-0.52162],[-0.88088,0.10373,-0.46184],[0.81273,-0.09801,-0.57434],[0.097138,-0.73104,-0.67538],[0.35552,0.36357,-0.86106],[-0.89712,0.32011,-0.30449],[0.79231,-0.36429,-0.48943],[-0.97686,0.13635,-0.16478],[-0.13493,-0.18087,-0.97421],[0.97096,-0.042351,-0.23545],[-0.20888,0.17889,-0.96144],[0.74062,0.59839,0.30563],[0.97356,-0.15763,-0.16535],[-0.87128,0.16514,0.46217],[-0.82091,0.52134,-0.23306],[0.90007,0.2391,0.36428],[0.53473,-0.4563,0.71123],[-0.66875,0.042014,0.7423],[0.94386,-0.18907,-0.27088],[-0.98579,0.16219,0.043681],[-0.88846,0.40805,-0.21007],[0.9392,0.28231,0.19547],[-0.20601,-0.96649,-0.15313],[-0.82779,-0.094281,0.55306],[-0.46014,0.34542,0.8179],[0.71324,-0.44693,-0.53994],[0.81293,-0.15756,-0.56065],[0.5747,0.41159,-0.70733],[-0.97421,0.14382,0.17388],[-0.7152,-0.69883,-0.011312],[-0.77978,-0.62378,0.053363],[-0.65555,-0.31904,0.68445],[-0.66404,-0.73417,0.14162],[-0.94532,0.13189,0.29829],[-0.95317,0.2447,-0.17774],[-0.58911,-0.02008,0.8078],[-0.33407,0.45677,0.82448],[0.8288,0.39724,0.39408],[0.58278,-0.029605,-0.81209],[0.33871,0.22169,0.9144],[-0.67767,-0.7017,-0.21997],[-0.40263,-0.39971,-0.82348],[-0.50701,-0.72207,-0.4707],[-0.1677,-0.17562,-0.97007],[-0.97977,-0.012347,-0.19975],[0.55198,-0.20338,-0.80867],[-0.44248,-0.64246,-0.62566],[-0.58504,-0.72887,-0.35563],[-0.93226,0.24105,0.2698],[-0.27156,-0.27335,-0.92279],[-0.62089,-0.32695,0.71246],[0.45022,-0.32132,-0.8331],[0.74024,0.53661,-0.40508],[0.9602,0.027744,0.27794],[-0.78234,-0.47904,-0.39808],[0.90159,-0.39982,0.16517],[0.33265,0.23024,-0.91451],[0.13507,0.39218,-0.90992],[-0.15606,0.58924,-0.79274],[-0.8582,0.17172,0.48375],[-0.87943,0.16579,0.44623],[-0.51236,-0.47726,-0.71394],[0.7223,-0.1545,-0.6741],[0.37595,0.2907,-0.87986],[0.33525,0.40869,-0.84887],[0.99677,0.076441,-0.02475],[0.93384,-0.08647,0.34709],[-0.4534,-0.45524,-0.76628],[0.64029,-0.0058888,0.76811],[0.38732,-0.30021,-0.8717],[0.72763,0.60876,0.31618],[-0.91858,-0.33086,0.21619],[0.84654,0.014929,0.53212],[0.91996,-0.20614,0.33343],[0.24745,0.78346,-0.57006],[-0.2937,0.35349,0.88813],[-0.56081,0.66341,-0.49536],[-0.7788,0.52103,-0.34929],[-0.61089,0.42512,0.6679],[-0.77658,-0.58144,0.24257],[-0.71761,-0.40431,-0.56707],[0.25486,0.85357,-0.45439],[0.70148,-0.21529,-0.67939],[-0.47603,0.57777,0.66301],[0.89287,-0.10473,0.43796],[0.74169,-0.018562,0.67048],[0.66563,0.58928,0.45791],[-0.87056,-0.46173,0.17012],[-0.98142,-0.097641,-0.16518],[0.022933,0.90744,-0.41955],[0.84348,-0.14988,0.51583],[-0.93339,0.30947,-0.18168],[0.85806,0.313,0.40713],[-0.39967,0.37685,0.83561],[-0.98506,0.17171,-0.013151],[0.43996,-0.35498,-0.82488],[-0.22772,0.59677,0.76942],[0.6321,0.6506,0.42092],[-0.14998,-0.98122,-0.12133],[-0.63813,-0.063638,0.76729],[0.37281,0.79079,-0.48546],[0.69304,-0.51063,-0.50887],[-0.82255,-0.50338,-0.26461],[-0.056221,0.41231,0.90931],[-0.17467,0.70588,0.68646],[0.013174,-0.99971,0.020183],[-0.06576,0.83485,0.54653],[0.09349,0.88246,0.46101],[0.47781,0.82214,0.30948],[0.55465,0.73426,-0.39145],[-0.16846,0.36629,0.91513],[-0.92691,0.35899,0.10939],[-0.64394,-0.024626,0.76468],[-0.66103,0.0060689,0.75034],[0.7386,0.59813,-0.311],[-0.97978,0.19763,0.031088],[0.44915,-0.36207,-0.81681],[0.28055,0.62635,0.72731],[0.86322,-0.063251,0.50085],[-0.91816,-0.35094,-0.18394],[0.39092,-0.38426,-0.83638],[-0.89318,-0.22154,0.39134],[0.85533,0.50908,-0.096125],[-0.78894,-0.59516,0.15282],[-0.71642,-0.16608,0.67761],[0.56044,-0.059042,0.82609],[-0.93778,0.33262,0.099697],[0.83206,0.011387,-0.55458],[0.32903,-0.40611,-0.85254],[0.88772,0.030224,0.45939],[-0.86349,0.47207,0.17757],[0.85099,-0.5181,0.085932],[-0.19727,0.3704,0.90768],[0.93817,0.34608,0.0079975],[-0.72819,-0.12328,0.6742],[0.53439,-0.77094,-0.34653],[-0.81233,0.53722,0.22695],[0.22562,-0.39145,-0.89211],[-0.87359,0.049374,0.48415],[0.13205,-0.32716,-0.9357],[0.11796,-0.41052,-0.90419],[0.41739,-0.44509,-0.79226],[0.73165,-0.10214,0.67399],[-0.31104,0.92638,0.2123],[0.18231,-0.97677,0.11261],[-0.74006,-0.6641,-0.10618],[0.84977,-0.090748,0.51929],[0.2315,-0.072968,0.97009],[0.54776,-0.51904,-0.65617],[-0.35009,0.31671,-0.88155],[-0.70682,0.66323,-0.24604],[0.87206,-0.19312,0.44969],[0.86871,-0.49528,0.005819],[-0.52236,0.058688,0.8507],[0.77974,-0.1793,0.59988],[-0.72214,0.61106,-0.32422],[0.86729,-0.17175,0.46724],[0.40148,-0.84247,0.35925],[0.76184,0.094357,0.64086],[0.76255,0.1599,-0.62685],[-0.49366,-0.27803,0.82401],[0.62104,0.13799,0.77154],[-0.60815,0.13778,0.78177],[0.59416,0.68316,0.42457],[-0.99045,-0.1336,-0.03391],[0.97367,-0.22791,0.0040528],[0.50576,0.25849,0.82304],[0.54438,-0.81411,-0.20219],[0.51837,0.27437,0.80994],[-0.8255,0.20195,0.52703],[-0.8647,0.20894,0.45676],[0.52525,0.28962,0.80015],[-0.47302,0.3393,0.8131],[0.30228,-0.19371,0.93333],[-0.80364,0.11546,0.58381],[-0.48435,0.77144,0.41266],[0.16077,0.014891,0.98688],[-0.35908,0.78996,0.49702],[0.63789,-0.75378,-0.15782],[0.34062,0.46055,0.81967],[-0.64345,-0.4402,0.62626],[-0.39805,0.33612,0.85357],[-0.20493,0.74085,0.63964],[0.78068,0.55558,0.28614],[0.64005,-0.20399,0.74076],[-0.043455,0.66976,0.74131],[0.93576,-0.34872,0.052391],[0.097526,0.58146,0.80771],[0.69381,-0.071873,0.71656],[0.32673,-0.0065931,0.94509],[-0.62899,0.46192,0.6253],[-0.017811,-0.9872,-0.15846],[0.20341,0.13902,0.96917],[0.20616,-0.978,-0.031875],[-0.37469,-0.89608,-0.23803],[-0.28104,-0.91823,-0.27905],[-0.8554,0.38843,0.34265],[0.253,-0.8858,-0.38904],[0.29006,-0.88355,-0.36771],[0.062999,0.31261,0.94779],[-0.21501,0.39874,0.8915],[0.57051,-0.79249,-0.2156],[0.9061,-0.42098,0.041934],[-0.39341,-0.91936,-0.0018663],[0.70659,-0.68766,-0.16693],[-0.8413,0.49,0.22828],[-0.63741,-0.76546,0.088243],[-0.41606,-0.90671,0.069088],[0.33876,0.05052,0.93952],[-0.5993,-0.15593,0.78519],[-0.090336,-0.60748,-0.78918],[0.78236,0.61356,-0.10698],[0.76967,0.43251,-0.46962],[-0.37766,0.28654,0.88049],[0.34901,-0.89065,0.29143],[-0.35686,-0.59079,-0.72362],[-0.15898,-0.52999,-0.83297],[-0.033464,-0.72693,-0.6859],[-0.17563,-0.56644,-0.80517],[-0.26933,0.7004,-0.66099],[0.41382,-0.80011,-0.43426],[-0.57093,-0.82091,0.011901],[0.71038,0.68185,0.17445],[0.0066544,-0.97401,0.22642],[-0.49689,-0.22961,0.83689],[-0.33846,-0.41622,-0.84392],[0.26848,-0.43593,-0.859],[0.67422,-0.73233,-0.09545],[0.29886,-0.2277,0.92673],[-0.1436,-0.98922,-0.028535],[-0.32022,-0.92029,0.22476],[-0.58506,-0.8045,0.10241],[-0.54818,-0.19505,-0.8133],[0.72944,-0.10639,0.67572],[-0.97537,-0.15735,0.15458],[-0.72338,-0.68882,-0.047355],[0.5586,-0.71987,0.412],[-0.59099,-0.73441,0.33373],[-0.52859,0.25284,-0.81035],[-0.52035,0.087481,-0.84946],[-0.11586,0.085125,0.98961],[0.29565,-0.63075,-0.71745],[0.40769,-0.62416,-0.66649],[-0.75465,-0.65397,0.053065],[-0.92167,0.36141,-0.14112],[-0.67242,-0.72492,0.14949],[0.49408,-0.72687,-0.47701],[-0.72474,-0.6647,0.18147],[0.75915,0.49195,-0.42624],[-0.72406,-0.65456,0.21747],[0.68493,-0.60201,0.41043],[-0.50094,0.55599,-0.66328],[0.52996,-0.81561,-0.23221],[-0.97717,-0.19238,0.09018],[0.955,-0.19948,-0.2195],[-0.72834,-0.63309,0.26213],[-0.7042,0.70046,-0.11598],[-0.28495,0.53271,-0.79688],[-0.61084,-0.78221,0.12254],[0.86449,-0.16147,-0.47601],[-0.70105,-0.62777,0.33828],[0.78448,0.27985,0.55343],[-0.85972,-0.50489,0.077258],[-0.13817,-0.95705,-0.25487],[-0.38887,-0.91871,-0.068949],[0.71974,-0.60583,0.33904],[-0.70304,0.70096,-0.11999],[0.75379,0.06609,0.65378],[0.71253,-0.50896,-0.48297],[-0.63022,-0.76706,-0.12017],[0.79604,-0.35419,-0.49078],[0.73064,-0.63608,0.24814],[-0.83626,0.034409,0.54726],[0.74632,-0.14162,0.65035],[-0.84818,-0.52955,0.013293],[-0.81674,-0.57175,0.077654],[-0.78419,0.45826,-0.41838],[-0.84514,0.19683,0.49699],[0.367,-0.24641,0.89699],[0.96354,-0.26656,0.023055],[-0.16938,0.79942,-0.57639],[0.80356,-0.44318,0.39734],[-0.78026,0.088857,0.61911],[0.53347,0.83969,-0.10168],[-0.90603,-0.40803,0.11231],[0.85869,-0.25129,-0.44667],[0.12577,-0.9869,-0.10102],[-0.74657,-0.65081,-0.13813],[0.75314,-0.094922,0.65097],[0.80344,-0.42976,0.41206],[0.93914,0.26651,0.21678],[0.60614,-0.68525,-0.40377],[0.58845,-0.77547,-0.22886],[-0.60754,0.5965,0.52449],[0.90248,-0.11521,-0.41503],[-0.84238,-0.51109,-0.17083],[0.89222,-0.35019,0.28516],[0.64367,0.045667,0.76394],[-0.74157,-0.32014,-0.58956],[-0.66798,-0.37012,-0.64561],[-0.92997,-0.25188,0.26779],[0.93117,0.17016,-0.32244],[-0.87627,-0.47221,0.095775],[0.90538,-0.36581,0.21558],[-0.93392,-0.066605,0.35121],[0.79525,0.22486,-0.56304],[-0.15641,0.95394,0.25601],[-0.84112,-0.38479,-0.38008],[-0.78404,0.26268,0.56239],[-0.98756,0.076051,0.13765],[0.61853,0.26908,-0.73825],[-0.87539,-0.36193,-0.32048],[0.85999,-0.42386,0.28417],[-0.85719,0.14881,-0.49303],[0.36868,0.13197,-0.92014],[0.68283,0.040443,-0.72946],[0.90404,-0.38207,0.19168],[-0.72715,0.22526,-0.64847],[-0.78088,-0.57473,-0.24477],[0.89472,-0.33533,-0.29499],[0.7511,-0.1423,-0.64467],[-0.77867,-0.58773,-0.21964],[0.68674,-0.67736,0.26376],[0.75868,0.08937,-0.64531],[-0.85909,0.073345,0.50654],[0.91166,-0.039364,-0.40905],[0.65054,-0.69788,0.29961],[-0.52493,-0.13786,0.83991],[-0.74586,0.10738,-0.65739],[0.96572,-0.0073399,-0.25947],[0.87414,-0.18411,-0.44942],[0.98606,0.084912,-0.14308],[-0.8177,-0.54349,-0.18971],[-0.96809,0.051773,0.24521],[0.87835,0.19298,-0.43732],[0.12863,-0.82245,0.5541],[-0.90626,0.39869,0.14046],[0.89638,-0.070705,-0.43761],[0.35595,-0.19728,0.91344],[-0.978,0.19993,0.059494],[0.94839,0.28235,-0.14432],[0.62974,-0.043916,0.77556],[-0.67695,0.44,0.59003],[-0.029209,-0.91164,0.40995],[-0.10378,-0.92763,0.3588],[-0.46207,-0.86016,0.21593],[0.24811,-0.80086,0.54504],[-0.82469,0.55248,0.12102],[-0.71713,0.033865,-0.69612],[-0.30251,-0.11843,0.94576],[0.88126,-0.11212,-0.45914],[-0.45977,-0.85558,0.23791],[-0.34454,-0.83402,0.43093],[0.95499,-0.28369,0.086748],[0.58579,0.38408,0.71368],[0.94996,-0.27436,0.14932],[-0.55956,-0.82448,0.084392],[0.99443,-0.095213,-0.045238],[-0.66027,0.0079787,0.75098],[-0.20817,0.36135,0.90889],[-0.8765,-0.45991,-0.14223],[0.99641,-0.062939,-0.056606],[0.81676,0.55033,0.17334],[-0.94208,-0.20281,-0.26713],[0.27153,0.89934,-0.34273],[0.87045,0.46927,-0.14866],[-0.94652,0.29212,0.13698],[0.57737,0.81535,-0.042863],[0.7494,0.63848,-0.17535],[-0.83064,0.48705,0.26985],[-0.92496,0.37994,-0.010019],[0.76485,0.63929,-0.079462],[-0.88819,-0.17425,-0.42516],[-0.76243,-0.15872,-0.62731],[0.94517,0.32605,-0.018624],[0.9309,0.098286,0.35179],[0.78473,0.61903,0.031544],[-0.88222,-0.071192,-0.46542],[-0.74124,0.133,-0.65793],[0.90583,0.42275,-0.02729],[0.43121,-0.0293,0.90178],[0.9716,0.23658,0.0054284],[-0.081519,-0.99284,-0.087306],[-0.69541,0.67176,0.25523],[0.89924,0.020312,0.43699],[-0.75973,0.63166,0.15432],[0.69338,0.70217,0.16182],[0.93592,0.28425,-0.20798],[-0.81309,0.12571,-0.5684],[0.49122,0.86102,0.13172],[0.26556,-0.29222,-0.91874],[-0.8157,0.13684,-0.56206],[0.89163,0.40204,-0.20823],[-0.73434,0.6761,0.060202],[0.42483,0.084716,0.9013],[-0.85819,0.51333,-0.0023565],[0.55604,0.76991,0.31313],[0.061974,0.99408,0.089289],[0.21767,0.96856,0.12043],[0.84253,0.15233,0.51666],[-0.55168,0.83301,-0.041716],[0.6003,-0.071637,0.79656],[0.5512,0.06455,0.83187],[-0.15834,0.91555,0.36973],[0.14645,0.94827,-0.28168],[0.27554,0.95103,-0.14007],[0.62223,0.64663,0.44125],[0.43076,0.82747,0.3602],[0.72675,-0.1709,0.6653],[-0.15507,0.92234,0.35389],[-0.23408,0.92646,0.29477],[-0.53202,-0.047612,0.84539],[-0.85868,0.16084,-0.48662],[-0.74529,0.22206,0.62868],[0.83329,-0.22405,0.50539],[-0.22569,0.93383,0.27752],[0.8844,0.19055,-0.42606],[0.84308,-0.17402,-0.50886],[-0.83483,0.26022,-0.48512],[0.63908,0.52726,0.55997],[0.89966,-0.12382,-0.41865],[-0.90769,0.29266,-0.30074],[0.81103,0.37288,0.45076],[-0.98522,0.16832,-0.031815],[0.7408,0.49149,0.45788],[0.41864,0.087327,0.90394],[0.91172,0.2553,0.32185],[0.70228,0.17092,-0.69108],[0.87335,-0.17389,-0.45501],[-0.92339,0.32132,-0.21],[0.88677,0.34672,0.30565],[-0.9973,0.044588,-0.058314],[0.45016,0.13892,-0.88207],[-0.94725,0.26253,0.18383],[-0.92725,-0.35893,0.10671],[0.57229,0.81602,-0.081252],[0.93668,-0.11208,0.33176],[-0.76691,-0.52478,0.3694],[0.46747,0.18831,-0.86372],[-0.5303,-0.62097,0.57722],[0.28271,0.050093,-0.9579],[-0.59496,-0.61742,0.51459],[-0.79695,-5.0464e-05,0.60404],[0.91715,0.39649,-0.0403],[0.41408,0.11841,0.9025],[-0.50709,-0.67161,0.54018],[0.81665,0.5759,-0.037819],[0.34223,-0.15461,-0.92681],[-0.75059,0.57963,-0.31724],[-0.89841,0.27496,0.34242],[-0.20193,-0.91598,0.3467],[0.85944,0.4469,0.24827],[-0.83006,0.33345,0.447],[-0.50132,-0.85811,-0.111],[0.30238,-0.21514,-0.92859],[0.71387,-0.023702,-0.69988],[0.75085,0.64261,0.15259],[-0.84303,-0.51773,0.14577],[-0.80297,0.10599,0.58652],[0.7908,0.60334,-0.10309],[-0.70764,0.57846,-0.40574],[0.89859,-0.19771,0.39172],[0.73567,-0.36617,0.56983],[0.32385,-0.21694,-0.9209],[0.62771,0.77837,0.010854],[-0.61787,-0.42705,0.6602],[0.23046,0.57262,-0.78676],[-0.062069,0.74506,-0.6641],[-0.55304,0.74786,-0.36721],[0.29654,0.73535,-0.60937],[-0.63709,0.040095,0.76974],[-0.31202,0.72847,-0.6099],[0.31678,0.11865,0.94105],[0.64063,0.074013,0.76427],[-0.44476,0.83908,-0.31326],[0.57514,0.13547,0.80676],[0.4349,0.13961,0.88959],[0.97804,0.059519,0.19976],[-0.86587,-0.3448,0.36247],[0.21871,0.87842,-0.4249],[0.20797,0.87124,-0.44462],[-0.68652,0.20046,0.69893],[-0.61064,0.045799,0.79058],[0.37831,-0.26181,-0.88788],[0.96984,0.11364,0.21561],[0.080759,0.91721,-0.39013],[-0.075376,-0.086578,0.99339],[-0.38215,0.62314,0.68239],[-0.59406,-0.14812,0.79067],[-0.64685,-0.1385,0.74993],[0.221,-0.93533,0.27625],[0.26858,0.86211,-0.42968],[0.56073,0.11109,0.82051],[0.2783,0.88312,-0.37768],[-0.97248,0.22888,-0.043555],[0.3798,-0.30673,-0.87274],[0.65613,0.75074,0.076703],[0.74581,0.65706,0.10975],[0.343,0.73496,0.58497],[-0.035301,0.31243,0.94929],[-0.25117,0.91315,-0.32104],[-0.39689,0.85134,-0.34306],[-0.55341,-0.0019508,0.8329],[0.93254,-0.1368,0.33414],[0.4559,0.11905,0.88203],[-0.60062,-0.10139,0.79308],[-0.50033,-0.15036,0.85268],[-0.58262,0.049164,0.81126],[-0.87734,0.46194,-0.12997],[-0.56736,0.7671,-0.29943],[-0.86102,-0.50727,0.036466],[-0.74404,-0.1082,0.65932],[0.45747,0.86876,0.18965],[0.54774,0.82836,0.11745],[-0.05971,0.16977,0.98367],[0.21418,-0.31306,-0.92527],[0.45752,0.10905,0.88249],[0.4155,0.058138,0.90773],[0.68216,-0.013518,0.73107],[0.15565,-0.33673,-0.92865],[-0.68622,0.23675,0.68779],[-0.63566,0.39115,0.66554],[0.16532,-0.33848,-0.92634],[-0.78014,0.58092,-0.23222],[0.64342,0.11043,0.7575],[-0.58823,0.62765,-0.50995],[-0.73917,-0.17456,0.65051],[-0.95442,0.22762,0.19307],[0.22445,-0.9686,0.10699],[0.41799,-0.48133,-0.77046],[0.15978,-0.36168,-0.91851],[-0.94262,-0.023019,0.33307],[-0.37184,-0.073489,0.92538],[0.82271,0.56817,0.018166],[0.95738,0.18326,0.22323],[0.64888,-0.52651,-0.54932],[0.84593,0.50673,0.1662],[0.86976,-0.39494,-0.29588],[-0.54793,-0.076195,0.83305],[0.66827,0.13371,-0.7318],[0.77698,0.050707,0.62748],[-0.63931,0.059625,0.76663],[0.73142,0.56253,0.38547],[-0.69462,0.67958,0.23594],[0.66752,0.047677,0.74307],[0.68216,0.63787,0.35747],[-0.66437,0.65413,-0.36156],[-0.77719,0.21072,0.59294],[0.51356,0.22489,0.82806],[0.088718,-0.97657,-0.19605],[-0.67804,0.69683,0.23385],[0.45643,0.70876,0.5379],[-0.57224,0.73001,0.37366],[-0.72594,-0.56025,0.39892],[0.86333,0.46312,-0.20045],[0.53713,0.23393,0.81041],[0.432,0.13808,0.89124],[-0.56119,0.20038,0.80307],[0.036184,0.93247,0.35943],[0.045542,-0.99888,0.012909],[0.41536,0.71189,0.56629],[0.82935,0.17047,0.53209],[0.57935,0.20753,0.78822],[0.22336,0.65077,0.72568],[0.0083822,-0.99984,0.015712],[-0.6713,0.58269,-0.45807],[0.5917,0.72571,-0.35103],[-0.28584,0.4917,0.82251],[-0.79252,0.20987,0.5726],[0.11543,0.59089,0.79845],[-0.96753,0.029826,0.25101],[-0.70378,0.70955,-0.035216],[-0.072322,0.55176,0.83086],[-0.65526,0.71058,-0.25635],[-0.25208,0.75708,0.60274],[-0.63353,0.35285,0.68858],[0.28756,0.48358,0.82672],[0.52105,0.14543,0.84104],[-0.45403,0.79381,-0.40463],[0.096731,0.59741,0.79608],[-0.19166,-0.97503,-0.1122],[0.010848,-0.99875,0.048745],[-0.12225,-0.99092,0.055955],[0.089612,-0.99415,-0.060321],[0.091342,-0.91734,-0.38748],[0.29045,-0.87061,-0.39709],[0.80633,0.38183,0.4517],[-0.54449,-0.82258,-0.16398],[0.43589,-0.83781,0.32874],[0.63146,0.49824,0.59415],[-0.90903,0.32548,0.26024],[0.2341,-0.93589,-0.26326],[0.37072,-0.92656,-0.063703],[-0.50312,-0.86275,0.050272],[-0.52114,0.68921,-0.50339],[0.74782,-0.63179,-0.20397],[0.80575,0.57343,0.14817],[-0.43188,-0.90011,0.05724],[0.70125,-0.7065,-0.095411],[-0.10207,-0.64484,-0.75747],[-0.19278,-0.56943,-0.79911],[0.019395,-0.67366,-0.73879],[0.13995,-0.67437,-0.72501],[0.34783,-0.38167,0.85636],[0.22087,-0.79071,-0.57096],[0.77674,0.62035,0.10877],[0.077778,0.55101,0.83087],[0.63733,-0.16952,0.75172],[-0.77914,-0.58504,0.22511],[0.71249,-0.69702,-0.080776],[0.91538,0.03948,0.40065],[-0.55263,-0.4853,-0.67756],[0.74591,0.66561,-0.024041],[0.83894,-0.52855,-0.12968],[-0.62855,0.11355,0.76944],[-0.29165,-0.61196,-0.73515],[0.5508,-0.7815,-0.29307],[-0.4459,-0.42016,-0.79034],[0.47073,-0.79253,-0.3877],[0.36402,-0.67346,-0.64339],[0.18571,-0.2,0.96203],[-0.77086,-0.63524,0.047349],[-0.37785,-0.9097,0.17225],[-0.13219,-0.99009,0.047346],[0.42615,-0.86571,0.26258],[0.34457,-0.61551,-0.70882],[0.9129,-0.37513,-0.16091],[0.53056,-0.78568,0.31814],[-0.97501,0.1274,-0.182],[0.92335,0.20142,-0.32689],[0.026576,-0.18694,0.98201],[-0.87195,0.22872,-0.43289],[0.90383,-0.18678,-0.38498],[-0.52496,0.5817,-0.62132],[0.62151,-0.67431,0.39878],[0.94087,-0.17116,-0.29235],[0.24384,-0.22129,0.94423],[-0.17565,-0.44157,-0.87987],[-0.44458,0.81803,-0.36492],[0.9059,-0.30193,-0.29695],[-0.75884,-0.64639,-0.079702],[-0.73504,-0.095608,0.67125],[-0.14572,-0.97593,-0.16227],[-0.13116,-0.97861,-0.15849],[0.4128,0.0718,0.90799],[-0.22915,-0.042324,0.97247],[0.71671,-0.62508,-0.3092],[0.37958,0.12986,0.916],[0.88196,-0.37603,-0.28416],[-0.47169,0.79361,-0.3843],[0.87277,0.011875,0.48798],[-0.85446,-0.47985,-0.19911],[0.92927,0.18971,0.31697],[0.59578,-0.58881,-0.54621],[0.93408,-0.2117,-0.28753],[-0.68933,-0.69617,-0.20042],[-0.63085,0.29193,-0.71889],[0.82678,0.52304,0.20705],[-0.8692,0.23301,0.43613],[0.4306,-0.78174,0.45107],[-0.61134,-0.0035376,-0.79136],[-0.69094,0.22148,-0.68814],[-0.89185,-0.26825,0.36422],[-0.80311,-0.48266,-0.34936],[0.93503,0.016696,-0.35416],[0.68544,-0.71135,-0.15543],[0.76843,0.63015,-0.11147],[0.88767,-0.42674,0.17303],[0.71177,-0.68857,-0.13874],[0.84757,-0.5252,-0.076092],[-0.18263,0.40394,0.89637],[-0.7631,-0.22574,-0.60558],[-0.81616,0.20051,0.54192],[0.86126,-0.43528,0.26225],[0.57029,0.58581,-0.57585],[-0.86063,-0.078653,-0.50312],[-0.5461,0.66794,-0.5056],[-0.84607,0.31887,0.42719],[-0.93525,-0.024501,0.35314],[-0.14094,0.86768,-0.47673],[0.88999,0.053432,-0.45283],[-0.67723,0.25596,0.68981],[0.93223,-0.1512,0.32877],[-0.86027,-0.28798,-0.42073],[0.91721,-0.28767,-0.27563],[0.81394,0.096782,-0.57283],[0.20652,-0.56281,-0.80037],[0.3834,0.12655,0.91487],[0.87097,-0.49134,-2.1755e-05],[0.69213,-0.68262,0.23448],[-0.78936,0.2087,-0.57737],[0.43338,0.19602,0.87964],[-0.69692,0.021718,-0.71682],[0.90309,-0.30295,-0.3044],[-0.80398,-0.51862,-0.29095],[0.69917,-0.69529,0.16656],[0.38391,0.85314,-0.35322],[0.84311,-0.098785,0.52858],[0.91944,-0.30612,-0.24681],[-0.78251,0.50855,0.35924],[0.97902,0.20318,-0.015327],[0.09766,0.67231,-0.7338],[0.7654,-0.57116,0.29654],[-0.75651,-0.65271,-0.04069],[0.74441,0.0066945,0.66769],[0.65845,-0.63066,0.41075],[-0.73328,0.023669,-0.67952],[-0.21891,0.73347,-0.64351],[0.9743,0.22012,0.047853],[-0.20887,-0.86032,0.465],[-0.39295,-0.88984,0.23191],[0.49216,-0.76477,0.41583],[-0.507,0.486,0.71186],[0.77746,0.62489,0.071135],[0.03436,-0.7885,0.61408],[-0.71994,0.011561,0.69394],[0.054042,-0.79693,0.60165],[-0.75231,0.10772,-0.64995],[0.91159,0.16913,0.37471],[0.95508,-0.013291,-0.29605],[-0.18137,0.088362,0.97944],[0.007404,0.3809,0.92459],[0.9175,0.29417,-0.26768],[0.18965,-0.79842,0.57146],[-0.41403,-0.027213,0.90986],[-0.72952,-0.68391,-0.0086237],[-0.96025,0.27239,0.061056],[0.87639,0.4816,0.00023167],[-0.78003,0.070459,-0.62176],[0.95294,-0.029071,0.30178],[0.99378,-0.041134,-0.10353],[0.86161,0.46166,-0.21093],[0.88049,0.21822,0.42085],[0.65057,0.75744,-0.055271],[-0.91764,-0.20986,-0.33749],[-0.79294,-0.02934,-0.6086],[-0.61388,0.11253,0.78134],[0.21549,0.86201,-0.4588],[0.66116,-0.30577,0.6851],[-0.88392,0.40723,0.2299],[-0.47008,0.82269,0.31971],[0.99482,-0.085546,-0.05484],[-0.095145,0.96331,-0.25096],[0.85977,0.46327,-0.21487],[-0.10578,0.9028,-0.41684],[-0.86446,-0.24637,-0.4382],[-0.7143,0.62397,0.31692],[0.14973,0.222,0.96348],[0.45397,0.13653,0.8805],[0.99517,0.045676,-0.086875],[-0.89505,0.42799,-0.12535],[0.96836,0.22982,0.097307],[0.96492,0.17038,-0.19975],[0.22689,-0.63044,-0.74234],[-0.85306,0.072169,-0.5168],[-0.88307,0.21269,-0.41827],[-0.7391,0.55698,0.37881],[0.54202,-0.36972,0.75466],[0.89348,0.083015,0.44137],[0.010589,0.64494,0.76416],[-0.85829,0.25801,-0.44358],[-0.31626,0.49853,0.80712],[0.3781,0.86285,0.33546],[0.35879,0.66199,-0.65805],[-0.81184,0.10879,0.57366],[0.76549,0.23831,0.59769],[-0.64169,0.75359,0.14261],[-0.5462,0.22122,0.80792],[0.42089,0.90661,0.030066],[-0.83197,0.15985,-0.53129],[0.90985,-0.38807,0.14686],[0.19875,0.96153,0.18965],[-0.085792,0.91517,-0.39384],[-0.11905,-0.39227,0.91211],[0.86752,0.26186,0.4229],[0.91225,0.3274,-0.24619],[-0.58675,0.056425,0.8078],[-0.2699,0.87905,0.39296],[0.19262,0.94779,0.25414],[0.19151,0.84993,0.49087],[0.31183,0.85878,0.40653],[-0.87939,0.20984,-0.42737],[-0.62396,-0.70953,0.32748],[-0.82907,-0.55819,0.032624],[0.62275,0.51516,0.5889],[0.17337,0.89746,0.4056],[0.17024,0.84012,0.51499],[0.39723,0.27991,0.87399],[-0.11297,0.17338,0.97835],[-0.82101,0.078521,-0.56548],[-0.049976,-0.18496,0.98147],[0.016396,0.9655,0.25988],[0.20197,0.92859,0.31134],[0.66179,0.094249,0.74374],[0.65006,-0.17303,0.73992],[0.069902,0.97179,-0.22527],[0.81106,0.2948,0.50525],[0.87336,0.045496,0.48495],[-0.91956,0.30726,-0.24497],[-0.84917,0.44921,-0.2777],[0.66825,0.12269,0.73375],[0.50932,-0.12087,0.85205],[-0.74493,0.036783,0.66613],[0.89922,0.30206,0.31648],[0.088831,0.886,-0.4551],[0.66009,0.50625,0.55497],[-0.27594,-0.30842,0.91035],[0.42002,0.32427,0.8476],[-0.80818,0.53999,-0.23505],[0.06397,-0.29496,0.95336],[0.99595,-0.089519,-0.0078044],[-0.66525,-0.36746,0.64994],[0.91028,-0.41207,-0.039793],[-0.95868,0.25062,0.13463],[0.80876,0.1629,0.56513],[-0.86502,0.43552,-0.24911],[0.80922,-0.38874,-0.4405],[-0.88496,0.23586,0.40153],[0.89891,0.19182,0.39392],[0.28038,-0.42745,0.85946],[-0.16483,-0.27691,0.94665],[0.28663,-0.011618,-0.95797],[-0.25498,0.37199,0.89253],[0.52147,-0.22925,-0.8219],[-0.93055,0.17477,0.32178],[-0.084712,0.18982,0.97816],[-0.77067,-0.60047,0.21334],[-0.65497,-0.014622,0.75552],[0.28183,-0.082013,-0.95595],[0.85784,-0.50923,0.06921],[0.22759,-0.045507,-0.97269],[0.092009,0.48462,0.86987],[0.82762,0.37018,0.42192],[0.43247,0.67754,-0.59491],[0.76068,0.4086,0.5044],[0.61078,0.60595,0.50968],[-0.48048,-0.6633,0.57373],[-0.39466,-0.51035,0.76406],[0.65633,-0.75431,0.015522],[0.25748,-0.31461,0.91363],[-0.1743,-0.27798,0.94464],[-0.73709,0.23771,0.6326],[0.4979,0.3292,0.80232],[0.7024,0.55372,0.44725],[-0.71047,-0.55098,0.43778],[-0.45084,-0.4213,0.78692],[0.25608,-0.12236,-0.95888],[-0.63857,0.72939,-0.24541],[-0.20015,0.33346,0.92127],[0.34763,0.64961,-0.67614],[0.61798,-0.62564,0.47612],[-0.39288,0.38631,0.83451],[0.61474,0.69391,0.37494],[-0.73531,0.39816,0.54844],[0.49829,0.56072,-0.66129],[0.31706,-0.14537,-0.9372],[-0.98987,-0.0526,-0.13189],[-0.47708,0.54977,0.68568],[0.62341,0.57314,0.53185],[-0.58897,-0.13095,0.79748],[-0.58765,-0.24603,0.77081],[-0.19201,0.93276,-0.30509],[0.20915,0.80961,-0.54845],[0.55077,0.62704,0.55088],[-0.28242,-0.62973,-0.72366],[-0.80904,-0.5824,0.079224],[0.32713,-0.21399,-0.92043],[-0.25759,0.89365,-0.36747],[-0.36103,0.59837,0.71527],[-0.28905,0.67063,0.68316],[0.83504,-0.18516,0.51809],[-0.79646,-0.53282,-0.28592],[-0.19706,-0.63834,-0.7441],[0.20143,0.96687,-0.15682],[0.79618,0.44073,0.41456],[-0.73937,0.60358,-0.29837],[-0.13621,-0.1591,0.97782],[-0.62898,0.48795,0.60522],[-0.22303,-0.098691,0.9698],[-0.53961,0.32689,0.77587],[-0.27712,0.72481,0.63076],[-0.12324,-0.87104,-0.47551],[-0.68816,-0.15756,0.70824],[-0.82778,0.4769,0.29555],[-0.0048201,0.94544,-0.32575],[0.13108,0.95749,-0.25696],[0.20016,0.95354,-0.22515],[-0.92878,0.34565,-0.13374],[0.62759,0.35619,0.69229],[0.11161,0.53097,0.84001],[0.0076246,0.76022,0.64962],[0.46264,0.39034,0.79599],[0.55847,0.077271,0.82592],[-0.72262,-0.071418,0.68754],[0.2719,0.88949,-0.36727],[-0.56695,0.61652,0.54633],[0.23208,-0.27635,-0.93261],[0.16745,-0.29966,-0.93923],[0.093766,-0.67824,-0.72884],[0.45015,0.81384,-0.36747],[-0.96612,0.25669,-0.02681],[0.81597,0.14938,0.55846],[0.79216,0.60056,-0.10867],[0.63581,0.72742,-0.25808],[0.15453,-0.31633,-0.93598],[0.1522,-0.32346,-0.93392],[0.98565,-0.08251,0.14728],[0.51139,-0.43792,-0.7394],[0.29791,-0.81439,-0.49801],[0.88054,0.30523,0.36262],[0.83201,-0.50414,-0.23152],[0.58308,-0.54163,-0.60552],[-0.86319,0.46527,0.19603],[0.82786,-0.56034,0.025707],[0.16851,-0.0086999,0.98566],[0.88432,-0.35808,0.2996],[-0.68051,-0.080499,0.7283],[-0.30527,0.53902,0.78503],[0.73718,-0.54198,0.40352],[0.59054,-0.60401,0.53519],[0.74747,0.59753,0.29024],[-0.77663,0.5634,0.28181],[-0.75443,0.54192,0.37035],[-0.98893,-0.14796,-0.011283],[0.3359,0.16779,0.92683],[0.66372,-0.59067,0.4589],[-0.70701,0.62675,0.32759],[-0.23793,0.88146,-0.40794],[-0.013585,0.32711,0.94489],[0.50432,0.14076,0.85197],[-0.76412,0.50534,0.40095],[0.12936,0.37208,0.91914],[-0.9112,-0.3763,0.16765],[0.44087,-0.76306,0.47262],[0.54377,0.18466,0.81867],[-0.6457,0.68847,0.33026],[0.0095466,-0.71165,0.70247],[0.69143,0.70617,0.15249],[-0.19347,-0.078615,0.97795],[0.41778,0.66861,0.61516],[-0.44124,-0.86997,-0.22013],[0.73815,0.51253,0.43868],[-0.016982,0.83947,-0.54314],[-0.43584,0.28294,0.85439],[-0.75413,0.17689,0.63245],[0.30578,0.66906,0.67739],[0.5795,0.62218,0.52638],[0.5058,0.2495,0.82578],[-0.34474,0.37579,0.86019],[0.17299,0.61461,0.76963],[0.019665,-0.75849,0.65138],[-0.42317,0.74014,0.5226],[0.40128,-0.62872,0.6661],[-0.32773,0.74855,0.57642],[0.37906,0.39509,0.83679],[0.62303,0.66694,0.4087],[-0.85955,-0.34985,0.37252],[0.55861,0.62908,0.54057],[0.20322,0.52311,0.82768],[-0.097327,0.048811,0.99405],[-0.10504,0.68942,0.71671],[-0.30681,0.48117,0.82119],[0.058057,-0.99822,0.014001],[0.11674,-0.99283,-0.025569],[-0.17901,-0.9834,-0.029506],[-0.063192,-0.94036,-0.33427],[0.05736,-0.93901,-0.33908],[0.65882,-0.11861,0.74289],[-0.40966,-0.9111,-0.045533],[0.45089,-0.87574,-0.17257],[-0.15637,0.62765,-0.76263],[0.54383,-0.83547,0.079012],[-0.49469,-0.85244,-0.16918],[0.51058,-0.75038,-0.41981],[0.64476,-0.7642,0.017036],[-0.51646,-0.84979,0.10551],[0.694,-0.71892,-0.038921],[-0.21843,-0.7591,-0.61324],[0.21625,0.37388,0.90191],[-0.17664,-0.71879,-0.67241],[0.1267,-0.55512,0.82207],[0.13044,-0.7712,-0.62308],[-0.78615,-0.44449,0.42941],[0.073003,-0.019846,0.99713],[-0.64805,-0.71158,0.27144],[-0.21232,-0.77842,-0.59075],[-0.67506,0.49348,0.54843],[-0.24867,-0.11856,0.9613],[0.45786,-0.70637,-0.53981],[0.45472,-0.80245,-0.38639],[-0.76487,-0.58645,0.26654],[-0.021932,-0.31008,-0.95046],[0.67921,-0.72481,-0.11541],[-0.52694,-0.66326,-0.53143],[0.64835,0.60324,0.46448],[0.16005,-0.83481,-0.52676],[0.49452,-0.29868,0.81624],[0.72607,-0.68015,-0.10109],[0.64254,0.69826,0.31555],[0.31757,-0.26777,0.90964],[-0.6478,-0.75478,0.1032],[0.49599,0.40408,0.76858],[0.061182,-0.99778,0.026234],[0.21902,-0.94929,0.22555],[0.034534,-0.53858,-0.84186],[-0.0085997,-0.44341,-0.89628],[0.56877,-0.63022,-0.52852],[-0.71272,-0.70048,0.036906],[-0.62565,-0.33582,0.70412],[-0.73298,0.65512,0.18321],[-0.49287,-0.86866,-0.050076],[-0.4642,0.76284,0.4501],[-0.74149,0.16728,-0.64977],[-0.26761,0.56418,0.78108],[0.77794,-0.30637,0.54859],[-0.60986,-0.78272,0.12421],[-0.086433,-0.58617,-0.80557],[-0.20373,0.55371,0.8074],[0.10935,-0.59086,-0.79933],[0.69077,-0.567,-0.44872],[-0.49861,-0.85355,-0.15113],[0.51344,-0.83848,-0.18259],[0.45176,-0.3603,0.81615],[-0.57087,-0.14761,0.80766],[-0.64456,-0.73589,-0.20739],[0.66903,-0.62986,0.39456],[-0.30623,0.84097,-0.44609],[-0.46251,0.8277,-0.31779],[0.57583,-0.72914,-0.36983],[-0.3748,-0.9271,0.00096165],[-0.53397,0.61934,0.57558],[0.46692,-0.8789,-0.097614],[-0.77524,-0.55883,-0.29448],[0.7348,-0.62271,0.26891],[0.29184,0.06706,0.95411],[-0.35953,-0.93278,0.025661],[0.43909,0.15616,0.88477],[0.53792,-0.69991,-0.46987],[-0.85642,-0.45442,0.24505],[-0.69632,-0.70014,0.15795],[0.76452,-0.57715,0.28707],[-0.80614,0.46058,-0.37149],[0.74029,-0.23044,0.63156],[0.60154,-0.62271,-0.50038],[-0.89656,-0.35218,0.26859],[-0.4592,-0.26719,0.8472],[0.14649,-0.54738,-0.82396],[-0.81822,0.035571,-0.5738],[-0.46078,-0.19678,0.86542],[0.46877,0.13488,0.87296],[-0.69721,0.11965,-0.70681],[-0.76965,0.03635,-0.63743],[0.76667,-0.54557,-0.33848],[0.025239,0.51339,0.85779],[-0.78264,-0.4832,-0.39242],[0.1453,0.50298,0.852],[0.85521,-0.47027,0.21784],[-0.77406,0.077689,-0.62833],[-0.86936,-0.15359,0.46971],[0.98041,-0.11427,-0.16041],[0.74289,-0.097359,0.6623],[-0.82873,-0.44298,0.342],[0.96604,0.14314,-0.21513],[-0.86963,-0.084011,-0.48651],[0.96153,0.14423,-0.23379],[-0.51391,0.61708,0.59591],[-0.89489,-0.031164,-0.4452],[0.058635,-0.62631,-0.77736],[0.71545,0.014079,0.69852],[0.3977,-0.12763,0.9086],[0.88679,-0.45618,-0.074197],[0.87926,-0.44021,-0.182],[-0.47786,-0.21116,0.85268],[0.92378,-0.1374,-0.35742],[-0.88308,0.050887,-0.46646],[-0.88878,-0.10264,0.44669],[0.88818,-0.061396,-0.45537],[-0.77481,-0.54817,-0.31492],[-0.82551,0.10713,-0.55413],[0.73928,-0.01307,0.67327],[-0.20682,-0.49533,-0.84373],[0.88966,0.24762,-0.38366],[-0.46165,0.65856,0.59429],[0.89271,0.29619,-0.33963],[-0.81587,-0.49233,-0.30326],[0.76217,-0.63565,-0.12262],[0.64616,0.05375,0.76131],[-0.77762,-0.013607,-0.62859],[-0.53098,-0.095713,0.84196],[-0.12643,-0.48372,-0.86604],[-0.98288,0.12365,0.13656],[-0.90197,-0.35407,-0.24716],[0.95681,0.22028,0.18973],[-0.39466,0.67789,0.62025],[0.96873,-0.14402,-0.20206],[0.097663,0.23701,0.96659],[-0.23757,-0.90363,0.35639],[0.49597,0.34053,0.79878],[-0.22741,-0.88379,0.4089],[0.64338,-0.11394,0.75702],[-0.28267,-0.88387,0.37264],[0.060023,-0.78969,0.61056],[0.65545,-0.5164,0.5511],[-0.5505,-0.82345,-0.1374],[-0.15168,-0.96416,0.2177],[0.85245,-0.34797,0.39019],[0.75369,-0.043116,0.65582],[0.93026,0.30532,0.20345],[-0.754,0.054407,-0.65461],[0.97939,0.12928,-0.15518],[0.87859,0.41757,0.23177],[0.16759,-0.44855,-0.8779],[-0.63034,-0.043628,0.77509],[0.96948,0.23951,-0.052383],[-0.9271,-0.28765,-0.24031],[0.30652,0.83821,0.45106],[0.68282,0.72939,0.04171],[0.99428,-0.043863,-0.097361],[-0.49683,-0.851,-0.17018],[-0.49579,0.67276,0.54918],[0.68246,0.67533,-0.2796],[0.3414,-0.42501,-0.83834],[-0.74793,0.52758,0.40281],[0.77596,0.094994,0.62358],[-0.93238,-0.25285,-0.25834],[0.86505,0.38848,-0.31744],[-0.022309,0.59981,0.79983],[0.6439,0.75955,0.092025],[-0.76935,0.57859,0.2708],[0.55773,-0.24707,0.7924],[-0.81338,0.15638,-0.56032],[0.91199,0.12128,0.39188],[0.72173,0.24907,0.6458],[0.56495,0.77225,0.29062],[0.98037,0.13077,-0.14753],[0.97188,0.19499,-0.13205],[-0.43703,-0.64041,-0.63157],[-0.1271,0.83084,0.54181],[-0.035812,0.89005,0.45445],[0.80856,0.23802,0.53813],[0.16368,0.92955,0.33036],[0.35899,0.93188,0.052239],[0.22028,0.92853,0.29886],[-0.86259,0.14032,-0.48606],[0.63996,0.74724,0.1791],[-0.89411,0.13956,-0.42554],[0.94616,0.20096,-0.25378],[-0.40707,0.83281,0.37514],[0.68425,-0.72905,-0.017166],[0.2324,0.88654,0.40004],[0.42466,0.48052,0.76731],[0.043711,0.92199,0.38474],[-0.27348,0.86884,0.4127],[0.54536,0.36389,0.7551],[0.23893,0.96072,0.14115],[0.26498,0.96047,0.085312],[0.57779,0.3839,0.72027],[0.78804,0.19497,0.58393],[-0.25481,0.90811,0.33228],[-0.15034,0.93773,0.31314],[0.18118,-0.24282,0.953],[-0.80385,0.015111,-0.59464],[0.53464,0.50462,0.67787],[0.76754,0.042271,0.63961],[-0.095313,0.34705,0.93299],[0.091071,-0.41863,0.90358],[-0.28419,0.8712,0.40031],[0.58822,0.62827,0.50919],[-0.25288,-0.24828,0.9351],[0.91772,0.11691,-0.37963],[-0.61107,-0.58309,-0.53535],[-0.57937,-0.080764,-0.81105],[-0.043577,0.85921,0.50977],[-0.78978,0.50439,0.34905],[-0.89354,0.36612,-0.25988],[0.88977,-0.099468,-0.44543],[0.65651,-0.037951,0.75336],[-0.54907,0.35971,-0.75441],[-0.65645,0.58647,0.47447],[-0.17537,-0.50385,0.8458],[0.59864,0.78963,0.13457],[-0.76158,0.23999,0.602],[0.27995,0.512,0.81208],[-0.013533,-0.41921,0.90779],[-0.67614,0.53973,-0.50152],[-0.90775,0.32787,-0.26172],[0.95524,0.1839,-0.23171],[0.56892,0.17004,0.80462],[0.97555,0.19424,-0.1028],[-0.87182,-0.38491,-0.30294],[-0.15512,-0.32511,0.93287],[0.60449,0.4254,0.67352],[-0.90458,0.42135,-0.064769],[0.73058,0.30293,0.61196],[-0.81097,0.54087,-0.22311],[0.75609,0.31517,0.57357],[0.70964,-0.35167,0.61052],[0.81153,-0.56725,0.14014],[0.73141,0.27851,0.62247],[0.78473,-0.61884,-0.03516],[-0.87613,0.2927,0.38305],[-0.96305,0.25234,0.09414],[0.033012,-0.18398,0.98237],[0.71958,-0.55888,-0.41214],[0.015119,0.31247,0.94981],[-0.91013,0.13894,0.39033],[-0.95974,-0.17995,0.21569],[0.75383,0.32525,0.57092],[0.24622,-0.4548,0.85588],[0.50381,-0.28807,-0.81437],[-0.84319,0.2277,0.48701],[-0.92624,-0.34669,-0.14797],[0.44489,-0.2377,0.86347],[-0.62741,-0.58045,0.51908],[-0.79422,-0.46828,0.38722],[-0.20692,-0.32609,-0.92241],[-0.49942,0.61314,0.61207],[-0.56761,-0.61344,0.5491],[-0.73273,-0.23508,-0.63863],[0.44552,-0.30265,-0.84256],[0.59046,-0.29213,-0.75234],[0.43266,0.5614,0.70543],[-0.7412,0.44887,0.49914],[0.70418,-0.55904,0.43773],[0.31489,-0.12372,-0.94103],[-0.29136,-0.39251,0.87238],[0.73333,0.41891,0.53548],[-0.57665,-0.54818,0.60579],[-0.63064,0.46383,0.62222],[0.66903,0.55663,0.4925],[0.49072,-0.44834,-0.74712],[-0.61262,0.32845,0.7189],[0.55352,0.52148,0.64936],[0.11862,-0.19104,0.97439],[-0.5101,0.39527,0.76391],[0.48502,0.70245,0.52088],[-0.59625,-0.40894,0.69084],[-0.55288,-0.37274,-0.74524],[0.35237,-0.1012,-0.93037],[-0.085911,-0.37765,0.92195],[0.024117,-0.5348,0.84463],[0.090999,0.55005,0.83016],[0.3016,-0.19467,-0.93335],[-0.28204,0.44595,0.84946],[-0.15414,0.35262,0.92298],[0.63973,0.73971,-0.20875],[-0.65666,-0.68611,-0.31312],[0.89663,-0.42553,-0.1224],[0.47908,0.52303,0.70492],[0.11235,0.90795,-0.40374],[-0.21146,0.87468,-0.43615],[-0.27145,0.47379,0.83776],[-0.34322,-0.36352,0.86605],[-0.12419,0.55413,0.82312],[0.26042,0.63667,0.72583],[-0.13421,0.62984,0.76504],[0.51,0.55427,0.65778],[0.36314,0.93149,0.021228],[0.12686,0.96292,-0.23811],[-0.48386,0.80049,-0.3537],[0.29832,-0.31611,-0.9006],[-0.39611,0.87387,0.28186],[0.18995,0.93955,-0.2849],[0.61775,0.55789,0.55421],[0.27776,0.93366,-0.22611],[0.012719,-0.5349,0.84482],[0.44485,-0.49267,-0.74792],[0.61155,-0.45366,-0.64823],[-0.73841,-0.094746,0.66766],[-0.51269,0.092336,0.85359],[0.27445,0.88255,-0.38182],[-0.28942,-0.54834,0.78458],[0.073988,-0.32042,0.94438],[0.24618,0.88396,-0.39751],[0.34689,-0.38591,-0.85483],[0.81225,-0.43158,-0.39242],[-0.74236,-0.085376,0.66453],[-0.7531,-0.58258,-0.3057],[-0.072739,0.64332,0.76213],[-0.67106,0.1173,0.73207],[0.90836,-0.38049,0.17354],[-0.95402,-0.0072187,0.29964],[-0.73229,-0.10956,0.67212],[0.76333,0.62864,0.14878],[0.83237,-0.39578,0.38797],[-0.88699,-0.28978,0.35955],[-0.83979,-0.45157,-0.3014],[-0.80116,-0.32176,-0.50459],[0.73798,-0.27733,0.6152],[-0.14498,0.94354,0.29784],[-0.18104,-0.4884,0.85363],[0.6455,-0.034339,0.76299],[0.72739,0.6023,0.32885],[0.60078,-0.41871,-0.68099],[0.88272,-0.45754,-0.10707],[-0.65561,-0.0051862,0.75508],[-0.9665,-0.15714,-0.20292],[0.46982,0.065665,0.88031],[-0.57817,0.11221,0.80816],[0.63562,0.62109,0.45852],[0.33538,-0.86631,0.37017],[0.028886,-0.50825,0.86072],[0.51021,0.089425,0.85539],[-0.61151,-0.13961,0.77882],[0.85841,0.47269,0.19925],[0.60221,0.6018,0.52457],[0.96416,-0.25887,-0.05822],[-0.93278,0.20046,0.29955],[0.68542,0.49302,0.53586],[0.53258,0.15057,0.83288],[-0.69416,0.4785,0.53775],[0.27984,0.056456,0.95839],[-0.54037,0.15088,0.82779],[-0.56408,0.6998,0.43829],[0.25561,0.21382,0.94284],[0.86782,0.30699,0.39069],[0.24253,0.62358,0.74319],[-0.95003,-0.26537,-0.16441],[0.27077,0.21395,0.93857],[0.072475,0.5855,0.80743],[0.47114,0.65167,0.59443],[-0.60934,0.29487,0.73604],[-0.42496,0.70716,0.5651],[0.093169,-0.59899,0.79532],[-0.54339,0.63172,0.55286],[-0.99314,-0.10143,-0.058131],[0.97505,-0.12541,0.18319],[-0.27914,0.68118,0.67681],[0.4182,-0.20639,0.8846],[-0.19088,0.68996,0.69822],[0.091793,0.58195,0.80803],[0.85243,0.34162,0.39579],[-0.98378,-0.14794,-0.10141],[-0.64992,-0.37011,-0.6638],[-0.47895,-0.52329,0.70483],[-0.49346,0.29149,0.81947],[-0.42658,-0.077558,0.90112],[-0.45835,-0.262,0.84927],[0.25121,0.71198,0.65573],[0.23634,-0.94627,-0.2207],[-0.19882,-0.97647,0.083521],[0.58992,-0.44026,-0.67688],[-0.29389,-0.93175,-0.21323],[0.58433,-0.72772,0.35914],[0.23703,0.69649,0.67729],[0.52622,-0.8501,0.020693],[0.32886,0.13818,0.93422],[0.555,-0.83159,0.020881],[-0.54178,-0.83098,-0.12627],[0.39546,-0.90951,0.12808],[0.85241,0.48274,0.2009],[0.52136,0.78855,0.32614],[-0.51243,-0.15946,0.84379],[-0.29988,-0.78429,-0.5431],[0.0035182,-0.81263,-0.58276],[-0.83782,0.52953,0.13286],[0.27984,-0.73641,-0.61594],[0.96611,-0.019963,0.25735],[-0.93757,0.30982,0.15805],[-0.47542,-0.29317,-0.82947],[-0.24056,-0.57625,0.78106],[-0.30405,0.64976,0.69668],[-0.077513,-0.59146,0.8026],[-0.27023,-0.89428,-0.3567],[-0.26741,-0.87827,-0.39639],[0.28578,0.74138,0.6072],[0.7798,0.62136,0.076326],[-0.48083,-0.39783,-0.78137],[0.80187,-0.053322,0.59511],[0.44053,-0.79748,-0.41227],[-0.24073,-0.44818,0.86092],[-0.50228,-0.18749,0.84413],[-0.69165,-0.51262,-0.50877],[-0.53332,-0.18835,-0.82468],[0.26494,-0.7838,-0.56166],[-0.63253,-0.7622,0.13769],[-0.36113,-0.92744,-0.097189],[0.083559,-0.99581,-0.037171],[0.19953,-0.97919,-0.037052],[-0.70314,-0.29164,-0.64849],[-0.7701,-0.25426,-0.58506],[0.50383,-0.8638,-0.0015438],[0.76103,-0.25318,0.59727],[-0.32448,0.72099,0.61229],[-0.84362,-0.53141,0.076837],[-0.57604,-0.7972,-0.18072],[0.66074,-0.7494,-0.042642],[-0.1073,-0.52526,-0.84415],[0.48623,-0.078878,0.87026],[-0.80419,-0.59229,0.049698],[0.94971,-0.29091,-0.11583],[-0.65642,0.5012,-0.56383],[-0.38813,0.79642,-0.46376],[-0.56681,-0.81971,-0.08247],[0.66461,-0.70846,-0.23745],[-0.25182,0.86911,-0.42572],[-0.28953,0.87665,-0.38425],[0.42621,-0.22135,0.87713],[0.56588,-0.79509,-0.21819],[-0.23342,-0.97083,-0.054793],[0.91909,-0.34448,-0.19135],[-0.67344,-0.70774,-0.21351],[0.2091,-0.21078,0.95491],[-0.76307,0.47257,-0.44092],[-0.016879,-0.40992,0.91197],[-0.27416,-0.70092,-0.65845],[-0.72955,0.23825,-0.64109],[0.93206,-0.36222,0.0081771],[-0.75259,0.65839,-0.011441],[0.16709,-0.82304,-0.54286],[0.70859,-0.62959,-0.31862],[-0.69446,0.025606,-0.71907],[0.76061,-0.5177,-0.39174],[0.21536,-0.56246,0.79829],[0.94056,-0.29193,-0.17356],[-0.85789,-0.49422,-0.14058],[-0.67533,-0.20639,-0.70805],[0.8508,-0.44754,-0.27542],[0.46865,-0.40789,0.78357],[-0.68763,0.16645,-0.70672],[-0.88707,-0.19086,0.42033],[0.95898,0.14738,-0.24214],[-0.69087,-0.68239,-0.23882],[-0.66572,-0.73904,-0.10316],[-0.30261,-0.634,-0.71167],[0.62407,0.046014,0.78001],[-0.98946,-0.14083,-0.033825],[-0.53658,-0.094403,0.83855],[0.82682,-0.51173,-0.23345],[0.51003,-0.63544,0.57973],[0.76511,-0.64317,-0.03058],[-0.71302,0.70108,0.0097843],[0.058884,-0.59725,0.79989],[-0.88489,-0.14041,0.44413],[0.99939,0.027845,-0.021028],[-0.42049,0.66653,0.61557],[-0.80029,-0.43831,-0.40918],[0.80316,-0.49308,-0.33436],[-0.96168,0.2601,0.086695],[0.8432,-0.51901,-0.14015],[0.71869,-0.14535,0.67997],[0.1727,0.75729,0.62983],[0.38373,-0.30498,0.87163],[-0.87886,-0.47408,0.0534],[-0.4275,-0.19797,0.88207],[-0.83651,-0.30153,-0.45753],[0.80349,-0.41858,-0.4233],[-0.23165,-0.10023,0.96762],[0.86743,0.03043,0.49663],[0.87423,-0.36991,-0.31445],[0.94526,0.13892,0.29528],[0.50418,0.70506,0.49869],[-0.021248,-0.50712,0.86161],[0.7755,-0.46268,-0.42957],[-0.9206,-0.0064578,0.39045],[0.74333,0.65271,-0.14638],[-0.43011,-0.29177,0.85433],[0.95991,-0.19806,0.19835],[0.90069,0.35276,-0.25363],[0.45275,-0.40659,-0.79354],[0.78397,-0.50845,-0.35618],[0.70152,0.68682,-0.19011],[-0.74736,0.037143,-0.66338],[0.97586,-0.15488,-0.154],[0.86294,0.44993,-0.22998],[0.89505,-0.41567,-0.16154],[0.36763,-0.5096,0.77792],[-0.81575,0.084017,-0.57227],[0.94407,0.32515,0.054802],[-0.5532,-0.34668,0.75749],[-0.93311,-0.31636,-0.17094],[0.811,-0.56892,0.13642],[-0.81503,0.13899,-0.56251],[0.97058,0.032814,-0.23855],[-0.60923,-0.76755,0.19925],[-0.34525,-0.64592,-0.68087],[-0.78827,0.12872,-0.60171],[-0.19562,-0.75535,-0.62545],[-0.37824,-0.91922,0.10939],[-0.15104,-0.96278,0.22414],[0.29108,-0.83683,0.46366],[-0.12524,-0.68536,-0.71735],[0.23266,-0.70343,0.67161],[0.24187,0.084002,0.96667],[0.89561,0.30947,0.31956],[-0.53565,-0.84442,0.0050245],[-0.092872,-0.60113,-0.79374],[-0.76076,-0.63662,-0.12631],[0.92036,-0.37792,0.10054],[0.4882,0.0047243,0.87272],[-0.89479,0.33937,0.29012],[0.79777,0.57722,0.17429],[0.53498,0.75046,-0.38808],[-0.70183,0.040421,-0.7112],[-0.89734,-0.39503,0.19682],[0.581,0.76125,-0.28799],[0.93359,0.35788,-0.018361],[0.16041,0.72984,0.66453],[-0.92055,-0.30136,-0.24853],[-0.90522,-0.25317,0.3413],[0.87768,0.36869,-0.30619],[0.8375,0.53311,-0.11992],[0.73193,0.64287,-0.2258],[-0.40101,-0.23506,0.8854],[-0.77319,0.057525,-0.63156],[0.6596,-0.40523,-0.63302],[0.37325,-0.67594,0.63544],[0.49818,-0.71034,0.49722],[0.98368,-0.06143,-0.16912],[0.85455,0.51056,0.095238],[0.59661,0.79348,-0.1202],[-0.94557,-0.020649,-0.32476],[0.98868,0.033732,-0.14619],[-0.58569,0.34944,0.73134],[-0.43154,0.90205,-0.0093606],[0.13669,0.71953,0.68088],[0.86769,0.44735,0.21678],[-0.40236,-0.53567,-0.7424],[0.54878,0.54909,0.63035],[-0.94303,0.25638,-0.21205],[0.9043,0.34219,0.25524],[0.87384,0.47318,0.11183],[0.53443,0.59467,0.60063],[0.34144,0.85846,0.3827],[-0.95538,0.13791,-0.26122],[0.78291,0.32737,0.52903],[-0.76832,0.58125,0.26801],[-0.66131,0.70614,0.25305],[0.47338,0.87124,0.12984],[0.38746,0.83834,0.38348],[0.67621,-0.26067,0.68906],[0.79189,0.19728,0.57791],[-0.34283,-0.28537,0.895],[-0.31468,0.071171,0.94653],[0.47284,0.88093,0.019757],[0.52102,0.8072,0.27742],[-0.78037,0.050394,-0.62328],[0.10497,0.87458,0.47339],[0.8089,-0.054828,0.58538],[-0.36081,0.78906,0.49719],[0.49485,-0.57424,0.65221],[0.75108,0.66021,0.00077686],[0.73708,-0.17837,0.65184],[0.077387,0.97627,0.20224],[0.4094,-0.74045,0.53304],[-0.91405,0.30565,0.26662],[0.22425,0.89111,0.3945],[-0.083538,0.65533,0.7507],[-0.049382,0.94421,0.32561],[-0.089629,0.92488,0.36954],[-0.73349,-0.67851,0.040209],[-0.49316,-0.54084,0.68139],[-0.020747,0.69559,0.71814],[0.20019,0.85179,0.48413],[0.91725,0.3515,-0.18735],[-0.62087,-0.14795,-0.76982],[0.82801,0.20282,0.52275],[0.19187,0.83217,0.52027],[-0.5756,0.17206,-0.79943],[-0.92426,0.31219,-0.21974],[-0.5565,0.54806,0.62445],[-0.47579,-0.5236,-0.70673],[0.93708,-0.0096636,-0.34897],[0.91831,-0.064482,0.39056],[0.62559,0.11945,0.77095],[-0.39652,0.68205,-0.61448],[-0.62932,0.73486,-0.25288],[-0.82407,0.50234,-0.26186],[-0.81833,0.57464,-0.011439],[-0.90367,0.37401,0.20855],[-0.084638,-0.39214,-0.916],[0.9153,-0.36779,0.16417],[-0.85684,0.35879,0.37027],[-0.89056,0.45476,0.0094586],[0.73324,0.19233,0.65221],[0.84428,-0.29419,0.44793],[0.23266,-0.4487,-0.86287],[0.71798,-0.15137,0.6794],[-0.86032,0.50947,-0.016852],[0.77779,-0.58505,0.22972],[0.69166,-0.65241,0.3098],[0.7475,0.20323,0.63241],[0.7344,-0.67591,0.061613],[-0.82016,0.25558,0.51187],[-0.39649,-0.48906,0.77693],[0.73685,-0.67513,0.035505],[-0.92246,-0.26766,0.27827],[0.62394,-0.47247,0.62247],[-0.45211,-0.61611,0.64499],[0.70157,-0.62328,-0.34543],[0.64099,-0.39839,-0.65606],[0.72447,0.27252,0.63314],[-0.57785,-0.11795,0.80758],[-0.47937,0.41774,0.77182],[-0.63275,-0.59605,0.49431],[0.41525,0.18996,0.88965],[0.60637,-0.63182,-0.48283],[-0.47684,0.43483,0.7639],[0.74196,-0.4647,-0.48326],[0.58888,0.40062,0.70194],[0.32697,0.69704,0.63815],[-0.68124,-0.52874,0.50631],[0.58254,-0.35223,-0.73252],[0.72782,-0.64316,-0.23794],[0.040812,-0.83348,0.55105],[0.46748,0.64463,0.60491],[0.42555,0.70068,0.57267],[-0.30613,-0.55795,-0.77135],[0.71616,-0.32228,-0.61908],[-0.29361,-0.25287,-0.92187],[-0.19895,0.44737,0.87194],[0.41946,0.58222,0.69647],[-0.77646,-0.55959,0.28978],[0.55495,-0.20396,0.80649],[0.62717,-0.051648,0.77717],[-0.28394,0.38104,0.87988],[-0.54785,-0.44408,0.70898],[-0.72815,-0.37768,0.57198],[0.22444,-0.46391,-0.85698],[0.81543,-0.33152,0.47452],[-0.77346,0.10029,0.62586],[-0.24082,0.37936,0.89336],[-0.32229,-0.7072,0.62929],[0.30592,0.48451,0.81955],[-0.51895,-0.13662,0.84382],[0.67329,-0.44144,-0.59314],[0.76051,0.64932,-0.0034612],[-0.20331,0.5662,0.7988],[0.039075,0.52606,0.84955],[0.55502,-0.17137,0.81399],[-0.75712,-0.20792,0.6193],[0.35372,0.93008,-0.099107],[0.055354,0.98877,-0.13884],[0.071156,0.98767,-0.13945],[0.28774,0.94001,0.18327],[-0.62881,-0.31451,0.71111],[-0.96987,-0.071793,0.23282],[-0.74214,0.62794,-0.23434],[-0.5393,0.84159,0.029714],[0.68642,-0.51364,-0.51479],[0.85061,-0.41002,0.32915],[0.5597,-0.29571,0.77414],[0.58327,-0.77932,0.22903],[0.13337,0.85506,-0.50108],[-0.016434,0.84454,-0.53523],[0.16531,0.84706,-0.50514],[-0.87105,0.46022,-0.17167],[0.68727,-0.34747,0.63791],[-0.64424,-0.20888,0.73575],[-0.69689,-0.2517,0.67155],[-0.94769,0.31359,0.059613],[0.9091,-0.36608,0.19878],[0.81,0.01019,0.58634],[-0.49082,-0.21867,0.84337],[0.57043,0.061808,0.81902],[0.84014,-0.1854,0.50971],[0.39656,0.32189,0.85972],[0.64884,0.75257,-0.11245],[0.52574,0.8172,-0.23619],[0.71438,0.69586,0.073789],[-0.91915,0.38527,0.082079],[0.83479,0.2043,0.51127],[-0.86739,0.45779,0.19509],[0.76367,0.64492,0.029723],[-0.33924,0.64166,0.68789],[-0.20331,0.95433,0.21891],[0.53372,-0.036128,0.84489],[0.52028,-0.61389,0.59368],[-0.2747,0.945,0.17754],[0.53436,0.02668,0.84484],[-0.08251,-0.66754,-0.73999],[0.68123,0.69145,0.24044],[0.52948,0.061126,0.84612],[-0.66054,0.032589,0.75008],[-0.69594,0.61309,0.37389],[0.58146,0.22356,0.78226],[0.04359,-0.68568,-0.72659],[0.63491,0.58784,0.50133],[-0.74679,-0.57876,0.32763],[0.67171,0.54261,0.50436],[0.60197,0.60123,0.5255],[-0.45747,-0.6033,0.65326],[-0.81954,-0.1664,0.54833],[0.4292,0.6501,0.62702],[0.48915,-0.11403,0.86471],[-0.60553,0.67414,0.42293],[-0.45399,-0.18222,0.87217],[0.52538,-0.22987,0.81923],[0.79693,-0.25446,-0.54786],[0.24032,0.63949,0.73027],[0.82778,-0.28914,-0.48081],[0.57694,0.12291,0.80748],[0.46983,0.058682,0.8808],[-0.37838,0.3007,0.87545],[-0.65224,0.71202,-0.26003],[0.14666,0.59459,0.79054],[-0.48375,0.64439,0.59224],[0.50499,-0.62954,0.59048],[0.39967,0.1144,0.90949],[-0.19978,0.43322,0.87887],[-0.070937,0.49018,0.86873],[0.44537,0.21422,0.86934],[-0.45361,-0.34691,-0.82091],[0.25738,0.43919,0.86074],[0.72543,-0.27406,0.63138],[0.26579,0.952,0.15182],[-0.12526,0.6196,0.77486],[-0.048216,0.58586,0.80897],[0.63709,-0.59329,-0.49206],[-0.62352,-0.20048,0.75566],[-0.16165,-0.96463,-0.20825],[0.085119,-0.99406,-0.067883],[0.23129,-0.96883,-0.088702],[0.049919,-0.98916,-0.13809],[-0.22105,-0.94538,-0.23957],[0.34092,-0.8778,0.33652],[-0.70114,-0.24501,0.66961],[-0.34979,-0.91247,0.21223],[0.76935,0.56492,0.29827],[0.57518,-0.81462,0.074542],[-0.44544,-0.89336,0.058993],[0.4385,-0.89746,0.047716],[0.80786,-0.34823,-0.4755],[-0.95695,-0.053749,0.28524],[-0.46438,-0.8809,-0.091469],[0.47878,-0.87337,0.089457],[-0.10373,-0.82463,-0.55609],[-0.39364,-0.3155,-0.86343],[-0.59356,-0.11461,0.79659],[-0.66189,-0.10811,0.74176],[-0.59872,-0.7887,-0.13962],[0.92685,0.37484,-0.021154],[0.56603,-0.82214,-0.060794],[-0.96285,0.24083,0.12216],[0.26082,-0.83301,-0.48792],[0.49217,-0.73344,-0.46886],[-0.71627,-0.69751,-0.020731],[0.62661,-0.17092,0.76036],[-0.47206,0.11729,0.87373],[-0.40982,-0.73275,-0.54326],[-0.96412,-0.1621,-0.21023],[-0.75582,-0.62869,0.18299],[0.60441,-0.70764,-0.36598],[0.90857,-0.27974,-0.31022],[-0.39759,-0.85771,-0.32597],[0.46178,-0.70794,-0.5344],[-0.71707,-0.62139,0.31574],[-0.46306,-0.28124,-0.84053],[-0.20428,-0.48109,0.85254],[-0.56942,-0.67824,-0.46449],[0.20874,-0.879,-0.4287],[0.18059,-0.91055,-0.37187],[-0.37657,0.20137,0.90424],[-0.71756,-0.6353,0.28547],[0.73254,-0.35732,-0.57941],[-0.62383,-0.50057,-0.60022],[0.40512,-0.85941,-0.3119],[-0.19922,0.96726,0.15724],[-0.20591,-0.97795,-0.034732],[-0.044772,-0.48058,0.87581],[-0.68532,-0.71313,0.14758],[0.77981,0.12343,0.61373],[0.80122,-0.53244,-0.27304],[-0.38696,-0.92055,-0.05339],[0.31162,-0.94902,0.047548],[-0.5646,0.13017,0.81503],[0.3991,-0.91679,-0.01506],[-0.53687,0.57544,0.61695],[0.71128,-0.60336,-0.36061],[0.37344,0.2235,0.90033],[0.5419,-0.83733,-0.072276],[-0.71692,0.090795,-0.69122],[0.22319,-0.94067,0.25559],[0.75735,-0.54811,-0.35497],[-0.7782,-0.62083,0.094763],[-0.049572,0.99072,0.12653],[0.9175,-0.33607,-0.21273],[-0.60673,-0.41747,0.67646],[0.62849,-0.70618,-0.32606],[-0.49151,0.71953,-0.4906],[0.68386,-0.64397,-0.34297],[0.54107,-0.81775,-0.19627],[0.2875,0.12275,0.94988],[-0.25738,0.65193,0.71326],[-0.86147,0.36781,0.35013],[0.71756,-0.088523,0.69085],[-0.40445,-0.90937,0.097267],[-0.23943,-0.95775,-0.15936],[-0.42954,0.28787,0.85594],[0.59033,-0.519,0.61818],[0.53578,-0.79083,-0.29585],[0.20561,0.75769,0.61938],[-0.77015,0.1348,-0.62345],[0.70978,-0.63289,-0.30929],[-0.32327,-0.804,0.49908],[0.88393,-0.37193,-0.28343],[-0.76899,-0.17187,0.61573],[-0.91315,-0.24984,0.32208],[-0.86989,-0.44704,0.20843],[-0.088747,-0.97779,0.18988],[0.036267,-0.85867,0.51124],[0.75346,-0.54122,-0.37334],[-0.62928,0.020854,-0.7769],[0.097528,-0.98892,-0.1119],[0.85664,-0.44368,-0.26329],[-0.29236,-0.70239,0.64898],[-0.58873,-0.34008,-0.73331],[-0.79634,0.17859,-0.57788],[0.84655,-0.49582,-0.19369],[0.99361,-0.047582,-0.10238],[-0.6639,-0.74775,0.010163],[0.92234,-0.3318,-0.19799],[-0.62497,0.16459,0.7631],[0.99721,0.06297,0.039991],[-0.6174,-0.66634,0.41809],[-0.74983,0.1938,-0.63261],[0.75217,-0.59849,-0.27578],[-0.17529,-0.97781,0.11469],[-0.74457,-0.081189,-0.66259],[0.78764,-0.61474,-0.041461],[0.97105,-0.14786,-0.18759],[-0.84465,-0.43804,-0.3077],[0.80077,-0.52987,-0.27929],[-0.74609,-0.053559,-0.66369],[0.9725,0.06759,-0.22286],[-0.88486,-0.24793,-0.39441],[-0.43724,0.60449,0.66589],[0.79545,-0.45259,-0.40302],[0.64615,0.45233,0.61472],[0.7421,-0.45901,-0.48847],[-0.1507,-0.33325,0.93072],[-0.87909,-0.077662,0.47029],[-0.10981,-0.3779,0.91931],[0.95473,-0.099703,-0.28028],[-0.70728,-0.013082,-0.70681],[0.95061,-0.21334,-0.22545],[0.4479,-0.6939,0.56381],[0.33554,-0.89999,0.27827],[0.59185,0.63993,0.4901],[-0.18443,0.34766,0.9193],[0.86308,-0.43955,-0.24877],[0.99569,-0.09235,0.0084441],[-0.87044,-0.4883,-0.062458],[0.75055,-0.65952,-0.041366],[-0.82517,0.091204,-0.55747],[-0.92115,0.19876,0.33464],[0.88814,0.39764,0.23043],[-0.51883,-0.82528,0.22298],[0.99309,0.11543,-0.020981],[-0.1267,-0.95225,0.2778],[0.62358,-0.77399,0.10991],[0.50261,-0.84289,0.19214],[0.17353,-0.82643,0.53563],[0.54335,-0.71965,0.43229],[-0.77392,-0.04271,-0.63184],[0.2018,0.82042,0.53496],[0.46826,-0.67512,-0.57004],[0.95865,0.27915,-0.055336],[0.89559,0.33816,0.28908],[0.92092,0.35726,0.15578],[0.19596,-0.55932,0.80546],[0.97511,-0.21937,-0.03209],[-0.7796,0.031685,-0.62547],[-0.10407,-0.994,0.033557],[0.9012,0.43234,0.030364],[0.97816,-0.030529,-0.20562],[0.88742,0.46079,-0.012432],[-0.79925,0.068109,-0.59712],[0.91686,0.28012,-0.28444],[-0.66239,-0.70346,-0.25764],[0.7149,0.14736,0.68352],[0.29039,0.30809,0.90596],[-0.98409,-0.13934,-0.11022],[-0.47364,0.35287,0.80694],[-0.64214,-0.20755,-0.73795],[-0.71551,0.58725,0.37839],[-0.55837,0.065451,0.82701],[-0.99268,0.12074,0.00040933],[-0.73167,0.13701,-0.66775],[0.081888,-0.99436,0.067332],[0.47245,0.87122,0.13328],[0.74046,0.60534,-0.29203],[-0.0072614,0.052837,0.99858],[0.49518,-0.66877,0.55457],[-0.41136,-0.68545,0.60078],[-0.68488,0.10838,-0.72055],[0.66916,0.72562,-0.16029],[0.81145,0.56404,0.15299],[-0.13061,0.4135,0.90109],[-0.095517,-0.99501,0.028698],[-0.69751,-0.33186,0.6351],[0.88507,0.30161,0.35452],[-0.37533,0.7893,0.48593],[0.25045,-0.60478,-0.75599],[0.38868,0.88114,0.26928],[-0.5073,-0.17964,-0.84284],[-0.1288,0.81006,0.57203],[0.39747,0.23917,0.8859],[-0.18804,0.81831,0.54315],[0.21176,0.90111,0.37836],[-0.083158,0.12651,0.98847],[0.10646,0.9713,0.21269],[0.12817,0.98305,0.13106],[-0.065402,-0.99715,0.037553],[-0.11351,0.84268,0.52632],[-0.0051473,0.80213,0.59712],[-0.95309,-0.28826,-0.092284],[-0.54776,-0.7505,0.36973],[0.03458,0.88596,0.46247],[-0.8936,0.40458,-0.19443],[-0.53914,-0.13548,-0.83125],[0.81556,-0.043838,0.57701],[-0.15166,-0.94349,-0.29465],[0.93036,-0.012537,-0.36643],[-0.57085,-0.14253,0.80859],[0.81351,0.11491,0.57008],[0.57187,-0.39223,0.7205],[0.49831,-0.72454,0.47616],[0.81194,0.044686,0.58203],[0.96253,0.23805,-0.1299],[-0.65453,0.44575,-0.61066],[-0.36743,0.59113,-0.71802],[-0.21303,0.84417,-0.49194],[0.83339,0.18273,0.52161],[-0.69778,-0.123,-0.70567],[0.9336,0.35499,-0.048669],[-0.69147,0.71924,-0.067581],[0.087588,-0.86769,-0.48933],[0.98673,0.16204,0.010608],[0.80441,0.33664,0.4895],[0.51687,0.37324,0.77041],[-0.036654,-0.99916,0.018549],[-0.73864,0.45354,0.49871],[0.7558,0.36168,0.54586],[0.88195,0.012114,-0.47119],[0.31112,-0.85955,-0.40543],[-0.80986,0.58622,0.02167],[-0.77017,0.33474,0.54295],[-0.872,0.47666,0.1114],[-0.96388,0.26536,0.022843],[-0.62545,0.68335,0.37663],[0.72853,0.31961,0.60588],[0.19602,0.80489,0.56011],[-0.99491,0.024938,0.097649],[-0.63235,0.36524,0.68318],[-0.98785,-0.0081216,0.15521],[-0.30318,-0.86146,0.40739],[0.72494,0.332,0.60353],[-0.38756,-0.83523,-0.39012],[-0.86021,-0.32665,0.39159],[0.68803,-0.6964,0.20403],[0.54353,-0.18919,0.81779],[-0.60705,-0.015285,0.79452],[0.6229,-0.76684,0.15476],[0.0080122,-0.99872,0.04987],[0.72129,-0.62416,0.30028],[-0.28288,0.43215,0.85629],[-0.62199,-0.51055,0.59369],[0.5972,-0.66382,-0.45022],[0.74847,-0.62259,0.22839],[0.88384,-0.39663,0.24801],[-0.30353,0.48539,0.81992],[0.32779,0.71156,0.62148],[-0.064034,-0.99767,0.023564],[-0.11957,0.55671,0.82205],[0.15688,-0.97678,-0.14592],[0.26303,0.58201,0.76947],[-0.71846,-0.42017,0.55431],[0.89541,-0.32789,0.30119],[-0.74886,0.56369,0.34851],[0.22756,-0.94025,0.25329],[-0.7214,0.027091,0.69199],[0.33948,0.85301,-0.3964],[0.09827,0.98827,-0.11689],[-0.066574,0.97001,-0.23375],[-0.29493,0.93244,-0.20874],[0.76646,-0.60436,-0.21745],[0.56844,-0.18558,0.80152],[-0.69756,-0.17891,0.69383],[-0.60724,-0.64052,-0.4701],[-0.98354,-0.16022,-0.083517],[0.46447,0.77566,-0.42734],[-0.58334,0.79077,-0.18547],[0.11334,-0.4895,0.86461],[0.62209,0.40282,0.67138],[-0.72243,-0.048593,0.68974],[0.042545,0.85221,-0.52147],[-0.63052,-0.71891,-0.29258],[0.20735,0.89262,-0.4003],[0.92025,-0.14337,-0.36411],[0.28696,-0.44098,0.85041],[-0.67496,-0.4701,-0.56872],[0.89937,-0.059466,0.43313],[0.23131,0.88403,-0.40619],[0.59631,0.087579,0.79796],[0.28295,0.84485,-0.45405],[0.0024489,0.85769,-0.51417],[0.77134,0.13279,0.62242],[0.288,-0.63201,0.71946],[-0.92615,0.37106,-0.067526],[0.74726,-0.21134,-0.63003],[0.58953,-0.11729,0.79919],[-0.60469,-0.060024,-0.7942],[0.57065,-0.080846,0.8172],[-0.36802,0.30104,0.87973],[0.33633,0.90331,-0.26631],[0.50048,-0.0021538,0.86575],[0.56365,-0.036156,0.82522],[-0.66975,-0.049181,0.74096],[-0.69143,0.66054,0.29258],[0.61173,-0.078147,0.7872],[0.62658,0.77936,0.00043898],[0.53775,-0.0029711,0.8431],[-0.98725,-0.063142,0.1461],[-0.01441,0.70756,0.70651],[0.5999,0.091924,0.79478],[0.80596,0.0098873,-0.59189],[0.45718,0.747,0.48267],[0.5846,0.051007,0.80971],[-0.92731,0.021018,-0.37371],[0.57335,0.75246,0.32416],[0.65236,0.22008,0.72525],[0.5738,0.77488,0.26517],[0.10373,-0.079543,0.99142],[0.70784,-0.041531,0.70515],[-0.63798,-0.079373,0.76595],[-0.46732,-0.17059,0.86747],[-0.57288,0.64078,0.51109],[0.51402,0.099405,0.852],[-0.77259,0.63216,0.059025],[-0.52237,0.17302,0.83498],[-0.21431,0.74412,0.63274],[-0.87103,-0.10487,0.4799],[0.8668,-0.26475,-0.42257],[-0.34214,0.76255,0.54905],[0.54286,0.50866,0.66825],[-0.52841,0.3201,0.78633],[0.13214,0.9908,-0.029315],[0.98469,0.13671,0.10816],[0.090412,0.55106,0.82955],[-0.099024,-0.51964,0.84863],[-0.49705,0.66541,0.55693],[0.84632,-0.34706,-0.4041],[-0.33123,0.32266,0.88667],[0.97997,-0.0021089,-0.19912],[-0.34688,0.64292,0.68288],[0.28283,0.31029,0.9076],[-0.49828,0.058651,-0.86503],[-0.55795,0.16512,0.81328],[-0.11305,0.55134,0.82658],[-0.042911,0.51914,0.85361],[-0.80081,0.52735,0.28391],[0.057695,0.50793,0.85946],[-0.19544,-0.97375,-0.11667],[-0.062879,-0.99465,0.081945],[0.36731,-0.91695,0.15583],[0.61747,-0.63316,0.46673],[-0.27033,-0.96249,0.023285],[-0.081031,-0.99551,-0.0489],[-0.11449,-0.9408,-0.31904],[-0.23202,0.82594,0.5138],[0.46255,-0.87545,0.14011],[-0.90309,0.088228,-0.42029],[-0.7909,-0.35165,-0.50083],[-0.25233,-0.96144,0.10936],[-0.71854,0.087667,0.68994],[0.33983,-0.90728,-0.2477],[0.67698,-0.3567,0.64379],[0.36988,-0.87864,-0.30196],[-0.95706,-0.086232,-0.27676],[-0.35412,-0.73007,-0.58446],[-0.23514,-0.86043,-0.45207],[-0.10564,-0.89505,-0.43327],[0.10921,-0.86591,-0.48813],[-0.14788,-0.98374,0.10193],[-0.64843,-0.75886,0.060595],[0.48358,-0.77103,-0.41432],[-0.9183,0.17241,0.35637],[0.44754,-0.82774,-0.33847],[0.83594,-0.20297,-0.50991],[-0.69157,0.19053,0.69672],[0.71995,0.19583,0.66583],[0.9224,0.38583,-0.017656],[-0.39628,-0.80719,-0.43749],[0.65288,-0.69262,-0.30664],[-0.19625,-0.70982,-0.6765],[-0.29684,-0.85556,-0.42416],[-0.69764,0.26527,0.66553],[0.80375,0.56744,0.1789],[0.1749,0.24141,0.95453],[-0.42626,-0.53825,-0.72704],[-0.27007,0.11952,0.95539],[0.34255,0.1419,0.92872],[0.35725,-0.74787,-0.55952],[0.46987,-0.78874,-0.39638],[-0.86672,-0.38481,0.31737],[0.63229,-0.694,-0.34434],[0.079316,0.76255,0.64205],[0.27832,0.82017,0.49986],[-0.54376,-0.31816,-0.77659],[0.89648,-0.39895,-0.19278],[0.45195,-0.88202,-0.13335],[0.57723,-0.7911,-0.2024],[0.63902,0.37357,0.67238],[-0.61568,-0.74972,0.24262],[0.68046,-0.62186,-0.38764],[-0.32115,-0.94593,0.045599],[-0.34097,0.49608,0.79852],[-0.74755,0.39775,0.53194],[0.99846,-0.035379,-0.042644],[-0.99835,0.037777,-0.043187],[0.77509,-0.43445,-0.45879],[-0.50509,-0.86137,-0.054145],[0.23638,-0.597,0.76663],[-0.94075,-0.06329,0.33313],[0.59142,-0.77137,-0.23496],[-0.56796,0.24333,-0.78626],[0.36776,0.68704,0.62668],[-0.59535,-0.80346,0.0005662],[-0.96474,0.20287,0.16767],[0.89228,-0.37224,-0.25549],[-0.72685,-0.68461,0.054768],[-0.30604,0.81685,-0.48898],[0.72418,-0.074225,0.68561],[-0.99812,-0.054443,-0.02829],[0.97534,-0.10103,0.19621],[0.59841,-0.35458,0.71846],[0.63256,-0.74439,-0.21391],[-0.416,0.74815,-0.51693],[-0.67709,0.53985,-0.5001],[-0.69185,-0.70978,0.13249],[-0.27494,0.89625,0.34805],[-0.57387,0.62265,0.53196],[-0.84578,-0.5318,-0.042843],[0.69282,-0.65648,-0.29838],[0.86844,-0.29176,-0.40085],[0.0074318,0.74263,0.66966],[-0.86372,0.14681,-0.48211],[-0.82412,-0.019201,-0.56609],[0.94867,-0.24896,-0.19502],[0.71434,0.69203,0.104],[0.34278,0.39252,0.85348],[-0.11639,-0.17819,0.97709],[-0.73438,-0.67627,-0.057913],[-0.53297,0.56949,0.6258],[0.90786,-0.39839,-0.13065],[-0.80509,0.040473,0.59177],[0.71468,-0.29529,0.63407],[-0.51243,0.29816,0.80531],[-0.77232,0.23622,-0.58968],[0.9753,-0.02456,0.2195],[-0.78222,-0.59206,-0.1939],[0.92992,-0.10694,-0.35186],[0.79086,-0.60381,-0.099746],[-0.96935,-0.13899,0.20257],[0.829,-0.5307,-0.1764],[0.96186,0.22486,-0.15577],[-0.5325,0.62326,0.5727],[0.42496,0.85908,0.2853],[-0.88909,-0.12134,0.44137],[0.96802,-0.20763,-0.1408],[0.85048,-0.50768,-0.13761],[0.0070064,0.82631,0.56318],[-0.72278,-0.00032877,-0.69108],[0.41401,0.90802,-0.063985],[0.95977,0.19081,0.20601],[0.20417,0.97207,0.11574],[0.91986,-0.36378,-0.14667],[-0.84005,-0.47883,-0.25503],[0.31238,0.75527,0.57619],[-0.66449,0.32612,-0.67238],[0.84323,-0.41882,-0.33698],[-0.75681,0.048307,-0.65184],[0.81148,0.36161,-0.45905],[-0.87829,-0.44484,-0.17528],[0.079301,0.76944,0.63378],[0.30845,-0.5119,-0.80176],[0.95764,0.26697,-0.10798],[-0.0035995,0.79113,0.61164],[0.83504,0.54083,-0.10105],[0.93358,-0.2877,-0.2137],[-0.72508,0.13836,-0.67462],[0.99786,-0.047874,-0.044647],[0.83388,-0.12769,-0.53698],[-0.90032,0.046006,0.43278],[0.1251,-0.33923,0.93235],[0.19418,0.84492,0.49841],[0.78162,0.6187,-0.079236],[0.7332,-0.67993,0.010288],[-0.79489,-0.60676,-0.00052969],[0.8144,-0.54591,-0.19684],[0.5302,0.49813,0.68612],[-0.016406,-0.94067,0.33892],[0.78312,0.090993,0.61518],[0.90244,0.258,0.34503],[-0.76586,0.49231,-0.41362],[0.8972,0.39709,0.19329],[-0.28151,-0.95494,-0.094013],[-0.11626,-0.99204,0.048448],[-0.025692,-0.98694,0.15904],[-0.92888,-0.042002,0.368],[0.29549,-0.90858,0.29524],[0.13724,0.97398,-0.18033],[-0.94882,-0.31441,-0.029853],[-0.55116,-0.80763,-0.20963],[0.27256,-0.8735,0.40336],[0.65791,-0.10323,0.74599],[0.47751,-0.26563,0.83751],[-0.81894,0.3843,0.4262],[-0.86943,-0.37864,-0.31736],[0.70449,-0.61505,0.35411],[0.95723,0.28927,-0.0053099],[0.95858,0.24623,-0.14314],[0.7207,0.31919,0.61539],[-0.94732,-0.22298,-0.22994],[0.17026,0.90454,-0.39092],[-0.74503,0.51943,0.41848],[0.96064,0.16053,-0.22671],[-0.11645,0.81816,0.56308],[0.71037,-0.063988,0.70091],[0.97487,0.027096,-0.22114],[0.11907,-0.98629,0.11428],[-0.3569,0.77144,0.52679],[0.68991,0.72388,0.0043706],[-0.98504,-0.082855,-0.15108],[-0.73265,0.6132,0.29532],[-0.82754,-0.003756,-0.56139],[0.81329,0.51216,-0.27613],[-0.76457,0.52546,0.37326],[0.52757,0.84824,0.046459],[0.25454,0.7321,0.63185],[-0.53665,0.59384,0.59947],[0.43822,0.89476,-0.085887],[0.46619,0.87065,-0.15695],[0.30643,0.14915,0.94014],[0.30238,0.92941,0.21156],[-0.42368,0.29096,0.85781],[-0.40107,-0.3598,0.84243],[-0.99259,0.075427,-0.095283],[-0.65147,0.10143,-0.75187],[-0.84496,-0.1534,0.51236],[-0.7385,0.5972,0.313],[0.55167,0.79156,0.26286],[0.56041,0.77972,0.27925],[0.32612,0.90942,0.25806],[-0.81571,0.47493,-0.33026],[0.77417,0.62985,-0.062802],[-0.53798,0.64954,0.53728],[0.82141,0.19281,0.53675],[0.15464,0.85738,0.49091],[0.094652,0.88131,0.46297],[-0.047205,0.86811,0.49413],[-0.30231,0.76489,0.56882],[-0.52341,0.66282,0.53545],[-0.97668,-0.0099499,-0.21449],[0.21221,-0.32525,0.92151],[-0.45836,-0.1495,-0.8761],[0.05505,0.82562,0.56154],[-0.36207,0.71236,0.6012],[-0.80443,0.36079,-0.47193],[0.95241,0.13828,-0.27164],[-0.43364,-0.17384,-0.88416],[0.8785,0.30636,0.36657],[0.60245,0.027112,0.79769],[-0.69963,0.70735,-0.10083],[-0.064166,0.83738,0.54285],[-0.54491,0.54058,0.64097],[-0.69178,0.35415,0.6293],[-0.013809,0.96701,0.25438],[0.1922,0.9795,-0.060341],[-0.9605,0.18754,-0.20561],[0.53645,0.4686,0.70188],[0.95016,0.31161,0.010252],[-0.6629,0.37316,0.64909],[0.94669,0.037124,-0.32],[-0.57763,0.71119,0.40069],[0.80884,0.38047,0.44836],[-0.51664,0.031908,-0.85561],[0.82207,0.2629,0.50506],[-0.94256,0.32182,-0.089495],[-0.6366,0.23348,-0.735],[0.90959,-0.10276,0.4026],[-0.51941,0.84847,0.10156],[0.97223,0.071098,-0.22297],[-0.95276,0.17029,-0.25151],[0.83096,0.092182,0.54865],[-0.93558,0.24804,-0.25132],[0.90056,0.42453,-0.093653],[-0.32227,0.77841,-0.53872],[-0.8997,0.00013533,0.4365],[0.40427,0.77955,-0.47841],[0.86409,0.23818,0.44343],[-0.3275,0.21944,0.91902],[-0.21716,0.88573,-0.41027],[-0.6842,0.34719,0.64135],[-0.79351,0.59618,-0.12214],[0.80605,0.29577,0.51265],[-0.80997,0.58117,-0.078734],[-0.72196,0.68884,0.06536],[-0.50764,0.36137,0.78212],[-0.51651,0.83862,0.17299],[0.99483,-0.051447,0.087591],[0.98845,-0.0052268,0.15147],[-0.16203,0.86642,-0.47229],[-0.80586,0.59149,-0.027058],[-0.73714,0.6339,0.23409],[0.65193,-0.70609,0.27645],[0.46432,0.73506,-0.49407],[-0.44212,0.89178,0.096236],[0.75846,0.28227,0.58742],[-0.42525,0.46512,0.77642],[-0.31946,0.9437,-0.085844],[0.71784,-0.66152,0.21704],[0.93908,0.21442,-0.26861],[-0.32577,0.4027,0.8554],[0.55313,0.75122,0.36016],[0.5654,0.38291,0.73055],[-0.72852,-0.47744,0.49124],[0.71367,-0.58206,0.38972],[0.87733,0.47884,0.031561],[-0.04009,0.92239,-0.38418],[-0.35672,0.44053,0.82382],[0.57442,0.36069,0.73481],[-0.47779,0.63233,0.60981],[0.20435,-0.52195,-0.82814],[0.067273,-0.34653,0.93562],[-0.41861,0.47086,0.77657],[-0.3842,-0.016536,0.9231],[0.60952,-0.53343,0.58647],[-0.67978,0.052862,0.73151],[0.42466,0.6252,0.65482],[0.07091,0.87526,-0.47842],[0.59281,-0.33342,0.73308],[0.89447,0.31303,-0.31926],[0.14302,0.73216,0.66594],[0.63687,-0.224,0.73772],[0.92753,0.26698,-0.26156],[0.5677,-0.63593,0.52279],[0.61001,-0.14764,0.77852],[0.8007,-0.41333,0.43364],[-0.899,0.28921,-0.32886],[0.61394,-0.72029,-0.32289],[-0.30682,-0.88951,0.33858],[0.15387,0.94735,-0.2808],[0.044222,0.98207,-0.18324],[-0.12319,0.97809,-0.1678],[-0.50407,0.50922,0.69757],[-0.60202,0.31639,0.73312],[-0.69746,-0.068114,0.71338],[0.40159,-0.64745,0.64772],[0.40024,0.86185,-0.31148],[-0.80952,0.56877,-0.14552],[-0.27665,-0.22625,0.93396],[0.042876,0.94273,-0.3308],[0.065919,0.94517,-0.31987],[-0.8506,0.3412,-0.40007],[-0.64797,0.44884,0.61537],[0.24251,0.93643,-0.25353],[-0.86815,0.49287,0.058264],[-0.086197,0.58447,0.80683],[0.51071,0.85238,-0.11241],[0.23868,0.95596,-0.17078],[0.40261,0.15762,0.9017],[-0.88239,0.34458,-0.3204],[-0.041089,0.52412,0.85065],[-0.82236,0.53031,0.20615],[0.6174,-0.018642,0.78643],[-0.59031,0.08002,0.8032],[-0.092607,-0.46909,-0.87828],[0.61976,0.77264,0.13756],[-0.69605,0.18129,0.69473],[0.8135,-0.45899,-0.35713],[-0.92389,-0.22313,-0.31087],[-0.9919,-0.127,0.0018312],[0.86604,-0.36168,-0.34518],[0.74603,0.22955,0.6251],[-0.90631,-0.061338,0.41815],[0.50527,0.096056,0.8576],[0.64277,0.09991,0.75952],[0.69242,0.65111,-0.31082],[0.94697,0.1862,0.26189],[0.58863,0.70451,0.39645],[0.8415,-0.41927,-0.34072],[-0.84492,-0.45814,-0.27608],[0.16925,0.70297,0.69079],[0.31211,0.73368,0.60357],[0.38717,0.19074,0.90206],[-0.8678,0.076859,0.49093],[-0.058051,0.48214,0.87417],[0.071875,0.53731,0.84032],[0.95434,-0.27111,0.12543],[-0.40461,0.64024,0.65298],[-0.63022,-0.55194,0.54606],[0.40589,-0.89681,0.17604],[0.28935,0.86388,0.41229],[-0.306,-0.36285,-0.88017],[-0.11786,-0.50232,-0.85661],[-0.18788,0.56801,0.80129],[-0.029051,-0.43637,-0.8993],[0.25951,0.3011,0.9176],[0.15237,-0.42308,0.89319],[-0.56281,0.30467,0.76839],[0.097422,-0.49166,-0.86532],[-0.6621,-0.010488,0.74934],[0.057689,0.43557,0.89831],[0.63052,-0.64169,0.43667],[0.15601,0.39726,0.90435],[-0.8241,-0.53932,0.17316],[-0.73558,0.3926,0.55207],[-0.073794,-0.97514,-0.20896],[-0.0046518,-0.2156,0.97647],[0.24026,-0.94205,0.23414],[-0.20767,-0.93595,-0.28437],[-0.88121,-0.21017,0.42343],[-0.56228,0.59034,0.57909],[-0.43653,-0.88692,0.15103],[0.89684,-0.21324,0.38757],[0.90095,-0.26749,-0.34167],[-0.37928,-0.88417,0.27275],[0.44348,-0.88219,-0.15832],[0.28014,0.39883,0.87319],[0.59297,0.27563,0.75658],[0.23329,0.090481,0.96819],[-0.26407,-0.66346,-0.70007],[0.9673,-0.10063,0.23284],[0.043118,-0.67934,-0.73255],[-0.85605,0.20955,0.47251],[0.46704,-0.78576,-0.40553],[-0.26156,-0.64799,-0.71533],[0.4804,-0.80136,-0.35642],[-0.77537,-0.63009,0.04224],[0.63965,-0.6819,-0.35476],[0.2555,-0.52325,-0.81298],[-0.43754,-0.34097,0.83204],[-0.96634,0.21379,0.14309],[-0.87549,0.22537,0.42747],[-0.47059,-0.58632,-0.65937],[-0.27707,-0.61568,-0.73768],[0.94487,0.0057508,0.3274],[-0.83412,-0.51301,0.20264],[0.60833,-0.73068,-0.30991],[-0.051527,-0.35756,-0.93247],[-0.52622,-0.41023,-0.74485],[0.41938,-0.888,-0.18864],[-0.0044584,-0.41726,-0.90878],[-0.53794,-0.80764,0.24155],[0.84691,-0.4036,-0.34619],[0.21616,-0.45695,-0.86283],[0.20662,-0.97528,0.078299],[-0.60222,-0.11795,-0.78957],[-0.44092,-0.88268,0.16268],[-0.17861,-0.98387,-0.0096],[0.49357,-0.3461,-0.79787],[-0.090053,-0.17041,0.98125],[-0.51077,-0.81555,0.272],[0.47418,-0.86118,0.1831],[0.24834,-0.94581,0.20922],[-0.59506,0.099766,-0.79746],[0.61958,-0.58878,-0.51909],[-0.6609,-0.74101,-0.11883],[0.94492,-0.27686,-0.17456],[0.47799,-0.84914,0.22468],[0.88248,0.40489,-0.23936],[-0.43849,0.14356,-0.8872],[-0.61346,0.39062,-0.68635],[0.91394,-0.33085,-0.23508],[0.59429,-0.80265,0.050807],[-0.66836,0.73671,0.1027],[-0.32011,0.56781,-0.75837],[0.67723,-0.57692,-0.45665],[-0.90194,0.14241,0.4077],[0.007142,-0.16583,0.98613],[-0.51927,-0.81662,-0.25198],[-0.38502,0.74635,-0.54288],[0.49292,-0.85393,-0.16682],[0.50622,-0.61222,0.60739],[-0.5454,-0.83777,-0.025985],[-0.44482,-0.87856,-0.17396],[-0.76902,-0.6335,0.085357],[-0.28387,0.80423,-0.52214],[0.0096762,-0.21873,0.97574],[0.019057,-0.49758,0.86721],[0.61911,-0.78002,-0.090965],[-0.10275,-0.38058,-0.91902],[0.025256,-0.33006,-0.94362],[-0.89506,-0.44586,0.0081914],[0.019406,0.16579,0.98597],[0.091849,-0.30707,-0.94724],[0.83117,-0.54242,-0.12222],[-0.96603,-0.17065,0.19405],[0.9629,-0.10609,-0.24814],[-0.8175,-0.55937,-0.13713],[0.15317,-0.36968,-0.91645],[-0.85893,0.020449,-0.51169],[0.86505,-0.47688,-0.1558],[-0.23981,-0.38181,-0.89259],[-0.92531,-0.11283,0.36204],[-0.68491,-0.72828,0.022686],[-0.72917,-0.071875,0.68055],[0.94821,-0.29115,0.12701],[-0.81734,0.12065,-0.56339],[0.98777,0.10347,-0.11662],[-0.74098,-0.67064,0.034357],[-0.25757,-0.38876,-0.88461],[-0.70958,-0.053607,-0.70258],[0.78114,-0.57123,-0.25204],[0.99911,-0.041763,-0.0066506],[0.67827,-0.72856,0.095627],[0.73023,-0.28505,0.62089],[0.94488,-0.32429,0.045164],[0.66534,-0.21501,-0.71491],[-0.88409,-0.46722,-0.0096911],[0.8105,-0.56489,-0.15488],[-0.35067,0.16586,0.9217],[-0.71582,-0.10424,-0.69046],[0.74987,-0.63728,-0.17768],[-0.91659,0.28679,-0.27858],[-0.6679,0.041089,-0.74311],[0.99372,0.030636,0.10762],[0.80872,-0.40397,0.42753],[-0.94491,-0.22999,-0.23291],[0.99256,0.12057,0.016728],[-0.73565,0.04785,-0.67567],[-0.46556,-0.48848,-0.73799],[0.64211,0.15837,0.75008],[-0.78791,0.074231,0.61131],[-0.86386,0.080331,-0.49729],[0.93881,-0.30925,-0.15166],[-0.19116,-0.63781,-0.7461],[0.93711,-0.032409,0.34752],[-0.89209,-0.068108,0.4467],[-0.037723,-0.39439,-0.91817],[-0.93861,-0.30199,-0.16677],[0.83235,-0.46674,-0.29893],[-0.94524,0.23446,0.22703],[-0.83075,0.043663,-0.55494],[-0.9547,-0.25004,-0.16131],[-0.83237,-0.4375,0.34022],[-0.051175,-0.69167,-0.7204],[-0.65351,-0.070854,0.7536],[-0.14177,-0.25336,0.95693],[-0.7366,0.077,-0.67194],[0.74765,0.66365,0.024282],[0.020755,-0.54922,-0.83542],[-0.93897,-0.095318,0.33053],[0.62757,0.13061,0.76753],[-0.31008,-0.61052,-0.72878],[0.99473,0.070018,-0.074943],[-0.82605,0.26417,0.49785],[-0.98746,-0.071693,0.14064],[-0.059627,-0.95461,0.29181],[0.58397,-0.48899,-0.64797],[-0.24777,-0.94344,0.2203],[0.5604,-0.82304,0.092511],[0.45827,-0.85586,0.23977],[-0.040255,-0.24639,0.96833],[-0.91276,0.2625,0.31299],[0.94839,0.2439,0.20263],[-0.59555,-0.7422,-0.30734],[0.27703,-0.90524,0.32217],[0.93079,0.23128,-0.28311],[0.89728,-0.42473,0.12042],[0.98603,-0.10224,-0.13149],[0.92055,0.37187,0.1196],[-0.59005,-0.6256,0.51036],[0.88937,-0.43635,0.13647],[0.94278,0.21763,-0.25259],[0.98392,-0.12404,-0.12854],[-0.81652,0.081564,-0.57153],[-0.65783,0.099711,0.74654],[-0.90168,-0.27321,-0.33515],[0.8207,0.50706,0.26332],[-0.84717,0.045617,0.52935],[0.91246,0.3928,-0.11456],[0.62533,0.74551,0.23061],[0.92483,0.38034,0.0058633],[-0.32381,0.23783,0.91574],[-0.99105,0.10515,0.082284],[-0.66268,0.56917,0.48673],[0.66611,0.69848,-0.26158],[0.50305,-0.66035,-0.55756],[0.16543,0.96019,0.22511],[-0.99479,0.050918,-0.088264],[0.96491,0.11822,-0.23446],[-0.57161,-0.29669,-0.765],[0.61724,0.76245,-0.19412],[0.94558,-0.25694,-0.19967],[-0.009837,0.93559,0.35294],[-0.52102,-0.54775,-0.65461],[0.40966,0.81773,0.40434],[0.44988,0.82681,0.33763],[-0.41801,-0.23323,-0.87799],[0.055846,-0.19334,0.97954],[-0.87669,0.47712,0.061358],[0.19836,0.89272,0.4046],[-0.41362,-0.72132,0.55553],[0.82548,0.56422,-0.01531],[-0.12309,0.84249,0.52446],[-0.19295,0.94576,0.26135],[-0.0011465,0.99485,0.10132],[0.18968,0.98107,0.039],[0.25684,0.95262,0.16292],[0.033972,0.9408,0.33724],[-0.49102,-0.077993,-0.86765],[-0.55618,-0.48815,-0.67259],[-0.91796,0.38797,-0.082669],[-0.56188,0.1479,-0.81389],[-0.85247,0.51602,0.083741],[-0.66952,0.28076,0.68769],[-0.30721,-0.13664,0.94178],[-0.61525,0.47864,-0.6264],[0.78851,0.067913,0.61126],[0.92176,-0.34158,-0.18354],[-0.11542,-0.62871,0.76903],[-0.62471,0.62748,-0.46476],[0.57942,-0.46392,-0.67011],[-0.54747,-0.49311,0.6761],[-0.17413,0.82168,0.5427],[0.65296,0.16354,0.73953],[0.88634,0.4585,-0.064719],[-0.56309,0.79652,-0.22022],[-0.20022,0.8893,-0.41116],[0.12718,0.30308,0.94444],[-0.92869,-0.070637,0.36408],[-0.7683,0.61719,0.16968],[0.96785,0.25068,0.020743],[-0.33809,0.84847,-0.40718],[0.69387,0.37328,0.6158],[-0.49048,0.86387,0.11472],[-0.79537,-0.51343,0.32215],[-0.43642,0.8052,0.40148],[-0.75781,0.65247,0.0013715],[-0.70824,0.41697,0.56967],[0.68883,0.27716,0.66985],[0.16385,0.25676,0.95249],[0.88659,-0.39077,0.2475],[0.54906,0.14914,0.82237],[-0.69454,0.33515,0.63662],[-0.6857,0.32221,0.65268],[-0.0091824,-0.33063,0.94372],[0.79743,0.2546,0.54706],[-0.89075,0.34487,-0.29603],[0.73959,-0.59816,0.30858],[0.7968,-0.27092,-0.54011],[-0.96042,0.23439,-0.15053],[-0.41097,0.52741,0.7436],[-0.021123,-0.31975,0.94727],[0.61585,-0.68246,0.39367],[0.83433,-0.082039,0.54512],[-0.23509,0.48488,0.8424],[0.54974,0.27258,0.78961],[0.71472,-0.64874,0.26138],[-0.21771,0.35937,0.90744],[0.76851,-0.21224,0.60361],[0.37286,0.41842,0.82819],[0.20436,-0.97858,0.024834],[-0.95334,-0.034101,0.29995],[0.48063,-0.50791,-0.71486],[-0.26598,0.44905,0.853],[-0.46232,0.36421,0.80847],[-0.12225,0.23407,0.9645],[0.53327,0.31402,0.7855],[-0.77985,-0.40147,-0.48028],[0.80087,-0.27395,-0.53251],[-0.31519,0.13631,0.93919],[0.61306,0.37608,0.69478],[-0.74359,-0.36125,0.56264],[0.035798,-0.25005,0.96757],[0.67941,-0.35776,0.64064],[-0.96755,-0.097943,-0.23294],[-0.39936,0.51368,0.75937],[-0.12141,0.60069,0.79021],[0.28154,0.67631,0.6807],[-0.49357,-0.49941,0.71203],[-0.62536,-0.46888,0.62376],[0.03914,-0.32537,0.94478],[-0.62771,-0.36205,0.68913],[-0.73526,-0.58884,0.33564],[0.68833,-0.25444,0.67931],[0.96607,0.079616,0.24572],[-0.19092,0.97275,-0.13156],[0.75902,-0.61658,0.20908],[0.65451,-0.19699,0.72994],[0.59771,-0.088643,0.7968],[-0.66293,-0.045576,0.74729],[0.19615,0.92693,-0.31987],[0.93582,-0.07757,0.34384],[0.22729,0.92199,-0.31348],[-0.59188,0.7933,-0.1427],[0.046299,-0.36205,0.93101],[-0.63115,-0.0279,0.77516],[0.68445,-0.62736,-0.37141],[0.48386,0.8165,-0.31498],[0.63017,-0.11027,0.76859],[-0.34173,-0.032818,0.93923],[-0.97486,-0.028131,-0.22105],[0.2757,0.92766,-0.25187],[0.82246,0.22796,0.52115],[0.17409,0.97036,-0.16762],[0.61107,-0.07284,0.78822],[0.959,-0.2615,-0.10929],[-0.19492,0.35078,0.91595],[0.85047,0.35489,0.38828],[0.69805,-0.069751,0.71264],[0.78288,-0.10122,0.61388],[0.47452,0.07034,0.87743],[-0.76562,-0.59972,0.23271],[0.34873,-0.14142,0.92649],[-0.48999,0.1859,0.85167],[-0.49422,-0.86325,0.10276],[0.89226,0.013107,0.45133],[-0.91369,-0.040352,0.4044],[0.94971,-0.30826,0.055014],[-0.4621,0.22228,0.85852],[-0.69817,0.60815,0.37777],[0.96846,-0.0022813,0.24916],[-0.99084,-0.080802,-0.10823],[-0.58715,0.63969,0.49603],[0.77039,-0.42132,0.47853],[0.40917,0.15279,0.89958],[-0.88469,0.20224,0.42002],[0.39292,0.76361,0.51236],[0.50167,0.79221,0.34746],[0.77739,-0.52416,0.34774],[-0.908,0.097815,0.40739],[-0.4381,0.64862,0.62238],[-0.79671,-0.42861,-0.42608],[-0.27362,0.34684,0.89713],[-0.019133,0.5267,0.84983],[-0.8349,-0.22706,0.50139],[-0.0012185,0.61057,0.79196],[0.10069,0.66102,0.74358],[-0.36712,0.38521,0.84666],[-0.014156,-0.31195,0.94999],[-0.082231,0.25807,0.96262],[0.23896,0.29688,0.92453],[0.77795,-0.45197,-0.43649],[-0.19712,0.59141,0.78191],[0.89495,-0.31476,0.31623],[-0.41315,-0.18653,0.89135],[0.97691,-0.18083,0.11382],[0.006246,0.47051,0.88237],[0.92489,-0.34204,0.16607],[0.12472,0.37059,0.92038],[0.26779,0.025088,0.96315],[-0.25121,-0.96602,-0.060896],[0.068883,-0.99758,0.0091098],[-0.0043615,-0.9634,0.26804],[0.77625,-0.60057,-0.19172],[0.19997,-0.937,0.28644],[0.29518,-0.94189,0.16034],[-0.36942,-0.89616,0.24583],[0.30946,-0.88482,-0.34831],[0.96223,-0.16245,0.21844],[-0.24503,0.15929,0.95634],[-0.30067,-0.94571,0.12337],[-0.83963,-0.35614,0.41011],[0.31178,-0.8436,-0.43719],[0.25693,-0.91065,-0.32357],[-0.0629,-0.73297,-0.67735],[-0.050131,-0.86964,-0.49114],[-0.15134,-0.91625,-0.37093],[0.06627,-0.95659,-0.28379],[0.32303,-0.89734,-0.30072],[-0.85354,-0.35841,-0.37817],[-0.8739,-0.29075,0.38957],[-0.46342,-0.86345,0.19924],[0.50923,-0.84043,-0.1854],[-0.22125,-0.57019,-0.79116],[0.9769,-0.01361,-0.21325],[0.65335,-0.74996,-0.10339],[0.3935,-0.83274,0.38948],[-0.23571,-0.70597,-0.66787],[-0.22098,-0.62263,-0.75067],[0.33338,-0.78612,-0.52045],[0.31949,-0.72875,-0.60568],[0.33136,-0.65706,-0.67711],[0.5808,-0.69171,0.4292],[0.55738,-0.64792,-0.51915],[-0.88536,-0.44207,0.1439],[0.65267,-0.75761,-0.0061955],[-0.66223,-0.50059,-0.55755],[-0.3354,0.36959,0.86655],[-0.98305,0.1824,0.018505],[-0.90498,-0.21813,-0.36528],[0.96929,-0.24161,-0.0458],[0.63359,-0.77364,-0.0066663],[0.84571,-0.53227,0.038264],[0.97886,0.070399,0.19204],[-0.69119,-0.71126,0.12792],[-0.88446,-0.29361,0.36266],[-0.75001,-0.28178,-0.59841],[0.48615,0.24122,0.83992],[0.046659,-0.28004,0.95885],[0.99709,-0.062216,-0.044117],[-0.47068,-0.88167,0.033423],[0.14426,-0.98954,0.001566],[0.37459,-0.9259,0.048987],[-0.6782,-0.13729,-0.72194],[0.68214,-0.70589,-0.19079],[0.016343,-0.28445,0.95855],[0.50356,-0.74781,-0.43267],[-0.67406,-0.73863,-0.0081889],[-0.54838,-0.81019,0.20705],[-0.94264,-0.12297,-0.31033],[0.08711,0.22386,0.97072],[0.96216,0.071398,-0.26296],[0.50274,-0.31624,0.80452],[0.55436,-0.62238,-0.55257],[0.040815,-0.47456,0.87928],[0.95248,-0.2949,-0.076268],[0.85384,-0.52042,-0.010887],[0.85712,-0.51252,0.05167],[-0.52791,-0.82164,0.21499],[0.54055,-0.80027,0.25956],[-0.8982,-0.26597,0.34999],[-0.54855,-0.10994,-0.82886],[0.68268,-0.55727,-0.47265],[0.096238,-0.27874,0.95553],[-0.52227,-0.81131,0.2627],[0.45529,-0.80429,0.38188],[0.44262,0.23719,0.86477],[-0.19508,0.43091,-0.88106],[-0.10108,0.27722,0.95548],[-0.54797,-0.80773,-0.21748],[-0.82661,-0.19961,0.52619],[-0.66298,-0.74317,0.090352],[-0.45367,-0.87206,0.18358],[0.53531,-0.75985,0.36889],[0.62235,-0.773,-0.12304],[0.89758,-0.43533,0.069557],[0.85416,-0.44616,-0.26713],[-0.89379,-0.26699,-0.36036],[-0.081262,0.67667,-0.73179],[0.9909,-0.0057598,-0.1345],[-0.79717,-0.59961,0.070668],[-0.16256,-0.31269,0.93584],[-0.3442,0.072558,0.93609],[0.6458,-0.71125,0.27759],[0.96889,-0.21429,-0.12383],[-0.76994,0.1786,-0.61261],[-0.91057,-0.23019,-0.34333],[0.70733,-0.70311,0.072924],[-0.89269,-0.42941,0.13677],[0.71126,-0.66867,-0.21676],[0.89957,-0.27534,-0.33906],[-0.92935,-0.19348,0.31443],[0.8152,-0.5203,0.25444],[0.95692,-0.28909,0.027123],[-0.44189,-0.0042819,0.89706],[0.92019,-0.28141,0.27213],[-0.73535,0.028689,-0.67708],[0.98381,0.051876,-0.17153],[-0.95754,-0.0062026,0.28823],[0.75373,-0.59773,0.27314],[0.79586,-0.54927,-0.25478],[-0.77699,-0.62941,-0.011347],[0.85452,0.037013,0.5181],[0.89952,-0.3528,0.25767],[-0.74941,-0.0023343,-0.6621],[-0.889,-0.068236,0.4528],[0.42896,-0.19702,0.88158],[-0.92914,0.10352,0.35494],[-0.35265,-0.75114,0.55805],[0.48206,-0.7523,0.44907],[-0.77919,-0.0034299,0.62678],[0.77103,-0.63665,0.013428],[-0.84021,0.12233,-0.52828],[0.96989,-0.13151,0.20496],[-0.85504,-0.44969,-0.25825],[0.94917,-0.011764,0.31453],[-0.94014,-0.33504,-0.062328],[-0.88264,-0.1036,-0.45849],[0.70589,-0.29527,0.64384],[0.80702,-0.55239,-0.20875],[0.89921,-0.42078,-0.11982],[-0.53834,-0.67346,0.5066],[-0.8772,-0.33089,-0.3479],[0.3221,-0.74598,0.58289],[0.90785,-0.37524,-0.18706],[0.94699,0.2415,0.21187],[-0.88269,-0.42981,-0.19006],[0.76694,-0.60138,0.22394],[0.94689,-0.10983,-0.30222],[0.45902,0.20337,0.86483],[0.91379,0.39396,0.098922],[0.79842,0.020257,0.60176],[0.69523,-0.66763,-0.26633],[0.86409,-0.10754,0.49172],[0.9485,0.12073,-0.29286],[0.81925,0.55094,0.15903],[0.88139,-0.46346,-0.091457],[0.83855,-0.51112,-0.18867],[-0.89491,0.038234,0.44461],[0.97206,-0.037393,0.23175],[-0.18524,0.88665,0.42371],[-0.69567,0.0727,-0.71468],[0.99268,0.067543,-0.1001],[-0.91804,-0.10448,0.38247],[-0.83024,-0.12416,-0.5434],[0.82383,0.47756,-0.30535],[-0.93095,-0.35639,-0.079545],[0.92857,-0.36985,-0.031242],[0.99949,0.020699,0.024454],[0.70271,0.29283,0.64843],[0.31826,0.18075,0.93061],[-0.67212,-0.73861,0.052099],[0.7809,-0.6199,0.076913],[-0.76977,0.03773,-0.63721],[0.87329,0.47304,-0.11664],[-0.95019,-0.18995,-0.24712],[-0.044244,-0.98544,0.16414],[-0.093936,-0.9729,0.21128],[0.88788,-0.15782,0.43216],[0.039092,0.42825,0.90282],[0.53247,-0.80805,0.25206],[-0.82432,-0.44392,0.35132],[-0.80237,-0.48342,0.35001],[0.9526,0.26097,0.15638],[0.084182,-0.9838,-0.15826],[0.86707,0.052326,0.49544],[0.39352,-0.82015,0.41533],[0.59081,-0.65536,0.47058],[-0.7957,0.17877,-0.57871],[0.93535,0.27069,-0.2277],[-0.83376,-0.4984,-0.23758],[-0.86567,-0.16628,-0.47219],[0.67082,-0.64225,0.37082],[0.88461,-0.39669,0.24517],[-0.075033,-0.39123,0.91723],[-0.87582,-0.031554,-0.4816],[0.98133,0.048266,0.1862],[0.97852,-0.02784,-0.20424],[-0.88736,0.25024,-0.38726],[-0.804,0.032877,-0.59372],[0.93819,-0.17002,0.30149],[0.99015,-0.085365,0.11102],[0.49439,0.84656,0.1973],[-0.96584,0.17829,-0.18804],[0.9657,0.063196,-0.25187],[0.81598,0.57787,0.01547],[-0.055284,-0.31194,0.94849],[0.29332,0.91914,0.26294],[-0.73286,-0.20632,-0.64834],[-0.40871,0.66823,0.62163],[-0.19348,0.086655,0.97727],[-0.2008,0.67563,0.70937],[-0.70141,0.16053,0.69444],[-0.08608,0.72557,0.68275],[0.98915,-0.10986,-0.097544],[0.048143,0.84894,0.5263],[-0.92872,-0.01978,0.37026],[-0.98106,-0.17292,0.087275],[-0.14634,0.87048,0.46995],[-0.28281,0.72908,0.62327],[-0.98321,0.0019932,-0.18244],[-0.42557,-0.38474,-0.81906],[0.24068,-0.19545,0.95072],[0.25597,0.1226,0.95888],[0.081019,0.27336,0.95849],[-0.26575,0.71739,0.644],[-0.94893,0.020675,0.31481],[0.69142,0.63346,-0.34736],[-0.1447,0.93489,0.32411],[0.97307,0.10641,0.20449],[0.72544,-0.62171,-0.29532],[-0.83604,-0.4957,-0.23519],[-0.4846,-0.15739,-0.86046],[-0.95978,0.20741,-0.18923],[-0.13827,0.97962,0.14571],[0.031763,0.9761,0.215],[0.89856,-0.17252,0.40351],[0.9578,0.10022,-0.26939],[0.97073,0.03539,-0.23755],[-0.99579,0.023506,0.088623],[0.70157,0.6841,-0.19952],[-0.85381,0.50443,0.12866],[-0.61618,0.17377,-0.7682],[0.79695,0.54562,0.25916],[-0.63552,0.39577,-0.66293],[0.47597,0.80004,0.36522],[-0.99142,0.13061,-0.004509],[0.9707,0.19957,-0.13383],[-0.27604,-0.13327,0.95186],[0.00084788,-0.43597,0.89996],[-0.48797,0.85518,-0.17478],[-0.87981,0.46323,0.10653],[-0.82619,-0.48468,-0.28722],[-0.4709,0.86936,-0.14987],[-0.94428,0.31481,-0.096096],[-0.73371,0.64123,0.22469],[-0.22432,0.85926,-0.45972],[-0.039642,0.95642,-0.28929],[0.92984,0.038852,0.3659],[0.46018,0.29942,0.83581],[0.98158,0.18392,-0.05179],[-0.17442,0.98423,0.029575],[-0.99803,0.062738,0.0011606],[-0.40587,0.88793,0.21646],[0.99033,0.019129,0.13741],[0.20397,-0.055799,0.97739],[-0.85567,0.50814,-0.098134],[-0.42071,0.4047,0.81193],[0.48052,0.20896,0.85172],[-0.78458,0.50613,-0.35815],[0.78515,-0.51336,0.34641],[-0.91067,0.41313,0.0022131],[0.37652,0.25555,0.89047],[-0.79918,0.40855,-0.44091],[-0.86776,0.38358,-0.31599],[0.63172,-0.68127,0.36987],[-0.12715,0.37791,0.91707],[-0.15289,0.45744,0.876],[-0.91538,0.25389,0.31245],[0.31689,0.29714,0.90072],[-0.37424,0.42807,0.82261],[-0.9297,0.36731,0.027207],[0.92789,0.33867,0.15595],[-0.0004567,-0.65248,0.75781],[-0.28611,0.43101,0.85578],[-0.89868,0.38266,0.21435],[0.35229,0.1576,0.92253],[-0.36344,0.25814,0.89514],[0.17926,-0.47381,0.86219],[0.32855,0.21659,0.91932],[0.84626,0.1196,0.51918],[-0.21733,0.25524,0.94214],[0.94474,-0.14979,0.29159],[-0.85131,-0.20788,0.48172],[0.73438,-0.4689,0.49073],[0.74455,-0.30561,0.5935],[-0.96912,-0.20629,0.13509],[0.66766,-0.17086,0.72459],[0.16146,-0.086009,0.98312],[0.18804,0.97065,-0.1499],[0.15986,0.96281,-0.21783],[-0.99057,0.1291,0.045905],[-0.59399,0.032509,0.80381],[0.95534,0.21847,0.199],[-0.81014,0.58611,0.011684],[-0.82423,0.56545,-0.030306],[0.47162,0.0086313,0.88176],[-0.44343,-0.76555,-0.46616],[0.40532,0.90882,-0.098847],[0.74492,-0.60259,-0.28631],[-0.58047,0.013326,0.81417],[0.88814,0.075894,0.45326],[0.26703,0.96234,-0.05099],[0.10971,0.99355,-0.028575],[0.020431,0.9943,-0.10469],[0.78382,-0.12863,0.60752],[0.3347,0.94218,-0.016187],[-0.21905,0.0049056,0.9757],[-0.74066,0.57371,0.34969],[-0.51174,0.097993,0.85353],[0.50614,0.85528,0.111],[-0.91405,0.40438,0.031258],[-0.75273,0.5673,0.33403],[-0.74726,0.5925,0.30091],[0.79662,-0.12979,0.59039],[0.98754,-0.055071,0.14741],[-0.62546,0.64292,0.4421],[0.52225,0.81053,0.26515],[0.98766,0.13414,0.080835],[-0.34694,0.012735,0.9378],[0.39021,0.10231,0.91502],[-0.36345,0.26193,0.89403],[0.4948,0.79078,0.36034],[-0.55913,0.66011,0.50163],[-0.67963,0.16509,0.71474],[0.074365,0.1543,0.98522],[0.62297,-0.73187,-0.27617],[-0.21745,0.37614,0.90069],[0.90279,0.19406,0.38381],[0.27273,0.23314,0.93342],[-0.10374,0.5044,0.85722],[0.21271,0.36144,0.90781],[0.0085453,0.6956,0.71838],[0.18732,0.77274,0.60645],[0.9602,0.20398,0.1908],[-0.71645,0.34205,0.60803],[0.99921,-0.038447,0.0098797],[0.18198,0.18132,0.96644],[-0.0403,0.5123,0.85786],[-0.037455,0.046714,0.99821],[-0.89017,0.085661,0.4475],[0.96278,-0.053459,0.26493],[0.93717,0.19159,0.29155],[-0.032718,-0.99945,-0.0046726],[-0.52276,-0.85232,0.016674],[0.16416,-0.95732,0.23787],[-0.69392,0.70674,-0.13781],[0.14242,-0.98714,-0.072598],[0.1279,-0.93538,-0.32972],[0.16928,-0.27192,0.94731],[-0.90273,0.093398,0.41994],[0.34091,-0.86011,-0.37947],[0.88542,0.29865,0.35616],[0.43102,-0.87912,-0.20339],[-0.13649,-0.69905,-0.70193],[-0.19939,-0.035511,0.97928],[0.031027,-0.8115,-0.58353],[0.15253,0.099984,0.98323],[-0.027313,-0.93631,-0.35012],[0.47641,0.31244,0.82183],[-0.25827,-0.96251,0.082892],[-0.26883,-0.96196,0.048666],[-0.55855,-0.82896,0.02901],[0.51889,-0.83881,0.16477],[-0.99994,0.001157,0.011032],[-0.35175,-0.63561,-0.68722],[0.05864,-0.76469,0.64172],[-0.10148,-0.25502,0.9616],[-0.32994,-0.73456,-0.59293],[0.058034,0.75733,0.65044],[0.96699,-0.04086,0.25153],[0.27983,-0.85974,-0.42726],[0.18796,-0.84647,-0.49815],[-0.4587,0.030885,0.88805],[0.3946,-0.65184,0.64761],[-0.4039,-0.75566,-0.51559],[0.4016,-0.84711,-0.34803],[-0.74601,-0.62873,0.21946],[0.93473,0.34928,0.065405],[0.65256,-0.72469,0.22134],[-0.59583,-0.66589,-0.44897],[0.69005,-0.62392,-0.36682],[-0.057592,-0.037768,0.99763],[-0.6767,-0.33315,0.65657],[-0.54621,-0.69407,0.46895],[0.53141,-0.84308,-0.082559],[-0.97662,0.19806,0.083529],[-0.79789,-0.34523,-0.49416],[0.71397,0.65166,0.2561],[0.0086661,0.40698,0.9134],[0.58002,0.34578,0.73757],[0.33982,0.41895,0.84203],[-0.73147,-0.32856,-0.59749],[0.50349,-0.84907,-0.15992],[-0.80682,-0.48736,-0.33395],[-0.59086,-0.7929,0.14896],[0.90224,-0.42619,0.065739],[-0.076964,0.42927,0.89989],[-0.99715,-0.052174,-0.054429],[0.83339,0.40723,0.37367],[0.69538,-0.13098,0.70661],[-0.59334,-0.5841,0.55387],[-0.37267,-0.91536,-0.15241],[-0.88006,0.24375,0.40753],[-0.68365,-0.22418,-0.69453],[0.77375,-0.53488,-0.33944],[0.92623,0.091883,0.3656],[-0.54374,-0.80025,-0.25287],[0.47027,-0.76755,0.43557],[0.66424,-0.70343,0.25293],[0.80512,-0.45095,-0.38525],[0.54231,-0.71379,0.44317],[-0.4836,0.23401,-0.84343],[-0.10375,0.44823,0.88788],[-0.66959,-0.73856,-0.078608],[0.7405,-0.58638,-0.32837],[-0.67612,-0.70255,-0.22202],[0.57725,-0.70795,0.40692],[-0.86703,0.37064,0.333],[-0.048298,0.65058,-0.7579],[0.64776,0.73584,0.19736],[0.63979,-0.76618,0.060243],[0.90999,0.1189,0.39721],[0.98167,0.18159,-0.05793],[-0.97734,-0.055264,-0.20433],[0.65137,-0.62746,0.42662],[-0.22659,0.54526,-0.80706],[-0.73997,0.088129,0.66684],[-0.2552,0.73335,-0.63013],[0.88261,0.36333,0.29832],[-0.44997,0.5647,-0.69184],[-0.74747,-0.61323,-0.25541],[0.081471,0.26595,0.96054],[-0.63368,0.11925,-0.76435],[-0.085671,0.48265,0.87161],[0.7431,-0.66854,-0.029461],[0.70912,0.62548,0.32546],[-0.96283,-0.092113,0.25393],[0.98998,-0.11326,-0.08428],[-0.65638,-0.59379,-0.46538],[0.69297,-0.67914,-0.24199],[-0.86842,0.2545,0.42553],[-0.080921,-0.47183,0.87797],[-0.73464,0.075579,-0.67424],[0.26,0.29503,0.91943],[-0.67605,-0.61053,-0.41257],[0.8309,-0.49245,-0.25903],[0.9506,0.052654,-0.30593],[-0.85579,0.075856,0.51174],[0.56006,-0.79487,0.23348],[-0.84207,-0.028752,-0.53861],[0.8422,-0.51781,-0.15023],[0.88946,0.35406,0.28897],[0.90084,0.13488,0.41267],[-0.70541,0.11591,0.69925],[-0.88206,0.04487,-0.469],[0.86132,-0.50205,-0.07794],[0.9854,-0.16183,-0.052936],[-0.86608,-0.4958,-0.063854],[-0.9955,0.089409,-0.031507],[0.59363,-0.69788,0.4007],[0.87104,-0.0021257,0.4912],[0.97007,0.22114,0.10032],[0.93079,0.14901,0.33382],[-0.83077,0.11942,-0.54365],[-0.35285,-0.28782,0.89031],[0.9286,0.36857,-0.043133],[0.91699,0.35505,0.18187],[-0.092202,-0.24176,0.96595],[0.86252,-0.3351,-0.37916],[0.96553,-0.26026,0.0046108],[-0.89541,-0.43932,-0.072337],[0.95941,-0.28085,-0.025483],[0.26211,0.43078,0.86355],[0.34203,0.3161,0.88493],[0.87873,0.33559,0.33944],[-0.79771,0.021926,-0.60265],[-0.49124,0.68769,0.53457],[-0.69308,0.57163,0.43918],[0.91411,0.37882,-0.14458],[-0.9519,-0.28042,-0.12351],[-0.55402,0.75044,0.36043],[-0.80928,-0.057334,-0.58462],[0.52807,-0.65452,0.54106],[0.70871,0.63005,-0.31743],[-0.89522,0.38746,0.22012],[-0.78809,-0.54417,-0.28772],[-0.33416,-0.90607,-0.25958],[0.012144,-0.99986,-0.011674],[0.089478,-0.98634,0.1383],[-0.34323,-0.93684,0.067266],[0.85491,-0.51513,0.06148],[-0.80721,0.10059,-0.58163],[0.69498,-0.57533,0.43127],[0.99988,0.00056549,-0.015511],[0.89687,0.44213,-0.011851],[-0.72219,-0.51434,-0.46248],[0.9425,0.32444,-0.080262],[-0.29365,-0.24017,0.92525],[-0.17687,-0.24877,0.95228],[0.33425,-0.88791,0.31607],[0.99795,0.044801,-0.045649],[0.60862,-0.001619,0.79346],[0.18048,0.44266,0.87834],[0.81935,0.48731,0.30198],[-0.84375,-0.089179,-0.52928],[0.91039,0.25665,0.32453],[-0.5458,0.74991,0.37382],[-0.70498,0.34889,0.61748],[0.7516,0.54803,0.36711],[-0.75345,-0.082492,-0.65231],[-0.72145,0.52416,0.45252],[-0.74439,0.005237,-0.66772],[0.92908,-0.29718,0.22021],[-0.96237,0.14329,0.23087],[0.7412,-0.60166,0.29771],[0.55583,-0.71949,0.41639],[0.27677,-0.17169,0.94547],[-0.33745,-0.91415,0.22464],[0.80998,-0.53745,0.23469],[-0.8921,0.17007,-0.41861],[0.54081,0.0088436,0.8411],[-0.45135,-0.45558,-0.76729],[0.81452,0.56671,0.12414],[-0.16267,0.68483,0.71031],[-0.1444,0.73362,0.66404],[0.38402,0.92027,0.075054],[0.42399,0.9029,0.070713],[0.95366,0.031382,-0.29925],[-0.33451,-0.50703,-0.79437],[-0.88809,0.44028,-0.13207],[0.78663,0.59511,-0.16449],[-0.038324,0.86583,0.49887],[-0.36421,0.82187,0.43804],[0.48622,0.1105,0.86682],[0.50095,-0.86133,0.08459],[-0.47906,-0.29586,-0.82642],[0.78661,0.1613,0.59601],[-0.36067,0.83208,0.42138],[0.64454,0.71612,0.26784],[0.25172,0.83469,0.48982],[0.96032,0.10219,-0.25951],[0.20934,-0.48406,0.84962],[0.73576,0.5183,-0.43591],[-0.22355,0.9207,0.31991],[-0.23485,0.92235,0.30678],[0.18978,0.50701,0.84079],[0.27255,0.93179,0.23977],[0.27416,0.84988,0.45004],[-0.94579,0.32356,-0.028085],[-0.68128,0.015179,-0.73187],[-0.26236,-0.22824,0.93759],[-0.0015488,-0.96553,0.26028],[0.95597,0.13248,-0.26184],[-0.73064,0.193,0.65491],[-0.13184,-0.37084,0.91929],[0.58271,0.6863,-0.43525],[-0.79218,0.57255,0.21128],[-0.73371,0.47325,-0.48756],[0.73049,0.68243,-0.025964],[-0.92255,0.36513,0.1248],[-0.98471,0.16527,0.055122],[-0.73739,0.52111,-0.42977],[0.79032,0.38172,0.47925],[-0.62224,0.6812,0.38572],[0.63639,0.22553,0.73766],[-0.61292,0.63433,-0.47112],[0.28061,-0.95884,0.043471],[-0.87104,0.44758,0.20237],[-0.15642,-0.10235,0.98237],[0.88649,0.45336,-0.092725],[-0.49872,0.86048,-0.10418],[0.22309,-0.50018,0.83669],[0.47299,0.27624,0.83664],[0.28418,-0.034536,0.95815],[-0.77185,0.62226,0.13057],[-0.68258,0.04814,0.72923],[-0.22687,0.89601,-0.38171],[0.47869,0.26258,0.8378],[-0.85106,0.52376,0.036958],[0.066751,0.97348,-0.21881],[-0.22139,0.96892,-0.11037],[-0.93062,0.31068,-0.19348],[0.99842,0.014431,0.054393],[-0.51121,0.77094,0.37989],[0.45843,0.88175,0.11114],[-0.41341,0.51015,0.75421],[-0.75641,0.34207,-0.55753],[-0.45078,0.30197,0.84001],[0.010079,0.941,0.33825],[0.71916,-0.69448,0.022595],[0.88768,-0.31421,0.3366],[0.74013,-0.67203,0.024315],[-0.19846,0.4494,0.87101],[-0.17756,0.45263,0.87384],[-0.2865,-0.033925,0.95748],[-0.43741,0.4195,0.79542],[0.49974,0.30616,0.81026],[-0.36524,0.77726,0.51231],[0.33476,-0.095554,0.93744],[0.213,0.23935,0.94728],[-0.20174,0.85316,0.48107],[-0.32955,0.50976,0.7947],[0.27854,0.41151,0.8678],[-0.79572,0.59001,-0.13681],[-0.055975,0.50985,0.85844],[0.62752,0.73958,0.24338],[0.65544,-0.51575,0.55172],[-0.067526,0.21852,0.97349],[-0.90751,0.37047,0.19793],[-0.29859,0.13293,0.94508],[-0.90967,-0.0068609,0.41527],[0.63314,-0.38125,0.67363],[-0.64678,-0.32586,0.68956],[0.6339,-0.20251,0.74643],[0.011917,-0.8247,0.56544],[0.58179,-0.063893,0.81082],[-0.68457,0.24335,0.68713],[-0.62119,-0.19048,0.76016],[0.37306,-0.92561,-0.063832],[0.51079,-0.00094884,0.85971],[0.44456,-0.86302,-0.23992],[-0.61573,0.023238,0.78761],[-0.043283,0.97633,-0.21189],[-0.29318,0.94883,-0.11729],[-0.50875,-0.79511,0.33011],[0.36401,0.9295,-0.05938],[-0.74634,-0.53673,-0.39356],[0.43292,0.080354,0.89784],[0.43085,0.038145,0.90162],[-0.62549,0.7802,0.0068585],[0.29367,0.95289,-0.075926],[-0.010223,0.99993,0.0055519],[-0.0031281,0.96555,-0.26021],[0.17764,0.94487,-0.27508],[-0.76387,0.61749,0.18763],[0.23112,0.96504,-0.12364],[0.25143,0.95773,-0.1398],[0.55192,-0.79836,-0.24086],[0.20754,-0.56812,0.79634],[0.37624,0.090176,0.92212],[0.60205,0.50791,0.61609],[-0.7976,-0.52379,-0.29914],[0.36472,0.11219,0.92434],[-0.53284,-0.80881,0.24882],[-0.37795,0.24173,0.89371],[0.38012,-0.18555,0.90613],[-0.49678,0.64823,0.57707],[0.71684,-0.69316,0.075367],[-0.30907,0.34494,0.88628],[-0.23975,-0.27394,0.93138],[0.8512,-0.33903,-0.40064],[0.67304,-0.50816,0.53738],[-0.59792,0.56122,0.5723],[0.64104,0.39025,0.66089],[-0.16481,0.54246,0.82376],[0.30437,0.79574,0.5236],[-0.75948,0.12918,0.63758],[-0.77577,0.0039682,0.631],[-0.059144,-0.98876,-0.13732],[0.72256,-0.55956,0.40596],[-0.2616,0.031124,0.96467],[-0.1987,0.61063,0.76658],[0.13772,0.38315,0.91336],[-0.77534,-0.35455,-0.52264],[0.051185,-0.99335,-0.10312],[0.61871,0.29734,0.72718],[0.0054836,-0.99126,-0.13178],[0.20352,-0.96302,0.17656],[-0.80409,-0.37715,0.45957],[0.0038326,-0.97415,0.22586],[0.012013,-0.99711,-0.074974],[0.019251,-0.94939,-0.31351],[0.11496,-0.94279,-0.31294],[0.67347,0.037092,0.73828],[-0.063704,-0.81072,-0.58195],[0.06363,-0.77945,-0.62323],[0.57671,-0.81695,0.0011612],[-0.50203,-0.72898,-0.46534],[0.40087,0.016757,0.91598],[0.45901,0.80114,0.38402],[-0.21757,-0.86234,-0.4572],[-0.70927,0.61301,0.34806],[0.16264,-0.82426,-0.54235],[0.20206,-0.96405,-0.17255],[0.23782,-0.96361,-0.12204],[0.55904,-0.77267,0.30077],[-0.45347,-0.77441,-0.4412],[0.29251,-0.91193,-0.28778],[-0.41546,-0.85523,0.30979],[0.55235,-0.58115,0.59763],[0.5521,-0.75164,0.36087],[0.52338,-0.57574,0.62817],[-0.54736,-0.78013,0.30298],[-0.43751,-0.83865,-0.32441],[0.57159,-0.77608,-0.26642],[-0.28153,-0.51857,0.80735],[0.61036,-0.72016,0.32989],[-0.9428,0.2656,0.20144],[0.63001,-0.75418,0.18517],[-0.79068,-0.48041,-0.37952],[-0.88395,-0.44184,0.15299],[0.56751,-0.82017,0.0725],[0.73954,-0.67077,0.056028],[-0.13287,0.45017,0.883],[0.49291,-0.83142,-0.25647],[-0.29372,-0.0096373,0.95584],[-0.10155,-0.96638,-0.23622],[0.81296,0.13807,0.56572],[-0.78086,-0.43506,-0.44831],[0.41682,-0.86713,-0.27264],[0.84888,-0.52575,-0.054675],[-0.46651,-0.82968,-0.30659],[-0.9051,-0.060749,0.42083],[0.15775,-0.95781,-0.24025],[0.29327,-0.92695,-0.234],[-0.27577,0.8678,0.41337],[0.34118,0.14434,0.92885],[0.60531,-0.73016,-0.31696],[-0.42297,-0.90192,-0.087375],[0.5273,0.68818,0.49835],[-0.61239,-0.75331,-0.2398],[0.6429,-0.7585,-0.10663],[-0.76939,-0.32598,-0.54935],[0.5679,0.77695,0.27175],[-0.4722,-0.4412,-0.76313],[-0.45107,-0.86785,-0.20827],[0.90146,-0.40202,-0.16047],[-0.88569,-0.32135,0.33508],[0.66624,-0.74289,0.065044],[0.91765,0.38264,-0.10727],[0.63411,-0.020571,0.77297],[-0.49901,-0.86217,-0.087401],[0.19068,0.91453,0.35676],[-0.74461,-0.3844,-0.5457],[-0.67015,-0.73439,-0.10755],[0.89938,-0.3982,-0.18043],[-0.35674,-0.90862,-0.21716],[0.51498,-0.79355,0.32415],[-0.19095,0.89798,0.39645],[-0.42424,-0.31121,0.85039],[0.86375,-0.46043,-0.20481],[0.89361,-0.44013,-0.087948],[-0.80712,0.49746,0.31794],[-0.45035,-0.75488,-0.47681],[-0.47496,0.36178,-0.8022],[0.60395,-0.70773,0.36654],[-0.35245,0.16881,0.92048],[-0.060669,0.69505,-0.7164],[-0.7101,0.32441,0.62491],[0.66289,-0.74436,0.080694],[0.90439,0.29356,0.30968],[-0.045449,0.71568,-0.69694],[-0.29166,0.53959,-0.7898],[-0.63715,-0.52728,-0.56215],[0.2503,0.030769,0.96768],[0.82096,-0.43472,0.37019],[0.20275,0.47321,0.8573],[-0.63965,0.099407,-0.76221],[0.40005,0.11475,0.90928],[-0.91933,0.062464,0.3885],[-0.85671,-0.28849,-0.42757],[-0.42921,-0.86371,-0.26417],[-0.69157,0.1349,-0.7096],[0.57688,-0.74571,0.33335],[0.90637,0.42248,0.0014103],[0.92692,-0.26685,0.26383],[0.96292,-0.059795,-0.26309],[-0.68983,-0.45849,-0.56029],[-0.59029,-0.46696,-0.65841],[0.78635,-0.60706,0.11463],[-0.96952,0.23226,0.078041],[-0.89331,0.062851,0.44502],[-0.33606,0.89236,0.30126],[0.2845,0.43602,0.85378],[-0.89187,-0.047789,0.44975],[0.50437,-0.61827,0.60279],[-0.7573,-0.44457,-0.47838],[0.67278,-0.71358,0.19537],[-0.76534,0.1929,0.61404],[-0.45931,-0.8612,-0.21763],[0.55467,-0.77643,0.29916],[-0.89892,-0.095502,0.42757],[-0.82761,-0.41199,-0.38121],[0.61181,0.75076,0.24908],[-0.56367,-0.79588,0.22101],[0.78687,-0.58784,-0.18781],[0.97925,0.15573,0.12971],[0.75532,-0.61395,0.22924],[-0.85582,0.08961,-0.50945],[-0.6975,-0.38951,-0.60148],[0.88106,-0.47223,0.027024],[0.75081,-0.52966,-0.39465],[-0.16747,0.21894,0.96126],[-0.85322,-0.48169,-0.19998],[0.526,-0.31105,0.79156],[-0.69721,0.0014055,-0.71686],[0.80477,-0.59319,-0.021814],[-0.72869,0.027764,-0.68428],[0.63618,0.078789,0.76751],[0.92115,0.30006,0.24787],[0.8832,-0.45206,-0.12492],[-0.16556,-0.39792,0.90236],[0.99289,0.11683,0.022803],[0.92397,0.21348,-0.31732],[-0.84162,0.20023,0.50159],[0.96423,0.26408,-0.022842],[-0.94077,-0.28741,-0.17987],[0.94994,-0.3048,-0.068656],[0.78398,0.56577,-0.25551],[-0.76203,-0.61469,-0.20362],[0.30127,-0.29765,0.90589],[0.70921,0.69312,-0.12884],[-0.035724,-0.99184,-0.1224],[0.78958,-0.60906,0.074969],[-0.16038,0.5133,0.84309],[-0.68421,-0.47227,-0.55571],[-0.86945,-0.067987,0.48932],[0.52865,-0.7883,0.31482],[0.83518,-0.30091,0.46035],[-0.77581,0.37701,0.50595],[-0.82727,-0.16017,-0.53848],[0.49498,-0.7803,0.38226],[-0.79932,0.11865,-0.58908],[-0.47222,-0.28001,0.83582],[-0.77849,-0.49503,0.38588],[0.79203,0.46842,0.3915],[0.77038,-0.61827,0.15575],[0.98066,0.17791,0.081584],[-0.31732,-0.32379,0.89133],[-0.82214,-0.33258,-0.46203],[0.68036,-0.72422,0.11234],[0.7869,-0.61568,-0.041519],[0.9302,0.36369,-0.04958],[0.67072,0.65019,0.35693],[-0.85483,0.24105,-0.45951],[0.58376,-0.025551,0.81153],[0.90169,-0.40101,-0.16171],[0.85186,0.52188,0.044484],[-0.59647,0.60876,0.5231],[-0.53985,0.75338,0.37548],[0.56263,0.77494,0.28796],[0.94612,0.037332,-0.32164],[-0.62659,-0.19502,-0.75455],[-0.012088,0.90696,0.42104],[0.85185,0.52244,0.037467],[0.80256,-0.57634,0.15404],[0.44607,-0.27257,0.85248],[0.40247,0.83013,0.38589],[0.081688,0.94582,0.31423],[-0.85337,0.4938,0.16709],[0.72913,0.5747,-0.37161],[-0.40341,-0.43879,-0.80294],[-0.32044,-0.38966,0.86342],[-0.17109,0.81475,0.554],[0.3672,0.89629,0.24867],[-0.027664,0.52726,0.84925],[0.32112,0.87848,0.35377],[0.30035,0.85067,0.43145],[0.14769,0.38181,0.91237],[-0.84285,-0.41964,-0.3369],[-0.23904,-0.95029,-0.19953],[-0.16585,0.74422,0.64702],[0.96782,0.045209,0.24755],[0.16659,-0.83015,0.53207],[0.3496,0.93189,0.096748],[-0.83944,0.071957,-0.53867],[-0.3498,-0.4293,-0.83267],[0.92344,0.38227,-0.033623],[-0.38017,0.82882,0.41053],[-0.59907,0.2991,0.74273],[0.24382,0.95467,0.17078],[-0.62456,-0.1293,-0.7702],[0.35775,-0.58439,0.72836],[0.90352,0.41332,-0.11321],[-0.16715,0.52183,0.83651],[-0.17432,0.90333,0.39194],[0.093462,0.89204,0.44218],[-0.84092,0.27157,-0.46809],[-0.77964,0.16851,-0.60313],[-0.16018,-0.9732,-0.16497],[0.74147,0.58478,-0.32901],[-0.19089,-0.96452,-0.18239],[-0.2955,0.88664,0.35574],[0.29433,0.8425,0.45118],[0.67722,-0.73473,-0.039219],[-0.79348,0.22887,-0.56392],[-0.028967,0.91338,0.40608],[0.10186,0.91778,0.38381],[0.51453,0.77994,-0.35631],[0.091292,-0.98369,0.15499],[-0.84243,0.52278,0.13042],[0.53155,-0.015125,0.84689],[0.70777,0.70493,0.046285],[-0.98281,0.11277,-0.14619],[-0.72842,0.63926,-0.24649],[-0.5312,-0.060119,0.84511],[0.67078,0.58515,0.4557],[0.73765,-0.65339,-0.17013],[-0.73727,0.67002,-0.086636],[0.97263,0.22821,-0.04382],[0.94243,0.28203,-0.17971],[-0.55253,0.83094,0.065165],[-0.28953,-0.63422,0.7169],[-0.13028,-0.98952,0.062296],[0.60748,0.51107,0.60809],[-0.44622,0.88066,-0.15918],[0.43954,-0.85086,0.28781],[-0.91232,0.20002,0.35729],[0.89867,0.4215,-0.12141],[0.56016,0.31445,0.76638],[0.36992,-0.85722,-0.35824],[-0.83327,0.46999,-0.29117],[-0.47477,0.87859,-0.05181],[-0.84655,0.11635,-0.51944],[0.017293,0.98373,-0.17883],[-0.12471,0.98956,-0.072202],[0.53645,0.24149,0.80864],[0.31235,-0.89049,0.33086],[-0.80634,0.0079028,-0.5914],[0.053148,-0.97923,-0.19564],[0.98701,0.14094,-0.077055],[-0.17399,0.92811,0.32913],[-0.18335,0.61456,0.76727],[-0.28154,0.59157,0.7555],[0.82112,-0.47376,-0.31829],[-0.042188,0.61951,0.78386],[-0.83697,0.21936,-0.50137],[-0.52893,-0.5802,0.61936],[-0.36845,0.41298,0.83288],[-0.50319,-0.22837,0.83346],[-0.7924,0.54422,-0.27555],[-0.31855,-0.93522,0.15457],[-0.36663,0.42502,0.82761],[-0.75122,0.56391,-0.34302],[-0.90979,0.22659,0.34777],[0.28678,0.38719,0.87627],[-0.27969,-0.63793,0.71751],[-0.022116,0.49808,0.86685],[0.6206,-0.52311,0.58413],[0.64074,-0.4762,0.60223],[0.84989,-0.33287,-0.40852],[-0.94203,0.1065,0.31819],[0.62178,-0.28076,0.73114],[-0.43225,-0.87899,-0.20134],[-0.80643,-0.56043,0.18864],[0.17204,-0.98448,0.034643],[0.24705,-0.95657,0.15476],[0.10729,0.61216,0.78342],[0.58655,-0.12769,0.79979],[-0.78111,0.29266,0.55156],[0.43673,-0.52013,0.73398],[-0.06116,-0.99746,-0.036506],[-0.056479,-0.99724,-0.048225],[-0.10897,0.52038,0.84695],[-0.6681,0.73856,0.090408],[-0.58727,0.027335,0.80893],[0.19437,0.97935,0.05558],[0.39529,0.90102,-0.17863],[-0.52553,0.1256,0.84145],[0.29983,0.8108,-0.5027],[0.15319,0.87346,-0.46217],[-0.05384,0.84396,-0.5337],[-0.59262,0.29732,0.7486],[0.63389,-0.2267,0.73946],[-0.95883,-0.06454,0.27656],[0.19065,0.87727,-0.44051],[0.8153,-0.19752,-0.54431],[0.33118,0.93124,0.15203],[0.92823,-0.0056223,0.37196],[0.35776,0.1571,0.9205],[0.9148,0.40054,-0.051947],[-0.41699,0.3051,0.85618],[0.42402,0.86722,0.26105],[0.28103,0.20201,0.9382],[0.74975,-0.51208,-0.4191],[0.4756,-0.86473,0.1614],[-0.88925,-0.076464,0.45099],[-0.09151,-0.95355,-0.28701],[0.13301,0.36857,0.92004],[-0.33106,0.44188,0.83375],[0.45092,-0.79418,0.40738],[-0.80291,-0.48046,-0.35283],[-0.73538,-0.66099,0.14935],[0.57509,-0.13511,0.80685],[-0.28935,0.6219,0.72768],[-0.03128,0.69173,0.72148],[0.28008,0.76869,0.57504],[0.079946,-0.99672,0.012445],[0.077785,-0.99124,0.10676],[-0.0066976,0.50724,0.86178],[-0.072532,-0.97247,0.22146],[0.56204,-0.79405,-0.23151],[-0.47587,-0.86612,0.15289],[-0.36418,-0.91587,0.169],[0.22596,-0.9513,0.2097],[0.16882,-0.97808,0.12193],[-0.068449,-0.99706,0.034397],[-0.16182,-0.9835,-0.080882],[-0.084568,-0.97397,-0.21032],[0.14175,-0.98473,-0.10111],[0.42306,-0.89687,0.12903],[-0.34837,-0.90114,-0.25804],[-0.3996,-0.36386,0.84138],[0.55311,0.66822,0.49754],[-0.0039358,-0.89237,-0.45129],[0.33437,-0.85909,-0.3875],[0.60573,-0.70641,0.36617],[0.20528,-0.95571,-0.21092],[-0.87772,0.079141,0.4726],[-0.4704,-0.88223,0.019865],[-0.37375,-0.92679,-0.036928],[-0.43064,-0.10499,0.8964],[0.16935,-0.93259,-0.31875],[-0.43948,-0.84919,0.29281],[0.54796,-0.78094,0.29979],[0.91712,0.39498,-0.053674],[-0.48838,-0.77674,-0.39768],[0.55192,-0.7953,0.25076],[0.4357,-0.2196,0.87289],[0.68096,0.16122,0.71436],[-0.66017,-0.61401,0.43264],[0.86733,0.16979,0.46788],[-0.71509,-0.57954,-0.39088],[0.57214,0.018421,0.81995],[0.73601,-0.57445,-0.35818],[0.57945,-0.79479,0.18041],[0.61262,0.30667,0.72846],[-0.7115,0.6596,-0.24226],[-0.69828,-0.67262,0.24493],[-0.35996,-0.93297,-0.00067274],[-0.92266,-0.26228,-0.28268],[-0.35521,-0.82837,-0.43316],[0.11521,-0.9447,-0.30703],[0.55811,-0.50276,0.66011],[-0.82394,0.30784,0.47577],[-0.60479,-0.7925,0.078595],[-0.57097,-0.65824,-0.49063],[0.5046,-0.81167,-0.29424],[-0.79009,-0.45123,-0.41491],[0.95643,-0.21135,0.20145],[-0.93704,-0.10342,-0.33356],[-0.52063,-0.72612,-0.44911],[-0.44579,0.23333,0.86419],[0.67069,-0.6503,-0.35676],[0.89029,-0.41189,-0.19425],[-0.54265,-0.16941,0.8227],[-0.2431,-0.8601,-0.44848],[-0.66865,-0.21016,0.71326],[-0.26486,-0.88163,-0.3906],[0.50242,-0.19054,0.84337],[0.69016,-0.71021,-0.13883],[0.59513,-0.77051,-0.22832],[-0.75057,-0.084205,-0.6554],[-0.86272,-0.089025,-0.49779],[0.83729,-0.48521,-0.25204],[-0.79581,0.60537,0.014925],[-0.55602,-0.65181,-0.51575],[0.37307,0.90351,-0.21093],[-0.51589,-0.61434,-0.59703],[0.94809,0.18697,0.25725],[-0.70341,0.17044,-0.69004],[0.76944,-0.63106,-0.09861],[-0.52142,-0.49676,-0.69379],[-0.44477,0.47635,0.75847],[0.5882,-0.80825,0.027269],[-0.52437,0.46078,-0.71604],[-0.2059,0.62697,-0.75134],[-0.94271,0.054244,0.32918],[-0.94139,-0.19954,0.27198],[0.65072,-0.75774,-0.048877],[-0.016698,0.40007,0.91633],[0.99582,-0.031844,-0.085601],[-0.9256,0.07337,-0.37132],[-0.52735,-0.4756,-0.70406],[0.79523,-0.60302,-0.06302],[0.75301,-0.65165,-0.091279],[-0.12412,-0.48385,0.86631],[-0.57709,0.32597,-0.74881],[-0.7731,0.6333,0.035386],[-0.69112,-0.37981,-0.6149],[0.86067,-0.46801,-0.20054],[-0.69415,0.12307,-0.70923],[-0.45936,-0.28223,0.84222],[-0.40979,-0.22025,0.88519],[0.78968,-0.51982,-0.32588],[-0.67547,0.15515,-0.72088],[0.87653,-0.47007,-0.10358],[-0.41012,0.56746,0.714],[0.67144,-0.71411,-0.19803],[-0.69227,0.12197,0.71126],[0.9137,0.05827,-0.40218],[-0.74179,-0.40121,-0.53738],[0.97146,0.21807,0.093322],[0.78527,-0.040563,0.61782],[0.88674,0.41187,-0.20991],[-0.69553,0.063266,0.71571],[-0.81372,0.089733,-0.57429],[0.70767,-0.59379,0.3829],[0.93902,0.20725,-0.27437],[-0.73905,-0.30633,-0.59997],[0.73606,-0.67315,0.071311],[0.79484,-0.093135,0.59963],[-0.86766,0.46673,-0.17127],[0.93877,0.2462,0.24103],[-0.76017,-0.064728,-0.64649],[0.89228,0.2523,0.37442],[-0.85698,-0.25437,-0.44819],[-0.3771,-0.91307,0.15525],[0.85053,-0.43382,0.29731],[-0.15611,-0.95184,-0.2639],[0.11205,0.74634,0.65606],[-0.38946,0.32827,0.86056],[-0.86576,-0.49299,0.086119],[-0.69656,0.018569,-0.71726],[0.90951,-0.22906,-0.34686],[-0.93639,-0.050352,0.34734],[0.55816,-0.72241,0.40814],[-0.91775,-0.34067,-0.20415],[0.92572,-0.34643,0.15173],[0.92377,0.00060522,-0.38294],[0.91499,0.24093,-0.32365],[-0.92543,0.13816,0.35283],[0.99023,0.10239,0.094672],[0.96837,0.24389,0.05279],[0.95075,-0.26805,-0.15565],[-0.80613,0.12253,-0.57891],[-0.94676,0.18972,-0.2601],[-0.79421,0.31217,0.52132],[0.79782,0.59149,0.11672],[0.0011952,0.8003,0.5996],[-0.27205,-0.94773,0.16669],[0.97489,0.16528,-0.14924],[-0.45105,-0.74595,-0.49001],[-0.23943,-0.87848,-0.41346],[-0.061704,-0.96015,-0.27259],[0.147,-0.98904,-0.013846],[0.21003,-0.97109,0.11343],[0.78165,0.57316,-0.24599],[-0.92262,-0.2543,-0.29],[-0.48998,-0.86937,-0.064157],[-0.81542,0.098642,-0.5704],[0.70117,0.70941,0.071387],[-0.76378,-0.20386,-0.61243],[0.16996,-0.95822,0.23008],[0.73261,-0.58374,0.35005],[0.5751,-0.81432,0.078396],[-0.54425,-0.084296,0.83468],[0.33502,0.25068,0.90825],[0.73015,0.63809,0.2444],[0.42904,-0.8167,0.3859],[-0.61933,0.14127,0.77232],[0.9783,0.20599,0.022227],[0.39341,-0.90631,0.15436],[0.97036,0.016518,0.24108],[0.67967,-0.35955,0.63935],[-0.87903,-0.098696,-0.46644],[0.50015,-0.84287,0.19853],[0.81416,-0.14355,0.56261],[-0.77623,-0.030409,-0.62972],[0.71092,0.55249,0.43514],[-0.91291,0.15141,-0.37903],[0.59994,-0.74848,0.28257],[-0.23131,0.35336,0.90644],[-0.40323,0.73412,0.54632],[0.87728,-0.001972,0.47997],[-0.12616,-0.26874,0.95492],[-0.74635,0.22219,0.62737],[0.38384,-0.21692,0.89756],[-0.87132,0.25491,-0.4193],[-0.58756,0.12853,0.7989],[0.1233,0.25311,0.95955],[-0.32128,-0.43637,-0.84045],[0.096892,-0.97493,0.2003],[-0.29333,-0.49845,-0.81578],[0.87392,0.48573,-0.017927],[-0.11367,0.78722,0.60611],[-0.25942,0.76413,0.5906],[0.57223,0.78336,0.24267],[0.54094,0.8256,0.16053],[-0.86488,0.010876,-0.50186],[-0.47067,-0.45605,0.75531],[-0.34334,0.82732,0.44458],[0.53835,-0.23052,0.81058],[-0.58131,-0.13017,-0.8032],[-0.19019,-0.42659,0.88422],[0.84775,-0.48835,0.20696],[0.28562,0.89464,0.34356],[0.0039066,0.96358,0.2674],[-0.87392,0.15099,-0.46202],[0.95179,0.17144,-0.25436],[-0.71846,0.096676,-0.68882],[-0.94492,0.20582,-0.25447],[-0.20494,0.85815,0.47072],[0.95169,0.21295,-0.2212],[-0.87261,0.05673,0.4851],[0.8251,0.54492,0.1492],[-0.6788,0.61076,-0.40768],[0.97374,0.0074961,-0.22756],[-0.85578,0.34746,-0.38329],[-0.77418,0.62472,-0.1018],[-0.92178,0.38728,-0.01829],[-0.86517,0.46652,-0.18394],[0.80532,0.59218,-0.028031],[-0.84375,0.48122,-0.23772],[0.68472,-0.63097,0.36473],[0.47203,0.80484,-0.35975],[0.52375,0.76136,-0.38212],[-0.90045,0.030967,-0.43385],[0.9442,0.26747,-0.19221],[0.66303,0.71545,-0.22026],[-0.71662,0.69652,0.036216],[0.48512,0.83891,-0.24675],[-0.81519,0.25251,-0.52126],[-0.60993,0.78659,0.096294],[0.82663,0.35636,0.43553],[-0.47789,-0.40181,0.78113],[0.64354,0.75121,0.14674],[-0.83127,0.51644,-0.20561],[0.98315,0.18113,0.024507],[-0.64914,0.76029,0.024036],[0.66948,0.60633,0.42913],[0.27311,-0.95446,-0.1201],[0.85421,0.46431,-0.23396],[-0.52753,-0.19824,0.82609],[0.90431,0.4228,0.058829],[-0.76585,0.52733,-0.36796],[0.69157,0.58346,-0.4258],[-0.88026,0.2644,-0.39401],[-0.48951,0.87157,0.027449],[0.48261,0.37528,0.79136],[-0.86637,0.063253,-0.49538],[0.9218,0.36081,-0.14178],[-0.26001,0.93477,0.24206],[-0.17674,0.93485,-0.30794],[-0.4798,0.52318,0.70433],[0.54863,-0.49182,0.6761],[-0.88176,0.17099,-0.43962],[-0.51556,-0.42819,0.74219],[0.10261,0.9947,-0.0066311],[-0.014202,0.91379,0.40593],[-0.3174,0.57137,0.75683],[-0.63974,-0.61034,0.46713],[0.23572,0.38137,0.89387],[0.73787,0.58576,0.33532],[0.29938,0.26732,0.91592],[-0.13648,-0.20863,0.96842],[-0.2154,-0.62268,0.75224],[0.02494,0.5454,0.8378],[-0.68848,0.61125,-0.39034],[0.0045353,0.34344,0.93916],[0.95971,0.12026,0.25398],[-0.44499,0.57004,0.69068],[-0.73033,0.66888,-0.13866],[-0.80867,0.58671,0.042705],[0.74777,0.65847,0.085242],[-0.68411,0.72577,-0.0724],[-0.69423,0.71637,0.069677],[0.55627,0.82283,0.11628],[-0.78142,0.59363,-0.19232],[0.6122,-0.34321,0.71233],[-0.88243,0.04096,0.46865],[-0.74092,-0.19592,0.64238],[0.50288,0.015812,0.86421],[-0.40655,-0.90131,0.14952],[-0.62148,-0.14804,0.76932],[-0.44761,0.81859,-0.35994],[0.44865,0.07387,0.89065],[-0.19817,0.2884,0.93678],[-0.62501,0.77796,-0.0644],[0.77931,-0.14328,0.61003],[-0.65329,0.33808,0.67743],[-0.41824,-0.52563,0.74081],[0.19618,0.94251,-0.27052],[0.13353,0.985,-0.10928],[-0.06237,0.99778,-0.023164],[0.63765,0.71085,-0.2968],[0.29043,0.95188,-0.097818],[0.55425,-0.38513,0.73788],[-0.48337,0.86976,0.099346],[0.44741,0.24624,0.85976],[0.3878,0.1385,0.91128],[-0.56259,0.087885,0.82205],[-0.42743,-0.060925,0.90199],[-0.77362,0.62052,-0.12832],[0.73259,0.11752,0.67045],[-0.64099,0.72015,0.26555],[0.36232,-0.33262,0.87068],[0.18737,0.86672,-0.46227],[-0.21612,0.89886,-0.38123],[-0.66054,0.6756,0.3275],[-0.84712,0.017133,0.53113],[-0.54111,-0.094799,0.83559],[0.18332,-0.64094,0.74538],[0.023749,0.88927,-0.45677],[0.083712,-0.31947,0.94389],[0.039343,0.99849,-0.03833],[0.01824,0.97997,-0.19829],[-0.45455,0.73347,0.50537],[-0.31059,-0.81026,0.49701],[0.35193,0.81229,0.46511],[-0.35747,0.67074,0.64987],[0.45487,0.8874,0.074965],[-0.41545,-0.65175,0.63453],[0.11873,0.39118,0.91262],[0.2554,0.25182,0.93347],[-0.21039,0.5777,0.78867],[0.49852,0.78017,-0.3779],[0.60833,0.074233,0.79021],[0.50343,-0.76402,0.40353],[0.71263,0.068062,0.69823],[-0.046576,0.51308,0.85708],[0.27923,0.95371,0.11167],[-0.080245,0.67272,0.73553],[-0.24023,0.81061,-0.53404],[-0.28328,0.90784,-0.30916],[0.15537,-0.98216,0.1059],[0.2421,-0.89116,-0.3837],[-0.11287,-0.99211,0.054529],[-0.16159,-0.98433,-0.070602],[0.41782,-0.81714,0.39712],[-0.20348,-0.95375,-0.22126],[-0.59929,0.0036972,0.80052],[0.48487,-0.71204,0.50784],[-0.50953,-0.7749,-0.37405],[-0.41434,0.82357,-0.38737],[0.29928,-0.90142,-0.31287],[0.092787,-0.55443,0.82704],[0.12153,-0.96558,-0.22995],[-0.28097,0.37274,0.88438],[-0.28862,-0.6534,0.69983],[0.29007,-0.9375,-0.19222],[-0.28925,0.83508,-0.46796],[-0.63545,-0.7646,0.10765],[0.95621,-0.22722,0.18446],[-0.50433,-0.77654,-0.37768],[-0.56977,-0.75155,0.33247],[0.60887,-0.71926,0.33458],[0.57374,-0.8161,-0.069397],[0.39107,0.90885,0.14513],[0.48495,-0.83834,-0.24903],[0.69308,-0.6954,-0.18988],[0.5883,0.64149,-0.49233],[0.2671,0.8765,-0.40051],[0.64733,0.71635,0.26039],[0.73494,-0.59345,-0.32814],[0.54908,-0.747,-0.37484],[-0.76494,-0.44789,-0.46289],[0.57204,-0.73864,-0.35663],[0.94145,0.20802,0.26532],[-0.66093,0.60701,-0.44126],[0.52391,-0.83998,-0.14124],[0.03876,-0.38529,0.92198],[0.69146,-0.55775,-0.45913],[0.62908,0.010352,0.77727],[-0.77072,0.60019,-0.2139],[-0.21519,-0.91295,-0.34673],[-0.084393,-0.94105,-0.32757],[-0.30633,-0.87393,0.37738],[0.54479,-0.83597,-0.065971],[-0.34433,-0.93746,-0.051002],[-0.61358,-0.69244,0.37953],[-0.6392,-0.67182,-0.37426],[0.26613,-0.8965,-0.3542],[-0.34294,-0.83727,0.42588],[0.68511,-0.72417,-0.078747],[0.65796,-0.23379,0.71585],[-0.37925,-0.92495,-0.025121],[0.7284,-0.37148,-0.5757],[-0.77782,-0.62475,-0.068521],[0.49847,0.26567,0.82519],[0.9642,0.19251,0.18239],[0.82987,-0.55529,-0.054493],[-0.77743,0.59751,-0.19646],[-0.55828,-0.82941,-0.020008],[-0.90211,-0.25715,-0.34651],[0.82075,-0.35538,-0.44729],[-0.3152,-0.83188,-0.45676],[-0.70957,0.70007,-0.080031],[0.85791,-0.34066,-0.38463],[-0.43215,-0.71444,-0.5503],[0.27773,-0.67191,0.68659],[-0.1777,-0.44487,-0.87779],[0.66325,-0.29024,0.68982],[0.40781,-0.79175,-0.45478],[-0.86206,-0.49037,0.12801],[0.97204,-0.17707,-0.15424],[0.65906,-0.18216,0.7297],[0.30141,-0.69049,0.65755],[-0.73265,0.24681,-0.63428],[0.59833,0.60927,0.52038],[-0.64262,-0.54789,-0.5356],[0.84586,0.50302,0.17744],[-0.10066,0.34431,0.93344],[0.70107,-0.71277,-0.021274],[-0.89313,0.10995,0.43616],[0.80387,0.55381,-0.21698],[-0.26906,0.62427,-0.73341],[-0.73601,0.67689,-0.0099007],[-0.010829,0.71709,-0.6969],[0.98755,-0.11132,-0.11115],[0.6731,-0.49681,-0.54783],[-0.99276,0.059481,-0.10436],[-0.62685,0.77914,-0.00075334],[-0.26873,0.62842,-0.72998],[-0.52074,0.45521,-0.72223],[-0.63842,0.76913,0.029447],[-0.40448,-0.90417,0.13737],[0.63849,-0.4799,-0.60168],[-0.13485,-0.16838,0.97645],[-0.8954,-0.0087678,0.44517],[-0.67433,0.021249,-0.73812],[-0.72694,-0.3944,-0.56214],[-0.8519,0.52307,-0.02568],[0.68349,-0.4893,-0.5417],[0.85862,-0.49635,-0.12812],[0.9934,-0.087351,-0.074314],[0.63259,0.43358,0.64175],[0.93882,0.33534,-0.078565],[-0.65921,-0.44049,-0.60944],[0.76941,0.055836,0.63631],[0.76949,-0.56839,-0.29123],[-0.45751,-0.47114,0.75413],[-0.9907,0.088219,-0.10361],[-0.28321,0.56572,0.77444],[-0.71507,-0.2855,-0.6381],[0.23644,-0.19213,0.95246],[0.69857,0.14407,0.70089],[-0.89043,-0.10064,0.44386],[0.8986,0.43104,-0.081999],[0.83695,-0.53671,0.10704],[-0.75016,0.038661,-0.66013],[0.67862,-0.65114,-0.33985],[0.92676,0.3669,0.080592],[-0.73959,-0.12731,-0.6609],[-0.51344,-0.48773,0.70604],[0.77464,0.15808,0.61233],[0.88692,0.45804,-0.059694],[-0.90737,-0.13255,0.39889],[0.71158,-0.59538,0.37307],[-0.7895,-0.086297,-0.60765],[0.83393,-0.42663,-0.35007],[0.94192,0.24541,0.22926],[-0.76125,0.548,-0.34668],[-0.82048,-0.11476,-0.56003],[0.99434,0.05405,-0.09149],[-0.26261,-0.91467,0.30728],[-0.53683,-0.26699,0.80033],[0.98885,-0.1406,-0.049126],[0.97839,-0.18804,-0.085996],[-0.81056,0.58355,-0.049579],[-0.39353,-0.33647,0.85552],[-0.90776,-0.2878,-0.30519],[-0.99407,-0.086941,0.065257],[-0.76632,0.57517,-0.28624],[0.89574,-0.43516,0.091035],[-0.91026,-0.33472,-0.24369],[0.7565,-0.654,0.0019587],[0.81794,-0.056495,0.57252],[0.93519,0.26558,-0.23428],[0.96992,0.18342,0.16004],[0.91711,0.31713,0.24154],[-0.94563,0.31947,-0.060961],[0.99181,-0.12579,0.021962],[-0.5505,-0.11099,0.82743],[-0.85695,0.025593,-0.51476],[0.58539,0.029644,0.81021],[0.73252,0.67548,0.084529],[-0.48605,-0.61126,-0.62459],[0.9952,-0.097248,-0.010744],[0.22647,-0.96417,0.13814],[0.96482,-0.24926,0.083646],[0.9034,-0.33137,0.27214],[0.77513,0.47918,-0.41179],[-0.78437,0.31294,0.53557],[-0.14893,-0.98781,0.045394],[0.59944,0.79109,0.12184],[0.61553,-0.66423,0.42416],[0.62798,-0.66319,0.40721],[-0.7866,0.078131,-0.61249],[0.40314,-0.84478,0.35188],[0.97624,0.06849,-0.20558],[0.95209,0.27626,0.13113],[-0.9782,-0.20519,0.031854],[-0.43834,0.3823,0.81345],[-0.98362,-0.16463,-0.073471],[0.38395,0.2298,0.8943],[0.58644,0.64062,0.49568],[0.56017,-0.77739,-0.28613],[-0.59735,-0.35865,0.71731],[-0.57825,-0.24757,-0.77739],[-0.71056,-0.673,0.20534],[0.58678,0.71131,0.38695],[-0.92173,0.36631,0.1274],[-0.36627,-0.51522,-0.77485],[0.50565,0.29431,0.81099],[0.86093,0.50608,-0.0519],[-0.10627,0.92748,0.35846],[0.049627,0.91238,0.40632],[-0.12868,0.76981,0.62516],[0.34426,-0.81538,0.46544],[0.92955,0.29668,-0.21891],[0.82221,0.17106,-0.54287],[-0.55003,-0.28887,-0.7836],[0.01953,0.2175,0.97586],[0.91905,0.11585,-0.37674],[0.58724,0.0028077,0.80941],[-0.38728,0.75727,0.52589],[0.40562,0.86422,0.29764],[-0.99422,0.024451,0.10451],[0.94524,-0.20076,0.25734],[-0.99915,-0.011666,0.039515],[-0.78269,0.064553,-0.61905],[0.89353,0.44734,-0.038513],[-0.56591,-0.19012,0.80225],[-0.016615,0.96025,0.27864],[-0.021719,0.94465,0.32735],[0.22164,0.94603,0.23645],[-0.55032,0.80692,-0.21453],[-0.81421,0.39938,-0.42137],[0.99553,-0.031378,-0.089123],[-0.12692,0.83073,0.54201],[-0.97973,-0.18536,0.075922],[-0.6355,-0.24837,0.73107],[0.34576,0.87872,0.3291],[-0.81269,0.39673,-0.42678],[-0.95053,-0.30592,0.053851],[0.08037,0.83002,0.55191],[-0.85796,-0.30984,0.40975],[0.54691,0.77256,-0.32255],[-0.82611,0.56021,-0.060964],[0.90109,0.36214,0.23852],[-0.65315,0.61046,-0.44804],[0.94588,0.24852,-0.20867],[-0.78072,0.25366,-0.57108],[0.50183,0.80041,-0.3279],[0.62756,0.76208,-0.1594],[0.62866,-0.68053,0.37638],[0.55195,-0.50892,0.66057],[-0.43039,-0.044905,0.90153],[-0.66451,0.66035,-0.3498],[0.50888,0.82733,-0.23782],[0.95095,0.13853,-0.2766],[-0.6298,0.77012,0.10132],[0.63153,0.77526,-0.011708],[0.58749,0.73761,-0.33284],[-0.69156,0.52511,-0.49599],[0.13969,-0.32021,0.93699],[-0.53597,0.84343,-0.036848],[0.78353,-0.59637,0.17443],[-0.54512,-0.086279,0.83391],[-0.37158,0.9195,-0.12827],[0.62755,0.58423,0.51464],[0.60183,0.76772,0.21999],[-0.69872,-0.55653,0.44951],[-0.30202,0.94532,0.12305],[-0.28048,0.39822,0.87336],[0.51149,0.73448,0.446],[-0.93392,0.15278,-0.32318],[-0.30313,0.94373,0.13223],[-0.10111,0.97376,-0.20386],[0.63491,-0.077076,0.76873],[-0.97222,-0.048997,0.22888],[0.22969,0.97306,0.019694],[-0.26432,0.54243,0.79744],[-0.24614,0.84389,0.47672],[0.35254,0.65178,0.67149],[0.81568,-0.56292,0.13338],[-0.043739,0.66869,0.74225],[-0.12056,0.87369,0.4713],[-0.47314,-0.016266,0.88084],[0.95084,0.29053,0.10727],[-0.83237,0.53596,-0.14109],[0.90481,-0.1109,0.41113],[-0.67728,0.73162,0.07768],[0.91654,0.22834,0.32835],[0.81677,-0.55717,0.14983],[0.74478,-0.29425,0.59893],[-0.077195,-0.19026,0.97869],[-0.91941,0.13845,0.36813],[-0.80871,-0.56546,0.162],[0.62533,-0.28205,0.72761],[0.59847,-0.1483,0.7873],[0.56542,-0.48714,0.66558],[0.69897,0.054541,0.71307],[0.76428,-0.55355,-0.33086],[0.54118,-0.029723,0.84038],[0.95331,-0.022401,0.30115],[-0.75301,-0.048301,0.65624],[-0.70506,-0.04549,0.70769],[0.46849,0.10648,0.87703],[0.41645,0.10598,0.90296],[-0.27526,0.95426,0.11672],[0.58025,-0.30716,0.75429],[-0.73482,-0.41623,0.53553],[0.37965,0.12024,0.91728],[0.41708,0.80795,-0.41624],[0.17305,0.85909,-0.48169],[-0.5726,0.79317,0.2074],[0.83956,-0.54117,0.047712],[0.47558,0.77401,-0.41802],[-0.82441,-0.50418,0.25719],[-0.52468,0.22176,0.82191],[0.29224,0.87865,-0.37759],[0.59792,-0.077733,0.79778],[-0.64928,-0.75738,-0.069328],[0.26095,0.25921,0.9299],[-0.43701,0.36456,0.82227],[0.035582,0.92328,-0.38247],[0.19989,0.84118,-0.50246],[0.15448,0.84997,-0.50367],[-0.84866,-0.504,0.16046],[0.093,0.28435,0.9542],[0.14249,0.38254,0.91289],[0.6299,-0.2194,0.74505],[0.21176,0.90856,0.36011],[0.23624,0.9497,0.20557],[-0.15277,0.96635,-0.20698],[0.0077276,0.9271,-0.37474],[-0.66608,0.65062,0.36473],[-0.04843,0.51742,0.85436],[0.094707,0.45415,0.88588],[0.15922,-0.10176,0.98198],[0.21561,0.75226,0.62258],[-0.84171,-0.11832,-0.52681],[-0.12725,0.65354,0.74612],[-0.0088923,-0.99596,-0.089359],[-0.49643,-0.064766,0.86566],[-0.30296,-0.86021,0.41019],[0.050965,-0.97342,0.2233],[-0.007793,-0.99793,-0.063808],[-0.02383,-0.97196,0.23394],[0.38647,-0.73934,0.55137],[0.87739,0.34187,-0.33661],[0.57033,-0.37389,0.73139],[-0.32886,-0.86305,-0.38341],[-0.25887,-0.9403,-0.22097],[-0.92492,-0.087906,-0.36986],[0.24965,-0.83417,-0.49177],[-0.78943,-0.58719,0.17889],[-0.20333,-0.95154,0.2307],[-0.2456,-0.88841,0.38784],[-0.33106,-0.83714,0.43544],[-0.76327,-0.35761,0.53808],[-0.40713,-0.66684,-0.62416],[0.27087,-0.83017,-0.48729],[0.27322,-0.91565,-0.29486],[-0.58024,-0.80236,0.13982],[-0.37905,-0.92334,0.06136],[0.39674,-0.87613,0.27385],[-0.92521,-0.19148,0.3276],[0.39861,-0.9113,-0.10316],[0.46518,-0.88058,0.090467],[-0.40449,-0.15449,0.9014],[0.8976,0.28106,-0.3396],[-0.38913,-0.68673,-0.61398],[-0.95791,0.13574,-0.25294],[0.60496,-0.78723,-0.11956],[0.43906,-0.89297,-0.099153],[-0.50713,-0.59431,-0.62419],[-0.54465,0.053917,0.83693],[-0.40291,-0.91523,0.0038152],[-0.48341,-0.87302,0.064413],[0.4034,-0.76608,-0.50038],[0.5276,-0.23567,0.81615],[-0.70755,-0.57387,0.41236],[0.37304,-0.65311,-0.65901],[-0.95171,-0.068227,0.29931],[0.5503,-0.69718,-0.45946],[-0.60215,-0.66843,0.4366],[0.55099,-0.69665,-0.45945],[-0.59736,-0.36177,0.71574],[0.45762,-0.49131,-0.74108],[0.086754,-0.94091,-0.32734],[-0.93028,0.15375,-0.33308],[0.65138,-0.63262,-0.41893],[-0.14536,0.30694,0.94056],[0.61617,0.089856,0.78247],[0.54589,-0.32473,-0.77237],[-0.42943,-0.80375,-0.4118],[0.7047,0.65446,0.27399],[0.58661,-0.35356,0.72862],[-0.44211,-0.87289,0.20638],[-0.98659,0.15088,-0.062275],[0.5144,-0.75891,-0.3993],[0.51892,0.010137,0.85476],[0.70992,0.033102,0.7035],[0.65994,-0.7473,0.077574],[-0.36174,-0.89802,0.25041],[-0.33085,-0.92723,0.17544],[-0.63271,-0.65992,-0.4052],[0.69142,-0.51232,0.50938],[0.65782,-0.22794,-0.71786],[-0.296,-0.89618,-0.33051],[0.62392,-0.67584,-0.39238],[0.71799,-0.58688,-0.37425],[-0.58577,-0.78088,0.21701],[-0.48148,-0.84221,-0.24263],[0.69935,-0.58536,-0.4102],[0.66999,-0.63119,-0.3908],[0.84092,-0.52793,-0.11891],[-0.71049,-0.69398,0.1166],[-0.58484,-0.76396,-0.27263],[-0.99236,-0.1034,-0.067335],[0.71563,-0.55528,0.42371],[0.76937,-0.11281,-0.62876],[0.39527,-0.835,-0.3828],[0.33062,-0.89764,-0.29145],[0.52713,-0.69351,-0.4911],[-0.58039,-0.35789,0.73148],[0.13609,-0.40457,0.90433],[-0.8229,0.1523,0.5474],[0.60084,-0.60301,-0.52476],[0.57869,-0.33782,0.74229],[0.61226,-0.58386,-0.53315],[-0.91129,-0.086426,-0.4026],[0.73464,-0.65052,-0.19271],[-0.94335,-0.062842,0.32579],[-0.58842,-0.14714,0.79505],[-0.70305,0.12638,-0.69982],[0.62883,-0.65847,0.41351],[-0.24176,0.30991,0.91951],[-0.30501,0.3907,-0.86852],[0.99595,-0.03821,-0.081378],[0.6674,-0.72072,0.18744],[0.90862,0.006767,-0.41758],[-0.59074,-0.37328,0.71532],[-0.12019,0.59383,-0.79556],[0.58548,-0.25856,0.76835],[-0.94459,-0.2649,0.19385],[0.53274,0.12285,0.83731],[0.012385,0.74698,-0.66473],[-0.97503,0.088747,-0.20356],[0.78404,-0.62064,0.0089712],[0.75866,-0.48341,-0.43675],[-0.7633,-0.42044,-0.49052],[-0.17923,0.40772,0.89534],[0.81946,0.57312,-0.0047554],[-0.90063,0.18229,0.39452],[-0.56595,-0.40384,0.71876],[-0.72975,0.10397,-0.67576],[0.50878,0.23461,0.82831],[0.8521,-0.51811,-0.074085],[0.62447,-0.26653,0.73417],[-0.66425,-0.71991,0.20125],[-0.75587,0.16473,-0.63366],[-0.65134,-0.41386,-0.63598],[0.56941,0.034717,0.82132],[0.95821,-0.11565,-0.26165],[-0.6765,0.27252,-0.68416],[0.46733,0.27474,0.84031],[0.63225,-0.71078,-0.3083],[0.40381,-0.61623,0.67617],[0.89011,-0.16644,0.42427],[0.75841,-0.34713,-0.55165],[0.91049,0.40718,-0.07215],[0.92275,-0.30209,-0.23932],[0.86301,0.47015,0.18488],[0.76001,-0.16767,0.62791],[0.85882,-0.50592,0.080492],[-0.95529,0.093051,-0.28064],[-0.77952,-0.30158,0.549],[0.92837,0.31723,-0.19362],[-0.77143,-0.47254,0.42614],[0.91195,-0.37902,-0.15714],[0.79536,-0.57672,0.18654],[-0.85121,-0.08444,-0.51798],[0.98205,-0.13728,-0.12937],[0.96339,0.22935,-0.13887],[0.16053,-0.42296,0.89181],[-0.74837,-0.020216,-0.66298],[0.91058,-0.40829,0.064368],[-0.87241,0.05351,-0.48584],[0.92176,-0.38777,0.00023359],[0.97942,-0.00034368,-0.20182],[-0.79936,-0.31776,0.50996],[-0.92836,-0.1182,0.35239],[0.98132,0.17692,0.075567],[-0.80308,0.23813,-0.54622],[-0.033041,0.36044,0.9322],[-0.8029,0.30436,0.51255],[0.76699,-0.64165,0.00071268],[-0.49996,-0.11589,0.85826],[0.96428,-0.22837,0.13423],[0.62016,0.10198,0.77782],[-0.80411,0.30544,0.51001],[0.82502,0.44821,0.34416],[-0.058892,-0.89716,-0.43775],[0.19677,-0.96254,-0.18655],[0.35269,-0.32896,0.87601],[-0.86889,-0.23824,0.4339],[-0.52511,-0.45726,-0.71775],[-0.2507,-0.7785,-0.5754],[0.3125,-0.94858,0.050453],[-0.57525,-0.80676,-0.13497],[0.98819,-0.083128,0.12873],[-0.91024,0.054302,-0.4105],[0.65228,0.75082,0.10391],[-0.71467,0.044111,-0.69806],[0.87365,-0.43924,0.2093],[0.94557,0.31784,-0.069758],[-0.7523,0.22612,-0.6188],[-0.71553,0.081099,-0.69386],[0.19787,-0.40021,0.89481],[0.58454,-0.44813,0.67638],[-0.72443,0.46121,0.51233],[0.63381,0.70763,0.31232],[0.94625,0.3207,0.041866],[0.55308,0.64944,0.52186],[0.33469,-0.9341,0.12426],[0.31744,-0.93351,-0.16672],[-0.56868,-0.20261,-0.79722],[-0.79256,-0.25221,0.55519],[-0.89384,0.24574,-0.37505],[-0.52583,-0.33639,-0.78124],[0.92698,0.23918,0.28897],[-0.55617,-0.76507,0.32456],[-0.548,0.059525,0.83436],[-0.48641,0.70777,0.51232],[-0.97016,-0.10883,-0.21666],[0.73468,-0.40806,-0.54197],[-0.38371,-0.49066,-0.78232],[-0.45312,0.49351,0.74238],[-0.51571,-0.84935,0.11245],[-0.30909,0.84015,0.44566],[-0.84867,0.31893,0.42195],[0.18935,0.90414,0.38299],[0.23566,-0.42878,0.87213],[0.71373,-0.59627,-0.3675],[-0.061718,0.29403,0.9538],[-0.88761,-0.26593,0.37607],[-0.49498,-0.47112,-0.7301],[0.89729,0.43879,0.048375],[-0.56951,-0.13702,0.81048],[-0.73807,-0.15981,0.65552],[-0.91879,0.12323,-0.37503],[-0.72887,-0.19088,-0.65751],[-0.40467,0.72239,0.56071],[0.21864,0.39396,0.89274],[-0.30403,0.75014,0.58724],[-0.60176,0.034295,0.79794],[0.46737,0.27727,0.83946],[0.93641,0.17623,-0.30346],[0.47375,-0.38403,0.79251],[-0.83007,0.4221,-0.36443],[-0.97367,0.20418,0.10141],[0.55763,-0.74129,-0.37355],[-0.12482,0.77848,0.61514],[0.58311,-0.27828,0.76325],[0.27975,0.93307,0.2261],[-0.56199,-0.38586,0.73163],[-0.84714,0.45202,-0.27934],[-0.43247,-0.8919,0.13222],[-0.16845,0.7993,0.57684],[0.028526,0.76349,0.64519],[0.080286,0.87209,0.48271],[-0.85645,0.2973,0.42203],[-0.75582,0.56195,-0.33608],[-0.76296,0.64466,-0.048029],[-0.58772,-0.10699,0.80196],[-0.66091,0.59322,-0.45966],[0.86804,0.044982,0.49446],[-0.7101,0.6855,0.16078],[-0.70161,0.62502,0.34218],[0.7363,0.66957,0.09765],[-0.66744,-0.13326,0.73265],[-0.7953,-0.01185,-0.6061],[0.94484,0.22967,-0.2335],[0.45722,0.8559,-0.24165],[-0.69267,0.71546,0.091221],[0.63655,-0.13555,0.75923],[0.45053,0.8598,-0.24034],[-0.86331,0.42004,-0.27976],[-0.67829,0.73471,0.011576],[-0.86397,-0.25889,0.43189],[0.51399,0.78912,-0.33632],[0.98512,-0.086027,0.1488],[0.47788,0.85995,-0.1792],[-0.80946,0.43784,-0.39125],[0.81436,0.50286,-0.28972],[-0.7204,-0.68555,0.10511],[-0.27711,0.95761,-0.078664],[0.1506,-0.38971,0.90854],[-0.119,0.38452,0.91542],[0.52902,0.84703,-0.051802],[-0.92202,0.28803,-0.25867],[-0.89955,0.1692,0.40271],[-0.25466,0.93174,0.25886],[0.20237,0.9759,0.081593],[-0.1097,0.99365,0.024833],[0.31286,0.90674,0.28275],[0.86216,0.16125,0.48029],[0.97459,0.22008,-0.041787],[-0.22147,0.95559,-0.19443],[-0.01782,0.99057,-0.13585],[0.25981,0.96413,-0.054328],[0.95598,0.20528,0.20969],[-0.56506,-0.25515,0.7846],[-0.60654,0.78781,0.10711],[0.36387,0.17014,0.91578],[-0.73389,0.66781,0.12427],[-0.93126,0.35704,-0.072626],[-0.024771,0.39217,0.91956],[-0.9478,0.29151,0.12926],[0.82887,-0.53167,-0.1741],[-0.94529,0.29235,0.14477],[0.5369,0.057806,0.84166],[-0.87078,0.20628,0.44632],[-0.57122,-0.1707,0.80285],[0.41117,0.18493,0.8926],[-0.70667,0.089365,0.70187],[0.15721,0.97936,-0.12707],[0.18539,-0.37533,0.90816],[-0.6026,0.158,0.78224],[-0.034291,0.33274,0.94239],[0.45638,0.074886,0.88663],[0.32551,0.89026,-0.31857],[0.34818,0.84046,-0.41521],[0.2432,0.47075,0.84809],[0.27456,0.86964,-0.4103],[-0.38423,0.77313,0.50461],[0.72994,-0.24035,0.63986],[0.44579,-0.54541,0.70979],[0.42404,0.83178,-0.35823],[0.41175,0.46753,0.78222],[0.24323,0.30935,0.91932],[-0.48359,0.00089884,0.8753],[0.66196,-0.028143,0.74901],[0.78461,-0.5748,-0.23235],[-0.53851,-0.77262,0.33625],[0.15977,0.94157,-0.29652],[0.53023,0.11089,0.84057],[-0.070186,0.59058,0.80392],[-0.81378,0.096786,0.57306],[-0.2493,0.58554,0.77136],[0.48455,-0.24334,0.84024],[0.16089,0.84488,0.51019],[-0.7846,0.32293,0.52926],[-0.063061,0.99801,-0.0011941],[-0.10116,0.96265,-0.25114],[0.18064,0.94835,-0.26076],[0.90844,-0.11384,0.40222],[0.74319,-0.20921,0.63553],[-0.10741,-0.99203,-0.065923],[0.18455,-0.93313,-0.30857],[0.08052,-0.92119,-0.38069],[-0.18191,-0.9113,0.36939],[-0.06597,-0.99452,-0.081124],[-0.01196,-0.99899,-0.043421],[0.13473,-0.95352,0.26954],[0.23323,-0.85186,0.46898],[0.377,-0.7491,0.54472],[-0.68363,0.07953,0.72548],[-0.026743,0.077937,0.9966],[-0.19142,-0.77447,-0.60295],[0.57147,0.13243,0.80987],[-0.049152,-0.89579,-0.44174],[0.54141,-0.6232,0.56435],[0.26988,-0.79503,-0.54322],[-0.51004,-0.63777,-0.57715],[0.42862,-0.73978,-0.51866],[0.24978,-0.96828,-0.0062459],[-0.66047,0.21278,0.72007],[0.39376,-0.79882,0.4548],[0.39636,-0.12778,0.90916],[-0.16306,0.44094,0.8826],[-0.86034,0.44946,-0.24043],[-0.6546,-0.71333,0.25032],[0.25169,-0.39391,0.88402],[0.23454,-0.95411,-0.18619],[0.34724,-0.8828,-0.31638],[-0.4648,-0.64737,-0.60405],[0.67226,-0.6097,0.41992],[0.5344,0.25395,0.80618],[0.27392,-0.79172,-0.54602],[-0.67678,-0.4211,-0.60386],[0.57691,-0.79611,-0.18269],[-0.1748,0.36201,0.91564],[0.14951,-0.57287,-0.8059],[-0.17984,0.24073,0.95378],[0.36659,-0.45285,-0.81273],[0.38426,0.25283,0.88793],[-0.71993,-0.36263,-0.59177],[0.51655,-0.79667,-0.31383],[-0.59549,-0.38084,0.70736],[0.34875,-0.51957,-0.78001],[-0.53968,0.17548,0.82338],[0.21492,0.4826,0.84906],[0.43759,0.4924,0.75237],[-0.021308,-0.94171,-0.33574],[0.11753,-0.91884,-0.37673],[-0.73275,-0.6524,0.19355],[0.38721,0.24684,0.88834],[0.45204,0.14877,0.87951],[-0.52464,-0.78598,0.32709],[-0.53126,-0.75417,-0.38599],[-0.33928,-0.86579,-0.36783],[0.31313,-0.82805,-0.46505],[-0.79801,-0.40758,-0.44391],[-0.5814,0.21538,0.78459],[0.60748,-0.79199,-0.060928],[-0.77478,-0.63064,0.044777],[-0.74377,-0.18738,0.64164],[0.56796,-0.05585,0.82116],[-0.49901,-0.60134,-0.624],[0.37579,0.4861,0.78898],[-0.82852,-0.55769,0.050415],[0.19458,0.5985,0.77713],[0.51992,-0.23046,-0.82254],[0.19537,0.52585,0.82784],[-0.84852,-0.52587,0.059048],[0.74729,-0.65527,0.11035],[-0.46537,0.60518,0.6459],[-0.74434,0.38233,0.54752],[-0.63649,-0.02262,0.77095],[-0.58478,-0.060936,0.8089],[0.44002,0.45338,0.77513],[-0.90805,-0.23685,-0.34546],[-0.40934,-0.87019,0.27425],[-0.63228,-0.0038911,0.77473],[-0.35168,-0.92255,-0.1588],[0.77574,-0.01946,0.63075],[0.53556,-0.10247,-0.83826],[0.72217,-0.68173,-0.11708],[0.86505,0.47198,-0.17008],[-0.95897,-0.19569,-0.20513],[-0.79075,-0.47951,0.38051],[0.43848,0.41955,0.7948],[0.41666,0.032652,0.90848],[0.78648,-0.56918,-0.23976],[-0.90454,-0.19908,0.37705],[-0.63038,-0.72614,-0.27449],[-0.89326,-0.44197,0.082136],[-0.9757,0.0019099,0.2191],[-0.75924,0.57149,-0.31137],[0.61475,0.033853,-0.78799],[-0.67158,-0.6562,-0.34406],[0.60586,-0.48749,-0.62872],[-0.82168,-0.030646,-0.56912],[0.81975,-0.53734,-0.19821],[-0.86478,0.11776,0.48815],[-0.85734,-0.34856,0.37878],[-0.99029,-0.136,0.028798],[0.30256,0.28271,0.91024],[-0.86233,0.11885,0.4922],[0.75688,0.084326,0.64809],[-0.45862,0.25829,-0.85027],[0.75844,-0.64936,-0.055661],[0.71428,-0.66765,-0.20987],[0.69064,0.18551,-0.699],[-0.94234,-0.17864,-0.283],[0.62757,-0.46097,-0.62743],[0.35495,-0.86171,0.36258],[0.062395,0.53863,-0.84023],[0.096417,0.61578,-0.782],[0.75589,0.33979,0.55962],[-0.42796,0.4452,-0.78654],[0.67578,-0.21067,0.70636],[0.92175,0.10365,-0.37368],[0.19358,0.49002,0.84995],[0.052872,0.50024,-0.86427],[0.13568,0.5618,-0.81607],[-0.72942,0.15094,-0.6672],[-0.93394,0.082321,-0.34783],[-0.70111,-0.71001,0.065848],[0.99266,0.031533,-0.11673],[-0.96289,0.19699,-0.18451],[-0.69882,-0.45885,-0.54873],[0.67824,-0.45972,-0.57328],[-0.11315,0.38537,0.9158],[0.32441,-0.20645,0.92311],[-0.95991,0.24841,0.12987],[0.96006,0.26423,-0.092047],[0.65922,0.60299,0.44926],[-0.80005,0.16828,-0.57585],[0.706,-0.62732,-0.32868],[0.84253,-0.13718,-0.52089],[-0.75596,0.1069,-0.64583],[-0.66398,0.070288,0.74444],[-0.87751,-0.19252,0.43921],[0.80721,-0.55599,-0.19822],[-0.69261,-0.14215,-0.70717],[0.7918,-0.34252,-0.5057],[0.80072,-0.56959,-0.18548],[0.90981,0.35352,-0.21743],[0.10263,-0.95967,0.26173],[0.78934,-0.60603,-0.098357],[-0.85023,-0.028935,-0.52561],[0.90372,0.097131,0.41695],[-0.51802,0.53652,0.66619],[-0.84849,0.10408,0.51888],[0.80438,-0.47444,-0.35761],[-0.99934,-0.035126,0.0091515],[0.92659,0.36034,-0.10761],[-0.58993,0.12809,0.79723],[-0.78733,0.006663,-0.61649],[-0.80751,0.14946,-0.57061],[0.97079,0.22367,-0.08684],[0.12131,0.32949,0.93633],[-0.54475,-0.83563,-0.070457],[0.6249,-0.37114,0.68684],[0.76867,-0.62356,0.14257],[0.87188,0.3924,0.29301],[-0.87447,-0.30212,-0.37951],[-0.83075,0.15864,-0.53356],[0.92335,0.32863,-0.19854],[0.91794,0.099295,0.3841],[-0.67973,0.22999,0.69647],[-0.8535,0.17483,0.49089],[-0.40261,-0.56134,-0.72305],[0.17002,-0.92297,-0.34528],[-0.80429,-0.53846,-0.25135],[0.8886,0.42793,0.16514],[0.98442,-0.14878,0.093727],[-0.011765,-0.018044,0.99977],[0.91326,0.36421,-0.1825],[-0.86342,0.33407,0.37803],[0.74989,0.54289,0.37808],[-0.62719,-0.15518,-0.76325],[0.28473,-0.95832,-0.023352],[-0.76277,-0.046689,-0.64499],[0.52768,-0.76137,0.37664],[0.21374,0.41059,0.88641],[0.877,0.36412,0.31352],[0.0062937,-0.9991,-0.041876],[-0.18415,-0.98288,0.006308],[0.80881,0.21902,0.54576],[-0.72742,-0.11558,-0.67639],[0.7211,-0.68801,0.081623],[0.45567,-0.85515,0.24715],[0.22014,0.23899,0.94574],[-0.64351,-0.34055,0.68551],[0.48022,0.79712,0.36605],[-0.80552,0.17833,-0.5651],[0.41775,-0.88019,0.22529],[0.14003,-0.97594,0.16712],[0.11947,-0.99076,-0.064137],[-0.56869,0.58405,0.57921],[-0.80213,0.38778,0.45412],[0.24238,-0.86544,-0.43848],[0.50082,-0.55136,-0.66722],[-0.87871,-0.19366,0.43631],[0.69013,-0.17856,0.70131],[-0.08425,-0.79956,-0.59465],[-0.66858,0.27113,0.69245],[0.53931,0.72676,0.42539],[0.43432,0.72036,0.54078],[0.70618,-0.10704,-0.69989],[-0.81606,0.44996,0.36273],[0.90105,0.41486,0.12648],[0.66589,0.56543,0.48671],[-0.013889,0.91459,0.40413],[0.16806,-0.69377,0.70031],[0.041505,0.9148,0.40176],[-0.31962,0.73819,0.59407],[0.062957,-0.8387,-0.54094],[0.73319,0.24079,0.63597],[-0.92069,-0.38094,-0.084894],[-0.73838,0.48862,0.4648],[-0.92983,0.21048,-0.30186],[0.8006,0.44121,0.40544],[0.54847,0.76008,0.34851],[-0.91662,0.040401,-0.3977],[0.94642,0.10564,0.30516],[-0.27648,0.74648,0.60525],[0.34179,0.5493,0.76253],[-0.89985,-0.052126,-0.43307],[-0.91414,0.19385,-0.35604],[0.90203,0.43148,0.012756],[0.15715,0.40289,0.90165],[0.74326,0.62177,0.24691],[0.89654,0.16038,0.41291],[-0.025788,0.93899,0.34297],[0.31275,0.87342,0.37327],[-0.90362,0.0054739,-0.42829],[-0.65112,0.3183,0.689],[-0.76892,0.57629,0.27685],[-0.16382,0.83707,0.522],[-0.16713,0.80016,0.57604],[0.042696,0.96918,0.24263],[0.30493,0.9252,0.22589],[0.12476,0.88498,0.44861],[0.86736,0.31786,-0.38294],[0.67083,-0.68676,0.2799],[-0.85678,0.46721,-0.21826],[0.86014,-0.48757,-0.14976],[-0.83212,-0.54646,0.094633],[-0.82404,0.55934,0.090029],[0.9856,0.021713,-0.16768],[0.79426,0.59884,0.10271],[-0.81751,0.53927,-0.20215],[0.95428,0.15735,-0.25415],[-0.93348,0.19092,-0.30359],[-0.64682,0.6891,0.32675],[-0.66183,-0.15827,0.73276],[-0.20484,-0.40807,0.88967],[0.64538,0.76362,-0.019464],[-0.76757,0.59164,0.24658],[0.50941,0.84631,0.15576],[0.57776,0.79625,0.17937],[0.68123,-0.18894,0.70727],[0.66744,0.68206,-0.29886],[0.96047,0.16438,-0.22466],[0.60105,0.73897,-0.3044],[-0.061369,-0.31654,0.94659],[-0.77898,0.55058,-0.30009],[0.91074,0.31348,-0.26885],[-0.75913,-0.54251,0.35972],[0.42895,-0.81178,0.39624],[-0.52018,0.83506,0.17914],[-0.44902,0.8459,0.28782],[0.90716,0.35624,-0.22393],[0.55546,0.82917,-0.062717],[-0.8077,0.57607,-0.12554],[-0.74005,0.65148,0.16702],[-0.19347,0.94396,0.26741],[-0.10259,0.97368,0.20353],[0.22069,0.38054,0.89805],[-0.92115,0.3584,-0.15176],[0.73865,0.65934,-0.14023],[0.86538,0.50064,-0.021887],[-0.17966,0.97614,0.12194],[0.043565,0.99882,0.021518],[0.034602,-0.92152,0.3868],[0.32637,0.94325,-0.061314],[-0.32282,-0.735,-0.59629],[-0.3171,0.93502,0.15871],[-0.85176,0.52384,-0.0096183],[-0.70002,0.71086,0.068221],[0.060014,0.47298,0.87902],[0.91812,0.022075,0.3957],[0.77631,-0.083225,0.62483],[-0.909,0.38358,-0.16306],[0.8838,0.17748,0.4329],[-0.7022,0.67227,0.23444],[0.62396,-0.028684,0.78093],[0.52545,0.1465,0.83811],[-0.87406,0.28011,0.39693],[0.7162,0.58683,0.37773],[0.81526,0.56188,-0.14014],[0.069718,0.50401,0.86088],[-0.8326,0.15107,0.53288],[0.50621,0.22639,0.83216],[-0.70706,0.28554,0.64694],[-0.054406,0.9983,0.021117],[0.32449,0.32966,0.88659],[-0.65433,0.69705,0.29322],[0.17792,-0.9054,0.38548],[0.037611,0.57153,0.81972],[-0.46041,0.82477,0.3283],[0.15158,0.54148,0.82694],[0.24988,0.39519,0.88396],[0.14283,0.42152,0.8955],[0.19904,0.50565,0.83946],[-0.53966,0.28917,0.79066],[0.94121,0.20804,0.26616],[0.012649,-0.94865,-0.31607],[-0.14043,0.72799,0.67105],[-0.66514,0.67967,0.30925],[-0.39353,0.48152,0.78312],[-0.68319,0.58342,0.43916],[0.26099,0.93016,-0.25825],[0.40436,0.90341,-0.14266],[0.62239,-0.0013003,0.7827],[-0.06814,0.75112,0.65664],[-0.0031635,0.90547,0.4244],[0.014466,0.98051,0.19591],[-0.23314,0.96339,-0.1324],[0.71057,0.63751,0.29777],[0.090562,0.95353,-0.28735],[-0.32307,-0.71863,-0.61578],[-0.14848,-0.86374,-0.48157],[0.80992,0.1275,0.57251],[0.1264,-0.94927,-0.28794],[-0.053625,-0.99806,-0.031594],[0.024375,-0.89766,0.44002],[0.25181,-0.85742,-0.4488],[-0.27665,-0.95907,0.060361],[0.041378,-0.99421,0.099131],[-0.62956,0.71913,0.29412],[0.21539,-0.81683,0.53516],[0.49499,-0.7681,-0.40622],[0.66699,-0.011788,0.74497],[-0.50349,0.71547,0.48436],[-0.33636,-0.87126,0.35746],[0.32836,-0.85527,0.40086],[0.53097,-0.64752,-0.54662],[0.69401,0.70052,-0.16616],[0.56768,-0.73836,-0.36409],[-0.40409,0.78899,0.46283],[-0.41339,-0.81963,0.39663],[-0.15773,-0.9107,0.38177],[0.16447,-0.97681,0.13706],[0.15273,-0.95725,-0.24565],[-0.54795,0.30726,0.77803],[0.80406,0.46659,0.36849],[0.5243,0.74713,0.40855],[-0.066791,-0.36399,-0.929],[-0.38202,-0.74263,-0.55006],[0.62296,-0.72577,0.29185],[0.072387,-0.2631,0.96205],[-0.43368,-0.78524,-0.44194],[0.32472,-0.9392,0.11165],[0.4129,-0.90222,0.1245],[0.13918,-0.85785,-0.49469],[-0.44259,0.8834,0.15401],[0.40476,-0.81038,0.42362],[0.015219,-0.69541,-0.71845],[-0.14284,-0.44759,-0.88276],[0.18218,-0.336,-0.92407],[0.40788,-0.17943,-0.89523],[-0.57523,-0.77782,0.25318],[0.32649,0.85012,0.41315],[0.45347,-0.76834,0.45169],[0.34981,0.85855,0.37486],[-0.76281,-0.51796,0.38709],[0.73226,0.66219,0.15906],[-0.77782,-0.30291,-0.55067],[0.56616,-0.80277,-0.18713],[-0.4716,0.65946,0.58542],[0.6858,0.65453,0.31822],[-0.67948,0.70451,0.20487],[-0.85288,0.48714,0.18788],[0.39115,-0.44138,-0.80758],[0.27569,0.82035,0.50101],[0.68686,-0.67338,-0.27347],[-0.9582,0.21051,0.19376],[-0.76657,-0.38446,-0.51436],[-0.30078,0.29205,0.90788],[0.78754,-0.55175,-0.27451],[-0.56758,-0.73861,0.36375],[-0.70741,-0.61562,0.34724],[0.47466,-0.29586,-0.82895],[-0.37723,0.31163,0.87212],[-0.18131,-0.89108,-0.41605],[0.065641,-0.90635,-0.41739],[0.80623,0.27082,0.52598],[-0.79347,-0.38397,-0.47219],[0.73786,-0.62647,-0.25121],[-0.0051424,0.80069,0.59905],[0.93489,0.18046,-0.30563],[0.47855,-0.70503,-0.52337],[-0.4106,0.58973,0.69543],[-0.44639,-0.78606,0.4276],[0.92324,0.25919,-0.28364],[0.23146,-0.83813,0.49392],[-0.65672,-0.62683,-0.4193],[0.24431,0.8608,0.44646],[0.66185,-0.62679,-0.41121],[-0.37639,-0.85107,0.36606],[-0.34116,-0.86484,0.36831],[-0.80449,-0.57344,0.15479],[-0.23582,0.33001,0.91405],[-0.36574,-0.81659,0.44656],[0.48775,-0.21774,-0.8454],[-0.43236,-0.83552,-0.33909],[-0.30061,-0.90497,-0.30109],[-0.52243,-0.76378,-0.37909],[-0.77894,0.36899,0.50705],[-0.40597,-0.80241,0.43741],[0.89123,0.23473,0.38809],[-0.466,-0.87145,-0.15305],[0.60271,-0.75392,-0.26142],[-0.96615,-0.14706,-0.21196],[0.68319,-0.72976,-0.026537],[-0.60122,-0.65888,0.45212],[0.54066,-0.034503,-0.84053],[-0.51116,-0.77611,-0.36929],[0.31711,0.90067,0.29704],[-0.28578,-0.22588,0.93129],[0.7228,0.42182,0.54739],[0.21519,0.83983,0.49838],[0.55277,-0.819,-0.15389],[0.75086,0.65341,-0.096219],[-0.79562,0.23603,0.55792],[0.67054,-0.686,-0.28244],[-0.9411,-0.16501,-0.29513],[-0.16112,-0.2989,0.94058],[-0.74487,-0.54887,-0.37937],[0.66539,-0.5706,-0.48133],[0.59199,0.13343,-0.79482],[0.45908,-0.46878,0.75465],[-0.82815,0.065962,-0.55661],[-0.89284,0.094462,0.44036],[-0.82292,-0.39595,-0.40746],[-0.13818,0.56218,-0.81539],[-0.80645,0.40317,0.43253],[0.752,0.28783,-0.59301],[0.62654,0.34613,-0.69831],[0.099492,-0.29436,0.9505],[-0.42172,-0.87206,0.24831],[0.0754,0.54299,-0.83634],[-0.39045,0.3884,-0.83468],[0.74547,-0.59176,-0.30675],[-0.67231,0.617,-0.40903],[0.42601,0.63878,0.64068],[-0.73783,0.20346,-0.6436],[-0.19438,0.49011,-0.84971],[0.7034,-0.59011,0.39624],[0.64139,-0.67471,0.36522],[-0.56633,-0.60258,-0.56229],[0.0094179,-0.13961,0.99016],[-0.73286,0.24801,-0.63356],[0.58869,0.80832,0.0078402],[-0.61504,-0.37123,0.69564],[-0.14305,-0.45413,-0.87937],[0.84434,-0.18307,-0.50357],[0.28422,-0.11626,0.95168],[-0.67163,0.73347,0.10459],[0.65434,-0.70232,-0.28034],[-0.16402,-0.47591,0.86406],[0.85138,-0.42621,0.30576],[0.84833,0.22971,-0.47704],[0.79115,0.32605,-0.51747],[0.85085,-0.13959,-0.50652],[-0.71875,0.11257,-0.68609],[-0.031093,-0.37951,0.92466],[-0.8782,-0.08129,0.47134],[-0.74827,0.52776,0.40196],[-0.21143,-0.68442,0.69776],[0.10968,-0.18656,0.9763],[0.38813,-0.21678,0.89575],[-0.31679,-0.76438,0.56157],[-0.78916,0.029788,-0.61347],[-0.86913,-0.40572,0.28284],[0.89032,0.33977,-0.30314],[-0.66695,-0.010646,-0.74502],[-0.55983,-0.82817,-0.027038],[0.69358,-0.36458,-0.62131],[-0.14533,-0.045642,0.98833],[-0.84521,-0.15671,0.51094],[0.87205,-0.27571,-0.40436],[0.80163,-0.19826,-0.56398],[-0.8439,0.016021,-0.53626],[-0.79669,-0.02774,0.60375],[0.07404,0.096695,0.99256],[0.32742,0.72951,0.60051],[-0.6329,0.10853,-0.76659],[0.69163,-0.024316,0.72185],[0.87979,-0.44521,-0.16662],[0.99703,0.047987,-0.060214],[-0.76271,0.20653,0.61288],[-0.67963,0.07308,-0.7299],[0.96931,-0.22775,0.092578],[0.076129,0.9613,0.26478],[0.1976,0.72922,0.65513],[0.78418,0.12545,0.60772],[-0.76303,0.36301,0.53479],[-0.11132,-0.79486,-0.59649],[0.5116,-0.66967,-0.53833],[0.13718,-0.89919,-0.41549],[-0.37987,-0.54982,0.7439],[-0.71249,0.11188,-0.69271],[0.32288,-0.71359,-0.62172],[0.79156,0.51474,0.32934],[0.11058,-0.063101,0.99186],[-0.29209,-0.5051,-0.81213],[0.36763,-0.92048,-0.13254],[-0.75907,-0.51312,-0.40066],[-0.80777,0.33731,0.48346],[-0.38604,0.91124,0.14361],[-0.57958,0.032573,-0.81426],[-0.50821,0.71189,0.48471],[-0.76775,0.37754,0.5177],[0.42242,-0.90302,-0.078171],[-0.48156,-0.81551,-0.32102],[0.79796,0.60262,0.010369],[-0.63311,0.18676,-0.75119],[0.15851,-0.40173,0.90193],[0.62224,0.73031,0.28189],[0.29145,-0.18209,0.93909],[0.84989,-0.5256,0.037858],[-0.50099,0.53311,0.68177],[0.91812,0.39528,0.028378],[0.10958,-0.38109,0.91802],[0.47379,0.84008,0.26417],[-0.61219,0.27493,-0.74138],[0.15568,-0.26222,0.95237],[0.72513,0.61777,-0.30421],[0.14723,0.18308,0.97201],[-0.59901,-0.27993,-0.75022],[-0.68209,0.73125,0.0058399],[-0.22157,-0.48433,0.84637],[0.096613,-0.99379,0.055282],[-0.083239,-0.47813,0.87433],[-0.42943,-0.48982,-0.75873],[-0.51095,0.66226,0.54804],[0.55218,0.73783,0.3882],[0.078747,-0.95752,-0.2774],[0.46913,0.87021,0.15052],[-0.38972,-0.3226,-0.86258],[0.19868,-0.69953,0.68642],[0.096135,0.91224,0.39822],[-0.09022,0.94934,0.30101],[-0.68454,-0.28926,-0.66913],[0.36217,0.91034,0.20029],[-0.42051,0.76539,0.48719],[0.70823,0.36005,-0.60727],[-0.88955,0.14239,-0.43407],[-0.53482,0.84149,0.076536],[-0.24872,-0.50384,0.82722],[-0.35876,0.7625,0.53841],[0.72746,0.30998,-0.61214],[-0.16667,0.75631,0.63263],[0.041128,-0.5658,0.82351],[0.23821,-0.96808,-0.07792],[0.42395,0.78255,0.45594],[-0.9074,0.40285,0.11972],[-0.43311,0.71737,0.54571],[-0.35409,0.85435,0.3804],[0.51287,0.68307,0.51998],[0.74461,0.31055,-0.59086],[0.23342,-0.41302,0.8803],[-0.14581,0.94394,0.29616],[-0.018318,0.95392,0.2995],[-0.90667,0.29244,-0.30401],[0.81293,0.58232,-0.0070178],[0.92964,0.12982,-0.34484],[0.5736,-0.30587,0.75988],[-0.68288,0.68697,0.24851],[0.86018,0.040466,-0.50838],[-0.29731,-0.35929,0.8846],[-0.90355,0.21288,-0.37186],[0.85558,-0.02582,0.51702],[0.83937,0.3583,-0.40875],[-0.6801,0.71037,0.1812],[0.67658,0.71556,0.17379],[0.91353,0.25585,-0.31622],[0.63717,-0.21951,0.7388],[-0.79112,0.57476,0.20924],[0.75029,0.64875,0.12725],[-0.63982,0.75358,0.1508],[0.43119,-0.87003,0.23902],[-0.3797,0.87196,0.30904],[0.41447,0.89178,-0.18151],[0.50839,0.68137,0.52657],[-0.82014,0.55469,-0.14033],[0.77121,0.61961,-0.14603],[0.28431,0.95813,-0.033867],[-0.27321,0.9498,0.15244],[-0.36718,0.91604,0.1614],[0.52915,0.84802,-0.029391],[-0.35552,0.92283,0.14827],[0.0081612,0.99995,-0.0063021],[0.031626,0.3221,0.94618],[-0.49244,0.73957,0.45884],[-0.037793,0.93118,0.36259],[0.20982,0.93299,0.29241],[0.49595,0.86707,0.047122],[0.92806,0.37242,-0.0018855],[-0.64621,0.75422,0.11649],[-0.82333,0.54391,-0.16214],[-0.054499,0.99577,0.073984],[-0.28718,0.95164,0.10914],[0.68546,0.11544,0.7189],[-0.83414,0.50298,0.22633],[0.39049,-0.65422,0.64769],[-0.44742,-0.070655,0.89153],[0.64961,0.21842,0.72822],[0.73768,-0.63385,0.23252],[0.44256,0.59602,0.67],[-0.77093,0.25534,0.5835],[0.23067,-0.24955,0.94049],[0.53077,0.42155,0.73524],[0.33433,0.39154,0.85728],[-0.13507,-0.40257,0.90537],[-0.66521,0.2521,0.70281],[0.41611,0.41328,0.80997],[-0.068819,-0.53091,0.84463],[-0.29102,-0.44904,0.84479],[0.35787,0.90864,-0.21517],[-0.099054,0.98883,0.11141],[-0.28649,0.91636,0.27964],[-0.51191,0.61483,0.59995],[-0.59661,0.29536,0.74621],[-0.12291,0.97381,0.19127],[-0.30143,0.83709,0.45652],[0.37007,0.55214,0.74712],[-0.90339,-0.22353,0.36595],[-0.07391,0.56733,0.82017],[0.23007,-0.66643,0.70918],[0.45319,0.18536,0.87193],[-0.2168,-0.9393,-0.26592],[0.29732,0.94381,-0.14433],[0.35588,0.9247,-0.13521],[-0.099905,0.78241,0.6147],[-0.32777,-0.038533,0.94397],[0.19513,-0.60413,0.77263],[-0.51224,-0.40226,0.75881],[0.28262,-0.46728,0.83772],[-0.25975,0.56696,0.78172],[-0.36677,0.65465,0.66099],[-0.18328,0.94164,0.28235],[-0.52396,0.29124,0.8004],[0.55088,-0.34827,0.75844],[-0.2743,0.96163,0.0042197],[0.020303,0.97858,-0.20486],[0.26743,0.95178,-0.15034],[-0.20513,0.9689,-0.13843],[0.009612,0.9833,-0.18173],[0.44548,0.88669,0.12386],[0.60973,0.79015,0.062386],[0.96694,-0.095362,0.23651],[-0.080608,-0.17703,-0.9809],[0.80218,-0.20504,0.56077],[-0.010308,-0.18803,-0.98211],[0.065597,-0.17736,-0.98196],[-0.45711,-0.39532,0.79672],[-0.12469,-0.14658,-0.98131],[-0.2774,-0.33748,0.89953],[-0.04522,-0.095059,-0.99444],[0.047114,-0.067025,-0.99664],[0.17255,-0.12246,-0.97736],[0.15149,-0.019858,-0.98826],[-0.1699,-0.13247,-0.97652],[-0.061509,-0.093441,-0.99372],[0.22361,0.045013,-0.97364],[-0.00070501,-0.024745,-0.99969],[0.050183,0.011614,-0.99867],[0.14082,0.060706,-0.98817],[-0.60989,0.095157,0.78676],[-0.17184,-0.084631,-0.98148],[-0.66529,0.65962,-0.3497],[0.082733,-0.14922,0.98534],[0.016523,-0.0037684,-0.99986],[-0.18811,-0.9417,-0.27895],[-0.083427,-0.029197,-0.99609],[0.052925,0.048689,-0.99741],[-0.22256,-0.95141,-0.21282],[-0.34665,-0.21237,0.91364],[-0.19149,-0.013134,-0.98141],[-0.16421,0.035995,-0.98577],[0.073264,0.10387,-0.99189],[0.144,0.16208,-0.97621],[0.70953,-0.042356,0.7034],[-0.040763,0.12114,-0.9918],[0.028502,0.13369,-0.99061],[0.085189,0.22213,-0.97129],[0.34427,-0.48083,0.8064],[-0.014169,-0.99412,0.10737],[0.024701,0.58919,0.80762],[-0.13417,0.60649,0.78369],[0.019481,0.22352,-0.9745],[-0.53167,-0.41233,0.7398],[-0.48706,0.17075,0.85651],[-0.038711,0.62749,0.77766],[0.030569,-0.9143,-0.40388],[-0.102,-0.96711,-0.23301],[-0.76552,0.37044,0.52608],[0.62853,-0.17027,0.75892],[-0.57082,-0.79948,-0.18706],[-0.31191,-0.92923,-0.19809],[-0.6107,-0.28825,0.73754],[-0.091727,-0.9903,-0.10437],[0.28721,-0.9073,-0.30711],[0.2602,0.95351,-0.15206],[0.65681,-0.17831,0.73267],[-0.44018,-0.8816,0.17036],[-0.15388,-0.96809,0.1978],[0.19833,-0.85833,0.47321],[0.24722,-0.79634,0.55202],[-0.28338,-0.48833,-0.82536],[0.036001,-0.51345,-0.85736],[0.63905,-0.28052,0.71619],[0.20518,-0.96143,-0.1832],[0.10119,-0.6441,0.75822],[-0.45916,-0.83006,0.31651],[0.17643,-0.87587,0.44913],[0.24276,-0.88529,0.39664],[0.2797,-0.32746,0.90252],[-0.28394,-0.54424,-0.78942],[0.20417,-0.20188,-0.95789],[0.43974,-0.1081,-0.8916],[0.61175,-0.27336,0.74232],[0.15013,-0.98007,0.13008],[-0.62484,-0.60765,-0.49024],[-0.13528,-0.89392,0.42732],[0.075855,-0.99507,0.063817],[-0.01032,-0.98011,-0.19817],[-0.0067355,-0.93687,-0.3496],[0.0081681,-0.88949,-0.45687],[-0.64252,0.19063,0.74218],[-0.068761,-0.77315,-0.63048],[0.49392,-0.12417,-0.8606],[-0.55279,-0.82512,-0.11663],[0.65173,-0.71827,-0.24359],[-0.66723,-0.66439,-0.33674],[-0.14885,-0.98627,0.071493],[0.44193,-0.8946,-0.066323],[-0.57356,-0.70458,0.41785],[0.40649,-0.3408,-0.84771],[-0.84448,-0.47981,-0.23799],[0.46829,-0.85369,-0.22786],[0.35689,-0.46881,-0.80799],[0.62264,-0.73228,0.27582],[0.78762,-0.40081,0.46799],[-0.50001,-0.32758,0.80167],[0.67029,0.6637,-0.33198],[0.37872,-0.46869,-0.79806],[0.38719,-0.7193,0.5768],[-0.86916,-0.24086,0.4319],[0.029593,0.53019,0.84736],[0.70333,-0.47323,-0.53045],[0.077427,-0.80533,-0.58775],[0.78323,0.17835,0.59561],[0.84597,-0.52377,-0.10001],[0.42155,-0.30429,-0.85423],[-0.60954,-0.51451,-0.60311],[-0.39378,-0.2763,0.87669],[-0.17117,-0.98072,0.094259],[-0.40537,-0.8032,0.43651],[-0.99581,0.060209,0.068805],[0.58677,0.37716,0.71655],[0.78099,-0.56196,-0.27249],[0.73883,-0.66618,0.10172],[-0.31675,-0.9227,-0.21976],[-0.22284,-0.97302,-0.059796],[0.32006,-0.48652,0.81293],[0.463,-0.30689,0.83154],[-0.42152,-0.2086,0.8825],[-0.36454,-0.92044,-0.14105],[0.13997,-0.61929,0.77259],[0.47945,-0.14069,-0.86622],[0.70467,-0.70641,-0.066561],[-0.5875,-0.29167,0.75483],[0.53498,-0.00026113,-0.84486],[0.50158,-0.83687,-0.21923],[0.46502,-0.86038,-0.20857],[-0.98377,-0.12931,-0.12437],[0.88364,0.32662,0.33542],[-0.57444,-0.74046,-0.3489],[0.48615,-0.30353,0.81947],[-0.97351,-0.20535,-0.10058],[-0.78695,-0.21186,0.5795],[-0.06087,-0.99738,0.039196],[0.64344,0.047576,0.76401],[-0.96919,-0.22866,-0.091535],[-0.47743,-0.37986,0.79232],[-0.06294,-0.99747,0.033188],[0.54801,0.10199,-0.83023],[-0.10437,-0.99397,0.033721],[0.68652,-0.014655,0.72697],[-0.70118,-0.59135,-0.39831],[0.70926,-0.63594,-0.30419],[0.81548,-0.40531,0.41318],[-0.97436,-0.0913,-0.20566],[0.0051463,-0.023784,0.9997],[0.78057,-0.56943,-0.25781],[-0.78879,-0.46844,-0.39796],[-0.56865,-0.046279,0.82128],[0.72727,-0.59321,-0.34523],[-0.69979,-0.095749,0.7079],[-0.6948,-0.55706,-0.45491],[-0.90528,0.372,0.20515],[0.070682,-0.99578,-0.058492],[0.58288,-0.24073,0.77608],[-0.092319,0.48951,0.8671],[0.77078,-0.41739,-0.48134],[-0.85405,0.10714,-0.50905],[-0.38119,-0.49072,0.78351],[-0.9083,-0.0026136,0.4183],[0.71585,0.30315,-0.62901],[0.10669,0.58733,-0.80229],[-0.60321,-0.57124,-0.55662],[-0.50761,0.44331,-0.73879],[-0.1098,0.53167,-0.83981],[-0.66639,0.21325,-0.71446],[0.75772,-0.60081,-0.25472],[-0.89037,-0.19536,-0.4112],[-0.65129,-0.44558,-0.61423],[-0.72976,0.6387,0.24397],[-0.020226,0.64213,-0.76633],[-0.66155,-0.27396,-0.69807],[-0.776,0.10918,-0.62121],[0.52935,0.030727,0.84785],[0.57374,0.12122,-0.81002],[-0.45988,-0.61343,0.64204],[0.64378,0.54915,-0.5329],[0.46435,0.38742,-0.79642],[0.42649,-0.50148,0.75274],[0.70005,-0.31035,-0.64312],[0.80008,0.58289,-0.1418],[0.99703,0.076486,0.0086285],[0.96902,-0.19352,-0.15348],[-0.78837,0.015318,-0.61501],[-0.76188,0.058377,0.64508],[0.8415,0.51241,0.17121],[-0.57931,-0.48552,0.65473],[0.8868,-0.11071,-0.4487],[-0.64453,0.066678,0.76167],[-0.76664,-0.26246,-0.58598],[0.58866,0.15423,0.79353],[0.90783,-0.38548,-0.16508],[-0.73328,0.14326,-0.66466],[-0.45843,-0.47995,0.74799],[0.97355,-0.19954,-0.11131],[0.94494,0.3231,-0.051901],[-0.53615,-0.19014,0.82243],[-0.83121,0.24045,0.50126],[0.73254,-0.46182,-0.50011],[-0.39808,-0.07989,-0.91387],[-0.07194,-0.13161,0.98869],[-0.66525,-0.64326,-0.37902],[-0.12059,-0.49676,-0.85947],[-0.39482,-0.64337,-0.65589],[-0.0083657,-0.70358,-0.71057],[0.3888,-0.90065,-0.1941],[-0.52442,-0.13589,0.84054],[0.62051,-0.41226,0.66709],[-0.53016,-0.43531,0.72762],[-0.53713,-0.021087,-0.84324],[-0.61644,0.74412,0.25747],[0.6929,0.52074,0.49872],[-0.079242,-0.066785,0.99462],[0.40036,-0.89771,-0.18393],[0.27778,-0.93892,-0.20317],[0.68551,-0.092309,0.72219],[0.79095,-0.20263,-0.57735],[-0.66035,0.19174,-0.72607],[-0.010545,-0.93389,-0.35739],[0.89896,-0.41505,0.13998],[-0.5767,-0.19106,-0.7943],[0.92045,-0.25958,0.29223],[0.055893,-0.18714,0.98074],[-0.39004,-0.37405,-0.8414],[-0.62527,0.4795,0.61573],[-0.62325,0.57913,0.52551],[-0.64465,0.20902,-0.73535],[0.60662,-0.78519,0.12446],[0.55023,0.35195,0.75721],[-0.92658,0.098134,0.36307],[-0.24762,-0.38379,-0.8896],[0.088674,-0.060731,0.99421],[0.74724,-0.58861,-0.30848],[0.42433,0.28952,0.85798],[0.43839,0.85888,0.26484],[0.094101,-0.83912,-0.53574],[-0.7191,0.41016,0.56096],[0.86771,-0.43688,0.23711],[0.98431,-0.087518,0.15323],[0.53998,0.80794,0.23592],[-0.64426,0.42481,-0.63598],[0.48987,-0.40629,-0.77133],[-0.52977,-0.10977,-0.84101],[-0.37862,0.70413,0.6007],[-0.40601,0.72673,0.55408],[-0.17121,0.72617,0.66586],[0.52588,0.72712,0.44131],[-0.64772,0.5058,-0.56976],[-0.73974,-0.024304,0.67246],[0.69618,0.1644,-0.69879],[-0.6673,-0.019022,-0.74455],[0.92583,0.32986,0.1845],[0.83494,0.087609,-0.54332],[-0.18344,0.08259,0.97956],[-0.85522,0.31059,-0.41489],[0.91701,0.37131,0.14572],[-0.28624,0.81873,0.49774],[-0.52363,-0.33427,0.78363],[-0.94593,-0.069349,-0.31686],[0.81377,-0.091491,-0.57394],[-0.76975,0.39079,-0.50474],[-0.87908,0.47366,-0.05351],[-0.15804,0.88096,0.44602],[0.68293,-0.43397,0.5876],[-0.95872,0.10709,-0.2634],[0.53948,0.37318,0.75479],[0.94826,0.29705,0.11212],[-0.31559,0.87073,0.37713],[-0.5392,-0.61379,0.57665],[0.37892,0.85435,0.35567],[0.1001,0.90342,0.41692],[-0.60443,0.21271,0.76773],[0.20278,-0.28562,0.93664],[-0.77504,0.55316,0.30549],[0.15438,0.90768,0.39024],[-0.60445,0.2446,0.75816],[0.8292,0.52704,0.18616],[0.48657,-0.62798,0.60736],[-0.6825,0.52928,0.50404],[0.77608,0.11264,-0.6205],[0.76671,0.64132,0.029246],[0.087287,-0.48921,0.86779],[-0.48347,-0.63508,0.60244],[-0.96616,0.21669,-0.1399],[0.51559,-0.13278,0.84648],[0.58672,0.76188,0.2744],[-0.71082,0.086689,0.69801],[-0.89279,0.056602,-0.44691],[0.72348,0.33087,0.60589],[0.10148,-0.48357,0.8694],[0.19825,-0.28997,0.93628],[0.90327,0.34053,-0.26103],[0.75351,0.63314,0.17707],[-0.38521,0.57519,0.72165],[-0.47291,0.79086,0.38844],[-0.22968,0.55987,0.79611],[0.55522,0.8101,0.18832],[0.92208,0.36943,-0.11531],[-0.3423,0.86884,0.3577],[-0.59478,0.066601,0.80113],[0.067841,0.033886,0.99712],[0.56088,0.79542,0.22961],[0.17834,0.95158,0.25037],[0.28625,0.93227,0.2212],[-0.27975,0.91666,0.28545],[-0.37527,0.9016,0.21514],[-0.85852,0.50624,0.081703],[0.77622,0.28539,0.56217],[0.76209,0.64639,-0.037409],[0.79065,0.48198,0.37758],[0.28354,0.91459,0.28834],[-0.67009,-0.37923,0.63809],[0.054012,0.96008,0.27446],[0.25174,0.95085,0.1803],[-0.080449,0.93771,0.33797],[0.9158,0.36888,-0.15888],[-0.77397,0.63226,-0.034935],[-0.67789,0.70601,-0.20496],[0.93357,0.34578,0.094232],[0.88845,0.25721,0.38013],[0.72572,-0.16256,0.66851],[-0.84456,0.50814,-0.16884],[0.54141,-0.58619,0.60271],[0.77204,0.19137,0.60608],[-0.83723,0.54676,-0.0097919],[0.75871,0.64106,0.11578],[0.4582,-0.54499,0.70217],[-0.8041,0.46884,0.36553],[-0.33965,0.59628,0.72738],[-0.85466,0.30174,0.4225],[0.65415,0.36947,0.65998],[0.86494,-0.21791,-0.45211],[0.74185,-0.66883,-0.048191],[0.64873,-0.17996,0.73943],[-0.83294,0.26861,-0.4838],[0.26146,0.68335,0.68167],[0.51634,0.52667,0.67528],[-0.62242,0.39952,0.67303],[-0.036744,0.090531,0.99522],[-0.4324,0.52405,0.73376],[0.21198,0.9713,-0.10789],[0.4247,0.51569,0.7441],[0.14933,0.69055,0.7077],[-0.82029,0.069688,0.56769],[0.84869,-0.50069,-0.17042],[0.72594,0.68651,0.04133],[0.18785,0.98029,-0.061149],[-0.71498,-0.57425,0.3988],[0.1531,0.988,-0.020478],[-0.21545,0.85566,0.47057],[-0.3095,0.89767,0.31367],[-0.99553,-0.086769,-0.037369],[-0.23971,0.66892,0.70363],[0.13706,0.9811,-0.1366],[-0.8399,0.2458,-0.48388],[-0.019602,-0.22924,-0.97317],[0.56773,-0.53089,0.62916],[0.035201,-0.18964,-0.98122],[-0.059129,-0.22655,-0.9722],[0.48321,0.82616,0.28975],[0.057899,-0.076757,0.99537],[-0.15201,-0.29635,-0.9429],[-0.0069366,-0.19607,-0.98056],[0.10553,-0.22411,-0.96883],[-0.59843,-0.093857,0.79566],[-0.18776,-0.21802,-0.95771],[0.17069,-0.20245,-0.9643],[-0.14751,0.38078,0.91282],[0.30455,0.85216,0.42553],[0.69747,-0.7123,0.078453],[-0.0044497,0.20084,0.97961],[-0.24332,-0.18899,-0.95136],[0.34311,0.82537,0.44837],[0.22971,-0.04339,-0.97229],[-0.24679,-0.147,-0.95786],[-0.010872,-0.040772,-0.99911],[-0.90501,-0.18895,0.38112],[0.91616,-0.12676,-0.38024],[-0.34268,-0.17046,-0.92386],[0.65951,0.72774,0.18827],[-0.35865,0.54795,0.75573],[-0.093387,0.073696,-0.9929],[0.051842,-0.027636,-0.99827],[-0.067723,-0.78617,0.61429],[-0.6117,0.57073,0.54781],[-0.36367,-0.65955,0.65782],[0.20692,0.13813,-0.96856],[0.35288,0.13587,-0.92575],[-0.26519,-0.078512,-0.961],[0.26546,0.23449,-0.93517],[0.83637,0.36571,-0.40834],[-0.73056,0.22648,-0.64419],[0.61926,-0.47625,0.62426],[0.21525,0.23787,-0.94715],[-0.094433,0.72945,0.67749],[-0.38654,-0.099709,-0.91687],[-0.33476,-0.0046944,-0.94229],[0.53694,0.84297,-0.033052],[-0.26079,0.058352,-0.96363],[-0.96072,0.1298,0.24531],[0.15781,0.26663,-0.95079],[0.23507,0.34017,-0.91051],[-0.17468,-0.15315,0.97264],[-0.5685,0.51423,-0.64217],[-0.26509,0.21843,-0.93916],[-0.17112,0.18512,-0.9677],[-0.010913,-0.26008,0.96553],[-0.49278,-0.77081,0.40375],[-0.14668,-0.98859,-0.034205],[0.12841,-0.93907,-0.31885],[-0.17031,-0.9659,-0.19501],[-0.062981,-0.99621,-0.060019],[0.18935,-0.96372,-0.18812],[0.32191,-0.88914,0.32529],[-0.30407,-0.60401,-0.73669],[-0.049789,0.95847,-0.2808],[0.015921,-0.77146,-0.63608],[0.30366,-0.69812,-0.64839],[0.28382,0.95506,-0.08546],[-0.29335,0.25705,-0.9208],[-0.03385,0.24917,-0.96787],[0.11453,0.29553,-0.94844],[0.19689,0.35395,-0.9143],[-0.52603,-0.82913,0.18933],[0.16858,-0.92762,-0.33332],[-0.0077178,-0.9454,-0.32581],[0.36992,-0.92155,-0.1179],[0.77697,0.43448,-0.45556],[-0.3068,0.5458,0.77973],[-0.0014828,-0.82832,0.56025],[-0.36741,-0.62535,-0.68844],[0.44811,-0.38728,-0.80574],[0.50323,-0.45535,-0.73445],[0.49034,-0.58008,0.65044],[-0.17037,0.27942,-0.94493],[0.049293,0.36035,-0.93151],[0.14184,-0.27018,0.9523],[0.17568,0.91258,-0.36924],[0.65998,-0.69757,-0.27895],[-0.33745,-0.82475,0.45378],[0.15955,0.70682,0.68916],[-0.68796,0.60476,0.40121],[0.55466,-0.12522,-0.8226],[-0.61554,-0.7845,0.075295],[-0.51124,-0.69591,0.50432],[-0.41574,-0.2478,0.87507],[0.67507,0.044806,0.73639],[-0.28207,-0.88784,0.36356],[-0.011363,-0.99116,-0.13222],[0.84932,0.34367,0.40068],[-0.57951,-0.78065,0.23398],[-0.62467,0.29389,0.72347],[0.81618,-0.27355,-0.50894],[-0.39583,-0.74032,0.54337],[-0.29477,-0.82266,0.48616],[-0.69962,0.67646,-0.23006],[0.31883,0.93861,-0.13178],[-0.68895,-0.68751,0.22951],[0.29302,-0.95182,0.090428],[-0.75161,-0.59861,0.27701],[0.27978,-0.95994,0.015346],[0.43852,-0.8963,-0.06588],[0.35829,-0.46481,-0.80968],[-0.84255,-0.5331,-0.076833],[-0.83293,-0.21491,0.50995],[-0.68935,-0.57862,0.43588],[0.61452,-0.1682,0.77076],[-0.57644,0.095134,0.81158],[0.67783,-0.73169,-0.071968],[-0.66002,-0.70907,0.2482],[0.41521,-0.59546,0.68777],[0.00029454,-0.86801,-0.49655],[-0.40258,-0.35215,0.84493],[-0.37408,-0.23473,0.8972],[0.9109,0.18865,0.36697],[-0.035903,0.63843,0.76885],[0.85487,-0.50367,-0.12456],[-0.67466,-0.69685,0.24337],[0.69346,-0.34108,0.63465],[-0.44655,-0.56579,-0.69316],[-0.24868,-0.71491,-0.6535],[0.2695,-0.66667,-0.69492],[-0.89131,-0.45035,-0.052488],[0.67855,0.1443,0.72024],[0.40278,-0.23478,-0.88467],[0.39758,-0.24717,-0.88365],[0.42322,0.71227,-0.55997],[0.55567,-0.49636,-0.66697],[-0.94939,-0.21236,-0.23143],[0.87778,-0.47883,-0.015128],[0.4662,0.76082,-0.45146],[-0.43565,-0.79301,0.42583],[0.43981,-0.14286,-0.88665],[-0.37423,-0.51515,-0.77109],[0.68177,-0.41405,-0.60312],[0.80716,-0.58068,-0.10631],[-0.17302,-0.17132,0.9699],[-0.30597,0.85416,0.42047],[-0.29643,-0.76974,0.56535],[-0.45301,0.88917,-0.064467],[0.49973,0.77684,0.38314],[-0.38656,-0.72855,0.56549],[0.50449,-0.0032196,-0.86341],[-0.34539,-0.64857,-0.67828],[-0.53813,0.78068,0.31773],[0.64383,-0.55969,-0.52176],[-0.99179,-0.1185,-0.048154],[0.65674,-0.75255,-0.048549],[-0.40384,-0.71933,0.56522],[-0.40884,-0.77243,0.48601],[-0.18031,-0.45316,-0.873],[-0.31405,0.87521,-0.36793],[-0.42474,-0.55132,-0.71809],[0.43725,-0.70993,-0.5521],[-0.12615,0.88119,-0.45562],[0.72199,-0.68557,-0.093409],[-0.59261,-0.41283,0.69165],[0.020932,0.73796,0.67452],[-0.66421,0.30012,0.68465],[0.28116,0.80573,-0.52129],[-0.65002,-0.1473,0.74551],[0.04326,0.71196,0.70088],[-0.58396,-0.63255,-0.50879],[-0.056487,-0.9552,-0.29054],[0.60872,-0.75913,-0.23061],[0.76028,-0.58025,-0.29204],[-0.39801,0.86266,0.31209],[-0.91607,0.39429,-0.073103],[0.84243,0.25643,0.47387],[-0.71217,-0.09153,0.69601],[0.56576,0.24045,-0.78873],[0.68007,-0.65339,-0.33255],[0.87888,-0.4718,-0.070474],[-0.59375,-0.45251,-0.66535],[0.69595,-0.6691,-0.26071],[0.17546,-0.92174,-0.34584],[-0.4018,-0.072621,0.91284],[-0.70757,-0.37311,-0.60011],[-0.98821,-0.15304,-0.0043238],[0.01092,-0.087742,0.99608],[0.57517,0.3922,-0.71788],[-0.71706,-0.39557,-0.57389],[-0.24689,-0.17065,0.9539],[0.72858,-0.62438,-0.28164],[0.74192,-0.58572,-0.32632],[0.66586,-0.69409,-0.27364],[-0.5872,-0.66044,-0.46799],[0.75645,-0.096871,0.64684],[-0.4611,-0.88733,0.0055611],[0.57717,0.4281,-0.69542],[0.63516,0.31649,-0.70456],[0.91905,-0.30516,-0.24944],[-0.95208,0.12123,-0.28078],[-0.89912,-0.019751,0.43726],[-0.78896,-0.097121,0.60672],[0.83379,-0.35898,-0.41943],[0.66418,-0.15688,0.73093],[0.10372,0.59099,-0.79998],[0.06222,0.50574,-0.86044],[-0.24755,0.34439,-0.9056],[-0.21715,0.91427,0.34198],[-0.50959,0.83504,0.20742],[0.67858,-0.0028769,-0.73452],[-0.29689,0.94407,-0.14346],[-0.52986,0.6565,-0.53689],[0.44151,0.80574,0.39479],[-0.069294,-0.38048,-0.92219],[0.46722,0.03743,-0.88335],[0.069469,-0.46231,-0.88399],[-0.42361,-0.88697,-0.18398],[0.39047,-0.04745,0.91939],[-0.87305,-0.47181,-0.12323],[0.19468,-0.22551,0.95459],[-0.55587,0.1949,-0.8081],[0.84736,-0.51429,-0.13221],[-0.25533,-0.92066,-0.29529],[-0.56858,-0.55534,0.60688],[-0.44957,-0.80264,0.39198],[-0.63665,-0.1949,-0.74611],[0.64419,-0.42829,-0.6337],[-0.16877,-0.62281,0.76395],[0.60934,-0.54632,-0.57467],[-0.16416,-0.93142,0.32481],[-0.8138,-0.012085,0.58102],[0.083945,-0.60558,0.79134],[-0.18326,-0.63834,-0.74762],[0.76708,0.15191,0.6233],[0.92363,-0.36682,-0.1111],[0.22944,-0.60212,0.76473],[-0.84554,0.52625,0.090163],[-0.76611,0.11082,-0.63308],[0.9903,-0.13229,-0.042394],[0.34539,0.64972,-0.67717],[0.82371,-0.047778,-0.565],[-0.30768,-0.37315,-0.87527],[0.45258,-0.47024,0.75766],[-0.36762,-0.04836,0.92872],[0.80498,0.58013,0.12429],[-0.03083,-0.31608,-0.94823],[-0.41187,-0.90488,-0.1075],[0.45184,0.041941,0.89111],[-0.5679,0.082587,-0.81895],[0.9757,0.21569,0.038657],[-0.34266,0.044778,-0.93839],[0.088829,-0.40474,-0.91011],[0.24068,-0.53989,-0.80659],[0.11599,-0.61509,-0.77988],[-0.76346,0.044128,-0.64435],[0.35912,-0.6005,0.71444],[-0.076727,-0.38628,-0.91919],[0.084089,-0.69169,0.71728],[0.23803,-0.7654,-0.59792],[0.10842,-0.83243,-0.54342],[0.36218,-0.88833,-0.28229],[0.30048,-0.6323,-0.71408],[0.15166,-0.79764,0.58376],[0.96148,-0.1031,-0.25481],[-0.38919,0.076813,0.91795],[0.74238,0.50714,0.43782],[-0.48232,0.30263,-0.82206],[0.41446,-0.89691,-0.15419],[-0.74672,-0.22653,-0.62537],[0.83844,0.52508,0.14599],[-0.67201,0.041899,-0.73935],[-0.98751,0.15748,0.0049869],[-0.63245,0.25931,-0.72991],[0.019638,-0.35193,0.93582],[0.9797,0.053318,-0.19327],[-0.62049,-0.057477,-0.78211],[0.036834,-0.078297,0.99625],[-0.61621,0.58495,-0.52738],[0.073481,-0.86172,-0.50204],[0.99658,-0.075359,-0.0339],[-0.35503,-0.33013,-0.87462],[-0.46414,-0.88576,0.0016494],[0.90733,0.42025,0.012169],[-0.76855,0.3751,0.5183],[0.040363,-0.66555,-0.74526],[-0.30469,-0.35799,-0.88262],[-0.051123,-0.20616,0.97718],[-0.72117,0.19942,-0.66344],[-0.22056,-0.45637,-0.86202],[-0.50318,-0.21454,-0.83713],[-0.14567,-0.9287,0.34102],[0.53469,0.74408,0.40057],[-0.95381,-0.25495,0.15889],[0.18055,-0.63427,-0.75174],[0.62191,0.77995,0.070073],[-0.28456,-0.20089,0.93737],[0.16908,-0.9834,-0.065876],[-0.10009,-0.9941,-0.041869],[-0.065656,-0.99686,-0.04434],[-0.065474,-0.97257,-0.22321],[-0.1272,-0.92917,-0.34707],[0.1962,-0.70359,-0.68298],[0.39134,-0.51545,-0.76234],[0.23193,-0.55741,-0.79718],[0.86209,0.50144,0.07312],[-0.2959,-0.45225,-0.84138],[-0.22155,0.80784,0.54618],[0.24261,0.080501,0.96678],[0.68505,-0.047493,-0.72695],[-0.80111,0.089028,-0.59186],[0.33903,0.11407,0.93383],[-0.081332,0.96964,0.2306],[-0.18812,0.96731,0.17009],[-0.37908,0.83269,0.40363],[-0.58865,0.57778,-0.56539],[0.73675,-0.0097687,0.6761],[0.77289,0.35878,-0.52337],[-0.58871,0.34537,-0.73085],[-0.73112,0.41231,-0.54356],[-0.23869,0.85713,0.45646],[-0.39712,-0.84971,0.34683],[0.40499,0.75478,0.51604],[0.83322,0.36593,0.41455],[-0.35613,-0.24927,0.90058],[-0.62866,0.76573,-0.13578],[-0.37516,0.80225,0.46439],[0.7338,-0.37042,-0.56949],[-0.99853,-0.042299,-0.033875],[0.29996,0.76973,0.56351],[-0.53933,-0.59484,-0.59606],[0.74261,0.30815,-0.59462],[-0.279,0.87285,0.40037],[-0.2437,0.88674,0.39282],[0.18212,0.78543,0.59154],[-0.97664,-0.016504,-0.21425],[0.70676,0.29914,-0.6411],[-0.74069,0.64059,0.20255],[0.85631,0.4614,0.23204],[-0.1253,0.84729,0.51614],[0.036321,0.87782,0.47761],[0.32406,0.85435,0.40629],[-0.63059,0.19984,0.74994],[-0.37791,-0.024487,0.92552],[-0.24431,-0.23859,0.93989],[0.68406,0.38621,-0.61879],[-0.86672,0.49763,-0.03408],[-0.75088,0.57458,0.32562],[0.082829,-0.41258,-0.90715],[0.8348,0.23466,-0.49804],[-0.66684,0.71131,0.22216],[0.72079,0.64406,0.25622],[-0.92241,0.37084,-0.10788],[0.85012,0.13615,-0.50868],[-0.93179,-0.040247,0.36076],[-0.82576,0.38396,0.41316],[0.81961,0.57285,0.0091314],[0.82177,0.45895,-0.33771],[-0.77031,0.62957,0.10129],[0.57108,0.7611,0.30755],[-0.75322,0.62322,0.21036],[-0.89506,0.43431,-0.10126],[-0.92743,-0.24129,0.28575],[-0.92281,0.15357,0.35334],[0.32858,0.14094,0.9339],[0.58198,0.76282,0.2818],[-0.5357,-0.58001,-0.61369],[0.86261,0.28525,0.41777],[-0.91194,-0.40875,-0.035947],[0.72794,0.68558,-0.0092922],[-0.87457,0.40886,0.26069],[0.99059,-0.052828,-0.12622],[-0.78349,0.61705,0.073421],[-0.36028,0.91819,0.16468],[-0.93847,0.31082,-0.15057],[0.51173,0.79732,0.32002],[-0.86468,0.49922,0.055757],[-0.19885,0.93544,0.29226],[0.33966,0.74952,0.5682],[0.84902,0.51096,0.13448],[0.095708,0.91091,0.40136],[-0.042479,0.98125,0.18799],[0.35112,0.652,0.67202],[0.9638,0.21206,-0.16164],[0.61992,0.49364,0.60993],[-0.87212,0.3406,-0.35128],[0.89324,0.37137,-0.25341],[0.66152,-0.34735,-0.66464],[-0.61327,0.67046,-0.41759],[0.85603,0.50338,-0.11758],[-0.56682,0.73922,-0.36367],[0.18406,0.24592,0.95166],[-0.70914,0.67142,0.21522],[0.8046,0.32647,0.49602],[-0.68582,0.67157,0.28043],[0.73472,0.26575,0.62415],[-0.012118,0.62032,0.78425],[0.43166,-0.74863,-0.50322],[-0.3738,-0.11123,0.92082],[-0.89036,0.36044,0.27811],[0.61354,-0.20163,0.76349],[-0.92297,0.3847,0.011746],[-0.7637,0.42129,0.48916],[-0.72363,-0.40632,-0.55791],[0.45605,-0.87195,-0.1781],[-0.74939,-0.44522,-0.4901],[-0.35244,-0.017443,0.93567],[0.3726,0.63439,0.67729],[-0.59619,0.56403,0.57134],[0.4741,-0.73415,-0.48606],[0.26979,0.95746,0.10238],[-0.042586,0.94636,0.32029],[-0.06486,0.88713,0.45693],[0.10181,0.32777,0.93925],[0.46075,0.62893,0.62623],[0.36559,0.92669,-0.087077],[-0.83269,0.32454,0.44866],[-0.45653,0.7194,0.52349],[-0.6556,0.46563,-0.59445],[0.45287,0.89107,0.030081],[0.82692,0.55656,0.080227],[0.42368,0.90433,0.051796],[-0.44041,0.88921,0.12388],[-0.32257,0.94651,0.0083586],[0.13748,-0.21438,0.96703],[-0.97491,0.22027,-0.032169],[0.18205,0.98211,-0.04813],[-0.079295,-0.34964,-0.93352],[0.12208,0.34208,0.93171],[0.02831,-0.31413,-0.94896],[0.18309,-0.32964,-0.92618],[-0.12854,-0.31918,-0.93894],[0.55391,0.76368,0.33162],[-0.27052,-0.35675,-0.89417],[0.46871,0.5277,0.70841],[0.2261,-0.25534,-0.94004],[0.72039,-0.61777,-0.31528],[-0.99306,0.041111,0.11016],[-0.016413,-0.22624,-0.97393],[0.075202,-0.29351,-0.95299],[-0.25875,-0.2917,-0.92085],[0.11408,0.76677,0.6317],[-0.1395,-0.28908,-0.94709],[0.22813,0.73439,0.63924],[0.098056,-0.20851,-0.97309],[-0.33279,-0.30551,-0.89214],[-0.6981,0.50728,0.50529],[0.28841,-0.24304,-0.92615],[-0.95527,-0.20104,-0.21689],[-0.21757,-0.1606,-0.96274],[0.93645,-0.22907,-0.26569],[0.63578,0.58922,0.49861],[-0.12577,-0.10707,-0.98626],[-0.24141,-0.95795,0.15509],[0.24941,-0.18496,-0.95057],[0.046714,-0.11385,-0.9924],[0.15326,-0.16363,-0.97454],[0.14457,0.13377,0.98041],[-0.66993,0.53707,0.51259],[0.32951,-0.094644,-0.9394],[-0.17663,-0.068265,-0.98191],[0.095461,-0.093803,-0.991],[-0.501,0.68333,0.53109],[-0.18687,-0.86843,-0.45924],[-0.12562,-0.019805,-0.99188],[0.8042,-0.33091,-0.49372],[-0.34679,-0.2221,-0.91127],[0.26182,-0.019516,-0.96492],[0.14888,-0.21839,0.96444],[0.19691,-0.071035,-0.97784],[0.27172,-0.12266,-0.95453],[-0.80478,-0.33046,-0.49308],[-0.20336,0.073117,-0.97637],[-0.36209,0.66357,0.65465],[-0.15763,0.81471,0.55803],[-0.88206,0.45631,0.11727],[0.69951,-0.58112,-0.41592],[-0.44322,-0.2568,-0.85884],[0.098158,-0.0092844,-0.99513],[0.6747,0.35551,0.64684],[0.41903,0.06251,-0.90582],[0.83236,0.47954,0.2779],[-0.18157,0.15951,-0.97035],[0.2143,0.029495,-0.97632],[-0.96346,-0.03695,-0.26529],[-0.43844,-0.2069,-0.87462],[-0.17648,0.823,0.53994],[-0.39041,-0.9122,-0.1244],[-0.13511,0.18179,-0.97401],[-0.092748,0.14538,-0.98502],[0.97089,-0.22862,0.07146],[0.0064371,0.10342,-0.99462],[0.40393,0.27909,-0.87118],[0.61802,-0.72897,-0.29437],[-0.50791,0.64377,0.57236],[0.069111,0.088243,-0.9937],[-0.1414,0.22298,-0.96451],[0.28266,0.0775,-0.95608],[0.36744,0.39743,-0.84085],[0.1955,-0.97064,-0.14014],[-0.1119,0.20833,-0.97164],[-0.049302,0.25413,-0.96591],[-0.41264,-0.076372,-0.90769],[-0.16153,-0.97694,-0.13962],[0.26501,0.34372,-0.9009],[-0.41276,0.7035,0.57854],[0.12567,0.17536,-0.97645],[0.18909,0.15581,-0.96952],[0.31938,0.43151,-0.84368],[-0.50323,-0.84945,-0.15874],[-0.1222,0.3136,-0.94166],[0.022281,0.98997,-0.13952],[-0.39741,-0.026317,-0.91726],[0.51239,-0.82936,-0.22275],[-0.34759,-0.71785,-0.60322],[0.052002,-0.91677,-0.39601],[-0.40333,0.863,-0.30422],[0.26778,-0.81281,-0.51733],[-0.28612,0.13114,-0.94918],[0.32254,0.46955,-0.82188],[0.87936,-0.45244,-0.14845],[-0.37685,-0.91998,0.10783],[-0.061114,-0.99127,-0.11679],[0.10556,-0.93254,-0.3453],[-0.85101,-0.30013,-0.43093],[0.76064,0.23445,0.60536],[-0.014863,-0.99527,-0.095996],[0.086312,-0.20442,0.97507],[-0.78193,-0.383,-0.49183],[0.41776,-0.65789,-0.62663],[0.99496,0.073838,-0.067856],[-0.53765,-0.83036,-0.1464],[-0.15997,0.27327,-0.94854],[-0.14488,0.34083,-0.92889],[-0.75484,-0.22662,0.61551],[-0.4302,-0.64512,-0.63147],[0.98604,-0.14995,0.072453],[-0.66809,-0.72285,-0.17646],[-0.34107,0.29446,-0.89273],[0.28502,0.48366,-0.82755],[0.75562,-0.65308,0.05034],[0.86552,0.091013,0.49253],[0.63265,0.72455,-0.27346],[-0.012368,0.72957,0.6838],[0.17821,-0.8164,0.5493],[0.72777,0.67602,-0.11556],[0.19101,-0.87002,0.45451],[0.80507,-0.53059,-0.26521],[-0.16619,-0.82936,-0.53343],[-0.74413,-0.58073,-0.33019],[-0.79263,-0.49367,-0.35781],[-0.87572,-0.2302,-0.42441],[0.99619,0.052254,0.069771],[-0.78424,0.24242,-0.57115],[-0.54523,-0.79892,-0.25386],[0.9831,-0.07114,0.16867],[-0.32194,-0.85413,0.40843],[-0.87459,0.41551,-0.24989],[0.029801,-0.97544,0.21824],[-0.017317,-0.99933,-0.032398],[-0.12597,-0.96549,-0.22794],[0.50645,-0.22091,-0.83349],[-0.3701,0.2397,-0.89753],[-0.94956,-0.29818,0.097086],[0.1766,0.47092,-0.86432],[0.71939,-0.66233,-0.20928],[0.43828,-0.14267,0.88744],[0.98333,0.0069495,0.18172],[-0.43771,0.6001,0.66955],[-0.041022,0.35505,-0.93395],[0.92581,-0.31672,0.20632],[0.43614,-0.89305,-0.11064],[-0.83679,-0.28732,-0.46608],[-0.32299,0.30532,-0.8958],[0.074014,0.48293,-0.87252],[0.14627,0.50855,-0.84852],[-0.6625,0.30219,0.6854],[0.16483,0.26832,0.94912],[0.93163,-0.28626,-0.22386],[-0.51657,-0.59088,0.6197],[-0.40807,0.56345,0.71833],[0.65116,-0.60083,0.46368],[0.32852,0.75397,-0.56886],[-0.86883,-0.36084,-0.339],[-0.71587,-0.21626,-0.6639],[0.60937,-0.79257,-0.022408],[0.97545,0.052573,0.21387],[-0.076853,-0.7106,-0.69939],[-0.15375,-0.64847,-0.74555],[0.47022,0.75336,-0.45973],[-0.0027414,-0.67804,-0.73502],[0.018288,-0.55427,-0.83214],[0.14701,-0.4735,-0.86844],[0.38727,0.7263,-0.5679],[0.9487,0.066328,0.30913],[0.69963,-0.43228,0.56891],[0.71362,0.27097,0.646],[0.34809,-0.37696,-0.85833],[-0.8538,-0.32806,-0.40423],[-0.20235,-0.58206,-0.78757],[-0.14795,-0.60797,-0.78005],[-0.0352,0.74128,0.67027],[-0.22674,-0.026946,0.97358],[0.95444,-0.12404,0.27141],[0.31186,-0.4203,-0.85211],[-0.81174,-0.5082,0.28777],[0.7345,0.50407,-0.45434],[-0.18696,-0.45476,-0.87077],[-0.19501,-0.41927,-0.88667],[0.96453,-0.15259,-0.2154],[0.48544,-0.30337,-0.81995],[-0.87549,0.45565,0.16091],[-0.99518,-0.027965,-0.093947],[-0.38364,-0.90884,0.1638],[-0.27446,-0.24291,-0.93041],[-0.20601,-0.26063,-0.9432],[0.98911,-0.091456,-0.11533],[-0.9373,-0.31711,0.14461],[-0.65882,-0.67247,0.33725],[0.50256,-0.10238,-0.85846],[-0.16035,-0.32621,-0.9316],[-0.91245,0.067602,-0.40356],[0.50993,-0.27255,-0.8159],[-0.81251,0.24525,0.52885],[-0.38783,-0.78271,0.48679],[-0.91339,-0.15195,-0.37766],[-0.19661,-0.44083,-0.87579],[0.98359,0.14524,0.10702],[0.98828,-0.15006,0.0279],[-0.234,-0.43917,-0.86739],[0.70267,-0.65283,0.28297],[-0.83254,0.49964,0.23923],[-0.31855,-0.30746,-0.89666],[-0.71044,0.4057,0.57506],[0.65075,-0.75552,-0.075618],[0.49629,-0.02566,-0.86778],[-0.87961,-0.08632,0.4678],[0.72969,0.28943,0.6195],[-0.25628,-0.29333,-0.92102],[0.97213,-0.005449,0.23438],[-0.98427,-0.16711,-0.057371],[-0.9311,0.12318,-0.34334],[-0.4048,-0.34885,0.84524],[-0.37746,-0.56775,0.73156],[0.6092,0.00015027,-0.79302],[-0.28988,-0.20489,-0.93488],[0.61014,0.25314,0.75077],[-0.79458,0.60215,0.077878],[-0.42604,-0.43248,-0.79464],[0.23296,-0.91648,0.32527],[0.48614,-0.70806,-0.51217],[-0.087581,-0.13352,0.98717],[-0.50328,-0.22979,0.83301],[-0.34316,-0.15062,-0.92712],[0.51547,0.54174,0.66394],[0.10393,-0.1836,0.97749],[0.57992,0.21408,-0.78604],[0.98592,-0.16589,0.021219],[0.13833,-0.3176,0.93808],[0.53698,0.46456,0.70416],[-0.53669,-0.2242,-0.81345],[-0.98216,-0.18439,0.03688],[-0.9804,-0.1879,-0.05918],[-0.92597,0.27731,0.25629],[0.55874,0.38828,-0.73283],[0.72131,-0.62856,-0.29091],[-0.60661,-0.37805,0.69936],[-0.95107,0.30603,-0.042697],[-0.30593,-0.93866,0.1591],[-0.56804,-0.47144,-0.67459],[0.80427,-0.5572,-0.20657],[-0.99671,-0.058656,0.056022],[0.83744,0.049137,0.54432],[0.20416,-0.90965,0.36173],[-0.60077,-0.64201,-0.47634],[0.88735,-0.27505,0.37008],[-0.9992,-0.031764,-0.024351],[-0.88643,0.026932,0.46208],[0.20266,-0.9293,0.30876],[0.79994,-0.56582,-0.19984],[0.62731,0.040598,-0.77771],[-0.65587,-0.62956,-0.41652],[-0.90714,0.42041,0.018825],[-0.90618,0.39545,-0.14983],[0.52609,0.7929,0.30747],[0.8374,-0.53961,-0.087066],[0.52141,-0.25844,-0.81323],[0.93206,-0.079427,0.35349],[-0.66734,0.43679,0.60322],[-0.98845,-0.084341,-0.1259],[0.48348,-0.19792,-0.85269],[-0.83447,0.36458,0.41321],[-0.23613,0.6264,-0.74287],[-0.025735,0.28413,-0.95844],[-0.014952,0.24188,-0.97019],[0.11084,-0.26086,0.95899],[0.58893,0.18933,-0.78569],[-0.97077,-0.046432,-0.23548],[-0.20552,0.17946,-0.96206],[0.87989,-0.46798,-0.082365],[0.98145,0.050113,0.18504],[0.48352,0.40864,-0.77409],[0.99304,-0.092776,0.072509],[0.85561,-0.0394,0.51611],[0.77878,0.52851,-0.33791],[0.85053,-0.1321,-0.50906],[-0.75337,0.38995,0.5295],[-0.29503,0.11797,-0.94818],[-0.041035,0.15837,-0.98653],[-0.43647,0.18125,-0.88128],[-0.7931,0.56621,-0.2245],[0.41722,0.57134,-0.70675],[-0.60324,-0.020592,-0.79729],[-0.88381,0.46711,-0.0262],[0.089211,0.38051,0.92046],[-0.18197,-0.17538,-0.96754],[0.11884,-0.41481,-0.90211],[-0.72036,-0.031242,-0.69289],[-0.98989,-0.14093,0.015981],[-0.82571,0.080904,0.55826],[0.40507,0.71562,-0.56905],[-0.23168,-0.1688,-0.95803],[0.92977,-0.19825,0.31019],[0.99947,-0.029352,-0.013924],[0.62545,0.75818,-0.18432],[-0.53084,0.16157,-0.83193],[0.28696,-0.80788,0.51476],[0.29431,-0.71819,-0.63055],[0.97551,0.15074,0.16016],[0.89934,0.054224,-0.43387],[0.71884,0.65348,0.23714],[-0.91404,-0.16558,0.3703],[0.4038,-0.84633,-0.34737],[0.92737,0.11987,0.35443],[-0.98698,-0.060519,0.14901],[-0.8962,0.44156,-0.042947],[-0.53778,0.24204,-0.8076],[-0.55391,0.055227,-0.83075],[-0.4222,-0.082271,-0.90276],[-0.57316,-0.1145,-0.8114],[0.65097,0.64179,0.40539],[-0.43481,0.45299,-0.77829],[0.32808,-0.87538,-0.35506],[0.39365,-0.85825,-0.3293],[0.33955,-0.87606,-0.34238],[0.89925,0.216,0.38037],[-0.8088,0.20565,0.55095],[0.51344,0.5722,0.6395],[-0.84325,0.30742,0.44093],[-0.61928,0.35488,-0.7004],[0.17487,-0.84109,-0.51184],[0.75386,0.56374,-0.33748],[-0.2171,-0.5454,-0.80957],[-0.63316,-0.46455,0.61911],[-0.47111,-0.45961,-0.75287],[-0.30955,-0.34202,-0.88724],[-0.71944,0.69089,0.071241],[-0.86048,0.34537,0.37456],[0.97416,0.14219,0.17551],[0.95037,0.30262,0.072206],[0.60522,0.41493,0.67937],[0.8786,0.039683,0.4759],[-0.75074,0.5963,-0.28429],[-0.31517,-0.32039,-0.89332],[0.64189,0.53236,0.55188],[0.72044,-0.50357,0.47685],[-0.54871,-0.20883,-0.80951],[0.53397,0.63413,0.55925],[0.93978,-0.33076,-0.086126],[0.51289,-0.094152,0.85328],[0.27071,-0.069694,0.96013],[-0.50434,0.43775,0.74432],[0.61848,0.76571,0.17655],[-0.72431,0.34018,-0.59971],[0.75197,-0.65047,0.10695],[-0.17819,-0.86385,-0.47118],[0.25088,-0.5944,-0.76403],[-0.91415,0.40271,-0.046515],[-0.32541,0.81829,0.47383],[-0.75103,0.59594,-0.28426],[0.62936,0.74728,0.21326],[0.46101,-0.88631,0.043931],[0.39224,0.48336,0.78263],[0.54471,-0.32678,-0.77234],[0.69253,-0.051592,-0.71954],[-0.81992,0.1057,-0.56263],[-0.88852,-0.06306,-0.45449],[-0.31947,0.88073,0.34964],[-0.99426,0.097046,0.045016],[0.33605,-0.73082,0.59411],[0.41102,0.88026,0.23705],[-0.69082,0.48512,-0.53613],[0.79981,0.36349,-0.47769],[0.8819,0.44332,0.16035],[-0.15501,0.97691,0.14706],[-0.25287,0.94639,0.201],[-0.83855,0.54018,-0.071038],[0.93865,-0.22248,0.2635],[0.34134,0.89513,0.28675],[-0.12885,0.009381,0.99162],[0.058914,0.76459,0.64182],[-0.15581,0.92401,0.34918],[-0.9966,-0.082254,-0.0053384],[0.93455,0.28678,0.21066],[0.26813,0.74065,0.61607],[-0.82687,-0.48321,-0.28776],[-0.61922,0.50145,-0.60424],[-0.88071,0.47327,-0.019164],[0.97479,0.015247,0.22259],[0.92367,0.22653,0.30906],[-0.74541,0.26732,-0.61066],[-0.66414,0.69182,0.28337],[-0.71894,0.6748,-0.16662],[-0.22155,0.81145,0.5408],[0.28267,0.46209,0.84058],[0.012279,-0.26005,0.96552],[0.85929,0.27084,-0.43389],[-0.57168,0.79625,0.19789],[-0.66319,0.69067,-0.28838],[-0.33692,0.74683,0.57335],[0.10813,0.86223,0.49484],[-0.86631,0.40129,-0.29743],[0.78529,0.48802,-0.38098],[-0.69197,0.65466,0.30429],[0.78276,0.4898,-0.3839],[0.49058,0.86398,-0.11339],[-0.74537,0.57212,0.3422],[-0.79543,0.53125,0.29167],[0.4156,0.90159,-0.12004],[0.80272,0.53382,0.26585],[-0.84397,0.51085,0.16353],[0.34194,-0.80281,-0.48844],[0.9066,-0.002074,0.42199],[-0.79993,0.52677,0.28743],[-0.67063,0.73268,0.1159],[-0.92952,0.36558,0.048466],[0.83754,0.51957,-0.16906],[0.82641,0.45929,0.32573],[-0.71355,0.66312,-0.22609],[0.73045,0.63928,0.24033],[-0.93863,0.29914,0.17173],[-0.59414,0.67318,0.44026],[0.76981,0.58964,0.24439],[0.74441,0.61189,0.26728],[0.87592,-0.0020281,0.48245],[-0.56334,0.71504,0.41396],[-0.3007,0.5398,0.78625],[-0.7796,0.61569,0.11464],[-0.40993,0.87623,0.25333],[-0.1084,0.18865,0.97604],[-0.37414,0.92198,0.099844],[0.28575,0.89414,0.34477],[0.3691,-0.28826,0.88356],[-0.82981,0.53401,-0.162],[0.55461,0.75792,0.34345],[0.37574,0.87313,0.31059],[-0.89249,0.44226,0.088712],[0.85229,-0.30634,0.42397],[0.63135,0.77299,0.0623],[-0.26989,0.9391,0.2127],[0.74834,0.66236,0.03559],[0.063545,0.91698,0.39384],[-0.12249,0.96716,0.22272],[0.027383,0.96673,0.25431],[0.26348,0.90754,0.32702],[0.9322,0.2918,-0.21414],[-0.79441,0.49148,-0.35689],[0.71391,0.52892,0.45888],[-0.9762,0.21268,-0.042442],[-0.72822,0.58687,-0.35394],[-0.5418,0.80509,-0.24143],[0.8424,0.39359,0.36803],[0.74102,0.67013,0.042649],[0.1576,0.20365,0.96628],[-0.93274,0.30171,0.19739],[0.8276,-0.3702,0.42195],[0.80061,0.55334,0.22987],[0.82654,0.43188,0.36098],[-0.66644,0.71213,0.22076],[-0.99956,0.025711,0.014603],[0.68067,-0.37596,0.62876],[0.69141,-0.63038,0.35293],[-0.77463,0.5909,0.22536],[-0.88476,0.30076,-0.35601],[0.72959,0.40035,0.55445],[-0.88314,0.39759,0.24897],[-0.7622,-0.54952,0.34216],[0.5946,0.54773,0.58859],[-0.7512,0.55312,0.36022],[0.52969,0.64534,0.55042],[-0.61682,0.6925,0.37414],[-0.50161,0.85581,0.12643],[-0.022466,0.62199,0.7827],[0.14254,0.93514,0.32433],[0.26987,0.82066,0.50367],[-0.21071,-0.17533,0.9617],[0.61902,0.76202,0.19012],[-0.40193,0.83412,0.37776],[0.33799,0.9411,0.00994],[-0.98183,-0.13163,0.13666],[-0.47695,0.81831,0.32076],[-0.064165,-0.24083,0.96844],[0.30399,0.95244,-0.020983],[0.10353,0.99119,0.082555],[-0.12244,0.98981,0.072737],[0.16179,0.97951,0.11992],[-0.047291,-0.4148,-0.90868],[-0.67839,0.70432,-0.2091],[0.093895,-0.42085,-0.90226],[-0.15186,-0.43085,-0.88955],[0.21835,-0.41826,-0.88169],[-0.83544,0.39337,0.3838],[-0.20471,-0.42498,-0.88175],[0.28168,-0.35469,-0.89154],[-0.062417,-0.34815,-0.93536],[-0.11176,-0.23802,0.96481],[0.29592,-0.95435,0.040551],[0.72794,0.62727,0.27683],[0.1213,-0.34924,-0.92915],[0.14555,-0.34387,-0.92767],[-0.98229,-0.14699,0.11621],[-0.24247,-0.30687,-0.92035],[0.8074,0.45424,0.37651],[-0.93355,-0.1933,0.30186],[0.17508,-0.3906,-0.90376],[0.5879,-0.43596,0.68141],[-0.8327,0.081517,0.54768],[0.61721,-0.67497,0.40431],[-0.64738,0.73387,-0.20575],[0.1474,-0.28059,-0.94844],[0.0039161,-0.2829,0.95914],[-0.75765,0.43407,0.48739],[0.8533,0.077199,0.51568],[-0.38741,-0.2611,-0.88416],[0.25001,-0.31302,-0.91625],[0.88198,0.27197,0.38489],[0.45046,-0.22974,-0.86273],[0.26448,-0.25144,-0.93104],[-0.33124,-0.94341,0.016236],[-0.47575,-0.3231,-0.81809],[0.017485,-0.085267,0.9962],[-0.31289,-0.9473,0.068782],[0.78733,-0.49146,0.37225],[-0.36696,-0.1152,-0.92307],[-0.3529,-0.024068,0.93535],[0.51702,-0.09499,-0.85068],[-0.26303,-0.022424,-0.96453],[0.15457,-0.098091,0.9831],[0.32916,-0.11754,-0.93693],[0.49783,-0.0142,-0.86716],[-0.788,-0.54094,0.29401],[-0.3237,0.081423,-0.94265],[-0.98177,-0.15421,0.11114],[0.27858,-0.075364,-0.95745],[0.53355,0.025897,-0.84537],[-0.61699,0.77241,-0.15069],[-0.29022,0.26749,-0.91881],[-0.25107,0.13561,-0.95842],[0.27834,-0.015376,-0.96036],[0.2495,0.0080877,0.96834],[-0.72098,0.45149,-0.52569],[0.45809,0.16261,-0.87391],[0.32041,-0.041969,-0.94635],[0.43431,-0.38293,0.81532],[-0.88675,-0.12296,0.4456],[0.68704,-0.4666,0.55701],[-0.2418,0.28624,-0.92715],[0.33314,0.063876,-0.94071],[-0.5203,-0.19089,-0.83237],[-0.68552,0.64785,-0.3322],[0.41554,0.46047,-0.78441],[0.84838,-0.30283,0.43422],[-0.27977,0.36474,-0.88809],[0.67034,0.69541,0.25894],[-0.4542,-0.10002,-0.88527],[0.39162,0.52174,-0.75791],[-0.90068,0.17159,-0.39916],[0.25692,0.12367,-0.95849],[-0.17205,-2.9758e-05,0.98509],[-0.61049,0.57285,0.54695],[-0.4606,-0.83752,0.29396],[-0.2299,0.43553,-0.87032],[-0.043494,-0.15246,0.98735],[-0.16078,0.38859,-0.90728],[0.069828,0.28201,-0.95687],[0.26092,0.12177,-0.95765],[-0.068854,-0.99733,-0.024395],[-0.28856,-0.76954,-0.56968],[-0.089257,-0.86463,-0.49442],[-0.00018243,-0.11525,0.99334],[0.3861,0.56686,-0.72773],[0.19779,0.97887,0.051926],[0.05323,-0.036683,0.99791],[-0.095076,0.35215,-0.9311],[-0.33727,-0.90864,0.24621],[-0.26991,-0.93835,0.21599],[0.11869,-0.92839,-0.35213],[0.0071791,-0.99593,0.089866],[0.08506,-0.98653,0.13972],[0.96443,-0.19095,0.18277],[-0.84821,-0.27774,0.45101],[-0.70079,0.23556,0.67335],[0.67784,-0.70769,0.19924],[-0.40391,-0.62468,-0.66831],[0.3519,-0.80717,-0.47396],[0.047255,-0.032464,0.99836],[0.17576,0.21834,-0.95992],[-0.48394,-0.82973,0.27811],[0.22841,0.97309,0.030266],[0.5399,-0.8415,0.01957],[0.49131,-0.26273,-0.83041],[-0.0095017,-0.065002,0.99784],[-0.6772,-0.51099,0.52943],[0.18996,-0.97446,0.11976],[-0.59003,-0.76085,0.27013],[-0.013747,-0.021383,0.99968],[0.47955,-0.8725,0.093674],[-0.64081,0.75751,-0.12468],[-0.15338,-0.91973,-0.36135],[-0.84646,-0.52812,0.067753],[-0.23739,0.26868,-0.93352],[-0.059261,0.3823,-0.92214],[-0.14348,0.40249,-0.90411],[0.39608,0.58156,-0.71057],[-0.5794,-0.79469,0.18102],[-0.63365,-0.62096,-0.46141],[-0.87458,-0.3011,0.38007],[-0.23152,-0.78946,0.56847],[-0.069868,-0.80328,0.59149],[0.0095922,-0.99171,0.12817],[-0.023991,-0.99942,-0.024181],[-0.093044,-0.98847,-0.11944],[0.65382,0.63677,0.4087],[-0.43142,0.2495,-0.86696],[0.31045,0.58274,-0.75103],[0.57511,-0.76856,-0.28031],[0.39516,-0.4045,-0.82476],[-0.71235,0.15539,0.6844],[-0.39951,-0.88251,0.24815],[-0.68545,-0.70311,0.18921],[-0.11789,-0.074298,0.99024],[-0.43945,-0.62789,0.64237],[-0.68374,-0.63862,-0.35308],[-0.46019,0.25524,-0.85034],[0.8412,0.52977,-0.10827],[0.24293,0.55033,-0.79882],[-0.048866,-0.49541,-0.86728],[-0.076891,0.031376,0.99655],[-0.069972,-0.42136,-0.90419],[0.10306,-0.39268,-0.91388],[0.91715,-0.13393,0.37536],[-0.74198,0.020626,0.67011],[0.37549,-0.52351,-0.76482],[-0.3301,-0.93645,0.11871],[-0.75772,-0.57846,-0.30206],[0.21766,0.62085,-0.7531],[0.1974,0.13592,0.97086],[0.81432,-0.4959,0.30161],[-0.059698,-0.54168,-0.83846],[0.21936,-0.40041,-0.88969],[-0.7382,-0.61573,0.27558],[-0.72719,0.046596,0.68485],[0.71867,0.68621,-0.1124],[0.44154,-0.36121,-0.82132],[-0.73702,0.65265,-0.17562],[-0.098879,0.4795,-0.87195],[0.12393,-0.020537,0.99208],[-0.095123,-0.57043,-0.81582],[0.046303,0.16555,0.98511],[0.29446,-0.9419,-0.16158],[0.26972,-0.36725,-0.89016],[-0.77603,-0.57924,0.24951],[-0.4938,-0.73065,0.4715],[-0.40361,-0.693,0.59736],[0.80127,0.069318,0.59427],[-0.68912,-0.60685,-0.39604],[0.95588,0.16647,-0.24204],[-0.8847,-0.24273,0.39798],[0.27471,-0.28303,-0.91893],[0.82503,-0.55787,0.090085],[0.47806,-0.22731,-0.8484],[0.65034,-0.74588,-0.14396],[-0.388,-0.38688,-0.83653],[0.27453,-0.15097,-0.94965],[-0.64843,-0.62026,0.44138],[-0.40985,0.90993,-0.063615],[-0.37082,-0.37945,-0.84765],[-0.077837,0.062912,0.99498],[-0.36234,-0.30106,-0.88208],[0.29317,-0.18495,-0.938],[-0.86147,-0.41661,0.29036],[0.75334,-0.64131,-0.14562],[-0.72885,-0.5004,0.46731],[0.49435,-0.098382,-0.86368],[-0.24605,-0.66212,-0.70785],[-0.16264,-0.52641,-0.83453],[0.32076,-0.24413,-0.91516],[0.0116,-0.036905,0.99925],[0.094,-0.044249,0.99459],[-0.36921,-0.51393,-0.77431],[-0.98168,0.13551,0.13394],[0.32263,-0.078391,-0.94327],[0.76404,-0.54773,0.34093],[-0.94438,-0.29714,0.14093],[0.91259,-0.37562,-0.16151],[0.70522,-0.68651,-0.17708],[-0.4534,-0.56084,0.69274],[0.80408,-0.49229,0.33333],[-0.20001,-0.1498,0.96828],[-0.93651,-0.0062128,0.35059],[-0.91637,0.24083,0.31979],[0.42781,0.069334,-0.90121],[0.48449,-0.57883,-0.65591],[0.28909,-0.25172,-0.92362],[0.95034,-0.20532,-0.23386],[0.84188,-0.53127,0.09481],[-0.35088,-0.33848,0.87311],[-0.33871,-0.2364,-0.91071],[-0.67977,-0.62318,-0.38674],[0.36652,-0.53449,-0.76157],[0.12925,-0.12125,-0.98417],[-0.31917,0.94624,-0.052639],[0.97921,-0.17376,-0.10472],[-0.98507,-0.1454,-0.092123],[0.6384,-0.74235,-0.20339],[0.55411,0.10105,-0.82629],[-0.050362,-0.045649,0.99769],[0.33673,-0.26581,-0.9033],[-0.36539,-0.31935,0.87436],[0.57765,-0.49494,-0.64911],[-0.013669,-0.37186,0.92819],[-0.28664,-0.78733,-0.54584],[0.013585,-0.29896,0.95417],[-0.30312,-0.11907,-0.94548],[0.72313,-0.65276,-0.22581],[0.73328,-0.57128,-0.3687],[-0.60383,-0.28691,0.74369],[-0.015621,-0.020441,0.99967],[0.055834,0.04682,0.99734],[-0.32372,0.0017261,-0.94615],[0.60981,-0.42703,-0.66767],[0.22223,0.97478,0.020302],[-0.49189,-0.1841,-0.85097],[-0.89347,-0.25113,0.37234],[0.70182,-0.48748,-0.51944],[0.80585,-0.56579,0.17458],[-0.82885,-0.11687,0.54713],[-0.98121,-0.13862,0.13421],[0.12111,0.15064,0.98114],[-0.5233,-0.31602,-0.79138],[-0.80196,-0.10156,0.58868],[0.97324,-0.18703,-0.13351],[-0.92257,-0.11951,0.36686],[0.87894,-0.38036,-0.28775],[-0.14756,0.00020405,0.98905],[-0.58084,-0.53521,-0.61334],[0.58129,-0.11548,-0.80546],[-0.5826,-0.57875,-0.57064],[0.88229,-0.34537,-0.31981],[0.20519,-0.30556,0.9298],[0.5045,-0.36125,-0.7842],[-0.60715,-0.4342,-0.66546],[-0.072581,0.11667,0.99052],[0.6622,-0.5568,-0.50146],[-0.99062,0.13599,-0.013345],[-0.8544,0.021488,0.51917],[0.44788,-0.35786,-0.81936],[0.98453,-0.09941,-0.1443],[-0.62943,-0.64079,-0.43955],[0.70121,-0.46456,-0.54083],[-0.71789,0.53866,-0.441],[0.4095,0.19085,-0.89213],[-0.077891,-0.32747,-0.94164],[0.033208,-0.32072,-0.94659],[0.98635,-0.09373,-0.13538],[0.34858,-0.51504,-0.78309],[-0.72043,0.23703,-0.65176],[-0.8382,0.02665,0.54471],[0.43998,0.57687,-0.68822],[-0.39758,-0.1283,-0.90855],[0.093006,-0.36219,-0.92745],[0.54739,-0.76346,0.34278],[0.98777,0.15572,-0.007779],[0.86499,-0.28945,-0.40989],[-0.73269,0.058512,-0.67804],[0.97008,-0.24235,-0.014577],[-0.62515,0.077039,-0.77669],[-0.33284,-0.11203,-0.93631],[0.40293,-0.62794,-0.66584],[-0.55797,-0.14642,-0.81684],[-0.06268,0.2298,-0.97122],[-0.0083628,0.20484,-0.97876],[-0.73364,-0.39352,-0.554],[0.65111,-0.39439,0.64847],[0.43172,0.66207,-0.6126],[-0.63789,0.13213,-0.75871],[-0.56061,0.093556,-0.82278],[-0.42931,-0.86466,0.26086],[-0.53428,-0.010759,-0.84524],[0.86837,-0.017407,-0.49561],[-0.61223,0.16332,-0.77363],[0.017514,0.14196,-0.98972],[0.19213,0.79034,-0.58176],[-0.3685,-0.092903,0.92497],[0.32263,0.70512,-0.63144],[0.44485,-0.74151,-0.50226],[0.027632,-0.52604,-0.85001],[0.4166,-0.80997,-0.41279],[0.92306,0.37177,-0.09873],[-0.26892,-0.065744,-0.96092],[0.28095,0.95075,-0.13095],[-0.50618,-0.033782,-0.86177],[-0.063415,-0.0043527,0.99798],[-0.83172,0.074403,0.55019],[-0.88533,-0.098487,0.45441],[0.45929,-0.80761,-0.36989],[0.8708,0.17632,-0.45893],[-0.20924,-0.17451,-0.96217],[-0.43091,-0.14049,0.89139],[0.2735,0.7044,0.65499],[0.91484,0.40139,-0.044168],[-0.67775,-0.44339,-0.58657],[-0.37439,0.40437,-0.83446],[0.042215,-0.72674,-0.68561],[-0.19091,-0.47779,-0.85748],[-0.24924,-0.27973,-0.92716],[0.70801,0.38364,0.59291],[-0.87288,0.41589,0.25517],[0.95724,0.20374,0.20537],[-0.64511,-0.092321,-0.75849],[-0.70932,0.33897,0.61803],[0.76296,0.45882,0.45539],[0.94556,0.107,-0.30734],[0.75171,-0.17587,0.63561],[-0.89312,0.066158,0.44493],[-0.76348,0.34709,-0.54463],[-0.96681,0.15771,-0.20101],[-0.76597,-0.32334,0.55565],[0.71498,0.55746,0.42194],[-0.09084,-0.74067,-0.6657],[0.43779,-0.38553,-0.81222],[-0.53588,0.67275,0.51014],[0.1127,-0.14775,0.98258],[0.96207,-0.012257,0.27252],[-0.79526,0.59896,0.093833],[-0.22057,-0.92198,-0.31828],[-0.20715,-0.88095,-0.42546],[0.65696,-0.097086,-0.74765],[0.86867,0.47983,0.12316],[-0.38125,0.83792,0.39055],[-0.78014,0.44269,-0.44205],[0.18179,-0.98219,0.047463],[-0.21426,-0.95019,-0.22633],[0.51906,-0.83081,0.20083],[0.76327,0.30159,-0.57137],[-0.93316,0.31834,0.16696],[-0.72108,-0.34883,-0.59864],[-0.72828,0.67061,0.14102],[-0.92021,0.19297,0.34056],[-0.14418,0.97196,0.18578],[-0.74734,-0.32733,-0.57822],[0.85398,0.32456,-0.40668],[-0.78986,0.51878,0.32709],[-0.7229,0.51082,-0.46527],[-0.66289,0.41661,-0.62211],[-0.78895,0.48787,0.37354],[0.87371,0.45079,0.1828],[-0.18351,0.81975,0.54252],[0.98007,0.017407,0.19789],[-0.88489,0.32803,0.33072],[0.31667,0.78296,0.53544],[0.16394,0.33966,0.92615],[-0.496,0.84228,0.21109],[0.6411,-0.69695,0.32133],[-0.016973,0.79107,0.61149],[-0.13939,-0.8817,-0.45074],[-0.098829,0.041156,0.99425],[0.86306,0.44658,0.23599],[-0.79519,-0.066667,0.60268],[-0.77857,0.61726,-0.11326],[0.15231,-0.96851,0.19693],[0.86724,0.31079,-0.38898],[-0.83438,0.50519,0.22044],[0.8574,-0.2389,0.45585],[-0.87676,0.47928,-0.039832],[0.88568,0.30815,-0.3473],[0.71078,0.63955,0.29287],[-0.70653,0.69374,0.13979],[-0.97873,0.20515,-0.0013594],[0.0074222,-0.095069,0.99544],[0.72449,-0.58002,0.37243],[0.47715,-0.094712,0.87371],[-0.83881,-0.32732,-0.43504],[-0.83166,0.31373,0.45817],[-0.52313,0.77332,0.35821],[-0.89178,0.45047,0.04256],[-0.5469,-0.74241,-0.38695],[0.95968,0.26031,-0.10606],[-0.77406,0.33191,0.53914],[0.7253,-0.68301,-0.086287],[0.9063,-0.092562,0.41238],[0.017619,-0.99914,-0.037554],[-0.79511,0.60522,0.038864],[-0.77748,0.46746,0.42072],[0.73012,0.68317,-0.014394],[-0.3464,0.92821,0.13577],[0.56126,0.74148,0.36768],[0.67116,0.74101,-0.021061],[-0.095012,0.92163,0.37625],[0.26304,-0.93138,0.25167],[-0.082486,0.93946,0.33257],[-0.79349,0.45946,0.39909],[-0.89692,0.26583,-0.35336],[0.91657,0.31146,-0.25079],[-0.12916,0.96159,0.2422],[-0.11118,0.021503,0.99357],[-0.86612,0.34183,-0.36467],[0.81233,0.56947,-0.12577],[-0.56214,0.82681,-0.019556],[0.81114,0.49812,0.30648],[0.7145,0.52604,0.46128],[-0.47016,-0.83655,0.28132],[0.68158,-0.73169,0.008778],[-0.75401,0.65328,-0.068537],[-0.7801,0.59003,-0.20811],[-0.88333,0.46128,-0.083398],[0.75393,0.49115,0.4363],[-0.79114,0.49091,0.36483],[-0.83973,0.54228,0.028172],[-0.71142,0.6778,0.18567],[0.1317,0.89399,0.42829],[-0.80913,-0.49544,-0.31599],[0.5243,0.73182,0.43537],[0.44193,0.87914,0.17836],[0.80723,-0.5862,-0.068883],[0.42443,0.90206,0.078473],[-0.33722,0.86477,0.3721],[0.13814,0.97882,0.15106],[0.09221,0.98933,0.11278],[0.6652,-0.32581,0.67184],[-0.5849,0.77925,0.22508],[-0.42325,0.89385,0.14798],[0.95102,0.15901,0.26508],[-0.47417,-0.23877,0.84744],[-0.84063,0.13725,0.52393],[-0.8802,-0.46818,-0.077802],[-0.31755,0.94824,0.0025917],[-0.19899,-0.52,-0.83067],[-0.10388,-0.50661,-0.85589],[0.049778,-0.51994,-0.85275],[0.16216,-0.5719,-0.80414],[0.30788,-0.47488,-0.82444],[-0.29972,-0.51816,-0.80105],[-0.11025,-0.44038,-0.89102],[0.33809,-0.93193,0.13117],[0.1197,-0.42193,-0.89869],[0.89162,-0.38673,-0.23547],[-0.056589,-0.053295,0.99697],[-0.3145,-0.42502,-0.84879],[0.32441,-0.76807,-0.55211],[0.35847,-0.41799,-0.83473],[-0.16028,-0.40389,-0.90066],[0.90478,0.34408,0.25098],[0.018416,-0.88079,-0.47314],[-0.88652,0.42247,0.18866],[-0.29601,-0.40695,-0.86416],[0.19909,-0.43091,-0.88016],[-0.43487,-0.3861,-0.81352],[0.46012,-0.39833,-0.79349],[0.50888,-0.4828,0.7127],[0.26331,-0.38347,-0.88522],[0.74679,0.56489,0.35101],[0.42609,-0.33881,-0.83884],[0.97858,-0.19361,0.069935],[-0.18833,-0.97205,0.14018],[-0.85543,0.45627,0.24506],[-0.6566,-0.26894,-0.70466],[0.54669,-0.29443,-0.78386],[-0.65385,0.63466,0.41193],[0.39734,-0.5451,0.73823],[0.32141,-0.24655,-0.91428],[-0.52709,-0.36873,-0.76565],[0.39381,-0.52744,0.75281],[-0.52106,-0.20945,-0.82742],[-0.7287,-0.19187,-0.65741],[-0.015664,0.019653,0.99968],[0.678,-0.17499,-0.71393],[0.045001,0.042629,0.99808],[0.71913,0.073251,0.69101],[-0.96203,0.041075,0.26984],[-0.64883,0.64229,0.40803],[-0.62296,-0.073919,-0.77876],[0.36187,-0.22261,-0.90526],[-0.50609,-0.27393,-0.81782],[0.60023,-0.050317,-0.79825],[-0.75736,-0.10421,-0.64463],[0.15483,0.087635,0.98405],[-0.50305,0.096104,-0.8589],[-0.64798,0.10226,-0.75476],[-0.05256,-0.99806,0.033408],[-0.43867,0.25621,-0.86135],[0.34332,0.065134,-0.93696],[-0.4036,-0.3676,0.83784],[-0.41351,0.39918,-0.81833],[0.46496,0.36645,-0.80593],[0.33477,0.060093,-0.94038],[0.31199,-0.78408,-0.53654],[-0.35275,0.43788,-0.82694],[0.34898,0.058091,-0.93533],[0.17277,-0.30056,0.93799],[0.42606,0.58315,-0.69167],[-0.89919,0.13597,0.41589],[0.53245,0.78126,0.32576],[-0.51519,-0.12751,-0.84754],[0.53711,-0.42044,0.73126],[-0.32858,-0.54469,-0.77159],[0.3216,0.048266,-0.94565],[-0.35222,-0.67963,-0.64346],[-0.5481,0.70945,0.44302],[0.22437,-0.89727,-0.38022],[-0.55123,-0.046905,-0.83304],[-0.32177,0.50164,-0.80301],[-0.37236,-0.81071,0.45176],[-0.012364,-0.98476,-0.17349],[0.25965,-0.95087,-0.16864],[0.30971,-0.66066,-0.68382],[0.062308,0.9155,0.39747],[0.6527,-0.69829,0.29388],[0.22076,0.86894,0.44295],[0.40004,0.6245,-0.67079],[0.01838,0.37927,0.9251],[-0.37184,-0.92817,-0.015553],[-0.25981,0.81884,0.51186],[-0.25701,0.4937,-0.83079],[-0.62079,-0.78322,0.034366],[0.1638,-0.95218,0.25791],[0.37064,-0.90836,0.19366],[-0.30806,-0.89401,-0.32535],[0.36781,-0.1753,-0.91323],[-0.36504,0.11227,-0.9242],[-0.65987,-0.74962,0.051408],[0.42594,0.61858,-0.66026],[-0.57187,0.7727,0.27551],[0.55681,0.83006,-0.031065],[-0.54973,-0.82334,0.14111],[0.63422,-0.75642,-0.15998],[-0.58868,0.80823,-0.014696],[0.48904,-0.1028,-0.86618],[-0.14388,-0.55564,0.81888],[-0.013276,-0.33595,-0.94179],[0.56458,0.75273,0.3386],[-0.17877,0.43572,-0.88215],[-0.031444,0.37658,-0.92585],[0.067141,0.31652,-0.94621],[0.081194,-0.50164,0.86126],[-0.52146,0.85184,0.049509],[0.58441,-0.73299,-0.34811],[0.57124,0.63883,0.51534],[-0.16027,-0.89332,0.41987],[-0.14955,-0.97525,0.16283],[-0.13079,-0.9914,-0.0038222],[-0.16537,-0.97784,-0.1284],[0.043016,-0.9984,0.036705],[-0.37259,0.16522,-0.91317],[0.0041398,-0.25331,0.96738],[0.68372,-0.72256,-0.10217],[-0.11303,-0.30635,-0.94518],[-0.063629,-0.16106,0.98489],[-0.60661,0.72205,0.33268],[-0.549,-0.80564,-0.22259],[-0.52272,-0.8428,-0.12825],[-0.46393,-0.88557,0.023019],[-0.38494,-0.85521,0.34704],[-0.41523,-0.90636,0.078086],[-0.22152,-0.81583,0.53418],[-0.21403,-0.85232,0.47722],[-0.64184,0.60975,0.46502],[-0.13527,-0.43367,-0.89086],[-0.15413,-0.13397,0.97893],[0.46711,0.2855,0.83684],[-0.057665,-0.42204,-0.90474],[0.29253,-0.44318,-0.84736],[0.23516,0.20048,0.95106],[0.5558,-0.79762,-0.23427],[0.35281,-0.93531,0.026791],[-0.58667,-0.64743,0.48648],[0.39398,-0.53306,-0.74875],[0.93799,0.1721,0.30092],[-0.0070688,0.44146,-0.89725],[-0.051924,0.44921,-0.89192],[-0.35691,0.30972,-0.8813],[-0.038099,-0.15655,0.98693],[-0.50311,0.64947,0.57015],[-0.18486,-0.50622,-0.84236],[-0.75491,-0.61956,-0.21509],[0.43627,-0.89031,0.13042],[-0.9299,0.12465,0.34605],[0.71797,-0.69602,-0.0079667],[-0.42126,0.21292,0.88159],[0.27333,0.64459,-0.714],[-0.18305,-0.62135,-0.76185],[-0.14777,-0.65891,-0.73756],[0.32867,-0.42145,-0.8452],[-0.81832,-0.55137,-0.16229],[0.61839,-0.7765,0.121],[-0.47528,-0.59511,0.64803],[-0.22771,-0.96565,-0.12519],[-0.45198,0.30152,-0.83952],[0.061401,-0.14336,0.98776],[-0.76553,-0.45831,0.45157],[-0.33782,-0.58971,-0.73357],[0.62543,-0.77942,0.036621],[0.7389,-0.66317,0.11928],[-0.68114,0.34606,0.64521],[-0.41392,0.32104,-0.85182],[0.1548,0.6312,-0.76002],[0.31985,0.86035,0.39686],[0.91791,0.22495,0.32687],[-0.92381,0.30299,0.23403],[-0.50637,-0.55614,-0.65902],[-0.8029,-0.48359,0.34856],[0.52323,-0.18855,-0.83107],[0.020044,0.654,-0.75623],[-0.10006,-0.1883,0.977],[-0.24937,-0.6171,-0.74632],[0.28094,-0.11031,-0.95336],[0.34235,-0.37331,-0.86223],[0.015209,-0.18228,0.98313],[-0.14576,0.84709,0.51106],[0.15516,-0.7074,-0.68958],[-0.87597,-0.46239,0.1374],[-0.14158,-0.48646,-0.86215],[-0.6486,-0.49102,0.58157],[-0.012271,0.89744,0.44096],[-0.37773,-0.50669,-0.77497],[0.074276,-0.2714,-0.9596],[0.024294,-0.23679,-0.97126],[0.22546,-0.45895,-0.85938],[0.51332,-0.017261,-0.85803],[0.77973,0.15348,0.60701],[-0.36406,-0.38083,-0.84996],[0.17644,-0.10631,0.97855],[0.032713,-0.26123,-0.96472],[0.20685,-0.22171,-0.95292],[0.35694,-0.35346,-0.86467],[0.91193,0.3171,0.26045],[0.65842,-0.73879,-0.1438],[-0.45028,-0.44761,0.77259],[0.15743,-0.19191,0.9687],[0.53475,0.090824,-0.84012],[-0.30524,0.87788,0.369],[0.29585,0.84495,0.44557],[0.22686,-0.1179,-0.96676],[-0.18766,-0.37149,0.90927],[-0.96349,-0.26627,0.028022],[-0.29954,-0.50472,0.80965],[-0.30317,-0.26705,-0.91475],[0.31024,-0.21177,-0.92677],[-0.45168,-0.36806,0.81272],[-0.80089,0.14364,0.58133],[-0.24058,-0.21621,-0.94624],[-0.054683,0.90366,0.42476],[0.21161,-0.034682,-0.97674],[-0.87308,0.40308,0.27433],[0.54493,0.25391,-0.79911],[-0.037214,0.91861,0.39342],[0.25968,-0.075334,-0.96275],[-0.99638,-0.083211,-0.017341],[-0.36033,-0.43557,0.82489],[0.71455,-0.32663,0.61865],[0.51783,0.31393,-0.7958],[-0.32599,-0.090823,-0.941],[0.27265,-0.085032,-0.95835],[0.19712,0.066505,-0.97812],[-0.46614,-0.68665,-0.55788],[0.33762,-0.68633,0.64418],[0.24516,-0.42783,0.86997],[-0.85638,0.5007,0.12616],[-0.46116,-0.41541,0.78407],[0.11449,0.92897,0.352],[-0.34929,0.039462,-0.93619],[0.80987,-0.56314,-0.16427],[0.76242,0.61414,0.20385],[-0.42299,0.52179,0.74082],[0.55173,0.41563,-0.72308],[-0.36483,0.00081877,-0.93107],[0.40587,-0.095214,-0.90896],[0.25875,0.093898,-0.96137],[-0.98644,-0.097149,0.13229],[-0.62944,-0.15728,0.76097],[-0.66273,-0.33545,0.66953],[-0.24168,0.030117,-0.96989],[-0.36582,0.064633,-0.92844],[0.57617,0.43346,-0.69293],[-0.078824,-0.04856,0.99571],[0.96032,-0.23923,-0.14338],[0.69591,-0.27897,-0.66173],[-0.98921,-0.032567,0.14281],[-0.41935,-0.16737,-0.89226],[0.69781,-0.25308,-0.67008],[0.59735,0.15783,-0.7863],[-0.28341,-0.19062,-0.93986],[-0.11789,-0.35296,-0.92818],[-0.63275,-0.090037,0.7691],[0.41113,-0.45648,-0.78905],[-0.0084283,-0.054329,0.99849],[0.46284,-0.47875,-0.74604],[-0.56398,-0.14805,-0.81241],[0.27437,-0.45942,-0.84478],[-0.48644,-0.39751,-0.77805],[-0.12544,-0.98348,-0.13049],[0.81741,0.55955,0.13687],[0.48414,-0.40701,-0.77457],[0.0056232,-0.9997,0.023956],[0.098171,-0.98894,0.11116],[-0.20627,-0.96061,-0.18625],[0.37242,0.22371,0.9007],[0.15743,-0.98259,0.098692],[-0.54523,-0.36183,-0.75618],[0.32818,-0.93344,0.1449],[-0.97164,0.088731,-0.21918],[0.7894,-0.53076,-0.30844],[-0.86023,0.3414,-0.37876],[0.5652,0.14328,-0.81242],[0.53484,-0.46635,0.7046],[-0.66318,0.021991,-0.74814],[-0.72673,0.049952,-0.6851],[0.51376,-0.54876,-0.65948],[0.37476,0.60309,-0.70416],[0.49017,-0.60597,-0.62652],[0.12731,-0.11168,0.98556],[-0.93321,0.094706,-0.34663],[-0.77567,0.053093,-0.6289],[0.49253,-0.68542,-0.5363],[-0.044914,-0.99896,-0.0072055],[-0.87044,-0.011617,-0.49215],[0.70846,0.68977,0.14931],[-0.66668,0.74037,0.085971],[-0.80836,0.19646,-0.55494],[-0.14927,-0.1813,0.97203],[0.44425,-0.74334,0.50009],[-0.61886,0.16982,-0.76693],[-0.57465,-0.55706,0.59956],[-0.33097,-0.88519,0.32695],[0.95755,0.27905,0.07225],[0.47025,0.8494,0.23955],[-0.20099,0.94544,-0.2564],[-0.12321,0.86749,-0.48196],[-0.5787,-0.27674,0.76715],[0.37221,-0.72375,-0.58107],[-0.41714,-0.15323,-0.89583],[0.32568,0.4997,0.80264],[-0.58322,0.33154,-0.74157],[-0.31851,0.22278,-0.92137],[0.4165,0.74187,0.52551],[0.36631,0.7845,0.50038],[-0.16281,-0.97268,-0.1655],[0.21597,-0.69301,-0.68782],[-0.84194,0.53954,-0.0060205],[-0.080583,-0.54888,-0.83201],[-0.30675,-0.3318,-0.89208],[0.46539,0.46491,-0.75317],[0.72148,0.57544,0.38515],[-0.5566,0.32031,-0.76654],[0.75543,0.6365,0.15554],[-0.70348,0.27448,-0.65558],[0.92177,0.36558,0.12916],[0.93881,0.30345,0.16296],[0.076844,0.37276,-0.92474],[0.87353,0.16668,-0.45735],[-0.27234,0.29238,-0.9167],[-0.44925,0.54953,-0.70441],[-0.39571,0.56907,-0.72082],[-0.91749,0.22062,-0.33097],[0.70085,0.55128,0.45266],[0.85958,-0.21176,-0.46505],[-0.6098,0.7913,-0.044631],[0.025894,-0.62372,-0.78122],[0.41607,-0.35302,-0.83801],[-0.60029,0.48999,0.63211],[-0.50157,0.86498,-0.015579],[-0.81006,-0.046317,-0.58451],[0.65964,0.55658,0.50506],[-0.75397,0.52656,-0.39278],[-0.63019,-0.72988,-0.26485],[-0.32672,-0.77874,-0.53554],[0.085109,-0.99582,0.033179],[0.52894,-0.78419,-0.32447],[0.2137,0.97362,0.079944],[-0.37332,0.84489,0.38313],[0.1422,-0.14704,0.97886],[0.50266,0.71067,0.49222],[-0.32244,0.94164,-0.096684],[-0.8135,0.49405,-0.30679],[-0.16258,-0.96755,-0.19344],[-0.91541,0.34066,0.2144],[0.31049,0.89763,0.31281],[0.70841,0.69126,0.14254],[0.71385,0.46492,-0.5237],[-0.20784,0.8375,0.50536],[-0.33269,0.93516,-0.12161],[0.24744,0.81631,0.52193],[0.17912,0.90666,0.38195],[0.79614,0.38387,-0.46776],[-0.68909,0.61395,0.38499],[0.21618,-0.32961,0.91903],[0.79247,0.27233,0.54574],[-0.043233,0.78844,0.61359],[0.73473,-0.042373,0.67703],[-0.20371,0.71432,0.66951],[0.25047,0.73799,0.6266],[-0.63395,0.73504,-0.24048],[-0.72846,0.4186,-0.54233],[0.84153,0.4151,0.34571],[-0.58456,0.78127,0.21888],[-0.68238,-0.14207,0.71706],[0.72424,0.10112,0.68209],[0.16566,-0.96109,0.22105],[0.47747,0.86653,0.14542],[0.58691,0.68524,-0.43127],[-0.72907,0.67064,0.13672],[-0.59945,0.60414,0.52505],[0.84705,0.46107,-0.26444],[0.79796,-0.59859,0.070398],[0.46766,0.85357,0.22958],[-0.60889,0.63691,-0.47287],[0.10503,-0.0041967,0.99446],[0.81197,0.5427,0.21491],[-0.77074,0.55559,0.31188],[0.61755,0.73047,0.29162],[0.60765,0.73875,0.29156],[-0.57288,0.73545,0.36183],[0.15415,-0.657,0.73796],[0.78141,0.59611,-0.18456],[0.62853,-0.66358,-0.40573],[0.82154,0.56749,-0.055013],[-0.529,0.73384,0.4262],[-0.14829,0.26132,-0.95379],[-0.6102,0.67576,0.41353],[0.93964,0.15724,0.3039],[0.5121,0.76026,0.39969],[-0.10592,-0.99373,-0.035935],[-0.80566,0.58643,0.083773],[0.87863,0.47326,-0.063482],[-0.54891,0.74563,0.37779],[0.40178,0.82022,0.4072],[-0.72824,0.68532,0.00021831],[0.57692,0.62933,0.52068],[-0.8621,0.27308,-0.42686],[0.053976,0.91387,0.4024],[0.35378,0.83622,0.41901],[-0.90684,0.14569,-0.39549],[-0.80863,0.53622,-0.24204],[-0.6975,0.70785,-0.1116],[0.66906,0.74198,0.042768],[-0.43604,0.89675,0.075567],[-0.4251,0.8974,0.11817],[0.6868,-0.12693,0.71568],[0.76569,0.63949,0.068996],[-0.78978,0.61068,-0.057674],[-0.6942,0.69907,0.17142],[-0.57826,-0.60412,-0.54832],[-0.14829,0.44568,-0.88282],[-0.80351,0.53986,-0.25084],[-0.74171,-0.45775,0.49023],[0.80053,0.45264,0.39278],[-0.71623,0.60667,-0.34491],[-0.70068,0.66447,-0.25986],[0.03013,0.064619,0.99746],[-0.22144,0.65173,-0.7254],[0.86929,0.42491,0.25255],[-0.73849,0.61254,0.28182],[-0.050043,-0.21663,0.97497],[0.60805,0.65231,0.45251],[0.18707,-0.97404,0.12749],[-0.63558,0.73,0.25126],[0.91588,0.28558,0.28214],[-0.56763,0.78812,0.23805],[-0.3624,0.86093,0.35702],[0.72614,-0.21825,0.65198],[0.57683,0.81619,-0.033029],[0.25621,0.95991,0.11371],[0.40473,0.91413,-0.023422],[-0.07245,-0.29687,0.95217],[0.12949,0.98958,-0.062911],[0.056131,0.99324,0.10165],[-0.099605,0.99083,0.091269],[0.17326,0.98429,0.033964],[-0.04881,-0.6391,-0.76757],[-0.3614,-0.49109,0.79261],[0.32256,-0.56854,-0.75678],[-0.089546,-0.98163,-0.16847],[-0.94589,0.2708,-0.17879],[0.77528,0.43226,-0.46053],[0.0083302,0.029767,0.99952],[0.82489,-0.076647,0.56007],[-0.1042,-0.55186,-0.8274],[0.081944,-0.5317,-0.84296],[0.80747,0.58798,0.047724],[-0.68477,-0.053612,0.72679],[0.96858,0.10255,0.22656],[0.4306,-0.48644,-0.76024],[0.011473,0.11853,0.99288],[-0.17397,-0.47779,-0.86107],[-0.89799,0.0040878,0.43999],[0.70447,-0.32604,0.63041],[0.53819,-0.65197,0.53412],[0.19354,-0.47339,-0.85933],[0.38025,0.77136,0.51031],[-0.35837,-0.52767,-0.77016],[0.11464,0.31103,0.94346],[-0.42968,-0.48821,-0.75962],[-0.93284,0.34383,-0.10764],[-0.80812,0.58702,-0.048346],[0.69944,0.69325,0.17373],[-0.46115,-0.40167,-0.7912],[0.24669,-0.45726,-0.85444],[-0.6915,-0.3117,-0.65167],[0.34278,-0.45456,-0.82212],[0.53451,-0.40331,-0.74272],[0.67185,0.71604,0.18947],[0.3663,-0.32718,-0.87108],[0.96111,-0.14034,0.23784],[-0.94918,0.18918,-0.25154],[-0.77587,-0.24891,-0.57972],[0.68703,-0.30145,-0.66115],[0.76035,0.44925,0.46909],[0.65463,0.25906,0.71017],[-0.66453,0.037829,0.7463],[0.46345,-0.29075,-0.83706],[-0.5353,-0.33019,-0.77745],[-0.79605,-0.17242,-0.58015],[0.45008,-0.12312,-0.88446],[0.95761,0.28785,0.011108],[0.67519,-0.041167,-0.7365],[-0.99601,0.0023185,-0.089238],[-0.99729,0.04614,-0.057261],[0.98193,0.18247,-0.050256],[-0.71871,-0.058701,-0.69283],[0.37478,-0.071235,-0.92437],[-0.21736,0.80239,-0.55581],[-0.15548,0.86926,-0.46927],[0.15294,0.028624,0.98782],[-0.56077,0.52537,0.63994],[0.26208,0.93718,-0.23025],[-0.58239,-0.27214,-0.76601],[0.63887,0.053134,-0.76748],[0.35628,0.93146,-0.073789],[-0.56335,0.32206,-0.76086],[-0.7266,0.55177,0.40939],[0.35483,0.060002,-0.933],[-0.23127,0.63897,0.73364],[0.59318,0.23589,-0.76974],[-0.028318,0.14204,0.98946],[-0.58779,-0.18652,-0.78722],[0.64639,-0.25331,0.71973],[-0.46543,0.48396,-0.74105],[0.34892,0.028039,-0.93673],[-0.96091,0.27053,-0.058891],[-0.1817,0.9202,0.34671],[0.41695,0.58428,-0.69625],[0.082677,0.32378,0.94251],[-0.37699,0.4973,-0.78139],[-0.72077,0.63986,0.2666],[-0.031998,-0.85958,-0.50999],[-0.12687,-0.18229,0.97503],[0.12079,-0.89609,-0.42712],[0.18909,-0.91875,-0.34662],[-0.030967,0.044421,0.99853],[0.30753,-0.9403,-0.14582],[0.41714,0.62184,-0.6628],[0.8794,0.41935,0.22538],[-0.19852,-0.97457,0.10391],[0.93854,0.24705,0.24107],[0.28979,-0.93573,-0.20107],[0.99373,0.076065,-0.0819],[-0.59162,-0.50315,-0.62994],[-0.17808,0.072931,0.98131],[0.22429,-0.93906,-0.26051],[0.41634,0.75178,0.51135],[-0.058434,-0.32784,-0.94292],[0.20393,-0.34777,0.91513],[0.38477,-0.46243,-0.79882],[0.73578,-0.1438,-0.66178],[-0.89247,0.43134,-0.13204],[0.77714,-0.2587,0.5737],[0.14826,-0.96884,0.19839],[-0.5525,-0.57276,-0.60555],[0.31301,-0.36085,0.87853],[0.1696,-0.86212,-0.47747],[0.17191,-0.49586,-0.85122],[-0.91519,0.25011,-0.31602],[0.49643,-0.11221,-0.8608],[-0.75368,0.64198,-0.14083],[0.24006,-0.14858,0.95932],[-0.21971,-0.35445,-0.9089],[0.19388,-0.37462,-0.90668],[0.48049,-0.52667,-0.70125],[0.1025,-0.24366,0.96443],[-0.36596,0.50069,-0.78447],[0.02757,0.16351,0.98616],[0.97489,-0.22264,0.0052867],[0.23006,0.14893,-0.96171],[-0.3894,-0.85394,0.34517],[-0.56206,0.30316,0.76953],[-0.042562,0.068714,0.99673],[-0.10258,-0.33992,-0.93484],[-0.15242,-0.37556,-0.91418],[-0.1203,-0.29036,-0.94932],[-0.83235,-0.54551,0.098035],[-0.085699,0.12705,0.98819],[-0.37924,-0.92438,0.041182],[0.47952,-0.87666,0.039085],[-0.8337,0.51599,-0.19673],[0.015398,0.1994,0.9798],[-0.21409,-0.96064,-0.17699],[-0.53717,0.12244,-0.83454],[0.85986,0.44081,-0.25755],[0.15245,-0.058402,0.98658],[-0.26932,-0.44698,-0.85304],[0.42907,-0.57293,-0.69832],[0.53512,0.71985,0.44212],[0.19211,0.19862,-0.96106],[0.32767,0.13051,-0.93574],[0.11203,-0.19182,0.97501],[0.73441,-0.27392,0.62098],[-0.40825,-0.81239,-0.41635],[0.74294,0.50372,0.44081],[-0.26571,-0.95864,0.10205],[-0.18246,-0.98297,-0.021973],[0.44535,-0.35052,-0.82389],[-0.35308,-0.016334,0.93545],[-0.28178,-0.55667,-0.78149],[0.78944,-0.57631,0.21131],[-0.82048,-0.53136,0.21086],[-0.28617,0.506,-0.81367],[0.12433,0.28774,-0.9496],[-0.86247,0.12126,0.49137],[-0.49501,-0.64123,-0.58633],[0.80654,-0.31501,-0.50026],[0.81049,-0.57176,0.12725],[-0.32105,-0.90329,0.28461],[0.58218,0.60016,0.54852],[0.42726,0.62624,-0.65213],[-0.19891,-0.57619,-0.79274],[0.44218,-0.57403,-0.68918],[0.77347,-0.31144,0.55203],[0.6904,0.32742,0.64509],[-0.6862,-0.43999,-0.57926],[0.43929,-0.89578,-0.067856],[-0.76626,0.55003,-0.33213],[-0.49053,-0.66727,0.56048],[0.064541,0.15079,0.98646],[-0.39799,0.28735,-0.87123],[0.37043,0.63798,-0.6751],[-0.28496,-0.83554,-0.46975],[0.49877,-0.6386,-0.58602],[0.67825,0.60473,0.41747],[0.028631,0.35783,-0.93335],[0.15695,0.93904,-0.30589],[0.13419,0.27346,-0.95248],[-0.35449,0.33235,0.874],[0.6518,0.32435,0.68553],[-0.17949,0.39115,-0.90265],[-0.56069,0.81914,-0.12097],[0.9473,-0.31944,0.024128],[-0.85426,0.052251,0.51722],[-0.41001,-0.81013,-0.41903],[-0.79295,-0.59137,0.14665],[-0.2547,0.54291,-0.80024],[-0.81823,0.56262,-0.11811],[-0.81699,-0.45591,-0.35309],[0.99506,-0.041227,0.090349],[0.66602,0.0045543,-0.74592],[-0.34335,-0.07124,0.9365],[-0.0015046,0.50334,-0.86409],[0.8375,-0.020375,0.54606],[-0.79219,0.55423,-0.25546],[0.2844,0.64567,-0.70868],[-0.60319,-0.70014,-0.38205],[0.42451,-0.40716,-0.80871],[-0.98608,0.051982,-0.15796],[0.52476,-0.57448,-0.62817],[-0.1022,0.45839,-0.88286],[-0.19539,-0.0054175,0.98071],[-0.89316,-0.32298,-0.31298],[0.85879,0.046434,0.51023],[0.4981,-0.31073,-0.80953],[-0.029762,0.47983,-0.87686],[-0.38276,0.36243,-0.84978],[-0.92043,-0.38888,0.039812],[-0.60607,-0.71341,-0.35174],[-0.97671,-0.19669,0.085696],[-0.37215,-0.70351,0.60546],[-0.37951,0.42126,-0.82372],[0.86887,-0.41433,0.27091],[0.98128,-0.1409,0.13128],[0.18664,0.63269,-0.75157],[0.24511,0.63291,-0.7344],[-0.30014,-0.83711,-0.45734],[-0.14556,-0.014662,0.98924],[0.34283,-0.56492,-0.75055],[-0.88158,-0.47191,-0.010606],[-0.55041,-0.63286,0.54455],[-0.33093,-0.75401,0.56741],[0.11453,0.66814,-0.73517],[-0.49397,0.82668,-0.26943],[0.71349,-0.49632,0.49457],[-0.4946,-0.75187,-0.43596],[-0.31303,-0.3332,0.88938],[-0.31577,-0.79472,-0.51837],[-0.98484,-0.16372,0.057379],[-0.018653,0.14852,0.98873],[-0.87371,-0.47423,0.10833],[-0.075541,0.39241,0.91668],[0.75682,-0.65221,0.042967],[-0.69978,-0.46689,0.54066],[0.56049,-0.090685,-0.82318],[-0.058168,0.67324,-0.73713],[-0.57297,0.7659,0.29172],[0.41378,-0.68484,-0.59981],[-0.86548,0.40087,-0.30041],[-0.4258,-0.69094,-0.58421],[0.45344,-0.57649,-0.67974],[-0.90269,-0.40313,0.15046],[0.56167,0.74699,-0.35572],[0.57139,0.0031032,-0.82067],[-0.27453,-0.45175,-0.84885],[-0.33453,-0.12637,0.93387],[0.65915,0.10893,0.74408],[0.69273,-0.71528,-0.092239],[0.65904,0.59453,0.46066],[-0.98378,-0.17781,0.023535],[0.54965,-0.68939,0.47183],[-0.26647,-0.56705,-0.77939],[0.0069355,0.066603,0.99776],[0.43133,-0.49812,-0.75221],[-0.47824,-0.4023,0.78067],[-0.41811,0.065006,0.90607],[0.59112,0.13597,-0.79504],[-0.2156,-0.2564,-0.94222],[-0.15374,-0.38919,-0.90824],[0.44662,-0.66012,0.60396],[0.62146,0.14399,0.7701],[-0.47742,-0.35992,0.80157],[-0.57763,0.76866,-0.2748],[-0.98719,-0.15947,-0.0042792],[0.70419,-0.67812,-0.2104],[0.17882,-0.22928,0.9568],[-0.12913,-0.10173,-0.9864],[-0.032741,-0.4939,-0.8689],[0.023654,-0.64796,0.76131],[0.9021,0.054744,0.42805],[0.63182,0.16424,-0.75752],[-0.13507,-0.10765,-0.98497],[-0.035434,-0.55515,0.831],[0.30817,-0.1113,-0.9448],[-0.40356,-0.40799,0.81895],[-0.023432,-0.069037,-0.99734],[-0.039442,-0.08776,-0.99536],[-0.017163,-0.18177,-0.98319],[-0.11437,-0.093629,-0.98902],[0.25457,0.035156,-0.96641],[-0.10801,-0.052073,0.99278],[0.41493,0.0043984,-0.90984],[-0.10914,0.022192,-0.99378],[-0.47497,-0.35146,0.80677],[0.01651,-0.52733,0.8495],[-0.42551,-0.39505,0.81417],[0.38758,0.80045,-0.45723],[0.21109,-0.46692,0.85874],[0.53518,0.42039,-0.7327],[0.81945,-0.54351,0.18192],[-0.10518,0.051878,-0.9931],[-0.06838,0.011492,0.99759],[-0.29267,0.083157,0.95259],[0.44255,-0.38931,0.80783],[0.47543,-0.4559,0.75241],[-0.94484,-0.19712,0.26159],[-0.14036,0.10874,-0.98411],[-0.079575,0.022873,-0.99657],[-0.090136,-0.058242,-0.99423],[0.23071,0.21953,-0.94793],[-0.83737,0.21628,0.50203],[-0.39257,0.011234,0.91965],[0.069039,-0.083953,0.99408],[0.23096,-0.39051,-0.89116],[0.18791,-0.16167,0.96879],[0.55068,0.35763,-0.75422],[-0.5543,-0.14533,-0.81953],[0.30276,-0.4468,0.84185],[-0.22626,-0.29582,-0.92806],[-0.44529,-0.74381,0.49846],[0.36499,0.1902,-0.91138],[0.41657,0.42164,-0.80541],[-0.97269,-0.094759,0.2119],[0.85226,-0.51404,-0.097012],[-0.50734,0.84105,-0.18773],[0.57961,0.051429,-0.81327],[0.45689,-0.51405,-0.72595],[-0.17745,0.21093,-0.96126],[-0.16993,0.077633,-0.98239],[0.57986,0.11896,-0.80598],[-0.76449,0.021466,0.64428],[0.52786,-0.31718,-0.78789],[0.5802,0.5311,-0.61749],[-0.012981,-0.096788,0.99522],[-0.70903,0.68231,-0.17811],[0.7438,-0.17556,-0.64494],[-0.98523,-0.019632,0.17009],[0.83616,-0.52543,0.15732],[-0.06053,0.55818,-0.82751],[-0.4205,-0.20364,-0.88414],[0.7266,-0.55709,-0.40212],[0.83297,0.53047,-0.15733],[0.33711,-0.26064,0.90467],[-0.90075,-0.19789,0.38663],[0.48157,-0.24078,0.84268],[-0.99291,0.10159,0.061705],[-0.60604,0.052216,-0.79372],[0.53465,-0.58994,-0.60508],[0.268,0.85881,-0.43659],[-0.49087,-0.29334,-0.82037],[0.82518,-0.39794,-0.40091],[0.89035,-0.4545,0.026648],[-0.8037,0.030388,0.59425],[0.57056,0.56881,-0.59239],[0.1172,-0.21686,0.96914],[-0.72848,0.090222,-0.6791],[-0.41132,-0.45738,0.78843],[0.080178,-0.074356,0.994],[-0.3481,0.93629,0.046706],[-0.6495,0.70324,-0.28914],[-0.47025,-0.12302,-0.87392],[0.85386,-0.17687,-0.48954],[-0.23833,0.96993,0.049354],[-0.99959,0.021226,-0.019452],[0.9981,-0.033524,0.051697],[0.41209,0.70507,-0.57711],[0.35314,0.682,-0.64045],[-0.14446,0.95986,-0.24043],[-0.98244,-0.15805,0.099196],[0.50577,-0.1705,0.84565],[-0.36643,-0.11037,-0.92388],[0.43543,-0.010776,0.90016],[0.98809,0.15336,0.012421],[0.96115,-0.26013,0.092303],[-0.75162,0.034615,-0.65869],[-0.44127,-0.68173,0.58355],[0.36366,-0.71465,-0.59751],[-0.28377,-0.19471,-0.93892],[-0.99342,0.076748,-0.084976],[0.56706,0.020142,0.82343],[-0.39184,-0.15766,-0.90642],[0.33101,0.92733,0.1746],[-0.42501,-0.4883,0.76218],[0.068117,0.89141,-0.44804],[0.39144,0.80873,-0.439],[0.42908,0.75445,-0.49668],[-0.44506,-0.45832,0.76932],[-0.065164,-0.52407,-0.84918],[-0.90877,0.32666,-0.25969],[0.56039,0.81887,0.12418],[-0.26368,0.92064,-0.28792],[-0.78996,0.21067,-0.57583],[-0.87461,-0.13932,0.46437],[-0.18758,0.93502,-0.30091],[-0.53382,0.42232,-0.73258],[-0.84344,0.43355,-0.31724],[-0.55897,0.81164,-0.16972],[0.51705,-0.10829,0.84908],[-0.4236,0.79394,-0.43614],[0.79838,0.59144,-0.11309],[-0.64889,0.33443,-0.68344],[0.7751,0.59601,0.20974],[-0.029549,0.9545,-0.29674],[-0.87012,0.4154,-0.26521],[-0.11876,-0.14238,0.98266],[0.42913,-0.48963,0.75902],[-0.99419,-0.072629,0.079486],[-0.28845,-0.72747,-0.62256],[-0.14533,-0.65834,-0.73856],[0.26524,-0.42082,-0.8675],[-0.88002,0.44286,0.17162],[0.57584,0.083124,0.81333],[0.90909,0.39188,0.14137],[-0.00096412,0.96156,-0.27459],[-0.59797,0.4909,-0.63361],[-0.65188,-0.26576,0.71023],[0.84403,0.0040701,-0.53627],[0.68672,0.054191,-0.7249],[-0.88799,0.38626,0.24956],[0.952,-0.30287,0.044294],[0.027736,0.063553,0.99759],[0.6724,0.57977,0.46016],[-0.29752,-0.85798,-0.41875],[0.62118,0.010584,-0.7836],[0.18212,-0.041368,0.98241],[0.72572,0.10265,0.68029],[0.59216,0.10361,0.79913],[-0.35872,0.73803,-0.57152],[0.57725,-0.59535,-0.55887],[-0.66563,-0.20587,0.71732],[0.76889,0.25482,-0.58641],[0.07354,-0.93469,-0.34776],[-0.1958,-0.051956,0.97927],[-0.72692,0.50979,0.46012],[0.55395,-0.051963,0.83093],[-0.26394,0.90645,0.32966],[-0.53981,-0.056315,0.8399],[-0.049164,0.89991,0.4333],[-0.059874,0.8371,0.54376],[-0.05424,-0.42432,0.90388],[-0.21974,0.7744,0.59331],[-0.19407,0.7627,0.61695],[0.25064,0.84475,0.47284],[0.062531,0.90256,0.426],[0.094419,0.88788,0.45028],[-0.097918,0.76168,-0.64052],[-0.82818,0.3543,-0.43426],[-0.80147,0.48149,0.35471],[0.38699,0.20854,0.89819],[-0.27869,0.69983,0.6577],[-0.11187,0.64731,-0.75397],[-0.077389,0.67716,0.73175],[-0.5683,-0.10194,0.81648],[0.074671,0.78627,0.61336],[0.13643,0.72856,-0.67126],[-0.20622,0.50513,0.83804],[0.68741,0.12848,0.71481],[0.58178,0.48018,0.65647],[-0.7027,0.69644,0.14555],[-0.073702,0.64877,0.7574],[-0.68856,0.72279,0.058895],[0.87988,0.43294,0.19588],[0.91135,0.26148,0.31792],[-0.72357,0.5499,-0.4172],[-0.29534,0.89786,-0.32653],[-0.72763,0.66356,0.17393],[-0.60302,0.64927,-0.46348],[0.90121,0.35291,-0.25156],[-0.26287,0.89408,-0.36267],[-0.81448,0.12188,0.56725],[0.52173,0.06057,0.85096],[0.8826,0.40972,-0.23054],[-0.96531,-0.23208,0.11964],[-0.62961,0.49468,0.59907],[0.47659,-0.5079,0.71756],[-0.90229,0.21995,-0.3708],[-0.75575,0.23823,0.60998],[0.36971,0.46852,-0.80237],[0.46515,0.32135,0.82485],[0.39527,0.10651,0.91237],[0.66804,0.74207,0.055314],[0.39685,0.57934,-0.71195],[-0.8182,0.35223,-0.45441],[-0.60764,-0.18686,0.77192],[-0.5236,0.81431,0.25048],[0.71893,0.66233,0.21088],[-0.88023,0.18167,0.43841],[0.74122,0.084233,0.66596],[-0.96975,-0.11745,0.21401],[-0.76051,0.50468,-0.40857],[-0.38877,0.029617,0.92086],[0.36798,0.85795,0.35848],[-0.67603,0.54125,-0.50003],[-0.94737,0.11476,0.29888],[0.7382,0.63379,-0.23104],[-0.26585,0.93394,0.2389],[0.36202,0.90089,-0.23944],[0.3237,-0.37521,0.86858],[0.35256,0.54061,0.76383],[-0.5896,-0.0052763,0.80768],[0.59486,-0.098976,0.79771],[0.78449,0.49374,-0.37523],[-0.014789,0.9556,0.29429],[0.069648,0.91533,0.39664],[-0.13521,0.9555,0.26219],[-0.13012,0.93414,0.33234],[0.069859,0.90004,0.43017],[0.95269,0.23592,-0.19165],[0.39554,0.37324,-0.83919],[0.90942,0.41299,-0.049012],[0.77349,0.63308,0.030561],[-0.0080257,0.088779,0.99602],[0.8092,0.45411,0.3728],[-0.2611,0.93191,-0.25174],[-0.40184,0.91325,0.06708],[-0.59392,0.79476,-0.12495],[0.67376,0.73675,0.056902],[-0.78623,0.45933,-0.41336],[-0.65462,-0.48073,-0.58341],[0.34659,0.52132,0.77981],[-0.82437,0.56319,-0.056839],[0.89109,-0.15411,0.42686],[0.71024,0.63784,0.29785],[-0.46176,4.1293e-05,0.88701],[-0.70682,0.69453,0.13425],[-0.98216,0.028985,0.18578],[0.29522,0.89599,0.33172],[0.4895,0.82374,0.28609],[-0.9631,0.044907,0.26538],[0.49936,0.8311,0.24476],[0.14924,0.14491,0.97812],[0.37335,0.91569,0.14875],[-0.56762,0.81556,0.11255],[0.47575,0.87824,-0.048455],[0.28637,0.027497,-0.95772],[0.12911,0.9885,0.078758],[-0.55693,0.82601,-0.086757],[-0.2226,0.86645,-0.4469],[0.30576,0.9347,-0.18125],[0.39996,0.43007,0.80937],[-0.36547,-0.12861,0.9219],[0.099552,0.974,-0.20353],[-0.074164,0.98633,-0.14715],[-0.21551,-0.64818,-0.73035],[0.66137,0.061404,0.74754],[0.11107,-0.66812,-0.73572],[-0.97109,0.019408,0.2379],[-0.29484,-0.60769,-0.73741],[-0.22867,0.87351,-0.42976],[-0.3058,0.086381,0.94817],[0.22755,-0.63941,-0.73442],[0.61079,0.23724,0.75541],[0.63507,0.39276,0.66516],[-0.83713,-0.37014,-0.40275],[-0.19293,-0.63462,-0.74835],[-0.0016296,0.014554,0.99989],[0.044856,0.4411,0.89634],[0.11677,-0.3614,0.92507],[0.53893,-0.015048,0.84221],[-0.50529,-0.081751,0.85907],[-0.39001,0.18456,0.90213],[-0.3302,-0.57299,-0.7501],[0.3993,-0.58574,-0.70532],[0.25129,0.39766,-0.88245],[0.32872,-0.46953,0.81945],[-0.40417,-0.5444,-0.73503],[-0.89922,-0.095958,-0.42684],[-0.75977,0.60608,0.23542],[0.71822,0.60252,0.34806],[0.55155,0.09884,0.82826],[-0.95119,-0.11607,0.28594],[-0.67857,-0.43115,-0.59469],[-0.28035,0.79058,-0.54441],[-0.59182,-0.72642,-0.34937],[-0.5528,-0.42916,-0.7143],[-0.85461,0.1013,0.50929],[0.43447,-0.027156,0.90028],[0.81333,0.51648,0.26787],[-0.86221,0.14831,0.48435],[0.4559,-0.41376,-0.78801],[-0.73303,-0.2871,-0.61664],[0.5412,-0.090064,0.83606],[0.94041,0.33259,0.070849],[0.91595,0.2106,0.34159],[0.27749,-0.055476,0.95913],[0.47991,-0.38794,-0.78688],[-0.53497,-0.46444,-0.70576],[0.91986,-0.066201,0.38661],[0.12633,0.6102,-0.78211],[0.68186,-0.26476,-0.68189],[0.31602,-0.022405,0.94849],[-0.5192,-0.13213,0.84438],[-0.54078,-0.37311,-0.75389],[0.070127,0.019744,-0.99734],[-0.77053,-0.20212,-0.6045],[0.69555,-0.13491,-0.7057],[-0.64982,-0.1694,-0.74097],[0.53065,-0.36284,-0.766],[0.95894,-0.12677,0.25369],[0.32103,-0.16932,0.93181],[-0.58065,-0.16009,0.79826],[0.55549,-0.21407,-0.80349],[0.66745,-0.045083,-0.74328],[0.11072,-0.044445,-0.99286],[-0.81725,0.32113,0.47852],[-0.088631,0.80756,0.58309],[-0.28696,-0.063468,0.95584],[-0.15411,0.30499,-0.9398],[-0.61074,0.15249,-0.77701],[0.44526,-0.045181,-0.89426],[0.49768,-0.13395,-0.85695],[0.54655,0.73256,0.40575],[-0.85921,0.037763,0.51023],[0.64002,0.10436,-0.76124],[0.89355,-0.15615,0.42093],[-0.63613,-0.2539,-0.72861],[-0.59122,0.27713,-0.7574],[-0.022334,-0.040081,-0.99895],[0.42439,-0.048324,-0.90419],[-0.38316,0.78331,-0.4895],[0.41792,0.078454,0.90509],[0.077428,0.055147,0.99547],[0.54163,0.36035,-0.75946],[-0.66288,-0.12459,-0.73828],[0.45739,0.50772,-0.73008],[0.86222,0.3585,0.35786],[-0.66408,0.62955,0.40332],[-0.20623,-0.49065,-0.8466],[0.056771,-0.41746,-0.90692],[0.064491,-0.19096,-0.97948],[-0.59436,0.047987,0.80277],[-0.41856,0.49112,-0.76394],[-0.25885,-0.77429,-0.57747],[-0.14259,-0.90615,-0.39819],[0.41633,-0.87622,-0.2427],[-0.77927,-0.24999,0.57467],[-0.32405,-0.57772,-0.74916],[0.74555,0.48945,0.45232],[-0.79596,0.46815,0.38377],[0.058951,-0.057441,0.99661],[0.3498,0.047828,-0.9356],[0.8179,0.45218,0.35578],[0.0044839,-0.9983,0.058139],[-0.29288,0.11013,0.94979],[0.31298,-0.94537,-0.091195],[-0.14847,-0.7496,-0.64503],[-0.047915,-0.7153,-0.69718],[0.28429,-0.56938,-0.77135],[0.1721,-0.77005,-0.61434],[-0.11855,0.093955,0.98849],[-0.24505,-0.1318,-0.96051],[-0.42716,-0.60372,-0.67309],[-0.064989,-0.33051,-0.94156],[0.78781,-0.43818,-0.43285],[-0.33547,0.42638,-0.84003],[0.080023,-0.25832,0.96274],[-0.4019,0.49282,-0.77176],[0.38991,0.038018,0.92007],[-0.36618,-0.85143,0.37546],[0.45583,-0.88949,-0.032119],[-0.23055,-0.039489,0.97226],[-0.68801,-0.0065238,-0.72567],[-0.66977,0.47939,0.5671],[-0.86408,0.12681,0.48711],[0.44098,-0.37183,-0.81687],[0.79598,0.58493,0.15577],[0.35481,0.11267,-0.92813],[-0.24962,-0.95244,0.17479],[-0.41875,-0.80189,0.42616],[0.21764,-0.93099,0.29308],[-0.58061,0.073813,0.81083],[0.56606,-0.032004,0.82374],[-0.86758,0.03112,0.49633],[0.3736,0.57407,-0.7286],[0.79475,0.50216,0.3409],[0.09731,-0.21769,0.97116],[0.44445,-0.46855,-0.7635],[0.21349,-0.23465,-0.94835],[0.75286,0.65767,-0.025918],[0.51028,-0.43846,0.73985],[-0.44407,0.85402,0.271],[-0.22935,-0.74944,-0.62107],[-0.16241,-0.81285,-0.55937],[-0.11558,-0.90149,-0.41708],[-0.69017,0.57106,0.44448],[0.30393,-0.9468,0.10579],[-0.35284,0.031587,-0.93515],[-0.53984,-0.073359,0.83857],[-0.60608,0.088613,-0.79045],[0.41481,0.6234,-0.6628],[-0.44337,-0.67418,-0.59068],[0.51577,-0.60241,-0.60917],[-0.081904,-0.22698,-0.97045],[-0.31732,-0.66576,-0.67533],[0.60126,-0.77337,-0.20097],[0.60532,0.02749,0.7955],[0.47458,-0.40758,-0.78016],[-0.78686,0.57712,0.2186],[-0.40302,-0.75704,-0.51426],[-0.29426,0.511,-0.80764],[-0.29468,0.52745,-0.79684],[0.30132,0.21544,-0.92887],[0.16613,0.082473,0.98265],[-0.85687,0.11822,0.5018],[-0.4287,-0.88025,0.20342],[0.90091,-0.029862,0.43297],[0.38032,0.56967,-0.72859],[-0.54,-0.057209,0.83972],[-0.27395,0.016492,0.9616],[-0.3977,0.15661,0.90405],[-0.29436,0.10235,0.9502],[-0.29255,-0.84376,0.44999],[0.41161,-0.56326,-0.71646],[-0.53326,-0.72751,0.4317],[-0.3307,-0.8935,-0.30381],[-0.28891,0.50742,-0.81182],[-0.65475,-0.34927,-0.67031],[0.66135,-0.74809,-0.054589],[0.46643,-0.86421,0.18862],[-0.22986,0.95885,-0.16667],[-0.35859,-0.58674,0.72605],[-0.33333,-0.65921,0.67405],[0.44033,-0.50222,-0.74423],[0.11853,-0.57865,-0.80692],[-0.035232,-0.18753,0.98163],[-0.14496,0.029059,0.98901],[-0.54096,-0.77039,-0.33743],[0.47469,-0.56242,-0.67701],[-0.2624,0.50325,-0.82334],[0.91836,0.044095,0.39328],[0.22189,-0.68756,-0.69139],[0.043,0.36098,-0.93158],[0.10537,0.36466,-0.92516],[0.89829,0.29081,0.3294],[0.59824,-0.74089,0.30528],[-0.62534,-0.53993,0.56341],[0.6982,-0.22993,0.67798],[0.73124,0.67525,-0.096585],[0.45615,0.26183,0.85051],[0.37534,0.61833,-0.6905],[-0.64599,-0.68977,-0.32698],[-0.38881,-0.37122,-0.84322],[-0.22783,0.42914,-0.87403],[0.52881,-0.66266,-0.53032],[-0.22114,0.57152,-0.79023],[0.0087677,-0.23312,0.97241],[0.19995,0.32478,-0.92441],[0.67405,-0.72478,0.14267],[-0.73759,0.61932,0.26908],[0.85483,0.14859,0.49718],[-0.49205,0.0065483,0.87054],[0.65552,0.74594,-0.11775],[0.53304,-0.17301,-0.82821],[0.47084,0.82737,-0.30622],[0.24806,0.303,0.92014],[0.46573,0.82365,-0.32358],[0.13698,-0.17978,0.97412],[-0.52457,0.80897,0.26531],[-0.35779,-0.83773,-0.41255],[0.46893,-0.67328,-0.57167],[-0.46173,0.88076,0.1052],[-0.00051384,0.48882,-0.87239],[0.43034,-0.56745,-0.702],[-0.8054,-0.27459,-0.52529],[-0.083893,-0.42386,0.90183],[-0.31587,0.087615,0.94475],[-0.39899,0.42342,-0.81334],[0.14065,0.1614,0.97681],[-0.44995,-0.7457,-0.4914],[0.42929,-0.63881,-0.63846],[-0.91178,-0.247,-0.3281],[0.70798,-0.70569,0.027775],[-0.28565,0.55842,-0.77883],[0.40734,0.10601,0.9071],[0.041839,0.64709,-0.76126],[-0.43187,-0.74505,-0.50833],[0.8059,0.59152,-0.024955],[0.36441,0.29221,0.8842],[-0.36686,-0.13289,0.92073],[0.94887,0.24186,-0.20287],[-0.34709,-0.75533,-0.55589],[0.52879,-0.6891,-0.4955],[-0.63168,-0.31038,0.71039],[0.13824,-0.17039,0.97563],[0.52111,-0.72243,-0.45446],[-0.94839,-0.31686,0.012042],[0.73437,-0.67793,0.033312],[-0.63429,-0.36534,0.68133],[-0.8944,0.36887,0.25294],[-0.23698,-0.70874,-0.66448],[-0.44738,0.092658,0.88953],[-0.24202,-0.65916,-0.71199],[-0.16213,-0.52678,-0.83439],[-0.21861,-0.72703,-0.65088],[0.53241,-0.709,-0.46245],[0.43207,-0.6351,0.64029],[0.83584,-0.064764,0.54514],[-0.17811,-0.53929,-0.82307],[-0.72187,0.66167,0.20274],[-0.22654,-0.58702,-0.77723],[0.39229,-0.37063,-0.84187],[-0.46143,-0.065822,0.88473],[-0.46497,-0.31828,0.82614],[-0.22553,-0.54836,-0.80526],[-0.1751,-0.58288,-0.79347],[-0.18065,-0.66245,-0.727],[0.63878,0.76936,-0.0067831],[0.0089509,-0.60427,-0.79673],[0.52611,0.68379,0.50561],[0.46589,-0.49508,-0.73338],[0.03253,-0.052799,0.99808],[0.58411,-0.47163,-0.66059],[-0.2237,-0.159,-0.9616],[0.12635,0.83383,0.53736],[0.51627,-0.35905,-0.77753],[0.79716,-0.58981,-0.12911],[0.26383,-0.36105,0.89445],[-0.38602,-0.32286,0.86415],[0.57816,0.29493,-0.76075],[-0.27247,0.014172,-0.96206],[0.5746,0.39042,-0.71932],[0.41392,0.16499,-0.89523],[-0.99733,0.018105,0.07075],[0.060765,-0.29392,0.9539],[-0.034083,-0.24102,0.96992],[-0.43322,-0.15924,-0.88711],[0.32236,-0.16413,0.93228],[0.070852,-0.32525,-0.94297],[0.35234,0.16184,0.92177],[-0.35478,-0.56879,0.74203],[0.39828,-0.33677,-0.85321],[-0.21241,0.11016,-0.97095],[-0.29836,0.093569,-0.94986],[-0.12885,0.13133,-0.98293],[0.62858,-0.34853,-0.69528],[0.50628,0.16733,-0.84598],[0.82184,-0.56129,-0.097612],[0.46196,0.034632,0.88623],[0.51907,0.85071,0.082797],[-0.6287,-0.067555,-0.77471],[-0.32556,-0.20697,-0.92259],[0.45508,0.36497,-0.81222],[-0.54325,0.047104,0.83825],[0.50635,-0.42,-0.75313],[-0.15426,0.23705,-0.95917],[-0.9731,-0.069613,0.21963],[-0.32755,-0.35676,0.87489],[0.93295,0.19377,0.30341],[0.24463,-0.59904,0.76243],[-0.23479,0.19376,-0.95254],[-0.14915,0.21477,-0.96521],[-0.5587,-0.14463,0.81666],[0.16526,0.93895,0.30176],[-0.61108,-0.10333,-0.7848],[0.54632,-0.5243,-0.65318],[0.22395,0.94524,0.23741],[-0.61707,0.77584,0.13152],[-0.58395,0.79237,0.1765],[0.74006,0.67252,0.0050054],[0.37739,-0.23835,0.89485],[0.36534,0.22496,0.90328],[-0.13365,0.32387,-0.93662],[0.39744,-0.58348,0.70823],[-0.16283,0.30882,-0.93708],[0.87199,-0.48921,-0.017727],[0.54147,-0.37235,-0.75377],[0.21126,0.18255,0.96023],[-0.25901,0.21072,-0.94261],[0.76934,-0.4469,-0.4565],[0.64166,-0.34408,-0.68548],[-0.52366,-0.033932,-0.85125],[-0.72265,0.37911,0.57797],[-0.28573,0.093917,-0.9537],[-0.48537,-0.27755,-0.82909],[-0.37485,-0.17024,-0.91132],[0.84971,0.10851,0.51597],[-0.97605,0.012687,0.21716],[-0.13976,0.14068,0.98014],[0.63454,0.76381,0.11814],[-0.44717,-0.22825,-0.86484],[-0.98911,0.095369,0.11214],[0.33741,0.24759,0.90821],[-0.39443,0.14009,-0.90818],[-0.47498,0.14976,-0.86716],[-0.42344,-0.23106,-0.87596],[-0.72867,0.67046,0.13969],[0.50837,-0.66828,-0.54311],[0.44049,0.69247,-0.57136],[-0.60417,0.13634,0.7851],[-0.3584,-0.48677,0.79662],[-0.70134,-0.27876,-0.65605],[0.82941,-0.066197,-0.5547],[-0.99192,0.073058,0.1037],[-0.74496,0.072619,0.66314],[-0.53911,0.14748,-0.82922],[-0.15772,-0.4045,-0.90083],[-0.068091,-0.44142,-0.89471],[-0.98706,0.051648,0.1518],[-0.16191,0.11156,0.98048],[-0.73919,0.21221,-0.63919],[0.34108,0.30808,0.88812],[-0.006306,0.9359,-0.3522],[0.12718,0.16122,0.97869],[0.31609,0.9299,-0.18808],[0.85257,0.096329,-0.51365],[-0.94489,0.27145,0.183],[0.72015,0.64004,-0.26784],[0.34326,0.88626,-0.31099],[-0.23354,0.90993,-0.34276],[0.095582,0.98649,-0.13302],[0.28751,0.95544,-0.06684],[-0.34744,0.91789,0.19172],[-0.8103,0.49414,0.31502],[-0.69572,0.21636,0.68495],[0.68366,0.72938,0.024775],[0.53475,-0.21617,0.81689],[0.84586,0.17896,-0.50249],[-0.25303,-0.64738,-0.71894],[-0.048216,-0.48364,-0.87394],[-0.82993,0.4944,0.25842],[0.26124,0.94315,0.20547],[-0.52819,0.031981,0.84853],[0.12059,-0.55552,-0.82271],[0.080651,-0.449,-0.88988],[0.51643,-0.11863,-0.84807],[-0.8312,0.46046,0.31159],[-0.56719,0.33972,0.75026],[0.81743,0.0027163,-0.57602],[-0.76839,0.28176,0.57462],[0.63216,0.08033,-0.77066],[-0.019181,-0.26215,0.96484],[0.6088,0.74753,0.26563],[-0.33932,0.23936,0.90971],[-0.63093,-0.15863,-0.75945],[-0.31829,-0.81298,-0.48761],[0.74794,0.3051,-0.58948],[0.5588,0.0013271,0.8293],[0.10569,-0.22769,0.96798],[-0.49495,0.71143,0.49889],[-0.56093,0.62876,-0.53854],[-0.54625,0.01629,0.83746],[-0.3769,0.70145,-0.60491],[0.72022,-0.2697,-0.63917],[0.57655,-0.41681,-0.70275],[0.27212,0.29043,0.91739],[0.7919,0.30333,-0.52999],[0.77781,0.51059,0.36649],[-0.74966,0.51969,0.4098],[0.84717,0.49749,0.18656],[0.22177,-0.95813,-0.18113],[-0.39754,0.67534,0.62118],[0.18352,0.96853,0.16812],[0.28176,0.94978,0.13616],[0.12894,0.18607,0.97404],[0.89726,0.29759,0.32614],[-0.26164,-0.90746,-0.32872],[-0.18235,0.7868,0.58965],[-0.76493,-0.19851,0.61277],[0.32417,0.69965,0.63671],[-0.46637,0.69623,-0.54568],[-0.84502,0.49177,-0.21],[-0.099353,0.74101,0.66411],[0.25694,0.86084,0.43924],[0.020508,-0.088372,0.99588],[0.69986,0.38194,-0.60358],[-0.57255,0.74004,0.35288],[-0.079238,0.71117,0.69854],[-0.078138,0.6621,0.74533],[-0.8917,0.24423,-0.38107],[-0.57235,-0.33416,-0.74884],[-0.80596,0.56214,0.18556],[0.85564,0.49182,0.16123],[-0.30078,0.18045,0.93647],[0.68622,0.60416,-0.40509],[0.1929,0.43513,0.87946],[-0.84764,0.36039,-0.38939],[-0.27938,-0.81503,0.50762],[0.85696,0.47093,-0.2094],[-0.63697,0.7698,0.040997],[0.55318,0.47244,0.68614],[-0.68936,0.58548,0.42661],[0.76354,0.62337,0.1686],[-0.65893,0.5316,-0.53218],[0.1263,-0.9739,-0.1886],[0.032782,-0.18189,0.98277],[-0.6245,0.61024,0.48745],[0.67144,0.73516,0.093334],[-0.13884,-0.98348,0.11615],[-0.74305,0.22887,-0.62888],[0.74126,0.66892,-0.055413],[-0.050557,-0.99871,0.0042316],[-0.56853,0.75873,0.31796],[-0.56731,0.56894,0.59537],[0.55305,0.76886,0.32093],[0.66501,0.22196,0.71309],[-0.47507,0.83427,0.27981],[0.033506,-0.4436,0.8956],[0.12439,-0.98836,0.087605],[0.23943,-0.85056,-0.46822],[0.94256,0.30181,-0.14318],[-0.56643,0.69073,0.44949],[-0.44363,0.72579,0.52575],[0.0037433,-0.50457,0.86336],[-0.23953,-0.9703,0.033809],[0.703,0.39034,0.59449],[-0.71624,0.47705,-0.50934],[0.32152,0.82619,0.46263],[0.57718,-0.46746,-0.66958],[0.18761,-0.97629,0.108],[0.74653,-0.25468,0.61468],[0.35774,-0.9242,0.1337],[-0.38632,0.78045,0.49159],[-0.18036,0.85846,0.48012],[-0.0016836,0.91139,0.41154],[-0.3986,0.29598,0.86805],[-0.57989,-0.17862,-0.79488],[0.060159,0.92535,0.37431],[0.38429,0.66204,0.64345],[0.17159,0.87132,0.45975],[0.89574,0.42103,-0.14274],[0.44089,0.74823,0.49575],[-0.75861,0.48424,-0.43592],[0.22278,0.43509,0.87239],[-0.89229,0.24926,-0.3764],[0.83512,0.45871,-0.30357],[-0.42743,0.82589,0.3677],[-0.79924,0.59954,0.042092],[-0.68792,0.70709,0.1637],[0.95001,-0.23992,-0.19982],[-0.51477,0.82284,0.24073],[-0.51456,0.83647,0.18854],[0.59418,0.78932,0.15465],[-0.095693,-0.99146,0.088653],[-0.076099,0.33377,0.93958],[0.78359,0.57575,-0.23346],[-0.79308,0.51583,-0.32395],[-0.82281,0.41336,-0.39002],[0.68212,0.72308,-0.10894],[-0.79602,0.35826,-0.48785],[0.6643,0.74747,0.0025595],[0.07564,0.71238,0.69771],[-0.75808,0.57016,-0.3166],[0.7973,0.53772,0.27418],[-0.32065,0.42618,0.84591],[-0.71426,0.66312,-0.22385],[-0.59233,0.80012,-0.094638],[-0.69124,0.69777,0.18787],[0.2788,0.46983,0.83757],[0.51374,0.81046,0.28146],[-0.57918,0.62608,0.52208],[0.59227,-0.67009,-0.44744],[-0.35503,0.92352,0.14513],[0.48534,0.85759,0.17024],[-0.91367,0.4016,0.062723],[0.14039,0.97006,0.19819],[-0.77198,0.62515,-0.11506],[-0.69219,0.70088,-0.17217],[-0.42462,0.90185,-0.079855],[-0.15308,0.55579,0.81711],[0.23795,0.96437,-0.11561],[-0.22878,0.97293,-0.032681],[0.065784,0.9959,-0.062149],[-0.0041059,0.97535,-0.22062],[0.040922,0.98647,-0.15876],[-0.090817,-0.67836,-0.72909],[0.094395,-0.75948,-0.64365],[0.22866,-0.71632,-0.65924],[0.14698,-0.98415,0.099184],[-0.38667,0.53482,0.7513],[0.10723,0.51723,0.8491],[0.339,-0.68705,-0.64269],[0.12164,0.35537,0.92678],[0.043383,-0.5725,-0.81876],[0.077262,-0.99515,0.06092],[-0.60356,0.54654,0.58053],[0.66566,-0.21878,0.71346],[-0.073008,-0.61489,-0.78522],[0.09607,0.57177,0.81477],[-0.097395,0.552,0.82814],[-0.071816,-0.99742,-0.00098518],[0.1655,-0.54082,-0.8247],[0.23565,0.5193,0.82146],[0.032348,0.89642,0.44202],[-0.67812,0.59133,0.43645],[0.27952,-0.49739,-0.82126],[0.80129,-0.28344,-0.52687],[0.12853,0.91813,0.37485],[-0.59376,-0.446,-0.66972],[-0.58648,-0.49692,-0.63962],[0.27582,-0.68452,0.6748],[0.21154,-0.081296,0.97398],[0.5116,-0.51836,-0.68525],[-0.51373,0.0043973,0.85794],[-0.40845,0.4525,0.79272],[-0.4863,-0.54411,-0.6837],[0.080737,-0.99383,-0.076009],[0.68165,-0.39915,-0.61322],[-0.1076,0.88343,0.45604],[-0.74479,-0.44235,-0.49961],[-0.16661,0.7999,0.57654],[0.25008,0.00176,0.96822],[0.49236,-0.44774,-0.7464],[0.25963,-0.01129,0.96564],[0.7162,-0.3378,-0.61069],[-0.63718,-0.39136,-0.66396],[-0.71036,-0.23638,-0.66296],[0.23145,0.77593,0.58683],[-0.52351,-0.80482,0.27965],[-0.44017,-0.22753,-0.86861],[-0.017204,-0.99983,0.0059335],[-0.366,0.69608,0.61767],[0.56239,-0.44678,-0.69578],[-0.10856,-0.99211,0.062764],[-0.22058,-0.17462,-0.95961],[0.25713,0.74296,0.61798],[-0.045936,-0.22184,-0.974],[-0.075842,-0.24086,-0.96759],[0.42211,-0.16686,-0.89105],[-0.14797,-0.098471,-0.98408],[-0.14415,-0.12829,-0.9812],[-0.76169,-0.14429,-0.63167],[-0.43295,0.048433,0.90012],[-0.081436,-0.10566,-0.99106],[0.59132,-0.29202,-0.75171],[-0.12357,0.84324,0.52314],[0.33357,-0.43037,0.83876],[0.2975,-0.32967,0.896],[0.43338,-0.08526,-0.89717],[-0.066228,0.84791,0.52599],[-0.60305,-0.30946,-0.73523],[0.025402,-0.99913,0.033184],[-0.16514,0.015588,-0.98615],[-0.37946,-0.032877,-0.92463],[-0.46036,-0.18589,0.86805],[-0.080771,0.088327,-0.99281],[-0.033012,-0.99935,0.014447],[0.59288,-0.25317,-0.76446],[0.54496,-0.19529,-0.8154],[-0.26639,0.17811,-0.94726],[0.055615,-0.4457,0.89345],[-0.070604,0.2121,-0.97469],[0.8635,-0.46763,0.18892],[-0.17674,-0.40411,0.89747],[0.42772,0.10719,-0.89753],[0.30467,-0.32171,0.89648],[-0.38644,0.22165,-0.89529],[-0.19198,-0.42346,0.88534],[0.42514,-0.29668,0.85512],[-0.24429,-0.69129,-0.68003],[-0.21123,-0.70261,-0.6795],[-0.2484,0.92772,0.27864],[-0.13075,-0.8117,-0.56925],[-0.48106,0.26352,-0.83615],[-0.9,0.0085539,-0.43581],[-0.31106,-0.18492,-0.93223],[-0.20192,0.050881,-0.97808],[-0.39386,0.40523,-0.82503],[0.39135,0.0081932,-0.92021],[0.45201,-0.71014,-0.5398],[-0.28195,0.063714,0.95731],[-0.26747,-0.46457,-0.84418],[0.10676,-0.4453,0.88899],[-0.040245,-0.046975,-0.99809],[-0.087007,0.094392,-0.99173],[-0.35457,0.42902,-0.83079],[-0.026452,-0.95756,-0.28703],[0.15299,-0.92159,-0.35674],[0.94481,-0.22636,0.23684],[-0.56616,-0.11733,0.8159],[0.41218,0.53061,-0.74065],[-0.34341,-0.51511,-0.78532],[0.30058,-0.40484,-0.86357],[0.10399,-0.021778,-0.99434],[-0.055583,0.14032,-0.98854],[-0.64146,-0.69892,-0.31629],[0.87248,-0.036191,-0.48731],[-0.29608,-0.77286,-0.56127],[-0.085254,-0.60066,0.79494],[0.32238,-0.71148,-0.62439],[-0.59632,0.76441,0.24511],[0.14487,-0.66956,0.72849],[-0.47443,-0.63152,-0.61326],[0.43977,-0.39957,-0.80433],[0.054569,-0.016891,-0.99837],[-0.082079,0.1872,-0.97889],[-0.19768,-0.92954,0.31126],[-0.80873,-0.21699,0.54669],[0.061715,-0.96851,0.24119],[0.3374,-0.93787,-0.080949],[-0.11725,-0.47271,0.87338],[-0.11856,-0.87976,-0.4604],[-0.25272,-0.83187,-0.49409],[0.45037,-0.46245,-0.76375],[0.37749,0.60298,-0.70279],[0.10351,0.0014481,-0.99463],[0.027997,0.058856,-0.99787],[0.00021497,-0.59957,0.80032],[-0.91439,0.067962,-0.39908],[-0.9243,-0.26795,0.2718],[0.41221,-0.90779,0.077425],[0.18775,-0.66381,0.72396],[0.5457,-0.13491,-0.82705],[-0.13766,0.028401,0.99007],[0.16802,-0.11996,-0.97846],[-0.21668,0.30493,-0.9274],[0.97684,0.095456,0.19148],[-0.019292,-0.85909,-0.51146],[0.60688,-0.69035,-0.39383],[0.018784,-0.87886,-0.4767],[-0.55862,-0.088888,0.82464],[0.049713,-0.96661,-0.25139],[0.11638,-0.94405,0.30858],[-0.41585,-0.5925,0.68993],[-0.62816,-0.62236,-0.467],[0.56488,0.028153,-0.8247],[-0.075483,0.21692,0.97327],[-0.91046,0.16481,-0.37934],[0.73011,-0.52065,-0.44256],[0.17885,-0.15178,-0.9721],[-0.24804,0.30551,-0.91932],[-0.30881,-0.66975,-0.67533],[0.18202,-0.11669,0.97635],[0.14759,-0.94365,0.29621],[-0.29563,-0.93538,-0.19408],[-0.0061658,-0.58962,0.80765],[0.54969,-0.11385,-0.82758],[-0.081363,-0.26918,-0.95965],[0.38666,0.56325,-0.73023],[-0.43211,-0.69288,-0.57724],[0.20761,-0.20744,-0.95596],[-0.15968,0.2618,-0.95182],[0.25798,-0.2876,-0.92235],[-0.54267,-0.48327,-0.687],[0.39948,-0.91618,0.032075],[-0.37629,-0.92648,-0.0061276],[-0.24483,-0.96788,-0.057238],[-0.49743,-0.72906,-0.47014],[0.26277,-0.26096,-0.9289],[0.013139,0.14154,-0.98985],[0.32126,0.26009,-0.91058],[0.34354,0.19341,-0.91901],[0.7328,-0.67721,-0.066221],[-0.38613,0.12582,0.91383],[0.44513,-0.50267,-0.74107],[-0.44844,-0.081789,0.89006],[-0.65395,0.15976,-0.73947],[-0.37033,-0.78864,0.49082],[0.7948,-0.075851,-0.60211],[0.78654,0.49387,0.37075],[0.40983,0.22174,-0.8848],[-0.58054,0.56991,0.58153],[-0.62655,-0.37905,-0.68099],[-0.2984,0.33867,0.89234],[0.46428,-0.67896,0.56873],[-0.55716,-0.7968,0.23383],[0.054336,-0.67867,0.73243],[0.40898,-0.56714,-0.7149],[-0.36804,-0.82079,-0.43687],[-0.34925,-0.80298,-0.48295],[0.84515,0.39387,0.36136],[-0.12892,0.31322,-0.94089],[-0.16154,-0.49599,0.85317],[-0.22312,-0.76643,0.60233],[-0.63689,-0.34925,-0.68731],[-0.45757,-0.7493,0.47873],[-0.65712,0.71299,0.24463],[-0.83174,-0.52221,-0.18844],[-0.4799,-0.63313,-0.60733],[-0.29085,-0.59087,-0.75252],[-0.21416,0.41561,0.88397],[-0.11387,0.23887,-0.96435],[0.84421,-0.10052,-0.52651],[0.36218,0.25046,-0.89783],[-0.70981,-0.20134,-0.67501],[-0.56935,-0.49345,0.65753],[-0.92468,-0.011649,-0.38057],[-0.4802,0.3194,-0.81694],[0.3568,0.50083,-0.78858],[-0.37621,-0.46191,0.80318],[0.37895,0.5424,-0.7498],[-0.43388,-0.61749,-0.65609],[0.54562,-0.59458,0.59057],[-0.12456,-0.54977,-0.82598],[0.53208,-0.81959,0.21254],[-0.28297,-0.89576,0.34285],[0.53357,-0.29481,-0.79271],[0.84459,0.45236,0.28641],[-0.17703,-0.64874,-0.74014],[0.4107,-0.49152,-0.76794],[0.070885,-0.65935,-0.74849],[-0.17881,0.48382,-0.85671],[-0.23841,0.55823,-0.7947],[-0.002364,-0.49952,-0.8663],[-0.50436,-0.57896,0.64064],[-0.0029175,-0.23361,0.97233],[0.014554,0.55453,-0.83203],[-0.058989,-0.26472,-0.96252],[0.17099,0.35504,-0.91908],[0.1857,0.14919,-0.97121],[-0.020177,-0.68535,-0.72794],[-0.11186,0.53466,-0.83763],[-0.52761,0.46247,0.71257],[0.32602,-0.56779,0.75586],[0.17778,-0.6596,0.73028],[-0.7301,-0.077878,-0.67888],[0.086049,-0.26483,-0.96045],[-0.21482,-0.90448,0.36846],[-0.35535,-0.53881,-0.76381],[-0.38363,-0.69157,0.61201],[0.61211,0.68532,0.39454],[-0.34508,-0.45633,0.82017],[0.03854,0.53407,-0.84456],[-0.25805,0.44304,-0.85856],[0.25332,0.51404,-0.81951],[-0.23275,-0.59808,-0.7669],[-0.20176,-0.94654,0.2517],[0.15549,-0.53999,0.82719],[-0.17448,0.48953,-0.85435],[-0.92405,-0.38175,0.019773],[0.1513,-0.027705,0.9881],[-0.83086,0.20885,-0.51581],[0.3492,-0.64135,0.68317],[-0.34669,-0.63822,0.68738],[0.53884,-0.044079,-0.84125],[-0.34193,-0.90406,-0.25643],[0.9542,0.28606,0.087608],[-0.53308,0.45111,0.71577],[0.87724,-0.26004,-0.40352],[0.16451,0.36946,-0.91457],[0.095398,0.21521,-0.9719],[-0.21194,-0.61912,-0.75616],[-0.40761,-0.42433,-0.80858],[-0.33121,-0.54994,-0.76672],[-0.51678,0.53441,0.66884],[-0.90555,-0.23529,-0.353],[0.1996,-0.39833,-0.89526],[-0.37137,0.22488,0.90084],[-0.30235,0.89425,0.33],[-0.044614,0.60773,-0.79289],[0.039491,0.47565,-0.87875],[0.055576,0.38791,-0.92002],[-0.18403,-0.48256,-0.85631],[0.011975,-0.15998,-0.98705],[0.33307,-0.51802,0.78786],[-0.85665,0.093734,-0.50731],[-0.71612,-0.32262,0.61895],[0.56409,0.076965,-0.82212],[-0.27678,0.27089,-0.92196],[0.047676,0.26246,-0.96377],[-0.032144,-0.43545,-0.89964],[0.57503,0.76464,0.29097],[-0.093249,0.052564,-0.99425],[-0.077604,-0.11441,-0.9904],[0.53535,-0.70988,-0.45769],[0.22694,-0.59123,0.77392],[0.57578,-0.79536,-0.18944],[-0.29102,-0.734,0.61363],[0.40482,0.15449,0.90125],[-0.0083396,-0.072317,0.99735],[-0.0014516,-0.10197,-0.99479],[-0.074399,-0.48997,-0.86856],[-0.53974,0.47553,0.69466],[-0.33688,-0.52087,-0.78435],[0.52219,-0.73701,-0.4291],[-0.94167,-0.33506,-0.031448],[0.22773,-0.60974,0.75918],[-0.17308,-0.74019,-0.64974],[-0.028424,-0.59097,-0.8062],[-0.84216,-0.51717,0.15267],[-0.51581,-0.3319,0.7898],[0.56695,-0.797,-0.20823],[0.30084,-0.50008,0.81205],[0.54458,0.76543,0.34286],[-0.61855,-0.29132,0.72974],[0.45116,-0.41033,0.79252],[-0.085957,-0.23274,-0.96873],[-0.40416,-0.21969,-0.88791],[-0.27513,-0.40259,-0.87305],[-0.076626,-0.66642,-0.74163],[-0.75295,0.35365,0.55497],[-0.94521,-0.19454,0.26217],[0.54795,-0.69616,-0.4638],[-0.26771,-0.53449,0.80166],[0.66418,-0.72095,-0.19774],[-0.58831,-0.069531,-0.80564],[-0.82672,0.10643,-0.55246],[-0.36446,-0.5756,0.73202],[0.27497,-0.30414,-0.91208],[-0.27506,-0.13586,-0.95178],[-0.33808,-0.11045,-0.93461],[0.0049027,-0.49769,0.86734],[0.36195,-0.56857,0.73873],[-0.77556,-0.22268,0.59069],[-0.71217,0.58282,0.39133],[-0.24007,-0.19224,-0.95153],[-0.50355,-0.63386,0.58707],[0.6348,-0.10737,-0.76518],[-0.99952,0.0010576,-0.030823],[-0.65742,-0.062543,-0.75093],[-0.63628,0.50971,-0.5791],[0.97891,-0.19897,-0.04632],[0.054976,-0.62828,-0.77604],[-0.27481,-0.0051032,-0.96148],[-0.568,-0.51898,0.63878],[0.48689,-0.062158,0.87125],[0.47812,0.053476,-0.87667],[-0.45278,-0.26327,0.85187],[0.37457,0.86276,0.33963],[-0.38715,-0.49001,0.78103],[0.1586,-0.20527,-0.96577],[-0.0962,-0.071516,-0.99279],[0.80847,-0.32378,0.49147],[-0.52098,-0.38109,0.76378],[-0.50382,-0.46717,0.72658],[0.0064817,0.94284,0.33317],[0.57508,0.39392,-0.71701],[-0.69557,-0.091033,-0.71267],[0.23503,-0.21457,-0.94801],[0.85542,-0.51062,-0.08681],[-0.28961,-0.29338,0.91107],[0.52754,0.40966,-0.74423],[0.37591,0.91605,-0.1398],[0.23468,0.96272,-0.13451],[0.63046,-0.57739,-0.51879],[0.4707,-0.3845,-0.7941],[0.022347,-0.10717,-0.99399],[0.1437,0.9712,0.19003],[0.96501,0.24906,0.081955],[-0.44448,-0.49557,-0.74622],[0.065662,-0.080277,-0.99461],[-0.19153,0.13401,-0.9723],[0.43263,0.39636,-0.80977],[-0.92207,0.37339,0.10183],[0.55158,0.002997,0.83411],[-0.75498,-0.29096,0.58767],[0.87806,-0.058661,-0.47495],[0.59589,0.052499,-0.80135],[-0.56489,0.69754,-0.44084],[-0.15941,0.20826,-0.965],[0.65937,0.6718,0.3375],[-0.98672,-0.041405,0.15705],[-0.31508,-0.23066,0.92061],[0.52623,-0.37574,-0.76283],[-0.6115,-0.096019,-0.78539],[0.29906,-0.30105,-0.9055],[0.032651,-0.09095,-0.99532],[0.57076,0.017814,-0.82092],[-0.52626,-0.065861,0.84777],[0.55779,-0.29947,-0.77407],[0.0073535,0.13132,-0.99131],[-0.060577,0.24382,-0.96793],[0.55732,-0.18799,-0.80874],[0.475,0.75555,-0.45113],[0.40436,-0.36782,-0.83738],[0.1216,-0.015207,-0.99246],[-0.16617,0.27792,-0.94612],[0.30348,0.9519,-0.042261],[-0.70314,0.013458,0.71093],[0.61563,0.31246,-0.72344],[0.18824,-0.1144,-0.97544],[-0.12999,0.030536,-0.99104],[-0.32571,-0.46452,0.82349],[-0.35382,-0.10949,-0.92888],[0.71767,-0.20924,-0.66421],[-0.9869,-0.083927,0.13778],[-0.56735,0.13685,-0.81203],[0.47556,-0.51078,-0.7162],[-0.81393,0.57739,-0.064312],[0.96557,-0.22764,0.1259],[0.50382,0.69193,-0.5171],[0.59464,-0.29693,0.74715],[-0.4446,-0.30466,-0.84233],[-0.53371,0.84379,-0.056311],[0.10504,-0.50119,-0.85894],[-0.56004,0.042316,0.82739],[0.97851,0.20186,0.042119],[-0.59936,0.69263,0.40129],[0.37056,0.79494,-0.48037],[-0.48828,0.26525,-0.8314],[-0.94961,0.12999,0.2852],[-0.53745,0.2095,0.81686],[0.32233,0.92963,-0.17858],[0.2585,0.89555,-0.36216],[-0.99033,-0.072691,-0.11815],[-0.50697,0.41673,-0.75453],[-0.077202,-0.5005,-0.86229],[0.24652,-0.28807,-0.92533],[-0.81933,0.40672,0.40409],[-0.92196,-0.37826,0.083091],[-0.67948,0.082659,0.72902],[0.41317,0.68214,-0.60331],[0.055897,0.66248,-0.74699],[-0.049687,0.73613,-0.67501],[0.88322,-0.14336,-0.44652],[0.29806,0.93879,-0.17272],[-0.45314,-0.37781,0.80742],[-0.81151,0.25036,-0.52799],[-0.27757,-0.59775,-0.7521],[-0.4828,-0.61169,-0.62669],[0.66903,-0.37614,0.64102],[0.50045,0.79104,-0.35185],[-0.79597,0.51523,0.31775],[-0.75171,0.65244,0.096233],[-0.41565,-0.72237,-0.55264],[0.35684,-0.22168,-0.90748],[0.58498,0.056305,-0.80909],[-0.77377,0.39113,0.49829],[-0.63383,-0.37242,0.67791],[0.51652,0.85601,-0.021453],[-0.74426,0.37849,-0.5503],[0.70492,0.035975,0.70837],[-0.47846,0.85895,-0.18242],[-0.38022,-0.76689,-0.51702],[-0.8119,0.50346,0.29556],[0.87074,0.48364,0.088949],[-0.6336,-0.43149,0.64216],[-0.43482,0.45768,0.77554],[0.02368,-0.41971,0.90735],[0.56395,0.72659,0.39246],[0.39129,0.70015,-0.59723],[-0.66592,0.37862,0.6428],[0.77937,-0.5275,-0.33811],[-0.18456,0.86259,-0.47104],[-0.48238,-0.26178,0.83593],[0.66991,-0.41845,0.61329],[0.66973,0.56651,0.48013],[-0.19261,-0.82167,-0.53644],[0.6333,-0.095529,0.76799],[0.81666,-0.28689,0.50076],[-0.22159,0.63101,0.74345],[0.46023,0.66038,0.59337],[0.73092,-0.35617,-0.58215],[-0.49814,0.72881,-0.46977],[-0.9218,0.35562,-0.15432],[0.13936,-0.76553,-0.62812],[0.56904,-0.63052,0.52786],[0.42312,-0.6574,0.62353],[0.81961,0.51081,0.25945],[-0.090667,0.59775,0.79654],[-0.032339,0.71044,0.70302],[-0.13275,-0.95353,-0.27047],[0.28691,-0.027659,0.95756],[0.88216,-0.36002,-0.30362],[-0.54056,-0.62713,0.5608],[-0.36345,0.65417,-0.6633],[0.77041,0.26023,-0.58202],[-0.62969,-0.085564,0.77212],[-0.023266,0.73718,0.6753],[-0.095215,0.80911,0.5799],[-0.23247,0.72645,0.64671],[-0.19952,0.80507,0.55862],[0.17422,0.85252,0.4928],[0.12786,0.79968,0.58666],[-0.13678,-0.36184,-0.92215],[0.74069,0.31413,-0.59388],[-0.0082808,0.87306,0.48754],[0.31443,-0.44143,-0.8404],[-0.94439,-0.32469,-0.051976],[-0.85923,0.50598,0.075517],[0.86271,0.47323,0.17828],[-0.98225,0.14593,-0.11787],[-0.31949,-0.29366,-0.90094],[0.6829,0.53903,-0.49305],[-0.76043,0.62744,0.16752],[0.90384,-0.20912,-0.37329],[-0.7691,0.53439,-0.35059],[0.61979,0.69539,-0.36371],[0.86366,0.47795,0.16014],[-0.51513,0.79708,0.31511],[-0.70722,0.62361,-0.33309],[0.60908,-0.53948,0.58136],[0.35101,-0.55371,-0.75512],[-0.23989,-0.94803,-0.20901],[-0.65383,0.59386,0.46886],[-0.58076,-0.2213,-0.78342],[-0.691,0.58118,-0.42982],[-0.73731,-0.15366,0.65785],[-0.13539,-0.73285,-0.66678],[-0.75945,0.29923,-0.57766],[0.88972,0.3992,-0.22143],[0.75757,0.63432,-0.15405],[-0.70439,0.59011,0.39446],[-0.31917,0.21532,0.92291],[0.57328,-0.19287,0.79634],[-0.76403,0.63022,0.13816],[0.69948,0.70689,-0.10504],[0.026852,-0.58499,-0.8106],[-0.79594,0.37513,-0.47514],[0.73541,0.67582,-0.0494],[-0.52101,0.82197,0.23002],[0.65876,0.75176,0.029819],[-0.25272,-0.38749,-0.88656],[0.93216,0.31486,-0.17873],[-0.21876,0.07838,0.97263],[0.44798,0.83269,0.3255],[0.54526,0.82235,0.16255],[-0.73458,-0.16539,0.65805],[0.54848,-0.58056,-0.60177],[0.2421,0.91042,0.33545],[0.33336,0.8649,0.37527],[0.57426,-0.25885,0.77668],[0.42505,-0.50596,-0.75056],[-0.01283,0.32194,0.94667],[0.60398,-0.50957,0.61282],[-0.82314,-0.38762,0.41496],[-0.90414,-0.40626,0.13227],[0.86682,0.45095,-0.21278],[0.051151,0.84919,0.52561],[-0.23079,0.9063,0.35406],[-0.087843,0.94946,0.30135],[0.9271,-0.30869,-0.21261],[0.79875,0.56793,-0.19865],[0.0012131,-0.70402,-0.71018],[-0.86866,0.49525,0.012644],[-0.53665,-0.52068,0.664],[0.84577,0.49538,0.19815],[0.77895,0.52283,0.34625],[-0.67784,0.72572,0.11776],[-0.51215,0.82864,0.22595],[0.70517,0.67257,-0.22444],[0.63504,0.71351,0.29601],[-0.1559,-0.65881,-0.73598],[0.82826,0.5592,-0.035804],[-0.90876,0.37204,-0.18907],[0.70814,0.69809,0.10584],[-0.85473,-0.2931,0.4284],[-0.7401,0.58001,0.34036],[-0.096362,-0.43388,-0.8958],[0.69843,0.69028,0.18899],[-0.70743,0.6972,0.11598],[0.58412,0.78603,0.20238],[0.35429,0.89404,0.27417],[-0.98844,-0.1348,-0.069425],[0.5419,-0.62415,-0.56283],[-0.65287,0.73605,-0.17883],[-0.89403,-0.3856,0.2281],[-0.42459,0.86747,-0.25926],[-0.040331,-0.90272,-0.42834],[0.17202,0.95002,-0.26053],[0.18611,0.95969,-0.2106],[-0.59477,0.021192,0.80362],[0.92482,-0.36814,-0.09587],[0.37917,0.90363,-0.19919],[0.68998,-0.67115,-0.27109],[-0.045913,0.99882,-0.015645],[0.16693,0.9856,-0.027167],[-0.18552,-0.7067,-0.68276],[-0.30878,-0.65207,-0.69243],[0.4989,-0.3606,0.78807],[-0.24715,-0.19237,0.94969],[0.32789,-0.75441,-0.56865],[-0.1639,-0.71543,-0.67919],[0.58754,-0.53472,-0.60735],[0.026828,-0.62623,-0.77917],[0.23191,0.14712,0.96155],[0.72593,-0.49989,-0.47237],[0.40648,-0.76319,-0.50232],[-0.28032,-0.75659,-0.59075],[0.28276,-0.94873,-0.14129],[0.8949,-0.17412,-0.4109],[-0.37097,-0.62159,-0.68994],[-0.45354,-0.68373,0.57169],[0.96032,-0.19367,-0.2007],[0.39646,-0.67819,-0.61877],[0.98405,-0.14696,-0.10021],[-0.4571,-0.72626,-0.51342],[0.68404,-0.2505,-0.68508],[-0.94739,0.020541,0.31941],[-0.62901,-0.60919,-0.48295],[-0.029599,-0.97527,-0.21903],[-0.66939,0.69078,0.27339],[-0.73234,-0.47616,-0.48678],[0.3727,-0.50523,-0.77836],[-0.51929,-0.5911,-0.6172],[0.31744,0.4733,0.82172],[-0.92751,0.32922,0.177],[-0.89314,-0.31363,-0.3224],[-0.95537,-0.16024,0.24817],[0.68599,-0.52149,-0.50741],[0.022803,-0.86049,0.50895],[-0.52655,-0.58258,-0.61915],[-0.61771,-0.16729,-0.76841],[-0.94879,0.27952,0.1472],[0.97132,-0.17603,-0.15984],[0.56187,-0.43114,-0.70599],[0.53997,-0.42788,-0.72481],[0.92792,-0.031161,-0.37148],[-0.36146,-0.33744,-0.86918],[0.086952,0.20384,0.97513],[-0.47393,0.12281,0.87195],[-0.15701,-0.30982,-0.93774],[-0.047176,-0.35964,-0.9319],[-0.5277,-0.356,0.77123],[0.55709,-0.43936,-0.70471],[0.088281,-0.34733,0.93358],[0.5367,-0.35064,-0.76747],[-0.55422,-0.53037,-0.64152],[-0.20367,-0.23254,-0.95102],[-0.49108,-0.0019639,0.87111],[-0.54535,-0.49043,-0.67976],[0.6622,-0.63451,-0.3986],[0.20135,-0.28627,-0.93675],[-0.086715,-0.17406,-0.98091],[0.40095,-0.52134,0.75329],[0.5982,-0.39665,-0.69629],[-0.60241,-0.3586,-0.7131],[0.96346,-0.25932,-0.067048],[-0.7575,-0.4208,-0.49912],[-0.36326,-0.77486,-0.51733],[0.3021,0.08514,-0.94947],[-0.13503,0.23371,-0.96288],[0.18093,0.13225,-0.97456],[0.52103,-0.17271,-0.83588],[-0.39497,0.27422,0.87681],[0.31818,0.14593,-0.93673],[0.497,-0.057909,-0.86581],[-0.18835,-0.021173,-0.98187],[0.80136,-0.30994,-0.51162],[0.82694,-0.56205,-0.016037],[0.84604,-0.47882,-0.2344],[-0.905,-0.28728,-0.31377],[-0.28145,-0.34084,-0.897],[-0.5518,-0.36731,0.74873],[0.44403,0.65087,0.6158],[-0.83552,-0.33398,-0.4363],[-0.31627,-0.73574,0.59888],[0.25386,-0.055412,0.96565],[-0.76056,0.18012,0.62379],[-0.75875,-0.18181,-0.6255],[-0.032909,-0.047001,-0.99835],[0.99616,0.082807,0.028477],[-0.64534,-0.59086,-0.48417],[-0.067223,-0.94677,-0.31482],[-0.12056,-0.98497,-0.12368],[-0.15209,-0.96012,-0.23461],[0.35322,-0.9154,-0.19307],[-0.51226,-0.67702,0.52842],[0.013427,-0.87506,-0.48382],[-0.68294,0.13379,-0.71812],[0.23043,0.32824,-0.91606],[-0.32535,-0.37678,-0.86728],[0.99136,-0.12247,-0.046938],[0.29531,-0.87398,-0.38594],[-0.60856,-0.18811,0.77089],[0.2301,-0.85292,-0.4686],[0.49244,-0.34798,0.79775],[0.27751,0.40627,-0.8706],[0.43515,0.049497,-0.89899],[-0.94793,-0.0025642,-0.31846],[0.39217,-0.68254,-0.61673],[-0.76381,-0.071906,-0.64142],[-0.082417,-0.055215,-0.99507],[-0.12503,-0.7987,-0.58859],[-0.77314,-0.42212,-0.47336],[0.12243,-0.89779,-0.42306],[-0.12638,-0.92856,-0.349],[-0.13133,-0.94893,0.28685],[-0.93928,0.078557,-0.33405],[0.49905,-0.86645,0.01475],[-0.7303,-0.47967,-0.4864],[0.51221,-0.77422,0.37179],[0.38193,0.6069,-0.697],[0.20099,0.40445,-0.8922],[0.049596,0.1937,-0.97981],[-0.14674,-0.16611,-0.97513],[0.9188,-0.29262,-0.26491],[-0.42245,-0.57292,-0.70235],[-0.1853,-0.72842,-0.65959],[0.75453,-0.64927,-0.095568],[0.96853,0.20055,-0.14743],[-0.02633,-0.99959,-0.010913],[0.45749,-0.88872,0.029698],[0.64745,-0.1235,0.75203],[0.062309,0.29505,-0.95345],[-0.25699,-0.29439,-0.92048],[0.4551,0.10819,-0.88384],[-0.523,-0.55488,-0.64697],[0.17412,-0.96478,0.1972],[-0.27374,-0.95434,-0.11962],[0.31284,-0.90825,-0.27787],[-0.72642,0.057558,-0.68484],[-0.70684,0.35292,-0.61304],[-0.018842,0.1462,0.98908],[0.54718,-0.83437,0.066459],[0.82817,-0.066109,0.55657],[-0.94051,0.31014,0.13877],[0.28236,0.087453,-0.95531],[0.94096,-0.21411,0.26222],[-0.29064,0.23999,0.92625],[-0.68078,0.30312,0.66683],[-0.56755,-0.817,0.10199],[0.94396,0.33006,0.0011539],[0.33211,0.36909,-0.86803],[-0.13347,-0.58274,-0.80163],[-0.13648,-0.39013,-0.91059],[-0.45597,-0.52587,-0.71802],[0.72815,-0.67069,0.1413],[-0.60202,-0.11109,0.79071],[0.052203,-0.037005,-0.99795],[0.61717,-0.28038,0.73518],[0.38125,-0.42473,-0.82112],[-0.019645,0.067712,-0.99751],[0.39493,0.29808,-0.86901],[0.20904,0.36095,-0.90886],[-0.82807,-0.35894,-0.43066],[-0.95134,-0.17719,-0.25212],[0.99354,0.049221,0.10223],[0.17455,0.19892,0.96435],[0.43505,-0.49791,-0.75021],[-0.68508,0.12845,-0.71705],[0.11186,-0.9903,0.082441],[-0.14167,0.029275,-0.98948],[-0.89299,-0.26526,-0.3636],[0.22539,0.060974,0.97236],[-0.67384,-0.22463,-0.7039],[0.59068,-0.7807,0.20397],[-0.5319,-0.63673,0.55826],[0.82015,-0.54258,-0.18154],[-0.58987,0.21836,-0.77742],[0.2905,-0.047983,-0.95567],[0.068431,0.15158,-0.98607],[-0.61035,-0.58804,-0.53074],[0.26975,-0.36283,-0.89196],[-0.049651,0.14219,-0.98859],[0.87484,-0.093209,0.47536],[-0.44567,-0.56694,0.69279],[-0.094603,-0.32011,-0.94265],[0.96953,0.077894,0.23225],[-0.33224,-0.71886,-0.61063],[0.50224,0.25313,-0.82685],[0.053744,0.46048,0.88604],[-0.95531,-0.10972,-0.27449],[0.53831,-0.12768,-0.83302],[0.51549,-0.4491,0.72978],[0.13422,-0.017133,-0.9908],[0.033702,0.17465,-0.98405],[-0.73341,-0.15266,-0.66243],[0.61315,-0.77978,0.12648],[0.65855,-0.74934,0.069278],[0.94655,-0.31194,0.082104],[0.41191,-0.90493,-0.10696],[0.73424,-0.017471,0.67867],[-0.31001,0.33936,-0.8881],[0.23009,0.35566,-0.90585],[-0.029838,-0.018397,-0.99939],[0.38616,-0.40017,-0.83111],[0.12233,0.21572,-0.96876],[-0.64266,0.11189,0.75794],[-0.91913,-0.31035,-0.24267],[0.3352,0.36935,-0.86673],[-0.43857,-0.59311,0.67518],[-0.48121,-0.86649,-0.1328],[-0.1238,0.26399,-0.95655],[-0.052232,0.49349,-0.86818],[0.098757,0.19462,0.97589],[0.53201,-0.4337,-0.72724],[-0.78296,-0.44233,-0.4374],[0.86349,0.030542,0.50344],[-0.15199,0.48313,-0.86225],[0.02585,0.52107,-0.85312],[0.13603,0.44947,-0.88288],[-0.17535,-0.10654,0.97872],[0.7859,0.013683,-0.6182],[-0.76064,-0.093516,-0.6424],[-0.48839,-0.44404,0.75121],[0.8905,-0.41525,0.18595],[0.097942,0.38274,-0.91865],[0.33823,-0.71569,0.61106],[-0.26086,0.090078,0.96117],[-0.27848,0.22324,-0.93414],[-0.13581,-0.90804,0.39626],[-0.072683,-0.97609,0.20484],[-0.8757,-0.35008,-0.33256],[0.57243,-0.80694,-0.14551],[-0.68629,0.34782,-0.63877],[0.95026,-0.025131,0.31043],[-0.37811,-0.92516,0.033457],[0.55909,-0.0093389,-0.82906],[0.71702,-0.086582,0.69165],[-0.1335,-0.38672,-0.91248],[0.21402,-0.37571,-0.90168],[-0.85099,-0.11238,0.51302],[-0.12729,0.17128,-0.97696],[-0.0056685,0.22256,-0.9749],[-0.042397,0.51934,-0.85352],[-0.15117,-0.93308,0.32635],[-0.83249,-0.003606,-0.55403],[-0.67007,-0.13244,-0.73039],[0.17667,-0.3539,-0.91845],[0.96798,0.04198,0.24749],[-0.2445,-0.37977,-0.89218],[-0.27944,-0.43076,-0.85811],[-0.97009,0.20224,0.13428],[0.7689,0.063328,0.63623],[0.46325,-0.58723,-0.66374],[-0.81965,-0.099029,-0.56424],[-0.58681,-0.29146,0.75545],[-0.91904,-0.37118,0.13266],[0.29597,-0.32845,-0.89695],[-0.0047801,-0.28481,-0.95857],[-0.17576,-0.30537,-0.93587],[-0.083242,-0.23323,-0.96885],[-0.050678,-0.33203,-0.94191],[0.099884,-0.48846,-0.86685],[0.0079383,-0.5172,-0.85583],[0.49131,-0.69364,-0.52677],[0.64687,0.21795,0.73079],[0.56483,0.2617,-0.78261],[-0.77619,-0.014187,-0.63034],[0.67002,-0.20259,0.71416],[-0.045475,-0.19301,-0.98014],[0.37642,-0.6629,0.64721],[0.58432,-0.67208,-0.45483],[-0.97684,-0.16269,-0.13899],[-0.25106,0.036212,0.96729],[0.96183,-0.027784,0.27223],[-0.97076,-0.12531,0.20474],[0.82461,-0.27419,0.49481],[0.73868,0.55631,0.38063],[0.26282,-0.27682,-0.92428],[0.58218,-0.57056,-0.57925],[0.96182,-0.24048,-0.13067],[-0.60402,-0.27498,0.74803],[-0.79163,-0.023391,-0.61056],[-0.73368,-0.21377,0.64499],[0.54832,0.42915,-0.71776],[0.77228,0.17234,0.61146],[0.25232,-0.17921,-0.9509],[0.19062,-0.56816,-0.80053],[0.20535,-0.60925,-0.76593],[0.31179,0.11737,0.94287],[-0.72928,0.38208,-0.5676],[-0.96888,0.11459,-0.21941],[0.3846,0.57137,0.725],[0.017993,0.05622,0.99826],[-0.96081,-0.21578,-0.17401],[0.14017,-0.082685,-0.98667],[0.35483,-0.12254,-0.92686],[-0.95401,0.13977,-0.2652],[-0.608,0.36255,0.70633],[0.19552,0.028138,-0.9803],[0.27623,0.20914,-0.93806],[-0.9923,0.10276,-0.069117],[-0.99798,0.059027,0.023535],[-0.34963,-0.22138,0.91036],[-0.48582,-0.20986,0.84849],[0.91365,-0.1721,-0.36826],[-0.62861,-0.18279,-0.75593],[0.24602,0.24295,-0.93832],[0.11558,0.11505,-0.98661],[-0.97057,-0.13303,-0.20075],[0.8859,-0.17498,0.42961],[0.2424,0.16575,-0.95591],[0.15458,0.22019,-0.96313],[0.34481,0.32951,-0.87894],[-0.16416,-0.10641,0.98068],[-0.27036,-0.16874,0.94786],[-0.44317,0.60628,0.66032],[0.28567,0.36809,-0.88482],[-0.65859,-0.3945,0.64081],[-0.45624,0.45549,0.76444],[0.4642,0.57166,0.67655],[0.53724,-0.47451,-0.69729],[0.23392,0.10812,-0.96623],[-0.97665,-0.020387,0.21386],[-0.36616,-0.081218,0.927],[0.61887,-0.09166,-0.78013],[-0.9762,-0.044251,-0.21229],[0.38928,0.20415,-0.89821],[0.929,0.17058,-0.32843],[0.96097,0.11352,0.2523],[0.99866,-0.042437,-0.029491],[-0.74113,0.030969,-0.67065],[-0.97056,0.1031,0.21766],[0.97849,0.17843,-0.10353],[0.93044,-0.052761,0.36262],[0.50358,0.59703,-0.62447],[0.51554,0.35956,-0.77777],[0.73208,-0.24017,-0.63748],[-0.9736,0.068759,0.21764],[-0.57988,0.40662,0.70598],[0.39312,0.66405,-0.63599],[-0.67034,0.13607,-0.72947],[-0.90652,0.41922,0.049754],[-0.69574,0.2132,-0.68592],[0.75569,-0.083981,-0.64953],[-0.34546,0.077287,0.93524],[0.50806,0.7446,-0.43295],[0.98921,-0.13928,-0.045502],[0.79887,0.060022,-0.5985],[-0.125,-0.44587,-0.88633],[0.070852,-0.34883,-0.93451],[-0.91049,0.30192,0.28258],[-0.032361,-0.14675,0.98864],[0.93436,0.01102,0.35615],[-0.663,0.28642,0.69166],[-0.031758,0.69624,0.7171],[-0.55295,0.35167,-0.75536],[-0.4097,-0.55733,-0.72217],[-0.29088,-0.5102,-0.80937],[0.29621,-0.24349,-0.92357],[0.52788,-0.049052,-0.8479],[-0.57262,0.49988,0.64978],[-0.71764,0.21071,0.66377],[-0.75491,0.27343,0.59611],[0.0014477,0.20343,0.97909],[-0.42106,0.17024,0.89091],[0.16045,0.96356,-0.21401],[0.19953,0.9615,-0.18898],[0.88986,0.20889,-0.40559],[-0.8915,0.4505,0.047674],[-0.99544,0.033318,-0.089389],[-0.97496,0.024892,0.221],[0.29243,0.7743,-0.5612],[0.77371,0.082871,-0.62809],[-0.99696,-0.017536,0.07597],[0.71411,0.19572,-0.67212],[0.94232,0.32389,0.084416],[0.38922,0.40491,0.82738],[0.91297,0.085014,0.39906],[0.028722,0.73304,-0.67958],[-0.2871,0.031431,0.95739],[0.066183,0.65341,-0.75411],[0.1887,-0.22317,0.95634],[-0.73824,0.39947,-0.54352],[-0.64758,0.19784,0.73587],[0.20962,0.054048,0.97629],[-0.47361,-0.68422,-0.55456],[-0.99699,-0.024412,0.07363],[0.92368,0.37988,0.050104],[-0.62423,0.2434,0.74236],[-0.45346,0.23791,0.85894],[0.189,0.94215,-0.27684],[0.13211,0.90467,-0.40513],[0.95088,0.088799,0.29656],[-0.4539,0.52575,0.71942],[-0.34072,-0.75168,-0.5647],[-0.44183,-0.70355,-0.5566],[0.7192,0.28163,-0.63517],[-0.86819,0.32444,0.37548],[0.53477,0.38151,0.75397],[0.46563,0.85437,0.23073],[0.088193,0.1879,0.97822],[0.99416,0.10606,-0.019983],[-0.99506,0.061576,0.077907],[-0.44222,-0.74418,-0.50063],[-0.73901,0.53226,-0.41299],[0.13343,-0.35471,0.9254],[-0.2937,-0.8142,-0.50081],[0.9245,-0.37772,0.051221],[-0.31106,-0.7976,-0.51679],[0.76447,0.32079,-0.55918],[-0.87993,0.26803,-0.39228],[-0.094702,0.40179,0.91082],[-0.029463,0.42782,0.90338],[0.28318,0.62877,0.72419],[-0.96212,-0.12168,0.24396],[-0.20404,-0.052764,0.97754],[-0.18242,0.21297,0.95988],[-0.82652,0.5497,0.12123],[-0.86083,0.47806,0.17442],[-0.93724,-0.0041271,-0.34865],[0.77263,0.1567,0.61521],[-0.26547,0.17925,0.94731],[-0.10425,0.63109,0.76867],[0.99605,-0.064609,0.060892],[0.28397,0.6421,0.71209],[-0.58286,0.66965,-0.46026],[0.97109,0.23664,-0.031529],[-0.68666,0.24867,0.68313],[0.83531,0.51907,0.18119],[-0.17472,0.67395,0.71782],[-0.1171,0.81082,0.57346],[-0.24205,0.012017,0.97019],[0.53152,-0.83595,-0.13668],[-0.65493,0.25529,0.71126],[-0.93227,-0.1732,-0.31759],[0.8054,0.30828,-0.50626],[-0.25393,0.7801,0.5718],[0.97431,0.055724,0.21821],[-0.55757,0.44045,-0.70364],[-0.57748,0.38769,-0.71848],[0.7943,0.47562,-0.37798],[-0.87,0.4583,0.18181],[-0.70237,0.47382,-0.53119],[0.88025,0.14248,0.45261],[0.79311,0.17153,0.58443],[0.6802,0.67589,-0.28372],[-0.92211,0.20427,0.32862],[0.43379,0.15895,0.88689],[0.67489,0.61668,-0.40527],[-0.38334,0.64302,0.663],[0.707,0.45943,-0.53766],[-0.52819,0.78426,0.32549],[0.022769,0.1733,0.98461],[-0.6799,0.68529,-0.26097],[0.84736,0.35976,-0.39058],[-0.70737,0.6617,-0.24855],[0.80678,0.57904,0.11758],[-0.67513,0.37395,0.63589],[0.88249,0.38778,0.26615],[0.67906,0.72978,0.079366],[-0.86368,0.35107,-0.36167],[0.60937,0.76233,-0.21798],[-0.82242,0.35029,-0.44825],[-0.57777,0.73662,0.35155],[0.96203,-0.22776,0.15039],[-0.83471,0.47283,-0.28231],[0.7963,0.35801,0.48758],[0.55032,0.82692,-0.11555],[0.138,0.35268,0.92551],[-0.83569,0.51349,-0.19479],[0.90686,0.29455,-0.30141],[-0.6148,0.64147,0.45884],[0.44441,0.71359,0.54156],[-0.95631,0.26783,0.11725],[-0.21115,0.74769,0.62958],[-0.20932,0.75434,0.62222],[-0.53929,0.52136,0.66132],[0.21331,0.88153,0.42119],[0.41668,0.71798,0.55757],[0.86241,0.48983,-0.12774],[0.077164,0.88425,0.46059],[-0.67209,0.7253,-0.14913],[-0.73486,0.66298,-0.14296],[0.62724,0.75243,-0.20105],[0.72044,0.69305,-0.025539],[-0.86964,0.49367,0.0027898],[0.18922,0.2414,0.9518],[0.6928,0.70298,0.16077],[0.67655,0.26314,0.68777],[0.31831,0.041925,0.94706],[-0.99556,0.051897,0.078537],[0.86493,0.15837,0.47624],[-0.57043,0.79824,-0.19343],[0.22558,0.17218,0.95889],[-0.695,0.71174,-0.102],[0.86929,0.48751,-0.081611],[0.85911,0.45573,-0.23288],[-0.89249,0.36579,-0.26394],[0.77208,0.63331,-0.052947],[-0.77702,0.62461,-0.078066],[0.5501,0.83242,0.066748],[-0.91929,-0.25676,-0.2983],[0.76982,0.59968,0.21854],[-0.66035,0.74839,-0.062094],[-0.45895,0.88065,0.11756],[-0.37717,0.90785,0.18314],[0.60604,0.71434,0.3499],[-0.73494,0.63175,0.24648],[0.88255,0.11688,0.45546],[-0.93636,0.24399,0.25239],[0.46656,0.88274,0.055699],[-0.73566,0.65249,-0.18183],[0.58705,0.80008,0.12345],[0.57904,0.76063,-0.29351],[0.43801,0.88895,-0.13387],[-0.48244,0.84848,-0.21755],[-0.5572,0.80564,-0.20118],[-0.4225,0.26401,0.86706],[0.57464,0.81048,-0.11364],[0.28809,0.93978,-0.18388],[-0.63904,0.76719,-0.055188],[0.47792,0.87738,-0.042434],[0.30158,0.95341,-0.0081548],[0.08211,0.99609,-0.032704],[0.66878,0.25671,0.69774],[-0.036994,-0.77121,-0.6355],[-0.61913,0.030341,0.7847],[0.24332,-0.78036,-0.57606],[-0.23396,0.28925,0.92822],[-0.2938,-0.68908,-0.66245],[-0.18283,-0.79432,-0.57934],[-0.085367,-0.73329,-0.67453],[0.018922,-0.72407,-0.68947],[0.15124,-0.63415,-0.75827],[-0.11007,-0.1519,0.98225],[0.27276,0.0067186,0.96206],[-0.29728,-0.84802,-0.43873],[-0.70431,0.33755,0.6245],[0.22746,-0.56925,-0.79007],[0.87254,0.1504,0.46482],[-0.43281,-0.6681,-0.60524],[0.34265,-0.54414,-0.76583],[0.4668,-0.714,-0.52182],[0.70299,0.55888,0.43984],[0.86687,0.066222,0.49412],[-0.53625,-0.67782,-0.50299],[-0.6575,-0.58391,-0.47618],[0.96501,-0.23476,-0.11679],[-0.67466,0.59164,0.44136],[0.59169,-0.53554,-0.60259],[0.49314,0.4797,0.72574],[-0.28656,0.26247,0.92141],[0.62759,-0.42622,-0.65151],[-0.58186,-0.46381,-0.66808],[-0.35892,0.29312,0.88614],[-0.73979,0.23266,0.63133],[0.38179,-0.009488,0.9242],[-0.13471,-0.36335,-0.92186],[0.79863,0.075251,0.5971],[-0.10833,-0.43801,-0.89242],[0.98154,-0.16641,-0.094242],[-0.65769,-0.43742,-0.61328],[-0.57141,0.48778,0.65997],[0.77267,0.24344,0.58628],[0.6706,-0.38487,-0.63417],[0.30526,-0.41202,-0.85852],[-0.12006,-0.33532,-0.93442],[-0.53827,0.75228,0.37992],[0.62507,-0.46336,-0.62816],[-0.93762,-0.26412,-0.22608],[-0.73344,-0.3621,-0.57529],[0.17506,0.16322,0.97093],[-0.56994,-0.6253,-0.53307],[-0.4969,0.36996,0.785],[-0.45521,0.78116,0.42729],[-0.60319,-0.56432,-0.56365],[-0.074865,-0.13763,0.98765],[0.98508,0.015028,0.17142],[-0.49409,0.5329,0.68695],[0.60785,-0.34059,-0.7173],[-0.68785,-0.31877,-0.65211],[-0.22102,0.25845,0.9404],[0.90883,-0.15497,0.38732],[-0.75628,0.36354,0.54394],[-0.81487,0.56672,0.1217],[-0.69395,0.23484,0.68064],[0.9902,-0.094159,-0.10311],[0.61291,-0.29983,-0.73105],[0.59663,-0.23583,-0.76709],[-0.76527,-0.28754,-0.57592],[0.97165,0.10497,0.21186],[-0.7834,-0.22721,-0.5785],[0.90247,0.21761,0.37175],[0.64334,-0.14812,-0.75112],[-0.023852,-0.98462,-0.17309],[0.16857,-0.97693,-0.13113],[0.3186,-0.86961,0.37719],[0.58229,0.00064118,-0.81298],[0.60753,-0.66823,0.42938],[-0.2549,-0.96227,-0.095222],[0.35775,-0.87674,-0.32147],[-0.17417,-0.82752,-0.53373],[0.20168,-0.9438,0.26186],[0.10068,-0.91752,-0.38473],[0.91704,-0.029177,0.39772],[0.45444,-0.78496,0.4211],[-0.096525,-0.81675,-0.56887],[0.24284,-0.72762,-0.64156],[0.44658,-0.41371,-0.79335],[0.56425,0.097315,-0.81985],[-0.23244,0.2128,0.94904],[0.089189,-0.92,-0.38163],[0.15426,-0.94497,-0.28851],[0.24929,-0.92979,-0.27082],[-0.16912,-0.85677,0.48718],[-0.081442,-0.87431,0.47849],[0.23473,-0.92496,0.29891],[0.82361,0.40749,0.39448],[0.64571,0.29113,0.70591],[0.56471,-0.013778,-0.82518],[-0.80936,0.37429,0.45259],[-0.43979,-0.60343,-0.66518],[-0.23536,-0.75787,-0.60848],[-0.66898,-0.71456,-0.20464],[-0.61586,0.77511,-0.14117],[0.10187,-0.97245,0.20965],[0.73335,-0.65324,0.18836],[-0.3368,-0.92959,-0.14975],[0.5571,-0.16053,-0.81478],[-0.41978,-0.53626,-0.73226],[-0.58494,-0.44219,-0.67994],[-0.4848,-0.87352,0.043836],[-0.38709,-0.92103,-0.043177],[0.41996,-0.55515,-0.71794],[0.5551,-0.83114,0.032524],[0.68462,-0.71001,0.16483],[0.19697,0.053646,-0.97894],[0.45897,0.20711,-0.86398],[-0.67724,-0.70092,0.22375],[0.45058,-0.51214,-0.73123],[-0.90589,0.2887,0.30985],[0.84043,-0.52603,0.13028],[0.74497,-0.66197,0.082583],[-0.14923,0.30866,0.93939],[0.24675,0.36154,-0.89911],[0.25359,-0.96609,0.048506],[-0.7014,-0.64171,0.31024],[0.49889,-0.34805,-0.7937],[0.35083,-0.93634,0.013936],[-0.65255,-0.7138,0.25428],[-0.78417,-0.61688,-0.067422],[0.22441,0.41075,-0.8837],[0.95618,0.27686,0.095185],[-0.70542,-0.1097,-0.70025],[-0.7046,-0.59589,0.3853],[0.52571,0.46691,0.71107],[0.54295,-0.82943,0.13132],[0.53603,-0.16963,-0.82698],[0.9367,-0.34551,-0.056796],[0.49619,0.30919,-0.8113],[-0.46521,-0.64275,0.60864],[-0.31939,0.015134,-0.9475],[-0.9249,0.15397,0.34764],[0.58258,0.26961,-0.76675],[0.86902,-0.49412,0.025628],[0.10192,-0.96068,-0.25826],[-0.4086,-0.40054,-0.82013],[-0.034529,-0.41264,-0.91024],[-0.43579,0.25798,-0.86229],[-0.93461,-0.034348,0.35402],[0.28958,-0.10548,-0.95132],[0.49688,0.33523,-0.80046],[-0.71723,-0.02853,-0.69625],[-0.73282,-0.67706,0.06749],[-0.46245,-0.45491,0.76105],[0.78629,-0.41026,0.46198],[0.45935,-0.075711,0.88502],[-0.68164,-0.20483,-0.70243],[0.1224,-0.36435,-0.92318],[0.89258,-0.32734,0.31009],[-0.15067,-0.12615,-0.9805],[-0.23495,-0.037329,-0.97129],[0.19996,-0.23894,-0.95022],[0.079768,0.04703,-0.9957],[0.25569,0.46154,-0.84947],[0.89491,-0.13491,0.42537],[-0.90416,-0.40496,-0.13603],[0.41912,0.59271,0.68777],[0.54062,-0.82327,-0.17307],[-0.63449,-0.20244,-0.74595],[-0.11204,-0.12587,-0.9857],[0.17465,-0.031346,-0.98413],[-0.090107,0.13511,-0.98672],[0.084354,0.14325,-0.98609],[0.045553,0.33868,-0.9398],[0.044584,0.47254,-0.88018],[0.088453,0.47394,-0.8761],[-0.87858,-0.47728,-0.017419],[-0.45312,-0.33916,0.82441],[0.85545,-0.36877,0.36361],[0.30949,-0.29796,-0.90302],[0.25619,-0.066394,-0.96434],[-0.32576,0.022192,0.94519],[0.65264,-0.75764,0.006312],[0.73559,-0.50841,0.4477],[0.56584,0.15578,-0.80966],[-0.69852,-0.40879,0.58733],[-0.85396,0.0018428,-0.52034],[0.11322,-0.14744,0.98257],[-0.76341,0.018438,-0.64565],[0.45784,-0.37659,-0.80534],[-0.9376,-0.34766,0.0068669],[-0.61901,-0.30254,0.72477],[-0.76128,0.47689,0.43936],[0.55353,-0.5442,-0.63044],[-0.97003,-0.0010565,-0.24297],[-0.33749,-0.052247,0.93988],[-0.62271,-0.25724,0.73895],[-0.85547,0.40239,0.32595],[-0.80618,0.0074938,-0.59163],[0.26353,-0.6716,-0.69246],[0.26778,-0.71059,-0.65066],[0.55913,0.36668,-0.74359],[-0.8739,-0.45572,-0.16918],[0.36255,-0.62463,-0.69165],[-0.68571,0.58173,0.43748],[0.93375,-0.086298,0.34737],[0.5525,-0.52591,0.64666],[0.45188,-0.26681,-0.85124],[-0.61137,0.65358,0.44617],[-0.54061,-0.10778,0.83434],[-0.63689,-0.12968,0.75997],[-0.72602,-0.22348,-0.65034],[-0.69517,-0.40911,0.59107],[0.40397,0.12607,-0.90604],[0.68009,-0.73238,0.033131],[0.54735,0.20009,0.81263],[-0.98073,0.12719,-0.14832],[-0.74019,-0.6398,-0.20684],[-0.4583,-0.09953,0.88321],[0.67178,0.081112,0.73629],[-0.71709,-0.19193,-0.67003],[0.89672,-0.4387,0.058647],[-0.88001,-0.21379,0.42411],[-0.74159,-0.10358,-0.66281],[0.30395,0.41279,-0.85862],[0.34425,0.36364,-0.8656],[0.583,-0.77285,0.25064],[0.57107,-0.35676,-0.73932],[-0.26273,-0.099009,0.95977],[-0.70624,-0.70052,-0.10246],[-0.13804,0.34964,0.92666],[-0.47463,-0.71131,-0.51843],[0.54937,-0.39711,-0.73519],[0.32684,0.4011,-0.85574],[0.89264,-0.013208,0.45058],[-0.32985,-0.08027,0.94062],[-0.79858,0.029667,-0.60116],[-0.89516,-0.30923,0.32105],[-0.64797,0.072439,0.75821],[0.90692,-0.39059,0.15789],[0.65914,0.26348,-0.70435],[0.52364,0.15025,-0.83859],[-0.85989,-0.45578,-0.22991],[0.49439,0.60057,-0.6284],[0.60467,0.31146,0.73305],[0.27513,-0.48891,-0.82781],[-0.76655,-0.16781,0.61987],[0.77189,-0.60923,-0.18173],[-0.26897,-0.06057,0.96124],[-0.88245,-0.44297,-0.15828],[0.986,0.044341,0.16076],[-0.81096,0.070356,-0.58085],[-0.20298,-0.46665,-0.86084],[0.5463,0.47082,0.69274],[0.17414,-0.29403,-0.9398],[-0.21308,0.040201,0.97621],[0.73365,-0.62989,-0.25494],[0.78739,-0.094991,0.6091],[-0.94328,-0.079292,0.32239],[-0.64509,0.084467,0.75942],[0.41135,-0.10534,-0.90537],[0.50287,-0.037477,-0.86355],[0.98043,0.037559,0.19326],[0.71996,0.48243,0.49892],[-0.87651,-0.29259,0.38225],[0.41051,0.82947,-0.37875],[0.83659,-0.54269,0.074902],[0.68011,-0.011511,-0.73302],[-0.75841,0.5621,0.32993],[-0.55045,-0.24506,0.79809],[-0.76112,-0.50091,0.41204],[0.12128,0.32578,0.93763],[0.71207,0.13291,-0.68941],[-0.85281,-0.29993,-0.42751],[0.67938,0.12006,-0.7239],[-0.7244,-0.14658,0.67362],[-0.7355,0.27201,0.62053],[0.724,-0.66423,0.18609],[0.45836,-0.042435,0.88775],[0.26423,0.94765,-0.17928],[-0.2783,0.15062,0.94861],[-0.11299,0.15244,0.98183],[0.3732,0.72794,-0.57517],[0.33831,0.75868,-0.55673],[0.46948,0.72882,0.4984],[-0.46599,0.50659,-0.72541],[-0.79016,-0.40905,0.45643],[-0.86111,0.2617,0.4359],[0.43139,-0.87588,0.2162],[0.34189,0.76443,-0.54659],[0.65779,0.65275,0.37582],[0.69354,0.2452,-0.6774],[-0.019683,0.27687,0.96071],[-0.14954,0.23428,0.9606],[0.8988,-0.43735,0.029784],[-0.13756,0.87338,-0.46721],[-0.53223,0.61645,-0.58027],[0.61566,0.0012904,-0.78801],[0.28685,-0.95126,0.11324],[-0.095727,0.34927,0.93212],[-0.24769,0.31812,0.91512],[0.12862,-0.99044,0.049765],[-0.42846,0.78283,0.45123],[0.28603,0.87934,0.38071],[-0.67893,0.55462,0.48109],[0.34091,0.93967,-0.028335],[-0.031711,0.90372,-0.42695],[-0.81353,0.48004,-0.32823],[0.13237,-0.99049,0.037525],[0.6787,0.36274,-0.63858],[-0.93226,0.29014,0.21611],[-0.20309,0.41155,0.88847],[-0.2804,0.41513,0.86548],[0.31975,0.79367,0.51754],[0.18341,0.74568,0.64056],[0.55769,-0.40397,-0.72511],[0.068198,0.20311,0.97678],[0.27154,-0.58914,-0.76104],[0.062001,-0.62355,-0.77932],[-0.80843,-0.16475,0.56506],[0.15063,-0.98428,0.092187],[-0.19423,0.50906,0.83853],[-0.25186,0.57554,0.77802],[0.4425,0.71889,0.5361],[0.66738,-0.72895,0.15242],[0.65813,-0.67902,0.32527],[0.21035,0.64696,0.73294],[-0.82889,0.46927,-0.30451],[0.89694,-0.42983,0.10363],[0.78895,0.61175,0.057599],[-0.72872,-0.5809,0.36266],[0.77035,-0.27162,0.57687],[0.025112,0.032233,0.99916],[0.71535,0.35374,-0.60261],[-0.85818,0.28026,-0.4301],[0.28827,0.68319,0.67094],[0.91992,-0.22369,0.32204],[-0.57486,0.50555,-0.6434],[-0.46825,0.69861,0.54101],[-0.80518,0.0099811,0.59295],[-0.61848,0.19989,0.75995],[-0.56793,0.46636,-0.67821],[-0.35851,0.58029,-0.73125],[-0.33869,0.55608,-0.75899],[0.88633,-0.013754,0.46284],[-0.036506,-0.022469,0.99908],[0.84334,0.52298,0.12359],[0.36633,0.099257,0.92518],[-0.56392,-0.79007,0.24037],[-0.72012,0.57694,0.38544],[0.88849,0.16231,0.42923],[-0.81245,0.14545,0.56459],[-0.58747,0.61145,0.5301],[-0.61527,-0.19053,0.76495],[-0.61368,0.64536,0.45487],[0.5789,0.067876,0.81257],[0.87662,0.45904,0.14431],[-0.83923,0.46939,-0.27453],[-0.81892,0.14122,0.55626],[-0.77753,0.60786,-0.16108],[-0.89046,-0.3374,-0.30536],[-0.49333,0.82923,0.26267],[-0.8445,0.5266,0.097534],[-0.56789,0.75338,0.33153],[-0.38421,-0.91877,-0.09084],[-0.50809,-0.85468,0.1066],[0.77148,0.54686,-0.32521],[-0.8535,0.44957,-0.26347],[-0.89244,-0.43843,-0.10646],[-0.68631,0.59408,0.41957],[0.37274,0.073165,0.92504],[-0.95909,-0.011377,0.28287],[0.8679,-0.4963,0.021135],[0.73515,0.63017,-0.24987],[0.35497,0.89025,0.28539],[0.75588,-0.58917,0.28554],[0.86431,0.40657,-0.29609],[0.96349,-0.030409,0.266],[-0.38344,0.83882,0.38646],[-0.48745,0.19805,0.85039],[0.3137,0.82997,0.46124],[0.42966,0.078839,0.89954],[-0.3508,0.81082,0.46851],[-0.066532,-0.38637,0.91994],[0.13692,0.83601,0.53136],[0.21526,0.84656,0.48682],[-0.84928,0.5133,-0.12347],[-0.050104,0.77983,0.62398],[-0.11644,0.74279,0.65932],[0.91101,-0.35113,-0.21627],[-0.21035,0.8138,0.54174],[0.86015,-0.27838,0.42736],[0.62461,0.55032,0.55408],[-0.95266,0.0042275,0.30401],[0.19798,0.77267,0.60314],[-0.87437,-0.46611,-0.13498],[-0.65397,0.74586,0.12654],[-0.85191,0.25603,0.45683],[0.6726,-0.44849,0.58861],[0.61171,0.77544,0.15652],[0.55926,0.60748,0.56409],[-0.82768,0.55592,0.076833],[0.7896,0.57342,0.21844],[-0.76999,0.63729,-0.031218],[0.79959,0.4188,0.43043],[0.96802,0.12052,0.22002],[0.6671,0.58898,0.45617],[0.91571,0.39285,-0.084475],[-0.68927,0.68183,-0.24498],[0.78902,-0.57085,-0.22709],[-0.84052,-0.53695,0.072151],[0.88617,0.43336,-0.16401],[-0.83348,0.54511,-0.090388],[0.92701,0.086762,0.36486],[-0.93075,0.35837,-0.072623],[0.51279,0.85751,0.041386],[-0.78208,-0.49882,0.37353],[-0.63611,0.7586,0.14103],[0.98252,0.08833,0.1639],[-0.46472,0.87736,0.11945],[-0.89254,0.44329,-0.082848],[0.37194,0.31288,0.87394],[0.66832,0.73709,-0.10024],[-0.87359,0.46474,-0.14442],[0.48808,0.86241,-0.13427],[0.039554,0.25338,0.96656],[0.32435,0.85831,0.39762],[0.69104,0.70627,-0.1538],[-0.74313,-0.51287,0.4298],[-0.66738,0.7307,-0.14379],[0.68394,0.68161,-0.26006],[-0.47156,0.40636,0.78262],[0.61904,0.76753,-0.16641],[0.93738,-0.32072,0.13587],[0.37724,0.88759,-0.26433],[-0.71178,0.7008,-0.047409],[0.65451,-0.75569,-0.02339],[0.14779,0.98531,-0.085605],[0.24334,0.96985,-0.013478],[0.10227,0.99472,0.0089501],[0.060905,0.9959,-0.066944],[0.36176,-0.90748,-0.21358],[-0.45602,0.62477,0.6338],[-0.5337,0.82128,0.20164],[0.23352,-0.82169,-0.5199],[-0.84341,-0.32623,0.42689],[-0.12853,-0.80833,-0.57452],[0.67238,0.062813,0.73753],[-0.38252,-0.69263,-0.61151],[0.37702,-0.79189,-0.48038],[0.92075,-0.25103,0.29867],[-0.27567,-0.84658,-0.45531],[0.96325,-0.21129,0.16584],[0.46909,-0.82526,-0.31448],[-0.45703,-0.8376,-0.29924],[0.95741,-0.1481,0.24785],[-0.58748,-0.57517,-0.56925],[-0.36854,0.57617,0.72952],[0.53775,-0.78652,-0.30365],[-0.86233,-0.29052,0.41471],[-0.61843,-0.72418,-0.30513],[0.98132,-0.14523,0.12616],[0.64129,-0.63243,-0.43448],[-0.87175,0.28727,0.3969],[0.091489,0.44706,0.88981],[0.6433,-0.76517,0.026072],[0.54096,-0.4784,-0.69174],[-0.35002,-0.93311,0.082407],[-0.51024,-0.71316,-0.48069],[0.60124,-0.61904,-0.50527],[0.22353,0.46001,0.85931],[-0.99317,0.098998,0.061709],[0.059953,-0.41573,-0.90751],[0.8665,0.082443,0.49232],[-0.93299,0.1665,0.31908],[-0.4988,0.79709,0.34036],[-0.97647,0.053456,0.20892],[-0.89333,-0.44606,-0.05475],[-0.0029975,-0.52865,-0.84883],[0.59458,-0.46262,-0.65761],[0.11021,-0.50273,-0.85739],[-0.19124,-0.36725,-0.91025],[0.15125,0.25939,0.95386],[-0.44228,-0.88767,0.12822],[0.59169,-0.78177,0.19684],[0.62542,-0.43886,-0.64518],[-0.85879,-0.22321,0.46115],[0.88127,0.05324,0.4696],[0.060019,0.32455,0.94396],[0.96117,0.18432,-0.20537],[0.58599,-0.54668,-0.59813],[0.67736,-0.73459,-0.039388],[0.97405,-0.1999,-0.10613],[0.60834,-0.44783,-0.65527],[0.72461,-0.68602,-0.06576],[-0.77556,0.24684,0.58102],[-0.49054,0.66293,0.56559],[-0.71946,-0.36051,-0.59364],[-0.62281,-0.78177,0.030773],[-0.95559,0.08363,0.28259],[-0.94013,-0.24947,0.23222],[-0.87555,0.48267,-0.020901],[0.92153,-0.019309,0.38784],[0.94425,-0.26888,-0.18998],[-0.81361,-0.18408,-0.5515],[0.67789,-0.072815,-0.73155],[-0.67892,-0.73305,0.041206],[-0.14096,-0.9896,-0.028512],[0.067274,0.35309,0.93317],[0.080392,-0.94883,0.3054],[0.20896,-0.97242,-0.10363],[0.16695,-0.96941,-0.17993],[-0.047444,-0.9071,-0.41823],[-0.25181,-0.77883,-0.57447],[0.17747,-0.92759,-0.32877],[0.20871,-0.82996,-0.5173],[0.64552,-0.75926,0.082572],[0.3143,-0.74588,-0.58727],[-0.96768,0.05577,0.24594],[-0.89064,0.25032,0.3796],[0.46037,-0.51687,-0.72173],[0.61704,0.44613,0.64825],[0.038029,-0.89622,-0.44197],[0.98506,-0.081323,0.15177],[0.57973,-0.081198,-0.81075],[0.98835,-0.11895,0.094967],[0.21732,-0.94132,-0.25824],[0.35355,-0.91848,-0.1772],[0.2241,-0.95698,0.1843],[-0.24871,-0.06483,0.96641],[-0.047188,-0.85269,0.52027],[-0.064536,-0.92206,0.38162],[0.51227,-0.85022,-0.12128],[-0.48966,-0.81298,-0.31511],[0.67387,0.052195,-0.737],[0.36068,-0.93157,-0.045598],[0.10893,-0.93502,0.33746],[0.94409,-0.2157,-0.24935],[0.22834,-0.90769,0.35209],[0.40133,-0.87357,0.27535],[-0.71609,-0.0063981,-0.69798],[-0.57129,0.18188,0.80034],[0.96409,-0.17304,-0.20145],[0.98488,-0.14149,0.099943],[0.40969,-0.91063,0.053921],[0.49443,0.76506,0.41258],[-0.51538,-0.84958,0.11227],[-0.6882,-0.71488,0.12383],[0.28142,0.64876,0.70705],[0.57701,0.20101,-0.79161],[0.71569,-0.62606,-0.30957],[-0.54583,-0.09637,-0.83233],[0.69989,-0.71417,-0.010178],[0.15167,-0.98654,0.061174],[-0.49989,-0.058854,-0.86408],[0.46807,0.28424,-0.83673],[0.39616,0.66684,0.63117],[0.58996,-0.80653,0.038111],[-0.90725,0.060049,0.41628],[-0.22664,-0.97359,0.027358],[0.9861,0.028082,0.16377],[0.65447,0.09933,0.74954],[-0.11461,-0.24286,-0.96327],[-0.37749,-0.064361,-0.92378],[0.22929,0.48584,-0.84344],[0.22173,0.49377,-0.84085],[0.94417,0.15009,-0.2933],[0.35233,0.58631,0.72945],[0.5657,-0.80135,0.19446],[-0.56776,-0.6327,0.52663],[0.5111,-0.097932,-0.85393],[-0.7926,0.53304,0.29607],[0.86293,0.43382,0.25913],[0.9623,0.087188,0.25763],[-0.44936,0.59407,0.6672],[0.997,0.055406,0.054092],[0.52108,0.35053,-0.77821],[-0.97219,0.20023,0.12145],[0.38114,0.0028424,0.92451],[-0.91395,-0.28749,0.28643],[0.55347,0.019095,-0.83265],[-0.91065,0.13536,0.39038],[0.56689,-0.26217,0.78096],[0.068686,0.31469,0.9467],[-0.74384,-0.1021,-0.66052],[0.95268,0.20307,0.22619],[-0.95563,0.29251,0.034758],[0.58325,-0.80873,-0.076062],[0.98613,0.13161,0.10111],[-0.58258,-0.29548,0.75716],[0.10567,0.35507,-0.92885],[-0.75223,0.032722,-0.65809],[0.93451,0.35545,0.018878],[0.33148,0.0068493,-0.94344],[0.99857,0.041314,0.033962],[0.9736,0.1693,0.15312],[0.78741,-0.61642,0.0044241],[-0.43302,-0.34328,0.83346],[-0.52533,-0.25098,0.81304],[0.55896,0.55639,0.61481],[0.56326,0.1736,-0.80784],[-0.88979,0.45272,0.057651],[0.37678,-0.11249,-0.91945],[0.8915,0.39969,0.21326],[-0.87387,0.28689,0.3925],[-0.63155,0.016618,-0.77515],[-0.76658,0.12674,-0.62952],[-0.57239,0.76378,0.29833],[0.92428,0.38119,-0.019951],[0.19619,-0.48434,-0.8526],[0.30996,-0.69775,-0.64581],[-0.85136,0.25825,-0.45661],[-0.62042,-0.13534,-0.7725],[0.39065,-0.69595,-0.60253],[-0.85494,0.12151,-0.5043],[0.82773,-0.56112,0.0017211],[0.42784,-0.37654,-0.82169],[-0.64271,-0.13016,0.75497],[0.54425,0.45352,-0.70577],[-0.66929,-0.23303,-0.70551],[0.4013,0.026342,-0.91557],[-0.96443,0.25378,-0.073893],[-0.59745,-0.10173,0.79543],[-0.59931,0.0082624,0.80047],[0.61098,0.76364,0.20871],[-0.12409,-0.99166,-0.034878],[0.38313,0.29407,-0.87564],[0.89927,-0.42882,0.086196],[-0.61366,0.0069738,0.78954],[0.53507,0.81887,0.20776],[0.56718,0.40705,-0.71598],[0.5395,0.40844,-0.73629],[-0.73373,0.67845,0.036576],[-0.1212,0.70988,0.69381],[0.62424,-0.047377,-0.7798],[0.70442,-0.62644,-0.33373],[-0.48249,0.11246,0.86865],[-0.75928,-0.071316,-0.64685],[0.42212,0.44618,0.78914],[0.94525,-0.11447,0.30562],[0.27126,0.43052,-0.86085],[-0.68309,0.41263,0.60259],[-0.27069,-0.011362,0.9626],[-0.036086,0.70394,0.70934],[0.68162,0.024848,-0.73128],[0.39455,0.36762,-0.84213],[0.28522,0.44623,-0.84825],[-0.72711,0.68651,-0.0031176],[-0.93709,0.34904,-0.0057256],[-0.0036265,-0.39708,-0.91778],[-0.93334,-0.33151,0.13774],[0.60426,0.45528,-0.65391],[0.59888,0.77921,0.18486],[-0.40584,-0.52425,-0.74863],[-0.0078006,0.69347,0.72044],[0.12396,-0.30252,-0.94505],[0.40528,-0.19803,-0.89249],[-0.95845,0.081461,0.27338],[-0.87964,0.13544,0.45594],[-0.46174,-0.55981,-0.68805],[0.67651,0.070591,-0.73304],[-0.23492,0.018905,0.97183],[0.51329,0.66909,-0.53745],[0.68975,0.045786,-0.7226],[-0.91485,0.16515,0.36847],[0.20341,0.92427,0.32302],[0.32138,0.75889,-0.56639],[-0.79097,0.14295,0.59493],[0.64483,0.73227,0.21906],[-0.12553,0.66704,0.73437],[0.33405,0.61676,0.71275],[0.027738,0.0778,0.99658],[0.99176,0.041604,-0.12117],[-0.19663,0.1229,0.97274],[0.8602,0.25208,0.4433],[-0.90484,0.41192,-0.10763],[-0.75444,0.54744,0.36212],[-0.12825,0.14284,0.9814],[0.34026,0.93157,-0.12809],[-0.23431,0.96871,0.081821],[0.11191,-0.3617,0.92555],[-0.46053,0.88479,0.071164],[0.7727,0.19598,-0.60376],[-0.80533,0.46667,0.36561],[0.44149,0.7639,-0.47069],[-0.72574,0.32339,-0.60723],[0.14686,0.66236,0.73465],[0.82165,0.34517,0.45359],[-0.54253,0.83977,-0.021019],[-0.79681,0.35172,0.49131],[0.17441,0.63841,0.74967],[0.37488,0.89953,0.22432],[0.8452,0.48377,-0.22717],[-0.8878,0.22635,0.40073],[-0.36821,0.3083,0.87714],[0.33915,0.74342,-0.57646],[-0.81504,-0.52813,-0.23831],[0.98384,0.041339,-0.1742],[-0.62397,0.5581,-0.54698],[0.77979,0.57502,0.24754],[-0.075068,0.94191,-0.32737],[-0.90908,-0.31924,0.2677],[0.31585,0.91751,-0.2417],[-0.026859,0.68644,0.72669],[-0.81859,-0.49391,-0.2932],[0.18001,0.91163,0.36951],[0.59236,-0.21255,0.77713],[0.017809,0.99249,0.12102],[-0.017294,0.99504,0.097923],[0.039255,0.96591,-0.25587],[0.17557,0.95456,-0.24079],[-0.41022,0.71782,-0.56254],[-0.44602,0.73888,-0.50511],[0.42847,-0.32371,-0.84358],[-0.1101,-0.66703,-0.73685],[0.62842,0.31663,-0.71052],[0.86818,0.49623,0.0046291],[0.32126,0.68595,0.65288],[0.15652,0.75563,0.63602],[-0.80832,0.53169,-0.25284],[-0.90113,0.4217,-0.10071],[-0.87339,0.48432,0.051194],[0.33868,0.43985,0.83176],[0.90424,0.29046,0.31302],[0.76416,-0.54801,-0.34022],[0.65976,-0.35623,0.66168],[-0.77167,0.61675,0.15537],[-0.16911,0.81048,0.56083],[-0.11028,0.71456,0.69083],[-0.10103,-0.48153,0.87058],[0.84921,-0.52191,0.080368],[0.3947,0.8755,0.27875],[-0.014086,-0.61558,0.78795],[0.4256,0.67438,0.60339],[-0.9645,0.19625,-0.17672],[-0.76435,0.50395,0.40224],[-0.0062262,0.75044,0.66091],[0.04836,0.58502,0.80957],[-0.75061,0.32732,-0.57397],[0.82542,0.44145,-0.35187],[0.81342,0.44257,0.37747],[-0.86857,0.46106,0.18169],[-0.114,-0.14153,0.98335],[0.022279,0.16312,0.98635],[-0.49788,0.66424,-0.55758],[-0.39427,0.63731,-0.66211],[0.97509,0.19535,0.10501],[0.73709,-0.56758,-0.36682],[0.77792,0.61153,-0.14447],[0.085126,-0.067077,0.99411],[-0.55127,0.64284,-0.53184],[-0.77477,0.59201,-0.22193],[0.023889,-0.63199,0.77461],[0.76691,0.57833,-0.27818],[-0.59661,0.68072,0.42506],[0.049668,-0.38377,0.92209],[-0.77105,0.59637,-0.22321],[-0.16225,0.20372,0.96549],[0.7525,0.50525,-0.42246],[-0.56295,0.59888,0.56958],[0.0053994,0.1025,0.99472],[-0.82014,0.5577,-0.12786],[-0.68701,0.54837,0.47677],[0.10541,0.15482,0.9823],[-0.9015,0.41735,-0.11453],[-0.51371,0.63368,0.5784],[0.72713,0.66608,-0.1662],[-0.96868,0.22732,-0.099922],[0.033501,-0.034309,0.99885],[0.71687,0.69375,-0.069354],[0.81497,-0.50293,0.2879],[0.48631,0.84969,0.20378],[0.93019,0.30424,0.2054],[-0.38939,-0.89832,-0.20348],[-0.45771,0.66098,0.59465],[-0.47435,0.7015,0.53188],[0.81906,0.52606,0.22892],[-0.84045,-0.4597,0.28692],[0.074722,0.02302,0.99694],[0.77906,0.50286,0.37442],[0.90839,0.37303,-0.18889],[-0.32348,0.61309,0.72075],[-0.17713,0.852,0.49266],[-0.037867,-0.037171,0.99859],[0.33376,0.65101,0.68176],[0.14898,0.77883,0.60928],[-0.68,-0.67965,-0.27509],[-0.29578,0.72137,0.62621],[-0.88824,0.40692,0.21316],[0.12597,0.7356,0.6656],[-0.38381,0.2368,0.89254],[0.33199,0.6161,0.71428],[-0.42767,0.15539,0.89048],[0.86144,0.50396,-0.062849],[-0.062304,0.76004,0.64689],[-0.80918,0.58642,0.036672],[-0.64522,0.75934,0.084189],[0.81742,0.55152,0.16627],[-0.8494,0.5113,0.13072],[0.51411,0.83953,0.17572],[0.54094,0.82522,0.16244],[-0.83082,0.49619,-0.25207],[0.16623,0.22786,0.9594],[0.91802,0.39402,-0.044664],[-0.29692,0.40311,0.86564],[-0.70257,0.68857,-0.17961],[-0.98564,-0.033142,-0.16556],[-0.51119,0.84,-0.18191],[-0.53554,0.84328,-0.045461],[0.92617,0.37204,0.06157],[-0.71526,0.55272,0.42767],[0.77397,0.63109,0.051955],[0.67486,0.73097,0.10121],[-0.72399,0.6797,0.11769],[-0.99287,-0.021753,-0.11719],[0.9986,0.049714,-0.01809],[0.4436,0.88855,0.11709],[0.79855,0.59731,0.074391],[-0.54738,0.83148,0.094986],[0.99218,-0.018179,0.12352],[-0.26334,-0.94617,-0.18819],[0.52506,0.84599,-0.092824],[-0.72558,0.66732,-0.16801],[-0.18274,-0.13604,0.9737],[-0.25281,0.45876,0.85183],[-0.45758,0.87625,-0.15104],[0.70337,0.62434,0.33981],[0.36361,0.93124,0.024046],[0.47167,0.88152,-0.021386],[0.15776,0.98733,0.017069],[0.34242,0.93951,0.0086982],[0.51039,0.85919,-0.036095],[-0.065027,0.090033,0.99381],[0.13498,0.053705,0.98939],[-0.079995,-0.97704,-0.19748],[-0.16384,0.98611,-0.027315],[-0.021394,0.99925,-0.032273],[-0.077668,-0.83504,-0.54467],[0.1312,-0.85758,-0.49733],[0.9038,0.045085,0.42558],[0.065736,0.29771,0.95239],[-0.22935,-0.7595,-0.60873],[-0.39495,-0.8894,-0.23016],[0.12076,-0.5499,0.82646],[0.069655,-0.74478,-0.66367],[0.69174,0.64588,0.32301],[0.82347,-0.12924,0.55245],[0.24276,-0.67023,-0.70133],[-0.98108,0.19237,-0.021688],[0.48197,-0.8112,-0.33114],[-0.37718,-0.85403,-0.35828],[0.40102,-0.55774,-0.72671],[0.78076,0.36984,0.50363],[-0.45956,-0.7023,-0.54368],[0.51336,-0.81423,-0.27109],[-0.97208,0.22875,-0.052275],[0.81554,-0.30425,0.49227],[0.18691,-0.507,0.84144],[-0.42893,-0.8598,-0.27706],[0.36891,-0.76201,-0.53221],[0.08104,0.20733,0.97491],[-0.55781,-0.65311,-0.51215],[-0.4224,-0.88809,-0.18132],[0.51087,-0.83847,-0.1897],[0.95085,-0.17659,0.25437],[-0.4967,-0.82168,-0.27952],[-0.11264,0.39977,0.90967],[0.67286,0.68205,0.28647],[-0.97979,0.17775,-0.091746],[-0.63511,-0.70228,-0.32161],[0.49376,-0.56431,-0.66163],[0.99154,0.057458,0.11637],[-0.13142,-0.24496,-0.96058],[-0.0083511,-0.3689,-0.92943],[0.12229,-0.32611,-0.93739],[-0.56664,-0.7121,-0.41452],[0.57394,-0.74541,-0.33905],[-0.32926,-0.32159,-0.88779],[-0.20312,-0.31953,-0.92555],[0.26843,-0.41818,-0.8678],[-0.46822,-0.87647,-0.11211],[-0.42474,-0.84095,-0.33526],[-0.98096,0.16873,-0.096172],[-0.14656,-0.97316,-0.17742],[0.17379,-0.55681,-0.81225],[-0.14702,-0.59179,-0.79257],[0.15448,-0.9589,-0.23799],[0.70428,0.69707,-0.13448],[0.97457,0.21345,-0.068189],[-0.83911,0.53017,-0.1217],[-0.094404,0.37263,0.92317],[-0.78086,-0.27487,-0.56098],[0.42636,-0.89859,-0.1037],[0.84424,-0.51137,0.16048],[-0.78478,0.34416,0.51544],[-0.60416,-0.65175,-0.45849],[-0.6156,0.6709,0.41344],[0.53872,0.79132,0.28913],[-0.71062,-0.43833,-0.55034],[0.63842,-0.76934,0.023228],[0.64722,-0.38805,-0.65615],[-0.77016,-0.3345,-0.5431],[0.18307,0.31162,0.93241],[0.23569,0.87531,0.42224],[-0.56771,-0.80671,-0.16412],[-0.8754,0.41747,0.24372],[0.90022,-0.43402,-0.035148],[0.15632,0.82047,0.5499],[-0.82823,-0.23545,-0.50852],[-0.58117,-0.8122,-0.050763],[0.7422,-0.13918,-0.65557],[0.84441,-0.53166,0.065623],[-0.15167,0.15369,0.97641],[0.76258,-0.073492,-0.6427],[0.80667,-0.58979,-0.037815],[0.062501,-0.99799,-0.010387],[-0.30572,-0.77035,-0.55955],[-0.047671,-0.88844,-0.45651],[-0.021414,0.19955,0.97965],[0.19028,-0.91241,-0.36234],[0.45043,-0.8008,-0.39474],[0.23149,0.59339,0.77091],[-0.29434,0.75431,0.58683],[0.0023359,-0.99865,-0.051859],[-0.20149,-0.97919,0.024394],[0.85662,-0.46107,0.23154],[-0.31306,-0.83442,-0.45359],[0.047426,-0.90143,-0.43031],[0.17395,-0.79316,-0.58364],[0.91934,0.37975,-0.10297],[-0.3359,-0.67573,-0.65617],[-0.066242,-0.86824,-0.4917],[0.206,-0.94053,-0.27011],[0.54317,0.83959,-0.0073709],[-0.68462,0.66598,0.29625],[-0.81988,-0.085947,-0.56605],[-0.47891,-0.48945,-0.72876],[0.39203,-0.84584,-0.36174],[-0.73492,0.66493,0.13332],[0.46178,0.88332,0.080646],[0.58051,-0.074184,-0.81087],[-0.53509,0.84437,0.027038],[0.46897,-0.87449,-0.12383],[0.1063,-0.91626,0.38623],[-0.80893,-0.55333,0.19864],[-0.14664,-0.86111,0.48681],[0.24471,-0.95898,0.14309],[0.53403,-0.84498,-0.028732],[-0.67831,-0.72764,-0.10216],[-0.21831,-0.31605,0.92328],[0.48838,-0.38268,-0.78424],[0.56533,0.12239,0.81574],[-0.98566,-0.1014,-0.13487],[-0.77333,-0.57075,0.27605],[0.63236,-0.76385,0.12906],[0.37916,-0.86203,0.33636],[-0.45375,0.88449,0.10858],[0.096774,-0.86161,0.49825],[0.9723,0.20958,-0.10347],[-0.48635,-0.33448,-0.80721],[-0.99813,0.04441,-0.042108],[0.2003,-0.81817,0.53896],[0.42353,-0.79394,0.43621],[-0.78178,-0.60606,0.14667],[-0.5465,-0.83508,0.063098],[-0.98172,0.16441,0.095917],[0.43964,-0.51902,-0.73303],[-0.5051,-0.21035,-0.83703],[-0.54287,0.69603,0.46993],[0.53001,-0.80853,0.25565],[0.55227,0.49543,0.67048],[-0.69209,-0.70172,0.16914],[0.41141,-0.91145,0.00041197],[0.54672,0.53822,0.64142],[0.69148,0.1319,-0.71026],[-0.80996,-0.56969,0.13936],[-0.74157,-0.63133,0.22693],[0.55543,-0.82836,-0.072853],[0.45554,-0.4653,-0.75894],[-0.49922,-0.19183,-0.84497],[0.74563,-0.32851,0.57976],[-0.048575,0.068297,0.99648],[0.48855,-0.27692,-0.82743],[0.99043,0.080894,0.1118],[-0.7295,-0.63294,0.25928],[-0.45682,-0.88954,0.0062668],[-0.41153,-0.41532,-0.81127],[0.96349,0.23863,-0.12143],[-0.57707,-0.046719,-0.81536],[-0.78937,-0.52264,0.32208],[-0.96636,0.25042,-0.058536],[-0.61609,-0.28985,-0.73241],[0.44875,0.36697,-0.81484],[-0.76892,-0.49506,0.40457],[0.32077,-0.90727,-0.27198],[0.29109,0.5139,-0.80695],[0.21806,0.58443,-0.78159],[-0.69244,-0.72135,0.013278],[-0.63428,-0.077324,-0.76923],[0.37562,-0.92501,0.057166],[-0.13837,0.40654,0.90309],[0.55423,0.039772,-0.83141],[0.95144,0.26295,0.16008],[0.25432,0.68547,0.68224],[0.52426,-0.84592,-0.09784],[-0.44461,-0.62512,0.64152],[-0.56437,-0.47502,0.67516],[0.53644,0.096792,-0.83837],[-0.67951,-0.14011,-0.72016],[0.5987,0.29427,-0.74496],[0.995,-0.031505,0.094826],[0.42264,0.77449,0.47068],[-0.55316,-0.34562,0.758],[-0.82922,0.31245,0.46343],[-0.60892,-0.081673,-0.78902],[0.4922,0.67879,0.54497],[-0.065152,-0.3673,0.92782],[0.57774,0.17985,-0.79616],[0.043966,-0.97847,0.20167],[-0.80084,0.40734,0.43902],[-0.37409,0.80401,0.4622],[-0.44483,0.13679,0.88511],[0.31116,0.37271,-0.87422],[-0.76308,0.11415,-0.63614],[0.765,-0.63223,0.1227],[-0.64849,-0.76116,-0.010189],[0.1173,0.047109,-0.99198],[0.17778,0.15131,-0.97237],[0.87362,-0.36449,0.32238],[0.3435,-0.29966,-0.89006],[0.61865,-0.20235,0.75916],[0.3958,0.10006,-0.91287],[-0.29013,0.84354,0.45196],[-0.40915,-0.32709,0.85183],[-0.38309,-0.29068,0.87678],[0.54844,0.31074,-0.77631],[0.42352,-0.60132,-0.67753],[0.32745,0.88794,0.32303],[-0.71658,0.16322,-0.67814],[0.80726,-0.57777,0.12047],[-0.078415,0.87877,0.47076],[0.20949,-0.17265,0.96245],[-0.48393,-0.046803,-0.87385],[0.20428,0.67712,0.70695],[-0.13864,0.86159,0.4883],[-0.9506,0.29759,0.08837],[-0.36593,-0.17607,0.91383],[0.87862,0.33554,0.33977],[0.37167,-0.41252,-0.83168],[0.59853,-0.60019,0.5306],[0.16841,-0.97283,-0.15888],[0.61646,-0.63856,0.46067],[0.79029,-0.27482,0.54764],[-0.54812,-0.024157,-0.83605],[-0.82331,0.2422,-0.51333],[0.68098,-0.62257,0.38557],[0.34363,0.26671,-0.90044],[-0.13028,-0.9803,0.14848],[-0.67952,0.52158,0.51594],[-0.90852,0.24626,-0.33756],[-0.53243,0.16079,0.83106],[0.5203,-0.10403,-0.84763],[0.35853,0.34209,-0.86858],[-0.66592,0.45501,0.5912],[0.51707,-0.3793,-0.76731],[-0.019219,-0.04059,0.99899],[-0.27458,-0.48404,-0.83085],[0.39091,0.094593,0.91556],[0.13376,-0.2981,-0.94512],[0.21751,-0.25204,-0.94296],[-0.98656,0.16303,-0.010993],[0.90232,-0.37038,0.22053],[-0.38759,-0.92175,0.011966],[-0.35114,0.84904,0.39476],[-0.43408,0.82297,0.36647],[0.36923,-0.22195,-0.90244],[0.51732,-0.05377,-0.8541],[0.58784,-0.57778,0.56623],[-0.54365,0.075081,0.83595],[-0.15945,-0.12727,0.97897],[0.59104,0.08281,-0.80238],[0.75261,0.40522,0.51901],[0.29866,0.37587,-0.87723],[-0.42466,0.65654,0.62339],[-0.44097,-0.45269,-0.775],[0.024377,0.20552,0.97835],[0.46154,-0.5971,0.65609],[-0.44944,-0.49316,-0.74485],[0.73402,0.09589,-0.67233],[-0.40452,0.11573,0.90718],[-0.82118,0.10111,-0.56164],[0.49396,-0.83081,0.25644],[-0.58888,0.58322,0.55953],[-0.94659,0.12755,0.29612],[0.030155,-0.46726,0.8836],[-0.57633,0.17819,0.79756],[0.26385,0.88925,0.37366],[0.53783,0.61023,-0.58168],[0.55506,0.13208,-0.82126],[0.063227,-0.37872,0.92335],[-0.50979,-0.55422,-0.65799],[0.92653,-0.26044,0.2715],[0.83492,-0.48221,0.2653],[-0.85181,0.14235,-0.50414],[0.78641,0.20234,-0.58362],[0.82648,0.21362,-0.52086],[-0.91241,0.27099,0.3067],[-0.48844,0.25299,0.83512],[0.50483,0.54438,0.66993],[0.47741,0.73073,-0.48797],[-0.48813,-0.58276,-0.6497],[-0.85392,0.51461,0.07744],[0.18777,0.91838,-0.34831],[0.89289,0.44815,-0.04376],[0.60001,-0.073119,-0.79665],[0.36422,0.55619,0.74699],[-0.30243,0.19599,0.93281],[0.4095,-0.42912,0.80508],[-0.92721,-0.25241,0.2767],[-0.0053981,0.94069,0.33922],[0.2797,0.93991,-0.19582],[-0.19414,0.73139,0.65374],[0.050787,0.93689,0.34592],[0.8571,0.18742,-0.47984],[-0.91042,0.3952,0.12226],[0.91964,0.28086,0.27455],[-0.45911,0.30366,0.83487],[0.86814,0.0027493,0.49631],[0.50512,0.65893,-0.55738],[-0.74587,0.47141,-0.4706],[0.46811,-0.014088,-0.88356],[0.2719,0.26944,0.92383],[0.1013,0.93694,0.33449],[-0.34284,-0.58419,-0.73565],[-0.95265,0.15224,0.2632],[0.91858,0.35165,0.18042],[0.73607,0.48311,0.47415],[0.33423,0.77323,-0.53889],[0.4866,-0.093393,-0.86862],[0.12622,-0.39415,-0.91034],[-0.07242,-0.49703,-0.86471],[0.63714,0.52133,0.56768],[-0.36152,0.46004,0.81097],[0.1996,0.93175,-0.30333],[0.74717,0.24709,-0.617],[-0.9755,0.13212,0.17593],[0.76867,-0.30303,0.56332],[0.07734,0.86303,0.4992],[0.21608,-0.42613,0.87848],[-0.14152,0.98223,-0.12326],[0.22382,0.96833,-0.11062],[-0.15869,-0.96614,-0.20343],[-0.29226,0.62933,0.72009],[0.23704,0.60378,0.76109],[0.74515,0.65838,-0.10624],[-0.94395,-0.23222,0.23458],[-0.54642,0.68708,-0.4789],[0.68011,0.46786,-0.56441],[-0.096785,0.74764,0.65701],[-0.0025465,0.57367,0.81908],[-0.84992,0.26894,-0.45312],[0.69489,0.55398,-0.45851],[0.78689,0.60099,0.14005],[-0.98127,-0.11286,0.1561],[0.26291,0.12792,0.9563],[-0.74212,0.55484,0.37604],[0.75829,0.63415,-0.15116],[0.7535,0.63982,-0.15126],[-0.15987,-0.97486,-0.15521],[-0.69518,-0.6875,0.20993],[-0.46965,0.69111,-0.54936],[0.14162,-0.96958,0.19963],[0.7987,0.58731,-0.13095],[-0.9772,-0.14089,0.15886],[-0.49549,-0.59567,0.63219],[0.79126,0.57988,-0.19401],[0.8713,0.47178,0.13513],[-0.67762,0.73134,-0.077368],[0.56181,-0.76709,-0.30973],[-0.49716,0.81518,0.29717],[-0.12067,-0.98939,0.080957],[0.067079,-0.95009,-0.30469],[-0.93301,0.35298,-0.069962],[-0.57272,0.61283,0.54445],[0.46932,0.050825,0.88156],[-0.1667,-0.95183,-0.25737],[-0.34982,0.11671,0.92952],[0.47612,-0.86313,0.16829],[0.90891,0.38188,-0.16748],[-0.36652,0.73655,0.56847],[-0.60496,-0.79003,-0.099337],[-0.16069,-0.98666,-0.025959],[0.13429,0.80534,0.57741],[0.15137,0.89154,0.42691],[0.21441,0.56826,0.79443],[-0.83794,0.54467,0.034443],[-0.054661,0.77465,0.63002],[0.0046383,0.82923,0.55888],[0.36947,0.025701,0.92889],[-0.19557,0.86776,0.45688],[0.11923,0.68351,0.72014],[0.069248,0.70353,0.70729],[0.40696,-0.89999,-0.15617],[-0.86664,-0.29312,0.40375],[-0.049115,0.67987,0.73169],[0.23292,0.56577,0.79098],[0.54701,-0.039985,0.83617],[-0.80408,-0.55716,0.20744],[0.75202,0.65473,0.076069],[-0.57675,0.80968,0.10855],[-0.80453,-0.2883,0.51925],[0.73482,0.67722,0.037527],[-0.84311,0.53731,-0.021634],[-0.899,0.34952,-0.26388],[0.80828,0.57777,0.1134],[-0.14879,-0.97687,-0.15355],[0.94643,0.22326,-0.23331],[-0.79668,0.55924,-0.22924],[0.92235,0.28969,-0.25565],[-0.049153,0.64574,0.76197],[0.88761,0.44113,-0.13248],[-0.85102,0.52194,0.057778],[-0.78929,-0.058613,0.61121],[0.62802,0.76425,0.14669],[0.78494,0.61532,0.072448],[-0.41804,0.89619,-0.14864],[0.84311,0.52873,-0.098],[-0.70797,0.64021,-0.29816],[-0.59505,0.76072,-0.25927],[-0.89924,0.36838,-0.23592],[0.70984,0.70389,-0.025796],[0.58937,0.80446,-0.074058],[0.40082,0.0028687,0.91615],[0.70639,0.70723,-0.029136],[0.58146,0.81017,0.074342],[-0.60323,0.76899,-0.21158],[-0.47364,0.85183,-0.22371],[-0.57636,0.81456,-0.065624],[-0.3314,0.94259,-0.041156],[-0.30439,-0.53909,0.78532],[0.31746,0.9412,-0.11555],[-0.10713,0.47942,-0.87103],[-0.59388,0.48339,-0.64316],[-0.28564,0.6612,-0.6937],[0.67422,-0.63813,0.37178],[0.42125,0.20439,0.88361],[0.26538,-0.96214,-0.06213],[-0.081037,-0.52451,0.84754],[-0.32576,-0.78712,-0.52376],[0.39788,-0.86372,-0.30933],[-0.10288,-0.10735,-0.98888],[0.062443,-0.079802,-0.99485],[-0.23941,-0.84728,-0.47414],[-0.13661,-0.83833,-0.52777],[-0.0067729,-0.99977,-0.02026],[0.73565,-0.44744,0.50854],[-0.42751,-0.70496,-0.56593],[0.42015,-0.61177,-0.67023],[0.23966,0.32132,0.91614],[-0.25874,-0.10564,-0.96015],[0.70199,0.12076,0.70187],[0.029224,-0.15087,-0.98812],[0.26555,-0.1425,-0.95351],[0.9241,-0.37542,0.071389],[0.86084,-0.47624,0.1793],[0.059968,-0.093772,0.99379],[0.31659,0.41635,0.85231],[-0.66986,-0.50623,-0.54316],[-0.46031,0.84358,-0.27656],[0.5,-0.83303,-0.23678],[0.63395,0.73945,-0.22655],[-0.36398,-0.19969,-0.90975],[0.99196,-0.12569,0.014626],[0.5135,-0.82552,-0.23415],[-0.70716,0.6015,-0.37164],[-0.15972,0.65007,0.7429],[0.41268,-0.21438,-0.88529],[-0.45393,-0.72591,-0.51673],[0.59969,-0.48835,-0.63395],[-0.73865,-0.43539,-0.51463],[-0.68194,-0.15623,0.71452],[0.97654,0.099619,0.19091],[-0.06276,0.17845,0.98195],[-0.41999,-0.27661,-0.86435],[0.09313,0.67555,0.73141],[0.091491,-0.5761,-0.81224],[-0.31992,-0.68151,-0.65818],[0.10824,0.63042,0.76867],[0.38836,0.54094,0.74603],[-0.06562,-0.49608,-0.8658],[0.75105,-0.26692,0.60388],[0.2435,-0.49112,0.83637],[-0.56224,-0.67875,-0.47242],[-0.98786,0.023901,0.15353],[-0.68227,-0.52532,-0.50847],[0.66856,-0.40459,-0.62397],[-0.74128,-0.64973,0.1684],[-0.016445,0.0073943,0.99984],[-0.83789,-0.2088,0.50433],[-0.55727,-0.70906,-0.43207],[0.53549,0.61814,0.57546],[-0.92346,-0.067316,-0.37774],[0.5954,0.71743,0.36166],[0.97102,0.23838,0.017009],[0.73592,0.58233,-0.34543],[-0.079376,0.010177,0.99679],[-0.059804,0.13831,0.98858],[0.69141,-0.33842,-0.6383],[0.079982,-0.019235,0.99661],[0.70005,-0.24257,-0.67163],[-0.79923,-0.31625,-0.51109],[-0.40399,-0.51555,0.75564],[-0.051023,0.43022,0.90128],[0.16983,-0.89236,-0.41816],[-0.89286,-0.31995,-0.31691],[0.83894,-0.086255,-0.53735],[-0.14939,-0.98862,0.017928],[0.028975,-0.98981,0.13942],[0.060153,-0.99462,0.084362],[0.10303,-0.99343,0.04991],[-0.32388,-0.8214,-0.46947],[0.019197,-0.88022,-0.47418],[0.6677,0.22989,0.70805],[0.26838,-0.86684,-0.42019],[0.68653,0.26654,0.67649],[0.86306,-0.1047,-0.49413],[-0.62271,-0.63362,-0.45908],[-0.94014,0.023653,-0.33996],[0.80874,-0.5538,0.19811],[0.0050656,-0.94805,-0.31808],[-0.041629,-0.98281,-0.17988],[0.81515,-0.056519,0.57648],[0.31967,-0.76125,-0.56418],[-0.66375,0.06796,0.74486],[-0.31484,-0.49459,0.8101],[-0.83897,-0.33854,-0.42605],[-0.07076,-0.83794,-0.54116],[0.98453,0.096993,0.14593],[-0.2954,0.069409,0.95285],[0.04836,-0.92503,-0.37679],[0.13155,-0.94109,-0.31152],[0.86669,-0.49723,0.040255],[-0.9112,0.16137,-0.37904],[-0.73491,-0.40971,-0.5404],[0.49711,-0.51351,-0.69942],[-0.15976,-0.67507,-0.72025],[0.31161,-0.94317,-0.11543],[-0.04154,0.14086,0.98916],[0.60686,-0.08874,-0.78984],[0.68827,0.4299,0.58435],[-0.32692,0.83617,-0.44039],[-0.73046,-0.50088,-0.46426],[-0.32524,0.83344,-0.44676],[0.60507,-0.088918,-0.79119],[0.77155,0.044185,-0.63463],[0.094419,-0.40291,0.91036],[0.43787,-0.89363,-0.098508],[0.34727,-0.93619,0.054232],[-0.89923,-0.075204,-0.43096],[-0.083677,-0.96186,0.26044],[0.95733,0.24197,0.15801],[-0.5287,-0.80632,-0.26518],[-0.94041,0.2797,-0.19337],[0.040397,0.10781,0.99335],[-0.37672,-0.39814,-0.8364],[-0.22921,-0.88988,0.39443],[-0.55612,-0.82954,-0.050902],[0.44695,-0.51623,-0.73058],[0.45297,-0.83948,0.30015],[0.75707,0.43452,0.48789],[-0.77568,-0.12634,-0.61835],[0.51909,0.64992,0.55511],[-0.86778,0.47846,-0.13432],[0.27076,-0.82559,0.49506],[0.17489,-0.27615,0.94507],[0.42354,-0.56126,-0.71106],[-0.63061,-0.21245,-0.74645],[0.18461,-0.8157,0.54822],[0.28364,-0.90387,0.32026],[0.60827,-0.31998,0.72637],[-0.19415,-0.20017,0.96033],[-0.82209,0.55759,0.11517],[0.81168,-0.070423,0.57985],[-0.45346,-0.43443,0.77823],[0.43173,-0.36719,-0.82388],[-0.55802,0.15026,0.81611],[-0.44879,0.84863,0.28002],[-0.46931,-0.11401,-0.87564],[0.6865,-0.72402,-0.067113],[0.18748,0.20605,0.96041],[0.48049,-0.28449,-0.82957],[-0.50421,-0.27262,-0.81942],[-0.92856,0.34611,0.13413],[0.18667,0.92904,-0.31943],[0.28364,0.92119,-0.26637],[0.69931,-0.70507,0.11763],[0.751,-0.37461,0.54374],[-0.95123,0.19207,-0.24139],[-0.97905,0.075184,0.18922],[0.58409,0.22656,-0.77943],[-0.50894,0.02124,-0.86054],[0.35786,-0.48225,0.79961],[0.52219,-0.11324,-0.84528],[-0.4853,0.71408,-0.50455],[0.43633,-0.047909,-0.89851],[0.47179,0.35029,-0.80915],[-0.78867,-0.55549,0.26349],[-0.95584,0.20707,-0.20853],[0.49093,0.67548,-0.5502],[-0.57166,-0.19401,-0.79723],[0.20507,0.58731,-0.78295],[-0.60361,0.10103,-0.79085],[-0.93275,0.19416,0.30378],[-0.50339,-0.14363,-0.85204],[0.24899,0.60237,-0.75839],[0.94303,0.33047,0.038605],[-0.59078,0.11143,0.7991],[0.88534,0.45614,-0.090063],[0.65648,-0.7452,0.11708],[0.91975,-0.38571,0.072679],[0.20517,-0.053763,0.97725],[-0.6037,-0.24262,0.7594],[0.61403,0.25607,-0.74659],[-0.73982,0.076229,-0.66847],[0.68838,-0.7077,0.15904],[-0.87563,0.40151,0.26846],[-0.40691,-0.0847,-0.90953],[0.52646,0.28275,-0.8018],[0.9038,0.39369,-0.16778],[-0.75877,0.50286,-0.41402],[-0.71102,0.13196,-0.69068],[-0.55823,-0.21726,0.80074],[0.86207,-0.014272,0.50658],[0.55233,-0.070874,-0.83061],[0.62699,0.68524,-0.37058],[-0.43227,-0.023627,-0.90143],[0.46809,-0.53137,-0.70608],[-0.57865,0.60498,0.54695],[0.52139,0.38781,-0.7601],[0.29162,-0.77981,-0.55394],[0.84515,0.12309,0.52016],[0.48946,-0.51865,0.70102],[-0.41361,-0.14466,0.89889],[0.23938,-0.73421,-0.63532],[0.8538,-0.48278,0.19481],[-0.63924,0.18549,0.7463],[0.36216,-0.014167,-0.93201],[0.88794,0.45879,-0.032701],[0.67287,0.6472,0.35829],[-0.32806,0.045016,0.94359],[-0.41633,-0.028772,0.90876],[0.29017,0.20858,-0.93397],[-0.21528,-0.43164,-0.87598],[-0.036255,-0.48339,-0.87466],[0.88061,-0.36905,0.29721],[0.47032,0.19682,-0.86027],[-0.7135,-0.089303,-0.69495],[0.97629,-0.20012,-0.082471],[0.42058,-0.27265,-0.86532],[-0.6043,-0.58894,-0.53663],[-0.688,0.30552,-0.65827],[-0.42787,0.032536,0.90325],[-0.29745,0.085098,0.95094],[-0.35553,-0.44573,-0.82154],[-0.43432,0.61195,0.66097],[0.65493,-0.034247,-0.75491],[-0.4832,0.10502,0.86919],[-0.71387,0.53558,0.45116],[0.48024,-0.33316,-0.8114],[0.25222,0.24594,-0.9359],[-0.85693,0.47309,-0.20458],[0.44728,0.77446,0.44739],[0.5791,-0.16994,-0.79735],[-0.71401,0.026416,-0.69963],[-0.9385,0.28232,0.19876],[0.85842,0.48284,0.17318],[0.67739,0.18613,-0.71168],[-0.76431,0.11191,-0.63507],[0.54059,0.73148,0.41556],[0.82757,0.187,-0.52929],[-0.50433,0.020634,0.86327],[0.56482,0.36458,-0.74031],[-0.39837,-0.35656,0.84508],[-0.85653,0.39679,-0.33001],[-0.3165,0.65071,0.69022],[0.83037,0.52521,-0.18609],[0.1892,0.38711,-0.90241],[-0.69996,0.7096,-0.080724],[-0.3888,-0.43296,-0.81326],[-0.66922,0.52162,0.52921],[-0.51719,-0.85112,0.090031],[-0.46561,0.24089,0.85157],[0.30541,0.47654,-0.8244],[0.16848,0.24692,-0.95428],[0.84543,0.38015,-0.37514],[0.81278,0.19161,-0.55016],[0.47606,0.71558,-0.51119],[0.36975,0.18283,-0.91096],[-0.33231,0.51514,0.79006],[0.67532,0.2539,0.69244],[-0.68381,0.48738,0.54302],[-0.90748,0.40546,0.10994],[0.84873,-0.33097,0.41244],[0.4788,-0.099178,-0.87231],[-0.32023,-0.39966,-0.85891],[-0.35059,-0.015421,0.9364],[0.91334,0.23003,-0.33601],[0.27169,0.89463,-0.35472],[-0.69954,0.63221,0.33308],[-0.65923,0.6382,0.39764],[-0.21439,-0.4259,-0.87901],[0.77915,0.23253,-0.58211],[-0.089905,-0.20577,0.97446],[0.50509,0.69491,-0.51185],[0.22503,0.90684,-0.35637],[0.31653,-0.26325,-0.91132],[0.12044,-0.35442,-0.9273],[-0.30764,-0.95101,0.030559],[-0.91603,0.4004,0.02391],[-0.85023,0.47667,0.22337],[0.86713,-0.050603,0.4955],[-0.3858,0.31547,0.86697],[0.74977,0.60951,0.25758],[-0.94368,0.31941,0.086259],[-0.26018,-0.10278,0.96007],[-0.73163,0.48918,-0.47479],[-0.34476,0.014958,0.93857],[0.85963,0.20571,-0.46767],[-0.32275,0.48468,0.81297],[0.63599,-0.21432,0.74134],[-0.52771,-0.44295,0.72479],[0.40931,0.54183,0.73408],[0.21961,0.85025,0.47839],[-0.11694,0.99039,0.073844],[-0.61666,0.64846,-0.44636],[-0.62382,0.75939,-0.18488],[-0.071407,-0.99634,-0.046964],[0.14151,0.78258,0.60625],[-0.11605,0.99074,-0.070452],[0.16201,0.97021,-0.18011],[-0.23766,-0.0006985,0.97135],[0.83092,0.45523,-0.31991],[-0.66167,0.69919,0.27079],[-0.090242,0.59672,0.79736],[0.0046613,0.58915,0.80801],[-0.68089,0.17282,0.71171],[-0.36261,0.69976,-0.61551],[-0.16655,-0.044393,0.98503],[0.74171,0.66276,-0.10301],[-0.84743,0.46937,0.24812],[0.050583,0.095146,0.99418],[0.66402,0.61451,-0.42597],[-0.063595,-0.12542,0.99006],[-0.71943,0.3422,-0.60442],[0.91274,-0.21931,0.34468],[0.67033,0.64181,-0.37247],[-0.50241,-0.14144,0.85298],[-0.66003,0.68339,0.31199],[-0.60015,0.61922,-0.50635],[0.44613,0.86381,-0.23409],[-0.59766,0.60606,0.52488],[-0.52765,0.7042,-0.47506],[0.78765,0.61024,-0.084994],[-0.62808,0.5972,0.49887],[-0.7917,-0.16352,0.58862],[-0.70089,0.59518,0.39309],[0.86453,0.48464,-0.13309],[-0.56071,0.76357,0.32026],[-0.77661,0.49253,-0.3928],[0.86122,-0.33016,0.38638],[-0.48016,0.72679,-0.49114],[-0.25734,0.035812,0.96566],[-0.69995,0.68068,-0.21622],[0.95662,-0.27172,0.10507],[0.67116,0.036066,0.74044],[-0.57764,0.61754,0.53383],[0.79031,0.60091,0.11963],[0.42973,0.16524,0.88771],[0.64846,0.39967,0.64789],[0.70524,0.70897,0.0019095],[-0.57318,0.53843,0.61771],[-0.53488,0.52324,0.66342],[-0.86665,0.49092,-0.088908],[0.6518,0.74459,-0.144],[0.86168,0.43624,-0.25923],[-0.48354,0.6246,0.61324],[0.17088,0.70419,0.68914],[-0.87842,0.209,-0.42976],[0.50607,0.81953,-0.26882],[0.0067771,0.86683,0.49856],[0.26073,0.88949,0.37528],[0.32336,0.49449,0.8068],[-0.61349,0.78876,0.038681],[0.074649,0.71295,0.69723],[-0.15719,-0.53624,0.8293],[0.91139,0.40598,-0.067383],[0.68285,0.72362,-0.10045],[-0.19401,0.84061,0.5057],[-0.069522,0.82016,0.5679],[-0.95449,-0.29221,0.059607],[0.10984,0.62686,0.77135],[-0.18312,-0.065954,0.98088],[-0.066652,-0.031656,0.99727],[-0.76748,0.6325,-0.10451],[0.84504,0.53296,0.043208],[0.35503,0.15596,0.92175],[-0.63262,0.765,0.12071],[-0.88477,0.46422,0.040947],[0.78435,0.60303,0.14543],[-0.9186,0.27342,0.28533],[-0.9849,-0.17239,-0.016164],[0.96588,0.17296,-0.19279],[0.64566,0.74109,0.18417],[-0.83029,0.46071,-0.31364],[0.91908,0.33881,-0.20126],[0.86569,0.49262,-0.088958],[0.80933,0.58732,-0.006727],[0.51619,-0.053136,0.85483],[-0.44242,0.89651,-0.02311],[-0.50525,0.86284,-0.015334],[0.69418,0.69504,0.18717],[-0.76427,0.64442,0.024757],[-0.7904,0.36514,0.49188],[0.59565,0.77288,0.21877],[-0.71238,0.68793,-0.1388],[-0.011782,0.007875,0.9999],[0.73757,0.66891,-0.092428],[0.091492,0.23547,0.96757],[-0.89356,-0.44808,-0.027904],[-0.55449,0.76916,-0.3177],[-0.6741,0.64805,-0.35444],[0.86538,0.48851,-0.1117],[0.29355,-0.11542,0.94895],[-0.68485,0.53834,0.4911],[-0.83343,0.51604,-0.19773],[0.73632,0.4375,0.51617],[-0.68081,0.686,-0.2567],[-0.67635,0.71595,-0.17312],[0.63121,0.77194,0.075401],[0.073635,0.3491,0.93419],[-0.44954,0.019322,0.89305],[0.48808,0.87279,0.0022832],[-0.84388,-0.53197,0.069832],[0.23419,0.96822,-0.087722],[0.21124,0.97734,0.013327],[0.59497,0.23242,0.76941],[-0.66661,0.44377,0.59891],[0.3795,0.92054,-0.09264],[0.22372,0.96195,-0.15683],[-0.2539,-0.57589,-0.7771],[-0.82242,-0.56399,0.074454],[0.41282,-0.40432,0.81615],[-0.10872,0.08869,-0.99011],[0.54556,-0.41687,0.72704],[0.60585,0.023766,-0.79522],[0.88539,-0.25695,0.38738],[-0.18499,0.47047,-0.8628],[0.26558,0.29661,-0.91733],[-0.021708,-0.13402,-0.99074],[0.92989,0.19516,-0.3118],[0.56117,0.82045,0.10929],[-0.9859,0.15385,-0.06579],[-0.11271,-0.044819,-0.99262],[-0.0066773,-0.092093,-0.99573],[0.026156,-0.18036,-0.98325],[0.060202,-0.15479,-0.98611],[0.18935,-0.17808,-0.96563],[0.93542,0.030597,-0.35221],[-0.075627,-0.0475,-0.996],[0.031825,-0.11468,-0.99289],[-0.27472,0.065541,0.95929],[-0.29259,0.00033713,-0.95624],[-0.084581,-0.092317,-0.99213],[0.07587,-0.087195,-0.9933],[0.2773,-0.080953,0.95737],[0.30516,-0.078601,-0.94905],[-0.17705,-0.048861,-0.98299],[0.0054783,-0.11707,-0.99311],[0.42087,0.075345,-0.90399],[0.11015,-0.020998,-0.99369],[-0.22575,-0.84944,-0.47696],[-0.88244,-0.4676,0.051361],[0.23908,-0.89239,-0.38272],[-0.34393,0.026104,-0.93863],[0.2178,0.026478,-0.97563],[0.93049,-0.073658,-0.35884],[-0.351,-0.15007,0.92427],[-0.62267,0.23289,0.74703],[0.0023891,-0.8123,-0.58324],[0.18148,-0.74914,-0.63707],[0.23704,-0.17446,0.95571],[0.42012,-0.17219,0.89098],[0.51462,-0.83523,-0.19378],[0.031363,-0.59448,0.8035],[-0.48032,-0.42163,0.76911],[0.52065,-0.83744,-0.1662],[-0.33253,-0.48605,0.80819],[0.057424,-0.60806,0.79181],[0.21733,-0.0053513,-0.97608],[0.65434,0.74589,0.12441],[-0.35313,-0.84499,-0.40162],[0.51919,-0.82237,-0.23272],[-0.36746,-0.045378,-0.92893],[0.33455,0.037284,-0.94164],[-0.39644,-0.81249,-0.42743],[-0.064434,0.187,0.98025],[0.49337,-0.79719,-0.34796],[-0.98954,0.020029,-0.14289],[0.27478,-0.28849,-0.91721],[-0.37541,-0.44457,0.81328],[-0.21867,-0.71782,-0.661],[-0.18783,0.92555,0.32876],[-0.20978,0.86643,0.45309],[0.27178,-0.72767,-0.62979],[-0.42323,0.86271,0.27679],[-0.34613,-0.25753,-0.90215],[-0.71147,0.40914,0.57132],[-0.091228,-0.5002,-0.86109],[0.59513,-0.53103,-0.60317],[0.19034,-0.68608,-0.70219],[0.53793,0.066109,0.84039],[0.16005,-0.65235,-0.74082],[-0.58783,-0.70861,-0.3903],[0.47503,0.84862,0.23279],[0.33332,0.016713,0.94267],[-0.7223,0.6759,0.14643],[0.63049,-0.48718,-0.60427],[0.89905,-0.17986,0.3992],[-0.97766,0.083,-0.19312],[-0.77779,-0.36801,-0.50952],[0.70753,-0.37534,-0.59876],[0.61406,-0.55915,-0.55703],[-0.13705,-0.165,0.97672],[0.46045,0.092697,0.88283],[0.5887,-0.59462,-0.5476],[-0.77063,-0.36072,-0.52537],[0.30648,0.8991,0.31255],[-0.94865,-0.31605,-0.013259],[0.40725,-0.065256,0.91098],[0.75629,0.18493,0.62756],[-0.99105,0.12922,0.033636],[-0.58598,0.30534,0.7506],[0.76707,-0.29963,-0.5673],[0.79856,-0.19126,-0.57072],[-0.10817,-0.9581,-0.26523],[0.055362,-0.95157,-0.3024],[0.179,-0.904,-0.38826],[-0.46746,-0.14173,0.87258],[0.81521,-0.53734,-0.21611],[-0.39808,-0.73891,-0.54364],[0.41197,-0.090012,0.90674],[0.96819,-0.12516,0.21666],[0.074387,-0.97846,0.19259],[0.8942,-0.39144,0.2172],[-0.3305,-0.86244,-0.38337],[-0.32733,-0.020599,0.94469],[-0.89338,0.15017,0.42347],[0.031623,-0.87162,-0.48915],[0.19756,-0.85192,-0.48497],[0.031165,-0.96687,-0.25336],[-0.1056,-0.97494,-0.19582],[0.37753,-0.70721,-0.59777],[0.68736,-0.0014564,0.72632],[-0.12594,0.18608,0.97443],[0.015977,-0.49479,-0.86887],[0.015288,-0.91052,-0.41318],[0.13177,-0.94955,-0.28458],[-0.99144,-0.069095,0.11075],[0.98733,-0.1523,0.044451],[0.15107,-0.20236,0.96759],[-0.16183,-0.25321,-0.95378],[-0.32089,-0.46874,-0.82299],[0.33938,-0.93413,-0.11058],[-0.77051,-0.41874,-0.4806],[-0.80024,-0.13955,-0.58322],[0.84839,-0.031981,-0.52841],[-0.38315,-0.26105,-0.88603],[-0.91992,-0.35408,-0.16847],[0.98626,-0.036297,0.16114],[0.94682,-0.15241,0.28339],[-0.27435,-0.48236,0.83191],[-0.42445,-0.16276,0.8907],[0.13082,-0.94973,0.28443],[0.75896,0.13039,0.63795],[0.6498,0.60683,0.45772],[-0.38454,-0.28604,-0.87767],[0.29091,-0.95667,0.012333],[0.11227,-0.96711,0.22824],[0.53011,-0.82263,0.20558],[0.5817,-0.47042,0.66357],[-0.27777,0.94823,0.15394],[0.41264,-0.54622,-0.72895],[-0.052497,0.98012,0.19132],[-0.40046,-0.32909,0.85518],[0.37863,-0.032148,0.92499],[0.58987,-0.78485,0.18991],[0.75476,0.08833,-0.65003],[-0.39616,-0.19548,-0.89713],[-0.18961,0.9568,0.22042],[0.19818,-0.93114,0.30612],[-0.74175,-0.64688,0.17706],[-0.85515,-0.51352,0.070772],[0.91513,-0.024694,0.4024],[-0.50941,-0.29542,-0.80823],[-0.82007,-0.082506,0.56629],[-0.3021,-0.15425,-0.94072],[0.3374,-0.91588,0.21754],[0.52815,-0.84161,0.11288],[-0.94623,-0.3027,0.1141],[-0.49744,-0.23917,-0.83388],[-0.35421,0.012906,-0.93508],[0.74035,-0.605,0.29302],[-0.43419,0.069538,0.89813],[0.39236,-0.24399,-0.88686],[-0.047062,0.9733,0.22464],[0.66586,0.073476,0.74245],[-0.43619,-0.19169,-0.8792],[0.70297,0.11615,-0.70168],[-0.33069,0.1277,0.93506],[0.78896,-0.58527,-0.18706],[0.48972,0.86032,0.1415],[-0.10049,0.19434,0.97577],[0.45283,-0.19695,0.86957],[0.58833,0.22223,-0.77748],[-0.37645,0.14523,-0.91498],[0.70799,-0.64495,0.28774],[-0.01847,-0.99788,0.062407],[0.42298,-0.040255,0.90524],[-0.69164,0.38615,0.61034],[0.46029,-0.88476,0.073046],[-0.83351,-0.37453,0.4062],[0.32403,-0.049964,-0.94473],[0.82738,-0.20794,0.52173],[0.17222,-0.17495,-0.9694],[-0.23159,-0.18949,-0.95418],[0.14912,-0.97546,-0.16198],[-0.42329,0.17983,-0.88797],[0.59548,-0.80246,0.038282],[0.06317,0.089299,-0.994],[-0.094259,-0.092182,-0.99127],[-0.29172,-0.13634,-0.94674],[0.37841,0.51459,-0.76941],[-0.82036,-0.25092,0.51386],[0.34541,0.16281,-0.92422],[-0.20172,-0.96961,0.13841],[0.16434,0.58842,-0.79168],[-0.58888,0.12488,-0.79851],[-0.36696,-0.065666,0.92791],[0.89379,-0.44686,-0.038199],[-0.31573,-0.026644,-0.94847],[0.40327,-0.84623,-0.34823],[0.43709,0.030954,0.89888],[-0.79711,-0.18154,0.5759],[0.51443,0.25213,-0.81963],[0.19078,0.19695,-0.96167],[0.82405,-0.11358,0.55501],[-0.1468,0.064736,-0.98705],[0.14999,-0.98809,-0.034452],[0.56192,-0.81896,0.1164],[-0.5562,-0.34101,0.75786],[0.095051,0.18134,0.97882],[-0.65354,-0.1757,0.73622],[0.90828,0.41819,0.012155],[-0.75127,-0.65166,0.10459],[0.026108,-0.17437,0.98433],[0.87788,-0.47791,0.030599],[0.088688,-0.23349,0.96831],[-0.24566,0.086884,-0.96545],[-0.39594,0.071241,-0.91551],[0.41177,-0.70344,-0.57932],[-0.69395,0.015629,-0.71985],[-0.55433,-0.095202,0.82683],[0.41533,0.32017,-0.85146],[-0.5237,0.1703,0.83471],[-0.33772,-0.054169,0.93969],[0.50499,-0.57113,0.64715],[0.35244,-0.40653,-0.84292],[0.18969,-0.77371,-0.60447],[0.21262,-0.55225,-0.80611],[-0.53922,-0.032105,-0.84155],[0.14243,-0.39103,0.90929],[0.37857,0.079306,0.92217],[0.34285,-0.048847,-0.93812],[-0.42694,-0.5428,0.72325],[0.021989,-0.25756,-0.96601],[-0.15981,-0.51496,-0.84218],[0.28739,-0.46861,-0.83535],[0.45513,0.35413,-0.81697],[-0.34186,-0.049469,0.93845],[-0.22809,-0.33876,-0.91281],[0.75766,-0.13639,-0.63824],[0.35594,-0.30388,0.88372],[-0.48172,0.33047,-0.81163],[0.19475,-0.096058,0.97614],[-0.57982,0.0089193,0.81469],[-0.51756,0.10775,-0.84884],[0.10571,0.018176,-0.99423],[-0.5748,0.68693,-0.44467],[0.95593,0.24231,0.16578],[-0.57399,-0.017631,0.81867],[0.44567,-0.090408,-0.89062],[0.0051615,0.37069,0.92874],[0.87821,0.11386,-0.46452],[0.074911,0.062266,-0.99524],[-0.20576,-0.22022,-0.9535],[-0.7752,0.58809,-0.23069],[-0.42021,-0.88936,-0.18019],[0.60687,0.029057,-0.79427],[-0.22722,-0.96962,-0.090585],[0.84248,-0.30353,0.44508],[-0.20477,-0.22932,-0.95157],[-0.9193,-0.0041832,0.39353],[-0.90341,0.42127,0.079907],[-0.95465,0.25934,0.14622],[-0.52479,0.073159,0.84808],[0.84506,0.1889,-0.50019],[0.82048,-0.2515,0.51338],[0.5117,0.56819,-0.64445],[0.66068,0.48778,-0.57059],[0.018346,0.042403,-0.99893],[-0.14735,-0.17801,-0.97293],[0.80072,-0.59407,-0.076967],[-0.38089,0.25748,0.88805],[-0.67487,-0.1493,0.72267],[0.4442,0.67859,-0.58498],[-0.24683,-0.11863,0.96177],[-0.96506,0.15924,0.2081],[0.90828,-0.062172,0.41372],[-0.15362,-0.16718,0.97388],[0.32098,0.034377,0.94646],[0.012413,-0.062782,-0.99795],[0.90236,0.1755,0.39364],[-0.42208,0.32314,0.84701],[0.33799,0.015075,0.94103],[-0.93154,-0.36089,-0.044492],[0.36024,0.86797,-0.34183],[-0.8483,0.16705,-0.50248],[-0.40796,0.28346,0.86788],[0.34159,0.70573,-0.6207],[0.19364,0.91937,-0.34243],[-0.83384,0.31048,-0.45641],[-0.82346,0.13707,0.55057],[0.50754,0.85623,-0.096301],[-0.34554,0.34758,0.87166],[0.39847,0.71185,-0.57835],[0.89765,-0.23956,0.36992],[-0.37377,-0.079004,0.92415],[0.88344,0.26675,0.38519],[0.74506,-0.65089,0.14568],[0.43344,0.82064,-0.37239],[-0.49865,0.18885,0.84598],[0.88872,0.33192,-0.31624],[-0.93529,0.20753,0.28664],[-0.21717,0.44627,0.86815],[-0.076574,0.58859,0.8048],[0.84962,0.17458,0.49765],[0.097164,-0.9913,-0.08879],[0.15494,-0.20612,0.96618],[-0.077139,0.72341,0.6861],[0.0397,0.94887,0.31316],[-0.07724,0.98262,0.16879],[-0.28681,0.93594,-0.20432],[0.19558,0.95294,-0.23165],[0.27477,0.93122,-0.23945],[0.85682,0.40507,0.31904],[-0.92479,-0.36038,-0.12201],[-0.076976,0.94186,-0.32706],[-0.056338,0.99294,-0.1044],[-0.56735,0.46023,-0.68286],[-0.15207,-0.14763,0.97728],[-0.35336,-0.018008,0.93531],[0.3197,0.057493,0.94577],[-0.38993,0.60871,-0.69096],[-0.89863,0.19643,0.39229],[-0.060133,-0.99644,0.059103],[-0.55045,0.25889,0.79372],[-0.74091,0.58753,0.32537],[0.37867,-0.65354,0.65536],[-0.8388,0.25669,-0.48013],[-0.62421,0.69427,0.35827],[0.79867,0.58122,0.15591],[-0.2482,-0.27892,0.92769],[0.93412,-0.07497,0.349],[-0.82731,0.35926,-0.43185],[0.67254,0.67792,-0.29683],[0.85685,0.50144,0.11985],[0.60149,0.78345,-0.15627],[0.92597,-0.14221,0.3498],[-0.48773,0.71436,0.50182],[-0.8306,-0.18925,0.52372],[-0.66012,0.59998,0.45196],[0.28483,0.015548,0.95845],[-0.92433,-0.37771,0.05424],[-0.47622,0.74006,-0.4749],[0.79863,0.60143,-0.021664],[-0.31698,-0.53164,0.78542],[-0.42384,0.80735,0.41053],[-0.49533,0.77272,0.39693],[-0.47206,-0.19134,0.86055],[-0.45124,0.75671,-0.47305],[-0.92667,-0.35117,-0.13405],[-0.33954,-0.62868,0.69963],[0.71907,0.69305,0.051193],[0.31398,-0.25782,0.91375],[-0.82829,0.38104,-0.41079],[-0.69655,-0.71703,0.026238],[0.60713,0.77532,0.17398],[0.85516,-0.25748,-0.4499],[-0.89723,0.0081072,-0.44149],[0.65701,0.74163,0.13535],[0.88501,-0.020848,0.46511],[0.062373,-0.11542,0.99136],[0.4843,0.82968,0.27765],[-0.74823,0.52975,-0.39939],[0.90059,-0.39302,0.18568],[-0.2938,0.67273,0.67906],[0.33505,-0.024202,0.94189],[0.30117,0.60799,0.7346],[0.1093,0.81321,0.57161],[0.034446,0.7241,0.68884],[0.029532,0.73522,0.67719],[-0.049333,0.80391,0.5927],[0.86713,0.49617,-0.043703],[0.48226,0.20585,0.8515],[-0.13967,0.71909,0.68073],[0.23003,0.75909,0.60899],[-0.53247,-0.066538,0.84383],[0.92613,-0.29618,0.23358],[-0.80087,0.57494,-0.16751],[-0.48791,0.0077766,0.87286],[-0.70066,0.61346,-0.36433],[-0.41519,-0.90936,-0.02605],[-0.48304,-0.21123,0.84974],[0.51346,0.81211,0.2772],[0.51487,0.8183,0.25554],[-0.89412,0.24345,-0.37587],[0.9729,0.21662,-0.080825],[-0.91521,0.229,-0.33158],[0.93151,0.25108,-0.26314],[0.97472,0.048058,-0.21822],[0.94053,0.10473,-0.32315],[-0.72956,0.6633,-0.16669],[-0.9382,-0.11136,-0.32769],[-0.66161,0.74871,-0.041144],[-0.47752,0.84427,0.24327],[-0.52442,0.85143,0.0077491],[-0.34407,0.1121,0.93223],[-0.85243,0.47586,-0.21661],[-0.74894,-0.65336,-0.11047],[0.664,0.722,0.19449],[0.52048,0.10404,0.84751],[0.59142,0.80191,-0.084636],[0.72583,-0.66812,-0.16366],[0.78493,0.61792,-0.045413],[-0.47562,0.01002,0.87959],[-0.64862,0.72889,-0.2191],[-0.89227,0.011436,0.45135],[-0.92051,-0.36376,-0.1426],[-0.65764,0.71609,-0.23394],[0.78996,-0.075514,0.6085],[0.64121,0.76689,-0.027177],[0.4882,0.86635,-0.10533],[-0.49958,-0.0021592,0.86626],[-0.47207,0.81073,-0.34623],[-0.94173,-0.23326,-0.24235],[-0.44008,0.73684,-0.51322],[0.86842,-0.45641,-0.19376],[-0.40047,0.83628,-0.37452],[-0.02894,0.90506,-0.42429],[-0.35415,-0.55233,-0.75466],[0.046008,0.94753,-0.31635],[-0.7752,-0.34647,-0.52822],[-0.31752,-0.89227,-0.32098],[0.14693,-0.92652,-0.34636],[0.36722,-0.4753,-0.79953],[0.61995,-0.5887,-0.51874],[0.79778,-0.5718,0.19128],[-0.58522,0.0084592,-0.81083],[-0.87919,0.19036,-0.43678],[0.72551,-0.28813,-0.62499],[-0.74425,0.47193,-0.47262],[0.93817,-0.25616,0.23286],[0.90007,0.00012871,0.43574],[-0.63307,0.64544,-0.42736],[0.42565,0.30614,-0.85153],[-0.11033,0.60242,-0.79052],[-0.48426,-0.1171,0.86705],[-0.0432,-0.41264,-0.90987],[0.0039982,-0.34782,-0.93755],[0.033881,-0.38744,-0.92127],[-0.87113,0.12148,0.47579],[-0.18833,-0.29236,-0.93758],[-0.036122,-0.28243,-0.95861],[0.054532,-0.23556,-0.97033],[0.15215,-0.25409,-0.95514],[-0.66035,0.614,0.43237],[0.18175,0.20487,0.96177],[-0.3192,0.24502,0.91546],[-0.243,-0.14192,-0.95959],[-0.18853,-0.15565,-0.96966],[0.19216,0.16728,0.967],[0.76682,-0.086468,-0.63601],[-0.78011,0.044627,0.62405],[0.56905,-0.7332,0.37228],[-0.29215,0.043485,-0.95538],[-0.26287,0.0035039,-0.96482],[-0.14353,-0.35701,0.92301],[-0.8987,0.05497,-0.43511],[0.29768,-0.1191,-0.94721],[0.84479,0.15443,0.51233],[-0.33758,0.0085366,-0.94126],[-0.46378,0.26055,0.84677],[-0.3046,0.036817,-0.95177],[0.35951,-0.057653,-0.93136],[-0.0046656,-0.17881,0.98387],[0.44903,0.025176,-0.89316],[-0.0041136,-0.12828,0.99173],[0.51274,0.11103,-0.85133],[-0.83009,0.25078,0.49806],[-0.10485,-0.90869,-0.40409],[0.065298,-0.91755,-0.39222],[-0.52427,0.1019,0.84543],[0.39048,-0.88436,-0.25581],[-0.43211,0.10603,-0.89556],[-0.11812,-0.86861,-0.48121],[-0.68414,-0.57407,-0.44989],[0.8554,0.23861,0.45973],[0.057619,-0.8576,-0.51109],[0.03826,-0.90617,0.42119],[0.47176,-0.27542,0.83761],[0.27325,-0.77006,-0.57649],[0.50604,-0.8435,-0.18009],[-0.42619,0.030029,-0.90413],[-0.34161,-0.85944,-0.38034],[0.14055,-0.19144,0.97139],[-0.25546,-0.8647,-0.43249],[-0.47287,0.37521,0.79725],[-0.49295,-0.76508,-0.41432],[-0.93552,-0.12955,-0.32866],[-0.52505,-0.73832,-0.42334],[0.50283,-0.83322,-0.23],[-0.52831,0.39938,0.74926],[0.42529,0.05625,-0.90331],[0.34799,0.084226,0.93371],[-0.37531,-0.79058,-0.48387],[-0.28683,-0.83702,-0.46596],[0.44962,-0.84424,-0.29171],[0.86013,0.34273,0.37776],[0.8577,0.11005,0.50224],[-0.45074,-0.038164,-0.89184],[0.10766,-0.22032,-0.96947],[-0.90792,0.20018,0.36826],[-0.10537,-0.59971,-0.79325],[0.86034,0.13472,0.4916],[-0.72215,-0.48683,-0.49141],[-0.013811,-0.87323,0.48711],[0.31848,-0.79252,-0.52008],[-0.16698,-0.49354,-0.85354],[-0.25985,-0.26111,-0.92968],[0.85743,-0.021944,-0.51413],[-0.87557,0.022984,-0.48254],[0.83449,0.43708,0.33554],[-0.76264,-0.40908,-0.50104],[-0.44262,-0.062789,0.89451],[0.44351,0.13037,0.88674],[-0.012958,-0.89041,0.45497],[-0.40813,-0.86612,-0.28854],[0.68105,0.70227,0.20734],[-0.58321,-0.7134,-0.3885],[0.74623,-0.15202,0.6481],[-0.80292,-0.35515,-0.47874],[-0.20969,0.94093,0.26586],[-0.3604,0.64219,0.67653],[-0.55782,-0.73315,-0.38902],[-0.65437,-0.56969,-0.49725],[0.67951,-0.46544,-0.56712],[-0.75489,-0.48254,-0.44419],[0.30583,0.15776,0.93892],[-0.11562,0.10968,0.98722],[0.73054,-0.36935,-0.57437],[-0.78381,0.4095,0.46684],[0.66272,-0.49871,0.55865],[0.34326,0.85824,0.38157],[0.51546,-0.83257,0.20283],[-0.37091,-0.025319,0.92832],[0.87248,-0.048652,-0.48622],[-0.38422,-0.87203,-0.30321],[0.030655,-0.98333,-0.17925],[0.082822,-0.96391,-0.25302],[-0.053494,-0.87245,-0.48577],[-0.0037202,-0.8554,-0.51795],[0.26915,0.85789,0.43769],[0.22927,-0.89032,-0.39341],[-0.37554,-0.24937,0.89263],[0.37112,0.23446,0.8985],[-0.11667,-0.55745,-0.82197],[0.14996,-0.57925,-0.80124],[0.2204,0.89302,0.39235],[-0.56909,-0.7008,-0.43013],[0.03952,-0.97236,-0.2301],[0.24039,-0.055803,0.96907],[0.89663,-0.18585,-0.40189],[0.02792,-0.99108,-0.13033],[-0.7195,0.41401,0.5576],[-0.20117,-0.97937,0.018936],[-0.38972,-0.88487,-0.25521],[0.68533,0.68704,0.24146],[0.81075,-0.1118,0.57462],[-0.817,-0.2193,-0.53331],[-0.34832,-0.071848,-0.93462],[-0.074392,-0.22628,-0.97122],[0.19656,-0.7262,-0.65878],[-0.9469,-0.14275,-0.28811],[0.57589,0.73,0.36803],[-0.79354,-0.3953,-0.46263],[-0.36986,0.75438,0.54232],[0.39511,-0.56566,0.72382],[0.25397,-0.94946,-0.18445],[0.86193,-0.4071,0.30223],[0.88758,0.11575,-0.44588],[0.55783,-0.60275,-0.57055],[0.54449,0.22633,0.80766],[-0.41926,-0.026218,-0.90749],[-0.31561,-0.31254,-0.89594],[-0.39255,-0.0036014,0.91973],[-0.50705,0.12159,0.85329],[-0.6884,0.46247,0.55877],[0.86165,-0.086624,-0.50006],[0.81243,0.39738,-0.42667],[0.53357,-0.84177,-0.081989],[-0.27991,-0.75287,0.59568],[0.50044,-0.31759,-0.80542],[-0.97114,-0.22918,-0.066067],[-0.84587,0.22248,-0.48477],[-0.73884,-0.21972,-0.63706],[-0.28757,0.22458,0.93106],[0.31789,0.90393,0.28611],[-0.14777,-0.78428,0.60255],[-0.32837,-0.76122,0.55921],[-0.13404,-0.8491,0.51095],[0.16069,-0.87356,0.45942],[-0.30032,-0.26933,-0.91503],[0.028982,-0.79894,0.60071],[0.45597,-0.88554,0.088903],[0.1345,0.79165,0.59599],[0.64646,-0.74355,0.17095],[-0.039766,-0.99823,-0.044183],[0.33509,-0.45971,-0.82243],[-0.48143,-0.84093,0.24712],[-0.55428,-0.30404,-0.77481],[-0.63399,-0.71058,-0.30518],[0.82781,0.010914,-0.5609],[-0.6738,-0.72524,0.14149],[-0.68431,0.63838,-0.3524],[0.34794,-0.51607,-0.78269],[-0.35507,-0.34506,-0.86883],[-0.42403,-0.7335,-0.53121],[0.31014,0.28389,0.90732],[-0.35515,-0.22169,-0.90814],[0.36276,-0.92242,0.13248],[0.14803,-0.96808,0.20226],[0.28383,-0.4741,-0.83347],[0.47884,0.87788,0.0070248],[0.18398,0.10217,0.9776],[0.25494,0.95551,0.14835],[0.55311,-0.76359,0.33316],[0.34627,-0.33899,-0.87475],[-0.28059,-0.24693,-0.92752],[-0.64951,0.60699,0.45794],[-0.79702,-0.55145,0.24631],[-0.48195,0.081671,0.87238],[-0.31536,0.020956,0.94874],[0.30363,0.30752,0.9018],[0.12992,-0.28803,-0.94877],[-0.056638,-0.25389,-0.96557],[-0.39144,0.34378,0.85358],[0.19956,0.088504,0.97588],[-0.46021,0.77781,-0.42804],[-0.060698,-0.19946,-0.97802],[-0.46047,0.79835,-0.38808],[-0.29715,0.12027,-0.94723],[-0.56403,0.25925,0.784],[0.42572,-0.89559,0.12913],[-0.73903,0.33764,0.58295],[0.36902,0.92238,-0.1142],[0.55234,-0.62912,0.54692],[0.33196,-0.93555,0.12065],[0.3283,-0.94065,0.085977],[-0.81866,-0.45969,0.3442],[0.50458,0.32287,-0.80072],[-0.62478,0.65438,0.42594],[-0.31167,0.19464,-0.93004],[0.31923,-0.2845,0.90396],[0.2362,0.57037,-0.7867],[0.79079,0.055257,0.60959],[0.01021,-0.76161,0.64795],[-0.58247,0.74117,-0.33375],[-0.34524,0.28529,-0.8941],[0.59963,0.34277,-0.72315],[0.53337,0.37395,-0.75874],[-0.084207,-0.3418,0.93599],[-0.45625,0.19902,-0.86731],[0.45571,0.80602,-0.3777],[0.20545,0.79195,0.57498],[-0.28419,0.50541,0.81474],[-0.80001,-0.10688,0.59039],[0.45224,0.53759,0.71167],[0.64075,0.089186,-0.76256],[0.74749,-0.64098,0.17436],[0.59975,-0.20018,-0.77474],[-0.43733,0.044777,0.89819],[-0.57365,0.1721,-0.80082],[0.87387,-0.23801,-0.42391],[0.085864,0.053313,0.99488],[0.32804,-0.94466,0.0023893],[-0.67152,-0.035849,0.74012],[0.036697,0.1492,-0.98813],[-0.34154,0.095385,-0.93502],[0.17669,-0.76302,-0.62175],[-0.60737,-0.32871,0.72323],[-0.15519,-0.62044,-0.76875],[0.067967,-0.627,0.77605],[0.21214,0.18017,0.96049],[0.18729,-0.60193,-0.77628],[-0.43634,-0.82179,0.36644],[-0.5628,-0.087377,-0.82196],[0.81757,-0.52793,0.22993],[0.10022,0.23566,0.96666],[-0.16261,0.060276,-0.98485],[0.19758,0.079302,0.97707],[-0.078479,-0.63581,-0.76785],[0.10142,0.2379,0.96598],[-0.26851,-0.64422,0.71616],[0.56846,-0.40281,-0.71735],[0.86026,-0.35544,0.36553],[0.21702,0.15595,-0.96363],[-0.4799,0.72728,-0.49068],[0.83284,-0.019865,0.55315],[-0.48117,-0.043057,-0.87557],[0.3544,0.11684,-0.92777],[-0.15363,0.21809,-0.96376],[0.93354,0.019963,-0.35793],[0.84471,-0.30077,0.44272],[-0.38335,-0.72737,0.56919],[0.18482,0.66245,0.72595],[-0.3088,0.18797,-0.93237],[-0.46799,0.42886,-0.7727],[-0.3647,0.72804,-0.58047],[-0.26813,-0.56305,0.78172],[-0.45227,0.73842,0.50018],[-0.65357,-0.057014,0.75472],[-0.95341,0.24388,0.1776],[0.41955,0.02163,-0.90748],[0.03141,0.28107,0.95917],[-0.93566,-0.11734,-0.33281],[0.88628,-0.24173,-0.39508],[-0.43735,0.17506,-0.88209],[0.91525,0.050112,-0.39977],[-0.50771,0.78412,-0.35693],[-0.44761,0.62703,-0.63756],[-0.73698,0.67293,-0.063476],[-0.61203,0.074233,0.78735],[-0.59978,0.51146,0.61536],[-0.58024,0.24342,-0.77722],[-0.69612,0.71492,-0.065672],[0.75931,0.31422,0.56983],[0.59714,0.30791,-0.74069],[0.85487,-0.34512,0.38741],[0.85643,0.10092,-0.5063],[0.66165,0.4451,-0.60341],[-0.34996,0.71271,0.60793],[-0.50254,0.29675,0.81203],[0.73921,0.39388,0.54628],[0.065397,-0.5993,0.79785],[-0.40417,0.19579,0.89348],[0.5793,0.63912,-0.5059],[0.27014,0.34805,0.89771],[-0.78137,0.23956,-0.57626],[0.64815,-0.0054012,0.76149],[-0.99324,0.065235,0.095999],[-0.97405,0.21916,0.056592],[0.77998,-0.15851,0.6054],[-0.49828,-0.35855,0.78941],[0.53898,0.69825,0.47112],[0.025215,-0.074632,0.99689],[0.86616,-0.23168,0.44282],[0.81907,0.10498,-0.56401],[-0.1409,0.78714,-0.60047],[0.26505,0.79388,0.54727],[0.79202,0.13795,-0.5947],[0.85264,0.05436,0.51967],[0.84138,-0.19467,0.50417],[-0.57403,-0.28329,0.76827],[0.22303,-0.54574,0.80773],[-0.93273,0.35137,0.080964],[0.63136,-0.24624,0.73536],[-0.59997,0.77933,-0.18075],[0.35004,0.49251,-0.79681],[0.32867,0.73916,-0.58789],[-0.82563,0.32139,-0.46373],[-0.96208,0.23503,0.13843],[-0.8639,0.50252,0.034038],[-0.28243,0.40706,0.86864],[0.75793,0.35278,-0.54871],[-0.12334,0.66565,0.736],[0.20472,-0.030567,0.97834],[0.31294,0.85975,-0.4036],[0.73285,0.45624,0.50476],[0.038596,0.20117,-0.97879],[-0.046635,0.80751,0.588],[0.17898,0.84043,0.51152],[-0.028589,0.91755,0.39659],[-0.27126,0.9625,0.0034549],[0.26943,0.93102,-0.24619],[-0.65582,0.39866,-0.64107],[-0.90547,0.23615,0.35265],[-0.95583,-0.24903,0.15612],[-0.29826,0.89211,-0.33939],[0.01526,0.96181,-0.27331],[-0.11807,0.99276,-0.021974],[0.14948,0.90142,0.40632],[0.047533,0.99632,0.071381],[0.19212,0.96533,-0.17672],[0.49269,0.86871,0.051],[0.78582,0.61297,-0.082147],[0.70469,-0.68577,-0.18202],[-0.84485,0.28078,0.4554],[0.1377,0.98416,0.11166],[-0.61922,0.47777,-0.62313],[0.85031,0.44181,0.28597],[-0.42199,0.61798,-0.66334],[-0.23426,-0.32888,-0.91486],[-0.24336,0.60555,-0.75769],[-0.13742,0.79618,0.58925],[-0.56569,0.66265,0.4908],[0.21048,-0.44288,-0.87153],[-0.36145,0.66877,-0.64969],[-0.92882,0.36676,0.052758],[-0.79763,0.46676,-0.382],[-0.18882,-0.15632,-0.96949],[0.22439,0.28588,0.93162],[-0.41018,-0.35798,0.83881],[0.59388,0.77407,-0.21935],[0.59689,0.76005,-0.25698],[-0.7302,0.51455,0.44949],[0.26528,-0.2989,0.91667],[0.21553,-0.16879,0.9618],[-0.55725,0.71346,-0.42478],[-0.68782,0.56725,0.45292],[0.87507,0.46695,0.12731],[-0.52393,0.71556,-0.46203],[-0.67587,0.62723,0.38701],[0.23072,0.9699,0.077906],[-0.14417,0.35846,0.92235],[0.82545,0.54233,-0.15654],[-0.54124,0.72144,-0.43195],[-0.5177,0.6761,0.52429],[0.54766,-0.24458,0.80016],[0.15315,-0.13869,0.97842],[-0.54762,0.74033,-0.38991],[-0.63833,0.56255,-0.52543],[-0.45937,0.72999,0.50606],[0.25885,0.23079,0.93794],[-0.67633,0.49165,-0.54851],[0.62889,-0.37466,0.68127],[-0.43949,0.71466,0.54416],[-0.42097,0.61165,0.66983],[-0.77874,0.44885,-0.43829],[-0.52921,0.59619,0.60373],[0.83845,0.53389,0.10934],[0.77393,-0.26234,0.57637],[-0.38058,-0.16294,0.91028],[0.29775,0.70763,0.64078],[0.10584,0.81317,0.57232],[-0.95796,0.27496,0.081868],[0.49065,-0.24714,0.83557],[-0.13232,0.84837,0.5126],[-0.16837,0.82845,0.53416],[0.99226,-0.11718,-0.041128],[0.23949,0.89189,0.38364],[-0.12287,-0.29372,-0.94796],[-0.24391,-0.34661,-0.90574],[-0.35325,0.72134,0.59572],[0.89564,0.44212,0.048602],[-0.1618,0.84419,0.51104],[0.084754,0.7661,0.63711],[0.26935,0.70595,0.65505],[-0.72189,0.54111,-0.43136],[0.82413,0.55192,0.12725],[-0.52103,-0.19583,0.83077],[-0.96319,-0.15882,0.21688],[0.77298,0.58863,0.23669],[-0.73406,0.52679,-0.42854],[-0.62331,0.63635,-0.45447],[0.59262,-0.13267,0.79448],[0.78933,0.61301,-0.034414],[-0.83137,0.44182,-0.33708],[0.91734,0.32811,-0.22547],[0.97071,0.14387,-0.19239],[0.73928,-0.26534,0.61891],[0.011262,-0.49334,-0.86976],[0.94669,0.31881,-0.046228],[-0.85187,0.47937,-0.21099],[0.77619,0.61639,0.13268],[0.41207,-0.40339,0.81699],[0.71726,0.68914,0.10308],[0.020392,-0.48203,-0.87592],[0.75684,0.64496,-0.10592],[0.71307,0.52212,0.4679],[0.72404,0.66041,-0.19908],[-0.8,0.54226,-0.25683],[-0.71939,0.66702,-0.19382],[-0.60408,0.0053238,0.79691],[-0.93017,-0.28651,0.22954],[-0.55971,0.81356,-0.15761],[0.73635,0.67513,-0.044504],[-0.1862,-0.60253,-0.77607],[-0.64832,0.61802,0.44468],[-0.9783,-0.15472,0.13784],[-0.8752,0.44145,-0.19784],[-0.37492,-0.35404,0.85679],[0.5506,0.82106,-0.1507],[-0.4466,0.8018,0.39707],[-0.59175,0.56967,-0.57036],[0.58184,-0.50099,-0.64067],[0.40868,0.88621,-0.2182],[0.24857,0.92385,-0.29107],[-0.85362,-0.3677,0.36896],[0.4928,0.80133,-0.33915],[0.15714,0.31988,0.93434],[0.34352,-0.35706,0.86862],[0.32346,0.75977,-0.56403],[-0.16292,0.76017,-0.62897],[-0.23765,0.86006,-0.45146],[-0.27468,0.7797,-0.56268],[0.029991,0.81462,-0.57922],[0.14126,0.63485,-0.75961],[-0.52468,-0.55252,-0.64763],[0.24055,0.77705,-0.58166],[-0.091866,0.45554,-0.88546],[0.29225,0.79632,0.52959],[-0.85769,-0.48364,0.17452],[0.5113,0.026428,0.85899],[-0.45059,-0.88099,0.14432],[-0.18144,-0.97428,0.13363],[0.29913,-0.95132,-0.074195],[0.62437,-0.67503,-0.39306],[-0.28181,-0.54647,-0.78864],[-0.94948,0.31212,0.032865],[0.56049,-0.35301,0.74916],[0.74024,-0.37758,-0.55631],[-0.28582,-0.58436,0.75949],[0.61413,0.10912,-0.78162],[-0.87346,0.48035,-0.079595],[-0.51109,0.74037,-0.43663],[0.050675,0.65549,-0.7535],[0.46772,0.34151,-0.81523],[0.33631,0.73487,0.58895],[-0.047473,-0.5525,-0.83216],[-0.011603,-0.50036,-0.86574],[-0.025181,0.91955,0.39217],[0.034284,-0.55541,-0.83087],[-0.53695,-0.58419,-0.60861],[0.46693,0.17278,0.86725],[-0.18287,-0.4294,-0.8844],[-0.11983,-0.46707,-0.87606],[0.14168,-0.46453,-0.87415],[0.98725,0.11298,-0.11209],[0.24831,-0.36767,-0.89619],[-0.25069,-0.2525,-0.93456],[0.27575,0.68866,0.6706],[0.23494,-0.19597,-0.95205],[0.30359,-0.219,-0.92729],[-0.39669,-0.076735,-0.91474],[0.34715,-0.073969,-0.93489],[0.99469,0.085384,0.057519],[-0.42879,0.08272,-0.89961],[-0.2811,-0.751,0.59748],[0.55888,-0.65366,0.51027],[0.3898,-0.22016,-0.89419],[0.30788,-0.83635,-0.45358],[-0.38834,0.1044,-0.91558],[0.6745,0.22452,0.70331],[0.51204,-0.203,-0.83463],[-0.1601,0.77088,0.61653],[0.39957,-0.35064,0.847],[-0.15644,0.73267,0.66236],[-0.60009,0.22189,0.76854],[0.26651,-0.9036,-0.33539],[0.53259,0.042043,0.84533],[-0.42607,-0.71483,-0.55451],[-0.29056,-0.85832,0.42292],[-0.93285,0.15487,0.32527],[0.17047,-0.83233,-0.52741],[-0.68922,-0.53361,-0.49013],[-0.32718,-0.86024,-0.39107],[-0.9431,0.29312,0.15698],[0.41481,-0.70477,-0.57553],[0.46566,0.094954,-0.87985],[0.054732,-0.36965,0.92756],[-0.74576,-0.38093,-0.54657],[0.53162,-0.81246,-0.23936],[-0.26876,-0.69902,0.66267],[-0.47367,0.10155,-0.87483],[0.3972,0.0041028,-0.91772],[0.5026,-0.61467,-0.60793],[-0.44366,0.040021,-0.8953],[0.64145,-0.64759,0.4113],[-0.12379,-0.53558,-0.83536],[-0.98311,-0.074633,-0.1671],[0.92268,0.025364,0.38473],[-0.55576,-0.71754,-0.41984],[-0.99629,-0.048111,-0.071288],[0.29322,-0.80368,-0.5178],[0.92853,-0.34046,-0.14802],[0.26241,-0.44902,-0.85412],[0.60753,-0.54627,-0.57663],[-0.71348,-0.4092,-0.56877],[0.23851,-0.67879,-0.69451],[-0.33744,-0.19657,-0.92059],[-0.77507,-0.14827,0.61423],[-0.42278,-0.70712,0.56677],[-0.91328,-0.40585,-0.034605],[0.72269,-0.62592,-0.29316],[0.64378,-0.51629,-0.56479],[-0.66895,-0.61605,-0.41593],[-0.4094,-0.86376,-0.29378],[-0.25885,-0.87142,0.41668],[0.64847,-0.48526,-0.58652],[-0.91645,-0.35743,-0.1799],[0.77663,-0.5177,-0.35893],[0.058494,-0.36882,0.92766],[-0.076215,-0.5241,0.84824],[-0.70278,-0.56727,-0.42931],[-0.21415,-0.69719,0.68415],[0.58703,-0.64611,-0.48779],[0.1687,0.28,0.94506],[0.53991,0.25085,0.80348],[-0.80029,-0.33936,-0.49434],[-0.96195,0.029517,-0.27162],[-0.15448,-0.54803,0.82207],[-0.10526,-0.63761,0.76314],[0.83402,-0.23069,-0.50119],[-0.86384,-0.27126,-0.42449],[-0.3765,-0.34099,0.86138],[0.8644,-0.1396,-0.48304],[-0.21217,-0.78694,0.5794],[0.1015,-0.86151,-0.4975],[-0.20562,-0.75383,-0.62407],[-0.24965,-0.38298,0.88938],[-0.011357,-0.78243,-0.62264],[0.29106,-0.73019,-0.61815],[-0.44343,-0.88215,-0.15869],[-0.26152,-0.9559,-0.13367],[0.22341,-0.91575,-0.33389],[0.12704,-0.91597,-0.3806],[-0.35679,0.93411,-0.011772],[0.39478,0.71657,0.57504],[-0.33663,-0.37639,-0.86314],[-0.25963,0.89207,0.36988],[0.95841,0.24746,0.1422],[-0.43696,0.278,0.85544],[-0.22562,-0.97397,-0.022111],[0.032597,-0.99619,0.080895],[-0.0096821,-0.99789,-0.064214],[-0.028606,-0.99102,-0.1306],[0.17456,-0.98393,0.03744],[0.80362,-0.48778,-0.34098],[0.27745,-0.80125,-0.5301],[-0.015654,0.80599,0.59172],[-0.38379,0.0053637,-0.9234],[0.13088,-0.92098,-0.36697],[0.15957,-0.53008,0.8328],[0.4235,-0.43665,0.79372],[0.13242,-0.98206,0.13428],[-0.33816,-0.93627,-0.095084],[0.49471,-0.73498,-0.46375],[0.90244,0.076351,0.42399],[-0.31758,-0.45632,0.83121],[0.030302,0.80024,0.59891],[-0.26696,-0.8234,0.50075],[-0.59532,-0.26861,-0.75726],[-0.36855,-0.1377,-0.91935],[0.36637,-0.92616,-0.089493],[-0.82527,-0.33179,-0.45699],[0.6317,-0.34765,-0.69289],[0.62531,-0.15454,0.76492],[-0.44918,0.38616,0.80568],[-0.32107,-0.31506,-0.89311],[0.35348,-0.93463,-0.039086],[0.19443,-0.58286,0.78897],[0.50054,-0.29855,-0.8126],[-0.36246,-0.35881,-0.86016],[0.58465,-0.80732,-0.080119],[-0.66176,-0.711,-0.23781],[0.31071,-0.57356,0.75795],[0.97599,-0.17596,0.12835],[-0.33569,-0.3831,-0.86055],[0.38038,-0.7199,0.58056],[0.85855,-0.44632,0.25238],[0.30955,-0.49341,-0.81285],[0.26065,-0.22285,0.93936],[-0.31073,-0.30707,-0.89953],[0.19149,-0.23233,0.9536],[-0.30843,0.2964,0.90389],[0.52069,-0.61521,0.59195],[-0.21428,-0.94665,0.24069],[-0.15091,-0.90105,0.40661],[0.2891,-0.87976,0.37741],[-0.27941,-0.73922,0.61277],[-0.26006,-0.54116,0.7997],[-0.22156,-0.32871,-0.91808],[-0.1467,-0.55228,0.82065],[0.21652,-0.64402,0.73373],[0.5793,-0.81501,-0.012974],[0.29613,-0.60887,0.73592],[0.071556,-0.40385,-0.91202],[-0.043212,-0.30518,-0.95131],[-0.21165,-0.29543,-0.93162],[0.29182,-0.44616,0.84604],[0.41248,-0.91053,0.028094],[-0.4159,0.32659,0.84874],[-0.37041,-0.14042,-0.91819],[-0.41406,-0.32757,0.84926],[0.87914,0.10476,0.4649],[0.36165,-0.34754,0.86512],[-0.36062,0.0045729,-0.9327],[-0.54861,0.46171,0.69703],[0.48297,-0.62487,0.61342],[0.69771,-0.65233,0.29608],[0.77164,0.04451,-0.63449],[-0.91338,0.29468,-0.28089],[0.98798,-0.12975,0.084061],[0.64869,0.16656,-0.7426],[-0.29668,0.13055,-0.94601],[0.73746,0.42002,0.5289],[-0.24782,0.18494,-0.95099],[0.61682,-0.75967,0.20601],[-0.88724,-0.1972,0.41703],[0.46238,-0.80243,-0.37723],[-0.21917,0.24721,-0.94385],[0.5448,0.13623,0.82743],[-0.84951,-0.19109,0.49176],[-0.90639,-0.25895,-0.33378],[0.41915,0.4275,-0.80097],[-0.86292,-0.26651,0.42936],[-0.15242,-0.15329,0.97636],[0.65488,-0.72843,0.2013],[0.18645,0.55094,-0.81345],[-0.98063,-0.070049,-0.18289],[0.19884,-0.4361,0.87766],[0.505,0.16186,-0.84781],[-0.78759,-0.0054801,0.61618],[0.57882,-0.22798,-0.78294],[0.3703,-0.39064,0.84278],[0.50841,-0.51823,-0.68772],[-0.41363,-0.74141,-0.52842],[0.91385,-0.31863,0.25169],[-0.82242,-0.53882,-0.18249],[0.45317,-0.49464,-0.7416],[-0.52745,0.20518,-0.82444],[-0.29845,0.61672,0.72841],[-0.76338,0.035529,0.64497],[0.93396,0.0020363,0.35736],[-0.72188,-0.41863,0.55104],[-0.12829,-0.65832,-0.74173],[-0.41637,-0.42015,0.8063],[0.78742,-0.29676,-0.54028],[0.027665,-0.30575,0.95171],[0.86891,-0.15593,-0.46976],[-0.39524,-0.23585,-0.88778],[0.89346,0.30721,0.32765],[0.14056,-0.631,0.76294],[-0.77815,-0.55443,-0.2951],[0.13127,0.3518,0.92682],[-0.43622,0.28972,-0.85192],[0.0010979,0.19426,-0.98095],[-0.91612,-0.23997,-0.32117],[0.95616,-0.084232,0.28047],[0.67823,0.18936,0.71003],[-0.6672,0.019574,0.74462],[-0.52365,0.44042,-0.72925],[-0.35758,0.75637,-0.54777],[-0.71105,-0.35413,-0.60746],[-0.2634,-0.73546,0.62427],[0.32996,0.21108,-0.92009],[-0.32222,0.2671,-0.9082],[-0.96303,-0.19996,-0.18053],[-0.35415,0.83747,-0.41621],[-0.2106,0.76433,-0.60947],[-0.33057,-0.35997,0.87244],[0.81065,-0.23282,0.53725],[0.066483,0.35703,-0.93172],[-0.11424,0.35146,-0.92921],[-0.29805,0.34492,-0.89005],[0.95939,-0.10195,0.263],[-0.43107,0.78164,-0.4508],[-0.55893,-0.048431,0.8278],[0.975,0.08972,0.2033],[0.22115,-0.94677,0.23394],[0.34708,-0.32044,0.88139],[-0.41144,0.37226,-0.83195],[0.92434,0.13992,-0.35499],[-0.90191,-0.34916,-0.25426],[-0.55708,0.79541,-0.23871],[0.96949,-0.24336,-0.029285],[-0.95416,0.15361,-0.25688],[0.89221,0.069561,-0.44624],[0.76935,-0.22783,0.59682],[0.31836,-0.65767,0.68272],[0.63947,0.5674,0.51878],[-0.18338,-0.97522,-0.12376],[-0.46118,0.23739,0.85496],[-0.5006,-0.37842,0.77859],[-0.99106,-0.13151,-0.022485],[-0.44293,0.32402,0.83596],[0.87836,-0.31021,-0.36366],[0.42537,0.80434,-0.41485],[-0.86284,0.4812,0.1548],[-0.46455,0.40568,0.78716],[-0.40727,0.31749,0.85635],[-0.7247,0.67367,-0.14488],[0.35292,0.89662,-0.26744],[0.29268,0.89295,-0.34203],[0.4186,-0.22712,0.87931],[0.51403,-0.44762,0.73172],[-0.93595,0.32277,0.14079],[-0.2412,0.50423,0.8292],[0.54541,-0.49149,0.67895],[0.45291,0.7345,-0.50535],[0.75478,0.30133,-0.58268],[0.919,-0.045454,0.39163],[-0.99807,-0.014662,0.060294],[-0.097631,0.63036,0.77014],[-0.52049,-0.29216,0.80233],[-0.18864,0.54069,0.8198],[0.32677,0.69936,-0.6357],[-0.85674,0.26322,-0.44352],[-0.77118,0.61295,0.17197],[-0.74776,0.61946,0.23901],[-0.47383,-0.60853,0.63653],[-0.25084,0.73751,0.62702],[0.90724,-0.0027158,0.4206],[0.23707,0.87838,-0.41502],[-0.82765,0.24924,-0.50287],[0.78116,0.41986,-0.46206],[0.83982,0.24864,0.48258],[-0.34633,0.93076,0.11726],[-0.46809,0.84548,-0.25703],[0.28924,0.95016,-0.11636],[-0.33911,-0.38986,0.85616],[0.75399,0.49424,-0.4327],[-0.81904,0.36794,0.44021],[-0.027745,-0.99908,0.032769],[-0.50221,0.57615,0.64485],[-0.0080371,0.95833,-0.28554],[0.074156,0.9545,-0.28886],[0.09383,0.96538,-0.24341],[0.15789,0.98703,-0.029168],[0.08844,0.99478,0.050996],[0.53622,-0.42119,0.73148],[-0.93249,-0.18107,-0.31253],[-0.65656,0.34414,0.67119],[-0.97114,0.19673,0.13488],[0.84797,0.4791,-0.22673],[-0.67755,0.4272,0.59869],[0.55235,-0.38531,0.73922],[0.53341,-0.20425,0.82083],[-0.97993,-0.14565,-0.13612],[0.47431,0.68581,0.55198],[0.80731,0.56259,-0.17816],[-0.46936,0.7258,0.5029],[-0.59419,0.65758,0.46318],[0.89718,0.12119,0.42471],[-0.032049,0.39436,0.91839],[-0.97813,0.19677,-0.06745],[0.95443,0.023329,-0.29753],[-0.75878,0.53087,-0.37741],[-0.99591,0.082594,-0.036556],[0.73735,0.6654,-0.11645],[0.24236,-0.94502,0.21953],[0.93678,0.085909,-0.33922],[-0.77568,0.52576,-0.34914],[0.69905,0.6216,-0.35347],[0.61426,0.65504,-0.44001],[-0.95664,0.28007,0.079953],[0.34178,-0.86873,0.35845],[0.77063,0.63709,0.015333],[0.8681,0.26572,0.41929],[0.96643,0.091763,0.23997],[-0.3454,0.81345,0.46797],[-0.97865,-0.092833,-0.18337],[-0.91056,0.028143,0.41243],[-0.42657,0.8651,-0.26391],[0.93628,-0.018188,0.35078],[0.5508,-0.26838,0.79031],[0.84099,0.50366,0.19764],[-0.46927,0.83091,-0.29897],[0.99097,-0.10897,-0.078073],[-0.67317,0.59967,-0.4327],[0.65916,0.74413,0.10847],[0.59434,0.77656,0.20909],[-0.21391,0.61647,0.75777],[0.55448,-0.027279,0.83175],[-0.11443,0.63268,0.76591],[0.24976,0.7259,0.64086],[0.15555,0.73546,0.65947],[-0.087508,0.80367,0.5886],[0.19787,0.91614,0.34862],[0.61109,0.77676,0.15234],[-0.99226,0.12414,0.0021064],[-0.38324,0.65249,0.65374],[0.70863,-0.58626,0.39261],[0.48821,-0.32491,0.80999],[-0.069987,0.73389,0.67565],[0.064049,0.83507,0.5464],[-0.61868,-0.54578,0.56511],[-0.73237,0.57066,-0.37147],[-0.36478,0.74681,0.55607],[0.95199,0.11834,0.28234],[0.35238,0.78372,0.51148],[-0.91626,0.39982,-0.024499],[-0.74976,0.52501,-0.40277],[-0.12775,0.36448,0.92241],[-0.73821,0.54416,-0.39867],[0.67466,0.73209,0.094197],[-0.99675,0.024656,0.076696],[0.93765,0.1789,0.298],[0.87425,0.48017,-0.071623],[0.58059,0.81063,0.07609],[-0.92516,0.37527,0.056991],[0.97108,-0.061552,-0.23069],[-0.67625,0.72732,-0.11704],[-0.87624,-0.20187,0.43755],[-0.54805,0.83426,-0.060405],[-0.79451,0.53342,-0.29019],[0.81258,0.54702,-0.20121],[-0.86982,0.37728,-0.31791],[0.99631,-0.068568,0.051699],[0.70748,0.67052,-0.22332],[-0.81708,0.49694,-0.29228],[0.62773,0.75875,-0.17392],[-0.8863,0.45384,0.092253],[0.7469,0.65533,-0.1126],[-0.90639,0.4168,-0.068799],[0.91591,0.083669,-0.39257],[-0.57255,0.69587,-0.43352],[-0.78865,0.52642,-0.31767],[0.63464,0.73531,-0.23781],[-0.66781,0.44766,-0.59467],[-0.54773,-0.7323,0.40464],[-0.59765,0.49884,-0.62767],[0.59778,0.68394,-0.41819],[-0.56373,0.3308,-0.75682],[0.92515,0.27905,0.25734],[0.56939,0.75252,0.33092],[-0.36122,0.1265,-0.92386],[-0.4473,0.50154,-0.74053],[0.21402,0.67659,-0.70457],[-0.27678,0.057363,-0.95922],[0.8875,0.36384,-0.28278],[-0.99716,0.037779,0.06509],[0.41451,0.54163,-0.73132],[-0.25839,0.053549,-0.96456],[-0.14604,0.13052,-0.98063],[-0.15256,0.33712,-0.92902],[-0.86427,-0.24473,0.43948],[0.36418,0.48052,-0.79779],[0.1312,0.30668,-0.94273],[0.020816,0.55168,-0.83379],[-0.3446,0.35164,-0.8704],[0.10525,0.38778,-0.91572],[0.23995,0.42914,-0.87078],[-0.22856,0.24806,-0.9414],[0.034749,0.20457,-0.97823],[-0.24624,0.24964,-0.93651],[-0.88696,0.022046,0.46133],[0.053485,0.26344,-0.96319],[0.19406,0.20867,-0.95854],[0.21322,0.31284,-0.92556],[-0.87773,0.46177,-0.1279],[0.11937,0.19451,-0.97361],[-0.33635,0.22544,-0.91435],[-0.09379,0.18036,-0.97912],[-0.19309,-0.97333,0.12384],[0.6353,-0.20025,0.74585],[0.006263,0.30587,-0.95205],[-0.12545,0.43605,-0.89114],[0.81511,-0.099628,0.57068],[0.18,0.21485,-0.95992],[-0.50601,-0.12707,0.85311],[-0.82459,-0.29241,0.4843],[-0.040356,0.27546,-0.96047],[0.91351,-0.053071,0.40333],[-0.33709,0.36804,-0.86656],[0.011689,0.4952,-0.8687],[-0.74836,0.6415,-0.16862],[0.021723,-0.99065,0.13472],[-0.68665,-0.13999,0.71339],[0.58538,-0.76314,-0.27374],[-0.95473,0.082844,0.2857],[0.53043,-0.2502,0.80996],[0.90371,0.072741,0.42193],[-0.93994,0.29491,0.17184],[0.72358,-0.12251,-0.67928],[0.21027,0.87387,0.43833],[0.67429,0.13442,-0.72613],[-0.78594,0.5958,-0.16529],[-0.8093,0.57851,-0.10178],[0.22101,0.62941,-0.74498],[-0.90936,0.31999,0.26583],[-0.29267,0.83916,-0.45842],[-0.1123,-0.66474,-0.73858],[-0.049735,-0.69579,-0.71652],[0.99991,-0.005103,-0.012527],[-0.026592,-0.73828,-0.67397],[0.01875,-0.7707,-0.63692],[0.076737,-0.69623,-0.7137],[-0.93832,-0.25926,0.22878],[0.17301,0.83108,0.52856],[-0.67777,0.72131,-0.1426],[0.54928,-0.442,0.70918],[-0.25383,-0.58984,-0.76659],[0.78752,0.53346,0.3086],[0.20137,-0.57842,-0.7905],[0.96892,0.15333,-0.19413],[-0.78651,0.22018,0.57699],[-0.30981,-0.40451,-0.86046],[-0.69657,-0.24255,0.67525],[-0.97565,0.099897,-0.19528],[0.33841,-0.51179,-0.78965],[0.37888,-0.30672,-0.87314],[0.65383,0.69566,0.29761],[-0.37758,-0.22298,-0.89873],[-0.83695,0.54697,-0.01847],[-0.4368,-0.12455,-0.8909],[0.43201,-0.14054,-0.89085],[-0.55751,0.091003,0.82517],[-0.46253,-0.009765,-0.88655],[0.54579,0.035497,-0.83717],[0.67148,0.66766,0.32146],[-0.97018,-0.17116,-0.1716],[-0.53689,0.1665,-0.82706],[0.52623,0.10695,-0.84359],[-0.17975,-0.13635,0.97422],[-0.49349,0.17745,-0.85146],[-0.82061,-0.24615,0.51577],[0.55405,0.81657,0.16203],[-0.20619,-0.89391,-0.39801],[-0.8448,-0.22177,0.48696],[0.47819,0.015946,-0.87811],[-0.2334,-0.87914,-0.41549],[-0.94971,-0.092105,-0.29928],[-0.91949,-0.045455,0.39047],[-0.88754,0.19908,0.41549],[-0.6517,0.13189,0.74692],[-0.38737,-0.82576,-0.40995],[0.41322,-0.82695,-0.38132],[-0.50978,-0.46606,0.72313],[0.48941,0.011965,-0.87197],[0.56574,-0.095866,0.81899],[0.46512,-0.3259,0.82307],[0.39557,-0.82374,-0.40618],[-0.93318,-0.17885,-0.31176],[0.184,-0.45314,-0.87224],[0.54519,-0.46146,0.69987],[-0.27428,-0.79659,-0.53872],[-0.30796,-0.82912,-0.4666],[-0.86784,0.45531,0.19885],[0.075243,-0.84406,0.53095],[0.34778,-0.81286,-0.46724],[-0.040162,-0.58449,-0.8104],[0.072535,-0.56366,-0.82281],[0.35334,-0.75998,-0.54551],[-0.045605,-0.53423,-0.84411],[-0.1892,-0.30604,-0.93303],[-0.35654,-0.91218,0.20202],[-0.60644,-0.32671,0.72491],[-0.11565,-0.42498,-0.89778],[0.70312,-0.34778,0.62022],[-0.61823,-0.66609,-0.41727],[0.66753,-0.53183,-0.52112],[0.69024,0.7196,0.075754],[0.52097,-0.27571,0.80782],[-0.96485,-0.24782,0.087499],[-0.27007,-0.72555,0.63296],[-0.77347,0.52214,0.35932],[0.72837,-0.34198,-0.59374],[0.74906,-0.38759,-0.5373],[-0.16339,-0.91974,0.3569],[0.66057,-0.56096,-0.49897],[0.57405,0.084653,0.81443],[-0.8507,-0.31661,-0.41961],[-0.70163,0.56261,0.43724],[-0.62173,-0.071045,0.78],[0.84993,0.31435,0.42284],[0.51378,-0.47871,0.71194],[0.85761,0.17383,0.48403],[-0.07084,-0.99303,-0.094177],[-0.022133,-0.99177,-0.12612],[-0.15231,-0.92451,-0.34942],[-0.48208,-0.6882,0.54219],[0.015012,-0.93504,-0.35423],[0.24694,-0.901,-0.35669],[-0.89898,-0.26887,-0.34577],[-0.2859,-0.69847,-0.65605],[0.80834,0.085482,0.58247],[0.11069,-0.85276,-0.51044],[0.44297,-0.7723,-0.45534],[0.11042,-0.91424,-0.38983],[-0.46829,-0.28087,0.83775],[0.88946,-0.074908,-0.45083],[-0.22106,-0.12641,-0.96703],[-0.86576,0.12183,0.4854],[-0.29749,-0.28838,-0.91013],[0.38393,-0.8056,-0.45123],[-0.48743,-0.8713,-0.056926],[0.8692,0.22458,0.44052],[-0.65461,-0.054745,0.75398],[-0.54981,-0.20126,0.81068],[-0.3875,0.79071,0.47394],[-0.84725,-0.29635,-0.44085],[-0.32603,0.084897,-0.94154],[-0.90762,-0.30401,0.2895],[0.16788,-0.96469,-0.20296],[0.2304,-0.95552,-0.18413],[0.58354,-0.38536,0.71483],[0.62617,-0.54479,0.55777],[-0.064808,-0.9934,-0.094624],[0.75103,-0.33389,0.56962],[0.44905,-0.48664,0.74936],[0.39355,-0.91195,-0.116],[-0.84599,-0.36305,-0.39051],[-0.5068,-0.63061,0.58778],[-0.40739,-0.091594,-0.90865],[-0.40435,-0.36838,-0.83714],[-0.95726,-0.16827,0.23525],[0.45246,-0.89163,0.016846],[-0.82984,0.24288,0.50237],[-0.2952,0.28693,0.91133],[0.37916,-0.4255,-0.8217],[-0.2741,-0.37502,-0.88557],[0.49679,-0.16475,0.85209],[0.59459,0.012426,0.80393],[-0.42771,-0.37747,-0.82133],[0.59846,-0.80066,0.028242],[-0.81517,-0.52156,-0.25195],[-0.99488,0.015598,-0.099852],[-0.87216,-0.46589,0.14928],[-0.16509,-0.38522,-0.90794],[-0.39877,-0.34363,-0.85024],[0.85446,0.51761,0.044424],[0.85962,-0.48019,0.17458],[0.22429,-0.5649,-0.79409],[-0.041657,-0.49587,-0.8674],[-0.36888,-0.34923,-0.86138],[0.68988,-0.71828,-0.090187],[-0.69641,-0.71405,0.071784],[0.82576,0.53594,-0.17576],[-0.72838,-0.68396,0.040856],[0.79701,0.5549,0.23843],[0.025504,-0.93241,-0.3605],[0.82263,-0.26866,0.50109],[0.45653,0.88879,-0.040282],[0.40439,-0.90907,0.10031],[-0.38952,0.26562,0.88189],[0.77592,-0.024607,-0.63035],[-0.67904,-0.73383,0.019739],[0.90208,0.3481,-0.25509],[-0.75458,-0.60969,0.24266],[0.95999,0.044793,0.27643],[-0.38579,-0.21758,-0.89656],[0.85027,0.21428,0.48076],[0.35815,-0.8838,0.30104],[0.50158,-0.67114,0.54589],[0.25848,-0.83044,0.49352],[-0.80215,0.29717,0.51793],[0.81732,0.50002,0.28631],[-0.39075,-0.012503,-0.92041],[0.65103,-0.62636,0.42877],[0.44979,-0.57727,0.6815],[-0.6458,-0.26551,0.71585],[-0.76027,0.52056,0.38859],[-0.84519,-0.41227,0.34012],[-0.80618,-0.51918,0.28376],[0.73897,-0.0099316,-0.67367],[-0.47924,0.093797,-0.87266],[-0.38771,0.10798,-0.91543],[0.42486,-0.89544,0.13299],[-0.63724,-0.76813,0.062363],[0.6346,0.05895,-0.77059],[0.55069,-0.77044,0.32119],[-0.52194,-0.4455,0.7274],[-0.34384,0.26902,-0.89967],[-0.27035,0.28572,-0.91939],[0.80992,0.53279,0.24528],[0.45344,-0.47186,0.75613],[-0.65993,0.71924,0.21722],[0.46281,0.27983,-0.84113],[0.030583,-0.97987,0.19726],[0.42785,-0.73256,0.52944],[0.69425,-0.68428,0.22311],[-0.86859,-0.07918,0.48916],[0.26681,0.33366,-0.90415],[-0.8277,-0.50903,0.23624],[-0.3546,0.38743,-0.85098],[0.17334,0.29564,-0.93944],[0.079042,0.17794,-0.98086],[0.33435,-0.92715,-0.16914],[0.92672,-0.061892,0.37063],[0.35583,-0.29136,-0.88797],[0.12169,-0.42432,-0.8973],[-0.93745,-0.044445,0.34528],[0.10523,-0.21743,-0.97039],[0.60419,-0.15086,0.78243],[-0.063215,-0.42375,-0.90357],[-0.044971,-0.56772,-0.82199],[-0.61062,0.065494,0.78921],[-0.59832,0.80121,0.0089339],[0.099505,-0.67813,-0.72817],[0.18571,-0.86048,-0.47444],[-0.36337,-0.068412,-0.92913],[0.78066,-0.55229,0.29249],[-0.90077,-0.38525,0.20048],[-0.34314,-0.24129,-0.90776],[0.79282,-0.26685,0.54794],[-0.40692,-0.28107,-0.86915],[-0.74927,-0.41459,0.51644],[0.83611,-0.096817,0.53995],[-0.39464,0.90707,-0.14659],[0.92135,0.015534,-0.38843],[-0.29925,-0.17488,-0.93801],[0.62647,0.11967,0.77021],[0.73002,-0.50519,0.46028],[0.82356,-0.37856,0.42243],[-0.72622,0.12831,0.67538],[-0.8567,-0.24001,0.45657],[0.82473,-0.22185,0.5202],[0.92095,0.017017,-0.38931],[-0.23688,0.59123,-0.77093],[0.57313,-0.74823,0.33417],[0.76729,-0.16932,0.61855],[-0.5612,0.17776,0.80837],[-0.79687,-0.24735,0.5512],[-0.42568,0.81883,-0.38512],[0.78806,-0.50645,0.34995],[0.31322,0.52688,-0.79012],[-0.81955,-0.46115,0.34012],[-0.84387,0.51354,-0.15542],[-0.43024,0.29218,0.85412],[0.50925,0.54326,-0.66748],[0.71298,-0.16532,0.68142],[-0.26583,0.51516,-0.81483],[0.25605,-0.96554,-0.046551],[-0.64735,-0.027553,0.7617],[0.0063827,0.61542,-0.78817],[-0.40923,0.024572,0.9121],[0.3588,-0.56466,-0.74325],[0.8901,0.046795,-0.45335],[-0.96846,0.24917,0.0024963],[0.026691,-0.93334,0.358],[-0.16896,-0.82449,0.54006],[0.58121,0.60056,-0.54912],[-0.53365,0.44737,-0.71769],[0.56735,-0.02954,0.82294],[-0.67296,-0.63761,0.37494],[-0.97235,0.19075,0.13474],[-0.3417,0.33153,0.87939],[-0.79363,0.29214,-0.53367],[-0.7298,-0.25086,0.63597],[0.77316,-0.015084,0.63403],[-0.24482,0.23114,0.94162],[0.87342,-0.46119,0.15637],[0.33813,0.82721,-0.44877],[-0.75261,-0.53759,0.38023],[-0.3182,0.54922,0.77273],[-0.66995,-0.36429,0.64688],[-0.37727,0.66252,0.6471],[-0.75179,0.38874,-0.53263],[0.70145,0.70101,0.12862],[0.84018,0.31557,-0.44104],[0.83771,0.20268,0.50712],[0.40466,0.77558,-0.48449],[0.55565,-0.097744,0.82565],[-0.24884,0.87883,0.4071],[0.15244,0.94481,-0.28999],[-0.77492,0.56525,0.28283],[-0.51165,0.82743,-0.23146],[0.067124,0.97841,-0.19549],[-0.86761,-0.32773,0.37396],[-0.85437,0.25016,-0.45549],[-0.75818,0.59043,-0.27668],[-0.70975,0.22374,0.66798],[-0.44847,0.8504,-0.27514],[0.17227,0.98258,0.069784],[0.60541,-0.42114,0.67537],[-0.6342,0.41419,0.65287],[-0.063673,0.99657,-0.052806],[-0.039632,0.99886,-0.026721],[-0.742,0.40808,-0.5319],[0.72289,-0.68976,0.04071],[-0.65365,0.53077,-0.53947],[-0.8152,-0.2714,0.51165],[-0.5402,0.49705,0.67906],[0.74936,-0.45251,0.48342],[0.85199,0.30128,0.42819],[-0.54581,0.65196,-0.52634],[0.92244,0.21315,0.32198],[0.93136,0.36398,0.0096238],[0.69791,-0.71269,0.070667],[-0.63678,-0.70095,0.32122],[-0.35092,0.70404,-0.61741],[-0.18081,0.7988,-0.57379],[-0.52881,0.23158,0.81654],[-0.63823,0.57822,0.50826],[0.85687,0.46971,0.21249],[0.33804,-0.74123,0.57992],[0.88371,-0.46593,0.044212],[-0.13605,-0.97194,0.19189],[0.63469,0.62927,-0.44855],[0.9686,0.059757,-0.24134],[0.20629,-0.23225,0.95053],[-0.51194,-0.85585,-0.073792],[0.6368,0.72478,-0.26301],[0.39006,0.73551,-0.55397],[-0.60823,-0.23112,0.75937],[-0.53065,0.7596,-0.37606],[-0.46381,-0.27639,0.84172],[-0.3244,0.73981,0.58944],[0.86353,-0.22238,0.45262],[-0.77281,-0.56686,0.28538],[0.63884,0.75743,0.13487],[0.70538,0.064319,0.7059],[-0.70996,0.64831,-0.27505],[0.76052,-0.26232,0.59396],[-0.05005,-0.92059,0.38732],[-0.17702,0.69926,0.6926],[-0.82509,0.13953,0.5475],[-0.27389,0.6257,0.7304],[-0.6939,-0.0085193,0.72002],[0.20548,0.6838,0.70014],[-0.16503,-0.95333,0.25284],[0.54649,0.60365,-0.58047],[0.16025,0.10785,0.98117],[0.47123,-0.882,0.0037087],[-0.35557,-0.92676,0.12122],[0.65341,0.10367,0.74988],[-0.28203,0.6663,0.69029],[0.20727,0.59606,0.77572],[0.13468,0.65015,0.74777],[0.76645,-0.069549,0.63853],[0.09597,0.7014,0.70628],[-0.58645,0.14111,0.7976],[-0.06745,0.90361,0.42302],[-0.74685,-0.026004,0.66448],[0.88043,0.47111,0.053944],[0.0086763,0.66579,0.74609],[-0.29888,0.21448,0.92988],[-0.75124,0.55258,-0.36097],[-0.41677,0.0098399,0.90896],[0.78744,0.60291,0.12821],[0.49743,-0.86671,-0.037138],[0.94356,0.21562,-0.25138],[-0.68571,0.15761,0.7106],[-0.66079,0.66425,-0.34947],[-0.91008,-0.40032,0.10725],[-0.65944,0.65348,-0.37163],[0.96096,0.2543,-0.10901],[-0.85032,-0.30253,0.43062],[-0.80748,0.51574,-0.28634],[0.88068,0.46237,0.10306],[0.49027,0.70089,0.51806],[0.92968,-0.077815,0.36006],[0.77134,0.63074,0.08487],[-0.58656,0.79925,-0.13099],[0.49186,-0.048972,0.8693],[0.68431,-0.71859,0.12386],[0.5411,0.35685,0.76149],[0.92232,0.27169,-0.27479],[0.84941,0.37336,0.37297],[-0.7142,0.64647,-0.26833],[-0.63131,-0.15948,0.75895],[-0.67677,0.67751,-0.28804],[-0.71176,0.66942,-0.21279],[-0.90342,0.42499,0.056668],[-0.69326,0.067959,0.71747],[0.74586,0.62574,-0.22835],[-0.6473,0.19658,-0.73645],[-0.20074,-0.096315,0.9749],[-0.51483,0.76864,-0.37965],[-0.33148,0.12182,-0.93556],[0.55971,0.70733,-0.43176],[-0.48401,0.78818,0.38015],[-0.33439,0.80008,-0.49804],[-0.41614,0.21888,0.88256],[-0.37667,0.24557,-0.89321],[0.69123,-0.59208,0.41429],[0.40143,0.55248,0.73049],[0.55644,0.54793,-0.62462],[-0.40143,0.087267,-0.91172],[-0.41533,0.076726,-0.90643],[0.41224,0.73585,-0.5372],[-0.76397,-0.5006,-0.40711],[0.90394,0.41321,-0.11028],[0.20101,0.49473,-0.84548],[0.37248,0.34414,-0.86188],[-0.73073,0.61179,-0.30289],[-0.41743,0.030107,-0.90821],[0.32053,0.35499,-0.8782],[0.56923,0.43993,0.69458],[0.30009,0.12864,-0.9452],[-0.63983,-0.18743,0.74531],[-0.59545,0.22198,-0.77211],[-0.3966,0.2005,-0.89583],[0.1576,0.099594,-0.98247],[0.35909,0.084784,-0.92944],[0.15283,0.26731,-0.95141],[0.18612,0.14718,-0.97144],[0.3738,0.039583,-0.92666],[-0.33177,0.37775,-0.86443],[0.0093921,0.21036,-0.97758],[-0.3913,0.41027,-0.82375],[-0.30312,0.54245,-0.7835],[0.16054,0.30144,-0.93987],[0.21206,0.35279,-0.91136],[0.27249,0.27007,-0.92348],[0.86797,0.040498,0.49497],[0.45549,0.19482,-0.86866],[0.85927,0.47057,-0.20052],[0.11739,0.41866,-0.90052],[0.31901,-0.42759,0.84581],[-0.94893,0.31262,0.042556],[0.28616,0.47356,-0.83298],[-0.19676,0.57634,-0.79317],[0.13092,0.54195,-0.83015],[-0.80972,-0.12356,0.57366],[-0.42624,0.42377,0.79921],[-0.30484,0.52295,-0.79599],[-0.57973,-0.038553,0.81389],[0.27099,0.44041,-0.85592],[-0.95521,0.26824,0.12497],[0.27831,0.62583,0.72862],[0.085466,0.44683,-0.89053],[-0.13916,0.5014,-0.85395],[-0.06813,-0.91325,-0.40167],[0.10037,0.71151,0.69547],[-0.038142,0.63812,-0.76899],[0.50569,0.42218,0.75236],[0.10473,0.64708,-0.75519],[-0.63639,0.18756,0.74822],[-0.65728,-0.67227,0.34064],[0.16999,-0.98237,0.077826],[0.37114,-0.92712,-0.052059],[0.6828,-0.62363,-0.38061],[0.7672,-0.33082,-0.54951],[0.40755,0.35286,0.84225],[-0.96504,0.25696,0.051655],[0.76654,-0.063078,-0.63909],[-0.89608,0.44257,0.03418],[-0.78712,0.61123,0.082704],[-0.65547,0.72744,-0.20294],[0.44683,0.49553,-0.74484],[0.50325,-0.82813,0.24685],[0.049235,0.6008,0.79788],[-0.045776,-0.80798,-0.58743],[-0.08721,0.73091,0.67688],[-0.95893,0.25592,0.12232],[-0.77342,-0.33589,0.53758],[-0.86626,-0.47499,-0.15487],[0.025889,-0.69768,-0.71594],[0.064542,-0.74848,-0.66001],[0.10023,-0.77494,-0.62403],[0.77725,0.12363,0.61693],[-0.19604,-0.75207,-0.62925],[-0.79023,0.57896,-0.20085],[-0.10705,-0.80603,-0.58211],[0.52292,-0.80677,0.27507],[0.24795,-0.71274,-0.65614],[0.75052,-0.65502,0.087592],[-0.27496,-0.76024,-0.58858],[-0.85326,-0.43632,-0.28562],[0.6297,-0.018718,0.77661],[-0.43634,-0.42654,-0.79226],[0.65339,-0.020423,0.75674],[0.54539,0.23001,0.80601],[0.50641,-0.31886,-0.80117],[-0.4823,-0.011986,-0.87593],[-0.96075,0.2376,0.14319],[0.56432,-0.13572,-0.81433],[-0.54417,0.14653,-0.82608],[-0.054873,0.71781,0.69407],[-0.93151,-0.29802,-0.20852],[-0.54218,0.11467,-0.8324],[0.90369,-0.0034697,0.42818],[0.51337,0.034781,-0.85746],[0.82256,-0.56036,0.09688],[0.18572,-0.9335,-0.30673],[-0.51675,0.38145,0.76647],[-0.038945,-0.91009,-0.41257],[-0.42628,0.8577,0.28746],[0.31887,-0.87957,-0.3531],[-0.18964,-0.86516,-0.46425],[0.40132,0.33834,0.85116],[-0.85682,-0.43146,-0.28232],[-0.4754,0.087134,-0.87545],[0.038166,-0.51189,-0.8582],[-0.14015,-0.77423,-0.6172],[0.69928,0.2428,0.67235],[-0.034069,-0.4978,-0.86662],[-0.28974,-0.15505,-0.94446],[-0.41738,0.27451,0.86628],[-0.52582,-0.74372,-0.41279],[0.24542,-0.68279,-0.68817],[-0.19616,-0.22849,-0.95358],[-0.54654,-0.72763,-0.41454],[-0.16136,0.69115,0.70446],[-0.32567,0.2948,0.89835],[0.81166,-0.58267,-0.041261],[-0.17276,0.70043,0.6925],[-0.52256,0.83997,-0.14626],[0.70758,0.1565,0.68909],[0.86731,0.42428,-0.2603],[-0.66974,-0.63505,-0.38491],[0.87381,0.37822,-0.30562],[-0.82672,-0.36946,-0.42431],[-0.84405,-0.32401,-0.42731],[-0.94052,0.19331,0.27939],[0.69049,-0.71099,-0.13312],[-0.84083,0.4633,0.27992],[-0.42207,0.6343,0.64771],[-0.58608,-0.71871,-0.37411],[0.61183,-0.64733,-0.45456],[0.74138,-0.43578,-0.51035],[-0.83026,-0.38289,-0.40504],[-0.48044,0.29123,0.82726],[0.80119,-0.32404,-0.50309],[-0.68311,-0.71851,0.13079],[0.93443,0.14933,-0.32332],[-0.90506,-0.26932,-0.32913],[0.38401,0.19717,0.90203],[0.94504,0.18602,0.26888],[0.89983,-0.030818,-0.43515],[0.63173,0.19551,0.75013],[-0.11201,-0.8696,-0.48088],[-0.25072,-0.96608,0.061818],[-0.22277,-0.89859,-0.37802],[0.19129,-0.89545,-0.40197],[0.46401,-0.30447,0.83186],[-0.12794,0.41664,0.90002],[-0.60707,0.3599,0.70848],[-0.33627,-0.41248,-0.84663],[-0.13278,-0.50657,-0.85191],[-0.12931,-0.73071,-0.67033],[0.8524,0.45576,-0.25631],[-0.070911,-0.65513,-0.75218],[0.46997,-0.81138,-0.34757],[-0.61096,0.317,0.72542],[-0.43049,-0.88435,-0.18058],[-0.33635,-0.9417,-0.0079474],[0.030241,-0.90545,-0.42337],[0.42311,-0.83744,-0.34593],[-0.32012,0.055251,-0.94576],[-0.093557,-0.97493,0.2019],[-0.07795,-0.98228,0.17046],[-0.089938,-0.99392,0.063486],[0.16333,-0.98121,0.10269],[-0.06167,0.70263,0.70888],[-0.52327,0.4014,0.75171],[-0.61628,-0.50056,-0.60799],[-0.39742,0.24855,-0.88334],[-0.79879,0.35689,0.48432],[0.36979,-0.92551,-0.081836],[0.70612,0.17773,0.68543],[-0.78279,-0.60608,-0.14108],[-0.65729,-0.75359,0.0086461],[0.93491,-0.34542,-0.081366],[0.45206,-0.70656,-0.54443],[-0.39848,-0.56238,-0.72453],[-0.3729,0.50215,0.78025],[0.49216,0.13823,0.85946],[0.86539,-0.15476,-0.4766],[0.001103,0.2743,0.96164],[0.43141,-0.57852,-0.69224],[0.3915,-0.53002,-0.7522],[0.20483,-0.14681,0.96773],[-0.26073,-0.49162,-0.83086],[-0.38507,0.50232,0.77421],[0.76002,-0.1366,-0.63539],[-0.36526,-0.41018,-0.83567],[0.019272,-0.99898,-0.040928],[0.6749,0.72578,-0.13327],[0.55443,0.82405,-0.11643],[0.90085,0.24041,0.36148],[-0.3455,-0.39841,-0.84965],[0.58235,0.093026,0.8076],[-0.061765,-0.98312,0.17223],[-0.64423,0.73783,-0.20144],[-0.35963,-0.22678,-0.90512],[-0.58532,0.42611,0.68981],[0.22251,-0.95854,0.17801],[0.20966,-0.94494,0.25126],[0.52362,-0.84128,0.13443],[-0.34822,-0.12702,-0.92877],[-0.36427,-0.050271,-0.92993],[0.62236,0.25936,0.73852],[-0.90603,-0.37537,-0.19549],[-0.60269,0.77526,-0.18904],[-0.34276,0.098932,-0.9342],[-0.37736,0.10099,-0.92054],[0.49267,-0.77494,0.39592],[-0.31997,0.1824,-0.9297],[-0.86784,0.36873,0.33299],[-0.66618,0.73348,0.13494],[0.74069,-0.66879,0.06402],[-0.46586,0.22529,-0.8557],[-0.32258,0.37899,0.86736],[0.55801,-0.74596,0.36355],[0.28664,-0.0018505,-0.95804],[0.30316,-0.22459,-0.9261],[-0.88857,0.35779,0.2871],[-0.46221,0.41379,-0.78431],[0.68884,0.20875,0.69421],[0.066071,-0.32109,-0.94474],[0.25659,-0.41932,-0.87083],[-0.89963,0.19201,0.39217],[-0.89911,-0.42417,0.10809],[0.23435,0.07966,-0.96888],[0.53905,-0.258,-0.80178],[-0.38307,0.29839,-0.8742],[-0.83725,0.067801,0.5426],[-0.77252,0.0076252,0.63495],[0.55708,0.82916,-0.046377],[0.76725,-0.24364,-0.59327],[-0.85251,-0.060079,0.51924],[-0.36311,0.2142,-0.90679],[-0.78109,0.52476,0.33842],[0.84091,-0.13069,-0.52515],[-0.39087,0.054661,-0.91882],[-0.3688,-0.13191,-0.9201],[-0.37271,-0.37389,-0.84929],[-0.38175,-0.38734,-0.83919],[0.46142,0.5118,0.72467],[-0.82076,0.082407,0.5653],[0.49851,0.45652,0.73694],[-0.44965,-0.079283,-0.88968],[-0.25374,0.12928,-0.95859],[0.7918,-0.22467,0.56795],[-0.36545,0.3784,-0.85045],[-0.23733,0.46286,-0.85407],[-0.18956,0.40346,-0.89515],[-0.50812,0.29964,0.80748],[-0.083836,0.71444,-0.69465],[0.61915,-0.77933,0.09638],[-0.33948,0.88106,-0.32937],[-0.36904,0.88653,-0.27908],[0.70854,0.13818,0.69201],[0.55397,-0.82812,0.085643],[-0.5832,0.8039,-0.11668],[-0.48614,0.77727,-0.39939],[0.80664,0.57208,-0.1485],[-0.5826,0.39339,0.71121],[0.88233,0.24799,0.39998],[0.61248,0.78753,-0.06832],[0.83982,0.51897,-0.15927],[0.74624,-0.20106,0.63458],[0.10886,0.25121,0.96179],[-0.34331,-0.3611,0.86703],[0.36211,0.6504,-0.66772],[-0.84348,0.32045,0.4311],[-0.83264,0.3791,0.40372],[-0.5139,0.46498,0.7209],[0.43932,0.76985,-0.46296],[-0.45419,0.48823,0.74521],[-0.48233,0.58798,-0.64934],[0.056709,-0.9893,0.13442],[0.87107,0.19879,-0.44913],[-0.95989,0.15032,0.23667],[-0.91171,0.3002,0.28047],[0.84283,-0.28794,0.45468],[0.43017,0.83639,-0.3397],[-0.71948,0.371,-0.58712],[0.58547,-0.13291,0.79973],[-0.90072,0.34521,0.26368],[-0.19489,0.97931,0.054477],[-0.42154,0.73739,0.52779],[-0.71999,0.63701,0.27537],[-0.11914,0.99193,0.043396],[-0.6118,0.78052,-0.12838],[-0.8369,-0.0205,0.54697],[-0.36678,0.81865,0.4419],[-0.88624,0.3865,0.25533],[0.39812,0.77049,-0.49784],[0.76645,0.59495,0.24205],[0.79249,0.167,0.58658],[-0.58287,0.80462,0.1134],[0.31309,0.90615,-0.28437],[0.4407,0.81008,-0.38672],[-0.83959,0.29145,-0.45841],[-0.58868,0.61303,0.52692],[-0.65116,0.74067,-0.16553],[-0.86271,0.10802,0.49402],[0.70354,0.57274,-0.4207],[0.0076273,0.99337,-0.11475],[0.098654,0.99429,-0.040739],[0.46181,0.39448,0.79443],[-0.49684,0.46745,0.7312],[0.93619,0.27165,0.22307],[0.090551,0.99378,-0.064833],[-0.89739,0.10689,0.42809],[0.67705,0.65704,-0.33151],[0.7345,0.66509,-0.13477],[0.94479,-0.034773,0.32583],[-0.85312,-0.054001,0.51891],[-0.84238,0.52018,0.14077],[-0.64314,0.65869,0.3905],[-0.67172,0.72118,-0.16938],[0.84292,0.41571,0.34158],[0.98039,0.19676,0.011234],[0.80582,0.55552,-0.20506],[-0.89834,-0.14958,0.41304],[-0.27256,0.82211,-0.49985],[0.70823,0.61732,-0.34254],[0.62641,0.078627,0.77552],[0.64382,0.68332,-0.34434],[-0.50996,0.62824,0.58759],[-0.76779,0.57058,-0.29144],[0.38982,0.29464,0.87248],[-0.4615,0.62742,0.62719],[0.83166,0.44326,0.33447],[0.92085,0.022247,0.38928],[0.75778,0.61603,0.21513],[-0.79722,0.59573,0.09767],[-0.31893,0.91102,0.26139],[0.86456,-0.24857,0.43675],[-0.25466,0.76739,0.58844],[-0.81237,0.50035,0.29951],[0.028418,0.75854,0.65101],[-0.33732,0.83934,0.42628],[0.53621,0.79174,0.29262],[-0.35112,0.73862,0.57546],[-0.39595,0.66022,0.63823],[-0.62911,0.75406,0.1887],[0.24733,0.4656,0.84973],[0.04879,0.61706,0.7854],[0.10823,-0.49847,0.86013],[-0.0057503,0.63692,0.77091],[-0.24574,0.88731,0.39026],[-0.62614,0.76325,0.15935],[0.22604,0.85131,0.47347],[-0.43806,0.84296,-0.31228],[-0.72977,0.59169,-0.34255],[-0.0052223,0.59685,0.80234],[0.17778,0.53381,0.8267],[-0.85215,-0.33118,0.40518],[0.30037,0.95382,0.00018881],[0.43877,0.28923,0.85078],[-0.90088,0.42668,0.079734],[-0.69728,0.57824,-0.42359],[0.83853,0.53642,0.095464],[-0.76205,0.60878,0.22058],[-0.72487,0.57511,-0.37923],[0.82232,0.56901,0.0039152],[-0.90896,0.40042,0.11602],[-0.75647,0.54746,-0.35783],[0.79048,0.58659,-0.17622],[0.57555,0.81264,-0.09139],[0.92339,0.3831,-0.024237],[-0.82768,-0.38326,0.40995],[0.92162,0.36428,0.13386],[-0.773,0.63341,0.035493],[0.60553,0.74017,0.29235],[0.93654,0.33599,0.10001],[-0.47202,0.43677,0.76579],[0.86187,0.50316,-0.063354],[0.83262,0.54093,-0.11888],[-0.20526,0.97861,-0.013891],[0.5812,0.81315,-0.031497],[-0.55082,0.5185,-0.65404],[-0.67114,0.48182,-0.5634],[0.90284,0.044069,0.4277],[0.78519,0.56599,-0.25126],[-0.74616,0.42061,-0.51607],[0.68616,0.7047,-0.18054],[-0.63463,0.51974,-0.57194],[-0.69073,0.64111,-0.33447],[0.094316,0.16942,0.98102],[0.46881,0.83452,0.28947],[0.60199,0.64094,-0.47624],[-0.54175,0.16412,-0.82436],[0.62298,0.60013,-0.50175],[-0.58899,0.16722,-0.79065],[-0.34425,-0.09471,-0.93409],[0.19713,0.64182,0.74109],[-0.27972,-0.037375,-0.95935],[-0.39375,0.17562,-0.90229],[0.56661,0.4551,-0.6869],[-0.24528,-0.12583,-0.96125],[-0.17258,-0.042563,-0.98408],[-0.24982,-0.1026,-0.96284],[0.45808,0.44054,-0.77207],[-0.20654,-0.0084053,-0.9784],[0.48906,0.61235,-0.62116],[0.45464,0.70815,-0.54021],[-0.37096,0.06586,-0.92631],[-0.15233,0.035954,-0.98768],[-0.046916,0.070289,-0.99642],[0.36428,0.28443,-0.88679],[-0.36437,0.2544,-0.89583],[-0.079742,0.15958,-0.98396],[0.24125,0.055488,-0.96888],[0.21483,0.94714,0.23826],[-0.10224,0.23528,-0.96654],[0.0084778,0.18298,-0.98308],[0.84819,0.0089343,0.52962],[0.2105,0.013614,-0.9775],[-0.33039,0.43412,-0.83808],[-0.46195,0.88627,0.033552],[-0.19672,0.38903,-0.89997],[-0.66657,0.28467,-0.68894],[0.15618,0.29585,-0.94238],[0.12067,0.13258,-0.9838],[-0.14935,0.55222,-0.82021],[-0.21049,0.97463,0.076134],[0.083999,0.23587,-0.96815],[0.18664,0.11318,-0.97589],[0.23538,-0.10598,0.96611],[0.38275,0.13205,-0.91437],[0.058468,0.25239,-0.96586],[-0.83431,0.44019,0.3319],[-0.027835,0.4411,-0.89702],[0.52075,0.49596,0.69487],[-0.549,0.43,0.71672],[-0.55114,0.51335,-0.65781],[0.44839,0.31489,-0.83653],[-0.043971,0.99831,-0.03797],[0.52706,0.45418,-0.71828],[-0.34041,0.692,-0.63659],[0.18139,0.59182,-0.7854],[0.82848,-0.02255,0.55956],[0.42382,0.24685,0.87146],[-0.052799,0.77069,-0.63502],[-0.34211,0.64774,-0.68073],[-0.5699,0.81735,0.084505],[-0.26148,0.73572,-0.62478],[0.3172,0.61935,-0.71819],[-0.0092031,0.7059,-0.70825],[0.90439,-0.26609,0.33358],[-0.064614,0.6972,-0.71395],[0.44232,0.77225,0.45605],[0.5005,0.653,0.56841],[-0.46004,0.65488,0.59958],[0.84467,-0.17538,0.50574],[0.38552,0.86101,0.33171],[-0.0027601,0.77163,-0.63607],[0.30757,0.90468,0.29487],[0.22239,0.78312,-0.58074],[-0.77468,0.62847,-0.069946],[0.65222,0.69319,0.30675],[0.20744,0.62267,-0.75449],[0.87873,0.36294,0.31001],[-0.45338,-0.83986,0.29846],[-0.091913,-0.97927,0.18048],[0.78077,-0.27883,0.55915],[-0.91958,-0.27461,0.28098],[-0.99232,0.10098,0.071459],[-0.61021,0.63153,0.47835],[-0.7847,0.61871,0.038019],[-0.82317,0.56707,0.028679],[0.00090893,-0.66909,0.74318],[0.7639,0.073507,-0.64113],[0.13559,0.78913,-0.59907],[0.59337,0.42522,-0.68345],[-0.23531,0.86369,-0.44571],[0.45272,0.76674,0.45514],[-0.10014,-0.72436,-0.68211],[-0.14887,-0.97863,-0.14182],[-0.044042,-0.72321,-0.68922],[-0.008495,-0.70818,-0.70598],[-0.90329,0.070349,0.42321],[0.21391,-0.74695,-0.62953],[0.3231,-0.73052,-0.60162],[-0.36463,-0.63688,-0.67929],[0.44771,-0.54081,-0.71209],[-0.65431,0.75581,-0.025096],[0.26515,-0.96421,-0.0006657],[0.551,-0.40672,-0.72868],[0.46367,0.54013,0.70233],[-0.63145,-0.20662,-0.74738],[0.56928,-0.16413,-0.80559],[-0.59231,0.13293,-0.79467],[-0.74395,-0.5527,0.37558],[-0.01817,-0.99781,0.063651],[-0.7802,-0.16585,0.60314],[0.59245,-0.039031,-0.80466],[0.63081,0.096208,-0.76995],[-0.613,0.19348,-0.76603],[-0.69827,0.71583,-0.004124],[0.60118,0.040619,-0.79808],[0.6299,0.036785,-0.7758],[0.40355,-0.20154,0.89248],[-0.84157,0.12549,0.52537],[-0.013348,-0.94476,-0.32749],[0.16902,-0.93072,-0.32433],[-0.45944,0.74251,0.48743],[-0.17998,-0.90796,-0.37844],[0.16338,-0.86629,-0.47207],[-0.43196,-0.81175,-0.39303],[0.1181,-0.67576,-0.7276],[-0.52029,0.49915,0.69293],[0.36004,-0.37619,-0.85373],[0.186,-0.54279,-0.81901],[-0.96503,0.16899,-0.20041],[-0.15934,-0.86406,-0.47751],[0.36724,-0.8089,-0.45914],[0.68748,-0.63849,0.34597],[-0.017589,-0.50421,-0.8634],[0.84946,-0.18289,0.49495],[-0.22058,-0.27993,-0.93434],[0.40067,0.84607,0.3516],[-0.63641,0.76016,0.13092],[-0.67523,-0.63835,0.36957],[0.58938,-0.6017,-0.53906],[0.89152,0.069491,0.44762],[-0.31513,-0.94739,0.05609],[-0.19523,-0.97017,0.14373],[-0.73818,0.66639,0.1049],[0.64908,-0.52226,-0.55313],[0.81461,0.33867,0.47087],[-0.96239,0.2714,-0.012493],[-0.27302,-0.93707,0.21762],[-0.77652,-0.441,-0.45005],[0.72279,-0.4929,-0.48438],[0.79408,-0.46635,-0.38981],[-0.088031,-0.99586,0.022487],[-0.41838,-0.90609,0.062932],[-0.44465,-0.84358,-0.30109],[0.64905,-0.59425,-0.47498],[0.062179,-0.98187,-0.17907],[-0.30318,-0.95267,0.022251],[0.76694,-0.38866,-0.51063],[0.19577,0.29513,0.93519],[0.97631,0.15021,0.15572],[0.14407,-0.89825,-0.4152],[0.599,-0.6543,-0.46162],[-0.020608,-0.99562,0.091158],[-0.63155,-0.68697,-0.35946],[0.82303,0.34741,0.44937],[0.90543,0.28091,0.31825],[-0.22542,-0.013688,0.97417],[-0.91484,-0.27308,-0.2975],[0.87381,0.064428,0.48199],[-0.90709,0.011739,0.42078],[-0.12398,-0.72599,-0.67644],[0.86247,0.023795,0.50555],[0.91052,-0.10405,-0.40017],[0.063468,-0.95245,-0.298],[0.38021,-0.87958,-0.28598],[-0.78903,-0.41275,0.45504],[-0.076825,-0.96194,-0.26223],[0.18086,-0.95017,-0.25389],[-0.22949,-0.80808,-0.54253],[-0.33537,-0.76204,-0.55391],[0.19078,0.42741,0.8837],[-0.16226,-0.93276,-0.3219],[0.047201,-0.84439,-0.53365],[0.037185,-0.79736,-0.60236],[-0.17336,-0.86379,-0.47309],[0.056227,0.31146,0.94859],[-0.19019,-0.97868,0.077578],[-0.32414,-0.90712,-0.26847],[0.27218,-0.91648,-0.29321],[0.83247,-0.41892,0.36263],[0.14406,-0.90177,-0.4075],[-0.066552,-0.98503,-0.15901],[0.16776,-0.97603,0.13867],[0.3803,-0.87291,-0.30563],[-0.42483,0.21279,-0.87991],[0.2761,-0.929,-0.24642],[0.19932,-0.95539,0.21796],[0.099599,0.23506,0.96686],[-0.8649,0.042512,0.50014],[0.45225,-0.7635,-0.46102],[-0.77919,-0.46977,-0.41494],[-0.4042,0.38316,-0.83055],[0.33793,0.078341,0.93791],[-0.39703,0.29099,-0.87045],[0.98751,-0.13678,0.078162],[0.63273,-0.57185,0.52215],[-0.27156,-0.9103,0.31242],[-0.067491,-0.91193,0.40476],[0.1744,-0.96914,0.17421],[-0.98029,-0.19164,0.048106],[0.35089,-0.72578,-0.59171],[0.98884,0.12346,0.083385],[0.75979,-0.46584,0.45356],[-0.35923,-0.70595,-0.61039],[-0.49062,-0.68145,-0.54307],[-0.72331,-0.38282,0.57469],[-0.37306,-0.90191,0.21769],[0.40464,-0.69779,-0.59107],[0.70464,-0.43201,0.56289],[-0.26572,0.24285,0.93296],[-0.28494,-0.67813,-0.67745],[-0.91549,0.39252,-0.088363],[-0.49547,0.81297,0.30593],[-0.43283,-0.11838,-0.89367],[0.75514,0.28287,0.59139],[0.45482,-0.88927,-0.048312],[0.51299,0.24773,0.82187],[-0.8431,-0.37936,-0.38114],[-0.15186,-0.64179,-0.75169],[-0.93232,0.35966,-0.037779],[0.98969,0.14185,-0.019995],[-0.38727,-0.92196,0.0049429],[-0.19732,-0.013718,0.98024],[-0.9919,-0.092441,0.087064],[0.99991,-0.013214,-0.00045942],[0.60074,-0.78199,0.16611],[-0.87081,-0.36628,-0.32791],[-0.34845,-0.41281,-0.84153],[0.763,-0.64635,-0.007574],[0.97716,-0.21251,-0.0016327],[0.56519,-0.80068,-0.19869],[0.0068369,-0.99928,-0.037244],[0.12049,-0.94186,0.31367],[0.079353,-0.92811,0.36376],[-0.82234,-0.55772,0.11272],[-0.35546,-0.28746,-0.88939],[0.28242,-0.89383,0.34828],[0.078568,-0.41427,0.90676],[-0.92792,-0.3651,0.075333],[-0.33974,-0.33305,-0.87958],[0.63764,-0.68738,0.34774],[0.63459,0.2232,0.73992],[-0.83645,-0.5249,0.15762],[-0.4146,-0.19685,-0.88846],[-0.3111,-0.18823,-0.93155],[0.44377,-0.51965,0.73009],[0.59845,-0.053772,-0.79936],[-0.61822,0.0040667,0.78599],[0.35697,-0.55965,0.74791],[-0.77595,-0.47714,0.41259],[-0.1075,-0.98505,-0.13464],[-0.31645,0.09183,-0.94416],[0.91285,-0.20059,0.35562],[-0.11911,0.49882,0.85848],[-0.32727,-0.92258,0.20432],[0.37753,-0.87194,0.31177],[-0.78417,0.1557,0.60069],[-0.83255,-0.3239,0.44939],[0.54622,-0.10529,-0.831],[0.83227,-0.53603,0.1414],[-0.39966,0.17486,-0.89983],[0.43131,-0.24737,0.86763],[-0.16359,0.60228,0.78135],[0.41886,-0.81212,0.40621],[-0.2811,-0.94895,0.14307],[0.52599,-0.12389,-0.84142],[-0.60399,0.41528,0.68025],[0.22422,-0.16473,-0.96051],[0.51306,-0.69904,0.49811],[-0.784,0.011507,0.62066],[0.12343,0.72532,0.67726],[-0.88311,-0.29438,0.36531],[0.26683,-0.21082,-0.9404],[-0.32112,0.36182,-0.87519],[0.9432,-0.20798,0.25907],[-0.29126,0.36802,-0.88303],[0.52988,-0.7427,0.40941],[0.51749,-0.045168,-0.85449],[-0.42992,0.43341,-0.79204],[-0.86829,0.0045419,0.49604],[0.79854,-0.58248,0.15185],[0.62607,-0.057265,-0.77766],[-0.35655,0.34804,-0.86703],[-0.80105,-0.57852,0.15371],[-0.76379,0.60513,0.22459],[0.77215,-0.47938,0.4171],[0.81945,-0.54415,0.17999],[0.45156,-0.87953,-0.15005],[-0.45791,0.016631,-0.88884],[0.78487,0.056724,-0.61705],[-0.43181,-0.36357,-0.82544],[0.70091,-0.66648,-0.25402],[-0.453,-0.43774,-0.77664],[0.78987,0.09788,0.60541],[-0.75367,0.13277,0.6437],[0.75824,-0.13711,0.6374],[-0.39375,0.42521,-0.81495],[0.99511,0.098501,0.007855],[-0.31911,0.57508,-0.75329],[-0.13054,0.64918,-0.74935],[-0.6364,0.42206,0.64565],[-0.23713,0.76955,-0.59293],[-0.018761,0.8066,-0.5908],[0.051914,0.83498,-0.54782],[-0.049811,0.8965,-0.44023],[-0.67635,0.32553,0.66074],[-0.37014,0.86975,-0.3264],[0.73204,-0.15448,0.66351],[0.83361,-0.55167,-0.027578],[0.98025,0.18473,0.070561],[-0.85962,0.48254,-0.16793],[-0.68436,0.439,0.58218],[-0.24301,-0.85113,-0.46532],[-0.63423,0.48855,0.59922],[0.048114,0.72886,-0.68297],[-0.21289,0.68048,-0.70116],[-0.99153,0.10938,0.069982],[0.4786,0.42412,0.76881],[0.2433,0.78744,-0.56634],[-0.71856,0.39909,0.56956],[-0.95646,0.22738,0.18299],[0.73498,-0.17048,0.65631],[0.8785,-0.47117,0.078969],[0.88653,-0.45519,-0.082864],[-0.89364,0.35347,0.27653],[0.76951,0.050624,0.63662],[-0.53312,0.67266,0.51314],[0.32817,0.77435,-0.541],[0.39848,0.7574,-0.51726],[-0.49233,0.51869,0.69898],[-0.1439,-0.81069,-0.56752],[0.25557,0.60673,0.75271],[0.28519,0.90733,-0.30889],[-0.70582,0.4213,-0.5695],[-0.58863,0.69952,0.4052],[-0.59617,0.75423,-0.27518],[0.06252,0.99801,-0.008679],[-0.85692,0.25525,0.44781],[0.96702,-0.17918,-0.18101],[0.76754,0.498,-0.40358],[-0.87465,-0.060782,0.48094],[0.27025,-0.93784,0.21776],[0.21976,0.97455,0.044339],[0.10453,0.9745,-0.19853],[-0.90537,0.24559,-0.34641],[-0.77242,-0.45729,0.44073],[-0.83585,0.27302,0.47626],[0.85143,0.0066432,0.52443],[-0.44292,0.88852,-0.11981],[-0.086844,0.99012,0.11013],[-0.05168,0.99287,0.10744],[0.029154,0.9947,0.098595],[-0.79971,0.40702,-0.44135],[0.96558,-0.15078,-0.21193],[-0.67407,0.38477,0.63054],[0.2241,0.17529,0.95867],[0.061255,-0.90646,-0.41783],[0.91518,0.02194,0.40244],[0.82209,0.52523,-0.21976],[0.94066,-0.32528,0.096732],[0.77175,-0.49227,0.40257],[0.21965,0.62581,0.74841],[0.98891,-0.12807,-0.075188],[-0.47644,0.77616,-0.41302],[-0.80335,0.5351,-0.26134],[0.26984,-0.96207,-0.040073],[-0.55904,0.74804,-0.35763],[0.59593,0.78174,-0.18373],[-0.48855,-0.86897,0.078857],[-0.1857,0.61255,0.76831],[0.53915,-0.63183,0.55687],[0.73575,0.46794,0.4896],[0.97749,0.034134,0.20822],[0.57355,0.80633,-0.14447],[-0.14012,0.70448,0.69575],[-0.37353,0.75051,0.54517],[0.10177,0.65956,0.74473],[0.028545,0.62639,0.77899],[-0.88924,0.021214,0.45695],[0.15162,0.63049,0.76124],[0.78935,0.59395,-0.15539],[-0.45051,0.83626,-0.31258],[0.54743,0.83426,-0.065751],[-0.21254,0.77843,0.59065],[-0.1792,0.65069,0.73789],[0.15083,0.54291,0.82613],[0.042261,-0.9984,-0.037644],[0.16677,0.54735,0.82012],[-0.98036,-0.17615,0.088661],[0.5745,0.57233,0.58514],[0.2297,0.51062,0.82855],[-0.21345,0.91584,0.34011],[0.075896,0.83358,0.54716],[-0.72154,0.47466,-0.50406],[0.72654,0.62588,-0.28356],[-0.98882,-0.14792,0.018782],[0.78415,0.5549,-0.27783],[0.93999,0.10415,0.32492],[0.83385,0.50858,-0.21458],[0.79645,0.56558,-0.214],[-0.17953,0.63886,0.74808],[-0.28871,-0.94741,-0.13804],[0.72233,0.67337,-0.15752],[0.55466,0.81173,-0.18288],[-0.046281,-0.99785,0.04634],[0.90871,0.40965,-0.08026],[-0.64257,0.50499,-0.57627],[-0.63591,0.6566,-0.40557],[-0.48835,0.5168,-0.70316],[0.8255,0.42321,-0.37342],[-0.57469,0.27501,-0.77078],[-0.32412,0.11929,-0.93846],[-0.31658,0.30801,-0.89716],[-0.66,0.16637,0.73262],[-0.98707,-0.16011,-0.0072078],[-0.87844,0.24015,0.41311],[-0.039512,0.14017,-0.98934],[-0.32545,0.31966,-0.88989],[-0.065499,0.68435,0.7262],[0.72927,0.48664,-0.48099],[-0.371,0.47251,-0.79943],[0.90198,0.4287,-0.051487],[0.84389,0.31,0.43789],[-0.33023,-0.11185,-0.93725],[-0.43303,-0.075516,-0.89821],[0.82028,-0.41592,-0.39263],[0.62394,0.42902,-0.65318],[-0.20525,-0.035645,-0.97806],[0.43403,0.33614,-0.83584],[-0.32624,-0.16407,-0.93094],[0.35686,0.18788,-0.91507],[-0.0079112,0.70584,0.70833],[-0.84733,0.34528,0.40351],[-0.54105,-0.12067,-0.83229],[-0.31211,-0.020626,-0.94982],[0.24719,0.18092,-0.95193],[0.197,0.044031,-0.97941],[-0.63633,0.041822,-0.77028],[-0.32541,-0.066663,-0.94322],[0.49082,-0.51923,0.69964],[-0.5394,0.23532,-0.8085],[0.16029,0.063419,-0.98503],[0.28355,0.087014,-0.955],[0.21562,0.056661,-0.97483],[0.97523,-0.077002,0.20735],[-0.82517,0.50851,0.24601],[0.85858,0.40145,0.31888],[0.13611,-0.43725,0.88898],[0.18558,-0.43035,0.88338],[-0.59237,0.41109,-0.6929],[-0.53615,0.48376,-0.69175],[0.85943,0.033802,0.51013],[-0.93836,-0.0017146,0.34567],[0.34462,0.001797,-0.93874],[0.36587,0.20582,-0.90762],[-0.43906,0.59387,-0.6742],[0.57211,-0.81474,0.094317],[-0.29094,0.65258,-0.69964],[0.40473,0.4475,-0.79745],[-0.74161,0.66964,0.039975],[-0.71545,0.5279,-0.45766],[0.29941,0.39767,-0.8673],[-0.13484,0.67207,0.72811],[-0.78049,0.62508,0.0099737],[-0.74995,0.46297,-0.47247],[0.85691,-0.0016313,0.51546],[-0.9455,0.19113,0.26362],[-0.062854,0.56696,-0.82134],[0.21856,0.57217,-0.79047],[0.48637,0.15449,0.85999],[0.094268,0.67912,0.72795],[0.038051,0.62004,-0.78365],[0.44335,-0.35922,0.82122],[0.42505,-0.39967,0.81215],[-0.79066,0.60337,0.1039],[-0.44068,0.74442,-0.50163],[-0.92814,0.37173,0.019464],[0.17903,0.78912,-0.58757],[0.75977,0.64652,-0.068987],[0.87588,0.15197,0.45798],[-0.31453,0.82749,-0.46511],[-0.30765,0.86829,-0.38913],[0.2993,0.83542,-0.46097],[-0.15117,0.90249,-0.40331],[0.2728,-0.25371,0.92802],[0.79659,-0.37966,-0.47043],[-0.0065605,0.83508,-0.55009],[0.22353,0.81019,-0.54187],[0.34828,0.66,-0.66566],[-0.41256,0.75581,-0.50847],[-0.065324,0.92479,-0.37482],[0.03674,0.85176,-0.52265],[0.13918,-0.98934,0.042946],[-0.69885,-0.69647,0.1629],[0.50799,-0.85022,-0.13809],[0.69178,-0.61103,-0.38483],[-0.97751,0.20965,-0.023048],[0.79593,-0.24914,-0.55174],[-0.62098,0.67894,-0.39169],[0.083447,0.49255,-0.86627],[0.76662,0.17181,-0.61869],[-0.61927,0.76579,-0.1734],[-0.011142,0.84383,-0.5365],[0.25779,0.73976,-0.62153],[0.40707,-0.21435,0.88789],[-0.063495,-0.11623,-0.99119],[-0.66555,0.16408,0.72809],[-0.064925,-0.091129,-0.99372],[0.012535,-0.05252,-0.99854],[0.3636,-0.14547,0.92013],[0.076342,-0.077932,-0.99403],[0.43086,-0.063861,0.90015],[-0.75015,-0.15623,0.64254],[-0.048393,-0.37104,-0.92736],[0.022172,-0.3826,-0.92365],[0.08595,-0.39123,-0.91627],[-0.19012,-0.74726,-0.63676],[0.95024,-0.29647,0.095708],[-0.12725,-0.30238,-0.94465],[0.16821,-0.44778,-0.87818],[0.68925,-0.71754,0.10039],[-0.2718,-0.7626,-0.587],[-0.35198,-0.76709,-0.53636],[0.39845,-0.75159,-0.52569],[-0.51689,-0.62603,-0.58388],[-0.60844,-0.010254,0.79353],[0.33111,0.015552,0.94346],[0.67206,0.46434,0.57682],[-0.67541,0.00047996,0.73744],[-0.88553,-0.17981,-0.42838],[-0.77829,0.1115,-0.61792],[0.5953,-0.10629,-0.79644],[-0.9141,0.25244,0.31731],[0.65419,0.09456,-0.75039],[-0.93054,-0.25566,0.26216],[-0.52936,0.030222,-0.84786],[-0.42395,-0.80118,-0.42235],[0.4091,0.55031,0.72787],[-0.080902,-0.84926,-0.52174],[0.82867,0.18209,0.5293],[0.51961,0.5738,0.63305],[-0.91597,-0.11631,0.38402],[-0.31654,-0.89312,-0.31959],[0.22858,-0.90839,-0.35012],[0.23113,-0.88287,-0.40879],[0.49515,-0.84659,0.1952],[-0.28604,-0.48239,-0.82794],[-0.2885,-0.26591,-0.91982],[0.37882,-0.4803,-0.79108],[0.2786,-0.59261,-0.75578],[0.36803,-0.8482,-0.38093],[-0.20644,-0.88508,-0.41715],[0.43528,-0.4898,0.7554],[-0.17218,-0.64766,0.74222],[0.46711,-0.71067,-0.52607],[0.10303,-0.55205,0.82742],[0.58894,-0.73505,-0.33595],[0.64951,-0.54727,-0.52786],[0.64783,-0.76165,0.014433],[0.41573,-0.68606,0.59706],[0.41799,0.18779,0.88883],[-0.68849,0.2645,0.67529],[-0.76265,-0.48243,-0.43085],[0.6525,-0.66293,-0.36711],[-0.49704,-0.79531,-0.34703],[-0.92779,0.021584,0.37247],[-0.84097,0.4502,0.30016],[-0.7672,-0.63963,-0.047768],[-0.0013917,-1,0.0022468],[-0.92738,0.35041,0.13105],[-0.68789,-0.61716,-0.38199],[-0.40693,0.18354,0.89483],[0.083479,-0.99124,0.10237],[0.77322,-0.62863,-0.083462],[0.37964,0.29031,0.87841],[-0.61322,-0.71177,-0.34255],[-0.77073,-0.506,-0.38723],[0.7441,0.52683,0.41082],[-0.87491,-0.31831,-0.36498],[-0.69985,-0.71145,-0.063604],[-0.21091,0.11463,0.97076],[-0.97599,0.043695,0.21338],[0.15982,0.42565,-0.89066],[0.32442,0.40257,0.85598],[0.7673,-0.64066,-0.028309],[-0.16145,-0.86092,-0.48244],[0.7608,0.50307,0.41001],[0.99392,-0.097318,0.051584],[0.81576,0.13922,0.56139],[-0.10819,-0.96544,-0.23712],[-0.70858,-0.11469,0.69624],[-0.17584,0.94508,0.27549],[-0.2835,-0.90104,-0.32827],[0.10759,-0.97411,-0.19881],[-0.9958,0.042065,0.081331],[0.83079,0.071709,-0.55194],[-0.11259,-0.94994,-0.29143],[0.48249,-0.81152,-0.3296],[0.58827,0.44394,-0.67591],[0.34727,-0.8795,-0.3254],[-0.42269,-0.4568,-0.78273],[-0.26195,-0.93246,-0.24881],[-0.22569,-0.9712,0.076452],[-0.9997,0.014159,-0.019936],[-0.64305,0.6249,0.4427],[0.27222,0.49516,0.82505],[0.31505,-0.93641,-0.15452],[0.19471,-0.97527,-0.1046],[-0.12732,-0.94916,0.2879],[0.10952,-0.96925,0.22035],[0.45243,0.38192,0.80588],[-0.96668,-0.16778,-0.19335],[0.24041,-0.8762,-0.4177],[0.35282,-0.80376,-0.47905],[-0.84869,-0.4817,-0.21839],[-0.88966,-0.38052,-0.25243],[0.93043,-0.36021,-0.067428],[-0.79009,-0.60531,-0.096777],[0.28309,-0.95628,-0.073443],[-0.49324,-0.83225,0.25313],[-0.13809,-0.94728,0.28913],[-0.20137,-0.93192,0.30161],[-0.24027,-0.9614,-0.13406],[-0.9336,-0.29944,-0.19678],[-0.40597,0.2696,-0.87322],[-0.59788,-0.79356,-0.11316],[0.12883,-0.78142,-0.61056],[-0.83022,0.34848,0.43508],[-0.37911,-0.13466,-0.9155],[0.54292,0.76024,0.35675],[0.41531,-0.90916,-0.030898],[-0.78497,-0.5743,-0.23237],[0.66874,0.04074,0.74238],[-0.34795,-0.40189,-0.84701],[0.56941,-0.8115,0.13132],[0.99142,-0.11541,-0.061301],[0.71218,-0.23626,-0.66105],[0.22577,0.1851,0.95644],[0.43399,0.83267,0.34397],[0.58873,-0.77532,0.22863],[-0.90085,-0.31287,-0.30098],[0.58328,-0.24514,-0.77439],[0.64286,-0.64946,0.40612],[-0.85632,-0.41239,0.3109],[0.64972,-0.71905,0.24664],[-0.11255,0.6459,-0.75508],[-0.95905,0.24411,0.14364],[-0.4306,-0.31902,-0.84428],[0.60936,-0.30345,0.73253],[0.18953,-0.88047,0.43456],[0.28061,-0.7886,0.54714],[0.99401,-0.013687,0.10843],[-0.9396,0.2822,0.19369],[0.17456,0.81775,0.54846],[0.5884,-0.12647,-0.79861],[-0.98535,-0.017964,-0.16958],[-0.82302,-0.50624,0.2576],[0.48911,-0.10388,-0.86601],[0.61801,-0.58049,0.53018],[0.69507,-0.45924,0.55315],[-0.40047,-0.10706,-0.91004],[0.64395,0.6899,0.3307],[0.24276,-0.12871,-0.96151],[0.084084,-0.17722,-0.98057],[0.066381,-0.15401,-0.98584],[-0.43631,-0.035768,-0.89909],[0.6458,-0.53135,0.54828],[-0.56304,0.68272,0.4657],[0.43728,-0.63058,0.64121],[0.28597,-0.092155,-0.9538],[0.67433,0.73423,0.078647],[0.99703,0.031618,0.070213],[0.76683,-0.21577,0.6045],[0.76304,-0.055364,-0.64398],[-0.37464,0.054761,-0.92555],[-0.78534,0.57352,0.23304],[0.19341,-0.65374,0.73158],[0.24168,-0.69669,0.67544],[-0.31937,0.21587,-0.92272],[0.24942,-0.78768,0.56334],[0.96913,0.15212,0.19403],[-0.79472,0.53184,0.29251],[0.23996,-0.054213,-0.96927],[0.34424,0.054397,-0.9373],[-0.33954,0.2295,-0.91216],[0.43842,0.89723,0.052553],[0.93007,0.26381,0.2557],[0.45972,-0.75793,-0.46282],[0.8148,0.38151,0.43651],[0.64003,0.76834,-0.0023553],[-0.37302,0.39804,-0.83811],[0.4015,-0.52625,0.74957],[0.46256,-0.70336,0.53973],[0.5503,0.53838,-0.63822],[0.36026,0.93148,0.050554],[0.41534,0.090972,-0.90511],[0.31691,0.10408,-0.94273],[0.90547,0.36211,0.22135],[-0.98748,0.013256,-0.15721],[0.95734,0.24158,0.15857],[-0.98512,0.060235,-0.16095],[0.67215,-0.514,0.53293],[-0.36839,0.37647,-0.85004],[0.40134,0.90821,0.11862],[-0.70953,0.085628,0.69946],[-0.82627,0.41751,0.3781],[-0.13119,0.82024,-0.55678],[0.76298,-0.29252,0.57644],[-0.85838,0.096846,0.50379],[-0.83376,0.52995,0.1549],[0.61833,0.10612,-0.77872],[-0.94612,0.29132,-0.14141],[0.79921,0.12334,-0.58826],[-0.3784,0.92101,0.092488],[-0.85931,0.19704,0.47197],[-0.38679,-0.427,-0.81735],[-0.90611,0.38734,-0.1701],[0.56333,-0.16976,0.80861],[-0.41936,-0.17696,-0.8904],[-0.30127,0.94875,0.095505],[0.79781,0.086067,-0.59674],[-0.21468,0.46308,-0.85993],[-0.73895,0.44167,0.50881],[0.92221,0.3657,-0.12566],[0.8856,0.024419,-0.46381],[-0.32394,0.66674,-0.67121],[-0.75928,0.28506,0.585],[0.2405,-0.341,0.90878],[0.5137,0.76631,0.38586],[0.099593,0.81895,-0.56515],[0.48629,0.87182,0.058685],[-0.19951,0.91633,-0.34719],[-0.41415,0.85918,-0.30047],[-0.8634,0.47407,-0.17263],[0.89248,0.04196,-0.44914],[-0.48525,0.73701,0.47047],[-0.45273,0.82329,-0.34239],[-0.48908,0.80937,-0.32515],[-0.92454,-0.2571,0.2813],[0.89793,0.36253,-0.24959],[0.50556,0.46486,0.72685],[-0.97244,0.19369,0.1298],[0.92025,0.0059847,-0.3913],[0.61209,0.63962,-0.465],[-0.66886,-0.7098,0.22093],[-0.52339,0.60789,0.5971],[-0.86299,0.50426,-0.030956],[-0.97351,-0.026525,0.22712],[0.16121,0.97827,-0.13039],[0.69287,0.45657,0.5581],[-0.54249,0.58102,0.60673],[-0.90556,0.40798,0.11626],[0.82257,0.43062,-0.3714],[0.90888,0.13685,-0.39396],[0.38063,0.77568,-0.50343],[-0.42702,0.65704,-0.62125],[0.52742,0.46743,0.70947],[0.70904,-0.10881,0.69672],[-0.8261,0.54806,-0.13114],[-0.72077,0.42189,-0.55],[-0.86808,0.49304,-0.057918],[-0.68269,0.72277,0.10746],[-0.80478,-0.19398,0.56098],[-0.94351,-0.12556,0.30663],[0.82026,0.51525,-0.24836],[-0.78207,0.49873,0.37367],[-0.74072,0.66049,-0.12283],[0.1425,-0.96108,0.23669],[-0.72498,0.65763,-0.20478],[0.42028,0.78976,-0.44681],[-0.80516,0.29955,-0.51185],[0.86748,0.29747,-0.39874],[-0.66331,0.74781,0.028319],[0.45494,0.52283,0.72089],[-0.32797,0.77403,0.54159],[-0.40782,0.72128,0.55986],[0.79467,0.12386,0.59427],[-0.65677,0.74843,-0.092292],[0.16915,0.98534,-0.022095],[-0.62055,0.77215,0.13674],[0.66983,0.66159,-0.3371],[0.78216,0.44928,-0.43172],[0.30014,0.94285,-0.14475],[-0.74803,0.44054,-0.49636],[0.98418,0.029478,0.1747],[-0.83039,0.49369,0.25832],[-0.74568,0.44807,0.49314],[0.10065,0.99492,0.0025351],[-0.035821,0.98708,-0.15615],[0.12499,0.97408,-0.18853],[0.9888,0.04089,0.14352],[0.097891,0.99214,-0.077924],[0.59503,0.75637,-0.27173],[0.82579,0.20164,0.52669],[-0.53953,0.45254,0.71002],[-0.64038,0.16408,0.75032],[-0.78636,0.45841,0.41412],[-0.86547,0.49888,-0.045632],[0.65981,0.68563,-0.30751],[-0.70448,0.54808,0.45092],[0.82863,0.31517,0.46264],[-0.61493,0.6276,-0.47747],[-0.55805,0.71424,0.42242],[-0.47538,0.70066,0.53207],[0.80618,0.41941,0.41734],[-0.37594,0.81,-0.45007],[0.58193,0.73467,0.34874],[0.77628,0.57891,-0.2495],[0.85773,0.49621,-0.13443],[-0.73965,0.62359,-0.25309],[0.66723,0.72294,-0.17934],[0.93023,0.35487,-0.093423],[-0.30009,0.59656,0.74435],[0.81017,0.34277,0.47553],[0.16001,0.82803,0.53737],[-0.22667,0.61759,0.75312],[0.72235,0.44976,0.52529],[-0.52378,0.22258,0.82226],[-0.41175,0.68328,0.60298],[0.04769,0.85632,0.51424],[-0.2125,0.85031,0.48148],[-0.89671,-0.32218,0.3035],[0.12587,0.48493,0.86545],[0.23501,0.58671,0.77495],[-0.17082,0.54872,0.81837],[-0.18941,0.65579,0.7308],[0.69884,0.023586,-0.71489],[-0.67058,0.70574,-0.2286],[0.66938,-0.087426,0.73776],[0.80587,0.59186,-0.016491],[0.53137,0.84382,-0.074942],[-0.31928,0.78574,0.52978],[0.10264,0.66026,0.74399],[-0.056003,0.6634,0.74617],[-0.325,0.78409,0.52875],[0.30432,0.68873,0.65806],[-0.65581,0.72168,-0.22156],[-0.44267,0.83352,-0.33058],[-0.9323,-0.35542,-0.067127],[-0.15693,0.86202,0.48198],[-0.14747,0.60668,0.78115],[-0.095174,0.92887,0.35798],[0.77468,0.55602,-0.30118],[-0.7345,0.49193,-0.46745],[-0.60958,0.762,-0.21858],[0.96051,0.27322,-0.0526],[0.78626,0.50447,-0.35681],[0.74068,0.66438,-0.099961],[0.80425,0.54061,-0.24683],[-0.87167,0.028099,0.48929],[-0.7445,0.52776,-0.40889],[0.042405,0.6204,0.78314],[0.67771,0.67677,-0.28755],[-0.64503,0.75126,0.13979],[-0.67628,0.60432,-0.42125],[-0.49604,0.33371,-0.80162],[0.89696,0.16316,-0.4109],[0.86606,0.23093,-0.44342],[-0.49482,0.093916,-0.8639],[0.63836,0.75603,-0.14462],[-0.3607,0.16814,-0.9174],[0.15542,0.92081,0.3577],[-0.27415,-0.063236,-0.95961],[-0.22989,0.020408,-0.973],[-0.64144,0.74712,-0.17424],[-0.2271,-0.031591,-0.97336],[-0.2932,-0.090132,-0.95179],[0.66788,0.47748,-0.57092],[0.50787,0.83843,-0.19773],[-0.36606,-0.0060179,-0.93057],[-0.16918,0.0039848,-0.98558],[0.72271,0.41036,-0.55614],[-0.38153,0.15137,-0.91188],[-0.022704,0.2078,-0.97791],[0.49501,-0.1471,-0.85634],[-0.11285,0.15564,-0.98135],[-0.078628,0.15011,-0.98554],[-0.5405,0.32578,-0.77571],[0.35469,0.087664,-0.93086],[0.52612,0.81475,-0.24369],[0.23222,-0.052303,-0.97126],[0.027713,0.13615,-0.9903],[0.4305,0.32704,-0.84126],[-0.30733,0.42875,-0.84954],[-0.04747,0.91751,0.39487],[-0.66843,0.6828,-0.29492],[0.19304,0.029422,-0.98075],[0.21468,-0.0090977,-0.97664],[0.16319,0.718,0.67665],[0.034727,0.91408,0.40405],[-0.098934,0.23128,-0.96784],[-0.41594,-0.09505,-0.90441],[0.1924,0.045761,-0.98025],[-0.63418,0.048891,-0.77164],[0.83687,0.53245,-0.12706],[0.29792,0.10259,-0.94906],[-0.86395,0.23564,-0.44504],[-0.8883,0.1713,0.42612],[-0.8414,0.51876,-0.15144],[-0.79538,0.28693,-0.5339],[0.20424,0.084086,-0.9753],[0.37048,0.20438,-0.90608],[0.074277,-0.97633,-0.20311],[-0.69506,0.54036,-0.47424],[0.21327,0.23546,-0.9482],[0.39959,0.1559,-0.90334],[0.25092,0.36547,-0.89636],[0.60241,0.032131,-0.79754],[0.33183,0.46383,-0.82143],[-0.6421,0.61276,-0.46069],[0.69639,0.71001,-0.10452],[0.5402,0.28477,-0.79189],[-0.4977,0.75985,-0.41823],[-0.15708,0.77091,-0.61728],[-0.25144,0.88726,-0.38672],[0.58516,-0.72925,-0.35464],[0.45184,0.64557,-0.61569],[-0.043057,-0.99905,-0.0066295],[-0.89024,0.44571,-0.093867],[0.37107,0.72568,-0.57939],[-0.21337,-0.43411,0.87523],[-0.76995,0.49312,0.40498],[-0.81956,0.52617,-0.22685],[0.60225,0.093734,0.79278],[-0.57398,0.81125,-0.11143],[0.11948,0.7888,-0.60293],[-0.59969,0.71084,-0.36753],[0.5881,0.56085,-0.58274],[0.10826,0.84755,-0.51955],[0.033665,-0.29707,0.95426],[-0.44356,0.85127,-0.28035],[0.28788,-0.44073,0.85022],[-0.29165,0.95023,-0.10961],[0.069156,0.95709,-0.28141],[0.15385,0.93295,-0.32547],[0.31315,0.88675,-0.34001],[0.72771,0.68381,0.053307],[0.07103,0.94296,-0.32525],[0.37912,-0.094457,0.92051],[0.013243,-0.99896,0.043622],[0.32313,0.91497,-0.2417],[-0.10965,0.97715,-0.18208],[0.18625,0.93267,-0.30893],[-0.41397,-0.87586,0.24799],[-0.67684,-0.68783,0.26224],[0.54669,-0.81192,-0.20473],[-0.97652,-0.17466,0.1261],[0.80736,-0.047665,-0.58814],[-0.8426,0.52266,0.1298],[-0.82561,0.56171,0.0533],[0.50382,0.5804,-0.63976],[-0.48692,0.82543,-0.28561],[-0.59755,-0.52757,0.60382],[0.36357,0.76851,-0.5265],[-0.39058,-0.84664,0.36147],[-0.23402,-0.92578,0.29694],[-0.12817,-0.56368,-0.81599],[0.004732,-0.33968,-0.94053],[-0.011829,-0.55901,-0.82908],[0.092945,-0.32152,-0.94233],[0.73674,-0.67395,-0.054745],[-0.14096,-0.27886,-0.94993],[-0.020178,-0.97204,-0.23393],[-0.11507,-0.31811,-0.94105],[-0.10725,-0.56322,-0.81932],[0.061093,-0.13389,-0.98911],[0.12665,-0.08613,-0.9882],[0.27496,-0.13575,-0.95183],[0.53748,0.81774,0.20594],[-0.060363,-0.9567,-0.28475],[-0.11762,-0.16272,-0.97964],[0.3594,-0.084168,-0.92938],[-0.64617,0.60422,0.46624],[-0.63541,0.64858,0.41904],[-0.1312,-0.16631,-0.9773],[0.28466,-0.082164,-0.9551],[0.17508,0.30169,0.93719],[0.14622,-0.11253,-0.98283],[-0.34417,-0.45364,0.82204],[-0.17329,-0.11341,-0.97832],[-0.13732,-0.11533,-0.98379],[-0.18637,-0.23325,-0.95439],[0.83799,-0.42894,0.33731],[0.50863,0.84262,0.17688],[0.63916,-0.17816,0.74816],[0.31938,-0.28662,-0.90324],[0.11798,-0.99235,0.036352],[-0.31184,-0.45303,-0.83518],[-0.21532,-0.46672,-0.85779],[-0.18883,0.90819,0.37355],[0.35797,-0.63592,-0.68372],[-0.38225,-0.63348,-0.67275],[-0.06607,-0.99601,-0.060026],[0.44878,-0.6671,-0.59461],[0.39942,0.88014,0.25655],[-0.9,0.38786,-0.19894],[-0.95468,0.21379,0.20707],[-0.54883,-0.6438,-0.5332],[-0.15374,-0.97717,-0.14663],[0.49722,-0.59833,-0.6283],[-0.77268,-0.51418,-0.37226],[0.56981,0.78887,-0.23022],[0.55584,-0.25257,-0.792],[-0.49501,0.24432,0.83383],[-0.82003,0.023075,-0.57185],[0.99156,-0.079953,0.10202],[-0.7138,0.097747,-0.6935],[0.65915,-0.21388,0.72095],[-0.64897,-0.13073,0.74949],[0.64151,0.11415,-0.75858],[-0.32523,0.93956,0.10705],[-0.13002,-0.9387,-0.31927],[0.65224,-0.72481,0.22189],[-0.20415,-0.61295,-0.76329],[-0.57494,-0.077719,-0.8145],[0.49004,-0.28309,-0.82445],[-0.5192,0.65994,0.54305],[-0.085294,-0.84653,0.52546],[-0.98163,0.011548,0.19045],[-0.11928,-0.89688,-0.42588],[-0.092874,-0.91607,-0.39011],[0.013115,-0.92901,-0.36983],[0.22235,-0.90225,-0.36946],[-0.98329,0.15662,0.092752],[-0.13842,-0.7252,-0.67448],[-0.085369,-0.68869,-0.72002],[-0.34242,0.82194,0.45516],[-0.51547,-0.75045,-0.41366],[0.5922,-0.69778,-0.40299],[-0.59692,-0.68999,-0.40939],[0.66687,-0.60941,-0.42884],[0.30791,0.91707,-0.25333],[0.70656,0.67545,0.21103],[-0.74549,-0.49724,-0.44385],[-0.90557,0.2385,0.3508],[-0.43689,-0.82563,-0.35701],[-0.44181,-0.81729,-0.36992],[0.65792,-0.66468,-0.35403],[-0.61472,-0.16899,0.77043],[-0.86808,-0.31054,-0.3873],[0.82416,-0.3216,-0.4662],[0.35227,0.82634,0.4394],[-0.5774,-0.74122,-0.34236],[0.64704,-0.63057,-0.42864],[0.6692,0.062469,0.74045],[0.76793,-0.47611,-0.42849],[-0.94464,-0.17929,-0.27478],[0.58559,0.49093,-0.64504],[0.89282,-0.2083,-0.39935],[-0.6411,-0.17809,0.74651],[0.845,0.36311,0.39259],[-0.91603,-0.26887,-0.29765],[0.43208,0.52879,0.73054],[-0.42283,0.85573,0.29824],[0.45427,-0.62072,0.63902],[-0.019076,-0.89287,-0.44991],[0.17658,-0.92726,-0.33018],[0.15378,-0.8989,-0.41028],[0.10957,-0.94861,-0.29687],[0.32712,-0.89281,-0.30966],[-0.48485,0.14234,0.86294],[-0.44611,-0.88736,-0.11648],[-0.35754,-0.92313,-0.14143],[0.047164,-0.93377,-0.35475],[0.053338,-0.91696,-0.39539],[0.24611,-0.92059,-0.30323],[-0.14021,0.42367,0.8949],[-0.26312,-0.78183,-0.56526],[0.072647,0.95823,-0.27662],[-0.34038,-0.8578,-0.38514],[0.38113,-0.82464,-0.41797],[0.921,-0.023052,0.38889],[-0.95115,-0.15711,-0.26576],[-0.73345,-0.46369,-0.49704],[0.89634,-0.10077,-0.43176],[-0.80367,-0.4779,-0.35458],[-0.35952,-0.43677,-0.8246],[-0.21966,-0.64449,-0.73238],[0.51548,-0.81156,-0.27503],[0.026113,0.96437,-0.26326],[0.79058,-0.22741,0.56857],[-0.39724,-0.89645,-0.19641],[-0.11504,-0.96959,-0.216],[-0.053897,-0.97697,-0.20646],[-0.082737,-0.99364,-0.076392],[0.28884,-0.86738,-0.40524],[-0.25,0.56466,0.78655],[-0.3175,-0.77158,-0.55124],[-0.47643,-0.69344,-0.54052],[-0.46001,0.21575,-0.8613],[-0.41587,0.18301,-0.89082],[0.80005,-0.027741,0.59929],[-0.46003,-0.8828,-0.095103],[-0.40805,-0.8648,-0.29261],[-0.65416,0.098169,0.74996],[0.99147,0.069958,0.10999],[-0.47362,0.087087,0.87641],[0.37816,-0.92504,-0.035939],[-0.45623,-0.43405,0.77683],[-0.92057,0.34082,0.19076],[-0.15438,-0.95205,0.26414],[-0.16454,-0.92039,0.35471],[-0.054252,-0.9784,0.19945],[0.86781,0.19392,0.4575],[-0.20379,-0.78385,-0.58656],[-0.40858,0.21142,-0.8879],[-0.21726,-0.9729,0.079112],[0.27895,0.90972,0.30758],[-0.93853,-0.030506,0.34386],[-0.42733,-0.18776,-0.88438],[0.50879,-0.8592,0.053972],[0.60756,0.35181,0.71211],[0.65376,-0.31685,-0.68718],[-0.39397,-0.43716,-0.80851],[-0.86908,-0.30161,-0.39209],[0.80751,-0.10204,0.58096],[0.90922,-0.41614,-0.011871],[-0.37889,-0.42838,-0.82033],[0.26327,0.90095,-0.34493],[-0.92609,-0.18961,-0.32619],[0.43262,0.87947,0.19843],[-0.62258,0.11152,0.77457],[0.31483,-0.2158,-0.92429],[0.077796,-0.29286,-0.95299],[0.16257,-0.24182,-0.95661],[0.18251,0.9304,0.31787],[-0.3386,-0.41838,-0.8428],[0.58164,-0.72972,0.35945],[0.46955,-0.51773,0.71518],[-0.56609,-0.45725,0.68591],[0.11392,-0.70004,0.70496],[-0.95469,-0.21544,-0.20532],[0.16079,-0.166,-0.97293],[0.26145,-0.15524,-0.95265],[-0.34011,-0.25286,-0.90575],[0.076289,-0.85146,0.51884],[0.19262,-0.6128,0.76641],[0.32115,-0.56627,0.75907],[-0.587,0.13452,0.79833],[0.96434,0.072443,0.25454],[0.51982,-0.48922,0.70032],[0.010113,0.94711,0.32075],[-0.3169,-0.094837,-0.9437],[-0.85356,-0.412,0.31888],[0.10891,-0.11938,-0.98686],[0.85393,-0.12043,0.50626],[-0.83374,-0.41086,0.36888],[0.29842,-0.034843,-0.9538],[-0.20718,-0.84535,0.4924],[0.16499,-0.15633,-0.97383],[-0.16777,-0.93078,0.32481],[0.10114,-0.04675,-0.99377],[-0.33266,-0.0024368,-0.94304],[0.07485,-0.015866,-0.99707],[0.21693,-0.786,0.57892],[0.35032,-0.69819,0.62435],[0.4085,-0.72444,0.55526],[0.28155,0.23245,0.93097],[0.22814,-0.057946,-0.9719],[-0.23491,0.15175,-0.9601],[0.86717,0.051568,0.49533],[-0.48382,-0.41958,0.76803],[0.053668,0.082753,-0.99512],[0.22319,0.0013432,-0.97477],[-0.12823,-0.99132,0.029143],[-0.29769,0.35627,-0.88569],[0.72927,0.32295,0.60321],[0.1334,-0.97414,-0.18238],[-0.87805,-0.098364,0.46835],[0.011593,0.13477,-0.99081],[-0.34651,0.40078,-0.84812],[0.48252,-0.67795,0.55457],[0.41472,0.19557,-0.88869],[0.19159,0.1715,-0.96638],[-0.023321,0.20532,-0.97842],[0.4716,-0.79044,-0.39089],[-0.2435,-0.96687,-0.076544],[0.81766,0.38594,0.42718],[-0.37913,0.39002,-0.83913],[0.5314,-0.51351,0.67374],[-0.18586,-0.98085,-0.058133],[-0.33943,0.40203,-0.85039],[-0.06098,-0.99426,0.087872],[0.40758,-0.91242,0.036914],[-0.52592,-0.4307,0.73342],[-0.38687,-0.28534,0.87688],[-0.37201,0.19243,-0.90806],[-0.84675,0.17202,0.50341],[0.58641,0.18477,-0.78866],[-0.59385,0.38701,0.70538],[0.58154,0.052737,0.81181],[0.83807,0.24292,0.48849],[-0.42357,-0.44169,-0.79088],[0.17897,-0.96391,-0.19709],[0.61216,0.65593,0.44161],[-0.43575,0.10917,-0.89342],[-0.78216,0.27037,0.56136],[0.87543,0.1114,0.47033],[-0.28402,0.53982,-0.79242],[0.54166,-0.43351,0.7202],[-0.25179,0.87353,-0.41659],[0.74316,-0.11879,0.65848],[-0.48374,-0.39782,0.77958],[-0.13219,0.89471,-0.42664],[-0.15213,0.65938,-0.73626],[-0.72464,0.38133,0.57401],[0.26104,0.883,-0.39009],[-0.22755,0.80105,-0.55365],[-0.18828,0.83455,-0.51776],[-0.91376,0.33993,0.22245],[-0.96213,0.18448,-0.20067],[0.73433,-0.17158,0.65675],[-0.32319,0.86585,-0.38191],[-0.56046,0.77608,-0.28912],[-0.68698,-0.6597,-0.30471],[-0.70202,0.70484,-0.1018],[-0.63271,0.65352,0.41544],[0.63057,0.094609,0.77034],[0.075362,-0.99422,0.076508],[-0.64061,0.15696,0.75165],[0.32975,0.3054,-0.89331],[-0.526,0.43697,0.72964],[-0.79923,0.5772,0.16753],[-0.81821,0.54646,-0.17866],[0.2662,0.81095,-0.52106],[-0.54614,0.13515,0.82672],[-0.52392,0.034657,0.85106],[-0.66848,0.38218,0.63802],[-0.79858,0.33606,-0.49934],[0.98376,-0.16877,0.06107],[-0.92945,0.34299,0.13596],[0.81758,0.46345,-0.34171],[-0.39029,-0.4467,0.80507],[-0.40505,0.73938,0.53782],[-0.52426,-0.49722,0.69132],[-0.73923,0.59882,-0.30815],[-0.58557,0.78192,-0.21382],[0.09328,0.95026,-0.29717],[0.17619,0.91113,-0.37256],[-0.72703,0.61701,0.30121],[0.7447,0.037922,0.66632],[-0.29008,0.66253,0.69059],[-0.0064092,0.99204,-0.12574],[0.29492,0.94955,-0.10667],[-0.74684,0.40054,-0.53085],[-0.10349,-0.99462,-0.0054518],[-0.27382,0.93924,0.20699],[0.12035,0.97263,-0.19874],[-0.041756,0.99721,-0.061835],[-0.67063,0.58075,-0.46151],[0.5255,0.028759,0.85031],[0.69725,0.66674,-0.26325],[-0.84473,0.41161,0.34207],[-0.33005,0.88753,-0.32148],[-0.31776,0.84317,-0.4337],[-0.25647,0.66589,0.70058],[-0.74321,0.45963,0.48619],[-0.90693,0.23696,-0.34833],[0.086788,-0.99495,-0.050493],[0.62686,0.19812,0.75352],[-0.87573,0.33884,-0.34394],[-0.70112,0.56448,-0.43565],[0.82903,0.4757,-0.29399],[0.05066,-0.9978,-0.042769],[-0.68584,0.40213,0.60655],[0.77751,0.25626,0.57428],[-0.24218,0.70303,0.66865],[-0.7151,0.69731,0.048819],[0.73531,0.66066,-0.15115],[-0.2935,0.67374,0.67818],[0.87253,0.065447,0.48416],[-0.28764,0.397,0.87158],[-0.19836,0.33578,0.92082],[0.32054,0.58508,0.74494],[0.4298,0.16973,-0.88683],[-0.088169,0.71642,0.69208],[-0.30573,0.58948,0.74769],[-0.42836,-0.58312,0.69027],[0.68089,-0.094828,0.72622],[-0.88341,-0.24396,-0.40009],[0.98288,0.15703,0.096353],[0.091236,-0.9936,0.066626],[-0.41219,0.69695,0.58682],[0.37586,0.33571,0.86373],[0.45565,0.053776,0.88853],[-0.75903,0.56702,-0.31994],[0.62019,0.77903,-0.092056],[-0.065927,0.72426,0.68637],[0.43292,-0.61096,0.6628],[0.017205,0.7576,0.65249],[0.46528,0.65554,0.59479],[-0.48002,0.63537,0.60489],[0.58194,0.54604,0.60265],[-0.99636,0.078784,-0.03244],[-0.3965,0.00091069,0.91803],[-0.40983,0.76702,0.49367],[0.34725,0.1534,0.92514],[-0.45822,0.82053,-0.3417],[-0.4299,-0.11299,0.89578],[0.59905,0.79145,-0.12144],[-0.37073,0.22725,0.90051],[0.089297,0.74009,0.66656],[-0.23978,0.031677,0.97031],[0.76859,0.55823,-0.31249],[0.76622,0.56503,-0.30603],[-0.64175,0.56623,-0.51724],[-0.65283,0.48995,-0.57773],[0.30633,-0.10938,-0.94562],[0.83081,-0.15225,0.53533],[0.81354,0.55831,-0.16263],[0.61616,-0.71131,0.33821],[0.62887,0.68411,-0.36949],[-0.65443,0.4512,-0.60674],[0.74874,0.32462,-0.57794],[0.28474,0.16734,0.94389],[-0.64393,0.20879,-0.73604],[0.63453,0.058347,-0.77069],[-0.46018,0.038234,-0.887],[-0.5357,-0.16131,-0.82886],[-0.30221,-0.1129,-0.94653],[-0.69006,-0.6851,0.23334],[0.59254,0.19783,-0.78087],[-0.34394,-0.058111,-0.93719],[-0.95205,-0.20491,0.22718],[0.82525,-0.13128,-0.5493],[-0.6471,-0.0066846,-0.76238],[-0.56325,0.19404,-0.80318],[-0.27326,-0.0024069,0.96194],[0.39886,0.33892,-0.85208],[-0.47966,0.15608,-0.86346],[-0.8822,0.036365,-0.46947],[0.39569,0.22567,-0.89023],[-0.94599,-0.24493,-0.21241],[0.38767,-0.24011,-0.88998],[-0.61417,0.33953,-0.7124],[-0.63457,0.51477,-0.57648],[0.48403,-0.041536,-0.87407],[0.82831,-0.057304,0.55734],[0.34953,0.14953,-0.92492],[-0.44533,0.55053,-0.70611],[-0.32013,0.36676,-0.8735],[0.50532,0.22297,-0.83363],[-0.45451,0.71377,-0.53288],[0.52554,0.32607,-0.7858],[0.36026,0.24784,0.89933],[0.5869,0.39724,-0.70551],[-0.99845,0.021328,-0.051463],[0.38746,0.33771,-0.8578],[0.85601,-0.20622,0.47405],[-0.86088,0.44479,-0.24707],[0.54138,0.6285,-0.55848],[-0.73348,0.64137,-0.22507],[0.84815,0.33331,0.41176],[0.51312,0.47888,-0.71231],[0.47096,0.74787,-0.46785],[0.80516,-0.069049,-0.58902],[-0.66614,0.70307,-0.24888],[-0.08375,0.1236,0.98879],[-0.86989,0.085181,-0.48583],[0.28957,0.16293,0.94319],[0.4747,0.29635,0.82876],[-0.38388,-0.6042,0.69827],[0.70829,0.52957,-0.46677],[0.53005,0.42798,-0.73204],[-0.1548,0.96225,-0.22384],[0.30302,-0.02102,0.95275],[0.49072,0.75561,-0.43388],[-0.56774,0.81882,-0.084876],[-0.61113,0.77596,-0.15623],[-0.31918,0.75751,-0.56948],[0.051955,0.95339,-0.29724],[0.18154,-0.16033,0.97022],[0.042262,-0.15941,0.98631],[0.40881,0.84088,-0.35467],[-0.45746,0.16059,0.87461],[0.6889,0.65958,-0.30062],[0.61022,0.73175,-0.30361],[-0.36888,0.92921,-0.022216],[0.56231,0.65068,-0.51031],[-0.38662,0.40604,-0.82804],[0.42484,0.89278,-0.14987],[0.064169,0.99048,-0.12181],[-0.30373,0.94391,-0.12954],[-0.40339,0.90871,-0.10737],[-0.38831,0.89575,-0.21646],[0.22421,0.9613,-0.16013],[-0.13516,0.98327,-0.12212],[-0.094866,0.99333,-0.0