# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_core.ipynb.

# %% auto 0
__all__ = ['count_values']

# %% ../nbs/00_core.ipynb 3
import pandas as pd

def count_values(df: pd.DataFrame,   # A pandas dataframe
                 col: str,           # A column name
                 order: bool = True, # Order the results by count
) -> pd.DataFrame:
    "Count the number of values in a column and return a dataframe with the results."

    return (
        df.groupby(col)
        .agg(count = (col, 'count'))
        .sort_values('count', ascending=order)
        .assign(percentual = lambda x: x['count'] / x['count'].sum())
        .assign(cumulative_percentual = lambda x: x['percentual'].cumsum())
        .reset_index()
    )
