# Security Policy

Security and stability are paramount for FastStream.

Learn more below. 👇

## Versions

The latest version of FastStream is actively supported.

We strongly encourage you to write tests for your application and regularly update your FastStream version after confirming that your tests pass. This ensures you benefit from the latest features, bug fixes, and **security updates**.

## Reporting a Vulnerability

If you suspect a security issue, even if you are uncertain, please report it promptly. However, **do not create a public issue**.

To responsibly report a security concern, navigate to the Security tab of the repository and click on *"Report a vulnerability"*.

![Screenshot of repo security tab showing "Report a vulnerability" button](https://github.com/encode/.github/raw/master/img/github-demos-private-vulnerability-reporting.png)

Alternatively, you can send an email to: [info@airt.ai](info@airt.ai).

Ensure your report contains sufficient detail. As with standard issue reports, a minimal, reproducible example expedites issue resolution.

Also, include the output of the following command in your report:

```bash
faststream --version
```

## Public Discussions

Please restrain from publicly discussing potential security vulnerabilities. 🙊

It is advisable to engage in private discussions and seek solutions first to minimize potential impact.

---

Thanks for your help!
