# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['DnsPreferencesArgs', 'DnsPreferences']

@pulumi.input_type
class DnsPreferencesArgs:
    def __init__(__self__, *,
                 magic_dns: pulumi.Input[bool]):
        """
        The set of arguments for constructing a DnsPreferences resource.
        :param pulumi.Input[bool] magic_dns: Enables or disables MagicDNS, automatically registers DNS names for devices on your network.
               At least one DNS server must be set before enabling Magic DNS.
        """
        pulumi.set(__self__, "magic_dns", magic_dns)

    @property
    @pulumi.getter(name="magicDns")
    def magic_dns(self) -> pulumi.Input[bool]:
        """
        Enables or disables MagicDNS, automatically registers DNS names for devices on your network.
        At least one DNS server must be set before enabling Magic DNS.
        """
        return pulumi.get(self, "magic_dns")

    @magic_dns.setter
    def magic_dns(self, value: pulumi.Input[bool]):
        pulumi.set(self, "magic_dns", value)


@pulumi.input_type
class _DnsPreferencesState:
    def __init__(__self__, *,
                 magic_dns: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering DnsPreferences resources.
        :param pulumi.Input[bool] magic_dns: Enables or disables MagicDNS, automatically registers DNS names for devices on your network.
               At least one DNS server must be set before enabling Magic DNS.
        """
        if magic_dns is not None:
            pulumi.set(__self__, "magic_dns", magic_dns)

    @property
    @pulumi.getter(name="magicDns")
    def magic_dns(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables or disables MagicDNS, automatically registers DNS names for devices on your network.
        At least one DNS server must be set before enabling Magic DNS.
        """
        return pulumi.get(self, "magic_dns")

    @magic_dns.setter
    def magic_dns(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "magic_dns", value)


class DnsPreferences(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 magic_dns: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        The dns_preferences resource allows you to configure DNS preferences for your Tailscale network. See the
        [Tailscale DNS documentation](https://tailscale.com/kb/1054/dns) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_tailscale as tailscale

        sample_preferences = tailscale.DnsPreferences("samplePreferences", magic_dns=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] magic_dns: Enables or disables MagicDNS, automatically registers DNS names for devices on your network.
               At least one DNS server must be set before enabling Magic DNS.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsPreferencesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The dns_preferences resource allows you to configure DNS preferences for your Tailscale network. See the
        [Tailscale DNS documentation](https://tailscale.com/kb/1054/dns) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_tailscale as tailscale

        sample_preferences = tailscale.DnsPreferences("samplePreferences", magic_dns=True)
        ```

        :param str resource_name: The name of the resource.
        :param DnsPreferencesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsPreferencesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 magic_dns: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsPreferencesArgs.__new__(DnsPreferencesArgs)

            if magic_dns is None and not opts.urn:
                raise TypeError("Missing required property 'magic_dns'")
            __props__.__dict__["magic_dns"] = magic_dns
        super(DnsPreferences, __self__).__init__(
            'tailscale:index/dnsPreferences:DnsPreferences',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            magic_dns: Optional[pulumi.Input[bool]] = None) -> 'DnsPreferences':
        """
        Get an existing DnsPreferences resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] magic_dns: Enables or disables MagicDNS, automatically registers DNS names for devices on your network.
               At least one DNS server must be set before enabling Magic DNS.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsPreferencesState.__new__(_DnsPreferencesState)

        __props__.__dict__["magic_dns"] = magic_dns
        return DnsPreferences(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="magicDns")
    def magic_dns(self) -> pulumi.Output[bool]:
        """
        Enables or disables MagicDNS, automatically registers DNS names for devices on your network.
        At least one DNS server must be set before enabling Magic DNS.
        """
        return pulumi.get(self, "magic_dns")

