import { PolicyStatement } from 'aws-cdk-lib/aws-iam';
import { Location } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * The properties for the SynchronousAthenaQuery construct.
 */
export interface SynchronousAthenaQueryProps {
    /**
     * The name of the Athena query to execute
     */
    readonly statement: string;
    /**
     * The timeout in seconds to wait for query success
     * @default - 60 seconds
     */
    readonly timeout?: number;
    /**
     * The Amazon S3 Location for the query results (without trailing slash)
     */
    readonly resultPath: Location;
    /**
     * The Amazon IAM Policy Statements used to run the query
     * @default - No Policy Statements are added to the execution role
     */
    readonly executionRoleStatements?: PolicyStatement[];
}
/**
 * Execute an Amazon Athena query synchronously during CDK deployment
 */
export declare class SynchronousAthenaQuery extends Construct {
    /**
    * Constructs a new instance of the SynchronousAthenaQuery class
    * @param {Construct} scope the Scope of the CDK Construct
    * @param {string} id the ID of the CDK Construct
    * @param {SynchronousAthenaQueryProps} props the CrawlerStartWait [properties]{@link SynchronousAthenaQueryProps}
    */
    constructor(scope: Construct, id: string, props: SynchronousAthenaQueryProps);
}
