"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlueDemoRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * GlueDemoRole Construct to automatically setup a new Amazon IAM role to use with AWS Glue jobs.
 * The role is created with AWSGlueServiceRole policy and authorize all actions on S3.
 * If you would like to scope down the permission you should create a new role with a scoped down policy
 * The Construct provides a getOrCreate method for SingletonInstantiation
 */
class GlueDemoRole extends constructs_1.Construct {
    /**
     * Constructs a new instance of the GlueDemoRole class
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @access private
     */
    constructor(scope, id) {
        super(scope, id);
        const stack = aws_cdk_lib_1.Stack.of(this);
        this.iamRole = new aws_iam_1.Role(this, 'GlueDemoRole', {
            assumedBy: new aws_iam_1.ServicePrincipal('glue.amazonaws.com'),
            managedPolicies: [aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSGlueServiceRole')],
            inlinePolicies: {
                DataAccess: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            resources: [
                                stack.formatArn({
                                    region: '',
                                    account: '',
                                    service: 's3',
                                    resource: '*',
                                    resourceName: '*',
                                }),
                            ],
                            actions: [
                                's3:ListBucket',
                                's3:*Object*',
                                's3:AbortMultipartUpload',
                                's3:ListBucketMultipartUploads',
                                's3:ListMultipartUploadParts',
                            ],
                        }),
                        new aws_iam_1.PolicyStatement({
                            resources: ['*'],
                            actions: ['lakeformation:GetDataAccess'],
                        }),
                        new aws_iam_1.PolicyStatement({
                            resources: ['*'],
                            actions: [
                                'kms:Encrypt*',
                                'kms:Decrypt*',
                                'kms:ReEncrypt*',
                                'kms:GenerateDataKey*',
                                'kms:Describe*',
                            ],
                        }),
                    ],
                }),
            },
        });
    }
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = 'GlueDemoRole';
        return stack.node.tryFindChild(id) || new GlueDemoRole(stack, id);
    }
}
exports.GlueDemoRole = GlueDemoRole;
_a = JSII_RTTI_SYMBOL_1;
GlueDemoRole[_a] = { fqn: "aws-analytics-reference-architecture.GlueDemoRole", version: "2.7.0" };
//# sourceMappingURL=data:application/json;base64,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