import { ISubnet } from 'aws-cdk-lib/aws-ec2';
import { NodegroupOptions } from 'aws-cdk-lib/aws-eks';
/**
 * The Options for adding EmrEksNodegroup to an EmrEksCluster. Some of the Amazon EKS Nodegroup parameters are overriden:
 * -  NodegroupName by the id and an index per AZ
 * -  LaunchTemplate spec
 * -  SubnetList by either the subnet parameter or one subnet per Amazon EKS Cluster AZ.
 * -  Labels and Taints are automatically used to tag the nodegroup for the cluster autoscaler
 */
export interface EmrEksNodegroupOptions extends NodegroupOptions {
    /**
     * Set to true if using instance types with local NVMe drives to mount them automatically at boot time
     * @default false
     */
    readonly mountNvme?: boolean;
    /**
     * Configure the Amazon EKS NodeGroup in this subnet. Use this setting for resource dependencies like an Amazon RDS database.
     * The subnet must include the availability zone information because the nodegroup is tagged with the AZ for the K8S Cluster Autoscaler.
     * @default - One NodeGroup is deployed per cluster AZ
     */
    readonly subnet?: ISubnet;
}
/**
 * @summary EmrEksNodegroup containing the default Nodegroups
 */
export declare class EmrEksNodegroup {
    static readonly TOOLING_ALL: EmrEksNodegroupOptions;
    /**
     * Default nodegroup configuration for EMR on EKS critical workloads (both drivers and executors)
     */
    static readonly CRITICAL_ALL: EmrEksNodegroupOptions;
    /**
     * Default nodegroup configuration for EMR on EKS shared (non-crtical) workloads (drivers only)
     */
    static readonly SHARED_DRIVER: EmrEksNodegroupOptions;
    /**
     * Default nodegroup configuration for EMR on EKS shared (non-crtical) workloads (executors only)
     */
    static readonly SHARED_EXECUTOR: EmrEksNodegroupOptions;
    /**
     * Default nodegroup configuration for EMR Studio notebooks used with EMR on EKS (executors only)
     */
    static readonly NOTEBOOK_EXECUTOR: EmrEksNodegroupOptions;
    /**
     * Default nodegroup configuration for EMR Studio notebooks used with EMR on EKS (drivers only)
     */
    static readonly NOTEBOOK_DRIVER: EmrEksNodegroupOptions;
    /**
     * Default nodegroup configuration for EMR Studio notebooks used with EMR on EKS
     * This nodegroup is replacing [NOTEBOOK_DRIVER]{@link EmrEksNodegroup.NOTEBOOK_DRIVER}
     * and [NOTEBOOK_EXECUTOR]{@link EmrEksNodegroup.NOTEBOOK_EXECUTOR} because EMR on EKS
     * Managed Endpoint currently doesn't support Pod Template customization
     */
    static readonly NOTEBOOK_WITHOUT_PODTEMPLATE: EmrEksNodegroupOptions;
}
