"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrEksJobTemplateProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const pre_bundled_function_1 = require("../common/pre-bundled-function");
const constructs_1 = require("constructs");
const pre_bundled_layer_1 = require("../common/pre-bundled-layer");
/**
 * A custom resource provider for CRUD operations on Amazon EMR on EKS Managed Endpoints.
 * @private
 */
class EmrEksJobTemplateProvider extends constructs_1.Construct {
    /**
     * Constructs a new instance of the ManageEndpointProvider. The provider can then be used to create Amazon EMR on EKS Managed Endpoint custom resources
     * @param { Construct} scope the Scope of the CDK Construct
     * @param id the ID of the CDK Construct
     * @private
     */
    constructor(scope, id) {
        super(scope, id);
        //The policy allowing the creatio of the job template
        const lambdaPolicy = [
            new aws_iam_1.PolicyStatement({
                resources: ['*'],
                actions: ['emr-containers:DeleteJobTemplate'],
                conditions: { StringEquals: { 'aws:ResourceTag/for-use-with': 'cdk-analytics-reference-architecture' } }
            }),
            new aws_iam_1.PolicyStatement({
                resources: ['*'],
                actions: ['emr-containers:CreateJobTemplate', 'emr-containers:TagResource'],
                conditions: { StringEquals: { 'aws:RequestTag/for-use-with': 'cdk-analytics-reference-architecture' } }
            }),
        ];
        // AWS Lambda function supporting the create, update, delete operations on Amazon EMR on EKS managed endpoints
        const onEvent = new pre_bundled_function_1.PreBundledFunction(this, 'OnEvent', {
            codePath: 'emr-eks-platform/resources/lambdas/job-template',
            runtime: aws_lambda_1.Runtime.PYTHON_3_9,
            handler: 'lambda.on_event',
            layers: [pre_bundled_layer_1.PreBundledLayer.getOrCreate(scope, 'common/resources/lambdas/pre-bundled-layer')],
            lambdaPolicyStatements: lambdaPolicy,
            logRetention: aws_logs_1.RetentionDays.ONE_WEEK,
            timeout: aws_cdk_lib_1.Duration.seconds(120),
        });
        this.provider = new custom_resources_1.Provider(this, 'CustomResourceProvider', {
            onEventHandler: onEvent,
            providerFunctionName: 'jobTemplateFn',
        });
    }
}
exports.EmrEksJobTemplateProvider = EmrEksJobTemplateProvider;
_a = JSII_RTTI_SYMBOL_1;
EmrEksJobTemplateProvider[_a] = { fqn: "aws-analytics-reference-architecture.EmrEksJobTemplateProvider", version: "2.7.0" };
//# sourceMappingURL=data:application/json;base64,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