"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2SsmRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
/**
 * Construct extending IAM Role with AmazonSSMManagedInstanceCore managed policy
 */
class Ec2SsmRole extends aws_iam_1.Role {
    /**
     * Constructs a new instance of the Ec2SsmRole class.
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @param {RoleProps} props the RoleProps [properties]{@link RoleProps}
     * @since 1.0.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
    }
}
exports.Ec2SsmRole = Ec2SsmRole;
_a = JSII_RTTI_SYMBOL_1;
Ec2SsmRole[_a] = { fqn: "aws-analytics-reference-architecture.Ec2SsmRole", version: "2.7.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWMyLXNzbS1yb2xlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2VjMi1zc20tcm9sZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLGlEQUFxRTtBQUdyRTs7R0FFRztBQUVILE1BQWEsVUFBVyxTQUFRLGNBQUk7SUFFbEM7Ozs7Ozs7T0FPRztJQUVILFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBZ0I7UUFDeEQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDeEIsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHVCQUFhLENBQUMsd0JBQXdCLENBQUMsOEJBQThCLENBQUMsQ0FBQyxDQUFDO0lBQ2hHLENBQUM7O0FBZEgsZ0NBZUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBSb2xlLCBSb2xlUHJvcHMsIE1hbmFnZWRQb2xpY3kgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4vKipcbiAqIENvbnN0cnVjdCBleHRlbmRpbmcgSUFNIFJvbGUgd2l0aCBBbWF6b25TU01NYW5hZ2VkSW5zdGFuY2VDb3JlIG1hbmFnZWQgcG9saWN5XG4gKi9cblxuZXhwb3J0IGNsYXNzIEVjMlNzbVJvbGUgZXh0ZW5kcyBSb2xlIHtcblxuICAvKipcbiAgICogQ29uc3RydWN0cyBhIG5ldyBpbnN0YW5jZSBvZiB0aGUgRWMyU3NtUm9sZSBjbGFzcy5cbiAgICogQHBhcmFtIHtDb25zdHJ1Y3R9IHNjb3BlIHRoZSBTY29wZSBvZiB0aGUgQ0RLIENvbnN0cnVjdFxuICAgKiBAcGFyYW0ge3N0cmluZ30gaWQgdGhlIElEIG9mIHRoZSBDREsgQ29uc3RydWN0XG4gICAqIEBwYXJhbSB7Um9sZVByb3BzfSBwcm9wcyB0aGUgUm9sZVByb3BzIFtwcm9wZXJ0aWVzXXtAbGluayBSb2xlUHJvcHN9XG4gICAqIEBzaW5jZSAxLjAuMFxuICAgKiBAYWNjZXNzIHB1YmxpY1xuICAgKi9cblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUm9sZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gICAgdGhpcy5hZGRNYW5hZ2VkUG9saWN5KE1hbmFnZWRQb2xpY3kuZnJvbUF3c01hbmFnZWRQb2xpY3lOYW1lKCdBbWF6b25TU01NYW5hZ2VkSW5zdGFuY2VDb3JlJykpO1xuICB9XG59Il19