# pylint: skip-file
"""Module with OUIs for Bluetooth addresses.

Usage:

>>> from bluetooth_numbers import oui
>>> oui["58:2D:34"]
'Qingping Electronics (Suzhou) Co., Ltd'
"""
from bluetooth_numbers.dicts import OUIDict

oui = OUIDict(
    {  # OUIs for Bluetooth addresses
        "00:22:72": "American Micro-Fuel Device Corp.",
        "00:D0:EF": "IGT",
        "08:61:95": "Rockwell Automation",
        "F4:BD:9E": "Cisco Systems, Inc",
        "58:85:E9": "Realme Chongqing MobileTelecommunications Corp Ltd",
        "BC:23:92": "BYD Precision Manufacture Company Ltd.",
        "40:55:82": "Nokia",
        "A4:E3:1B": "Nokia",
        "D8:97:90": "Commonwealth Scientific and Industrial Research Organisation",
        "88:3A:30": "Aruba, a Hewlett Packard Enterprise Company",
        "B8:A5:8D": "Axe Group Holdings Limited",
        "50:CE:E3": "Gigafirm.co.LTD",
        "98:E7:43": "Dell Inc.",
        "C4:19:D1": "Telink Semiconductor (Shanghai) Co., Ltd.",
        "88:7E:25": "Extreme Networks, Inc.",
        "08:60:83": "zte corporation",
        "E0:19:54": "zte corporation",
        "10:32:7E": "Huawei Device Co., Ltd.",
        "F8:08:4F": "Sagemcom Broadband SAS",
        "30:FB:B8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F4:97:C2": "Nebulon Inc",
        "A4:45:19": "Xiaomi Communications Co Ltd",
        "68:DB:F5": "Amazon Technologies Inc.",
        "24:46:C8": "Motorola Mobility LLC, a Lenovo Company",
        "18:02:AE": "vivo Mobile Communication Co., Ltd.",
        "0C:20:D3": "vivo Mobile Communication Co., Ltd.",
        "44:D7:91": "HUAWEI TECHNOLOGIES CO.,LTD",
        "84:46:FE": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D8:29:18": "HUAWEI TECHNOLOGIES CO.,LTD",
        "64:B2:1D": "Chengdu Phycom Tech Co., Ltd.",
        "C4:29:96": "Signify B.V.",
        "98:06:37": "IEEE Registration Authority",
        "8C:B8:4A": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "98:E8:FA": "Nintendo Co.,Ltd",
        "38:C4:E8": "NSS Sp. z o.o.",
        "34:DD:7E": "Umeox Innovations Co.,Ltd",
        "CC:CD:64": "SM-Electronic GmbH",
        "24:DF:A7": "Hangzhou BroadLink Technology Co.,Ltd",
        "B0:65:F1": "WIO Manufacturing HK Limited",
        "90:12:34": "Shenzhen YOUHUA Technology Co., Ltd",
        "54:2A:1B": "Sonos, Inc.",
        "5C:92:5E": "Zioncom Electronics (Shenzhen) Ltd.",
        "08:4F:A9": "Cisco Systems, Inc",
        "08:4F:F9": "Cisco Systems, Inc",
        "50:98:B8": "New H3C Technologies Co., Ltd",
        "11:00:AA": "Private",
        "B8:4D:EE": "Hisense broadband multimedia technology Co.,Ltd",
        "A8:93:52": "SHANGHAI ZHONGMI COMMUNICATION TECHNOLOGY CO.,LTD",
        "E4:CC:9D": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "A8:D0:E3": "Systech Electronics Ltd",
        "98:BA:39": "Doro AB",
        "D4:6B:A6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "CC:05:77": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:8B:B2": "Cisco Systems, Inc",
        "E0:EB:62": "Shanghai Hulu Devices Co., Ltd",
        "08:68:8D": "New H3C Technologies Co., Ltd",
        "E8:6F:38": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "48:21:6C": "China Mobile IOT Company Limited",
        "8C:BE:24": "Tashang Semiconductor(Shanghai) Co., Ltd.",
        "08:B3:AF": "vivo Mobile Communication Co., Ltd.",
        "30:86:2D": "Arista Network, Inc.",
        "6C:E8:C6": "Earda Technologies co Ltd",
        "1C:41:76": "China Mobile Group Device Co.,Ltd.",
        "60:8B:0E": "Apple, Inc.",
        "18:71:D5": "Hazens Automotive Electronics(SZ)Co.,Ltd.",
        "AC:B1:EE": "SHENZHEN FENDA TECHNOLOGY CO., LTD",
        "F8:AD:CB": "HMD Global Oy",
        "D4:62:EA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "54:BA:D6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "94:DC:4E": "AEV, spol. s r. o.",
        "14:42:FC": "Texas Instruments",
        "AC:5D:5C": "FN-LINK TECHNOLOGY LIMITED",
        "54:DE:D0": "Sevio Srl",
        "6C:5E:3B": "Cisco Systems, Inc",
        "40:19:20": "Movon Corporation",
        "D0:37:45": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "60:3A:7C": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "00:01:78": "MARGI Systems, Inc.",
        "0C:B7:71": "ARRIS Group, Inc.",
        "58:C8:76": "China Mobile (Hangzhou) Information Technology Co., Ltd.",
        "2C:1E:4F": "Chengdu Qianli Network Technology Co., Ltd.",
        "00:90:52": "SELCOM ELETTRONICA S.R.L.",
        "00:1A:83": "Pegasus Technologies Inc.",
        "24:16:6D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "94:0B:19": "HUAWEI TECHNOLOGIES CO.,LTD",
        "70:C7:F2": "HUAWEI TECHNOLOGIES CO.,LTD",
        "38:94:ED": "NETGEAR",
        "70:04:33": "California Things Inc.",
        "DC:A6:32": "Raspberry Pi Trading Ltd",
        "88:F5:6E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "BC:97:E1": "Broadcom Limited",
        "28:D1:B7": "Shenzhen YOUHUA Technology Co., Ltd",
        "C8:C2:FA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "88:B3:62": "Nokia Shanghai Bell Co., Ltd.",
        "08:47:D0": "Nokia Shanghai Bell Co., Ltd.",
        "08:9C:86": "Nokia Shanghai Bell Co., Ltd.",
        "7C:89:56": "Samsung Electronics Co.,Ltd",
        "9C:93:E4": "Private",
        "88:29:9C": "Samsung Electronics Co.,Ltd",
        "CC:90:93": "Hansong Tehnologies",
        "CC:64:A6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:31:7D": "Hosiden Corporation",
        "F0:A9:68": "Antailiye Technology Co.,Ltd",
        "48:E1:E9": "Chengdu Meross Technology Co., Ltd.",
        "D8:13:99": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "54:E0:19": "Ring LLC",
        "14:84:30": "MITAC COMPUTING TECHNOLOGY CORPORATION",
        "B8:A4:4F": "Axis Communications AB",
        "00:24:EB": "ClearPath Networks, Inc.",
        "50:AF:4D": "zte corporation",
        "C8:EA:F8": "zte corporation",
        "70:9F:2D": "zte corporation",
        "38:3B:26": "Jiangsu Qinheng Co., Ltd.",
        "5C:FA:FB": "Acubit",
        "9C:7B:EF": "Hewlett Packard",
        "74:2E:DB": "Perinet GmbH",
        "20:17:42": "LG Electronics",
        "CC:88:26": "LG Innotek",
        "EC:5B:73": "Advanced & Wise Technology Corp.",
        "84:8B:CD": "IEEE Registration Authority",
        "14:C0:3E": "ARRIS Group, Inc.",
        "C0:89:AB": "ARRIS Group, Inc.",
        "D4:4D:A4": "Murata Manufacturing Co., Ltd.",
        "F8:E5:CF": "CGI IT UK LIMITED",
        "68:82:F2": "grandcentrix GmbH",
        "D4:20:B0": "Mist Systems, Inc.",
        "08:ED:ED": "Zhejiang Dahua Technology Co., Ltd.",
        "60:92:F5": "ARRIS Group, Inc.",
        "00:22:AF": "Safety Vision, LLC",
        "A0:91:A2": "OnePlus Electronics (Shenzhen) Co., Ltd.",
        "00:80:B5": "UNITED NETWORKS INC.",
        "1C:69:7A": "EliteGroup Computer Systems Co., LTD",
        "4C:17:44": "Amazon Technologies Inc.",
        "B0:30:55": "China Mobile IOT Company Limited",
        "90:5C:34": "Sirius Electronic Systems Srl",
        "D4:6A:35": "Cisco Systems, Inc",
        "D0:9C:7A": "Xiaomi Communications Co Ltd",
        "C8:2C:2B": "IEEE Registration Authority",
        "80:20:DA": "Sagemcom Broadband SAS",
        "68:84:7E": "FUJITSU LIMITED",
        "00:30:85": "Cisco Systems, Inc",
        "60:5F:8D": "eero inc.",
        "C4:B3:6A": "Cisco Systems, Inc",
        "70:F7:54": "AMPAK Technology,Inc.",
        "6C:8B:D3": "Cisco Systems, Inc",
        "68:97:4B": "Shenzhen Costar Electronics Co. Ltd.",
        "34:E1:D1": "IEEE Registration Authority",
        "00:21:B7": "LEXMARK INTERNATIONAL, INC.",
        "00:A0:B0": "I-O DATA DEVICE,INC.",
        "24:79:F3": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "80:A2:35": "Edgecore Networks Corporation",
        "30:EA:26": "Sycada BV",
        "9C:49:7F": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "C4:E3:9F": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "F8:9A:78": "HUAWEI TECHNOLOGIES CO.,LTD",
        "88:F8:72": "HUAWEI TECHNOLOGIES CO.,LTD",
        "EC:56:23": "HUAWEI TECHNOLOGIES CO.,LTD",
        "54:86:BC": "Cisco Systems, Inc",
        "40:23:43": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "18:F1:8E": "ChipER Technology co. ltd",
        "00:04:22": "Studio Technologies, Inc",
        "80:DA:13": "eero inc.",
        "50:EC:50": "Beijing Xiaomi Mobile Software Co., Ltd",
        "60:61:DF": "Z-meta Research LLC",
        "70:57:BF": "New H3C Technologies Co., Ltd",
        "10:82:86": "Luxshare Precision Industry Co.,Ltd",
        "14:B4:57": "Silicon Laboratories",
        "DC:96:2C": "NST Audio Ltd",
        "18:02:2D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D8:BC:59": "Shenzhen DAPU Microelectronics Co., Ltd",
        "08:97:98": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "24:6F:28": "Espressif Inc.",
        "8C:79:F5": "Samsung Electronics Co.,Ltd",
        "48:F8:DB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:12:2A": "VTech Telecommunications Ltd.",
        "B0:51:8E": "Holl technology CO.Ltd.",
        "28:52:E0": "Layon international Electronic & Telecom Co.,Ltd",
        "58:CB:52": "Google, Inc.",
        "7C:61:66": "Amazon Technologies Inc.",
        "98:9B:CB": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "94:F7:AD": "Juniper Networks",
        "60:63:F9": "Ciholas, Inc.",
        "AC:8F:F8": "Nokia",
        "60:03:A6": "Inteno Broadband Technology AB",
        "7C:52:59": "Sichuan Jiuzhou Electronic Technology Co., Ltd.",
        "44:B2:95": "Sichuan AI-Link Technology Co., Ltd.",
        "94:24:E1": "Alcatel-Lucent Enterprise",
        "F8:CA:59": "NetComm Wireless",
        "88:B2:91": "Apple, Inc.",
        "C4:2A:D0": "Apple, Inc.",
        "CC:D2:81": "Apple, Inc.",
        "20:0D:B0": "Shenzhen Four Seas Global Link Network Technology Co., Ltd.",
        "D8:1E:DD": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "D4:3F:CB": "ARRIS Group, Inc.",
        "5C:76:95": "Technicolor CH USA Inc.",
        "F8:4D:33": "Fiberhome Telecommunication Technologies Co.,LTD",
        "C0:8A:CD": "Guangzhou Shiyuan Electronic Technology Company Limited",
        "AC:F6:F7": "LG Electronics (Mobile Communications)",
        "48:E6:C0": "SIMCom Wireless Solutions Co.,Ltd.",
        "38:3C:9C": "Fujian Newland Payment Technology Co.,Ltd.",
        "C0:2E:25": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "10:77:17": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD",
        "A8:6D:5F": "Raisecom Technology CO., LTD",
        "58:EC:ED": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "00:50:79": "Private",
        "10:0C:6B": "NETGEAR",
        "C4:F0:EC": "Fiberhome Telecommunication Technologies Co.,LTD",
        "E8:0F:C8": "Universal Electronics, Inc.",
        "E4:5D:37": "Juniper Networks",
        "00:EE:AB": "Cisco Systems, Inc",
        "54:A7:03": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "90:7A:58": "Zegna-Daidong Limited",
        "E0:09:BF": "SHENZHEN TONG BO WEI TECHNOLOGY Co.,LTD",
        "00:13:1E": "peiker acustic GmbH",
        "84:69:91": "Nokia",
        "00:1B:F7": "Lund IP Products AB",
        "78:36:07": "Cermate Technologies Inc.",
        "B0:00:73": "Wistron Neweb Corporation",
        "D8:8D:C8": "Atil Technology Co., LTD",
        "A8:E2:C1": "Texas Instruments",
        "90:9A:77": "Texas Instruments",
        "04:EE:03": "Texas Instruments",
        "4C:24:98": "Texas Instruments",
        "7C:D9:5C": "Google, Inc.",
        "C8:AA:CC": "Private",
        "00:21:67": "HWA JIN T&I Corp.",
        "00:0B:86": "Aruba, a Hewlett Packard Enterprise Company",
        "DC:31:D1": "vivo Mobile Communication Co., Ltd.",
        "C8:F7:50": "Dell Inc.",
        "D4:92:34": "NEC Corporation",
        "00:07:CB": "FREEBOX SAS",
        "14:9F:B6": "GUANGDONG GENIUS TECHNOLOGY CO., LTD.",
        "00:11:5A": "Ivoclar Vivadent AG",
        "4C:AE:A3": "Hewlett Packard Enterprise",
        "1C:2E:1B": "Suzhou Tremenet Communication Technology Co., Ltd.",
        "1C:24:EB": "Burlywood",
        "00:10:13": "Kontron America, Inc.",
        "2C:2B:F9": "LG Innotek",
        "D8:C7:C8": "Aruba, a Hewlett Packard Enterprise Company",
        "70:3A:0E": "Aruba, a Hewlett Packard Enterprise Company",
        "20:4C:03": "Aruba, a Hewlett Packard Enterprise Company",
        "58:C6:F0": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "84:A0:6E": "Sagemcom Broadband SAS",
        "A4:3E:A0": "iComm HK LIMITED",
        "64:C2:DE": "LG Electronics (Mobile Communications)",
        "8C:44:4F": "HUMAX Co., Ltd.",
        "00:67:62": "Fiberhome Telecommunication Technologies Co.,LTD",
        "2C:C4:07": "machineQ",
        "B4:ED:19": "Pie Digital, Inc.",
        "40:DF:02": "LINE BIZ Plus",
        "CC:E1:94": "Juniper Networks",
        "14:4E:2A": "Ciena Corporation",
        "84:13:9F": "zte corporation",
        "F0:51:EA": "Fitbit, Inc.",
        "50:33:F0": "YICHEN (SHENZHEN) TECHNOLOGY CO.LTD",
        "FC:2B:B2": "Actiontec Electronics, Inc",
        "E0:9F:2A": "Iton Technology Corp. ",
        "4C:E1:9E": "TECNO MOBILE LIMITED",
        "AC:5A:EE": "China Mobile Group Device Co.,Ltd.",
        "70:BC:10": "Microsoft Corporation",
        "88:4A:18": "Opulinks",
        "9C:69:B4": "IEEE Registration Authority",
        "50:00:84": "Siemens Canada",
        "44:B4:33": "tide.co.,ltd",
        "D8:A6:FD": "Ghost Locomotion",
        "DC:21:B9": "Sentec Co.Ltd",
        "6C:DF:FB": "IEEE Registration Authority",
        "24:7D:4D": "Texas Instruments",
        "88:50:F6": "Shenzhen Jingxun Software Telecommunication Technology Co.,Ltd",
        "E4:98:BB": "Phyplus Microelectronics Limited",
        "60:A1:1E": "Wuhan Maxsine Electric Co.,Ltd.",
        "C4:5B:F7": "ants",
        "8C:DF:9D": "NEC Corporation",
        "5C:41:5A": "Amazon.com, LLC",
        "70:5E:55": "Realme Chongqing MobileTelecommunications Corp Ltd",
        "B0:D5:68": "Shenzhen Cultraview Digital Technology Co., Ltd",
        "F0:0E:BF": "ZettaHash Inc.",
        "70:35:09": "Cisco Systems, Inc",
        "44:1A:FA": "New H3C Technologies Co., Ltd",
        "04:07:2E": "VTech Electronics Ltd.",
        "78:0E:D1": "TRUMPF Werkzeugmaschinen GmbH+Co.KG",
        "44:EC:CE": "Juniper Networks",
        "F8:2F:08": "Molex CMS",
        "44:1C:12": "Technicolor CH USA Inc.",
        "44:28:A3": "Jiangsu fulian  Communication Technology Co., Ltd.",
        "10:C5:95": "Lenovo",
        "20:32:33": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
        "68:29:DC": "Ficosa Electronics S.L.U.",
        "94:54:DF": "YST CORP.",
        "7C:BC:84": "IEEE Registration Authority",
        "F8:0D:F1": "Sontex SA",
        "A4:94:26": "Elgama-Elektronika Ltd.",
        "E4:F1:4C": "Private",
        "A8:B4:56": "Cisco Systems, Inc",
        "2C:A9:F0": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "54:9B:72": "Ericsson AB",
        "A0:47:D7": "Best IT World (India) Pvt Ltd",
        "68:99:CD": "Cisco Systems, Inc",
        "10:40:F3": "Apple, Inc.",
        "58:6B:14": "Apple, Inc.",
        "BC:B8:63": "Apple, Inc.",
        "2C:1C:F6": "Alien Green LLC",
        "6C:2B:59": "Dell Inc.",
        "44:E6:6E": "Apple, Inc.",
        "C0:E8:62": "Apple, Inc.",
        "F4:06:16": "Apple, Inc.",
        "0C:FE:5D": "IEEE Registration Authority",
        "3C:8D:20": "Google, Inc.",
        "60:1D:91": "Motorola Mobility LLC, a Lenovo Company",
        "D4:C9:4B": "Motorola Mobility LLC, a Lenovo Company",
        "08:35:1B": "Shenzhen Jialihua Electronic Technology Co., Ltd",
        "AC:15:85": "silergy corp",
        "AC:50:93": "Magna Electronics Europe GmbH & Co. OHG",
        "70:BB:E9": "Xiaomi Communications Co Ltd",
        "50:A0:A4": "Nokia",
        "00:D0:2D": "Resideo",
        "80:69:40": "LEXAR CO.,LIMITED",
        "64:F8:1C": "Huawei Technologies Co., Ltd.",
        "10:98:C3": "Murata Manufacturing Co., Ltd.",
        "9C:C8:FC": "ARRIS Group, Inc.",
        "B0:7E:11": "Texas Instruments",
        "10:C7:53": "Qingdao Intelligent&Precise Electronics Co.,Ltd.",
        "F4:95:1B": "Hefei Radio Communication Technology Co., Ltd ",
        "6C:38:45": "Fiberhome Telecommunication Technologies Co.,LTD",
        "2C:61:04": "SHENZHEN FENGLIAN TECHNOLOGY CO., LTD.",
        "BC:93:25": "Ningbo Joyson Preh Car Connect Co.,Ltd.  ",
        "D0:B6:0A": "Xingluo Technology Company  Limited",
        "04:92:26": "ASUSTek COMPUTER INC.",
        "E8:AD:A6": "Sagemcom Broadband SAS",
        "0C:1C:19": "LONGCONN ELECTRONICS(SHENZHEN) CO.,LTD",
        "90:E7:10": "New H3C Technologies Co., Ltd",
        "30:29:52": "Hillstone Networks Inc",
        "E0:13:B5": "vivo Mobile Communication Co., Ltd.",
        "E0:79:5E": "Wuxi Xiaohu Technology Co.,Ltd.",
        "00:B1:E3": "Cisco Systems, Inc",
        "A4:11:94": "Lenovo",
        "00:CB:00": "Private",
        "DC:F4:01": "Dell Inc.",
        "0C:41:01": "Ruichi Auto Technology (Guangzhou) Co., Ltd.",
        "00:B7:71": "Cisco Systems, Inc",
        "E4:B2:FB": "Apple, Inc.",
        "2C:CA:0C": "WITHUS PLANET",
        "84:32:6F": "GUANGZHOU AVA ELECTRONICS TECHNOLOGY CO.,LTD ",
        "C8:9C:13": "Inspiremobile",
        "8C:85:E6": "Cleondris GmbH",
        "80:7D:14": "HUAWEI TECHNOLOGIES CO.,LTD",
        "20:28:3E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A4:FC:77": "Mega Well Limited",
        "4C:56:9D": "Apple, Inc.",
        "38:53:9C": "Apple, Inc.",
        "40:26:19": "Apple, Inc.",
        "6C:E8:5C": "Apple, Inc.",
        "04:91:62": "Microchip Technology Inc.",
        "F8:38:80": "Apple, Inc.",
        "2C:79:D7": "Sagemcom Broadband SAS",
        "00:B4:F5": "DongGuan Siyoto Electronics Co., Ltd       ",
        "BC:3F:4E": "Teleepoch Ltd",
        "18:38:AE": "CONSPIN SOLUTION",
        "04:CF:8C": "XIAOMI Electronics,CO.,LTD",
        "0C:75:12": "Shenzhen Kunlun TongTai Technology  Co.,Ltd.",
        "50:57:9C": "Seiko Epson Corporation",
        "54:27:8D": "NXP (China) Management Ltd.",
        "B0:BE:76": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "44:47:CC": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "4C:D9:8F": "Dell Inc.",
        "B0:AE:25": "Varikorea",
        "4C:1B:86": "Arcadyan Corporation",
        "EC:C4:0D": "Nintendo Co.,Ltd",
        "44:00:49": "Amazon Technologies Inc.",
        "E8:6A:64": "LCFC(HeFei) Electronics Technology co., ltd",
        "10:A2:4E": "GOLD3LINK ELECTRONICS CO., LTD",
        "CC:C5:E5": "Dell Inc.",
        "6C:C3:74": "Texas Instruments",
        "68:47:49": "Texas Instruments",
        "F8:D9:B8": "Open Mesh, Inc.",
        "7C:69:6B": "Atmosic Technologies",
        "5C:D2:0B": "Yytek Co., Ltd.",
        "70:03:7E": "Technicolor CH USA Inc.",
        "D0:03:DF": "Samsung Electronics Co.,Ltd",
        "C4:23:A2": "PT. Emsonic Indonesia",
        "B4:CB:57": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "4C:12:65": "ARRIS Group, Inc.",
        "00:50:0C": "e-Tek Labs, Inc.",
        "48:5F:99": "Cloud Network Technology (Samoa) Limited",
        "88:34:FE": "Bosch Automotive Products (Suzhou) Co. Ltd",
        "88:F7:BF": "vivo Mobile Communication Co., Ltd.",
        "D8:7D:7F": "Sagemcom Broadband SAS",
        "00:05:1A": "3COM EUROPE LTD",
        "08:00:4E": "3COM EUROPE LTD",
        "00:30:1E": "3COM EUROPE LTD",
        "00:50:04": "3COM",
        "00:01:03": "3COM",
        "58:B5:68": "SECURITAS DIRECT ESPAÑA, SAU",
        "48:4A:E9": "Hewlett Packard Enterprise",
        "84:6A:66": "Sumitomo Kizai  Co.,Ltd.",
        "18:D7:17": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "80:B6:24": "IVS",
        "DC:F5:05": "AzureWave Technology Inc.",
        "CC:F0:FD": "China Mobile (Hangzhou) Information Technology Co., Ltd.",
        "84:89:EC": "IEEE Registration Authority",
        "88:10:8F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F4:63:1F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A4:9B:4F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:07:3A": "INVENTEL",
        "00:26:6C": "INVENTEC CORPORATION",
        "00:8C:FA": "INVENTEC CORPORATION",
        "5C:FB:7C": "Shenzhen Jingxun Software Telecommunication Technology Co.,Ltd",
        "FC:03:9F": "Samsung Electronics Co.,Ltd",
        "02:C0:8C": "3COM",
        "00:57:C1": "LG Electronics (Mobile Communications)",
        "7C:24:0C": "Telechips, Inc.",
        "00:20:3D": "Honeywell Environmental & Combustion Controls",
        "A4:D9:90": "Samsung Electronics Co.,Ltd",
        "00:60:87": "KANSAI ELECTRIC CO., LTD.",
        "DC:F7:19": "Cisco Systems, Inc",
        "A0:95:0C": "China Mobile IOT Company Limited",
        "D4:74:1B": "Beijing HuaDa ZhiBao Electronic System Co.,Ltd.",
        "00:1B:C0": "Juniper Networks",
        "2C:15:E1": "Phicomm (Shanghai) Co., Ltd.",
        "30:D1:6B": "Liteon Technology Corporation",
        "98:AE:71": "VVDN Technologies Pvt Ltd",
        "A4:56:CC": "Technicolor CH USA Inc.",
        "AC:6E:1A": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "00:80:EB": "COMPCONTROL B.V.",
        "00:02:EB": "Pico Communications",
        "34:2E:B6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "AC:92:32": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:0F:B0": "Compal Electronics INC.",
        "00:02:3F": "Compal Electronics INC.",
        "68:A8:E1": "Wacom Co.,Ltd.",
        "30:D3:2D": "devolo AG",
        "BC:F2:AF": "devolo AG",
        "E0:AF:4F": "Deutsche Telekom AG",
        "B8:69:F4": "Routerboard.com",
        "28:3A:4D": "Cloud Network Technology (Samoa) Limited",
        "B8:7C:6F": "NXP (China) Management Ltd.",
        "30:5D:A6": "ADVALY SYSTEM Inc.",
        "BC:30:D9": "Arcadyan Corporation",
        "04:79:B7": "Texas Instruments",
        "C0:D0:FF": "China Mobile IOT Company Limited",
        "88:DF:9E": "New H3C Technologies Co., Ltd",
        "2C:7C:E4": "Wuhan Tianyu Information Industry Co., Ltd.",
        "58:03:FB": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "14:48:02": "THE YEOLRIM Co.,Ltd.",
        "40:31:3C": "XIAOMI Electronics,CO.,LTD",
        "FC:45:96": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "A0:E5:34": "Stratec Biomedical AG",
        "44:4B:5D": "GE Healthcare",
        "00:15:55": "DFM GmbH",
        "1C:75:08": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "00:1B:38": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "00:23:5A": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "24:D7:6B": "Syntronic AB",
        "C4:FE:E2": "AMICCOM Electronics Corporation",
        "78:0C:F0": "Cisco Systems, Inc",
        "0C:8C:24": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
        "8C:6D:77": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E8:C5:7A": "Ufispace Co., LTD.",
        "E0:12:83": "Shenzhen Fanzhuo Communication Technology Co., Lt",
        "A0:CF:5B": "Cisco Systems, Inc",
        "00:24:21": "MICRO-STAR INT'L CO., LTD.",
        "00:60:D1": "CASCADE COMMUNICATIONS",
        "84:C9:C6": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "88:B6:6B": "easynetworks",
        "24:F5:7E": "HWH CO., LTD.",
        "8C:A0:48": "Beijing NeTopChip Technology Co.,LTD",
        "24:D3:F2": "zte corporation",
        "D4:69:A5": "Miura Systems Ltd.",
        "8C:81:26": "ARCOM",
        "D4:7C:44": "IEEE Registration Authority",
        "80:5E:4F": "FN-LINK TECHNOLOGY LIMITED",
        "84:17:EF": "Technicolor CH USA Inc.",
        "38:56:B5": "Peerbridge Health Inc",
        "7C:96:D2": "Fihonest communication co.,Ltd",
        "C0:42:D0": "Juniper Networks",
        "D0:C5:D8": "LATECOERE",
        "20:A6:0C": "Xiaomi Communications Co Ltd",
        "48:8A:D2": "MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "DC:E8:38": "CK Telecom (Shenzhen) Limited",
        "A8:D4:98": "Avira Operations GmbH & Co. KG",
        "50:59:67": "Intent Solutions Inc",
        "00:06:80": "Card Access, Inc.",
        "3C:57:6C": "Samsung Electronics Co.,Ltd",
        "84:17:66": "WEIFANG GOERTEK ELECTRONICS CO.,LTD",
        "2C:4D:79": "WEIFANG GOERTEK ELECTRONICS CO.,LTD",
        "00:0C:42": "Routerboard.com",
        "00:26:BD": "JTEC Card &amp; Communication Co., Ltd",
        "60:D0:2C": "Ruckus Wireless",
        "14:57:9F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B4:43:26": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:D2:94": "NETGEAR",
        "70:9F:A9": "TECNO MOBILE LIMITED",
        "0C:01:DB": "Infinix mobility limited",
        "08:C5:E1": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "18:66:C7": "Shenzhen Libre Technology Co., Ltd",
        "5C:B3:F6": "Human, Incorporated",
        "2C:48:35": "IEEE Registration Authority",
        "48:2A:E3": "Wistron InfoComm(Kunshan)Co.,Ltd.",
        "FC:A6:CD": "Fiberhome Telecommunication Technologies Co.,LTD",
        "44:C8:74": "China Mobile Group Device Co.,Ltd.",
        "74:C1:4F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B0:EB:57": "HUAWEI TECHNOLOGIES CO.,LTD",
        "18:69:DA": "China Mobile Group Device Co.,Ltd.",
        "F8:5C:4D": "Nokia",
        "2C:58:4F": "ARRIS Group, Inc.",
        "F0:4B:3A": "Juniper Networks",
        "54:BF:64": "Dell Inc.",
        "A8:5B:6C": "Robert Bosch Gmbh, CM-CI2",
        "C8:B1:EE": "Qorvo",
        "00:FC:BA": "Cisco Systems, Inc",
        "00:CB:B4": "SHENZHEN ATEKO PHOTOELECTRICITY CO.,LTD",
        "4C:C0:0A": "vivo Mobile Communication Co., Ltd.",
        "9C:E8:2B": "vivo Mobile Communication Co., Ltd.",
        "70:79:B3": "Cisco Systems, Inc",
        "D8:18:D3": "Juniper Networks",
        "14:9B:2F": "JiangSu ZhongXie Intelligent Technology co., LTD",
        "38:35:FB": "Sagemcom Broadband SAS",
        "48:DD:9D": "ITEL MOBILE LIMITED",
        "A0:75:EA": "BoxLock, Inc.",
        "F0:4C:D5": "Maxlinear, Inc",
        "00:01:AE": "Trex Enterprises",
        "00:E0:09": "Stratus Technologies",
        "E4:EA:83": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "74:EC:42": "Fiberhome Telecommunication Technologies Co.,LTD",
        "D4:FC:13": "Fiberhome Telecommunication Technologies Co.,LTD",
        "80:7D:3A": "Espressif Inc.",
        "EC:AF:97": "GIT",
        "A0:B0:45": "Halong Mining",
        "E0:BA:B4": "Arrcus, Inc",
        "58:9B:0B": "Shineway Technologies, Inc.",
        "D8:16:0A": "Nippon Electro-Sensory Devices",
        "10:C0:7C": "Blu-ray Disc Association",
        "40:A6:77": "Juniper Networks",
        "E4:B0:21": "Samsung Electronics Co.,Ltd",
        "9C:7F:57": "UNIC Memory Technology Co Ltd",
        "B4:E0:1D": "CONCEPTION ELECTRONIQUE",
        "1C:00:42": "NARI Technology Co., Ltd.",
        "44:34:A7": "ARRIS Group, Inc.",
        "3C:E1:A1": "Universal Global Scientific Industrial Co., Ltd.",
        "F8:98:EF": "HUAWEI TECHNOLOGIES CO.,LTD",
        "58:F9:87": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A8:F5:AC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "58:BA:D4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "70:1D:08": "99IOT Shenzhen co.,ltd",
        "74:12:BB": "Fiberhome Telecommunication Technologies Co.,LTD",
        "00:10:27": "L-3 COMMUNICATIONS EAST",
        "BC:26:43": "Elprotronic Inc.",
        "04:E2:29": "Qingdao Haier Technology Co.,Ltd",
        "34:8B:75": "LAVA INTERNATIONAL(H.K) LIMITED",
        "9C:E8:95": "New H3C Technologies Co., Ltd",
        "00:58:3F": "PC Aquarius",
        "90:3D:68": "G-Printec, Inc.",
        "10:94:BB": "Apple, Inc.",
        "78:1D:4A": "zte corporation",
        "94:E1:AC": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "34:E8:94": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "F8:6F:C1": "Apple, Inc.",
        "28:FF:3C": "Apple, Inc.",
        "F0:99:B6": "Apple, Inc.",
        "88:E9:FE": "Apple, Inc.",
        "38:89:2C": "Apple, Inc.",
        "74:9E:AF": "Apple, Inc.",
        "94:BF:2D": "Apple, Inc.",
        "68:CA:E4": "Cisco Systems, Inc",
        "00:BE:3B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "7C:A1:77": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:2E:02": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:B6:EC": "Scuf Gaming International LLC",
        "80:35:C1": "Xiaomi Communications Co Ltd",
        "58:B3:FC": "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD.",
        "20:47:DA": "Xiaomi Communications Co Ltd",
        "24:29:FE": "KYOCERA Corporation ",
        "7C:49:EB": "XIAOMI Electronics,CO.,LTD",
        "C4:33:06": "China Mobile Group Device Co.,Ltd.",
        "08:DF:CB": "Systrome Networks",
        "A4:93:3F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "28:AC:9E": "Cisco Systems, Inc",
        "68:D4:82": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "98:45:62": "Shanghai Baud Data Communication Co.,Ltd.",
        "E4:C4:83": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "00:1F:BA": "Boyoung Tech",
        "A4:33:D7": "MitraStar Technology Corp.",
        "B0:AC:D2": "zte corporation",
        "20:0F:70": "FOXTECH",
        "20:2D:23": "Collinear Networks Inc.",
        "90:83:4B": "BEIJING YUNYI TIMES TECHNOLOGY CO,.LTD",
        "18:50:2A": "SOARNEX",
        "A8:36:7A": "frogblue TECHNOLOGY GmbH",
        "6C:E4:DA": "NEC Platforms, Ltd.",
        "10:E7:C6": "Hewlett Packard",
        "18:31:BF": "ASUSTek COMPUTER INC.",
        "C8:FA:E1": "ARQ Digital LLC",
        "DC:A3:33": "Shenzhen YOUHUA Technology Co., Ltd",
        "78:8C:54": "Ping Communication",
        "B8:AF:67": "Hewlett Packard",
        "C0:98:DA": "China Mobile IOT Company Limited",
        "F0:0F:EC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "AC:07:5F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C0:48:E6": "Samsung Electronics Co.,Ltd",
        "88:2E:5A": "storONE",
        "00:71:47": "Amazon Technologies Inc.",
        "00:BE:75": "Cisco Systems, Inc",
        "64:DB:8B": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "78:25:7A": "LEO Innovation Lab",
        "10:A4:B9": "Baidu Online Network Technology (Beijing) Co., Ltd",
        "50:1C:B0": "Cisco Systems, Inc",
        "04:AC:44": "Holtek Semiconductor Inc.",
        "F4:DC:A5": "DAWON DNS",
        "80:CE:62": "Hewlett Packard",
        "80:1F:12": "Microchip Technology Inc.",
        "50:6C:BE": "InnosiliconTechnology Ltd",
        "24:7E:12": "Cisco Systems, Inc",
        "04:C2:41": "Nokia",
        "3C:47:9B": "Theissen Training Systems, Inc.",
        "60:6B:FF": "Nintendo Co.,Ltd",
        "8C:F7:10": "AMPAK Technology, Inc.",
        "30:7B:AC": "New H3C Technologies Co., Ltd",
        "78:5D:C8": "LG Electronics",
        "3C:04:61": "ARRIS Group, Inc.",
        "88:3D:24": "Google, Inc.",
        "E8:C1:B8": "Nanjing Bangzhong Electronic Commerce Limited",
        "D8:D7:75": "Sagemcom Broadband SAS",
        "E8:33:0D": "Xaptec GmbH",
        "D4:60:E3": "Sercomm Corporation.",
        "B4:A8:B9": "Cisco Systems, Inc",
        "50:DC:E7": "Amazon Technologies Inc.",
        "64:98:29": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "08:1D:C4": "Thermo Fisher Scientific Messtechnik GmbH",
        "78:53:64": "SHIFT GmbH",
        "38:E6:0A": "Xiaomi Communications Co Ltd",
        "40:CB:C0": "Apple, Inc.",
        "C4:61:8B": "Apple, Inc.",
        "CC:6E:A4": "Samsung Electronics Co.,Ltd",
        "80:3A:59": "AT&T",
        "58:8D:64": "Xi'an Clevbee Technology Co.,Ltd",
        "00:5D:73": "Cisco Systems, Inc",
        "60:6D:3C": "Luxshare Precision Industry Company Limited",
        "44:F0:34": "Kaonmedia CO., LTD.",
        "00:27:90": "Cisco Systems, Inc",
        "34:BA:38": "PAL MOHAN ELECTRONICS PVT LTD",
        "98:29:A6": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "CC:4D:38": "Carnegie Technologies",
        "08:E6:89": "Apple, Inc.",
        "DC:56:E7": "Apple, Inc.",
        "A8:16:D0": "Samsung Electronics Co.,Ltd",
        "A4:6C:F1": "Samsung Electronics Co.,Ltd",
        "08:AE:D6": "Samsung Electronics Co.,Ltd",
        "DC:BF:E9": "Motorola Mobility LLC, a Lenovo Company",
        "B4:2D:56": "Extreme Networks, Inc.",
        "40:64:A4": "THE FURUKAWA ELECTRIC CO., LTD",
        "6C:B2:AE": "Cisco Systems, Inc",
        "B0:98:2B": "Sagemcom Broadband SAS",
        "34:FA:9F": "Ruckus Wireless",
        "F0:65:C2": "Yanfeng Visteon Electronics Technology (Shanghai) Co.,Ltd.",
        "70:B7:E2": "Jiangsu Miter Technology Co.,Ltd.",
        "80:8D:B7": "Hewlett Packard Enterprise",
        "A0:9D:86": "Alcatel-Lucent Shanghai Bell Co., Ltd",
        "00:C0:FF": "Seagate Cloud Systems Inc",
        "D4:5D:DF": "PEGATRON CORPORATION",
        "F8:B5:68": "IEEE Registration Authority",
        "2C:6B:7D": "Texas Instruments",
        "88:D1:71": "BEGHELLI S.P.A",
        "A0:9D:C1": "China Dragon Technology Limited",
        "2C:42:05": "Lytx",
        "A8:25:EB": "Cambridge Industries(Group) Co.,Ltd.",
        "34:E3:80": "Genexis B.V.",
        "5C:58:19": "Jingsheng Technology Co., Ltd.",
        "B8:CA:04": "Holtek Semiconductor Inc.",
        "C4:C5:63": "TECNO MOBILE LIMITED",
        "80:B7:08": "Blue Danube Systems, Inc",
        "08:BC:20": "Hangzhou Royal Cloud Technology Co., Ltd",
        "94:2A:3F": "Diversey Inc",
        "20:31:EB": "HDSN",
        "F8:C9:6C": "Fiberhome Telecommunication Technologies Co.,LTD",
        "84:48:23": "WOXTER TECHNOLOGY Co. Ltd",
        "F4:1E:5E": "RtBrick Inc.",
        "6C:76:60": "KYOCERA CORPORATION ",
        "00:21:02": "UpdateLogic Inc.",
        "50:58:00": "WyTec International, Inc.",
        "C8:D1:2A": "Comtrend Corporation",
        "0C:EA:C9": "ARRIS Group, Inc.",
        "E8:2A:44": "Liteon Technology Corporation",
        "10:A4:BE": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
        "EC:C0:6A": "PowerChord Group Limited",
        "94:49:96": "WiSilica Inc",
        "F8:1D:0F": "Hitron Technologies. Inc",
        "00:94:A1": "F5 Networks, Inc.",
        "BC:F2:92": "PLANTRONICS, INC.",
        "04:50:DA": "Qiku Internet Network Scientific (Shenzhen) Co., Ltd",
        "E8:20:E2": "HUMAX Co., Ltd.",
        "00:26:A8": "DAEHAP HYPER-TECH",
        "78:5C:28": "Prime Motion Inc.",
        "8C:5B:F0": "ARRIS Group, Inc.",
        "18:90:D8": "Sagemcom Broadband SAS",
        "88:83:5D": "FN-LINK TECHNOLOGY LIMITED",
        "EC:9F:0D": "IEEE Registration Authority",
        "E0:78:A3": "Shanghai Winner Information Technology Co.,Inc",
        "00:05:A7": "HYPERCHIP Inc.",
        "08:84:66": "Novartis Pharma AG",
        "30:9F:FB": "Ardomus Networks Corporation",
        "28:23:73": "Digita",
        "64:9A:08": "Shenzhen SuperElectron Technology Co.,LTD",
        "68:A6:82": "Shenzhen YOUHUA Technology Co., Ltd",
        "58:7A:62": "Texas Instruments",
        "54:7A:52": "CTE International srl",
        "F0:6E:0B": "Microsoft Corporation",
        "34:6F:ED": "Enovation Controls",
        "54:33:CB": "Apple, Inc.",
        "34:08:BC": "Apple, Inc.",
        "1C:36:BB": "Apple, Inc.",
        "3C:2E:FF": "Apple, Inc.",
        "00:E0:25": "dit Co., Ltd.",
        "AC:84:C6": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "00:15:30": "Dell EMC",
        "0C:B2:B7": "Texas Instruments",
        "24:F6:77": "Apple, Inc.",
        "B0:CA:68": "Apple, Inc.",
        "C8:3C:85": "Apple, Inc.",
        "78:87:0D": "Unifiedgateways India Private Limited",
        "A8:82:00": "Hisense Electric Co.,Ltd",
        "38:20:A8": "ColorTokens, Inc.",
        "70:58:96": "InShow Technology",
        "00:05:89": "National Datacomputer",
        "3C:A6:16": "vivo Mobile Communication Co., Ltd.",
        "9C:E0:63": "Samsung Electronics Co.,Ltd",
        "D0:31:69": "Samsung Electronics Co.,Ltd",
        "24:F2:7F": "Hewlett Packard Enterprise",
        "BC:05:43": "AVM GmbH",
        "00:B6:9F": "Latch",
        "84:2C:80": "Sichuan Changhong Electric Ltd.",
        "3C:C0:79": "Shenzhen One-Nine Intelligent Electronic Science and Technology Co., Ltd",
        "98:C5:DB": "Ericsson AB",
        "14:9F:3C": "Samsung Electronics Co.,Ltd",
        "FC:EE:E6": "FORMIKE ELECTRONIC CO., LTD",
        "84:E3:27": "TAILYN TECHNOLOGIES INC",
        "00:21:B8": "Inphi Corporation",
        "0C:91:60": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "D8:ED:1C": "Magna Technology SL",
        "40:8B:F6": "Shenzhen TCL New Technology Co., Ltd",
        "00:00:6B": "Silicon Graphics",
        "74:37:3B": "UNINET Co.,Ltd.",
        "7C:64:56": "Samsung Electronics Co.,Ltd",
        "F4:6E:24": "NEC Personal Computers, Ltd.",
        "88:82:79": "Shenzhen RB-LINK Intelligent Technology Co.Ltd",
        "68:C6:3A": "Espressif Inc.",
        "A0:64:8F": "ASKEY COMPUTER CORP",
        "C8:50:E9": "Raisecom Technology CO., LTD",
        "10:F1:63": "TNK CO.,LTD",
        "98:EF:9B": "OHSUNG",
        "14:CF:8D": "OHSUNG",
        "10:44:00": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B0:E1:7E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E4:A7:C5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "5C:8D:2D": "Shanghai Wellpay Information Technology Co., Ltd",
        "90:FD:9F": "Silicon Laboratories",
        "B4:30:C0": "York Instruments Ltd",
        "E8:1D:A8": "Ruckus Wireless",
        "F0:3D:03": "TECNO MOBILE LIMITED",
        "DC:F0:90": "Nubia Technology Co.,Ltd.",
        "A0:FE:61": "Vivint Wireless Inc. ",
        "5C:2B:F5": "Vivint Wireless Inc. ",
        "CC:5A:53": "Cisco Systems, Inc",
        "00:60:88": "Analog Devices, Inc.",
        "08:4A:CF": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "2C:27:9E": "IEEE Registration Authority",
        "8C:5F:48": "Continental Intelligent Transportation Systems LLC",
        "94:7E:B9": "National Narrowband Network Communications Pty Ltd",
        "64:6E:69": "Liteon Technology Corporation",
        "70:6B:B9": "Cisco Systems, Inc",
        "00:C0:EE": "KYOCERA Display Corporation",
        "24:5F:DF": "KYOCERA CORPORATION ",
        "9C:63:ED": "zte corporation",
        "74:F6:61": "Schneider Electric Fire & Security Oy",
        "B8:63:4D": "Apple, Inc.",
        "24:C4:2F": "Philips Lifeline",
        "2C:B2:1A": "Phicomm (Shanghai) Co., Ltd.",
        "A4:E9:75": "Apple, Inc.",
        "30:35:AD": "Apple, Inc.",
        "84:41:67": "Apple, Inc.",
        "98:00:C6": "Apple, Inc.",
        "AC:1F:74": "Apple, Inc.",
        "A8:5C:2C": "Apple, Inc.",
        "00:DB:70": "Apple, Inc.",
        "FC:E5:57": "Nokia Corporation",
        "48:C5:8D": "Lear Corporation GmbH",
        "00:28:9F": "Semptian Co., Ltd.",
        "9C:30:5B": "Hon Hai Precision Ind. Co.,Ltd.",
        "10:4E:89": "Garmin International",
        "D8:C4:97": "Quanta Computer Inc.",
        "BC:C3:42": "Panasonic Communications Co., Ltd.",
        "00:1B:D3": "Panasonic Corporation AVC Networks Company",
        "CC:7E:E7": "Panasonic Corporation AVC Networks Company",
        "20:C6:EB": "Panasonic Corporation AVC Networks Company",
        "64:B5:C6": "Nintendo Co.,Ltd",
        "28:30:AC": "Frontiir Co. Ltd.",
        "D4:D2:E5": "BKAV Corporation",
        "00:50:B5": "FICHET SECURITE ELECTRONIQUE",
        "00:14:39": "Blonder Tongue Laboratories, Inc",
        "20:A6:CD": "Hewlett Packard Enterprise",
        "84:80:2D": "Cisco Systems, Inc",
        "00:19:87": "Panasonic Mobile Communications Co.,Ltd.",
        "74:1C:27": "ITEL MOBILE LIMITED",
        "00:A0:AC": "GILAT SATELLITE NETWORKS, LTD.",
        "00:26:09": "Phyllis Co., Ltd.",
        "28:F5:37": "IEEE Registration Authority",
        "94:D9:B3": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "C8:40:29": "Fiberhome Telecommunication Technologies Co.,LTD",
        "F8:6E:EE": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:02:B1": "Cisco Systems, Inc",
        "B4:0F:3B": "Tenda Technology Co.,Ltd.Dongguan branch",
        "00:18:8D": "Nokia Danmark A/S",
        "00:15:AB": "PRO CO SOUND INC",
        "58:76:C5": "DIGI I'S LTD",
        "A8:B2:DA": "FUJITSU LIMITED",
        "00:13:54": "Zcomax Technologies, Inc.",
        "78:D8:00": "IEEE Registration Authority",
        "08:35:B2": "CoreEdge Networks Co., Ltd",
        "4C:49:E3": "Xiaomi Communications Co Ltd",
        "24:58:80": "VIZEO",
        "54:66:6C": "Shenzhen YOUHUA Technology Co., Ltd",
        "A8:96:75": "Motorola Mobility LLC, a Lenovo Company",
        "38:9A:F6": "Samsung Electronics Co.,Ltd",
        "E0:AA:96": "Samsung Electronics Co.,Ltd",
        "50:77:05": "Samsung Electronics Co.,Ltd",
        "28:D4:36": "Jiangsu dewosi electric co., LTD",
        "D4:B2:7A": "ARRIS Group, Inc.",
        "44:EA:4B": "Actlas Inc.",
        "C4:CB:6B": "Airista Flow, Inc.",
        "18:80:90": "Cisco Systems, Inc",
        "78:62:56": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B0:55:08": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B8:75:C0": "PayPal, Inc.",
        "00:1C:71": "Emergent Electronics",
        "00:1A:93": "ERCO Leuchten GmbH",
        "94:F6:65": "Ruckus Wireless",
        "B0:90:D4": "Shenzhen Hoin Internet Technology Co., Ltd",
        "8C:9F:3B": "Qingdao Hisense Communications Co.,Ltd.",
        "00:14:B8": "Hill-Rom",
        "AC:ED:5C": "Intel Corporate",
        "84:20:96": "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD.",
        "B4:C1:70": "Yi chip Microelectronics (Hangzhou) Co., Ltd",
        "AC:67:06": "Ruckus Wireless",
        "04:4F:AA": "Ruckus Wireless",
        "58:93:96": "Ruckus Wireless",
        "00:1F:41": "Ruckus Wireless",
        "C4:10:8A": "Ruckus Wireless",
        "F0:B0:52": "Ruckus Wireless",
        "70:DF:2F": "Cisco Systems, Inc",
        "38:94:E0": "Syrotech Networks. Ltd.",
        "34:F6:4B": "Intel Corporate",
        "F4:6B:EF": "Sagemcom Broadband SAS",
        "10:CD:B6": "Essential Products, Inc.",
        "A4:F3:E7": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "E4:3A:6E": "Shenzhen Zeroone Technology CO.,LTD",
        "7C:E2:CA": "Juniper Networks",
        "90:61:AE": "Intel Corporate",
        "6C:F9:D2": "CHENGDU POVODO ELECTRONIC TECHNOLOGY CO., LTD",
        "30:B6:2D": "Mojo Networks, Inc.",
        "50:18:4C": "Platina Systems Inc.",
        "F4:B7:B3": "vivo Mobile Communication Co., Ltd.",
        "FC:A6:67": "Amazon Technologies Inc.",
        "C8:1F:EA": "Avaya Inc",
        "00:27:E3": "Cisco Systems, Inc",
        "00:18:AE": "TVT CO.,LTD",
        "88:91:DD": "Racktivity",
        "1C:45:93": "Texas Instruments",
        "90:EC:50": "C.O.B.O. SPA",
        "E0:D8:48": "Dell Inc.",
        "60:27:1C": "VIDEOR E. Hartig GmbH",
        "00:EC:0A": "Xiaomi Communications Co Ltd",
        "C8:D7:B0": "Samsung Electronics Co.,Ltd",
        "6C:60:EB": "ZHI YUAN ELECTRONICS CO., LIMITED",
        "74:DA:DA": "D-Link International",
        "D8:F1:F0": "Pepxim International Limited",
        "DC:C8:F5": "Shanghai UMEinfo CO.,LTD.",
        "88:D7:F6": "ASUSTek COMPUTER INC.",
        "90:97:F3": "Samsung Electronics Co.,Ltd",
        "7C:1C:68": "Samsung Electronics Co.,Ltd",
        "C0:87:EB": "Samsung Electronics Co.,Ltd",
        "04:71:4B": "IEEE Registration Authority",
        "2C:41:A1": "Bose Corporation",
        "4C:38:D8": "ARRIS Group, Inc.",
        "44:7B:BB": "Shenzhen YOUHUA Technology Co., Ltd",
        "9C:7B:D2": "NEOLAB Convergence",
        "D0:F8:8C": "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd.",
        "2C:B1:15": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "10:D0:7A": "AMPAK Technology, Inc.",
        "D4:C1:C8": "zte corporation",
        "88:D2:74": "zte corporation",
        "00:24:49": "Shen Zhen Lite Star Electronics Technology Co., Ltd",
        "00:E1:8C": "Intel Corporate",
        "84:79:33": "profichip GmbH",
        "88:15:44": "Cisco Meraki",
        "C4:AB:B2": "vivo Mobile Communication Co., Ltd.",
        "80:B2:34": "Technicolor CH USA Inc.",
        "44:B4:12": "SIUS AG",
        "0C:B9:12": "JM-DATA GmbH",
        "3C:A3:08": "Texas Instruments",
        "F4:3E:61": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "B4:41:7A": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "00:00:62": "BULL HN INFORMATION SYSTEMS",
        "E8:C1:D7": "Philips",
        "4C:81:20": "Taicang T&W Electronics",
        "28:A6:DB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "14:A0:F8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C8:F8:6D": "Alcatel-Lucent Shanghai Bell Co., Ltd",
        "60:45:CB": "ASUSTek COMPUTER INC.",
        "00:11:8B": "Alcatel-Lucent Enterprise",
        "00:E0:B1": "Alcatel-Lucent Enterprise",
        "00:E0:DA": "Alcatel-Lucent Enterprise",
        "F8:BE:0D": "A2UICT Co.,Ltd.",
        "E4:42:A6": "Intel Corporate",
        "3C:67:8C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D4:50:3F": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "38:8C:50": "LG Electronics",
        "DC:08:56": "Alcatel-Lucent Enterprise",
        "1C:DA:27": "vivo Mobile Communication Co., Ltd.",
        "90:F3:05": "HUMAX Co., Ltd.",
        "40:95:BD": "NTmore.Co.,Ltd",
        "98:AA:FC": "IEEE Registration Authority",
        "00:14:3F": "Hotway Technology Corporation",
        "D0:55:B2": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "14:4F:D7": "IEEE Registration Authority",
        "B8:55:10": "Zioncom Electronics (Shenzhen) Ltd.",
        "04:95:73": "zte corporation",
        "F0:D7:AA": "Motorola Mobility LLC, a Lenovo Company",
        "F8:FF:0B": "Electronic Technology Inc.",
        "7C:6B:F7": "NTI co., ltd.",
        "00:D3:18": "SPG Controls",
        "30:96:FB": "Samsung Electronics Co.,Ltd",
        "48:27:EA": "Samsung Electronics Co.,Ltd",
        "7C:78:7E": "Samsung Electronics Co.,Ltd",
        "24:5B:A7": "Apple, Inc.",
        "70:F0:87": "Apple, Inc.",
        "00:0C:46": "Allied Telesyn Inc.",
        "00:1F:72": "QingDao Hiphone Technology Co,.Ltd",
        "00:23:65": "Insta Elektro GmbH",
        "60:91:F3": "vivo Mobile Communication Co., Ltd.",
        "28:39:5E": "Samsung Electronics Co.,Ltd",
        "38:29:5A": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "88:E6:28": "Shenzhen Kezhonglong Optoelectronic Technology Co.,Ltd",
        "58:23:8C": "Technicolor CH USA Inc.",
        "CC:82:EB": "KYOCERA CORPORATION ",
        "14:98:7D": "Technicolor CH USA Inc.",
        "D4:CF:37": "Symbolic IO",
        "D4:7D:FC": "TECNO MOBILE LIMITED",
        "40:9F:38": "AzureWave Technology Inc.",
        "BC:2F:3D": "vivo Mobile Communication Co., Ltd.",
        "40:FA:7F": "Preh Car Connect GmbH",
        "00:0D:BB": "Nippon Dentsu Co.,Ltd.",
        "2C:7E:81": "ARRIS Group, Inc.",
        "40:7D:0F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "68:CC:6E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:34:D2": "Availink, Inc.",
        "50:40:61": "Nokia",
        "00:10:8E": "HUGH SYMONS CONCEPT Technologies Ltd.",
        "E0:51:63": "Arcadyan Corporation",
        "54:E3:F6": "Alcatel-Lucent",
        "40:B0:34": "Hewlett Packard",
        "B8:16:DB": "CHANT SINCERE CO.,LTD",
        "40:B4:CD": "Amazon Technologies Inc.",
        "D4:81:D7": "Dell Inc.",
        "F4:2B:48": "Ubiqam",
        "50:F1:4A": "Texas Instruments",
        "04:DE:F2": "Shenzhen ECOM Technology Co. Ltd",
        "78:C1:A7": "zte corporation",
        "4C:78:72": "Cav. Uff. Giacomo Cimberio S.p.A. ",
        "8C:F5:A3": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "8C:C8:F4": "IEEE Registration Authority",
        "F4:83:E1": "Shanghai Clouder Semiconductor Co.,Ltd",
        "08:3E:5D": "Sagemcom Broadband SAS",
        "3C:BD:3E": "Beijing Xiaomi Electronics Co., Ltd.",
        "A0:84:CB": "SonicSensory,Inc.",
        "D4:7A:E2": "Samsung Electronics Co.,Ltd",
        "68:54:FD": "Amazon Technologies Inc.",
        "00:03:BC": "COT GmbH",
        "D4:B1:69": "Le Shi Zhi Xin Electronic Technology (Tianjin) Limited",
        "E4:47:90": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "38:45:4C": "Light Labs, Inc.",
        "00:0A:49": "F5 Networks, Inc.",
        "00:A0:C8": "Adtran Inc",
        "F4:96:51": "NAKAYO Inc",
        "44:62:46": "Comat AG",
        "34:FC:B9": "Hewlett Packard Enterprise",
        "70:91:8F": "Weber-Stephen Products LLC",
        "D8:E0:E1": "Samsung Electronics Co.,Ltd",
        "7C:10:15": "Brilliant Home Technology, Inc.",
        "D8:C7:71": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E0:2A:82": "Universal Global Scientific Industrial Co., Ltd.",
        "B0:F9:63": "Hangzhou H3C Technologies Co., Limited",
        "D4:90:E0": "Topcon Electronics GmbH & Co. KG",
        "A8:40:41": "Dragino Technology Co., Limited",
        "E0:22:02": "ARRIS Group, Inc.",
        "D8:25:B0": "Rockeetech Systems Co.,Ltd.",
        "74:61:4B": "Chongqing Huijiatong Information Technology Co., Ltd.",
        "98:D2:93": "Google, Inc.",
        "CC:B8:A8": "AMPAK Technology, Inc.",
        "10:77:B0": "Fiberhome Telecommunication Technologies Co.,LTD",
        "F0:1D:BC": "Microsoft Corporation",
        "34:04:9E": "IEEE Registration Authority",
        "94:FB:29": "Zebra Technologies Inc.",
        "B0:70:2D": "Apple, Inc.",
        "6C:19:C0": "Apple, Inc.",
        "00:20:4F": "DEUTSCHE AEROSPACE AG",
        "00:DB:DF": "Intel Corporate",
        "94:A0:4E": "Bostex Technology Co., LTD",
        "8C:E1:17": "zte corporation",
        "68:8A:F0": "zte corporation",
        "C0:21:0D": "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD.",
        "50:4B:5B": "CONTROLtronic GmbH",
        "B4:74:47": "CoreOS",
        "80:D4:A5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "04:B0:E7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "44:6A:2E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "AC:58:7B": "JCT Healthcare",
        "10:62:EB": "D-Link International",
        "00:08:94": "InnoVISION Multimedia Ltd.",
        "48:00:33": "Technicolor CH USA Inc.",
        "A0:6F:AA": "LG Innotek",
        "00:26:AB": "Seiko Epson Corporation",
        "FC:10:C6": "Taicang T&W Electronics",
        "2C:6F:C9": "Hon Hai Precision Ind. Co.,Ltd.",
        "58:EF:68": "Belkin International Inc.",
        "00:0B:4F": "Verifone",
        "60:C7:98": "Verifone",
        "C8:66:2C": "Beijing Haitai Fangyuan High Technology Co,.Ltd.",
        "80:96:CA": "Hon Hai Precision Ind. Co.,Ltd.",
        "18:65:71": "Top Victory Electronics (Taiwan) Co., Ltd.",
        "F8:3F:51": "Samsung Electronics Co.,Ltd",
        "50:D7:53": "CONELCOM GmbH",
        "0C:C4:7A": "Super Micro Computer, Inc.",
        "34:D2:70": "Amazon Technologies Inc.",
        "50:79:5B": "Interexport Telecomunicaciones S.A.",
        "00:16:D9": "NINGBO BIRD CO.,LTD.",
        "6C:A7:FA": "YOUNGBO ENGINEERING INC.",
        "8C:7E:B3": "Lytro, Inc.",
        "B4:B3:84": "ShenZhen Figigantic Electronic Co.,Ltd",
        "78:28:CA": "Sonos, Inc.",
        "00:C0:03": "GLOBALNET COMMUNICATIONS",
        "00:23:4A": "Private",
        "2C:40:2B": "Smart iBlue Technology Limited",
        "5C:6B:4F": "Hello Inc.",
        "2C:99:24": "ARRIS Group, Inc.",
        "D0:58:A8": "zte corporation",
        "D0:71:C4": "zte corporation",
        "A0:CC:2B": "Murata Manufacturing Co., Ltd.",
        "50:01:D9": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:27:1C": "MERCURY CORPORATION",
        "E0:D9:E3": "Eltex Enterprise Ltd.",
        "80:5E:C0": "YEALINK(XIAMEN) NETWORK TECHNOLOGY CO.,LTD.",
        "00:7B:18": "SENTRY Co., LTD.",
        "14:4D:67": "Zioncom Electronics (Shenzhen) Ltd.",
        "4C:E1:73": "IEEE Registration Authority",
        "0C:D8:6C": "SHENZHEN FAST TECHNOLOGIES CO.,LTD",
        "04:97:90": "Lartech telecom LLC",
        "28:EE:D3": "Shenzhen Super D Technology Co., Ltd",
        "24:C4:4A": "zte corporation",
        "98:54:1B": "Intel Corporate",
        "1C:40:E8": "SHENZHEN PROGRESS&WIN TECHNOLOGY CO.,LTD",
        "00:23:D2": "Inhand Electronics, Inc.",
        "DC:0B:34": "LG Electronics (Mobile Communications)",
        "40:4E:36": "HTC Corporation",
        "A8:E7:05": "Fiberhome Telecommunication Technologies Co.,LTD",
        "98:40:BB": "Dell Inc.",
        "00:60:D6": "NovAtel Inc.",
        "50:3A:A0": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "B0:95:8E": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "C0:25:E9": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "18:8B:15": "ShenZhen ZhongRuiJing Technology co.,LTD",
        "88:6B:0F": "Bluegiga Technologies OY",
        "AC:84:C9": "Sagemcom Broadband SAS",
        "24:5C:BF": "NCSE",
        "2C:33:61": "Apple, Inc.",
        "60:A4:D0": "Samsung Electronics Co.,Ltd",
        "00:87:01": "Samsung Electronics Co.,Ltd",
        "5C:99:60": "Samsung Electronics Co.,Ltd",
        "9C:62:AB": "Sumavision Technologies Co.,Ltd",
        "C8:F9:46": "LOCOSYS Technology Inc.",
        "48:7B:6B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "88:3F:D3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:0D:65": "Shenzhen Vsun Communication Technology Co., Ltd.",
        "00:0B:14": "ViewSonic Corporation",
        "C8:02:8F": "Nova Electronics (Shanghai) Co., Ltd.",
        "A4:60:11": "Verifone",
        "5C:A9:33": "Luma Home",
        "00:13:7E": "CorEdge Networks, Inc.",
        "D8:14:D6": "SURE SYSTEM Co Ltd",
        "6C:EF:C6": "SHENZHEN TWOWING TECHNOLOGIES CO.,LTD.",
        "10:1D:C0": "Samsung Electronics Co.,Ltd",
        "00:23:41": "Vanderbilt International (SWE) AB ",
        "40:7C:7D": "Nokia",
        "24:59:0B": "White Sky Inc. Limited",
        "68:EB:AE": "Samsung Electronics Co.,Ltd",
        "44:4E:1A": "Samsung Electronics Co.,Ltd",
        "14:33:65": "TEM Mobile Limited",
        "80:18:44": "Dell Inc.",
        "78:47:1D": "Samsung Electronics Co.,Ltd",
        "A0:75:91": "Samsung Electronics Co.,Ltd",
        "0C:DF:A4": "Samsung Electronics Co.,Ltd",
        "B0:72:BF": "Murata Manufacturing Co., Ltd.",
        "70:1D:C4": "NorthStar Battery Company, LLC",
        "64:DA:A0": "Robert Bosch Smart Home GmbH",
        "14:B8:37": "Shenzhen YOUHUA Technology Co., Ltd",
        "5C:86:13": "Beijing Zhoenet Technology Co., Ltd",
        "CC:73:14": "HONG KONG WHEATEK TECHNOLOGY LIMITED",
        "B8:EE:65": "Liteon Technology Corporation",
        "98:5B:B0": "KMDATA INC.",
        "E0:06:E6": "Hon Hai Precision Ind. Co.,Ltd.",
        "BC:85:56": "Hon Hai Precision Ind. Co.,Ltd.",
        "34:23:87": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:26:37": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "00:21:19": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "F4:D9:FB": "Samsung Electronics Co.,Ltd",
        "3C:62:00": "Samsung Electronics Co.,Ltd",
        "C4:17:FE": "Hon Hai Precision Ind. Co.,Ltd.",
        "94:39:E5": "Hon Hai Precision Ind. Co.,Ltd.",
        "64:27:37": "Hon Hai Precision Ind. Co.,Ltd.",
        "A4:17:31": "Hon Hai Precision Ind. Co.,Ltd.",
        "5C:A3:9D": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "90:18:7C": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "50:CC:F8": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "00:22:3B": "Communication Networks, LLC",
        "C0:F8:DA": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:11:FF": "Digitro Tecnologia Ltda",
        "00:1B:94": "T.E.M.A. S.p.A.",
        "F0:F0:02": "Hon Hai Precision Ind. Co.,Ltd.",
        "C0:CB:38": "Hon Hai Precision Ind. Co.,Ltd.",
        "F0:7B:CB": "Hon Hai Precision Ind. Co.,Ltd.",
        "50:B7:C3": "Samsung Electronics Co.,Ltd",
        "1C:5A:3E": "Samsung Electronics Co.,Ltd",
        "A0:21:95": "Samsung Electronics Co.,Ltd",
        "B0:78:70": "Wi-NEXT, Inc.",
        "E4:7C:F9": "Samsung Electronics Co.,Ltd",
        "48:44:F7": "Samsung Electronics Co.,Ltd",
        "00:13:77": "Samsung Electronics Co.,Ltd",
        "00:24:54": "Samsung Electronics Co.,Ltd",
        "E8:11:32": "Samsung Electronics Co.,Ltd",
        "C0:65:99": "Samsung Electronics Co.,Ltd",
        "BC:79:AD": "Samsung Electronics Co.,Ltd",
        "4C:3C:16": "Samsung Electronics Co.,Ltd",
        "00:73:E0": "Samsung Electronics Co.,Ltd",
        "00:17:D5": "Samsung Electronics Co.,Ltd",
        "00:1E:7D": "Samsung Electronics Co.,Ltd",
        "00:1D:F6": "Samsung Electronics Co.,Ltd",
        "F0:08:F1": "Samsung Electronics Co.,Ltd",
        "58:C3:8B": "Samsung Electronics Co.,Ltd",
        "00:E3:B2": "Samsung Electronics Co.,Ltd",
        "30:19:66": "Samsung Electronics Co.,Ltd",
        "F0:E7:7E": "Samsung Electronics Co.,Ltd",
        "94:35:0A": "Samsung Electronics Co.,Ltd",
        "00:1D:25": "Samsung Electronics Co.,Ltd",
        "E4:C1:F1": "SHENZHEN SPOTMAU INFORMATION TECHNOLIGY CO., Ltd  ",
        "24:0A:C4": "Espressif Inc.",
        "34:31:11": "Samsung Electronics Co.,Ltd",
        "08:FD:0E": "Samsung Electronics Co.,Ltd",
        "04:1B:BA": "Samsung Electronics Co.,Ltd",
        "88:9B:39": "Samsung Electronics Co.,Ltd",
        "E4:32:CB": "Samsung Electronics Co.,Ltd",
        "BC:8C:CD": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "D0:22:BE": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "EC:9B:F3": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "F4:09:D8": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "10:D5:42": "Samsung Electronics Co.,Ltd",
        "A0:82:1F": "Samsung Electronics Co.,Ltd",
        "F0:6B:CA": "Samsung Electronics Co.,Ltd",
        "AC:36:13": "Samsung Electronics Co.,Ltd",
        "00:26:11": "Licera AB",
        "00:50:94": "ARRIS Group, Inc.",
        "E0:B7:B1": "ARRIS Group, Inc.",
        "D8:25:22": "ARRIS Group, Inc.",
        "F0:03:8C": "AzureWave Technology Inc.",
        "18:D2:76": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:52:18": "Wuxi Keboda Electron Co.Ltd",
        "00:1E:81": "CNB Technology Inc.",
        "7C:A9:7D": "Objenious",
        "A8:A6:48": "Qingdao Hisense Communications Co.,Ltd.",
        "98:5D:AD": "Texas Instruments",
        "D4:36:39": "Texas Instruments",
        "BC:28:2C": "e-Smart Systems Pvt. Ltd",
        "A4:0D:BC": "Xiamen Intretech Inc.",
        "84:EF:18": "Intel Corporate",
        "84:C1:C1": "Juniper Networks",
        "A8:1B:6A": "Texas Instruments",
        "34:3D:C4": "BUFFALO.INC",
        "B0:F8:93": "Shanghai MXCHIP Information Technology Co., Ltd.",
        "C4:11:E0": "Bull Group Co., Ltd",
        "28:C8:7A": "ARRIS Group, Inc.",
        "48:FD:8E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "7C:06:23": "Ultra Electronics Sonar System Division",
        "28:AC:67": "Mach Power, Rappresentanze Internazionali s.r.l.",
        "14:82:5B": "Hefei Radio Communication Technology Co., Ltd ",
        "64:12:69": "ARRIS Group, Inc.",
        "00:02:C9": "Mellanox Technologies, Inc.",
        "08:00:51": "ExperData",
        "00:12:6C": "Visonic Technologies 1993 Ltd.",
        "AC:61:75": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:44:27": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:80:C7": "XIRCOM",
        "00:01:38": "XAVi Technologies Corp.",
        "00:16:6D": "Yulong Computer Telecommunication Scientific (Shenzhen) Co.,Ltd",
        "3C:91:57": "Yulong Computer Telecommunication Scientific (Shenzhen) Co.,Ltd",
        "00:00:D8": "Novell, Inc.",
        "00:1F:46": "Nortel Networks",
        "00:30:93": "Sonnet Technologies, Inc",
        "00:03:4B": "Nortel Networks",
        "00:25:61": "ProCurve Networking by HP",
        "00:80:58": "PRINTER SYSTEMS CORP.",
        "00:15:7D": "POSDATA",
        "48:49:C7": "Samsung Electronics Co.,Ltd",
        "84:98:66": "Samsung Electronics Co.,Ltd",
        "00:1C:9C": "Nortel Networks",
        "00:1B:25": "Nortel Networks",
        "00:19:E1": "Nortel Networks",
        "00:1D:42": "Nortel Networks",
        "00:14:0D": "Nortel Networks",
        "00:0E:40": "Nortel Networks",
        "FC:B0:C4": "Shanghai DareGlobal Technologies Co.,Ltd",
        "A8:9D:D2": "Shanghai DareGlobal Technologies Co.,Ltd",
        "00:E0:0F": "Shanghai Baud Data Communication Co.,Ltd.",
        "28:BE:03": "TCT mobile ltd",
        "90:3A:E6": "PARROT SA",
        "A0:98:ED": "Shandong Intelligent Optical Communication Development Co., Ltd.",
        "00:0E:F4": "Kasda Networks Inc",
        "00:16:7A": "Skyworth Overseas Development Ltd.",
        "A4:29:40": "Shenzhen YOUHUA Technology Co., Ltd",
        "E4:A3:87": "Control Solutions LLC",
        "18:80:F5": "Alcatel-Lucent Shanghai Bell Co., Ltd",
        "10:E8:78": "Nokia",
        "10:F9:6F": "LG Electronics (Mobile Communications)",
        "C4:43:8F": "LG Electronics (Mobile Communications)",
        "A0:91:69": "LG Electronics (Mobile Communications)",
        "28:6C:07": "XIAOMI Electronics,CO.,LTD",
        "00:22:80": "A2B Electronics AB",
        "40:4A:D4": "Widex A/S",
        "98:93:CC": "LG ELECTRONICS INC",
        "3C:CD:93": "LG ELECTRONICS INC",
        "20:21:A5": "LG Electronics (Mobile Communications)",
        "6C:D6:8A": "LG Electronics (Mobile Communications)",
        "CC:79:CF": "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD.",
        "00:19:25": "Intelicis Corporation",
        "94:76:B7": "Samsung Electronics Co.,Ltd",
        "2C:54:CF": "LG Electronics (Mobile Communications)",
        "48:59:29": "LG Electronics (Mobile Communications)",
        "58:A2:B5": "LG Electronics (Mobile Communications)",
        "00:24:83": "LG Electronics (Mobile Communications)",
        "00:1F:E3": "LG Electronics (Mobile Communications)",
        "F0:42:1C": "Intel Corporate",
        "00:0F:62": "Alcatel Bell Space N.V.",
        "00:1C:D8": "BlueAnt Wireless",
        "00:19:AB": "Raycom CO ., LTD",
        "4C:33:4E": "HIGHTECH",
        "7C:70:BC": "IEEE Registration Authority",
        "E8:18:63": "IEEE Registration Authority",
        "2C:D1:41": "IEEE Registration Authority",
        "3C:39:E7": "IEEE Registration Authority",
        "BC:66:41": "IEEE Registration Authority",
        "80:E4:DA": "IEEE Registration Authority",
        "88:5D:90": "IEEE Registration Authority",
        "C8:8E:D1": "IEEE Registration Authority",
        "B0:1F:81": "IEEE Registration Authority",
        "54:9A:11": "IEEE Registration Authority",
        "B8:D8:12": "IEEE Registration Authority",
        "1C:21:D1": "IEEE Registration Authority",
        "28:36:38": "IEEE Registration Authority",
        "F4:85:C6": "FDT Technologies",
        "D4:04:FF": "Juniper Networks",
        "C8:75:5B": "Quantify Technology Pty. Ltd.",
        "88:12:4E": "Qualcomm Inc.",
        "00:14:28": "Vocollect Inc",
        "00:6B:9E": "Vizio, Inc",
        "4C:66:41": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "5C:A8:6A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:1B:32": "QLogic Corporation",
        "00:17:CA": "Qisda Corporation",
        "70:F3:95": "Universal Global Scientific Industrial Co., Ltd.",
        "48:F7:C0": "Technicolor CH USA Inc.",
        "00:15:B7": "Toshiba",
        "E8:9D:87": "Toshiba",
        "E0:95:79": "ORTHOsoft inc, d/b/a Zimmer CAS",
        "A0:AD:A1": "JMR Electronics, Inc",
        "BC:C0:0F": "Fiberhome Telecommunication Technologies Co.,LTD",
        "9C:A5:C0": "vivo Mobile Communication Co., Ltd.",
        "80:C6:AB": "Technicolor CH USA Inc.",
        "90:A4:DE": "Wistron Neweb Corporation",
        "70:E2:84": "Wistron Infocomm (Zhongshan) Corporation",
        "A8:54:B2": "Wistron Neweb Corporation",
        "30:44:A1": "Shanghai Nanchao Information Technology",
        "CC:03:FA": "Technicolor CH USA Inc.",
        "E0:AC:F1": "Cisco Systems, Inc",
        "00:01:5B": "ITALTEL S.p.A/RF-UP-I",
        "00:A0:A8": "RENEX CORPORATION",
        "00:C0:AB": "Telco Systems, Inc. ",
        "00:23:F8": "Zyxel Communications Corporation",
        "00:19:CB": "Zyxel Communications Corporation",
        "2C:09:4D": "Raptor Engineering, LLC",
        "AC:37:43": "HTC Corporation",
        "00:1D:7E": "Cisco-Linksys, LLC",
        "E4:FB:8F": "MOBIWIRE MOBILES (NINGBO) CO.,LTD",
        "10:BD:55": "Q-Lab Corporation",
        "C4:49:BB": "MITSUMI ELECTRIC CO.,LTD.",
        "FC:2D:5E": "zte corporation",
        "B4:04:18": "Smartchip Integrated Inc.",
        "90:CF:7D": "Qingdao Hisense Communications Co.,Ltd.",
        "F4:0A:4A": "INDUSNET Communication Technology Co.,LTD",
        "F8:5A:00": "Sanford LP",
        "FC:55:DC": "Baltic Latvian Universal Electronics LLC",
        "94:18:82": "Hewlett Packard Enterprise",
        "60:38:E0": "Belkin International Inc.",
        "88:50:DD": "Infiniband Trade Association ",
        "D0:B2:C4": "Technicolor CH USA Inc.",
        "50:AB:3E": "Qibixx AG",
        "38:76:CA": "Shenzhen Smart Intelligent Technology Co.Ltd",
        "04:27:58": "HUAWEI TECHNOLOGIES CO.,LTD",
        "9C:E3:74": "HUAWEI TECHNOLOGIES CO.,LTD",
        "8C:D2:E9": "YOKOTE SEIKO CO., LTD.",
        "B8:BB:AF": "Samsung Electronics Co.,Ltd",
        "60:C5:AD": "Samsung Electronics Co.,Ltd",
        "44:2C:05": "AMPAK Technology, Inc.",
        "8C:89:7A": "AUGTEK",
        "F8:45:AD": "Konka Group Co., Ltd.",
        "00:0F:E2": "Hangzhou H3C Technologies Co., Limited",
        "80:F6:2E": "Hangzhou H3C Technologies Co., Limited",
        "60:8D:17": "Sentrus Government Systems Division, Inc",
        "EC:AD:B8": "Apple, Inc.",
        "98:01:A7": "Apple, Inc.",
        "68:79:ED": "SHARP Corporation",
        "00:23:82": "Lih Rong electronic Enterprise Co., Ltd.",
        "24:F0:94": "Apple, Inc.",
        "08:6D:41": "Apple, Inc.",
        "B4:D5:BD": "Intel Corporate",
        "98:AA:3C": "Will i-tech Co., Ltd.",
        "BC:AD:28": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "F4:91:1E": "ZHUHAI EWPE INFORMATION TECHNOLOGY INC",
        "00:25:52": "VXi Corporation",
        "6C:E9:83": "Gastron Co., LTD.",
        "28:E3:1F": "Xiaomi Communications Co Ltd",
        "98:90:96": "Dell Inc.",
        "DC:37:52": "GE",
        "DC:D9:16": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:02:2E": "TEAC Corp. R& D",
        "00:60:B0": "Hewlett Packard",
        "7C:73:8B": "Cocoon Alarm Ltd",
        "F8:0F:84": "Natural Security SAS",
        "44:A4:2D": "TCT mobile ltd",
        "70:F9:6D": "Hangzhou H3C Technologies Co., Limited",
        "BC:6A:44": "Commend International GmbH",
        "F0:EE:58": "PACE Telematics GmbH",
        "08:3F:BC": "zte corporation",
        "00:C0:F0": "Kingston Technology Company, Inc.",
        "94:3B:B1": "Kaonmedia CO., LTD.",
        "00:18:D7": "JAVAD GNSS, Inc.",
        "00:1F:09": "Jastec",
        "AC:62:0D": "Jabil Circuit(Wuxi) Co.,Ltd",
        "08:00:0D": "International Computers, Ltd",
        "1C:73:70": "Neotech",
        "30:E3:7A": "Intel Corporate",
        "00:00:C9": "Emulex Corporation",
        "00:40:AA": "Valmet Automation",
        "D0:B0:CD": "Moen",
        "F4:EF:9E": "SGSG SCIENCE & TECHNOLOGY CO. LTD",
        "1C:74:0D": "Zyxel Communications Corporation",
        "60:3E:CA": "Cambridge Medical Robotics Ltd",
        "00:1F:1F": "Edimax Technology Co. Ltd.",
        "00:02:0E": "ECI Telecom Ltd.",
        "20:0A:5E": "Xiangshan Giant Eagle Technology Developing Co., Ltd.",
        "9C:74:1A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E4:A8:B6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:4C:07": "HUAWEI TECHNOLOGIES CO.,LTD",
        "74:6F:F7": "Wistron Neweb Corporation",
        "B8:AE:ED": "Elitegroup Computer Systems Co.,Ltd.",
        "00:0D:B0": "Olym-tech Co.,Ltd.",
        "30:F6:B9": "Ecocentric Energy",
        "84:7B:EB": "Dell Inc.",
        "54:51:1B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "68:53:6C": "SPnS Co.,Ltd",
        "1C:EA:1B": "Nokia",
        "D4:61:2E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B0:E2:E5": "Fiberhome Telecommunication Technologies Co.,LTD",
        "00:1F:A7": "Sony Interactive Entertainment Inc.",
        "90:46:A2": "Tedipay UK Ltd",
        "64:79:A7": "Phison Electronics Corp.   ",
        "CC:B1:1A": "Samsung Electronics Co.,Ltd",
        "70:3C:03": "RadiAnt Co.,Ltd",
        "00:C1:64": "Cisco Systems, Inc",
        "DC:2D:CB": "Beijing Unis HengYue Technology Co., Ltd.",
        "2C:96:62": "Invenit BV",
        "CC:D3:E2": "Jiangsu Yinhe  Electronics Co.,Ltd.",
        "E4:FA:ED": "Samsung Electronics Co.,Ltd",
        "28:83:35": "Samsung Electronics Co.,Ltd",
        "DC:CF:96": "Samsung Electronics Co.,Ltd",
        "AC:44:F2": "YAMAHA CORPORATION",
        "1C:5F:2B": "D-Link International",
        "1C:98:EC": "Hewlett Packard Enterprise",
        "70:66:1B": "Sonova AG",
        "B0:7F:B9": "NETGEAR",
        "04:7E:4A": "moobox CO., Ltd.",
        "00:80:E5": "NetApp",
        "9C:5C:8E": "ASUSTek COMPUTER INC.",
        "C8:87:22": "Lumenpulse",
        "84:68:3E": "Intel Corporate",
        "E0:CD:FD": "Beijing E3Control Technology Co, LTD",
        "00:08:95": "DIRC Technologie GmbH & Co.KG",
        "60:AC:C8": "KunTeng Inc.",
        "CC:B3:AB": "shenzhen Biocare Bio-Medical Equipment Co.,Ltd.",
        "E4:B3:18": "Intel Corporate",
        "74:3E:2B": "Ruckus Wireless",
        "E0:C7:67": "Apple, Inc.",
        "80:ED:2C": "Apple, Inc.",
        "F0:34:04": "TCT mobile ltd",
        "80:D1:60": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "30:78:5C": "Partow Tamas Novin (Parman)",
        "24:69:68": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "8C:A2:FD": "Starry, Inc.",
        "84:BA:3B": "CANON INC.",
        "00:05:85": "Juniper Networks",
        "20:4E:71": "Juniper Networks",
        "00:19:4F": "Nokia Danmark A/S",
        "00:BD:3A": "Nokia Corporation",
        "80:50:1B": "Nokia Corporation",
        "A0:4E:04": "Nokia Corporation",
        "00:12:62": "Nokia Danmark A/S",
        "00:14:A7": "Nokia Danmark A/S",
        "00:15:A0": "Nokia Danmark A/S",
        "00:16:BC": "Nokia Danmark A/S",
        "00:17:4B": "Nokia Danmark A/S",
        "00:26:69": "Nokia Danmark A/S",
        "AC:61:EA": "Apple, Inc.",
        "38:B5:4D": "Apple, Inc.",
        "1C:5C:F2": "Apple, Inc.",
        "A8:7E:33": "Nokia Danmark A/S",
        "00:24:03": "Nokia Danmark A/S",
        "00:24:04": "Nokia Danmark A/S",
        "00:19:B7": "Nokia Danmark A/S",
        "00:17:B0": "Nokia Danmark A/S",
        "00:21:09": "Nokia Danmark A/S",
        "00:21:08": "Nokia Danmark A/S",
        "00:1B:33": "Nokia Danmark A/S",
        "00:15:DE": "Nokia Danmark A/S",
        "00:02:EE": "Nokia Danmark A/S",
        "D8:F7:10": "Libre Wireless Technologies Inc.",
        "3C:59:1E": "TCL King Electrical Appliances (Huizhou) Co., Ltd",
        "C4:36:55": "Shenzhen Fenglian Technology Co., Ltd.",
        "00:30:DA": "Comtrend Corporation",
        "64:68:0C": "Comtrend Corporation",
        "38:72:C0": "Comtrend Corporation",
        "A8:06:00": "Samsung Electronics Co.,Ltd",
        "00:26:82": "Gemtek Technology Co., Ltd.",
        "00:09:E1": "Gemtek Technology Co., Ltd.",
        "14:C1:26": "Nokia Corporation",
        "60:01:94": "Espressif Inc.",
        "F0:5A:09": "Samsung Electronics Co.,Ltd",
        "50:32:75": "Samsung Electronics Co.,Ltd",
        "08:FC:88": "Samsung Electronics Co.,Ltd",
        "02:70:B3": "DATA RECALL LTD.",
        "00:01:36": "CyberTAN Technology Inc.",
        "D0:4D:2C": "Roku, Inc.",
        "B0:A7:37": "Roku, Inc.",
        "14:0C:76": "FREEBOX SAS",
        "00:1B:E9": "Broadcom",
        "00:19:C7": "Cambridge Industries(Group) Co.,Ltd.",
        "70:D9:31": "Cambridge Industries(Group) Co.,Ltd.",
        "02:9D:8E": "CARDIAC RECORDERS, INC.",
        "00:40:2A": "Canoga Perkins Corporation",
        "A4:C7:DE": "Cambridge Industries(Group) Co.,Ltd.",
        "D8:B8:F6": "Nantworks",
        "00:80:77": "Brother industries, LTD.",
        "24:F5:AA": "Samsung Electronics Co.,Ltd",
        "98:83:89": "Samsung Electronics Co.,Ltd",
        "84:A4:66": "Samsung Electronics Co.,Ltd",
        "C4:57:6E": "Samsung Electronics Co.,Ltd",
        "50:85:69": "Samsung Electronics Co.,Ltd",
        "00:60:BB": "Cabletron Systems, Inc.",
        "F8:D0:BD": "Samsung Electronics Co.,Ltd",
        "78:59:5E": "Samsung Electronics Co.,Ltd",
        "0C:14:20": "Samsung Electronics Co.,Ltd",
        "94:B1:0A": "Samsung Electronics Co.,Ltd",
        "3C:BB:FD": "Samsung Electronics Co.,Ltd",
        "A4:84:31": "Samsung Electronics Co.,Ltd",
        "A0:B4:A5": "Samsung Electronics Co.,Ltd",
        "E4:F8:EF": "Samsung Electronics Co.,Ltd",
        "DC:44:6D": "Allwinner Technology Co., Ltd",
        "74:5A:AA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "04:FE:8D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:13:33": "BaudTec Corporation",
        "58:67:1A": "Barnes&Noble",
        "00:26:75": "Aztech Electronics Pte Ltd",
        "00:24:FE": "AVM GmbH",
        "C0:25:06": "AVM GmbH",
        "40:5D:82": "NETGEAR",
        "DC:EF:09": "NETGEAR",
        "DC:64:B8": "Shenzhen JingHanDa Electronics Co.Ltd",
        "00:0D:92": "ARIMA Communications Corp.",
        "00:21:63": "ASKEY COMPUTER CORP",
        "A8:D3:F7": "Arcadyan Technology Corporation",
        "4C:60:DE": "NETGEAR",
        "C4:3D:C7": "NETGEAR",
        "48:9D:24": "BlackBerry RTS",
        "08:BD:43": "NETGEAR",
        "44:EE:02": "MTI Ltd.",
        "58:56:E8": "ARRIS Group, Inc.",
        "F8:0B:BE": "ARRIS Group, Inc.",
        "DC:45:17": "ARRIS Group, Inc.",
        "C8:AA:21": "ARRIS Group, Inc.",
        "00:17:EE": "ARRIS Group, Inc.",
        "00:11:1A": "ARRIS Group, Inc.",
        "00:0F:9F": "ARRIS Group, Inc.",
        "00:04:BD": "ARRIS Group, Inc.",
        "00:26:42": "ARRIS Group, Inc.",
        "00:24:A1": "ARRIS Group, Inc.",
        "00:22:10": "ARRIS Group, Inc.",
        "00:22:B4": "ARRIS Group, Inc.",
        "00:14:9A": "ARRIS Group, Inc.",
        "00:14:E8": "ARRIS Group, Inc.",
        "00:19:C0": "ARRIS Group, Inc.",
        "00:E0:6F": "ARRIS Group, Inc.",
        "80:96:B1": "ARRIS Group, Inc.",
        "70:7E:43": "ARRIS Group, Inc.",
        "00:15:2F": "ARRIS Group, Inc.",
        "00:1F:C4": "ARRIS Group, Inc.",
        "00:1C:FB": "ARRIS Group, Inc.",
        "00:23:95": "ARRIS Group, Inc.",
        "00:23:AF": "ARRIS Group, Inc.",
        "F8:7B:7A": "ARRIS Group, Inc.",
        "00:00:F4": "Allied Telesis, Inc.",
        "00:15:77": "Allied Telesis, Inc.",
        "70:3C:39": "SEAWING Kft",
        "90:97:D5": "Espressif Inc.",
        "AC:D0:74": "Espressif Inc.",
        "38:E3:C5": "Taicang T&W Electronics",
        "00:15:CE": "ARRIS Group, Inc.",
        "00:15:A2": "ARRIS Group, Inc.",
        "00:15:A3": "ARRIS Group, Inc.",
        "00:15:A4": "ARRIS Group, Inc.",
        "00:00:CA": "ARRIS Group, Inc.",
        "70:9E:29": "Sony Interactive Entertainment Inc.",
        "A4:DB:30": "Liteon Technology Corporation",
        "40:F0:2F": "Liteon Technology Corporation",
        "74:C2:46": "Amazon Technologies Inc.",
        "00:0F:A3": "Alpha Networks Inc.",
        "00:1D:6A": "Alpha Networks Inc.",
        "00:1A:80": "Sony Corporation",
        "88:41:FC": "AirTies Wireless Networks",
        "00:30:D3": "Agilent Technologies, Inc.",
        "00:A0:2F": "ADB Broadband Italia",
        "98:74:3D": "Shenzhen Jun Kai Hengye Technology Co. Ltd",
        "A0:F4:59": "FN-LINK TECHNOLOGY LIMITED",
        "58:63:56": "FN-LINK TECHNOLOGY LIMITED",
        "8C:B8:64": "AcSiP Technology Corp.",
        "5C:E2:F4": "AcSiP Technology Corp.",
        "B8:61:6F": "Accton Technology Corp",
        "00:12:CF": "Accton Technology Corp",
        "00:30:F1": "Accton Technology Corp",
        "70:5A:0F": "Hewlett Packard",
        "44:95:FA": "Qingdao Santong Digital Technology Co.Ltd",
        "00:25:D3": "AzureWave Technology Inc.",
        "1C:4B:D6": "AzureWave Technology Inc.",
        "08:A9:5A": "AzureWave Technology Inc.",
        "94:DB:C9": "AzureWave Technology Inc.",
        "24:0A:64": "AzureWave Technology Inc.",
        "40:E2:30": "AzureWave Technology Inc.",
        "80:D2:1D": "AzureWave Technology Inc.",
        "D4:D1:84": "ADB Broadband Italia",
        "A0:4F:D4": "ADB Broadband Italia",
        "D0:0E:D9": "Taicang T&W Electronics",
        "54:14:73": "Wingtech Group (HongKong）Limited",
        "80:86:F2": "Intel Corporate",
        "E0:94:67": "Intel Corporate",
        "08:D4:0C": "Intel Corporate",
        "6C:88:14": "Intel Corporate",
        "30:3A:64": "Intel Corporate",
        "AC:FD:CE": "Intel Corporate",
        "7C:CC:B8": "Intel Corporate",
        "F4:06:69": "Intel Corporate",
        "00:1D:E1": "Intel Corporate",
        "90:E2:BA": "Intel Corporate",
        "00:26:C7": "Intel Corporate",
        "00:26:C6": "Intel Corporate",
        "0C:CC:26": "Airenetworks",
        "E0:9D:31": "Intel Corporate",
        "88:53:2E": "Intel Corporate",
        "74:C9:9A": "Ericsson AB",
        "5C:C2:13": "Fr. Sauter AG",
        "28:10:1B": "MagnaCom",
        "00:16:76": "Intel Corporate",
        "00:16:EA": "Intel Corporate",
        "00:1B:77": "Intel Corporate",
        "00:1C:C0": "Intel Corporate",
        "10:4A:7D": "Intel Corporate",
        "00:1A:A0": "Dell Inc.",
        "00:19:B9": "Dell Inc.",
        "00:B0:D0": "Dell Inc.",
        "00:C0:4F": "Dell Inc.",
        "B0:79:94": "Motorola Mobility LLC, a Lenovo Company",
        "A4:70:D6": "Motorola Mobility LLC, a Lenovo Company",
        "74:86:7A": "Dell Inc.",
        "18:03:73": "Dell Inc.",
        "14:FE:B5": "Dell Inc.",
        "78:2B:CB": "Dell Inc.",
        "00:1F:3B": "Intel Corporate",
        "00:21:5D": "Intel Corporate",
        "00:21:6A": "Intel Corporate",
        "00:1C:23": "Dell Inc.",
        "A4:BA:DB": "Dell Inc.",
        "00:25:64": "Dell Inc.",
        "A4:1F:72": "Dell Inc.",
        "C4:66:99": "vivo Mobile Communication Co., Ltd.",
        "C8:F2:30": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "8C:0E:E3": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "C8:CD:72": "Sagemcom Broadband SAS",
        "F8:2C:18": "2Wire Inc",
        "18:01:7D": "Harbin Arteor technology co., LTD",
        "00:15:56": "Sagemcom Broadband SAS",
        "C0:D0:44": "Sagemcom Broadband SAS",
        "A0:1B:29": "Sagemcom Broadband SAS",
        "74:E1:4A": "IEEE Registration Authority",
        "0C:EF:AF": "IEEE Registration Authority",
        "F8:02:78": "IEEE Registration Authority",
        "A0:BB:3E": "IEEE Registration Authority",
        "88:4A:EA": "Texas Instruments",
        "00:22:A4": "2Wire Inc",
        "98:2C:BE": "2Wire Inc",
        "64:0F:28": "2Wire Inc",
        "00:12:3F": "Dell Inc.",
        "00:0B:DB": "Dell Inc.",
        "20:47:47": "Dell Inc.",
        "00:14:95": "2Wire Inc",
        "34:8A:AE": "Sagemcom Broadband SAS",
        "7C:03:D8": "Sagemcom Broadband SAS",
        "C0:AC:54": "Sagemcom Broadband SAS",
        "2C:39:96": "Sagemcom Broadband SAS",
        "F0:82:61": "Sagemcom Broadband SAS",
        "00:30:C5": "CADENCE DESIGN SYSTEMS, INC.",
        "D0:8C:B5": "Texas Instruments",
        "00:18:2F": "Texas Instruments",
        "00:17:EA": "Texas Instruments",
        "00:21:BA": "Texas Instruments",
        "BC:0D:A5": "Texas Instruments",
        "CC:8C:E3": "Texas Instruments",
        "E0:D7:BA": "Texas Instruments",
        "1C:E2:CC": "Texas Instruments",
        "98:59:45": "Texas Instruments",
        "94:44:52": "Belkin International Inc.",
        "B0:B4:48": "Texas Instruments",
        "D4:94:A1": "Texas Instruments",
        "00:14:BF": "Cisco-Linksys, LLC",
        "CC:B2:55": "D-Link International",
        "28:10:7B": "D-Link International",
        "FC:75:16": "D-Link International",
        "84:C9:B2": "D-Link International",
        "C8:D3:A3": "D-Link International",
        "3C:BB:73": "Shenzhen Xinguodu Technology Co., Ltd.",
        "0C:47:C9": "Amazon Technologies Inc.",
        "00:50:BA": "D-Link Corporation",
        "00:17:9A": "D-Link Corporation",
        "00:1C:F0": "D-Link Corporation",
        "00:1E:58": "D-Link Corporation",
        "00:22:B0": "D-Link Corporation",
        "00:24:01": "D-Link Corporation",
        "1C:AF:F7": "D-Link International",
        "14:D6:4D": "D-Link International",
        "90:94:E4": "D-Link International",
        "B4:99:BA": "Hewlett Packard",
        "04:78:63": "Shanghai MXCHIP Information Technology Co., Ltd.",
        "40:9F:87": "Jide Technology (Hong Kong) Limited",
        "4C:FF:12": "Fuze Entertainment Co., ltd",
        "AC:9A:22": "NXP Semiconductors",
        "28:7C:DB": "Hefei  Toycloud Technology Co.,ltd",
        "48:AD:08": "HUAWEI TECHNOLOGIES CO.,LTD",
        "4C:FB:45": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:9A:CD": "HUAWEI TECHNOLOGIES CO.,LTD",
        "3C:5A:B4": "Google, Inc.",
        "F4:F5:E8": "Google, Inc.",
        "94:EB:2C": "Google, Inc.",
        "0C:C7:31": "Currant, Inc.",
        "70:B3:D5": "IEEE Registration Authority",
        "28:ED:6A": "Apple, Inc.",
        "C0:56:E3": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "EC:3E:F7": "Juniper Networks",
        "0C:F8:93": "ARRIS Group, Inc.",
        "3C:DF:A9": "ARRIS Group, Inc.",
        "84:61:A0": "ARRIS Group, Inc.",
        "00:15:D1": "ARRIS Group, Inc.",
        "00:1D:D0": "ARRIS Group, Inc.",
        "00:1D:D3": "ARRIS Group, Inc.",
        "AC:B3:13": "ARRIS Group, Inc.",
        "38:F2:3E": "Microsoft Mobile Oy",
        "E4:F8:9C": "Intel Corporate",
        "6C:A1:00": "Intel Corporate",
        "2C:41:38": "Hewlett Packard",
        "44:1E:A1": "Hewlett Packard",
        "78:E7:D1": "Hewlett Packard",
        "5C:8F:E0": "ARRIS Group, Inc.",
        "90:C7:92": "ARRIS Group, Inc.",
        "BC:CA:B5": "ARRIS Group, Inc.",
        "D0:39:B3": "ARRIS Group, Inc.",
        "00:0F:CC": "ARRIS Group, Inc.",
        "00:12:F0": "Intel Corporate",
        "00:07:40": "BUFFALO.INC",
        "00:24:A5": "BUFFALO.INC",
        "CC:E1:D5": "BUFFALO.INC",
        "A4:02:B9": "Intel Corporate",
        "DC:53:60": "Intel Corporate",
        "00:1C:C4": "Hewlett Packard",
        "00:1E:0B": "Hewlett Packard",
        "00:22:64": "Hewlett Packard",
        "00:25:B3": "Hewlett Packard",
        "00:0C:F1": "Intel Corporation",
        "78:48:59": "Hewlett Packard",
        "58:DC:6D": "Exceptional Innovation, Inc.",
        "90:21:55": "HTC Corporation",
        "64:31:50": "Hewlett Packard",
        "7C:B1:5D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:26:5E": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:24:2C": "Hon Hai Precision Ind. Co.,Ltd.",
        "D8:B3:77": "HTC Corporation",
        "B0:F1:A3": "Fengfan (BeiJing) Technology Co., Ltd. ",
        "34:64:A9": "Hewlett Packard",
        "38:63:BB": "Hewlett Packard",
        "5C:B9:01": "Hewlett Packard",
        "DC:4A:3E": "Hewlett Packard",
        "B0:5A:DA": "Hewlett Packard",
        "00:10:83": "Hewlett Packard",
        "A0:B3:CC": "Hewlett Packard",
        "EC:B1:D7": "Hewlett Packard",
        "9C:B6:54": "Hewlett Packard",
        "6C:3B:E5": "Hewlett Packard",
        "B0:AA:36": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "78:4B:87": "Murata Manufacturing Co., Ltd.",
        "E4:CE:02": "WyreStorm Technologies Ltd",
        "40:F3:08": "Murata Manufacturing Co., Ltd.",
        "80:89:17": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "A0:93:47": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "E8:BB:A8": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "94:2C:B3": "HUMAX Co., Ltd.",
        "00:27:19": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "40:16:9F": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "F4:EC:38": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "14:04:67": "SNK Technologies Co.,Ltd.",
        "80:30:DC": "Texas Instruments",
        "A4:D5:78": "Texas Instruments",
        "14:CF:92": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "20:DC:E6": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "14:CC:20": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "24:60:81": "razberi technologies",
        "A4:D1:8C": "Apple, Inc.",
        "90:F6:52": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "24:1E:EB": "Apple, Inc.",
        "CC:25:EF": "Apple, Inc.",
        "88:CF:98": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:0D:43": "Hon Hai Precision Ind. Co.,Ltd.",
        "38:F8:89": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D0:7A:B5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:19:C6": "zte corporation",
        "00:1D:D9": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:19:7D": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:14:A4": "Hon Hai Precision Ind. Co.,Ltd.",
        "78:DD:08": "Hon Hai Precision Ind. Co.,Ltd.",
        "9C:D2:1E": "Hon Hai Precision Ind. Co.,Ltd.",
        "B4:30:52": "HUAWEI TECHNOLOGIES CO.,LTD",
        "80:D0:9B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "1C:8E:5C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "84:74:2A": "zte corporation",
        "9C:D2:4B": "zte corporation",
        "C8:7B:5B": "zte corporation",
        "00:07:D8": "Hitron Technologies. Inc",
        "90:4E:2B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "20:08:ED": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:34:FE": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C8:51:95": "HUAWEI TECHNOLOGIES CO.,LTD",
        "40:CB:A8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D4:6E:5C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "88:53:D4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "04:C0:6F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "20:2B:C1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "54:A5:1B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:25:68": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:1D:BA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:25:9E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:6B:8E": "Shanghai Feixun Communication Co.,Ltd.",
        "D4:6A:A8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "BC:AD:AB": "Avaya Inc",
        "FC:A8:41": "Avaya Inc",
        "3C:B1:5B": "Avaya Inc",
        "34:75:C7": "Avaya Inc",
        "B0:AD:AA": "Avaya Inc",
        "B4:47:5E": "Avaya Inc",
        "B8:BC:1B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "58:2A:F7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:D9:21": "Avaya Inc",
        "84:83:71": "Avaya Inc",
        "00:1B:4F": "Avaya Inc",
        "4C:8B:EF": "HUAWEI TECHNOLOGIES CO.,LTD",
        "50:06:AB": "Cisco Systems, Inc",
        "FC:48:EF": "HUAWEI TECHNOLOGIES CO.,LTD",
        "70:7B:E8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "4C:1F:CC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:90:6D": "Cisco Systems, Inc",
        "00:90:AB": "Cisco Systems, Inc",
        "00:50:54": "Cisco Systems, Inc",
        "00:50:0B": "Cisco Systems, Inc",
        "00:03:DD": "Comark Interactive Solutions",
        "00:50:53": "Cisco Systems, Inc",
        "00:50:50": "Cisco Systems, Inc",
        "D4:B1:10": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E4:68:A3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:71:89": "Texas Instruments",
        "98:7B:F3": "Texas Instruments",
        "A0:F6:FD": "Texas Instruments",
        "D0:B5:C2": "Texas Instruments",
        "78:A5:04": "Texas Instruments",
        "6C:EC:EB": "Texas Instruments",
        "34:00:A3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:90:2B": "Cisco Systems, Inc",
        "00:E0:8F": "Cisco Systems, Inc",
        "00:18:68": "Cisco SPVTG",
        "88:75:56": "Cisco Systems, Inc",
        "FC:99:47": "Cisco Systems, Inc",
        "6C:20:56": "Cisco Systems, Inc",
        "00:15:F2": "ASUSTek COMPUTER INC.",
        "90:E6:BA": "ASUSTek COMPUTER INC.",
        "00:26:18": "ASUSTek COMPUTER INC.",
        "F4:6D:04": "ASUSTek COMPUTER INC.",
        "00:E0:18": "ASUSTek COMPUTER INC.",
        "00:0C:6E": "ASUSTek COMPUTER INC.",
        "00:0E:A6": "ASUSTek COMPUTER INC.",
        "00:1D:60": "ASUSTek COMPUTER INC.",
        "6C:41:6A": "Cisco Systems, Inc",
        "EC:E1:A9": "Cisco Systems, Inc",
        "C0:67:AF": "Cisco Systems, Inc",
        "AC:F2:C5": "Cisco Systems, Inc",
        "24:01:C7": "Cisco Systems, Inc",
        "68:86:A7": "Cisco Systems, Inc",
        "C0:25:5C": "Cisco Systems, Inc",
        "3C:0E:23": "Cisco Systems, Inc",
        "08:CC:68": "Cisco Systems, Inc",
        "0C:27:24": "Cisco Systems, Inc",
        "6C:FA:89": "Cisco Systems, Inc",
        "00:E0:A3": "Cisco Systems, Inc",
        "60:2A:D0": "Cisco SPVTG",
        "74:5E:1C": "PIONEER CORPORATION",
        "04:62:73": "Cisco Systems, Inc",
        "D8:B1:90": "Cisco Systems, Inc",
        "80:E8:6F": "Cisco Systems, Inc",
        "AC:7E:8A": "Cisco Systems, Inc",
        "1C:E8:5D": "Cisco Systems, Inc",
        "A8:9D:21": "Cisco Systems, Inc",
        "68:9C:E2": "Cisco Systems, Inc",
        "00:23:BE": "Cisco SPVTG",
        "18:59:33": "Cisco SPVTG",
        "44:58:29": "Cisco SPVTG",
        "F4:4E:05": "Cisco Systems, Inc",
        "88:1D:FC": "Cisco Systems, Inc",
        "00:10:11": "Cisco Systems, Inc",
        "00:00:0C": "Cisco Systems, Inc",
        "28:CF:E9": "Apple, Inc.",
        "00:A0:40": "Apple, Inc.",
        "A0:F8:49": "Cisco Systems, Inc",
        "3C:D0:F8": "Apple, Inc.",
        "68:09:27": "Apple, Inc.",
        "6C:C2:6B": "Apple, Inc.",
        "44:D8:84": "Apple, Inc.",
        "00:26:08": "Apple, Inc.",
        "00:26:B0": "Apple, Inc.",
        "00:26:BB": "Apple, Inc.",
        "D4:9A:20": "Apple, Inc.",
        "F8:1E:DF": "Apple, Inc.",
        "C8:2A:14": "Apple, Inc.",
        "3C:07:54": "Apple, Inc.",
        "A4:B1:97": "Apple, Inc.",
        "F0:B4:79": "Apple, Inc.",
        "10:93:E9": "Apple, Inc.",
        "44:2A:60": "Apple, Inc.",
        "A4:D1:D2": "Apple, Inc.",
        "28:CF:DA": "Apple, Inc.",
        "00:30:65": "Apple, Inc.",
        "00:14:51": "Apple, Inc.",
        "00:1E:52": "Apple, Inc.",
        "00:21:E9": "Apple, Inc.",
        "CC:08:E0": "Apple, Inc.",
        "04:54:53": "Apple, Inc.",
        "F4:F9:51": "Apple, Inc.",
        "C0:63:94": "Apple, Inc.",
        "18:AF:8F": "Apple, Inc.",
        "C8:B5:B7": "Apple, Inc.",
        "90:B2:1F": "Apple, Inc.",
        "30:F7:C5": "Apple, Inc.",
        "40:B3:95": "Apple, Inc.",
        "44:FB:42": "Apple, Inc.",
        "E8:8D:28": "Apple, Inc.",
        "94:94:26": "Apple, Inc.",
        "20:7D:74": "Apple, Inc.",
        "F4:F1:5A": "Apple, Inc.",
        "C8:6F:1D": "Apple, Inc.",
        "30:90:AB": "Apple, Inc.",
        "8C:2D:AA": "Apple, Inc.",
        "84:85:06": "Apple, Inc.",
        "98:FE:94": "Apple, Inc.",
        "D8:00:4D": "Apple, Inc.",
        "64:20:0C": "Apple, Inc.",
        "C8:33:4B": "Apple, Inc.",
        "64:E6:82": "Apple, Inc.",
        "B8:E8:56": "Apple, Inc.",
        "D8:96:95": "Apple, Inc.",
        "14:99:E2": "Apple, Inc.",
        "B4:18:D1": "Apple, Inc.",
        "9C:20:7B": "Apple, Inc.",
        "B0:65:BD": "Apple, Inc.",
        "54:26:96": "Apple, Inc.",
        "64:A3:CB": "Apple, Inc.",
        "90:3C:92": "Apple, Inc.",
        "D8:1D:72": "Apple, Inc.",
        "34:12:98": "Apple, Inc.",
        "70:E7:2C": "Apple, Inc.",
        "70:EC:E4": "Apple, Inc.",
        "68:AE:20": "Apple, Inc.",
        "AC:87:A3": "Apple, Inc.",
        "D8:BB:2C": "Apple, Inc.",
        "D0:4F:7E": "Apple, Inc.",
        "20:78:F0": "Apple, Inc.",
        "E0:AC:CB": "Apple, Inc.",
        "A0:99:9B": "Apple, Inc.",
        "24:24:0E": "Apple, Inc.",
        "F0:DB:F8": "Apple, Inc.",
        "48:74:6E": "Apple, Inc.",
        "54:AE:27": "Apple, Inc.",
        "FC:E9:98": "Apple, Inc.",
        "0C:BC:9F": "Apple, Inc.",
        "34:36:3B": "Apple, Inc.",
        "D0:A6:37": "Apple, Inc.",
        "78:9F:70": "Apple, Inc.",
        "9C:F3:87": "Apple, Inc.",
        "A8:5B:78": "Apple, Inc.",
        "C8:F6:50": "Apple, Inc.",
        "A8:8E:24": "Apple, Inc.",
        "6C:4A:39": "BITA",
        "84:7D:50": "Holley Metering Limited",
        "50:D5:9C": "Thai Habel Industrial Co., Ltd.",
        "20:89:6F": "Fiberhome Telecommunication Technologies Co.,LTD",
        "30:52:CB": "Liteon Technology Corporation",
        "04:96:45": "WUXI SKY CHIP INTERCONNECTION TECHNOLOGY CO.,LTD.",
        "1C:CD:E5": "Shanghai Wind Technologies Co.,Ltd",
        "68:14:01": "Hon Hai Precision Ind. Co.,Ltd.",
        "50:A9:DE": "Smartcom - Bulgaria AD",
        "AC:1F:D7": "Real Vision Technology Co.,Ltd.",
        "88:C2:42": "Poynt Co.",
        "14:02:EC": "Hewlett Packard Enterprise",
        "E0:34:E4": "Feit Electric Company, Inc.",
        "34:C9:F0": "LM Technologies Ltd",
        "68:A8:28": "HUAWEI TECHNOLOGIES CO.,LTD",
        "CC:20:E8": "Apple, Inc.",
        "48:BF:74": "Baicells Technologies Co.,LTD",
        "6C:93:54": "Yaojin Technology (Shenzhen) Co., LTD.",
        "DC:DC:07": "TRP Systems BV",
        "38:91:D5": "Hangzhou H3C Technologies Co., Limited",
        "8C:E2:DA": "Circle Media Inc",
        "38:21:87": "Midea Group Co., Ltd.",
        "78:D6:B2": "Toshiba",
        "E8:DE:D6": "Intrising Networks, Inc.",
        "DC:82:F6": "iPort",
        "70:48:0F": "Apple, Inc.",
        "3C:B7:2B": "PLUMgrid Inc",
        "48:9A:42": "Technomate Ltd",
        "20:D1:60": "Private",
        "BC:9C:31": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D8:8B:4C": "KingTing Tech.",
        "38:4C:90": "ARRIS Group, Inc.",
        "F0:B0:E7": "Apple, Inc.",
        "38:1C:23": "Hilan Technology CO.,LTD",
        "64:9A:12": "P2 Mobile Technologies Limited",
        "AC:89:95": "AzureWave Technology Inc.",
        "04:69:F8": "Apple, Inc.",
        "30:29:BE": "Shanghai MRDcom Co.,Ltd",
        "20:C3:A4": "RetailNext",
        "E4:C2:D1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D4:F4:BE": "Palo Alto Networks",
        "48:B6:20": "ROLI Ltd.",
        "D8:88:CE": "RF Technology Pty Ltd",
        "30:7C:B2": "ANOV FRANCE",
        "84:79:73": "Shanghai Baud Data Communication Co.,Ltd.",
        "E8:B4:C8": "Samsung Electronics Co.,Ltd",
        "D0:87:E2": "Samsung Electronics Co.,Ltd",
        "F0:5B:7B": "Samsung Electronics Co.,Ltd",
        "B0:47:BF": "Samsung Electronics Co.,Ltd",
        "7C:0B:C6": "Samsung Electronics Co.,Ltd",
        "7C:FE:90": "Mellanox Technologies, Inc.",
        "84:5B:12": "HUAWEI TECHNOLOGIES CO.,LTD",
        "20:55:31": "Samsung Electronics Co.,Ltd",
        "10:86:8C": "ARRIS Group, Inc.",
        "44:FD:A3": "Everysight LTD.",
        "A8:A7:95": "Hon Hai Precision Ind. Co.,Ltd.",
        "90:6F:A9": "NANJING PUTIAN TELECOMMUNICATIONS TECHNOLOGY CO.,LTD.",
        "60:FD:56": "WOORISYSTEMS CO., Ltd",
        "98:70:E8": "INNATECH SDN BHD",
        "44:65:6A": "Mega Video Electronic(HK) Industry Co., Ltd",
        "78:EB:39": "Instituto Nacional de Tecnología Industrial",
        "0C:75:6C": "Anaren Microwave, Inc.",
        "D4:7B:B0": "ASKEY COMPUTER CORP",
        "F0:22:4E": "Esan electronic co.",
        "CC:5F:BF": "Topwise 3G Communication Co., Ltd.",
        "C8:F9:C8": "NewSharp Technology(SuZhou)Co,Ltd",
        "80:C5:E6": "Microsoft Corporation",
        "10:DF:8B": "Shenzhen CareDear Communication Technology Co.,Ltd",
        "C4:12:F5": "D-Link International",
        "5C:45:27": "Juniper Networks",
        "E0:2C:B2": "Lenovo Mobile Communication (Wuhan) Company Limited",
        "60:6D:C7": "Hon Hai Precision Ind. Co.,Ltd.",
        "68:ED:A4": "Shenzhen Seavo Technology Co.,Ltd",
        "2C:C5:D3": "Ruckus Wireless",
        "F4:57:3E": "Fiberhome Telecommunication Technologies Co.,LTD",
        "D0:43:1E": "Dell Inc.",
        "54:CD:10": "Panasonic Mobile Communications Co.,Ltd.",
        "40:8D:5C": "GIGA-BYTE TECHNOLOGY CO.,LTD.",
        "FC:E1:FB": "Array Networks",
        "E8:91:20": "Motorola Mobility LLC, a Lenovo Company",
        "D4:F9:A1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "54:40:AD": "Samsung Electronics Co.,Ltd",
        "A4:24:DD": "Cambrionix Ltd",
        "14:5A:83": "Logi-D inc",
        "80:4E:81": "Samsung Electronics Co.,Ltd",
        "C0:9A:71": "XIAMEN MEITU MOBILE TECHNOLOGY CO.LTD",
        "64:16:7F": "Polycom",
        "34:0B:40": "MIOS ELETTRONICA SRL",
        "48:06:6A": "Tempered Networks, Inc.",
        "BC:F8:11": "Xiamen DNAKE Technology Co.,Ltd",
        "90:0A:39": "Wiio, Inc.",
        "D0:C0:BF": "Actions Microelectronics Co., Ltd",
        "E8:61:BE": "Melec Inc.",
        "58:70:C6": "Shanghai Xiaoyi Technology Co., Ltd.",
        "FC:8F:90": "Samsung Electronics Co.,Ltd",
        "74:04:2B": "Lenovo Mobile Communication (Wuhan) Company Limited",
        "F8:7A:EF": "Rosonix Technology, Inc.",
        "20:28:BC": "Visionscape Co,. Ltd.",
        "24:1C:04": "SHENZHEN JEHE TECHNOLOGY DEVELOPMENT CO., LTD.",
        "D0:5C:7A": "Sartura d.o.o.",
        "88:70:33": "Hangzhou Silan Microelectronic Inc",
        "DC:56:E6": "Shenzhen Bococom Technology Co.,LTD",
        "CC:96:35": "LVS Co.,Ltd.",
        "44:80:EB": "Motorola Mobility LLC, a Lenovo Company",
        "40:28:14": "RFI Engineering",
        "14:41:46": "Honeywell (China) Co., LTD",
        "94:F1:9E": "HUIZHOU MAORONG INTELLIGENT TECHNOLOGY CO.,LTD",
        "B8:56:BD": "ITT LLC",
        "40:A5:EF": "Shenzhen Four Seas Global Link Network Technology Co., Ltd.",
        "C4:92:4C": "KEISOKUKI CENTER CO.,LTD.",
        "74:9C:E3": "KodaCloud Canada, Inc",
        "D4:55:56": "Fiber Mountain Inc.",
        "50:50:2A": "Egardia",
        "74:96:37": "Todaair Electronic Co., Ltd",
        "88:E6:03": "Avotek corporation",
        "2C:AD:13": "SHENZHEN ZHILU TECHNOLOGY CO.,LTD",
        "78:AC:BF": "Igneous Systems",
        "C4:8E:8F": "Hon Hai Precision Ind. Co.,Ltd.",
        "C4:36:6C": "LG Innotek",
        "54:36:9B": "1Verge Internet Technology (Beijing) Co., Ltd.",
        "40:D2:8A": "Nintendo Co., Ltd.",
        "40:62:B6": "Tele system communication",
        "60:12:8B": "CANON INC.",
        "84:C3:E8": "Vaillant GmbH",
        "9C:D3:5B": "Samsung Electronics Co.,Ltd",
        "A8:9F:BA": "Samsung Electronics Co.,Ltd",
        "B8:8E:C6": "Stateless Networks",
        "BC:D1:65": "Cisco SPVTG",
        "28:E4:76": "Pi-Coral",
        "4C:A5:15": "Baikal Electronics JSC",
        "7C:3C:B6": "Shenzhen Homecare Technology Co.,Ltd.",
        "20:C0:6D": "SHENZHEN SPACETEK TECHNOLOGY CO.,LTD",
        "48:86:E8": "Microsoft Corporation",
        "74:A3:4A": "ZIMI CORPORATION",
        "A8:64:05": "nimbus 9, Inc",
        "30:D5:87": "Samsung Electronics Co.,Ltd",
        "68:28:F6": "Vubiq Networks, Inc.",
        "DC:60:A1": "Teledyne DALSA Professional Imaging",
        "10:A6:59": "Mobile Create Co.,Ltd.",
        "58:85:6E": "QSC AG",
        "8C:91:09": "Toyoshima Electric Technoeogy(Suzhou) Co.,Ltd.",
        "54:09:8D": "deister electronic GmbH",
        "D0:5B:A8": "zte corporation",
        "E4:BA:D9": "360 Fly Inc.",
        "EC:59:E7": "Microsoft Corporation",
        "C0:35:C5": "Prosoft Systems LTD",
        "A0:A3:E2": "Actiontec Electronics, Inc",
        "74:54:7D": "Cisco SPVTG",
        "00:E6:E8": "Netzin Technology Corporation,.Ltd.",
        "50:F4:3C": "Leeo Inc",
        "E8:87:A3": "Loxley Public Company Limited",
        "10:C6:7E": "SHENZHEN JUCHIN TECHNOLOGY CO., LTD",
        "08:A5:C8": "Sunnovo International Limited",
        "F8:84:79": "Yaojin Technology(Shenzhen)Co.,Ltd",
        "2C:29:97": "Microsoft Corporation",
        "D4:61:32": "Pro Concept Manufacturer Co.,Ltd.",
        "54:A0:50": "ASUSTek COMPUTER INC.",
        "4C:2C:83": "Zhejiang KaNong Network Technology Co.,Ltd.",
        "90:8C:09": "Total Phase",
        "DC:2F:03": "Step forward Group Co., Ltd.",
        "38:0E:7B": "V.P.S. Thai Co., Ltd",
        "2C:37:96": "CYBO CO.,LTD.",
        "58:7F:B7": "SONAR INDUSTRIAL CO., LTD.",
        "08:EB:29": "Jiangsu Huitong Group Co.,Ltd.",
        "40:9B:0D": "Shenzhen Yourf Kwan Industrial Co., Ltd",
        "D8:CB:8A": "Micro-Star INTL CO., LTD.",
        "70:FC:8C": "OneAccess SA",
        "58:10:8C": "Intelbras",
        "4C:74:03": "BQ",
        "8C:5D:60": "UCI Corporation Co.,Ltd.",
        "BC:6B:4D": "Nokia",
        "C8:D0:19": "Shanghai Tigercel Communication Technology Co.,Ltd",
        "90:21:81": "Shanghai Huaqin Telecom Technology Co.,Ltd",
        "84:96:81": "Cathay Communication Co.,Ltd",
        "2C:A3:0E": "POWER DRAGON DEVELOPMENT LIMITED",
        "84:86:F3": "Greenvity Communications",
        "1C:52:16": "DONGGUAN HELE ELECTRONICS CO., LTD",
        "60:99:D1": "Vuzix / Lenovo",
        "B0:45:15": "mira fitness,LLC.",
        "14:48:8B": "Shenzhen Doov Technology Co.,Ltd",
        "20:12:D5": "Scientech Materials Corporation",
        "6C:6E:FE": "Core Logic Inc.",
        "38:08:FD": "Silca Spa",
        "78:45:61": "CyberTAN Technology Inc.",
        "94:CE:31": "CTS Limited",
        "80:F8:EB": "RayTight",
        "D4:37:D7": "zte corporation",
        "2C:01:0B": "NASCENT Technology, LLC - RemKon",
        "04:DE:DB": "Rockport Networks Inc",
        "1C:48:40": "IMS Messsysteme GmbH",
        "60:50:C1": "Kinetek Sports",
        "2C:1A:31": "Electronics Company Limited",
        "90:B6:86": "Murata Manufacturing Co., Ltd.",
        "EC:D9:D1": "Shenzhen TG-NET Botone Technology Co.,Ltd.",
        "6C:02:73": "Shenzhen Jin Yun Video Equipment Co., Ltd.",
        "54:DF:00": "Ulterius Technologies, LLC",
        "20:ED:74": "Ability enterprise co.,Ltd.",
        "A0:56:B2": "Harman/Becker Automotive Systems GmbH",
        "44:66:6E": "IP-LINE",
        "24:4F:1D": "iRule LLC",
        "94:AE:E3": "Belden Hirschmann Industries (Suzhou) Ltd.",
        "5C:B6:CC": "NovaComm Technologies Inc.",
        "70:5B:2E": "M2Communication Inc.",
        "5C:15:15": "ADVAN",
        "D0:59:E4": "Samsung Electronics Co.,Ltd",
        "14:A3:64": "Samsung Electronics Co.,Ltd",
        "B4:0A:C6": "DEXON Systems Ltd.",
        "D8:66:EE": "BOXIN COMMUNICATION CO.,LTD.",
        "28:29:CC": "Corsa Technology Incorporated",
        "18:4A:6F": "Alcatel-Lucent Shanghai Bell Co., Ltd",
        "10:C3:7B": "ASUSTek COMPUTER INC.",
        "E8:5D:6B": "Luminate Wireless",
        "B4:0B:44": "Smartisan Technology Co., Ltd.",
        "34:31:C4": "AVM GmbH",
        "50:FE:F2": "Sify Technologies Ltd",
        "34:C5:D0": "Hagleitner Hygiene International GmbH",
        "A0:12:DB": "TABUCHI ELECTRIC CO.,LTD",
        "48:1A:84": "Pointer Telocation Ltd",
        "DC:66:3A": "Apacer Technology Inc.",
        "08:DF:1F": "Bose Corporation",
        "58:1F:67": "Open-m technology limited",
        "48:26:E8": "Tek-Air Systems, Inc.",
        "D0:5A:F1": "Shenzhen Pulier Tech CO.,Ltd",
        "FC:E1:86": "A3M Co., LTD",
        "54:EF:92": "Shenzhen Elink Technology Co., LTD",
        "EC:E5:12": "tado GmbH",
        "5C:F4:AB": "Zyxel Communications Corporation",
        "08:B2:A3": "Cynny Italia S.r.L.",
        "70:30:5D": "Ubiquoss Inc",
        "48:82:44": "Life Fitness / Div. of Brunswick",
        "C8:31:68": "eZEX corporation",
        "40:B3:CD": "Chiyoda Electronics Co.,Ltd.",
        "24:33:6C": "Private",
        "20:25:64": "PEGATRON CORPORATION",
        "C8:D5:90": "FLIGHT DATA SYSTEMS",
        "7C:FF:62": "Huizhou Super Electron Technology Co.,Ltd.",
        "84:B5:9C": "Juniper Networks",
        "C0:9D:26": "Topicon HK Lmd.",
        "44:29:38": "NietZsche enterprise Co.Ltd.",
        "A0:DA:92": "Nanjing Glarun Atten Technology Co. Ltd.",
        "EC:F7:2B": "HD DIGITAL TECH CO., LTD.",
        "4C:F4:5B": "Blue Clover Devices",
        "B0:69:71": "DEI Sales, Inc.",
        "18:89:DF": "CerebrEX Inc.",
        "54:C8:0F": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "E4:D3:32": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "0C:20:26": "noax Technologies AG",
        "28:3B:96": "Cool Control LTD",
        "64:8D:9E": "IVT Electronic Co.,Ltd",
        "CC:95:D7": "Vizio, Inc",
        "FC:09:F6": "GUANGDONG TONZE ELECTRIC CO.,LTD",
        "BC:F6:1C": "Geomodeling Wuxi Technology Co. Ltd.",
        "FC:92:3B": "Nokia Corporation",
        "E0:3F:49": "ASUSTek COMPUTER INC.",
        "88:A7:3C": "Ragentek Technology Group",
        "88:D9:62": "Canopus Systems US LLC",
        "D0:9C:30": "Foster Electric Company, Limited",
        "94:9F:3F": "Optek Digital Technology company limited",
        "78:FE:E2": "Shanghai Diveo Technology Co., Ltd",
        "08:6D:F2": "Shenzhen MIMOWAVE Technology Co.,Ltd",
        "48:D0:CF": "Universal Electronics, Inc.",
        "9C:3E:AA": "EnvyLogic Co.,Ltd.",
        "1C:FC:BB": "Realfiction ApS",
        "F8:F0:05": "Newport Media Inc.",
        "28:65:6B": "Keystone Microtech Corporation",
        "CC:9F:35": "Transbit Sp. z o.o.",
        "DC:C7:93": "Nokia Corporation",
        "44:48:91": "HDMI Licensing, LLC",
        "5C:25:4C": "Avire Global Pte Ltd",
        "D4:2F:23": "Akenori PTE Ltd",
        "98:C0:EB": "Global Regency Ltd",
        "F0:3F:F8": "R L Drake",
        "B0:C5:54": "D-Link International",
        "48:EE:86": "UTStarcom (China) Co.,Ltd",
        "88:89:14": "All Components Incorporated",
        "F0:32:1A": "Mita-Teknik A/S",
        "A8:81:F1": "BMEYE B.V.",
        "C4:E9:84": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "D0:69:D0": "Verto Medical Solutions, LLC",
        "FC:13:49": "Global Apps Corp.",
        "84:84:33": "Paradox Engineering SA",
        "44:C3:06": "SIFROM Inc.",
        "60:21:03": "I4VINE, INC",
        "FC:07:A0": "LRE Medical GmbH",
        "1C:EE:E8": "Ilshin Elecom",
        "90:31:CD": "Onyx Healthcare Inc.",
        "E4:81:84": "Nokia",
        "14:C0:89": "DUNE HD LTD",
        "F4:B6:E5": "TerraSem Co.,Ltd",
        "60:FF:DD": "C.E. ELECTRONICS, INC",
        "24:05:0F": "MTN Electronic Co. Ltd",
        "AC:2D:A3": "TXTR GmbH",
        "88:9C:A6": "BTB Korea INC",
        "90:83:7A": "General Electric Water & Process Technologies",
        "80:BA:E6": "Neets",
        "F8:A2:B4": "RHEWA-WAAGENFABRIK August Freudewald GmbH &amp;Co. KG",
        "E0:56:F4": "AxesNetwork Solutions inc.",
        "84:56:9C": "Coho Data, Inc.,",
        "78:AE:0C": "Far South Networks",
        "B0:24:F3": "Progeny Systems",
        "0C:54:A5": "PEGATRON CORPORATION",
        "8C:4D:B9": "Unmonday Ltd",
        "78:CA:5E": "ELNO",
        "2C:5A:05": "Nokia Corporation",
        "D4:81:CA": "iDevices, LLC",
        "D8:58:D7": "CZ.NIC, z.s.p.o.",
        "B0:D7:C5": "Logipix Ltd",
        "A4:3A:69": "Vers Inc",
        "9C:44:A6": "SwiftTest, Inc.",
        "4C:D9:C4": "Magneti Marelli Automotive Electronics (Guangzhou) Co. Ltd",
        "50:E0:C7": "TurControlSystme AG",
        "B4:82:7B": "AKG Acoustics GmbH",
        "DC:5E:36": "Paterson Technology",
        "DC:AD:9E": "GreenPriz",
        "B8:DF:6B": "SpotCam Co., Ltd.",
        "9C:88:88": "Simac Techniek NV",
        "10:B2:6B": "base Co.,Ltd.",
        "4C:F0:2E": "Vifa Denmark A/S",
        "28:8A:1C": "Juniper Networks",
        "DC:CE:BC": "Shenzhen JSR Technology Co.,Ltd.",
        "18:C8:E7": "Shenzhen Hualistone Technology Co.,Ltd",
        "A0:3B:1B": "Inspire Tech",
        "7C:CD:3C": "Guangzhou Juzing Technology Co., Ltd",
        "98:43:DA": "INTERTECH",
        "08:CA:45": "Toyou Feiji Electronics Co., Ltd.",
        "3C:CA:87": "Iders Incorporated",
        "7C:6A:B3": "IBC TECHNOLOGIES INC.",
        "18:1B:EB": "Actiontec Electronics, Inc",
        "84:A7:83": "Alcatel Lucent",
        "04:1A:04": "WaveIP",
        "34:A5:E1": "Sensorist ApS",
        "80:79:AE": "ShanDong Tecsunrise  Co.,Ltd",
        "7C:BD:06": "AE REFUsol",
        "94:BA:56": "Shenzhen Coship Electronics Co., Ltd.",
        "38:DB:BB": "Sunbow Telecom Co., Ltd.",
        "44:8A:5B": "Micro-Star INT'L CO., LTD.",
        "6C:4B:7F": "Vossloh-Schwabe Deutschland GmbH",
        "90:8C:44": "H.K ZONGMU TECHNOLOGY CO., LTD.",
        "68:8A:B5": "EDP Servicos",
        "24:93:CA": "Voxtronic Austria",
        "0C:CB:8D": "ASCO Numatics GmbH",
        "90:79:90": "Benchmark Electronics Romania SRL",
        "74:0E:DB": "Optowiz Co., Ltd",
        "6C:83:66": "Nanjing SAC Power Grid Automation Co., Ltd.",
        "F8:3D:4E": "Softlink Automation System Co., Ltd",
        "74:D4:35": "GIGA-BYTE TECHNOLOGY CO.,LTD.",
        "78:D9:9F": "NuCom HK Ltd.",
        "14:2B:D2": "Armtel Ltd.",
        "9C:A1:0A": "SCLE SFE",
        "88:78:9C": "Game Technologies SA",
        "A4:89:5B": "ARK INFOSOLUTIONS PVT LTD",
        "D0:9D:0A": "LINKCOM",
        "EC:21:9F": "VidaBox LLC",
        "A8:CC:C5": "Saab AB (publ)",
        "58:46:8F": "Koncar Electronics and Informatics",
        "98:5D:46": "PeopleNet Communication",
        "F8:9F:B8": "YAZAKI Energy System Corporation",
        "F0:F5:AE": "Adaptrum Inc.",
        "FC:3F:AB": "Henan Lanxin Technology Co., Ltd",
        "98:8E:4A": "NOXUS(BEIJING) TECHNOLOGY CO.,LTD",
        "EC:2A:F0": "Ypsomed AG",
        "F8:54:AF": "ECI Telecom Ltd.",
        "54:BE:F7": "PEGATRON CORPORATION",
        "50:B8:88": "wi2be Tecnologia S/A",
        "7C:83:06": "Glen Dimplex Nordic as",
        "44:2A:FF": "E3 Technology, Inc.",
        "14:0D:4F": "Flextronics International",
        "44:67:55": "Orbit Irrigation",
        "E0:FA:EC": "Platan sp. z o.o. sp. k.",
        "7C:E5:6B": "ESEN Optoelectronics Technology Co.,Ltd.",
        "D4:4C:9C": "Shenzhen YOOBAO Technology Co.Ltd",
        "20:CE:C4": "Peraso Technologies",
        "CC:47:03": "Intercon Systems Co., Ltd.",
        "AC:CA:8E": "ODA Technologies",
        "08:8E:4F": "SF Software Solutions",
        "54:05:36": "Vivago Oy",
        "6C:90:B1": "SanLogic Inc",
        "CC:7B:35": "zte corporation",
        "04:D4:37": "ZNV",
        "CC:F4:07": "EUKREA ELECTROMATIQUE SARL",
        "DC:17:92": "Captivate Network",
        "28:A2:41": "exlar corp",
        "50:98:71": "Inventum Technologies Private Limited",
        "04:8C:03": "ThinPAD Technology (Shenzhen)CO.,LTD",
        "88:46:2A": "Telechips Inc.",
        "C8:02:58": "ITW GSE ApS",
        "30:78:6B": "TIANJIN Golden Pentagon Electronics Co., Ltd.",
        "20:DF:3F": "Nanjing SAC Power Grid Automation Co., Ltd.",
        "F8:51:6D": "Denwa Technology Corp.",
        "44:4A:65": "Silverflare Ltd.",
        "74:4B:E9": "EXPLORER HYPERTECH CO.,LTD",
        "FC:60:18": "Zhejiang Kangtai Electric Co., Ltd.",
        "F4:20:12": "Cuciniale GmbH",
        "98:B0:39": "Nokia",
        "B8:30:A8": "Road-Track Telematics Development",
        "4C:D6:37": "Qsono Electronics Co., Ltd",
        "94:36:E0": "Sichuan Bihong Broadcast &amp; Television New Technologies Co.,Ltd",
        "54:22:F8": "zte corporation",
        "48:6E:73": "Pica8, Inc.",
        "64:05:BE": "NEW LIGHT LED",
        "64:6E:EA": "Iskratel d.o.o.",
        "D0:73:7F": "Mini-Circuits",
        "E8:BB:3D": "Sino Prime-Tech Limited",
        "28:28:5D": "Zyxel Communications Corporation",
        "0C:F0:19": "Malgn Technology Co., Ltd.",
        "94:9F:B4": "ChengDu JiaFaAnTai Technology Co.,Ltd",
        "40:68:26": "Thales UK Limited",
        "F8:2B:C8": "Jiangsu Switter Co., Ltd",
        "60:C3:97": "2Wire Inc",
        "E0:7F:88": "EVIDENCE Network SIA",
        "1C:7C:C7": "Coriant GmbH",
        "34:1B:22": "Grandbeing Technology Co., Ltd",
        "40:56:0C": "In Home Displays Ltd",
        "58:E0:2C": "Micro Technic A/S",
        "78:B3:CE": "Elo touch solutions",
        "88:14:2B": "Protonic Holland",
        "A4:FC:CE": "Security Expert Ltd.",
        "34:A6:8C": "Shine Profit Development Limited",
        "34:1A:4C": "SHENZHEN WEIBU ELECTRONICS CO.,LTD.",
        "04:88:E2": "Beats Electronics LLC",
        "A4:7A:CF": "VIBICOM COMMUNICATIONS INC.",
        "BC:26:1D": "HONG KONG TECON TECHNOLOGY",
        "E8:CE:06": "SkyHawke Technologies, LLC.",
        "C8:F3:86": "Shenzhen Xiaoniao Technology Co.,Ltd",
        "84:2F:75": "Innokas Group",
        "CC:3C:3F": "SA.S.S. Datentechnik AG",
        "2C:69:BA": "RF Controls, LLC",
        "D4:BF:7F": "UPVEL",
        "2C:72:C3": "Soundmatters",
        "C4:48:38": "Satcom Direct, Inc.",
        "C8:DD:C9": "Lenovo Mobile Communication Technology Ltd.",
        "6C:86:86": "Technonia",
        "D4:AC:4E": "BODi rS, LLC",
        "20:4C:6D": "Hugo Brennenstuhl Gmbh & Co. KG.",
        "40:C4:D6": "ChongQing Camyu Technology Development Co.,Ltd.",
        "A8:29:4C": "Precision Optical Transceivers, Inc.",
        "70:C6:AC": "Bosch Automotive Aftermarket",
        "7C:05:07": "PEGATRON CORPORATION",
        "88:09:05": "MTMCommunications",
        "30:D4:6A": "Autosales Incorporated",
        "28:2C:B2": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "64:E5:99": "EFM Networks",
        "30:89:99": "Guangdong East Power Co.,",
        "C8:93:46": "MXCHIP Company Limited",
        "F4:B3:81": "WindowMaster A/S",
        "74:F1:02": "Beijing HCHCOM Technology Co., Ltd",
        "A0:86:1D": "Chengdu Fuhuaxin Technology co.,Ltd",
        "50:8D:6F": "CHAHOO Limited",
        "E8:DE:27": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "94:AC:CA": "trivum technologies GmbH",
        "90:82:60": "IEEE 1904.1 Working Group",
        "D4:EE:07": "HIWIFI Co., Ltd.",
        "FC:AD:0F": "QTS NETWORKS",
        "98:4C:04": "Zhangzhou Keneng Electrical Equipment Co Ltd",
        "A4:E9:91": "SISTEMAS AUDIOVISUALES ITELSIS S.L.",
        "3C:86:A8": "Sangshin elecom .co,, LTD",
        "84:F4:93": "OMS spol. s.r.o.",
        "BC:D1:77": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "AC:DB:DA": "Shenzhen Geniatech Inc, Ltd",
        "D4:27:51": "Infopia Co., Ltd",
        "10:3D:EA": "HFC Technology (Beijing) Ltd. Co.",
        "F0:5D:C8": "Duracell Powermat",
        "CC:5D:57": "Information  System Research Institute,Inc.",
        "64:C6:67": "Barnes&Noble",
        "F0:F2:60": "Mobitec AB",
        "04:4C:EF": "Fujian Sanao Technology Co.,Ltd",
        "4C:80:4F": "Armstrong Monitoring Corp",
        "7C:D7:62": "Freestyle Technology Pty Ltd",
        "90:1D:27": "zte corporation",
        "9C:31:78": "Foshan Huadian Intelligent Communications Teachnologies Co.,Ltd",
        "B0:C9:5B": "Beijing Symtech CO.,LTD",
        "4C:CA:53": "Skyera, Inc.",
        "90:FF:79": "Metro Ethernet Forum",
        "B0:14:08": "LIGHTSPEED INTERNATIONAL CO.",
        "08:1D:FB": "Shanghai Mexon Communication Technology Co.,Ltd",
        "98:3F:9F": "China SSJ (Suzhou) Network Technology Inc.",
        "B8:38:CA": "Kyokko Tsushin System CO.,LTD",
        "C4:4E:AC": "Shenzhen Shiningworth Technology Co., Ltd.",
        "A8:01:80": "IMAGO Technologies GmbH",
        "0C:55:21": "Axiros GmbH",
        "68:A4:0E": "BSH Hausgeräte GmbH",
        "F4:C6:D7": "blackned GmbH",
        "D4:CA:6E": "u-blox AG",
        "5C:43:D2": "HAZEMEYER",
        "D8:09:C3": "Cercacor Labs",
        "E0:C2:B7": "Masimo Corporation",
        "A0:19:17": "Bertel S.p.a.",
        "68:B8:D9": "Act KDE, Inc.",
        "90:CC:24": "Synaptics, Inc",
        "2C:E8:71": "Alert Metalguard ApS",
        "F8:7B:62": "FASTWEL INTERNATIONAL CO., LTD. Taiwan Branch",
        "40:27:0B": "Mobileeco Co., Ltd",
        "74:FE:48": "ADVANTECH CO., LTD.",
        "80:B9:5C": "ELFTECH Co., Ltd.",
        "38:B5:BD": "E.G.O. Elektro-Ger",
        "20:91:8A": "PROFALUX",
        "E4:EE:FD": "MR&D Manufacturing",
        "10:5C:BF": "DuroByte Inc",
        "A4:6E:79": "DFT System Co.Ltd",
        "C8:8A:83": "Dongguan HuaHong Electronics Co.,Ltd",
        "8C:C5:E1": "ShenZhen Konka Telecommunication Technology Co.,Ltd",
        "64:A3:41": "Wonderlan (Beijing) Technology Co., Ltd.",
        "78:98:FD": "Q9 Networks Inc.",
        "D0:63:B4": "SolidRun Ltd.",
        "9C:54:1C": "Shenzhen My-power Technology Co.,Ltd",
        "8C:33:30": "EmFirst Co., Ltd.",
        "08:7B:AA": "SVYAZKOMPLEKTSERVICE, LLC",
        "24:F2:DD": "Radiant Zemax LLC",
        "20:B5:C6": "Mimosa Networks",
        "E4:E4:09": "LEIFHEIT AG",
        "B8:77:C3": "METER Group",
        "00:4D:32": "Andon Health Co.,Ltd.",
        "FC:A9:B0": "MIARTECH (SHANGHAI),INC.",
        "94:DE:80": "GIGA-BYTE TECHNOLOGY CO.,LTD.",
        "2C:44:1B": "Spectrum Medical Limited",
        "EC:49:93": "Qihan Technology Co., Ltd ",
        "B0:AC:FA": "FUJITSU LIMITED",
        "8C:E0:81": "zte corporation",
        "A4:4E:2D": "Adaptive Wireless Solutions, LLC",
        "0C:CD:FB": "EDIC Systems Inc.",
        "9C:8D:1A": "INTEG process group inc",
        "48:03:62": "DESAY ELECTRONICS(HUIZHOU)CO.,LTD",
        "18:67:3F": "Hanover Displays Limited",
        "7C:0A:50": "J-MEX Inc.",
        "50:11:EB": "SilverNet Ltd",
        "54:DF:63": "Intrakey technologies GmbH",
        "40:F2:E9": "IBM",
        "74:4D:79": "Arrive Systems Inc.",
        "9C:04:73": "Tecmobile (International) Ltd. ",
        "B4:DF:FA": "Litemax Electronics Inc.",
        "68:1C:A2": "Rosewill Inc.",
        "60:46:16": "XIAMEN VANN INTELLIGENT CO., LTD",
        "E4:56:14": "Suttle Apparatus",
        "3C:83:B5": "Advance Vision Electronics Co. Ltd.",
        "28:A1:92": "GERP Solution",
        "10:6F:EF": "Ad-Sol Nissin Corp",
        "6C:40:C6": "Nimbus Data, Inc.",
        "10:48:B1": "Beijing Duokan Technology Limited",
        "D4:93:A0": "Fidelix Oy",
        "08:EB:ED": "World Elite Technology Co.,LTD",
        "DC:9F:A4": "Nokia Corporation",
        "44:C3:9B": "OOO RUBEZH NPO",
        "C4:45:67": "SAMBON PRECISON and ELECTRONICS",
        "48:F8:B3": "Cisco-Linksys, LLC",
        "D8:D2:7C": "JEMA ENERGY, SA",
        "B0:12:03": "Dynamics Hong Kong Limited",
        "98:86:B1": "Flyaudio corporation (China)",
        "70:93:F8": "Space Monkey, Inc.",
        "28:B3:AB": "Genmark Automation",
        "C4:E7:BE": "SCSpro Co.,Ltd",
        "58:87:4C": "LITE-ON CLEAN ENERGY TECHNOLOGY CORP.",
        "28:91:D0": "Stage Tec Entwicklungsgesellschaft für professionelle Audiotechnik mbH",
        "C0:BD:42": "ZPA Smart Energy a.s.",
        "FC:52:CE": "Control iD",
        "5C:4A:26": "Enguity Technology Corp",
        "60:F2:EF": "VisionVera International Co., Ltd.",
        "C0:3F:2A": "Biscotti, Inc.",
        "38:1C:4A": "SIMCom Wireless Solutions Co.,Ltd.",
        "D8:C6:91": "Hichan Technology Corp.",
        "E4:3F:A2": "Wuxi DSP Technologies Inc.",
        "F4:B7:2A": "TIME INTERCONNECT LTD",
        "74:99:75": "IBM Corporation",
        "2C:62:5A": "Finest Security Systems Co., Ltd",
        "20:74:CF": "Shenzhen Voxtech Co.,Ltd",
        "E0:F5:CA": "CHENG UEI PRECISION INDUSTRY CO.,LTD.",
        "A8:EF:26": "Tritonwave",
        "20:DC:93": "Cheetah Hi-Tech, Inc.",
        "44:23:AA": "Farmage Co., Ltd.",
        "7C:FE:28": "Salutron Inc.",
        "E8:10:2E": "Really Simple Software, Inc",
        "0C:56:5C": "HyBroad Vision (Hong Kong) Technology Co Ltd",
        "8C:6A:E4": "Viogem Limited",
        "54:39:68": "Edgewater Networks Inc",
        "44:0C:FD": "NetMan Co., Ltd.",
        "8C:D3:A2": "VisSim AS",
        "D8:2D:E1": "Tricascade Inc.",
        "14:35:8B": "Mediabridge Products, LLC.",
        "00:F4:03": "Orbis Systems Oy",
        "54:73:98": "Toyo Electronics Corporation",
        "E0:A3:0F": "Pevco",
        "20:44:3A": "Schneider Electric Asia Pacific Ltd",
        "C4:39:3A": "SMC Networks Inc",
        "5C:24:79": "Baltech AG",
        "EC:93:27": "MEMMERT GmbH + Co. KG",
        "A0:EF:84": "Seine Image Int'l Co., Ltd",
        "64:51:7E": "LONG BEN (DONGGUAN) ELECTRONIC TECHNOLOGY CO.,LTD.",
        "D4:3D:7E": "Micro-Star Int'l Co, Ltd",
        "AC:D9:D6": "tci GmbH",
        "48:28:2F": "zte corporation",
        "60:CB:FB": "AirScape Inc.",
        "7C:16:0D": "Saia-Burgess Controls AG",
        "A4:97:BB": "Hitachi Industrial Equipment Systems Co.,Ltd",
        "4C:54:27": "Linepro Sp. z o.o.",
        "80:D1:8B": "Hangzhou I'converge Technology Co.,Ltd",
        "40:88:E0": "Beijing Ereneben Information Technology Limited Shenzhen Branch",
        "E8:54:84": "NEO Information Systems Co., Ltd.",
        "74:AE:76": "iNovo Broadband, Inc.",
        "EC:1A:59": "Belkin International Inc.",
        "88:10:36": "Panodic(ShenZhen) Electronics Limted",
        "68:B6:FC": "Hitron Technologies. Inc",
        "EC:A2:9B": "Kemppi Oy",
        "04:CE:14": "Wilocity LTD.",
        "C4:BA:99": "I+ME Actia Informatik und Mikro-Elektronik GmbH",
        "A4:93:4C": "Cisco Systems, Inc",
        "D0:D2:12": "K2NET Co.,Ltd.",
        "B0:43:5D": "NuLEDs, Inc.",
        "08:08:EA": "AMSC",
        "E8:D4:83": "ULTIMATE Europe Transportation Equipment GmbH",
        "1C:84:64": "FORMOSA WIRELESS COMMUNICATION CORP.",
        "34:6E:8A": "Ecosense",
        "64:F2:42": "Gerdes Aktiengesellschaft",
        "60:F2:81": "TRANWO TECHNOLOGY CO., LTD.",
        "94:21:97": "Stalmart Technology Limited",
        "A0:C3:DE": "Triton Electronic Systems Ltd.",
        "D0:69:9E": "LUMINEX Lighting Control Equipment",
        "0C:C0:C0": "MAGNETI MARELLI SISTEMAS ELECTRONICOS MEXICO",
        "08:37:9C": "Topaz Co. LTD.",
        "D8:0D:E3": "FXI TECHNOLOGIES AS",
        "B0:D2:F5": "Vello Systems, Inc.",
        "70:9A:0B": "Italian Institute of Technology",
        "F0:FD:A0": "Acurix Networks Pty Ltd",
        "B4:55:70": "Borea",
        "10:0D:2F": "Online Security Pty. Ltd.",
        "14:2D:F5": "Amphitech",
        "50:57:A8": "Cisco Systems, Inc",
        "00:DE:FB": "Cisco Systems, Inc",
        "3C:A3:15": "Bless Information & Communications Co., Ltd",
        "F8:30:94": "Alcatel-Lucent Telecom Limited",
        "10:A9:32": "Beijing Cyber Cloud Technology Co. ,Ltd.",
        "34:FC:6F": "ALCEA",
        "C0:B3:57": "Yoshiki Electronics Industry Ltd.",
        "3C:98:BF": "Quest Controls, Inc.",
        "D0:AE:EC": "Alpha Networks Inc.",
        "E8:13:24": "GuangZhou Bonsoninfo System CO.,LTD",
        "E4:77:D4": "Minrray Industry Co.,Ltd ",
        "38:E0:8E": "Mitsubishi Electric Corporation",
        "E4:C8:06": "Ceiec Electric Technology Inc.",
        "E0:F9:BE": "Cloudena Corp.",
        "B8:8F:14": "Analytica GmbH",
        "7C:94:B2": "Philips Healthcare PCCI",
        "44:2B:03": "Cisco Systems, Inc",
        "F4:73:CA": "Conversion Sound Inc.",
        "F8:F7:FF": "SYN-TECH SYSTEMS INC",
        "A8:17:58": "Elektronik System i Umeå AB",
        "88:20:12": "LMI Technologies",
        "60:E9:56": "Ayla Networks, Inc",
        "EC:11:20": "FloDesign Wind Turbine Corporation",
        "F8:97:CF": "DAESHIN-INFORMATION TECHNOLOGY CO., LTD.",
        "08:B4:CF": "Abicom International",
        "C4:95:A2": "SHENZHEN WEIJIU INDUSTRY AND TRADE DEVELOPMENT CO., LTD",
        "8C:68:78": "Nortek-AS",
        "20:25:98": "Teleview",
        "38:F8:B7": "V2COM PARTICIPACOES S.A.",
        "F8:D4:62": "Pumatronix Equipamentos Eletronicos Ltda.",
        "A0:DC:04": "Becker-Antriebe GmbH",
        "40:60:5A": "Hawkeye Tech Co. Ltd",
        "A0:4C:C1": "Helixtech Corp.",
        "34:A7:BA": "Fischer International Systems Corporation",
        "04:63:E0": "Nome Oy",
        "B4:9E:E6": "SHENZHEN TECHNOLOGY CO LTD",
        "BC:4B:79": "SensingTek",
        "A4:90:05": "CHINA GREATWALL COMPUTER SHENZHEN CO.,LTD",
        "C4:0A:CB": "Cisco Systems, Inc",
        "68:16:05": "Systems And Electronic Development FZCO",
        "D4:A0:2A": "Cisco Systems, Inc",
        "3C:4E:47": "Etronic A/S",
        "F4:87:71": "Infoblox",
        "54:53:ED": "Sony Corporation",
        "00:37:6D": "Murata Manufacturing Co., Ltd.",
        "50:00:8C": "Hong Kong Telecommunications (HKT) Limited",
        "90:2B:34": "GIGA-BYTE TECHNOLOGY CO.,LTD.",
        "88:C3:6E": "Beijing Ereneben lnformation Technology Limited",
        "4C:9E:80": "KYOKKO ELECTRIC Co., Ltd.",
        "5C:EB:4E": "R. STAHL HMI Systems GmbH",
        "34:AA:99": "Nokia",
        "64:55:63": "Intelight Inc.",
        "94:3A:F0": "Nokia Corporation",
        "64:54:22": "Equinox Payments",
        "08:0D:84": "GECO, Inc.",
        "88:E7:12": "Whirlpool Corporation",
        "D4:12:BB": "Quadrant Components Inc. Ltd",
        "24:B8:8C": "Crenus Co.,Ltd.",
        "BC:FE:8C": "Altronic, LLC",
        "64:9E:F3": "Cisco Systems, Inc",
        "24:BB:C1": "Absolute Analysis",
        "9C:CA:D9": "Nokia Corporation",
        "04:6D:42": "Bryston Ltd.",
        "D8:E7:43": "Wush, Inc",
        "64:4D:70": "dSPACE GmbH",
        "DC:C1:01": "SOLiD Technologies, Inc.",
        "3C:E6:24": "LG Display ",
        "D8:F0:F2": "Zeebo Inc",
        "80:60:07": "RIM",
        "38:A8:51": "Moog, Ing",
        "94:E0:D0": "HealthStream Taiwan Inc.",
        "D8:05:2E": "Skyviia Corporation",
        "80:94:6C": "TOKYO RADAR CORPORATION",
        "D0:CF:5E": "Energy Micro AS",
        "18:03:FA": "IBT Interfaces",
        "30:6E:5C": "Validus Technologies",
        "C8:94:D2": "Jiangsu Datang  Electronic Products Co., Ltd",
        "C8:A6:20": "Nebula, Inc",
        "EC:62:64": "Global411 Internet Services, LLC",
        "00:F0:51": "KWB Gmbh",
        "FC:94:6C": "UBIVELOX",
        "40:7B:1B": "Mettle Networks Inc.",
        "40:D5:59": "MICRO S.E.R.I.",
        "30:6C:BE": "Skymotion Technology (HK) Limited",
        "18:38:25": "Wuhan Lingjiu High-tech Co.,Ltd.",
        "7C:4B:78": "Red Sun Synthesis Pte Ltd",
        "64:A0:E7": "Cisco Systems, Inc",
        "DC:F8:58": "Lorent Networks, Inc.",
        "94:0B:2D": "NetView Technologies(Shenzhen) Co., Ltd",
        "80:3F:5D": "Winstars Technology Ltd",
        "40:BF:17": "Digistar Telecom. SA",
        "78:07:38": "Z.U.K. Elzab S.A.",
        "20:37:BC": "Kuipers Electronic Engineering BV",
        "94:31:9B": "Alphatronics BV",
        "00:E1:75": "AK-Systems Ltd",
        "CC:50:1C": "KVH Industries, Inc.",
        "04:D7:83": "Y&H E&C Co.,LTD.",
        "54:A9:D4": "Minibar Systems",
        "B0:E5:0E": "NRG SYSTEMS INC",
        "64:80:8B": "VG Controls, Inc.",
        "48:C1:AC": "PLANTRONICS, INC.",
        "98:58:8A": "SYSGRATION Ltd.",
        "24:37:EF": "EMC Electronic Media Communication SA",
        "28:B0:CC": "Xenya d.o.o.",
        "20:5B:5E": "Shenzhen Wonhe Technology Co., Ltd",
        "C0:58:A7": "Pico Systems Co., Ltd.",
        "EC:3F:05": "Institute 706, The Second Academy China Aerospace Science & Industry Corp",
        "48:9B:E2": "SCI Innovations Ltd",
        "80:FF:A8": "UNIDIS",
        "E4:35:FB": "Sabre Technology (Hull) Ltd",
        "C8:3B:45": "JRI",
        "E8:78:A1": "BEOVIEW INTERCOM DOO",
        "CC:EF:48": "Cisco Systems, Inc",
        "F0:4B:6A": "Scientific Production Association Siberian Arsenal, Ltd.",
        "64:AE:0C": "Cisco Systems, Inc",
        "E8:DA:96": "Zhuhai Tianrui Electrical Power Tech. Co., Ltd.",
        "B4:D8:DE": "iota Computing, Inc.",
        "C8:90:3E": "Pakton Technologies",
        "54:CD:A7": "Fujian Shenzhou Electronic Co.,Ltd",
        "88:6B:76": "CHINA HOPEFUL GROUP HOPEFUL ELECTRIC CO.,LTD",
        "78:F7:D0": "Silverbrook Research",
        "20:76:00": "Actiontec Electronics, Inc",
        "F0:13:C3": "SHENZHEN FENDA TECHNOLOGY CO., LTD",
        "04:A8:2A": "Nokia Corporation",
        "E4:4E:18": "Gardasoft VisionLimited",
        "20:46:A1": "VECOW Co., Ltd",
        "FC:01:CD": "FUNDACION TEKNIKER",
        "9C:8B:F1": "The Warehouse Limited",
        "DC:2E:6A": "HCT. Co., Ltd.",
        "14:8A:70": "ADS GmbH",
        "00:B3:38": "Kontron Asia Pacific Design Sdn. Bhd",
        "84:24:8D": "Zebra Technologies Inc",
        "FC:E8:92": "Hangzhou Lancable Technology Co.,Ltd",
        "10:71:F9": "Cloud Telecomputers, LLC",
        "B8:62:1F": "Cisco Systems, Inc",
        "F0:02:2B": "Chrontel",
        "D4:53:AF": "VIGO System S.A.",
        "18:AD:4D": "Polostar Technology Corporation",
        "94:C6:EB": "NOVA electronics, Inc.",
        "84:3F:4E": "Tri-Tech Manufacturing, Inc.",
        "C8:32:32": "Hunting Innova",
        "54:94:78": "Silvershore Technology Partners",
        "A0:6E:50": "Nanotek Elektronik Sistemler Ltd. Sti.",
        "4C:77:4F": "Embedded Wireless Labs ",
        "D0:C2:82": "Cisco Systems, Inc",
        "14:7D:B3": "JOA TELECOM.CO.,LTD",
        "EC:BD:09": "FUSION Electronics Ltd",
        "94:46:96": "BaudTec Corporation",
        "54:84:7B": "Digital Devices GmbH",
        "3C:27:63": "SLE quality engineering GmbH & Co. KG",
        "B0:F1:BC": "Dhemax Ingenieros Ltda",
        "B8:28:8B": "Parker Hannifin Manufacturing (UK) Ltd",
        "90:D1:1B": "Palomar Medical Technologies",
        "34:A5:5D": "TECHNOSOFT INTERNATIONAL SRL",
        "80:2E:14": "azeti Networks AG",
        "D4:C1:FC": "Nokia Corporation",
        "34:BC:A6": "Beijing Ding Qing Technology, Ltd.",
        "58:35:D9": "Cisco Systems, Inc",
        "64:D9:12": "Solidica, Inc.",
        "C4:7B:2F": "Beijing JoinHope Image Technology Ltd.",
        "50:8A:CB": "SHENZHEN MAXMADE TECHNOLOGY CO., LTD.",
        "3C:D1:6E": "Telepower Communication Co., Ltd",
        "FC:2E:2D": "Lorom Industrial Co.LTD.",
        "40:04:0C": "A&T",
        "DC:3C:84": "Ticom Geomatics, Inc.",
        "D0:13:1E": "Sunrex Technology Corp",
        "70:3A:D8": "Shenzhen Afoundry Electronic Co., Ltd",
        "70:4A:AE": "Xstream Flow (Pty) Ltd",
        "40:B3:FC": "Logital Co. Limited ",
        "A4:13:4E": "Luxul ",
        "B0:99:28": "FUJITSU LIMITED",
        "04:E1:C8": "IMS Soluções em Energia Ltda.",
        "94:8F:EE": "Verizon Telematics",
        "50:D6:D7": "Takahata Precision",
        "88:F0:77": "Cisco Systems, Inc",
        "58:75:21": "CJSC RTSoft",
        "C4:0F:09": "Hermes electronic GmbH",
        "48:F4:7D": "TechVision Holding  Internation Limited",
        "F0:81:AF": "IRZ AUTOMATION TECHNOLOGIES LTD",
        "70:14:04": "Limited Liability Company",
        "B4:35:F7": "Zhejiang Pearmain Electronics Co.ltd.",
        "98:66:EA": "Industrial Control Communications, Inc.",
        "98:30:00": "Beijing KEMACOM Technologies Co., Ltd.",
        "90:CF:15": "Nokia Corporation",
        "94:8B:03": "EAGET Innovation and Technology Co., Ltd.",
        "2C:00:33": "EControls, LLC",
        "AC:19:9F": "SUNGROW POWER SUPPLY CO.,LTD.",
        "7C:4A:82": "Portsmith LLC",
        "94:E8:48": "FYLDE MICRO LTD",
        "AC:5E:8C": "Utillink",
        "18:E2:88": "STT Condigi",
        "1C:35:F1": "NEW Lift Neue Elektronische Wege Steuerungsbau GmbH",
        "80:34:57": "OT Systems Limited",
        "5C:0C:BB": "CELIZION Inc.",
        "C4:24:2E": "Galvanic Applied Sciences Inc",
        "24:C8:6E": "Chaney Instrument Co.",
        "F0:AE:51": "Xi3 Corp",
        "B8:0B:9D": "ROPEX Industrie-Elektronik GmbH",
        "30:61:18": "Paradom Inc.",
        "4C:73:67": "Genius Bytes Software Solutions GmbH",
        "90:EA:60": "SPI Lasers Ltd ",
        "50:70:E5": "He Shan World Fair Electronics Technology Limited",
        "80:22:75": "Beijing Beny Wave Technology Co Ltd",
        "CC:F3:A5": "Chi Mei Communication Systems, Inc",
        "14:A9:E3": "MST CORPORATION",
        "F8:EA:0A": "Dipl.-Math. Michael Rauch",
        "38:31:AC": "WEG",
        "58:4C:19": "Chongqing Guohong Technology Development Company Limited",
        "64:69:BC": "Hytera Communications Co .,ltd",
        "B4:F3:23": "PETATEL INC.",
        "28:51:32": "Shenzhen Prayfly Technology Co.,Ltd",
        "E4:2F:F6": "Unicore communication Inc.",
        "84:D9:C8": "Unipattern Co.,",
        "94:AA:B8": "Joview(Beijing) Technology Co. Ltd.",
        "28:F3:58": "2C - Trifonov & Co",
        "14:C2:1D": "Sabtech Industries",
        "C8:84:39": "Sunrise Technologies",
        "F0:BF:97": "Sony Corporation",
        "C4:4A:D0": "FIREFLIES SYSTEMS",
        "EC:7D:9D": "CPI",
        "C8:1E:8E": "ADV Security (S) Pte Ltd",
        "A8:87:92": "Broadband Antenna Tracking Systems",
        "14:F0:C5": "Xtremio Ltd.",
        "E8:C2:29": "H-Displays (MSC) Bhd",
        "3C:A7:2B": "MRV Communications (Networks) LTD",
        "04:E6:62": "Acroname Inc.",
        "F8:7B:8C": "Amped Wireless",
        "28:34:10": "Enigma Diagnostics Limited",
        "0C:E8:2F": "Bonfiglioli Vectron GmbH",
        "40:F4:EC": "Cisco Systems, Inc",
        "14:B7:3D": "ARCHEAN Technologies",
        "94:8D:50": "Beamex Oy Ab",
        "A4:33:D1": "Fibrlink Communications Co.,Ltd.",
        "5C:BD:9E": "HONGKONG MIRACLE EAGLE TECHNOLOGY(GROUP) LIMITED",
        "08:E6:72": "JEBSEE ELECTRONICS CO.,LTD.",
        "B8:E5:89": "Payter BV",
        "88:E0:A0": "Shenzhen VisionSTOR Technologies Co., Ltd",
        "FC:10:BD": "Control Sistematizado S.A.",
        "F0:C2:7C": "Mianyang Netop Telecom Equipment Co.,Ltd.",
        "24:1A:8C": "Squarehead Technology AS",
        "D4:4F:80": "Kemper Digital GmbH",
        "A4:1B:C0": "Fastec Imaging Corporation",
        "20:5B:2A": "Private",
        "F4:03:21": "BeNeXt B.V.",
        "A0:71:A9": "Nokia Corporation",
        "A4:E3:2E": "Silicon & Software Systems Ltd.",
        "C8:C1:26": "ZPM Industria e Comercio Ltda",
        "64:DE:1C": "Kingnetic Pte Ltd",
        "A8:62:A2": "JIWUMEDIA CO., LTD.",
        "98:4E:97": "Starlight Marketing (H. K.) Ltd.",
        "64:DC:01": "Static Systems Group PLC",
        "FC:1F:C0": "EURECAM",
        "BC:67:84": "Environics Oy",
        "68:DC:E8": "PacketStorm Communications",
        "48:8E:42": "DIGALOG GmbH",
        "60:76:88": "Velodyne",
        "78:CD:8E": "SMC Networks Inc",
        "2C:80:65": "HARTING Inc. of North America",
        "3C:C0:C6": "d&b audiotechnik GmbH",
        "44:68:AB": "JUIN COMPANY, LIMITED",
        "F8:10:37": "Atopia Systems, LP",
        "78:A6:83": "Precidata",
        "F0:25:72": "Cisco Systems, Inc",
        "04:FF:51": "NOVAMEDIA INNOVISION SP. Z O.O.",
        "4C:B4:EA": "HRD (S) PTE., LTD.",
        "D4:4C:24": "Vuppalamritha Magnetic Components LTD",
        "F8:C6:78": "Carefusion",
        "6C:AB:4D": "Digital Payment Technologies",
        "2C:B0:DF": "Soliton Technologies Pvt Ltd",
        "EC:E5:55": "Hirschmann Automation",
        "58:F9:8E": "SECUDOS GmbH",
        "B4:C4:4E": "VXL eTech Pvt Ltd",
        "70:7E:DE": "NASTEC LTD.",
        "C0:7E:40": "SHENZHEN XDK COMMUNICATION EQUIPMENT CO.,LTD",
        "E4:4F:29": "MA Lighting Technology GmbH",
        "B4:74:9F": "ASKEY COMPUTER CORP",
        "7C:4A:A8": "MindTree Wireless PVT Ltd",
        "80:91:C0": "AgileMesh, Inc.",
        "E0:5F:B9": "Cisco Systems, Inc",
        "E0:14:3E": "Modoosis Inc.",
        "90:D8:52": "Comtec Co., Ltd.",
        "38:01:97": "TSST Global,Inc",
        "AC:02:CF": "RW Tecnologia Industria e Comercio Ltda",
        "D4:12:96": "Anobit Technologies Ltd.",
        "48:17:4C": "MicroPower technologies",
        "34:9A:0D": "ZBD Displays Ltd",
        "90:50:7B": "Advanced PANMOBIL Systems GmbH & Co. KG",
        "08:76:FF": "Thomson Telecom Belgium",
        "1C:7C:11": "EID ",
        "20:AA:25": "IP-NET LLC",
        "C4:EE:F5": "II-VI Incorporated",
        "E0:CF:2D": "Gemintek Corporation",
        "D4:91:AF": "Electroacustica General Iberica, S.A.",
        "C4:B5:12": "General Electric Digital Energy",
        "00:34:F1": "Radicom Research, Inc.",
        "94:33:DD": "Taco Inc",
        "E0:25:38": "Titan Pet Products",
        "CC:7A:30": "CMAX Wireless Co., Ltd.",
        "B8:8E:3A": "Infinite Technologies JLT",
        "58:8D:09": "Cisco Systems, Inc",
        "C0:C1:C0": "Cisco-Linksys, LLC",
        "60:15:C7": "IdaTech",
        "DC:20:08": "ASD Electronics Ltd ",
        "1C:83:B0": "Linked IP GmbH",
        "A4:D1:D1": "ECOtality North America",
        "C4:93:13": "100fio networks technology llc",
        "7C:39:20": "SSOMA SECURITY",
        "28:C0:DA": "Juniper Networks",
        "9C:77:AA": "NADASNV",
        "10:E8:EE": "PhaseSpace",
        "A4:7C:1F": "Cobham plc",
        "D4:6C:DA": "CSM GmbH",
        "5C:D9:98": "D-Link Corporation",
        "68:59:7F": "Alcatel Lucent",
        "F0:65:DD": "Primax Electronics Ltd.",
        "70:65:82": "Suzhou Hanming Technologies Co., Ltd.",
        "34:D2:C4": "RENA GmbH Print Systeme",
        "D4:CB:AF": "Nokia Corporation",
        "04:5D:56": "camtron industrial inc.",
        "68:23:4B": "Nihon Dengyo Kousaku",
        "1C:3D:E7": "Sigma Koki Co.,Ltd.",
        "58:BC:27": "Cisco Systems, Inc",
        "20:D6:07": "Nokia Corporation",
        "6C:E0:B0": "SOUND4",
        "9C:FF:BE": "OTSL Inc.",
        "00:F8:60": "PT. Panggung Electric Citrabuana",
        "B8:BA:72": "Cynove",
        "44:3D:21": "Nuvolt",
        "30:49:3B": "Nanjing Z-Com Wireless Co.,Ltd",
        "A4:5C:27": "Nintendo Co., Ltd.",
        "6C:04:60": "RBH Access Technologies Inc.",
        "70:64:17": "ORBIS TECNOLOGIA ELECTRICA S.A.",
        "18:EF:63": "Cisco Systems, Inc",
        "20:6F:EC": "Braemac CA LLC",
        "10:0D:32": "Embedian, Inc.",
        "88:AC:C1": "Generiton Co., Ltd. ",
        "88:18:AE": "Tamron Co., Ltd",
        "7C:ED:8D": "Microsoft",
        "A4:BE:61": "EutroVision System, Inc.",
        "D0:7D:E5": "Forward Pay Systems, Inc.",
        "04:DD:4C": "Velocytech",
        "A4:0C:C3": "Cisco Systems, Inc",
        "4C:BA:A3": "Bison Electronics Inc.",
        "A8:B1:D4": "Cisco Systems, Inc",
        "EC:7C:74": "Justone Technologies Co., Ltd.",
        "CC:FC:B1": "Wireless Technology, Inc.",
        "3C:1A:79": "Huayuan Technology CO.,LTD",
        "7C:F0:98": "Bee Beans Technologies, Inc.",
        "EC:66:D1": "B&W Group LTD",
        "38:5F:C3": "Yu Jeong System, Co.Ltd",
        "88:8B:5D": "Storage Appliance Corporation ",
        "84:A9:91": "Cyber Trans Japan Co.,Ltd.",
        "68:78:4C": "Nortel Networks",
        "F8:D7:56": "Simm Tronic Limited ",
        "04:A3:F3": "Emicon",
        "1C:17:D3": "Cisco Systems, Inc",
        "7C:E0:44": "NEON Inc",
        "28:4C:53": "Intune Networks",
        "90:51:3F": "Elettronica Santerno SpA",
        "88:41:C1": "ORBISAT DA AMAZONIA IND E AEROL SA",
        "9C:75:14": "Wildix srl",
        "4C:F7:37": "SamJi Electronics Co., Ltd",
        "F0:D7:67": "Axema Passagekontroll AB",
        "C8:4C:75": "Cisco Systems, Inc",
        "C8:02:A6": "Beijing Newmine Technology",
        "4C:8B:55": "Grupo Digicon",
        "6C:5C:DE": "SunReports, Inc.",
        "34:F3:9B": "WizLAN Ltd.",
        "E8:6C:DA": "Supercomputers and Neurocomputers Research Center",
        "24:0B:2A": "Viettel Group",
        "00:B5:D6": "Omnibit Inc.",
        "54:89:22": "Zelfy Inc",
        "50:C5:8D": "Juniper Networks",
        "24:A4:2C": "KOUKAAM a.s.",
        "4C:30:89": "Thales Transportation Systems GmbH",
        "48:12:49": "Luxcom Technologies Inc.",
        "24:A9:37": "PURE Storage",
        "34:83:02": "iFORCOM Co., Ltd",
        "B4:3D:B2": "Degreane Horizon",
        "84:F6:4C": "Cross Point BV",
        "C0:8B:6F": "S I Sistemas Inteligentes Eletrônicos Ltda",
        "F8:6E:CF": "Arcx Inc",
        "8C:84:01": "Private",
        "40:84:93": "Clavister AB",
        "78:A6:BD": "DAEYEON Control&Instrument Co,.Ltd",
        "3C:19:15": "GFI Chrono Time",
        "EC:B1:06": "Acuro Networks, Inc",
        "C8:35:B8": "Ericsson, EAB/RWI/K",
        "F8:9D:0D": "Control Technology Inc.",
        "2C:3F:3E": "Alge-Timing GmbH",
        "08:9F:97": "LEROY AUTOMATION",
        "34:BA:51": "Se-Kure Controls, Inc.",
        "6C:70:39": "Novar GmbH",
        "98:2D:56": "Resolution Audio",
        "14:73:73": "TUBITAK UEKAE",
        "FC:CF:62": "IBM Corp",
        "08:4E:1C": "H2A Systems, LLC",
        "88:B6:27": "Gembird Europe BV",
        "F0:68:53": "Integrated Corporation",
        "A4:AD:B8": "Vitec Group, Camera Dynamics Ltd",
        "A4:B1:21": "Arantia 2010 S.L.",
        "E0:26:36": "Nortel Networks",
        "5C:57:C8": "Nokia Corporation",
        "D4:6C:BF": "Goodrich ISR",
        "E0:26:30": "Intrigue Technologies, Inc.",
        "EC:C8:82": "Cisco Systems, Inc",
        "6C:FD:B9": "Proware Technologies Co Ltd.",
        "10:18:9E": "Elmo Motion Control",
        "8C:56:C5": "Nintendo Co., Ltd.",
        "CC:B8:88": "AnB Securite s.a.",
        "6C:5E:7A": "Ubiquitous Internet Telecom Co., Ltd",
        "B4:2C:BE": "Direct Payment Solutions Limited",
        "CC:22:18": "InnoDigital Co., Ltd.",
        "C8:6C:1E": "Display Systems Ltd",
        "A0:18:59": "Shenzhen Yidashi Electronics Co Ltd",
        "E8:05:6D": "Nortel Networks",
        "C4:59:76": "Fugoo Coorporation",
        "90:A7:C1": "Pakedge Device and Software Inc.",
        "80:BA:AC": "TeleAdapt Ltd",
        "50:2D:F4": "Phytec Messtechnik GmbH",
        "2C:CD:27": "Precor Inc",
        "10:43:69": "Soundmax Electronic Limited ",
        "C0:6C:0F": "Dobbs Stanford",
        "C8:6C:B6": "Optcom Co., Ltd.",
        "58:49:BA": "Chitai Electronic Corp.",
        "00:D1:1C": "ACETEL",
        "60:1D:0F": "Midnite Solar",
        "A8:F9:4B": "Eltex Enterprise Ltd.",
        "0C:82:30": "SHENZHEN MAGNUS TECHNOLOGIES CO.,LTD",
        "74:6B:82": "MOVEK ",
        "9C:C0:77": "PrintCounts, LLC",
        "3C:B1:7F": "Wattwatchers Pty Ld",
        "CC:54:59": "OnTime Networks AS",
        "F8:DC:7A": "Variscite LTD",
        "D4:F1:43": "IPROAD.,Inc",
        "B8:F7:32": "Aryaka Networks Inc",
        "E8:DF:F2": "PRF Co., Ltd.",
        "B4:ED:54": "Wohler Technologies",
        "00:64:40": "Cisco Systems, Inc",
        "94:C4:E9": "PowerLayer Microsystems HongKong Limited",
        "88:43:E1": "Cisco Systems, Inc",
        "34:86:2A": "Heinz Lackmann GmbH & Co KG",
        "AC:E3:48": "MadgeTech, Inc",
        "54:9A:16": "Uzushio Electric Co.,Ltd.",
        "90:18:AE": "Shanghai Meridian Technologies, Co. Ltd.",
        "04:94:A1": "CATCH THE WIND INC",
        "00:3A:99": "Cisco Systems, Inc",
        "00:3A:9A": "Cisco Systems, Inc",
        "00:3A:98": "Cisco Systems, Inc",
        "50:A6:E3": "David Clark Company",
        "50:93:4F": "Gradual Tecnologia Ltda.",
        "B8:B1:C7": "BT&COM CO.,LTD",
        "DC:2C:26": "Iton Technology Limited",
        "D4:11:D6": "ShotSpotter, Inc.",
        "9C:AF:CA": "Cisco Systems, Inc",
        "1C:0F:CF": "Sypro Optics GmbH",
        "9C:4E:8E": "ALT Systems Ltd",
        "70:72:CF": "EdgeCore Networks",
        "EC:D0:0E": "MiraeRecognition Co., Ltd.",
        "A4:AD:00": "Ragsdale Technology",
        "4C:9E:E4": "Hanyang Navicom Co.,Ltd.",
        "C8:72:48": "Aplicom Oy",
        "C4:7D:4F": "Cisco Systems, Inc",
        "3C:DF:1E": "Cisco Systems, Inc",
        "98:6D:C8": "TOSHIBA MITSUBISHI-ELECTRIC INDUSTRIAL SYSTEMS CORPORATION",
        "6C:AC:60": "Venetex Corp",
        "F0:4B:F2": "JTECH Communications, Inc.",
        "04:2B:BB": "PicoCELA, Inc.",
        "FC:08:77": "Prentke Romich Company",
        "64:F9:70": "Kenade Electronics Technology Co.,LTD.",
        "C8:2E:94": "Halfa Enterprise Co., Ltd.",
        "80:17:7D": "Nortel Networks",
        "7C:7B:E4": "Z'SEDAI KENKYUSHO CORPORATION",
        "F0:DE:71": "Shanghai EDO Technologies Co.,Ltd.",
        "60:D3:0A": "Quatius Limited",
        "24:CF:21": "Shenzhen State Micro Technology Co., Ltd",
        "10:BA:A5": "GANA I&C CO., LTD",
        "BC:9D:A5": "DASCOM Europe GmbH",
        "28:FB:D3": "Ragentek Technology Group",
        "58:6E:D6": "Private",
        "EC:30:91": "Cisco Systems, Inc",
        "64:BC:11": "CombiQ AB",
        "C8:C1:3C": "RuggedTek Hangzhou Co., Ltd",
        "F4:AC:C1": "Cisco Systems, Inc",
        "40:97:D1": "BK Electronics cc",
        "0C:E9:36": "ELIMOS srl",
        "A0:2E:F3": "United Integrated Services Co., Led.",
        "A0:98:05": "OpenVox Communication Co Ltd",
        "60:39:1F": "ABB Ltd",
        "E8:A4:C1": "Deep Sea Electronics Ltd",
        "C8:D2:C1": "Jetlun (Shenzhen) Corporation",
        "E0:91:53": "XAVi Technologies Corp.",
        "88:A5:BD": "QPCOM INC.",
        "D4:C7:66": "Acentic GmbH",
        "00:27:12": "MaxVision LLC",
        "00:27:1F": "MIPRO Electronics Co., Ltd",
        "00:27:0C": "Cisco Systems, Inc",
        "00:26:CF": "DEKA R&D",
        "00:26:E7": "Shanghai ONLAN Communication Tech. Co., Ltd.",
        "00:26:E0": "ASITEQ",
        "00:27:03": "Testech Electronics Pte Ltd",
        "00:26:F3": "SMC Networks",
        "00:26:A5": "MICROROBOT.CO.,LTD",
        "00:26:A3": "FQ Ingenieria Electronica S.A.",
        "00:26:9D": "M2Mnet Co., Ltd.",
        "00:26:97": "Alpha  Technologies Inc.",
        "00:26:8A": "Terrier SC Ltd",
        "00:26:89": "General Dynamics Robotic Systems",
        "00:26:C5": "Guangdong Gosun Telecommunications Co.,Ltd",
        "00:26:C4": "Cadmos microsystems S.r.l.",
        "00:26:C8": "System Sensor",
        "00:26:7A": "wuhan hongxin telecommunication technologies co.,ltd",
        "00:26:C2": "SCDI Co. LTD",
        "00:26:85": "Digital Innovation",
        "00:26:A9": "Strong Technologies Pty Ltd",
        "00:26:72": "AAMP of America",
        "00:25:FD": "OBR Centrum Techniki Morskiej S.A.",
        "00:26:00": "TEAC Australia Pty Ltd.",
        "00:25:FF": "CreNova Multimedia Co., Ltd",
        "00:26:59": "Nintendo Co., Ltd.",
        "00:26:51": "Cisco Systems, Inc",
        "00:26:12": "Space Exploration Technologies",
        "00:26:16": "Rosemount Inc.",
        "00:26:0B": "Cisco Systems, Inc",
        "00:26:23": "JRD Communication Inc",
        "00:26:27": "Truesell",
        "00:26:4F": "Krüger &Gothe GmbH",
        "00:26:21": "InteliCloud Technology Inc.",
        "00:26:1C": "NEOVIA INC.",
        "00:26:64": "Core System Japan",
        "00:26:39": "T.M. Electronics, Inc.",
        "00:25:C6": "kasercorp, ltd",
        "00:25:C5": "Star Link Communication Pvt. Ltd.",
        "00:25:C7": "altek Corporation",
        "00:25:E6": "Belgian Monitoring Systems bvba",
        "00:25:E0": "CeedTec Sdn Bhd",
        "00:25:DE": "Probits Co., LTD.",
        "00:25:B0": "Schmartz Inc",
        "00:25:AD": "Manufacturing Resources International",
        "00:25:AC": "I-Tech corporation",
        "00:25:AB": "AIO LCD PC BU / TPV",
        "00:25:EC": "Humanware",
        "00:25:ED": "NuVo Technologies LLC",
        "00:25:E9": "i-mate Development, Inc.",
        "00:25:BA": "Alcatel-Lucent IPD",
        "00:25:BB": "INNERINT Co., Ltd.",
        "00:25:B8": "Agile Communications, Inc.",
        "00:25:B1": "Maya-Creation Corporation",
        "00:25:A1": "Enalasys",
        "00:25:F3": "Nordwestdeutsche Zählerrevision",
        "00:25:DD": "SUNNYTEK INFORMATION CO., LTD.",
        "00:25:CE": "InnerSpace",
        "00:25:49": "Jeorich Tech. Co.,Ltd.",
        "00:25:39": "IfTA GmbH",
        "00:25:37": "Runcom Technologies Ltd.",
        "00:25:38": "Samsung Electronics Co., Ltd., Memory Division",
        "00:25:44": "LoJack Corporation",
        "00:25:32": "Digital Recorders",
        "00:25:5D": "Morningstar Corporation",
        "00:25:58": "MPEDIA",
        "00:25:4A": "RingCube Technologies, Inc.",
        "00:25:4F": "ELETTROLAB Srl",
        "00:25:83": "Cisco Systems, Inc",
        "00:25:91": "NEXTEK, Inc.",
        "00:25:8D": "Haier",
        "00:25:71": "Zhejiang Tianle Digital Electric Co.,Ltd",
        "00:25:9A": "CEStronics GmbH",
        "00:25:02": "NaturalPoint",
        "00:24:F8": "Technical Solutions Company Ltd.",
        "00:24:F9": "Cisco Systems, Inc",
        "00:24:F2": "Uniphone Telecommunication Co., Ltd.",
        "00:25:14": "PC Worth Int'l Co., Ltd.",
        "00:25:0B": "CENTROFACTOR  INC",
        "00:25:06": "A.I. ANTITACCHEGGIO ITALIA SRL",
        "00:25:1C": "EDT",
        "00:25:1A": "Psiber Data Systems Inc.",
        "00:24:E1": "Convey Computer Corp.",
        "00:24:EE": "Wynmax Inc.",
        "00:24:E3": "CAO Group",
        "00:25:07": "ASTAK Inc.",
        "00:24:D9": "BICOM, Inc.",
        "00:24:8E": "Infoware ZRt.",
        "00:24:94": "Shenzhen Baoxin Tech CO., Ltd.",
        "00:24:89": "Vodafone Omnitel N.V.",
        "00:24:6F": "Onda Communication spa",
        "00:24:7F": "Nortel Networks",
        "00:24:75": "Compass System(Embedded Dept.)",
        "00:24:C3": "Cisco Systems, Inc",
        "00:24:B5": "Nortel Networks",
        "00:24:B0": "ESAB AB",
        "00:24:C4": "Cisco Systems, Inc",
        "00:24:9D": "NES Technology Inc.",
        "00:24:64": "Bridge Technologies Co AS",
        "00:24:62": "Rayzone Corporation",
        "00:24:20": "NetUP Inc.",
        "00:24:1E": "Nintendo Co., Ltd.",
        "00:24:1F": "DCT-Delta GmbH",
        "00:24:0E": "Inventec Besta Co., Ltd.",
        "00:24:60": "Giaval Science Development Co. Ltd.",
        "00:24:5C": "Design-Com Technologies Pty. Ltd.",
        "00:24:3D": "Emerson Appliance Motors and Controls",
        "00:24:37": "Motorola - BSG",
        "00:24:44": "Nintendo Co., Ltd.",
        "00:24:13": "Cisco Systems, Inc",
        "00:24:4F": "Asantron Technologies Ltd.",
        "00:23:DD": "ELGIN S.A.",
        "00:23:DE": "Ansync Inc.",
        "00:23:D9": "Banner Engineering",
        "00:23:DA": "Industrial Computer Source (Deutschland)GmbH",
        "00:24:05": "Dilog Nordic AB",
        "00:23:E8": "Demco Corp.",
        "00:23:E3": "Microtronic AG",
        "00:23:B7": "Q-Light Co., Ltd.",
        "00:23:FD": "AFT Atlas Fahrzeugtechnik GmbH",
        "00:23:EF": "Zuend Systemtechnik AG",
        "00:23:AC": "Cisco Systems, Inc",
        "00:23:D8": "Ball-It Oy",
        "00:23:9F": "Institut für Prüftechnik",
        "00:23:9D": "Mapower Electronics Co., Ltd",
        "00:23:9C": "Juniper Networks",
        "00:23:98": "Vutlan sro",
        "00:23:5B": "Gulfstream",
        "00:23:59": "Benchmark Electronics ( Thailand ) Public Company Limited",
        "00:23:57": "Pitronot Technologies and Engineering P.T.E. Ltd.",
        "00:23:55": "Kinco Automation(Shanghai) Ltd.",
        "00:23:73": "GridIron Systems, Inc.",
        "00:23:67": "UniControls a.s.",
        "00:23:68": "Zebra Technologies Inc",
        "00:23:6E": "Burster GmbH & Co KG",
        "00:23:66": "Beijing Siasun Electronic System Co.,Ltd.",
        "00:23:8F": "NIDEC COPAL CORPORATION",
        "00:23:80": "Nanoteq",
        "00:23:3D": "Laird Technologies",
        "00:23:3F": "Purechoice Inc",
        "00:23:1B": "Danaher Motion - Kollmorgen",
        "00:23:1E": "Cezzer Multimedia Technologies",
        "00:23:1F": "Guangda Electronic & Telecommunication Technology Development Co., Ltd.",
        "00:22:70": "ABK North America, LLC",
        "00:23:13": "Qool Technologies Ltd.",
        "00:23:10": "LNC Technology Co., Ltd.",
        "00:22:CD": "Ared Technology Co., Ltd.",
        "00:22:CC": "SciLog, Inc.",
        "00:22:CB": "IONODES Inc.",
        "00:22:C6": "Sutus Inc",
        "00:22:E8": "Applition Co., Ltd.",
        "00:22:E9": "ProVision Communications",
        "00:22:E6": "Intelligent Data",
        "00:22:E3": "Amerigon",
        "00:22:EB": "Data Respons A/S",
        "00:22:EF": "iWDL Technologies",
        "00:22:F2": "SunPower Corp",
        "00:22:E2": "WABTEC Transit Division",
        "00:23:01": "Witron Technology Limited",
        "00:22:F7": "Conceptronic",
        "00:23:0C": "CLOVER ELECTRONICS CO.,LTD.",
        "00:23:34": "Cisco Systems, Inc",
        "00:22:C8": "Applied Instruments B.V.",
        "00:22:C0": "Shenzhen Forcelink Electronic Co, Ltd",
        "00:22:A6": "Sony Computer Entertainment America",
        "00:22:A7": "Tyco Electronics AMP GmbH",
        "00:22:A1": "Huawei Symantec Technologies Co.,Ltd.",
        "00:22:9D": "PYUNG-HWA IND.CO.,LTD",
        "00:22:96": "LinoWave Corporation",
        "00:22:44": "Chengdu Linkon Communications Device Co., Ltd",
        "00:22:50": "Point Six Wireless, LLC",
        "00:22:6F": "3onedata Technology Co. Ltd.",
        "00:22:78": "Shenzhen  Tongfang Multimedia  Technology Co.,Ltd.",
        "00:22:7A": "Telecom Design",
        "00:22:60": "AFREEY Inc.",
        "00:21:EF": "Kapsys",
        "00:21:ED": "Telegesis",
        "00:21:EB": "ESP SYSTEMS, LLC",
        "00:22:37": "Shinhint Group",
        "00:22:2F": "Open Grid Computing, Inc.",
        "00:21:F6": "Oracle Corporation",
        "00:22:06": "Cyberdyne Inc.",
        "00:22:02": "Excito Elektronik i Skåne AB",
        "00:22:27": "uv-electronic GmbH",
        "00:22:1E": "Media Devices Co., Ltd.",
        "00:22:25": "Thales Avionics Ltd",
        "00:22:20": "Mitac Technology Corp",
        "00:22:0E": "Indigo Security Co., Ltd.",
        "00:22:07": "Inteno Broadband Technology AB",
        "00:22:3E": "IRTrans GmbH",
        "00:21:CE": "NTC-Metrotek",
        "00:21:CA": "ART System Co., Ltd.",
        "00:21:CB": "SMS TECNOLOGIA ELETRONICA LTDA",
        "00:21:C8": "LOHUIS Networks",
        "00:21:DB": "Santachi Video Technology (Shenzhen) Co., Ltd.",
        "00:21:BF": "Hitachi High-Tech Control Systems Corporation",
        "00:21:BC": "ZALA COMPUTER",
        "00:21:B4": "APRO MEDIA CO., LTD",
        "00:21:A8": "Telephonics Corporation",
        "00:21:A9": "Mobilink Telecom Co.,Ltd",
        "00:21:8D": "AP Router Ind. Eletronica LTDA",
        "00:21:90": "Goliath Solutions",
        "00:21:85": "MICRO-STAR INT'L CO.,LTD.",
        "00:21:9F": "SATEL OY",
        "00:21:96": "Telsey  S.p.A.",
        "00:21:82": "SandLinks Systems, Ltd.",
        "00:21:83": "ANDRITZ HYDRO GmbH",
        "00:21:DF": "Martin Christ GmbH",
        "00:21:D4": "Vollmer Werke GmbH",
        "00:21:D6": "LXI Consortium",
        "00:21:A6": "Videotec Spa",
        "00:21:59": "Juniper Networks",
        "00:21:55": "Cisco Systems, Inc",
        "00:21:57": "National Datacast, Inc.",
        "00:21:3B": "Berkshire Products, Inc",
        "00:21:37": "Bay Controls, LLC",
        "00:21:39": "Escherlogic Inc.",
        "00:21:2C": "SemIndia System Private Limited",
        "00:21:2B": "MSA Auer",
        "00:21:74": "AvaLAN Wireless",
        "00:21:79": "IOGEAR, Inc.",
        "00:21:68": "iVeia, LLC",
        "00:21:50": "EYEVIEW ELECTRONICS",
        "00:21:4D": "Guangzhou Skytone Transmission Technology Com. Ltd.",
        "00:21:2A": "Audiovox Corporation",
        "00:21:5E": "IBM Corp",
        "00:1F:F6": "PS Audio International",
        "00:21:10": "Clearbox Systems",
        "00:21:0C": "Cymtec Systems, Inc.",
        "00:21:0B": "GEMINI TRAZE RFID PVT. LTD.",
        "00:1F:DD": "GDI LLC",
        "00:1F:DA": "Nortel Networks",
        "00:21:04": "Gigaset Communications GmbH",
        "00:1F:FB": "Green Packet Bhd",
        "00:1F:E9": "Printrex, Inc.",
        "00:1F:F0": "Audio Partnership",
        "00:1F:EA": "Applied Media Technologies Corporation",
        "00:1F:D9": "RSD Communications Ltd",
        "00:1F:CE": "QTECH LLC",
        "00:1F:8B": "Cache IQ",
        "00:1F:85": "Apriva ISS, LLC",
        "00:1F:87": "Skydigital Inc.",
        "00:1F:88": "FMS Force Measuring Systems AG",
        "00:1F:86": "digEcor",
        "00:1F:A1": "Gtran Inc",
        "00:1F:9F": "Thomson Telecom Belgium",
        "00:1F:99": "SERONICS co.ltd",
        "00:1F:80": "Lucas Holding bv",
        "00:1B:58": "ACE CAD Enterprise Co., Ltd.",
        "00:1F:B0": "TimeIPS, Inc.",
        "00:1F:AE": "Blick South Africa (Pty) Ltd",
        "00:1F:79": "Lodam Electronics A/S",
        "00:1F:71": "xG Technology, Inc.",
        "00:1F:A5": "Blue-White Industries",
        "00:1F:9D": "Cisco Systems, Inc",
        "00:1F:96": "APROTECH CO.LTD",
        "00:1F:6C": "Cisco Systems, Inc",
        "00:1F:6F": "Fujian Sunnada Communication Co.,Ltd.",
        "00:1F:60": "COMPASS SYSTEMS CORP.",
        "00:1F:6A": "PacketFlux Technologies, Inc.",
        "00:1F:65": "KOREA ELECTRIC TERMINAL CO., LTD.",
        "00:1F:17": "IDX Company, Ltd.",
        "00:1F:1B": "RoyalTek Company Ltd.",
        "00:1F:5E": "Dyna Technology Co.,Ltd.",
        "00:1F:55": "Honeywell Security (China) Co., Ltd.",
        "00:1F:54": "Lorex Technology Inc.",
        "00:1F:2E": "Triangle Research Int'l Pte Ltd",
        "00:1F:4B": "Lineage Power",
        "00:1F:0D": "L3 Communications - Telemetry West",
        "00:1E:FC": "JSC MASSA-K",
        "00:1F:23": "Interacoustics",
        "00:1F:06": "Integrated Dispatch Solutions",
        "00:1E:BA": "High Density Devices AS",
        "00:1E:B8": "Aloys, Inc",
        "00:1E:B4": "UNIFAT TECHNOLOGY LTD.",
        "00:1E:DA": "Wesemann Elektrotechniek B.V.",
        "00:1E:D7": "H-Stream Wireless, Inc.",
        "00:1E:D5": "Tekon-Automatics",
        "00:1E:E8": "Mytek",
        "00:1E:EE": "ETL Systems Ltd",
        "00:1E:FA": "PROTEI Ltd.",
        "00:1E:FB": "Trio Motion Technology Ltd",
        "00:1E:F8": "Emfinity Inc.",
        "00:1E:CB": "RPC Energoautomatika Ltd",
        "00:1E:A8": "Datang Mobile Communications Equipment CO.,LTD",
        "00:1E:AB": "TeleWell Oy",
        "00:1E:9F": "Visioneering Systems, Inc.",
        "00:1E:6B": "Cisco SPVTG",
        "00:1E:61": "ITEC GmbH",
        "00:1E:3E": "KMW Inc.",
        "00:1E:38": "Bluecard Software Technology Co., Ltd.",
        "00:1E:47": "PT. Hariff Daya Tunggal Engineering",
        "00:1E:48": "Wi-Links",
        "00:1E:8A": "eCopy, Inc",
        "00:1E:9B": "San-Eisha, Ltd.",
        "00:1E:96": "Sepura Plc",
        "00:1E:59": "Silicon Turnkey Express, LLC",
        "00:1E:51": "Converter Industry Srl",
        "00:1E:71": "MIrcom Group of Companies",
        "00:1D:C4": "AIOI Systems Co., Ltd.",
        "00:1D:C0": "Enphase Energy",
        "00:1D:BD": "Versamed Inc.",
        "00:1D:F8": "Webpro Vision Technology Corporation",
        "00:1D:F9": "Cybiotronics (Far East) Limited",
        "00:1D:F7": "R. STAHL Schaltgeräte GmbH",
        "00:1E:05": "Xseed Technologies & Computing",
        "00:1E:07": "Winy Technology Co., Ltd.",
        "00:1E:0A": "Syba Tech Limited",
        "00:1E:03": "LiComm Co., Ltd.",
        "00:1E:1B": "Digital Stream Technology, Inc.",
        "00:1E:17": "STN BV",
        "00:1E:18": "Radio Activity srl",
        "00:1E:15": "Beech Hill Electronics",
        "00:1E:30": "Shireen Inc",
        "00:1E:2E": "SIRTI S.p.A.",
        "00:1D:DC": "HangZhou DeChangLong Tech&Info Co.,Ltd",
        "00:1D:EB": "DINEC International",
        "00:1D:9A": "GODEX INTERNATIONAL CO., LTD",
        "00:1D:97": "Alertus Technologies LLC",
        "00:1D:91": "Digitize, Inc",
        "00:1D:95": "Flash, Inc.",
        "00:1D:9D": "ARTJOY INTERNATIONAL LIMITED",
        "00:1D:9E": "AXION TECHNOLOGIES",
        "00:1D:70": "Cisco Systems, Inc",
        "00:1D:78": "Invengo Information Technology Co.,Ltd",
        "00:1D:6F": "Chainzone Technology Co., Ltd",
        "00:1D:7F": "Tekron International Ltd",
        "00:1D:79": "SIGNAMAX LLC",
        "00:1D:AE": "CHANG TSENG TECHNOLOGY CO., LTD",
        "00:1D:A6": "Media Numerics Limited",
        "00:1D:62": "InPhase Technologies",
        "00:1D:63": "Miele & Cie. KG",
        "00:1D:B7": "Tendril Networks, Inc.",
        "00:1D:8D": "Fluke Process Instruments GmbH",
        "00:1D:1F": "Siauliu Tauro Televizoriai, JSC",
        "00:1D:43": "Shenzhen G-link Digital Technology Co., Ltd.",
        "00:1D:3F": "Mitron Pty Ltd",
        "00:1D:39": "MOOHADIGITAL CO., LTD",
        "00:1D:37": "Thales-Panda Transportation System",
        "00:1D:13": "NextGTV",
        "00:1D:14": "SPERADTONE INFORMATION TECHNOLOGY LIMITED",
        "00:1D:10": "LightHaus Logic, Inc.",
        "00:1D:04": "Zipit Wireless, Inc.",
        "00:1C:F2": "Tenlon Technology Co.,Ltd.",
        "00:1D:30": "YX Wireless S.A.",
        "00:1C:B2": "BPT SPA",
        "00:1C:B5": "Neihua Network Technology Co.,LTD.(NHN)",
        "00:1C:B4": "Iridium Satellite LLC",
        "00:1C:B6": "Duzon CNT Co., Ltd.",
        "00:1C:C7": "Rembrandt Technologies, LLC d/b/a REMSTREAM",
        "00:1C:BB": "MusicianLink",
        "00:1C:8D": "Mesa Imaging",
        "00:1C:89": "Force Communications, Inc.",
        "00:1C:87": "Uriver Inc.",
        "00:1C:CD": "Alektrona Corporation",
        "00:1C:EC": "Mobilesoft (Aust.) Pty Ltd",
        "00:1C:E8": "Cummins Inc",
        "00:1C:D0": "Circleone Co.,Ltd.",
        "00:1C:9F": "Razorstream, LLC",
        "00:1C:7D": "Excelpoint Manufacturing Pte Ltd",
        "00:1C:5C": "Integrated Medical Systems, Inc.",
        "00:1C:52": "VISIONEE SRL",
        "00:1C:47": "Hangzhou Hollysys Automation Co., Ltd",
        "00:1C:16": "ThyssenKrupp Elevator",
        "00:1C:19": "secunet Security Networks AG",
        "00:1C:6C": "30805",
        "00:1C:61": "Galaxy  Microsystems LImited",
        "00:1C:3B": "AmRoad Technology Inc.",
        "00:1C:3F": "International Police Technologies, Inc.",
        "00:1C:28": "Sphairon Technologies GmbH ",
        "00:1C:1F": "Quest Retail Technology Pty Ltd",
        "00:1C:32": "Telian Corporation",
        "00:1C:2B": "Alertme.com Limited",
        "00:1C:77": "Prodys",
        "00:1C:6F": "Emfit Ltd",
        "00:1C:49": "Zoltan Technology Inc.",
        "00:1C:63": "TRUEN",
        "00:1B:DF": "Iskra Sistemi d.d.",
        "00:1B:D9": "Edgewater Wireless Systems Inc",
        "00:1B:C7": "StarVedia Technology Inc.",
        "00:1B:EC": "Netio Technologies Co., Ltd",
        "00:1C:09": "SAE Electronic Co.,Ltd.",
        "00:1C:0C": "TANITA Corporation",
        "00:1B:A6": "intotech inc.",
        "00:1B:A4": "S.A.E Afikim",
        "00:1B:B4": "Airvod Limited",
        "00:1B:B6": "Bird Electronic Corp.",
        "00:1B:E8": "Ultratronik GmbH",
        "00:1B:E1": "ViaLogy",
        "00:1B:93": "JC Decaux SA DNT",
        "00:1B:9B": "Hose-McCann Communications",
        "00:1B:9C": "SATEL sp. z o.o.",
        "00:1B:92": "l-acoustics",
        "00:1B:8E": "Hulu Sweden AB",
        "00:1B:45": "ABB AS, Division Automation Products",
        "00:1B:3F": "ProCurve Networking by HP",
        "00:1B:41": "General Infinity Co.,Ltd.",
        "00:1B:50": "Nizhny Novgorod Factory named after M.Frunze, FSUE (NZiF)",
        "00:1B:47": "Futarque A/S",
        "00:1B:6C": "LookX Digital Media BV",
        "00:1B:6B": "Swyx Solutions AG",
        "00:1B:69": "Equaline Corporation",
        "00:1B:76": "Ripcode, Inc.",
        "00:1B:70": "IRI Ubiteq, INC.",
        "00:1B:68": "Modnnet Co., Ltd",
        "00:1B:62": "JHT Optoelectronics Co.,Ltd.",
        "00:1B:8A": "2M Electronic A/S",
        "00:1B:80": "LORD Corporation",
        "00:1B:3E": "Curtis, Inc.",
        "00:1B:37": "Computec Oy",
        "00:1B:07": "Mendocino Software",
        "00:1B:08": "Danfoss Drives A/S",
        "00:1B:01": "Applied Radio Technologies",
        "00:1B:02": "ED Co.Ltd",
        "00:1A:FC": "ModusLink Corporation",
        "00:1B:10": "ShenZhen Kang Hui Technology Co.,ltd",
        "00:1B:0B": "Phidgets Inc.",
        "00:1B:0C": "Cisco Systems, Inc",
        "00:1A:E0": "Mythology Tech Express Inc.",
        "00:1A:E2": "Cisco Systems, Inc",
        "00:1A:D7": "Christie Digital Systems, Inc.",
        "00:1B:23": "SimpleComTools",
        "00:1A:F6": "Woven Systems, Inc.",
        "00:1A:F9": "AeroVIronment (AV Inc)",
        "00:1B:30": "Solitech Inc.",
        "00:1B:18": "Tsuken Electric Ind. Co.,Ltd",
        "00:1A:E7": "Aztek Networks, Inc.",
        "00:1A:95": "Hisense Mobile Communications Technoligy Co.,Ltd.",
        "00:1A:81": "Zelax",
        "00:1A:87": "Canhold International Limited",
        "00:1A:88": "Venergy,Co,Ltd",
        "00:1A:C1": "3Com Ltd",
        "00:1A:BB": "Fontal Technology Incorporation",
        "00:1A:BD": "Impatica Inc.",
        "00:1A:AE": "Savant Systems LLC",
        "00:1A:CD": "Tidel Engineering LP",
        "00:1A:C9": "SUZUKEN CO.,LTD",
        "00:1A:79": "TELECOMUNICATION TECHNOLOGIES LTD.",
        "00:1A:AA": "Analogic Corp.",
        "00:1A:8B": "CHUNIL ELECTRIC IND., CO.",
        "00:1A:8D": "AVECS Bergen GmbH",
        "00:1A:B4": "FFEI Ltd.",
        "00:1A:B5": "Home Network System",
        "00:1A:A4": "Future University-Hakodate",
        "00:1A:9F": "A-Link Ltd",
        "00:1A:74": "Procare International Co",
        "00:1A:BE": "COMPUTER HI-TECH INC.",
        "00:1A:19": "Computer Engineering Limited",
        "00:1A:18": "Advanced Simulation Technology inc.",
        "00:1A:58": "CCV Deutschland GmbH - Celectronic eHealth Div.",
        "00:1A:5E": "Thincom Technology Co.,Ltd",
        "00:1A:5C": "Euchner GmbH+Co. KG",
        "00:1A:5B": "NetCare Service Co., Ltd.",
        "00:1A:24": "Galaxy Telecom Technologies Ltd",
        "00:1A:20": "CMOTECH Co. Ltd.",
        "00:1A:4E": "NTI AG / LinMot",
        "00:1A:52": "Meshlinx Wireless Inc.",
        "00:1A:13": "Wanlida Group Co., LTD",
        "00:1A:43": "Logical Link Communications",
        "00:1A:47": "Agami Systems, Inc.",
        "00:1A:2D": "The Navvo Group",
        "00:1A:2F": "Cisco Systems, Inc",
        "00:19:A9": "Cisco Systems, Inc",
        "00:19:AE": "Hopling Technologies b.v.",
        "00:19:AF": "Rigol Technologies, Inc.",
        "00:19:DE": "MOBITEK",
        "00:19:E5": "Lynx Studio Technology, Inc.",
        "00:19:DB": "MICRO-STAR INTERNATIONAL CO., LTD.",
        "00:1A:03": "Angel Electronics Co., Ltd.",
        "00:19:F9": "TDK-Lambda",
        "00:19:CE": "Progressive Gaming International",
        "00:19:BD": "New Media Life",
        "00:19:F2": "Teradyne K.K.",
        "00:19:A7": "ITU-T",
        "00:19:9F": "DKT A/S",
        "00:19:8D": "Ocean Optics, Inc.",
        "00:19:82": "SmarDTV",
        "00:19:85": "IT Watchdogs, Inc",
        "00:19:51": "NETCONS, s.r.o.",
        "00:19:57": "Saafnet Canada Inc.",
        "00:19:58": "Bluetooth SIG, Inc.",
        "00:19:56": "Cisco Systems, Inc",
        "00:19:6B": "Danpex Corporation",
        "00:19:3D": "GMC Guardian Mobility Corp.",
        "00:19:86": "Cheng Hongjian",
        "00:19:9E": "Nifty",
        "00:19:6A": "MikroM GmbH",
        "00:18:FF": "PowerQuattro Co.",
        "00:18:F4": "EO TECHNICS Co., Ltd.",
        "00:18:FC": "Altec Electronic AG",
        "00:18:F6": "Thomson Telecom Belgium",
        "00:18:F5": "Shenzhen Streaming Video Technology Company Limited",
        "00:18:F9": "VVOND, Inc.",
        "00:19:3B": "LigoWave",
        "00:19:35": "DUERR DENTAL AG",
        "00:19:10": "Knick Elektronische Messgeraete GmbH & Co. KG",
        "00:19:13": "Chuang-Yi Network Equipment Co.Ltd.",
        "00:18:FA": "Yushin Precision Equipment Co.,Ltd.",
        "00:18:EA": "Alltec GmbH",
        "00:18:E8": "Hacetron Corporation",
        "00:19:14": "Winix Co., Ltd",
        "00:19:06": "Cisco Systems, Inc",
        "00:19:01": "F1MEDIA",
        "00:19:31": "Balluff GmbH",
        "00:18:E3": "Visualgate Systems, Inc.",
        "00:18:9F": "Lenntek Corporation",
        "00:18:99": "ShenZhen jieshun Science&Technology Industry CO,LTD.",
        "00:18:6D": "Zhenjiang Sapphire Electronic Industry CO.",
        "00:18:6F": "Setha Industria Eletronica LTDA",
        "00:18:75": "AnaCise Testnology Pte Ltd",
        "00:18:C1": "Almitec Informática e Comércio",
        "00:18:C4": "Raba Technologies LLC",
        "00:18:C9": "EOps Technology Limited",
        "00:18:D8": "ARCH METER Corporation",
        "00:18:D9": "Santosha Internatonal, Inc",
        "00:18:CF": "Baldor Electric Company",
        "00:18:BC": "ZAO NVP Bolid",
        "00:18:B7": "D3 LED, LLC",
        "00:18:95": "Hansun Technologies Inc.",
        "00:18:83": "FORMOSA21 INC.",
        "00:18:8E": "Ekahau, Inc.",
        "00:18:14": "Mitutoyo Corporation",
        "00:18:17": "D. E. Shaw Research, LLC",
        "00:18:11": "Neuros Technology International, LLC.",
        "00:17:DE": "Advantage Six Ltd",
        "00:17:D7": "ION Geophysical Corporation Inc.",
        "00:18:37": "Universal ABIT Co., Ltd.",
        "00:18:22": "CEC TELECOM CO.,LTD.",
        "00:18:20": "w5networks",
        "00:18:5D": "TAIGUEN TECHNOLOGY (SHEN-ZHEN) CO., LTD.",
        "00:18:5E": "Nexterm Inc.",
        "00:18:28": "e2v technologies (UK) ltd.",
        "00:18:35": "Thoratec / ITC",
        "00:18:01": "Actiontec Electronics, Inc",
        "00:17:F3": "Harris Corporation",
        "00:18:4A": "Catcher, Inc.",
        "00:18:4B": "Las Vegas Gaming, Inc.",
        "00:18:0E": "Avega Systems",
        "00:17:BC": "Touchtunes Music Corporation",
        "00:17:C1": "CM Precision Technology LTD.",
        "00:17:B2": "SK Telesys",
        "00:17:B1": "ACIST Medical Systems, Inc.",
        "00:17:A3": "MIX s.r.l.",
        "00:17:A6": "YOSIN ELECTRONICS CO., LTD.",
        "00:17:9C": "DEPRAG SCHULZ GMBH u. CO.",
        "00:17:96": "Rittmeyer AG",
        "00:17:E1": "DACOS Technologies Co., Ltd.",
        "00:17:E0": "Cisco Systems, Inc",
        "00:17:D2": "THINLINX PTY LTD",
        "00:17:85": "Sparr Electronics Ltd",
        "00:17:75": "TTE Germany GmbH",
        "00:17:B8": "NOVATRON CO., LTD.",
        "00:17:BB": "Syrinx Industrial Electronics",
        "00:17:7C": "Smartlink Network Systems Limited",
        "00:17:81": "Greystone Data System, Inc.",
        "00:17:8D": "Checkpoint Systems, Inc.",
        "00:17:8E": "Gunnebo Cash Automation AB",
        "00:17:C7": "MARA Systems Consulting AB",
        "00:17:5D": "Dongseo system.",
        "00:17:50": "GSI Group, MicroE Systems",
        "00:17:55": "GE Security",
        "00:17:1D": "DIGIT",
        "00:17:18": "Vansco Electronics Oy",
        "00:17:19": "Audiocodes USA, Inc",
        "00:17:76": "Meso Scale Diagnostics, LLC",
        "00:17:79": "QuickTel",
        "00:17:67": "Earforce AS",
        "00:17:39": "Bright Headphone Electronics Company",
        "00:17:2C": "TAEJIN INFOTECH",
        "00:17:51": "Online Corporation",
        "00:17:4C": "Millipore",
        "00:17:45": "INNOTZ CO., Ltd",
        "00:17:48": "Neokoros Brasil Ltda",
        "00:17:63": "Essentia S.p.A.",
        "00:17:01": "KDE, Inc.",
        "00:16:F6": "Video Products Group",
        "00:16:EE": "Royaldigital Inc.",
        "00:16:DE": "FAST Inc",
        "00:16:DA": "Futronic Technology Co. Ltd.",
        "00:16:D4": "Compal Communications, Inc.",
        "00:16:D7": "Sunways AG",
        "00:16:FF": "Wamin Optocomm Mfg Corp",
        "00:16:D1": "ZAT a.s.",
        "00:16:C5": "Shenzhen Xing Feng Industry Co.,Ltd",
        "00:16:CC": "Xcute Mobile Corp.",
        "00:17:17": "Leica Geosystems AG",
        "00:17:15": "Qstik",
        "00:17:0E": "Cisco Systems, Inc",
        "00:17:05": "Methode Electronics",
        "00:16:AA": "Kei Communication Technology Inc.",
        "00:16:A8": "CWT CO., LTD.",
        "00:16:A6": "Dovado FZ-LLC",
        "00:16:ED": "Utility, Inc",
        "00:16:C7": "Cisco Systems, Inc",
        "00:16:71": "Symphox Information Co.",
        "00:16:69": "MRV Communication (Networks) LTD",
        "00:16:68": "Eishin Electronics",
        "00:16:40": "Asmobile Communication Inc.",
        "00:16:3C": "Rebox B.V.",
        "00:16:7D": "Sky-Line Information Co., Ltd.",
        "00:16:77": "Bihl + Wiedemann GmbH",
        "00:16:55": "FUHO TECHNOLOGY Co., LTD",
        "00:16:46": "Cisco Systems, Inc",
        "00:16:48": "SSD Company Limited",
        "00:16:72": "Zenway enterprise ltd",
        "00:16:5A": "Harman Specialty Group",
        "00:16:59": "Z.M.P. RADWAG",
        "00:16:A2": "CentraLite Systems, Inc.",
        "00:16:95": "AVC Technology (International) Limited",
        "00:15:D8": "Interlink Electronics",
        "00:15:D4": "Emitor AB",
        "00:15:D5": "NICEVT",
        "00:16:0C": "LPL  DEVELOPMENT S.A. DE C.V",
        "00:16:0B": "TVWorks LLC",
        "00:16:03": "COOLKSKY Co., LTD",
        "00:15:EA": "Tellumat (Pty) Ltd",
        "00:15:E2": "Dr.Ing. Herbert Knauer GmbH",
        "00:15:E1": "Picochip Ltd",
        "00:15:DF": "Clivet S.p.A.",
        "00:16:1D": "Innovative Wireless Technologies, Inc.",
        "00:16:11": "Altecon Srl",
        "00:16:09": "Unitech electronics co., ltd.",
        "00:15:F5": "Sustainable Energy Systems",
        "00:15:F1": "KYLINK Communications Corp.",
        "00:16:23": "Interval Media",
        "00:16:19": "Lancelan Technologies S.L.",
        "00:16:25": "Impinj, Inc.",
        "00:15:86": "Xiamen Overseas Chinese Electronic Co., Ltd.",
        "00:15:7E": "Weidmüller Interface GmbH & Co. KG",
        "00:15:80": "U-WAY CORPORATION",
        "00:15:7C": "Dave Networks, Inc.",
        "00:15:7F": "ChuanG International Holding CO.,LTD.",
        "00:15:B3": "Caretech AB",
        "00:15:AA": "Rextechnik International Co.,",
        "00:15:A6": "Digital Electronics Products Ltd.",
        "00:15:9D": "Tripp Lite ",
        "00:15:D6": "OSLiNK Sp. z o.o.",
        "00:15:92": "Facom UK Ltd (Melksham)",
        "00:15:8B": "Park Air Systems Ltd",
        "00:15:76": "LABiTec - Labor Biomedical Technologies GmbH",
        "00:15:BE": "Iqua Ltd.",
        "00:15:C7": "Cisco Systems, Inc",
        "00:15:5E": "Morgan Stanley",
        "00:15:0B": "SAGE INFOTECH LTD.",
        "00:15:07": "Renaissance Learning Inc",
        "00:15:08": "Global Target Enterprise Inc",
        "00:15:02": "BETA tech",
        "00:14:FD": "Thecus Technology Corp.",
        "00:14:FC": "Extandon, Inc.",
        "00:14:F8": "Scientific Atlanta",
        "00:14:F7": "CREVIS Co., LTD",
        "00:15:15": "Leipold+Co.GmbH",
        "00:15:0F": "mingjong",
        "00:15:5C": "Dresser Wayne",
        "00:15:59": "Securaplane Technologies, Inc.",
        "00:15:57": "Olivetti",
        "00:15:54": "Atalum Wireless S.A.",
        "00:15:3B": "EMH metering GmbH & Co. KG",
        "00:15:37": "Ventus Networks",
        "00:15:33": "NADAM.CO.,LTD",
        "00:15:34": "A Beltrónica-Companhia de Comunicações, Lda",
        "00:15:3F": "Alcatel Alenia Space Italia",
        "00:15:18": "Shenzhen 10MOONS Technology Development CO.,Ltd",
        "00:15:26": "Remote Technologies Inc",
        "00:14:F1": "Cisco Systems, Inc",
        "00:14:EA": "S Digm Inc. (Safe Paradigm Inc.)",
        "00:14:E5": "Alticast",
        "00:14:9F": "System and Chips, Inc.",
        "00:14:B3": "CoreStar International Corp",
        "00:14:B1": "Axell Wireless Limited",
        "00:14:E0": "LET'S Corporation",
        "00:14:E2": "datacom systems inc.",
        "00:14:E4": "infinias, LLC",
        "00:14:CC": "Zetec, Inc.",
        "00:14:CB": "LifeSync Corporation",
        "00:14:C6": "Quixant Ltd",
        "00:14:98": "Viking Design Technology",
        "00:14:96": "Phonic Corp.",
        "00:14:93": "Systimax Solutions",
        "00:14:DB": "Elma Trenew Electronic GmbH",
        "00:14:3A": "RAYTALK INTERNATIONAL SRL",
        "00:14:36": "Qwerty Elektronik AB",
        "00:14:6B": "Anagran, Inc.",
        "00:14:61": "CORONA CORPORATION",
        "00:14:62": "Digiwell Technology, inc",
        "00:14:63": "IDCS N.V.",
        "00:14:65": "Novo Nordisk A/S",
        "00:14:74": "K40 Electronics",
        "00:14:6F": "Kohler Co",
        "00:14:66": "Kleinhenz Elektronik GmbH",
        "00:14:7F": "Thomson Telecom Belgium",
        "00:14:75": "Wiline Networks, Inc.",
        "00:14:86": "Echo Digital Audio Corporation",
        "00:14:82": "Aurora Networks",
        "00:14:55": "Coder Electronics Corporation",
        "00:14:4E": "SRISA",
        "00:14:8D": "Cubic Defense Simulation Systems",
        "00:14:3D": "Aevoe Inc.",
        "00:14:15": "Intec Automation inc.",
        "00:14:10": "Suzhou Keda Technology CO.,Ltd",
        "00:14:17": "RSE Informations Technologie GmbH",
        "00:14:33": "Empower Technologies(Canada) Inc.",
        "00:14:34": "Keri Systems, Inc",
        "00:13:DE": "Adapt4, LLC",
        "00:13:DD": "Abbott Diagnostics",
        "00:13:D7": "SPIDCOM Technologies SA",
        "00:13:C7": "IONOS Co.,Ltd.",
        "00:14:23": "J-S Co. NEUROCOM",
        "00:14:25": "Galactic Computing Corp.",
        "00:14:19": "SIDSA",
        "00:13:EE": "JBX Designs Inc.",
        "00:13:E5": "TENOSYS, INC.",
        "00:13:E2": "GeoVision Inc.",
        "00:14:02": "kk-electronic a/s",
        "00:13:FF": "Dage-MTI of MC, Inc.",
        "00:13:BC": "Artimi Ltd",
        "00:14:08": "Eka Systems Inc.",
        "00:13:A7": "BATTELLE MEMORIAL INSTITUTE",
        "00:13:A6": "Extricom Ltd",
        "00:13:A2": "MaxStream, Inc",
        "00:13:9F": "Electronics Design Services, Co., Ltd.",
        "00:13:A0": "ALGOSYSTEM Co., Ltd.",
        "00:13:9B": "ioIMAGE Ltd.",
        "00:13:96": "Acbel Polytech Inc.",
        "00:13:93": "Panta Systems, Inc.",
        "00:13:8B": "Phantom Technologies LLC",
        "00:13:88": "WiMedia Alliance",
        "00:13:6E": "Techmetro Corp.",
        "00:13:6D": "Tentaculus AB",
        "00:13:6A": "Hach Lange Sarl",
        "00:13:B2": "Carallon Limited",
        "00:13:AD": "Sendo Ltd",
        "00:13:AA": "ALS  & TEC Ltd.",
        "00:13:A4": "KeyEye Communications",
        "00:13:4D": "Inepro BV",
        "00:13:4B": "ToGoldenNet Technology Inc.",
        "00:13:84": "Advanced Motion Controls",
        "00:13:7B": "Movon Corporation",
        "00:13:53": "HYDAC Filtertechnik GMBH",
        "00:13:63": "Verascape, Inc.",
        "00:13:03": "GateConnect",
        "00:13:04": "Flaircomm Technologies Co. LTD",
        "00:12:F9": "URYU SEISAKU, LTD.",
        "00:13:37": "Orient Power Home Network Ltd.",
        "00:13:34": "Arkados, Inc.",
        "00:13:32": "Beijing Topsec Network Security Technology Co., Ltd.",
        "00:13:1F": "NxtPhase T&D, Corp.",
        "00:12:DC": "SunCorp Industrial Limited",
        "00:12:FF": "Lely Industries N.V.",
        "00:13:3A": "VadaTech Inc.",
        "00:13:2A": "Sitronics Telecom Solutions",
        "00:12:E5": "Time America, Inc.",
        "00:13:0E": "Focusrite Audio Engineering Limited",
        "00:13:09": "Ocean Broadband Networks",
        "00:13:19": "Cisco Systems, Inc",
        "00:13:1C": "LiteTouch, Inc.",
        "00:13:4A": "Engim, Inc.",
        "00:12:D7": "Invento Networks, Inc.",
        "00:12:C4": "Viseon, Inc.",
        "00:12:94": "SUMITOMO ELECTRIC DEVICE INNOVATIONS, INC",
        "00:12:96": "Addlogix",
        "00:12:B3": "Advance Wireless Technology Corp.",
        "00:12:B0": "Efore Oyj   (Plc)",
        "00:12:7F": "Cisco Systems, Inc",
        "00:12:A6": "Dolby Australia",
        "00:12:A4": "ThingMagic, LLC",
        "00:12:A9": "3Com Ltd",
        "00:12:D0": "Gossen-Metrawatt-GmbH",
        "00:12:99": "Ktech Telecommunications Inc",
        "00:12:8C": "Woodward Governor",
        "00:12:B8": "G2 Microsystems",
        "00:12:7B": "VIA Networking Technologies, Inc.",
        "00:12:80": "Cisco Systems, Inc",
        "00:12:75": "Sentilla Corporation",
        "00:12:76": "CG Power Systems Ireland Limited",
        "00:12:71": "Measurement Computing Corp",
        "00:12:73": "Stoke Inc",
        "00:12:69": "Value Electronics",
        "00:12:50": "Tokyo Aircaft Instrument Co., Ltd.",
        "00:12:52": "Citronix, LLC",
        "00:12:40": "AMOI ELECTRONICS CO.,LTD",
        "00:12:2E": "Signal Technology - AISD",
        "00:12:64": "daum electronic gmbh",
        "00:12:61": "Adaptix, Inc",
        "00:12:60": "Stanton Magnetics,inc.",
        "00:12:31": "Motion Control Systems, Inc.",
        "00:12:4B": "Texas Instruments",
        "00:12:4A": "Dedicated Devices, Inc.",
        "00:12:43": "Cisco Systems, Inc",
        "00:11:D9": "TiVo",
        "00:11:D2": "Perception Digital Ltd",
        "00:11:CF": "Thrane & Thrane A/S",
        "00:11:D4": "NetEnrich, Inc",
        "00:11:D5": "Hangzhou Sunyard System Engineering Co.,Ltd.",
        "00:11:F8": "AIRAYA Corp",
        "00:11:F4": "woori-net",
        "00:11:F6": "Asia Pacific Microsystems , Inc.",
        "00:11:F0": "Wideful Limited",
        "00:11:F1": "QinetiQ Ltd",
        "00:11:ED": "802 Global",
        "00:12:11": "Protechna Herbst GmbH & Co. KG",
        "00:12:19": "General Datacomm LLC",
        "00:12:16": "ICP Internet Communication Payment AG",
        "00:12:15": "iStor Networks, Inc.",
        "00:12:03": "ActivNetworks",
        "00:11:CC": "Guangzhou Jinpeng Group Co.,Ltd.",
        "00:11:C7": "Raymarine UK Ltd",
        "00:11:C9": "MTT Corporation",
        "00:11:DB": "Land-Cellular Corporation",
        "00:12:24": "NexQL Corporation",
        "00:11:BD": "Bombardier Transportation",
        "00:11:AA": "Uniclass Technology, Co., LTD",
        "00:11:79": "Singular Technology Co. Ltd.",
        "00:11:8A": "Viewtran Technology Limited",
        "00:11:84": "Humo Laboratory,Ltd.",
        "00:11:B1": "BlueExpert Technology Corp.",
        "00:11:A6": "Sypixx Networks",
        "00:11:B5": "Shenzhen Powercom Co.,Ltd",
        "00:11:BB": "Cisco Systems, Inc",
        "00:11:66": "Taelim Electronics Co., Ltd.",
        "00:11:64": "ACARD Technology Corp.",
        "00:11:A2": "Manufacturing Technology Inc",
        "00:11:9E": "Solectron Brazil",
        "00:11:73": "SMART Storage Systems",
        "00:11:25": "IBM Corp",
        "00:11:1C": "Pleora Technologies Inc.",
        "00:11:1F": "Doremi Labs, Inc.",
        "00:11:1D": "Hectrix Limited",
        "00:11:19": "Solteras, Inc.",
        "00:11:50": "Belkin Corporation",
        "00:11:46": "Telecard-Pribor Ltd",
        "00:11:0D": "SANBlaze Technology, Inc.",
        "00:11:06": "Siemens NV (Belgium)",
        "00:0F:F4": "Guntermann & Drunck GmbH",
        "00:0F:F8": "Cisco Systems, Inc",
        "00:11:2C": "IZT GmbH",
        "00:11:0E": "Tsurusaki Sealand Transportation Co. Ltd.",
        "00:11:4C": "caffeina applied research ltd.",
        "00:11:41": "GoodMan Corporation",
        "00:11:55": "Sevis Systems",
        "00:11:52": "Eidsvoll Electronics AS",
        "00:0F:CF": "DataWind Research",
        "00:0F:D2": "EWA Technologies, Inc.",
        "00:0F:CE": "Kikusui Electronics Corp.",
        "00:0F:EB": "Cylon Controls",
        "00:0F:DC": "Ueda Japan  Radio Co., Ltd.",
        "00:0F:8E": "DONGYANG TELECOM CO.,LTD.",
        "00:0F:91": "Aerotelecom Co.,Ltd.",
        "00:0F:87": "Maxcess International",
        "00:0F:A1": "Gigabit Systems Inc.",
        "00:0F:99": "APAC opto Electronics Inc.",
        "00:0F:F5": "GN&S company",
        "00:0F:E8": "Lobos, Inc.",
        "00:0F:B2": "Broadband Pacenet (India) Pvt. Ltd.",
        "00:0F:D7": "Harman Music Group",
        "00:0F:D4": "Soundcraft",
        "00:0F:AF": "Dialog Inc.",
        "00:0F:A5": "BWA Technology GmbH",
        "00:0F:80": "Trinity Security Systems,Inc.",
        "00:0F:2A": "Cableware Electronics",
        "00:0F:29": "Augmentix Corporation",
        "00:0F:27": "TEAL Electronics, Inc.",
        "00:0F:43": "Wasabi Systems Inc.",
        "00:0F:48": "Polypix Inc.",
        "00:0F:50": "StreamScale Limited",
        "00:0F:4E": "Cellink",
        "00:0F:47": "ROBOX SPA",
        "00:0F:18": "Industrial Control Systems",
        "00:0F:1D": "Cosmo Techs Co., Ltd.",
        "00:0F:1B": "Ego Systems Inc.",
        "00:0F:78": "Datacap Systems Inc",
        "00:0F:70": "Wintec Industries, inc.",
        "00:0F:74": "Qamcom Technology AB",
        "00:0F:6D": "Midas Engineering",
        "00:0F:5F": "Nicety Technologies Inc. (NTS)",
        "00:0F:5A": "Peribit Networks",
        "00:0F:31": "Allied Vision Technologies Canada Inc",
        "00:0F:73": "RS Automation Co., Ltd",
        "00:0F:3C": "Endeleo Limited",
        "00:0E:AB": "Cray Inc",
        "00:0E:AD": "Metanoia Technologies, Inc.",
        "00:0E:AF": "CASTEL",
        "00:0E:F8": "SBC ASI",
        "00:0E:F9": "REA Elektronik GmbH",
        "00:0E:E6": "Adimos Systems LTD",
        "00:0E:F6": "E-TEN Information Systems Co., Ltd.",
        "00:0E:EA": "Shadong Luneng Jicheng Electronics,Co.,Ltd",
        "00:0F:0F": "Real ID Technology Co., Ltd.",
        "00:0F:16": "JAY HOW TECHNOLOGY CO.,",
        "00:0E:C6": "ASIX ELECTRONICS CORP.",
        "00:0E:BF": "Remsdaq Limited",
        "00:0E:FF": "Megasolution,Inc.",
        "00:0E:E0": "Mcharge",
        "00:0E:9F": "TEMIC SDS GmbH",
        "00:0E:96": "Cubic Defense Applications, Inc.",
        "00:0E:8E": "SparkLAN Communications, Inc.",
        "00:0E:91": "Navico Auckland Ltd",
        "00:0E:48": "Lipman TransAction Solutions",
        "00:0E:3E": "Sun Optronics Inc",
        "00:0E:33": "Shuko Electronics Co.,Ltd",
        "00:0E:75": "New York Air Brake Corp.",
        "00:0E:7C": "Televes S.A.",
        "00:0E:66": "Hitachi Industry & Control Solutions, Ltd.",
        "00:0E:68": "E-TOP Network Technology Inc.",
        "00:0E:5E": "Raisecom Technology",
        "00:0E:56": "4G Systems GmbH & Co. KG",
        "00:0E:55": "AUVITRAN",
        "00:0E:73": "Tpack A/S",
        "00:0E:72": "CTS electronics",
        "00:0E:6E": "MAT S.A. (Mircrelec Advanced Technology)",
        "00:0E:84": "Cisco Systems, Inc",
        "00:0E:87": "adp Gauselmann GmbH",
        "00:0E:92": "Open Telecom",
        "00:0E:53": "AV TECH CORPORATION",
        "00:0D:F9": "NDS Limited",
        "00:0D:FD": "Huges Hi-Tech Inc.,",
        "00:0D:FB": "Komax AG",
        "00:0E:00": "Atrie",
        "00:0D:F4": "Watertek Co.",
        "00:0D:FA": "Micro Control Systems Ltd.",
        "00:0D:FC": "ITFOR Inc.",
        "00:0D:FE": "Hauppauge Computer Works, Inc.",
        "00:0D:D6": "ITI    LTD",
        "00:0D:D5": "O'RITE TECHNOLOGY CO.,LTD",
        "00:0E:0F": "ERMME",
        "00:0E:10": "C-guys, Inc.",
        "00:0E:0A": "SAKUMA DESIGN OFFICE",
        "00:0E:0E": "ESA elettronica S.P.A.",
        "00:0E:18": "MyA Technology",
        "00:0E:14": "Visionary Solutions, Inc.",
        "00:0E:1B": "IAV GmbH",
        "00:0E:13": "Accu-Sort Systems inc.",
        "00:0D:DE": "Joyteck Co., Ltd.",
        "00:0D:E2": "CMZ Sistemi Elettronici",
        "00:0D:DA": "ALLIED TELESIS K.K.",
        "00:0D:CD": "GROUPE TXCOM",
        "00:0D:CA": "Tait Electronics",
        "00:0D:CF": "Cidra Corp.",
        "00:0E:3A": "Cirrus Logic",
        "00:0E:3B": "Hawking Technologies, Inc.",
        "00:0D:EC": "Cisco Systems, Inc",
        "00:0D:F2": "Private",
        "00:0E:27": "Crere Networks, Inc.",
        "00:0D:A0": "NEDAP N.V.",
        "00:0D:8E": "Koden Electronics Co., Ltd.",
        "00:0D:8A": "Winners Electronics Co., Ltd.",
        "00:0D:7E": "Axiowave Networks, Inc.",
        "00:0D:71": "boca systems",
        "00:0D:5A": "Tiesse SpA",
        "00:0D:B8": "SCHILLER AG",
        "00:0D:C4": "Emcore Corporation",
        "00:0D:9B": "Heraeus Electro-Nite International N.V.",
        "00:0D:7C": "Codian Ltd",
        "00:0D:6B": "Mita-Teknik A/S",
        "00:0D:43": "DRS Tactical Systems Inc.",
        "00:0D:44": "Audio BU - Logitech",
        "00:0D:36": "Wu Han Routon Electronic Co., Ltd",
        "00:0D:3D": "Hammerhead Systems, Inc.",
        "00:0D:3E": "APLUX Communications Ltd.",
        "00:0D:0D": "ITSupported, LLC",
        "00:0D:06": "Compulogic Limited",
        "00:0D:4A": "Steag ETA-Optik",
        "00:0D:4F": "Kenwood Corporation",
        "00:0D:47": "Collex",
        "00:0D:61": "Giga-Byte Technology Co., Ltd.",
        "00:0D:3B": "Microelectronics Technology Inc.",
        "00:0D:2D": "NCT Deutschland GmbH",
        "00:0D:1E": "Control Techniques",
        "00:0D:52": "Comart system",
        "00:0D:1A": "Mustek System Inc.",
        "00:0C:B8": "MEDION AG",
        "00:0C:BB": "ISKRAEMECO",
        "00:0C:C0": "Genera Oy",
        "00:0C:A8": "Garuda Networks Corporation",
        "00:0D:03": "Matrics, Inc.",
        "00:0C:FF": "MRO-TEK Realty Limited",
        "00:0C:FA": "Digital Systems Corp",
        "00:0C:FD": "Hyundai ImageQuest Co.,Ltd.",
        "00:0C:D3": "Prettl Elektronik Radeberg GmbH",
        "00:0C:D7": "Nallatech Ltd",
        "00:0C:D4": "Positron Public Safety Systems inc.",
        "00:0C:D6": "PARTNER TECH",
        "00:0C:B9": "LEA",
        "00:0C:BD": "Interface Masters, Inc",
        "00:0C:B2": "UNION co., ltd.",
        "00:0C:EB": "CNMP Networks, Inc.",
        "00:0C:CC": "Aeroscout Ltd.",
        "00:0C:C7": "Intelligent Computer Solutions Inc.",
        "00:0C:BE": "Innominate Security Technologies AG",
        "00:0C:A7": "Metro (Suzhou) Technologies Co., Ltd.",
        "00:0C:EF": "Open Networks Engineering Ltd",
        "00:0C:64": "X2 MSA Group",
        "00:0C:A0": "StorCase Technology, Inc.",
        "00:0C:99": "HITEL LINK Co.,Ltd",
        "00:0C:5A": "IBSmm Embedded Electronics Consulting",
        "00:0C:5E": "Calypso Medical",
        "00:0C:61": "AC Tech corporation DBA Advanced Digital",
        "00:0C:5F": "Avtec, Inc.",
        "00:0C:4B": "Cheops Elektronik",
        "00:0C:45": "Animation Technologies Inc.",
        "00:0C:3C": "MediaChorus, Inc.",
        "00:0C:7C": "Internet Information Image Inc.",
        "00:0C:7B": "ALPHA PROJECT Co.,Ltd.",
        "00:0C:77": "Life Racing Ltd",
        "00:0C:69": "National Radio Astronomy Observatory",
        "00:0C:66": "Pronto Networks Inc",
        "00:0C:88": "Apache Micro Peripherals, Inc.",
        "00:0C:82": "NETWORK TECHNOLOGIES INC",
        "00:0C:8D": "MATRIX VISION GmbH",
        "00:0C:89": "AC Electric Vehicles, Ltd.",
        "00:0C:4E": "Winbest Technology CO,LT",
        "00:0B:FE": "CASTEL Broadband Limited",
        "00:0B:F5": "Shanghai Sibo Telecom Technology Co.,Ltd",
        "00:0C:27": "Sammy Corporation",
        "00:0C:2A": "OCTTEL Communication Co., Ltd.",
        "00:0C:1C": "MicroWeb Co., Ltd.",
        "00:0B:DF": "Shenzhen RouterD Networks Limited",
        "00:0B:E6": "Datel Electronics",
        "00:0B:F2": "Chih-Kan Technology Co., Ltd.",
        "00:0B:EB": "Systegra AG",
        "00:0B:EF": "Code Corporation",
        "00:0C:05": "RPA Reserch Co., Ltd.",
        "00:0C:22": "Double D Electronics Ltd",
        "00:0C:0F": "Techno-One Co., Ltd",
        "00:0C:38": "TelcoBridges Inc.",
        "00:0B:AF": "WOOJU COMMUNICATIONS Co,.Ltd",
        "00:0B:B6": "Metalligence Technology Corp.",
        "00:0B:B3": "RiT technologies Ltd.",
        "00:0B:B7": "Micro Systems Co.,Ltd.",
        "00:0B:BA": "Harmonic, Inc",
        "00:0B:62": "ib-mohnen KG",
        "00:0B:64": "Kieback & Peter GmbH & Co KG",
        "00:0B:67": "Topview Technology Corporation",
        "00:0B:7D": "SOLOMON EXTREME INTERNATIONAL LTD.",
        "00:0B:94": "Digital Monitoring Products, Inc.",
        "00:0B:AE": "Vitals System Inc.",
        "00:0B:D9": "General Hydrogen",
        "00:0B:AB": "Advantech Technology (CHINA) Co., Ltd.",
        "00:0B:6D": "SOLECTRON JAPAN NAKANIIDA",
        "00:0B:C4": "BIOTRONIK GmbH & Co",
        "00:0B:57": "Silicon Laboratories",
        "00:0B:51": "Micetek International Inc.",
        "00:0B:53": "INITIUM Co., Ltd.",
        "00:0A:FB": "Ambri Limited",
        "00:0A:FF": "Kilchherr Elektronik AG",
        "00:0B:4A": "Visimetrics (UK) Ltd",
        "00:0B:48": "sofrel",
        "00:0B:1E": "KAPPA opto-electronics GmbH",
        "00:0B:1C": "SIBCO bv",
        "00:0B:37": "MANUFACTURE DES MONTRES ROLEX SA",
        "00:0A:F8": "American Telecare Inc.",
        "00:0B:17": "MKS Instruments",
        "00:0B:2D": "Danfoss Inc.",
        "00:0A:A3": "SHIMAFUJI ELECTRIC CO.,LTD.",
        "00:0A:A7": "FEI Electron Optics",
        "00:0A:A6": "Hochiki Corporation",
        "00:0A:9A": "Aiptek International Inc",
        "00:0A:94": "ShangHai cellink CO., LTD",
        "00:0A:97": "SONICblue, Inc.",
        "00:0A:92": "Presonus Corporation",
        "00:0A:85": "PLAT'C2,Inc",
        "00:0A:D0": "Niigata Develoment Center,  F.I.T. Co., Ltd.",
        "00:0A:D4": "CoreBell Systems Inc.",
        "00:0A:CA": "YOKOYAMA SHOKAI CO.,Ltd.",
        "00:0A:CE": "RADIANTECH, INC.",
        "00:0A:C7": "Unication Group",
        "00:0A:DE": "Happy Communication Co., Ltd.",
        "00:0A:E2": "Binatone Electronics International, Ltd",
        "00:0A:DB": "Trilliant",
        "00:0A:B8": "Cisco Systems, Inc",
        "00:0A:AC": "TerraTec Electronic GmbH",
        "00:0A:BF": "HIROTA SS",
        "00:0A:BC": "Seabridge Ltd.",
        "00:0A:50": "REMOTEK CORPORATION",
        "00:0A:58": "Freyer & Siegel Elektronik GmbH & Co. KG",
        "00:0A:4E": "UNITEK Electronics INC.",
        "00:0A:62": "Crinis Networks, Inc.",
        "00:0A:6A": "SVM Microwaves s.r.o.",
        "00:0A:66": "MITSUBISHI ELECTRIC SYSTEM & SERVICE CO.,LTD.",
        "00:0A:31": "HCV Consulting",
        "00:42:52": "RLX Technologies",
        "00:0A:70": "MPLS Forum",
        "00:0A:72": "STEC, INC.",
        "00:0A:3D": "Elo Sistemas Eletronicos S.A.",
        "00:0A:46": "ARO WELDING TECHNOLOGIES SAS",
        "00:0A:71": "Avrio Technologies, Inc",
        "00:0A:64": "Eracom Technologies",
        "00:0A:83": "SALTO SYSTEMS S.L.",
        "00:0A:86": "Lenze",
        "00:0A:3F": "Data East Corporation",
        "00:0A:0C": "Scientific Research Corporation",
        "00:09:F6": "Shenzhen Eastern Digital Tech Ltd.",
        "00:0A:20": "SVA Networks, Inc.",
        "00:0A:24": "Octave Communications",
        "00:0A:19": "Valere Power, Inc.",
        "00:09:DE": "Samjin Information & Communications Co., Ltd.",
        "00:09:E0": "XEMICS S.A.",
        "00:0A:01": "SOHOware, Inc.",
        "00:09:EC": "Daktronics, Inc.",
        "00:09:CA": "iMaxNetworks(Shenzhen)Limited.",
        "00:09:CF": "iAd GmbH",
        "00:0A:11": "ExPet Technologies, Inc",
        "00:0A:0F": "Ilryung Telesys, Inc",
        "00:09:E7": "ADC Techonology",
        "00:09:93": "Visteon Corporation",
        "00:09:99": "CP GEORGES RENAULT",
        "00:09:94": "Cronyx Engineering",
        "00:09:B9": "Action Imaging Solutions",
        "00:09:AC": "LANVOICE",
        "00:09:B1": "Kanematsu Electronics, Ltd.",
        "00:09:79": "Advanced Television Systems Committee, Inc.",
        "00:09:63": "Dominion Lasercom Inc.",
        "00:09:66": "TRIMBLE EUROPE BV",
        "00:09:C1": "PROCES-DATA A/S",
        "00:09:BB": "MathStar, Inc.",
        "00:09:68": "TECHNOVENTURE, INC.",
        "00:09:61": "Switchgear and Instrumentation Ltd",
        "00:09:7C": "Cisco Systems, Inc",
        "00:09:7B": "Cisco Systems, Inc",
        "00:09:9D": "Haliplex Communications",
        "00:09:9E": "Testech, Inc.",
        "00:09:88": "Nudian Electron Co., Ltd.",
        "00:09:8E": "ipcas GmbH",
        "00:09:AB": "Netcontrol Oy",
        "00:09:60": "YOZAN Inc.",
        "00:09:56": "Network Systems Group, Ltd. (NSG)",
        "00:09:00": "TMT",
        "00:09:01": "Shenzhen Shixuntong Information & Technoligy Co",
        "00:09:13": "SystemK Corporation",
        "00:09:0E": "Helix Technology Inc.",
        "00:09:3C": "Jacques Technologies P/L",
        "00:09:35": "Sandvine Incorporated",
        "00:09:36": "Ipetronik GmbH & Co. KG",
        "00:09:37": "Inventec Appliance Corp",
        "00:09:46": "Cluster Labs GmbH",
        "00:09:3F": "Double-Win Enterpirse CO., LTD",
        "00:09:48": "Vista Control Systems, Corp.",
        "00:09:49": "Glyph Technologies Inc.",
        "00:09:2A": "MYTECS Co.,Ltd.",
        "00:09:25": "VSN Systemen BV",
        "00:08:E0": "ATO Technology Ltd.",
        "00:08:E4": "Envenergy Inc",
        "00:08:E3": "Cisco Systems, Inc",
        "00:08:E5": "IDK Corporation",
        "00:08:D9": "Mitadenshi Co.,LTD",
        "00:08:91": "Lyan Inc.",
        "00:08:92": "EM Solutions",
        "00:08:8C": "Quanta Network Systems Inc.",
        "00:08:8A": "Minds@Work",
        "00:08:FD": "BlueKorea Co., Ltd.",
        "00:08:F8": "UTC CCS",
        "00:08:D5": "Vanguard Networks Solutions, LLC",
        "00:08:CD": "With-Net Inc",
        "00:08:CC": "Remotec, Inc.",
        "00:08:D1": "KAREL INC.",
        "00:08:A7": "iLogic Inc.",
        "00:08:99": "Netbind, Inc.",
        "00:08:A0": "Stotz Feinmesstechnik GmbH",
        "00:08:BC": "Ilevo AB",
        "00:08:BD": "TEPG-US",
        "00:08:AE": "PacketFront Network Products AB",
        "00:08:C3": "Contex A/S",
        "00:08:F3": "WANY",
        "00:08:DE": "3UP Systems",
        "00:08:22": "InPro Comm",
        "00:08:23": "Texa Corp.",
        "00:08:1D": "Ipsil, Incorporated",
        "00:08:2D": "Indus Teqsite Private Limited",
        "00:08:20": "Cisco Systems, Inc",
        "00:08:28": "Koei Engineering Ltd.",
        "00:08:24": "Nuance Document Imaging",
        "00:08:6C": "Plasmon LMS",
        "00:08:68": "PurOptix",
        "00:08:69": "Command-e Technology Co.,Ltd.",
        "00:08:62": "NEC Eluminant Technologies, Inc.",
        "00:08:03": "Cos Tron",
        "00:08:05": "Techno-Holon Corporation",
        "00:08:08": "PPT Vision, Inc.",
        "00:08:14": "TIL Technologies",
        "00:08:5C": "Shanghai Dare Technologies Co. Ltd.",
        "00:08:2C": "Homag AG",
        "00:08:21": "Cisco Systems, Inc",
        "00:08:87": "Maschinenfabrik Reinhausen GmbH",
        "00:08:77": "Liebert-Hiross Spa",
        "00:08:7B": "RTX Telecom A/S",
        "00:08:61": "SoftEnergy Co., Ltd.",
        "00:08:4F": "Qualstar Corporation",
        "00:08:54": "Netronix, Inc.",
        "00:08:76": "SDSystem",
        "00:08:70": "Rasvia Systems, Inc.",
        "00:08:6E": "Hyglo AB",
        "00:07:FD": "LANergy Ltd.",
        "00:07:FE": "Rigaku Corporation",
        "00:07:BF": "Armillaire Technologies, Inc.",
        "00:07:BB": "Candera Inc.",
        "00:07:BD": "Radionet Ltd.",
        "00:07:C4": "JEAN Co. Ltd.",
        "00:07:B6": "Telecom Technology Ltd.",
        "00:07:B7": "Samurai Ind. Prods Eletronicos Ltda",
        "00:07:B0": "Office Details, Inc.",
        "00:07:D9": "Splicecom",
        "00:07:DA": "Neuro Telecom Co., Ltd.",
        "00:07:CD": "Kumoh Electronic Co, Ltd",
        "00:07:CF": "Anoto AB",
        "00:07:D2": "Logopak Systeme GmbH & Co. KG",
        "00:07:C9": "Technol Seven Co., Ltd.",
        "00:07:C7": "Synectics Systems Limited",
        "00:07:C3": "Thomson",
        "00:07:A5": "Y.D.K Co. Ltd.",
        "00:07:9C": "Golden Electronics Technology Co., Ltd.",
        "00:07:E4": "SoftRadio Co., Ltd.",
        "00:07:54": "Xyterra Computing, Inc.",
        "00:07:57": "Topcall International AG",
        "00:07:53": "Beijing Qxcomm Technology Co., Ltd.",
        "00:07:4C": "Beicom Inc.",
        "00:07:4D": "Zebra Technologies Corp.",
        "00:07:32": "AAEON Technology Inc.",
        "00:07:25": "Bematech International Corp.",
        "00:07:23": "ELCON Systemtechnik GmbH",
        "00:07:1D": "Satelsa Sistemas Y Aplicaciones De Telecomunicaciones, S.A.",
        "00:07:20": "Trutzschler GmbH & Co. KG",
        "00:07:6E": "Sinetica Corporation Limited",
        "00:07:6F": "Synoptics Limited",
        "00:07:73": "Ascom Powerline Communications Ltd.",
        "00:07:6C": "Daehanet, Inc.",
        "00:07:5D": "Celleritas Inc.",
        "00:07:3F": "Woojyun Systec Co., Ltd.",
        "00:07:28": "Neo Telecom",
        "00:07:2C": "Fabricom",
        "00:07:2D": "CNSystems",
        "00:07:2F": "Intransa, Inc.",
        "00:07:80": "Bluegiga Technologies OY",
        "00:07:77": "Motah Ltd.",
        "00:07:24": "Telemax Co., Ltd.",
        "00:07:1B": "CDVI Americas Ltd",
        "00:07:15": "General Research of Electronics, Inc.",
        "00:07:37": "Soriya Co. Ltd.",
        "00:07:34": "ONStor, Inc.",
        "00:07:65": "Jade Quantum Technologies, Inc.",
        "00:05:EA": "Rednix",
        "00:06:C9": "Technical Marketing Research, Inc.",
        "00:06:C8": "Sumitomo Metal Micro Devices, Inc.",
        "00:06:F1": "Optillion",
        "00:06:A7": "Primarion",
        "00:06:A9": "Universal Instruments Corp.",
        "00:06:9E": "UNIQA, Inc.",
        "00:06:B1": "Sonicwall",
        "00:06:AD": "KB Electronics Ltd.",
        "00:06:AF": "Xalted Networks",
        "00:06:D7": "Cisco Systems, Inc",
        "00:06:D5": "Diamond Systems Corp.",
        "00:06:FD": "Comjet Information Systems Corp.",
        "00:06:F9": "Mitsui Zosen Systems Research Inc.",
        "00:06:C0": "United Internetworks, Inc.",
        "00:06:E0": "MAT Co., Ltd.",
        "00:D0:B9": "MICROTEK INTERNATIONAL, INC.",
        "00:D0:5F": "VALCOM, INC.",
        "00:06:75": "Banderacom, Inc.",
        "00:06:98": "egnite GmbH",
        "00:06:9C": "Transmode Systems AB",
        "00:06:43": "SONO Computer Co., Ltd.",
        "00:06:49": "3M Deutschland GmbH",
        "00:06:3E": "Opthos Inc.",
        "00:06:3B": "Arcturus Networks Inc.",
        "00:06:7B": "Toplink C&C Corporation",
        "00:06:70": "Upponetti Oy",
        "00:06:6F": "Korea Data Systems",
        "00:06:68": "Vicon Industries Inc.",
        "00:06:6D": "Compuprint S.P.A.",
        "00:06:26": "MWE GmbH",
        "00:06:20": "Serial System Ltd.",
        "00:06:18": "DigiPower Manufacturing Inc.",
        "00:06:33": "Cross Match Technologies GmbH",
        "00:06:86": "ZARDCOM Co., Ltd.",
        "00:06:89": "yLez Technologies Pte Ltd",
        "00:06:81": "Goepel Electronic GmbH",
        "00:06:58": "Helmut Fischer GmbH Institut für Elektronik und Messtechnik",
        "00:05:D3": "eProduction Solutions, Inc.",
        "00:06:04": "@Track Communications, Inc.",
        "00:06:06": "RapidWAN, Inc.",
        "00:06:03": "Baker Hughes Inc.",
        "00:06:07": "Omni Directional Control Technology Inc.",
        "00:05:F7": "Analog Devices, Inc.",
        "00:05:9C": "Kleinknecht GmbH, Ing. Büro",
        "00:05:AE": "Mediaport USA",
        "00:05:B0": "Korea Computer Technology Co., Ltd.",
        "00:05:B2": "Medison Co., Ltd.",
        "00:05:97": "Eagle Traffic Control Systems",
        "00:05:B5": "Broadcom Technologies",
        "00:05:CB": "ROIS Technologies, Inc.",
        "00:05:C8": "VERYTECH",
        "00:05:CD": "D&M Holdings Inc.",
        "00:05:A2": "CELOX Networks",
        "00:05:AA": "Moore Industries International Inc.",
        "00:05:E7": "Netrake an AudioCodes Company",
        "00:05:F4": "System Base Co., Ltd.",
        "00:05:E1": "Trellis Photonics, Ltd.",
        "00:05:E2": "Creativ Network Technologies",
        "00:06:13": "Kawasaki Microelectronics Incorporated",
        "00:06:17": "Redswitch Inc.",
        "00:05:51": "F & S Elektronik Systeme GmbH",
        "00:05:4D": "Brans Technologies, Inc.",
        "00:05:47": "Starent Networks",
        "00:05:4E": "Philips",
        "00:05:46": "KDDI Network & Solultions Inc.",
        "00:05:40": "FAST Corporation",
        "00:05:3C": "XIRCOM",
        "00:05:44": "Valley Technologies, Inc.",
        "00:05:2E": "Cinta Networks",
        "00:05:2F": "Leviton Network Solutions",
        "00:05:3B": "Harbour Networks Ltd., Co. Beijing",
        "00:05:28": "New Focus, Inc.",
        "00:05:6B": "C.P. Technology Co., Ltd.",
        "00:05:60": "LEADER COMM.CO., LTD",
        "00:05:5E": "Cisco Systems, Inc",
        "00:05:96": "Genotech Co., Ltd.",
        "00:05:79": "Universal Control Solution Corp.",
        "00:05:7F": "Acqis Technology",
        "00:05:73": "Cisco Systems, Inc",
        "00:05:75": "CDS-Electronics BV",
        "00:05:56": "360 Systems",
        "00:05:59": "Intracom S.A.",
        "00:05:8C": "Opentech Inc.",
        "00:04:C9": "Micro Electron Co., Ltd.",
        "00:04:BE": "OptXCon, Inc.",
        "00:04:C4": "Audiotonix Group Limited",
        "00:04:C1": "Cisco Systems, Inc",
        "00:04:D6": "Takagi Industrial Co., Ltd.",
        "00:04:D1": "Drew Technologies, Inc.",
        "00:04:D0": "Softlink s.r.o.",
        "00:80:87": "OKI ELECTRIC INDUSTRY CO., LTD",
        "00:04:D9": "Titan Electronics, Inc.",
        "00:04:D8": "IPWireless, Inc.",
        "00:05:24": "BTL System (HK) Limited",
        "00:05:22": "LEA*D Corporation, Inc.",
        "00:05:20": "Smartronix, Inc.",
        "00:04:EB": "Paxonet Communications, Inc.",
        "00:04:EF": "Polestar Corp.",
        "00:05:14": "KDT Systems Co., Ltd.",
        "00:05:0B": "SICOM Systems, Inc.",
        "00:05:05": "Systems Integration Solutions, Inc.",
        "00:04:FE": "Pelago Networks",
        "00:05:18": "Jupiters Technology",
        "00:04:B7": "AMB i.t. Holding",
        "00:04:B9": "S.I. Soubou, Inc.",
        "00:04:BB": "Bardac Corporation",
        "00:04:BC": "Giantec, Inc.",
        "00:04:AF": "Digital Fountain, Inc.",
        "00:04:56": "Cambium Networks Limited",
        "00:04:58": "Fusion X Co., Ltd.",
        "00:04:4F": "Schubert System Elektronik Gmbh",
        "00:04:46": "CYZENTECH Co., Ltd.",
        "00:04:4A": "iPolicy Networks, Inc.",
        "00:04:40": "cyberPIXIE, Inc.",
        "00:04:3C": "SONOS Co., Ltd.",
        "00:04:B2": "ESSEGI SRL",
        "00:04:B4": "CIAC",
        "00:04:AD": "Malibu Networks",
        "00:04:A9": "SandStream Technologies, Inc.",
        "00:04:61": "EPOX Computer Co., Ltd.",
        "00:04:62": "DAKOS Data & Communication Co., Ltd.",
        "00:04:5F": "Avalue Technology, Inc.",
        "00:04:9C": "Surgient Networks, Inc.",
        "00:04:9D": "Ipanema Technologies",
        "00:04:60": "Knilink Technology, Inc.",
        "00:04:8F": "TD Systems Corporation",
        "00:04:95": "Tejas Networks India Limited",
        "00:04:6F": "Digitel S/A Industria Eletronica",
        "00:04:69": "Innocom, Inc.",
        "00:04:87": "Cogency Semiconductor, Inc.",
        "00:04:68": "Vivity, Inc.",
        "00:03:E1": "Winmate Communication, Inc.",
        "00:03:E4": "Cisco Systems, Inc",
        "00:03:DC": "Lexar Media, Inc.",
        "00:03:D8": "iMPath Networks, Inc.",
        "00:03:D5": "Advanced Communications Co., Ltd.",
        "00:03:F7": "Plast-Control GmbH",
        "00:03:FC": "Intertex Data AB",
        "00:03:EF": "Oneline AG",
        "00:03:F1": "Cicada Semiconductor, Inc.",
        "00:04:30": "Netgem",
        "00:04:2C": "Minet, Inc.",
        "00:04:2A": "Wireless Networks, Inc.",
        "00:04:2B": "IT Access Co., Ltd.",
        "00:03:D6": "RADVision, Ltd.",
        "00:03:D4": "Alloptic, Inc.",
        "00:03:CE": "ETEN Technologies, Inc.",
        "00:03:C8": "CML Emergency Services",
        "00:03:C3": "Micronik Multimedia",
        "00:04:19": "Fibercycle Networks, Inc.",
        "00:04:1C": "ipDialog, Inc.",
        "00:04:18": "Teltronic S.A.U.",
        "00:03:70": "NXTV, Inc.",
        "00:04:02": "Nexsan Technologies, Ltd.",
        "00:03:ED": "Shinkawa Electric Co., Ltd.",
        "00:03:BD": "OmniCluster Technologies, Inc.",
        "00:03:C0": "RFTNC Co., Ltd.",
        "00:03:B8": "NetKit Solutions, LLC",
        "00:03:B7": "ZACCESS Systems",
        "00:03:A0": "Cisco Systems, Inc",
        "00:03:A2": "Catapult Communications",
        "00:03:9C": "OptiMight Communications, Inc.",
        "00:03:B0": "Xsense Technology Corp.",
        "00:03:AA": "Watlow",
        "00:03:A8": "IDOT Computers, Inc.",
        "00:03:55": "TeraBeam Internet Systems",
        "00:03:69": "Nippon Antenna Co., Ltd.",
        "00:03:73": "Aselsan A.S",
        "00:03:77": "Gigabit Wireless",
        "00:03:65": "Kira Information & Communications, Ltd.",
        "00:03:85": "Actelis Networks, Inc.",
        "00:03:54": "Fiber Logic Communications",
        "00:03:50": "BTICINO SPA",
        "00:03:4E": "Pos Data Company, Ltd.",
        "00:03:48": "Norscan Instruments, Ltd.",
        "00:03:46": "Hitachi Kokusai Electric, Inc.",
        "00:03:44": "Tietech.Co., Ltd.",
        "00:02:E6": "Gould Instrument Systems, Inc.",
        "00:02:E4": "JC HYUN Systems, Inc.",
        "00:02:DE": "Astrodesign, Inc.",
        "00:02:E2": "NDC Infared Engineering",
        "00:02:E1": "Integrated Network Corporation",
        "00:02:F7": "ARM",
        "00:D0:24": "Cognex Corporation",
        "00:02:F1": "Pinetron Co., Ltd.",
        "00:02:ED": "DXO Telecom Co., Ltd.",
        "00:02:EC": "Maschoff Design Engineering",
        "00:03:36": "Zetes Technologies",
        "00:03:37": "Vaone, Inc.",
        "00:03:3B": "TAMI Tech Co., Ltd.",
        "00:03:2D": "IBASE Technology, Inc.",
        "00:B0:52": "Atheros Communications",
        "00:03:43": "Martin Professional A/S",
        "00:03:35": "Mirae Technology",
        "00:02:F8": "SEAKR Engineering, Inc.",
        "00:03:14": "Teleware Network Systems",
        "00:03:2F": "Global Sun Technology, Inc.",
        "00:02:DC": "Fujitsu General Limited",
        "00:02:D7": "EMPEG Ltd",
        "00:02:D3": "NetBotz, Inc.",
        "00:02:DA": "ExiO Communications, Inc.",
        "00:02:D4": "PDA Peripherals, Inc.",
        "00:02:D6": "NICE Systems",
        "00:02:7D": "Cisco Systems, Inc",
        "00:02:7C": "Trilithic, Inc.",
        "00:02:8B": "VDSL Systems OY",
        "00:02:8C": "Micrel-Synergy Semiconductor",
        "00:02:8D": "Movita Technologies, Inc.",
        "00:02:98": "Broadframe Corporation",
        "00:02:97": "C-COR.net",
        "00:02:91": "Open Network Co., Ltd.",
        "00:02:C1": "Innovative Electronic Designs, Inc.",
        "00:02:C0": "Bencent Tzeng Industry Co., Ltd.",
        "00:02:99": "Apex, Inc.",
        "00:02:75": "SMART Technologies, Inc.",
        "00:02:C6": "Data Track Technology PLC",
        "00:02:A6": "Effinet Systems Co., Ltd.",
        "00:02:5F": "Nortel Networks",
        "00:02:5C": "SCI Systems (Kunshan) Co., Ltd.",
        "00:00:87": "HITACHI, LTD.",
        "00:02:58": "Flying Packets Communications",
        "00:02:4E": "Datacard Group",
        "00:02:42": "Videoframe Systems",
        "00:02:44": "SURECOM Technology Co.",
        "00:02:3E": "Selta Telematica S.p.a",
        "00:02:41": "Amer.com",
        "00:02:07": "VisionGlobal Network Corp.",
        "00:02:08": "Unify Networks, Inc.",
        "00:02:04": "Bodmann Industries Elektronik GmbH",
        "00:02:29": "Adtec Corporation",
        "00:02:2D": "Agere Systems",
        "00:02:26": "XESystems, Inc.",
        "00:02:25": "One Stop Systems",
        "00:02:11": "Nature Worldwide Technology Corp.",
        "00:02:12": "SierraCom",
        "00:02:17": "Cisco Systems, Inc",
        "00:01:7A": "Chengdu Maipu Electric Industrial Co., Ltd.",
        "00:02:38": "Serome Technology, Inc.",
        "00:02:69": "Nadatel Co., Ltd",
        "00:02:64": "AudioRamp.com",
        "00:02:55": "IBM Corp",
        "00:02:52": "Carrier Corporation",
        "00:02:20": "CANON FINETECH INC.",
        "00:02:0D": "Micronpc.com",
        "00:01:D4": "Leisure Time, Inc.",
        "00:01:DD": "Avail Networks",
        "00:01:D5": "HAEDONG INFO & COMM CO., LTD",
        "00:01:D7": "F5 Networks, Inc.",
        "00:01:DE": "Trango Systems, Inc.",
        "00:01:DC": "Activetelco",
        "00:01:F9": "TeraGlobal Communications Corp.",
        "00:01:FB": "DoTop Technology, Inc.",
        "00:01:F8": "TEXIO TECHNOLOGY CORPORATION",
        "00:01:BE": "Gigalink Co., Ltd.",
        "00:01:B1": "General Bandwidth",
        "00:01:BF": "Teleforce Co., Ltd.",
        "00:01:B4": "Wayport, Inc.",
        "00:01:BA": "IC-Net, Inc.",
        "00:01:CF": "Alpha Data Parallel Systems, Ltd.",
        "00:01:D0": "VitalPoint, Inc.",
        "00:01:B0": "Fulltek Technology Co., Ltd.",
        "00:01:A9": "BMW AG",
        "00:01:AA": "Airspan Communications, Ltd.",
        "00:01:9E": "ESS Technology, Inc.",
        "00:01:7D": "ThermoQuest",
        "00:01:81": "Nortel Networks",
        "00:01:94": "Capital Equipment Corporation",
        "00:01:98": "Darim Vision",
        "00:01:E8": "Force10 Networks, Inc.",
        "00:01:E9": "Litton Marine Systems B.V.",
        "00:01:E5": "Supernet, Inc.",
        "00:01:A2": "Logical Co., Ltd.",
        "00:01:85": "Hitachi Aloka Medical, Ltd.",
        "00:01:C7": "Cisco Systems, Inc",
        "00:01:21": "WatchGuard Technologies, Inc.",
        "00:01:29": "DFI Inc.",
        "00:01:19": "RTUnet (Australia)",
        "00:01:22": "Trend Communications, Ltd.",
        "00:01:1A": "Hoffmann und Burmeister GbR",
        "00:01:0A": "CIS TECHNOLOGY INC.",
        "00:01:67": "HIOKI E.E. CORPORATION",
        "00:01:68": "VITANA CORPORATION",
        "00:01:62": "Cygnet Technologies, Inc.",
        "00:01:54": "G3M Corporation",
        "00:01:52": "CHROMATEK INC.",
        "00:01:50": "GILAT COMMUNICATIONS, LTD.",
        "00:01:51": "Ensemble Communications",
        "00:01:15": "EXTRATECH CORPORATION",
        "00:01:01": "Private",
        "00:01:0D": "Teledyne DALSA Inc.",
        "00:01:05": "Beckhoff Automation GmbH",
        "00:B0:17": "InfoGear Technology Corp.",
        "00:01:2C": "Aravox Technologies, Inc.",
        "00:01:42": "Cisco Systems, Inc",
        "00:01:64": "Cisco Systems, Inc",
        "00:01:5F": "DIGITAL DESIGN GmbH",
        "00:01:2B": "TELENET Co., Ltd.",
        "00:01:3F": "Neighbor World Co., Ltd.",
        "00:01:24": "Acer Incorporated",
        "00:30:88": "Ericsson",
        "00:30:20": "TSI, Inc..",
        "00:30:95": "Procomp Informatics, Ltd.",
        "00:30:CA": "Discovery Com",
        "00:30:CE": "Zaffire",
        "00:30:7B": "Cisco Systems, Inc",
        "00:30:B5": "Tadiran Microwave Networks",
        "00:30:B8": "RiverDelta Networks",
        "00:30:71": "Cisco Systems, Inc",
        "00:30:3A": "MAATEL",
        "00:30:4E": "BUSTEC PRODUCTION LTD.",
        "00:30:A4": "Woodwind Communications System",
        "00:30:3B": "PowerCom Technology",
        "00:30:BC": "Optronic AG",
        "00:B0:2D": "ViaGate Technologies, Inc.",
        "00:30:EE": "DSG Technology, Inc.",
        "00:30:9E": "WORKBIT CORPORATION.",
        "00:30:DE": "WAGO Kontakttechnik GmbH",
        "00:30:3E": "Radcom Ltd.",
        "00:30:D7": "Innovative Systems, L.L.C.",
        "00:B0:CE": "Viveris Technologies",
        "00:B0:1C": "Westport Technologies",
        "00:B0:4A": "Cisco Systems, Inc",
        "00:B0:48": "Marconi Communications Inc.",
        "00:30:1B": "SHUTTLE, INC.",
        "00:30:21": "HSING TECH. ENTERPRISE CO.,LTD",
        "00:30:2C": "SYLANTRO SYSTEMS CORPORATION",
        "00:30:DF": "KB/TEL TELECOMUNICACIONES",
        "00:30:30": "HARMONIX CORPORATION",
        "00:30:63": "SANTERA SYSTEMS, INC.",
        "00:30:A3": "Cisco Systems, Inc",
        "00:30:DD": "INDIGITA CORPORATION",
        "00:30:99": "BOENIG UND KALLENBACH OHG",
        "00:30:F2": "Cisco Systems, Inc",
        "00:30:51": "ORBIT AVIONIC & COMMUNICATION",
        "00:30:8E": "CROSS MATCH TECHNOLOGIES, INC.",
        "00:30:27": "KERBANGO, INC.",
        "00:30:33": "ORIENT TELECOM CO., LTD.",
        "00:30:08": "AVIO DIGITAL, INC.",
        "00:30:1D": "SKYSTREAM, INC.",
        "00:30:BA": "AC&T SYSTEM CO., LTD.",
        "00:30:FD": "INTEGRATED SYSTEMS DESIGN",
        "00:30:B9": "ECTEL",
        "00:30:7D": "GRE AMERICA, INC.",
        "00:30:EF": "NEON TECHNOLOGY, INC.",
        "00:30:96": "Cisco Systems, Inc",
        "00:30:39": "SOFTBOOK PRESS",
        "00:D0:F8": "FUJIAN STAR TERMINAL",
        "00:D0:ED": "XIOX",
        "00:D0:97": "Cisco Systems, Inc",
        "00:D0:8E": "Grass Valley, A Belden Brand",
        "00:D0:56": "SOMAT CORPORATION",
        "00:D0:E0": "DOOIN ELECTRONICS CO.",
        "00:D0:00": "FERRAN SCIENTIFIC, INC.",
        "00:D0:D0": "ZHONGXING TELECOM LTD.",
        "00:D0:53": "CONNECTED SYSTEMS",
        "00:D0:33": "DALIAN DAXIAN NETWORK",
        "00:D0:D6": "AETHRA TELECOMUNICAZIONI",
        "00:D0:63": "Cisco Systems, Inc",
        "00:D0:47": "XN TECHNOLOGIES",
        "00:D0:55": "KATHREIN-WERKE KG",
        "00:D0:3B": "VISION PRODUCTS PTY. LTD.",
        "00:D0:B3": "DRS Technologies Canada Ltd",
        "00:D0:AF": "CUTLER-HAMMER, INC.",
        "00:D0:52": "ASCEND COMMUNICATIONS, INC.",
        "00:D0:AD": "TL INDUSTRIES",
        "00:D0:A4": "ALANTRO COMMUNICATIONS",
        "00:D0:B0": "BITSWITCH LTD.",
        "00:D0:30": "Safetran Systems Corp",
        "00:30:2A": "SOUTHERN INFORMATION",
        "00:30:E1": "Network Equipment Technologies, Inc.",
        "00:30:01": "SMP",
        "00:D0:8B": "ADVA Optical Networking Ltd.",
        "00:D0:E4": "Cisco Systems, Inc",
        "00:D0:5A": "SYMBIONICS, LTD.",
        "00:D0:79": "Cisco Systems, Inc",
        "00:D0:21": "REGENT ELECTRONICS CORP.",
        "00:D0:9F": "NOVTEK TEST SYSTEMS",
        "00:D0:FE": "ASTRAL POINT",
        "00:D0:D4": "V-BITS, INC.",
        "00:D0:84": "NEXCOMM SYSTEMS, INC.",
        "00:D0:99": "Elcard Wireless Systems Oy",
        "00:D0:E7": "VCON TELECOMMUNICATION LTD.",
        "00:D0:1B": "MIMAKI ENGINEERING CO., LTD.",
        "00:D0:0D": "MICROMERITICS INSTRUMENT",
        "00:D0:54": "SAS INSTITUTE INC.",
        "00:D0:09": "HSING TECH. ENTERPRISE CO. LTD",
        "00:D0:F4": "CARINTHIAN TECH INSTITUTE",
        "00:D0:7D": "COSINE COMMUNICATIONS",
        "00:D0:83": "INVERTEX, INC.",
        "00:D0:BA": "Cisco Systems, Inc",
        "00:D0:98": "Photon Dynamics Canada Inc.",
        "00:D0:BE": "EMUTEC INC.",
        "00:D0:92": "GLENAYRE WESTERN MULTIPLEX",
        "00:50:9D": "THE INDUSTREE B.V.",
        "00:D0:B8": "Iomega Corporation",
        "00:50:CB": "JETTER",
        "00:50:58": "Sangoma Technologies",
        "00:50:74": "ADVANCED HI-TECH CORP.",
        "00:50:0A": "IRIS TECHNOLOGIES, INC.",
        "00:50:6D": "VIDEOJET SYSTEMS",
        "00:D0:C7": "PATHWAY, INC.",
        "00:D0:7A": "AMAQUEST COMPUTER CORP.",
        "00:50:3F": "ANCHOR GAMES",
        "00:50:32": "PICAZO COMMUNICATIONS, INC.",
        "00:D0:4A": "PRESENCE TECHNOLOGY GMBH",
        "00:D0:74": "TAQUA SYSTEMS, INC.",
        "00:50:4D": "Tokyo Electron Device Limited",
        "00:50:70": "CHAINTECH COMPUTER CO., LTD.",
        "00:50:23": "PG DESIGN ELECTRONICS, INC.",
        "00:50:9E": "Les Technologies SoftAcoustik Inc.",
        "00:50:71": "AIWA CO., LTD.",
        "00:50:5F": "BRAND INNOVATORS",
        "00:50:B4": "SATCHWELL CONTROL SYSTEMS, LTD",
        "00:50:D6": "ATLAS COPCO TOOLS AB",
        "00:50:82": "FORESSON CORPORATION",
        "00:50:DF": "AirFiber, Inc.",
        "00:50:C5": "ADS Technologies, Inc",
        "00:50:8E": "OPTIMATION, INC.",
        "00:50:28": "AVAL COMMUNICATIONS",
        "00:50:2F": "TollBridge Technologies, Inc.",
        "00:50:FE": "PCTVnet ASA",
        "00:50:AB": "NALTEC, Inc.",
        "00:50:37": "KOGA ELECTRONICS CO.",
        "00:50:A8": "OpenCon Systems, Inc.",
        "00:50:9C": "BETA RESEARCH",
        "00:50:B1": "GIDDINGS & LEWIS",
        "00:50:06": "TAC AB",
        "00:50:09": "PHILIPS BROADBAND NETWORKS",
        "00:50:30": "FUTURE PLUS SYSTEMS",
        "00:50:78": "MEGATON HOUSE, LTD.",
        "00:50:02": "OMNISEC AG",
        "00:50:6A": "EDEVA, INC.",
        "00:50:AA": "KONICA MINOLTA HOLDINGS, INC.",
        "00:50:38": "DAIN TELECOM CO., LTD.",
        "00:50:B7": "BOSER TECHNOLOGY CO., LTD.",
        "00:90:88": "BAXALL SECURITY LTD.",
        "00:90:6C": "Sartorius Hamburg GmbH",
        "00:90:A4": "ALTIGA NETWORKS",
        "00:90:F9": "Imagine Communications",
        "00:90:89": "SOFTCOM MICROSYSTEMS, INC.",
        "00:90:EE": "PERSONAL COMMUNICATIONS TECHNOLOGIES",
        "00:90:80": "NOT LIMITED, INC.",
        "00:90:E8": "MOXA TECHNOLOGIES CORP., LTD.",
        "00:90:A1": "Flying Pig Systems/High End Systems Inc.",
        "00:90:79": "ClearOne, Inc.",
        "00:90:9A": "ONE WORLD SYSTEMS, INC.",
        "00:90:C2": "JK microsystems, Inc.",
        "00:50:D0": "MINERVA SYSTEMS",
        "00:50:D8": "UNICORN COMPUTER CORP.",
        "00:50:B2": "BRODEL GmbH",
        "00:90:76": "FMT AIRCRAFT GATE SUPPORT SYSTEMS AB",
        "00:90:17": "Zypcom, Inc",
        "00:90:49": "ENTRIDIA CORPORATION",
        "00:90:E6": "ALi Corporation",
        "00:90:70": "NEO NETWORKS, INC.",
        "00:90:30": "HONEYWELL-DATING",
        "00:90:08": "HanA Systems Inc.",
        "00:90:AC": "OPTIVISION, INC.",
        "00:90:4E": "DELEM BV",
        "00:90:ED": "CENTRAL SYSTEM RESEARCH CO., LTD.",
        "00:90:1E": "Selesta Ingegneria S.p.A.",
        "00:90:75": "NEC DO BRASIL S.A.",
        "00:90:AD": "ASPECT ELECTRONICS, INC.",
        "00:90:01": "NISHIMU ELECTRONICS INDUSTRIES CO., LTD.",
        "00:90:43": "Tattile SRL ",
        "00:90:CB": "Wireless OnLine, Inc.",
        "00:10:63": "STARGUIDE DIGITAL NETWORKS",
        "00:10:23": "Network Equipment Technologies",
        "00:10:2B": "UMAX DATA SYSTEMS, INC.",
        "00:90:8A": "BAYLY COMMUNICATIONS, INC.",
        "00:90:0E": "HANDLINK TECHNOLOGIES, INC.",
        "00:90:C1": "Peco II, Inc.",
        "00:10:8D": "Johnson Controls, Inc.",
        "00:10:45": "Nortel Networks",
        "00:10:7D": "AURORA COMMUNICATIONS, LTD.",
        "00:90:E4": "NEC AMERICA, INC.",
        "00:90:40": "Siemens Network Convergence LLC",
        "00:90:C8": "WAVERIDER COMMUNICATIONS (CANADA) INC.",
        "00:90:1B": "DIGITAL CONTROLS",
        "00:90:F7": "NBASE COMMUNICATIONS LTD.",
        "00:90:12": "GLOBESPAN SEMICONDUCTOR, INC.",
        "00:90:B7": "DIGITAL LIGHTWAVE, INC.",
        "00:90:A0": "8X8 INC.",
        "00:90:47": "GIGA FAST E. LTD.",
        "00:90:E1": "TELENA S.P.A.",
        "00:90:32": "PELCOMBE GROUP LTD.",
        "00:10:62": "NX SERVER, ILNC.",
        "00:10:F0": "RITTAL-WERK RUDOLF LOH GmbH & Co.",
        "00:10:01": "Citel",
        "00:10:5C": "QUANTUM DESIGNS (H.K.) LTD.",
        "00:10:CF": "FIBERLANE COMMUNICATIONS",
        "00:10:69": "HELIOSS COMMUNICATIONS, INC.",
        "00:10:BF": "InterAir Wireless",
        "00:10:26": "ACCELERATED NETWORKS, INC.",
        "00:10:36": "INTER-TEL INTEGRATED SYSTEMS",
        "00:10:39": "Vectron Systems AG",
        "00:10:B6": "ENTRATA COMMUNICATIONS CORP.",
        "00:10:59": "DIABLO RESEARCH CO. LLC",
        "00:10:FC": "BROADBAND NETWORKS, INC.",
        "00:10:31": "OBJECTIVE COMMUNICATIONS, INC.",
        "00:10:6D": "Axxcelera Broadband Wireless",
        "00:10:4C": "Teledyne LeCroy, Inc",
        "00:10:CC": "CLP COMPUTER LOGISTIK PLANUNG GmbH",
        "00:10:30": "EION Inc.",
        "00:10:D0": "WITCOM, LTD.",
        "00:10:93": "CMS COMPUTERS, LTD.",
        "00:10:8F": "RAPTOR SYSTEMS",
        "00:10:A4": "XIRCOM",
        "00:10:F1": "I-O CORPORATION",
        "00:10:66": "ADVANCED CONTROL SYSTEMS, INC.",
        "00:10:AC": "IMCI TECHNOLOGIES",
        "00:10:B1": "FOR-A CO., LTD.",
        "00:10:EE": "CTI PRODUCTS, INC.",
        "00:10:41": "BRISTOL BABCOCK, INC.",
        "00:10:AA": "MEDIA4, INC.",
        "00:10:E8": "TELOCITY, INCORPORATED",
        "00:10:A2": "TNS",
        "00:10:65": "RADYNE CORPORATION",
        "00:10:9F": "PAVO, INC.",
        "00:10:1D": "WINBOND ELECTRONICS CORP.",
        "00:10:84": "K-BOT COMMUNICATIONS",
        "00:10:00": "CABLE TELEVISION LABORATORIES, INC.",
        "00:10:09": "HORANET",
        "00:10:F8": "TEXIO TECHNOLOGY CORPORATION",
        "00:10:C0": "ARMA, Inc.",
        "00:10:5B": "NET INSIGHT AB",
        "00:10:02": "ACTIA",
        "00:10:EB": "SELSIUS SYSTEMS, INC.",
        "00:10:57": "Rebel.com, Inc.",
        "00:10:F9": "UNIQUE SYSTEMS, INC.",
        "00:10:75": "Segate Technology LLC",
        "00:E0:03": "NOKIA WIRELESS BUSINESS COMMUN",
        "00:E0:F3": "WebSprint Communications, Inc.",
        "08:BB:CC": "AK-NORD EDV VERTRIEBSGES. mbH",
        "00:E0:DB": "ViaVideo Communications, Inc.",
        "00:E0:A6": "TELOGY NETWORKS, INC.",
        "00:E0:9F": "PIXEL VISION",
        "00:E0:CC": "HERO SYSTEMS, LTD.",
        "00:E0:80": "CONTROL RESOURCES CORPORATION",
        "00:E0:04": "PMC-SIERRA, INC.",
        "00:E0:3B": "PROMINET CORPORATION",
        "00:E0:F5": "TELES AG",
        "00:E0:D7": "SUNSHINE ELECTRONICS, INC.",
        "00:E0:B5": "ARDENT COMMUNICATIONS CORP.",
        "00:E0:68": "MERRIMAC SYSTEMS INC.",
        "00:E0:49": "MICROWI ELECTRONIC GmbH",
        "00:E0:95": "ADVANCED-VISION TECHNOLGIES CORP.",
        "00:E0:0E": "AVALON IMAGING SYSTEMS, INC.",
        "00:E0:48": "SDL COMMUNICATIONS, INC.",
        "00:E0:CB": "RESON, INC.",
        "00:E0:C8": "VIRTUAL ACCESS, LTD.",
        "00:E0:06": "SILICON INTEGRATED SYS. CORP.",
        "00:E0:AC": "MIDSCO, INC.",
        "00:E0:08": "AMAZING CONTROLS! INC.",
        "00:E0:AE": "XAQTI CORPORATION",
        "00:E0:E0": "SI ELECTRONICS, LTD.",
        "00:E0:50": "EXECUTONE INFORMATION SYSTEMS, INC.",
        "00:E0:23": "TELRAD",
        "00:E0:2C": "AST COMPUTER",
        "00:E0:67": "eac AUTOMATION-CONSULTING GmbH",
        "00:E0:FA": "TRL TECHNOLOGY, LTD.",
        "00:E0:2A": "TANDBERG TELEVISION AS",
        "00:E0:4E": "SANYO DENKI CO., LTD.",
        "00:E0:12": "PLUTO TECHNOLOGIES INTERNATIONAL INC.",
        "00:E0:4C": "REALTEK SEMICONDUCTOR CORP.",
        "00:E0:51": "TALX CORPORATION",
        "00:60:6B": "Synclayer Inc.",
        "00:60:3B": "AMTEC spa",
        "00:E0:39": "PARADYNE CORP.",
        "00:60:0B": "LOGWARE GmbH",
        "00:E0:C7": "EUROTECH SRL",
        "00:E0:AF": "GENERAL DYNAMICS INFORMATION SYSTEMS",
        "00:E0:54": "KODAI HITEC CO., LTD.",
        "00:E0:B9": "BYAS SYSTEMS",
        "00:60:4B": "Safe-com GmbH & Co. KG",
        "00:E0:EF": "DIONEX",
        "00:E0:2D": "InnoMediaLogic, Inc.",
        "00:E0:35": "Artesyn Embedded Technologies",
        "00:E0:90": "BECKMAN LAB. AUTOMATION DIV.",
        "00:60:01": "InnoSys, Inc.",
        "00:60:FE": "LYNX SYSTEM DEVELOPERS, INC.",
        "00:60:BD": "Enginuity Communications",
        "00:08:00": "MULTITECH SYSTEMS, INC.",
        "00:E0:85": "GLOBAL MAINTECH, INC.",
        "00:E0:BE": "GENROCO INTERNATIONAL, INC.",
        "00:E0:B6": "Entrada Networks",
        "00:E0:F4": "INSIDE Technology A/S",
        "00:E0:A0": "WILTRON CO.",
        "00:E0:F1": "THAT CORPORATION",
        "00:60:D5": "AMADA MIYACHI Co., Ltd",
        "00:60:3F": "PATAPSCO DESIGNS",
        "00:60:B5": "KEBA GmbH",
        "00:60:14": "EDEC CO., LTD.",
        "00:60:AC": "RESILIENCE CORPORATION",
        "00:60:4E": "CYCLE COMPUTER CORPORATION, INC.",
        "00:60:E1": "ORCKIT COMMUNICATIONS LTD.",
        "00:60:D2": "LUCENT TECHNOLOGIES TAIWAN TELECOMMUNICATIONS CO., LTD.",
        "00:60:42": "TKS (USA), INC.",
        "00:60:79": "Mainstream Data, Inc.",
        "00:60:9A": "NJK TECHNO CO.",
        "00:60:2B": "PEAK AUDIO",
        "00:60:F1": "EXP COMPUTER, INC.",
        "00:60:E6": "SHOMITI SYSTEMS INCORPORATED",
        "00:60:FF": "QuVis, Inc.",
        "00:60:67": "ACER NETXUS INC.",
        "00:60:9F": "PHAST CORPORATION",
        "00:60:40": "NETRO CORP.",
        "00:60:CC": "EMTRAK, INCORPORATED",
        "00:60:2C": "LINX Data Terminals, Inc.",
        "00:60:7E": "GIGALABS, INC.",
        "00:60:CD": "VideoServer, Inc.",
        "00:60:AA": "INTELLIGENT DEVICES INC. (IDI)",
        "00:60:25": "ACTIVE IMAGING PLC",
        "00:60:A7": "MICROSENS GmbH & CO. KG",
        "00:05:A8": "WYLE ELECTRONICS",
        "00:60:E5": "FUJI AUTOMATION CO., LTD.",
        "00:60:5E": "LIBERTY TECHNOLOGY NETWORKING",
        "00:60:C6": "DCS AG",
        "00:60:1E": "SOFTLAB, INC.",
        "00:60:5D": "SCANIVALVE CORP.",
        "00:60:6F": "CLARION CORPORATION OF AMERICA",
        "00:A0:10": "SYSLOGIC DATENTECHNIK AG",
        "00:A0:59": "HAMILTON HALLMARK",
        "00:A0:39": "ROSS TECHNOLOGY, INC.",
        "00:A0:AD": "MARCONI SPA",
        "00:A0:D6": "SBE, Inc.",
        "00:A0:2E": "BRAND COMMUNICATIONS, LTD.",
        "00:60:4A": "SAIC IDEAS GROUP",
        "00:A0:BD": "I-TECH CORP.",
        "00:60:90": "Artiza Networks Inc",
        "00:60:0D": "Digital Logic GmbH",
        "00:60:30": "VILLAGE TRONIC ENTWICKLUNG",
        "00:A0:8D": "JACOMO CORPORATION",
        "00:A0:8E": "Check Point Software Technologies",
        "00:A0:FC": "IMAGE SCIENCES, INC.",
        "00:A0:9C": "Xyplex, Inc.",
        "00:A0:0D": "THE PANDA PROJECT",
        "00:A0:E9": "ELECTRONIC RETAILING SYSTEMS INTERNATIONAL",
        "00:A0:BE": "INTEGRATED CIRCUIT SYSTEMS, INC. COMMUNICATIONS GROUP",
        "00:A0:16": "MICROPOLIS CORP.",
        "00:A0:48": "QUESTECH, LTD.",
        "00:A0:03": "Siemens Switzerland Ltd., I B T HVP",
        "00:A0:F9": "BINTEC COMMUNICATIONS GMBH",
        "00:A0:F5": "RADGUARD LTD.",
        "00:A0:CA": "FUJITSU DENSO LTD.",
        "00:A0:22": "CENTRE FOR DEVELOPMENT OF ADVANCED COMPUTING",
        "00:A0:B6": "SANRITZ AUTOMATION CO., LTD.",
        "00:A0:79": "ALPS ELECTRIC (USA), INC.",
        "00:A0:C0": "DIGITAL LINK CORP.",
        "00:A0:1E": "EST CORPORATION",
        "00:A0:AE": "NUCOM SYSTEMS, INC.",
        "00:A0:62": "AES PRODATA",
        "00:A0:76": "CARDWARE LAB, INC.",
        "00:A0:A1": "EPIC DATA INC.",
        "00:A0:44": "NTT IT CO., LTD.",
        "00:A0:11": "MUTOH INDUSTRIES LTD.",
        "00:A0:BA": "PATTON ELECTRONICS CO.",
        "00:A0:B5": "3H TECHNOLOGY",
        "00:A0:4D": "EDA INSTRUMENTS, INC.",
        "00:A0:86": "AMBER WAVE SYSTEMS, INC.",
        "00:A0:AF": "WMS INDUSTRIES",
        "00:A0:57": "LANCOM Systems GmbH",
        "00:A0:30": "CAPTOR NV/SA",
        "00:A0:DE": "YAMAHA CORPORATION",
        "00:A0:84": "Dataplex Pty Ltd",
        "00:A0:49": "DIGITECH INDUSTRIES, INC.",
        "00:A0:9D": "JOHNATHON FREEMAN TECHNOLOGIES",
        "00:A0:6B": "DMS DORSCH MIKROSYSTEM GMBH",
        "00:A0:F8": "Zebra Technologies Inc",
        "00:A0:9F": "COMMVISION CORP.",
        "00:A0:6E": "AUSTRON, INC.",
        "00:20:22": "NMS Communications",
        "00:20:AE": "ORNET DATA COMMUNICATION TECH.",
        "00:20:AA": "Ericsson Television Limited",
        "00:20:A4": "MULTIPOINT NETWORKS",
        "00:02:67": "NODE RUNNER, INC.",
        "00:20:B1": "COMTECH RESEARCH INC.",
        "00:20:32": "ALCATEL TAISEL",
        "00:20:E9": "DANTEL",
        "00:20:38": "VME MICROSYSTEMS INTERNATIONAL CORPORATION",
        "00:20:A3": "Harmonic, Inc",
        "00:20:59": "MIRO COMPUTER PRODUCTS AG",
        "00:20:34": "ROTEC INDUSTRIEAUTOMATION GMBH",
        "00:20:79": "MIKRON GMBH",
        "00:20:05": "SIMPLE TECHNOLOGY",
        "00:20:18": "CIS TECHNOLOGY INC.",
        "00:20:98": "HECTRONIC AB",
        "00:20:FD": "ITV TECHNOLOGIES, INC.",
        "00:20:FA": "GDE SYSTEMS, INC.",
        "00:20:C1": "SAXA, Inc.",
        "00:20:80": "SYNERGY (UK) LTD.",
        "00:C0:23": "TUTANKHAMON ELECTRONICS",
        "00:C0:8B": "RISQ MODULAR SYSTEMS, INC.",
        "00:20:C4": "INET,INC.",
        "00:20:74": "SUNGWOON SYSTEMS",
        "00:20:3C": "EUROTIME AB",
        "00:20:28": "WEST EGG SYSTEMS, INC.",
        "00:20:68": "ISDYNE",
        "00:20:C8": "LARSCOM INCORPORATED",
        "00:20:9D": "LIPPERT AUTOMATIONSTECHNIK",
        "00:20:9C": "PRIMARY ACCESS CORP.",
        "00:20:6D": "DATA RACE, INC.",
        "00:20:3A": "DIGITAL BI0METRICS INC.",
        "00:20:48": "Marconi Communications",
        "00:20:DC": "DENSITRON TAIWAN LTD.",
        "00:20:0C": "ADASTRA SYSTEMS CORP.",
        "00:20:11": "CANOPUS CO., LTD.",
        "00:20:51": "Verilink Corporation",
        "00:20:3B": "WISDM LTD.",
        "00:20:BA": "CENTER FOR HIGH PERFORMANCE",
        "00:20:F5": "PANDATEL AG",
        "00:20:0E": "NSSLGlobal Technologies AS",
        "00:20:E7": "B&W NUCLEAR SERVICE COMPANY",
        "00:20:F0": "UNIVERSAL MICROELECTRONICS CO.",
        "00:20:89": "T3PLUS NETWORKING, INC.",
        "00:20:61": "GarrettCom, Inc.",
        "00:C0:80": "NETSTAR, INC.",
        "00:C0:B4": "MYSON TECHNOLOGY, INC.",
        "00:C0:45": "ISOLATION SYSTEMS, LTD.",
        "00:70:B3": "DATA RECALL LTD.",
        "00:70:B0": "M/A-COM INC. COMPANIES",
        "00:E6:D3": "NIXDORF COMPUTER CORP.",
        "00:C0:C3": "ACUSON COMPUTED SONOGRAPHY",
        "00:C0:B3": "COMSTAT DATACOMM CORPORATION",
        "00:C0:E5": "GESPAC, S.A.",
        "00:C0:4D": "MITEC, INC.",
        "00:C0:47": "UNIMICRO SYSTEMS, INC.",
        "00:C0:84": "DATA LINK CORP. LTD.",
        "00:C0:41": "DIGITAL TRANSMISSION SYSTEMS",
        "00:C0:1F": "S.E.R.C.E.L.",
        "00:60:86": "LOGIC REPLACEMENT TECH. LTD.",
        "00:C0:59": "DENSO CORPORATION",
        "00:C0:F1": "SHINKO ELECTRIC CO., LTD.",
        "00:C0:A1": "TOKYO DENSHI SEKEI CO.",
        "00:C0:2E": "NETWIZ",
        "00:C0:0D": "ADVANCED LOGIC RESEARCH, INC.",
        "00:C0:81": "METRODATA LTD.",
        "00:C0:3B": "MULTIACCESS COMPUTING CORP.",
        "00:C0:82": "MOORE PRODUCTS CO.",
        "00:C0:99": "YOSHIKI INDUSTRIAL CO.,LTD.",
        "00:C0:01": "DIATEK PATIENT MANAGMENT",
        "00:C0:F4": "INTERLINK SYSTEM CO., LTD.",
        "00:C0:E2": "CALCOMP, INC.",
        "00:C0:7B": "ASCEND COMMUNICATIONS, INC.",
        "00:C0:3C": "TOWER TECH S.R.L.",
        "00:C0:1D": "GRAND JUNCTION NETWORKS, INC.",
        "00:C0:35": "QUINTAR COMPANY",
        "00:C0:70": "SECTRA SECURE-TRANSMISSION AB",
        "00:C0:6D": "BOCA RESEARCH, INC.",
        "00:C0:EA": "ARRAY TECHNOLOGY LTD.",
        "00:C0:09": "KT TECHNOLOGY (S) PTE LTD",
        "00:C0:D6": "J1 SYSTEMS, INC.",
        "00:C0:DC": "EOS TECHNOLOGIES, INC.",
        "00:C0:72": "KNX LTD.",
        "00:C0:AE": "TOWERCOM CO. INC. DBA PC HOUSE",
        "00:C0:C2": "INFINITE NETWORKS LTD.",
        "00:C0:AF": "TEKLOGIX INC.",
        "00:C0:7A": "PRIVA B.V.",
        "00:C0:F6": "CELAN TECHNOLOGY INC.",
        "00:C0:F8": "ABOUT COMPUTING INC.",
        "00:C0:78": "COMPUTER SYSTEMS ENGINEERING",
        "00:C0:9A": "PHOTONICS CORPORATION",
        "00:C0:1A": "COROMETRICS MEDICAL SYSTEMS",
        "00:C0:68": "HME Clear-Com LTD.",
        "00:C0:D8": "UNIVERSAL DATA SYSTEMS",
        "00:40:16": "ADC - Global Connectivity Solutions Division",
        "00:40:6A": "KENTEK INFORMATION SYSTEMS,INC",
        "00:40:0A": "PIVOTAL TECHNOLOGIES, INC.",
        "00:40:99": "NEWGEN SYSTEMS CORP.",
        "00:40:11": "ANDOVER CONTROLS CORPORATION",
        "00:40:A1": "ERGO COMPUTING",
        "00:40:81": "MANNESMANN SCANGRAPHIC GMBH",
        "00:C0:8C": "PERFORMANCE TECHNOLOGIES, INC.",
        "00:C0:07": "PINNACLE DATA SYSTEMS, INC.",
        "00:C0:98": "CHUNTEX ELECTRONIC CO., LTD.",
        "00:C0:BE": "ALCATEL - SEL",
        "00:C0:6E": "HAFT TECHNOLOGY, INC.",
        "00:C0:8A": "Lauterbach GmbH",
        "00:C0:F7": "ENGAGE COMMUNICATION, INC.",
        "00:40:B7": "STEALTH COMPUTER SYSTEMS",
        "00:40:AC": "SUPER WORKSTATION, INC.",
        "10:00:5A": "IBM Corp",
        "00:40:D1": "FUKUDA DENSHI CO., LTD.",
        "00:40:69": "LEMCOM SYSTEMS, INC.",
        "00:40:3B": "SYNERJET INTERNATIONAL CORP.",
        "00:80:3B": "APT COMMUNICATIONS, INC.",
        "00:80:6A": "ERI (EMPAC RESEARCH INC.)",
        "00:C0:A8": "GVC CORPORATION",
        "00:40:E0": "ATOMWIDE LTD.",
        "00:40:A8": "IMF INTERNATIONAL LTD.",
        "00:40:70": "INTERWARE CO., LTD.",
        "00:40:8A": "TPS TELEPROCESSING SYS. GMBH",
        "00:40:FD": "LXE",
        "00:40:3F": "SSANGYONG COMPUTER SYSTEMS",
        "00:40:82": "LABORATORY EQUIPMENT CORP.",
        "00:40:F1": "CHUO ELECTRONICS CO., LTD.",
        "00:40:A9": "DATACOM INC.",
        "00:40:E3": "QUIN SYSTEMS LTD",
        "00:40:91": "PROCOMP INDUSTRIA ELETRONICA",
        "00:40:EA": "PLAIN TREE SYSTEMS INC",
        "00:40:A7": "ITAUTEC PHILCO S.A.",
        "00:40:64": "KLA INSTRUMENTS CORPORATION",
        "00:40:43": "Nokia Siemens Networks GmbH & Co. KG.",
        "00:40:5A": "GOLDSTAR INFORMATION & COMM.",
        "00:40:13": "NTT DATA COMM. SYSTEMS CORP.",
        "00:40:0C": "GENERAL MICRO SYSTEMS, INC.",
        "00:40:5E": "NORTH HILLS ISRAEL",
        "00:40:FA": "MICROBOARDS, INC.",
        "00:40:14": "COMSOFT GMBH",
        "00:40:00": "PCI COMPONENTES DA AMZONIA LTD",
        "00:40:6C": "COPERNIQUE",
        "00:40:75": "Tattile SRL ",
        "00:40:53": "AMPRO COMPUTERS",
        "00:80:38": "DATA RESEARCH & APPLICATIONS",
        "00:80:5E": "LSI LOGIC CORPORATION",
        "00:80:60": "NETWORK INTERFACE CORPORATION",
        "00:80:C3": "BICC INFORMATION SYSTEMS & SVC",
        "00:80:44": "SYSTECH COMPUTER CORP.",
        "00:80:06": "COMPUADD CORPORATION",
        "00:80:9B": "JUSTSYSTEM CORPORATION",
        "00:80:DF": "ADC CODENOLL TECHNOLOGY CORP.",
        "00:80:28": "TRADPOST (HK) LTD",
        "00:80:61": "LITTON SYSTEMS, INC.",
        "00:80:F5": "Quantel Ltd",
        "00:80:B9": "ARCHE TECHNOLIGIES INC.",
        "00:40:63": "VIA TECHNOLOGIES, INC.",
        "00:80:8A": "SUMMIT MICROSYSTEMS CORP.",
        "00:80:A7": "Honeywell International Inc",
        "00:80:66": "ARCOM CONTROL SYSTEMS, LTD.",
        "00:80:CB": "FALCO DATA PRODUCTS",
        "00:80:07": "DLOG NC-SYSTEME",
        "00:80:62": "INTERFACE  CO.",
        "00:80:1E": "XINETRON, INC.",
        "00:80:E2": "T.D.I. CO., LTD.",
        "00:80:49": "NISSIN ELECTRIC CO., LTD.",
        "00:80:C1": "LANEX CORPORATION",
        "00:80:A3": "Lantronix",
        "00:80:BC": "HITACHI ENGINEERING CO., LTD",
        "00:80:36": "REFLEX MANUFACTURING SYSTEMS",
        "00:80:83": "AMDAHL",
        "00:80:B8": "DMG MORI B.U.G. CO., LTD.",
        "00:80:4D": "CYCLONE MICROSYSTEMS, INC.",
        "00:80:D4": "CHASE RESEARCH LTD.",
        "00:80:3D": "SURIGIKEN CO.,  LTD.",
        "00:80:8B": "DACOLL LIMITED",
        "00:80:B2": "NETWORK EQUIPMENT TECHNOLOGIES",
        "00:80:76": "MCNC",
        "00:80:0B": "CSK CORPORATION",
        "00:80:18": "KOBE STEEL, LTD.",
        "00:80:68": "YAMATECH SCIENTIFIC LTD.",
        "00:80:A8": "VITACOM CORPORATION",
        "00:80:33": "EMS Aviation, Inc.",
        "00:80:7C": "FIBERCOM, INC.",
        "00:80:91": "TOKYO ELECTRIC CO.,LTD",
        "00:00:8E": "SOLBOURNE COMPUTER, INC.",
        "00:00:DC": "HAYES MICROCOMPUTER PRODUCTS",
        "00:00:63": "BARCO CONTROL ROOMS GMBH",
        "00:00:4E": "AMPEX CORPORATION",
        "00:00:2E": "SOCIETE EVIRA",
        "00:00:3F": "SYNTREX, INC.",
        "00:80:9D": "Commscraft Ltd.",
        "00:80:F4": "TELEMECANIQUE ELECTRIQUE",
        "00:80:22": "SCAN-OPTICS",
        "00:00:CD": "Allied Telesis Labs Ltd",
        "00:80:DD": "GMX INC/GIMIX",
        "00:80:FB": "BVM LIMITED",
        "00:80:B4": "SOPHIA SYSTEMS",
        "00:80:7F": "DY-4 INCORPORATED",
        "00:80:2D": "XYLOGICS INC",
        "00:00:61": "GATEWAY COMMUNICATIONS",
        "00:00:EA": "UPNOD AB",
        "00:00:43": "MICRO TECHNOLOGY",
        "00:00:17": "Oracle",
        "00:00:B2": "TELEVIDEO SYSTEMS, INC.",
        "00:00:EE": "NETWORK DESIGNERS, LTD.",
        "00:00:E5": "SIGMEX LTD.",
        "00:00:89": "CAYMAN SYSTEMS INC.",
        "00:00:FF": "CAMTEC ELECTRONICS LTD.",
        "00:00:B7": "DOVE COMPUTER CORPORATION",
        "00:00:F2": "SPIDER COMMUNICATIONS",
        "00:00:CC": "DENSAN CO., LTD.",
        "00:00:A4": "ACORN COMPUTERS LIMITED",
        "00:00:DB": "British Telecommunications plc",
        "00:00:C1": "Madge Ltd.",
        "00:00:F6": "APPLIED MICROSYSTEMS CORP.",
        "00:00:77": "INTERPHASE CORPORATION",
        "00:00:A2": "Bay Networks",
        "00:00:EC": "MICROPROCESS",
        "00:00:C2": "INFORMATION PRESENTATION TECH.",
        "00:00:FC": "MEIKO",
        "00:00:6D": "CRAY COMMUNICATIONS, LTD.",
        "00:00:DA": "ATEX",
        "00:00:DD": "TCL INCORPORATED",
        "00:00:AE": "DASSAULT ELECTRONIQUE",
        "00:00:A0": "SANYO Electric Co., Ltd.",
        "00:00:C0": "WESTERN DIGITAL CORPORATION",
        "00:00:33": "EGAN MACHINERY COMPANY",
        "00:00:9D": "LOCUS COMPUTING CORPORATION",
        "00:00:FD": "HIGH LEVEL HARDWARE",
        "00:00:65": "Network General Corporation",
        "00:00:11": "NORMEREL SYSTEMES",
        "00:00:10": "SYTEK INC.",
        "00:00:BC": "Rockwell Automation",
        "08:00:7E": "AMALGAMATED WIRELESS(AUS) LTD",
        "08:00:7F": "CARNEGIE-MELLON UNIVERSITY",
        "00:00:99": "MTX, INC.",
        "00:00:C4": "WATERS DIV. OF MILLIPORE",
        "00:00:EB": "MATSUSHITA COMM. IND. CO. LTD.",
        "00:00:28": "PRODIGY SYSTEMS CORPORATION",
        "08:00:3B": "TORUS SYSTEMS LIMITED",
        "08:00:3C": "SCHLUMBERGER WELL SERVICES",
        "08:00:34": "FILENET CORPORATION",
        "08:00:36": "INTERGRAPH CORPORATION",
        "08:00:33": "BAUSCH & LOMB",
        "08:00:48": "EUROTHERM GAUGING SYSTEMS",
        "08:00:43": "PIXEL COMPUTER INC.",
        "08:00:45": "CONCURRENT COMPUTER CORP.",
        "08:00:78": "ACCELL CORPORATION",
        "08:00:6D": "WHITECHAPEL COMPUTER WORKS",
        "08:00:30": "CERN",
        "08:00:31": "LITTLE MACHINES INC.",
        "08:00:2E": "METAPHOR COMPUTER SYSTEMS",
        "08:00:56": "STANFORD LINEAR ACCEL. CENTER",
        "08:00:4F": "CYGNET SYSTEMS",
        "08:00:50": "DAISY SYSTEMS CORP.",
        "08:00:5E": "COUNTERPOINT COMPUTER INC.",
        "08:00:76": "PC LAN TECHNOLOGIES",
        "08:00:75": "DANSK DATA ELECTRONIK",
        "08:00:2B": "DIGITAL EQUIPMENT CORPORATION",
        "08:00:29": "Megatek Corporation",
        "02:70:B0": "M/A-COM INC. COMPANIES",
        "00:00:53": "COMPUCORP",
        "08:00:90": "SONOMA SYSTEMS",
        "08:00:0A": "NESTAR SYSTEMS INCORPORATED",
        "00:80:0F": "STANDARD MICROSYSTEMS",
        "00:40:6B": "SYSGEN",
        "08:00:0F": "MITEL CORPORATION",
        "08:00:23": "Panasonic Communications Co., Ltd.",
        "B0:4F:C3": "Shenzhen NVC Cloud Technology Co., Ltd.",
        "08:00:1C": "KDD-KOKUSAI DEBNSIN DENWA CO.",
        "00:DD:0C": "UNGERMANN-BASS INC.",
        "08:00:18": "PIRELLI FOCOM NETWORKS",
        "00:00:A6": "NETWORK GENERAL CORPORATION",
        "00:BB:F0": "UNGERMANN-BASS INC.",
        "00:40:8E": "Tattile SRL ",
        "00:00:04": "XEROX CORPORATION",
        "00:DD:0E": "UNGERMANN-BASS INC.",
        "88:57:1D": "Seongji Industry Company",
        "7C:F3:1B": "LG Electronics (Mobile Communications)",
        "00:01:C8": "CONRAD CORP.",
        "CC:EF:03": "Hunan Keyshare Communication Technology Co., Ltd.",
        "10:2F:A3": "Shenzhen Uvision-tech Technology Co.Ltd",
        "70:48:F7": "Nintendo Co.,Ltd",
        "18:E1:CA": "wanze",
        "EC:BE:DD": "Sagemcom Broadband SAS",
        "00:C0:B6": "HVE, Inc. ",
        "30:91:76": "Skyworth Digital Technology(Shenzhen) Co.,Ltd",
        "78:C8:81": "Sony Interactive Entertainment Inc.",
        "D4:4F:68": "Eidetic Communications Inc",
        "74:9E:A5": "OHSUNG",
        "8C:C8:4B": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "0C:2F:B0": "Samsung Electronics Co.,Ltd",
        "B4:02:16": "Cisco Systems, Inc",
        "54:A4:93": "IEEE Registration Authority",
        "6C:1C:71": "Zhejiang Dahua Technology Co., Ltd.",
        "CC:6A:10": "The Chamberlain Group, Inc",
        "F0:3F:95": "HUAWEI TECHNOLOGIES CO.,LTD",
        "18:56:44": "HUAWEI TECHNOLOGIES CO.,LTD",
        "9C:69:D1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "18:5A:58": "Dell Inc.",
        "C4:3A:35": "FN-LINK TECHNOLOGY LIMITED",
        "04:D1:6E": "IEEE Registration Authority",
        "04:0E:3C": "HP Inc.",
        "C4:E0:DE": "Zhengzhou XindaJiean Information Technology Co.,Ltd.",
        "90:1A:4F": "EM Microelectronic",
        "C8:4F:0E": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "6C:D2:BA": "zte corporation",
        "30:3A:BA": "Guangzhou BaoLun Electronics Co., Ltd",
        "D8:8A:DC": "Huawei Device Co., Ltd.",
        "10:E9:53": "Huawei Device Co., Ltd.",
        "7C:48:B2": "Vida Resources Lte Ltd",
        "2C:AB:33": "Texas Instruments",
        "B8:87:C6": "Prudential Technology co.,LTD",
        "EC:9C:32": "Sichuan AI-Link Technology Co., Ltd.",
        "4C:AD:A8": "PANOPTICS CORP.",
        "FC:1C:A1": "Nokia",
        "E8:D0:3C": "Shenzhen Jingxun Software Telecommunication Technology Co.,Ltd",
        "1C:1A:DF": "Microsoft Corporation",
        "D4:F5:47": "Google, Inc.",
        "98:1B:B5": "ASSA ABLOY Korea Co., Ltd iRevo",
        "34:CB:1A": "Procter & Gamble Company",
        "F0:B1:07": "Ericsson AB",
        "78:4F:9B": "Juniper Networks",
        "78:3A:6C": "TECNO MOBILE LIMITED",
        "E0:40:07": "Huawei Device Co., Ltd.",
        "38:3F:B3": "Technicolor CH USA Inc.",
        "70:CE:8C": "Samsung Electronics Co.,Ltd",
        "40:70:F5": "Apple, Inc.",
        "B0:35:B5": "Apple, Inc.",
        "90:AF:D1": "netKTI Co., Ltd",
        "80:0C:67": "Apple, Inc.",
        "90:81:2A": "Apple, Inc.",
        "78:17:BE": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F0:72:EA": "Google, Inc.",
        "B8:7B:C5": "Apple, Inc.",
        "F0:51:36": "TCT mobile ltd",
        "B8:C9:B5": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "88:AC:C0": "Zyxel Communications Corporation",
        "90:FD:73": "zte corporation",
        "1C:1E:38": "PCCW Global, Inc.",
        "3C:41:0E": "Cisco Systems, Inc",
        "88:D9:8F": "Juniper Networks",
        "00:45:E2": "CyberTAN Technology Inc.",
        "00:69:67": "IEEE Registration Authority",
        "F8:6F:DE": "Shenzhen Goodix Technology Co.,Ltd.",
        "64:66:24": "Sagemcom Broadband SAS",
        "B0:F5:30": "Hitron Technologies. Inc",
        "74:0A:E1": "Huawei Device Co., Ltd.",
        "B4:A8:98": "Huawei Device Co., Ltd.",
        "0C:E4:A0": "Huawei Device Co., Ltd.",
        "BC:1A:E4": "Huawei Device Co., Ltd.",
        "04:3F:72": "Mellanox Technologies, Inc.",
        "1C:4D:66": "Amazon Technologies Inc.",
        "50:2C:C6": "GREE ELECTRIC APPLIANCES, INC. OF ZHUHAI",
        "F4:FE:FB": "Samsung Electronics Co.,Ltd",
        "98:49:14": "Wistron Neweb Corporation",
        "0C:EE:99": "Amazon Technologies Inc.",
        "00:11:7E": "Midmark Corp",
        "D0:28:BA": "Realme Chongqing MobileTelecommunications Corp Ltd",
        "A4:28:B7": "Yangtze Memory Technologies Co., Ltd.",
        "94:92:D2": "KCF Technologies, Inc.",
        "E4:A8:DF": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "8C:53:C3": "Beijing Xiaomi Mobile Software Co., Ltd",
        "70:2F:35": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C0:14:B8": "Nokia",
        "00:76:3D": "Veea",
        "30:93:BC": "Sagemcom Broadband SAS",
        "FC:F5:C4": "Espressif Inc.",
        "54:CE:69": "Hikari Trading Co.,Ltd.",
        "6C:C6:3B": "Taicang T&W Electronics",
        "58:8E:81": "Silicon Laboratories",
        "48:B0:2D": "NVIDIA Corporation",
        "4C:E1:76": "Cisco Systems, Inc",
        "6C:AE:F6": "eero inc.",
        "FC:8E:6E": "StreamCCTV, LLC",
        "E0:2A:E6": "Fiberhome Telecommunication Technologies Co.,LTD",
        "64:12:36": "Technicolor CH USA Inc.",
        "78:8B:2A": "Zhen Shi Information Technology (Shanghai) Co., Ltd.",
        "AC:64:CF": "FN-LINK TECHNOLOGY LIMITED",
        "F0:67:28": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "9C:E1:76": "Cisco Systems, Inc",
        "10:29:59": "Apple, Inc.",
        "E4:76:84": "Apple, Inc.",
        "B4:1A:1D": "Samsung Electronics Co.,Ltd",
        "F0:5C:D5": "Apple, Inc.",
        "3C:DA:6D": "Tiandy Technologies CO.,LTD",
        "F8:0D:F0": "zte corporation",
        "9C:E9:1C": "zte corporation",
        "5C:17:CF": "OnePlus Technology (Shenzhen) Co., Ltd",
        "A4:FA:76": "New H3C Technologies Co., Ltd",
        "70:EA:5A": "Apple, Inc.",
        "3C:FA:D3": "IEEE Registration Authority",
        "8C:60:78": "Swissbit AG",
        "00:DD:25": "Shenzhen hechengdong Technology Co., Ltd",
        "80:20:E1": "BVBA DPTechnics",
        "04:45:A1": "NIRIT- Xinwei  Telecom Technology Co., Ltd.",
        "8C:97:EA": "FREEBOX SAS",
        "30:AB:6A": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "74:9B:E8": "Hitron Technologies. Inc",
        "5C:BA:EF": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "4C:63:71": "Xiaomi Communications Co Ltd",
        "D8:4D:B9": "Wu Qi Technologies,Inc.",
        "A0:4F:85": "LG Electronics (Mobile Communications)",
        "D8:07:B6": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "64:6E:97": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "78:50:7C": "Juniper Networks",
        "00:12:58": "TechVoIP Sp z o.o.",
        "6C:16:32": "HUAWEI TECHNOLOGIES CO.,LTD",
        "2C:1A:01": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:78:39": "zte corporation",
        "24:16:9D": "Cisco Systems, Inc",
        "F4:19:E2": "Volterra",
        "4C:A0:03": "VITEC",
        "64:F2:FB": "Hangzhou Ezviz Software Co.,Ltd.",
        "30:80:9B": "New H3C Technologies Co., Ltd",
        "74:22:BB": "Huawei Device Co., Ltd.",
        "6C:0D:34": "Nokia",
        "4C:45:76": "China Mobile(Hangzhou) Information Technology Co.,Ltd.",
        "B4:40:A4": "Apple, Inc.",
        "48:B8:A3": "Apple, Inc.",
        "F4:DB:E3": "Apple, Inc.",
        "F0:7C:C7": "Juniper Networks",
        "D4:5E:EC": "Beijing Xiaomi Electronics Co., Ltd.",
        "74:C9:29": "Zhejiang Dahua Technology Co., Ltd.",
        "D4:CF:F9": "Shenzhen SEI Robotics Co.,Ltd",
        "5C:B2:9E": "ASCO Power Technologies",
        "9C:C9:EB": "NETGEAR",
        "94:CC:04": "IEEE Registration Authority",
        "90:EC:77": "silicom",
        "88:C3:97": "Beijing Xiaomi Mobile Software Co., Ltd",
        "F0:F6:C1": "Sonos, Inc.",
        "60:68:4E": "Samsung Electronics Co.,Ltd",
        "80:20:FD": "Samsung Electronics Co.,Ltd",
        "B4:CE:40": "Samsung Electronics Co.,Ltd",
        "54:03:84": "Hongkong Nano IC Technologies Co., Ltd",
        "04:BD:BF": "Samsung Electronics Co.,Ltd",
        "BC:7A:BF": "Samsung Electronics Co.,Ltd",
        "B4:09:31": "HUAWEI TECHNOLOGIES CO.,LTD",
        "94:E7:EA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "94:E4:BA": "Huawei Device Co., Ltd.",
        "34:71:46": "Huawei Device Co., Ltd.",
        "2C:C5:46": "Huawei Device Co., Ltd.",
        "0C:83:9A": "Huawei Device Co., Ltd.",
        "E0:E0:FC": "Huawei Device Co., Ltd.",
        "30:50:75": "GN Audio A/S",
        "F4:B7:8D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A4:16:E7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:B9:B0": "Intracom Asia Co., Ltd",
        "0C:35:FE": "Fiberhome Telecommunication Technologies Co.,LTD",
        "8C:83:DF": "Nokia",
        "AC:4B:1E": "Integri-Sys.Com LLC",
        "B0:E4:D5": "Google, Inc.",
        "68:69:CA": "Hitachi, Ltd.",
        "AC:4A:56": "Cisco Systems, Inc",
        "F4:EA:B5": "Extreme Networks, Inc.",
        "00:19:77": "Extreme Networks, Inc.",
        "08:EA:44": "Extreme Networks, Inc.",
        "B0:B5:C3": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "70:4A:0E": "AMPAK Technology,Inc.",
        "08:30:6B": "Palo Alto Networks",
        "00:86:9C": "Palo Alto Networks",
        "4C:B9:11": "Raisecom Technology CO.,LTD",
        "40:47:6A": "Astro Gaming",
        "4C:CE:2D": "Danlaw Inc",
        "30:B2:37": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "BC:5A:56": "Cisco Systems, Inc",
        "B8:7C:F2": "Extreme Networks, Inc.",
        "88:2B:94": "MADOKA SYSTEM Co.,Ltd.",
        "7C:EF:61": "STR Elektronik Josef Schlechtinger GmbH",
        "64:A9:65": "Linkflow Co., Ltd.",
        "24:62:CE": "Aruba, a Hewlett Packard Enterprise Company",
        "68:E2:09": "HUAWEI TECHNOLOGIES CO.,LTD",
        "40:05:89": "T-Mobile, USA",
        "C0:9B:F4": "IEEE Registration Authority",
        "F4:30:8B": "Xiaomi Communications Co Ltd",
        "DC:6B:12": "worldcns inc.",
        "70:03:9F": "Espressif Inc.",
        "A0:DE:0F": "Huawei Device Co., Ltd.",
        "F4:87:C5": "Huawei Device Co., Ltd.",
        "08:00:88": "Brocade Communications Systems LLC",
        "00:01:0F": "Brocade Communications Systems LLC",
        "08:B0:55": "ASKEY COMPUTER CORP",
        "04:5F:B9": "Cisco Systems, Inc",
        "CC:4E:24": "Brocade Communications Systems LLC",
        "00:E0:52": "Brocade Communications Systems LLC",
        "98:DF:82": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "3C:F6:52": "zte corporation",
        "5C:0F:FB": "Amino Communications Ltd",
        "74:58:F3": "Amazon Technologies Inc.",
        "00:06:31": "Calix Inc.",
        "A8:05:77": "Netlist, Inc.",
        "E4:3A:65": "MofiNetwork Inc",
        "08:AA:55": "Motorola Mobility LLC, a Lenovo Company",
        "54:21:9D": "Samsung Electronics Co.,Ltd",
        "C8:8B:E8": "Masimo Corporation",
        "F0:41:C6": "Heat Tech Company, Ltd.",
        "40:40:28": "ZIV",
        "F8:6C:03": "Shenzhen Teleone Technology Co., Ltd",
        "D8:71:4D": "Texas Instruments",
        "0C:EC:80": "Texas Instruments",
        "10:5D:DC": "Huawei Device Co., Ltd.",
        "DC:73:85": "Huawei Device Co., Ltd.",
        "54:55:D5": "Huawei Device Co., Ltd.",
        "00:15:D2": "Xantech Corporation",
        "00:1F:40": "Speakercraft Inc.",
        "18:45:93": "Taicang T&W Electronics",
        "CC:9E:CA": "HMD Global Oy",
        "3C:30:6F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:EA:E7": "Shanghai High-Flying Electronics  Technology Co., Ltd",
        "D4:AB:CD": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "80:E1:BF": "HUAWEI TECHNOLOGIES CO.,LTD",
        "48:2C:D0": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:19:32": "Gude Systems GmbH",
        "A0:CA:A5": "INTELLIGENCE TECHNOLOGY OF CEC CO., LTD",
        "5C:5F:67": "Intel Corporate",
        "0C:54:15": "Intel Corporate",
        "30:24:32": "Intel Corporate",
        "DC:8B:28": "Intel Corporate",
        "1C:1B:B5": "Intel Corporate",
        "F8:34:41": "Intel Corporate",
        "E4:70:B8": "Intel Corporate",
        "E0:0E:E4": "DWnet Technologies(Suzhou) Corporation",
        "E8:85:4B": "Apple, Inc.",
        "28:EC:95": "Apple, Inc.",
        "58:FD:B1": "LG Electronics",
        "E0:2B:96": "Apple, Inc.",
        "A8:46:9D": "Cisco Meraki",
        "6C:DE:A9": "Cisco Meraki",
        "8C:CE:FD": "Shenzhen zhouhai technology co.,LTD",
        "50:FB:19": "CHIPSEA TECHNOLOGIES (SHENZHEN) CORP.",
        "D0:AB:D5": "Intel Corporate",
        "68:17:29": "Intel Corporate",
        "B8:08:CF": "Intel Corporate",
        "DC:71:96": "Intel Corporate",
        "50:E0:85": "Intel Corporate",
        "94:08:C7": "Huawei Device Co., Ltd.",
        "C8:CA:63": "Huawei Device Co., Ltd.",
        "98:3B:8F": "Intel Corporate",
        "D0:C6:37": "Intel Corporate",
        "04:EA:56": "Intel Corporate",
        "D4:3B:04": "Intel Corporate",
        "38:68:93": "Intel Corporate",
        "D8:3B:BF": "Intel Corporate",
        "14:F6:D8": "Intel Corporate",
        "E0:D4:E8": "Intel Corporate",
        "94:E6:F7": "Intel Corporate",
        "4C:1D:96": "Intel Corporate",
        "70:3A:A6": "New H3C Technologies Co., Ltd",
        "94:37:F7": "Huawei Device Co., Ltd.",
        "04:6C:59": "Intel Corporate",
        "90:3F:EA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "20:AB:48": "HUAWEI TECHNOLOGIES CO.,LTD",
        "CC:D7:3C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D4:40:D0": "OCOSMOS Co., LTD",
        "94:E7:0B": "Intel Corporate",
        "00:1E:E0": "Urmet SpA",
        "DC:D9:AE": "Nokia Shanghai Bell Co., Ltd.",
        "98:B8:BC": "Samsung Electronics Co.,Ltd",
        "18:4E:16": "Samsung Electronics Co.,Ltd",
        "C0:3D:03": "Samsung Electronics Co.,Ltd",
        "A4:97:B1": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "BC:A9:93": "Cambium Networks Limited",
        "10:74:6F": "MOTOROLA SOLUTIONS MALAYSIA SDN. BHD.",
        "00:92:7D": "Ficosa Internationa(Taicang) C0.,Ltd.",
        "44:16:22": "Microsoft Corporation",
        "44:E6:B0": "China Mobile IOT Company Limited",
        "74:7A:90": "Murata Manufacturing Co., Ltd.",
        "24:E9:CA": "Huawei Device Co., Ltd.",
        "14:00:7D": "zte corporation",
        "94:AE:F0": "Cisco Systems, Inc",
        "1C:08:C1": "LG Innotek",
        "9C:F6:1A": "Carrier Fire & Security",
        "58:B6:23": "Beijing Xiaomi Mobile Software Co., Ltd",
        "FC:73:FB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "04:45:62": "ANDRA Sp. z o. o.",
        "00:26:9E": "Quanta Computer Inc.",
        "C4:54:44": "Quanta Computer Inc.",
        "00:C0:9F": "Quanta Computer Inc.",
        "00:1B:24": "Quanta Computer Inc.",
        "C8:0A:A9": "Quanta Computer Inc.",
        "60:EB:69": "Quanta Computer Inc.",
        "C0:8F:20": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "74:F7:F6": "Shanghai Sunmi Technology Co.,Ltd.",
        "24:1A:E6": "Huawei Device Co., Ltd.",
        "60:B7:6E": "Google, Inc.",
        "B4:23:30": "Itron Inc",
        "08:4E:BF": "Sumitomo Electric Industries, Ltd",
        "A8:02:DB": "zte corporation",
        "1C:5D:80": "Mitubishi Hitachi Power Systems Industries Co., Ltd.",
        "80:16:05": "Vodafone Italia S.p.A.",
        "3C:9C:0F": "Intel Corporate",
        "5C:44:3E": "Skullcandy",
        "F8:82:00": "CaptionCall",
        "08:FB:EA": "AMPAK Technology,Inc.",
        "34:0F:66": "Web Sensing LLC",
        "58:65:E6": "infomark",
        "00:50:F1": "Maxlinear, Inc",
        "F4:E5:78": "LLC Proizvodstvennaya Kompania TransService",
        "08:54:BB": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD",
        "60:EB:5A": "Asterfusion Data Technologies Co.,Ltd",
        "E4:D3:73": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C0:BC:9A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "70:2C:09": "Nintendo Co.,Ltd",
        "E8:1B:69": "Sercomm Corporation.",
        "68:52:D6": "UGame Technology Co.,Ltd",
        "90:12:A1": "We Corporation Inc.",
        "B8:80:35": "Shenzhen Qihu Intelligent Technology Company Limited",
        "00:17:11": "Cytiva Sweden AB",
        "B4:C2:6A": "Garmin International",
        "E8:9F:80": "Belkin International Inc.",
        "BC:5C:4C": "ELECOM CO.,LTD.",
        "04:AB:18": "ELECOM CO.,LTD.",
        "6C:E5:F7": "New H3C Technologies Co., Ltd",
        "B8:DD:71": "zte corporation",
        "78:F8:B8": "Rako Controls Ltd",
        "00:16:12": "Otsuka Electronics Co., Ltd.",
        "A4:51:29": "XAG",
        "5C:02:72": "Silicon Laboratories",
        "FC:4A:E9": "Castlenet Technology Inc.",
        "04:46:CF": "Beijing Venustech Cybervision Co.,Ltd.",
        "CC:87:4A": "Nokia",
        "00:07:8E": "Garz & Fricke GmbH",
        "B4:36:D1": "Renesas Electronics (Penang) Sdn. Bhd.",
        "00:61:51": "HUAWEI TECHNOLOGIES CO.,LTD",
        "BC:76:C5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "DC:77:4C": "Cisco Systems, Inc",
        "20:44:41": "Remote Solution",
        "B8:5F:98": "Amazon Technologies Inc.",
        "A0:85:FC": "Microsoft Corporation",
        "C4:98:86": "Qorvo International Pte. Ltd.",
        "94:FF:61": "China Mobile Group Device Co.,Ltd.",
        "10:19:65": "New H3C Technologies Co., Ltd",
        "80:F1:F1": "Tech4home, Lda",
        "14:A9:D0": "F5 Networks, Inc.",
        "1C:50:1E": "Sunplus Technology Co., Ltd.",
        "40:95:05": "ACOINFO TECHNOLOGY CO.,LTD",
        "FC:66:CF": "Apple, Inc.",
        "AC:1D:06": "Apple, Inc.",
        "44:A8:FC": "Apple, Inc.",
        "F8:10:93": "Apple, Inc.",
        "5C:D8:9E": "Huawei Device Co., Ltd.",
        "04:05:DD": "Shenzhen Cultraview Digital Technology Co., Ltd",
        "38:97:A4": "ELECOM CO.,LTD.",
        "E4:33:AE": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "DC:E9:94": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "38:7A:3C": "Fiberhome Telecommunication Technologies Co.,LTD",
        "8C:CE:4E": "Espressif Inc.",
        "B8:2D:28": "AMPAK Technology,Inc.",
        "EC:C8:9C": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "F0:13:C1": "Hannto Technology Co., Ltd",
        "F8:0D:AC": "HP Inc.",
        "88:DA:1A": "Redpine Signals, Inc.",
        "40:B5:C1": "Cisco Systems, Inc",
        "E4:47:91": "Iris ID Systems, Inc.",
        "00:60:65": "B&R Industrial Automation GmbH ",
        "84:9D:C2": "Shanghai MXCHIP Information Technology Co., Ltd.",
        "18:45:16": "Texas Instruments",
        "D0:2E:AB": "Texas Instruments",
        "84:54:DF": "Huawei Device Co., Ltd.",
        "F0:F7:E7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "8C:55:BB": "Songwoo Information & Technology Co., Ltd",
        "7C:8F:DE": "DWnet Technologies(Suzhou) Corporation",
        "98:F1:81": "New H3C Technologies Co., Ltd",
        "90:80:8F": "Huawei Device Co., Ltd.",
        "40:A9:CF": "Amazon Technologies Inc.",
        "58:95:D8": "IEEE Registration Authority",
        "08:38:E6": "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd.",
        "E8:C2:DD": "Infinix mobility limited",
        "48:D8:90": "FN-LINK TECHNOLOGY LIMITED",
        "78:1F:11": "RAB Lighting",
        "F8:B9:5A": "LG Innotek",
        "C4:1C:9C": "JiQiDao",
        "D4:4F:67": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B4:FF:98": "HUAWEI TECHNOLOGIES CO.,LTD",
        "84:71:27": "Silicon Laboratories",
        "00:26:4E": "r2p GmbH",
        "B0:BB:E5": "Sagemcom Broadband SAS",
        "C4:18:E9": "Samsung Electronics Co.,Ltd",
        "1C:E5:7F": "Samsung Electronics Co.,Ltd",
        "B0:C5:3C": "Cisco Systems, Inc",
        "EC:CE:13": "Cisco Systems, Inc",
        "10:71:00": "Huawei Device Co., Ltd.",
        "8C:FD:DE": "Sagemcom Broadband SAS",
        "A4:68:BC": "Oakley Inc.",
        "60:7E:A4": "Shanghai Imilab Technology Co.Ltd",
        "78:95:EB": "ITEL MOBILE LIMITED",
        "1C:9F:4E": "COOSEA GROUP (HK) COMPANY LIMITED",
        "14:AB:02": "HUAWEI TECHNOLOGIES CO.,LTD",
        "BC:5B:D5": "ARRIS Group, Inc.",
        "08:55:31": "Routerboard.com",
        "3C:61:05": "Espressif Inc.",
        "24:06:AA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "84:30:95": "Hon Hai Precision IND.CO.,LTD",
        "08:65:F0": "JM Zengge Co., Ltd",
        "AC:47:1B": "Huawei Device Co., Ltd.",
        "00:31:92": "TP-Link Corporation Limited",
        "A4:CC:B9": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "90:FF:D6": "Honor Device Co., Ltd.",
        "6C:B8:81": "zte corporation",
        "98:9A:B9": "zte corporation",
        "00:8A:55": "Huawei Device Co., Ltd.",
        "64:A2:8A": "Huawei Device Co., Ltd.",
        "B4:56:E3": "Apple, Inc.",
        "4C:20:B8": "Apple, Inc.",
        "14:88:E6": "Apple, Inc.",
        "BC:0F:9A": "D-Link International",
        "94:7B:BE": "Ubicquia LLC",
        "24:64:9F": "Huawei Device Co., Ltd.",
        "0C:17:73": "Huawei Device Co., Ltd.",
        "E8:1E:92": "Huawei Device Co., Ltd.",
        "88:8E:68": "Huawei Device Co., Ltd.",
        "80:74:84": "ALL Winner (Hong Kong) Limited",
        "04:98:F3": "ALPSALPINE CO,.LTD",
        "64:D4:BD": "ALPSALPINE CO,.LTD",
        "34:C7:31": "ALPSALPINE CO,.LTD",
        "00:06:F5": "ALPSALPINE CO,.LTD",
        "00:07:04": "ALPSALPINE CO,.LTD",
        "00:06:F7": "ALPSALPINE CO,.LTD",
        "88:23:8C": "Fiberhome Telecommunication Technologies Co.,LTD",
        "20:FF:36": "IFLYTEK CO.,LTD.",
        "BC:42:8C": "ALPSALPINE CO,.LTD",
        "74:95:EC": "ALPSALPINE CO,.LTD",
        "98:ED:7E": "eero inc.",
        "8C:AE:49": "IEEE Registration Authority",
        "00:21:4F": "ALPSALPINE CO,.LTD",
        "78:CF:2F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A8:3B:5C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B0:EE:7B": "Roku, Inc",
        "D8:31:34": "Roku, Inc",
        "10:59:32": "Roku, Inc",
        "A8:CC:6F": "HMD Global Oy",
        "5C:6F:69": "Broadcom Limited",
        "D0:12:CB": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "FC:44:82": "Intel Corporate",
        "D8:F8:83": "Intel Corporate",
        "E8:84:A5": "Intel Corporate",
        "E8:F4:08": "Intel Corporate",
        "74:8B:29": "Micobiomed",
        "00:25:50": "Riverbed Technology, Inc.",
        "58:B0:FE": "Team EPS GmbH",
        "14:3F:A6": "Sony Home Entertainment&Sound Products Inc",
        "F0:FE:E7": "Huawei Device Co., Ltd.",
        "54:21:1D": "Huawei Device Co., Ltd.",
        "04:49:5D": "Huawei Device Co., Ltd.",
        "44:D4:53": "Sagemcom Broadband SAS",
        "DC:A1:20": "Nokia",
        "50:52:3B": "Nokia",
        "DC:CD:74": "Japan E.M.Solutions Co., Ltd.",
        "A0:3B:01": "Kyung In Electronics",
        "14:5E:69": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "48:4C:29": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C4:D4:38": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C0:28:0B": "Honor Device Co., Ltd.",
        "9C:EA:97": "Honor Device Co., Ltd.",
        "EC:0D:E4": "Amazon Technologies Inc.",
        "0C:96:CD": "MERCURY CORPORATION",
        "E8:D2:FF": "Sagemcom Broadband SAS",
        "C4:E2:87": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F4:B3:01": "Intel Corporate",
        "5C:DE:34": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "E8:A0:CD": "Nintendo Co.,Ltd",
        "A0:A3:F0": "D-Link International",
        "84:65:69": "New H3C Technologies Co., Ltd",
        "34:F7:16": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "9C:82:3F": "Huawei Device Co., Ltd.",
        "54:F6:07": "Huawei Device Co., Ltd.",
        "68:78:48": "WESTUNITIS CO., LTD.",
        "08:FF:24": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "50:55:8D": "China Mobile IOT Company Limited",
        "64:26:56": "Shenzhen Fanweitai Technology Service Co.,Ltd",
        "F0:25:8E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "9C:74:6F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "64:E0:03": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "18:CE:94": "Samsung Electronics Co.,Ltd",
        "78:37:16": "Samsung Electronics Co.,Ltd",
        "28:1B:04": "Zalliant LLC",
        "7C:50:79": "Intel Corporate",
        "80:38:FB": "Intel Corporate",
        "08:B4:B1": "Google, Inc.",
        "34:58:7C": "MIRAE INFORMATION TECHNOLOGY CO., LTD.",
        "AC:82:47": "Intel Corporate",
        "74:9A:C0": "Cachengo, Inc.",
        "A4:5E:5A": "ACTIVIO Inc.",
        "5C:56:A4": "Wanan Hongsheng Electronic Co.Ltd",
        "B4:85:E1": "Apple, Inc.",
        "0C:19:F8": "Apple, Inc.",
        "50:1F:C6": "Apple, Inc.",
        "3C:9B:C6": "Huawei Device Co., Ltd.",
        "54:09:10": "Apple, Inc.",
        "9C:FC:28": "Apple, Inc.",
        "CC:69:FA": "Apple, Inc.",
        "10:CE:E9": "Apple, Inc.",
        "0C:8D:DB": "Cisco Meraki",
        "CC:03:D9": "Cisco Meraki",
        "00:36:BE": "Northwest Towers",
        "A8:77:E5": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD",
        "10:A4:DA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "38:20:28": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E4:77:27": "HUAWEI TECHNOLOGIES CO.,LTD",
        "10:51:07": "Intel Corporate",
        "AC:74:C4": "Maytronics Ltd.",
        "84:D6:08": "Wingtech Mobile Communications Co., Ltd.",
        "34:68:93": "Tecnovideo Srl",
        "3C:7A:AA": "China Dragon Technology Limited",
        "6C:47:60": "Sunitec Enterprise Co.,Ltd",
        "18:32:19": "EM Microelectronic",
        "28:D3:EA": "Huawei Device Co., Ltd.",
        "A8:F2:66": "Huawei Device Co., Ltd.",
        "84:26:7A": "GUANGDONG TAIDE ZHILIAN TECHNOLOGY CO.,LTD",
        "D8:EC:5E": "Belkin International Inc.",
        "84:FD:27": "Silicon Laboratories",
        "CC:9C:3E": "Cisco Meraki",
        "FC:A9:DC": "Renesas Electronics (Penang) Sdn. Bhd.",
        "FC:58:4A": "xiamenshi c-chip technology co., ltd",
        "78:65:3B": "Shaoxing Ourten Electronics Co., Ltd.",
        "E0:E6:56": "Nethesis  srl",
        "90:23:B4": "New H3C Technologies Co., Ltd",
        "88:2A:5E": "New H3C Technologies Co., Ltd",
        "84:1E:A3": "Sagemcom Broadband SAS",
        "F4:02:23": "PAX Computer Technology(Shenzhen) Ltd.",
        "64:6E:E0": "Intel Corporate",
        "04:56:E5": "Intel Corporate",
        "08:10:86": "NEC Platforms, Ltd.",
        "64:79:F0": "Intel Corporate",
        "1C:D1:E0": "Cisco Systems, Inc",
        "24:45:6B": "Huawei Device Co., Ltd.",
        "48:38:71": "Huawei Device Co., Ltd.",
        "44:BD:DE": "BHTC GmbH",
        "8C:2A:8E": "DongGuan Ramaxel Memory Technology",
        "40:44:FD": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "E8:FD:35": "Huawei Device Co., Ltd.",
        "EC:C5:D2": "Huawei Device Co., Ltd.",
        "B4:60:8C": "Fiberhome Telecommunication Technologies Co.,LTD",
        "B8:14:DB": "OHSUNG",
        "80:07:1B": "VSOLUTION TELECOMMUNICATION TECHNOLOGY CO.,LTD.",
        "FC:13:F0": "Bouffalo Lab (Nanjing) Co., Ltd.",
        "1C:6E:E6": "NHNETWORKS",
        "08:F6:06": "zte corporation",
        "E8:9E:0C": "MAX8USA DISTRIBUTORS INC.",
        "FC:9C:98": "Arlo Technology",
        "A0:70:B7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:B5:54": "Huawei Device Co., Ltd.",
        "68:9E:6A": "Huawei Device Co., Ltd.",
        "28:2B:96": "Huawei Device Co., Ltd.",
        "CC:68:B6": "TP-Link Corporation Limited",
        "64:64:4A": "Beijing Xiaomi Mobile Software Co., Ltd",
        "A4:39:B6": "SHENZHEN PEIZHE MICROELECTRONICS CO .LTD",
        "F4:FB:B8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "CC:33:31": "Texas Instruments",
        "2C:B8:ED": "SonicWall",
        "C8:9B:AD": "Honor Device Co., Ltd.",
        "C4:5B:BE": "Espressif Inc.",
        "88:90:09": "Juniper Networks",
        "90:B6:7A": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "7C:D9:F4": "UAB Teltonika Telematics",
        "C8:C6:4A": "Flextronics Tech.(Ind) Pvt Ltd",
        "FC:4E:A4": "Apple, Inc.",
        "F4:BE:EC": "Apple, Inc.",
        "BC:FF:4D": "Espressif Inc.",
        "54:E6:1B": "Apple, Inc.",
        "D8:9A:C1": "Nokia",
        "F0:B1:1D": "Nokia",
        "00:04:7D": "Motorola Solutions Inc.",
        "A4:D7:95": "Wingtech Mobile Communications Co.,Ltd",
        "84:AB:26": "Tiinlab Corporation",
        "F8:97:53": "Huawei Device Co., Ltd.",
        "58:94:AE": "Huawei Device Co., Ltd.",
        "B0:3A:CE": "Huawei Device Co., Ltd.",
        "34:AB:95": "Espressif Inc.",
        "C4:91:CF": "Luxul ",
        "58:35:6B": "TECNO MOBILE LIMITED",
        "F8:4C:DA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A8:93:4A": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "A4:05:6E": "Tiinlab Corporation",
        "8C:19:B5": "Arcadyan Corporation",
        "C8:7B:23": "Bose Corporation",
        "78:D9:E9": "MOMENTUM IOT",
        "2C:08:23": "Sercomm France Sarl",
        "9C:1C:37": "AltoBeam (China) Inc.",
        "8C:E7:48": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "98:42:65": "Sagemcom Broadband SAS",
        "B8:A3:77": "Cisco Systems, Inc",
        "E4:4E:2D": "Cisco Systems, Inc",
        "00:CC:34": "Juniper Networks",
        "1C:D1:07": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "10:3D:1C": "Intel Corporate",
        "38:87:D5": "Intel Corporate",
        "80:65:59": "EM Microelectronic",
        "D0:47:C1": "Elma Electronic AG",
        "C0:CC:42": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "C4:23:60": "Intel Corporate",
        "08:01:0F": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "18:52:07": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "E0:C6:3C": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "DC:21:5C": "Intel Corporate",
        "BC:EC:A0": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "F8:BA:E6": "Nokia",
        "58:FD:5D": "Hangzhou Xinyun technology Co., Ltd.",
        "24:A7:99": "Huawei Device Co., Ltd.",
        "7C:3E:74": "Huawei Device Co., Ltd.",
        "14:89:19": "2bps",
        "4C:71:67": "PoLabs d.o.o.",
        "04:71:53": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
        "48:E7:DA": "AzureWave Technology Inc.",
        "40:C4:8C": "N-iTUS CO.,LTD.",
        "48:22:18": "Shenzhen Yipingfang Network Technology Co., Ltd.",
        "30:A1:76": "Fiberhome Telecommunication Technologies Co.,LTD",
        "E4:0C:FD": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "58:D6:97": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "54:37:BB": "Taicang T&W Electronics",
        "60:F8:F2": "Synaptec",
        "AC:74:B1": "Intel Corporate",
        "1C:3C:D4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F4:E4:51": "HUAWEI TECHNOLOGIES CO.,LTD",
        "60:26:EF": "Aruba, a Hewlett Packard Enterprise Company",
        "F4:60:77": "Texas Instruments",
        "24:9A:C8": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "C0:3C:04": "Sagemcom Broadband SAS",
        "A4:D7:3C": "Seiko Epson Corporation",
        "6C:10:8B": "WeLink Communications",
        "F8:8E:A1": "Edgecore Networks Corporation",
        "7C:85:30": "Nokia",
        "F4:63:E7": "Nanjing Maxon O.E. Tech. Co., LTD",
        "24:28:FD": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "88:AE:DD": "EliteGroup Computer Systems Co., LTD",
        "64:D0:2D": "NEXT GENERATION INTEGRATION LIMITED (NGI)",
        "A0:E7:0B": "Intel Corporate",
        "B0:D8:88": "Panasonic Corporation Automotive",
        "04:EE:EE": "Laplace System Co., Ltd.",
        "68:96:6A": "OHSUNG",
        "90:2E:16": "LCFC(HeFei) Electronics Technology co., ltd",
        "78:06:C9": "Huawei Device Co., Ltd.",
        "E8:A6:CA": "Huawei Device Co., Ltd.",
        "CC:FA:66": "Huawei Device Co., Ltd.",
        "1C:7D:22": "FUJIFILM Business Innovation Corp.",
        "34:FE:9E": "Fujitsu Limited",
        "0C:71:8C": "TCT mobile ltd",
        "E0:30:F9": "Juniper Networks",
        "24:08:5D": "Continental Aftermarket & Services GmbH",
        "34:24:3E": "zte corporation",
        "38:45:3B": "Ruckus Wireless",
        "78:13:05": "IEEE Registration Authority",
        "20:54:76": "Sony Corporation",
        "30:17:C8": "Sony Corporation",
        "6C:23:B9": "Sony Corporation",
        "6C:0E:0D": "Sony Corporation",
        "00:19:63": "Sony Corporation",
        "00:16:20": "Sony Corporation",
        "00:12:EE": "Sony Corporation",
        "D4:38:9C": "Sony Corporation",
        "68:1B:EF": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:23:45": "Sony Corporation",
        "00:1F:E4": "Sony Corporation",
        "F4:46:37": "Intel Corporate",
        "64:50:D6": "Liquidtool Systems",
        "68:76:4F": "Sony Corporation",
        "38:A6:59": "Sagemcom Broadband SAS",
        "60:61:34": "Genesis Technical Systems Corp",
        "A8:48:FA": "Espressif Inc.",
        "FC:58:DF": "Interphone Service",
        "98:10:82": "Nsolution Co., Ltd.",
        "C4:12:34": "Apple, Inc.",
        "3C:A6:F6": "Apple, Inc.",
        "4C:AB:4F": "Apple, Inc.",
        "9C:58:3C": "Apple, Inc.",
        "E4:DC:5F": "Cofractal, Inc.",
        "50:81:40": "HP Inc.",
        "CC:89:6C": "GN Hearing A/S",
        "48:F3:F3": "Baidu Online Network Technology (Beijing) Co., Ltd",
        "D4:73:50": "DBG Commnunications Technology  Co., Ltd.",
        "3C:7A:F0": "ITEL MOBILE LIMITED",
        "70:DA:17": "Austrian Audio GmbH",
        "50:41:1C": "AMPAK Technology,Inc.",
        "8C:1E:D9": "Beijing Unigroup Tsingteng Microsystem Co., LTD.",
        "B0:37:95": "LG Electronics",
        "A4:FF:95": "Nokia",
        "F4:26:79": "Intel Corporate",
        "38:61:A5": "Grabango Co",
        "D0:8E:79": "Dell Inc.",
        "78:D3:ED": "NORMA",
        "34:B4:72": "Espressif Inc.",
        "F8:0C:58": "Taicang T&W Electronics",
        "FC:19:99": "Xiaomi Communications Co Ltd",
        "24:11:45": "Xiaomi Communications Co Ltd",
        "50:78:B0": "Huawei Device Co., Ltd.",
        "E4:07:2B": "Huawei Device Co., Ltd.",
        "FC:A8:9B": "Texas Instruments",
        "98:F0:7B": "Texas Instruments",
        "24:46:E4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "68:F0:D0": "SkyBell Technologies Inc.",
        "BC:D7:A5": "Aruba, a Hewlett Packard Enterprise Company",
        "4C:F2:02": "Xiaomi Communications Co Ltd",
        "88:46:04": "Xiaomi Communications Co Ltd",
        "A4:55:90": "Xiaomi Communications Co Ltd",
        "08:1C:6E": "Xiaomi Communications Co Ltd",
        "84:AC:16": "Apple, Inc.",
        "2C:BC:87": "Apple, Inc.",
        "44:A9:2C": "IEEE Registration Authority",
        "D8:80:83": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "AC:B9:2F": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "18:77:58": "Audoo Limited (UK)",
        "90:E8:68": "AzureWave Technology Inc.",
        "4C:50:F1": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "FC:42:65": "Zhejiang Tmall Technology Co., Ltd.",
        "B4:E4:54": "Amazon Technologies Inc.",
        "0C:43:F9": "Amazon Technologies Inc.",
        "68:87:C6": "Cisco Systems, Inc",
        "80:24:8F": "Cisco Systems, Inc",
        "D4:94:FB": "Continental Automotive Systems Inc.",
        "44:D4:54": "Sagemcom Broadband SAS",
        "E8:95:26": "Luxshare Precision Industry CO., LTD.",
        "C8:C9:A3": "Espressif Inc.",
        "E4:3B:C9": "HISENSE VISUAL TECHNOLOGY CO.,LTD",
        "D4:93:90": "CLEVO CO.",
        "BC:06:2D": "Wacom Co.,Ltd.",
        "10:41:21": "TELLESCOM INDUSTRIA E COMERCIO EM TELECOMUNICACAO ",
        "50:E7:A0": "Renesas Electronics (Penang) Sdn. Bhd.",
        "00:13:98": "TrafficSim Co.,Ltd",
        "50:0A:52": "Huiwan Technologies Co. Ltd",
        "40:9C:A6": "Curvalux",
        "9C:97:26": "Technicolor Delivery Technologies Belgium NV",
        "30:91:8F": "Technicolor Delivery Technologies Belgium NV",
        "E0:B9:E5": "Technicolor Delivery Technologies Belgium NV",
        "80:7E:B4": "Shenzhen SuperElectron Technology Co.,Ltd.",
        "50:4B:9E": "Huawei Device Co., Ltd.",
        "04:7A:AE": "Huawei Device Co., Ltd.",
        "3C:93:F4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "64:33:B5": "IEEE Registration Authority",
        "8C:4B:14": "Espressif Inc.",
        "D4:E8:53": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "18:E2:15": "Nokia",
        "4C:E2:F1": "Udino srl",
        "B8:8C:29": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "BC:6A:D1": "Xiaomi Communications Co Ltd",
        "84:27:B6": "China Mobile IOT Company Limited",
        "54:44:A3": "Samsung Electronics Co.,Ltd",
        "64:B6:23": "Schrack Seconet Care Communication GmbH",
        "08:45:D1": "Cisco Systems, Inc",
        "9C:40:CD": "Synclayer Inc.",
        "78:5E:E8": "IEEE Registration Authority",
        "CC:BC:E3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "08:9E:84": "HUAWEI TECHNOLOGIES CO.,LTD",
        "10:82:D7": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "30:03:C8": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "08:8E:DC": "Apple, Inc.",
        "98:50:2E": "Apple, Inc.",
        "58:0A:D4": "Apple, Inc.",
        "A4:77:F3": "Apple, Inc.",
        "A8:4A:28": "Apple, Inc.",
        "D8:BE:1F": "Apple, Inc.",
        "10:B7:A8": "CableFree Networks Limited",
        "08:9B:F1": "eero inc.",
        "00:11:14": "EverFocus Electronics Corp.",
        "D0:3F:27": "Wyze Labs Inc",
        "50:29:7B": "China Mobile Group Device Co.,Ltd.",
        "6C:DD:EF": "EPCOMM Inc.",
        "D0:F1:21": "Xi'an LINKSCI Technology Co., Ltd",
        "EC:1C:5D": "Siemens AG",
        "78:44:4A": "Shenzhen Aiwinn information Technology Co., Ltd.",
        "8C:B8:7E": "Intel Corporate",
        "70:1A:B8": "Intel Corporate",
        "5C:DF:89": "Ruckus Wireless",
        "70:B6:4F": "Guangzhou V-SOLUTION Electronic Technology Co., Ltd.",
        "B4:20:5B": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "18:7A:3B": "Aruba, a Hewlett Packard Enterprise Company",
        "70:B9:BB": "Shenzhen Hankvision Technology CO.,LTD",
        "A4:C6:9A": "Samsung Electronics Co.,Ltd",
        "D0:F5:20": "KYOCERA Corporation ",
        "B8:94:70": "Calix Inc.",
        "94:7F:1D": "Shenzhen Fastrain Technology Co., Ltd.",
        "60:7D:DD": "Shenzhen Shichuangyi Electronics Co.,Ltd",
        "24:0F:9B": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "E4:29:3D": "Shenzhen Sy-Fiber Optical Communication Technology.Co.,Ltd",
        "AC:5E:14": "HUAWEI TECHNOLOGIES CO.,LTD",
        "20:DF:73": "HUAWEI TECHNOLOGIES CO.,LTD",
        "48:12:8F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "9C:56:36": "Huawei Device Co., Ltd.",
        "40:CA:63": "Seongji Industry Company",
        "D4:8A:3B": "HUNAN FN-LINK TECHNOLOGY LIMITED",
        "40:06:D5": "Cisco Systems, Inc",
        "A0:22:DE": "vivo Mobile Communication Co., Ltd.",
        "14:DD:9C": "vivo Mobile Communication Co., Ltd.",
        "2C:48:81": "vivo Mobile Communication Co., Ltd.",
        "94:31:CB": "vivo Mobile Communication Co., Ltd.",
        "20:74:54": "vivo Mobile Communication Co., Ltd.",
        "BC:22:28": "D-Link International",
        "C4:CA:2B": "Arista Networks",
        "00:24:69": "Fasttel - Smart Doorphones",
        "B4:3D:08": "GX International BV",
        "70:89:F5": "Dongguan Lingjie IOT Co., LTD",
        "88:DC:96": "EnGenius Technologies, Inc.",
        "40:B0:A1": "VALCOM CO.,LTD.",
        "90:38:0C": "Espressif Inc.",
        "84:7B:57": "Intel Corporate",
        "64:CB:E9": "LG Innotek",
        "9C:75:6E": "Ajax Systems DMCC",
        "F0:6C:73": "Nokia",
        "E8:F9:D4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B0:C7:87": "HUAWEI TECHNOLOGIES CO.,LTD",
        "0C:4F:9B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "7C:21:4A": "Intel Corporate",
        "50:84:92": "Intel Corporate",
        "48:2F:D7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:D8:1E": "MirWifi,Joint-Stock Company",
        "98:80:BB": "IEEE Registration Authority",
        "D8:B0:53": "Xiaomi Communications Co Ltd",
        "6C:F7:84": "Xiaomi Communications Co Ltd",
        "04:2B:58": "Shenzhen Hanzsung Technology Co.,Ltd",
        "28:C0:1B": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "B8:12:DA": "LVSWITCHES INC.",
        "A0:D7:F3": "Samsung Electronics Co.,Ltd",
        "E8:6D:6E": "voestalpine Signaling UK Ltd.",
        "28:2A:87": "ITEL MOBILE LIMITED",
        "A8:B5:7C": "Roku, Inc",
        "78:C6:BB": "Analog Devices, Inc.",
        "24:26:BA": "Shenzhen Toptel Technology Co., Ltd.",
        "54:6C:EB": "Intel Corporate",
        "00:93:37": "Intel Corporate",
        "AC:BC:D9": "Cisco Systems, Inc",
        "58:CE:2A": "Intel Corporate",
        "10:A5:1D": "Intel Corporate",
        "08:8E:90": "Intel Corporate",
        "C0:44:42": "Apple, Inc.",
        "D4:68:AA": "Apple, Inc.",
        "98:DD:60": "Apple, Inc.",
        "F8:C3:CC": "Apple, Inc.",
        "30:1A:28": "Mako Networks Ltd",
        "30:5A:99": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "60:4D:E1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "70:4E:6B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "70:C6:DD": "New H3C Technologies Co., Ltd",
        "18:5B:00": "Nokia",
        "6C:C4:9F": "Aruba, a Hewlett Packard Enterprise Company",
        "60:3D:29": "HUAWEI TECHNOLOGIES CO.,LTD",
        "54:C4:80": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A8:61:DF": "China Mobile Group Device Co.,Ltd.",
        "7C:A6:2A": "Hewlett Packard Enterprise",
        "1C:45:86": "Nintendo Co.,Ltd",
        "50:7C:6F": "Intel Corporate",
        "58:9B:4A": "DWnet Technologies(Suzhou) Corporation",
        "5C:83:CD": "New platforms",
        "38:4B:24": "SIEMENS AG",
        "F0:AE:66": "Cosonic Intelligent Technologies Co., Ltd.",
        "20:80:97": "Shenzhen OXO Technology limited",
        "7C:16:89": "Sagemcom Broadband SAS",
        "40:11:C3": "Samsung Electronics Co.,Ltd",
        "C4:7D:9F": "Samsung Electronics Co.,Ltd",
        "3C:A9:16": "Huawei Device Co., Ltd.",
        "C4:1C:07": "Samsung Electronics Co.,Ltd",
        "58:FC:C6": "TOZO INC",
        "00:40:36": "Minim Inc.",
        "44:85:02": "Shenzhen SuperElectron Technology Co.,Ltd.",
        "A4:EF:15": "AltoBeam (China) Inc.",
        "D4:94:00": "HUAWEI TECHNOLOGIES CO.,LTD",
        "84:15:D3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A0:6C:65": "Texas Instruments",
        "F4:A4:54": "IEEE Registration Authority",
        "10:E8:A7": "Wistron Neweb Corporation",
        "D4:2C:46": "BUFFALO.INC",
        "10:91:A8": "Espressif Inc.",
        "6C:3A:36": "Glowforge Inc",
        "80:6A:00": "Cisco Systems, Inc",
        "D4:6C:6D": "ARRIS Group, Inc.",
        "A0:E7:AE": "ARRIS Group, Inc.",
        "EC:50:AA": "Aruba, a Hewlett Packard Enterprise Company",
        "B4:45:06": "Dell Inc.",
        "CC:A3:BD": "ITEL MOBILE LIMITED",
        "D4:35:4A": "ALAXALA Networks Corporation",
        "40:E9:9B": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "78:04:7A": "Edge Networks LLC",
        "BC:AF:87": "smartAC.com, Inc.",
        "C0:2B:31": "Phytium Technology Co.,Ltd.",
        "58:CF:79": "Espressif Inc.",
        "4C:C4:49": "Icotera A/S",
        "BC:45:5B": "Samsung Electronics Co.,Ltd",
        "B0:3C:DC": "Intel Corporate",
        "00:09:B0": "Onkyo Technology K.K.",
        "08:F8:0D": "IEEE Registration Authority",
        "78:62:99": "BITSTREAM sp. z o.o.",
        "CC:5B:31": "Nintendo Co.,Ltd",
        "0C:1E:F7": "Omni-ID",
        "E0:6D:18": "PIONEERCORPORATION",
        "8C:F8:C5": "Intel Corporate",
        "34:5D:9E": "Sagemcom Broadband SAS",
        "A4:5F:B9": "DreamBig Semiconductor, Inc.",
        "B4:D2:86": "Telechips, Inc.",
        "00:0F:32": "Lootom Telcovideo Network (Wuxi) Co Ltd",
        "18:C2:3C": "Lumi United Technology Co., Ltd",
        "04:75:F9": "Taicang T&W Electronics",
        "E8:51:77": "Qingdao Intelligent&Precise Electronics Co.,Ltd.",
        "38:8A:21": "UAB Teltonika Telematics",
        "A0:59:50": "Intel Corporate",
        "50:87:4D": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "50:89:D1": "Huawei Device Co., Ltd.",
        "00:62:0B": "Broadcom Limited",
        "A4:17:52": "Hifocus Electronics India Private Limited",
        "40:FE:95": "New H3C Technologies Co., Ltd",
        "BC:D0:74": "Apple, Inc.",
        "F0:61:C0": "Aruba, a Hewlett Packard Enterprise Company",
        "DC:CC:E6": "Samsung Electronics Co.,Ltd",
        "F0:65:AE": "Samsung Electronics Co.,Ltd",
        "1C:70:C9": "Jiangsu Aisida Electronic Co., Ltd",
        "9C:B8:B4": "AMPAK Technology,Inc.",
        "00:40:84": "Honeywell",
        "A0:53:94": "Shenzhen zediel co., Ltd.",
        "04:EE:E8": "IEEE Registration Authority",
        "3C:F7:D1": "OMRON Corporation",
        "84:B4:DB": "Silicon Laboratories",
        "38:C8:04": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "E0:07:C2": "FUJIAN STAR-NET COMMUNICATION CO.,LTD",
        "2C:FD:B4": "Shenzhen Jingxun Software Telecommunication Technology Co.,Ltd",
        "B4:F2:67": "Compal Broadband Networks, Inc.",
        "C0:BA:E6": "Application Solutions (Safety and Security) Ltd",
        "18:D7:93": "IEEE Registration Authority",
        "00:09:E5": "Hottinger Brüel & Kjaer GmbH",
        "D8:B6:73": "Texas Instruments",
        "98:50:A3": "SIGNALTEK JSC",
        "C0:FB:C1": "ITEL MOBILE LIMITED",
        "E8:17:FC": "Fujitsu Cloud Technologies Limited",
        "B0:DD:74": "Heimgard Technologies AS",
        "DC:36:43": "IEEE Registration Authority",
        "10:2C:8D": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "94:E6:86": "Espressif Inc.",
        "F8:28:C9": "HUAWEI TECHNOLOGIES CO.,LTD",
        "50:B3:B4": "Shenzhen Furuilian Electronic Co.,Ltd.",
        "B4:8C:9D": "AzureWave Technology Inc.",
        "FC:11:93": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:B8:83": "Cisco Systems, Inc",
        "C0:79:82": "TCL King Electrical Appliances(Huizhou)Co.,Ltd",
        "D0:ED:FF": "ZF CVCS",
        "F8:A9:1F": "ZVISION Technologies Co., Ltd",
        "4C:BA:D7": "LG Innotek",
        "7C:C9:5E": "Dongguan Liesheng Electronic Co., Ltd.",
        "7C:CC:FC": "Quectel Wireless Solutions Co.,Ltd.",
        "98:8F:E0": "IEEE Registration Authority",
        "34:D7:37": "IBG Industriebeteiligungsgesellschaft mbH &b Co. KG",
        "2C:33:41": "China Mobile IOT Company Limited",
        "AC:56:7B": "Sunnovo International Limited",
        "9C:C1:2D": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "80:65:7C": "Apple, Inc.",
        "DC:80:84": "Apple, Inc.",
        "8C:C7:C3": "NETLINK ICT ",
        "7C:35:F8": "Zhejiang Tmall Technology Co., Ltd.",
        "74:26:FF": "zte corporation",
        "C4:27:28": "zte corporation",
        "C8:58:95": "Motorola Mobility LLC, a Lenovo Company",
        "E4:DA:DF": "Taicang T&W Electronics",
        "A8:53:7D": "Mist Systems, Inc.",
        "30:34:22": "eero inc.",
        "08:E0:21": "Honor Device Co., Ltd.",
        "B0:5C:16": "Fiberhome Telecommunication Technologies Co.,LTD",
        "E8:D3:22": "Cisco Systems, Inc",
        "8C:15:53": "Beijing Memblaze Technology Co Ltd",
        "D4:BD:4F": "Ruckus Wireless",
        "5C:C9:C0": "Renesas Electronics (Penang) Sdn. Bhd.",
        "6C:B1:58": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "E8:81:AB": "Beijing Sankuai Online Technology Co.,Ltd",
        "1C:47:F6": "Zhidao Network Technology(Shenzhen) Co.,Ltd",
        "A0:B4:BF": "InfiNet LLC",
        "E8:EB:D3": "Mellanox Technologies, Inc.",
        "30:2B:DC": "Top-Unum Electronics Co., LTD",
        "90:F7:B2": "New H3C Technologies Co., Ltd",
        "04:E3:1A": "Sagemcom Broadband SAS",
        "C0:06:0C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B0:A4:F0": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:75:3A": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "6C:99:9D": "Amazon Technologies Inc.",
        "6C:93:08": "IEEE Registration Authority",
        "7C:6A:60": "China Mobile Group Device Co.,Ltd.",
        "68:18:D9": "Hill AFB - CAPRE Group",
        "18:BC:57": "ADVA Optical Networking Ltd.",
        "D8:E2:DF": "Microsoft Corporation",
        "1C:61:B4": "TP-Link Corporation Limited",
        "9C:A2:F4": "TP-Link Corporation Limited",
        "B4:69:5F": "TCT mobile ltd",
        "38:8F:30": "Samsung Electronics Co.,Ltd",
        "A0:44:66": "Intellics",
        "44:6D:7F": "Amazon Technologies Inc.",
        "84:C6:92": "Texas Instruments",
        "6C:B2:FD": "Texas Instruments",
        "6C:0F:61": "Hypervolt Ltd",
        "24:06:F2": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "C0:6D:ED": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "90:93:5A": "ARRIS Group, Inc.",
        "AC:8F:A9": "Nokia Solutions and Networks GmbH & Co. KG",
        "4C:73:4F": "Juniper Networks",
        "C0:C1:70": "Shenzhen SuperElectron Technology Co.,Ltd.",
        "50:42:89": "zte corporation",
        "44:29:1E": "AltoBeam (China) Inc.",
        "24:EB:ED": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:8E:7A": "Shenzhen iComm Semiconductor CO.,LTD",
        "2C:DD:5F": "Shenzhen iComm Semiconductor CO.,LTD",
        "AC:51:AB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "48:CD:D3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "CC:66:18": "Adtran Inc",
        "E0:27:6C": "Guangzhou Shiyuan Electronic Technology Company Limited",
        "DC:8E:95": "Silicon Laboratories",
        "28:BE:43": "vivo Mobile Communication Co., Ltd.",
        "2C:FC:8B": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "F8:AD:24": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "B0:1F:8C": "Aruba, a Hewlett Packard Enterprise Company",
        "A8:C9:8A": "New H3C Technologies Co., Ltd",
        "00:26:04": "WorldCast Systems",
        "7C:EF:40": "Nextorage Corporation",
        "1C:AF:4A": "Samsung Electronics Co.,Ltd",
        "C8:12:0B": "Samsung Electronics Co.,Ltd",
        "28:74:F5": "Nokia Solutions and Networks GmbH & Co. KG",
        "C0:E0:1C": "IoT Security Group, SL",
        "00:00:BD": "RYOSEI, Ltd.",
        "AC:CC:FC": "Amazon Technologies Inc.",
        "90:2C:FB": "CanTops Co,.Ltd.",
        "F8:AB:82": "Xiaomi Communications Co Ltd",
        "EC:30:B3": "Xiaomi Communications Co Ltd",
        "9C:57:BC": "eero inc.",
        "14:2D:4D": "Apple, Inc.",
        "EC:42:CC": "Apple, Inc.",
        "B8:21:1C": "Apple, Inc.",
        "B0:3F:64": "Apple, Inc.",
        "D4:5A:3F": "Juniper Networks",
        "E8:DC:6C": "Cisco Systems, Inc",
        "A8:A2:37": "Arcadyan Corporation",
        "2C:82:17": "Apple, Inc.",
        "C8:9E:61": "Lyngsoe Systems LTd",
        "E0:28:B1": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "C0:8D:51": "Amazon Technologies Inc.",
        "44:B4:B2": "Amazon Technologies Inc.",
        "48:B4:C3": "Aruba, a Hewlett Packard Enterprise Company",
        "6C:15:24": "IEEE Registration Authority",
        "78:03:4F": "Nokia",
        "C0:E9:11": "Private",
        "14:F5:92": "Shenzhen SDG DONZHI Technology Co., Ltd",
        "4C:09:FA": "FRONTIER SMART TECHNOLOGIES LTD",
        "68:A7:B4": "Honor Device Co., Ltd.",
        "80:3C:20": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A4:DD:58": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:2C:FE": "Zhejiang Tmall Technology Co., Ltd.",
        "E8:D8:7E": "Amazon Technologies Inc.",
        "00:12:93": "ABB Switzerland Ltd.",
        "9C:1F:CA": "Hangzhou AlmightyDigit Technology Co., Ltd",
        "2C:DC:78": "Descartes Systems (USA) LLC",
        "A0:42:D1": "Huawei Device Co., Ltd.",
        "58:87:9F": "Huawei Device Co., Ltd.",
        "E0:6C:4E": "Shenzhen TINNO Mobile Technology Corp.",
        "80:6A:B0": "Shenzhen TINNO Mobile Technology Corp.",
        "84:70:D7": "eero inc.",
        "10:B2:32": "Qingdao Intelligent&Precise Electronics Co.,Ltd.",
        "14:9B:F3": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "10:07:1D": "Fiberhome Telecommunication Technologies Co.,LTD",
        "F4:B3:B1": "Silicon Laboratories",
        "B8:50:D8": "Beijing Xiaomi Mobile Software Co., Ltd",
        "58:1D:D8": "Sagemcom Broadband SAS",
        "04:69:8F": "Juniper Networks",
        "5C:53:C3": "Ubee Interactive Co., Limited",
        "AC:5A:F0": "LG Electronics",
        "EC:A6:2F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C0:9F:51": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
        "80:02:F4": "IEEE Registration Authority",
        "A0:CD:F3": "Murata Manufacturing Co., Ltd.",
        "24:29:34": "Google, Inc.",
        "38:0A:4F": "PRACHI ENTERPRISES",
        "C8:3A:1B": "Toshiba TEC Corporation Inc",
        "B4:8A:0A": "Espressif Inc.",
        "80:19:70": "Samsung Electronics Co.,Ltd",
        "E0:F7:28": "Amazon Technologies Inc.",
        "1C:0E:D3": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "24:32:AE": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "38:22:F4": "Huawei Device Co., Ltd.",
        "0C:BE:F1": "Huawei Device Co., Ltd.",
        "AC:93:6A": "Huawei Device Co., Ltd.",
        "38:A4:4B": "Huawei Device Co., Ltd.",
        "7C:4C:A5": "SKY UK LIMITED",
        "C0:3E:0F": "SKY UK LIMITED",
        "0C:F9:C0": "SKY UK LIMITED",
        "70:50:AF": "SKY UK LIMITED",
        "D0:58:FC": "SKY UK LIMITED",
        "90:02:18": "SKY UK LIMITED",
        "D4:DA:CD": "SKY UK LIMITED",
        "B0:45:30": "SKY UK LIMITED",
        "6C:A0:B4": "SKY UK LIMITED",
        "3C:9E:C7": "SKY UK LIMITED",
        "A4:AE:11": "Hon Hai Precision Industry Co., Ltd.",
        "7C:DE:78": "New H3C Technologies Co., Ltd",
        "3C:E0:64": "Texas Instruments",
        "E0:92:8F": "Texas Instruments",
        "CC:03:7B": "Texas Instruments",
        "58:1C:F8": "Intel Corporate",
        "AC:19:8E": "Intel Corporate",
        "C8:5E:A9": "Intel Corporate",
        "B8:FB:AF": "Xiamen IPRT Technology CO.,LTD",
        "34:85:18": "Espressif Inc.",
        "EC:E6:A2": "Fiberhome Telecommunication Technologies Co.,LTD",
        "04:E8:B9": "Intel Corporate",
        "E0:2E:0B": "Intel Corporate",
        "38:5C:FB": "Silicon Laboratories",
        "C4:3D:1A": "Intel Corporate",
        "68:53:9D": "EM Microelectronic",
        "C8:BF:4C": "Beijing Xiaomi Mobile Software Co., Ltd",
        "E4:65:64": "SHENZHEN KTC TECHNOLOGY CO.,LTD",
        "E0:51:D8": "China Dragon Technology Limited",
        "5C:60:BA": "HP Inc.",
        "E0:EF:02": "Chengdu Quanjing Intelligent Technology Co.,Ltd",
        "4C:A3:A7": "TECNO MOBILE LIMITED",
        "A8:AB:B5": "Apple, Inc.",
        "58:64:C4": "Apple, Inc.",
        "40:A5:3B": "Nokia",
        "74:80:3F": "Renesas Electronics (Penang) Sdn. Bhd.",
        "04:43:FD": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "A4:89:7E": "Guangzhou Yuhong Technology Co.,Ltd.",
        "E8:CC:8C": "Chengdu Jiarui Hualian Communication Technology Co",
        "5C:52:84": "Apple, Inc.",
        "C0:95:6D": "Apple, Inc.",
        "3C:39:C8": "Apple, Inc.",
        "20:9C:B4": "Aruba, a Hewlett Packard Enterprise Company",
        "EC:A1:38": "Amazon Technologies Inc.",
        "B0:67:B5": "Apple, Inc.",
        "90:0A:62": "Inventus Power Eletronica do Brasil LTDA",
        "70:54:B4": "Vestel Elektronik San ve Tic. A.S.",
        "04:BF:1B": "Dell Inc.",
        "08:1A:1E": "Shenzhen iComm Semiconductor CO.,LTD",
        "50:5F:B5": "ASKEY COMPUTER CORP",
        "88:DE:7C": "ASKEY COMPUTER CORP",
        "AC:31:84": "Huawei Device Co., Ltd.",
        "50:3F:50": "Huawei Device Co., Ltd.",
        "48:1C:B9": "SZ DJI TECHNOLOGY CO.,LTD",
        "B8:20:8E": "Panasonic Connect Co., Ltd.",
        "80:64:6F": "Espressif Inc.",
        "04:57:47": "GoPro",
        "F4:2B:7D": "Chipsguide technology CO.,LTD.",
        "8C:52:19": "SHARP Corporation",
        "E0:BA:AD": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "D4:2D:C5": "i-PRO Co., Ltd.",
        "EC:1D:9E": "Quectel Wireless Solutions Co.,Ltd.",
        "BC:D7:67": "BAE Systems Apllied Intelligence",
        "74:D4:23": "Amazon Technologies Inc.",
        "08:91:15": "Amazon Technologies Inc.",
        "2C:69:1D": "IEEE Registration Authority",
        "E0:47:35": "Ericsson AB",
        "80:39:8C": "Samsung Electronics Co.,Ltd",
        "98:0D:6F": "Samsung Electronics Co.,Ltd",
        "1C:90:FF": "Tuya Smart Inc.",
        "A0:44:F3": "RafaelMicro",
        "C4:04:D8": "Aviva Links Inc.",
        "E0:CA:3C": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "98:20:44": "New H3C Technologies Co., Ltd",
        "D8:A0:E8": "zte corporation",
        "DC:6A:E7": "Xiaomi Communications Co Ltd",
        "7C:A4:49": "Xiaomi Communications Co Ltd",
        "10:82:3D": "Ruijie Networks Co.,LTD",
        "90:98:77": "Vestel Elektronik San ve Tic. A.S.",
        "E0:CB:1D": "Amazon Technologies Inc.",
        "80:56:3C": "ZF",
        "D0:06:6A": "Cornelis Networks, Inc.",
        "2C:9E:00": "Sony Interactive Entertainment Inc.",
        "88:3C:93": "Alcatel-Lucent Enterprise",
        "AC:96:5B": "Lucid Motors",
        "84:AA:A4": "SONoC Corp.",
        "E8:BF:DB": "Inodesign Group",
        "28:7E:80": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "E8:FF:98": "Huawei Device Co., Ltd.",
        "24:15:51": "Huawei Device Co., Ltd.",
        "58:95:7E": "Huawei Device Co., Ltd.",
        "00:1A:0F": "ARTECHE GROUP",
        "B8:14:4D": "Apple, Inc.",
        "EC:28:D3": "Apple, Inc.",
        "08:65:18": "Apple, Inc.",
        "2C:57:CE": "Apple, Inc.",
        "0C:9F:71": "Dolphin Electronics (DongGuan) Co., Ltd.",
        "74:58:89": "Multilaser Industrial S.A.",
        "00:10:EC": "Embedded Planet",
        "FC:DF:00": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "F0:1A:A0": "Aruba, a Hewlett Packard Enterprise Company",
        "E4:8C:73": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "2C:94:52": "HUAWEI TECHNOLOGIES CO.,LTD",
        "60:01:B1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "1C:8B:76": "Calix Inc.",
        "2C:B6:C8": "Raisecom Technology CO., LTD",
        "D8:34:D1": "Shenzhen Orange Digital Technology Co.,Ltd",
        "C4:61:C7": "Microsoft Corporation",
        "AC:CB:36": "Fiberhome Telecommunication Technologies Co.,LTD",
        "C8:40:52": "PAX Computer Technology(Shenzhen) Ltd.",
        "00:1E:70": "Chelton Limited",
        "64:1A:22": "Heliospectra AB",
        "54:70:68": "VTech Communications Limited",
        "24:09:35": "Samsung Electronics Co.,Ltd",
        "84:22:89": "Samsung Electronics Co.,Ltd",
        "68:EE:4B": "Sharetronic Data Technology Co.,Ltd",
        "60:70:6C": "Google, Inc.",
        "C8:2A:DD": "Google, Inc.",
        "C0:A5:E8": "Intel Corporate",
        "90:65:84": "Intel Corporate",
        "28:C5:D2": "Intel Corporate",
        "AC:4C:A5": "Technicolor CH USA Inc.",
        "00:CB:7A": "Technicolor CH USA Inc.",
        "48:C3:5A": "LENOVO(BEIJING)CO., LTD.",
        "40:E1:1C": "shenzhen Cloud High Communication Technology Co.,Ltd",
        "C4:83:72": "IEEE Registration Authority",
        "B4:DB:91": "CELESTICA INC.",
        "C0:BF:AC": "Huawei Device Co., Ltd.",
        "44:27:2E": "Huawei Device Co., Ltd.",
        "08:1A:FD": "Huawei Device Co., Ltd.",
        "84:07:C4": "Carrier Corporation",
        "10:66:50": "Robert Bosch JuP1",
        "A8:0C:03": "Florawise",
        "CC:8D:B5": "Shenzhen SuperElectron Technology Co.,Ltd.",
        "AC:EE:64": "Shenzhen SuperElectron Technology Co.,Ltd.",
        "44:64:3C": "Cisco Systems, Inc",
        "24:16:1B": "Cisco Systems, Inc",
        "A8:40:0B": "Visteon Corporation",
        "00:12:F3": "u-blox AG",
        "18:18:8B": "FCNT LMITED",
        "3C:B0:7E": "Arounds Intelligent Equipment Co., Ltd.",
        "5C:A0:6C": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "C0:4E:8A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "08:56:9B": "WiZ",
        "20:31:8D": "Giax GmbH",
        "8C:94:6A": "New H3C Technologies Co., Ltd",
        "FC:11:65": "Cambium Networks Limited",
        "F8:00:9D": "INTRACOM DEFENSE S.A.",
        "20:16:42": "Microsoft Corporation",
        "A8:3B:76": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "48:E7:29": "Espressif Inc.",
        "90:DA:F9": "Siemens Rail Automation SAU",
        "E8:BA:E2": "Xplora Technologies AS",
        "90:27:78": "Open Infrastructure",
        "08:E6:3B": "zte corporation",
        "88:C1:74": "zte corporation",
        "CC:29:BD": "zte corporation",
        "BC:F8:8B": "zte corporation",
        "3C:A7:AE": "zte corporation",
        "9C:DE:4D": "ML vision Co.,LTD",
        "10:3C:59": "zte corporation",
        "78:90:A2": "zte corporation",
        "50:5D:7A": "zte corporation",
        "FC:33:57": "KAGA FEI Co., Ltd.",
        "5C:BB:EE": "zte corporation",
        "68:41:8F": "Telechips, Inc.",
        "BC:9E:BB": "Nintendo Co.,Ltd",
        "F8:F0:C5": "Suzhou Kuhan Information Technologies Co.,Ltd.",
        "F8:DE:73": "HUAWEI TECHNOLOGIES CO.,LTD",
        "EC:1A:02": "HUAWEI TECHNOLOGIES CO.,LTD",
        "3C:3B:99": "ITEL MOBILE LIMITED",
        "1C:1A:1B": "Shanghai Sunmi Technology Co.,Ltd.",
        "10:2E:00": "Intel Corporate",
        "80:38:D4": "Fibercentury Network Technology Co.,Ltd.",
        "7C:29:6F": "Apple, Inc.",
        "40:ED:CF": "Apple, Inc.",
        "8C:98:6B": "Apple, Inc.",
        "D0:39:57": "Liteon Technology Corporation",
        "1C:86:82": "Apple, Inc.",
        "80:54:E3": "Apple, Inc.",
        "D0:09:C8": "Cisco Systems, Inc",
        "FC:91:89": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "A8:16:9D": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "AC:AD:4B": "zte corporation",
        "20:3A:43": "Intel Corporate",
        "44:49:88": "Intel Corporate",
        "80:F7:A6": "Shenzhen C-Data Technology Co., Ltd.",
        "9C:54:40": "ChengDu TD Tech",
        "50:26:EF": "Murata Manufacturing Co., Ltd.",
        "74:05:7C": "Qorvo International Pte. Ltd.",
        "F0:22:1D": "IEEE Registration Authority",
        "94:1F:A2": "Wuhan YuXin Semiconductor Co., Ltd.",
        "6C:D1:99": "vivo Mobile Communication Co., Ltd.",
        "00:09:EE": "MEIKYO ELECTRIC CO.,LTD",
        "E8:26:B6": "Companies House to GlucoRx Technologies Ltd.",
        "80:AB:4D": "Nokia Solutions and Networks GmbH & Co. KG",
        "4C:BA:7D": "Gemtek Technology Co., Ltd.",
        "D0:40:BE": "NPO RPS LLC",
        "F4:4D:AD": "Cable Matters Inc.",
        "F0:4A:3D": "Bosch Thermotechnik GmbH",
        "B4:9D:FD": "Shenzhen SDMC Technology CO.,Ltd.",
        "80:76:C2": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "F8:D2:AC": "Technicolor CH USA Inc.",
        "B0:BC:7A": "Harman/Becker Automotive Systems GmbH",
        "A0:A0:01": "Aruba, a Hewlett Packard Enterprise Company",
        "DC:06:82": "Accessia Technology Ltd.",
        "78:49:46": "Cambridge Mobile Telematics, Inc.",
        "F4:1A:9C": "Xiaomi Communications Co Ltd",
        "00:1A:EB": "Allied Telesis K.K.",
        "DC:07:F8": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "34:87:3D": "Quectel Wireless Solutions Co.,Ltd.",
        "C4:41:37": "Quectel Wireless Solutions Co.,Ltd.",
        "10:D6:80": "Tendyron Corporation",
        "0C:FC:18": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:3E:73": "Mist Systems, Inc.",
        "44:D2:67": "Snorble",
        "84:90:0A": "Arcadyan Corporation",
        "8C:D0:B2": "Beijing Xiaomi Mobile Software Co., Ltd",
        "30:31:80": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "5C:3E:06": "Cisco Systems, Inc",
        "C8:28:E5": "Cisco Systems, Inc",
        "C4:A0:52": "Motorola Mobility LLC, a Lenovo Company",
        "B0:FC:88": "Sagemcom Broadband SAS",
        "78:76:89": "eero inc.",
        "0C:CC:47": "IEEE Registration Authority",
        "48:77:06": "NXP Semiconductor (Tianjin) LTD.",
        "E8:80:88": "LCFC(Hefei) Electronics Technology Co., Ltd",
        "BC:E8:FA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "00:FC:70": "Intrepid Control Systems, Inc.",
        "08:F1:B3": "Cisco Meraki",
        "08:C3:B3": "TCL King Electrical Appliances(Huizhou)Co.,Ltd",
        "20:45:69": "ITEL MOBILE LIMITED",
        "6C:0C:9A": "Amazon Technologies Inc.",
        "A4:C7:F6": "Extreme Networks, Inc.",
        "CC:00:F1": "Sagemcom Broadband SAS",
        "D4:63:52": "Vutility Inc.",
        "50:5A:65": "AzureWave Technology Inc.",
        "30:82:16": "Apple, Inc.",
        "C4:A5:59": "IEEE Registration Authority",
        "DC:AC:6F": "Everytale Inc",
        "F4:15:32": "PETAiO (NanJing), Inc.",
        "A8:B2:71": "HUAWEI TECHNOLOGIES CO.,LTD",
        "64:05:E4": "ALPSALPINE CO,.LTD",
        "BC:64:D9": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "30:1F:48": "zte corporation",
        "94:0E:E7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "7C:C7:4A": "Fiberhome Telecommunication Technologies Co.,LTD",
        "38:FC:34": "Huawei Device Co., Ltd.",
        "3C:F6:92": "Huawei Device Co., Ltd.",
        "28:B5:E8": "Texas Instruments",
        "48:29:E4": "AO ",
        "70:F8:AE": "Microsoft Corporation",
        "F8:3C:80": "MITSUMI ELECTRIC CO.,LTD.",
        "D8:3A:DD": "Raspberry Pi Trading Ltd",
        "64:EC:65": "vivo Mobile Communication Co., Ltd.",
        "F4:24:62": "Selcom Electronics (Shanghai) Co., Ltd",
        "F4:A1:7F": "Marquardt Electronics Technology (Shanghai) Co.Ltd",
        "48:BC:E1": "Samsung Electronics Co.,Ltd",
        "90:B4:DD": "Private",
        "B8:5C:EE": "Baidu Online Network Technology (Beijing) Co., Ltd",
        "8C:79:09": "Aruba, a Hewlett Packard Enterprise Company",
        "D0:D0:03": "Samsung Electronics Co.,Ltd",
        "5C:76:D5": "Nokia",
        "8C:7A:00": "Nokia",
        "B8:38:EF": "ADVA Optical Networking Ltd.",
        "B4:ED:D5": "Quectel Wireless Solutions Co.,Ltd.",
        "2C:D1:C6": "Murata Manufacturing Co., Ltd.",
        "F0:74:8D": "Ruijie Networks Co.,LTD",
        "08:42:18": "Asyril SA",
        "D8:5B:22": "Shenzhen Hohunet Technology Co., Ltd",
        "08:91:A3": "Amazon Technologies Inc.",
        "0C:D9:23": "GOCLOUD Networks(GAOKE Networks)",
        "90:9B:6F": "Apple, Inc.",
        "74:73:B4": "Apple, Inc.",
        "A4:FC:14": "Apple, Inc.",
        "A8:1A:F1": "Apple, Inc.",
        "98:0C:33": "Silicon Laboratories",
        "CC:08:FA": "Apple, Inc.",
        "70:58:46": "Trig Avionics Limited",
        "84:39:8F": "Fortinet, Inc.",
        "A4:A5:28": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "E8:78:EE": "New H3C Technologies Co., Ltd",
        "EC:A7:AD": "Barrot Technology Co.,Ltd.",
        "9C:DB:AF": "HUAWEI TECHNOLOGIES CO.,LTD",
        "0C:2E:57": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E8:D7:75": "HUAWEI TECHNOLOGIES CO.,LTD",
        "44:DB:D2": "YEALINK(XIAMEN) NETWORK TECHNOLOGY CO.,LTD.",
        "5C:64:F1": "Cisco Systems, Inc",
        "00:30:2B": "Inalp Solutions AG",
        "1C:3B:62": "HMD Global Oy",
        "24:48:45": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "E0:DC:A0": "Siemens Industrial Automation Products Ltd., Chengdu",
        "88:58:BE": "kuosheng.com",
        "F4:64:12": "Sony Interactive Entertainment Inc.",
        "7C:4D:8F": "HP Inc.",
        "3C:F9:F0": "zte corporation",
        "68:77:DA": "zte corporation",
        "74:D5:58": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "9C:CB:F7": "CLOUD STAR TECHNOLOGY CO., LTD.",
        "48:81:4E": "E&M SOLUTION CO,.Ltd",
        "AC:80:0A": "Sony Corporation",
        "B8:EA:98": "Xiaomi Communications Co Ltd",
        "78:8C:B5": "TP-Link Corporation Limited",
        "10:C4:CA": "HUMAX Co., Ltd.",
        "58:C9:35": "Chiun Mai Communication System, Inc",
        "BC:49:B2": "SHENZHEN ALONG COMMUNICATION TECH CO., LTD",
        "94:97:AE": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "0C:BD:75": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "AC:90:73": "HUAWEI TECHNOLOGIES CO.,LTD",
        "FC:1D:3A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "54:8C:81": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "88:B6:BD": "Flaircomm Microelectronics, Inc.",
        "00:50:CA": "DZS Inc.",
        "74:EE:8D": "Apollo Intelligent Connectivity (Beijing) Technology Co., Ltd.",
        "F0:9F:C2": "Ubiquiti Inc",
        "80:2A:A8": "Ubiquiti Inc",
        "78:8A:20": "Ubiquiti Inc",
        "74:83:C2": "Ubiquiti Inc",
        "E0:63:DA": "Ubiquiti Inc",
        "24:5A:4C": "Ubiquiti Inc",
        "E4:BE:FB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "58:F8:D7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "60:22:32": "Ubiquiti Inc",
        "E4:38:83": "Ubiquiti Inc",
        "00:03:51": "Diebold Nixdorf",
        "9C:FF:C2": "AVI Systems GmbH",
        "44:D8:78": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "A0:D8:07": "Huawei Device Co., Ltd.",
        "2C:78:0E": "Huawei Device Co., Ltd.",
        "34:B2:0A": "Huawei Device Co., Ltd.",
        "98:F4:AB": "Espressif Inc.",
        "D8:BF:C0": "Espressif Inc.",
        "20:26:81": "TECNO MOBILE LIMITED",
        "F4:D6:20": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "64:FB:92": "PPC Broadband Inc.",
        "14:13:46": "Skyworth Digital Technology(Shenzhen) Co.,Ltd",
        "94:90:34": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD",
        "98:7A:10": "Ericsson AB",
        "54:2B:DE": "New H3C Technologies Co., Ltd",
        "98:F7:81": "ARRIS Group, Inc.",
        "78:97:C3": "DINGXIN INFORMATION TECHNOLOGY CO.,LTD",
        "4C:90:DB": "JL Audio",
        "B8:99:AE": "Shenzhen MiaoMing  Intelligent Technology Co.,Ltd",
        "E8:D0:B9": "Taicang T&W Electronics",
        "3C:8F:06": "Shenzhen Libtor Technology Co.,Ltd",
        "B0:08:75": "HUAWEI TECHNOLOGIES CO.,LTD",
        "8C:F1:12": "Motorola Mobility LLC, a Lenovo Company",
        "84:76:37": "HUAWEI TECHNOLOGIES CO.,LTD",
        "FC:94:35": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E0:24:81": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A8:C0:EA": "Pepwave Limited",
        "18:2A:D3": "Juniper Networks",
        "80:B0:7B": "zte corporation",
        "C8:5A:9F": "zte corporation",
        "44:AE:AB": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "A4:F0:5E": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "1C:68:7E": "Shenzhen Qihu Intelligent Technology Company Limited",
        "C0:36:56": "Fiberhome Telecommunication Technologies Co.,LTD",
        "58:85:A2": "Realme Chongqing MobileTelecommunications Corp Ltd",
        "2C:F8:9B": "Cisco Systems, Inc",
        "00:07:1C": "AT&T",
        "E0:E8:E6": "Shenzhen C-Data Technology Co., Ltd.",
        "50:02:91": "Espressif Inc.",
        "00:1D:DF": "Sunitec Enterprise Co.,Ltd",
        "8C:0F:FA": "Hutec co.,ltd",
        "AC:FE:05": "ITEL MOBILE LIMITED",
        "78:2A:79": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "78:65:59": "Sagemcom Broadband SAS",
        "50:D2:F5": "Beijing Xiaomi Mobile Software Co., Ltd",
        "24:52:6A": "Zhejiang Dahua Technology Co., Ltd.",
        "20:DF:B9": "Google, Inc.",
        "5C:CA:D3": "CHIPSEA TECHNOLOGIES (SHENZHEN) CORP.",
        "28:16:7F": "Xiaomi Communications Co Ltd",
        "5C:E8:83": "HUAWEI TECHNOLOGIES CO.,LTD",
        "10:01:77": "HUAWEI TECHNOLOGIES CO.,LTD",
        "44:A1:91": "HUAWEI TECHNOLOGIES CO.,LTD",
        "60:23:A4": "Sichuan AI-Link Technology Co., Ltd.",
        "A4:53:0E": "Cisco Systems, Inc",
        "00:40:3A": "IMPACT TECHNOLOGIES",
        "F8:87:F1": "Apple, Inc.",
        "9C:28:BF": "Continental Automotive Czech Republic s.r.o.",
        "74:D6:37": "Amazon Technologies Inc.",
        "D0:5F:64": "IEEE Registration Authority",
        "BC:C3:1B": "Kygo Life A",
        "64:DF:10": "JingLue Semiconductor(SH) Ltd.",
        "C4:63:FB": "Neatframe AS",
        "0C:81:26": "Juniper Networks",
        "30:57:14": "Apple, Inc.",
        "60:44:7A": "Water-i.d. GmbH",
        "C8:B1:CD": "Apple, Inc.",
        "14:60:CB": "Apple, Inc.",
        "B8:F1:2A": "Apple, Inc.",
        "04:AB:6A": "Chun-il Co.,Ltd.",
        "54:4E:45": "Private",
        "04:C8:07": "Xiaomi Communications Co Ltd",
        "04:A2:22": "Arcadyan Corporation",
        "48:9B:D5": "Extreme Networks, Inc.",
        "3C:8C:93": "Juniper Networks",
        "28:FE:65": "DongGuan Siyoto Electronics Co., Ltd       ",
        "18:06:F5": "RAD Data Communications, Ltd.",
        "74:84:E1": "Dongguan Haoyuan Electronics Co.,Ltd",
        "44:FB:5A": "zte corporation",
        "44:59:E3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "DC:54:D7": "Amazon Technologies Inc.",
        "44:D3:CA": "Cisco Systems, Inc",
        "88:9F:AA": "Hella Gutmann Solutions GmbH ",
        "E4:54:E8": "Dell Inc.",
        "20:96:8A": "China Mobile (Hangzhou) Information Technology Co., Ltd.",
        "8C:18:50": "China Mobile (Hangzhou) Information Technology Co., Ltd.",
        "D8:D4:E6": "Hytec Inter Co., Ltd.",
        "68:3F:1E": "EFFECT Photonics B.V.",
        "00:35:FF": "Texas Instruments",
        "F8:E7:A0": "vivo Mobile Communication Co., Ltd.",
        "2C:FF:EE": "vivo Mobile Communication Co., Ltd.",
        "84:0B:7C": "Hitron Technologies. Inc",
        "48:A7:3C": "Sichuan tianyi kanghe communications co., LTD",
        "C8:5D:38": "HUMAX Co., Ltd.",
        "F8:A7:63": "Zhejiang Tmall Technology Co., Ltd.",
        "A4:98:13": "ARRIS Group, Inc.",
        "6C:29:90": "WiZ Connected Lighting Company Limited",
        "98:35:ED": "HUAWEI TECHNOLOGIES CO.,LTD",
        "08:4F:0A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A8:49:4D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "44:00:4D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "18:CF:24": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D8:9B:3B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "88:40:3B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "FC:87:43": "HUAWEI TECHNOLOGIES CO.,LTD",
        "80:76:93": "Newag SA",
        "BC:97:40": "IEEE Registration Authority",
        "04:88:5F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C8:50:CE": "HUAWEI TECHNOLOGIES CO.,LTD",
        "50:F8:A5": "eWBM Co., Ltd.",
        "14:49:BC": "DrayTek Corp.",
        "20:F4:78": "Xiaomi Communications Co Ltd",
        "90:73:5A": "Motorola Mobility LLC, a Lenovo Company",
        "1C:82:59": "IEEE Registration Authority",
        "00:04:DF": "TERACOM TELEMATICA S.A",
        "74:38:B7": "CANON INC.",
        "8C:04:BA": "Dell Inc.",
        "00:FA:21": "Samsung Electronics Co.,Ltd",
        "7C:23:02": "Samsung Electronics Co.,Ltd",
        "18:B6:F7": "NEW POS TECHNOLOGY LIMITED",
        "5C:B1:5F": "Oceanblue Cloud Technology Limited",
        "18:AA:CA": "Sichuan tianyi kanghe communications co., LTD",
        "D4:9D:C0": "Samsung Electronics Co.,Ltd",
        "D0:19:6A": "Ciena Corporation",
        "44:13:D0": "zte corporation",
        "24:62:AB": "Espressif Inc.",
        "6C:AB:05": "Cisco Systems, Inc",
        "00:0B:E4": "Hosiden Corporation",
        "60:D2:48": "ARRIS Group, Inc.",
        "48:5D:EB": "Just Add Power",
        "50:13:95": "Sichuan AI-Link Technology Co., Ltd.",
        "18:D9:EF": "Shuttle Inc.",
        "88:DA:33": "Beijing Xiaoyuer Network Technology Co., Ltd",
        "50:41:B9": "I-O DATA DEVICE,INC.",
        "80:DA:BC": "Megafone Limited",
        "C0:9F:E1": "zte corporation",
        "18:46:44": "Home Control Singapore Pte Ltd",
        "B0:70:0D": "Nokia",
        "34:6B:5B": "New H3C Technologies Co., Ltd",
        "84:E8:92": "Actiontec Electronics, Inc",
        "78:E2:BD": "Vodafone Automotive S.p.A.",
        "F8:48:FD": "China Mobile Group Device Co.,Ltd.",
        "20:DA:22": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C8:21:DA": "Shenzhen YOUHUA Technology Co., Ltd",
        "E0:B6:55": "Beijing Xiaomi Electronics Co., Ltd.",
        "00:21:75": "Pacific Satellite International Ltd.",
        "88:97:46": "Sichuan AI-Link Technology Co., Ltd.",
        "1C:DE:57": "Fiberhome Telecommunication Technologies Co.,LTD",
        "E0:DC:FF": "Xiaomi Communications Co Ltd",
        "00:77:8D": "Cisco Systems, Inc",
        "00:0E:8C": "Siemens AG",
        "00:87:64": "Cisco Systems, Inc",
        "FC:33:42": "Juniper Networks",
        "C4:68:D0": "VTech Telecommunications Ltd.",
        "14:AE:DB": "VTech Telecommunications Ltd.",
        "78:DB:2F": "Texas Instruments",
        "8C:0F:A0": "di-soric GmbH & Co. KG",
        "DC:B8:08": "Extreme Networks, Inc.",
        "B0:E7:1D": "Shanghai Maigantech Co.,Ltd",
        "F8:BB:BF": "eero inc.",
        "84:6F:CE": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "20:65:8E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "18:3D:5E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "DC:71:37": "zte corporation",
        "84:7C:9B": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "34:41:A8": "ER-Telecom",
        "34:DB:9C": "Sagemcom Broadband SAS",
        "74:40:BE": "LG Innotek",
        "04:D4:C4": "ASUSTek COMPUTER INC.",
        "F0:D4:E2": "Dell Inc.",
        "A8:E2:C3": "Shenzhen YOUHUA Technology Co., Ltd",
        "90:20:C2": "Aruba, a Hewlett Packard Enterprise Company",
        "0C:A0:6C": "Industrial Cyber Sensing Inc.",
        "FC:D2:B6": "IEEE Registration Authority",
        "80:4A:14": "Apple, Inc.",
        "70:3C:69": "Apple, Inc.",
        "AC:2D:A9": "TECNO MOBILE LIMITED",
        "48:04:9F": "ELECOM CO., LTD",
        "08:7F:98": "vivo Mobile Communication Co., Ltd.",
        "C8:52:61": "ARRIS Group, Inc.",
        "74:88:BB": "Cisco Systems, Inc",
        "A4:CF:12": "Espressif Inc.",
        "4C:6A:F6": "HMD Global Oy",
        "48:9D:D1": "Samsung Electronics Co.,Ltd",
        "B0:6F:E0": "Samsung Electronics Co.,Ltd",
        "44:B9:94": "Douglas Lighting Controls",
        "40:A9:3F": "Pivotal Commware, Inc.",
        "70:BF:92": "GN Audio A/S",
        "C0:8C:71": "Motorola Mobility LLC, a Lenovo Company",
        "F4:6F:4E": "Echowell",
        "5C:88:16": "Rockwell Automation",
        "00:2F:5C": "Cisco Systems, Inc",
        "F4:64:5D": "Toshiba",
        "38:F8:5E": "HUMAX Co., Ltd.",
        "AC:BB:61": "YSTen Technology Co.,Ltd",
        "24:79:F8": "KUPSON spol. s r.o.",
        "7C:FD:82": "GUANGDONG GENIUS TECHNOLOGY CO., LTD.",
        "18:0D:2C": "Intelbras",
        "04:2D:B4": "First Property (Beijing) Co., Ltd Modern MOMA Branch",
        "04:E0:B0": "Shenzhen YOUHUA Technology Co., Ltd",
        "08:EC:F5": "Cisco Systems, Inc",
        "D0:76:50": "IEEE Registration Authority",
        "60:D0:A9": "Samsung Electronics Co.,Ltd",
        "88:CE:FA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:27:06": "YOISYS",
        "00:CB:51": "Sagemcom Broadband SAS",
        "C4:64:B7": "Fiberhome Telecommunication Technologies Co.,LTD",
        "EC:41:18": "XIAOMI Electronics,CO.,LTD",
        "D8:86:0B": "IEEE Registration Authority",
        "34:20:03": "Shenzhen Feitengyun Technology Co.,LTD",
        "F0:7D:68": "D-Link Corporation",
        "40:E3:D6": "Aruba, a Hewlett Packard Enterprise Company",
        "B4:5D:50": "Aruba, a Hewlett Packard Enterprise Company",
        "78:DA:A2": "Cynosure Technologies Co.,Ltd",
        "38:B1:9E": "IEEE Registration Authority",
        "38:E2:6E": "ShenZhen Sweet Rain Electronics Co.,Ltd.",
        "00:D0:50": "Iskratel d.o.o.",
        "70:C9:C6": "Cisco Systems, Inc",
        "D4:B9:2F": "Technicolor CH USA Inc.",
        "68:9A:87": "Amazon Technologies Inc.",
        "64:AE:88": "Polytec GmbH",
        "AC:A3:1E": "Aruba, a Hewlett Packard Enterprise Company",
        "00:17:7B": "Azalea Networks inc",
        "98:DA:C4": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "50:2B:98": "Es-tech International",
        "C8:28:32": "Beijing Xiaomi Electronics Co., Ltd.",
        "94:6A:77": "Technicolor CH USA Inc.",
        "C4:34:6B": "Hewlett Packard",
        "80:84:A9": "oshkosh Corporation",
        "F4:6E:95": "Extreme Networks, Inc.",
        "4C:C7:D6": "FLEXTRONICS MANUFACTURING(ZHUHAI)CO.,LTD.",
        "C8:08:73": "Ruckus Wireless",
        "70:1B:FB": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "00:1B:B5": "Cherry GmbH",
        "D0:51:57": "LEAX Arkivator Telecom",
        "28:80:88": "NETGEAR",
        "64:CE:6E": "Sierra Wireless",
        "1C:34:77": "Innovation Wireless",
        "BC:3E:07": "Hitron Technologies. Inc",
        "48:FD:A3": "Xiaomi Communications Co Ltd",
        "00:16:97": "NEC Corporation",
        "00:30:13": "NEC Corporation",
        "04:9D:FE": "Hivesystem",
        "DC:EB:69": "Technicolor CH USA Inc.",
        "00:4E:35": "Hewlett Packard Enterprise",
        "F8:13:08": "Nokia",
        "F8:A2:D6": "Liteon Technology Corporation",
        "18:2A:44": "HIROSE ELECTRONIC SYSTEM",
        "FC:94:CE": "zte corporation",
        "90:86:9B": "zte corporation",
        "E0:18:9F": "EM Microelectronic",
        "74:36:6D": "Vodafone Italia S.p.A.",
        "84:DB:2F": "Sierra Wireless",
        "94:58:CB": "Nintendo Co.,Ltd",
        "28:EC:9A": "Texas Instruments",
        "FC:BE:7B": "vivo Mobile Communication Co., Ltd.",
        "B4:0F:B3": "vivo Mobile Communication Co., Ltd.",
        "EC:5C:68": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "C4:E5:06": "Piper Networks, Inc.",
        "30:EB:5A": "LANDIS + GYR",
        "F8:0F:6F": "Cisco Systems, Inc",
        "00:80:E3": "CORAL NETWORK CORPORATION",
        "B4:C6:2E": "Molex CMS",
        "B8:25:9A": "Thalmic Labs ",
        "28:25:36": "SHENZHEN HOLATEK CO.,LTD",
        "B8:A1:75": "Roku, Inc.",
        "0C:D0:F8": "Cisco Systems, Inc",
        "74:5F:90": "LAM Technologies",
        "A4:26:55": "LTI Motion (Shanghai) Co., Ltd.",
        "60:A7:30": "Shenzhen Yipinfang Internet Technology Co.,Ltd",
        "3C:9B:D6": "Vizio, Inc",
        "F8:5B:9C": "SB SYSTEMS Co.,Ltd",
        "6C:A9:28": "HMD Global Oy",
        "00:D8:61": "Micro-Star INTL CO., LTD.",
        "74:C1:7D": "Infinix mobility limited",
        "88:71:B1": "ARRIS Group, Inc.",
        "F0:AF:85": "ARRIS Group, Inc.",
        "FC:AE:34": "ARRIS Group, Inc.",
        "DC:DA:80": "New H3C Technologies Co., Ltd",
        "CC:72:86": "Xi'an Fengyu Information Technology Co., Ltd.",
        "64:EE:B7": "Netcore Technology Inc",
        "38:81:D7": "Texas Instruments",
        "18:04:ED": "Texas Instruments",
        "D4:32:60": "GoPro",
        "50:DB:3F": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "10:81:B4": "Hunan Greatwall Galaxy Science and Technology Co.,Ltd.",
        "00:42:79": "Sunitec Enterprise Co.,Ltd",
        "00:B8:B3": "Cisco Systems, Inc",
        "F4:DD:9E": "GoPro",
        "D4:D9:19": "GoPro",
        "14:11:14": "TECNO MOBILE LIMITED",
        "A4:50:46": "Xiaomi Communications Co Ltd",
        "00:7C:2D": "Samsung Electronics Co.,Ltd",
        "B4:77:48": "Shenzhen Neoway Technology Co.,Ltd.",
        "F8:50:1C": "Tianjin Geneuo Technology Co.,Ltd",
        "44:07:0B": "Google, Inc.",
        "B8:31:B5": "Microsoft Corporation",
        "EC:F6:BD": "SNCF MOBILITÉS",
        "38:B4:D3": "BSH Hausgeraete GmbH",
        "C8:47:82": "Areson Technology Corp.",
        "E8:93:63": "Nokia",
        "7C:0C:F6": "Guangdong Huiwei High-tech Co., Ltd.",
        "74:9D:79": "Sercomm Corporation.",
        "00:D6:FE": "Cisco Systems, Inc",
        "0C:BF:74": "Morse Micro",
        "FC:8F:7D": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "24:BE:18": "DADOUTEK COMPANY LIMITED",
        "B4:1D:2B": "Shenzhen YOUHUA Technology Co., Ltd",
        "14:C2:13": "Apple, Inc.",
        "70:D3:13": "HUAWEI TECHNOLOGIES CO.,LTD",
        "9C:1D:36": "HUAWEI TECHNOLOGIES CO.,LTD",
        "CC:BB:FE": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A4:D9:31": "Apple, Inc.",
        "BC:FE:D9": "Apple, Inc.",
        "80:82:23": "Apple, Inc.",
        "30:0A:60": "IEEE Registration Authority",
        "80:D0:65": "CKS Corporation",
        "28:31:66": "vivo Mobile Communication Co., Ltd.",
        "C0:40:04": "Medicaroid Corporation",
        "20:AD:56": "Continental Automotive Systems Inc.",
        "50:29:F5": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "CC:08:FB": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "BC:AF:91": "TE Connectivity Sensor Solutions",
        "F0:D7:DC": "Wesine (Wuhan) Technology Co., Ltd.",
        "00:72:04": "Samsung Electronics Co., Ltd. ARTIK",
        "40:C8:1F": "Shenzhen Xinguodu Technology Co., Ltd.",
        "14:59:C0": "NETGEAR",
        "8C:61:A3": "ARRIS Group, Inc.",
        "A8:10:87": "Texas Instruments",
        "A0:28:33": "IEEE Registration Authority",
        "C8:C2:F5": "FLEXTRONICS MANUFACTURING(ZHUHAI)CO.,LTD.",
        "F0:58:49": "CareView Communications",
        "34:E5:EC": "Palo Alto Networks",
        "A4:ED:43": "IEEE Registration Authority",
        "94:29:8D": "Shanghai AdaptComm Technology Co., Ltd.",
        "00:AA:6E": "Cisco Systems, Inc",
        "68:43:D7": "Agilecom Photonics Solutions Guangdong Limited",
        "20:D8:0B": "Juniper Networks",
        "8C:8F:8B": "China Mobile Chongqing branch",
        "B8:6A:97": "Edgecore Networks Corporation",
        "00:0A:5E": "3COM",
        "00:10:5A": "3COM",
        "00:60:97": "3COM",
        "00:60:08": "3COM",
        "00:1B:6E": "Keysight Technologies, Inc.",
        "00:04:0B": "3COM EUROPE LTD",
        "00:01:02": "3COM",
        "8C:FE:74": "Ruckus Wireless",
        "A8:01:6D": "Aiwa Corporation",
        "04:40:A9": "New H3C Technologies Co., Ltd",
        "4C:01:43": "eero inc.",
        "E4:34:93": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:29:12": "HUAWEI TECHNOLOGIES CO.,LTD",
        "60:4B:AA": "Magic Leap, Inc.",
        "BC:A5:8B": "Samsung Electronics Co.,Ltd",
        "80:CE:B9": "Samsung Electronics Co.,Ltd",
        "D0:D3:FC": "Mios, Ltd.",
        "6C:6C:D3": "Cisco Systems, Inc",
        "E0:49:ED": "Audeze LLC",
        "80:30:E0": "Hewlett Packard Enterprise",
        "E8:5D:86": "CHANG YOW TECHNOLOGIES INTERNATIONAL CO.,LTD.",
        "14:37:19": "PT Prakarsa Visi Valutama",
        "58:2F:40": "Nintendo Co.,Ltd",
        "08:90:BA": "Danlaw Inc",
        "94:A3:CA": "KonnectONE, LLC",
        "24:4C:E3": "Amazon Technologies Inc.",
        "B8:BE:F4": "devolo AG",
        "00:01:57": "SYSWAVE CO., LTD",
        "58:FD:BE": "Shenzhen Taikaida Technology Co., Ltd",
        "F4:F1:97": "EMTAKE Inc",
        "6C:ED:51": "NEXCONTROL Co.,Ltd",
        "04:C3:E6": "IEEE Registration Authority",
        "28:63:36": "Siemens AG",
        "14:D1:69": "HUAWEI TECHNOLOGIES CO.,LTD",
        "10:62:E5": "Hewlett Packard",
        "00:20:B5": "YASKAWA ELECTRIC CORPORATION",
        "E0:62:67": "Xiaomi Communications Co Ltd",
        "70:B7:AA": "vivo Mobile Communication Co., Ltd.",
        "84:B3:1B": "Kinexon GmbH",
        "08:25:25": "Xiaomi Communications Co Ltd",
        "C4:95:00": "Amazon Technologies Inc.",
        "F4:60:E2": "Xiaomi Communications Co Ltd",
        "E4:D1:24": "Mojo Networks, Inc.",
        "00:13:A3": "Siemens Home & Office Comm. Devices",
        "B0:B8:67": "Hewlett Packard Enterprise",
        "C0:03:80": "Juniper Networks",
        "98:BB:99": "Phicomm (Sichuan) Co.,Ltd.",
        "00:26:22": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "F8:27:2E": "Mercku",
        "9C:C9:50": "Baumer Holding",
        "F8:99:10": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "50:E0:EF": "Nokia",
        "84:8A:8D": "Cisco Systems, Inc",
        "1C:C3:EB": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "50:4C:7E": "THE 41ST INSTITUTE OF CETC",
        "00:14:13": "Trebing & Himstedt Prozeßautomation GmbH & Co. KG",
        "00:07:99": "Tipping Point Technologies, Inc.",
        "D0:1C:BB": "Beijing Ctimes Digital Technology Co., Ltd.",
        "74:87:BB": "Ciena Corporation",
        "68:DD:26": "Shanghai Focus Vision Security Technology Co.,Ltd",
        "28:66:E3": "AzureWave Technology Inc.",
        "60:F1:8A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "EC:38:73": "Juniper Networks",
        "78:04:73": "Texas Instruments",
        "A8:3E:0E": "HMD Global Oy",
        "10:C1:72": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:15:1E": "ETHERNET Powerlink Standarization Group (EPSG)",
        "00:11:1E": "ETHERNET Powerlink Standarization Group (EPSG)",
        "00:40:9D": "DigiBoard",
        "CC:50:E3": "Espressif Inc.",
        "A4:DA:32": "Texas Instruments",
        "00:0E:EE": "Muco Industrie BV",
        "7C:1C:4E": "LG Innotek",
        "D8:B6:B7": "Comtrend Corporation",
        "00:21:06": "RIM Testing Services",
        "8C:14:B4": "zte corporation",
        "3C:98:72": "Sercomm Corporation.",
        "40:C3:C6": "SnapRoute",
        "5C:96:56": "AzureWave Technology Inc.",
        "E0:60:66": "Sercomm Corporation.",
        "14:93:46": "PNI sensor corporation",
        "DC:E0:EB": "Nanjing Aozheng Information Technology Co.Ltd",
        "EC:8C:9A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B4:86:55": "HUAWEI TECHNOLOGIES CO.,LTD",
        "2C:47:59": "Beijing MEGA preponderance Science & Technology Co. Ltd",
        "A4:15:66": "WEIFANG GOERTEK ELECTRONICS CO.,LTD",
        "1C:96:5A": "WEIFANG GOERTEK ELECTRONICS CO.,LTD",
        "40:1B:5F": "WEIFANG GOERTEK ELECTRONICS CO.,LTD",
        "A8:E5:52": "JUWEL Aquarium AG & Co. KG",
        "5C:CD:7C": "MEIZU Technology Co.,Ltd.",
        "00:13:8A": "Qingdao GoerTek Technology Co., Ltd.",
        "A8:30:AD": "WEIFANG GOERTEK ELECTRONICS CO.,LTD",
        "BC:5F:F6": "MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "C8:E7:D8": "MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "60:D2:1C": "Sunnovo International Limited",
        "CC:51:B4": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "00:C3:F4": "Samsung Electronics Co.,Ltd",
        "B8:8A:EC": "Nintendo Co.,Ltd",
        "D0:D7:83": "HUAWEI TECHNOLOGIES CO.,LTD",
        "AC:3B:77": "Sagemcom Broadband SAS",
        "B0:FC:0D": "Amazon Technologies Inc.",
        "CC:C9:2C": "Schindler - PORT Technology",
        "00:1E:39": "Comsys Communication Ltd.",
        "78:72:5D": "Cisco Systems, Inc",
        "FC:E6:6A": "Industrial Software Co",
        "78:36:CC": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "8C:CF:5C": "BEFEGA GmbH",
        "70:C8:33": "Wirepas Oy",
        "0C:73:EB": "IEEE Registration Authority",
        "04:8A:E1": "FLEXTRONICS MANUFACTURING(ZHUHAI)CO.,LTD.",
        "F0:B5:D1": "Texas Instruments",
        "00:E0:00": "FUJITSU LIMITED",
        "90:84:8B": "HDR10+ Technologies, LLC",
        "C8:D7:79": "QING DAO HAIER TELECOM CO.,LTD.",
        "10:B3:6F": "Bowei Technology Company Limited ",
        "FC:9B:C6": "Sumavision Technologies Co.,Ltd",
        "C8:29:2A": "Barun Electronics",
        "E4:82:CC": "Jumptronic GmbH",
        "48:60:5F": "LG Electronics (Mobile Communications)",
        "B0:41:6F": "Shenzhen Maxtang Computer Co.,Ltd",
        "50:1D:93": "HUAWEI TECHNOLOGIES CO.,LTD",
        "28:16:A8": "Microsoft Corporation",
        "F8:F5:32": "ARRIS Group, Inc.",
        "B0:83:D6": "ARRIS Group, Inc.",
        "80:C7:C5": "Fiberhome Telecommunication Technologies Co.,LTD",
        "E4:43:4B": "Dell Inc.",
        "0C:F5:A4": "Cisco Systems, Inc",
        "9C:2E:A1": "Xiaomi Communications Co Ltd",
        "08:97:34": "Hewlett Packard Enterprise",
        "F0:9C:D7": "Guangzhou Blue Cheetah Intelligent Technology Co., Ltd.",
        "BC:E1:43": "Apple, Inc.",
        "64:70:33": "Apple, Inc.",
        "84:68:78": "Apple, Inc.",
        "C8:D0:83": "Apple, Inc.",
        "0C:6A:BC": "Fiberhome Telecommunication Technologies Co.,LTD",
        "00:80:BA": "SPECIALIX (ASIA) PTE, LTD",
        "48:0B:B2": "IEEE Registration Authority",
        "CC:C0:79": "Murata Manufacturing Co., Ltd.",
        "E0:19:D8": "BH TECHNOLOGIES",
        "60:30:D4": "Apple, Inc.",
        "F8:95:EA": "Apple, Inc.",
        "18:F1:D8": "Apple, Inc.",
        "3C:CD:5D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "7C:76:68": "HUAWEI TECHNOLOGIES CO.,LTD",
        "6C:38:38": "Marking System Technology Co., Ltd.",
        "30:D9:D9": "Apple, Inc.",
        "78:0F:77": "HangZhou Gubei Electronics Technology Co.,Ltd",
        "A4:38:CC": "Nintendo Co.,Ltd",
        "74:72:1E": "Edison Labs Inc.",
        "8C:4C:DC": "PLANEX COMMUNICATIONS INC.",
        "50:65:F3": "Hewlett Packard",
        "3C:95:09": "Liteon Technology Corporation",
        "BC:AB:7C": "TRnP KOREA Co Ltd",
        "64:CB:5D": "SIA TeleSet",
        "58:21:E9": "TWPI",
        "C4:9F:4C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "0C:70:4A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F0:E3:DC": "Tecon MT, LLC",
        "A8:DA:01": "Shenzhen NUOLIJIA Digital Technology Co.,Ltd",
        "7C:25:86": "Juniper Networks",
        "F0:41:C8": "IEEE Registration Authority",
        "CC:99:16": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "EC:7F:C6": "ECCEL CORPORATION SAS",
        "4C:AB:FC": "zte corporation",
        "00:10:D8": "CALISTA",
        "00:21:94": "Ping Communication",
        "5C:5A:EA": "FORD",
        "00:0B:7B": "Test-Um Inc.",
        "30:FD:38": "Google, Inc.",
        "00:13:86": "ABB Inc/Totalflow",
        "00:3C:10": "Cisco Systems, Inc",
        "54:A6:5C": "Technicolor CH USA Inc.",
        "BC:DD:C2": "Espressif Inc.",
        "98:D8:63": "Shanghai High-Flying Electronics Technology Co., Ltd",
        "0C:F3:46": "Xiaomi Communications Co Ltd",
        "7C:FF:4D": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "C8:8F:26": "Skyworth Digital Technology(Shenzhen) Co.,Ltd",
        "70:3A:73": "Shenzhen Sundray Technologies Company Limited",
        "10:F9:EB": "Industria Fueguina de Relojería Electrónica s.a.",
        "80:AD:16": "Xiaomi Communications Co Ltd",
        "04:4E:AF": "LG Innotek",
        "18:94:C6": "ShenZhen Chenyee Technology Co., Ltd.",
        "40:BD:32": "Texas Instruments",
        "CC:8E:71": "Cisco Systems, Inc",
        "38:F5:54": "HISENSE ELECTRIC CO.,LTD",
        "88:E9:0F": "innomdlelab",
        "00:30:74": "EQUIINET LTD.",
        "EC:9B:8B": "Hewlett Packard Enterprise",
        "B0:B3:AD": "HUMAX Co., Ltd.",
        "18:A2:8A": "Essel-T Co., Ltd",
        "20:36:5B": "Megafone Limited",
        "E8:DE:00": "ChongQing GuanFang Technology Co.,LTD",
        "70:C9:4E": "Liteon Technology Corporation",
        "70:D0:81": "Beijing Netpower Technologies Inc.",
        "FC:64:3A": "Samsung Electronics Co.,Ltd",
        "A8:51:5B": "Samsung Electronics Co.,Ltd",
        "54:B7:E5": "Rayson Technology Co., Ltd.",
        "94:63:72": "vivo Mobile Communication Co., Ltd.",
        "BC:0F:A7": "Ouster",
        "F8:C1:20": "Xi'an Link-Science Technology Co.,Ltd",
        "F0:C9:D1": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "34:7E:5C": "Sonos, Inc.",
        "B4:FB:F9": "HUAWEI TECHNOLOGIES CO.,LTD",
        "50:6F:77": "HUAWEI TECHNOLOGIES CO.,LTD",
        "0C:41:E9": "HUAWEI TECHNOLOGIES CO.,LTD",
        "3C:E8:24": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:5A:06": "SHARP Corporation",
        "00:19:36": "STERLITE OPTICAL TECHNOLOGIES LIMITED",
        "B8:9F:09": "Wistron Neweb Corporation",
        "04:02:CA": "Shenzhen Vtsonic Co.,ltd",
        "3C:FB:5C": "Fiberhome Telecommunication Technologies Co.,LTD",
        "74:40:BB": "Hon Hai Precision Ind. Co.,Ltd.",
        "1C:11:61": "Ciena Corporation",
        "B4:DE:31": "Cisco Systems, Inc",
        "A4:40:27": "zte corporation",
        "B4:F7:A1": "LG Electronics (Mobile Communications)",
        "28:ED:E0": "AMPAK Technology, Inc.",
        "88:BD:45": "Samsung Electronics Co.,Ltd",
        "54:FC:F0": "Samsung Electronics Co.,Ltd",
        "30:6A:85": "Samsung Electronics Co.,Ltd",
        "4C:DD:31": "Samsung Electronics Co.,Ltd",
        "88:B6:EE": "Dish Technologies Corp",
        "70:F2:20": "Actiontec Electronics, Inc",
        "D0:81:7A": "Apple, Inc.",
        "98:CA:33": "Apple, Inc.",
        "68:AB:1E": "Apple, Inc.",
        "70:EF:00": "Apple, Inc.",
        "C8:77:65": "Tiesse SpA",
        "2C:37:C5": "Qingdao Haier Intelligent Home Appliance Technology Co.,Ltd",
        "CC:40:D0": "NETGEAR",
        "7C:76:30": "Shenzhen YOUHUA Technology Co., Ltd",
        "98:22:EF": "Liteon Technology Corporation",
        "78:80:38": "FUNAI ELECTRIC CO., LTD.",
        "BC:FF:EB": "Motorola Mobility LLC, a Lenovo Company",
        "00:01:30": "Extreme Networks, Inc.",
        "FC:0A:81": "Extreme Networks, Inc.",
        "F0:45:DA": "Texas Instruments",
        "B8:07:16": "vivo Mobile Communication Co., Ltd.",
        "A8:EE:C6": "Muuselabs NV/SA",
        "E4:F0:42": "Google, Inc.",
        "40:48:FD": "IEEE Registration Authority",
        "20:B3:99": "Enterasys",
        "CC:2D:21": "Tenda Technology Co.,Ltd.Dongguan branch",
        "00:40:97": "DATEX DIVISION OF",
        "9C:4F:CF": "TCT mobile ltd",
        "D8:96:E0": "Alibaba Cloud Computing Ltd.",
        "00:18:62": "Seagate Technology",
        "1C:EE:C9": "Elo touch solutions",
        "00:0C:50": "Seagate Technology",
        "34:2A:F1": "Texas Instruments",
        "C8:DE:C9": "Coriant",
        "44:D5:A5": "AddOn Computer",
        "38:F7:3D": "Amazon Technologies Inc.",
        "C0:A0:0D": "ARRIS Group, Inc.",
        "0C:61:11": "Anda Technologies SAC",
        "00:22:C4": "epro GmbH",
        "1C:33:0E": "PernixData",
        "B8:F7:4A": "RCNTEC",
        "64:51:06": "Hewlett Packard",
        "0C:15:39": "Apple, Inc.",
        "6C:56:97": "Amazon Technologies Inc.",
        "00:05:FF": "SNS Solutions, Inc.",
        "F8:7B:20": "Cisco Systems, Inc",
        "E0:AA:DB": "Nanjing PANENG Technology Development Co.,Ltd",
        "EC:F4:51": "Arcadyan Corporation",
        "58:12:43": "AcSiP Technology Corp.",
        "A8:9F:EC": "ARRIS Group, Inc.",
        "00:BE:9E": "Fiberhome Telecommunication Technologies Co.,LTD",
        "54:C5:7A": "Sunnovo International Limited",
        "58:C1:7A": "Cambium Networks Limited",
        "38:01:9F": "SHENZHEN FAST TECHNOLOGIES CO.,LTD",
        "24:5C:CB": "AXIe Consortium, Inc.",
        "60:9B:C8": "Hipad Intelligent Technology Co., Ltd.",
        "40:6A:8E": "Hangzhou Puwell OE Tech Ltd.",
        "1C:0F:AF": "Lucid Vision Labs",
        "88:B4:A6": "Motorola Mobility LLC, a Lenovo Company",
        "28:CF:08": "ESSYS",
        "00:21:28": "Oracle Corporation",
        "00:1C:73": "Arista Networks",
        "2C:8A:72": "HTC Corporation",
        "38:AD:8E": "New H3C Technologies Co., Ltd",
        "34:D0:B8": "IEEE Registration Authority",
        "D0:67:26": "Hewlett Packard Enterprise",
        "EC:FA:F4": "SenRa Tech Pvt. Ltd",
        "D8:8F:76": "Apple, Inc.",
        "40:9C:28": "Apple, Inc.",
        "58:38:79": "RICOH COMPANY, LTD.",
        "F4:4C:70": "Skyworth Digital Technology(Shenzhen) Co.,Ltd",
        "C8:E7:F0": "Juniper Networks",
        "B0:93:5B": "ARRIS Group, Inc.",
        "F4:49:EF": "EMSTONE",
        "54:DF:24": "Fiberhome Telecommunication Technologies Co.,LTD",
        "AC:1D:DF": "IEEE Registration Authority",
        "E8:D8:19": "AzureWave Technology Inc.",
        "78:2D:7E": "TRENDnet, Inc.",
        "74:1A:E0": "IEEE Registration Authority",
        "24:B2:09": "Avaya Inc",
        "FC:65:DE": "Amazon Technologies Inc.",
        "B0:6E:BF": "ASUSTek COMPUTER INC.",
        "60:3D:26": "Technicolor CH USA Inc.",
        "BC:90:3A": "Robert Bosch GmbH",
        "D0:B1:28": "Samsung Electronics Co.,Ltd",
        "BC:54:51": "Samsung Electronics Co.,Ltd",
        "74:86:0B": "Cisco Systems, Inc",
        "18:2D:98": "Jinwoo Industrial system",
        "D8:A5:34": "Spectronix Corporation",
        "EC:51:BC": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "F0:79:E8": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "60:18:03": "Daikin Air-conditioning (Shanghai) Co., Ltd.",
        "00:A0:96": "MITSUMI ELECTRIC CO.,LTD.",
        "78:61:7C": "MITSUMI ELECTRIC CO.,LTD.",
        "94:0E:6B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "64:FB:50": "RoomReady/Zdi, Inc.",
        "74:EA:C8": "New H3C Technologies Co., Ltd",
        "B4:D6:4E": "Caldero Limited",
        "F8:9D:BB": "Tintri",
        "D8:A0:1D": "Espressif Inc.",
        "C4:F3:12": "Texas Instruments",
        "90:4E:91": "IEEE Registration Authority",
        "5C:E8:B7": "Oraimo Technology Limited",
        "3C:11:B2": "Fraunhofer FIT",
        "10:4B:46": "Mitsubishi Electric Corporation",
        "DC:0C:2D": "WEIFANG GOERTEK ELECTRONICS CO.,LTD",
        "D0:67:E5": "Dell Inc.",
        "8C:FE:B4": "VSOONTECH ELECTRONICS CO., LIMITED",
        "CC:66:B2": "Nokia",
        "78:CA:04": "Nokia Corporation",
        "34:29:8F": "IEEE Registration Authority",
        "5C:EA:1D": "Hon Hai Precision Ind. Co.,Ltd.",
        "18:14:56": "Nokia Corporation",
        "00:17:C8": "KYOCERA Display Corporation",
        "38:E2:DD": "zte corporation",
        "88:5D:FB": "zte corporation",
        "58:B4:2D": "YSTen Technology Co.,Ltd",
        "E0:48:D3": "MOBIWIRE MOBILES (NINGBO) CO.,LTD",
        "58:E2:8F": "Apple, Inc.",
        "78:7B:8A": "Apple, Inc.",
        "4C:16:FC": "Juniper Networks",
        "48:BC:A6": "​ASUNG TECHNO CO.,Ltd",
        "B0:09:DA": "Ring Solutions",
        "00:05:4F": "Garmin International",
        "00:5C:86": "SHENZHEN FAST TECHNOLOGIES CO.,LTD",
        "30:05:3F": "JTI Co.,Ltd.",
        "B8:DB:1C": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "3C:10:E6": "PHAZR Inc.",
        "90:45:06": "Tokyo Boeki Medisys Inc.",
        "00:21:A1": "Cisco Systems, Inc",
        "FC:B6:98": "Cambridge Industries(Group) Co.,Ltd.",
        "00:01:CD": "ARtem",
        "5C:54:6D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "84:A1:D1": "Sagemcom Broadband SAS",
        "90:9D:7D": "ARRIS Group, Inc.",
        "78:8C:4D": "Indyme Solutions, LLC",
        "78:BC:1A": "Cisco Systems, Inc",
        "00:0E:59": "Sagemcom Broadband SAS",
        "10:1D:51": "8Mesh Networks Limited",
        "DC:EB:53": "Wuhan QianXiao Elecronic Technology CO.,LTD",
        "EC:8A:C7": "Fiberhome Telecommunication Technologies Co.,LTD",
        "88:36:5F": "LG Electronics (Mobile Communications)",
        "28:8C:B8": "zte corporation",
        "FC:7F:56": "CoSyst Control Systems GmbH",
        "2C:40:53": "Samsung Electronics Co.,Ltd",
        "0C:8F:FF": "HUAWEI TECHNOLOGIES CO.,LTD",
        "54:B1:21": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:81:02": "Sercomm Corporation.",
        "84:AA:9C": "MitraStar Technology Corp.",
        "F0:EF:D2": "TF PAYMENT SERVICE CO., LTD",
        "24:B2:DE": "Espressif Inc.",
        "00:07:26": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "FC:8B:97": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "2C:AB:25": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "1C:A5:32": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "00:0C:03": "HDMI Licensing, LLC",
        "7C:BA:CC": "IEEE Registration Authority",
        "94:F1:28": "Hewlett Packard Enterprise",
        "10:1B:54": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A8:0C:63": "HUAWEI TECHNOLOGIES CO.,LTD",
        "5C:C3:07": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E0:10:7F": "Ruckus Wireless",
        "C4:01:7C": "Ruckus Wireless",
        "04:FA:3F": "Opticore Inc.",
        "54:02:37": "Teltronic AG",
        "4C:B0:08": "Shenzhen Gwelltimes Technology Co.,Ltd",
        "E8:6F:F2": "Actiontec Electronics, Inc",
        "00:50:18": "AMIT, Inc.",
        "70:DE:F9": "FAI WAH INTERNATIONAL (HONG KONG) LIMITED",
        "B0:EA:BC": "ASKEY COMPUTER CORP",
        "94:C6:91": "EliteGroup Computer Systems Co., LTD",
        "3C:F5:91": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "60:21:01": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "7C:EB:7F": "Dmet Products Corp.",
        "8C:85:80": "Smart Innovation LLC",
        "40:42:29": "Layer3TV, Inc",
        "FC:2F:6B": "Everspin Technologies, Inc.",
        "28:7B:09": "zte corporation",
        "00:25:C4": "Ruckus Wireless",
        "C0:C5:20": "Ruckus Wireless",
        "78:B2:8D": "Beijing Tengling Technology CO.Ltd ",
        "A8:80:38": "ShenZhen MovingComm Technology Co., Limited",
        "F8:1D:90": "Solidwintech",
        "A0:6A:44": "Vizio, Inc",
        "DC:BE:7A": "Zhejiang Nurotron Biotechnology Co.",
        "34:38:B7": "HUMAX Co., Ltd.",
        "CC:06:77": "Fiberhome Telecommunication Technologies Co.,LTD",
        "78:45:01": "Biamp Systems",
        "30:9C:23": "Micro-Star INTL CO., LTD.",
        "54:D7:51": "Proximus",
        "14:78:0B": "Varex Imaging Deutschland AG",
        "AC:AF:B9": "Samsung Electronics Co.,Ltd",
        "88:B1:11": "Intel Corporate",
        "8C:39:5C": "Bit4id Srl",
        "D4:25:8B": "Intel Corporate",
        "04:1B:6D": "LG Electronics (Mobile Communications)",
        "F4:41:56": "Arrikto Inc.",
        "68:8D:B6": "AETEK INC.",
        "EC:F3:42": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "50:FF:20": "Keenetic Limited",
        "E4:57:40": "ARRIS Group, Inc.",
        "F8:94:C2": "Intel Corporate",
        "70:D3:79": "Cisco Systems, Inc",
        "00:F8:2C": "Cisco Systems, Inc",
        "00:C1:B1": "Cisco Systems, Inc",
        "F4:FC:B1": "JJ Corp",
        "D8:C8:E9": "Phicomm (Shanghai) Co., Ltd.",
        "7C:B9:60": "Shanghai X-Cheng telecom LTD",
        "B0:3D:96": "Vision Valley FZ LLC",
        "98:6C:5C": "Jiangxi Gosun Guard Security Co.,Ltd",
        "24:79:2A": "Ruckus Wireless",
        "30:D3:86": "zte corporation",
        "70:DB:98": "Cisco Systems, Inc",
        "B4:2A:0E": "Technicolor CH USA Inc.",
        "9C:C8:AE": "Becton, Dickinson  and Company",
        "B0:35:9F": "Intel Corporate",
        "C0:D9:62": "ASKEY COMPUTER CORP",
        "F8:0B:CB": "Cisco Systems, Inc",
        "50:D3:7F": "Yu Fly Mikly Way Science and Technology Co., Ltd.",
        "18:12:12": "Cepton Technologies",
        "70:D9:23": "vivo Mobile Communication Co., Ltd.",
        "B8:3A:08": "Tenda Technology Co.,Ltd.Dongguan branch",
        "28:B4:48": "HUAWEI TECHNOLOGIES CO.,LTD",
        "10:05:01": "PEGATRON CORPORATION",
        "2C:FA:A2": "Alcatel-Lucent Enterprise",
        "A4:9B:F5": "Hybridserver Tec GmbH",
        "50:3D:A1": "Samsung Electronics Co.,Ltd",
        "F0:97:E5": "TAMIO, INC",
        "4C:1A:3D": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "08:02:8E": "NETGEAR",
        "E8:E7:32": "Alcatel-Lucent Enterprise",
        "B4:7C:9C": "Amazon Technologies Inc.",
        "F4:A7:39": "Juniper Networks",
        "F4:70:AB": "vivo Mobile Communication Co., Ltd.",
        "2C:5A:0F": "Cisco Systems, Inc",
        "2C:31:24": "Cisco Systems, Inc",
        "50:32:37": "Apple, Inc.",
        "B0:48:1A": "Apple, Inc.",
        "B4:9C:DF": "Apple, Inc.",
        "48:BF:6B": "Apple, Inc.",
        "2C:1D:B8": "ARRIS Group, Inc.",
        "58:82:1D": "H. Schomäcker GmbH",
        "D8:A1:05": "Syslane, Co., Ltd.",
        "BC:A0:42": "SHANGHAI FLYCO ELECTRICAL APPLIANCE CO.,LTD",
        "3C:05:18": "Samsung Electronics Co.,Ltd",
        "90:06:28": "Samsung Electronics Co.,Ltd",
        "B4:A9:FE": "GHIA Technology (Shenzhen) LTD",
        "08:B2:58": "Juniper Networks",
        "9C:84:BF": "Apple, Inc.",
        "1C:A0:D3": "IEEE Registration Authority",
        "9C:FC:D1": "Aetheris Technology (Shanghai) Co., Ltd.",
        "CC:CE:1E": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "0C:F4:D5": "Ruckus Wireless",
        "7C:26:64": "Sagemcom Broadband SAS",
        "AC:6B:0F": "CADENCE DESIGN SYSTEMS INC",
        "C8:B5:AD": "Hewlett Packard Enterprise",
        "7C:38:66": "Texas Instruments",
        "0C:61:CF": "Texas Instruments",
        "9C:1D:58": "Texas Instruments",
        "38:05:AC": "Piller Group GmbH",
        "34:6E:9D": "Ericsson AB",
        "68:54:C1": "ColorTokens, Inc.",
        "00:11:1B": "Targa Systems Div L-3 Communications",
        "6C:75:0D": "WiFiSONG",
        "BC:3F:8F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "14:30:04": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F4:DC:41": "YOUNGZONE CULTURE (SHANGHAI) CORP",
        "C4:83:6F": "Ciena Corporation",
        "7C:C6:C4": "Kolff Computer Supplies b.v.",
        "00:0F:4F": "PCS Systemtechnik GmbH",
        "A8:0C:CA": "Shenzhen Sundray Technologies Company Limited",
        "38:AA:3C": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "00:03:02": "Charles Industries, Ltd.",
        "50:A4:D0": "IEEE Registration Authority",
        "80:00:10": "AT&T",
        "00:24:F1": "Shenzhen Fanhai Sanjiang Electronics Co., Ltd.",
        "14:2F:FD": "LT SECURITY INC",
        "0C:3C:CD": "Universal Global Scientific Industrial Co., Ltd.",
        "14:AB:C5": "Intel Corporate",
        "50:D2:13": "CviLux Corporation",
        "00:1E:29": "Hypertherm Inc",
        "50:04:B8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:D0:B2": "Xiotech Corporation",
        "5C:FF:35": "Wistron Corporation",
        "78:F2:9E": "PEGATRON CORPORATION",
        "64:77:7D": "Hitron Technologies. Inc",
        "9C:50:EE": "Cambridge Industries(Group) Co.,Ltd.",
        "40:ED:98": "IEEE Registration Authority",
        "C8:91:F9": "Sagemcom Broadband SAS",
        "AC:DC:E5": "Procter & Gamble Company",
        "00:B3:62": "Apple, Inc.",
        "E4:E4:AB": "Apple, Inc.",
        "60:D2:62": "Tzukuri Pty Ltd",
        "84:04:D2": "Kirale Technologies SL",
        "60:33:4B": "Apple, Inc.",
        "38:AF:D7": "FUJITSU LIMITED",
        "28:99:3A": "Arista Networks",
        "64:EB:8C": "Seiko Epson Corporation",
        "F4:8C:50": "Intel Corporate",
        "DC:D2:55": "Kinpo Electronics, Inc.",
        "A0:2C:36": "FN-LINK TECHNOLOGY LIMITED",
        "00:03:20": "Xpeed, Inc.",
        "50:8A:0F": "SHENZHEN FISE TECHNOLOGY HOLDING CO.,LTD.",
        "7C:CB:E2": "IEEE Registration Authority",
        "A8:A5:E2": "MSF-Vathauer Antriebstechnik GmbH & Co KG ",
        "BC:A8:A6": "Intel Corporate",
        "74:FF:4C": "Skyworth Digital Technology(Shenzhen) Co.,Ltd",
        "68:AF:13": "Futura Mobility",
        "68:1A:B2": "zte corporation",
        "7C:EB:AE": "Ridgeline Instruments",
        "E0:50:8B": "Zhejiang Dahua Technology Co., Ltd.",
        "9C:1E:95": "Actiontec Electronics, Inc",
        "60:42:7F": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD",
        "E8:9E:B4": "Hon Hai Precision Ind. Co.,Ltd.",
        "D4:6A:6A": "Hon Hai Precision Ind. Co.,Ltd.",
        "98:FD:74": "ACT.CO.LTD",
        "64:DB:43": "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd.",
        "00:0E:58": "Sonos, Inc.",
        "00:25:90": "Super Micro Computer, Inc.",
        "AC:1F:6B": "Super Micro Computer, Inc.",
        "00:0B:2E": "Cal-Comp Electronics & Communications Company Ltd.",
        "48:65:EE": "IEEE Registration Authority",
        "D0:F7:3B": "Helmut Mauell GmbH Werk Weida",
        "18:06:75": "Dilax Intelcom GmbH",
        "00:0F:C2": "Uniwell Corporation",
        "6C:EC:5A": "Hon Hai Precision Ind. CO.,Ltd.",
        "44:C3:46": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:74:96": "HUAWEI TECHNOLOGIES CO.,LTD",
        "70:8A:09": "HUAWEI TECHNOLOGIES CO.,LTD",
        "CC:C5:EF": "Co-Comm Servicios Telecomunicaciones S.L.",
        "90:02:A9": "Zhejiang Dahua Technology Co., Ltd.",
        "C0:28:8D": "Logitech, Inc",
        "0C:49:33": "Sichuan Jiuzhou Electronic Technology Co., Ltd.",
        "00:00:64": "Yokogawa Digital Computer Corporation",
        "50:6B:8D": "Nutanix",
        "00:38:DF": "Cisco Systems, Inc",
        "F4:CA:E5": "FREEBOX SAS",
        "90:00:4E": "Hon Hai Precision Ind. Co.,Ltd.",
        "7C:26:34": "ARRIS Group, Inc.",
        "40:F4:13": "Rubezh",
        "C8:D3:FF": "Hewlett Packard",
        "C4:BE:84": "Texas Instruments",
        "F4:F5:24": "Motorola Mobility LLC, a Lenovo Company",
        "00:BB:C1": "CANON INC.",
        "24:C1:BD": "CRRC DALIAN R&D CO.,LTD.",
        "00:A2:EE": "Cisco Systems, Inc",
        "00:59:DC": "Cisco Systems, Inc",
        "00:FD:45": "Hewlett Packard Enterprise",
        "50:98:F3": "Rheem Australia Pty Ltd",
        "B4:D1:35": "Cloudistics",
        "00:13:A5": "General Solutions, LTD.",
        "9C:3D:CF": "NETGEAR",
        "24:88:94": "shenzhen lensun Communication Technology LTD",
        "B0:4B:BF": "PT HAN SUNG ELECTORONICS INDONESIA",
        "CC:2D:83": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "D4:6E:0E": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "88:36:6C": "EFM Networks",
        "48:DA:96": "Eddy Smart Home Solutions Inc.",
        "F0:74:E4": "Thundercomm Technology Co., Ltd",
        "A0:72:2C": "HUMAX Co., Ltd.",
        "FC:D8:48": "Apple, Inc.",
        "EC:10:7B": "Samsung Electronics Co.,Ltd",
        "1C:23:2C": "Samsung Electronics Co.,Ltd",
        "E0:0D:B9": "Cree, Inc.",
        "DC:0D:30": "Shenzhen Feasycom Technology Co., Ltd.",
        "F0:AC:D7": "IEEE Registration Authority",
        "94:95:A0": "Google, Inc.",
        "00:A6:CA": "Cisco Systems, Inc",
        "38:D5:47": "ASUSTek COMPUTER INC.",
        "FC:83:C6": "N-Radio Technologies Co., Ltd.",
        "30:B6:4F": "Juniper Networks",
        "1C:9D:3E": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "F0:2F:A7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "18:DE:D7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C8:3D:D4": "CyberTAN Technology Inc.",
        "E0:B9:4D": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
        "D8:45:2B": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "E4:18:6B": "Zyxel Communications Corporation",
        "00:87:31": "Cisco Systems, Inc",
        "88:DE:A9": "Roku, Inc.",
        "78:88:8A": "CDR Sp. z o.o. Sp. k.",
        "00:21:D1": "Samsung Electronics Co.,Ltd",
        "00:1F:CC": "Samsung Electronics Co.,Ltd",
        "A4:29:83": "Boeing Defence Australia",
        "EC:88:92": "Motorola Mobility LLC, a Lenovo Company",
        "74:87:A9": "OCT Technology Co., Ltd.",
        "00:4A:77": "zte corporation",
        "A4:14:37": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "60:A1:0A": "Samsung Electronics Co.,Ltd",
        "8C:71:F8": "Samsung Electronics Co.,Ltd",
        "CC:05:1B": "Samsung Electronics Co.,Ltd",
        "8C:77:12": "Samsung Electronics Co.,Ltd",
        "94:63:D1": "Samsung Electronics Co.,Ltd",
        "00:21:D2": "Samsung Electronics Co.,Ltd",
        "5C:49:7D": "Samsung Electronics Co.,Ltd",
        "98:23:4E": "Micromedia AG",
        "50:3F:98": "CMITECH",
        "78:20:79": "ID Tech",
        "0C:60:76": "Hon Hai Precision Ind. Co.,Ltd.",
        "0C:EE:E6": "Hon Hai Precision Ind. Co.,Ltd.",
        "E4:D5:3D": "Hon Hai Precision Ind. Co.,Ltd.",
        "C0:14:3D": "Hon Hai Precision Ind. Co.,Ltd.",
        "C0:18:85": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:74:9C": "Ruijie Networks Co.,LTD",
        "58:94:CF": "Vertex Standard LMR, Inc.",
        "20:F8:5E": "Delta Electronics",
        "78:25:AD": "Samsung Electronics Co.,Ltd",
        "EC:E0:9B": "Samsung Electronics Co.,Ltd",
        "00:23:E4": "IPnect co. ltd.",
        "70:D4:F2": "RIM",
        "78:D6:F0": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "BC:20:A4": "Samsung Electronics Co.,Ltd",
        "08:D4:2B": "Samsung Electronics Co.,Ltd",
        "78:9E:D0": "Samsung Electronics Co.,Ltd",
        "B0:C4:E7": "Samsung Electronics Co.,Ltd",
        "A0:07:98": "Samsung Electronics Co.,Ltd",
        "00:1F:CD": "Samsung Electronics Co.,Ltd",
        "38:EC:E4": "Samsung Electronics Co.,Ltd",
        "94:51:03": "Samsung Electronics Co.,Ltd",
        "00:24:90": "Samsung Electronics Co.,Ltd",
        "00:23:D7": "Samsung Electronics Co.,Ltd",
        "54:9B:12": "Samsung Electronics Co.,Ltd",
        "FC:A1:3E": "Samsung Electronics Co.,Ltd",
        "24:C6:96": "Samsung Electronics Co.,Ltd",
        "94:D7:71": "Samsung Electronics Co.,Ltd",
        "E8:4E:84": "Samsung Electronics Co.,Ltd",
        "00:16:32": "Samsung Electronics Co.,Ltd",
        "E4:E0:C5": "Samsung Electronics Co.,Ltd",
        "C8:14:79": "Samsung Electronics Co.,Ltd",
        "1C:AF:05": "Samsung Electronics Co.,Ltd",
        "00:16:DB": "Samsung Electronics Co.,Ltd",
        "00:1E:E2": "Samsung Electronics Co.,Ltd",
        "20:D5:BF": "Samsung Electronics Co.,Ltd",
        "5C:E8:EB": "Samsung Electronics Co.,Ltd",
        "C0:BD:D1": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "B4:79:A7": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "7C:11:CB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "1C:25:E1": "China Mobile IOT Company Limited",
        "C0:F6:36": "Hangzhou Kuaiyue Technologies, Ltd.",
        "00:1A:22": "eQ-3 Entwicklung GmbH",
        "B0:DF:3A": "Samsung Electronics Co.,Ltd",
        "80:57:19": "Samsung Electronics Co.,Ltd",
        "34:BE:00": "Samsung Electronics Co.,Ltd",
        "54:E2:E0": "ARRIS Group, Inc.",
        "34:7A:60": "ARRIS Group, Inc.",
        "00:1C:C3": "ARRIS Group, Inc.",
        "24:0D:C2": "TCT mobile ltd",
        "78:52:1A": "Samsung Electronics Co.,Ltd",
        "70:85:C6": "ARRIS Group, Inc.",
        "20:BB:C6": "Jabil Circuit Hungary Ltd.",
        "04:FE:A1": "Fihonest communication co.,Ltd",
        "EC:8C:A2": "Ruckus Wireless",
        "B8:00:18": "Htel",
        "74:72:B0": "Guangzhou Shiyuan Electronics Co., Ltd. ",
        "54:6C:0E": "Texas Instruments",
        "EC:8E:AE": "Nagravision SA",
        "A0:43:DB": "Sitael S.p.A.",
        "E0:E7:BB": "Nureva, Inc.",
        "00:10:87": "XSTREAMIS PLC",
        "00:B0:B3": "XSTREAMIS PLC",
        "04:9F:CA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "50:01:6B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "AC:48:2D": "Ralinwi Nanjing Electronic Technology Co., Ltd.",
        "00:23:63": "Zhuhai Raysharp Technology Co.,Ltd",
        "00:00:1B": "Novell, Inc.",
        "00:90:58": "Ultra Electronics Command & Control Systems",
        "00:1C:FD": "Universal Electronics, Inc.",
        "08:00:87": "Xyplex, Inc.",
        "DC:1A:01": "Ecoliv Technology ( Shenzhen ) Ltd.",
        "00:54:9F": "Avaya Inc",
        "28:24:FF": "Wistron Neweb Corporation",
        "38:25:6B": "Microsoft Mobile Oy",
        "00:1C:EF": "Primax Electronics Ltd.",
        "00:02:76": "Primax Electronics Ltd.",
        "4C:B2:1C": "Maxphotonics Co.,Ltd",
        "20:5E:F7": "Samsung Electronics Co.,Ltd",
        "14:1F:78": "Samsung Electronics Co.,Ltd",
        "D8:47:10": "Sichuan Changhong Electric Ltd.",
        "00:19:72": "Plexus (Xiamen) Co.,ltd.",
        "00:23:47": "ProCurve Networking by HP",
        "00:24:A8": "ProCurve Networking by HP",
        "C0:91:34": "ProCurve Networking by HP",
        "00:19:69": "Nortel Networks",
        "00:18:B0": "Nortel Networks",
        "00:16:CA": "Nortel Networks",
        "00:0F:CD": "Nortel Networks",
        "00:1B:BA": "Nortel Networks",
        "00:04:DC": "Nortel Networks",
        "00:0C:F7": "Nortel Networks",
        "00:14:0E": "Nortel Networks",
        "00:1E:1F": "Nortel Networks",
        "20:3A:EF": "Sivantos GmbH",
        "00:59:79": "Networked Energy Services",
        "20:7C:8F": "Quanta Microsystems,Inc.",
        "00:0B:34": "ShangHai Broadband Technologies CO.LTD",
        "74:B5:7E": "zte corporation",
        "B8:BB:23": "Guangdong Nufront CSC Co., Ltd",
        "34:EA:34": "HangZhou Gubei Electronics Technology Co.,Ltd",
        "30:92:F6": "SHANGHAI SUNMON COMMUNICATION TECHNOGY CO.,LTD",
        "A8:AD:3D": "Alcatel-Lucent Shanghai Bell Co., Ltd",
        "24:AF:4A": "Alcatel-Lucent IPD",
        "7C:20:64": "Alcatel-Lucent IPD",
        "44:DC:91": "PLANEX COMMUNICATIONS INC.",
        "E0:9D:B8": "PLANEX COMMUNICATIONS INC.",
        "00:0F:59": "Phonak AG",
        "00:14:78": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "48:F8:E1": "Nokia",
        "8C:90:D3": "Nokia",
        "00:28:F8": "Intel Corporate",
        "58:BC:8F": "Cognitive Systems Corp.",
        "D4:55:BE": "SHENZHEN FAST TECHNOLOGIES CO.,LTD",
        "64:0D:CE": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "54:D2:72": "Nuki Home Solutions GmbH",
        "EC:26:FB": "TECC CO.,LTD.",
        "00:20:F4": "SPECTRIX CORPORATION",
        "04:EE:91": "x-fabric GmbH",
        "B4:74:43": "Samsung Electronics Co.,Ltd",
        "FC:F6:47": "Fiberhome Telecommunication Technologies Co.,LTD",
        "18:68:6A": "zte corporation",
        "C4:4B:D1": "Wallys Communications  Teachnologies Co.,Ltd.",
        "6C:B9:C5": "Delta Networks, Inc.",
        "30:76:6F": "LG Electronics (Mobile Communications)",
        "A8:92:2C": "LG Electronics (Mobile Communications)",
        "F8:0C:F3": "LG Electronics (Mobile Communications)",
        "C4:9A:02": "LG Electronics (Mobile Communications)",
        "00:1F:6B": "LG Electronics (Mobile Communications)",
        "00:26:E2": "LG Electronics (Mobile Communications)",
        "DC:44:27": "IEEE Registration Authority",
        "BC:34:00": "IEEE Registration Authority",
        "E8:88:6C": "Shenzhen SC Technologies Co.,LTD",
        "00:24:FF": "QLogic Corporation",
        "00:1E:21": "Qisda Corporation",
        "00:03:9D": "Qisda Corporation",
        "00:08:0D": "Toshiba",
        "00:0E:7B": "Toshiba",
        "00:03:B2": "Radware",
        "00:A0:C6": "Qualcomm Inc.",
        "64:9C:81": "Qualcomm Inc.",
        "00:1A:6A": "Tranzas, Inc.",
        "A4:71:74": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F4:CB:52": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B8:08:D7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "94:61:1E": "Wata Electronics Co.,Ltd. ",
        "00:C0:E4": "SIEMENS BUILDING",
        "00:0D:10": "Embedtronics Oy",
        "00:1F:A8": "Smart Energy Instruments Inc.",
        "00:0F:DB": "Westell Technologies Inc.",
        "3C:07:71": "Sony Corporation",
        "80:41:4E": "BBK EDUCATIONAL ELECTRONICS CORP.,LTD.",
        "24:94:42": "OPEN ROAD SOLUTIONS , INC.",
        "C4:64:13": "Cisco Systems, Inc",
        "00:10:CA": "Telco Systems, Inc. ",
        "00:E0:9E": "Quantum Corporation",
        "20:6A:8A": "Wistron Infocomm (Zhongshan) Corporation",
        "78:44:76": "Zioncom Electronics (Shenzhen) Ltd.",
        "00:11:65": "ZNYX Networks, Inc.",
        "00:0A:68": "Solarflare Communications Inc.",
        "00:21:86": "Universal Global Scientific Industrial Co., Ltd.",
        "18:39:19": "Unicoi Systems",
        "E8:E0:B7": "Toshiba",
        "68:07:15": "Intel Corporate",
        "3C:B6:B7": "vivo Mobile Communication Co., Ltd.",
        "C4:27:95": "Technicolor CH USA Inc.",
        "A0:20:A6": "Espressif Inc.",
        "58:52:8A": "Mitsubishi Electric Corporation",
        "C4:F1:D1": "BEIJING SOGOU TECHNOLOGY DEVELOPMENT CO., LTD.",
        "2C:36:A0": "Capisco Limited",
        "B0:B2:DC": "Zyxel Communications Corporation",
        "CC:5D:4E": "Zyxel Communications Corporation",
        "40:4A:03": "Zyxel Communications Corporation",
        "C8:6C:87": "Zyxel Communications Corporation",
        "00:1E:C0": "Microchip Technology Inc.",
        "38:BC:1A": "MEIZU Technology Co., Ltd.",
        "80:29:94": "Technicolor CH USA Inc.",
        "E0:88:5D": "Technicolor CH USA Inc.",
        "34:0A:FF": "Qingdao Hisense Communications Co.,Ltd.",
        "58:7E:61": "Qingdao Hisense Communications Co.,Ltd.",
        "C0:A1:A2": "MarqMetrix",
        "08:D0:B7": "Qingdao Hisense Communications Co.,Ltd.",
        "EC:D6:8A": "Shenzhen JMicron Intelligent Technology Developmen",
        "50:52:D2": "Hangzhou Telin Technologies Co., Limited",
        "90:EE:D9": "UNIVERSAL DE DESARROLLOS ELECTRÓNICOS, SA",
        "60:64:53": "AOD Co.,Ltd.",
        "00:9E:1E": "Cisco Systems, Inc",
        "00:25:3E": "Sensus Metering Systems",
        "C8:AF:E3": "Hefei Radio Communication Technology Co., Ltd ",
        "7C:57:4E": "COBI GmbH",
        "28:F1:0E": "Dell Inc.",
        "04:56:04": "Gionee Communication Equipment Co.,Ltd.",
        "34:C0:F9": "Rockwell Automation",
        "00:FE:C8": "Cisco Systems, Inc",
        "2C:5A:8D": "SYSTRONIK Elektronik u. Systemtechnik GmbH",
        "10:BE:F5": "D-Link International",
        "E4:7B:3F": "BEIJING CO-CLOUD TECHNOLOGY LTD.",
        "0C:8A:87": "AgLogica Holdings, Inc",
        "54:ED:A3": "Navdy, Inc.",
        "34:A2:A2": "HUAWEI TECHNOLOGIES CO.,LTD",
        "74:9D:8F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "94:59:07": "Shanghai HITE-BELDEN Network Technology Co., Ltd.",
        "00:16:FB": "SHENZHEN MTC CO LTD",
        "A0:41:5E": "Opsens Solution Inc.",
        "A8:60:B6": "Apple, Inc.",
        "C4:B3:01": "Apple, Inc.",
        "E0:5F:45": "Apple, Inc.",
        "74:CC:39": "Fiberhome Telecommunication Technologies Co.,LTD",
        "38:22:D6": "Hangzhou H3C Technologies Co., Limited",
        "94:E8:C5": "ARRIS Group, Inc.",
        "6C:3B:6B": "Routerboard.com",
        "00:22:E7": "WPS Parking Systems",
        "48:51:B7": "Intel Corporate",
        "B8:E7:79": "9Solutions Oy",
        "C8:64:C7": "zte corporation",
        "48:3B:38": "Apple, Inc.",
        "1C:91:48": "Apple, Inc.",
        "90:5F:2E": "TCT mobile ltd",
        "F8:23:B2": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:12:90": "Treeview Co.,Ltd.",
        "7C:FE:4E": "Shenzhen Safe vision Technology Co.,LTD",
        "64:4F:B0": "Hyunjin.com",
        "00:E0:E6": "INCAA Computers",
        "28:F3:66": "Shenzhen Bilian electronic CO.,LTD",
        "E0:A3:AC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "BC:75:74": "HUAWEI TECHNOLOGIES CO.,LTD",
        "20:A6:80": "HUAWEI TECHNOLOGIES CO.,LTD",
        "88:28:B3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A4:E5:97": "Gessler GmbH",
        "00:6C:BC": "Cisco Systems, Inc",
        "5C:70:A3": "LG Electronics (Mobile Communications)",
        "00:1D:08": "Jiangsu Yinhe  Electronics Co.,Ltd.",
        "00:1D:82": "GN Netcom A/S",
        "00:13:17": "GN Netcom A/S",
        "00:A0:A4": "Oracle Corporation ",
        "74:97:81": "zte corporation",
        "00:01:F4": "Enterasys",
        "00:10:9B": "Emulex Corporation",
        "00:14:2A": "Elitegroup Computer Systems Co.,Ltd.",
        "00:11:5B": "Elitegroup Computer Systems Co.,Ltd.",
        "C0:3F:D5": "Elitegroup Computer Systems Co.,Ltd.",
        "EC:A8:6B": "Elitegroup Computer Systems Co.,Ltd.",
        "C8:9C:DC": "Elitegroup Computer Systems Co.,Ltd.",
        "00:25:11": "Elitegroup Computer Systems Co.,Ltd.",
        "44:87:FC": "Elitegroup Computer Systems Co.,Ltd.",
        "A8:6B:AD": "Hon Hai Precision Ind. Co.,Ltd.",
        "D8:0F:99": "Hon Hai Precision Ind. Co.,Ltd.",
        "B4:B1:5A": "Siemens AG Energy Management Division",
        "00:24:65": "Elentec",
        "00:08:9F": "EFM Networks",
        "00:50:FC": "Edimax Technology Co. Ltd.",
        "9C:DF:03": "Harman/Becker Automotive Systems GmbH",
        "00:11:88": "Enterasys",
        "00:16:FA": "ECI Telecom Ltd.",
        "F8:A1:88": "LED Roadway Lighting",
        "A0:82:AC": "Linear DMS Solutions Sdn. Bhd.",
        "A8:6A:C1": "HanbitEDS Co., Ltd.",
        "D4:63:FE": "Arcadyan Corporation",
        "68:93:61": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "BC:15:AC": "Vodafone Italia S.p.A.",
        "00:BD:82": "Shenzhen YOUHUA Technology Co., Ltd",
        "94:51:3D": "iSmart Alarm, Inc.",
        "00:11:74": "Mojo Networks, Inc.",
        "00:19:54": "Leaf Corporation.",
        "94:66:E7": "WOM Engineering",
        "4C:B8:B5": "Shenzhen YOUHUA Technology Co., Ltd",
        "70:85:C2": "ASRock Incorporation",
        "EC:93:ED": "DDoS-Guard LTD",
        "30:FC:68": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "00:8A:96": "Cisco Systems, Inc",
        "BC:60:A7": "Sony Interactive Entertainment Inc.",
        "80:8C:97": "Kaonmedia CO., LTD.",
        "DC:EE:06": "HUAWEI TECHNOLOGIES CO.,LTD",
        "04:52:C7": "Bose Corporation",
        "F0:27:45": "F-Secure Corporation",
        "54:D0:B4": "Xiamen Four-Faith Communication Technology Co.,Ltd",
        "00:13:7C": "Kaicom co., Ltd.",
        "E8:56:59": "Advanced-Connectek Inc.",
        "34:BF:90": "Fiberhome Telecommunication Technologies Co.,LTD",
        "CC:B3:F8": "FUJITSU ISOTEC LIMITED",
        "E4:A4:71": "Intel Corporate",
        "10:F0:05": "Intel Corporate",
        "64:CC:2E": "Xiaomi Communications Co Ltd",
        "88:01:F2": "Vitec System Engineering Inc.",
        "14:D1:1F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "DC:09:4C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "1C:67:58": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:BC:F8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A0:04:3E": "Parker Hannifin Manufacturing Germany GmbH & Co. KG",
        "C8:45:29": "IMK Networks Co.,Ltd",
        "7C:47:7C": "IEEE Registration Authority",
        "F8:77:B8": "Samsung Electronics Co.,Ltd",
        "F0:D2:F1": "Amazon Technologies Inc.",
        "A8:E3:EE": "Sony Interactive Entertainment Inc.",
        "00:24:8D": "Sony Interactive Entertainment Inc.",
        "00:04:1F": "Sony Interactive Entertainment Inc.",
        "20:A9:0E": "TCT mobile ltd",
        "EC:43:8B": "YAPTV",
        "98:0C:A5": "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd.",
        "44:11:02": "EDMI  Europe Ltd",
        "A8:5E:E4": "12Sided Technology, LLC",
        "18:21:95": "Samsung Electronics Co.,Ltd",
        "44:78:3E": "Samsung Electronics Co.,Ltd",
        "0C:A2:F4": "Chameleon Technology (UK) Limited",
        "BC:44:B0": "Elastifile",
        "74:BF:B7": "Nusoft Corporation",
        "50:DA:00": "Hangzhou H3C Technologies Co., Limited",
        "F4:ED:5F": "SHENZHEN KTC TECHNOLOGY GROUP ",
        "00:E0:E4": "FANUC ROBOTICS NORTH AMERICA, Inc.",
        "00:08:96": "Printronix, Inc.",
        "24:5E:BE": "QNAP Systems, Inc.",
        "04:04:EA": "Valens Semiconductor Ltd.",
        "80:0D:D7": "Latticework, Inc",
        "D0:B5:3D": "SEPRO ROBOTIQUE",
        "00:D0:EC": "NAKAYO Inc",
        "4C:CC:6A": "Micro-Star INTL CO., LTD.",
        "30:63:6B": "Apple, Inc.",
        "70:88:4D": "JAPAN RADIO CO., LTD.",
        "A4:F1:E8": "Apple, Inc.",
        "54:67:51": "Compal Broadband Networks, Inc.",
        "24:0B:0A": "Palo Alto Networks",
        "D0:99:D5": "Alcatel-Lucent",
        "14:C3:C2": "K.A. Schmersal GmbH & Co. KG",
        "10:78:5B": "Actiontec Electronics, Inc",
        "DC:00:77": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "F4:F5:A5": "Nokia Corporation",
        "EC:9B:5B": "Nokia Corporation",
        "2C:CC:15": "Nokia Corporation",
        "14:BB:6E": "Samsung Electronics Co.,Ltd",
        "18:86:AC": "Nokia Danmark A/S",
        "00:1F:5C": "Nokia Danmark A/S",
        "00:1F:00": "Nokia Danmark A/S",
        "00:25:47": "Nokia Danmark A/S",
        "00:18:C5": "Nokia Danmark A/S",
        "00:16:4E": "Nokia Danmark A/S",
        "00:26:68": "Nokia Danmark A/S",
        "00:24:7D": "Nokia Danmark A/S",
        "00:22:65": "Nokia Danmark A/S",
        "F8:80:96": "Elsys Equipamentos Eletrônicos Ltda",
        "A8:11:FC": "ARRIS Group, Inc.",
        "00:1D:AA": "DrayTek Corp.",
        "E4:98:D1": "Microsoft Mobile Oy",
        "6C:27:79": "Microsoft Mobile Oy",
        "00:CF:1C": "Communication Machinery Corporation",
        "28:CC:01": "Samsung Electronics Co.,Ltd",
        "D8:FB:5E": "ASKEY COMPUTER CORP",
        "00:23:26": "FUJITSU LIMITED",
        "0C:BF:15": "Genetec Inc.",
        "00:0D:4B": "Roku, Inc.",
        "00:40:FB": "CASCADE COMMUNICATIONS",
        "D0:54:2D": "Cambridge Industries(Group) Co.,Ltd.",
        "74:4A:A4": "zte corporation",
        "00:1B:A9": "Brother industries, LTD.",
        "30:A2:20": "ARG Telecom",
        "6C:F3:73": "Samsung Electronics Co.,Ltd",
        "9C:3A:AF": "Samsung Electronics Co.,Ltd",
        "78:1F:DB": "Samsung Electronics Co.,Ltd",
        "4C:A5:6D": "Samsung Electronics Co.,Ltd",
        "B8:6C:E8": "Samsung Electronics Co.,Ltd",
        "0C:B3:19": "Samsung Electronics Co.,Ltd",
        "18:3F:47": "Samsung Electronics Co.,Ltd",
        "B4:62:93": "Samsung Electronics Co.,Ltd",
        "50:A4:C8": "Samsung Electronics Co.,Ltd",
        "00:00:1D": "Cabletron Systems, Inc.",
        "18:67:B0": "Samsung Electronics Co.,Ltd",
        "6C:83:36": "Samsung Electronics Co.,Ltd",
        "DC:D8:7C": "Beijing Jingdong Century Trading Co., LTD.",
        "C4:DA:7D": "Ivium Technologies B.V.",
        "00:0B:6A": "Asiarock Technology Limited",
        "00:90:96": "ASKEY COMPUTER CORP",
        "00:1B:9E": "ASKEY COMPUTER CORP",
        "E0:CA:94": "ASKEY COMPUTER CORP",
        "00:26:B6": "ASKEY COMPUTER CORP",
        "00:25:57": "BlackBerry RTS",
        "00:1C:CC": "BlackBerry RTS",
        "00:30:0A": "Aztech Electronics Pte Ltd",
        "00:1F:3F": "AVM GmbH",
        "24:65:11": "AVM GmbH",
        "C0:FF:D4": "NETGEAR",
        "6C:B0:CE": "NETGEAR",
        "00:8E:F2": "NETGEAR",
        "9C:D3:6D": "NETGEAR",
        "C4:04:15": "NETGEAR",
        "E8:FC:AF": "NETGEAR",
        "84:1B:5E": "NETGEAR",
        "2C:B0:5D": "NETGEAR",
        "A0:21:B7": "NETGEAR",
        "00:24:B2": "NETGEAR",
        "00:1B:2F": "NETGEAR",
        "00:26:4D": "Arcadyan Technology Corporation",
        "84:9C:A6": "Arcadyan Technology Corporation",
        "E0:3E:44": "Broadcom",
        "00:1F:33": "NETGEAR",
        "00:20:40": "ARRIS Group, Inc.",
        "38:6B:BB": "ARRIS Group, Inc.",
        "E8:6D:52": "ARRIS Group, Inc.",
        "3C:75:4A": "ARRIS Group, Inc.",
        "E4:83:99": "ARRIS Group, Inc.",
        "00:21:43": "ARRIS Group, Inc.",
        "74:F6:12": "ARRIS Group, Inc.",
        "00:24:95": "ARRIS Group, Inc.",
        "00:24:A0": "ARRIS Group, Inc.",
        "00:08:0E": "ARRIS Group, Inc.",
        "00:90:9C": "ARRIS Group, Inc.",
        "00:12:25": "ARRIS Group, Inc.",
        "14:5B:D1": "ARRIS Group, Inc.",
        "6C:C1:D2": "ARRIS Group, Inc.",
        "1C:14:48": "ARRIS Group, Inc.",
        "00:17:84": "ARRIS Group, Inc.",
        "00:1C:11": "ARRIS Group, Inc.",
        "00:1E:46": "ARRIS Group, Inc.",
        "00:18:A4": "ARRIS Group, Inc.",
        "00:18:C0": "ARRIS Group, Inc.",
        "00:23:74": "ARRIS Group, Inc.",
        "AC:E0:10": "Liteon Technology Corporation",
        "74:75:48": "Amazon Technologies Inc.",
        "00:00:B1": "Alpha Micro",
        "00:18:02": "Alpha Networks Inc.",
        "78:84:3C": "Sony Corporation",
        "00:13:A9": "Sony Corporation",
        "FC:0F:E6": "Sony Interactive Entertainment Inc.",
        "74:DE:2B": "Liteon Technology Corporation",
        "00:22:5F": "Liteon Technology Corporation",
        "5C:93:A2": "Liteon Technology Corporation",
        "24:FD:52": "Liteon Technology Corporation",
        "2C:D0:5A": "Liteon Technology Corporation",
        "74:E5:43": "Liteon Technology Corporation",
        "00:15:CF": "ARRIS Group, Inc.",
        "6C:FA:A7": "AMPAK Technology, Inc.",
        "54:E4:BD": "FN-LINK TECHNOLOGY LIMITED",
        "54:14:FD": "Orbbec 3D Technology International",
        "90:0B:C1": "Sprocomm Technologies CO.,Ltd",
        "00:1C:A8": "AirTies Wireless Networks",
        "48:5D:60": "AzureWave Technology Inc.",
        "DC:85:DE": "AzureWave Technology Inc.",
        "B0:EE:45": "AzureWave Technology Inc.",
        "00:23:8E": "ADB Broadband Italia",
        "00:1D:8B": "ADB Broadband Italia",
        "00:13:C8": "ADB Broadband Italia",
        "DC:0B:1A": "ADB Broadband Italia",
        "0C:6A:E6": "Stanley Security Solutions",
        "84:26:15": "ADB Broadband Italia",
        "F0:84:2F": "ADB Broadband Italia",
        "54:27:1E": "AzureWave Technology Inc.",
        "28:C2:DD": "AzureWave Technology Inc.",
        "80:A5:89": "AzureWave Technology Inc.",
        "C4:09:38": "FUJIAN STAR-NET COMMUNICATION CO.,LTD",
        "00:1C:50": "TCL Technoly Electronics (Huizhou) Co., Ltd.",
        "00:AA:02": "Intel Corporation",
        "AC:E5:F0": "Doppler Labs",
        "F4:8E:38": "Dell Inc.",
        "74:C6:3B": "AzureWave Technology Inc.",
        "7C:7A:91": "Intel Corporate",
        "AC:7B:A1": "Intel Corporate",
        "6C:29:95": "Intel Corporate",
        "98:4F:EE": "Intel Corporate",
        "E8:2A:EA": "Intel Corporate",
        "60:57:18": "Intel Corporate",
        "C4:D9:87": "Intel Corporate",
        "FC:F8:AE": "Intel Corporate",
        "60:36:DD": "Intel Corporate",
        "10:0B:A9": "Intel Corporate",
        "8C:70:5A": "Intel Corporate",
        "60:67:20": "Intel Corporate",
        "7C:5C:F8": "Intel Corporate",
        "B4:E1:C4": "Microsoft Mobile Oy",
        "E0:75:7D": "Motorola Mobility LLC, a Lenovo Company",
        "34:BB:26": "Motorola Mobility LLC, a Lenovo Company",
        "80:6C:1B": "Motorola Mobility LLC, a Lenovo Company",
        "00:16:EB": "Intel Corporate",
        "00:18:DE": "Intel Corporate",
        "5C:E0:C5": "Intel Corporate",
        "58:A8:39": "Intel Corporate",
        "00:1E:67": "Intel Corporate",
        "00:22:FA": "Intel Corporate",
        "00:15:00": "Intel Corporate",
        "A0:88:B4": "Intel Corporate",
        "64:80:99": "Intel Corporate",
        "D0:7E:35": "Intel Corporate",
        "00:1E:65": "Intel Corporate",
        "34:84:46": "Ericsson AB",
        "04:4E:06": "Ericsson AB",
        "00:27:0E": "Intel Corporate",
        "00:26:B9": "Dell Inc.",
        "64:00:6A": "Dell Inc.",
        "00:D0:9E": "2Wire Inc",
        "00:19:E4": "2Wire Inc",
        "00:1A:C4": "2Wire Inc",
        "00:1B:5B": "2Wire Inc",
        "3C:EA:4F": "2Wire Inc",
        "DC:7F:A4": "2Wire Inc",
        "B0:D5:CC": "Texas Instruments",
        "38:29:DD": "ONvocal Inc",
        "00:1E:C7": "2Wire Inc",
        "00:26:50": "2Wire Inc",
        "00:23:51": "2Wire Inc",
        "00:1E:4F": "Dell Inc.",
        "5C:26:0A": "Dell Inc.",
        "78:45:C4": "Dell Inc.",
        "C8:1F:66": "Dell Inc.",
        "00:15:C5": "Dell Inc.",
        "00:14:22": "Dell Inc.",
        "10:98:36": "Dell Inc.",
        "80:0A:80": "IEEE Registration Authority",
        "F8:DB:88": "Dell Inc.",
        "3C:A3:48": "vivo Mobile Communication Co., Ltd.",
        "E4:5A:A2": "vivo Mobile Communication Co., Ltd.",
        "CC:3B:3E": "Lester Electrical",
        "20:82:C0": "Xiaomi Communications Co Ltd",
        "DC:6D:CD": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "C4:28:2D": "Embedded Intellect Pty Ltd",
        "58:46:E1": "Baxter International Inc",
        "00:17:3F": "Belkin International Inc.",
        "00:1C:DF": "Belkin International Inc.",
        "C0:56:27": "Belkin International Inc.",
        "4C:17:EB": "Sagemcom Broadband SAS",
        "CC:33:BB": "Sagemcom Broadband SAS",
        "D8:6C:E9": "Sagemcom Broadband SAS",
        "E8:F1:B0": "Sagemcom Broadband SAS",
        "5C:6B:32": "Texas Instruments",
        "84:DD:20": "Texas Instruments",
        "00:18:31": "Texas Instruments",
        "24:FD:5B": "SmartThings, Inc.",
        "28:76:CD": "Funshion Online Technologies Co.,Ltd",
        "20:55:32": "Gotech International Technology Limited",
        "2C:FF:65": "Oki Electric Industry Co., Ltd.",
        "2C:27:D7": "Hewlett Packard",
        "98:4B:E1": "Hewlett Packard",
        "00:29:26": "Applied Optoelectronics, Inc Taiwan Branch",
        "24:BA:13": "RISO KAGAKU CORPORATION",
        "00:17:E5": "Texas Instruments",
        "00:17:EC": "Texas Instruments",
        "00:17:E7": "Texas Instruments",
        "00:17:E9": "Texas Instruments",
        "1C:BA:8C": "Texas Instruments",
        "00:15:E9": "D-Link Corporation",
        "00:1B:11": "D-Link Corporation",
        "00:26:5A": "D-Link Corporation",
        "C8:BE:19": "D-Link International",
        "A4:BA:76": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:50:C2": "IEEE Registration Authority",
        "44:00:10": "Apple, Inc.",
        "00:56:CD": "Apple, Inc.",
        "00:60:37": "NXP Semiconductors",
        "DC:C0:EB": "ASSA ABLOY CÔTE PICARDE",
        "28:BC:56": "EMAC, Inc.",
        "00:CD:FE": "Apple, Inc.",
        "00:78:CD": "Ignition Design Labs",
        "B4:36:A9": "Fibocom Wireless Inc. ",
        "70:CA:4D": "Shenzhen lnovance Technology Co.,Ltd.",
        "00:1A:11": "Google, Inc.",
        "48:DB:50": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C8:47:8C": "Beken Corporation",
        "9C:EF:D5": "Panda Wireless, Inc.",
        "9C:34:26": "ARRIS Group, Inc.",
        "2C:6E:85": "Intel Corporate",
        "00:1D:D1": "ARRIS Group, Inc.",
        "00:1D:CF": "ARRIS Group, Inc.",
        "00:1D:D5": "ARRIS Group, Inc.",
        "00:1D:D4": "ARRIS Group, Inc.",
        "E4:98:D6": "Apple, Inc.",
        "00:22:83": "Juniper Networks",
        "00:10:DB": "Juniper Networks",
        "00:12:1E": "Juniper Networks",
        "CC:A4:62": "ARRIS Group, Inc.",
        "48:45:20": "Intel Corporate",
        "C8:0E:77": "Le Shi Zhi Xin Electronic Technology (Tianjin) Limited",
        "10:6F:3F": "BUFFALO.INC",
        "90:49:FA": "Intel Corporate",
        "BC:0F:64": "Intel Corporate",
        "00:00:C5": "ARRIS Group, Inc.",
        "64:55:B1": "ARRIS Group, Inc.",
        "00:02:B3": "Intel Corporation",
        "00:03:47": "Intel Corporation",
        "00:0E:0C": "Intel Corporation",
        "D8:D3:85": "Hewlett Packard",
        "18:A9:05": "Hewlett Packard",
        "00:1B:78": "Hewlett Packard",
        "E4:FA:FD": "Intel Corporate",
        "94:65:9C": "Intel Corporate",
        "B0:C7:45": "BUFFALO.INC",
        "14:CF:E2": "ARRIS Group, Inc.",
        "44:E1:37": "ARRIS Group, Inc.",
        "00:13:20": "Intel Corporate",
        "00:80:E1": "STMicroelectronics SRL",
        "F8:DB:7F": "HTC Corporation",
        "64:A7:69": "HTC Corporation",
        "E8:99:C4": "HTC Corporation",
        "BC:CF:CC": "HTC Corporation",
        "00:04:EA": "Hewlett Packard",
        "00:12:79": "Hewlett Packard",
        "00:13:21": "Hewlett Packard",
        "00:08:02": "Hewlett Packard",
        "00:02:A5": "Hewlett Packard",
        "00:18:71": "Hewlett Packard",
        "00:0E:7F": "Hewlett Packard",
        "00:11:85": "Hewlett Packard",
        "10:60:4B": "Hewlett Packard",
        "C8:CB:B8": "Hewlett Packard",
        "84:34:97": "Hewlett Packard",
        "6C:C2:17": "Hewlett Packard",
        "14:58:D0": "Hewlett Packard",
        "5C:8A:38": "Hewlett Packard",
        "EC:9A:74": "Hewlett Packard",
        "2C:59:E5": "Hewlett Packard",
        "D8:FC:38": "Giantec Semiconductor Inc",
        "AC:2A:0C": "CSR ZHUZHOU INSTITUTE CO.,LTD.",
        "2C:67:98": "InTalTech Ltd.",
        "00:23:4D": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:25:56": "Hon Hai Precision Ind. Co.,Ltd.",
        "60:18:88": "zte corporation",
        "D8:60:B0": "bioMérieux Italia S.p.A.",
        "54:E6:FC": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "74:EA:3A": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "F8:1A:67": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "EC:17:2F": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "84:77:78": "Cochlear Limited",
        "88:7F:03": "Comper Technology Investment Limited",
        "00:19:E0": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "00:25:86": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "F4:31:C3": "Apple, Inc.",
        "64:A5:C3": "Apple, Inc.",
        "28:56:5A": "Hon Hai Precision Ind. Co.,Ltd.",
        "6C:B5:6B": "HUMAX Co., Ltd.",
        "BC:3A:EA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "E4:22:A5": "PLANTRONICS, INC.",
        "D4:C9:B2": "Quanergy Systems Inc",
        "60:21:C0": "Murata Manufacturing Co., Ltd.",
        "88:30:8A": "Murata Manufacturing Co., Ltd.",
        "5C:DA:D4": "Murata Manufacturing Co., Ltd.",
        "00:26:E8": "Murata Manufacturing Co., Ltd.",
        "00:25:12": "zte corporation",
        "00:1C:26": "Hon Hai Precision Ind. Co.,Ltd.",
        "14:E6:E4": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "34:4B:50": "zte corporation",
        "FC:C8:97": "zte corporation",
        "00:16:CE": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:22:68": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:18:82": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D4:EA:0E": "Avaya Inc",
        "6C:FA:58": "Avaya Inc",
        "20:F3:A3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "0C:37:DC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "BC:76:70": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:DB:AC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "1C:1D:67": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:0E:D5": "Hon Hai Precision Ind. Co.,Ltd.",
        "48:5A:B6": "Hon Hai Precision Ind. Co.,Ltd.",
        "54:35:30": "Hon Hai Precision Ind. Co.,Ltd.",
        "F8:66:D1": "Hon Hai Precision Ind. Co.,Ltd.",
        "24:69:A5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "EC:23:3D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:F5:FD": "HUAWEI TECHNOLOGIES CO.,LTD",
        "5C:7D:5E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "90:67:1C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "BC:25:E0": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F4:E3:FB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D0:2D:B3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E8:CD:2D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "84:A8:E4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "0C:96:BF": "HUAWEI TECHNOLOGIES CO.,LTD",
        "60:E7:01": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E8:08:8B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A0:51:C6": "Avaya Inc",
        "F0:EB:D0": "Shanghai Feixun Communication Co.,Ltd.",
        "64:3E:8C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:12:D2": "Texas Instruments",
        "A8:63:F2": "Texas Instruments",
        "7C:60:97": "HUAWEI TECHNOLOGIES CO.,LTD",
        "CC:53:B5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "60:DE:44": "HUAWEI TECHNOLOGIES CO.,LTD",
        "10:51:72": "HUAWEI TECHNOLOGIES CO.,LTD",
        "08:E8:4F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "88:86:03": "HUAWEI TECHNOLOGIES CO.,LTD",
        "04:F9:38": "HUAWEI TECHNOLOGIES CO.,LTD",
        "AC:85:3D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "48:46:FB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D0:FF:50": "Texas Instruments",
        "20:C3:8F": "Texas Instruments",
        "7C:66:9D": "Texas Instruments",
        "D8:DD:FD": "Texas Instruments",
        "D0:5F:B8": "Texas Instruments",
        "E0:24:7F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:46:4B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "80:FB:06": "HUAWEI TECHNOLOGIES CO.,LTD",
        "6C:A8:49": "Avaya Inc",
        "64:C3:54": "Avaya Inc",
        "50:CD:22": "Avaya Inc",
        "B4:A9:5A": "Avaya Inc",
        "84:EB:18": "Texas Instruments",
        "EC:11:27": "Texas Instruments",
        "58:16:26": "Avaya Inc",
        "70:E4:22": "Cisco Systems, Inc",
        "00:50:0F": "Cisco Systems, Inc",
        "7C:1D:D9": "Xiaomi Communications Co Ltd",
        "A0:86:C6": "Xiaomi Communications Co Ltd",
        "9C:99:A0": "Xiaomi Communications Co Ltd",
        "58:44:98": "Xiaomi Communications Co Ltd",
        "00:E0:B0": "Cisco Systems, Inc",
        "00:E0:FE": "Cisco Systems, Inc",
        "00:E0:34": "Cisco Systems, Inc",
        "00:E0:F9": "Cisco Systems, Inc",
        "C8:D7:19": "Cisco-Linksys, LLC",
        "00:10:79": "Cisco Systems, Inc",
        "00:10:29": "Cisco Systems, Inc",
        "00:0E:08": "Cisco-Linksys, LLC",
        "44:03:A7": "Cisco Systems, Inc",
        "B0:FA:EB": "Cisco Systems, Inc",
        "7C:AD:74": "Cisco Systems, Inc",
        "00:60:3E": "Cisco Systems, Inc",
        "00:60:2F": "Cisco Systems, Inc",
        "00:60:47": "Cisco Systems, Inc",
        "00:50:A2": "Cisco Systems, Inc",
        "00:02:3D": "Cisco Systems, Inc",
        "20:3A:07": "Cisco Systems, Inc",
        "00:50:2A": "Cisco Systems, Inc",
        "BC:16:F5": "Cisco Systems, Inc",
        "FC:5B:39": "Cisco Systems, Inc",
        "34:6F:90": "Cisco Systems, Inc",
        "5C:FC:66": "Cisco Systems, Inc",
        "D4:6D:50": "Cisco Systems, Inc",
        "74:A0:2F": "Cisco Systems, Inc",
        "88:90:8D": "Cisco Systems, Inc",
        "F0:78:16": "Cisco Systems, Inc",
        "00:22:3A": "Cisco SPVTG",
        "00:21:BE": "Cisco SPVTG",
        "14:DA:E9": "ASUSTek COMPUTER INC.",
        "F4:CF:E2": "Cisco Systems, Inc",
        "A8:0C:0D": "Cisco Systems, Inc",
        "C0:7B:BC": "Cisco Systems, Inc",
        "24:E9:B3": "Cisco Systems, Inc",
        "00:11:D8": "ASUSTek COMPUTER INC.",
        "C0:8C:60": "Cisco Systems, Inc",
        "E8:ED:F3": "Cisco Systems, Inc",
        "E4:C7:22": "Cisco Systems, Inc",
        "64:E9:50": "Cisco Systems, Inc",
        "F4:1F:C2": "Cisco Systems, Inc",
        "44:AD:D9": "Cisco Systems, Inc",
        "0C:68:03": "Cisco Systems, Inc",
        "1C:DE:A7": "Cisco Systems, Inc",
        "F0:7F:06": "Cisco Systems, Inc",
        "88:F0:31": "Cisco Systems, Inc",
        "00:18:F3": "ASUSTek COMPUTER INC.",
        "00:1A:92": "ASUSTek COMPUTER INC.",
        "00:0C:41": "Cisco-Linksys, LLC",
        "00:16:B6": "Cisco-Linksys, LLC",
        "00:18:F8": "Cisco-Linksys, LLC",
        "00:25:2E": "Cisco SPVTG",
        "54:D4:6F": "Cisco SPVTG",
        "A4:A2:4A": "Cisco SPVTG",
        "44:E0:8E": "Cisco SPVTG",
        "00:E0:36": "PIONEER CORPORATION",
        "00:E0:4F": "Cisco Systems, Inc",
        "00:10:FF": "Cisco Systems, Inc",
        "00:10:54": "Cisco Systems, Inc",
        "00:10:F6": "Cisco Systems, Inc",
        "00:10:A6": "Cisco Systems, Inc",
        "BC:C8:10": "Cisco SPVTG",
        "7C:B2:1B": "Cisco SPVTG",
        "24:76:7D": "Cisco SPVTG",
        "48:1D:70": "Cisco SPVTG",
        "F0:B2:E5": "Cisco Systems, Inc",
        "00:23:32": "Apple, Inc.",
        "00:23:6C": "Apple, Inc.",
        "00:23:DF": "Apple, Inc.",
        "00:25:00": "Apple, Inc.",
        "00:25:BC": "Apple, Inc.",
        "58:97:BD": "Cisco Systems, Inc",
        "5C:83:8F": "Cisco Systems, Inc",
        "EC:BD:1D": "Cisco Systems, Inc",
        "00:19:E3": "Apple, Inc.",
        "00:1B:63": "Apple, Inc.",
        "00:1E:C2": "Apple, Inc.",
        "00:1F:F3": "Apple, Inc.",
        "00:10:FA": "Apple, Inc.",
        "00:50:E4": "Apple, Inc.",
        "00:0D:93": "Apple, Inc.",
        "7C:FA:DF": "Apple, Inc.",
        "78:A3:E4": "Apple, Inc.",
        "14:8F:C6": "Apple, Inc.",
        "28:6A:B8": "Apple, Inc.",
        "28:E0:2C": "Apple, Inc.",
        "E0:B9:BA": "Apple, Inc.",
        "00:C6:10": "Apple, Inc.",
        "B8:F6:B1": "Apple, Inc.",
        "8C:FA:BA": "Apple, Inc.",
        "7C:D1:C3": "Apple, Inc.",
        "F0:DC:E2": "Apple, Inc.",
        "24:AB:81": "Apple, Inc.",
        "E0:F8:47": "Apple, Inc.",
        "28:E7:CF": "Apple, Inc.",
        "E4:CE:8F": "Apple, Inc.",
        "A8:20:66": "Apple, Inc.",
        "BC:52:B7": "Apple, Inc.",
        "5C:59:48": "Apple, Inc.",
        "C8:BC:C8": "Apple, Inc.",
        "E8:04:0B": "Apple, Inc.",
        "14:5A:05": "Apple, Inc.",
        "1C:AB:A7": "Apple, Inc.",
        "C0:84:7A": "Apple, Inc.",
        "34:15:9E": "Apple, Inc.",
        "58:B0:35": "Apple, Inc.",
        "DC:86:D8": "Apple, Inc.",
        "90:B9:31": "Apple, Inc.",
        "D0:E1:40": "Apple, Inc.",
        "24:A2:E1": "Apple, Inc.",
        "04:21:4C": "Insight Energy Ventures LLC",
        "F8:32:E4": "ASUSTek COMPUTER INC.",
        "80:EA:96": "Apple, Inc.",
        "60:03:08": "Apple, Inc.",
        "04:F1:3E": "Apple, Inc.",
        "98:F0:AB": "Apple, Inc.",
        "78:31:C1": "Apple, Inc.",
        "78:3A:84": "Apple, Inc.",
        "5C:8D:4E": "Apple, Inc.",
        "88:63:DF": "Apple, Inc.",
        "88:1F:A1": "Apple, Inc.",
        "C8:E0:EB": "Apple, Inc.",
        "98:B8:E3": "Apple, Inc.",
        "88:53:95": "Apple, Inc.",
        "78:6C:1C": "Apple, Inc.",
        "4C:8D:79": "Apple, Inc.",
        "1C:E6:2B": "Apple, Inc.",
        "0C:30:21": "Apple, Inc.",
        "0C:3E:9F": "Apple, Inc.",
        "FC:FC:48": "Apple, Inc.",
        "9C:29:3F": "Apple, Inc.",
        "80:A1:AB": "Intellisis",
        "84:28:5A": "Saffron Solutions Inc",
        "D4:B8:FF": "Home Control Singapore Pte Ltd",
        "08:74:02": "Apple, Inc.",
        "94:F6:A3": "Apple, Inc.",
        "98:E0:D9": "Apple, Inc.",
        "CC:29:F5": "Apple, Inc.",
        "28:5A:EB": "Apple, Inc.",
        "F0:24:75": "Apple, Inc.",
        "2C:1F:23": "Apple, Inc.",
        "54:9F:13": "Apple, Inc.",
        "F0:DB:E2": "Apple, Inc.",
        "74:81:14": "Apple, Inc.",
        "18:F6:43": "Apple, Inc.",
        "A4:5E:60": "Apple, Inc.",
        "A0:18:28": "Apple, Inc.",
        "D0:03:4B": "Apple, Inc.",
        "10:41:7F": "Apple, Inc.",
        "A8:66:7F": "Apple, Inc.",
        "D0:25:98": "Apple, Inc.",
        "80:BE:05": "Apple, Inc.",
        "24:A0:74": "Apple, Inc.",
        "84:78:8B": "Apple, Inc.",
        "84:A4:23": "Sagemcom Broadband SAS",
        "3C:78:73": "Airsonics",
        "9C:88:AD": "Fiberhome Telecommunication Technologies Co.,LTD",
        "88:94:7E": "Fiberhome Telecommunication Technologies Co.,LTD",
        "C8:A2:CE": "Oasis Media Systems LLC",
        "58:F4:96": "Source Chain",
        "58:7F:57": "Apple, Inc.",
        "D0:7C:2D": "Leie IOT technology Co., Ltd",
        "EC:64:E7": "MOCACARE Corporation",
        "40:86:2E": "JDM MOBILE INTERNET SOLUTION CO., LTD.",
        "C4:BB:EA": "Pakedge Device and Software Inc",
        "98:87:44": "Wuxi Hongda Science and Technology Co.,LTD",
        "E8:34:3E": "Beijing Infosec Technologies Co., LTD.",
        "34:69:87": "zte corporation",
        "98:F4:28": "zte corporation",
        "A4:CC:32": "Inficomm Co., Ltd",
        "00:6D:52": "Apple, Inc.",
        "A0:32:99": "Lenovo (Beijing) Co., Ltd.",
        "40:54:E4": "Wearsafe Labs Inc",
        "DC:9A:8E": "Nanjing Cocomm electronics co., LTD",
        "AC:EE:9E": "Samsung Electronics Co.,Ltd",
        "B8:57:D8": "Samsung Electronics Co.,Ltd",
        "70:BF:3E": "Charles River Laboratories",
        "A8:C8:7F": "Roqos, Inc.",
        "3C:83:1E": "CKD Corporation",
        "90:DF:FB": "HOMERIDER SYSTEMS",
        "30:5A:3A": "ASUSTek COMPUTER INC.",
        "2C:08:1C": "OVH",
        "C0:84:88": "Finis Inc",
        "38:F5:57": "JOLATA, INC.",
        "54:A3:FA": "BQT Solutions (Australia)Pty Ltd",
        "24:6C:8A": "YUKAI Engineering",
        "AC:C5:1B": "Zhuhai Pantum Electronics Co., Ltd.",
        "38:5F:66": "Cisco SPVTG",
        "B8:44:D9": "Apple, Inc.",
        "9C:7A:03": "Ciena Corporation",
        "5C:CF:7F": "Espressif Inc.",
        "68:12:95": "Lupine Lighting Systems GmbH",
        "70:11:AE": "Music Life LTD",
        "04:1E:7A": "DSPWorks",
        "84:A7:88": "Perples",
        "AC:60:B6": "Ericsson AB",
        "14:B3:70": "Gigaset Digital Technology (Shenzhen) Co., Ltd.",
        "68:89:C1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "1C:49:7B": "Gemtek Technology Co., Ltd.",
        "2C:CF:58": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D0:93:80": "Ducere Technologies Pvt. Ltd.",
        "68:F9:56": "Objetivos y Servicio de Valor Añadido",
        "C8:A9:FC": "Goyoo Networks Inc.",
        "FC:FE:C2": "Invensys Controls UK Limited",
        "68:9A:B7": "Atelier Vision Corporation",
        "44:4C:A8": "Arista Networks",
        "7C:2B:E1": "Shenzhen Ferex Electrical Co.,Ltd",
        "50:31:AD": "ABB Global Industries and Services Private Limited",
        "14:3E:BF": "zte corporation",
        "FC:2F:EF": "UTT Technologies Co., Ltd.",
        "A4:C1:38": "Telink Semiconductor (Taipei) Co. Ltd.",
        "20:F5:10": "Codex Digital Limited",
        "A8:74:1D": "PHOENIX CONTACT Electronics GmbH",
        "F0:9A:51": "Shanghai Viroyal Electronic Technology Company Limited",
        "4C:B8:2C": "Cambridge Mobile Telematics, Inc.",
        "E4:A3:2F": "Shanghai Artimen Technology Co., Ltd.",
        "F4:67:2D": "ShenZhen Topstar Technology Company",
        "A8:D8:28": "Ascensia Diabetes Care",
        "B8:69:C2": "Sunitec Enterprise Co., Ltd.",
        "88:CB:A5": "Suzhou Torchstar Intelligent Technology Co.,Ltd",
        "7C:A2:3E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "50:1A:A5": "GN Netcom A/S",
        "A4:8D:3B": "Vizio, Inc",
        "1C:56:FE": "Motorola Mobility LLC, a Lenovo Company",
        "B8:99:B0": "Cohere Technologies",
        "D8:5D:EF": "Busch-Jaeger Elektro GmbH",
        "88:A2:D7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:32:3A": "so-logic",
        "80:9F:AB": "Fiberhome Telecommunication Technologies Co.,LTD",
        "E0:03:70": "ShenZhen Continental Wireless Technology Co., Ltd.",
        "04:61:69": "MEDIA GLOBAL LINKS CO., LTD.",
        "BC:EB:5F": "Fujian Beifeng Telecom Technology Co., Ltd.",
        "AC:5A:14": "Samsung Electronics Co.,Ltd",
        "F0:AB:54": "MITSUMI ELECTRIC CO.,LTD.",
        "3C:31:78": "Qolsys Inc.",
        "08:EC:A9": "Samsung Electronics Co.,Ltd",
        "E0:4B:45": "Hi-P Electronics Pte Ltd",
        "F4:6A:92": "SHENZHEN FAST TECHNOLOGIES CO.,LTD",
        "F0:D6:57": "ECHOSENS",
        "9C:37:F4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "3C:47:11": "HUAWEI TECHNOLOGIES CO.,LTD",
        "5C:EB:68": "Cheerstar Technology Co., Ltd",
        "AC:56:2C": "LAVA INTERNATIONAL(H.K) LIMITED",
        "FC:9A:FA": "Motus Global Inc.",
        "14:15:7C": "TOKYO COSMOS ELECTRIC CO.,LTD.",
        "20:E4:07": "Spark srl",
        "D0:9D:AB": "TCT mobile ltd",
        "88:73:84": "Toshiba",
        "24:69:3E": "innodisk Corporation",
        "C0:DC:6A": "Qingdao Eastsoft Communication Technology Co.,LTD",
        "24:B0:A9": "Shanghai Mobiletek Communication Ltd.",
        "1C:C5:86": "Absolute Acoustics",
        "40:7F:E0": "Glory Star Technics (ShenZhen) Limited",
        "C8:E1:30": "Milkyway Group Ltd",
        "48:6E:FB": "Davit System Technology Co., Ltd.",
        "B0:96:6C": "Lanbowan Technology Ltd.",
        "1C:F0:3E": "Wearhaus Inc.",
        "88:3B:8B": "Cheering Connection Co. Ltd.",
        "E4:F9:39": "Minxon Hotel Technology INC.",
        "14:6B:72": "Shenzhen Fortune Ship Technology Co., Ltd.",
        "B8:F0:80": "SPS, INC.",
        "80:50:67": "W & D TECHNOLOGY CORPORATION",
        "78:F9:44": "Private",
        "24:76:56": "Shanghai Net Miles Fiber Optics Technology Co., LTD.",
        "F8:CF:C5": "Motorola Mobility LLC, a Lenovo Company",
        "A4:7B:85": "ULTIMEDIA Co Ltd,",
        "5C:5B:35": "Mist Systems, Inc.",
        "EC:BA:FE": "GIROPTIC",
        "3C:2C:94": "杭州德澜科技有限公司（HangZhou Delan Technology Co.,Ltd）",
        "24:1B:44": "Hangzhou Tuners Electronics Co., Ltd",
        "80:A8:5D": "Osterhout Design Group",
        "AC:CA:AB": "Virtual Electric Inc",
        "48:54:15": "NET RULES TECNOLOGIA EIRELI",
        "78:40:E4": "Samsung Electronics Co.,Ltd",
        "E0:99:71": "Samsung Electronics Co.,Ltd",
        "70:DA:9C": "TECSEN",
        "2C:A2:B4": "Fortify Technologies, LLC",
        "10:D3:8A": "Samsung Electronics Co.,Ltd",
        "E4:85:01": "Geberit International AG",
        "20:62:74": "Microsoft Corporation",
        "E8:16:2B": "IDEO Security Co., Ltd.",
        "B4:73:56": "Hangzhou Treebear Networking Co., Ltd.",
        "34:68:95": "Hon Hai Precision Ind. Co.,Ltd.",
        "84:73:03": "Letv Mobile and Intelligent Information Technology (Beijing) Corporation Ltd.",
        "3C:C2:E1": "XINHUA CONTROL ENGINEERING CO.,LTD",
        "8C:87:3B": "Leica Camera AG",
        "44:F4:77": "Juniper Networks",
        "14:29:71": "NEMOA ELECTRONICS (HK) CO. LTD",
        "78:E9:80": "RainUs Co.,Ltd",
        "E0:FF:F7": "Softiron Inc.",
        "3C:6A:9D": "Dexatek Technology LTD.",
        "34:9E:34": "Evervictory Electronic Co.Ltd",
        "70:0F:C7": "SHENZHEN IKINLOOP TECHNOLOGY CO.,LTD.",
        "BC:74:D7": "HangZhou JuRu Technology CO.,LTD",
        "78:EB:14": "SHENZHEN FAST TECHNOLOGIES CO.,LTD",
        "3C:49:37": "ASSMANN Electronic GmbH",
        "84:44:64": "ServerU Inc",
        "00:35:60": "Rosen Aviation",
        "F8:BC:41": "Rosslare Enterprises Limited",
        "3C:B7:92": "Hitachi Maxell, Ltd., Optronics Division",
        "F8:B2:F3": "GUANGZHOU BOSMA TECHNOLOGY CO.,LTD",
        "28:D9:8A": "Hangzhou Konke Technology Co.,Ltd.",
        "D8:93:41": "General Electric Global Research",
        "1C:9E:CB": "Beijing Nari Smartchip Microelectronics Company Limited",
        "D4:8D:D9": "Meld Technology, Inc",
        "DC:C6:22": "BUHEUNG SYSTEM",
        "90:2C:C7": "C-MAX Asia Limited",
        "88:70:EF": "SC Professional Trading Co., Ltd.",
        "94:C0:38": "Tallac Networks",
        "68:36:B5": "DriveScale, Inc.",
        "C4:08:80": "Shenzhen UTEPO Tech Co., Ltd.",
        "D8:80:39": "Microchip Technology Inc.",
        "5C:96:6A": "RTNET",
        "BC:BC:46": "SKS Welding Systems GmbH",
        "98:16:EC": "IC Intracom",
        "D0:62:A0": "China Essence Technology (Zhumadian) Co., Ltd.",
        "90:17:9B": "Nanomegas",
        "14:F8:93": "Wuhan FiberHome Digital Technology Co.,Ltd.",
        "58:21:36": "KMB systems, s.r.o.",
        "80:09:02": "Keysight Technologies, Inc.",
        "04:99:E6": "Shenzhen Yoostar Technology Co., Ltd",
        "70:FF:5C": "Cheerzing Communication(Xiamen)Technology Co.,Ltd",
        "4C:48:DA": "Beijing Autelan Technology Co.,Ltd",
        "20:5C:FA": "Yangzhou ChangLian Network Technology Co,ltd.",
        "84:93:0C": "InCoax Networks Europe AB",
        "1C:A2:B1": "ruwido austria gmbh",
        "38:4B:76": "AIRTAME ApS",
        "38:B1:DB": "Hon Hai Precision Ind. Co.,Ltd.",
        "34:F6:D2": "Panasonic Taiwan Co.,Ltd.",
        "64:00:2D": "Powerlinq Co., LTD",
        "B4:7C:29": "Shenzhen Guzidi Technology Co.,Ltd",
        "D4:8F:33": "Microsoft Corporation",
        "54:F8:76": "ABB AG",
        "34:B7:FD": "Guangzhou Younghead Electronic Technology Co.,Ltd",
        "B4:17:80": "DTI Group Ltd",
        "48:9D:18": "Flashbay Limited",
        "90:20:3A": "BYD Precision Manufacture Co.,Ltd",
        "80:EA:CA": "Dialog Semiconductor Hellas SA",
        "20:A9:9B": "Microsoft Corporation",
        "60:48:26": "Newbridge Technologies Int. Ltd.",
        "38:F3:3F": "TATSUNO CORPORATION",
        "D8:0C:CF": "C.G.V. S.A.S.",
        "4C:BB:58": "Chicony Electronics Co., Ltd.",
        "A4:12:42": "NEC Platforms, Ltd.",
        "D0:0A:AB": "Yokogawa Digital Computer Corporation",
        "C4:00:06": "Lipi Data Systems Ltd.",
        "38:26:2B": "UTran Technology",
        "48:0C:49": "NAKAYO Inc",
        "3C:D9:CE": "Eclipse WiFi",
        "60:77:E2": "Samsung Electronics Co.,Ltd",
        "FC:19:10": "Samsung Electronics Co.,Ltd",
        "FC:79:0B": "Hitachi High Technologies America, Inc.",
        "60:81:F9": "Helium Systems, Inc",
        "84:01:A7": "Greyware Automation Products, Inc",
        "98:F1:70": "Murata Manufacturing Co., Ltd.",
        "68:6E:48": "Prophet Electronic Technology Corp.,Ltd",
        "04:C9:91": "Phistek INC.",
        "3C:A1:0D": "Samsung Electronics Co.,Ltd",
        "64:6C:B2": "Samsung Electronics Co.,Ltd",
        "68:05:71": "Samsung Electronics Co.,Ltd",
        "14:B4:84": "Samsung Electronics Co.,Ltd",
        "F4:C4:47": "Coagent International Enterprise Limited",
        "C8:E4:2F": "Technical Research Design and Development",
        "C4:C9:EC": "Gugaoo   HK Limited",
        "34:E4:2A": "Automatic Bar Controls Inc.",
        "30:59:B7": "Microsoft",
        "20:A7:87": "Bointec Taiwan Corporation Limited",
        "A0:FC:6E": "Telegrafia a.s.",
        "20:53:CA": "Risk Technology Ltd",
        "A4:3D:78": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "04:57:2F": "Sertel Electronics UK Ltd",
        "D8:97:7C": "Grey Innovation",
        "BC:8D:0E": "Nokia",
        "A4:9F:85": "Lyve Minds, Inc",
        "78:92:3E": "Nokia Corporation",
        "AC:A9:A0": "Audioengine, Ltd.",
        "A4:81:EE": "Nokia Corporation",
        "78:D6:6F": "Aristocrat Technologies Australia Pty. Ltd.",
        "44:1E:91": "ARVIDA Intelligent Electronics Technology  Co.,Ltd.",
        "C4:62:6B": "ZPT Vigantice",
        "EC:17:66": "Research Centre Module",
        "A0:D1:2A": "AXPRO Technology Inc.",
        "20:9A:E9": "Volacomm Co., Ltd",
        "34:5D:10": "Wytek",
        "6C:14:F7": "Erhardt+Leimer GmbH",
        "B0:D5:9D": "Shenzhen Zowee Technology Co., Ltd",
        "68:28:BA": "Dejai",
        "B0:57:06": "Vallox Oy",
        "48:EE:07": "Silver Palm Technologies LLC",
        "50:C7:BF": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "20:5A:00": "Coval",
        "A8:A6:68": "zte corporation",
        "00:EE:BD": "HTC Corporation",
        "38:F7:08": "National Resource Management, Inc.",
        "E0:DB:88": "Open Standard Digital-IF Interface for SATCOM Systems",
        "A8:BD:3A": "UNIONMAN TECHNOLOGY CO.,LTD",
        "A8:24:EB": "ZAO NPO Introtest",
        "C4:0E:45": "ACK Networks,Inc.",
        "3C:89:A6": "KAPELSE",
        "A4:6C:C1": "LTi REEnergy GmbH",
        "A8:B9:B3": "ESSYS",
        "6C:09:D6": "Digiquest Electronics LTD",
        "48:18:42": "Shanghai Winaas Co. Equipment Co. Ltd.",
        "44:70:98": "MING HONG TECHNOLOGY (SHEN ZHEN) LIMITED",
        "9C:BD:9D": "SkyDisk, Inc.",
        "74:C6:21": "Zhejiang Hite Renewable Energy Co.,LTD",
        "D4:31:9D": "Sinwatec",
        "B0:68:B6": "Hangzhou OYE Technology Co. Ltd",
        "9C:65:F9": "AcSiP Technology Corp.",
        "48:76:04": "Private",
        "2C:53:4A": "Shenzhen Winyao Electronic Limited",
        "A4:BB:AF": "Lime Instruments",
        "F4:90:CA": "Tensorcom",
        "E4:4C:6C": "Shenzhen Guo Wei Electronic Co,. Ltd.",
        "A8:57:4E": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "B8:43:E4": "Vlatacom",
        "28:22:46": "Beijing Sinoix Communication Co., LTD",
        "48:B9:77": "PulseOn Oy",
        "70:71:B3": "Brain Corporation",
        "64:E6:25": "Woxu Wireless Co., Ltd",
        "10:B7:13": "Private",
        "10:0E:7E": "Juniper Networks",
        "20:89:86": "zte corporation",
        "44:C5:6F": "NGN Easy Satfinder (Tianjin) Electronic Co., Ltd",
        "B8:98:F7": "Gionee Communication Equipment Co,Ltd.ShenZhen",
        "84:83:36": "Newrun",
        "18:20:12": "Aztech Associates Inc.",
        "B8:26:6C": "ANOV France",
        "3C:30:0C": "Dewar Electronics Pty Ltd",
        "98:FF:D0": "Lenovo Mobile Communication Technology Ltd.",
        "A8:75:E2": "Aventura Technologies, Inc.",
        "B8:7A:C9": "Siemens Ltd.",
        "F0:61:30": "Advantage Pharmacy Services, LLC",
        "6C:3C:53": "SoundHawk Corp",
        "08:40:27": "Gridstore Inc.",
        "38:BF:2F": "Espec Corp.",
        "44:C4:A9": "Opticom Communication, LLC",
        "C4:82:4E": "Changzhou Uchip Electronics Co., LTD.",
        "A4:77:60": "Nokia Corporation",
        "C8:56:63": "Sunflex Europe GmbH",
        "88:FE:D6": "ShangHai WangYong Software Co., Ltd.",
        "7C:72:E4": "Unikey Technologies",
        "7C:20:48": "KoamTac",
        "8C:B7:F7": "Shenzhen UniStrong Science & Technology Co., Ltd",
        "38:B7:4D": "Fijowave Limited",
        "18:0C:14": "iSonea Limited",
        "9C:A9:E4": "zte corporation",
        "90:F3:B7": "Kirisun Communications Co., Ltd.",
        "C4:E9:2F": "AB Sciex",
        "A8:8D:7B": "SunDroid Global limited.",
        "3C:F7:48": "Shenzhen Linsn Technology Development Co.,Ltd",
        "B0:79:08": "Cummings Engineering",
        "E4:77:23": "zte corporation",
        "1C:63:B7": "OpenProducts 237 AB",
        "94:B9:B4": "Aptos Technology",
        "6C:15:F9": "Nautronix Limited",
        "18:AA:45": "Fon Technology",
        "90:20:83": "General Engine Management Systems Ltd.",
        "14:B1:26": "Industrial Software Co",
        "D8:50:E6": "ASUSTek COMPUTER INC.",
        "DC:3E:F8": "Nokia Corporation",
        "A4:9F:89": "Shanghai Rui Rui Communication Technology Co.Ltd.",
        "70:60:DE": "LaVision GmbH",
        "50:2E:5C": "HTC Corporation",
        "FC:FE:77": "Hitachi Reftechno, Inc.",
        "70:53:3F": "Alfa Instrumentos Eletronicos Ltda.",
        "40:7A:80": "Nokia Corporation",
        "64:42:14": "Swisscom Energy Solutions AG",
        "0C:A6:94": "Sunitec Enterprise Co.,Ltd",
        "18:44:62": "Riava Networks, Inc.",
        "C0:35:80": "A&R TECH",
        "D0:8A:55": "Skullcandy",
        "34:4F:3F": "IO-Power Technology Co., Ltd.",
        "14:60:80": "zte corporation",
        "9C:BB:98": "Shen Zhen RND Electronic Co.,LTD",
        "50:C2:71": "SECURETECH INC",
        "CC:72:0F": "Viscount Systems Inc.",
        "74:2B:62": "FUJITSU LIMITED",
        "64:3F:5F": "Exablaze",
        "8C:2F:39": "IBA Dosimetry GmbH",
        "C0:A0:BB": "D-Link International",
        "2C:CD:69": "Aqavi.com",
        "F4:5F:69": "Matsufu Electronics distribution Company",
        "28:A1:EB": "ETEK TECHNOLOGY (SHENZHEN) CO.,LTD",
        "B8:F8:28": "Changshu Gaoshida Optoelectronic Technology Co. Ltd.",
        "3C:1A:57": "Cardiopulmonary Corp",
        "54:1B:5D": "Techno-Innov",
        "9C:E7:BD": "Winduskorea co., Ltd",
        "38:42:A6": "Ingenieurbuero Stahlkopf",
        "24:80:00": "Westcontrol AS",
        "1C:4B:B9": "SMG ENTERPRISE, LLC",
        "34:61:78": "The Boeing Company",
        "14:46:E4": "AVISTEL",
        "D0:95:C7": "Pantech Co., Ltd.",
        "D0:2C:45": "littleBits Electronics, Inc.",
        "04:4F:8B": "Adapteva, Inc.",
        "B4:A8:2B": "Histar Digital Electronics Co., Ltd.",
        "28:4D:92": "Luminator",
        "54:FB:58": "WISEWARE, Lda",
        "94:0B:D5": "Himax Technologies, Inc",
        "E0:D1:E6": "Aliph dba Jawbone",
        "D8:2D:9B": "Shenzhen G.Credit Communication Technology Co., Ltd",
        "70:9B:FC": "Bryton Inc.",
        "AC:E4:2E": "SK hynix",
        "78:FE:41": "Socus networks",
        "20:57:21": "Salix Technology CO., Ltd.",
        "88:36:12": "SRC Computers, LLC",
        "08:35:71": "CASwell INC.",
        "98:76:B6": "Adafruit",
        "50:3C:C4": "Lenovo Mobile Communication Technology Ltd.",
        "2C:7B:84": "OOO Petr Telegin",
        "A4:C0:C7": "ShenZhen Hitom Communication Technology Co..LTD",
        "30:61:12": "PAV GmbH",
        "78:9F:4C": "HOERBIGER Elektronik GmbH",
        "18:10:4E": "CEDINT-UPM",
        "9C:14:65": "Edata Elektronik San. ve Tic. A.Ş.",
        "4C:55:CC": "Zentri Pty Ltd",
        "00:C5:DB": "Datatech Sistemas Digitales Avanzados SL",
        "8C:F9:45": "Power Automation pte Ltd",
        "F8:42:FB": "Yasuda Joho Co.,ltd.",
        "88:73:98": "K2E Tekpoint",
        "2C:92:2C": "Kishu Giken Kogyou Company Ltd,.",
        "D8:FE:E3": "D-Link International",
        "3C:97:7E": "IPS Technology Limited",
        "A4:FB:8D": "Hangzhou Dunchong Technology Co.Ltd",
        "F4:CD:90": "Vispiron Rotec GmbH",
        "80:6C:8B": "KAESER KOMPRESSOREN AG",
        "04:3D:98": "ChongQing QingJia Electronics CO.,LTD",
        "E0:3E:4A": "Cavanagh Group International",
        "04:1B:94": "Host Mobility AB",
        "A0:CE:C8": "CE LINK LIMITED",
        "90:7A:28": "Beijing Morncloud Information And Technology Co. Ltd.",
        "10:01:CA": "Ashley Butterworth",
        "24:6A:AB": "IT-IS International",
        "FC:4B:BC": "Sunplus Technology Co., Ltd.",
        "50:A0:BF": "Alba Fiber Systems Inc.",
        "B8:36:D8": "Videoswitch",
        "DC:6F:00": "Livescribe, Inc.",
        "54:E3:B0": "JVL Industri Elektronik",
        "80:4B:20": "Ventilation Control",
        "28:79:94": "Realplay Digital Technology(Shenzhen) Co.,Ltd",
        "10:7A:86": "U&U ENGINEERING INC.",
        "40:BD:9E": "Physio-Control, Inc",
        "6C:57:79": "Aclima, Inc.",
        "C0:DA:74": "Hangzhou Sunyard Technology Co., Ltd.",
        "18:D6:CF": "Kurth Electronic GmbH",
        "F4:81:39": "CANON INC.",
        "18:36:FC": "Elecsys International Corporation",
        "88:23:64": "Watchnet DVR Inc",
        "58:1C:BD": "Affinegy",
        "28:4F:CE": "Liaoning Wontel Science and Technology Development Co.,Ltd.",
        "04:8D:38": "Netcore Technology Inc.",
        "2C:94:64": "Cincoze Co., Ltd.",
        "30:65:EC": "Wistron (ChongQing)",
        "54:2C:EA": "PROTECTRON",
        "94:B8:C5": "RuggedCom Inc.",
        "DC:82:5B": "JANUS, spol. s r.o.",
        "9C:A5:77": "Osorno Enterprises Inc.",
        "C0:43:01": "Epec Oy",
        "E0:7C:62": "Whistle Labs, Inc.",
        "F0:7F:0C": "Leopold Kostal GmbH &Co. KG",
        "4C:62:55": "SANMINA-SCI SYSTEM DE MEXICO S.A. DE C.V.",
        "08:27:19": "APS systems/electronic AG",
        "50:5A:C6": "GUANGDONG SUPER TELECOM CO.,LTD.",
        "9C:79:AC": "Suntec Software(Shanghai) Co., Ltd.",
        "4C:96:14": "Juniper Networks",
        "B8:63:BC": "ROBOTIS, Co, Ltd",
        "98:0D:2E": "HTC Corporation",
        "C4:19:EC": "Qualisys AB",
        "60:4A:1C": "SUYIN Corporation",
        "D4:64:F7": "CHENGDU USEE DIGITAL TECHNOLOGY CO., LTD",
        "74:D0:2B": "ASUSTek COMPUTER INC.",
        "60:1E:02": "EltexAlatau",
        "E0:C6:B3": "MilDef AB",
        "64:72:D8": "GooWi Technology Co.,Limited",
        "60:60:1F": "SZ DJI TECHNOLOGY CO.,LTD",
        "5C:84:86": "Brightsource Industries Israel LTD",
        "50:CD:32": "NanJing Chaoran Science & Technology Co.,Ltd.",
        "BC:BA:E1": "AREC Inc.",
        "18:FA:6F": "ISC applied systems corp",
        "A0:1C:05": "NIMAX TELECOM CO.,LTD.",
        "60:E0:0E": "SHINSEI ELECTRONICS CO LTD",
        "54:54:14": "Digital RF Corea, Inc",
        "24:EB:65": "SAET I.S. S.r.l.",
        "D0:F2:7F": "SteadyServ Technoligies, LLC",
        "E8:94:F6": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "18:84:10": "CoreTrust Inc.",
        "FC:22:9C": "Han Kyung I Net Co.,Ltd.",
        "18:32:A2": "LAON TECHNOLOGY CO., LTD.",
        "D4:A4:99": "InView Technology Corporation",
        "08:48:2C": "Raycore Taiwan Co., LTD.",
        "DC:2B:CA": "Zera GmbH",
        "94:98:A2": "Shanghai LISTEN TECH.LTD",
        "E0:ED:C7": "Shenzhen Friendcom Technology Development Co., Ltd",
        "B4:DD:15": "ControlThings Oy Ab",
        "DC:1D:D4": "Microstep-MIS spol. s r.o.",
        "FC:DD:55": "Shenzhen WeWins wireless Co.,Ltd",
        "B0:17:43": "EDISON GLOBAL CIRCUITS LLC",
        "D0:BE:2C": "CNSLink Co., Ltd.",
        "40:51:6C": "Grandex International Corporation",
        "C0:88:5B": "SnD Tech Co., Ltd.",
        "3C:FB:96": "Emcraft Systems LLC",
        "84:62:23": "Shenzhen Coship Electronics Co., Ltd.",
        "1C:FA:68": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "08:1F:3F": "WondaLink Inc.",
        "18:53:E0": "Hanyang Digitech Co.Ltd",
        "00:C1:4F": "DDL Co,.ltd.",
        "2C:26:C5": "zte corporation",
        "10:5F:06": "Actiontec Electronics, Inc",
        "08:79:99": "AIM GmbH",
        "C0:11:A6": "Fort-Telecom ltd.",
        "C0:4A:00": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "04:5F:A7": "Shenzhen Yichen Technology Development Co.,LTD",
        "94:C9:62": "Teseq AG",
        "DC:2A:14": "Shanghai Longjing Technology Co.",
        "68:86:E7": "Orbotix, Inc.",
        "C0:5E:6F": "V. Stonkaus firma Kodinis Raktas",
        "C0:B8:B1": "BitBox Ltd",
        "F8:2E:DB": "RTW GmbH & Co. KG",
        "80:8B:5C": "Shenzhen Runhuicheng Technology Co., Ltd",
        "D8:19:CE": "Telesquare",
        "E0:CE:C3": "ASKEY COMPUTER CORP",
        "38:F5:97": "home2net GmbH",
        "80:7B:1E": "Corsair Memory, Inc.",
        "B4:AB:2C": "MtM Technology Corporation",
        "74:37:2F": "Tongfang Shenzhen Cloudcomputing Technology Co.,Ltd",
        "F0:21:9D": "Cal-Comp Electronics & Communications Company Ltd.",
        "18:17:25": "Cameo Communications, Inc.",
        "84:62:A6": "EuroCB (Phils), Inc.",
        "E4:F3:65": "Time-O-Matic, Inc.",
        "DC:C0:DB": "Shenzhen Kaiboer Technology Co., Ltd.",
        "AC:5D:10": "Pace Americas",
        "FC:62:6E": "Beijing MDC Telecom",
        "84:C8:B1": "Incognito Software Systems Inc.",
        "E8:A3:64": "Signal Path International / Peachtree Audio",
        "BC:51:FE": "Swann communications Pty Ltd",
        "88:F4:90": "Jetmobile Pte Ltd",
        "1C:91:79": "Integrated System Technologies Ltd",
        "A0:BA:B8": "Pixon Imaging",
        "74:E4:24": "APISTE CORPORATION",
        "24:11:D0": "Chongqing Ehs Science and Technology Development Co.,Ltd.",
        "B4:61:FF": "Lumigon A/S",
        "A0:A1:30": "DLI Taiwan Branch office",
        "30:21:5B": "Shenzhen Ostar Display Electronic Co.,Ltd",
        "34:FA:40": "Guangzhou Robustel Technologies Co., Limited",
        "1C:5A:6B": "Philips Electronics Nederland BV",
        "A8:75:D6": "FreeTek International Co., Ltd.",
        "EC:E9:15": "STI Ltd",
        "80:D7:33": "QSR Automations, Inc.",
        "30:3D:08": "GLINTT TES S.A.",
        "A8:1F:AF": "KRYPTON POLSKA",
        "30:D3:57": "Logosol, Inc.",
        "BC:39:A6": "CSUN System Technology Co.,LTD",
        "EC:B5:41": "SHINANO E and E Co.Ltd.",
        "D4:10:CF": "Huanshun Network Science and Technology Co., Ltd.",
        "6C:B3:11": "Shenzhen Lianrui Electronics Co.,Ltd",
        "10:A7:43": "SK Mtek Limited",
        "54:7F:A8": "TELCO systems, s.r.o.",
        "54:74:E6": "Webtech Wireless",
        "C4:6D:F1": "DataGravity",
        "94:FD:2E": "Shanghai Uniscope Technologies Co.,Ltd",
        "E4:C1:46": "Objetivos y Servicios de Valor A",
        "D4:00:57": "MC Technologies GmbH",
        "5C:E0:F6": "NIC.br- Nucleo de Informacao e Coordenacao do Ponto BR",
        "C8:3D:97": "Nokia Corporation",
        "0C:F3:61": "Java Information",
        "60:0F:77": "SilverPlus, Inc",
        "B0:35:8D": "Nokia Corporation",
        "F8:E4:FB": "Actiontec Electronics, Inc",
        "8C:4A:EE": "GIGA TMS INC",
        "34:C9:9D": "EIDOLON COMMUNICATIONS TECHNOLOGY CO. LTD.",
        "AC:E6:4B": "Shenzhen Baojia Battery Technology Co., Ltd.",
        "78:9F:87": "Siemens AG I IA PP PRM",
        "08:E5:DA": "NANJING FUJITSU COMPUTER PRODUCTS CO.,LTD. ",
        "58:84:E4": "IP500 Alliance e.V.",
        "04:4B:FF": "GuangZhou Hedy Digital Technology Co., Ltd",
        "E8:71:8D": "Elsys Equipamentos Eletronicos Ltda",
        "D0:73:8E": "DONG OH PRECISION CO., LTD. ",
        "64:C9:44": "LARK Technologies, Inc",
        "0C:93:FB": "BNS Solutions",
        "E4:4F:5F": "EDS Elektronik Destek San.Tic.Ltd.Sti",
        "E8:6D:54": "Digit Mobile Inc",
        "90:B1:1C": "Dell Inc.",
        "00:5D:03": "Xilinx, Inc",
        "80:2F:DE": "Zurich Instruments AG",
        "5C:38:E0": "Shanghai Super Electronics Technology Co.,LTD",
        "08:AF:78": "Totus Solutions, Inc.",
        "C8:C7:91": "Zero1.tv GmbH",
        "EC:D9:25": "RAMI",
        "1C:94:92": "RUAG Schweiz AG",
        "B8:89:CA": "ILJIN ELECTRIC Co., Ltd.",
        "64:F5:0E": "Kinion Technology Company Limited",
        "D0:4C:C1": "SINTRONES Technology Corp.",
        "50:3F:56": "Syncmold Enterprise Corp",
        "8C:EE:C6": "Precepscion Pty. Ltd.",
        "10:12:48": "ITG, Inc.",
        "18:48:D8": "Fastback Networks",
        "F0:D3:E7": "Sensometrix SA",
        "B0:12:66": "Futaba-Kikaku",
        "7C:C8:D0": "TIANJIN YAAN TECHNOLOGY CO., LTD.",
        "88:E9:17": "Tamaggo",
        "88:61:5A": "Siano Mobile Silicon Ltd.",
        "70:E2:4C": "SAE IT-systems GmbH & Co. KG",
        "00:FD:4C": "NEVATEC",
        "14:43:19": "Creative&Link Technology Limited",
        "D8:AF:3B": "Hangzhou Bigbright Integrated communications system Co.,Ltd",
        "60:32:F0": "Mplus technology",
        "28:29:D9": "GlobalBeiMing technology (Beijing)Co. Ltd",
        "68:15:D3": "Zaklady Elektroniki i Mechaniki Precyzyjnej R&G S.A.",
        "10:F3:DB": "Gridco Systems, Inc.",
        "30:5D:38": "Beissbarth ",
        "60:D2:B9": "REALAND BIO CO., LTD.",
        "30:FD:11": "MACROTECH (USA) INC.",
        "C4:DA:26": "NOBLEX SA",
        "7C:C8:AB": "Acro Associates, Inc.",
        "60:19:29": "VOLTRONIC POWER TECHNOLOGY(SHENZHEN) CORP.",
        "48:B2:53": "Marketaxess Corporation",
        "74:94:3D": "AgJunction",
        "58:CF:4B": "Lufkin Industries",
        "68:B4:3A": "WaterFurnace International, Inc.",
        "4C:78:97": "Arrowhead Alarm Products Ltd",
        "44:E8:A5": "Myreka Technologies Sdn. Bhd.",
        "D8:AF:F1": "Panasonic Appliances Company",
        "2C:62:89": "Regenersis (Glenrothes) Ltd",
        "58:EC:E1": "Newport Corporation",
        "4C:09:B4": "zte corporation",
        "60:D1:AA": "Vishal Telecommunications Pvt Ltd",
        "70:9B:A5": "Shenzhen Y&D Electronics Co.,LTD.",
        "F4:54:33": "Rockwell Automation",
        "B4:89:10": "Coster T.E. S.P.A.",
        "B0:C8:3F": "Jiangsu Cynray IOT Co., Ltd.",
        "3C:F3:92": "Virtualtek. Co. Ltd",
        "B4:82:C5": "Relay2, Inc.",
        "98:5E:1B": "ConversDigital Co., Ltd.",
        "D4:8C:B5": "Cisco Systems, Inc",
        "90:9D:E0": "Newland Design + Assoc. Inc.",
        "14:9F:E8": "Lenovo Mobile Communication Technology Ltd.",
        "BC:D9:40": "ASR Co,.Ltd.",
        "04:9C:62": "BMT Medical Technology s.r.o.",
        "0C:2A:69": "electric imp, incorporated",
        "C4:55:C2": "Bach-Simpson",
        "00:E8:AB": "Meggitt Training Systems, Inc.",
        "B4:21:8A": "Dog Hunter LLC",
        "B4:A4:B5": "Zen Eye Co.,Ltd",
        "DC:37:D2": "Hunan HKT Electronic Technology Co., Ltd",
        "40:70:74": "Life Technology (China) Co., Ltd",
        "20:F0:02": "MTData Developments Pty. Ltd.",
        "38:8A:B7": "ITC Networks",
        "BC:C2:3A": "Thomson Video Networks",
        "1C:F4:CA": "Private",
        "AC:C2:EC": "CLT INT'L IND. CORP.",
        "A8:65:B2": "DONGGUAN YISHANG ELECTRONIC TECHNOLOGY CO., LIMITED",
        "E8:D0:FA": "MKS Instruments Deutschland GmbH",
        "98:26:2A": "Applied Research Associates, Inc",
        "3C:91:74": "ALONG COMMUNICATION TECHNOLOGY",
        "AC:EE:3B": "6harmonics Inc",
        "1C:6B:CA": "Mitsunami Co., Ltd.",
        "64:24:00": "Xorcom Ltd.",
        "E8:3E:FB": "GEODESIC LTD.",
        "EC:D1:9A": "Zhuhai Liming Industries Co., Ltd",
        "34:81:37": "UNICARD SA",
        "38:B1:2D": "Sonotronic Nagel GmbH",
        "54:9D:85": "EnerAccess inc",
        "B0:75:0C": "QA Cafe",
        "B4:E1:EB": "Private",
        "3C:36:3D": "Nokia Corporation",
        "80:86:98": "Netronics Technologies Inc.",
        "9C:E1:0E": "NCTech Ltd",
        "A0:6D:09": "Intelcan Technosystems Inc.",
        "60:F3:DA": "Logic Way GmbH",
        "FC:50:90": "SIMEX Sp. z o.o.",
        "60:B9:82": "RO.VE.R. Laboratories S.p.A.",
        "B4:62:38": "Exablox",
        "C8:BB:D3": "Embrane",
        "8C:60:4F": "Cisco Systems, Inc",
        "A4:B9:80": "Parking BOXX Inc.",
        "A4:7C:14": "ChargeStorm AB",
        "80:20:AF": "Trade FIDES, a.s.",
        "2C:75:0F": "Shanghai Dongzhou-Lawton Communication Technology Co. Ltd.",
        "5C:50:15": "Cisco Systems, Inc",
        "98:02:84": "Theobroma Systems GmbH",
        "1C:D4:0C": "Kriwan Industrie-Elektronik GmbH",
        "00:2D:76": "TITECH GmbH",
        "F8:DB:4C": "PNY Technologies, INC.",
        "0C:9D:56": "Consort Controls Ltd",
        "3C:B8:7A": "Private",
        "AC:14:61": "ATAW  Co., Ltd.",
        "E4:C6:E6": "Mophie, LLC",
        "50:2D:1D": "Nokia Corporation",
        "F4:8E:09": "Nokia Corporation",
        "58:48:C0": "COFLEC",
        "8C:57:FD": "LVX Western",
        "54:E6:3F": "ShenZhen LingKeWeiEr Technology Co., Ltd.",
        "20:FA:BB": "Cambridge Executive Limited",
        "14:1A:51": "Treetech Sistemas Digitais",
        "58:7F:C8": "S2M",
        "20:05:05": "RADMAX COMMUNICATION PRIVATE LIMITED",
        "C0:35:BD": "Velocytech Aps",
        "28:71:84": "Spire Payments",
        "7C:B0:3E": "OSRAM GmbH",
        "3C:9F:81": "Shenzhen CATIC Bit Communications Technology Co.,Ltd",
        "44:5F:7A": "Shihlin Electric & Engineering Corp.",
        "44:13:19": "WKK TECHNOLOGY LTD.",
        "18:B5:91": "I-Storm",
        "BC:8B:55": "NPP ELIKS America Inc. DBA T&M Atlantic",
        "C0:49:3D": "MAITRISE TECHNOLOGIQUE",
        "C8:45:44": "Asia Pacific CIS (Wuxi) Co, Ltd",
        "E0:EF:25": "Lintes Technology Co., Ltd.",
        "50:ED:94": "EGATEL SL",
        "48:A2:2D": "Shenzhen Huaxuchang Telecom Technology Co.,Ltd",
        "C8:60:00": "ASUSTek COMPUTER INC.",
        "AC:0D:FE": "Ekon GmbH - myGEKKO",
        "FC:5B:26": "MikroBits",
        "40:F4:07": "Nintendo Co., Ltd.",
        "B0:1C:91": "Elim Co",
        "04:F1:7D": "Tarana Wireless",
        "84:49:15": "vArmour Networks, Inc.",
        "2C:BE:97": "Ingenieurbuero Bickele und Buehler GmbH",
        "70:A6:6A": "Prox Dynamics AS",
        "DC:3E:51": "Solberg & Andersen AS",
        "90:0A:3A": "PSG Plastic Service GmbH",
        "28:CD:1C": "Espotel Oy",
        "D4:43:A8": "Changzhou Haojie Electric Co., Ltd.",
        "BC:E5:9F": "WATERWORLD Technology Co.,LTD",
        "70:41:B7": "Edwards Lifesciences LLC",
        "DC:A8:CF": "New Spin Golf, LLC.",
        "A8:49:A5": "Lisantech Co., Ltd.",
        "A0:5E:6B": "MELPER Co., Ltd.",
        "D8:78:E5": "KUHN SA",
        "D8:24:BD": "Cisco Systems, Inc",
        "34:97:FB": "ADVANCED RF TECHNOLOGIES INC",
        "F0:3A:55": "Omega Elektronik AS",
        "98:BC:57": "SVA TECHNOLOGIES CO.LTD",
        "DC:3C:2E": "Manufacturing System Insights, Inc.",
        "F8:35:53": "Magenta Research Ltd.",
        "F4:04:4C": "ValenceTech Limited",
        "C4:67:B5": "Libratone A/S",
        "4C:39:10": "Newtek Electronics co., Ltd.",
        "90:3A:A0": "Nokia",
        "B0:6C:BF": "3ality Digital Systems GmbH",
        "54:D0:ED": "AXIM Communications",
        "84:36:11": "hyungseul publishing networks",
        "34:40:B5": "IBM",
        "D4:D7:48": "Cisco Systems, Inc",
        "34:4F:69": "EKINOPS SAS",
        "F8:31:3E": "endeavour GmbH",
        "14:36:05": "Nokia Corporation",
        "C8:1A:FE": "DLOGIC GmbH",
        "EC:63:E5": "ePBoard Design LLC",
        "94:DB:49": "SITCORP",
        "F0:62:0D": "Shenzhen Egreat Tech Corp.,Ltd",
        "2C:67:FB": "ShenZhen Zhengjili Electronics Co., LTD",
        "3C:E5:B4": "KIDASEN INDUSTRIA E COMERCIO DE ANTENAS LTDA",
        "08:D0:9F": "Cisco Systems, Inc",
        "64:4B:F0": "CalDigit, Inc",
        "64:ED:62": "WOORI SYSTEMS Co., Ltd",
        "2C:00:2C": "UNOWHY",
        "5C:C9:D3": "PALLADIUM ENERGY ELETRONICA DA AMAZONIA LTDA",
        "C8:7C:BC": "Valink Co., Ltd. ",
        "B8:14:13": "Keen High Holding(HK) Ltd.",
        "B4:94:4E": "WeTelecom Co., Ltd.",
        "E0:0B:28": "Inovonics",
        "48:02:2A": "B-Link Electronic Limited",
        "18:E8:0F": "Viking Electronics Inc.",
        "CC:6B:F1": "Sound Masking Inc.",
        "2C:97:17": "I.C.Y. B.V.",
        "2C:3F:38": "Cisco Systems, Inc",
        "40:50:E0": "Milton Security Group LLC",
        "70:CA:9B": "Cisco Systems, Inc",
        "A0:78:BA": "Pantech Co., Ltd.",
        "68:BC:0C": "Cisco Systems, Inc",
        "34:5B:11": "EVI HEAT AB",
        "78:BA:D0": "Shinybow Technology Co. Ltd.",
        "24:E6:BA": "JSC Zavod im. Kozitsky",
        "CC:A3:74": "Guangdong Guanglian Electronic Technology Co.Ltd",
        "58:67:7F": "Clare Controls Inc.",
        "0C:5A:19": "Axtion Sdn Bhd",
        "A8:BD:1A": "Honey Bee (Hong Kong) Limited",
        "24:87:07": "SEnergy Corporation",
        "C4:C1:9F": "National Oilwell Varco Instrumentation, Monitoring, and Optimization (NOV IMO)",
        "00:08:30": "Cisco Systems, Inc",
        "C4:EE:AE": "VSS Monitoring",
        "F8:D3:A9": "AXAN Networks",
        "BC:77:9F": "SBM Co., Ltd.",
        "40:6A:AB": "RIM",
        "9C:A3:BA": "SAKURA Internet Inc.",
        "8C:8A:6E": "ESTUN AUTOMATION TECHNOLOY CO., LTD",
        "98:82:17": "Disruptive Ltd",
        "9C:5C:8D": "FIREMAX INDÚSTRIA E COMÉRCIO DE PRODUTOS ELETRÔNICOS  LTDA",
        "D4:20:6D": "HTC Corporation",
        "7C:1E:52": "Microsoft",
        "DC:B4:C4": "Microsoft XCG",
        "AC:CB:09": "Hefcom Metering (Pty) Ltd",
        "18:66:E3": "Veros Systems, Inc.",
        "74:FD:A0": "Compupal (Group) Corporation ",
        "CC:B8:F1": "EAGLE KINGDOM TECHNOLOGIES LIMITED",
        "A4:29:B7": "bluesky",
        "48:F3:17": "Private",
        "CC:F8:F0": "Xi'an HISU Multimedia Technology Co.,Ltd.",
        "04:88:8C": "Eifelwerk Butler Systeme GmbH",
        "D4:5A:B2": "Galleon Systems",
        "30:DE:86": "Cedac Software S.r.l.",
        "18:C4:51": "Tucson Embedded Systems",
        "70:46:42": "CHYNG HONG ELECTRONIC CO., LTD.",
        "D4:1C:1C": "RCF S.P.A.",
        "58:92:0D": "Kinetic Avionics Limited",
        "AC:02:EF": "Comsis",
        "B8:B4:2E": "Gionee Communication Equipment Co,Ltd.ShenZhen",
        "44:3E:B2": "DEOTRON Co., LTD.",
        "D0:59:C3": "CeraMicro Technology Corporation",
        "18:2C:91": "Concept Development, Inc.",
        "FC:17:94": "InterCreative Co., Ltd",
        "B4:0B:7A": "Brusa Elektronik AG",
        "28:0C:B8": "Mikrosay Yazilim ve Elektronik A.S.",
        "3C:C9:9E": "Huiyang Technology Co., Ltd",
        "2C:1E:EA": "AERODEV",
        "1C:8E:8E": "DB Communication & Systems Co., ltd.",
        "24:EC:99": "ASKEY COMPUTER CORP",
        "A4:4B:15": "Sun Cupid Technology (HK) LTD",
        "48:C8:62": "Simo Wireless,Inc.",
        "78:BE:B6": "Enhanced Vision",
        "44:9C:B5": "Alcomp, Inc",
        "B4:FC:75": "SEMA Electronics(HK) CO.,LTD",
        "B0:BF:99": "WIZITDONGDO",
        "B8:2A:DC": "EFR Europäische Funk-Rundsteuerung GmbH",
        "40:F1:4C": "ISE Europe SPRL",
        "E8:94:4C": "Cogent Healthcare Systems Ltd",
        "90:67:F3": "Alcatel Lucent",
        "D4:F0:B4": "Napco Security Technologies",
        "68:F8:95": "Redflow Limited",
        "70:B9:21": "Fiberhome Telecommunication Technologies Co.,LTD",
        "A0:E2:95": "DAT System Co.,Ltd",
        "A0:16:5C": "Triteka LTD",
        "9C:41:7C": "Hame  Technology Co.,  Limited ",
        "9C:6A:BE": "QEES ApS.",
        "9C:93:4E": "Xerox Corporation",
        "04:46:65": "Murata Manufacturing Co., Ltd.",
        "2C:21:72": "Juniper Networks",
        "90:09:17": "Far-sighted mobile",
        "2C:8B:F2": "Hitachi Metals America Ltd",
        "D8:97:3B": "Artesyn Embedded Technologies",
        "38:26:CD": "ANDTEK",
        "88:BF:D5": "Simple Audio Ltd",
        "24:CB:E7": "MYK, Inc.",
        "B0:A1:0A": "Pivotal Systems Corporation",
        "80:2D:E1": "Solarbridge Technologies",
        "F4:A5:2A": "Hawa Technologies Inc",
        "0C:6E:4F": "PrimeVOLT Co., Ltd.",
        "E8:B7:48": "Cisco Systems, Inc",
        "BC:99:BC": "FonSee Technology Inc.",
        "78:3F:15": "EasySYNC Ltd.",
        "18:D0:71": "DASAN CO., LTD.",
        "58:E4:76": "CENTRON COMMUNICATIONS TECHNOLOGIES FUJIAN CO.,LTD",
        "44:7E:95": "Alpha and Omega, Inc",
        "98:60:22": "EMW Co., Ltd.",
        "B8:D4:9D": "M Seven System Ltd.",
        "3C:67:2C": "Sciovid Inc.",
        "DC:9B:1E": "Intercom, Inc.",
        "BC:5F:F4": "ASRock Incorporation",
        "E8:B4:AE": "Shenzhen C&D Electronics Co.,Ltd",
        "50:FA:AB": "L-tek d.o.o.",
        "38:91:FB": "Xenox Holding BV",
        "A8:E0:18": "Nokia Corporation",
        "78:1D:FD": "Jabil Inc",
        "18:AE:BB": "Siemens Convergence Creators GmbH&Co.KG",
        "B0:BD:A1": "ZAKLAD ELEKTRONICZNY SIMS",
        "70:B2:65": "Hiltron s.r.l.",
        "CC:C6:2B": "Tri-Systems Corporation",
        "D8:C0:68": "Netgenetech.co.,ltd.",
        "60:11:99": "Siama Systems Inc",
        "6C:81:FE": "Mitsuba Corporation",
        "C0:27:B9": "Beijing National Railway Research & Design Institute  of Signal & Communication Co., Ltd.",
        "14:74:11": "RIM",
        "F8:A9:DE": "PUISSANCE PLUS",
        "A8:8C:EE": "MicroMade Galka i Drozdz sp.j.",
        "DC:2B:66": "InfoBLOCK S.A. de C.V.",
        "B8:87:1E": "Good Mind Industries Co., Ltd.",
        "D4:F0:27": "Trust Power Ltd.",
        "04:55:CA": "BriView (Xiamen) Corp.",
        "14:35:B3": "Future Designs, Inc.",
        "AC:93:2F": "Nokia Corporation",
        "00:54:AF": "Continental Automotive Systems Inc.",
        "AC:CA:BA": "Midokura Co., Ltd. ",
        "0C:81:12": "Private",
        "9C:95:F8": "SmartDoor Systems, LLC",
        "78:19:F7": "Juniper Networks",
        "64:09:4C": "Beijing Superbee Wireless Technology Co.,Ltd",
        "7C:7D:41": "Jinmuyu Electronics Co., Ltd.",
        "4C:14:80": "NOREGON SYSTEMS, INC",
        "A4:85:6B": "Q Electronics Ltd",
        "20:D5:AB": "Korea Infocom Co.,Ltd.",
        "0C:F3:EE": "EM Microelectronic",
        "64:D1:A3": "Sitecom Europe BV",
        "F4:3E:9D": "Benu Networks, Inc.",
        "04:E2:F8": "AEP Ticketing solutions srl",
        "EC:9E:CD": "Artesyn Embedded Technologies",
        "8C:51:05": "Shenzhen ireadygo Information Technology CO.,LTD.",
        "C8:20:8E": "Storagedata",
        "5C:5E:AB": "Juniper Networks",
        "9C:80:7D": "SYSCABLE Korea Inc.",
        "34:B5:71": "PLDS",
        "3C:74:37": "RIM",
        "EC:92:33": "Eddyfi NDT Inc",
        "74:38:89": "ANNAX Anzeigesysteme GmbH",
        "44:D2:CA": "Anvia TV Oy",
        "38:6E:21": "Wasion Group Ltd.",
        "28:72:F0": "ATHENA",
        "1C:19:DE": "eyevis GmbH",
        "60:9E:64": "Vivonic GmbH",
        "BC:15:A6": "Taiwan Jantek Electronics,Ltd.",
        "DC:DE:CA": "Akyllor",
        "A0:AA:FD": "EraThink Technologies Corp.",
        "6C:A9:06": "Telefield Ltd",
        "78:22:3D": "Affirmed Networks",
        "3C:02:B1": "Creation Technologies LP",
        "E4:41:E6": "Ottec Technology GmbH",
        "BC:71:C1": "XTrillion, Inc.",
        "E0:E8:E8": "Olive Telecommunication Pvt. Ltd",
        "60:52:D0": "FACTS Engineering ",
        "B0:89:91": "LGE ",
        "30:14:2D": "Piciorgros GmbH",
        "50:AF:73": "Shenzhen Bitland Information Technology Co., Ltd.",
        "5C:9A:D8": "FUJITSU LIMITED",
        "A4:C0:E1": "Nintendo Co., Ltd.",
        "4C:3B:74": "VOGTEC(H.K.) Co., Ltd",
        "68:43:52": "Bhuu Limited",
        "EC:E9:0B": "SISTEMA SOLUCOES ELETRONICAS LTDA - EASYTECH",
        "A0:8C:9B": "Xtreme Technologies Corp",
        "A8:39:44": "Actiontec Electronics, Inc",
        "74:E0:6E": "Ergophone GmbH",
        "0C:F0:B4": "Globalsat International Technology Ltd",
        "48:DF:1C": "Wuhan NEC Fibre Optic Communications industry Co. Ltd",
        "D4:9C:8E": "University of FUKUI",
        "F8:F0:14": "RackWare Inc.",
        "28:26:A6": "PBR electronics GmbH",
        "B4:28:F1": "E-Prime Co., Ltd.",
        "C0:12:42": "Alpha Security Products",
        "BC:20:BA": "Inspur (Shandong) Electronic Information Co., Ltd",
        "1C:FE:A7": "IDentytech Solutins Ltd.",
        "30:4E:C3": "Tianjin Techua Technology Co., Ltd.",
        "B4:CF:DB": "Shenzhen Jiuzhou Electric Co.,LTD",
        "FC:D4:F2": "The Coca Cola Company",
        "5C:6A:7D": "KENTKART EGE ELEKTRONIK SAN. VE TIC. LTD. STI. ",
        "44:59:9F": "Criticare Systems, Inc",
        "3C:2F:3A": "SFORZATO Corp.",
        "74:CE:56": "Packet Force Technology Limited Company",
        "AC:2F:A8": "Humannix Co.,Ltd.",
        "10:64:E2": "ADFweb.com s.r.l.",
        "CC:34:D7": "GEWISS S.P.A.",
        "F0:2A:61": "Waldo Networks, Inc.",
        "C8:A7:0A": "Verizon Business",
        "60:DA:23": "Estech Co.,Ltd",
        "44:DC:CB": "SEMINDIA SYSTEMS PVT LTD",
        "A0:DE:05": "JSC Irbis-T",
        "08:17:F4": "IBM Corp",
        "CC:D8:11": "Aiconn Technology Corporation",
        "F4:38:14": "Shanghai Howell Electronic Co.,Ltd",
        "90:61:0C": "Fida International (S) Pte Ltd",
        "3C:5F:01": "Synerchip Co., Ltd.",
        "EC:BB:AE": "Digivoice Tecnologia em Eletronica Ltda",
        "34:A1:83": "AWare, Inc",
        "98:73:C4": "Sage Electronic Engineering LLC",
        "B4:01:42": "GCI Science & Technology Co.,LTD",
        "74:0A:BC": "LightwaveRF Technology Ltd",
        "10:A1:3B": "FUJIKURA RUBBER LTD.",
        "F4:E1:42": "Delta Elektronika BV",
        "AC:81:12": "Gemtek Technology Co., Ltd.",
        "68:63:59": "Advanced Digital Broadcast SA",
        "28:06:1E": "NINGBO GLOBAL USEFUL ELECTRIC CO.,LTD",
        "64:E8:E6": "global moisture management system",
        "E0:D1:0A": "Katoudenkikougyousyo co ltd",
        "C4:4B:44": "Omniprint Inc.",
        "18:92:2C": "Virtual Instruments",
        "A4:9B:13": "Digital Check",
        "C8:EE:08": "TANGTOP TECHNOLOGY CO.,LTD",
        "74:72:F2": "Chipsip Technology Co., Ltd.",
        "48:C8:B6": "SysTec GmbH",
        "3C:62:78": "SHENZHEN JETNET TECHNOLOGY CO.,LTD.",
        "C8:D5:FE": "Shenzhen Zowee Technology Co., Ltd",
        "2C:30:68": "Pantech Co.,Ltd",
        "00:BD:27": "Exar Corp.",
        "5C:40:58": "Jefferson Audio Video Systems, Inc.",
        "58:D0:8F": "IEEE 1904.1 Working Group",
        "6C:9C:E9": "Nimble Storage",
        "CC:09:C8": "IMAQLIQ LTD",
        "9C:45:63": "DIMEP Sistemas",
        "D4:3D:67": "Carma Industries Inc.",
        "E0:A6:70": "Nokia Corporation",
        "58:DB:8D": "Fast Co., Ltd.",
        "E4:46:BD": "C&C TECHNIC TAIWAN CO., LTD.",
        "8C:DD:8D": "Wifly-City System Inc.",
        "20:A2:E7": "Lee-Dickens Ltd",
        "FC:ED:B9": "Arrayent",
        "44:ED:57": "Longicorn, inc.",
        "EC:98:C1": "Beijing Risbo Network Technology Co.,Ltd",
        "38:A9:5F": "Actifio Inc",
        "F4:DC:DA": "Zhuhai Jiahe Communication Technology Co., limited",
        "E8:04:62": "Cisco Systems, Inc",
        "DC:D0:F7": "Bentek Systems Ltd.",
        "D4:A9:28": "GreenWave Reality Inc",
        "E0:62:90": "Jinan Jovision Science & Technology Co., Ltd.",
        "10:0E:2B": "NEC CASIO Mobile Communications",
        "70:E1:39": "3view Ltd",
        "18:42:2F": "Alcatel Lucent",
        "C4:63:54": "U-Raku, Inc.",
        "40:5F:BE": "RIM",
        "68:54:F5": "enLighted Inc",
        "7C:B5:42": "ACES Technology",
        "90:54:46": "TES ELECTRONIC SOLUTIONS",
        "54:4A:05": "wenglor sensoric gmbh",
        "98:E1:65": "Accutome",
        "78:57:12": "Mobile Integration Workgroup",
        "38:0A:0A": "Sky-City Communication and Electronics Limited Company",
        "0C:D6:96": "Amimon Ltd",
        "F4:DC:4D": "Beijing CCD Digital Technology Co., Ltd",
        "40:13:D9": "Global ES",
        "AC:4F:FC": "SVS-VISTEK GmbH",
        "B4:37:41": "Consert, Inc.",
        "94:85:7A": "Evantage Industries Corp",
        "40:83:DE": "Zebra Technologies Inc",
        "88:97:DF": "Entrypass Corporation Sdn. Bhd.",
        "24:AF:54": "NEXGEN Mediatech Inc.",
        "F0:F8:42": "KEEBOX, Inc.",
        "DC:4E:DE": "SHINYEI TECHNOLOGY CO., LTD.",
        "E0:87:B1": "Nata-Info Ltd.",
        "44:7C:7F": "Innolight Technology Corporation",
        "D4:96:DF": "SUNGJIN C&T CO.,LTD",
        "5C:86:4A": "Secret Labs LLC",
        "F0:AD:4E": "Globalscale Technologies, Inc.",
        "90:3D:5A": "Shenzhen Wision Technology Holding Limited",
        "7C:A2:9B": "D.SignT GmbH & Co. KG",
        "A0:40:41": "SAMWONFA Co.,Ltd.",
        "6C:22:AB": "Ainsworth Game Technology",
        "30:18:CF": "DEOS control systems GmbH",
        "08:FA:E0": "Fohhn Audio AG",
        "58:B9:E1": "Crystalfontz America, Inc.",
        "20:D9:06": "Iota, Inc.",
        "F4:55:95": "HENGBAO Corporation LTD.",
        "1C:3A:4F": "AccuSpec Electronics, LLC",
        "9C:4E:20": "Cisco Systems, Inc",
        "D8:75:33": "Nokia Corporation",
        "98:35:B8": "Assembled Products Corporation",
        "28:89:15": "CashGuard Sverige AB",
        "4C:5D:CD": "Oy Finnish Electric Vehicle Technologies Ltd",
        "70:D5:7E": "Scalar Corporation",
        "B0:E3:9D": "CAT SYSTEM CO.,LTD.",
        "7C:2E:0D": "Blackmagic Design",
        "18:0C:77": "Westinghouse Electric Company, LLC",
        "68:CA:00": "Octopus Systems Limited",
        "E0:58:9E": "Laerdal Medical",
        "0C:1D:C2": "SeAH Networks",
        "54:75:D0": "Cisco Systems, Inc",
        "60:89:B7": "KAEL MÜHENDİSLİK ELEKTRONİK TİCARET SANAYİ LİMİTED ŞİRKETİ",
        "30:52:5A": "NST Co., LTD",
        "2C:A7:80": "True Technologies Inc.",
        "7C:6F:06": "Caterpillar Trimble Control Technologies",
        "60:12:83": "TSB REAL TIME LOCATION SYSTEMS S.L.",
        "98:DC:D9": "UNITEC Co., Ltd.",
        "C0:CF:A3": "Creative Electronics & Software, Inc.",
        "94:23:6E": "Shenzhen Junlan Electronic Ltd",
        "10:E6:AE": "Source Technologies, LLC",
        "FC:E1:92": "Sichuan Jinwangtong Electronic Science&Technology Co,.Ltd",
        "40:8A:9A": "TITENG CO., Ltd.",
        "F4:45:ED": "Portable Innovation Technology Ltd.",
        "5C:E2:86": "Nortel Networks",
        "8C:64:0B": "Beyond Devices d.o.o.",
        "94:9C:55": "Alta Data Technologies",
        "D4:79:C3": "Cameronet GmbH & Co. KG",
        "70:D5:E7": "Wellcore Corporation",
        "3C:F7:2A": "Nokia Corporation",
        "54:5F:A9": "Teracom Limited",
        "6C:32:DE": "Indieon Technologies Pvt. Ltd.",
        "14:A6:2C": "S.M. Dezac S.A.",
        "54:7F:EE": "Cisco Systems, Inc",
        "AC:EA:6A": "GENIX INFOCOMM CO., LTD.",
        "E0:BC:43": "C2 Microsystems, Inc.",
        "2C:A8:35": "RIM",
        "C4:1E:CE": "HMI Sources Ltd.",
        "A8:F4:70": "Fujian Newland Communication Science Technologies Co.,Ltd.",
        "8C:73:6E": "FUJITSU LIMITED",
        "B8:64:91": "CK Telecom Ltd",
        "50:F0:03": "Open Stack, Inc.",
        "DC:49:C9": "CASCO SIGNAL LTD",
        "70:D8:80": "Upos System sp. z o.o.",
        "A0:5D:C1": "TMCT Co., LTD.",
        "58:3C:C6": "Omneality Ltd.",
        "B0:C8:AD": "People Power Company",
        "18:17:14": "DAEWOOIS",
        "F0:EC:39": "Essec",
        "44:6C:24": "Reallin Electronic Co.,Ltd",
        "20:46:F9": "Advanced Network Devices (dba:AND)",
        "48:71:19": "SGB GROUP LTD.",
        "04:FE:7F": "Cisco Systems, Inc",
        "A4:B1:EE": "H. ZANDER GmbH & Co. KG",
        "84:21:41": "Shenzhen Ginwave Technologies Ltd.",
        "A0:23:1B": "TeleComp R&D Corp.",
        "B8:A3:E0": "BenRui Technology Co.,Ltd",
        "3C:F5:2C": "DSPECIALISTS GmbH",
        "EC:44:76": "Cisco Systems, Inc",
        "6C:18:11": "Decatur Electronics",
        "F8:E9:68": "Egker Kft.",
        "A8:99:5C": "aizo ag",
        "40:12:E4": "Compass-EOS",
        "54:03:F5": "EBN Technology Corp.",
        "04:C0:5B": "Tigo Energy",
        "80:38:FD": "LeapFrog Enterprises, Inc.",
        "AC:BE:B6": "Visualedge Technology Co., Ltd.",
        "2C:91:27": "Eintechno Corporation",
        "AC:58:3B": "Human Assembler, Inc.",
        "E8:E7:76": "Shenzhen Kootion Technology Co., Ltd",
        "68:1F:D8": "Siemens Industry, Inc.",
        "40:01:C6": "3COM EUROPE LTD",
        "9C:5E:73": "Calibre UK LTD",
        "5C:14:37": "Thyssenkrupp Aufzugswerke GmbH",
        "9C:55:B4": "I.S.E. S.r.l.",
        "70:2F:97": "Aava Mobile Oy",
        "10:CA:81": "PRECIA",
        "40:A6:A4": "PassivSystems Ltd",
        "94:BA:31": "Visiontec da Amazônia Ltda.",
        "B8:94:D2": "Retail Innovation HTT AB",
        "B0:E9:7E": "Advanced Micro Peripherals",
        "F0:C2:4C": "Zhejiang FeiYue Digital Technology Co., Ltd",
        "E4:75:1E": "Getinge Sterilization AB",
        "9C:5B:96": "NMR Corporation",
        "60:F1:3D": "JABLOCOM s.r.o.",
        "50:25:2B": "Nethra Imaging Incorporated",
        "F8:81:1A": "OVERKIZ",
        "38:63:F6": "3NOD MULTIMEDIA(SHENZHEN)CO.,LTD",
        "78:B8:1A": "INTER SALES A/S",
        "CC:00:80": "BETTINI SRL",
        "64:4B:C3": "Shanghai WOASiS Telecommunications Ltd., Co.",
        "94:2E:63": "Finsécur",
        "AC:83:17": "Shenzhen Furtunetel Communication Co., Ltd",
        "AC:D1:80": "Crexendo Business Solutions, Inc.",
        "CC:CC:4E": "Sun Fountainhead USA. Corp ",
        "68:85:40": "IGI Mobile, Inc.",
        "A0:9A:5A": "Time Domain",
        "64:A8:37": "Juni Korea Co., Ltd",
        "20:2C:B7": "Kong Yue Electronics & Information Industry (Xinhui) Ltd.",
        "60:9F:9D": "CloudSwitch",
        "48:34:3D": "IEP GmbH",
        "D4:AA:FF": "MICRO WORLD ",
        "74:E5:37": "RADSPIN",
        "00:26:E9": "SP Corp",
        "00:26:EB": "Advanced Spectrum Technology Co., Ltd.",
        "00:26:E1": "Stanford University, OpenFlow Group",
        "00:27:17": "CE Digital(Zhenjiang)Co.,Ltd",
        "00:27:16": "Adachi-Syokai Co., Ltd.",
        "00:26:DC": "Optical Systems Design",
        "00:27:00": "Shenzhen Siglent Technology Co., Ltd.",
        "00:26:EC": "Legrand Home Systems, Inc",
        "00:26:D4": "IRCA SpA",
        "00:26:63": "Shenzhen Huitaiwei Tech. Ltd, co.",
        "00:26:61": "Irumtek Co., Ltd.",
        "00:26:5B": "Hitron Technologies. Inc",
        "00:26:56": "Sansonic Electronics USA",
        "00:26:7D": "A-Max Technology Macao Commercial Offshore Company Limited",
        "00:26:7C": "Metz-Werke GmbH & Co KG",
        "00:26:73": "RICOH COMPANY,LTD.",
        "00:26:6D": "MobileAccess Networks",
        "00:26:C0": "EnergyHub",
        "00:26:C1": "ARTRAY CO., LTD.",
        "00:26:BE": "Schoonderbeek Elektronica Systemen B.V.",
        "00:26:B5": "ICOMM Tele Ltd",
        "00:26:8C": "StarLeaf Ltd.",
        "00:26:8B": "Guangzhou Escene Computer Technology Limited",
        "00:26:6F": "Coordiwise Technology Corp.",
        "00:26:6E": "Nissho-denki Co.,LTD.",
        "00:26:C3": "Insightek Corp.",
        "00:26:81": "Interspiro AB",
        "00:26:83": "Ajoho Enterprise Co., Ltd.",
        "00:26:98": "Cisco Systems, Inc",
        "00:26:9B": "SOKRAT Ltd.",
        "00:26:A1": "Megger",
        "00:26:44": "Thomson Telecom Belgium",
        "00:26:46": "SHENYANG TONGFANG MULTIMEDIA TECHNOLOGY COMPANY LIMITED",
        "00:26:3F": "LIOS Technology GmbH",
        "00:26:3B": "Onbnetech",
        "00:26:58": "T-Platforms (Cyprus) Limited",
        "00:26:4C": "Shanghai DigiVision Technology Co., Ltd.",
        "00:26:2F": "HAMAMATSU TOA ELECTRONICS",
        "00:26:31": "COMMTACT LTD",
        "00:25:FB": "Tunstall Healthcare A/S",
        "00:25:F4": "KoCo Connector AG",
        "00:26:06": "RAUMFELD GmbH",
        "00:26:07": "Enabling Technology Pty Ltd",
        "00:26:24": "Thomson Inc.",
        "00:26:05": "CC Systems AB",
        "00:26:02": "SMART Temps LLC",
        "00:26:1A": "Femtocomm System Technology Corp.",
        "00:26:34": "Infineta Systems, Inc",
        "00:25:99": "Hedon e.d. B.V.",
        "00:25:97": "Kalki Communication Technologies",
        "00:25:92": "Guangzhou Shirui Electronic Co., Ltd",
        "00:25:94": "Eurodesign BG LTD",
        "00:25:9F": "TechnoDigital Technologies GmbH",
        "00:25:9D": "Private",
        "00:25:98": "Zhong Shan City Litai Electronic Industrial Co. Ltd",
        "00:25:E3": "Hanshinit Inc.",
        "00:25:D4": "General Dynamics Mission Systems",
        "00:25:C2": "RingBell Co.,Ltd.",
        "00:25:A7": "itron",
        "00:25:A9": "Shanghai Embedway Information Technologies Co.,Ltd",
        "00:25:B4": "Cisco Systems, Inc",
        "00:25:B2": "MBDA Deutschland GmbH",
        "00:25:EF": "I-TEC Co., Ltd.",
        "00:25:28": "Daido Signal Co., Ltd.",
        "00:25:26": "Genuine Technologies Co., Ltd.",
        "00:25:6B": "ATENIX E.E. s.r.l.",
        "00:25:6E": "Van Breda B.V.",
        "00:25:65": "Vizimax Inc.",
        "00:25:5E": "Shanghai Dare Technologies Co.,Ltd.",
        "00:25:3B": "din Dietmar Nocker Facilitymanagement GmbH",
        "00:25:3D": "DRS Consolidated Controls",
        "00:25:35": "Minimax GmbH & Co KG",
        "00:25:84": "Cisco Systems, Inc",
        "00:25:79": "J & F Labs",
        "00:25:7F": "CallTechSolution Co.,Ltd",
        "00:25:77": "D-BOX Technologies",
        "00:25:72": "Nemo-Q International AB",
        "00:25:29": "COMELIT GROUP S.P.A",
        "00:25:2A": "Chengdu GeeYa Technology Co.,LTD",
        "00:25:8A": "Pole/Zero Corporation",
        "00:25:5F": "SenTec AG",
        "00:24:EC": "United Information Technology Co.,Ltd.",
        "00:24:E6": "In Motion Technology Inc.",
        "00:24:E7": "Plaster Networks",
        "00:24:DE": "GLOBAL Technology Inc.",
        "00:24:DC": "Juniper Networks",
        "00:24:DB": "Alcohol Monitoring Systems",
        "00:25:21": "Logitek Electronic Systems, Inc.",
        "00:25:1F": "ZYNUS VISION INC.",
        "00:25:1E": "ROTEL TECHNOLOGIES",
        "00:25:19": "Viaas Inc",
        "00:24:D5": "Winward Industrial Limited",
        "00:24:DD": "Centrak, Inc.",
        "00:24:EA": "iris-GmbH infrared & intelligent sensors",
        "00:24:ED": "YT Elec. Co,.Ltd.",
        "00:25:03": "IBM Corp",
        "00:25:04": "Valiant Communications Limited",
        "00:25:13": "CXP DIGITAL BV",
        "00:24:A4": "Siklu Communication",
        "00:24:9A": "Beijing Zhongchuang Telecommunication Test Co., Ltd.",
        "00:24:9E": "ADC-Elektronik GmbH",
        "00:24:9F": "RIM Testing Services",
        "00:24:C2": "Asumo Co.,Ltd.",
        "00:24:C0": "NTI COMODO INC",
        "00:24:BB": "CENTRAL Corporation",
        "00:24:BC": "HuRob Co.,Ltd",
        "00:24:AD": "Adolf Thies Gmbh & Co. KG",
        "00:24:A7": "Advanced Video Communications Inc.",
        "00:24:AB": "A7 Engineering, Inc.",
        "00:24:66": "Unitron nv",
        "00:24:5F": "Vine Telecom CO.,Ltd.",
        "00:24:55": "MuLogic BV",
        "00:24:88": "Centre For Development Of Telematics",
        "00:24:8F": "DO-MONIX",
        "00:24:79": "Optec Displays, Inc.",
        "00:24:B7": "GridPoint, Inc.",
        "00:24:AE": "IDEMIA",
        "00:24:68": "Sumavision Technologies Co.,Ltd",
        "00:24:3A": "Ludl Electronic Products",
        "00:24:39": "Digital Barriers Advanced Technologies",
        "00:24:34": "Lectrosonics, Inc.",
        "00:24:5A": "Nanjing Panda Electronics Company Limited",
        "00:24:5B": "RAIDON TECHNOLOGY, INC.",
        "00:24:59": "ABB Automation products GmbH",
        "00:24:4E": "RadChips, Inc.",
        "00:24:0D": "OnePath Networks LTD.",
        "00:24:0B": "Virtual Computer Inc.",
        "00:24:02": "Op-Tection GmbH",
        "00:24:2F": "Micron",
        "00:24:26": "NOHMI BOSAI LTD.",
        "00:24:18": "Nextwave Semiconductor",
        "00:24:12": "Benign Technologies Co, Ltd.",
        "00:24:29": "MK MASTER INC.",
        "00:23:DB": "saxnet gmbh",
        "00:23:C8": "TEAM-R",
        "00:23:EB": "Cisco Systems, Inc",
        "00:23:EC": "Algorithmix GmbH",
        "00:23:C1": "Securitas Direct AB",
        "00:23:AA": "HFR, Inc.",
        "00:23:A5": "SageTV, LLC",
        "00:23:9E": "Jiangsu Lemote Technology Corporation Limited",
        "00:23:FC": "Ultra Stereo Labs, Inc",
        "00:23:8D": "Techno Design Co., Ltd.",
        "00:23:87": "ThinkFlood, Inc.",
        "00:23:84": "GGH Engineering s.r.l.",
        "00:23:91": "Maxian",
        "00:23:92": "Proteus Industries Inc.",
        "00:23:93": "AJINEXTEK",
        "00:23:7F": "PLANTRONICS, INC.",
        "00:23:6F": "DAQ System",
        "00:23:30": "DIZIPIA, INC.",
        "00:23:69": "Cisco-Linksys, LLC",
        "00:22:F8": "PIMA Electronic Systems Ltd.",
        "00:23:1C": "Fourier Systems Ltd.",
        "00:23:1D": "Deltacom Electronics Ltd",
        "00:22:D7": "Nintendo Co., Ltd.",
        "00:22:D6": "Cypak AB",
        "00:22:D0": "Polar Electro Oy",
        "00:23:0A": "ARBURG GmbH & Co KG",
        "00:22:C3": "Zeeport Technology Inc.",
        "00:23:16": "KISAN ELECTRONICS CO",
        "00:23:0F": "Hirsch Electronics Corporation",
        "00:23:2D": "SandForce",
        "00:23:23": "Zylin AS",
        "00:22:DE": "OPPO Digital, Inc.",
        "00:22:F1": "Private",
        "00:22:A2": "Xtramus Technologies",
        "00:22:9E": "Social Aid Research Co., Ltd.",
        "00:22:85": "NOMUS COMM SYSTEMS",
        "00:22:81": "Daintree Networks Pty",
        "00:22:55": "Cisco Systems, Inc",
        "00:22:4E": "SEEnergy Corp.",
        "00:22:87": "Titan Wireless LLC",
        "00:22:88": "Sagrad, Inc.",
        "00:22:73": "Techway",
        "00:22:6B": "Cisco-Linksys, LLC",
        "00:22:67": "Nortel Networks",
        "00:22:95": "SGM Technology for lighting spa",
        "00:22:5A": "Garde Security AB",
        "00:22:42": "Alacron Inc.",
        "00:22:34": "Corventis Inc.",
        "00:21:F7": "HPN Supply Chain",
        "00:21:F4": "INRange Systems, Inc",
        "00:21:F5": "Western Engravers Supply, Inc.",
        "00:22:32": "Design Design Technology Ltd",
        "00:22:2B": "Nucomm, Inc.",
        "00:22:26": "Avaak, Inc.",
        "00:22:21": "ITOH DENKI CO,LTD.",
        "00:22:1D": "Freegene Technology LTD",
        "00:22:24": "Good Will Instrument Co., Ltd.",
        "00:22:45": "Leine & Linde AB",
        "00:22:49": "HOME MULTIENERGY SL",
        "00:22:40": "Universal Telecom S/A",
        "00:22:0F": "MoCA (Multimedia over Coax Alliance)",
        "00:22:0A": "OnLive, Inc",
        "00:22:03": "Glensound Electronics Ltd",
        "00:22:04": "KORATEK",
        "00:21:FF": "Cyfrowy Polsat SA",
        "00:21:E4": "I-WIN",
        "00:21:E5": "Display Solution AG",
        "00:22:1B": "Morega Systems",
        "00:21:B2": "Fiberblaze A/S",
        "00:21:AC": "Infrared Integrated Systems Ltd",
        "00:21:8E": "MEKICS CO., LTD.",
        "00:21:8F": "Avantgarde Acoustic Lautsprechersysteme GmbH",
        "00:21:7E": "Telit Communication s.p.a",
        "00:21:87": "Imacs GmbH",
        "00:21:81": "Si2 Microsystems Limited",
        "00:21:C2": "GL Communications Inc",
        "00:21:E2": "visago Systems & Controls GmbH & Co. KG",
        "00:21:DD": "Northstar Systems Corp",
        "00:21:D5": "X2E GmbH",
        "00:21:A2": "EKE-Electronics Ltd.",
        "00:21:C9": "Wavecom Asia Pacific Limited",
        "00:21:4A": "Pixel Velocity, Inc",
        "00:21:46": "Sanmina-SCI",
        "00:21:6E": "Function ATI (Huizhou) Telecommunications Co., Ltd.",
        "00:21:6D": "Soltech Co., Ltd.",
        "00:21:65": "Presstek Inc.",
        "00:21:1F": "SHINSUNG DELTATECH CO.,LTD.",
        "00:21:24": "Optos Plc",
        "00:21:33": "Building B, Inc",
        "00:21:34": "Brandywine Communications",
        "00:21:3A": "Winchester Systems Inc.",
        "00:21:2E": "dresden-elektronik",
        "00:21:30": "Keico Hightech Inc.",
        "00:21:5B": "SenseAnywhere",
        "00:21:4E": "GS Yuasa Power Supply Ltd.",
        "00:21:42": "Advanced Control Systems doo",
        "00:1F:FA": "Coretree, Co, Ltd",
        "00:1F:F2": "VIA Technologies, Inc.",
        "00:21:01": "Aplicaciones Electronicas Quasar (AEQ)",
        "00:21:03": "GHI Electronics, LLC",
        "00:1F:F8": "Siemens AG, Sector Industry, Drive Technologies, Motion Control Systems",
        "00:1F:D0": "GIGA-BYTE TECHNOLOGY CO.,LTD.",
        "00:1F:D1": "OPTEX CO.,LTD.",
        "00:1F:C9": "Cisco Systems, Inc",
        "00:1F:DC": "Mobile Safe Track Ltd",
        "00:1F:D6": "Shenzhen Allywll",
        "00:21:17": "Tellord",
        "00:21:0F": "Cernium Corp",
        "00:1F:F1": "Paradox Hellas S.A.",
        "00:1F:E6": "Alphion Corporation",
        "00:1F:CF": "MSI Technology GmbH",
        "00:1F:9C": "LEDCO",
        "00:1F:90": "Actiontec Electronics, Inc",
        "00:1F:91": "DBS Lodging Technologies, LLC",
        "00:1F:98": "DAIICHI-DENTSU LTD.",
        "00:1F:93": "Xiotech Corporation",
        "00:1F:51": "HD Communications Corp",
        "00:1F:53": "GEMAC Chemnitz GmbH",
        "00:1F:50": "Swissdis AG",
        "00:1F:4C": "Roseman Engineering Ltd",
        "00:1F:A9": "Atlanta DTH, Inc.",
        "00:1F:A3": "T&W Electronics(Shenzhen)Co.,Ltd.",
        "00:1F:A2": "Datron World Communications, Inc.",
        "00:1F:70": "Botik Technologies LTD",
        "00:1F:64": "Beijing Autelan Technology Inc.",
        "00:1F:6D": "Cisco Systems, Inc",
        "00:1F:24": "DIGITVIEW TECHNOLOGY CO., LTD.",
        "00:1F:21": "Inner Mongolia Yin An Science & Technology Development Co.,L",
        "00:1F:22": "Source Photonics, Inc.",
        "00:1F:1D": "Atlas Material Testing Technology LLC",
        "00:1F:15": "Bioscrypt Inc",
        "00:1F:2B": "Orange Logic",
        "00:1F:2A": "ACCM",
        "00:1F:30": "Travelping",
        "00:1F:48": "Mojix Inc.",
        "00:1F:3E": "RP-Technik e.K.",
        "00:1E:F0": "Gigafin Networks",
        "00:1E:F2": "Micro Motion Inc",
        "00:1F:37": "Genesis I&C",
        "00:1F:2C": "Starbridge Networks",
        "00:1F:31": "Radiocomp",
        "00:1F:12": "Juniper Networks",
        "00:1E:EA": "Sensor Switch, Inc.",
        "00:1F:04": "Granch Ltd.",
        "00:1E:94": "SUPERCOM TECHNOLOGY CORPORATION",
        "00:1E:8F": "CANON INC.",
        "00:1E:A5": "ROBOTOUS, Inc.",
        "00:1E:A7": "Actiontec Electronics, Inc",
        "00:1E:A0": "XLN-t",
        "00:1E:98": "GreenLine Communications",
        "00:1E:9A": "HAMILTON Bonaduz AG",
        "00:1E:DF": "Master Industrialization Center Kista",
        "00:1E:E3": "T&W Electronics (ShenZhen) Co.,Ltd",
        "00:1E:D9": "Mitsubishi Precision Co.,LTd.",
        "00:1E:D3": "Dot Technology Int'l Co., Ltd.",
        "00:1E:A6": "Best IT World (India) Pvt. Ltd.",
        "00:1E:83": "LAN/MAN Standards Association (LMSC)",
        "00:1E:7C": "Taiwick Limited",
        "00:1E:CF": "PHILIPS ELECTRONICS UK LTD",
        "00:1E:22": "ARVOO Imaging Products BV",
        "00:1E:1A": "Best Source Taiwan Inc.",
        "00:1E:19": "GTRI",
        "00:1E:14": "Cisco Systems, Inc",
        "00:1E:44": "SANTEC",
        "00:1E:62": "Siemon",
        "00:1E:5C": "RB GeneralEkonomik",
        "00:1E:5D": "Holosys d.o.o.",
        "00:1E:78": "Owitek Technology Ltd.,",
        "00:1E:7A": "Cisco Systems, Inc",
        "00:1E:27": "SBN TECH Co.,Ltd.",
        "00:1E:60": "Digital Lighting Systems, Inc",
        "00:1E:6C": "Opaque Systems",
        "00:1E:2F": "DiMoto Pty Ltd",
        "00:1E:36": "IPTE",
        "00:1D:A7": "Seamless Internet",
        "00:1D:A5": "WB Electronics",
        "00:1D:A8": "Takahata Electronics Co.,Ltd",
        "00:1D:A9": "Castles Technology, Co., LTD",
        "00:1D:CB": "Exéns Development Oy",
        "00:1D:CA": "PAV Electronics Limited",
        "00:1D:C2": "XORTEC OY",
        "00:1E:0E": "MAXI VIEW HOLDINGS LIMITED",
        "00:1E:0F": "Briot International",
        "00:1D:E3": "Intuicom",
        "00:1D:DE": "Zhejiang Broadcast&Television Technology Co.,Ltd.",
        "00:1D:E5": "Cisco Systems, Inc",
        "00:1D:EC": "Marusys",
        "00:1D:E8": "Nikko Denki Tsushin Corporation(NDTC)",
        "00:1D:DA": "Mikroelektronika spol. s r. o.",
        "00:1D:B0": "FuJian HengTong Information Technology Co.,Ltd",
        "00:1D:B8": "Intoto Inc.",
        "00:1D:F5": "Sunshine Co,LTD",
        "00:1D:F0": "Vidient Systems, Inc.",
        "00:1D:FE": "Palm, Inc",
        "00:1D:52": "Defzone B.V.",
        "00:1D:4A": "Carestream Health, Inc.",
        "00:1D:96": "WatchGuard Video",
        "00:1D:8F": "PureWave Networks",
        "00:1D:8C": "La Crosse Technology LTD",
        "00:1D:64": "Adam Communications Systems Int Ltd",
        "00:1D:5E": "COMING MEDIA CORP.",
        "00:1D:55": "ZANTAZ, Inc",
        "00:1D:A1": "Cisco Systems, Inc",
        "00:1D:71": "Cisco Systems, Inc",
        "00:1D:65": "Microwave Radio Communications",
        "00:1D:50": "SPINETIX SA",
        "00:1D:45": "Cisco Systems, Inc",
        "00:1D:69": "Knorr-Bremse IT-Services GmbH",
        "00:1C:F8": "Parade Technologies, Ltd.",
        "00:1C:F7": "AudioScience",
        "00:1C:F6": "Cisco Systems, Inc",
        "00:1C:F5": "Wiseblue Technology Limited",
        "00:1C:EE": "SHARP Corporation",
        "00:1D:07": "Shenzhen Sang Fei Consumer Communications Co.,Ltd",
        "00:1D:06": "HM Electronics, Inc.",
        "00:1D:01": "Neptune Digital",
        "00:1D:33": "Maverick Systems Inc.",
        "00:1D:2C": "Wavetrend Technologies (Pty) Limited",
        "00:1C:CF": "LIMETEK",
        "00:1D:24": "Aclara Power-Line Systems Inc.",
        "00:1D:18": "Power Innovation GmbH",
        "00:1D:1B": "Sangean Electronics Inc.",
        "00:1D:17": "Digital Sky Corporation",
        "00:1D:27": "NAC-INTERCOM",
        "00:1C:E3": "Optimedical Systems",
        "00:1C:DE": "Interactive Multimedia eXchange Inc.",
        "00:1D:36": "ELECTRONICS CORPORATION OF INDIA LIMITED",
        "00:1C:80": "New Business Division/Rhea-Information CO., LTD.",
        "00:1C:83": "New Level Telecom Co., Ltd.",
        "00:1C:76": "The Wandsworth Group Ltd",
        "00:1C:72": "Mayer & Cie GmbH & Co KG",
        "00:1C:AD": "Wuhan Telecommunication Devices Co.,Ltd",
        "00:1C:A7": "International Quartz Limited",
        "00:1C:AB": "Meyer Sound Laboratories, Inc.",
        "00:1C:9E": "Dualtech IT AB",
        "00:1C:C8": "INDUSTRONIC Industrie-Electronic GmbH & Co. KG",
        "00:1C:C6": "ProStor Systems",
        "00:1C:BE": "Nintendo Co., Ltd.",
        "00:1C:94": "LI-COR Biosciences",
        "00:1C:8C": "DIAL TECHNOLOGY LTD.",
        "00:1C:CA": "Shanghai Gaozhi Science & Technology Development Co.",
        "00:1C:C9": "Kaise Electronic Technology Co., Ltd.",
        "00:1C:93": "ExaDigm Inc",
        "00:1C:85": "Eunicorn",
        "00:1C:67": "Pumpkin Networks, Inc.",
        "00:1C:60": "CSP Frontier Technologies,Inc.",
        "00:1C:6A": "Weiss Engineering Ltd.",
        "00:1C:0A": "Shenzhen AEE Technology Co.,Ltd.",
        "00:1C:0D": "G-Technology, Inc.",
        "00:1C:03": "Betty TV Technology AG",
        "00:1C:46": "QTUM",
        "00:1C:42": "Parallels, Inc.",
        "00:1C:3E": "ECKey Corporation",
        "00:1C:51": "Celeno Communications",
        "00:1C:54": "Hillstone Networks Inc",
        "00:1C:59": "DEVON IT",
        "00:1C:22": "Aeris Elettronica s.r.l.",
        "00:1C:1D": "CHENZHOU GOSPELL DIGITAL TECHNOLOGY CO.,LTD",
        "00:1C:39": "S Netsystems Inc.",
        "00:1C:37": "Callpod, Inc.",
        "00:1C:33": "Sutron",
        "00:1B:F6": "CONWISE Technology Corporation Ltd.",
        "00:1B:F8": "Digitrax Inc.",
        "00:1C:2F": "Pfister GmbH",
        "00:1C:27": "Sunell Electronics Co.",
        "00:1C:0F": "Cisco Systems, Inc",
        "00:1C:48": "WiDeFi, Inc.",
        "00:1B:AD": "iControl Incorporated",
        "00:1B:A7": "Lorica Solutions",
        "00:1B:A5": "MyungMin Systems, Inc.",
        "00:1B:F1": "Nanjing SilverNet Software Co., Ltd.",
        "00:1B:EF": "Blossoms Digital Technology Co.,Ltd.",
        "00:1B:EB": "DMP Electronics INC.",
        "00:1B:A2": "IDS Imaging Development Systems GmbH",
        "00:1B:9D": "Novus Security Sp. z o.o.",
        "00:1B:C9": "FSN DISPLAY INC",
        "00:1B:C3": "Mobisolution Co.,Ltd",
        "00:1B:CE": "Measurement Devices Ltd",
        "00:1B:B8": "BLUEWAY ELECTRONIC CO;LTD",
        "00:1B:B2": "Intellect International NV",
        "00:1B:E7": "Postek Electronics Co., Ltd.",
        "00:1B:E3": "Health Hero Network, Inc.",
        "00:1B:DC": "Vencer Co., Ltd.",
        "00:1B:D5": "Cisco Systems, Inc",
        "00:1B:95": "VIDEO SYSTEMS SRL",
        "00:1B:90": "Cisco Systems, Inc",
        "00:1B:7F": "TMN Technologies Telecomunicacoes Ltda",
        "00:1B:7E": "Beckmann GmbH",
        "00:1B:7A": "Nintendo Co., Ltd.",
        "00:1B:34": "Focus System Inc.",
        "00:1B:3A": "SIMS Corp.",
        "00:1B:5F": "Alien Technology",
        "00:1B:61": "Digital Acoustics, LLC",
        "00:1B:5E": "BPL Limited",
        "00:1B:5C": "Azuretec Co., Ltd.",
        "00:1B:72": "Sicep s.p.a.",
        "00:1B:74": "MiraLink Corporation",
        "00:1B:6D": "Midtronics, Inc.",
        "00:1B:6F": "Teletrak Ltd",
        "00:1B:4B": "SANION Co., Ltd.",
        "00:1B:2D": "Med-Eng Systems Inc.",
        "00:1B:87": "Deepsound Tech. Co., Ltd",
        "00:1B:4D": "Areca Technology Corporation",
        "00:1A:E3": "Cisco Systems, Inc",
        "00:1A:DF": "Interactivetv Pty Limited",
        "00:1A:E1": "EDGE ACCESS INC",
        "00:1A:E8": "Unify Software and Solutions GmbH & Co. KG",
        "00:1A:E9": "Nintendo Co., Ltd.",
        "00:1A:E5": "Mvox Technologies Inc.",
        "00:1A:E4": "Medicis Technologies Corporation",
        "00:1A:F8": "Copley Controls Corporation",
        "00:1A:F5": "PENTAONE. CO., LTD.",
        "00:1A:ED": "INCOTEC GmbH",
        "00:1A:EE": "Shenztech Ltd",
        "00:1A:CE": "YUPITERU CORPORATION",
        "00:1A:CC": "Celestial Semiconductor, Ltd",
        "00:1A:D2": "Eletronica Nitron Ltda",
        "00:1B:1D": "Phoenix International Co., Ltd",
        "00:1B:1A": "e-trees Japan, Inc.",
        "00:1B:12": "Apprion",
        "00:1A:FE": "SOFACREAL",
        "00:1A:F1": "Embedded Artists AB",
        "00:1B:0D": "Cisco Systems, Inc",
        "00:1B:0A": "Intelligent Distributed Controls Ltd",
        "00:1A:B1": "Asia Pacific Satellite Industries Co., Ltd.",
        "00:1A:B7": "Ethos Networks LTD.",
        "00:1A:B2": "Cyber Solutions Inc.",
        "00:1A:97": "fitivision technology Inc.",
        "00:1A:90": "Trópico Sistemas e Telecomunicações da Amazônia LTDA. ",
        "00:1A:94": "Votronic GmbH",
        "00:1A:C7": "UNIPOINT",
        "00:1A:C0": "JOYBIEN TECHNOLOGIES CO., LTD.",
        "00:1A:9E": "ICON Digital International Limited",
        "00:1A:98": "Asotel Communication Limited Taiwan Branch",
        "00:1A:72": "Mosart Semiconductor Corp.",
        "00:1A:68": "Weltec Enterprise Co., Ltd.",
        "00:1A:C2": "YEC Co.,Ltd.",
        "00:1A:A5": "BRN Phoenix",
        "00:1A:A2": "Cisco Systems, Inc",
        "00:1A:9C": "RightHand Technologies, Inc.",
        "00:1A:7E": "LN Srithai Comm Ltd.",
        "00:1A:5A": "Korea Electric Power Data Network  (KDN) Co., Ltd",
        "00:1A:5F": "KitWorks.fi Ltd.",
        "00:1A:37": "Lear Corporation",
        "00:1A:38": "Sanmina-SCI",
        "00:1A:2B": "Ayecom Technology Co., Ltd.",
        "00:1A:28": "ASWT Co., LTD. Taiwan Branch H.K.",
        "00:1A:2C": "SATEC Co.,LTD",
        "00:1A:27": "Ubistar",
        "00:1A:21": "Brookhuis Applied Technologies BV",
        "00:19:FF": "Finnzymes",
        "00:19:FA": "Cable Vision Electronics CO., LTD.",
        "00:1A:5D": "Mobinnova Corp.",
        "00:1A:4D": "GIGA-BYTE TECHNOLOGY CO.,LTD.",
        "00:1A:48": "Takacom Corporation",
        "00:1A:0B": "BONA TECHNOLOGY INC.",
        "00:1A:06": "OpVista, Inc.",
        "00:1A:2E": "Ziova Coporation",
        "00:1A:32": "ACTIVA MULTIMEDIA",
        "00:1A:00": "MATRIX INC.",
        "00:19:AD": "BOBST SA",
        "00:19:A2": "ORDYN TECHNOLOGIES",
        "00:19:A5": "RadarFind Corporation",
        "00:19:93": "Changshu Switchgear MFG. Co.,Ltd. (Former Changshu Switchgea",
        "00:19:F1": "Star Communication Network Technology Co.,Ltd",
        "00:19:EC": "Sagamore Systems, Inc.",
        "00:19:CC": "RCG (HK) Ltd",
        "00:19:C8": "AnyDATA Corporation",
        "00:19:C4": "Infocrypt Inc.",
        "00:19:BC": "ELECTRO CHANCE SRL",
        "00:19:9B": "Diversified Technical Systems, Inc.",
        "00:19:90": "ELM DATA Co., Ltd.",
        "00:19:8F": "Nokia Bell N.V.",
        "00:19:D8": "MAXFOR",
        "00:19:D5": "IP Innovations, Inc.",
        "00:19:A3": "asteel electronique atlantique",
        "00:19:EA": "TeraMage Technologies Co., Ltd.",
        "00:19:6E": "Metacom (Pty) Ltd.",
        "00:19:65": "YuHua TelTech (ShangHai) Co., Ltd.",
        "00:19:66": "Asiarock Technology Limited",
        "00:19:7B": "Picotest Corp.",
        "00:19:73": "Zeugma Systems",
        "00:19:75": "Beijing Huisen networks technology Inc",
        "00:19:40": "Rackable Systems",
        "00:19:3C": "HighPoint Technologies Incorporated",
        "00:19:5C": "Innotech Corporation",
        "00:19:5F": "Valemount Networks Corporation",
        "00:19:48": "AireSpider Networks",
        "00:19:43": "Belden",
        "00:19:2E": "Spectral Instruments, Inc.",
        "00:19:2B": "Aclara RF Systems Inc.",
        "00:19:1E": "Beyondwiz Co., Ltd.",
        "00:19:81": "Vivox Inc",
        "00:19:45": "RF COncepts, LLC",
        "00:19:1F": "Microlink communications Inc.",
        "00:19:20": "KUME electric Co.,Ltd.",
        "00:19:26": "BitsGen Co., Ltd.",
        "00:19:29": "2M2B Montadora de Maquinas Bahia Brasil LTDA",
        "00:18:F1": "Chunichi Denshi Co.,LTD.",
        "00:18:F2": "Beijing Tianyu Communication Equipment Co., Ltd",
        "00:18:EC": "Welding Technology Corporation",
        "00:18:ED": "Accutech Ultrasystems Co., Ltd.",
        "00:19:0B": "Southern Vision Systems, Inc.",
        "00:19:03": "Bigfoot Networks Inc",
        "00:19:00": "Intelliverese - DBA Voicecom",
        "00:19:02": "Cambridge Consultants Ltd",
        "00:19:2A": "Antiope Associates",
        "00:19:0F": "Advansus Corp.",
        "00:19:11": "Just In Mobile Information Technologies (Shanghai) Co., Ltd.",
        "00:18:E0": "ANAVEO",
        "00:19:17": "Posiflex Inc.",
        "00:19:18": "Interactive Wear AG",
        "00:18:CB": "Tecobest Technology Limited",
        "00:18:CE": "Dreamtech Co., Ltd",
        "00:18:94": "NPCore, Inc.",
        "00:18:98": "KINGSTATE ELECTRONICS CORPORATION",
        "00:18:92": "ads-tec GmbH",
        "00:18:91": "Zhongshan General K-mate Electronics Co., Ltd",
        "00:18:AD": "NIDEC SANKYO CORPORATION",
        "00:18:AC": "Shanghai Jiao Da HISYS Technology Co. Ltd.",
        "00:18:AB": "BEIJING LHWT MICROELECTRONICS INC.",
        "00:18:A5": "ADigit Technologies Corp.",
        "00:18:78": "Mackware GmbH",
        "00:18:6A": "Global Link Digital Technology Co,.LTD",
        "00:18:6B": "Sambu Communics CO., LTD.",
        "00:18:6E": "3Com Ltd",
        "00:18:A6": "Persistent Systems, LLC",
        "00:18:9B": "Thomson Inc.",
        "00:18:B2": "ADEUNIS RF",
        "00:18:B3": "TEC WizHome Co., Ltd.",
        "00:18:BD": "SHENZHEN DVBWORLD TECHNOLOGY CO., LTD.",
        "00:18:67": "Datalogic ADC",
        "00:18:65": "Siemens Healthcare Diagnostics Manufacturing Ltd",
        "00:18:77": "Amplex A/S",
        "00:18:89": "WinNet Solutions Limited",
        "00:17:F9": "Forcom Sp. z o.o.",
        "00:17:F4": "ZERON ALLIANCE",
        "00:17:F7": "CEM Solutions Pvt Ltd",
        "00:17:ED": "WooJooIT Ltd.",
        "00:18:43": "Dawevision Ltd",
        "00:18:2C": "Ascend Networks, Inc.",
        "00:18:1D": "ASIA ELECTRONICS CO.,LTD",
        "00:18:1F": "Palmmicro Communications",
        "00:18:1B": "TaiJin Metal Co., Ltd.",
        "00:18:05": "Beijing InHand Networking Technology Co.,Ltd.",
        "00:18:0D": "Terabytes Server Storage Tech Corp",
        "00:18:54": "Argard Co., Ltd",
        "00:18:47": "AceNet Technology Inc.",
        "00:18:36": "REJ Co.,Ltd",
        "00:17:CC": "Alcatel-Lucent",
        "00:17:C4": "Quanta Microsystems, INC.",
        "00:17:9E": "Sirit Inc",
        "00:17:A7": "Mobile Computing Promotion Consortium",
        "00:17:9F": "Apricorn",
        "00:17:B4": "Remote Security Systems, LLC",
        "00:17:AC": "O'Neil Product Development Inc.",
        "00:17:AD": "AceNet Corporation",
        "00:17:DD": "Clipsal Australia",
        "00:17:D9": "AAI Corporation",
        "00:17:DC": "DAEMYUNG ZERO1",
        "00:17:BF": "Coherent Research Limited",
        "00:17:BD": "Tibetsystem",
        "00:17:A1": "3soft inc.",
        "00:17:92": "Falcom Wireless Comunications Gmbh",
        "00:17:97": "Telsy Elettronica S.p.A.",
        "00:17:8C": "Independent Witness, Inc",
        "00:17:CB": "Juniper Networks",
        "00:17:D3": "Etymotic Research, Inc.",
        "00:17:88": "Philips Lighting BV",
        "00:17:3C": "Extreme Engineering Solutions",
        "00:17:36": "iiTron Inc.",
        "00:17:37": "Industrie Dial Face S.p.A.",
        "00:17:33": "SFR",
        "00:17:58": "ThruVision Ltd",
        "00:17:4F": "iCatch Inc.",
        "00:17:4A": "SOCOMEC",
        "00:17:4E": "Parama-tech Co.,Ltd.",
        "00:17:6F": "PAX Computer Technology(Shenzhen) Ltd.",
        "00:17:71": "APD Communications Ltd",
        "00:17:5B": "ACS Solutions Switzerland Ltd.",
        "00:17:29": "Ubicod Co.LTD",
        "00:17:27": "Thermo Ramsey Italia s.r.l.",
        "00:17:2A": "Proware Technology Corp.(By Unifosa)",
        "00:17:25": "Liquid Computing",
        "00:17:64": "ATMedia GmbH",
        "00:17:5E": "Zed-3",
        "00:17:66": "Accense Technology, Inc.",
        "00:16:D0": "ATech elektronika d.o.o.",
        "00:16:C3": "BA Systems Inc",
        "00:16:F0": "Dell",
        "00:16:F8": "AVIQTECH TECHNOLOGY CO., LTD.",
        "00:17:03": "MOSDAN Internation Co.,Ltd",
        "00:16:FC": "TOHKEN CO.,LTD.",
        "00:16:E9": "Tiba Medical Inc",
        "00:16:DC": "ARCHOS",
        "00:17:14": "BR Controls Nederland bv",
        "00:17:1B": "Innovation Lab Corp.",
        "00:17:09": "Exalt Communications",
        "00:16:C1": "Eleksen Ltd",
        "00:16:A9": "2EI",
        "00:16:B0": "VK Corporation",
        "00:16:B1": "KBS",
        "00:16:AE": "INVENTEL",
        "00:16:AC": "Toho Technology Corp.",
        "00:16:83": "WEBIO International Co.,.Ltd.",
        "00:16:84": "Donjin Co.,Ltd.",
        "00:16:87": "Chubb CSC-Vendor AP",
        "00:16:7F": "Bluebird Soft Inc.",
        "00:16:4C": "PLANET INT Co., Ltd",
        "00:16:49": "SetOne GmbH",
        "00:16:47": "Cisco Systems, Inc",
        "00:16:65": "Cellon France",
        "00:16:5F": "Fairmount Automation",
        "00:16:7C": "iRex Technologies BV",
        "00:16:73": "Bury GmbH & Co. KG",
        "00:16:94": "Sennheiser Communications A/S",
        "00:16:9C": "Cisco Systems, Inc",
        "00:16:57": "Aegate Ltd",
        "00:16:8C": "DSL Partner AS",
        "00:16:1B": "Micronet Corporation",
        "00:16:18": "HIVION Co., Ltd.",
        "00:16:1E": "Woojinnet",
        "00:16:1F": "SUNWAVETEC Co., Ltd.",
        "00:16:14": "Picosecond Pulse Labs",
        "00:16:0E": "Optica Technologies Inc.",
        "00:16:43": "Sunhillo Corporation",
        "00:16:44": "LITE-ON Technology Corp.",
        "00:16:3E": "Xensource, Inc.",
        "00:15:FD": "Complete Media Systems",
        "00:15:F6": "SCIENCE AND ENGINEERING SERVICES, INC.",
        "00:16:34": "Mathtech, Inc.",
        "00:16:2C": "Xanboo",
        "00:16:05": "YORKVILLE SOUND INC.",
        "00:15:F9": "Cisco Systems, Inc",
        "00:15:E3": "Dream Technologies Corporation",
        "00:15:E0": "Ericsson",
        "00:15:F3": "PELTOR AB",
        "00:15:D3": "Pantech&Curitel Communications, Inc.",
        "00:15:AD": "Accedian Networks",
        "00:15:AC": "Capelon AB",
        "00:15:A9": "KWANG WOO I&C CO.,LTD",
        "00:E0:A8": "SAT GmbH & Co.",
        "00:15:74": "Horizon Semiconductors Ltd.",
        "00:15:8A": "SURECOM Technology Corp.",
        "00:15:8E": "Plustek.INC",
        "00:15:89": "D-MAX Technology Co.,Ltd",
        "00:15:B4": "Polymap  Wireless LLC",
        "00:15:CA": "TeraRecon, Inc.",
        "00:15:98": "Kolektor group",
        "00:15:12": "Zurich University of Applied Sciences",
        "00:15:0A": "Sonoa Systems, Inc",
        "00:15:70": "Zebra Technologies Inc",
        "00:15:6E": "A. W. Communication Systems Ltd",
        "00:15:68": "Dilithium Networks",
        "00:15:4B": "Wonde Proud Technology Co., Ltd",
        "00:15:48": "CUBE TECHNOLOGIES",
        "00:15:5F": "GreenPeak Technologies",
        "00:15:5A": "DAINIPPON PHARMACEUTICAL CO., LTD.",
        "00:15:1D": "M2I CORPORATION",
        "00:15:3C": "Kprotech Co., Ltd.",
        "00:15:3A": "Shenzhen Syscan Technology Co.,Ltd.",
        "00:15:32": "Consumer Technologies Group, LLC",
        "00:14:9B": "Nokota Communications, LLC",
        "00:14:A1": "Synchronous Communication Corp",
        "00:14:9E": "UbONE Co., Ltd",
        "00:14:A2": "Core Micro Systems Inc.",
        "00:14:AD": "Gassner Wiege- und Meßtechnik GmbH",
        "00:14:AF": "Datasym POS Inc.",
        "00:14:A9": "Cisco Systems, Inc",
        "00:14:FF": "Precise Automation, Inc.",
        "00:14:FA": "AsGa S.A.",
        "00:14:FB": "Technical Solutions Inc.",
        "00:14:D2": "Kyuden Technosystems Corporation",
        "00:14:DC": "Communication System Design & Manufacturing (CSDM)",
        "00:14:CD": "DigitalZone Co., Ltd.",
        "00:14:C0": "Symstream Technology Group Ltd",
        "00:14:C1": "U.S. Robotics Corporation",
        "00:14:C4": "Vitelcom Mobile Technology",
        "00:14:EC": "Acro Telecom",
        "00:14:EB": "AwarePoint Corporation",
        "00:14:AB": "Senhai Electronic Technology Co., Ltd.",
        "00:14:B0": "Naeil Community",
        "00:14:F4": "DekTec Digital Video B.V.",
        "00:14:F5": "OSI Security Devices",
        "00:14:8E": "Tele Power Inc.",
        "00:14:8F": "Protronic (Far East) Ltd.",
        "00:14:8C": "General Dynamics Mission Systems",
        "00:14:87": "American Technology Integrators",
        "00:14:44": "Grundfos Holding",
        "00:14:37": "GSTeletech Co.,Ltd.",
        "00:14:31": "PDL Electronics Ltd",
        "00:14:4D": "Intelligent Systems",
        "00:14:4A": "Taiwan Thick-Film Ind. Corp.",
        "00:14:45": "Telefon-Gradnja d.o.o.",
        "00:14:68": "CelPlan International, Inc.",
        "00:14:7C": "3Com Ltd",
        "00:14:81": "Multilink Inc",
        "00:14:64": "Cryptosoft",
        "00:14:5E": "IBM Corp",
        "00:14:58": "HS Automatic ApS",
        "00:14:21": "Total Wireless Technologies Pte. Ltd.",
        "00:14:20": "G-Links networking company",
        "00:14:18": "C4Line",
        "00:14:1B": "Cisco Systems, Inc",
        "00:13:F0": "Wavefront Semiconductor",
        "00:13:EF": "Kingjon Digital Technology Co.,Ltd",
        "00:13:EB": "Sysmaster Corporation",
        "00:13:EC": "Netsnapper Technologies SARL",
        "00:14:2B": "Edata Communication Inc.",
        "00:14:2C": "Koncept International, Inc.",
        "00:14:24": "Merry Electrics CO., LTD.",
        "00:13:D0": "t+ Medical Ltd",
        "00:13:D2": "PAGE IBERICA, S.A.",
        "00:13:D1": "KIRK telecom A/S",
        "00:14:0F": "Federal State Unitary Enterprise Leningrad R&D Institute of",
        "00:14:07": "Sperian Protection Instrumentation",
        "00:14:06": "Go Networks",
        "00:14:0A": "WEPIO Co., Ltd.",
        "00:13:FA": "LifeSize Communications, Inc",
        "00:13:FB": "RKC INSTRUMENT INC.",
        "00:13:DC": "IBTEK INC.",
        "00:13:BA": "ReadyLinks Inc",
        "00:13:B8": "RyCo Electronic Systems Limited",
        "00:13:B6": "Sling Media, Inc.",
        "00:13:7D": "Dynalab, Inc.",
        "00:13:83": "Application Technologies and Engineering Research Laboratory",
        "00:13:87": "27M Technologies AB",
        "00:13:73": "BLwave Electronics Co., Ltd",
        "00:13:66": "Neturity Technologies Inc.",
        "00:13:5B": "PanelLink Cinema, LLC",
        "00:13:6F": "PacketMotion, Inc.",
        "00:13:68": "Saab Danmark A/S",
        "00:13:AE": "Radiance Technologies, Inc.",
        "00:13:97": "Oracle Corporation ",
        "00:13:C3": "Cisco Systems, Inc",
        "00:13:BD": "HYMATOM SA",
        "00:13:91": "OUEN CO.,LTD.",
        "00:13:23": "Cap Co., Ltd.",
        "00:13:14": "Asiamajor Inc.",
        "00:13:16": "L-S-B Broadcast Technologies GmbH",
        "00:13:12": "Amedia Networks Inc.",
        "00:13:36": "Tianjin 712 Communication Broadcasting co., ltd.",
        "00:13:5E": "EAB/RWI/K",
        "00:13:4E": "Valox Systems, Inc.",
        "00:13:44": "Fargo Electronics Inc.",
        "00:13:48": "Artila Electronics Co., Ltd.",
        "00:12:EF": "OneAccess SA",
        "00:12:E9": "Abbey Systems Ltd",
        "00:13:00": "IT-FACTORY, INC.",
        "00:13:22": "DAQ Electronics, Inc.",
        "00:12:D5": "Motion Reality Inc.",
        "00:12:D8": "International Games System Co., Ltd.",
        "00:12:9A": "IRT Electronics Pty Ltd",
        "00:12:8D": "STB Datenservice GmbH",
        "00:12:DB": "ZIEHL industrie-elektronik GmbH + Co KG",
        "00:12:D6": "Jiangsu Yitong High-Tech Co.,Ltd",
        "00:12:DA": "Cisco Systems, Inc",
        "00:12:D3": "Zetta Systems, Inc.",
        "00:12:A2": "VITA",
        "00:12:A5": "Dolphin Interconnect Solutions AS",
        "00:12:A8": "intec GmbH",
        "00:12:9E": "Surf Communications Inc.",
        "00:12:BA": "FSI Systems, Inc.",
        "00:12:B2": "AVOLITES LTD.",
        "00:12:AE": "HLS HARD-LINE Solutions Inc.",
        "00:12:AF": "ELPRO Technologies",
        "00:12:E6": "SPECTEC COMPUTER CO., LTD.",
        "00:12:36": "ConSentry Networks",
        "00:12:35": "Andrew Corporation",
        "00:12:45": "Zellweger Analytics, Inc.",
        "00:12:42": "Millennial Net",
        "00:12:41": "a2i marketing center",
        "00:12:3B": "KeRo Systems ApS",
        "00:12:87": "Digital Everywhere Unterhaltungselektronik GmbH",
        "00:12:82": "Qovia",
        "00:12:85": "Gizmondo Europe Ltd",
        "00:12:77": "Korenix Technologies Co., Ltd.",
        "00:12:6D": "University of California, Berkeley",
        "00:12:67": "Panasonic Corporation",
        "00:12:65": "Enerdyne Technologies, Inc.",
        "00:12:57": "LeapComm Communication Technologies Inc.",
        "00:12:51": "SILINK",
        "00:12:8E": "Q-Free ASA",
        "00:12:92": "Griffin Technology",
        "00:11:F3": "NeoMedia Europe AG",
        "00:11:E9": "STARNEX CO., LTD.",
        "00:11:EC": "AVIX INC.",
        "00:11:E7": "WORLDSAT - Texas de France",
        "00:12:02": "Decrane Aerospace - Audio International Inc.",
        "00:11:FE": "Keiyo System Research, Inc.",
        "00:11:FD": "KORG INC.",
        "00:11:FA": "Rane Corporation",
        "00:11:CE": "Ubisense Limited",
        "00:11:D0": "Tandberg Data ASA",
        "00:11:C3": "Transceiving System Technology Corporation",
        "00:11:C2": "United Fiber Optic Communication",
        "00:12:28": "Data Ltd.",
        "00:12:1F": "Harding Instruments",
        "00:12:20": "Cadco Systems",
        "00:12:29": "BroadEasy Technologies Co.,Ltd",
        "00:12:26": "Japan Direx Corporation",
        "00:12:22": "Skardin (UK) Ltd",
        "00:11:E8": "Tixi.Com",
        "00:11:E0": "U-MEDIA Communications, Inc.",
        "00:12:0D": "Advanced Telecommunication Technologies, Inc.",
        "00:12:0E": "AboCom",
        "00:11:F2": "Institute of Network Technologies",
        "00:12:10": "WideRay Corp",
        "00:11:A4": "JStream Technologies Inc.",
        "00:11:98": "Prism Media Products Limited",
        "00:11:97": "Monitoring Technologies Limited",
        "00:11:99": "2wcom Systems GmbH",
        "00:11:A7": "Infilco Degremont Inc.",
        "00:11:A9": "MOIMSTONE Co., LTD",
        "00:11:A3": "LanReady Technologies Inc.",
        "00:11:76": "Intellambda Systems, Inc.",
        "00:11:77": "Coaxial Networks, Inc.",
        "00:11:70": "GSC SRL",
        "00:11:6B": "Digital Data Communications Asia Co.,Ltd",
        "00:11:69": "EMS Satcom",
        "00:11:62": "STAR MICRONICS CO.,LTD.",
        "00:11:81": "InterEnergy Co.Ltd,",
        "00:11:94": "Chi Mei Communication Systems, Inc.",
        "00:11:BF": "AESYS S.p.A.",
        "00:11:B7": "Octalix B.V.",
        "00:11:B9": "Inner Range Pty. Ltd.",
        "00:11:09": "Micro-Star International",
        "00:11:04": "TELEXY",
        "00:11:61": "NetStreams, LLC",
        "00:11:56": "Pharos Systems NZ",
        "00:11:59": "MATISSE NETWORKS INC",
        "00:11:5C": "Cisco Systems, Inc",
        "00:11:5D": "Cisco Systems, Inc",
        "00:11:26": "Venstar Inc.",
        "00:11:2E": "CEICOM",
        "00:11:22": "CIMSYS Inc",
        "00:11:17": "CESNET",
        "00:11:16": "COTEAU VERT CO., LTD.",
        "00:11:10": "Maxanna Technology Co., Ltd.",
        "00:11:3B": "Micronet Communications Inc.",
        "00:11:3D": "KN SOLTEC CO.,LTD.",
        "00:11:34": "MediaCell, Inc.",
        "00:11:35": "Grandeye Ltd",
        "00:11:21": "Cisco Systems, Inc",
        "00:11:49": "Proliphix Inc.",
        "00:0F:C0": "DELCOMp",
        "00:0F:BA": "Tevebox AB",
        "00:0F:B8": "CallURL Inc.",
        "00:0F:B7": "Cavium",
        "00:0F:D3": "Digium",
        "00:0F:D1": "Applied Wireless Identifications Group, Inc.",
        "00:0F:C1": "WAVE Corporation",
        "00:11:00": "Schneider Electric",
        "00:0F:FA": "Optinel Systems, Inc.",
        "00:0F:FD": "Glorytek Network Inc.",
        "00:0F:F9": "Valcretec, Inc.",
        "00:0F:C4": "NST co.,LTD.",
        "00:0F:C9": "Allnet GmbH",
        "00:0F:C6": "Eurocom Industries A/S",
        "00:0F:BE": "e-w/you Inc.",
        "00:0F:A9": "PC Fabrik",
        "00:0F:9A": "Synchrony, Inc.",
        "00:0F:EA": "Giga-Byte Technology Co.,LTD.",
        "00:0F:F7": "Cisco Systems, Inc",
        "00:0F:D8": "Force, Inc.",
        "00:0F:8D": "FAST TV-Server AG",
        "00:0F:85": "ADDO-Japan Corporation",
        "00:0F:82": "Mortara Instrument, Inc.",
        "00:0F:49": "Northover Solutions Limited",
        "00:0F:4B": "Oracle Corporation",
        "00:0F:44": "Tivella Inc.",
        "00:0F:4A": "Kyushu-kyohan co.,ltd",
        "00:0F:81": "PAL Pacific Inc.",
        "00:0F:7F": "UBSTORAGE Co.,Ltd.",
        "00:0F:95": "ELECOM Co.,LTD Laneed Division",
        "00:0F:55": "Datawire Communication Networks Inc.",
        "00:0F:56": "Continuum Photonics Inc",
        "00:0F:60": "Lifetron Co.,Ltd",
        "00:0F:5B": "Delta Information Systems, Inc.",
        "00:0F:8A": "WideView",
        "00:0F:90": "Cisco Systems, Inc",
        "00:0F:77": "DENTUM CO.,LTD",
        "00:0F:7B": "Arce Sistemas, S.A.",
        "00:0F:68": "Vavic Network Technology, Inc.",
        "00:0E:E2": "Custom Engineering",
        "00:0E:E3": "Chiyu Technology Co.,Ltd",
        "00:0E:E5": "bitWallet, Inc.",
        "00:0E:DA": "C-TECH UNITED CORP.",
        "00:0E:CF": "PROFIBUS Nutzerorganisation e.V.",
        "00:0E:EB": "Sandmartin(zhong shan)Electronics Co.,Ltd",
        "00:0E:EC": "Orban",
        "00:0E:EF": "Private",
        "00:0E:F1": "EZQUEST INC.",
        "00:0E:E7": "AAC ELECTRONICS CORP.",
        "00:0F:1C": "DigitAll World Co., Ltd",
        "00:0F:1A": "Gaming Support B.V.",
        "00:0F:0A": "Clear Edge Networks",
        "00:0F:02": "Digicube Technology Co., Ltd",
        "00:0F:2F": "W-LINX TECHNOLOGY CO., LTD.",
        "00:0F:2D": "CHUNG-HSIN ELECTRIC & MACHINERY MFG.CORP.",
        "00:0E:F7": "Vulcan Portals Inc",
        "00:0E:F0": "Festo AG & Co. KG",
        "00:0E:E9": "WayTech Development, Inc.",
        "00:0F:40": "Optical Internetworking Forum",
        "00:0F:33": "DUALi Inc.",
        "00:0F:05": "3B SYSTEM INC.",
        "00:0E:C9": "YOKO Technology Corp.",
        "00:0E:BD": "Burdick, a Quinton Compny",
        "00:0E:B9": "HASHIMOTO Electronics Industry Co.,Ltd.",
        "00:0E:B2": "Micro-Research Finland Oy",
        "00:0E:D0": "Privaris, Inc.",
        "00:0E:C3": "Logic Controls, Inc.",
        "00:0E:C4": "Iskra Transmission d.d.",
        "00:0E:C1": "MYNAH Technologies",
        "00:0E:89": "CLEMATIC",
        "00:0E:79": "Ample Communications Inc.",
        "00:0E:A1": "Formosa Teletek Corporation",
        "00:0E:98": "HME Clear-Com LTD.",
        "00:0E:99": "Spectrum Digital, Inc",
        "00:0E:95": "Fujiya Denki Seisakusho Co.,Ltd.",
        "00:0E:97": "Ultracker Technology CO., Inc",
        "00:0E:A7": "Endace Technology",
        "00:0E:6F": "IRIS Corporation Berhad",
        "00:0E:B5": "Ecastle Electronics Co., Ltd.",
        "00:0E:50": "Thomson Telecom Belgium",
        "00:0E:4B": "atrium c and i",
        "00:0E:2B": "Safari Technologies",
        "00:0E:28": "Dynamic Ratings P/L",
        "00:0E:24": "Huwell Technology Inc.",
        "00:0E:3F": "Soronti, Inc.",
        "00:0E:45": "Beijing Newtry Electronic Technology Ltd",
        "00:0E:1D": "ARION Technology Inc.",
        "00:0E:12": "Adaptive Micro Systems Inc.",
        "00:0E:4F": "Trajet GmbH",
        "00:0E:38": "Cisco Systems, Inc",
        "00:0E:36": "HEINESYS, Inc.",
        "00:0E:17": "Private",
        "00:0E:15": "Tadlys LTD",
        "00:0E:01": "ASIP Technologies Inc.",
        "00:0D:CB": "Petcomkorea Co., Ltd.",
        "00:0D:CC": "NEOSMART Corp.",
        "00:0D:CE": "Dynavac Technology Pte Ltd",
        "00:0D:E8": "Nasaco Electronics Pte. Ltd",
        "00:0D:E9": "Napatech Aps",
        "00:0D:E6": "YOUNGBO ENGINEERING CO.,LTD",
        "00:0D:C3": "First Communication, Inc.",
        "00:0D:B9": "PC Engines GmbH",
        "00:0D:B7": "SANKO ELECTRIC CO,.LTD",
        "00:0D:AC": "Japan CBM Corporation",
        "00:0D:DF": "Japan Image & Network Inc.",
        "00:0D:DB": "AIRWAVE TECHNOLOGIES INC.",
        "00:0E:04": "CMA/Microdialysis AB",
        "00:0D:2A": "Scanmatic AS",
        "00:0D:29": "Cisco Systems, Inc",
        "00:0D:26": "Primagraphics Limited",
        "00:0D:46": "Parker SSD Drives",
        "00:0D:41": "Siemens AG ICM MP UC RD IT KLF1",
        "00:0D:42": "Newbest Development Limited",
        "00:0D:3C": "i.Tech Dynamic Ltd",
        "00:0D:55": "SANYCOM Technology Co.,Ltd",
        "00:0D:57": "Fujitsu I-Network Systems Limited.",
        "00:0D:58": "Private",
        "00:0D:51": "DIVR Systems, Inc.",
        "00:0D:39": "Network Electronics",
        "00:0D:35": "PAC International Ltd",
        "00:0D:95": "Opti-cell, Inc.",
        "00:0D:91": "Eclipse (HQ Espana) S.L.",
        "00:0D:62": "Funkwerk Dabendorf GmbH",
        "00:0D:65": "Cisco Systems, Inc",
        "00:0D:45": "Tottori SANYO Electric Co., Ltd.",
        "00:0D:A1": "MIRAE ITS Co.,LTD.",
        "00:0D:80": "Online Development Inc",
        "00:0D:13": "Wilhelm Rutenbeck GmbH&Co.KG",
        "00:0D:19": "ROBE Show lighting",
        "00:0D:1C": "Amesys Defense",
        "00:0C:ED": "Real Digital Media",
        "00:0C:F0": "M & N GmbH",
        "00:0C:F4": "AKATSUKI ELECTRIC MFG.CO.,LTD.",
        "00:0C:F3": "CALL IMAGE SA",
        "00:0C:CF": "Cisco Systems, Inc",
        "00:0C:D8": "M. K. Juchheim GmbH & Co",
        "00:0C:C6": "Ka-Ro electronics GmbH",
        "00:0D:01": "P&E Microcomputer Systems, Inc.",
        "00:0D:00": "Seaway Networks Inc.",
        "00:0C:F9": "Xylem Water Solutions",
        "00:0C:C4": "Tiptel AG",
        "00:0C:BA": "Jamex, Inc.",
        "00:0C:D1": "SFOM Technology Corp.",
        "00:0C:CE": "Cisco Systems, Inc",
        "00:0C:E0": "Trek Diagnostics Inc.",
        "00:0C:E2": "Rolls-Royce",
        "00:0D:0C": "MDI Security Systems",
        "00:0D:16": "UHS Systems Pty Ltd",
        "00:0D:1F": "AV Digital",
        "00:0C:AD": "BTU International",
        "00:0C:AA": "Cubic Transportation Systems Inc",
        "00:0C:AC": "Citizen Watch Co., Ltd.",
        "00:0C:AE": "Ailocom Oy",
        "00:0C:A3": "Rancho Technology, Inc.",
        "00:0C:9C": "Chongho information & communications",
        "00:0C:97": "NV ADB TTV Technologies SA",
        "00:0C:8F": "Nergal s.r.l.",
        "00:0C:92": "WolfVision Gmbh",
        "00:0C:93": "Xeline Co., Ltd.",
        "00:0C:7F": "synertronixx GmbH",
        "00:0C:81": "Schneider Electric (Australia) ",
        "00:0C:9E": "MemoryLink Corp.",
        "00:0C:95": "PrimeNet",
        "00:0C:76": "MICRO-STAR INTERNATIONAL CO., LTD.",
        "00:0C:80": "Opelcomm Inc.",
        "00:0C:7D": "TEIKOKU ELECTRIC MFG. CO., LTD",
        "00:0C:B7": "Nanjing Huazhuo Electronics Co., Ltd.",
        "00:0C:68": "SigmaTel, Inc.",
        "00:0C:07": "Iftest AG",
        "00:0C:0C": "APPRO TECHNOLOGY INC.",
        "00:0C:0E": "XtremeSpectrum, Inc.",
        "00:0C:12": "Micro-Optronic-Messtechnik GmbH",
        "00:0C:10": "PNI Corporation",
        "00:0C:40": "Altech Controls",
        "00:0C:3E": "Crest Audio",
        "00:0C:3A": "Oxance",
        "00:0C:35": "KaVo Dental GmbH & Co. KG",
        "00:0C:56": "Megatel Computer (1986) Corp.",
        "00:0C:57": "MACKIE Engineering Services Belgium BVBA",
        "00:0C:23": "Beijing Lanchuan Tech. Co., Ltd.",
        "00:0C:25": "Allied Telesis Labs, Inc. ",
        "00:0C:18": "Zenisu Keisoku Inc.",
        "00:0C:0A": "Guangdong Province Electronic Technology Research Institute",
        "00:0C:0B": "Broadbus Technologies",
        "00:0C:4A": "Cygnus Microsystems (P) Limited",
        "00:0C:54": "Pedestal Networks, Inc",
        "00:0C:37": "Geomation, Inc.",
        "00:0B:E8": "AOIP",
        "00:0B:DC": "AKCP",
        "00:0B:D8": "Industrial Scientific Corp.",
        "00:0B:D7": "DORMA Time + Access GmbH",
        "00:0B:DD": "TOHOKU RICOH Co., LTD.",
        "00:0B:E5": "HIMS International Corporation",
        "00:0B:E9": "Actel Corporation",
        "00:0B:E3": "Key Stream Co., Ltd.",
        "00:0B:D3": "cd3o",
        "00:0B:D5": "Nvergence, Inc.",
        "00:0B:D1": "Aeronix, Inc.",
        "00:0B:D2": "Remopro Technology Inc.",
        "00:0B:C7": "ICET S.p.A.",
        "00:0B:B8": "Kihoku Electronic Co.",
        "00:0B:C0": "China IWNComm Co., Ltd.",
        "00:0B:B0": "Sysnet Telematica srl",
        "00:0B:B4": "RDC Semiconductor Inc.,",
        "00:0B:CC": "JUSAN, S.A.",
        "00:0B:AC": "3Com Ltd",
        "00:0B:F9": "Gemstone Communications, Inc.",
        "00:0B:FC": "Cisco Systems, Inc",
        "00:0B:EA": "Zultys Technologies",
        "00:0B:9F": "Neue ELSA GmbH",
        "00:0B:98": "NiceTechVision",
        "00:0B:95": "eBet Gaming Systems Pty Ltd",
        "00:0B:9E": "Yasing Technology Corp.",
        "00:0B:88": "Vidisco ltd.",
        "00:0B:54": "BiTMICRO Networks, Inc.",
        "00:0B:8C": "Flextronics",
        "00:0B:8A": "MITEQ Inc.",
        "00:0B:90": "ADVA Optical Networking Ltd.",
        "00:0B:79": "X-COM, Inc.",
        "00:0B:4B": "VISIOWAVE SA",
        "00:0B:36": "Productivity Systems, Inc.",
        "00:0B:35": "Quad Bit System co., Ltd.",
        "00:0B:75": "Iosoft Ltd.",
        "00:0B:70": "Load Technology, Inc.",
        "00:0B:6F": "Media Streaming Networks Inc",
        "00:0B:43": "Microscan Systems, Inc.",
        "00:0B:45": "Cisco Systems, Inc",
        "00:0B:4C": "Clarion (M) Sdn Bhd",
        "00:0B:63": "Kaleidescape",
        "00:0B:68": "Addvalue Communications Pte Ltd",
        "00:0B:58": "Astronautics C.A  LTD",
        "00:0B:55": "ADInstruments",
        "00:0B:87": "American Reliance Inc.",
        "00:0B:0D": "Air2U, Inc.",
        "00:0B:0B": "Corrent Corporation",
        "00:0B:08": "Pillar Data Systems",
        "00:0B:27": "Scion Corporation",
        "00:0B:21": "G-Star Communications Inc.",
        "00:0A:DA": "Vindicator Technologies",
        "00:0A:C9": "Zambeel Inc",
        "00:0B:25": "Aeluros",
        "00:0B:1A": "Industrial Defender, Inc.",
        "00:0B:18": "Private",
        "00:0B:15": "Platypus Technology",
        "00:0A:FA": "Traverse Technologies Australia",
        "00:0A:FC": "Core Tec Communications, LLC",
        "00:0A:EC": "Koatsu Gas Kogyo Co., Ltd.",
        "00:0A:E7": "ELIOP S.A.",
        "00:0A:E8": "Cathay Roxus Information Technology Co. LTD",
        "00:0A:DD": "Allworx Corp.",
        "00:0A:E1": "EG Technology",
        "00:0A:DF": "Gennum Corporation",
        "00:0B:3F": "Anthology Solutions Inc.",
        "00:0B:3C": "Cygnal Integrated Products, Inc.",
        "00:0A:F1": "Clarity Design, Inc.",
        "00:0A:F3": "Cisco Systems, Inc",
        "00:0A:8D": "EUROTHERM LIMITED",
        "00:0A:9F": "Pannaway Technologies, Inc.",
        "00:0A:8F": "Aska International Inc.",
        "00:0A:A0": "Cedar Point Communications",
        "00:0A:8E": "Invacom Ltd",
        "00:0A:C1": "Futuretel",
        "00:0A:BE": "OPNET Technologies CO., LTD.",
        "00:0A:C3": "eM Technics Co., Ltd.",
        "00:0A:C4": "Daewoo Teletech Co., Ltd",
        "00:0A:C0": "Fuyoh Video Industry CO., LTD.",
        "00:0A:AE": "Rosemount Process Analytical",
        "00:0A:B3": "Fa. GIRA",
        "00:0A:BA": "Arcon Technology Limited",
        "00:0A:B6": "COMPUNETIX, INC",
        "00:0A:AF": "Pipal Systems",
        "00:0A:76": "Beida Jade Bird Huaguang Technology Co.,Ltd",
        "00:0A:B2": "Fresnel Wireless Systems",
        "00:0A:AA": "AltiGen Communications Inc.",
        "00:0A:99": "Calamp Wireless Networks Inc",
        "00:0A:93": "W2 Networks, Inc.",
        "00:0A:89": "Creval Systems, Inc.",
        "00:0A:80": "Telkonet Inc.",
        "00:0A:79": "corega K.K",
        "00:0A:5C": "Carel s.p.a.",
        "00:0A:5A": "GreenNET Technologies Co.,Ltd.",
        "00:0A:56": "HITACHI Maxell Ltd.",
        "00:0A:51": "GyroSignal Technology Co., Ltd.",
        "00:0A:2C": "Active Tchnology Corporation",
        "00:0A:2A": "QSI Systems Inc.",
        "00:0A:23": "Parama Networks Inc",
        "00:0A:1F": "ART WARE Telecommunication Co., Ltd.",
        "00:0A:0A": "SUNIX Co., Ltd.",
        "00:0A:05": "Widax Corp.",
        "00:0A:34": "Identicard Systems Incorporated",
        "00:0A:30": "Visteon Corporation",
        "00:0A:2F": "Artnix Inc.",
        "00:0A:15": "Silicon Data, Inc",
        "00:0A:1B": "Stream Labs",
        "00:0A:1A": "Imerge Ltd",
        "00:0A:60": "Autostar Technology Pte Ltd",
        "00:0A:5D": "FingerTec Worldwide Sdn Bhd",
        "00:0A:39": "LoPA Information Technology",
        "00:0A:37": "Procera Networks, Inc.",
        "00:0A:53": "Intronics, Incorporated",
        "00:0A:4A": "Targa Systems Ltd.",
        "00:09:D6": "KNC One GmbH",
        "00:09:C7": "Movistec",
        "00:09:C9": "BlueWINC Co., Ltd.",
        "00:09:D4": "Transtech Networks",
        "00:09:CB": "HBrain",
        "00:09:F1": "Yamaki Electric Corporation",
        "00:09:F4": "Alcon Laboratories, Inc.",
        "00:09:F5": "Emerson Network Power Co.,Ltd",
        "00:09:EA": "YEM Inc.",
        "00:09:C5": "KINGENE Technology Corporation",
        "00:09:CD": "HUDSON SOFT CO.,LTD.",
        "00:09:C0": "6WIND",
        "00:09:BF": "Nintendo Co., Ltd.",
        "00:09:E3": "Angel Iglesias S.A.",
        "00:09:B4": "KISAN TELECOM CO., LTD.",
        "00:09:AE": "OKANO ELECTRIC CO.,LTD",
        "00:09:BA": "MAKU Informationstechik GmbH",
        "00:0A:04": "3Com Ltd",
        "00:09:71": "Time Management, Inc.",
        "00:09:74": "Innopia Technologies, Inc.",
        "00:09:8B": "Entropic Communications, Inc.",
        "00:09:7E": "IMI TECHNOLOGY CO., LTD",
        "00:09:6A": "Cloverleaf Communications Inc.",
        "00:09:5A": "RACEWOOD TECHNOLOGY",
        "00:09:4E": "BARTECH SYSTEMS INTERNATIONAL, INC",
        "00:09:47": "Aztek, Inc.",
        "00:09:51": "Apogee Imaging Systems",
        "00:09:3D": "Newisys,Inc.",
        "00:09:67": "Tachyon, Inc",
        "00:09:96": "RDI",
        "00:09:0C": "Mayekawa Mfg. Co. Ltd.",
        "00:09:0D": "LEADER ELECTRONICS CORP.",
        "00:08:FE": "UNIK C&C Co.,Ltd.",
        "00:08:FF": "Trilogy Communications Ltd",
        "00:09:04": "MONDIAL electronic",
        "00:09:1F": "A&D Co., Ltd.",
        "00:09:24": "Telebau GmbH",
        "00:09:21": "Planmeca Oy",
        "00:09:19": "MDS Gateways",
        "00:09:18": "SAMSUNG TECHWIN CO.,LTD",
        "00:09:2F": "Akom Technology Corporation",
        "00:08:EF": "DIBAL,S.A.",
        "00:08:F0": "Next Generation Systems, Inc.",
        "00:08:E9": "NextGig",
        "00:09:10": "Simple Access Inc.",
        "00:09:14": "COMPUTROLS INC.",
        "00:08:E7": "SHI ControlSystems,Ltd.",
        "00:08:D7": "HOW CORPORATION",
        "00:08:FC": "Gigaphoton Inc.",
        "00:09:38": "Allot Communications",
        "00:08:BF": "Aptus Elektronik AB",
        "00:08:B8": "E.F. Johnson",
        "00:08:BB": "NetExcell",
        "00:08:BE": "XENPAK MSA Group",
        "00:08:C1": "Avistar Communications Corporation",
        "00:08:C6": "Philips Consumer Communications",
        "00:08:65": "JASCOM CO., LTD",
        "00:08:64": "Fasy S.p.A.",
        "00:08:60": "LodgeNet Entertainment Corp.",
        "00:08:97": "Quake Technologies",
        "00:08:90": "AVILINKS SA",
        "00:08:8D": "Sigma-Links Inc.",
        "00:08:A8": "Systec Co., Ltd.",
        "00:08:A4": "Cisco Systems, Inc",
        "08:00:6B": "ACCEL TECHNOLOGIES INC.",
        "00:08:84": "Index Braille AB",
        "00:07:E8": "EdgeWave",
        "00:07:EB": "Cisco Systems, Inc",
        "00:07:EC": "Cisco Systems, Inc",
        "00:08:51": "Canadian Bank Note Company, Ltd.",
        "00:08:59": "ShenZhen Unitone Electronics Co., Ltd.",
        "00:08:4E": "DivergeNet, Inc.",
        "00:08:19": "Banksys",
        "00:08:1A": "Sanrad Intelligence Storage Communications (2000) Ltd.",
        "00:08:10": "Key Technology, Inc.",
        "00:08:07": "Access Devices Limited",
        "00:07:FC": "Adept Systems Inc.",
        "00:08:25": "Acme Packet",
        "00:07:DC": "Atek Co, Ltd.",
        "00:08:1F": "Pou Yuen Tech Corp. Ltd.",
        "00:07:C6": "VDS Vosskuhler GmbH",
        "00:07:F5": "Bridgeco Co AG",
        "00:07:94": "Simple Devices, Inc.",
        "00:07:97": "Netpower Co., Ltd.",
        "00:07:8C": "Elektronikspecialisten i Borlange AB",
        "00:07:CC": "Kaba Benzing GmbH",
        "00:07:C0": "NetZerver Inc.",
        "00:04:7E": "Siqura B.V.",
        "00:07:BC": "Identix Inc.",
        "00:07:A9": "Novasonics",
        "00:07:A1": "VIASYS Healthcare GmbH",
        "00:07:9E": "Ilinx Co., Ltd.",
        "00:07:A0": "e-Watch Inc.",
        "00:07:88": "Clipcomm, Inc.",
        "00:07:81": "Itron Inc.",
        "00:07:6B": "Stralfors AB",
        "00:07:68": "Danfoss A/S",
        "00:07:5F": "VCS Video Communication Systems AG",
        "00:07:B8": "Corvalent Corporation",
        "00:07:7B": "Millimetrix Broadband Networks",
        "00:07:69": "Italiana Macchi SpA",
        "00:07:1A": "Finedigital Inc.",
        "00:07:1E": "Tri-M Engineering / Nupak Dev. Corp.",
        "00:07:17": "Wieland Electric GmbH",
        "00:07:11": "Acterna",
        "00:07:02": "Varex Imaging",
        "00:07:05": "Endress & Hauser GmbH & Co",
        "00:06:FF": "Sheba Systems Co., Ltd.",
        "00:07:41": "Sierra Automated Systems",
        "00:07:45": "Radlan Computer Communications Ltd.",
        "00:07:3E": "China Great-Wall Computer Shenzhen Co., Ltd.",
        "00:07:33": "DANCONTROL Engineering",
        "00:07:2B": "Jung Myung Telecom Co., Ltd.",
        "00:07:18": "iCanTek Co., Ltd.",
        "00:07:16": "J & S Marine Ltd.",
        "00:07:5C": "Eastman Kodak Company",
        "00:07:56": "Juyoung Telecom",
        "00:07:5A": "Air Products and Chemicals, Inc.",
        "00:07:48": "The Imaging Source Europe",
        "00:07:46": "TURCK, Inc.",
        "00:07:3B": "Tenovis GmbH & Co KG",
        "00:07:31": "Ophir-Spiricon LLC",
        "00:07:0A": "Unicom Automation Co., Ltd.",
        "00:07:09": "Westerstrand Urfabrik AB",
        "00:06:EB": "Global Data",
        "00:06:D3": "Alpha Telecom, Inc. U.S.A.",
        "00:06:47": "Etrali S.A.",
        "00:06:A4": "INNOWELL Corp.",
        "00:06:D6": "Cisco Systems, Inc",
        "00:06:CB": "Jotron Electronics A/S",
        "00:06:CD": "Leaf Imaging Ltd.",
        "00:06:95": "Ensure Technologies, Inc.",
        "00:06:91": "PT Inovacao",
        "00:06:92": "Intruvert Networks, Inc.",
        "00:06:8B": "AirRunner Technologies, Inc.",
        "00:06:88": "Telways Communication Co., Ltd.",
        "00:06:AB": "W-Link Systems, Inc.",
        "00:06:AC": "Intersoft Co.",
        "00:06:94": "Mobillian Corporation",
        "00:06:C7": "RFNET Technologies Pte Ltd (S)",
        "00:06:B9": "A5TEK Corp.",
        "00:06:B3": "Diagraph Corporation",
        "00:06:E3": "Quantitative Imaging Corporation",
        "00:06:E4": "Citel Technologies Ltd.",
        "00:06:A1": "Celsian Technologies, Inc.",
        "00:06:D9": "IPM-Net S.p.A.",
        "00:06:63": "Human Technology Co., Ltd.",
        "00:06:65": "Sunny Giken, Inc.",
        "00:06:69": "Datasound Laboratories Ltd",
        "00:06:6E": "Delta Electronics, Inc.",
        "00:06:1B": "Notebook Development Lab.  Lenovo Japan Ltd.",
        "00:06:0F": "Narad Networks Inc",
        "00:06:10": "Abeona Networks Inc",
        "00:06:11": "Zeus Wireless, Inc.",
        "00:05:EC": "Mosaic Systems Inc.",
        "00:06:62": "MBM Technology Ltd.",
        "00:06:5A": "Strix Systems",
        "00:06:52": "Cisco Systems, Inc",
        "00:06:56": "Tactel AB",
        "00:06:41": "ITCN",
        "00:06:48": "Seedsware, Inc.",
        "00:06:4C": "Invicta Networks, Inc.",
        "00:06:74": "Spectrum Control, Inc.",
        "00:06:38": "Sungjin C&C Co., Ltd.",
        "00:06:35": "PacketAir Networks, Inc.",
        "00:06:1A": "Zetari Inc.",
        "00:06:1F": "Vision Components GmbH",
        "00:06:87": "Omnitron Systems Technology, Inc.",
        "00:06:02": "Cirkitech Electronics Co.",
        "00:05:C0": "Digital Network Alacarte Co., Ltd.",
        "00:05:B8": "Electronic Design Associates, Inc.",
        "00:05:BA": "Area Netwoeks, Inc.",
        "00:05:BF": "JustEzy Technology, Inc.",
        "00:05:D5": "Speedcom Wireless",
        "00:05:C5": "Flaga HF",
        "00:05:CA": "Hitron Technology, Inc.",
        "00:05:D2": "DAP Technologies",
        "00:05:B1": "ASB Technology BV",
        "00:05:99": "DRS Test and Energy Management or DRS-TEM",
        "00:05:9A": "Cisco Systems, Inc",
        "00:05:AB": "Cyber Fone, Inc.",
        "00:05:92": "Pultek Corp.",
        "00:05:8B": "IPmental, Inc.",
        "00:05:AC": "Northern Digital, Inc.",
        "00:05:AD": "Topspin Communications, Inc.",
        "00:05:D1": "Metavector Technologies",
        "00:05:FB": "ShareGate, Inc.",
        "00:05:FE": "Traficon N.V.",
        "00:05:F0": "SATEC",
        "00:05:30": "Andiamo Systems, Inc.",
        "00:05:38": "Merilus, Inc.",
        "00:05:2B": "HORIBA, Ltd.",
        "00:05:1D": "Airocon, Inc.",
        "00:05:15": "Nuark Co., Ltd.",
        "00:05:16": "SMART Modular Technologies",
        "00:05:77": "SM Information & Communication",
        "00:05:70": "Baydel Ltd.",
        "00:05:6E": "National Enhance Technology, Inc.",
        "00:05:6D": "Pacific Corporation",
        "00:05:81": "Snell",
        "00:05:7D": "Sun Communications, Inc.",
        "00:05:86": "Lucent Technologies",
        "00:05:7B": "Chung Nam Electronic Co., Ltd.",
        "00:05:71": "Seiwa Electronics Co.",
        "00:05:49": "Salira Optical Network Systems",
        "00:05:4C": "RF Innovations Pty Ltd",
        "00:05:43": "IQ Wireless GmbH",
        "00:05:5C": "Kowa Company, Ltd.",
        "00:05:10": "Infinite Shanghai Communication Terminals Ltd.",
        "00:04:FF": "Acronet Co., Ltd.",
        "00:05:01": "Cisco Systems, Inc",
        "00:05:08": "Inetcam, Inc.",
        "00:05:1B": "Magic Control Technology Corporation",
        "00:05:13": "VTLinx Multimedia Systems, Inc.",
        "00:05:0E": "3ware, Inc.",
        "00:04:D7": "Omitec Instrumentation Ltd.",
        "00:04:D4": "Proview Electronics Co., Ltd.",
        "00:04:DB": "Tellus Group Corp.",
        "00:04:E0": "Procket Networks",
        "00:04:DD": "Cisco Systems, Inc",
        "00:80:86": "COMPUTER GENERATION INC.",
        "00:05:04": "Naray Information & Communication Enterprise",
        "00:05:09": "AVOC Nishimura Ltd.",
        "00:04:FB": "Commtech, Inc.",
        "00:04:C0": "Cisco Systems, Inc",
        "00:04:BA": "KDD Media Will Corporation",
        "00:04:B6": "Stratex Networks, Inc.",
        "00:04:CD": "Extenway Solutions Inc",
        "00:04:E9": "Infiniswitch Corporation",
        "00:04:E8": "IER, Inc.",
        "00:04:B3": "Videotek, Inc.",
        "00:04:4C": "JENOPTIK",
        "00:04:44": "Western Multiplex Corporation",
        "00:04:39": "Rosco Entertainment Technology, Inc.",
        "00:04:3A": "Intelligent Telecommunications, Inc.",
        "00:04:92": "Hive Internet, Ltd.",
        "00:04:8C": "Nayna Networks, Inc.",
        "00:04:91": "Technovision, Inc.",
        "00:04:93": "Tsinghua Unisplendour Co., Ltd.",
        "00:04:94": "Breezecom, Ltd.",
        "00:04:89": "YAFO Networks, Inc.",
        "00:04:8A": "Temia Vertriebs GmbH",
        "00:04:81": "Econolite Control Products, Inc.",
        "00:04:6C": "Cyber Technology Co., Ltd.",
        "00:04:71": "IPrad",
        "00:04:6E": "Cisco Systems, Inc",
        "00:04:74": "LEGRAND",
        "00:04:2D": "Sarian Systems, Ltd.",
        "00:04:2E": "Netous Technologies, Ltd.",
        "00:04:25": "Atmel Corporation",
        "00:04:3F": "ESTeem Wireless Modems, Inc",
        "00:04:33": "Cyberboard A/S",
        "00:04:34": "Accelent Systems, Inc.",
        "00:04:77": "Scalant Systems, Inc.",
        "00:04:73": "Photonex Corporation",
        "00:04:70": "ipUnplugged AB",
        "00:04:5D": "BEKA Elektronik",
        "00:04:59": "Veristar Corporation",
        "00:04:A4": "NetEnabled, Inc.",
        "00:04:16": "Parks S/A Comunicacoes Digitais",
        "00:04:0F": "Asus Network Technologies, Inc.",
        "00:04:0A": "Sage Systems",
        "00:04:04": "Makino Milling Machine Co., Ltd.",
        "00:03:D0": "KOANKEISO Co., Ltd.",
        "00:03:CF": "Muxcom, Inc.",
        "00:03:D1": "Takaya Corporation",
        "00:03:AD": "Emerson Energy Systems AB",
        "00:03:A7": "Unixtar Technology, Inc.",
        "00:03:AE": "Allied Advanced Manufacturing Pte, Ltd.",
        "00:03:A3": "MAVIX, Ltd.",
        "00:03:B6": "QSI Corporation",
        "00:03:B3": "IA Link Systems Co., Ltd.",
        "00:03:EB": "Atrica",
        "00:03:E7": "Logostek Co. Ltd.",
        "00:03:E3": "Cisco Systems, Inc",
        "00:03:F4": "NetBurner",
        "00:03:F2": "Seneca Networks",
        "00:03:F0": "Redfern Broadband Networks",
        "00:03:DB": "Apogee Electronics Corp.",
        "00:03:D2": "Crossbeam Systems, Inc.",
        "00:04:05": "ACN Technologies",
        "00:04:01": "Osaki Electric Co., Ltd.",
        "00:03:A1": "HIPER Information & Communication, Inc.",
        "00:03:96": "EZ Cast Co., Ltd.",
        "00:03:9A": "SiConnect",
        "00:03:63": "Miraesys Co., Ltd.",
        "00:03:5F": "Prüftechnik Condition Monitoring GmbH & Co. KG",
        "00:03:60": "PAC Interactive Technology, Inc.",
        "00:03:61": "Widcomm, Inc.",
        "00:03:94": "Connect One",
        "00:03:8A": "America Online, Inc.",
        "00:03:8D": "PCS Revenue Control Systems, Inc.",
        "00:03:88": "Fastfame Technology Co., Ltd.",
        "00:03:59": "DigitalSis",
        "00:03:52": "Colubris Networks",
        "00:03:4C": "Shanghai DigiVision Technology Co., Ltd.",
        "00:03:78": "HUMAX Co., Ltd.",
        "00:03:74": "Control Microsystems",
        "00:03:76": "Graphtec Technology, Inc.",
        "00:03:7E": "PORTech Communications, Inc.",
        "00:03:6D": "Runtop, Inc.",
        "00:03:6E": "Nicon Systems (Pty) Limited",
        "00:03:71": "Acomz Networks Corp.",
        "00:03:49": "Vidicode Datacommunicatie B.V.",
        "00:03:3E": "Tateyama System Laboratory Co., Ltd.",
        "00:03:3C": "Daiden Co., Ltd.",
        "00:03:25": "Arima Computer Corp.",
        "00:03:1F": "Condev Ltd.",
        "00:02:9F": "L-3 Communication Aviation Recorders",
        "00:03:1B": "Cellvision Systems, Inc.",
        "00:03:1C": "Svenska Hardvarufabriken AB",
        "00:01:A8": "Welltech Computer Co., Ltd.",
        "00:03:0C": "Telesoft Technologies Ltd.",
        "00:03:08": "AM Communications, Inc.",
        "00:03:07": "Secure Works, Inc.",
        "00:03:06": "Fusion In Tech Co., Ltd.",
        "00:02:FC": "Cisco Systems, Inc",
        "00:02:FA": "DX Antenna Co., Ltd.",
        "00:02:FB": "Baumuller Aulugen-Systemtechnik GmbH",
        "00:02:F6": "Equipe Communications",
        "00:02:23": "ClickTV",
        "00:02:CB": "TriState Ltd.",
        "00:02:CA": "EndPoints, Inc.",
        "00:03:2A": "UniData Communication Systems, Inc.",
        "00:02:BF": "dotRocket, Inc.",
        "00:03:17": "Merlin Systems, Inc.",
        "00:03:18": "Cyras Systems, Inc.",
        "00:02:E3": "LITE-ON Communications, Inc.",
        "00:02:DD": "Bromax Communications, Ltd.",
        "00:02:47": "Great Dragon Information Technology (Group) Co., Ltd.",
        "00:02:43": "Raysis Co., Ltd.",
        "00:02:31": "Ingersoll-Rand",
        "00:02:66": "Thermalogic Corporation",
        "00:02:68": "Harris Government Communications",
        "00:02:5E": "High Technology Ltd",
        "00:02:60": "Accordion Networks, Inc.",
        "00:02:83": "Spectrum Controls, Inc.",
        "00:02:84": "UK Grid Solutions Limited",
        "00:02:80": "Mu Net, Inc.",
        "00:90:64": "Thomson Inc.",
        "00:02:7A": "IOI Technology Corporation",
        "00:02:74": "Tommy Technologies Corp.",
        "00:02:9E": "Information Equipment Co., Ltd.",
        "00:02:9B": "Kreatel Communications AB",
        "00:02:95": "IP.Access Limited",
        "00:02:72": "CC&C Technologies, Inc.",
        "00:02:6D": "Adept Telecom",
        "00:02:6B": "BCM Computers Co., Ltd.",
        "00:02:93": "Solid Data Systems",
        "00:02:89": "DNE Technologies",
        "00:01:2F": "Twinhead International Corp",
        "00:02:A7": "Vivace Networks",
        "00:01:B2": "Digital Processing Systems, Inc.",
        "00:01:B8": "Netsensity, Inc.",
        "00:01:B9": "SKF (U.K.) Limited",
        "00:01:B3": "Precision Electronic Manufacturing",
        "00:01:BD": "Peterson Electro-Musical Products, Inc.",
        "00:02:09": "Shenzhen SED Information Technology Co., Ltd.",
        "00:02:02": "Amino Communications, Ltd.",
        "00:02:01": "IFM Electronic gmbh",
        "00:02:34": "Imperial Technology, Inc.",
        "00:02:36": "INIT GmbH",
        "00:02:2B": "SAXA, Inc.",
        "00:02:24": "C-COR",
        "00:02:1F": "Aculab PLC",
        "00:02:1A": "Zuma Networks",
        "00:01:CA": "Geocast Network Systems, Inc.",
        "00:01:D1": "CoNet Communications, Inc.",
        "00:02:22": "Chromisys, Inc.",
        "00:02:13": "S.D.E.L.",
        "00:01:DB": "Freecom Technologies GmbH",
        "00:01:DF": "ISDN Communications, Ltd.",
        "00:01:EF": "Camtel Technology Corp.",
        "00:02:0A": "Gefran Spa",
        "00:02:06": "Telital R&D Denmark A/S",
        "00:01:79": "WIRELESS TECHNOLOGY, INC.",
        "00:01:60": "ELMEX Co., LTD.",
        "00:01:4E": "WIN Enterprises, Inc.",
        "00:30:73": "International Microsystems, In",
        "00:30:3F": "TurboComm Tech Inc.",
        "00:01:84": "SIEB & MEYER AG",
        "00:01:95": "Sena Technologies, Inc.",
        "00:01:A4": "Microlink Corporation",
        "00:01:8E": "Logitec Corporation",
        "00:01:6D": "CarrierComm Inc.",
        "00:01:6F": "Inkel Corp.",
        "00:01:70": "ESE Embedded System Engineer'g",
        "00:01:6A": "ALITEC",
        "00:01:53": "ARCHTEK TELECOM CORPORATION",
        "00:01:35": "KDC Corp.",
        "00:01:41": "CABLE PRINT",
        "00:01:65": "AirSwitch Corporation",
        "00:01:56": "FIREWIREDIRECT.COM, INC.",
        "00:01:B7": "Centos, Inc.",
        "00:01:B5": "Turin Networks, Inc.",
        "00:01:83": "ANITE TELECOMS",
        "00:01:7E": "ADTEK System Science Co., Ltd.",
        "00:01:0C": "System Talks Inc.",
        "00:01:11": "iDigm Inc.",
        "00:01:07": "Leiser GmbH",
        "00:01:14": "KANDA TSUSHIN KOGYO CO., LTD.",
        "00:B0:F5": "NetWorth Technologies, Inc.",
        "00:B0:DB": "Nextcell, Inc.",
        "00:B0:AE": "Symmetricom",
        "00:B0:E7": "British Federal Ltd.",
        "00:B0:8E": "Cisco Systems, Inc",
        "00:30:5C": "SMAR Laboratories Corp.",
        "00:30:04": "LEADTEK RESEARCH INC.",
        "00:30:F9": "Sollae Systems Co., Ltd.",
        "00:01:18": "EZ Digital Co., Ltd.",
        "00:01:1C": "Universal Talkware Corporation",
        "00:01:28": "EnjoyWeb, Inc.",
        "00:01:46": "Tesco Controls, Inc.",
        "00:01:49": "TDT AG",
        "00:01:31": "Bosch Security Systems, Inc.",
        "00:30:BE": "City-Net Technology, Inc.",
        "00:30:02": "Expand Networks",
        "00:30:78": "Cisco Systems, Inc",
        "00:B0:EC": "EACEM",
        "00:B0:DF": "Starboard Storage Systems",
        "00:01:0B": "Space CyberLink, Inc.",
        "00:30:9C": "Timing Applications, Inc.",
        "00:30:7E": "Redflex Communication Systems",
        "00:30:4F": "PLANET Technology Corporation",
        "00:30:22": "Fong Kai Industrial Co., Ltd.",
        "00:30:70": "1Net Corporation",
        "00:30:F8": "Dynapro Systems, Inc.",
        "00:30:B7": "Teletrol Systems, Inc.",
        "00:30:B3": "San Valley Systems, Inc.",
        "00:30:09": "Tachion Networks, Inc.",
        "00:30:7A": "Advanced Technology & Systems",
        "00:30:61": "MobyTEL",
        "00:30:0B": "mPHASE Technologies, Inc.",
        "00:30:8F": "MICRILOR, Inc.",
        "00:30:50": "Versa Technology",
        "00:30:C0": "Lara Technology, Inc.",
        "00:30:05": "Fujitsu Siemens Computers",
        "00:30:E0": "OXFORD SEMICONDUCTOR LTD.",
        "00:30:64": "ADLINK TECHNOLOGY, INC.",
        "00:30:DB": "Mindready Solutions, Inc.",
        "00:30:E7": "CNF MOBILE SOLUTIONS, INC.",
        "00:30:B4": "INTERSIL CORP.",
        "00:30:B1": "TrunkNet",
        "00:30:60": "Powerfile, Inc.",
        "00:30:A0": "TYCO SUBMARINE SYSTEMS, LTD.",
        "00:30:15": "CP CLARE CORP.",
        "00:30:1F": "OPTICAL NETWORKS, INC.",
        "00:30:FA": "TELICA, INC.",
        "00:30:4B": "ORBACOM SYSTEMS, INC.",
        "00:30:E9": "GMA COMMUNICATION MANUFACT'G",
        "00:30:A5": "ACTIVE POWER",
        "00:30:84": "ALLIED TELESYN INTERNAIONAL",
        "00:30:43": "IDREAM TECHNOLOGIES, PTE. LTD.",
        "00:30:00": "ALLWELL TECHNOLOGY CORP.",
        "00:30:11": "HMS Industrial Networks   ",
        "00:30:68": "CYBERNETICS TECH. CO., LTD.",
        "00:30:91": "TAIWAN FIRST LINE ELEC. CORP.",
        "00:30:CD": "CONEXANT SYSTEMS, INC.",
        "00:30:1A": "SMARTBRIDGES PTE. LTD.",
        "00:30:29": "OPICOM",
        "00:30:83": "Ivron Systems",
        "00:30:B6": "Cisco Systems, Inc",
        "00:30:C7": "Macromate Corp.",
        "00:30:E4": "CHIYODA SYSTEM RIKEN",
        "00:30:66": "RFM",
        "00:30:31": "LIGHTWAVE COMMUNICATIONS, INC.",
        "00:D0:07": "MIC ASSOCIATES, INC.",
        "00:D0:FF": "Cisco Systems, Inc",
        "00:D0:28": "Harmonic, Inc",
        "00:D0:25": "XROSSTECH, INC.",
        "00:D0:44": "ALIDIAN NETWORKS, INC.",
        "00:30:5B": "Toko Inc.",
        "00:D0:49": "IMPRESSTEK CO., LTD.",
        "00:D0:5B": "ACROLOOP MOTION CONTROL",
        "00:D0:42": "MAHLO GMBH & CO. UG",
        "00:D0:31": "INDUSTRIAL LOGIC CORPORATION",
        "00:D0:38": "FIVEMERE, LTD.",
        "00:D0:C6": "THOMAS & BETTS CORP.",
        "00:D0:77": "LUCENT TECHNOLOGIES",
        "00:D0:3E": "ROCKETCHIPS, INC.",
        "00:D0:93": "TQ - COMPONENTS GMBH",
        "00:D0:3F": "AMERICAN COMMUNICATION",
        "00:D0:F7": "NEXT NETS CORPORATION",
        "00:D0:6F": "KMC CONTROLS",
        "00:D0:FC": "GRANITE MICROSYSTEMS",
        "00:D0:A6": "LANBIRD TECHNOLOGY CO., LTD.",
        "00:D0:03": "COMDA ENTERPRISES CORP.",
        "00:D0:D2": "EPILOG CORPORATION",
        "00:D0:F9": "ACUTE COMMUNICATIONS CORP.",
        "00:D0:CE": "iSystem Labs ",
        "00:D0:18": "QWES. COM, INC.",
        "00:01:A7": "UNEX TECHNOLOGY CORPORATION",
        "00:D0:8C": "GENOA TECHNOLOGY, INC.",
        "00:D0:59": "AMBIT MICROSYSTEMS CORP.",
        "00:D0:FD": "OPTIMA TELE.COM, INC.",
        "00:D0:A9": "SHINANO KENSHI CO., LTD.",
        "00:D0:DD": "SUNRISE TELECOM, INC.",
        "00:D0:E6": "IBOND INC.",
        "00:D0:D1": "Sycamore Networks",
        "00:D0:87": "MICROFIRST INC.",
        "00:D0:80": "EXABYTE CORPORATION",
        "00:D0:91": "SMARTSAN SYSTEMS, INC.",
        "00:D0:4E": "LOGIBAG",
        "00:D0:27": "APPLIED AUTOMATION, INC.",
        "00:D0:72": "BROADLOGIC",
        "00:D0:E2": "MRT MICRO, INC.",
        "00:D0:6A": "LINKUP SYSTEMS CORPORATION",
        "00:D0:89": "DYNACOLOR, INC.",
        "00:D0:2C": "CAMPBELL SCIENTIFIC, INC.",
        "00:D0:CD": "ATAN TECHNOLOGY INC.",
        "00:D0:40": "SYSMATE CO., LTD.",
        "00:D0:1A": "URMET  TLC S.P.A.",
        "00:50:FF": "HAKKO ELECTRONICS CO., LTD.",
        "00:50:D2": "CMC Electronics Inc",
        "00:50:F9": "Sensormatic Electronics LLC",
        "00:50:48": "INFOLIBRIA",
        "00:50:4E": "SIERRA MONITOR CORP.",
        "00:50:F6": "PAN-INTERNATIONAL INDUSTRIAL CORP.",
        "00:50:6C": "Beijer Electronics Products AB",
        "00:50:D7": "TELSTRAT",
        "00:50:44": "ASACA CORPORATION",
        "00:50:E6": "HAKUSAN CORPORATION",
        "00:50:3C": "TSINGHUA NOVEL ELECTRONICS",
        "00:50:60": "TANDBERG TELECOM AS",
        "00:50:EE": "TEK DIGITEL CORPORATION",
        "00:50:45": "RIOWORKS SOLUTIONS, INC.",
        "00:50:2B": "GENRAD LTD.",
        "00:50:2E": "CAMBEX CORPORATION",
        "00:50:6E": "CORDER ENGINEERING CORPORATION",
        "00:50:2C": "SOYO COMPUTER, INC.",
        "00:50:77": "PROLIFIC TECHNOLOGY, INC.",
        "00:50:33": "MAYAN NETWORKS",
        "00:50:0E": "CHROMATIS NETWORKS, INC.",
        "00:D0:CC": "TECHNOLOGIES LYRE INC.",
        "00:50:EC": "OLICOM A/S",
        "00:50:C9": "MASPRO DENKOH CORP.",
        "00:50:BB": "CMS TECHNOLOGIES",
        "00:50:62": "KOUWELL ELECTRONICS CORP.  **",
        "00:50:D5": "AD SYSTEMS CORP.",
        "00:50:F3": "GLOBAL NET INFORMATION CO., Ltd.",
        "00:50:BE": "FAST MULTIMEDIA AG",
        "00:50:6F": "G-CONNECT",
        "00:50:F8": "ENTREGA TECHNOLOGIES, INC.",
        "00:50:42": "SCI MANUFACTURING SINGAPORE PTE, LTD.",
        "00:50:C0": "GATAN, INC.",
        "00:50:51": "IWATSU ELECTRIC CO., LTD.",
        "00:50:7D": "IFP",
        "00:50:97": "MMC-EMBEDDED COMPUTERTECHNIK GmbH",
        "00:50:10": "NovaNET Learning, Inc.",
        "00:50:9A": "TAG ELECTRONIC SYSTEMS",
        "00:50:22": "ZONET TECHNOLOGY, INC.",
        "00:50:07": "SIEMENS TELECOMMUNICATION SYSTEMS LIMITED",
        "00:50:40": "Panasonic Electric Works Co., Ltd.",
        "00:50:1C": "JATOM SYSTEMS, INC.",
        "00:50:92": "Rigaku Corporation Osaka Plant",
        "00:50:7A": "XPEED, INC.",
        "00:50:69": "PixStream Incorporated",
        "00:50:68": "ELECTRONIC INDUSTRIES ASSOCIATION",
        "00:50:BC": "HAMMER STORAGE SOLUTIONS",
        "00:90:71": "Applied Innovation Inc.",
        "00:50:EB": "ALPHA-TOP CORPORATION",
        "00:50:EF": "SPE Systemhaus GmbH",
        "00:50:98": "GLOBALOOP, LTD.",
        "00:50:4F": "OLENCOM ELECTRONICS",
        "00:90:FF": "TELLUS TECHNOLOGY INC.",
        "00:90:3E": "N.V. PHILIPS INDUSTRIAL ACTIVITIES",
        "00:90:BA": "VALID NETWORKS, INC.",
        "00:90:18": "ITO ELECTRIC INDUSTRY CO, LTD.",
        "00:90:CD": "ENT-EMPRESA NACIONAL DE TELECOMMUNICACOES, S.A.",
        "00:90:FB": "PORTWELL, INC.",
        "00:90:94": "OSPREY TECHNOLOGIES, INC.",
        "00:90:B3": "AGRANAT SYSTEMS",
        "00:90:3C": "ATLANTIC NETWORK SYSTEMS",
        "00:90:5D": "NETCOM SICHERHEITSTECHNIK GMBH",
        "00:90:D1": "LEICHU ENTERPRISE CO., LTD.",
        "00:90:46": "DEXDYNE, LTD.",
        "00:90:DA": "DYNARC, INC.",
        "00:90:E0": "SYSTRAN CORP.",
        "00:90:D0": "Thomson Telecom Belgium",
        "00:90:9B": "MARKEM-IMAJE",
        "00:90:22": "IVEX",
        "00:90:16": "ZAC",
        "00:90:A7": "CLIENTEC CORPORATION",
        "00:90:53": "DAEWOO ELECTRONICS CO., LTD.",
        "00:90:DC": "TECO INFORMATION SYSTEMS",
        "00:90:E2": "DISTRIBUTED PROCESSING TECHNOLOGY",
        "00:90:85": "GOLDEN ENTERPRISES, INC.",
        "00:90:C7": "ICOM INC.",
        "00:90:35": "ALPHA TELECOM, INC.",
        "00:90:0F": "KAWASAKI HEAVY INDUSTRIES, LTD",
        "00:90:EA": "ALPHA TECHNOLOGIES, INC.",
        "00:90:77": "ADVANCED FIBRE COMMUNICATIONS",
        "00:90:99": "ALLIED TELESIS, K.K.",
        "00:10:AD": "SOFTRONICS USB, INC.",
        "00:10:A7": "UNEX TECHNOLOGY CORPORATION",
        "00:10:D5": "IMASDE CANARIAS, S.A.",
        "00:10:55": "FUJITSU MICROELECTRONICS, INC.",
        "00:90:7A": "Spectralink, Inc",
        "00:90:F0": "Harmonic Video Systems Ltd.",
        "00:90:20": "PHILIPS ANALYTICAL X-RAY B.V.",
        "00:10:A3": "OMNITRONIX, INC.",
        "00:90:5C": "EDMI",
        "00:90:E3": "AVEX ELECTRONICS INC.",
        "00:90:A9": "WESTERN DIGITAL",
        "00:90:F3": "ASPECT COMMUNICATIONS",
        "00:90:4F": "ABB POWER T&D COMPANY, INC.",
        "00:90:60": "SYSTEM CREATE CORP.",
        "00:90:13": "SAMSAN CORP.",
        "00:10:52": "METTLER-TOLEDO (ALBSTADT) GMBH",
        "00:10:6B": "SONUS NETWORKS, INC.",
        "00:10:C3": "CSI-CONTROL SYSTEMS",
        "00:90:55": "PARKER HANNIFIN CORPORATION COMPUMOTOR DIVISION",
        "00:10:DD": "ENABLE SEMICONDUCTOR, INC.",
        "00:10:2D": "HITACHI SOFTWARE ENGINEERING",
        "00:10:33": "ACCESSLAN COMMUNICATIONS, INC.",
        "00:10:12": "PROCESSOR SYSTEMS (I) PVT LTD",
        "00:10:15": "OOmon Inc.",
        "00:10:78": "NUERA COMMUNICATIONS, INC.",
        "00:10:4F": "Oracle Corporation ",
        "00:10:7A": "AmbiCom, Inc.",
        "00:10:B9": "MAXTOR CORP.",
        "00:10:5D": "Draeger Medical",
        "00:10:91": "NO WIRES NEEDED BV",
        "00:10:1B": "CORNET TECHNOLOGY, INC.",
        "00:10:DC": "MICRO-STAR INTERNATIONAL CO., LTD.",
        "00:10:0A": "WILLIAMS COMMUNICATIONS GROUP",
        "00:10:32": "ALTA TECHNOLOGY",
        "00:10:80": "METAWAVE COMMUNICATIONS",
        "00:10:F4": "Vertical Communications",
        "00:10:77": "SAF DRIVE SYSTEMS, LTD.",
        "00:10:B3": "NOKIA MULTIMEDIA TERMINALS",
        "00:10:1E": "MATSUSHITA ELECTRONIC INSTRUMENTS CORP.",
        "00:10:4D": "SURTEC INDUSTRIES, INC.",
        "00:10:51": "CMICRO CORPORATION",
        "00:10:37": "CYQ've Technology Co., Ltd.",
        "00:E0:BB": "NBX CORPORATION",
        "00:E0:8A": "GEC AVERY, LTD.",
        "00:E0:86": "Emerson Network Power, Avocent Division",
        "00:E0:1B": "SPHERE COMMUNICATIONS, INC.",
        "00:E0:59": "CONTROLLED ENVIRONMENTS, LTD.",
        "00:E0:C5": "BCOM ELECTRONICS INC.",
        "00:E0:EE": "MAREL HF",
        "00:E0:8E": "UTSTARCOM",
        "00:E0:3F": "JATON CORPORATION",
        "00:E0:D4": "EXCELLENT COMPUTER",
        "00:E0:7F": "LOGISTISTEM s.r.l.",
        "00:E0:13": "EASTERN ELECTRONIC CO., LTD.",
        "00:E0:FD": "A-TREND TECHNOLOGY CO., LTD.",
        "00:E0:BD": "INTERFACE SYSTEMS, INC.",
        "00:E0:6E": "FAR SYSTEMS S.p.A.",
        "00:E0:6D": "COMPUWARE CORPORATION",
        "00:E0:EA": "INNOVAT COMMUNICATIONS, INC.",
        "00:E0:64": "SAMSUNG ELECTRONICS",
        "00:E0:C9": "AutomatedLogic Corporation",
        "00:E0:38": "PROXIMA CORPORATION",
        "00:E0:9C": "MII",
        "00:E0:E9": "DATA LABS, INC.",
        "00:E0:0C": "MOTOROLA",
        "00:E0:0A": "DIBA, INC.",
        "00:E0:C4": "HORNER ELECTRIC, INC.",
        "00:E0:69": "JAYCOR",
        "00:E0:A4": "ESAOTE S.p.A.",
        "00:E0:DE": "DATAX NV",
        "00:E0:A5": "ComCore Semiconductor, Inc.",
        "00:E0:15": "HEIWA CORPORATION",
        "00:E0:E8": "GRETACODER Data Systems AG",
        "00:E0:16": "RAPID CITY COMMUNICATIONS",
        "00:E0:05": "TECHNICAL CORP.",
        "00:E0:C1": "MEMOREX TELEX JAPAN, LTD.",
        "00:E0:A9": "FUNAI ELECTRIC CO., LTD.",
        "00:E0:84": "COMPULITE R&D",
        "00:E0:96": "SHIMADZU CORPORATION",
        "00:E0:17": "EXXACT GmbH",
        "00:60:7F": "AURORA TECHNOLOGIES, INC.",
        "00:E0:29": "STANDARD MICROSYSTEMS CORP.",
        "00:60:74": "QSC LLC",
        "00:60:76": "SCHLUMBERGER TECHNOLOGIES RETAIL PETROLEUM SYSTEMS",
        "00:60:A1": "VPNet, Inc.",
        "00:60:27": "Superior Modular Products",
        "00:60:BC": "KeunYoung Electronics & Communication Co., Ltd.",
        "00:60:A5": "PERFORMANCE TELECOM CORP.",
        "00:60:05": "FEEDBACK DATA LTD.",
        "00:60:2E": "CYCLADES CORPORATION",
        "00:60:B6": "LAND COMPUTER CO., LTD.",
        "00:60:6C": "ARESCOM",
        "00:60:E3": "ARBIN INSTRUMENTS",
        "00:60:71": "MIDAS LAB, INC.",
        "00:60:61": "WHISTLE COMMUNICATIONS CORP.",
        "00:60:1B": "MESA ELECTRONICS",
        "00:60:C5": "ANCOT CORP.",
        "00:60:A9": "GESYTEC MBH",
        "00:60:F2": "LASERGRAPHICS, INC.",
        "00:60:C3": "NETVISION CORPORATION",
        "00:60:29": "CARY PERIPHERALS INC.",
        "00:60:A8": "TIDOMAT AB",
        "00:60:FC": "CONSERVATION THROUGH INNOVATION LTD.",
        "00:60:18": "STELLAR ONE CORPORATION",
        "00:60:0A": "SORD COMPUTER CORPORATION",
        "00:60:A4": "GEW Technologies (PTY)Ltd",
        "00:60:64": "NETCOMM LIMITED",
        "00:60:F9": "DIAMOND LANE COMMUNICATIONS",
        "00:60:EA": "StreamLogic",
        "00:60:82": "NOVALINK TECHNOLOGIES, INC.",
        "00:60:E7": "RANDATA",
        "00:60:D9": "TRANSYS NETWORKS INC.",
        "00:60:1F": "STALLION TECHNOLOGIES",
        "00:60:54": "CONTROLWARE GMBH",
        "00:60:C2": "MPL AG",
        "00:60:D4": "ELDAT COMMUNICATION LTD.",
        "00:A0:4E": "VOELKER TECHNOLOGIES, INC.",
        "00:A0:5A": "KOFAX IMAGE PRODUCTS",
        "00:A0:52": "STANILITE ELECTRONICS PTY. LTD",
        "00:A0:5E": "MYRIAD LOGIC INC.",
        "00:A0:95": "ACACIA NETWORKS, INC.",
        "00:A0:53": "COMPACT DEVICES, INC.",
        "00:A0:69": "Symmetricom, Inc.",
        "00:A0:7A": "ADVANCED PERIPHERALS TECHNOLOGIES, INC.",
        "00:60:9B": "AstroNova, Inc",
        "00:60:DB": "NTP ELEKTRONIK A/S",
        "00:60:52": "PERIPHERALS ENTERPRISE CO., Ltd.",
        "00:60:B2": "PROCESS CONTROL CORP.",
        "00:60:81": "TV/COM INTERNATIONAL",
        "00:A0:05": "DANIEL INSTRUMENTS, LTD.",
        "00:A0:F2": "INFOTEK COMMUNICATIONS, INC.",
        "00:A0:DF": "STS TECHNOLOGIES, INC.",
        "00:A0:94": "COMSAT CORPORATION",
        "00:A0:EF": "LUCIDATA LTD.",
        "00:A0:20": "CITICORP/TTI",
        "00:A0:CE": "Ecessa",
        "00:A0:28": "CONNER PERIPHERALS",
        "00:A0:9E": "ICTV",
        "00:A0:99": "K-NET LTD.",
        "00:A0:EC": "TRANSMITTON LTD.",
        "00:A0:67": "NETWORK SERVICES GROUP",
        "00:A0:E0": "TENNYSON TECHNOLOGIES PTY LTD",
        "00:A0:FD": "SCITEX DIGITAL PRINTING, INC.",
        "00:A0:0F": "Broadband Technologies",
        "00:A0:02": "LEEDS & NORTHRUP AUSTRALIA PTY LTD",
        "00:A0:E4": "OPTIQUEST",
        "00:A0:EE": "NASHOBA NETWORKS",
        "00:A0:C3": "UNICOMPUTER GMBH",
        "00:A0:0A": "Airspan",
        "00:A0:E7": "CENTRAL DATA CORPORATION",
        "00:A0:80": "Tattile SRL ",
        "00:A0:2B": "TRANSITIONS RESEARCH CORP.",
        "00:A0:E8": "REUTERS HOLDINGS PLC",
        "00:A0:08": "NETCORP",
        "00:A0:50": "CYPRESS SEMICONDUCTOR",
        "00:A0:DD": "AZONIX CORPORATION",
        "00:A0:75": "MICRON TECHNOLOGY, INC.",
        "00:A0:09": "WHITETREE NETWORK",
        "00:A0:0C": "KINGMAX TECHNOLOGY, INC.",
        "00:A0:66": "ISA CO., LTD.",
        "00:A0:AB": "NETCS INFORMATIONSTECHNIK GMBH",
        "00:A0:D8": "SPECTRA - TEK",
        "00:A0:FA": "Marconi Communication GmbH",
        "00:A0:CB": "ARK TELECOMMUNICATIONS, INC.",
        "00:A0:34": "AXEL",
        "00:A0:01": "DRS Signal Solutions",
        "00:20:B2": "GKD Gesellschaft Fur Kommunikation Und Datentechnik",
        "00:20:52": "RAGULA SYSTEMS",
        "00:20:FC": "MATROX",
        "00:20:FE": "TOPWARE INC. / GRAND COMPUTER",
        "00:20:73": "FUSION SYSTEMS CORPORATION",
        "00:20:35": "IBM Corp",
        "00:A0:17": "J B M CORPORATION",
        "00:A0:25": "REDCOM LABS INC.",
        "00:A0:BB": "HILAN GMBH",
        "00:A0:91": "APPLICOM INTERNATIONAL",
        "00:A0:A5": "TEKNOR MICROSYSTEME, INC.",
        "00:20:B7": "NAMAQUA COMPUTERWARE",
        "00:20:E3": "MCD KENCOM CORPORATION",
        "00:20:13": "DIVERSIFIED TECHNOLOGY, INC.",
        "00:20:AB": "MICRO INDUSTRIES CORP.",
        "00:20:8D": "CMD TECHNOLOGY",
        "00:20:DD": "Cybertec Pty Ltd",
        "00:20:E6": "LIDKOPING MACHINE TOOLS AB",
        "00:20:86": "MICROTECH ELECTRONICS LIMITED",
        "00:20:23": "T.C. TECHNOLOGIES PTY. LTD",
        "00:A0:54": "Private",
        "00:20:5A": "COMPUTER IDENTICS",
        "00:20:00": "LEXMARK INTERNATIONAL, INC.",
        "00:20:1D": "KATANA PRODUCTS",
        "00:20:03": "PIXEL POWER LTD.",
        "00:20:46": "CIPRICO, INC.",
        "00:20:9B": "ERSAT ELECTRONIC GMBH",
        "00:20:1C": "EXCEL, INC.",
        "00:20:7F": "KYOEI SANGYO CO., LTD.",
        "00:20:C9": "VICTRON BV",
        "00:20:77": "KARDIOS SYSTEMS CORP.",
        "00:20:7A": "WiSE Communications, Inc.",
        "00:20:3E": "LogiCan Technologies, Inc.",
        "00:20:58": "ALLIED SIGNAL INC.",
        "00:20:E1": "ALAMAR ELECTRONICS",
        "00:20:26": "AMKLY SYSTEMS, INC.",
        "00:20:65": "SUPERNET NETWORKING INC.",
        "00:20:2A": "N.V. DZINE",
        "00:20:83": "PRESTICOM INCORPORATED",
        "00:20:19": "OHLER GMBH",
        "00:20:9E": "BROWN'S OPERATING SYSTEM SERVICES, LTD.",
        "00:20:8E": "CHEVIN SOFTWARE ENG. LTD.",
        "00:20:97": "APPLIED SIGNAL TECHNOLOGY",
        "00:C0:0B": "NORCONTROL A.S.",
        "00:20:B0": "GATEWAY DEVICES, INC.",
        "00:20:5B": "Kentrox, LLC",
        "00:20:F6": "NET TEK  AND KARLNET, INC.",
        "00:20:C6": "NECTEC",
        "00:20:08": "CABLE & COMPUTER TECHNOLOGY",
        "00:20:D3": "OST (OUEST STANDARD TELEMATIQU",
        "00:C0:0E": "PSITECH, INC.",
        "00:C0:31": "DESIGN RESEARCH SYSTEMS, INC.",
        "00:07:01": "RACAL-DATACOM",
        "00:C0:9C": "HIOKI E.E. CORPORATION",
        "00:C0:AA": "SILICON VALLEY COMPUTER",
        "00:C0:66": "DOCUPOINT, INC.",
        "00:C0:2D": "FUJI PHOTO FILM CO., LTD.",
        "00:C0:F2": "TRANSITION NETWORKS",
        "00:C0:BD": "INEX TECHNOLOGIES, INC.",
        "00:C0:88": "EKF ELEKTRONIK GMBH",
        "00:C0:11": "INTERACTIVE COMPUTING DEVICES",
        "00:C0:3E": "FA. GEBR. HELLER GMBH",
        "00:C0:FD": "PROSUM",
        "00:C0:14": "TELEMATICS CALABASAS INT'L,INC",
        "00:AA:3C": "OLIVETTI TELECOM SPA (OLTECO)",
        "00:C0:C9": "ELSAG BAILEY PROCESS",
        "00:C0:48": "BAY TECHNICAL ASSOCIATES",
        "00:C0:76": "I-DATA INTERNATIONAL A-S",
        "00:C0:46": "Blue Chip Technology Ltd",
        "00:C0:97": "ARCHIPEL SA",
        "00:C0:04": "JAPAN BUSINESS COMPUTER CO.LTD",
        "00:C0:60": "ID SCANDINAVIA AS",
        "00:40:CC": "SILCOM MANUF'G TECHNOLOGY INC.",
        "00:C0:9E": "CACHE COMPUTERS, INC.",
        "00:C0:AC": "GAMBIT COMPUTER COMMUNICATIONS",
        "00:C0:34": "TRANSACTION NETWORK",
        "00:C0:93": "ALTA RESEARCH CORP.",
        "00:40:E7": "ARNOS INSTRUMENTS & COMPUTER",
        "00:40:87": "UBITREX CORPORATION",
        "00:40:07": "TELMAT INFORMATIQUE",
        "00:40:7B": "SCIENTIFIC ATLANTA",
        "00:40:2C": "ISIS DISTRIBUTED SYSTEMS, INC.",
        "00:C0:DF": "KYE Systems Corp.",
        "00:C0:F5": "METACOMP, INC.",
        "00:C0:91": "JABIL CIRCUIT, INC.",
        "00:C0:49": "U.S. ROBOTICS, INC.",
        "00:C0:9D": "DISTRIBUTED SYSTEMS INT'L, INC",
        "00:C0:E9": "OAK SOLUTIONS, LTD.",
        "00:C0:C5": "SID INFORMATICA",
        "00:C0:51": "ADVANCED INTEGRATION RESEARCH",
        "00:C0:85": "ELECTRONICS FOR IMAGING, INC.",
        "00:C0:B2": "NORAND CORPORATION",
        "00:C0:54": "NETWORK PERIPHERALS, LTD.",
        "00:C0:22": "LASERMASTER TECHNOLOGIES, INC.",
        "00:C0:25": "DATAPRODUCTS CORPORATION",
        "00:40:CF": "STRAWBERRY TREE, INC.",
        "00:40:77": "MAXTON TECHNOLOGY CORPORATION",
        "00:C0:2C": "CENTRUM COMMUNICATIONS, INC.",
        "00:C0:FB": "ADVANCED TECHNOLOGY LABS",
        "00:C0:2B": "GERLOFF GESELLSCHAFT FUR",
        "00:40:74": "CABLE AND WIRELESS",
        "00:40:B8": "IDEA ASSOCIATES",
        "00:40:E8": "CHARLES RIVER DATA SYSTEMS,INC",
        "00:40:C0": "VISTA CONTROLS CORPORATION",
        "00:C0:A0": "ADVANCE MICRO RESEARCH, INC.",
        "00:C0:10": "HIRAKAWA HEWTECH CORP.",
        "00:C0:37": "DYNATEM",
        "00:40:83": "TDA INDUSTRIA DE PRODUTOS",
        "00:40:5B": "FUNASSET LIMITED",
        "00:40:73": "BASS ASSOCIATES",
        "00:40:7D": "EXTENSION TECHNOLOGY CORP.",
        "00:80:D7": "Fantum Engineering",
        "00:80:7A": "AITECH SYSTEMS LTD.",
        "00:80:DC": "PICKER INTERNATIONAL",
        "00:40:4D": "TELECOMMUNICATIONS TECHNIQUES",
        "00:40:0D": "LANNET DATA COMMUNICATIONS,LTD",
        "00:40:19": "AEON SYSTEMS, INC.",
        "00:40:BE": "BOEING DEFENSE & SPACE",
        "00:40:6E": "COROLLARY, INC.",
        "00:40:76": "Sun Conversion Technologies",
        "00:40:22": "KLEVER COMPUTERS, INC.",
        "00:40:BF": "CHANNEL SYSTEMS INTERN'L INC.",
        "00:40:1E": "ICC",
        "00:40:9A": "NETWORK EXPRESS, INC.",
        "00:40:94": "SHOGRAPHICS, INC.",
        "00:40:55": "METRONIX GMBH",
        "00:40:27": "SMC MASSACHUSETTS, INC.",
        "00:40:8B": "RAYLAN CORPORATION",
        "00:40:EF": "HYPERCOM, INC.",
        "00:40:93": "PAXDATA NETWORKS LTD.",
        "00:40:85": "SAAB INSTRUMENTS AB",
        "00:40:23": "LOGIC CORPORATION",
        "00:40:A4": "ROSE ELECTRONICS",
        "00:40:08": "A PLUS INFO CORPORATION",
        "00:40:B5": "VIDEO TECHNOLOGY COMPUTERS LTD",
        "00:40:12": "WINDATA, INC.",
        "00:40:D5": "Sartorius Mechatronics T&H GmbH ",
        "00:40:10": "SONIC SYSTEMS, INC.",
        "00:40:CA": "FIRST INTERNAT'L COMPUTER, INC",
        "00:40:C4": "KINKEI SYSTEM CORPORATION",
        "00:40:5D": "STAR-TEK, INC.",
        "00:40:E2": "MESA RIDGE TECHNOLOGIES, INC.",
        "00:40:8C": "AXIS COMMUNICATIONS AB",
        "00:40:45": "TWINHEAD CORPORATION",
        "00:40:28": "NETCOMM LIMITED",
        "00:40:DD": "HONG TECHNOLOGIES",
        "00:40:CB": "LANWAN TECHNOLOGIES",
        "00:40:B2": "SYSTEMFORSCHUNG",
        "00:40:E6": "C.A.E.N.",
        "00:40:F0": "MicroBrain,Inc.",
        "00:40:89": "MEIDENSHA CORPORATION",
        "00:40:15": "ASCOM INFRASYS AG",
        "00:80:95": "BASIC MERTON HANDELSGES.M.B.H.",
        "00:80:AE": "HUGHES NETWORK SYSTEMS",
        "00:80:3A": "VARITYPER, INC.",
        "00:80:1C": "NEWPORT SYSTEMS SOLUTIONS",
        "00:80:56": "SPHINX Electronics GmbH & Co KG",
        "00:80:31": "BASYS, CORP.",
        "00:80:DB": "GRAPHON CORPORATION",
        "00:80:82": "PEP MODULAR COMPUTERS GMBH",
        "00:80:39": "ALCATEL STC AUSTRALIA",
        "00:80:23": "INTEGRATED BUSINESS NETWORKS",
        "00:80:6B": "SCHMID TELECOMMUNICATION",
        "00:80:59": "STANLEY ELECTRIC CO., LTD",
        "00:80:41": "VEB KOMBINAT ROBOTRON",
        "00:80:80": "DATAMEDIA CORPORATION",
        "00:80:3F": "TATUNG COMPANY",
        "00:80:E6": "PEER NETWORKS, INC.",
        "00:80:E0": "XTP SYSTEMS, INC.",
        "00:80:88": "VICTOR COMPANY OF JAPAN, LTD.",
        "00:80:D8": "NETWORK PERIPHERALS INC.",
        "00:80:9E": "DATUS GMBH",
        "00:80:2B": "INTEGRATED MARKETING CO",
        "00:80:01": "PERIPHONICS CORPORATION",
        "00:80:97": "CENTRALP AUTOMATISMES",
        "00:80:71": "SAI TECHNOLOGY",
        "00:80:98": "TDK CORPORATION",
        "00:80:CA": "NETCOM RESEARCH INCORPORATED",
        "00:80:D5": "CADRE TECHNOLOGIES",
        "00:80:1B": "KODIAK TECHNOLOGY",
        "00:80:D3": "SHIVA CORP.",
        "00:80:B3": "AVAL DATA CORPORATION",
        "00:80:20": "NETWORK PRODUCTS",
        "00:80:70": "COMPUTADORAS MICRON",
        "00:80:08": "DYNATECH COMPUTER SYSTEMS",
        "00:00:E4": "IN2 GROUPE INTERTECHNIQUE",
        "00:80:13": "THOMAS-CONRAD CORPORATION",
        "00:80:6E": "NIPPON STEEL CORPORATION",
        "00:80:10": "COMMODORE INTERNATIONAL",
        "00:80:47": "IN-NET CORP.",
        "00:80:67": "SQUARE D COMPANY",
        "00:80:45": "MATSUSHITA ELECTRIC IND. CO",
        "00:80:BF": "TAKAOKA ELECTRIC MFG. CO. LTD.",
        "00:80:F9": "HEURIKON CORPORATION",
        "00:80:A1": "MICROTEST, INC.",
        "00:80:A9": "CLEARPOINT RESEARCH",
        "00:80:17": "PFU LIMITED",
        "00:80:F8": "MIZAR, INC.",
        "00:00:14": "NETRONIX",
        "00:00:72": "MINIWARE TECHNOLOGY",
        "00:00:A1": "MARQUETTE ELECTRIC CO.",
        "00:00:F5": "DIAMOND SALES LIMITED",
        "00:00:5C": "TELEMATICS INTERNATIONAL INC.",
        "00:00:AC": "CONWARE COMPUTER CONSULTING",
        "00:00:94": "ASANTE TECHNOLOGIES",
        "00:00:90": "MICROCOM",
        "00:00:47": "NICOLET INSTRUMENTS CORP.",
        "00:00:21": "SUREMAN COMP. & COMMUN. CORP.",
        "00:00:30": "VG LABORATORY SYSTEMS LTD",
        "00:00:35": "SPECTRAGRAPHICS CORPORATION",
        "00:00:26": "SHA-KEN CO., LTD.",
        "00:00:B6": "MICRO-MATIC RESEARCH",
        "00:00:82": "LECTRA SYSTEMES SA",
        "00:00:2B": "CRISP AUTOMATION, INC",
        "00:00:51": "HOB ELECTRONIC GMBH & CO. KG",
        "00:00:A7": "NETWORK COMPUTING DEVICES INC.",
        "00:00:98": "CROSSCOMM CORPORATION",
        "00:00:C6": "EON SYSTEMS",
        "00:00:70": "HCL LIMITED",
        "00:00:8F": "Raytheon",
        "00:00:F1": "MAGNA COMPUTER CORPORATION",
        "00:00:54": "Schneider Electric",
        "00:00:20": "DATAINDUSTRIER DIAB AB",
        "00:00:7A": "DANA COMPUTER INC.",
        "00:00:45": "FORD AEROSPACE & COMM. CORP.",
        "00:00:9C": "ROLM MIL-SPEC COMPUTERS",
        "00:00:7C": "AMPERE INCORPORATED",
        "00:00:68": "ROSEMOUNT CONTROLS",
        "00:00:E9": "ISICAD, INC.",
        "00:00:9F": "AMERISTAR TECHNOLOGIES INC.",
        "00:00:E3": "INTEGRATED MICRO PRODUCTS LTD",
        "00:00:AD": "BRUKER INSTRUMENTS INC.",
        "00:00:74": "RICOH COMPANY LTD.",
        "00:00:46": "OLIVETTI NORTH AMERICA",
        "00:00:8D": "Cryptek Inc.",
        "00:00:3B": "i Controls, Inc.",
        "00:00:B3": "CIMLINC INCORPORATED",
        "00:00:D3": "WANG LABORATORIES INC.",
        "00:00:D0": "DEVELCON ELECTRONICS LTD.",
        "00:00:93": "PROTEON INC.",
        "00:00:8B": "INFOTRON",
        "08:00:57": "Evans & Sutherland",
        "08:00:5D": "GOULD INC.",
        "08:00:5B": "VTA TECHNOLOGIES INC.",
        "08:00:71": "MATRA (DSIE)",
        "08:00:6C": "SUNTEK TECHNOLOGY INT'L",
        "08:00:67": "ComDesign",
        "08:00:8C": "NETWORK RESEARCH CORPORATION",
        "08:00:81": "ASTECH INC.",
        "08:00:2D": "LAN-TEC INC.",
        "00:DD:00": "UNGERMANN-BASS INC.",
        "00:00:AA": "XEROX CORPORATION",
        "04:0A:E0": "XMIT AG COMPUTER NETWORKS",
        "08:00:11": "TEKTRONIX INC.",
        "08:00:26": "NORSK DATA A.S.",
        "08:00:25": "CONTROL DATA",
        "10:00:00": "Private",
        "00:00:D7": "DARTMOUTH COLLEGE",
        "AA:00:04": "DIGITAL EQUIPMENT CORPORATION",
        "08:00:0C": "MIKLYN DEVELOPMENT CO.",
        "00:DD:05": "UNGERMANN-BASS INC.",
        "08:00:1D": "ABLE COMMUNICATIONS INC.",
        "00:DD:0B": "UNGERMANN-BASS INC.",
        "08:00:03": "ADVANCED COMPUTER COMM.",
        "00:DD:03": "UNGERMANN-BASS INC.",
        "00:DD:0F": "UNGERMANN-BASS INC.",
        "00:00:01": "XEROX CORPORATION",
        "08:00:17": "NATIONAL SEMICONDUCTOR",
        "54:21:60": "Alula",
        "10:B3:C6": "Cisco Systems, Inc",
        "10:B3:D6": "Cisco Systems, Inc",
        "58:96:30": "Technicolor CH USA Inc.",
        "F8:54:B8": "Amazon Technologies Inc.",
        "78:17:35": "Nokia Shanghai Bell Co., Ltd.",
        "3C:89:4D": "Dr. Ing. h.c. F. Porsche AG",
        "84:C8:07": "ADVA Optical Networking Ltd.",
        "A0:AB:51": "WEIFANG GOERTEK ELECTRONICS CO.,LTD",
        "64:C9:01": "INVENTEC Corporation",
        "74:9E:F5": "Samsung Electronics Co.,Ltd",
        "68:BF:C4": "Samsung Electronics Co.,Ltd",
        "A8:5E:45": "ASUSTek COMPUTER INC.",
        "04:B1:A1": "Samsung Electronics Co.,Ltd",
        "CC:46:4E": "Samsung Electronics Co.,Ltd",
        "F8:89:3C": "Inventec Appliances Corp.",
        "A0:DF:15": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C4:AD:34": "Routerboard.com",
        "30:6F:07": "Nations Technologies Inc.",
        "24:74:F7": "GoPro",
        "7C:D5:66": "Amazon Technologies Inc.",
        "68:63:50": "Hella India Automotive Pvt Ltd",
        "5C:E5:0C": "Beijing Xiaomi Mobile Software Co., Ltd",
        "18:70:3B": "Huawei Device Co., Ltd.",
        "D8:9E:61": "Huawei Device Co., Ltd.",
        "34:7E:00": "Huawei Device Co., Ltd.",
        "00:30:92": "Kontron Electronics AG",
        "E8:5A:8B": "Xiaomi Communications Co Ltd",
        "44:22:95": "China Mobile Iot Limited company",
        "5C:71:0D": "Cisco Systems, Inc",
        "00:AB:48": "eero inc.",
        "F8:55:CD": "Visteon Corporation",
        "44:18:47": "HUNAN SCROWN ELECTRONIC INFORMATION TECH.CO.,LTD",
        "1C:C1:BC": "Yichip Microelectronics (Hangzhou) Co.,Ltd",
        "AC:61:B9": "WAMA Technology Limited",
        "C4:D8:F3": "iZotope",
        "00:30:56": "HMS Industrial Networks",
        "68:0A:E2": "Silicon Laboratories",
        "AC:8B:9C": "Primera Technology, Inc.",
        "2C:3A:FD": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "34:49:5B": "Sagemcom Broadband SAS",
        "C8:F3:19": "LG Electronics (Mobile Communications)",
        "80:16:09": "Sleep Number",
        "04:5E:A4": "SHENZHEN NETIS TECHNOLOGY CO.,LTD",
        "1C:BF:C0": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "78:B4:6A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "6C:EB:B6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "4C:F5:5B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E8:3F:67": "Huawei Device Co., Ltd.",
        "34:46:EC": "Huawei Device Co., Ltd.",
        "64:31:39": "IEEE Registration Authority",
        "A4:4B:D5": "Xiaomi Communications Co Ltd",
        "64:95:6C": "LG Electronics",
        "14:87:6A": "Apple, Inc.",
        "E0:B5:5F": "Apple, Inc.",
        "F8:FF:C2": "Apple, Inc.",
        "E0:EB:40": "Apple, Inc.",
        "64:69:4E": "Texas Instruments",
        "94:D6:DB": "NexFi",
        "B4:EC:F2": "Shanghai Listent Medical Tech Co., Ltd.",
        "40:77:A9": "New H3C Technologies Co., Ltd",
        "F8:33:31": "Texas Instruments",
        "C4:95:4D": "IEEE Registration Authority",
        "C4:98:78": "SHANGHAI MOAAN INTELLIGENT TECHNOLOGY CO.,LTD",
        "6C:63:9C": "ARRIS Group, Inc.",
        "A4:BB:6D": "Dell Inc.",
        "6C:06:D6": "Huawei Device Co., Ltd.",
        "0C:8E:29": "Arcadyan Corporation",
        "A0:22:4E": "IEEE Registration Authority",
        "38:43:E5": "Grotech Inc",
        "CC:59:3E": "Sensium Healthcare Limited",
        "5C:68:D0": "Aurora Innovation Inc.",
        "10:36:4A": "Boston Dynamics",
        "00:B8:10": "Yichip Microelectronics (Hangzhou) Co.,Ltd",
        "A4:B2:39": "Cisco Systems, Inc",
        "00:1B:B0": "Bharat Electronics Limited",
        "68:AF:FF": "Shanghai Cambricon Information Technology Co., Ltd.",
        "DC:21:E2": "HUAWEI TECHNOLOGIES CO.,LTD",
        "FC:1B:D1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "58:25:75": "HUAWEI TECHNOLOGIES CO.,LTD",
        "28:DE:E5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D0:1C:3C": "TECNO MOBILE LIMITED",
        "18:C0:4D": "GIGA-BYTE TECHNOLOGY CO.,LTD.",
        "8C:AA:B5": "Espressif Inc.",
        "40:2C:76": "IEEE Registration Authority",
        "44:C7:FC": "Huawei Device Co., Ltd.",
        "78:85:F4": "Huawei Device Co., Ltd.",
        "F4:49:55": "MIMO TECH Co., Ltd.",
        "08:09:C7": "Zhuhai Unitech Power Technology Co., Ltd.",
        "88:54:1F": "Google, Inc.",
        "90:0C:C8": "Google, Inc.",
        "04:1D:C7": "zte corporation",
        "68:21:5F": "Edgecore Networks Corporation",
        "3C:28:A6": "Alcatel-Lucent Enterprise (China)",
        "50:50:A4": "Samsung Electronics Co.,Ltd",
        "80:86:D9": "Samsung Electronics Co.,Ltd",
        "F4:17:B8": "AirTies Wireless Networks",
        "3C:BF:60": "Apple, Inc.",
        "AC:15:F4": "Apple, Inc.",
        "38:6A:77": "Samsung Electronics Co.,Ltd",
        "14:14:59": "Vodafone Italia S.p.A.",
        "50:43:B9": "OktoInform RUS",
        "5C:27:D4": "Shenzhen Qihu Intelligent Technology Company Limited",
        "88:A4:79": "Apple, Inc.",
        "04:72:95": "Apple, Inc.",
        "D4:46:E1": "Apple, Inc.",
        "78:D1:62": "Apple, Inc.",
        "08:F8:BC": "Apple, Inc.",
        "90:A2:5B": "Apple, Inc.",
        "18:30:0C": "Hisense Electric Co.,Ltd",
        "44:A5:6E": "NETGEAR",
        "1C:91:9D": "Dongguan Liesheng Electronic Co., Ltd.",
        "FC:F2:9F": "China Mobile Iot Limited company",
        "F8:1F:32": "Motorola Mobility LLC, a Lenovo Company",
        "B0:0A:D5": "zte corporation",
        "20:11:4E": "MeteRSit S.R.L.",
        "2C:57:41": "Cisco Systems, Inc",
        "A8:4D:4A": "Audiowise Technology Inc.",
        "78:94:E8": "Radio Bridge",
        "48:4E:FC": "ARRIS Group, Inc.",
        "B0:B3:53": "IEEE Registration Authority",
        "54:7F:BC": "iodyne",
        "7C:DF:A1": "Espressif Inc.",
        "98:00:6A": "zte corporation",
        "00:26:74": "Hunter Douglas",
        "1C:97:C5": "Ynomia Pty Ltd",
        "5C:C1:D7": "Samsung Electronics Co.,Ltd",
        "38:01:46": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
        "88:96:55": "Zitte corporation",
        "F4:A4:D6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "FC:E1:4F": "BRK Brands, Inc.",
        "74:B6:B6": "eero inc.",
        "EC:97:B2": "SUMEC Machinery & Electric Co.,Ltd.",
        "28:FA:7A": "Zhejiang Tmall Technology Co., Ltd.",
        "84:2E:14": "Silicon Laboratories",
        "10:05:E1": "Nokia",
        "08:F4:58": "Huawei Device Co., Ltd.",
        "5C:BA:2C": "Hewlett Packard Enterprise",
        "34:37:94": "Hamee Corp.",
        "EC:31:6D": "Hansgrohe",
        "44:10:FE": "Huizhou Foryou General Electronics Co., Ltd.",
        "7C:AB:60": "Apple, Inc.",
        "44:C6:5D": "Apple, Inc.",
        "18:7E:B9": "Apple, Inc.",
        "4C:A6:4D": "Cisco Systems, Inc",
        "CC:7F:75": "Cisco Systems, Inc",
        "20:E8:74": "Apple, Inc.",
        "D0:3F:AA": "Apple, Inc.",
        "0C:B9:37": "Ubee Interactive Co., Limited",
        "D4:DC:09": "Mist Systems, Inc.",
        "00:88:BA": "NC&C",
        "F4:73:35": "Logitech Far East",
        "90:AD:FC": "Telechips, Inc.",
        "5C:A6:2D": "Cisco Systems, Inc",
        "40:2B:69": "Kumho Electric Inc.",
        "E8:E9:8E": "SOLAR controls s.r.o.",
        "64:F6:BB": "Fibocom Wireless Inc.",
        "BC:16:95": "zte corporation",
        "DC:35:F1": "Positivo Tecnologia S.A.",
        "A4:08:01": "Amazon Technologies Inc.",
        "AC:1E:D0": "Temic Automotive Philippines Inc.",
        "2C:EA:7F": "Dell Inc.",
        "34:51:80": "TCL King Electrical Appliances (Huizhou) Co., Ltd",
        "A4:CF:D2": "Ubee Interactive Co., Limited",
        "A8:A0:97": "ScioTeq bvba",
        "08:6B:D1": "Shenzhen SuperElectron Technology Co.,Ltd.",
        "AC:3A:67": "Cisco Systems, Inc",
        "3C:B5:3D": "HUNAN GOKE MICROELECTRONICS CO.,LTD",
        "98:0D:51": "Huawei Device Co., Ltd.",
        "00:AD:D5": "Huawei Device Co., Ltd.",
        "90:5D:7C": "New H3C Technologies Co., Ltd",
        "98:FA:A7": "INNONET",
        "48:7B:5E": "SMT TELECOMM HK",
        "B8:E3:B1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:B7:A8": "Heinzinger electronic GmbH",
        "EC:79:49": "FUJITSU LIMITED",
        "D4:D2:D6": "FN-LINK TECHNOLOGY LIMITED",
        "10:50:72": "Sercomm Corporation.",
        "90:0A:84": "Mellanox Technologies, Inc.",
        "AC:4A:67": "Cisco Systems, Inc",
        "70:CA:97": "Ruckus Wireless",
        "00:09:91": "Intelligent Platforms, LLC.",
        "C8:66:5D": "Extreme Networks, Inc.",
        "E0:1C:41": "Extreme Networks, Inc.",
        "D8:54:A2": "Extreme Networks, Inc.",
        "08:66:1F": "Palo Alto Networks",
        "BC:F3:10": "Extreme Networks, Inc.",
        "28:54:71": "Huawei Device Co., Ltd.",
        "B8:8E:82": "Huawei Device Co., Ltd.",
        "DC:33:3D": "Huawei Device Co., Ltd.",
        "D8:78:7F": "Ubee Interactive Co., Limited",
        "D4:1D:71": "Palo Alto Networks",
        "08:87:C6": "INGRAM MICRO SERVICES",
        "78:57:73": "HUAWEI TECHNOLOGIES CO.,LTD",
        "AC:60:89": "HUAWEI TECHNOLOGIES CO.,LTD",
        "84:3E:92": "HUAWEI TECHNOLOGIES CO.,LTD",
        "70:8C:B6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "50:46:4A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C4:A4:02": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:15:FF": "Novatel Wireless Solutions, Inc.",
        "28:80:A2": "Novatel Wireless Solutions, Inc.",
        "68:33:2C": "KENSTEL NETWORKS LIMITED",
        "14:5E:45": "Bamboo Systems Group",
        "70:61:7B": "Cisco Systems, Inc",
        "98:59:49": "LUXOTTICA GROUP S.P.A.",
        "AC:67:B2": "Espressif Inc.",
        "9C:BD:6E": "DERA Co., Ltd",
        "4C:33:29": "Sweroam",
        "64:E1:72": "Shenzhen Qihoo Intelligent Technology Co.,Ltd",
        "48:8F:5A": "Routerboard.com",
        "10:06:45": "Sagemcom Broadband SAS",
        "00:14:C9": "Brocade Communications Systems LLC",
        "00:24:38": "Brocade Communications Systems LLC",
        "74:8E:F8": "Brocade Communications Systems LLC",
        "00:27:F8": "Brocade Communications Systems LLC",
        "50:EB:1A": "Brocade Communications Systems LLC",
        "F8:4D:FC": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "84:9A:40": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "D8:1F:CC": "Brocade Communications Systems LLC",
        "C4:89:ED": "Solid Optics EU N.V.",
        "60:F4:3A": "Edifier International",
        "58:A8:7B": "Fitbit, Inc.",
        "5C:6B:D7": "Foshan VIOMI Electric Appliance Technology Co. Ltd.",
        "18:48:CA": "Murata Manufacturing Co., Ltd.",
        "90:EE:C7": "Samsung Electronics Co.,Ltd",
        "10:29:AB": "Samsung Electronics Co.,Ltd",
        "18:4E:CB": "Samsung Electronics Co.,Ltd",
        "80:22:A7": "NEC Platforms, Ltd.",
        "64:E8:81": "Aruba, a Hewlett Packard Enterprise Company",
        "98:9D:5D": "Technicolor CH USA Inc.",
        "5C:23:16": "Squirrels Research Labs LLC",
        "04:21:44": "Sunitec Enterprise Co.,Ltd",
        "A0:27:B6": "Samsung Electronics Co.,Ltd",
        "10:39:17": "Samsung Electronics Co.,Ltd",
        "98:80:EE": "Samsung Electronics Co.,Ltd",
        "CC:0D:F2": "Motorola Mobility LLC, a Lenovo Company",
        "94:BF:94": "Juniper Networks",
        "94:43:4D": "Ciena Corporation",
        "A8:40:25": "Oxide Computer Company",
        "10:65:A3": "Panamax LLC",
        "C8:5B:A0": "Shenzhen Qihu Intelligent Technology Company Limited",
        "E0:BE:03": "Lite-On Network Communication (Dongguan) Limited",
        "5C:90:12": "Owl Cyber Defense Solutions, LLC",
        "38:F7:CD": "IEEE Registration Authority",
        "98:CB:A4": "Benchmark Electronics",
        "00:12:E3": "Agat Soft LLC",
        "00:13:51": "Niles Audio Corporation",
        "18:3C:B7": "Huawei Device Co., Ltd.",
        "A4:88:73": "Cisco Systems, Inc",
        "B8:80:4F": "Texas Instruments",
        "FC:A5:D0": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "04:CB:88": "Shenzhen Jingxun Software Telecommunication Technology Co.,Ltd",
        "A0:62:60": "Private",
        "A4:BD:C4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "5C:91:57": "HUAWEI TECHNOLOGIES CO.,LTD",
        "48:16:93": "Lear Corporation GmbH",
        "B4:79:47": "Nutanix",
        "04:F8:F8": "Edgecore Networks Corporation",
        "5C:FE:9E": "Wiwynn Corporation Tainan Branch",
        "88:1C:95": "ITEL MOBILE LIMITED",
        "F4:69:42": "ASKEY COMPUTER CORP",
        "24:14:07": "Xiamen Sigmastar Technology Ltd.",
        "08:E9:F6": "AMPAK Technology,Inc.",
        "F0:2E:51": "Casa Systems",
        "CC:C2:61": "IEEE Registration Authority",
        "74:70:FD": "Intel Corporate",
        "7C:2A:31": "Intel Corporate",
        "B4:6B:FC": "Intel Corporate",
        "14:4F:8A": "Intel Corporate",
        "C0:B6:F9": "Intel Corporate",
        "48:A4:72": "Intel Corporate",
        "D8:F2:CA": "Intel Corporate",
        "48:F1:7F": "Intel Corporate",
        "68:EC:C5": "Intel Corporate",
        "7C:76:35": "Intel Corporate",
        "64:0B:D7": "Apple, Inc.",
        "A8:91:3D": "Apple, Inc.",
        "4C:C9:5E": "Samsung Electronics Co.,Ltd",
        "0C:3B:50": "Apple, Inc.",
        "78:2B:46": "Intel Corporate",
        "34:7D:F6": "Intel Corporate",
        "CC:D9:AC": "Intel Corporate",
        "9C:29:76": "Intel Corporate",
        "B8:9A:2A": "Intel Corporate",
        "58:96:1D": "Intel Corporate",
        "74:D8:3E": "Intel Corporate",
        "08:D2:3E": "Intel Corporate",
        "A8:7E:EA": "Intel Corporate",
        "40:EC:99": "Intel Corporate",
        "BC:54:2F": "Intel Corporate",
        "34:CF:F6": "Intel Corporate",
        "C8:7E:A1": "TCL MOKA International Limited",
        "A0:51:0B": "Intel Corporate",
        "DC:FB:48": "Intel Corporate",
        "84:FD:D1": "Intel Corporate",
        "40:74:E0": "Intel Corporate",
        "08:71:90": "Intel Corporate",
        "5C:CD:5B": "Intel Corporate",
        "98:AF:65": "Intel Corporate",
        "40:A6:B7": "Intel Corporate",
        "0C:7A:15": "Intel Corporate",
        "54:8D:5A": "Intel Corporate",
        "30:66:D0": "Huawei Device Co., Ltd.",
        "3C:B2:33": "Huawei Device Co., Ltd.",
        "20:9E:79": "Universal Electronics, Inc.",
        "AC:5F:EA": "OnePlus Technology (Shenzhen) Co., Ltd",
        "04:4A:C6": "Aipon Electronics Co., Ltd",
        "5C:D5:B5": "Shenzhen WiSiYiLink Technology Co.,Ltd",
        "88:94:8F": "Xi'an Zhisensor Technologies Co.,Ltd",
        "18:95:52": "1MORE",
        "C0:FF:A8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C0:51:7E": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "FC:14:99": "Aimore Acoustics Incorporation",
        "98:C7:A4": "Shenzhen HS Fiber Communication Equipment CO., LTD",
        "00:BE:D5": "New H3C Technologies Co., Ltd",
        "00:02:C4": "OPT Machine Vision Tech Co., Ltd",
        "AC:F1:08": "LG Innotek",
        "08:ED:9D": "TECNO MOBILE LIMITED",
        "E8:6D:CB": "Samsung Electronics Co.,Ltd",
        "30:49:50": "IEEE Registration Authority",
        "00:05:C9": "LG Innotek",
        "0C:DC:7E": "Espressif Inc.",
        "20:98:D8": "Shenzhen Yingdakang Technology CO., LTD",
        "7C:C7:7E": "Fiberhome Telecommunication Technologies Co.,LTD",
        "A0:CF:F5": "zte corporation",
        "1C:01:2D": "Ficer Technology",
        "3C:A6:2F": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "98:B3:EF": "Huawei Device Co., Ltd.",
        "50:F9:58": "Huawei Device Co., Ltd.",
        "60:32:B1": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "E4:1F:7B": "Cisco Systems, Inc",
        "18:26:49": "Intel Corporate",
        "88:03:E9": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "34:58:40": "HUAWEI TECHNOLOGIES CO.,LTD",
        "5C:64:7A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "BC:7F:7B": "Huawei Device Co., Ltd.",
        "F0:FA:C7": "Huawei Device Co., Ltd.",
        "DC:EF:80": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B4:6F:2D": "Wahoo Fitness",
        "5C:85:7E": "IEEE Registration Authority",
        "84:6B:48": "ShenZhen EepuLink Co., Ltd.",
        "B4:60:ED": "Beijing Xiaomi Mobile Software Co., Ltd",
        "30:CC:21": "zte corporation",
        "64:6C:80": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "08:9E:01": "Quanta Computer Inc.",
        "A8:1E:84": "Quanta Computer Inc.",
        "C0:18:50": "Quanta Computer Inc.",
        "44:27:F3": "70mai Co.,Ltd.",
        "04:7D:7B": "Quanta Computer Inc.",
        "00:25:DC": "Sumitomo Electric Industries, Ltd",
        "D4:F3:37": "Xunison Ltd.",
        "48:A2:B8": "Chengdu Vision-Zenith Tech.Co,.Ltd",
        "C0:B8:E6": "Ruijie Networks Co.,LTD",
        "8C:94:1F": "Cisco Systems, Inc",
        "68:7D:B4": "Cisco Systems, Inc",
        "58:E8:73": "HANGZHOU DANGBEI NETWORK TECH.Co.,Ltd",
        "B0:30:C8": "Teal Drones, Inc.",
        "DC:41:A9": "Intel Corporate",
        "08:8F:2C": "Amber Technology Ltd.",
        "A8:35:12": "Huawei Device Co., Ltd.",
        "90:F6:44": "Huawei Device Co., Ltd.",
        "44:AF:28": "Intel Corporate",
        "9C:9D:7E": "Beijing Xiaomi Mobile Software Co., Ltd",
        "74:12:B3": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "94:47:B0": "BEIJING ESWIN COMPUTING TECHNOLOGY CO., LTD",
        "A0:68:1C": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "6C:44:2A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A4:7C:C9": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C4:0D:96": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:5C:7D": "Shenzhen Honesty Electronics Co.,Ltd.",
        "84:22:5E": "SHENZHEN TECHNEWCHIP TECHNOLOGY CO.,LTD.",
        "E4:5A:D4": "Eltex Enterprise Ltd.",
        "84:2A:FD": "HP Inc.",
        "1C:FE:2B": "Amazon Technologies Inc.",
        "CC:48:3A": "Dell Inc.",
        "DC:A3:A2": "Feng mi(Beijing)technology co., LTD",
        "7C:25:DA": "FN-LINK TECHNOLOGY LIMITED",
        "A8:69:8C": "Oracle Corporation ",
        "EC:57:0D": "AFE Inc.",
        "A4:AC:0F": "Huawei Device Co., Ltd.",
        "CC:FF:90": "Huawei Device Co., Ltd.",
        "54:05:DB": "LCFC(HeFei) Electronics Technology co., ltd",
        "D4:D5:1B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:91:BB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "64:5E:10": "HUAWEI TECHNOLOGIES CO.,LTD",
        "EC:F2:2B": "TECNO MOBILE LIMITED",
        "E4:5F:01": "Raspberry Pi Trading Ltd",
        "44:A5:4E": "Qorvo International Pte. Ltd.",
        "C8:E6:00": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:57:8E": "eero inc.",
        "00:30:54": "Castlenet Technology Inc.",
        "C8:16:DA": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "B0:44:14": "New H3C Technologies Co., Ltd",
        "30:96:10": "Huawei Device Co., Ltd.",
        "64:F9:47": "Senscomm Semiconductor Co., Ltd.",
        "DC:00:B0": "FREEBOX SAS",
        "70:74:14": "Murata Manufacturing Co., Ltd.",
        "A0:76:4E": "Espressif Inc.",
        "B4:FB:E3": "AltoBeam (China) Inc.",
        "10:D7:B0": "Sagemcom Broadband SAS",
        "44:59:43": "zte corporation",
        "34:36:54": "zte corporation",
        "74:8F:3C": "Apple, Inc.",
        "40:F9:46": "Apple, Inc.",
        "6C:09:BF": "Fiberhome Telecommunication Technologies Co.,LTD",
        "FC:6D:D1": "APRESIA Systems, Ltd.",
        "80:C9:55": "Redpine Signals, Inc.",
        "CC:4F:5C": "IEEE Registration Authority",
        "4C:6D:58": "Juniper Networks",
        "5C:ED:8C": "Hewlett Packard Enterprise",
        "30:D0:42": "Dell Inc.",
        "C0:C9:E3": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "F8:8C:21": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "C4:27:8C": "Huawei Device Co., Ltd.",
        "80:8F:E8": "Intelbras",
        "7C:73:EB": "Huawei Device Co., Ltd.",
        "E4:8F:1D": "Huawei Device Co., Ltd.",
        "FC:CD:2F": "IEEE Registration Authority",
        "94:B2:71": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:05:8C": "mMax Communications, Inc.",
        "C4:A7:2B": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD",
        "CC:F5:5F": "E FOCUS INSTRUMENTS INDIA PRIVATE LIMITED",
        "D0:C3:1E": "JUNGJIN Electronics Co.,Ltd",
        "14:13:33": "AzureWave Technology Inc.",
        "A4:17:8B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "5C:34:00": "Hisense Electric Co.,Ltd",
        "4C:3B:DF": "Microsoft Corporation",
        "08:7C:39": "Amazon Technologies Inc.",
        "D8:10:CB": "Andrea Informatique",
        "FC:19:28": "Actions Microelectronics Co., Ltd",
        "3C:D2:E5": "New H3C Technologies Co., Ltd",
        "B0:98:BC": "Huawei Device Co., Ltd.",
        "24:01:6F": "Huawei Device Co., Ltd.",
        "D0:59:19": "zte corporation",
        "E0:91:3C": "Kyeungin CNS Co., Ltd.",
        "00:B8:81": "New platforms LLC",
        "00:1B:2E": "Sinkyo Electron Inc",
        "C4:37:72": "Virtuozzo International GmbH",
        "CC:3B:27": "TECNO MOBILE LIMITED",
        "08:58:A5": "Beijing Vrv Software Corpoaration Limited.",
        "98:3F:60": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C0:3F:DD": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:32:35": "Qingdao Intelligent&Precise Electronics Co.,Ltd.",
        "E0:E2:E6": "Espressif Inc.",
        "9C:73:70": "HUAWEI TECHNOLOGIES CO.,LTD",
        "58:24:29": "Google, Inc.",
        "E8:0A:EC": "Jiangsu Hengtong Optic-Electric Co., LTD",
        "C4:DE:7B": "Huawei Device Co., Ltd.",
        "7C:C2:94": "Beijing Xiaomi Mobile Software Co., Ltd",
        "40:D4:BD": "SK Networks Service CO., LTD.",
        "68:D4:8B": "Hailo Technologies Ltd.",
        "6C:1A:75": "Huawei Device Co., Ltd.",
        "6C:76:37": "Huawei Device Co., Ltd.",
        "18:EE:86": "Novatel Wireless Solutions, Inc.",
        "A0:9F:10": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
        "20:1B:88": "Dongguan Liesheng Electronic Co., Ltd.",
        "24:94:93": "FibRSol Global Network Limited",
        "28:D0:44": "Shenzhen Xinyin technology company",
        "A8:40:7D": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "FC:4B:57": "Peerless Instrument Division of Curtiss-Wright ",
        "5C:10:C5": "Samsung Electronics Co.,Ltd",
        "E8:EB:34": "Cisco Systems, Inc",
        "58:60:D8": "ARRIS Group, Inc.",
        "9C:9A:C0": "LEGO System A/S",
        "3C:BD:C5": "Arcadyan Corporation",
        "A8:DA:0C": "SERVERCOM (INDIA) PRIVATE LIMITED",
        "F8:53:29": "HUAWEI TECHNOLOGIES CO.,LTD",
        "50:A5:DC": "ARRIS Group, Inc.",
        "74:B7:B3": "Shenzhen YOUHUA Technology Co., Ltd",
        "88:15:C5": "Huawei Device Co., Ltd.",
        "B4:1B:B0": "Apple, Inc.",
        "58:D3:49": "Apple, Inc.",
        "F4:34:F0": "Apple, Inc.",
        "B0:8C:75": "Apple, Inc.",
        "A4:AA:FE": "Huawei Device Co., Ltd.",
        "F8:3B:7E": "Huawei Device Co., Ltd.",
        "9C:28:B3": "Apple, Inc.",
        "A0:78:17": "Apple, Inc.",
        "5C:87:30": "Apple, Inc.",
        "DC:9B:D6": "TCT mobile ltd",
        "70:40:FF": "Huawei Device Co., Ltd.",
        "34:D6:93": "Huawei Device Co., Ltd.",
        "E0:1F:ED": "Nokia Shanghai Bell Co., Ltd.",
        "14:6B:9A": "zte corporation",
        "78:32:1B": "D-Link International",
        "04:E7:7E": "We Corporation Inc.",
        "4C:52:EC": "SOLARWATT GmbH",
        "30:D9:41": "Raydium Semiconductor Corp.",
        "68:76:27": "Zhuhai Dingzhi Electronic Technology Co., Ltd",
        "20:0B:CF": "Nintendo Co.,Ltd",
        "38:C0:96": "ALPSALPINE CO,.LTD",
        "AC:7A:4D": "ALPSALPINE CO,.LTD",
        "04:76:6E": "ALPSALPINE CO,.LTD",
        "24:E4:C8": "Fiberhome Telecommunication Technologies Co.,LTD",
        "94:8E:D3": "Arista Networks",
        "00:26:43": "ALPSALPINE CO,.LTD",
        "C0:F6:EC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "CC:20:8C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "88:5A:85": "Wistron Neweb Corporation",
        "D8:00:93": "Aurender Inc.",
        "38:90:52": "HUAWEI TECHNOLOGIES CO.,LTD",
        "40:8F:9D": "Juniper Networks",
        "00:15:E7": "Quantec Tontechnik",
        "FC:B3:BC": "Intel Corporate",
        "18:CC:18": "Intel Corporate",
        "C0:3C:59": "Intel Corporate",
        "84:1B:77": "Intel Corporate",
        "2C:A5:9C": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "34:C9:3D": "Intel Corporate",
        "6C:98:EB": "Riverbed Technology, Inc.",
        "00:1F:F5": "Kongsberg Defence & Aerospace",
        "74:EC:B2": "Amazon Technologies Inc.",
        "C8:6C:3D": "Amazon Technologies Inc.",
        "C0:41:21": "Nokia Solutions and Networks GmbH & Co. KG",
        "0C:7C:28": "Nokia Solutions and Networks GmbH & Co. KG",
        "20:78:52": "Nokia Solutions and Networks GmbH & Co. KG",
        "54:FA:96": "Nokia Solutions and Networks GmbH & Co. KG",
        "7C:C2:C6": "TP-Link Corporation Limited",
        "08:9A:C7": "zte corporation",
        "BC:6D:05": "Dusun Electron Co.,Ltd.",
        "74:4C:A1": "Liteon Technology Corporation",
        "B4:B2:91": "LG Electronics",
        "C0:E0:18": "HUAWEI TECHNOLOGIES CO.,LTD",
        "5C:E7:47": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A8:FF:BA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "AC:78:D1": "Juniper Networks",
        "A4:42:3B": "Intel Corporate",
        "70:CF:49": "Intel Corporate",
        "48:51:C5": "Intel Corporate",
        "20:EF:BD": "Roku, Inc",
        "EC:7C:B6": "Samsung Electronics Co.,Ltd",
        "58:A6:39": "Samsung Electronics Co.,Ltd",
        "A4:E5:7C": "Espressif Inc.",
        "04:F9:93": "Infinix mobility limited",
        "BC:BD:9E": "ITEL MOBILE LIMITED",
        "F4:2A:7D": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "8C:0F:C9": "Huawei Device Co., Ltd.",
        "30:4E:1B": "Huawei Device Co., Ltd.",
        "6C:03:09": "Cisco Systems, Inc",
        "BC:D2:95": "Cisco Systems, Inc",
        "74:50:4E": "New H3C Technologies Co., Ltd",
        "F0:39:65": "Samsung Electronics Co.,Ltd",
        "FC:B6:62": "IC Holdings LLC",
        "50:2D:FB": "IGShare Co., Ltd.",
        "40:EE:15": "Zioncom Electronics (Shenzhen) Ltd.",
        "00:F3:61": "Amazon Technologies Inc.",
        "6C:0D:E1": "Dongguan Cannice Precision Manufacturing Co., Ltd.",
        "60:6C:63": "Hitron Technologies. Inc",
        "E8:D7:65": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E4:5E:1B": "Google, Inc.",
        "C4:30:CA": "SD Biosensor",
        "D4:A6:51": "Tuya Smart Inc.",
        "28:05:2E": "Dematic Corp",
        "88:C3:E5": "Betop Techonologies ",
        "E4:28:A4": "Prama India Private Limited",
        "94:3A:91": "Amazon Technologies Inc.",
        "40:8C:1F": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "2C:3F:0B": "Cisco Meraki",
        "80:C5:01": "OctoGate IT Security Systems GmbH",
        "04:F0:3E": "Huawei Device Co., Ltd.",
        "78:E2:2C": "Huawei Device Co., Ltd.",
        "C0:D0:26": "Huawei Device Co., Ltd.",
        "14:D1:9E": "Apple, Inc.",
        "40:C7:11": "Apple, Inc.",
        "5C:70:17": "Apple, Inc.",
        "8C:EC:7B": "Apple, Inc.",
        "00:2D:B3": "AMPAK Technology,Inc.",
        "3C:C7:86": "DONGGUAN HUARONG COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "28:C8:7C": "zte corporation",
        "14:50:51": "SHARP Corporation",
        "C4:D0:E3": "Intel Corporate",
        "E4:FD:45": "Intel Corporate",
        "18:4C:AE": "CONTINENTAL",
        "98:38:7D": "ITRONIC  TECHNOLOGY CO . , LTD .",
        "C8:D8:84": "Universal Electronics, Inc.",
        "B4:A2:5C": "Cambium Networks Limited",
        "2C:71:FF": "Amazon Technologies Inc.",
        "AC:D6:18": "OnePlus Technology (Shenzhen) Co., Ltd",
        "6C:56:40": "BLU Products Inc",
        "48:78:5E": "Amazon Technologies Inc.",
        "20:C7:4F": "SensorPush",
        "48:29:52": "Sagemcom Broadband SAS",
        "A4:7E:36": "EM Microelectronic",
        "B0:5D:D4": "ARRIS Group, Inc.",
        "24:E8:53": "LG Innotek",
        "30:7C:4A": "Huawei Device Co., Ltd.",
        "2C:CE:1E": "Cloudtronics Pty Ltd",
        "F0:21:E0": "eero inc.",
        "9C:DB:CB": "Wuhan Funshion Online Technologies Co.,Ltd",
        "64:17:59": "Intellivision Holdings, LLC",
        "50:43:48": "ThingsMatrix Inc.",
        "D8:59:82": "HUAWEI TECHNOLOGIES CO.,LTD",
        "48:B2:5D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A4:1B:34": "China Mobile Group Device Co.,Ltd.",
        "80:45:DD": "Intel Corporate",
        "C0:D4:6B": "Huawei Device Co., Ltd.",
        "9C:95:67": "Huawei Device Co., Ltd.",
        "58:AE:F1": "Fiberhome Telecommunication Technologies Co.,LTD",
        "A4:7B:1A": "Huawei Device Co., Ltd.",
        "14:7D:05": "SERCOMM PHILIPPINES INC",
        "78:7A:6F": "Juice Technology AG",
        "E8:6C:C7": "IEEE Registration Authority",
        "40:24:B2": "Sichuan AI-Link Technology Co., Ltd.",
        "64:0D:22": "LG Electronics (Mobile Communications)",
        "20:A7:F9": "SHENZHEN OLANBOA TECHNOLOGY CO., LTD",
        "C0:06:C3": "TP-Link Corporation Limited",
        "3C:15:12": "Shenzhen Huanhu Technology Co.,Ltd",
        "8C:31:E2": "DAYOUPLUS",
        "10:39:4E": "Hisense broadband multimedia technology Co.,Ltd",
        "D8:D5:B9": "Rainforest Automation, Inc.",
        "04:BA:1C": "Huawei Device Co., Ltd.",
        "7C:3D:2B": "Huawei Device Co., Ltd.",
        "18:C2:41": "SonicWall",
        "58:45:4C": "Ericsson AB",
        "FC:4D:A6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B4:14:E6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "AC:99:29": "HUAWEI TECHNOLOGIES CO.,LTD",
        "18:48:59": "Castlenet Technology Inc.",
        "14:51:7E": "New H3C Technologies Co., Ltd",
        "08:3A:38": "New H3C Technologies Co., Ltd",
        "70:F0:88": "Nintendo Co.,Ltd",
        "84:23:88": "Ruckus Wireless",
        "F4:C7:AA": "Marvell Semiconductors",
        "F8:AB:E5": "shenzhen worldelite electronics co., LTD",
        "CC:ED:21": "Nokia Shanghai Bell Co., Ltd.",
        "10:D5:61": "Tuya Smart Inc.",
        "00:1A:86": "New Wave Design & Verification",
        "50:9A:46": "Safetrust Inc",
        "D0:CF:D8": "Huizhou Boshijie Technology Co.,Ltd",
        "84:C7:8F": "APS Networks GmbH",
        "F0:A3:B2": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "08:BB:3C": "Flextronics Tech.(Ind) Pvt Ltd",
        "2C:BE:EB": "Nothing Technology Limited",
        "F0:4A:02": "Cisco Systems, Inc",
        "74:09:AC": "Quext, LLC",
        "F0:01:6E": "Tianyi Telecom Terminals Company Limited",
        "EC:0B:AE": "Hangzhou BroadLink Technology Co.,Ltd",
        "80:25:11": "ITEL MOBILE LIMITED",
        "E8:A6:60": "HUAWEI TECHNOLOGIES CO.,LTD",
        "CC:24:2E": "Shenzhen SuperElectron Technology Co.,Ltd.",
        "08:2F:E9": "HUAWEI TECHNOLOGIES CO.,LTD",
        "98:48:74": "HUAWEI TECHNOLOGIES CO.,LTD",
        "1C:A6:81": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B8:81:FA": "Apple, Inc.",
        "9C:76:0E": "Apple, Inc.",
        "94:EA:32": "Apple, Inc.",
        "C8:BF:FE": "Huawei Device Co., Ltd.",
        "08:2E:36": "Huawei Device Co., Ltd.",
        "50:F4:EB": "Apple, Inc.",
        "28:C7:09": "Apple, Inc.",
        "38:02:DE": "Sercomm Corporation.",
        "5C:62:5A": "CANON INC.",
        "7C:0A:3F": "Samsung Electronics Co.,Ltd",
        "08:AA:89": "zte corporation",
        "A4:35:2D": "TRIZ Networks corp.",
        "04:D6:0E": "FUNAI ELECTRIC CO., LTD.",
        "04:9F:81": "NETSCOUT SYSTEMS INC",
        "00:80:8C": "NETSCOUT SYSTEMS INC",
        "00:1F:92": "Motorola Solutions Inc.",
        "00:23:BB": "Accretech SBS, Inc.",
        "B0:C9:52": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "F4:41:9E": "Huawei Device Co., Ltd.",
        "90:F9:B7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F4:45:88": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C8:BB:81": "Huawei Device Co., Ltd.",
        "1C:47:2F": "Huawei Device Co., Ltd.",
        "20:5E:64": "Huawei Device Co., Ltd.",
        "60:57:7D": "eero inc.",
        "C8:13:8B": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "78:F2:35": "Sichuan AI-Link Technology Co., Ltd.",
        "F4:4E:E3": "Intel Corporate",
        "D0:E0:42": "Cisco Systems, Inc",
        "3C:37:12": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "80:B6:55": "Intel Corporate",
        "0C:CB:0C": "iSYS RTS GmbH",
        "44:56:E2": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "54:AE:D2": "CSL Dualcom Ltd",
        "F4:6F:A4": "Physik Instrumente GmbH & Co. KG",
        "C4:74:69": "BT9",
        "64:5D:92": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "9C:61:21": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "E0:4F:BD": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "40:F4:20": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "CC:A2:60": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "AC:E7:7B": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "4C:D3:AF": "HMD Global Oy",
        "C8:51:42": "Samsung Electronics Co.,Ltd",
        "CC:0D:E7": "B METERS S.R.L.",
        "5C:A1:76": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "10:E4:C2": "Samsung Electronics Co.,Ltd",
        "0C:8D:CA": "Samsung Electronics Co.,Ltd",
        "58:2F:F7": "Sagemcom Broadband SAS",
        "8C:FD:15": "Imagine Marketing Private Limited",
        "AC:D8:29": "Bouffalo Lab (Nanjing) Co., Ltd.",
        "68:3A:48": "SAMJIN Co., Ltd.",
        "B0:27:CF": "Extreme Networks, Inc.",
        "14:22:3B": "Google, Inc.",
        "48:F8:FF": "CHENGDU KT ELECTRONIC HI-TECH CO.,LTD",
        "E8:C1:E8": "Shenzhen Xiao Bi En Culture Education Technology Co.,Ltd.",
        "2C:DD:E9": "Arista Networks",
        "70:97:41": "Arcadyan Corporation",
        "C4:FF:22": "Huawei Device Co., Ltd.",
        "A0:A0:DC": "Huawei Device Co., Ltd.",
        "C4:80:8A": "Cloud Diagnostics Canada ULC",
        "E4:08:E7": "Quectel Wireless Solutions Co.,Ltd.",
        "7C:70:DB": "Intel Corporate",
        "8C:94:CC": "SFR",
        "60:B6:E1": "Texas Instruments",
        "6C:79:B8": "Texas Instruments",
        "A4:D0:94": "VIVAVIS AG",
        "8C:A3:99": "SERVERCOM (INDIA) PRIVATE LIMITED",
        "60:DB:15": "New H3C Technologies Co., Ltd",
        "5C:A7:21": "New H3C Technologies Co., Ltd",
        "98:F2:17": "Castlenet Technology Inc.",
        "90:80:60": "Nilfisk A/S",
        "70:A6:CC": "Intel Corporate",
        "6C:43:3C": "TECNO MOBILE LIMITED",
        "44:5B:ED": "Aruba, a Hewlett Packard Enterprise Company",
        "84:EB:EF": "Cisco Systems, Inc",
        "D0:3E:7D": "CHIPSEA TECHNOLOGIES (SHENZHEN) CORP.",
        "90:69:76": "Withrobot Inc.",
        "FC:92:57": "Renesas Electronics (Penang) Sdn. Bhd.",
        "60:A5:E2": "Intel Corporate",
        "A4:2A:71": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "D4:54:8B": "Intel Corporate",
        "10:09:F9": "Amazon Technologies Inc.",
        "D0:1E:1D": "SaiNXT Technologies LLP",
        "58:4D:42": "Dragos, Inc.",
        "60:8A:10": "Microchip Technology Inc.",
        "A8:23:16": "Nokia",
        "38:E3:9F": "Motorola Mobility LLC, a Lenovo Company",
        "44:67:52": "Wistron INFOCOMM (Zhongshan) CORPORATION",
        "78:BB:88": "Maxio Technology (Hangzhou) Ltd.",
        "A8:64:F1": "Intel Corporate",
        "10:6F:D9": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "E0:67:81": "Dongguan Liesheng Electronic Co., Ltd.",
        "00:03:24": "SANYO Techno Solutions Tottori Co., Ltd.",
        "B8:AE:1D": "Guangzhou Xingyi Electronic Technology Co.,Ltd",
        "3C:CD:57": "Beijing Xiaomi Mobile Software Co., Ltd",
        "B8:DA:E8": "Huawei Device Co., Ltd.",
        "28:DE:A8": "zte corporation",
        "80:8A:BD": "Samsung Electronics Co.,Ltd",
        "D8:BE:65": "Amazon Technologies Inc.",
        "60:E3:2B": "Intel Corporate",
        "AC:EC:85": "eero inc.",
        "C0:F8:27": "Rapidmax Technology Corporation",
        "B4:52:7E": "Sony Corporation",
        "70:86:CE": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "30:75:12": "Sony Corporation",
        "C4:3A:BE": "Sony Corporation",
        "94:CE:2C": "Sony Corporation",
        "DC:8D:8A": "Nokia Solutions and Networks GmbH & Co. KG",
        "20:E7:B6": "Universal Electronics, Inc.",
        "50:0F:59": "STMicrolectronics International NV",
        "E4:2A:AC": "Microsoft Corporation",
        "D4:3D:F3": "Zyxel Communications Corporation",
        "20:57:9E": "HUNAN FN-LINK TECHNOLOGY LIMITED",
        "00:1E:45": "Sony Corporation",
        "00:0E:07": "Sony Corporation",
        "00:0A:D9": "Sony Corporation",
        "00:23:F1": "Sony Corporation",
        "00:1A:75": "Sony Corporation",
        "00:1C:A4": "Sony Corporation",
        "24:5E:48": "Apple, Inc.",
        "08:C7:29": "Apple, Inc.",
        "C8:84:CF": "HUAWEI TECHNOLOGIES CO.,LTD",
        "80:6A:10": "Whisker Labs - Ting",
        "E0:23:D7": "Sleep Number",
        "C4:C3:6B": "Apple, Inc.",
        "24:1D:48": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "00:91:9E": "Intel Corporate",
        "64:DC:DE": "ZheJiang FuChunJiang Information Technology Co.,Ltd",
        "0C:E1:59": "Shenzhen iStartek Technology Co., Ltd.",
        "E8:A7:30": "Apple, Inc.",
        "60:06:E3": "Apple, Inc.",
        "A0:29:BD": "Team Group Inc",
        "98:B1:77": "LANDIS + GYR",
        "50:F9:08": "Wizardlab Co., Ltd.",
        "50:C2:E8": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "30:09:C0": "Motorola Mobility LLC, a Lenovo Company",
        "FC:2E:19": "China Mobile Group Device Co.,Ltd.",
        "70:1A:D5": "Openpath Security, Inc.",
        "00:0E:82": "Infinity Tech",
        "F0:B6:1E": "Intel Corporate",
        "C8:4D:44": "Shenzhen Jiapeng Huaxiang Technology Co.,Ltd",
        "B0:46:92": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "AC:76:4C": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "5C:58:E6": "Palo Alto Networks",
        "EC:94:CB": "Espressif Inc.",
        "40:40:6B": "Icomera",
        "EC:97:E0": "Hangzhou Ezviz Software Co.,Ltd.",
        "D0:B6:6F": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
        "7C:FD:6B": "Xiaomi Communications Co Ltd",
        "18:87:40": "Xiaomi Communications Co Ltd",
        "34:1C:F0": "Xiaomi Communications Co Ltd",
        "2C:3A:91": "Huawei Device Co., Ltd.",
        "64:F7:05": "Huawei Device Co., Ltd.",
        "60:6E:E8": "Xiaomi Communications Co Ltd",
        "F0:5E:CD": "Texas Instruments",
        "F8:38:69": "LG Electronics",
        "00:16:E8": "Lumissil Microsystems",
        "60:CE:41": "HUAWEI TECHNOLOGIES CO.,LTD",
        "28:17:09": "HUAWEI TECHNOLOGIES CO.,LTD",
        "5C:DF:B8": "Shenzhen Unionmemory Information System Limited",
        "E0:0A:F6": "Liteon Technology Corporation",
        "B4:0E:CF": "Bouffalo Lab (Nanjing) Co., Ltd.",
        "E0:C5:8F": "China Mobile IOT Company Limited",
        "2C:05:47": "Shenzhen Phaten Tech. LTD",
        "2C:1A:05": "Cisco Systems, Inc",
        "9C:50:D1": "Murata Manufacturing Co., Ltd.",
        "14:00:20": "LongSung Technology (Shanghai) Co.,Ltd.   ",
        "44:17:93": "Espressif Inc.",
        "50:3D:EB": "Zhejiang Tmall Technology Co., Ltd.",
        "7C:66:EF": "Hon Hai Precision IND.CO.,LTD",
        "78:50:05": "MOKO TECHNOLOGY Ltd",
        "F8:7F:A5": "GREATEK",
        "18:E1:DE": "Chengdu ChipIntelli Technology Co., Ltd",
        "8C:F6:81": "Silicon Laboratories",
        "7C:84:37": "China Post Communications Equipment Co., Ltd.",
        "B8:4D:43": "HUNAN FN-LINK TECHNOLOGY LIMITED",
        "AC:64:90": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A8:4A:63": "TPV Display Technology(Xiamen) Co.,Ltd.",
        "24:3F:AA": "Huawei Device Co., Ltd.",
        "D8:67:D3": "Huawei Device Co., Ltd.",
        "48:47:4B": "Huawei Device Co., Ltd.",
        "80:6F:1C": "Huawei Device Co., Ltd.",
        "C8:9F:1A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D8:68:52": "HUAWEI TECHNOLOGIES CO.,LTD",
        "84:E3:42": "Tuya Smart Inc.",
        "E0:A2:58": "Wanbang Digital Energy Co.,Ltd",
        "4C:BC:E9": "LG Innotek",
        "74:5C:FA": "Shenzhen Shunrui Gaojie Technology Co., Ltd.",
        "94:A4:08": "Shenzhen Trolink Technology CO, LTD",
        "D0:F8:65": "ITEL MOBILE LIMITED",
        "38:5C:76": "PLANTRONICS, INC.",
        "7C:C1:77": "INGRAM MICRO SERVICES",
        "78:76:D9": "EXARA Group",
        "84:A9:38": "LCFC(HeFei) Electronics Technology co., ltd",
        "3C:9F:C3": "Beijing Sinead Technology Co., Ltd. ",
        "60:8F:A4": "Nokia Solutions and Networks GmbH & Co. KG",
        "38:FD:F8": "Cisco Systems, Inc",
        "20:8C:47": "Tenstorrent Inc",
        "5C:2A:EF": "r2p Asia-Pacific Pty Ltd",
        "E4:93:6A": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "48:77:BD": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "7C:FC:16": "Apple, Inc.",
        "88:B9:45": "Apple, Inc.",
        "00:80:E7": "Leonardo UK Ltd",
        "10:32:1D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B0:BE:83": "Apple, Inc.",
        "DC:F4:CA": "Apple, Inc.",
        "18:EF:3A": "Sichuan AI-Link Technology Co., Ltd.",
        "A0:FF:22": "SHENZHEN APICAL TECHNOLOGY CO., LTD",
        "00:04:1B": "Bridgeworks Ltd.",
        "6C:D3:EE": "ZIMI CORPORATION",
        "E4:28:05": "Pivotal Optics",
        "5C:02:14": "Beijing Xiaomi Mobile Software Co., Ltd",
        "78:5E:A2": "Sunitec Enterprise Co.,Ltd",
        "38:1F:8D": "Tuya Smart Inc.",
        "04:CD:15": "Silicon Laboratories",
        "A0:B5:3C": "Technicolor Delivery Technologies Belgium NV",
        "70:09:71": "Samsung Electronics Co.,Ltd",
        "D0:1B:49": "Samsung Electronics Co.,Ltd",
        "34:29:EF": "Qingdao Haier Technology Co.,Ltd",
        "54:1D:61": "YEESTOR Microelectronics Co., Ltd",
        "34:53:D2": "Sagemcom Broadband SAS",
        "C4:BD:E5": "Intel Corporate",
        "30:35:C5": "Huawei Device Co., Ltd.",
        "64:9E:31": "Beijing Xiaomi Mobile Software Co., Ltd",
        "F8:20:A9": "Huawei Device Co., Ltd.",
        "24:CD:8D": "Murata Manufacturing Co., Ltd.",
        "34:AA:31": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "48:BD:4A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A8:D4:E0": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A0:40:6F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:4F:1A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:69:8E": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "74:33:A6": "Shenzhen SuperElectron Technology Co.,Ltd.",
        "2C:0D:A7": "Intel Corporate",
        "BC:2C:E6": "Cisco Systems, Inc",
        "CC:ED:4D": "Cisco Systems, Inc",
        "FC:5F:49": "Zhejiang Dahua Technology Co., Ltd.",
        "6C:B0:FD": "Shenzhen Xinghai Iot Technology Co.,Ltd",
        "D4:63:DE": "vivo Mobile Communication Co., Ltd.",
        "A8:5B:F7": "Aruba, a Hewlett Packard Enterprise Company",
        "64:2C:0F": "vivo Mobile Communication Co., Ltd.",
        "30:AF:CE": "vivo Mobile Communication Co., Ltd.",
        "DC:8C:1B": "vivo Mobile Communication Co., Ltd.",
        "0C:90:43": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "18:E7:77": "vivo Mobile Communication Co., Ltd.",
        "6C:D9:4C": "vivo Mobile Communication Co., Ltd.",
        "CC:71:90": "VIETNAM POST AND TELECOMMUNICATION INDUSTRY TECHNOLOGY JOINT STOCK COMPANY",
        "B0:F7:C4": "Amazon Technologies Inc.",
        "18:A9:A6": "Nebra Ltd",
        "8C:56:46": "LG Electronics",
        "DC:2C:6E": "Routerboard.com",
        "14:00:E9": "Mitel Networks Corporation",
        "AC:AC:E2": "CHANGHONG (HONGKONG) TRADING LIMITED",
        "4C:8D:53": "HUAWEI TECHNOLOGIES CO.,LTD",
        "54:7D:40": "Powervision Tech Inc.",
        "C0:D7:AA": "Arcadyan Corporation",
        "6C:0F:0B": "China Mobile Group Device Co.,Ltd.",
        "D4:B7:D0": "Ciena Corporation",
        "20:20:27": "Shenzhen Sundray Technologies Company Limited",
        "C8:41:8A": "Samsung Electronics.,LTD",
        "4C:AB:F8": "ASKEY COMPUTER CORP",
        "F8:9E:94": "Intel Corporate",
        "18:48:BE": "Amazon Technologies Inc.",
        "68:22:8E": "Juniper Networks",
        "68:67:25": "Espressif Inc.",
        "80:B7:45": "The Silk Technologies ILC LTD",
        "C4:03:A8": "Intel Corporate",
        "64:42:12": "Shenzhen Water World Information Co.,Ltd.",
        "88:6E:E1": "Erbe Elektromedizin GmbH",
        "C4:75:AB": "Intel Corporate",
        "0C:B0:88": "AITelecom",
        "DC:97:3A": "Verana Networks",
        "20:66:FD": "CONSTELL8 NV",
        "9C:00:D3": "SHENZHEN IK WORLD Technology Co., Ltd",
        "28:2D:06": "AMPAK Technology,Inc.",
        "20:2B:20": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "88:4D:7C": "Apple, Inc.",
        "A8:FE:9D": "Apple, Inc.",
        "A0:A3:09": "Apple, Inc.",
        "5C:50:D9": "Apple, Inc.",
        "00:0A:08": "Alps Alpine",
        "E8:CA:C8": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "D4:19:F6": "NXP Semiconductor (Tianjin) LTD.",
        "A0:4C:0C": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "40:AC:BF": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "64:BF:6B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:49:9E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "FC:76:92": "Semptian Co.,Ltd.",
        "FC:AF:BE": "TireCheck GmbH",
        "9C:EC:61": "Huawei Device Co., Ltd.",
        "B0:33:66": "vivo Mobile Communication Co., Ltd.",
        "7C:C2:25": "Samsung Electronics Co.,Ltd",
        "74:70:69": "Huawei Device Co., Ltd.",
        "14:FB:70": "Huawei Device Co., Ltd.",
        "84:D3:D5": "Huawei Device Co., Ltd.",
        "D4:13:F8": "Peplink International Ltd.",
        "C8:5A:CF": "HP Inc.",
        "9C:1C:6D": "HEFEI DATANG STORAGE TECHNOLOGY CO.,LTD",
        "FC:29:E3": "Infinix mobility limited",
        "88:C2:27": "HUAWEI TECHNOLOGIES CO.,LTD",
        "80:54:D9": "HUAWEI TECHNOLOGIES CO.,LTD",
        "48:B4:23": "Amazon Technologies Inc.",
        "70:70:AA": "Amazon Technologies Inc.",
        "9C:85:66": "Wingtech Mobile Communications Co.,Ltd.",
        "94:A9:A8": "Texas Instruments",
        "64:2F:C7": "New H3C Technologies Co., Ltd",
        "60:26:AA": "Cisco Systems, Inc",
        "5C:31:92": "Cisco Systems, Inc",
        "A8:3A:48": "Ubiqcom India Pvt Ltd",
        "F4:13:99": "Aerospace new generation communications Co.,Ltd",
        "64:1A:BA": "Dryad Networks GmbH",
        "34:94:54": "Espressif Inc.",
        "A4:43:8C": "ARRIS Group, Inc.",
        "94:DE:B8": "Silicon Laboratories",
        "04:0D:84": "Silicon Laboratories",
        "4C:19:5D": "Sagemcom Broadband SAS",
        "00:80:C2": "IEEE 802.1 Chair",
        "48:02:86": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "98:67:2E": "Skullcandy",
        "D4:35:38": "Beijing Xiaomi Mobile Software Co., Ltd",
        "10:CE:02": "Amazon Technologies Inc.",
        "D8:53:9A": "Juniper Networks",
        "54:F8:2A": "u-blox AG",
        "64:CF:13": "Weigao Nikkiso(Weihai)Dialysis Equipment Co.,Ltd",
        "8C:49:7A": "Extreme Networks, Inc.",
        "40:32:9D": "Union Image Co.,Ltd",
        "4C:77:13": "Renesas Electronics (Penang) Sdn. Bhd.",
        "6C:4B:B4": "HUMAX Co., Ltd.",
        "58:9B:F7": "Hefei Radio Communication Technology Co., Ltd ",
        "50:E9:DF": "Quectel Wireless Solutions Co.,Ltd.",
        "44:1B:88": "Apple, Inc.",
        "80:04:5F": "Apple, Inc.",
        "9C:3E:53": "Apple, Inc.",
        "C8:89:F3": "Apple, Inc.",
        "E8:FA:23": "Huawei Device Co., Ltd.",
        "EC:3A:52": "Huawei Device Co., Ltd.",
        "60:10:9E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "44:EA:30": "Samsung Electronics Co.,Ltd",
        "9C:2F:9D": "Liteon Technology Corporation",
        "A4:F3:3B": "zte corporation",
        "30:E7:BC": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "7C:B5:66": "Intel Corporate",
        "90:11:95": "Amazon Technologies Inc.",
        "10:B9:C4": "Apple, Inc.",
        "CC:7D:5B": "Telink Semiconductor (Shanghai) Co., Ltd.",
        "74:95:52": "Xuzhou WIKA Electronics Control Technology Co., Ltd.",
        "A8:13:06": "vivo Mobile Communication Co., Ltd.",
        "1C:34:F1": "Silicon Laboratories",
        "B4:31:61": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "4C:FE:2E": "DongGuan Siyoto Electronics Co., Ltd       ",
        "84:5F:04": "Samsung Electronics Co.,Ltd",
        "F8:C1:16": "Juniper Networks",
        "EC:9B:2D": "China Mobile Group Device Co.,Ltd.",
        "AC:93:C4": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "48:CA:C6": "UNIONMAN TECHNOLOGY CO.,LTD",
        "4C:63:EB": "Application Solutions (Electronics and Vision) Ltd",
        "60:8C:DF": "Beamtrail-Sole Proprietorship",
        "D0:1B:1F": "OHSUNG",
        "0C:4E:C0": "Maxlinear Inc",
        "FC:38:C4": "China Grand Communications Co.,Ltd.",
        "5C:F5:1A": "Zhejiang Dahua Technology Co., Ltd.",
        "D8:AA:59": "Tonly Technology Co. Ltd ",
        "2C:FD:B3": "Tonly Technology Co. Ltd ",
        "CC:8C:BF": "Tuya Smart Inc.",
        "04:CF:4B": "Intel Corporate",
        "C0:18:03": "HP Inc.",
        "2C:78:4C": "Iton Technology Corp.",
        "48:87:59": "Xiaomi Communications Co Ltd",
        "AC:1E:9E": "Xiaomi Communications Co Ltd",
        "E0:AE:A2": "HUAWEI TECHNOLOGIES CO.,LTD",
        "44:45:6F": "SHENZHEN ONEGA TECHNOLOGY CO.,LTD",
        "34:97:6F": "Rootech, Inc.",
        "E8:FD:F8": "Shanghai High-Flying Electronics  Technology Co., Ltd",
        "6C:6C:0F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:97:A9": "Ericsson AB",
        "98:CA:20": "Shanghai SIMCOM Ltd.",
        "DC:15:2D": "China Mobile Group Device Co.,Ltd.",
        "00:D8:A2": "Huawei Device Co., Ltd.",
        "DC:6B:1B": "Huawei Device Co., Ltd.",
        "34:28:40": "Apple, Inc.",
        "18:E7:B0": "Apple, Inc.",
        "50:57:8A": "Apple, Inc.",
        "D4:9F:DD": "Huawei Device Co., Ltd.",
        "D0:6D:C9": "Sagemcom Broadband SAS",
        "08:57:FB": "Amazon Technologies Inc.",
        "D4:FB:8E": "Apple, Inc.",
        "B0:DE:28": "Apple, Inc.",
        "7C:13:1D": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
        "D8:33:B7": "Sagemcom Broadband SAS",
        "D8:50:A1": "Hunan Danuo Technology Co.,LTD",
        "44:1A:AC": "Elektrik Uretim AS EOS",
        "48:51:D0": "Jiangsu Xinsheng Intelligent Technology Co., Ltd. ",
        "80:77:A4": "TECNO MOBILE LIMITED",
        "B4:28:75": "Futecho Solutions Private Limited",
        "30:23:64": "Nokia Shanghai Bell Co., Ltd.",
        "0C:1C:1A": "eero inc.",
        "00:C3:0A": "Xiaomi Communications Co Ltd",
        "88:52:EB": "Xiaomi Communications Co Ltd",
        "7C:6C:F0": "Shenzhen TINNO Mobile Technology Corp.",
        "00:A0:A2": "B810 S.R.L.",
        "38:68:BE": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "DC:9A:7D": "HISENSE VISUAL TECHNOLOGY CO.,LTD",
        "28:A5:3F": "vivo Mobile Communication Co., Ltd.",
        "8C:49:B6": "vivo Mobile Communication Co., Ltd.",
        "84:F1:D0": "EHOOME IOT PRIVATE LIMITED",
        "20:8B:D1": "NXP Semiconductor (Tianjin) LTD.",
        "00:0F:A0": "Canon Korea Inc.",
        "30:BB:7D": "OnePlus Technology (Shenzhen) Co., Ltd",
        "6C:67:EF": "HUAWEI TECHNOLOGIES CO.,LTD",
        "88:69:3D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:99:1D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B8:3F:D2": "Mellanox Technologies, Inc.",
        "28:3E:0C": "Preferred Robotics, Inc.",
        "30:CB:36": "Belden Singapore Pte. Ltd.",
        "8C:17:59": "Intel Corporate",
        "04:BC:9F": "Calix Inc.",
        "BC:6E:6D": "EM Microelectronic",
        "B0:4A:6A": "Samsung Electronics Co.,Ltd",
        "A8:79:8D": "Samsung Electronics Co.,Ltd",
        "5C:ED:F4": "Samsung Electronics Co.,Ltd",
        "34:92:C2": "Square Route Co., Ltd.",
        "28:3D:C2": "Samsung Electronics Co.,Ltd",
        "00:D4:9E": "Intel Corporate",
        "6C:A4:01": "essensys plc",
        "CC:F3:05": "SHENZHEN TIAN XING CHUANG ZHAN ELECTRONIC CO.,LTD",
        "34:BD:20": "Hangzhou Hikrobot Technology Co., Ltd.",
        "64:C2:69": "eero inc.",
        "AC:2A:A1": "Cisco Systems, Inc",
        "F8:E9:4F": "Cisco Systems, Inc",
        "30:89:4A": "Intel Corporate",
        "B8:D6:1A": "Espressif Inc.",
        "BC:F4:D4": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "D8:9C:8E": "Comcast Cable Corporation",
        "74:56:3C": "GIGA-BYTE TECHNOLOGY CO.,LTD.",
        "EC:55:1C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "8C:6B:DB": "Huawei Device Co., Ltd.",
        "10:DA:49": "Huawei Device Co., Ltd.",
        "60:18:3A": "Huawei Device Co., Ltd.",
        "18:C0:07": "Huawei Device Co., Ltd.",
        "E0:6C:C5": "Huawei Device Co., Ltd.",
        "30:96:3B": "Huawei Device Co., Ltd.",
        "90:B5:7F": "Shenzhen iComm Semiconductor CO.,LTD",
        "98:59:7A": "Intel Corporate",
        "64:49:7D": "Intel Corporate",
        "B4:83:51": "Intel Corporate",
        "00:25:CA": "Laird Connectivity",
        "04:B9:7D": "AiVIS Co., Itd.",
        "C4:C0:63": "New H3C Technologies Co., Ltd",
        "54:43:B2": "Espressif Inc.",
        "C0:DD:8A": "Facebook Technologies, LLC",
        "E0:79:8D": "Silicon Laboratories",
        "34:AD:61": "CELESTICA INC.",
        "10:96:1A": "CHIPSEA TECHNOLOGIES (SHENZHEN) CORP.",
        "BC:E9:E2": "Brocade Communications Systems LLC",
        "AC:BF:71": "Bose Corporation",
        "18:A5:9C": "IEEE Registration Authority",
        "AC:D3:1D": "Cisco Meraki",
        "74:84:69": "Nintendo Co.,Ltd",
        "74:71:8B": "Apple, Inc.",
        "70:31:7F": "Apple, Inc.",
        "A4:CF:99": "Apple, Inc.",
        "4C:2E:B4": "Apple, Inc.",
        "B4:19:74": "Apple, Inc.",
        "04:E8:92": "SHENNAN CIRCUITS CO.,LTD",
        "00:18:48": "Vecima Networks Inc.",
        "2C:55:3C": "Vecima Networks Inc.",
        "60:95:BD": "Apple, Inc.",
        "00:1A:35": "BARTEC GmbH",
        "8C:CB:DF": "FOXCONN INTERCONNECT TECHNOLOGY ",
        "98:F1:12": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "84:69:93": "HP Inc.",
        "98:C8:1C": "BAYTEC LIMITED",
        "D0:98:9C": "ConMet",
        "24:26:D6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "EC:81:9C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "1C:A4:10": "Amlogic, Inc.",
        "20:0B:16": "Texas Instruments",
        "88:01:F9": "Texas Instruments",
        "F8:55:48": "Texas Instruments",
        "68:E7:4A": "Texas Instruments",
        "70:A6:BD": "Honor Device Co., Ltd.",
        "4C:9E:6C": "BROADEX TECHNOLOGIES CO.LTD",
        "54:2F:04": "Shanghai Longcheer Technology Co., Ltd.",
        "E4:B6:33": "Wuxi Stars Microsystem Technology Co., Ltd",
        "08:51:04": "Huawei Device Co., Ltd.",
        "78:5B:64": "Huawei Device Co., Ltd.",
        "54:E1:5B": "Huawei Device Co., Ltd.",
        "AC:C4:BD": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "AC:A3:2F": "Solidigm Technology",
        "C4:A1:0E": "IEEE Registration Authority",
        "AC:71:2E": "Fortinet, Inc.",
        "0C:EC:84": "Shenzhen TINNO Mobile Technology Corp.",
        "B4:39:39": "Shenzhen TINNO Mobile Technology Corp.",
        "8C:98:06": "SHENZHEN SEI ROBOTICS CO.,LTD",
        "70:70:FC": "GOLD&WATER INDUSTRIAL LIMITED",
        "98:D9:3D": "Demant Enterprise A/S",
        "B4:A6:78": "Zhejiang Tmall Technology Co., Ltd.",
        "88:F2:BD": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "A0:F8:95": "Shenzhen TINNO Mobile Technology Corp.",
        "6C:08:31": "ANALOG SYSTEMS",
        "2C:07:F6": "SKG Health Technologies Co., Ltd. ",
        "00:24:E4": "Withings",
        "A4:7E:FA": "Withings",
        "78:91:DE": "Guangdong ACIGA Science&Technology Co.,Ltd",
        "E0:80:6B": "Xiaomi Communications Co Ltd",
        "70:AC:08": "Silicon Laboratories",
        "70:50:E7": "IEEE Registration Authority",
        "00:13:B4": "Appear AS",
        "38:12:7B": "Crenet Labs Co., Ltd.",
        "B0:E4:5C": "Samsung Electronics Co.,Ltd",
        "3C:26:E4": "Cisco Systems, Inc",
        "38:91:B7": "Cisco Systems, Inc",
        "34:5D:A8": "Cisco Systems, Inc",
        "BC:4C:A0": "HUAWEI TECHNOLOGIES CO.,LTD",
        "74:34:2B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "68:7F:F0": "TP-Link Corporation Limited",
        "DC:36:0C": "Hitron Technologies. Inc",
        "38:FD:F5": "Renesas Electronics (Penang) Sdn. Bhd.",
        "C4:12:EC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "60:CF:69": "meerecompany",
        "4C:62:7B": "SmartCow AI Technologies Taiwan Ltd.",
        "BC:7B:72": "Huawei Device Co., Ltd.",
        "F8:2B:7F": "Huawei Device Co., Ltd.",
        "40:C3:BC": "Huawei Device Co., Ltd.",
        "34:FE:1C": "CHOUNG HWA TECH CO.,LTD",
        "D8:68:A0": "Samsung Electronics Co.,Ltd",
        "04:29:2E": "Samsung Electronics Co.,Ltd",
        "6C:C2:42": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "28:53:E0": "Sintela Ltd",
        "F4:93:9F": "Hon Hai Precision Industry Co., Ltd.",
        "AC:4E:65": "Fiberhome Telecommunication Technologies Co.,LTD",
        "BC:5D:A3": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "80:72:15": "SKY UK LIMITED",
        "B0:3E:51": "SKY UK LIMITED",
        "80:75:1F": "SKY UK LIMITED",
        "A4:AE:12": "Hon Hai Precision Industry Co., Ltd.",
        "C0:A3:6E": "SKY UK LIMITED",
        "00:A3:88": "SKY UK LIMITED",
        "38:F0:C8": "Logitech",
        "1C:EF:03": "Guangzhou V-SOLUTION Electronic Technology Co., Ltd.",
        "58:B0:3E": "Nintendo Co.,Ltd",
        "74:13:EA": "Intel Corporate",
        "18:7A:3E": "Silicon Laboratories",
        "30:05:05": "Intel Corporate",
        "B0:DC:EF": "Intel Corporate",
        "28:BC:05": "BLU Products Inc",
        "2C:A7:74": "Texas Instruments",
        "18:4E:03": "HMD Global Oy",
        "E0:08:71": "Dongguan Liesheng Electronic Co., Ltd.",
        "9C:95:6E": "Microchip Technology Inc.",
        "DC:0B:09": "Cisco Systems, Inc",
        "08:F3:FB": "Cisco Systems, Inc",
        "DC:F3:1C": "Texas Instruments",
        "54:45:38": "Texas Instruments",
        "78:C2:13": "Sagemcom Broadband SAS",
        "40:22:D8": "Espressif Inc.",
        "A0:36:BC": "ASUSTek COMPUTER INC.",
        "10:73:EB": "Infiniti Electro-Optics",
        "84:0B:BB": "MitraStar Technology Corp.",
        "04:D9:C8": "Hon Hai Precision Industry Co., Ltd.",
        "A0:FB:83": "Honor Device Co., Ltd.",
        "9C:92:4F": "Apple, Inc.",
        "20:0E:2B": "Apple, Inc.",
        "F0:D7:93": "Apple, Inc.",
        "70:B3:06": "Apple, Inc.",
        "B8:49:6D": "Apple, Inc.",
        "90:65:60": "EM Microelectronic",
        "88:0A:A3": "Juniper Networks",
        "30:3D:51": "IEEE Registration Authority",
        "CC:D3:C1": "Vestel Elektronik San ve Tic. A.S.",
        "EC:BE:5F": "Vestel Elektronik San ve Tic. A.S.",
        "F4:BB:C7": "vivo Mobile Communication Co., Ltd.",
        "4C:36:4E": "Panasonic Connect Co., Ltd.",
        "44:71:47": "Beijing Xiaomi Electronics Co.,Ltd",
        "A8:DC:5A": "Digital Watchdog",
        "1C:24:CD": "ASKEY COMPUTER CORP",
        "64:37:A4": "TOKYOSHUHA CO.,LTD.",
        "90:CA:FA": "Google, Inc.",
        "38:A8:9B": "Fiberhome Telecommunication Technologies Co.,LTD",
        "00:FB:F9": "Axiado Corporation",
        "DC:AA:43": "Shenzhen Terca Information Technology Co., Ltd.",
        "88:B4:36": "FUJIFILM Corporation",
        "30:27:CF": "Canopy Growth Corp",
        "44:16:FA": "Samsung Electronics Co.,Ltd",
        "FC:67:1F": "Tuya Smart Inc.",
        "84:3C:4C": "Robert Bosch SRL",
        "6C:72:E2": "amitek",
        "78:F1:C6": "Cisco Systems, Inc",
        "34:1B:2D": "Cisco Systems, Inc",
        "64:B5:F2": "Samsung Electronics Co.,Ltd",
        "10:E8:40": "ZOWEE TECHNOLOGY(HEYUAN) CO., LTD.",
        "44:05:E8": "twareLAB",
        "8C:06:CB": "Toradex AG",
        "A4:0E:75": "Aruba, a Hewlett Packard Enterprise Company",
        "78:C5:7D": "Zyxel Communications Corporation",
        "98:9D:E5": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "44:5A:DF": "MIKAMI & CO., LTD.",
        "8C:35:92": "Guangzhou Shiyuan Electronic Technology Company Limited",
        "6C:B1:33": "Apple, Inc.",
        "28:E7:1D": "Arista Networks",
        "A0:46:5A": "Motorola Mobility LLC, a Lenovo Company",
        "08:6E:9C": "Huawei Device Co., Ltd.",
        "C4:AC:AA": "Apple, Inc.",
        "2C:32:6A": "Apple, Inc.",
        "88:28:7D": "AltoBeam (China) Inc.",
        "D0:DA:D7": "Apple, Inc.",
        "C4:D4:96": "Shenzhen Excelsecu Data Technology Co.,Ltd",
        "00:26:7F": "Oregan Networks Ltd.",
        "44:8C:AB": "Beijing Flitlink Vientiane Technology Co., LTD",
        "14:21:03": "Calix Inc.",
        "34:25:B4": "Silicon Laboratories",
        "28:80:8A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:66:79": "HUAWEI TECHNOLOGIES CO.,LTD",
        "40:B1:5C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:03:B1": "ICU Medical, Inc.",
        "68:26:24": "Ergatta",
        "70:4D:E7": "TECNO MOBILE LIMITED",
        "74:D8:73": "GUANGDONG GENIUS TECHNOLOGY CO., LTD.",
        "4C:24:CE": "Sichuan AI-Link Technology Co., Ltd.",
        "1C:97:FB": "CoolBitX Ltd.",
        "A0:21:8B": "ACE Antenna Co., ltd",
        "6C:97:AA": "AI TECHNOLOGY CO.,LTD.",
        "6C:65:67": "BELIMO Automation AG",
        "20:84:F5": "Yufei Innovation Software(Shenzhen) Co., Ltd.",
        "30:DE:4B": "TP-Link Corporation Limited",
        "EC:96:BF": "eSystems MTG GmbH",
        "A4:9D:DD": "Samsung Electronics Co.,Ltd",
        "6C:55:63": "Samsung Electronics Co.,Ltd",
        "3C:1B:F8": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "D4:92:B9": "ORION NOVA, S.L.",
        "14:AC:60": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "1C:22:85": "Serrature Meroni SpA",
        "58:F3:87": "Airios",
        "68:B8:BB": "Beijing Xiaomi Electronics Co.,Ltd",
        "50:FD:D5": "SJI Industry Company",
        "80:DB:17": "Juniper Networks",
        "68:AA:C4": "Altice Labs S.A.",
        "D4:20:00": "IEEE Registration Authority",
        "80:FD:7B": "BLU Products Inc",
        "58:93:51": "Huawei Device Co., Ltd.",
        "E0:DB:D1": "Technicolor CH USA Inc.",
        "EC:A8:1F": "Technicolor CH USA Inc.",
        "2C:A7:EF": "OnePlus Technology (Shenzhen) Co., Ltd",
        "48:4B:D4": "Technicolor CH USA Inc.",
        "D4:E9:8A": "Intel Corporate",
        "CC:A1:74": "Facebook Technologies, LLC",
        "8C:FA:DD": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:9A:25": "HUAWEI TECHNOLOGIES CO.,LTD",
        "6C:3C:8C": "Dell Inc.",
        "F8:71:0C": "Xiaomi Communications Co Ltd",
        "3C:13:5A": "Xiaomi Communications Co Ltd",
        "6C:5C:B1": "Silicon Laboratories",
        "C0:84:E0": "HUAWEI TECHNOLOGIES CO.,LTD",
        "90:01:17": "HUAWEI TECHNOLOGIES CO.,LTD",
        "38:BD:7A": "Aruba, a Hewlett Packard Enterprise Company",
        "D0:F4:F7": "Huawei Device Co., Ltd.",
        "38:9E:80": "zte corporation",
        "08:3A:8D": "Espressif Inc.",
        "FC:E9:D8": "Amazon Technologies Inc.",
        "C4:98:94": "IEEE Registration Authority",
        "B8:B2:F7": "DRIMAES INC.",
        "64:29:43": "D-Link Corporation",
        "38:65:04": "Honor Device Co., Ltd.",
        "58:5B:69": "TVT CO., LTD",
        "A8:F1:B2": "Allwinner Technology Co., Ltd",
        "90:F8:2E": "Amazon Technologies Inc.",
        "C4:5A:B1": "Dell Inc.",
        "94:98:69": "zte corporation",
        "F8:56:C3": "zte corporation",
        "54:1F:8D": "zte corporation",
        "2C:F1:BB": "zte corporation",
        "D8:4A:2B": "zte corporation",
        "D0:F9:9B": "zte corporation",
        "74:6F:88": "zte corporation",
        "20:08:89": "zte corporation",
        "98:66:10": "zte corporation",
        "28:77:77": "zte corporation",
        "30:B9:30": "zte corporation",
        "70:C9:32": "Dreame Technology (Suzhou) Limited",
        "F8:34:5A": "Hitron Technologies. Inc",
        "E0:B6:68": "zte corporation",
        "C4:EB:42": "Sagemcom Broadband SAS",
        "F8:C2:49": "AMPERE COMPUTING LLC",
        "A0:17:F1": "Allwinner Technology Co., Ltd",
        "2C:6F:4E": "Hubei Yuan Times Technology Co.,Ltd.",
        "64:8C:BB": "Texas Instruments",
        "74:B8:39": "Texas Instruments",
        "C4:D3:6A": "Texas Instruments",
        "98:89:24": "Texas Instruments",
        "B0:8B:BE": "ABL GmbH",
        "48:8F:4C": "shenzhen trolink  Technology Co.,Ltd",
        "74:4D:6D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:15:93": "Ruckus Wireless",
        "10:9F:4F": "New H3C Intelligence Terminal Co., Ltd.",
        "A0:ED:6D": "Ubee Interactive Co., Limited",
        "AC:C9:06": "Apple, Inc.",
        "04:BC:6D": "Apple, Inc.",
        "44:0C:EE": "Robert Bosch Elektronikai Kft.",
        "30:19:84": "HUAWEI TECHNOLOGIES CO.,LTD",
        "80:DE:CC": "HYBE Co.,LTD",
        "C4:35:D9": "Apple, Inc.",
        "44:D5:06": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "2C:69:CC": "Valeo Detection Systems ",
        "5C:C7:C1": "Silicon Laboratories",
        "D0:CF:0E": "Sagemcom Broadband SAS",
        "9C:DB:07": "Yellowtec GmbH",
        "D4:61:37": "IEEE Registration Authority",
        "10:5F:02": "Private",
        "08:08:5C": "Luna Products",
        "B4:57:E6": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "BC:BD:84": "zte corporation",
        "2C:8A:C7": "Ubee Interactive Co., Limited",
        "B8:F0:15": "Juniper Networks",
        "28:E2:97": "Shanghai InfoTM Microelectronics Co.,Ltd",
        "58:F8:5C": "LLC Proizvodstvennaya Kompania TransService",
        "1C:8B:EF": "Beijing Xiaomi Electronics Co.,Ltd",
        "50:D4:5C": "Amazon Technologies Inc.",
        "70:03:3F": "Pimax Technology(ShangHai)Co.,Ltd",
        "80:F1:A4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A4:6C:24": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:07:1C": "Green Energy Options Ltd",
        "EC:C3:B0": "zte corporation",
        "08:7B:12": "Sagemcom Broadband SAS",
        "E4:DB:AE": "Extreme Networks, Inc.",
        "30:44:49": "PLATH Signal Products GmbH & Co. KG",
        "5C:B1:2E": "Cisco Systems, Inc",
        "BC:6B:FF": "Guangzhou Shiyuan Electronic Technology Company Limited",
        "3C:6A:48": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "FC:2A:46": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "40:B6:07": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "F4:4D:5C": "Zyxel Communications Corporation",
        "80:61:6C": "New H3C Technologies Co., Ltd",
        "E4:23:3C": "Juniper Networks",
        "9C:FA:3C": "Daeyoung Electronics",
        "FC:B0:DE": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "1C:C3:16": "Xiamen Milesight IoT Co., Ltd.",
        "64:C6:D2": "Seiko Epson Corporation",
        "78:24:59": "Alcatel-Lucent Enterprise",
        "28:CF:51": "Nintendo Co.,Ltd",
        "0C:35:26": "Microsoft Corporation",
        "00:24:BF": "Carrier Culoz SA",
        "B8:3C:28": "Apple, Inc.",
        "3C:6D:89": "Apple, Inc.",
        "AC:45:00": "Apple, Inc.",
        "84:B1:E4": "Apple, Inc.",
        "54:EB:E9": "Apple, Inc.",
        "AC:16:15": "Apple, Inc.",
        "48:BD:CE": "Technicolor CH USA Inc.",
        "48:1F:66": "China Mobile Group Device Co.,Ltd.",
        "10:68:38": "AzureWave Technology Inc.",
        "74:86:69": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "C8:0A:35": "Qingdao Hisense Smart Life Technology Co., Ltd",
        "14:1A:AA": "Metal Work SpA",
        "CC:DE:DE": "Nokia",
        "EC:F8:D0": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:DF:17": "ALPSALPINE CO,.LTD",
        "D8:02:8A": "Shenzhen YOUHUA Technology Co., Ltd",
        "88:CE:3F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "60:B6:47": "Silicon Laboratories",
        "EC:73:79": "Apple, Inc.",
        "04:70:56": "Arcadyan Corporation",
        "40:FF:40": "GloquadTech",
        "E8:65:38": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "D4:04:E6": "Broadcom Limited",
        "DC:E3:05": "AO ",
        "B8:94:D9": "Texas Instruments",
        "7C:E2:69": "Texas Instruments",
        "88:6D:2D": "Huawei Device Co., Ltd.",
        "08:04:B4": "Texas Instruments",
        "30:AF:7E": "Texas Instruments",
        "24:2A:04": "Cisco Systems, Inc",
        "24:95:2F": "Google, Inc.",
        "10:BE:99": "Netberg",
        "60:DE:F4": "Shenzhen iComm Semiconductor CO.,LTD",
        "84:D3:52": "Tonly Technology Co. Ltd ",
        "E4:21:50": "Shanghai Chint low voltage electrical technology Co.,Ltd.",
        "F8:D7:58": "Veratron AG",
        "24:FE:9A": "CyberTAN Technology Inc.",
        "B4:CB:B8": "Universal Electronics, Inc.",
        "BC:32:B2": "Samsung Electronics Co.,Ltd",
        "80:D2:66": "ScaleFlux",
        "28:EB:A6": "Nex-T LLC",
        "E8:10:98": "Aruba, a Hewlett Packard Enterprise Company",
        "CC:4D:74": "Fujian Newland Payment Technology Co., Ltd.",
        "A0:31:EB": "Semikron Elektronik GmbH & Co. KG",
        "EC:8A:48": "Arista Networks",
        "98:86:8B": "Juniper Networks",
        "8C:5D:B2": "IEEE Registration Authority",
        "C0:B3:C8": "LLC NTC Rotek",
        "3C:1E:B5": "Apple, Inc.",
        "AC:86:A3": "Apple, Inc.",
        "74:87:2E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "40:45:C4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "74:95:A7": "Keyence Corporation",
        "F4:EE:31": "Cisco Systems, Inc",
        "14:1A:97": "Apple, Inc.",
        "88:62:5D": "BITNETWORKS CO.,LTD",
        "B4:B9:E6": "eero inc.",
        "68:59:32": "Sunitec Enterprise Co.,Ltd",
        "C8:36:A3": "GERTEC BRASIL LTDA",
        "30:B2:16": "Hitachi Energy Germany AG",
        "CC:9F:7A": "Chiun Mai Communication System, Inc",
        "54:14:A7": "Nanjing Qinheng Microelectronics Co., Ltd.",
        "A0:A3:B3": "Espressif Inc.",
        "34:98:7A": "Espressif Inc.",
        "00:58:28": "Axon Networks Inc.",
        "38:07:16": "FREEBOX SAS",
        "5C:6A:EC": "IEEE Registration Authority",
        "4C:E7:05": "Siemens Industrial Automation Products Ltd., Chengdu",
        "0C:72:74": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "48:BD:A7": "Honor Device Co., Ltd.",
        "EC:21:50": "vivo Mobile Communication Co., Ltd.",
        "A0:AF:12": "HUAWEI TECHNOLOGIES CO.,LTD",
        "AC:8B:A9": "Ubiquiti Inc",
        "9C:05:D6": "Ubiquiti Inc",
        "28:70:4E": "Ubiquiti Inc",
        "60:96:A4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:45:58": "Ubiquiti Inc",
        "04:A5:26": "Nokia",
        "D8:0A:E6": "zte corporation",
        "48:9E:9D": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "9C:54:16": "Cisco Systems, Inc",
        "9C:65:EE": "DZS Inc.",
        "20:BA:36": "u-blox AG",
        "84:80:94": "Meter, Inc.",
        "10:B3:D5": "Cisco Systems, Inc",
        "30:A2:C2": "Huawei Device Co., Ltd.",
        "DC:DF:D6": "zte corporation",
        "AC:A8:8E": "SHARP Corporation",
        "98:41:5C": "Nintendo Co.,Ltd",
        "70:54:25": "ARRIS Group, Inc.",
        "5C:0B:CA": "Tunstall Nordic AB",
        "28:33:34": "Huawei Device Co., Ltd.",
        "50:A1:32": "Shenzhen MiaoMing  Intelligent Technology Co.,Ltd",
        "80:78:71": "ASKEY COMPUTER CORP",
        "4C:B1:CD": "Ruckus Wireless",
        "F4:9C:12": "Structab AB",
        "88:51:7A": "HMD Global Oy",
        "AC:B3:B5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "08:3A:88": "Universal Global Scientific Industrial Co., Ltd.",
        "08:31:8B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F4:B6:88": "PLANTRONICS, INC.",
        "4C:7A:48": "Nippon Seiki (Europe) B.V.",
        "84:D1:5A": "TCT mobile ltd",
        "B8:F6:53": "Shenzhen Jingxun Software Telecommunication Technology Co.,Ltd",
        "60:AB:14": "LG Innotek",
        "BC:62:D2": "Genexis International B.V.",
        "6C:9E:7C": "Fiberhome Telecommunication Technologies Co.,LTD",
        "44:D5:F2": "IEEE Registration Authority",
        "00:0C:86": "Cisco Systems, Inc",
        "F8:3C:BF": "BOTATO ELECTRONICS SDN BHD",
        "FC:58:9A": "Cisco Systems, Inc",
        "F0:86:20": "Arcadyan Corporation",
        "DC:CC:8D": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "F0:5C:77": "Google, Inc.",
        "11:11:11": "Private",
        "6C:D7:1F": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "F0:68:65": "Taicang T&W Electronics",
        "A4:63:A1": "Inventus Power Eletronica do Brasil LTDA",
        "3C:9D:56": "HUAWEI TECHNOLOGIES CO.,LTD",
        "70:FD:45": "HUAWEI TECHNOLOGIES CO.,LTD",
        "44:67:47": "HUAWEI TECHNOLOGIES CO.,LTD",
        "88:4A:70": "Wacom Co.,Ltd.",
        "F4:B5:BB": "CERAGON NETWORKS",
        "50:7A:C5": "Apple, Inc.",
        "4C:6B:E8": "Apple, Inc.",
        "8C:86:1E": "Apple, Inc.",
        "54:2B:8D": "Apple, Inc.",
        "00:1D:29": "Doro AB",
        "EC:A5:DE": "ONYX WIFI Inc",
        "10:33:BF": "Technicolor CH USA Inc.",
        "34:75:63": "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD.",
        "14:2E:5E": "Sercomm Corporation.",
        "00:25:CB": "Reiner SCT",
        "44:23:7C": "Beijing Xiaomi Mobile Software Co., Ltd",
        "C0:64:E4": "Cisco Systems, Inc",
        "30:94:35": "vivo Mobile Communication Co., Ltd.",
        "D4:4B:B6": "Zhejiang Tmall Technology Co., Ltd.",
        "38:18:4C": "Sony Home Entertainment&Sound Products Inc",
        "D8:2F:E6": "Zhejiang Tmall Technology Co., Ltd.",
        "14:0F:42": "Nokia",
        "00:6D:61": "Guangzhou V-SOLUTION Electronic Technology Co., Ltd.",
        "C4:AC:59": "Murata Manufacturing Co., Ltd.",
        "FC:A4:7A": "IEEE Registration Authority",
        "E4:19:C1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B8:66:85": "Sagemcom Broadband SAS",
        "38:1A:52": "Seiko Epson Corporation",
        "00:0A:17": "NESTAR COMMUNICATIONS, INC",
        "E4:FD:A1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B4:52:A9": "Texas Instruments",
        "54:EF:44": "Lumi United Technology Co., Ltd",
        "40:2B:50": "ARRIS Group, Inc.",
        "78:CC:2B": "SINEWY TECHNOLOGY CO., LTD",
        "D0:C8:57": "IEEE Registration Authority",
        "FC:BC:D1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "74:60:FA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "38:EF:E3": "INGENICO TERMINALS SAS",
        "50:D4:F7": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "00:1F:47": "MCS Logic Inc.",
        "8C:FD:18": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B4:54:59": "China Mobile (Hangzhou) Information Technology Co., Ltd.",
        "00:09:70": "Vibration Research Corporation",
        "14:A2:A0": "Cisco Systems, Inc",
        "E4:AB:89": "MitraStar Technology Corp.",
        "78:C3:13": "China Mobile Group Device Co.,Ltd.",
        "74:34:AE": "this is engineering Inc.",
        "74:AD:B7": "China Mobile Group Device Co.,Ltd.",
        "60:95:CE": "IEEE Registration Authority",
        "8C:E5:C0": "Samsung Electronics Co.,Ltd",
        "F0:8A:76": "Samsung Electronics Co.,Ltd",
        "EC:AA:25": "Samsung Electronics Co.,Ltd",
        "68:7D:6B": "Samsung Electronics Co.,Ltd",
        "48:51:69": "Samsung Electronics Co.,Ltd",
        "C4:06:83": "HUAWEI TECHNOLOGIES CO.,LTD",
        "94:D0:0D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C4:8A:5A": "JFCONTROL",
        "B4:9A:95": "Shenzhen Boomtech Industrial Corporation",
        "AC:83:E9": "Beijing Zile Technology Co., Ltd",
        "D8:CA:06": "Titan DataCenters France",
        "1C:20:DB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D0:C6:5B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "90:78:B2": "Xiaomi Communications Co Ltd",
        "B4:CF:E0": "Sichuan tianyi kanghe communications co., LTD",
        "BC:7F:A4": "Xiaomi Communications Co Ltd",
        "FC:49:2D": "Amazon Technologies Inc.",
        "74:EE:2A": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
        "08:7E:64": "Technicolor CH USA Inc.",
        "08:00:39": "SPIDER SYSTEMS LIMITED",
        "90:47:3C": "China Mobile Group Device Co.,Ltd.",
        "88:9E:33": "TCT mobile ltd",
        "6C:8A:EC": "Nantong Coship Electronics Co., Ltd.",
        "84:C2:E4": "Jiangsu Qinheng Co., Ltd.",
        "7C:21:D8": "Shenzhen Think Will Communication Technology co., LTD.",
        "FC:EA:50": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "00:E0:6B": "W&G SPECIAL PRODUCTS",
        "04:5C:6C": "Juniper Networks",
        "D8:F1:5B": "Espressif Inc.",
        "D4:F0:57": "Nintendo Co.,Ltd",
        "6C:F1:7E": "Zhejiang Uniview Technologies Co.,Ltd.",
        "08:3A:2F": "Guangzhou Juan Intelligent Tech Joint Stock Co.,Ltd",
        "1C:3A:60": "Ruckus Wireless",
        "60:09:C3": "u-blox AG",
        "48:87:64": "vivo Mobile Communication Co., Ltd.",
        "5C:1C:B9": "vivo Mobile Communication Co., Ltd.",
        "C0:FD:84": "zte corporation",
        "44:4B:7E": "Fiberhome Telecommunication Technologies Co.,LTD",
        "DC:8C:37": "Cisco Systems, Inc",
        "E8:D0:FC": "Liteon Technology Corporation",
        "E8:E8:B7": "Murata Manufacturing Co., Ltd.",
        "10:3D:3E": "China Mobile Group Device Co.,Ltd.",
        "64:CC:22": "Arcadyan Corporation",
        "4C:91:57": "Fujian LANDI Commercial Equipment Co.,Ltd",
        "9C:25:BE": "Wildlife Acoustics, Inc.",
        "D0:39:EA": "NetApp",
        "F8:DF:E1": "MyLight Systems",
        "60:D2:DD": "Shenzhen Baitong Putian Technology Co.,Ltd.",
        "78:8C:77": "LEXMARK INTERNATIONAL, INC.",
        "3C:0C:7D": "Tiny Mesh AS",
        "34:76:C5": "I-O DATA DEVICE,INC.",
        "24:DA:33": "HUAWEI TECHNOLOGIES CO.,LTD",
        "FC:AB:90": "HUAWEI TECHNOLOGIES CO.,LTD",
        "58:93:D8": "Texas Instruments",
        "50:51:A9": "Texas Instruments",
        "A4:97:5C": "VTech Telecommunications Ltd.",
        "B0:2A:1F": "Wingtech Group (HongKong）Limited",
        "DC:68:0C": "Hewlett Packard Enterprise",
        "F4:02:70": "Dell Inc.",
        "1C:27:04": "zte corporation",
        "50:78:B3": "zte corporation",
        "F0:D4:F7": "varram system",
        "E0:CC:7A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "6C:23:CB": "Wattty Corporation",
        "60:AB:67": "Xiaomi Communications Co Ltd",
        "AC:71:0C": "China Mobile Group Device Co.,Ltd.",
        "A8:DB:03": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "30:89:44": "DEVA Broadcast Ltd.",
        "F4:79:60": "HUAWEI TECHNOLOGIES CO.,LTD",
        "14:52:90": "KNS Group LLC (YADRO Company)",
        "5C:32:C5": "Teracom Ltd.",
        "AC:EE:70": "Fontem Ventures BV",
        "AC:E2:D3": "Hewlett Packard",
        "00:FD:22": "Cisco Systems, Inc",
        "44:18:FD": "Apple, Inc.",
        "00:B6:00": "VOIM Co., Ltd.",
        "98:FA:9B": "LCFC(HeFei) Electronics Technology co., ltd",
        "00:5B:94": "Apple, Inc.",
        "E0:89:7E": "Apple, Inc.",
        "B0:0C:D1": "Hewlett Packard",
        "48:46:C1": "FN-LINK TECHNOLOGY LIMITED",
        "B4:D0:A9": "China Mobile Group Device Co.,Ltd.",
        "FC:29:F3": "McPay Co.,LTD.",
        "F8:AF:DB": "Fiberhome Telecommunication Technologies Co.,LTD",
        "A0:BD:1D": "Zhejiang Dahua Technology Co., Ltd.",
        "E4:9F:1E": "ARRIS Group, Inc.",
        "00:26:15": "Teracom Limited",
        "9C:8E:DC": "Teracom Limited",
        "00:01:91": "SYRED Data Systems",
        "AC:D5:64": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "94:D0:75": "CIS Crypto",
        "28:B4:FB": "Sprocomm Technologies CO.,LTD.",
        "40:F9:D5": "Tecore Networks",
        "CC:2C:83": "DarkMatter L.L.C",
        "DC:ED:84": "Haverford Systems Inc",
        "7C:57:3C": "Aruba, a Hewlett Packard Enterprise Company",
        "2C:01:B5": "Cisco Systems, Inc",
        "C0:53:36": "Beijing National Railway Research & Design Institute of Signal & Communication Group Co..Ltd.",
        "60:6E:D0": "SEAL AG",
        "2C:CC:E6": "Skyworth Digital Technology(Shenzhen) Co.,Ltd",
        "E4:4C:C7": "IEEE Registration Authority",
        "D4:E8:80": "Cisco Systems, Inc",
        "A8:34:6A": "Samsung Electronics Co.,Ltd",
        "3C:20:F6": "Samsung Electronics Co.,Ltd",
        "7C:38:AD": "Samsung Electronics Co.,Ltd",
        "D4:9C:DD": "AMPAK Technology,Inc.",
        "50:F7:22": "Cisco Systems, Inc",
        "98:49:E1": "Boeing Defence Australia",
        "04:D7:A5": "New H3C Technologies Co., Ltd",
        "4C:4D:66": "Nanjing Jiahao Technology Co., Ltd.",
        "90:58:51": "Technicolor CH USA Inc.",
        "98:09:CF": "OnePlus Technology (Shenzhen) Co., Ltd",
        "B8:DE:5E": "LONGCHEER TELECOMMUNICATION LIMITED",
        "88:5A:06": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "54:47:D3": "TSAT AS",
        "CC:ED:DC": "MitraStar Technology Corp.",
        "68:8B:0F": "China Mobile IOT Company Limited",
        "F8:2F:6A": "ITEL MOBILE LIMITED",
        "B0:68:E6": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "A4:E7:E4": "Connex GmbH",
        "B8:EF:8B": "SHENZHEN CANNICE TECHNOLOGY CO.,LTD",
        "B8:18:6F": "ORIENTAL MOTOR CO., LTD.",
        "00:1A:3F": "Intelbras",
        "C0:D8:34": "xvtec ltd",
        "B8:C2:53": "Juniper Networks",
        "F0:5C:19": "Aruba, a Hewlett Packard Enterprise Company",
        "04:BD:88": "Aruba, a Hewlett Packard Enterprise Company",
        "9C:1C:12": "Aruba, a Hewlett Packard Enterprise Company",
        "18:DF:B4": "BOSUNG POWERTEC CO.,LTD.",
        "20:B7:80": "Toshiba Visual Solutions Corporation Co.,Ltd",
        "E0:37:17": "Technicolor CH USA Inc.",
        "14:D4:FE": "ARRIS Group, Inc.",
        "EC:A9:FA": "GUANGDONG GENIUS TECHNOLOGY CO., LTD.",
        "00:03:A5": "Medea Corporation",
        "BC:E6:7C": "Cambium Networks Limited",
        "7C:1E:06": "New H3C Technologies Co., Ltd",
        "F0:B3:1E": "Universal Electronics, Inc.",
        "F8:91:73": "AEDLE SAS",
        "C8:4F:86": "Sophos Ltd",
        "64:29:ED": "AO PKK Milandr",
        "44:3C:88": "FICOSA MAROC INTERNATIONAL",
        "84:1C:70": "zte corporation",
        "54:47:41": "XCHENG HOLDING",
        "CC:F7:35": "Amazon Technologies Inc.",
        "C4:F8:39": "Actia Automotive",
        "C8:F7:42": "HangZhou Gubei Electronics Technology Co.,Ltd",
        "00:6F:F2": "MITSUMI ELECTRIC CO.,LTD.",
        "30:DF:8D": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "D4:C9:3C": "Cisco Systems, Inc",
        "78:DD:12": "Arcadyan Corporation",
        "2C:5D:34": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "9C:14:63": "Zhejiang Dahua Technology Co., Ltd.",
        "64:60:38": "Hirschmann Automation and Control GmbH",
        "70:18:A7": "Cisco Systems, Inc",
        "CC:D3:9D": "IEEE Registration Authority",
        "D4:25:CC": "IEEE Registration Authority",
        "8C:6D:C4": "Megapixel VR",
        "D4:B7:61": "Sichuan AI-Link Technology Co., Ltd.",
        "7C:03:5E": "Xiaomi Communications Co Ltd",
        "44:FE:3B": "Arcadyan Corporation",
        "D8:3A:F5": "Wideband Labs LLC",
        "38:D9:A5": "Mikotek Information Inc. ",
        "4C:87:5D": "Bose Corporation",
        "B0:E7:DE": "Homa Technologies JSC",
        "64:9D:99": "FS COM INC",
        "00:16:9D": "Cisco Systems, Inc",
        "4C:96:2D": "Fresh AB",
        "00:D2:79": "VINGROUP JOINT STOCK COMPANY",
        "48:4A:30": "George Robotics Limited",
        "48:61:A3": "Concern Axion JSC",
        "30:4A:26": "Shenzhen Trolink Technology CO, LTD",
        "4C:E5:AE": "Tianjin Beebox Intelligent Technology Co.,Ltd.",
        "D4:67:D3": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "A4:12:32": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "48:E3:C3": "JENOPTIK Advanced Systems GmbH",
        "CC:35:5A": "SecuGen Corporation",
        "80:54:6A": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "B4:47:F5": "Earda Technologies co Ltd",
        "F4:C7:C8": "Kelvin Inc.",
        "A8:9C:A4": "Furrion Limited",
        "00:00:4C": "NEC Corporation",
        "8C:CF:8F": "ITC Systems",
        "28:75:D8": "FUJIAN STAR-NET COMMUNICATION CO.,LTD",
        "90:E2:02": "Texas Instruments",
        "30:24:78": "Sagemcom Broadband SAS",
        "7C:89:C1": "Palo Alto Networks",
        "84:A9:3E": "Hewlett Packard",
        "B0:C3:87": "GOEFER, Inc.",
        "08:6B:D7": "Silicon Laboratories",
        "34:93:42": "TTE Corporation",
        "58:9E:C6": "Gigaset Communications GmbH",
        "64:C7:53": "Apple, Inc.",
        "64:58:AD": "China Mobile IOT Company Limited",
        "1C:F2:9A": "Google, Inc.",
        "74:8A:0D": "ARRIS Group, Inc.",
        "CC:75:E2": "ARRIS Group, Inc.",
        "A0:A3:B8": "WISCLOUD",
        "38:F9:D3": "Apple, Inc.",
        "FC:18:3C": "Apple, Inc.",
        "A4:0C:66": "Shenzhen Colorful Yugong Technology and Development Co., Ltd.",
        "44:55:B1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "98:F9:C7": "IEEE Registration Authority",
        "70:0B:4F": "Cisco Systems, Inc",
        "E4:38:8C": "Digital Products Limited",
        "18:4B:DF": "Caavo Inc",
        "B8:9A:9A": "Xin Shi Jia Technology (Beijing) Co.,Ltd",
        "8C:7B:F0": "Xufeng Development Limited",
        "E0:A5:09": "Bitmain Technologies Inc",
        "3C:5C:C4": "Amazon Technologies Inc.",
        "D8:A7:56": "Sagemcom Broadband SAS",
        "D8:D6:F3": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "6C:2C:DC": "Skyworth Digital Technology(Shenzhen) Co.,Ltd",
        "78:35:A0": "Zurn Industries LLC",
        "F4:39:09": "Hewlett Packard",
        "20:1F:31": "Inteno Broadband Technology AB",
        "2C:CC:44": "Sony Interactive Entertainment Inc.",
        "F4:7D:EF": "Samsung Electronics Co.,Ltd",
        "7C:8B:B5": "Samsung Electronics Co.,Ltd",
        "54:83:3A": "Zyxel Communications Corporation",
        "78:70:52": "Welotec GmbH",
        "D8:A9:8B": "Texas Instruments",
        "00:11:6C": "Nanwang Multimedia Inc.,Ltd",
        "10:B9:F7": "Niko-Servodan",
        "14:EF:CF": "SCHREDER",
        "38:30:F9": "LG Electronics (Mobile Communications)",
        "A8:3F:A1": "IEEE Registration Authority",
        "6C:9B:C0": "Chemoptics Inc.",
        "F4:DB:E6": "Cisco Systems, Inc",
        "24:84:98": "Beijing Jiaoda Microunion Tech.Co.,Ltd.",
        "C0:74:AD": "Grandstream Networks, Inc.",
        "F0:95:F1": "Carl Zeiss AG",
        "00:F4:8D": "Liteon Technology Corporation",
        "70:2E:D9": "Guangzhou Shiyuan Electronics Co., Ltd.",
        "70:19:2F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "10:C2:2F": "China Entropy Co., Ltd.",
        "BC:38:65": "JWCNETWORKS",
        "04:EB:40": "Cisco Systems, Inc",
        "18:A7:F1": "Qingdao Haier Technology Co.,Ltd",
        "90:E1:7B": "Apple, Inc.",
        "D8:1C:79": "Apple, Inc.",
        "58:E6:BA": "Apple, Inc.",
        "44:E4:EE": "Wistron Neweb Corporation",
        "DC:41:E5": "Shenzhen Zhixin Data Service Co., Ltd.",
        "00:A5:BF": "Cisco Systems, Inc",
        "C8:BA:E9": "QDIS",
        "18:01:F1": "Xiaomi Communications Co Ltd",
        "C4:4F:33": "Espressif Inc.",
        "54:6A:D8": "Elster Water Metering",
        "C0:84:7D": "AMPAK Technology, Inc.",
        "04:09:A5": "HFR, Inc.",
        "94:91:7F": "ASKEY COMPUTER CORP",
        "9C:0C:DF": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "24:21:24": "Nokia",
        "94:9B:2C": "Extreme Networks, Inc.",
        "7C:D3:0A": "INVENTEC CORPORATION",
        "00:1E:33": "INVENTEC CORPORATION",
        "FC:1D:84": "Autobase",
        "18:AC:9E": "ITEL MOBILE LIMITED",
        "00:D0:96": "3COM EUROPE LTD",
        "00:26:54": "3COM",
        "00:50:DA": "3COM",
        "00:04:76": "3COM",
        "00:04:75": "3COM",
        "44:22:F1": "S.FAC, INC",
        "30:09:F9": "IEEE Registration Authority",
        "B4:DD:D0": "Continental Automotive Hungary Kft",
        "48:F0:27": "Chengdu newifi Co.,Ltd",
        "14:C6:97": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "7C:03:AB": "Xiaomi Communications Co Ltd",
        "DC:16:B2": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:FB:65": "HUAWEI TECHNOLOGIES CO.,LTD",
        "0C:B5:27": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B4:2E:99": "GIGA-BYTE TECHNOLOGY CO.,LTD.",
        "34:2C:C4": "Compal Broadband Networks, Inc.",
        "14:E9:B2": "Fiberhome Telecommunication Technologies Co.,LTD",
        "C8:54:4B": "Zyxel Communications Corporation",
        "D0:7F:A0": "Samsung Electronics Co.,Ltd",
        "00:90:93": "EIZO Corporation",
        "4C:11:59": "Vision Information & Communications",
        "00:04:9F": "Freescale Semiconductor",
        "00:D0:7B": "COMCAM INTERNATIONAL INC",
        "E4:FC:82": "Juniper Networks",
        "00:B5:D0": "Samsung Electronics Co.,Ltd",
        "14:96:E5": "Samsung Electronics Co.,Ltd",
        "C4:6E:7B": "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD.",
        "C0:48:FB": "Shenzhen JingHanDa Electronics Co.Ltd",
        "20:E8:82": "zte corporation",
        "F0:9F:FC": "SHARP Corporation",
        "0C:B5:DE": "Alcatel Lucent",
        "00:0B:3B": "devolo AG",
        "24:05:88": "Google, Inc.",
        "50:DC:FC": "ECOCOM",
        "70:0B:01": "Sagemcom Broadband SAS",
        "5C:26:23": "WaveLynx Technologies Corporation",
        "30:38:55": "Nokia Corporation",
        "00:B6:70": "Cisco Systems, Inc",
        "AC:64:17": "Siemens AG",
        "34:79:16": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:66:EA": "VERTU INTERNATIONAL CORPORATION LIMITED",
        "28:38:5C": "FLEXTRONICS",
        "0C:1C:57": "Texas Instruments",
        "80:6F:B0": "Texas Instruments",
        "88:3F:99": "Siemens AG",
        "EC:6F:0B": "FADU, Inc.",
        "00:06:EC": "Harris Corporation",
        "7C:6D:A6": "Superwave Group LLC",
        "D0:16:B4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "20:A8:B9": "SIEMENS AG",
        "F0:F0:8F": "Nextek Solutions Pte Ltd",
        "8C:B0:E9": "Samsung Electronics.,LTD",
        "1C:39:47": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "34:27:92": "FREEBOX SAS",
        "40:A1:08": "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd.",
        "70:5A:B6": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "20:1A:06": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "F8:A9:63": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "DC:0E:A1": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "B8:70:F4": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "00:9D:6B": "Murata Manufacturing Co., Ltd.",
        "74:59:33": "Danal Entertainment",
        "EC:58:EA": "Ruckus Wireless",
        "7C:9A:54": "Technicolor CH USA Inc.",
        "38:8B:59": "Google, Inc.",
        "88:01:18": "BLT Co",
        "A4:26:18": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "A4:61:91": "NamJunSa",
        "84:A2:4D": "Birds Eye Systems Private Limited",
        "7C:6B:9C": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "00:17:B6": "Aquantia Corporation",
        "10:59:17": "Tonal",
        "D0:EF:C1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D4:52:51": "IBT Ingenieurbureau Broennimann Thun",
        "00:18:B5": "Magna Carta",
        "D8:7E:B1": "x.o.ware, inc.",
        "48:57:02": "HUAWEI TECHNOLOGIES CO.,LTD",
        "64:4F:42": "JETTER CO., Ltd.",
        "DC:AF:68": "WEIFANG GOERTEK ELECTRONICS CO.,LTD",
        "24:EC:51": "ADF Technologies Sdn Bhd",
        "70:89:CC": "China Mobile Group Device Co.,Ltd.",
        "2C:5B:E1": "Centripetal Networks, Inc",
        "DC:EF:CA": "Murata Manufacturing Co., Ltd.",
        "00:BC:60": "Cisco Systems, Inc",
        "CC:7B:61": "NIKKISO CO., LTD.",
        "9C:71:3A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "2C:97:B1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A8:99:69": "Dell Inc.",
        "A4:EA:8E": "Extreme Networks, Inc.",
        "88:2D:53": "Baidu Online Network Technology (Beijing) Co., Ltd.",
        "00:D0:B5": "IPricot formerly DotCom",
        "74:6B:AB": "GUANGDONG ENOK COMMUNICATION CO., LTD",
        "78:29:ED": "ASKEY COMPUTER CORP",
        "50:61:BF": "Cisco Systems, Inc",
        "F4:03:2F": "Reduxio Systems",
        "94:4A:0C": "Sercomm Corporation.",
        "00:0F:A2": "2xWireless",
        "10:8E:E0": "Samsung Electronics Co.,Ltd",
        "FC:A6:21": "Samsung Electronics Co.,Ltd",
        "8C:F2:28": "MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "70:0F:6A": "Cisco Systems, Inc",
        "00:0B:B2": "SMALLBIG TECHNOLOGY",
        "00:30:5E": "Abelko Innovation",
        "FC:6B:F0": "TOPWELL INTERNATIONAL HOLDINDS LIMITED",
        "00:14:77": "Trilliant",
        "00:07:9B": "Aurora Networks",
        "54:48:10": "Dell Inc.",
        "54:B2:03": "PEGATRON CORPORATION",
        "38:68:DD": "INVENTEC CORPORATION",
        "B8:B7:F1": "Wistron Neweb Corporation",
        "80:50:F6": "ITEL MOBILE LIMITED",
        "A8:CA:B9": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "20:39:56": "HMD Global Oy",
        "78:AF:E4": "Comau S.p.A",
        "90:A1:37": "Beijing Splendidtel Communication Technology Co,. Ltd",
        "80:02:9C": "Gemtek Technology Co., Ltd.",
        "D0:C5:D3": "AzureWave Technology Inc.",
        "14:16:9E": "Wingtech Group (HongKong）Limited",
        "F8:C3:9E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E8:D0:99": "Fiberhome Telecommunication Technologies Co.,LTD",
        "10:7B:A4": "Olive & Dove Co.,Ltd.",
        "7C:41:A2": "Nokia",
        "BC:32:5F": "Zhejiang Dahua Technology Co., Ltd.",
        "50:5B:C2": "Liteon Technology Corporation",
        "6C:21:A2": "AMPAK Technology, Inc.",
        "9C:2F:73": "Universal Tiancheng Technology (Beijing) Co., Ltd.",
        "D8:32:E3": "Xiaomi Communications Co Ltd",
        "94:87:E0": "Xiaomi Communications Co Ltd",
        "38:AF:29": "Zhejiang Dahua Technology Co., Ltd.",
        "C8:86:29": "Shenzhen Duubee Intelligent Technologies Co.,LTD.",
        "CC:C2:E0": "Raisecom Technology CO., LTD",
        "30:0A:C5": "Ruio telecommunication technologies Co., Limited",
        "00:E0:65": "OPTICAL ACCESS INTERNATIONAL",
        "44:66:FC": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "A0:28:ED": "HMD Global Oy",
        "AC:54:74": "China Mobile IOT Company Limited",
        "8C:1C:DA": "IEEE Registration Authority",
        "00:07:A8": "Haier Group Technologies Ltd",
        "98:14:D2": "Avonic",
        "14:09:DC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "EC:93:65": "Mapper.ai, Inc.",
        "C4:BA:A3": "Beijing Winicssec Technologies Co., Ltd.",
        "9C:FE:A1": "Fiberhome Telecommunication Technologies Co.,LTD",
        "D8:8A:3B": "UNIT-EM",
        "EC:5A:86": "Yulong Computer Telecommunication Scientific (Shenzhen) Co.,Ltd",
        "C0:EE:B5": "Enice Network.",
        "60:DE:F3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "50:A0:09": "Xiaomi Communications Co Ltd",
        "88:96:4E": "ARRIS Group, Inc.",
        "88:3F:4A": "Texas Instruments",
        "9C:A6:15": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "E4:4E:76": "CHAMPIONTECH  ENTERPRISE (SHENZHEN) INC",
        "00:40:98": "DRESSLER GMBH & CO.",
        "00:1D:FA": "Fujian LANDI Commercial Equipment Co.,Ltd",
        "9C:E6:5E": "Apple, Inc.",
        "C4:98:80": "Apple, Inc.",
        "E0:33:8E": "Apple, Inc.",
        "08:F6:9C": "Apple, Inc.",
        "04:FA:83": "Qingdao Haier Technology Co.,Ltd",
        "D0:76:E7": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "50:A6:7F": "Apple, Inc.",
        "D4:61:DA": "Apple, Inc.",
        "F0:18:98": "Apple, Inc.",
        "88:19:08": "Apple, Inc.",
        "5C:09:47": "Apple, Inc.",
        "14:20:5E": "Apple, Inc.",
        "B8:41:A4": "Apple, Inc.",
        "00:16:5C": "Trackflow Ltd.",
        "64:1C:AE": "Samsung Electronics Co.,Ltd",
        "F8:E4:4E": "MCOT INC.",
        "40:CD:7A": "Qingdao Hisense Communications Co.,Ltd.",
        "DC:4E:F4": "Shenzhen MTN Electronics CO., Ltd",
        "F0:81:73": "Amazon Technologies Inc.",
        "EC:65:CC": "Panasonic Automotive Systems Company of America",
        "94:99:90": "VTC Telecommunications",
        "F4:BC:97": "Shenzhen Crave Communication Co., LTD",
        "28:FE:DE": "COMESTA, Inc.",
        "90:79:10": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "00:3D:E8": "LG Electronics (Mobile Communications)",
        "68:FE:DA": "Fiberhome Telecommunication Technologies Co.,LTD",
        "E8:98:6D": "Palo Alto Networks",
        "14:4E:34": "Remote Solution",
        "00:50:8B": "Hewlett Packard",
        "14:6B:9C": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
        "94:8D:EF": "Oetiker Schweiz AG",
        "2C:D9:74": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "D4:F7:86": "Fiberhome Telecommunication Technologies Co.,LTD",
        "34:03:DE": "Texas Instruments",
        "24:0A:63": "ARRIS Group, Inc.",
        "F8:8B:37": "ARRIS Group, Inc.",
        "20:67:7C": "Hewlett Packard Enterprise",
        "34:D7:12": "Smartisan Digital Co., Ltd",
        "A0:66:10": "FUJITSU LIMITED",
        "44:FF:BA": "zte corporation",
        "E0:E6:2E": "TCT mobile ltd",
        "E4:2D:7B": "China Mobile IOT Company Limited",
        "C4:64:E3": "Texas Instruments",
        "88:17:A3": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "88:A9:A7": "IEEE Registration Authority",
        "EC:89:14": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B8:94:36": "HUAWEI TECHNOLOGIES CO.,LTD",
        "50:14:79": "iRobot Corporation ",
        "60:84:BD": "BUFFALO.INC",
        "34:7E:CA": "NEXTWILL",
        "B4:2E:F8": "Eline Technology co.Ltd",
        "A4:D4:B2": "Shenzhen MeiG Smart Technology Co.,Ltd",
        "8C:F7:73": "Nokia",
        "DC:DD:24": "Energica Motor Company SpA",
        "64:1C:B0": "Samsung Electronics Co.,Ltd",
        "90:3A:72": "Ruckus Wireless",
        "CC:3B:58": "Curiouser Products Inc",
        "4C:EF:C0": "Amazon Technologies Inc.",
        "8C:59:73": "Zyxel Communications Corporation",
        "24:18:1D": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "58:D7:59": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:90:66": "Nain Inc.",
        "70:06:AC": "Eastcompeace Technology Co., Ltd",
        "28:02:D8": "Samsung Electronics Co.,Ltd",
        "DC:E5:33": "IEEE Registration Authority",
        "D8:44:5C": "DEV Tecnologia Ind Com Man Eq LTDA",
        "50:95:51": "ARRIS Group, Inc.",
        "80:41:26": "HUAWEI TECHNOLOGIES CO.,LTD",
        "AC:F9:70": "HUAWEI TECHNOLOGIES CO.,LTD",
        "7C:39:53": "zte corporation",
        "38:E1:AA": "zte corporation",
        "48:C7:96": "Samsung Electronics Co.,Ltd",
        "F4:C2:48": "Samsung Electronics Co.,Ltd",
        "F4:71:90": "Samsung Electronics Co.,Ltd",
        "C4:FF:BC": "IEEE Registration Authority",
        "0C:23:69": "Honeywell SPS",
        "04:C9:D9": "Dish Technologies Corp",
        "70:55:F8": "Cerebras Systems Inc",
        "6C:54:CD": "LAMPEX ELECTRONICS LIMITED",
        "00:08:89": "Dish Technologies Corp",
        "F0:B5:B7": "Disruptive Technologies Research AS",
        "B4:DE:DF": "zte corporation",
        "D4:90:9C": "Apple, Inc.",
        "E4:E0:A6": "Apple, Inc.",
        "58:04:54": "ICOMM HK LIMITED",
        "3C:9A:77": "Technicolor CH USA Inc.",
        "C4:77:AF": "Advanced Digital Broadcast SA",
        "94:29:0C": "Shenyang wisdom Foundation Technology Development Co., Ltd.",
        "9C:32:CE": "CANON INC.",
        "20:E0:9C": "Nokia",
        "2C:FD:A1": "ASUSTek COMPUTER INC.",
        "38:07:D4": "Zeppelin Systems GmbH",
        "04:19:7F": "Grasphere Japan",
        "5C:00:38": "Viasat Group S.p.A.",
        "8C:EC:4B": "Dell Inc.",
        "00:50:91": "NETACCESS, INC.",
        "B8:50:01": "Extreme Networks, Inc.",
        "80:2B:F9": "Hon Hai Precision Ind. Co.,Ltd.",
        "54:B8:02": "Samsung Electronics Co.,Ltd",
        "10:CE:A9": "Texas Instruments",
        "80:5E:0C": "YEALINK(XIAMEN) NETWORK TECHNOLOGY CO.,LTD.",
        "6C:49:C1": "o2ones Co., Ltd.",
        "70:EE:A3": "Eoptolink Technology Inc. Ltd,",
        "70:47:E9": "vivo Mobile Communication Co., Ltd.",
        "5C:52:1E": "Nintendo Co.,Ltd",
        "14:44:4A": "Apollo Seiko Ltd.",
        "3C:2C:99": "Edgecore Networks Corporation",
        "68:3E:02": "SIEMENS AG, Digital Factory, Motion Control System",
        "00:02:61": "Tilgin AB",
        "00:14:C3": "Seagate Technology",
        "00:04:CF": "Seagate Technology",
        "00:20:37": "Seagate Technology",
        "5C:81:A7": "Network Devices Pty Ltd",
        "5C:0C:0E": "Guizhou Huaxintong Semiconductor Technology Co Ltd",
        "50:3C:EA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "00:E0:91": "LG Electronics",
        "38:43:7D": "Compal Broadband Networks, Inc.",
        "50:6F:98": "Sehaj Synergy Technologies Private Limited",
        "4C:AE:1C": "SaiNXT Technologies LLP",
        "14:28:82": "MIDICOM ELECTRONICS CO.LTD",
        "EC:81:93": "Logitech, Inc",
        "6C:DD:30": "Cisco Systems, Inc",
        "6C:4E:86": "Third Millennium Systems Ltd.",
        "5C:86:C1": "DONGGUAN SOLUM ELECTRONICS CO.,LTD",
        "5C:77:76": "TCT mobile ltd",
        "70:E5:6E": "Texas Instruments",
        "54:7D:CD": "Texas Instruments",
        "00:AE:CD": "Pensando Systems",
        "FC:9D:D8": "Beijing TongTongYiLian Science and Technology Ltd.",
        "DC:28:34": "HAKKO Corporation",
        "84:50:9A": "Easy Soft TV Co., Ltd",
        "00:17:30": "Automation Electronics",
        "30:E4:8E": "Vodafone UK",
        "44:91:60": "Murata Manufacturing Co., Ltd.",
        "B4:F1:DA": "LG Electronics (Mobile Communications)",
        "C8:63:F1": "Sony Interactive Entertainment Inc.",
        "DC:E1:AD": "Shenzhen Wintop Photoelectric Technology Co., Ltd",
        "94:88:54": "Texas Instruments",
        "00:1D:0D": "Sony Interactive Entertainment Inc.",
        "B0:FC:36": "CyberTAN Technology Inc.",
        "00:1D:F4": "Magellan Technology Pty Limited",
        "6C:05:D5": "Ethertronics Inc",
        "00:19:C2": "Equustek Solutions, Inc.",
        "EC:B0:E1": "Ciena Corporation",
        "78:DD:D9": "Guangzhou Shiyuan Electronics Co., Ltd. ",
        "F8:B7:E2": "Cisco Systems, Inc",
        "F8:20:55": "Green Information System",
        "74:E1:9A": "Fiberhome Telecommunication Technologies Co.,LTD",
        "00:00:97": "Dell EMC",
        "8C:CF:09": "Dell EMC",
        "8C:83:9D": "SHENZHEN XINYUPENG ELECTRONIC TECHNOLOGY CO., LTD",
        "B0:C1:9E": "zte corporation",
        "0C:37:47": "zte corporation",
        "AC:A6:67": "Electronic Systems Protection, Inc.",
        "00:81:F9": "Texas Instruments",
        "EC:B5:FA": "Philips Lighting BV",
        "44:CD:0E": "FLEXTRONICS MANUFACTURING(ZHUHAI)CO.,LTD.",
        "E8:82:5B": "ARRIS Group, Inc.",
        "70:99:1C": "Shenzhen Honesty Electronics Co.,Ltd",
        "80:B0:3D": "Apple, Inc.",
        "E4:9A:DC": "Apple, Inc.",
        "AC:E4:B5": "Apple, Inc.",
        "D0:D2:B0": "Apple, Inc.",
        "00:1C:AE": "WiChorus, Inc.",
        "7C:DD:76": "Suzhou Hanming Technologies Co., Ltd.",
        "24:68:80": "Braveridge.co.,ltd.",
        "E8:DF:70": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "28:AD:3E": "Shenzhen TONG BO WEI Technology CO.,LTD",
        "00:1C:56": "Pado Systems, Inc.",
        "F0:6D:78": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "78:44:FD": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "70:7D:95": "Shenzhen City LinwlanTechnology Co. Ltd.",
        "2C:43:1A": "Shenzhen YOUHUA Technology Co., Ltd",
        "A8:D3:C8": "Topcon Electronics GmbH & Co. KG",
        "D0:59:95": "Fiberhome Telecommunication Technologies Co.,LTD",
        "18:CC:88": "Hitachi Johnson Controls Air ",
        "80:C7:55": "Panasonic Appliances Company",
        "F0:BD:2E": "H+S Polatis Ltd",
        "74:6E:E4": "Asia Vital Components Co.,Ltd.",
        "00:40:E4": "E-M TECHNOLOGY, INC.",
        "98:4B:4A": "ARRIS Group, Inc.",
        "E0:84:F3": "High Grade Controls Corporation",
        "70:70:8B": "Cisco Systems, Inc",
        "38:9F:5A": "C-Kur TV Inc.",
        "D8:43:ED": "Suzuken",
        "04:3A:0D": "SM Optics S.r.l.",
        "44:8F:17": "Samsung Electronics Co., Ltd. ARTIK",
        "00:FC:8B": "Amazon Technologies Inc.",
        "00:76:B1": "Somfy-Protect By Myfox SAS",
        "6C:C1:47": "Xiamen Hanin Electronic Technology Co., Ltd",
        "A0:72:E4": "NJ SYSTEM CO.,LTD",
        "4C:13:65": "Emplus Technologies",
        "CC:F9:57": "u-blox AG",
        "0C:62:A6": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "18:13:2D": "zte corporation",
        "74:D2:1D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "18:78:D4": "Verizon ",
        "B8:D9:4D": "Sagemcom Broadband SAS",
        "38:90:A5": "Cisco Systems, Inc",
        "C0:74:2B": "SHENZHEN XUNLONG SOFTWARE CO.,LIMITED",
        "5C:67:76": "IDS Imaging Development Systems GmbH",
        "44:EA:D8": "Texas Instruments",
        "18:9B:A5": "IEEE Registration Authority",
        "1C:70:22": "Murata Manufacturing Co., Ltd.",
        "CC:98:91": "Cisco Systems, Inc",
        "28:BF:89": "Fiberhome Telecommunication Technologies Co.,LTD",
        "90:3D:BD": "SECURE METERS LIMITED",
        "00:22:94": "KYOCERA CORPORATION ",
        "38:89:DC": "Opticon Sensors Europe B.V.",
        "8C:45:00": "Murata Manufacturing Co., Ltd.",
        "1C:DD:EA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "94:00:06": "jinyoung",
        "20:04:0F": "Dell Inc.",
        "A4:34:12": "Thales Alenia Space",
        "8C:85:90": "Apple, Inc.",
        "BC:88:C3": "Ningbo Dooya Mechanic & Electronic Technology Co., Ltd",
        "38:CD:07": "Beijing FaceCam Technology Co., Ltd.",
        "00:D0:60": "Panasonic Europe Ltd.",
        "EC:FA:03": "FCA",
        "6C:96:CF": "Apple, Inc.",
        "68:1F:40": "Blu Wireless Technology Ltd",
        "90:AD:F7": "vivo Mobile Communication Co., Ltd.",
        "40:CE:24": "Cisco Systems, Inc",
        "34:32:E6": "Panasonic Industrial Devices Europe GmbH",
        "40:01:7A": "Cisco Systems, Inc",
        "78:88:6D": "Apple, Inc.",
        "20:EE:28": "Apple, Inc.",
        "B4:F6:1C": "Apple, Inc.",
        "08:F4:AB": "Apple, Inc.",
        "FC:01:7C": "Hon Hai Precision Ind. Co.,Ltd.",
        "90:32:4B": "Hon Hai Precision Ind. Co.,Ltd.",
        "60:2E:20": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E4:72:E2": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:12:7D": "MobileAria",
        "F8:64:65": "Anova Applied Electronics, Inc.",
        "00:20:60": "ALCATEL ITALIA S.p.A.",
        "50:8F:4C": "Xiaomi Communications Co Ltd",
        "A4:77:58": "Ningbo Freewings Technologies Co.,Ltd",
        "58:A0:CB": "TrackNet, Inc",
        "E0:60:89": "Cloudleaf, Inc.",
        "78:36:90": "Yulong Computer Telecommunication Scientific (Shenzhen) Co.,Ltd",
        "BC:54:FC": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "0C:4B:54": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "E4:F0:04": "Dell Inc.",
        "94:E3:6D": "Texas Instruments",
        "F0:F8:F2": "Texas Instruments",
        "34:15:13": "Texas Instruments",
        "74:81:9A": "PT. Hartono Istana Teknologi",
        "28:35:45": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD",
        "04:4F:4C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "18:B8:1F": "ARRIS Group, Inc.",
        "1C:15:1F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:8B:FC": "mixi,Inc.",
        "A8:2B:B5": "Edgecore Networks Corporation",
        "E8:E1:E2": "Energotest",
        "78:11:DC": "XIAOMI Electronics,CO.,LTD",
        "D4:63:C6": "Motorola Mobility LLC, a Lenovo Company",
        "F8:44:E3": "Taicang T&W Electronics",
        "24:A5:34": "SynTrust Tech International Ltd. ",
        "C4:44:A0": "Cisco Systems, Inc",
        "18:74:2E": "Amazon Technologies Inc.",
        "90:A3:65": "HMD Global Oy",
        "DC:44:B6": "Samsung Electronics Co.,Ltd",
        "10:07:B6": "Samsung Electronics Co.,Ltd",
        "34:2D:0D": "Samsung Electronics Co.,Ltd",
        "A4:4C:C8": "Dell Inc.",
        "D8:37:BE": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "D4:68:4D": "Ruckus Wireless",
        "8C:0C:90": "Ruckus Wireless",
        "6C:AA:B3": "Ruckus Wireless",
        "00:13:92": "Ruckus Wireless",
        "08:51:14": "QINGDAO TOPSCOMM COMMUNICATION CO., LTD",
        "D0:5A:00": "Technicolor CH USA Inc.",
        "70:78:8B": "vivo Mobile Communication Co., Ltd.",
        "48:59:A4": "zte corporation",
        "54:BD:79": "Samsung Electronics Co.,Ltd",
        "A0:42:3F": "Tyan Computer Corp",
        "70:F1:1C": "Shenzhen Ogemray Technology Co.,Ltd",
        "70:65:A3": "Kandao lightforge Co., Ltd.",
        "14:14:4B": "Ruijie Networks Co.,LTD",
        "74:D0:DC": "Ericsson AB",
        "C0:8A:DE": "Ruckus Wireless",
        "00:1D:2E": "Ruckus Wireless",
        "B4:E6:2A": "LG Innotek",
        "A0:C5:F2": "IEEE Registration Authority",
        "A8:6B:7C": "SHENZHEN FENGLIAN TECHNOLOGY CO., LTD.",
        "B0:39:56": "NETGEAR",
        "3C:0C:DB": "UNIONMAN TECHNOLOGY CO.,LTD",
        "EC:42:B4": "ADC Corporation",
        "60:DA:83": "Hangzhou H3C Technologies Co., Limited",
        "2C:57:31": "Wingtech Group (HongKong）Limited",
        "CC:46:39": "WAAV, Inc.",
        "AC:9E:17": "ASUSTek COMPUTER INC.",
        "64:16:66": "Nest Labs Inc.",
        "D8:DF:7A": "Quest Software, Inc.",
        "14:5B:E1": "nyantec GmbH",
        "A0:23:9F": "Cisco Systems, Inc",
        "70:F3:5A": "Cisco Systems, Inc",
        "A0:34:1B": "Adero Inc",
        "A0:AF:BD": "Intel Corporate",
        "7C:8B:CA": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "B0:4E:26": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "B0:89:C2": "Zyptonite",
        "F0:23:B9": "IEEE Registration Authority",
        "FC:4D:D4": "Universal Global Scientific Industrial Co., Ltd.",
        "A4:F4:C2": "VNPT TECHNOLOGY",
        "8C:14:7D": "IEEE Registration Authority",
        "30:07:4D": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "1C:1F:D4": "LifeBEAM Technologies LTD",
        "00:9A:D2": "Cisco Systems, Inc",
        "44:7F:77": "Connected Home",
        "E8:B6:C2": "Juniper Networks",
        "94:7B:E7": "Samsung Electronics Co.,Ltd",
        "50:92:B9": "Samsung Electronics Co.,Ltd",
        "DC:74:A8": "Samsung Electronics Co.,Ltd",
        "E8:39:35": "Hewlett Packard",
        "00:18:0A": "Cisco Meraki",
        "5C:6A:80": "Zyxel Communications Corporation",
        "D8:60:B3": "Guangdong Global Electronic Technology CO.，LTD",
        "64:35:1C": "e-CON SYSTEMS INDIA PVT LTD",
        "60:BA:18": "nextLAP GmbH",
        "44:AA:50": "Juniper Networks",
        "84:CD:62": "ShenZhen IDWELL Technology CO.,Ltd",
        "A8:D5:79": "Beijing Chushang Science and Technology Co.,Ltd",
        "44:48:C1": "Hewlett Packard Enterprise",
        "48:10:63": "NTT Innovation Institute, Inc.",
        "A0:8E:78": "Sagemcom Broadband SAS",
        "88:D5:0C": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "D4:28:D5": "TCT mobile ltd",
        "9C:AF:6F": "ITEL MOBILE LIMITED",
        "FC:53:9E": "Shanghai Wind Technologies Co.,Ltd",
        "60:53:17": "Sandstone Technologies",
        "90:70:65": "Texas Instruments",
        "18:A9:58": "PROVISION THAI CO., LTD.",
        "74:C9:A3": "Fiberhome Telecommunication Technologies Co.,LTD",
        "EC:8A:4C": "zte corporation",
        "D4:5F:25": "Shenzhen YOUHUA Technology Co., Ltd",
        "40:C8:CB": "AM Telecom co., Ltd.",
        "2C:AB:EB": "Cisco Systems, Inc",
        "B4:C6:F8": "Axilspot Communication",
        "9C:E9:51": "Shenzhen Sang Fei Consumer Communications Ltd., Co.",
        "B8:D5:0B": "Sunitec Enterprise Co.,Ltd",
        "BC:66:DE": "Shadow Creator Information Technology Co.,Ltd.",
        "18:68:CB": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "C4:AE:12": "Samsung Electronics Co.,Ltd",
        "00:1F:A4": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "D4:DC:CD": "Apple, Inc.",
        "48:4B:AA": "Apple, Inc.",
        "DC:A9:04": "Apple, Inc.",
        "6C:AB:31": "Apple, Inc.",
        "4C:74:BF": "Apple, Inc.",
        "04:94:6B": "TECNO MOBILE LIMITED",
        "48:88:03": "ManTechnology Inc.",
        "B4:36:E3": "KBVISION GROUP",
        "94:D2:99": "Techmation Co.,Ltd.",
        "34:1A:35": "Fiberhome Telecommunication Technologies Co.,LTD",
        "2C:02:9F": "3ALogics",
        "64:D1:54": "Routerboard.com",
        "58:D9:D5": "Tenda Technology Co.,Ltd.Dongguan branch",
        "6C:4B:90": "LiteON",
        "00:05:0F": "Tanaka S/S Ltd.",
        "98:9E:63": "Apple, Inc.",
        "88:6B:6E": "Apple, Inc.",
        "F4:E4:AD": "zte corporation",
        "28:FF:3E": "zte corporation",
        "B8:D7:AF": "Murata Manufacturing Co., Ltd.",
        "D4:AE:05": "Samsung Electronics Co.,Ltd",
        "E0:48:AF": "Premietech Limited",
        "2C:33:11": "Cisco Systems, Inc",
        "50:82:D5": "Apple, Inc.",
        "F0:EE:10": "Samsung Electronics Co.,Ltd",
        "C4:70:0B": "GUANGZHOU CHIP TECHNOLOGIES CO.,LTD",
        "3C:A0:67": "Liteon Technology Corporation",
        "BC:02:4A": "HMD Global Oy",
        "94:99:01": "Shenzhen YITOA Digital Appliance CO.,LTD",
        "F8:59:71": "Intel Corporate",
        "10:05:CA": "Cisco Systems, Inc",
        "78:94:B4": "Sercomm Corporation.",
        "44:37:08": "MRV Comunications",
        "28:5F:2F": "RNware Co.,Ltd.",
        "50:0F:F5": "Tenda Technology Co.,Ltd.Dongguan branch",
        "BC:45:2E": "Knowledge Development for POF S.L.",
        "DC:C6:4B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "04:33:89": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:A0:68": "BHP LIMITED",
        "70:3A:CB": "Google, Inc.",
        "70:6D:EC": "Wifi-soft LLC",
        "B0:C2:05": "BIONIME",
        "94:F5:51": "Cadi Scientific Pte Ltd",
        "10:5A:F7": "ADB Italia ",
        "B8:1D:AA": "LG Electronics (Mobile Communications)",
        "00:E4:00": "Sichuan Changhong Electric Ltd.",
        "2C:55:D3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:C0:24": "EDEN SISTEMAS DE COMPUTACAO SA",
        "7C:46:85": "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd.",
        "1C:1E:E3": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "44:03:2C": "Intel Corporate",
        "78:68:F7": "YSTen Technology Co.,Ltd",
        "00:4B:F3": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "08:CC:A7": "Cisco Systems, Inc",
        "08:96:AD": "Cisco Systems, Inc",
        "08:23:B2": "vivo Mobile Communication Co., Ltd.",
        "88:C3:B3": "SOVICO",
        "E0:51:24": "NXP Semiconductors",
        "00:1D:A3": "SabiOso",
        "54:2F:8A": "TELLESCOM INDUSTRIA E COMERCIO EM TELECOMUNICACAO ",
        "60:14:B3": "CyberTAN Technology Inc.",
        "10:56:11": "ARRIS Group, Inc.",
        "34:78:77": "O-Net Communications (Shenzhen) Limited",
        "00:20:CC": "DIGITAL SERVICES, LTD.",
        "68:9F:F0": "zte corporation",
        "5C:AF:06": "LG Electronics (Mobile Communications)",
        "00:17:9B": "CHANT SINCERE CO.,LTD",
        "1C:39:8A": "Fiberhome Telecommunication Technologies Co.,LTD",
        "E8:65:D4": "Tenda Technology Co.,Ltd.Dongguan branch",
        "24:D5:1C": "Zhongtian broadband technology co., LTD ",
        "EC:43:F6": "Zyxel Communications Corporation",
        "60:C6:58": "PHYTRONIX Co.,Ltd.",
        "FC:B5:8A": "Wapice Ltd.",
        "A4:62:DF": "DS Global. Co., LTD",
        "4C:16:94": "shenzhen sibituo Technology Co., Ltd",
        "C8:14:51": "HUAWEI TECHNOLOGIES CO.,LTD",
        "44:D4:37": "Inteno Broadband Technology AB",
        "EC:E1:54": "Beijing Unisound Information Technology Co.,Ltd.",
        "6C:16:0E": "ShotTracker",
        "80:3A:0A": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "0C:73:BE": "Dongguan Haimai Electronie Technology Co.,Ltd",
        "28:6F:7F": "Cisco Systems, Inc",
        "F0:C8:50": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:01:4F": "Adtran Inc",
        "28:52:61": "Cisco Systems, Inc",
        "C8:AA:55": "Hunan Comtom Electronic Incorporated Co.,Ltd",
        "20:78:0B": "Delta Faucet Company",
        "88:09:AF": "Masimo Corporation",
        "2C:D0:2D": "Cisco Systems, Inc",
        "9C:CC:83": "Juniper Networks",
        "64:DB:A0": "Select Comfort",
        "F8:98:3A": "Leeman International (HongKong) Limited",
        "4C:EC:EF": "Soraa, Inc.",
        "1C:EF:CE": "bebro electronic GmbH",
        "98:B6:E9": "Nintendo Co.,Ltd",
        "F0:15:B9": "PlayFusion Limited",
        "64:B0:A6": "Apple, Inc.",
        "7C:04:D0": "Apple, Inc.",
        "84:FC:AC": "Apple, Inc.",
        "DC:0C:5C": "Apple, Inc.",
        "70:70:0D": "Apple, Inc.",
        "30:E1:71": "Hewlett Packard",
        "18:65:90": "Apple, Inc.",
        "F8:62:14": "Apple, Inc.",
        "78:4F:43": "Apple, Inc.",
        "40:4D:7F": "Apple, Inc.",
        "00:1D:72": "Wistron Corporation",
        "D8:19:7A": "Nuheara Ltd",
        "4C:38:D5": "MITAC COMPUTING TECHNOLOGY CORPORATION",
        "54:B5:6C": "Xi'an NovaStar Tech Co., Ltd",
        "34:4C:C8": "Echodyne Corp",
        "64:13:6C": "zte corporation",
        "04:B6:48": "ZENNER",
        "98:F1:99": "NEC Platforms, Ltd.",
        "18:40:A4": "Shenzhen Trylong Smart Science and Technology Co., Ltd.",
        "1C:48:CE": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "C8:0C:C8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "04:25:C5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "60:3E:7B": "Gafachi, Inc.",
        "4C:74:87": "Leader Phone Communication Technology Co., Ltd.",
        "AC:83:F3": "AMPAK Technology, Inc.",
        "CC:8C:DA": "Shenzhen Wei Da Intelligent Technology Go.,Ltd",
        "D4:36:DB": "Jiangsu Toppower Automotive Electronics Co., Ltd",
        "2C:DC:AD": "Wistron Neweb Corporation",
        "6C:5C:14": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "E8:09:45": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "7C:25:87": "chaowifi.com",
        "2C:21:31": "Juniper Networks",
        "00:50:1E": "Grass Valley, A Belden Brand",
        "EC:0D:9A": "Mellanox Technologies, Inc.",
        "90:D7:BE": "Wavelab Global Inc.",
        "24:4E:7B": "IEEE Registration Authority",
        "30:AE:A4": "Espressif Inc.",
        "3C:FA:43": "HUAWEI TECHNOLOGIES CO.,LTD",
        "14:5F:94": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:1F:82": "Cal-Comp Electronics & Communications Company Ltd.",
        "88:3C:1C": "MERCURY CORPORATION",
        "00:21:44": "SS Telecoms",
        "00:6B:F1": "Cisco Systems, Inc",
        "28:34:A2": "Cisco Systems, Inc",
        "78:23:AE": "ARRIS Group, Inc.",
        "20:71:9E": "SF Technology Co.,Ltd",
        "2C:C2:60": "Oracle Corporation ",
        "3C:3F:51": "2CRSI",
        "3C:2A:F4": "Brother Industries, LTD.",
        "C0:85:4C": "Ragentek Technology Group",
        "00:24:AC": "Hangzhou DPtech Technologies Co., Ltd.",
        "50:58:4F": "waytotec,Inc.",
        "08:5D:DD": "MERCURY CORPORATION",
        "8C:60:E7": "MPGIO CO.,LTD",
        "CC:94:70": "Kinestral Technologies, Inc.",
        "B4:39:D6": "ProCurve Networking by HP",
        "34:F3:9A": "Intel Corporate",
        "D8:16:C1": "DEWAV (HK) ELECTRONICS LIMITED",
        "CC:61:E5": "Motorola Mobility LLC, a Lenovo Company",
        "8C:8A:BB": "Beijing Orient View Technology Co., Ltd.",
        "00:03:9B": "NetChip Technology, Inc.",
        "9C:8B:A0": "Apple, Inc.",
        "CC:08:8D": "Apple, Inc.",
        "38:A4:ED": "Xiaomi Communications Co Ltd",
        "B8:99:19": "7signal Solutions, Inc",
        "40:FE:0D": "MAXIO",
        "AC:64:DD": "IEEE Registration Authority",
        "94:B8:19": "Nokia",
        "78:7D:48": "ITEL MOBILE LIMITED",
        "88:71:E5": "Amazon Technologies Inc.",
        "BC:39:D9": "Z-TEC",
        "60:9A:C1": "Apple, Inc.",
        "74:8D:08": "Apple, Inc.",
        "00:B0:EE": "Ajile Systems, Inc.",
        "20:DB:AB": "Samsung Electronics Co., Ltd.",
        "38:3A:21": "IEEE Registration Authority",
        "D8:38:0D": "SHENZHEN IP-COM Network Co.,Ltd",
        "88:AD:43": "PEGATRON CORPORATION",
        "B4:EF:FA": "Lemobile Information Technology (Beijing) Co., Ltd.",
        "6C:71:BD": "EZELINK TELECOM",
        "60:EF:C6": "Shenzhen Chima Technologies Co Limited",
        "00:1F:C6": "ASUSTek COMPUTER INC.",
        "B0:C1:28": "Adler ELREHA GmbH",
        "30:87:D9": "Ruckus Wireless",
        "FC:CA:C4": "LifeHealth, LLC",
        "F0:D9:B2": "EXO S.A.",
        "E4:C8:01": "BLU Products Inc",
        "F0:98:38": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C8:0E:14": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "AC:63:BE": "Amazon Technologies Inc.",
        "F8:1D:78": "IEEE Registration Authority",
        "38:F7:B2": "SEOJUN ELECTRIC",
        "10:12:50": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "78:02:B7": "ShenZhen Ultra Easy Technology CO.,LTD",
        "64:61:84": "VELUX",
        "E8:E5:D6": "Samsung Electronics Co.,Ltd",
        "C8:7E:75": "Samsung Electronics Co.,Ltd",
        "00:26:5F": "Samsung Electronics Co.,Ltd",
        "00:23:3A": "Samsung Electronics Co.,Ltd",
        "08:6A:0A": "ASKEY COMPUTER CORP",
        "98:E7:F4": "Hewlett Packard",
        "00:07:AB": "Samsung Electronics Co.,Ltd",
        "00:24:86": "DesignArt Networks",
        "00:24:78": "Mag Tech Electronics Co Limited",
        "38:2D:D1": "Samsung Electronics Co.,Ltd",
        "00:1B:2C": "ATRON electronic GmbH",
        "90:34:FC": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:14:27": "JazzMutant",
        "00:1E:84": "Pika Technologies Inc.",
        "10:DD:B1": "Apple, Inc.",
        "00:23:29": "DDRdrive LLC",
        "00:26:AD": "Arada Systems, Inc.",
        "FC:1F:19": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "84:0B:2D": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "20:64:32": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "B4:07:F9": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "88:9F:FA": "Hon Hai Precision Ind. Co.,Ltd.",
        "8C:7C:B5": "Hon Hai Precision Ind. Co.,Ltd.",
        "C4:46:19": "Hon Hai Precision Ind. Co.,Ltd.",
        "50:63:13": "Hon Hai Precision Ind. Co.,Ltd.",
        "60:D8:19": "Hon Hai Precision Ind. Co.,Ltd.",
        "F8:2F:A8": "Hon Hai Precision Ind. Co.,Ltd.",
        "0C:84:DC": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:16:6C": "Samsung Electronics Co.,Ltd",
        "18:1E:B0": "Samsung Electronics Co.,Ltd",
        "24:7F:20": "Sagemcom Broadband SAS",
        "E8:03:9A": "Samsung Electronics Co.,Ltd",
        "30:CD:A7": "Samsung Electronics Co.,Ltd",
        "00:12:47": "Samsung Electronics Co.,Ltd",
        "00:15:99": "Samsung Electronics Co.,Ltd",
        "00:12:FB": "Samsung Electronics Co.,Ltd",
        "D0:66:7B": "Samsung Electronics Co.,Ltd",
        "B8:5E:7B": "Samsung Electronics Co.,Ltd",
        "E4:92:FB": "Samsung Electronics Co.,Ltd",
        "6C:B7:F4": "Samsung Electronics Co.,Ltd",
        "2C:44:01": "Samsung Electronics Co.,Ltd",
        "B8:D9:CE": "Samsung Electronics Co.,Ltd",
        "1C:66:AA": "Samsung Electronics Co.,Ltd",
        "3C:8B:FE": "Samsung Electronics Co.,Ltd",
        "D4:E8:B2": "Samsung Electronics Co.,Ltd",
        "14:89:FD": "Samsung Electronics Co.,Ltd",
        "BC:85:1F": "Samsung Electronics Co.,Ltd",
        "00:15:B9": "Samsung Electronics Co.,Ltd",
        "00:24:91": "Samsung Electronics Co.,Ltd",
        "00:23:39": "Samsung Electronics Co.,Ltd",
        "50:01:BB": "Samsung Electronics Co.,Ltd",
        "C4:01:42": "MaxMedia Technology Limited",
        "84:30:E5": "SkyHawke Technologies, LLC",
        "1C:77:F6": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "58:E3:26": "Compass Technologies Inc.",
        "00:1B:2A": "Cisco Systems, Inc",
        "74:9D:DC": "2Wire Inc",
        "14:DD:E5": "MPMKVVCL",
        "00:1A:09": "Wayfarer Transit Systems Ltd",
        "74:23:44": "Xiaomi Communications Co Ltd",
        "54:88:0E": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "F0:25:B7": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "F0:43:47": "HUAWEI TECHNOLOGIES CO.,LTD",
        "9C:B2:B2": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A8:C8:3A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "BC:72:B1": "Samsung Electronics Co.,Ltd",
        "78:F7:BE": "Samsung Electronics Co.,Ltd",
        "68:48:98": "Samsung Electronics Co.,Ltd",
        "34:23:BA": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "00:36:76": "ARRIS Group, Inc.",
        "FC:8E:7E": "ARRIS Group, Inc.",
        "FC:6F:B7": "ARRIS Group, Inc.",
        "D4:2C:0F": "ARRIS Group, Inc.",
        "40:0E:85": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "C8:BA:94": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "84:38:38": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "A0:55:DE": "ARRIS Group, Inc.",
        "80:F5:03": "ARRIS Group, Inc.",
        "44:AA:F5": "ARRIS Group, Inc.",
        "E0:9D:FA": "Wanan Hongsheng Electronic Co.Ltd",
        "5C:3C:27": "Samsung Electronics Co.,Ltd",
        "70:A8:4C": "MONAD., Inc.",
        "24:E4:3F": "Wenzhou Kunmei Communication Technology Co.,Ltd.",
        "28:7A:EE": "ARRIS Group, Inc.",
        "88:79:7E": "Motorola Mobility LLC, a Lenovo Company",
        "30:58:90": "Frontier Silicon Ltd",
        "70:8B:CD": "ASUSTek COMPUTER INC.",
        "00:25:8B": "Mellanox Technologies, Inc.",
        "00:56:2B": "Cisco Systems, Inc",
        "E8:FD:90": "Turbostor",
        "2C:AC:44": "CONEXTOP",
        "D0:13:FD": "LG Electronics (Mobile Communications)",
        "BC:64:4B": "ARRIS Group, Inc.",
        "60:64:05": "Texas Instruments",
        "18:99:F5": "Sichuan Changhong Electric Ltd.",
        "00:25:C3": "21168",
        "00:0F:57": "CABLELOGIC Co., Ltd.",
        "00:03:42": "Nortel Networks",
        "A4:82:69": "Datrium, Inc.",
        "10:E6:8F": "KWANGSUNG ELECTRONICS KOREA CO.,LTD.",
        "4C:FA:CA": "Cambridge Industries(Group) Co.,Ltd.",
        "18:AB:F5": "Ultra Electronics Electrics",
        "B0:3E:B0": "MICRODIA Ltd.",
        "00:15:91": "RLW Inc.",
        "00:18:2E": "XStreamHD",
        "00:12:83": "Nortel Networks",
        "00:11:F9": "Nortel Networks",
        "00:11:58": "Nortel Networks",
        "00:0F:6A": "Nortel Networks",
        "00:0E:62": "Nortel Networks",
        "00:0C:F8": "Nortel Networks",
        "00:26:F1": "ProCurve Networking by HP",
        "38:0D:D4": "Primax Electronics Ltd.",
        "98:FD:B4": "Primax Electronics Ltd.",
        "D8:C4:6A": "Murata Manufacturing Co., Ltd.",
        "D8:FB:68": "Cloud Corner Ltd.",
        "68:53:88": "P&S Technology",
        "98:2F:3C": "Sichuan Changhong Electric Ltd.",
        "14:C1:FF": "ShenZhen QianHai Comlan communication Co.,LTD",
        "00:04:17": "ELAU AG",
        "EC:FA:AA": "The IMS Company",
        "F0:07:86": "Shandong Bittel Electronics Co., Ltd",
        "00:D0:F6": "Nokia",
        "54:A6:19": "Alcatel-Lucent Shanghai Bell Co., Ltd",
        "00:09:97": "Nortel Networks",
        "00:1C:EB": "Nortel Networks",
        "00:1C:17": "Nortel Networks",
        "00:1A:8F": "Nortel Networks",
        "00:17:D1": "Nortel Networks",
        "88:83:22": "Samsung Electronics Co.,Ltd",
        "E8:93:09": "Samsung Electronics Co.,Ltd",
        "00:14:C7": "Nortel Networks",
        "00:1D:AF": "Nortel Networks",
        "88:A6:C6": "Sagemcom Broadband SAS",
        "94:D4:69": "Cisco Systems, Inc",
        "88:2B:D7": "ADDÉNERGIE  TECHNOLOGIES",
        "00:90:CC": "PLANEX COMMUNICATIONS INC.",
        "20:57:AF": "Shenzhen FH-NET OPTOELECTRONICS CO.,LTD",
        "54:DC:1D": "Yulong Computer Telecommunication Scientific (Shenzhen) Co.,Ltd",
        "AC:A2:13": "Shenzhen Bilian electronic CO.,LTD",
        "3C:33:00": "Shenzhen Bilian electronic CO.,LTD",
        "6C:D0:32": "LG Electronics",
        "3C:BD:D8": "LG ELECTRONICS INC",
        "34:4D:F7": "LG Electronics (Mobile Communications)",
        "58:3F:54": "LG Electronics (Mobile Communications)",
        "00:22:CF": "PLANEX COMMUNICATIONS INC.",
        "E4:17:D8": "8BITDO TECHNOLOGY HK LIMITED",
        "9C:D3:32": "PLC Technology Ltd",
        "38:F8:CA": "OWIN Inc.",
        "44:33:4C": "Shenzhen Bilian electronic CO.,LTD",
        "64:89:9A": "LG Electronics (Mobile Communications)",
        "00:21:05": "Alcatel-Lucent IPD",
        "00:1B:C5": "IEEE Registration Authority",
        "48:DF:37": "Hewlett Packard Enterprise",
        "C0:E4:2D": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "8C:A6:DF": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "84:16:F9": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "18:D6:C7": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "78:C3:E9": "Samsung Electronics Co.,Ltd",
        "8C:1A:BF": "Samsung Electronics Co.,Ltd",
        "30:CB:F8": "Samsung Electronics Co.,Ltd",
        "A0:CB:FD": "Samsung Electronics Co.,Ltd",
        "E4:5D:75": "Samsung Electronics Co.,Ltd",
        "00:E0:4D": "INTERNET INITIATIVE JAPAN, INC",
        "F8:A9:D0": "LG Electronics (Mobile Communications)",
        "CC:FA:00": "LG Electronics (Mobile Communications)",
        "74:A7:22": "LG Electronics (Mobile Communications)",
        "F0:1C:13": "LG Electronics (Mobile Communications)",
        "58:FC:DB": "IEEE Registration Authority",
        "B0:C5:CA": "IEEE Registration Authority",
        "74:19:F8": "IEEE Registration Authority",
        "A8:16:B2": "LG Electronics (Mobile Communications)",
        "64:BC:0C": "LG Electronics (Mobile Communications)",
        "90:C6:82": "IEEE Registration Authority",
        "C0:1A:DA": "Apple, Inc.",
        "00:00:31": "QPSX COMMUNICATIONS, LTD.",
        "00:0E:1E": "QLogic Corporation",
        "00:14:D1": "TRENDnet, Inc.",
        "CC:52:AF": "Universal Global Scientific Industrial Co., Ltd.",
        "00:1C:14": "VMware, Inc.",
        "00:50:56": "VMware, Inc.",
        "00:12:1C": "PARROT SA",
        "90:03:B7": "PARROT SA",
        "20:87:56": "SIEMENS AG",
        "74:B4:72": "CIESSE",
        "FC:F1:52": "Sony Corporation",
        "48:3C:0C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:9B:AD": "BBK EDUCATIONAL ELECTRONICS CORP.,LTD.",
        "00:1B:B1": "Wistron Neweb Corporation",
        "00:80:F7": "Zenith Electronics Corporation",
        "BC:30:7D": "Wistron Neweb Corporation",
        "48:A9:D2": "Wistron Neweb Corporation",
        "80:EA:23": "Wistron Neweb Corporation",
        "00:27:13": "Universal Global Scientific Industrial Co., Ltd.",
        "BC:30:7E": "Wistron Neweb Corporation",
        "08:95:2A": "Technicolor CH USA Inc.",
        "44:32:C8": "Technicolor CH USA Inc.",
        "38:A2:8C": "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD.",
        "B4:A5:EF": "Sercomm Corporation.",
        "84:9D:64": "SMC Corporation",
        "00:10:C1": "OI ELECTRIC CO.,LTD",
        "28:BE:9B": "Technicolor CH USA Inc.",
        "FC:52:8D": "Technicolor CH USA Inc.",
        "50:65:83": "Texas Instruments",
        "B0:91:22": "Texas Instruments",
        "FC:51:A4": "ARRIS Group, Inc.",
        "98:57:D3": "HON HAI-CCPBG  PRECISION IND.CO.,LTD.",
        "FC:F5:28": "Zyxel Communications Corporation",
        "00:A0:C5": "Zyxel Communications Corporation",
        "A0:9E:1A": "Polar Electro Oy",
        "1C:D6:BD": "LEEDARSON LIGHTING CO., LTD.",
        "D0:D9:4F": "IEEE Registration Authority",
        "00:1E:04": "Hanson Research Corporation",
        "60:C0:BF": "ON Semiconductor",
        "AC:04:81": "Jiangsu Huaxing Electronics Co., Ltd.",
        "68:B3:5E": "Shenzhen Neostra Technology Co.Ltd",
        "40:88:05": "Motorola Mobility LLC, a Lenovo Company",
        "24:E2:71": "Qingdao Hisense Communications Co.,Ltd.",
        "BC:60:10": "Qingdao Hisense Communications Co.,Ltd.",
        "D0:FC:CC": "Samsung Electronics Co.,Ltd",
        "98:39:8E": "Samsung Electronics Co.,Ltd",
        "44:D1:FA": "Shenzhen Yunlink Technology Co., Ltd",
        "F0:F6:44": "Whitesky Science & Technology Co.,Ltd.",
        "20:F1:7C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:6A:C2": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C4:1C:FF": "Vizio, Inc",
        "C0:97:27": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "DC:29:3A": "Shenzhen Nuoshi Technology Co., LTD.",
        "7C:6A:F3": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "E4:62:51": "HAO CHENG GROUP LIMITED",
        "40:56:2D": "Smartron India Pvt ltd",
        "38:76:D1": "Euronda SpA",
        "C4:69:3E": "Turbulence Design Inc.",
        "00:95:69": "LSD Science and Technology Co.,Ltd.",
        "B0:CF:4D": "MI-Zone Technology Ireland",
        "28:9A:FA": "TCT mobile ltd",
        "00:1A:34": "Konka Group Co., Ltd.",
        "00:11:FC": "HARTING Electronics GmbH",
        "00:23:89": "Hangzhou H3C Technologies Co., Limited",
        "3C:E5:A6": "Hangzhou H3C Technologies Co., Limited",
        "5C:DD:70": "Hangzhou H3C Technologies Co., Limited",
        "3C:8C:40": "Hangzhou H3C Technologies Co., Limited",
        "A0:67:BE": "Sicon srl",
        "D8:20:9F": "Cubro Acronet GesmbH",
        "8C:77:16": "LONGCHEER TELECOMMUNICATION LIMITED",
        "68:FB:7E": "Apple, Inc.",
        "84:A1:34": "Apple, Inc.",
        "A0:D3:85": "AUMA Riester GmbH & Co. KG",
        "14:14:E6": "Ningbo Sanhe Digital Co.,Ltd",
        "00:25:82": "Maksat Technologies (P) Ltd",
        "0C:51:01": "Apple, Inc.",
        "2C:F0:A2": "Apple, Inc.",
        "48:C0:49": "Broad Telecom SA",
        "AC:6F:BB": "TATUNG Technology Inc.",
        "00:1C:41": "scemtec Transponder Technology GmbH",
        "14:63:08": "JABIL CIRCUIT (SHANGHAI) LTD.",
        "00:1E:25": "INTEK DIGITAL",
        "00:E0:CF": "INTEGRATED DEVICE",
        "90:4D:4A": "Sagemcom Broadband SAS",
        "04:4E:5A": "ARRIS Group, Inc.",
        "00:60:B1": "Input/Output, Inc.",
        "54:7F:54": "INGENICO",
        "6C:24:83": "Microsoft Mobile Oy",
        "68:91:D0": "IEEE Registration Authority",
        "E0:4F:43": "Universal Global Scientific Industrial Co., Ltd.",
        "38:70:0C": "ARRIS Group, Inc.",
        "00:0E:2E": "Edimax Technology Co. Ltd.",
        "00:06:5F": "ECI Telecom Ltd.",
        "00:20:8F": "ECI Telecom Ltd.",
        "84:40:76": "Drivenets",
        "00:1C:D7": "Harman/Becker Automotive Systems GmbH",
        "00:3A:7D": "Cisco Systems, Inc",
        "90:C7:D8": "zte corporation",
        "00:18:5C": "EDSLAB Technologies",
        "00:1A:45": "GN Netcom A/S",
        "00:20:88": "GLOBAL VILLAGE COMMUNICATION",
        "54:13:79": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:19:21": "Elitegroup Computer Systems Co.,Ltd.",
        "00:16:EC": "Elitegroup Computer Systems Co.,Ltd.",
        "00:07:95": "Elitegroup Computer Systems Co.,Ltd.",
        "FC:0F:4B": "Texas Instruments",
        "D4:88:3F": "HDPRO CO., LTD.",
        "10:88:CE": "Fiberhome Telecommunication Technologies Co.,LTD",
        "60:B6:17": "Fiberhome Telecommunication Technologies Co.,LTD",
        "DC:9C:9F": "Shenzhen YOUHUA Technology Co., Ltd",
        "74:DF:BF": "Liteon Technology Corporation",
        "F0:3E:90": "Ruckus Wireless",
        "D8:D7:23": "IDS, Inc",
        "84:AD:58": "HUAWEI TECHNOLOGIES CO.,LTD",
        "58:60:5F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:A0:F4": "GE",
        "AC:0D:1B": "LG Electronics (Mobile Communications)",
        "F0:D1:B8": "LEDVANCE",
        "98:6D:35": "IEEE Registration Authority",
        "88:79:5B": "Konka Group Co., Ltd.",
        "08:1F:71": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "5C:CA:1A": "Microsoft Mobile Oy",
        "FC:2F:AA": "Nokia",
        "B0:7E:70": "Zadara Storage Ltd.",
        "00:80:B1": "SOFTCOM A/S",
        "20:2D:F8": "Digital Media Cartridge Ltd.",
        "10:D0:AB": "zte corporation",
        "00:04:C6": "YAMAHA MOTOR CO.,LTD",
        "18:A3:E8": "Fiberhome Telecommunication Technologies Co.,LTD",
        "74:1E:93": "Fiberhome Telecommunication Technologies Co.,LTD",
        "20:2D:07": "Samsung Electronics Co.,Ltd",
        "D8:80:3C": "Anhui Huami Information Technology Company Limited",
        "00:34:DA": "LG Electronics (Mobile Communications)",
        "38:10:D5": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "18:C5:01": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "00:A0:B8": "NetApp",
        "00:C8:8B": "Cisco Systems, Inc",
        "24:C3:F9": "Securitas Direct AB",
        "2C:21:D7": "IMAX Corporation",
        "00:09:D2": "Mai Logic Inc.",
        "00:60:16": "CLARIION",
        "98:1F:B1": "Shenzhen Lemon Network Technology Co.,Ltd",
        "0C:5A:9E": "Wi-SUN Alliance",
        "B4:4B:D2": "Apple, Inc.",
        "DC:41:5F": "Apple, Inc.",
        "64:12:25": "Cisco Systems, Inc",
        "78:64:E6": "Green Motive Technology Limited",
        "3C:BE:E1": "NIKON CORPORATION",
        "10:2A:B3": "Xiaomi Communications Co Ltd",
        "40:D3:57": "Ison Technology Co., Ltd.",
        "A4:15:88": "ARRIS Group, Inc.",
        "F4:5C:89": "Apple, Inc.",
        "20:76:8F": "Apple, Inc.",
        "00:11:D1": "Soft Imaging System GmbH",
        "98:D6:86": "Chyi Lee industry Co., ltd.",
        "8C:C6:61": "Current, powered by GE",
        "88:A0:84": "Formation Data Systems",
        "E8:B2:AC": "Apple, Inc.",
        "E4:9A:79": "Apple, Inc.",
        "30:A9:DE": "LG Innotek",
        "F0:1B:6C": "vivo Mobile Communication Co., Ltd.",
        "A0:B9:ED": "Skytap",
        "94:C9:60": "Zhongshan B&T technology.co.,ltd",
        "74:C3:30": "SHENZHEN FAST TECHNOLOGIES CO.,LTD",
        "40:3F:8C": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "DC:B3:B4": "Honeywell Environmental & Combustion Controls (Tianjin) Co., Ltd.",
        "00:1D:3B": "Nokia Danmark A/S",
        "00:1D:FD": "Nokia Danmark A/S",
        "00:1E:3B": "Nokia Danmark A/S",
        "00:1E:A4": "Nokia Danmark A/S",
        "00:26:CC": "Nokia Danmark A/S",
        "00:0E:ED": "Nokia Danmark A/S",
        "4C:25:78": "Nokia Corporation",
        "BC:C6:DB": "Nokia Corporation",
        "00:11:9F": "Nokia Danmark A/S",
        "00:1A:16": "Nokia Danmark A/S",
        "00:1A:89": "Nokia Danmark A/S",
        "00:1A:DC": "Nokia Danmark A/S",
        "00:25:CF": "Nokia Danmark A/S",
        "00:21:AB": "Nokia Danmark A/S",
        "00:1F:DE": "Nokia Danmark A/S",
        "00:1F:DF": "Nokia Danmark A/S",
        "54:79:75": "Nokia Corporation",
        "A8:7B:39": "Nokia Corporation",
        "00:24:7C": "Nokia Danmark A/S",
        "00:22:66": "Nokia Danmark A/S",
        "00:21:FE": "Nokia Danmark A/S",
        "C4:77:AB": "Beijing ASU Tech Co.,Ltd",
        "00:0B:CA": "DATAVAN TC",
        "70:25:59": "CyberTAN Technology Inc.",
        "60:7E:DD": "Microsoft Mobile Oy",
        "A8:A0:89": "Tactical Communications",
        "48:36:5F": "Wintecronics Ltd.",
        "00:1D:20": "Comtrend Corporation",
        "08:37:3D": "Samsung Electronics Co.,Ltd",
        "0C:75:BD": "Cisco Systems, Inc",
        "30:0D:43": "Microsoft Mobile Oy",
        "00:00:0E": "FUJITSU LIMITED",
        "00:0B:5D": "FUJITSU LIMITED",
        "C4:88:E5": "Samsung Electronics Co.,Ltd",
        "08:05:81": "Roku, Inc.",
        "00:0D:F3": "Asmax Solutions",
        "80:AC:AC": "Juniper Networks",
        "00:0D:B6": "Broadcom",
        "00:0A:F7": "Broadcom",
        "D4:01:29": "Broadcom",
        "00:1D:00": "Brivo Systems, LLC",
        "00:20:D6": "Breezecom, Ltd.",
        "00:E0:63": "Cabletron Systems, Inc.",
        "FC:C7:34": "Samsung Electronics Co.,Ltd",
        "84:25:DB": "Samsung Electronics Co.,Ltd",
        "B0:EC:71": "Samsung Electronics Co.,Ltd",
        "E4:58:B8": "Samsung Electronics Co.,Ltd",
        "08:8C:2C": "Samsung Electronics Co.,Ltd",
        "64:B8:53": "Samsung Electronics Co.,Ltd",
        "38:94:96": "Samsung Electronics Co.,Ltd",
        "50:56:BF": "Samsung Electronics Co.,Ltd",
        "90:F1:AA": "Samsung Electronics Co.,Ltd",
        "10:77:B1": "Samsung Electronics Co.,Ltd",
        "00:1F:C7": "Casio Hitachi Mobile Communications Co., Ltd.",
        "A4:9A:58": "Samsung Electronics Co.,Ltd",
        "08:EE:8B": "Samsung Electronics Co.,Ltd",
        "0C:A4:2A": "OB Telecom Electronic Technology Co., Ltd",
        "74:45:8A": "Samsung Electronics Co.,Ltd",
        "5C:DC:96": "Arcadyan Technology Corporation",
        "74:31:70": "Arcadyan Technology Corporation",
        "00:1A:2A": "Arcadyan Technology Corporation",
        "88:25:2C": "Arcadyan Technology Corporation",
        "40:BA:61": "ARIMA Communications Corp.",
        "00:11:F5": "ASKEY COMPUTER CORP",
        "00:16:E3": "ASKEY COMPUTER CORP",
        "E8:39:DF": "ASKEY COMPUTER CORP",
        "1C:C6:3C": "Arcadyan Technology Corporation",
        "18:83:BF": "Arcadyan Technology Corporation",
        "68:ED:43": "BlackBerry RTS",
        "70:AA:B2": "BlackBerry RTS",
        "00:14:6C": "NETGEAR",
        "00:1E:2A": "NETGEAR",
        "00:18:4D": "NETGEAR",
        "00:04:0E": "AVM GmbH",
        "9C:C7:A6": "AVM GmbH",
        "A0:63:91": "NETGEAR",
        "20:E5:2A": "NETGEAR",
        "44:94:FC": "NETGEAR",
        "20:0C:C8": "NETGEAR",
        "C4:47:3F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "74:44:01": "NETGEAR",
        "E0:91:F5": "NETGEAR",
        "00:0F:86": "BlackBerry RTS",
        "00:24:D2": "ASKEY COMPUTER CORP",
        "B4:EE:B4": "ASKEY COMPUTER CORP",
        "E4:64:49": "ARRIS Group, Inc.",
        "40:FC:89": "ARRIS Group, Inc.",
        "2C:9E:5F": "ARRIS Group, Inc.",
        "00:26:36": "ARRIS Group, Inc.",
        "00:1C:C1": "ARRIS Group, Inc.",
        "00:1E:5A": "ARRIS Group, Inc.",
        "00:13:71": "ARRIS Group, Inc.",
        "00:23:EE": "ARRIS Group, Inc.",
        "00:1A:DE": "ARRIS Group, Inc.",
        "74:56:12": "ARRIS Group, Inc.",
        "00:50:E3": "ARRIS Group, Inc.",
        "00:21:36": "ARRIS Group, Inc.",
        "00:16:26": "ARRIS Group, Inc.",
        "00:19:A6": "ARRIS Group, Inc.",
        "E8:C7:4F": "Liteon Technology Corporation",
        "D0:53:49": "Liteon Technology Corporation",
        "E8:F7:24": "Hewlett Packard Enterprise",
        "28:0D:FC": "Sony Interactive Entertainment Inc.",
        "00:13:11": "ARRIS Group, Inc.",
        "D0:DF:9A": "Liteon Technology Corporation",
        "1C:65:9D": "Liteon Technology Corporation",
        "30:10:B3": "Liteon Technology Corporation",
        "70:1A:04": "Liteon Technology Corporation",
        "48:D2:24": "Liteon Technology Corporation",
        "20:68:9D": "Liteon Technology Corporation",
        "7C:BF:B1": "ARRIS Group, Inc.",
        "08:00:46": "Sony Corporation",
        "EC:F0:0E": "AboCom",
        "00:E0:98": "AboCom",
        "74:DA:EA": "Texas Instruments",
        "94:88:15": "Infinique Worldwide Inc",
        "D0:E4:4A": "Murata Manufacturing Co., Ltd.",
        "38:4F:F0": "AzureWave Technology Inc.",
        "E8:74:E6": "ADB Broadband Italia",
        "00:20:E0": "Actiontec Electronics, Inc",
        "00:26:62": "Actiontec Electronics, Inc",
        "00:25:53": "ADB Broadband Italia",
        "00:19:3E": "ADB Broadband Italia",
        "00:08:27": "ADB Broadband Italia",
        "74:2F:68": "AzureWave Technology Inc.",
        "4C:14:A3": "TCL Technoly Electronics (Huizhou) Co., Ltd.",
        "4C:B0:E8": "Beijing RongZhi xinghua technology co., LTD",
        "D8:87:D5": "Leadcore Technology CO.,LTD",
        "00:F2:8B": "Cisco Systems, Inc",
        "34:E6:AD": "Intel Corporate",
        "08:11:96": "Intel Corporate",
        "18:3D:A2": "Intel Corporate",
        "80:9B:20": "Intel Corporate",
        "00:23:14": "Intel Corporate",
        "34:02:86": "Intel Corporate",
        "00:1C:BF": "Intel Corporate",
        "B4:B6:76": "Intel Corporate",
        "3C:A9:F4": "Intel Corporate",
        "B8:8A:60": "Intel Corporate",
        "78:FF:57": "Intel Corporate",
        "9C:4E:36": "Intel Corporate",
        "34:13:E8": "Intel Corporate",
        "00:27:10": "Intel Corporate",
        "A4:8E:0A": "DeLaval International AB",
        "AC:2B:6E": "Intel Corporate",
        "9C:35:83": "Nipro Diagnostics, Inc",
        "C0:61:18": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "B8:2A:72": "Dell Inc.",
        "F8:E0:79": "Motorola Mobility LLC, a Lenovo Company",
        "CC:C3:EA": "Motorola Mobility LLC, a Lenovo Company",
        "40:78:6A": "Motorola Mobility LLC, a Lenovo Company",
        "00:19:D1": "Intel Corporate",
        "00:19:D2": "Intel Corporate",
        "00:1B:21": "Intel Corporate",
        "18:FF:0F": "Intel Corporate",
        "34:DE:1A": "Intel Corporate",
        "E8:B1:FC": "Intel Corporate",
        "CC:3D:82": "Intel Corporate",
        "00:1F:3C": "Intel Corporate",
        "00:23:15": "Intel Corporate",
        "00:16:6F": "Intel Corporate",
        "00:0A:8A": "Cisco Systems, Inc",
        "00:1D:09": "Dell Inc.",
        "00:23:AE": "Dell Inc.",
        "BC:30:5B": "Dell Inc.",
        "38:86:02": "Flexoptix GmbH",
        "40:65:A3": "Sagemcom Broadband SAS",
        "D0:22:12": "IEEE Registration Authority",
        "10:07:23": "IEEE Registration Authority",
        "A4:4F:29": "IEEE Registration Authority",
        "74:F8:DB": "IEEE Registration Authority",
        "A4:3B:FA": "IEEE Registration Authority",
        "B8:CA:3A": "Dell Inc.",
        "EC:F4:BB": "Dell Inc.",
        "D4:BE:D9": "Dell Inc.",
        "00:19:4B": "Sagemcom Broadband SAS",
        "00:1E:74": "Sagemcom Broadband SAS",
        "38:3B:C8": "2Wire Inc",
        "60:FE:20": "2Wire Inc",
        "00:24:56": "2Wire Inc",
        "C0:83:0A": "2Wire Inc",
        "00:18:3F": "2Wire Inc",
        "00:0D:56": "Dell Inc.",
        "18:1E:78": "Sagemcom Broadband SAS",
        "00:37:B7": "Sagemcom Broadband SAS",
        "00:54:BD": "Swelaser AB",
        "00:1E:4C": "Hon Hai Precision Ind. Co.,Ltd.",
        "20:BB:76": "COL GIOVANNI PAOLO SpA",
        "3C:DD:89": "SOMO HOLDINGS & TECH. CO.,LTD.",
        "18:01:E3": "Bittium Wireless Ltd",
        "14:91:82": "Belkin International Inc.",
        "18:62:2C": "Sagemcom Broadband SAS",
        "3C:81:D8": "Sagemcom Broadband SAS",
        "40:F2:01": "Sagemcom Broadband SAS",
        "D0:84:B0": "Sagemcom Broadband SAS",
        "D8:54:3A": "Texas Instruments",
        "64:9C:8E": "Texas Instruments",
        "10:2E:AF": "Texas Instruments",
        "7C:8E:E4": "Texas Instruments",
        "B4:EE:D4": "Texas Instruments",
        "D0:37:61": "Texas Instruments",
        "C8:3E:99": "Texas Instruments",
        "40:98:4E": "Texas Instruments",
        "00:17:EB": "Texas Instruments",
        "00:17:E6": "Texas Instruments",
        "C4:ED:BA": "Texas Instruments",
        "00:18:32": "Texas Instruments",
        "3C:2D:B7": "Texas Instruments",
        "54:64:D9": "Sagemcom Broadband SAS",
        "00:19:5B": "D-Link Corporation",
        "00:0F:3D": "D-Link Corporation",
        "24:DA:11": "NO NDA Inc",
        "EC:22:80": "D-Link International",
        "9C:8E:99": "Hewlett Packard",
        "90:59:AF": "Texas Instruments",
        "BC:6A:29": "Texas Instruments",
        "84:7E:40": "Texas Instruments",
        "00:17:35": "Intel Wireless Network Group",
        "74:AC:5F": "Qiku Internet Network Scientific (Shenzhen) Co., Ltd.",
        "38:CA:DA": "Apple, Inc.",
        "D0:B3:3F": "Shenzhen TINNO Mobile Technology Corp.",
        "BC:D1:D3": "Shenzhen TINNO Mobile Technology Corp.",
        "D8:3C:69": "Shenzhen TINNO Mobile Technology Corp.",
        "F4:F5:D8": "Google, Inc.",
        "8C:57:9B": "Wistron Neweb Corporation",
        "00:59:AC": "KPN. B.V.",
        "40:D8:55": "IEEE Registration Authority",
        "34:AB:37": "Apple, Inc.",
        "24:00:BA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:DF:6A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:8B:77": "Standar Telecom",
        "B0:C0:90": "Chicony Electronics Co., Ltd.",
        "90:7F:61": "Chicony Electronics Co., Ltd.",
        "0C:05:35": "Juniper Systems",
        "BC:83:A7": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD",
        "BC:EC:23": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD",
        "18:AF:61": "Apple, Inc.",
        "5C:F9:38": "Apple, Inc.",
        "00:90:69": "Juniper Networks",
        "64:64:9B": "Juniper Networks",
        "F0:1C:2D": "Juniper Networks",
        "30:7C:5E": "Juniper Networks",
        "AC:06:C7": "ServerNet S.r.l.",
        "E8:3E:FC": "ARRIS Group, Inc.",
        "90:0D:CB": "ARRIS Group, Inc.",
        "00:1D:CD": "ARRIS Group, Inc.",
        "00:1D:D2": "ARRIS Group, Inc.",
        "8C:09:F4": "ARRIS Group, Inc.",
        "88:57:EE": "BUFFALO.INC",
        "10:1F:74": "Hewlett Packard",
        "00:9C:02": "Hewlett Packard",
        "F4:CE:46": "Hewlett Packard",
        "DC:FB:02": "BUFFALO.INC",
        "00:16:35": "Hewlett Packard",
        "00:08:C7": "Hewlett Packard",
        "00:10:E3": "Hewlett Packard",
        "00:08:83": "Hewlett Packard",
        "A0:2B:B8": "Hewlett Packard",
        "00:19:BB": "Hewlett Packard",
        "00:1F:29": "Hewlett Packard",
        "00:21:5A": "Hewlett Packard",
        "00:23:7D": "Hewlett Packard",
        "E8:ED:05": "ARRIS Group, Inc.",
        "78:96:84": "ARRIS Group, Inc.",
        "CC:65:AD": "ARRIS Group, Inc.",
        "00:26:55": "Hewlett Packard",
        "00:0D:9D": "Hewlett Packard",
        "00:15:60": "Hewlett Packard",
        "00:20:7B": "Intel Corporation",
        "00:11:75": "Intel Corporation",
        "78:0C:B8": "Intel Corporate",
        "18:5E:0F": "Intel Corporate",
        "2C:81:58": "Hon Hai Precision Ind. Co.,Ltd.",
        "80:02:DF": "ORA Inc.",
        "00:30:6E": "Hewlett Packard",
        "3C:4A:92": "Hewlett Packard",
        "7C:7D:3D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "44:82:E5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:23:4E": "Hon Hai Precision Ind. Co.,Ltd.",
        "2C:23:3A": "Hewlett Packard",
        "00:0A:57": "Hewlett Packard",
        "00:01:E7": "Hewlett Packard",
        "00:01:E6": "Hewlett Packard",
        "00:23:76": "HTC Corporation",
        "38:E7:D8": "HTC Corporation",
        "18:87:96": "HTC Corporation",
        "B4:CE:F6": "HTC Corporation",
        "8C:DC:D4": "Hewlett Packard",
        "D4:C9:EF": "Hewlett Packard",
        "FC:15:B4": "Hewlett Packard",
        "3C:A8:2A": "Hewlett Packard",
        "EC:5F:23": "Qinghai Kimascend Electronics Technology Co. Ltd.",
        "04:7D:50": "Shenzhen Kang Ying Technology Co.Ltd.",
        "54:EF:FE": "Fullpower Technologies, Inc.",
        "94:09:37": "HUMAX Co., Ltd.",
        "E8:4D:D0": "HUAWEI TECHNOLOGIES CO.,LTD",
        "0C:45:BA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "20:90:6F": "Shenzhen Tencent Computer System Co., Ltd.",
        "6C:E3:B6": "Nera Telecommunications Ltd.",
        "DC:D3:21": "HUMAX Co., Ltd.",
        "6C:72:E7": "Apple, Inc.",
        "74:1B:B2": "Apple, Inc.",
        "6C:E8:73": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "C4:6E:1F": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "50:FA:84": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "44:B3:2D": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "CC:44:63": "Apple, Inc.",
        "88:25:93": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "00:1F:E1": "Hon Hai Precision Ind. Co.,Ltd.",
        "D8:5D:4C": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "A0:F3:C1": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "00:1D:0F": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "00:23:CD": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "90:48:9A": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:71:CC": "Hon Hai Precision Ind. Co.,Ltd.",
        "B0:5B:67": "HUAWEI TECHNOLOGIES CO.,LTD",
        "CC:A2:23": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:6A:89": "HUAWEI TECHNOLOGIES CO.,LTD",
        "38:46:08": "zte corporation",
        "4C:AC:0A": "zte corporation",
        "B4:B3:62": "zte corporation",
        "B0:75:D5": "zte corporation",
        "D0:15:4A": "zte corporation",
        "00:26:ED": "zte corporation",
        "00:60:57": "Murata Manufacturing Co., Ltd.",
        "14:B9:68": "HUAWEI TECHNOLOGIES CO.,LTD",
        "5C:F9:6A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "08:3E:8E": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:22:93": "zte corporation",
        "10:A5:D0": "Murata Manufacturing Co., Ltd.",
        "50:A7:2B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "0C:D6:BD": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:F8:1C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "08:7A:4C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "AC:E2:15": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:6B:D3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "70:72:3C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "AC:E8:7B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:3D:FF": "HUAWEI TECHNOLOGIES CO.,LTD",
        "28:5F:DB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "40:4D:8E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "4C:54:99": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F4:9F:F3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:09:95": "HUAWEI TECHNOLOGIES CO.,LTD",
        "84:DB:AC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "94:77:2B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D4:40:F0": "HUAWEI TECHNOLOGIES CO.,LTD",
        "04:02:1F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "10:CD:AE": "Avaya Inc",
        "04:8A:15": "Avaya Inc",
        "B4:B0:17": "Avaya Inc",
        "90:FB:5B": "Avaya Inc",
        "C8:F4:06": "Avaya Inc",
        "70:52:C5": "Avaya Inc",
        "F8:15:47": "Avaya Inc",
        "50:61:84": "Avaya Inc",
        "18:59:36": "Xiaomi Communications Co Ltd",
        "20:A7:83": "miControl GmbH",
        "20:0B:C7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:4A:BF": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:D7:52": "HUAWEI TECHNOLOGIES CO.,LTD",
        "10:47:80": "HUAWEI TECHNOLOGIES CO.,LTD",
        "54:89:98": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:04:0D": "Avaya Inc",
        "70:A8:E3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:E8:11": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:A4:5F": "Xiaomi Communications Co Ltd",
        "64:09:80": "Xiaomi Communications Co Ltd",
        "94:04:9C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "68:8F:84": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:D1:7E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:50:BD": "Cisco Systems, Inc",
        "00:90:6F": "Cisco Systems, Inc",
        "74:D6:EA": "Texas Instruments",
        "20:91:48": "Texas Instruments",
        "54:4A:16": "Texas Instruments",
        "E0:2F:6D": "Cisco Systems, Inc",
        "58:97:1E": "Cisco Systems, Inc",
        "B4:E9:B0": "Cisco Systems, Inc",
        "00:08:32": "Cisco Systems, Inc",
        "18:9C:5D": "Cisco Systems, Inc",
        "5C:A4:8A": "Cisco Systems, Inc",
        "1C:1D:86": "Cisco Systems, Inc",
        "60:73:5C": "Cisco Systems, Inc",
        "34:A8:4E": "Cisco Systems, Inc",
        "54:78:1A": "Cisco Systems, Inc",
        "00:60:5C": "Cisco Systems, Inc",
        "00:06:C1": "Cisco Systems, Inc",
        "00:E0:14": "Cisco Systems, Inc",
        "DC:A5:F4": "Cisco Systems, Inc",
        "50:17:FF": "Cisco Systems, Inc",
        "70:10:5C": "Cisco Systems, Inc",
        "10:F3:11": "Cisco Systems, Inc",
        "00:50:F0": "Cisco Systems, Inc",
        "00:50:14": "Cisco Systems, Inc",
        "00:90:F2": "Cisco Systems, Inc",
        "0C:E0:E4": "PLANTRONICS, INC.",
        "74:A2:E6": "Cisco Systems, Inc",
        "BC:F1:F2": "Cisco Systems, Inc",
        "C8:00:84": "Cisco Systems, Inc",
        "40:A6:E8": "Cisco Systems, Inc",
        "30:85:A9": "ASUSTek COMPUTER INC.",
        "B8:38:61": "Cisco Systems, Inc",
        "58:0A:20": "Cisco Systems, Inc",
        "2C:3E:CF": "Cisco Systems, Inc",
        "B0:59:47": "Shenzhen Qihu Intelligent Technology Company Limited",
        "34:62:88": "Cisco Systems, Inc",
        "CC:D8:C1": "Cisco Systems, Inc",
        "7C:0E:CE": "Cisco Systems, Inc",
        "A0:EC:F9": "Cisco Systems, Inc",
        "50:87:89": "Cisco Systems, Inc",
        "38:1C:1A": "Cisco Systems, Inc",
        "BC:67:1C": "Cisco Systems, Inc",
        "00:19:47": "Cisco SPVTG",
        "00:18:39": "Cisco-Linksys, LLC",
        "00:22:15": "ASUSTek COMPUTER INC.",
        "E0:CB:4E": "ASUSTek COMPUTER INC.",
        "54:7C:69": "Cisco Systems, Inc",
        "00:17:31": "ASUSTek COMPUTER INC.",
        "DC:CE:C1": "Cisco Systems, Inc",
        "9C:57:AD": "Cisco Systems, Inc",
        "60:FE:C5": "Apple, Inc.",
        "E4:25:E7": "Apple, Inc.",
        "BC:92:6B": "Apple, Inc.",
        "10:1C:0C": "Apple, Inc.",
        "08:00:07": "Apple, Inc.",
        "00:40:96": "Cisco Systems, Inc",
        "30:F7:0D": "Cisco Systems, Inc",
        "E8:65:49": "Cisco Systems, Inc",
        "B0:7D:47": "Cisco Systems, Inc",
        "38:ED:18": "Cisco Systems, Inc",
        "38:20:56": "Cisco Systems, Inc",
        "40:D3:2D": "Apple, Inc.",
        "C4:2C:03": "Apple, Inc.",
        "90:27:E4": "Apple, Inc.",
        "10:9A:DD": "Apple, Inc.",
        "58:1F:AA": "Apple, Inc.",
        "88:C6:63": "Apple, Inc.",
        "00:1F:5B": "Apple, Inc.",
        "00:24:36": "Apple, Inc.",
        "00:25:4B": "Apple, Inc.",
        "00:16:CB": "Apple, Inc.",
        "00:17:F2": "Apple, Inc.",
        "7C:6D:62": "Apple, Inc.",
        "20:C9:D0": "Apple, Inc.",
        "68:96:7B": "Apple, Inc.",
        "84:FC:FE": "Apple, Inc.",
        "E4:8B:7F": "Apple, Inc.",
        "00:88:65": "Apple, Inc.",
        "BC:3B:AF": "Apple, Inc.",
        "3C:E0:72": "Apple, Inc.",
        "38:48:4C": "Apple, Inc.",
        "A4:67:06": "Apple, Inc.",
        "8C:58:77": "Apple, Inc.",
        "7C:F0:5F": "Apple, Inc.",
        "80:49:71": "Apple, Inc.",
        "6C:3E:6D": "Apple, Inc.",
        "BC:67:78": "Apple, Inc.",
        "D8:D1:CB": "Apple, Inc.",
        "A8:FA:D8": "Apple, Inc.",
        "B8:17:C2": "Apple, Inc.",
        "7C:11:BE": "Apple, Inc.",
        "28:37:37": "Apple, Inc.",
        "50:EA:D6": "Apple, Inc.",
        "98:D6:BB": "Apple, Inc.",
        "18:9E:FC": "Apple, Inc.",
        "AC:CF:5C": "Apple, Inc.",
        "80:00:6E": "Apple, Inc.",
        "84:8E:0C": "Apple, Inc.",
        "3C:15:C2": "Apple, Inc.",
        "6C:70:9F": "Apple, Inc.",
        "C0:F2:FB": "Apple, Inc.",
        "24:E3:14": "Apple, Inc.",
        "80:E6:50": "Apple, Inc.",
        "90:FD:61": "Apple, Inc.",
        "08:70:45": "Apple, Inc.",
        "A8:88:08": "Apple, Inc.",
        "A4:C3:61": "Apple, Inc.",
        "2C:F0:EE": "Apple, Inc.",
        "5C:97:F3": "Apple, Inc.",
        "D4:F4:6F": "Apple, Inc.",
        "64:76:BA": "Apple, Inc.",
        "34:E2:FD": "Apple, Inc.",
        "04:48:9A": "Apple, Inc.",
        "F0:F6:1C": "Apple, Inc.",
        "8C:29:37": "Apple, Inc.",
        "B0:9F:BA": "Apple, Inc.",
        "0C:4D:E9": "Apple, Inc.",
        "E0:F5:C6": "Apple, Inc.",
        "A0:ED:CD": "Apple, Inc.",
        "F0:F2:49": "Hitron Technologies. Inc",
        "5C:F5:DA": "Apple, Inc.",
        "18:EE:69": "Apple, Inc.",
        "64:9A:BE": "Apple, Inc.",
        "F0:99:BF": "Apple, Inc.",
        "94:E9:6A": "Apple, Inc.",
        "AC:29:3A": "Apple, Inc.",
        "9C:FC:01": "Apple, Inc.",
        "9C:35:EB": "Apple, Inc.",
        "48:43:7C": "Apple, Inc.",
        "34:A3:95": "Apple, Inc.",
        "78:7E:61": "Apple, Inc.",
        "60:F8:1D": "Apple, Inc.",
        "38:C9:86": "Apple, Inc.",
        "D0:33:11": "Apple, Inc.",
        "50:7A:55": "Apple, Inc.",
        "C8:C2:C6": "Shanghai Airm2m Communication Technology Co., Ltd",
        "78:9C:85": "August Home, Inc.",
        "74:D7:CA": "Panasonic Corporation Automotive",
        "58:82:A8": "Microsoft",
        "58:68:5D": "Tempo Australia Pty Ltd",
        "54:4B:8C": "Juniper Networks",
        "DC:FE:07": "PEGATRON CORPORATION",
        "70:79:38": "Wuxi Zhanrui Electronic Technology Co.,LTD",
        "24:31:84": "SHARP Corporation",
        "58:2B:DB": "Pax AB",
        "E0:36:76": "HUAWEI TECHNOLOGIES CO.,LTD",
        "EC:38:8F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D0:3E:5C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C4:9E:41": "G24 Power Limited",
        "B8:13:E9": "Trace Live Network",
        "80:B7:09": "Viptela, Inc",
        "F0:0D:5C": "JinQianMao  Technology Co.,Ltd.",
        "54:BE:53": "zte corporation",
        "28:0E:8B": "Beijing Spirit Technology Development Co., Ltd.",
        "F4:4D:30": "Elitegroup Computer Systems Co.,Ltd.",
        "0C:86:10": "Juniper Networks",
        "38:D4:0B": "Samsung Electronics Co.,Ltd",
        "E8:3A:12": "Samsung Electronics Co.,Ltd",
        "24:DA:9B": "Motorola Mobility LLC, a Lenovo Company",
        "A4:DC:BE": "HUAWEI TECHNOLOGIES CO.,LTD",
        "EC:B8:70": "Beijing Heweinet Technology Co.,Ltd.",
        "94:BB:AE": "Husqvarna AB",
        "D4:0A:A9": "ARRIS Group, Inc.",
        "20:3D:66": "ARRIS Group, Inc.",
        "D4:94:E8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B0:78:F0": "Beijing HuaqinWorld Technology Co.,Ltd.",
        "20:9B:CD": "Apple, Inc.",
        "30:95:E3": "SHANGHAI SIMCOM LIMITED",
        "80:65:6D": "Samsung Electronics Co.,Ltd",
        "FC:F1:36": "Samsung Electronics Co.,Ltd",
        "B8:86:87": "Liteon Technology Corporation",
        "18:89:5B": "Samsung Electronics Co.,Ltd",
        "58:49:25": "E3 Enterprise",
        "94:F2:78": "Elma Electronic",
        "28:37:13": "Shenzhen 3Nod Digital Technology Co., Ltd.",
        "08:94:EF": "Wistron Infocomm (Zhongshan) Corporation",
        "E0:31:9E": "Valve Corporation",
        "3C:5C:C3": "Shenzhen First Blue Chip Technology Ltd",
        "C4:9F:F3": "Mciao Technologies, Inc.",
        "78:8E:33": "Jiangsu SEUIC Technology Co.,Ltd",
        "EC:EE:D8": "ZTLX Network Technology Co.,Ltd",
        "80:EB:77": "Wistron Corporation",
        "48:39:74": "Proware Technologies Co., Ltd.",
        "30:FF:F6": "HangZhou KuoHeng Technology Co.,ltd",
        "4C:C6:81": "Shenzhen Aisat Electronic Co., Ltd.",
        "48:E2:44": "Hon Hai Precision Ind. Co.,Ltd.",
        "7C:AB:25": "MESMO TECHNOLOGY INC.",
        "B0:41:1D": "ITTIM Technologies",
        "F8:BF:09": "HUAWEI TECHNOLOGIES CO.,LTD",
        "7C:B2:5C": "Acacia Communications",
        "DC:DB:70": "Tonfunk Systementwicklung und Service GmbH",
        "80:0B:51": "Chengdu XGimi Technology Co.,Ltd",
        "F8:0D:60": "CANON INC.",
        "F0:18:2B": "LG Chem",
        "34:81:F4": "SST Taiwan Ltd.",
        "7C:A2:37": "King Slide Technology CO., LTD.",
        "D4:04:CD": "ARRIS Group, Inc.",
        "74:73:36": "MICRODIGTAL Inc",
        "38:2B:78": "ECO PLUGS ENTERPRISE CO., LTD",
        "A4:7B:2C": "Nokia",
        "24:E5:AA": "Philips Oral Healthcare, Inc.",
        "78:BD:BC": "Samsung Electronics Co.,Ltd",
        "34:9B:5B": "Maquet GmbH",
        "88:41:57": "Shenzhen Atsmart Technology Co.,Ltd.",
        "D8:9A:34": "Beijing SHENQI Technology Co., Ltd.",
        "A0:A6:5C": "Supercomputing Systems AG",
        "48:50:73": "Microsoft Corporation",
        "E8:37:7A": "Zyxel Communications Corporation",
        "80:3B:2A": "ABB Xiamen Low Voltage Equipment Co.,Ltd.",
        "7C:F9:0E": "Samsung Electronics Co.,Ltd",
        "50:F0:D3": "Samsung Electronics Co.,Ltd",
        "00:A7:84": "ITX security",
        "84:11:9E": "Samsung Electronics Co.,Ltd",
        "14:9A:10": "Microsoft Corporation",
        "38:FA:CA": "Skyworth Digital Technology(Shenzhen) Co.,Ltd",
        "5C:B4:3E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "70:77:81": "Hon Hai Precision Ind. Co.,Ltd.",
        "54:E1:40": "INGENICO",
        "E4:90:7E": "Motorola Mobility LLC, a Lenovo Company",
        "74:6A:3A": "Aperi Corporation",
        "94:A7:B7": "zte corporation",
        "18:44:E6": "zte corporation",
        "3C:CE:15": "Mercedes-Benz USA, LLC",
        "28:76:10": "IgniteNet",
        "20:D7:5A": "Posh Mobile Limited",
        "F4:15:63": "F5 Networks, Inc.",
        "8C:8B:83": "Texas Instruments",
        "40:11:DC": "Sonance",
        "1C:83:41": "Hefei Bitland Information Technology Co.Ltd",
        "08:1F:EB": "BinCube",
        "78:5F:4C": "Argox Information Co., Ltd.",
        "34:CC:28": "Nexpring Co. LTD.,",
        "54:E2:C8": "Dongguan Aoyuan Electronics Technology Co., Ltd",
        "6C:1E:70": "Guangzhou YBDS IT Co.,Ltd",
        "54:B8:0A": "D-Link International",
        "D8:AD:DD": "Sonavation, Inc.",
        "88:33:BE": "Ivenix, Inc.",
        "E4:8D:8C": "Routerboard.com",
        "70:68:79": "Saijo Denki International Co., Ltd.",
        "10:AF:78": "Shenzhen ATUE Technology Co., Ltd",
        "CC:19:A8": "PT Inovação e Sistemas SA",
        "B4:B2:65": "DAEHO I&T",
        "E0:35:60": "Challenger Supply Holdings, LLC",
        "3C:CB:7C": "TCT mobile ltd",
        "24:9E:AB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:4B:03": "Samsung Electronics Co.,Ltd",
        "E4:CE:70": "Health & Life co., Ltd.",
        "7C:11:CD": "QianTang Technology",
        "CC:A4:AF": "Shenzhen Sowell Technology Co., LTD",
        "10:2C:83": "XIMEA",
        "6C:A7:5F": "zte corporation",
        "8C:79:67": "zte corporation",
        "78:58:F3": "Vachen Co.,Ltd",
        "70:9C:8F": "Nero AG",
        "00:7E:56": "China Dragon Technology Limited",
        "74:E2:8C": "Microsoft Corporation",
        "00:71:C2": "PEGATRON CORPORATION",
        "7C:82:74": "Shenzhen Hikeen Technology CO.,LTD",
        "94:D4:17": "GPI KOREA INC.",
        "24:4B:81": "Samsung Electronics Co.,Ltd",
        "70:4E:66": "SHENZHEN FAST TECHNOLOGIES CO.,LTD",
        "D8:55:A3": "zte corporation",
        "38:D8:2F": "zte corporation",
        "F0:79:59": "ASUSTek COMPUTER INC.",
        "E0:8E:3C": "Aztech Electronics Pte Ltd",
        "84:4B:B7": "Beijing Sankuai Online Technology Co.,Ltd",
        "68:F0:BC": "Shenzhen LiWiFi Technology Co., Ltd",
        "30:0E:E3": "Aquantia Corporation",
        "18:F1:45": "NetComm Wireless Limited",
        "AC:AB:BF": "AthenTek Inc.",
        "28:84:FA": "SHARP Corporation",
        "60:AF:6D": "Samsung Electronics Co.,Ltd",
        "B8:5A:73": "Samsung Electronics Co.,Ltd",
        "3C:1E:04": "D-Link International",
        "60:D9:A0": "Lenovo Mobile Communication Technology Ltd.",
        "68:B9:83": "b-plus GmbH",
        "78:B3:B9": "ShangHai sunup lighting CO.,LTD",
        "04:C0:9C": "Tellabs Inc.",
        "98:1D:FA": "Samsung Electronics Co.,Ltd",
        "18:68:82": "Beward R&D Co., Ltd.",
        "EC:80:09": "NovaSparks",
        "50:AD:D5": "Dynalec Corporation",
        "B0:45:19": "TCT mobile ltd",
        "D8:8D:5C": "Elentec",
        "74:29:AF": "Hon Hai Precision Ind. Co.,Ltd.",
        "3C:1A:0F": "ClearSky Data",
        "E8:CC:18": "D-Link International",
        "B0:91:37": "ISis ImageStream Internet Solutions, Inc",
        "8C:05:51": "Koubachi AG",
        "D8:97:BA": "PEGATRON CORPORATION",
        "A8:D8:8A": "Wyconn",
        "40:EA:CE": "FOUNDER BROADBAND NETWORK SERVICE CO.,LTD",
        "A4:9D:49": "Ketra, Inc.",
        "C0:38:96": "Hon Hai Precision Ind. Co.,Ltd.",
        "2C:50:89": "Shenzhen Kaixuan Visual Technology Co.,Limited",
        "94:8E:89": "INDUSTRIAS UNIDAS SA DE CV",
        "00:AE:FA": "Murata Manufacturing Co., Ltd.",
        "84:18:26": "Osram GmbH",
        "F8:E9:03": "D-Link International",
        "E8:96:06": "testo Instruments (Shenzhen) Co., Ltd.",
        "1C:7E:51": "3bumen.com",
        "68:72:DC": "CETORY.TV Company Limited",
        "30:77:CB": "Maike Industry(Shenzhen)CO.,LTD",
        "24:97:ED": "Techvision Intelligent Technology Limited",
        "90:9F:33": "EFM Networks",
        "60:04:17": "POSBANK CO.,LTD",
        "20:76:93": "Lenovo (Beijing) Limited.",
        "08:46:56": "VEO-LABS",
        "EC:3C:5A": "SHEN ZHEN HENG SHENG HUI DIGITAL TECHNOLOGY CO.,LTD",
        "44:88:CB": "Camco Technologies NV",
        "6C:BF:B5": "Noon Technology Co., Ltd",
        "50:29:4D": "NANJING IOT SENSOR TECHNOLOGY CO,LTD",
        "0C:CF:D1": "SPRINGWAVE Co., Ltd",
        "74:BA:DB": "Longconn Electornics(shenzhen)Co.,Ltd",
        "B8:F3:17": "iSun Smasher Communications Private Limited",
        "8C:F8:13": "ORANGE POLSKA",
        "54:9F:35": "Dell Inc.",
        "24:42:BC": "Alinco,incorporated",
        "F8:24:41": "Yeelink",
        "10:8A:1B": "RAONIX Inc.",
        "10:2F:6B": "Microsoft Corporation",
        "8C:B0:94": "Airtech I&C Co., Ltd",
        "94:54:93": "Rigado, LLC",
        "68:F0:6D": "ALONG INDUSTRIAL CO., LIMITED",
        "F4:28:53": "Zioncom Electronics (Shenzhen) Ltd.",
        "D4:EC:86": "LinkedHope Intelligent Technologies Co., Ltd",
        "1C:9C:26": "Zoovel Technologies",
        "04:67:85": "scemtec Hard- und Software fuer Mess- und Steuerungstechnik GmbH",
        "D0:FA:1D": "Qihoo  360  Technology Co.,Ltd",
        "AC:11:D3": "Suzhou HOTEK  Video Technology Co. Ltd",
        "84:32:EA": "ANHUI WANZTEN P&T CO., LTD",
        "E0:1D:38": "Beijing HuaqinWorld Technology Co.,Ltd",
        "E4:7F:B2": "FUJITSU LIMITED",
        "FC:6D:C0": "BME CORPORATION",
        "24:D1:3F": "MEXUS CO.,LTD",
        "78:24:AF": "ASUSTek COMPUTER INC.",
        "FC:9F:E1": "CONWIN.Tech. Ltd",
        "B8:9B:E4": "ABB Power Systems Power Generation",
        "A8:1B:5D": "Foxtel Management Pty Ltd",
        "50:50:65": "TAKT Corporation",
        "40:C6:2A": "Shanghai Jing Ren Electronic Technology Co., Ltd.",
        "E8:15:0E": "Nokia Corporation",
        "C4:42:02": "Samsung Electronics Co.,Ltd",
        "B4:AE:6F": "Circle Reliance, Inc DBA Cranberry Networks",
        "90:DA:6A": "FOCUS H&S Co., Ltd.",
        "DC:53:7C": "Compal Broadband Networks, Inc.",
        "44:A6:E5": "THINKING TECHNOLOGY CO.,LTD",
        "A4:5D:A1": "ADB Broadband Italia",
        "0C:AC:05": "Unitend Technologies Inc.",
        "4C:6E:6E": "Comnect Technology CO.,LTD",
        "8C:33:57": "HiteVision Digital Media Technology Co.,Ltd.",
        "3C:AA:3F": "iKey, Ltd.",
        "0C:38:3E": "Fanvil Technology Co., Ltd.",
        "60:CD:A9": "Abloomy",
        "B8:AD:3E": "BLUECOM",
        "18:30:09": "Woojin Industrial Systems Co., Ltd.",
        "74:DB:D1": "Ebay Inc",
        "30:B5:F1": "Aitexin Technology Co., Ltd",
        "B0:10:41": "Hon Hai Precision Ind. Co.,Ltd.",
        "80:AD:67": "Kasda Networks Inc",
        "18:D5:B6": "SMG Holdings LLC",
        "5C:2E:59": "Samsung Electronics Co.,Ltd",
        "A8:E5:39": "Moimstone Co.,Ltd",
        "54:B7:53": "Hunan Fenghui Yinjia Science And Technology Co.,Ltd",
        "10:30:47": "Samsung Electronics Co.,Ltd",
        "F8:84:F2": "Samsung Electronics Co.,Ltd",
        "B0:75:4D": "Nokia",
        "E0:CB:EE": "Samsung Electronics Co.,Ltd",
        "4C:39:09": "HPL Electric & Power Private Limited",
        "90:7E:BA": "UTEK TECHNOLOGY (SHENZHEN) CO.,LTD",
        "A0:02:DC": "Amazon Technologies Inc.",
        "54:2A:A2": "Alpha Networks Inc.",
        "84:94:8C": "Hitron Technologies. Inc",
        "A8:F7:E0": "PLANET Technology Corporation",
        "44:86:C1": "Siemens Low Voltage & Products",
        "40:45:DA": "Spreadtrum Communications (Shanghai) Co., Ltd.",
        "34:51:AA": "JID GLOBAL",
        "98:BE:94": "IBM",
        "6C:19:8F": "D-Link International",
        "C8:FF:77": "Dyson Limited",
        "B4:9E:AC": "Imagik Int'l Corp",
        "CC:07:E4": "Lenovo Mobile Communication Technology Ltd.",
        "C4:6B:B4": "myIDkey",
        "0C:63:FC": "Nanjing Signway Technology Co., Ltd",
        "D4:E0:8E": "ValueHD Corporation",
        "C8:9F:1D": "SHENZHEN COMMUNICATION TECHNOLOGIES CO.,LTD",
        "14:3D:F2": "Beijing Shidai Hongyuan Network Communication Co.,Ltd",
        "2C:39:C1": "Ciena Corporation",
        "54:EE:75": "Wistron InfoComm(Kunshan)Co.,Ltd.",
        "08:74:F6": "Winterhalter Gastronom GmbH",
        "D8:49:2F": "CANON INC.",
        "80:0E:24": "ForgetBox",
        "3C:25:D7": "Nokia Corporation",
        "18:FF:2E": "Shenzhen Rui Ying Da Technology Co., Ltd",
        "84:72:07": "I&C Technology",
        "CC:A6:14": "AIFA TECHNOLOGY CORP.",
        "90:F1:B0": "Hangzhou Anheng Info&Tech CO.,LTD",
        "4C:8B:30": "Actiontec Electronics, Inc",
        "08:05:CD": "DongGuang EnMai Electronic Product Co.Ltd.",
        "54:D1:63": "MAX-TECH,INC",
        "48:B5:A7": "Glory Horse Industries Ltd.",
        "0C:4F:5A": "ASA-RT s.r.l.",
        "D4:22:4E": "Alcatel Lucent",
        "9C:86:DA": "Phoenix Geophysics Ltd.",
        "2C:07:3C": "DEVLINE LIMITED",
        "7C:1A:03": "8Locations Co., Ltd.",
        "AC:B8:59": "Uniband Electronic Corp,",
        "2C:9A:A4": "Eolo SpA",
        "88:B1:E1": "Mojo Networks, Inc.",
        "90:DB:46": "E-LEAD ELECTRONIC CO., LTD",
        "34:4F:5C": "R&amp;M AG",
        "60:47:D4": "FORICS Electronic Technology Co., Ltd.",
        "FC:F8:B7": "TRONTEQ Electronic",
        "30:F4:2F": "ESP",
        "70:4E:01": "KWANGWON TECH CO., LTD.",
        "74:6A:8F": "VS Vision Systems GmbH",
        "54:A3:1B": "Shenzhen Linkworld Technology Co,.LTD",
        "CC:39:8C": "Shiningtek",
        "18:20:A6": "Sage Co., Ltd.",
        "20:EA:C7": "SHENZHEN RIOPINE ELECTRONICS CO., LTD",
        "64:B3:70": "PowerComm Solutions LLC",
        "5C:F5:0D": "Institute of microelectronic applications",
        "74:9C:52": "Huizhou Desay SV Automotive Co., Ltd.",
        "C4:29:1D": "KLEMSAN ELEKTRIK ELEKTRONIK SAN.VE TIC.AS.",
        "6C:5F:1C": "Lenovo Mobile Communication Technology Ltd.",
        "7C:E4:AA": "Private",
        "08:3F:3E": "WSH GmbH",
        "2C:95:7F": "zte corporation",
        "3C:0C:48": "Servergy, Inc.",
        "10:DE:E4": "automationNEXT GmbH",
        "40:4A:18": "Addrek Smart Solutions",
        "C0:C5:69": "SHANGHAI LYNUC CNC TECHNOLOGY CO.,LTD",
        "C4:C0:AE": "MIDORI ELECTRONIC CO., LTD.",
        "AC:C5:95": "Graphite Systems",
        "7C:E1:FF": "Computer Performance, Inc. DBA Digital Loggers, Inc.",
        "D8:15:0D": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "58:50:AB": "TLS Corporation",
        "7C:CD:11": "MS-Magnet",
        "98:FF:6A": "OTEC(Shanghai)Technology Co.,Ltd.",
        "BC:1A:67": "YF Technology Co., Ltd",
        "4C:D7:B6": "Helmer Scientific",
        "84:25:A4": "Tariox Limited",
        "48:3D:32": "Syscor Controls &amp; Automation",
        "CC:85:6C": "SHENZHEN MDK DIGITAL TECHNOLOGY CO.,LTD",
        "AC:6B:AC": "Jenny Science AG",
        "D8:EE:78": "Moog Protokraft",
        "24:11:48": "Entropix, LLC",
        "C4:45:EC": "Shanghai Yali Electron Co.,LTD",
        "E0:E6:31": "SNB TECHNOLOGIES LIMITED",
        "78:B5:D2": "Ever Treasure Industrial Limited",
        "50:ED:78": "Changzhou Yongse Infotech Co.,Ltd",
        "90:02:8A": "Shenzhen Shidean Legrand Electronic Products Co.,Ltd",
        "1C:C1:1A": "Wavetronix",
        "FC:09:D8": "ACTEON Group",
        "74:3E:CB": "Gentrice tech",
        "7C:44:4C": "Entertainment Solutions, S.L.",
        "04:44:A1": "TELECON GALICIA,S.A.",
        "20:C6:0D": "Shanghai annijie Information technology Co.,LTD",
        "38:CA:97": "Contour Design LLC",
        "BC:2D:98": "ThinGlobal LLC",
        "18:79:A2": "GMJ ELECTRIC LIMITED",
        "E0:C8:6A": "SHENZHEN TW-SCIE Co., Ltd",
        "BC:EE:7B": "ASUSTek COMPUTER INC.",
        "34:13:A8": "Mediplan Limited",
        "7C:97:63": "Openmatics s.r.o.",
        "48:A2:B7": "Kodofon JSC",
        "CC:74:98": "Filmetrics Inc.",
        "08:5A:E0": "Recovision Technology Co., Ltd.",
        "20:E7:91": "Siemens Healthcare Diagnostics, Inc",
        "08:97:58": "Shenzhen Strong Rising Electronics Co.,Ltd DongGuan Subsidiary",
        "FC:19:D0": "Cloud Vision Networks Technology Co.,Ltd.",
        "94:86:D4": "Surveillance Pro Corporation",
        "9C:D6:43": "D-Link International",
        "3C:18:A0": "Luxshare Precision Industry Company Limited",
        "8C:AE:89": "Y-cam Solutions Ltd",
        "94:E9:8C": "Nokia",
        "FC:E1:D9": "Stable Imaging Solutions LLC",
        "50:20:6B": "Emerson Climate Technologies Transportation Solutions",
        "7C:BF:88": "Mobilicom LTD",
        "60:DB:2A": "HNS",
        "B0:45:45": "YACOUB Automation GmbH",
        "C8:EE:75": "Pishion International Co. Ltd",
        "CC:34:29": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "64:BA:BD": "SDJ Technologies, Inc.",
        "24:C8:48": "mywerk Portal GmbH",
        "CC:FB:65": "Nintendo Co., Ltd.",
        "A0:A2:3C": "GPMS",
        "68:FC:B3": "Next Level Security Systems, Inc.",
        "94:C3:E4": "Atlas Copco IAS GmbH",
        "34:88:5D": "Logitech Far East",
        "88:57:6D": "XTA Electronics Ltd",
        "BC:41:00": "CODACO ELECTRONIC s.r.o.",
        "FC:D8:17": "Beijing Hesun Technologies Co.Ltd.",
        "68:2D:DC": "Wuhan Changjiang Electro-Communication Equipment CO.,LTD",
        "E8:61:1F": "Dawning Information Industry Co.,Ltd",
        "28:47:AA": "Nokia Corporation",
        "5C:D6:1F": "Qardio, Inc",
        "70:59:57": "Medallion Instrumentation Systems",
        "9C:44:3D": "CHENGDU XUGUANG TECHNOLOGY CO, LTD",
        "B4:24:E7": "Codetek Technology Co.,Ltd",
        "54:2F:89": "Euclid Laboratories, Inc.",
        "90:99:16": "ELVEES NeoTek OJSC",
        "00:A2:FF": "abatec group AG",
        "60:24:C1": "Jiangsu Zhongxun Electronic Technology Co., Ltd",
        "A0:14:3D": "PARROT SA",
        "FC:1B:FF": "V-ZUG AG",
        "F4:28:96": "SPECTO PAINEIS ELETRONICOS LTDA",
        "78:CB:33": "DHC Software Co.,Ltd",
        "60:A9:B0": "Merchandising Technologies, Inc",
        "50:27:C7": "TECHNART Co.,Ltd",
        "6C:5A:B5": "TCL Technoly Electronics (Huizhou) Co., Ltd.",
        "38:5A:A8": "Beijing Zhongdun Security Technology Development Co.",
        "F4:A2:94": "EAGLE WORLD DEVELOPMENT CO., LIMITED",
        "EC:3E:09": "PERFORMANCE DESIGNED PRODUCTS, LLC",
        "94:7C:3E": "Polewall Norge AS",
        "34:A3:BF": "Terewave. Inc.",
        "8C:08:8B": "Remote Solution",
        "B4:3E:3B": "Viableware, Inc",
        "0C:5C:D8": "DOLI Elektronik GmbH",
        "3C:15:EA": "TESCOM CO., LTD.",
        "E8:04:10": "Private",
        "F4:BD:7C": "Chengdu jinshi communication Co., LTD",
        "DC:C4:22": "Systembase Limited",
        "C8:F3:6B": "Yamato Scale Co.,Ltd.",
        "98:F8:C1": "IDT Technology Limited",
        "6C:D1:B0": "WING SING ELECTRONICS HONG KONG LIMITED",
        "A4:F5:22": "CHOFU SEISAKUSHO CO.,LTD",
        "84:5C:93": "Chabrier Services",
        "68:E1:66": "Private",
        "BC:2B:D7": "Revogi Innovation Co., Ltd.",
        "28:6D:97": "SAMJIN Co., Ltd.",
        "24:EC:D6": "CSG Science & Technology Co.,Ltd.Hefei",
        "CC:2A:80": "Micro-Biz intelligence solutions Co.,Ltd",
        "60:FE:F9": "Thomas & Betts",
        "B8:DC:87": "IAI Corporation",
        "7C:6F:F8": "ShenZhen ACTO Digital Video Technology Co.,Ltd.",
        "DC:F7:55": "SITRONIK",
        "5C:02:6A": "Applied Vision Corporation",
        "0C:93:01": "PT. Prasimax Inovasi Teknologi",
        "74:66:30": "T:mi Ytti",
        "6C:B3:50": "Anhui comhigher tech co.,ltd",
        "38:59:F8": "MindMade Sp. z o.o.",
        "4C:DF:3D": "TEAM ENGINEERS ADVANCE TECHNOLOGIES INDIA PVT LTD",
        "E8:92:18": "Arcontia International AB",
        "00:75:E1": "Ampt, LLC",
        "98:CD:B4": "Virident Systems, Inc.",
        "A4:23:05": "Open Networking Laboratory",
        "1C:48:F9": "GN Netcom A/S",
        "B0:FE:BD": "Private",
        "60:69:9B": "isepos GmbH",
        "D4:D5:0D": "Southwest Microwave, Inc",
        "34:CD:6D": "CommSky Technologies",
        "E4:F3:E3": "Shanghai iComhome Co.,Ltd.",
        "90:46:B7": "Vadaro Pte Ltd",
        "04:CF:25": "MANYCOLORS, INC.",
        "80:BB:EB": "Satmap Systems Ltd",
        "00:B7:8D": "Nanjing Shining Electric Automation Co., Ltd",
        "60:FE:1E": "China Palms Telecom.Ltd",
        "B0:50:BC": "SHENZHEN BASICOM ELECTRONIC CO.,LTD.",
        "84:1E:26": "KERNEL-I Co.,LTD",
        "B4:34:6C": "MATSUNICHI DIGITAL TECHNOLOGY (HONG KONG) LIMITED",
        "00:86:A0": "Private",
        "A0:5B:21": "ENVINET GmbH",
        "50:B8:A2": "ImTech Technologies LLC,",
        "B0:4C:05": "Fresenius Medical Care Deutschland GmbH",
        "B0:79:3C": "Revolv Inc",
        "9C:4E:BF": "BoxCast",
        "34:A8:43": "KYOCERA Display Corporation",
        "74:CA:25": "Calxeda, Inc.",
        "5C:A3:EB": "Lokel s.r.o.",
        "C8:B3:73": "Cisco-Linksys, LLC",
        "0C:2A:E7": "Beijing General Research Institute of Mining and Metallurgy",
        "98:30:71": "DAIKYUNG VASCOM",
        "D4:95:24": "Clover Network, Inc.",
        "94:50:47": "Rechnerbetriebsgruppe",
        "E0:31:D0": "SZ Telstar CO., LTD",
        "54:11:2F": "Sulzer Pump Solutions Finland Oy",
        "4C:55:B8": "Turkcell Teknoloji",
        "08:80:39": "Cisco SPVTG",
        "E4:38:F2": "Advantage Controls",
        "C4:C7:55": "Beijing HuaqinWorld Technology Co.,Ltd",
        "0C:2D:89": "QiiQ Communications Inc.",
        "A8:D2:36": "Lightware Visual Engineering",
        "98:10:94": "Shenzhen Vsun communication technology Co.,ltd",
        "A4:F3:C1": "Open Source Robotics Foundation, Inc.",
        "14:13:30": "Anakreon UK LLP",
        "0C:F4:05": "Beijing Signalway Technologies Co.,Ltd",
        "50:61:D6": "Indu-Sol GmbH",
        "DC:70:14": "Private",
        "78:8D:F7": "Hitron Technologies. Inc",
        "2C:24:5F": "Babolat VS",
        "90:56:92": "Autotalks Ltd.",
        "04:BF:A8": "ISB Corporation",
        "8C:C7:D0": "zhejiang ebang communication co.,ltd",
        "B8:AE:6E": "Nintendo Co., Ltd.",
        "D0:EB:03": "Zhehua technology limited",
        "68:3E:EC": "ERECA",
        "C4:26:28": "Airo Wireless",
        "30:AA:BD": "Shanghai Reallytek Information Technology Co.,Ltd",
        "A4:B8:18": "PENTA Gesellschaft für elektronische Industriedatenverarbeitung mbH",
        "C0:4D:F7": "SERELEC",
        "0C:84:84": "Zenovia Electronics Inc.",
        "00:59:07": "LenovoEMC Products USA, LLC",
        "50:A7:15": "Aboundi, Inc.",
        "0C:04:00": "Jantar d.o.o.",
        "68:7C:D5": "Y Soft Corporation, a.s.",
        "90:7A:F1": "Wally",
        "2C:B6:93": "Radware",
        "A8:61:AA": "Cloudview Limited",
        "FC:11:86": "Logic3 plc",
        "E0:18:77": "FUJITSU LIMITED",
        "E4:57:A8": "Stuart Manufacturing, Inc.",
        "78:99:66": "Musilab Electronics (DongGuan)Co.,Ltd.",
        "28:CB:EB": "One",
        "7C:A1:5D": "GN ReSound A/S",
        "3C:08:1E": "Beijing Yupont Electric Power Technology Co.,Ltd",
        "FC:58:FA": "Shen Zhen Shi Xin Zhong Xin Technology Co.,Ltd.",
        "4C:CC:34": "Motorola Solutions Inc.",
        "D0:D4:71": "MVTECH co., Ltd",
        "08:68:D0": "Japan System Design",
        "D4:22:3F": "Lenovo Mobile Communication Technology Ltd.",
        "C8:EE:A6": "Shenzhen SHX Technology Co., Ltd",
        "24:81:AA": "KSH International Co., Ltd.",
        "AC:41:22": "Eclipse Electronic Systems Inc.",
        "68:97:E8": "Society of Motion Picture &amp; Television Engineers",
        "E8:E8:75": "iS5 Communications Inc.",
        "C8:0E:95": "OmniLync Inc.",
        "30:05:5C": "Brother industries, LTD.",
        "08:0E:A8": "Velex s.r.l.",
        "B8:C4:6F": "PRIMMCON INDUSTRIES INC",
        "D8:B0:2E": "Guangzhou Zonerich Business Machine Co., LTD.",
        "C4:E0:32": "IEEE 1904.1 Working Group",
        "58:EB:14": "Proteus Digital Health",
        "C4:58:C2": "Shenzhen TATFOOK Technology Co., Ltd.",
        "D0:CD:E1": "Scientech Electronics",
        "5C:E0:CA": "FeiTian United (Beijing) System Technology Co., Ltd.",
        "E0:81:77": "GreenBytes, Inc.",
        "9C:98:11": "Guangzhou Sunrise Electronics Development Co., Ltd",
        "B8:60:91": "Onnet Technologies and Innovations LLC",
        "8C:76:C1": "Goden Tech Limited",
        "8C:07:8C": "FLOW DATA INC",
        "F8:DF:A8": "zte corporation",
        "A8:95:B0": "Aker Subsea Ltd",
        "10:4D:77": "Innovative Computer Engineering",
        "C4:5D:D8": "HDMI Forum",
        "C4:EB:E3": "RRCN SAS",
        "94:75:6E": "QinetiQ North America",
        "4C:1A:95": "Novakon Co., Ltd.",
        "60:BB:0C": "Beijing HuaqinWorld Technology Co,Ltd",
        "A4:2C:08": "Masterwork Automodules",
        "10:B9:FE": "Lika srl",
        "30:15:18": "Ubiquitous Communication Co. ltd.",
        "84:17:15": "GP Electronics (HK) Ltd.",
        "84:8E:96": "Embertec Pty Ltd",
        "64:99:A0": "AG Elektronik AB",
        "08:F1:B7": "Towerstream Corpration",
        "C0:44:E3": "Shenzhen Sinkna Electronics Co., LTD",
        "18:55:0F": "Cisco SPVTG",
        "18:7A:93": "AMICCOM Electronics Corporation",
        "88:87:DD": "DarbeeVision Inc.",
        "30:C8:2A": "WI-BIZ srl",
        "88:A3:CC": "Amatis Controls",
        "C0:A0:C7": "FAIRFIELD INDUSTRIES",
        "DC:A9:89": "MACANDC",
        "A0:03:63": "Robert Bosch Healthcare GmbH",
        "D0:B4:98": "Robert Bosch LLC Automotive Electronics",
        "E0:55:97": "Emergent Vision Technologies Inc.",
        "7C:43:8F": "E-Band Communications Corp.",
        "A0:E2:5A": "Amicus SK, s.r.o.",
        "D4:0F:B2": "Applied Micro Electronics AME bv",
        "44:9B:78": "The Now Factory",
        "F0:F6:69": "Motion Analysis Corporation",
        "78:99:5C": "Nationz Technologies Inc",
        "84:9D:C5": "Centera Photonics Inc.",
        "58:09:43": "Private",
        "EC:FC:55": "A. Eberle GmbH & Co. KG",
        "18:2A:7B": "Nintendo Co., Ltd.",
        "68:FB:95": "Generalplus Technology Inc.",
        "5C:89:D4": "Beijing Banner Electric Co.,Ltd",
        "54:11:5F": "Atamo Pty Ltd",
        "8C:AE:4C": "Plugable Technologies",
        "0C:C6:55": "Wuxi YSTen Technology Co.,Ltd.",
        "24:2F:FA": "Toshiba Global Commerce Solutions",
        "E4:96:AE": "ALTOGRAPHICS Inc.",
        "4C:22:58": "cozybit, Inc.",
        "F4:94:66": "CountMax,  ltd",
        "F4:52:14": "Mellanox Technologies, Inc.",
        "1C:95:9F": "Veethree Electronics And Marine LLC",
        "08:81:F4": "Juniper Networks",
        "10:F4:9A": "T3 Innovation",
        "3C:57:BD": "Kessler Crane Inc.",
        "04:E9:E5": "PJRC.COM, LLC",
        "60:BD:91": "Move Innovation",
        "CC:4B:FB": "Hellberg Safety AB",
        "6C:AD:EF": "KZ Broadband Technologies, Ltd. ",
        "74:5F:AE": "TSL PPL",
        "68:51:B7": "PowerCloud Systems, Inc.",
        "74:2D:0A": "Norfolk Elektronik AG",
        "70:F1:E5": "Xetawave LLC",
        "C0:AA:68": "OSASI Technos Inc.",
        "88:D7:BC": "DEP Company",
        "48:5A:3F": "WISOL",
        "60:BC:4C": "EWM Hightec Welding GmbH",
        "1C:11:E1": "Wartsila Finland Oy",
        "50:46:5D": "ASUSTek COMPUTER INC.",
        "74:BF:A1": "HYUNTECK",
        "CC:26:2D": "Verifi, LLC",
        "3C:8A:E5": "Tensun Information Technology(Hangzhou) Co.,LTD",
        "2C:5A:A3": "PROMATE ELECTRONIC CO.LTD",
        "34:E0:CF": "zte corporation",
        "08:B7:38": "Lite-On Technogy Corp.",
        "F8:AA:8A": "Axview Technology (Shenzhen) Co.,Ltd",
        "7C:01:87": "Curtis Instruments, Inc.",
        "54:F6:66": "Berthold Technologies GmbH and Co.KG",
        "34:C8:03": "Nokia Corporation",
        "F0:5F:5A": "Getriebebau NORD GmbH and Co. KG",
        "80:1D:AA": "Avaya Inc",
        "7C:09:2B": "Bekey A/S",
        "84:2B:BC": "Modelleisenbahn GmbH",
        "B4:00:9C": "CableWorld Ltd.",
        "28:9E:DF": "Danfoss Turbocor Compressors, Inc",
        "80:3F:D6": "bytes at work AG",
        "78:44:05": "FUJITU(HONG KONG) ELECTRONIC Co.,LTD.",
        "04:4A:50": "Ramaxel Technology (Shenzhen) limited company",
        "0C:D9:C1": "Visteon Corporation",
        "38:A5:B6": "SHENZHEN MEGMEET ELECTRICAL CO.,LTD",
        "68:AB:8A": "RF IDeas",
        "24:EE:3A": "Chengdu Yingji Electronic Hi-tech Co Ltd",
        "0C:C6:6A": "Nokia Corporation",
        "74:27:3C": "ChangYang Technology (Nanjing) Co., LTD",
        "08:7C:BE": "Quintic Corp.",
        "E8:04:F3": "Throughtek Co., Ltd.",
        "08:68:EA": "EITO ELECTRONICS CO., LTD.",
        "F8:22:85": "Cypress Technology CO., LTD.",
        "C4:AD:21": "MEDIAEDGE Corporation",
        "E8:5B:F0": "Imaging Diagnostics",
        "A4:0B:ED": "Carry Technology Co.,Ltd",
        "70:23:93": "fos4X GmbH",
        "64:D8:14": "Cisco Systems, Inc",
        "F8:5F:2A": "Nokia Corporation",
        "C4:38:D3": "TAGATEC CO.,LTD",
        "50:2E:CE": "Asahi Electronics Co.,Ltd",
        "AC:14:D2": "wi-daq, inc.",
        "9C:4C:AE": "Mesa Labs",
        "20:C1:AF": "i Wit Digital Co., Limited",
        "80:AA:A4": "USAG",
        "30:AE:F6": "Radio Mobile Access",
        "08:5B:0E": "Fortinet, Inc.",
        "EC:42:F0": "ADL Embedded Solutions, Inc.",
        "E8:CB:A1": "Nokia Corporation",
        "6C:E4:CE": "Villiger Security Solutions AG",
        "64:9F:F7": "Kone OYj",
        "CC:91:2B": "TE Connectivity Touch Solutions",
        "C0:5E:79": "SHENZHEN HUAXUN ARK TECHNOLOGIES CO.,LTD",
        "58:BF:EA": "Cisco Systems, Inc",
        "C4:01:B1": "SeekTech INC",
        "C0:C9:46": "MITSUYA LABORATORIES INC.",
        "F4:60:0D": "Panoptic Technology, Inc",
        "A8:2B:D6": "Shina System Co., Ltd",
        "AC:CF:23": "Hi-flying electronics technology Co.,Ltd",
        "60:90:84": "DSSD Inc",
        "FC:1D:59": "I Smart Cities HK Ltd",
        "78:C4:AB": "Shenzhen Runsil Technology Co.,Ltd",
        "B0:A8:6E": "Juniper Networks",
        "80:2A:FA": "Germaneers GmbH",
        "18:42:1D": "Private",
        "28:C9:14": "Taimag Corporation",
        "74:93:A4": "Zebra Technologies Corp.",
        "E4:71:85": "Securifi Ltd",
        "08:0C:C9": "Mission Technology Group, dba Magma",
        "64:0E:94": "Pluribus Networks, Inc.",
        "0C:B4:EF": "Digience Co.,Ltd.",
        "14:6A:0B": "Cypress Electronics Limited",
        "5C:EE:79": "Global Digitech Co LTD",
        "4C:AA:16": "AzureWave Technologies (Shanghai) Inc.",
        "AC:40:EA": "C&T Solution Inc. ",
        "00:2A:AF": "LARsys-Automation GmbH",
        "1C:E1:65": "Marshal Corporation",
        "40:16:FA": "EKM Metering",
        "0C:13:0B": "Uniqoteq Ltd.",
        "2C:54:2D": "Cisco Systems, Inc",
        "BC:14:01": "Hitron Technologies. Inc",
        "94:CA:0F": "Honeywell Analytics",
        "78:25:44": "Omnima Limited",
        "A4:18:75": "Cisco Systems, Inc",
        "C8:AE:9C": "Shanghai TYD Elecronic Technology Co. Ltd",
        "AC:3F:A4": "TAIYO YUDEN CO.,LTD",
        "6C:AE:8B": "IBM Corporation",
        "40:AC:8D": "Data Management, Inc.",
        "80:CE:B1": "Theissen Training Systems GmbH",
        "FC:2A:54": "Connected Data, Inc.",
        "04:5C:06": "Zmodo Technology Corporation",
        "74:7B:7A": "ETH Inc.",
        "48:EA:63": "Zhejiang Uniview Technologies Co., Ltd.",
        "E8:8D:F5": "ZNYX Networks, Inc.",
        "90:F7:2F": "Phillips Machine & Welding Co., Inc. ",
        "D0:57:85": "Pantech Co., Ltd.",
        "40:8B:07": "Actiontec Electronics, Inc",
        "28:41:21": "OptiSense Network, LLC",
        "38:45:8C": "MyCloud Technology corporation",
        "10:E4:AF": "APR, LLC",
        "F4:EA:67": "Cisco Systems, Inc",
        "2C:2D:48": "bct electronic GesmbH",
        "28:BA:18": "NextNav, LLC",
        "AC:3D:75": "HANGZHOU ZHIWAY TECHNOLOGIES CO.,LTD.",
        "A0:90:DE": "VEEDIMS,LLC",
        "64:2D:B7": "SEUNGIL ELECTRONICS",
        "00:2A:6A": "Cisco Systems, Inc",
        "F4:36:E1": "Abilis Systems SARL",
        "78:1C:5A": "SHARP Corporation",
        "E8:0C:75": "Syncbak, Inc.",
        "80:0A:06": "COMTEC co.,ltd",
        "60:8C:2B": "Hanson Technology",
        "94:00:70": "Nokia Corporation",
        "BC:2C:55": "Bear Flag Design, Inc.",
        "0C:75:23": "BEIJING GEHUA CATV NETWORK CO.,LTD",
        "04:F0:21": "Compex Systems Pte Ltd",
        "28:18:FD": "Aditya Infotech Ltd.",
        "D8:B9:0E": "Triple Domain Vision Co.,Ltd.",
        "34:2F:6E": "Anywire corporation",
        "CC:EE:D9": "VAHLE Automation GmbH",
        "00:5C:B1": "Gospell DIGITAL TECHNOLOGY CO., LTD",
        "B0:8E:1A": "URadio Systems Co., Ltd",
        "D8:E9:52": "KEOPSYS",
        "BC:A4:E1": "Nabto",
        "90:8F:CF": "UNO System Co., Ltd",
        "40:E7:93": "Shenzhen Siviton Technology Co.,Ltd",
        "00:08:31": "Cisco Systems, Inc",
        "34:D0:9B": "MobilMAX Technology Inc.",
        "F0:00:7F": "Janz - Contadores de Energia, SA",
        "30:B3:A2": "Shenzhen Heguang Measurement & Control Technology Co.,Ltd",
        "50:60:28": "Xirrus Inc.",
        "00:91:FA": "Synapse Product Development",
        "A0:5A:A4": "Grand Products Nevada, Inc.",
        "F0:EE:BB": "VIPAR GmbH",
        "6C:E9:07": "Nokia Corporation",
        "E4:FA:1D": "PAD Peripheral Advanced Design Inc.",
        "1C:5C:55": "PRIMA Cinema, Inc",
        "34:BA:9A": "Asiatelco Technologies Co.",
        "50:64:41": "Greenlee",
        "9C:1F:DD": "Accupix Inc.",
        "7C:DD:11": "Chongqing MAS SCI&TECH.Co.,Ltd",
        "B8:FD:32": "Zhejiang ROICX Microelectronics",
        "70:EE:50": "Netatmo",
        "98:4A:47": "CHG Hospital Beds",
        "14:49:78": "Digital Control Incorporated",
        "2C:10:C1": "Nintendo Co., Ltd.",
        "8C:D1:7B": "CG Mobile",
        "50:22:67": "PixeLINK",
        "3C:6A:7D": "Niigata Power Systems Co., Ltd.",
        "3C:70:59": "MakerBot Industries",
        "50:26:90": "FUJITSU LIMITED",
        "24:B6:57": "Cisco Systems, Inc",
        "C8:AF:40": "marco Systemanalyse und Entwicklung GmbH",
        "40:98:4C": "Casacom Solutions AG",
        "5C:18:B5": "Talon Communications",
        "64:E1:61": "DEP Corp.",
        "88:23:FE": "TTTech Computertechnik AG",
        "B8:9A:ED": "OceanServer Technology, Inc",
        "C8:7D:77": "Shenzhen Kingtech Communication Equipment Co.,Ltd",
        "94:AE:61": "Alcatel Lucent",
        "5C:CE:AD": "CDYNE Corporation",
        "AC:54:EC": "IEEE P1823 Standards Working Group",
        "70:97:56": "Happyelectronics Co.,Ltd",
        "B8:20:E7": "Guangzhou Horizontal Information & Network Integration Co. Ltd",
        "00:CD:90": "MAS Elektronik AG",
        "7C:6B:52": "Tigaro Wireless",
        "00:64:A6": "Maquet CardioVascular",
        "98:8B:AD": "Corintech Ltd.",
        "D4:4B:5E": "TAIYO YUDEN CO., LTD.",
        "64:0E:36": "TAZTAG",
        "94:1D:1C": "TLab West Systems AB",
        "E4:55:EA": "Dedicated Computing",
        "B0:5C:E5": "Nokia Corporation",
        "34:82:DE": "Kiio Inc",
        "4C:5F:D2": "Alcatel-Lucent",
        "28:C7:18": "Altierre",
        "7C:4C:58": "Scale Computing, Inc.",
        "10:13:EE": "Justec International Technology INC.",
        "8C:27:1D": "QuantHouse",
        "38:60:77": "PEGATRON CORPORATION",
        "70:81:05": "Cisco Systems, Inc",
        "E0:ED:1A": "vastriver Technology Co., Ltd",
        "D4:F6:3F": "IEA S.R.L.",
        "58:B0:D4": "ZuniData Systems Inc.",
        "64:55:7F": "NSFOCUS Information Technology Co., Ltd.",
        "00:08:2F": "Cisco Systems, Inc",
        "9C:C7:D1": "SHARP Corporation",
        "14:90:90": "KongTop industrial(shen zhen)CO.,LTD",
        "38:DE:60": "Mohlenhoff GmbH",
        "28:39:E7": "Preceno Technology Pte.Ltd.",
        "68:5E:6B": "PowerRay Co., Ltd.",
        "20:C8:B3": "SHENZHEN BUL-TECH CO.,LTD.",
        "F8:E7:B5": "µTech Tecnologia LTDA",
        "D4:CE:B8": "Enatel LTD",
        "80:7A:7F": "ABB Genway Xiamen Electrical Equipment CO., LTD",
        "24:DA:B6": "Sistemas de Gestión Energética S.A. de C.V",
        "B0:7D:62": "Dipl.-Ing. H. Horstmann GmbH",
        "B8:F5:E7": "WayTools, LLC",
        "B8:19:99": "Nesys",
        "34:25:5D": "Shenzhen Loadcom Technology Co.,Ltd",
        "4C:A7:4B": "Alcatel Lucent",
        "D0:31:10": "Ingenic Semiconductor Co.,Ltd",
        "1C:E1:92": "Qisda Corporation",
        "70:6F:81": "Private",
        "FC:00:12": "Toshiba Samsung Storage Technolgoy Korea Corporation ",
        "18:14:20": "TEB SAS",
        "AC:81:F3": "Nokia Corporation",
        "30:68:8C": "Reach Technology Inc.",
        "10:EE:D9": "Canoga Perkins Corporation",
        "94:DE:0E": "SmartOptics AS",
        "C0:29:F3": "XySystem",
        "AC:4A:FE": "Hisense Broadband Multimedia Technology Co.,Ltd.",
        "54:F5:B6": "ORIENTAL PACIFIC INTERNATIONAL LIMITED",
        "90:34:2B": "Gatekeeper Systems, Inc.",
        "8C:B8:2C": "IPitomy Communications",
        "80:7D:E3": "Chongqing Sichuan Instrument Microcircuit Co.LTD.",
        "DC:17:5A": "Hitachi High-Technologies Corporation",
        "C8:A1:BA": "Neul Ltd",
        "C4:3A:9F": "Siconix Inc.",
        "68:6E:23": "Wi3 Inc.",
        "DC:F0:5D": "Letta Teknoloji",
        "84:8F:69": "Dell Inc.",
        "3C:09:6D": "Powerhouse Dynamics",
        "90:0D:66": "Digimore Electronics Co., Ltd",
        "0C:92:4E": "Rice Lake Weighing Systems",
        "F4:94:61": "NexGen Storage",
        "B8:CD:A7": "Maxeler Technologies Ltd.",
        "54:35:DF": "Symeo GmbH",
        "F4:3D:80": "FAG Industrial Services GmbH",
        "F0:DB:30": "Yottabyte",
        "9C:31:B6": "Kulite Semiconductor Products Inc",
        "A4:B3:6A": "JSC SDO Chromatec",
        "E4:DD:79": "En-Vision America, Inc.",
        "E8:CC:32": "Micronet  LTD",
        "D4:3A:E9": "DONGGUAN ipt INDUSTRIAL CO., LTD",
        "8C:5C:A1": "d-broad,INC",
        "18:F6:50": "Multimedia Pacific Limited",
        "68:84:70": "eSSys Co.,Ltd",
        "48:DC:FB": "Nokia Corporation",
        "20:B7:C0": "OMICRON electronics GmbH",
        "80:58:C5": "NovaTec Kommunikationstechnik GmbH",
        "B8:C7:16": "Fiberhome Telecommunication Technologies Co.,LTD",
        "D4:2C:3D": "Sky Light Digital Limited",
        "A4:5A:1C": "smart-electronic GmbH",
        "80:64:59": "Nimbus Inc.",
        "8C:89:A5": "Micro-Star INT'L CO., LTD",
        "B4:A5:A9": "MODI GmbH",
        "C4:36:DA": "Rusteletech Ltd.",
        "04:32:F4": "Partron",
        "1C:18:4A": "ShenZhen RicherLink Technologies Co.,LTD",
        "0C:39:56": "Observator instruments",
        "DC:A6:BD": "Beijing Lanbo Technology Co., Ltd.",
        "10:C5:86": "BIO SOUND LAB CO., LTD.",
        "10:76:8A": "EoCell",
        "F4:4E:FD": "Actions Semiconductor Co.,Ltd.(Cayman Islands)",
        "24:B8:D2": "Opzoon Technology Co.,Ltd.",
        "A4:99:81": "FuJian Elite Power Tech CO.,LTD.",
        "B8:3A:7B": "Worldplay (Canada) Inc.",
        "14:07:E0": "Abrantix AG",
        "DC:CF:94": "Beijing Rongcheng Hutong Technology Co., Ltd.",
        "A4:DB:2E": "Kingspan Environmental Ltd",
        "C8:FE:30": "Bejing DAYO Mobile Communication Technology Ltd.",
        "E4:D7:1D": "Oraya Therapeutics",
        "24:C9:DE": "Genoray",
        "54:05:5F": "Alcatel Lucent",
        "6C:5D:63": "ShenZhen Rapoo Technology Co., Ltd.",
        "94:16:73": "Point Core SARL",
        "5C:56:ED": "3pleplay Electronics Private Limited",
        "78:02:8F": "Adaptive Spectrum and Signal Alignment (ASSIA), Inc.",
        "DC:16:A2": "Medtronic Diabetes",
        "30:8C:FB": "Dropcam",
        "D0:EB:9E": "Seowoo Inc.",
        "BC:CD:45": "VOISMART",
        "14:3E:60": "Nokia",
        "70:32:D5": "Athena Wireless Communications Inc",
        "78:51:0C": "LiveU Ltd.",
        "44:AA:E8": "Nanotec Electronic GmbH & Co. KG",
        "D4:28:B2": "ioBridge, Inc.",
        "84:27:CE": "Corporation of the Presiding Bishop of The Church of Jesus Christ of Latter-day Saints",
        "48:D8:FE": "ClarIDy Solutions, Inc.",
        "D4:94:5A": "COSMO CO., LTD",
        "30:4C:7E": "Panasonic Electric Works Automation Controls Techno Co.,Ltd.",
        "5C:F2:07": "Speco Technologies",
        "B4:2A:39": "ORBIT MERRET, spol. s r. o.",
        "70:E8:43": "Beijing C&W Optical Communication Technology Co.,Ltd.",
        "2C:7E:CF": "Onzo Ltd",
        "50:E5:49": "GIGA-BYTE TECHNOLOGY CO.,LTD.",
        "B4:B8:8D": "Thuh Company",
        "4C:73:A5": "KOVE",
        "70:A4:1C": "Advanced Wireless Dynamics S.L.",
        "BC:BB:C9": "Kellendonk Elektronik GmbH",
        "E4:2A:D3": "Magneti Marelli S.p.A. Powertrain",
        "E8:3E:B6": "RIM",
        "BC:35:E5": "Hydro Systems Company",
        "9C:5D:95": "VTC Electronics Corp.",
        "B8:A8:AF": "Logic S.p.A.",
        "60:F6:73": "TERUMO CORPORATION",
        "28:CC:FF": "Corporacion Empresarial Altra SL",
        "94:FD:1D": "WhereWhen Corp",
        "4C:07:C9": "COMPUTER OFFICE Co.,Ltd.",
        "F8:76:9B": "Neopis Co., Ltd.",
        "74:B0:0C": "Network Video Technologies, Inc",
        "E8:40:40": "Cisco Systems, Inc",
        "D8:9D:B9": "eMegatech International Corp.",
        "40:5A:9B": "ANOVO",
        "E0:69:95": "PEGATRON CORPORATION",
        "84:DE:3D": "Crystal Vision Ltd",
        "D0:75:BE": "Reno A&E",
        "BC:6E:76": "Green Energy Options Ltd",
        "E8:28:D5": "Cots Technology",
        "F8:DA:F4": "Taishan Online Technology Co., Ltd.",
        "08:D5:C0": "Seers Technology Co., Ltd",
        "6C:33:A9": "Magicjack LP",
        "10:8C:CF": "Cisco Systems, Inc",
        "D8:E3:AE": "CIRTEC MEDICAL SYSTEMS",
        "08:B7:EC": "Wireless Seismic",
        "18:AF:9F": "DIGITRONIC Automationsanlagen GmbH",
        "00:B3:42": "MacroSAN Technologies Co., Ltd.",
        "1C:F5:E7": "Turtle Industry Co., Ltd.",
        "98:0E:E4": "Private",
        "44:7D:A5": "VTION INFORMATION TECHNOLOGY (FUJIAN) CO.,LTD",
        "0C:CD:D3": "EASTRIVER TECHNOLOGY CO., LTD.",
        "E4:6C:21": "messMa GmbH",
        "00:B0:33": "OAO Izhevskiy radiozavod",
        "08:17:35": "Cisco Systems, Inc",
        "C8:9C:1D": "Cisco Systems, Inc",
        "E4:37:D7": "HENRI DEPAEPE S.A.S.",
        "E0:A1:D7": "SFR",
        "94:81:A4": "Azuray Technologies",
        "BC:E0:9D": "Eoslink",
        "9C:22:0E": "TASCAN Systems GmbH",
        "7C:DD:90": "Shenzhen Ogemray Technology Co., Ltd.",
        "0C:3C:65": "Dome Imaging Inc",
        "C8:DF:7C": "Nokia Corporation",
        "B4:4C:C2": "NR ELECTRIC CO., LTD",
        "48:CB:6E": "Cello Electronics (UK) Ltd",
        "BC:43:77": "Hang Zhou Huite Technology Co.,ltd.",
        "CC:76:69": "SEETECH",
        "AC:20:AA": "DMATEK Co., Ltd.",
        "FC:AF:6A": "Qulsar Inc",
        "34:6F:92": "White Rodgers Division",
        "34:BD:F9": "Shanghai WDK Industrial Co.,Ltd.",
        "CC:BE:71": "OptiLogix BV",
        "0C:46:9D": "MS Sedco",
        "B0:9A:E2": "STEMMER IMAGING GmbH",
        "14:EE:9D": "AirNav Systems LLC",
        "78:D0:04": "Neousys Technology Inc.",
        "88:95:B9": "Unified Packet Systems Crop",
        "D8:FE:8F": "IDFone Co., Ltd.",
        "88:8C:19": "Brady Corp Asia Pacific Ltd",
        "44:8C:52": "KTIS CO., Ltd",
        "00:6D:FB": "Vutrix Technologies Ltd",
        "84:18:88": "Juniper Networks",
        "90:67:B5": "Alcatel-Lucent",
        "E0:F3:79": "Vaddio",
        "78:B6:C1": "AOBO Telecom Co.,Ltd",
        "08:D2:9A": "Proformatique",
        "C8:93:83": "Embedded Automation, Inc.",
        "78:A0:51": "iiNet Labs Pty Ltd ",
        "80:4F:58": "ThinkEco, Inc.",
        "04:75:F5": "CSST",
        "24:BA:30": "Technical Consumer Products, Inc.",
        "18:8E:D5": "TP Vision Belgium N.V. - innovation site Brugge",
        "E8:0C:38": "DAEYOUNG INFORMATION SYSTEM CO., LTD",
        "E0:8A:7E": "Exponent",
        "E4:27:71": "Smartlabs",
        "34:DF:2A": "Fujikon Industrial Co.,Limited",
        "2C:DD:0C": "Discovergy GmbH",
        "40:B2:C8": "Nortel Networks",
        "70:A1:91": "Trendsetter Medical, LLC",
        "70:8B:78": "citygrow technology co., ltd",
        "64:31:7E": "Dexin Corporation",
        "3C:99:F7": "Lansentechnology AB",
        "50:7D:02": "BIODIT",
        "B4:A4:E3": "Cisco Systems, Inc",
        "8C:1F:94": "RF Surgical System Inc. ",
        "44:91:DB": "Shanghai Huaqin Telecom Technology Co.,Ltd",
        "14:D7:6E": "CONCH ELECTRONIC Co.,Ltd",
        "CC:6B:98": "Minetec Wireless Technologies",
        "3C:04:BF": "PRAVIS SYSTEMS Co.Ltd.,",
        "94:DD:3F": "A+V Link Technologies, Corp.",
        "F4:42:27": "S & S Research Inc.",
        "C8:A7:29": "SYStronics Co., Ltd.",
        "44:54:C0": "Thompson Aerospace",
        "C4:F4:64": "Spica international",
        "60:2A:54": "CardioTek B.V.",
        "BC:FF:AC": "TOPCON CORPORATION",
        "44:5E:F3": "Tonalite Holding B.V.",
        "68:DB:96": "OPWILL Technologies CO .,LTD",
        "7C:55:E7": "YSI, Inc.",
        "70:B0:8C": "Shenou Communication Equipment Co.,Ltd",
        "C0:3B:8F": "Minicom Digital Signage",
        "20:FE:DB": "M2M Solution S.A.S.",
        "0C:8D:98": "TOP EIGHT IND CORP",
        "40:C7:C9": "Naviit Inc.",
        "7C:BB:6F": "Cosco Electronics Co., Ltd.",
        "94:A7:BC": "BodyMedia, Inc.",
        "C8:A1:B6": "Shenzhen Longway Technologies Co., Ltd",
        "64:A2:32": "OOO Samlight",
        "64:FC:8C": "Zonar Systems",
        "D0:57:4C": "Cisco Systems, Inc",
        "F8:DA:E2": "NDC Technologies",
        "70:5E:AA": "Action Target, Inc.",
        "34:F9:68": "ATEK Products, LLC",
        "20:B0:F7": "Enclustra GmbH",
        "54:31:31": "Raster Vision Ltd",
        "D0:E3:47": "Yoga",
        "F0:ED:1E": "Bilkon Bilgisayar Kontrollu Cih. Im.Ltd.",
        "C4:16:FA": "Prysm Inc",
        "50:6F:9A": "Wi-Fi Alliance",
        "84:29:14": "EMPORIA TELECOM Produktions- und VertriebsgesmbH & Co KG",
        "BC:7D:D1": "Radio Data Comms",
        "58:50:76": "Linear Equipamentos Eletronicos SA",
        "F0:F9:F7": "IES GmbH & Co. KG",
        "38:58:0C": "Panaccess Systems GmbH",
        "44:51:DB": "Raytheon BBN Technologies",
        "DC:FA:D5": "STRONG Ges.m.b.H.",
        "6C:8D:65": "Wireless Glue Networks, Inc.",
        "98:03:A0": "ABB n.v. Power Quality Products",
        "CC:43:E3": "Trump s.a.",
        "F8:C0:91": "Highgates Technology",
        "AC:9B:84": "Smak Tecnologia e Automacao",
        "90:F2:78": "Radius Gateway",
        "80:66:29": "Prescope Technologies CO.,LTD.",
        "24:1F:2C": "Calsys, Inc.",
        "F0:BD:F1": "Sipod Inc.",
        "64:67:07": "Beijing Omnific Technology, Ltd.",
        "AC:A0:16": "Cisco Systems, Inc",
        "58:E7:47": "Deltanet AG",
        "40:40:22": "ZIV",
        "A8:5B:B0": "Shenzhen Dehoo Technology Co.,Ltd",
        "44:A6:89": "PROMAX ELECTRONICA SA",
        "40:61:8E": "Stella-Green Co",
        "68:E4:1F": "Unglaube Identech GmbH",
        "4C:60:D5": "airPointe of New Hampshire",
        "88:87:17": "CANON INC.",
        "6C:DC:6A": "Promethean Limited",
        "90:55:AE": "Ericsson, EAB/RWI/K",
        "10:10:B6": "McCain Inc",
        "00:93:63": "Uni-Link Technology Co., Ltd.",
        "D4:82:3E": "Argosy Technologies, Ltd.",
        "00:35:32": "Electro-Metrics Corporation",
        "08:1F:F3": "Cisco Systems, Inc",
        "44:37:6F": "Young Electric Sign Co",
        "38:9F:83": "OTN Systems N.V.",
        "BC:6A:16": "tdvine",
        "00:3A:9D": "NEC Platforms, Ltd.",
        "28:CD:4C": "Individual Computers GmbH",
        "8C:53:F7": "A&D ENGINEERING CO., LTD.",
        "7C:76:73": "ENMAS GmbH",
        "6C:6F:18": "Stereotaxis, Inc.",
        "84:C7:27": "Gnodal Ltd",
        "08:76:95": "Auto Industrial Co., Ltd.",
        "AC:CE:8F": "HWA YAO TECHNOLOGIES CO., LTD",
        "8C:92:36": "Aus.Linx Technology Co., Ltd.",
        "10:C7:3F": "Midas Klark Teknik Ltd",
        "F8:91:2A": "GLP German Light Products GmbH",
        "44:E4:9A": "OMNITRONICS PTY LTD",
        "08:F2:F4": "Net One Partners Co.,Ltd.",
        "0C:7D:7C": "Kexiang Information Technology Co, Ltd.",
        "30:37:A6": "Cisco Systems, Inc",
        "DC:1D:9F": "U & B tech",
        "78:5C:72": "Hioso Technology Co., Ltd.",
        "58:05:56": "Elettronica GF S.r.L.",
        "B0:90:74": "Fulan Electronics Limited",
        "94:F6:92": "Geminico co.,Ltd.",
        "68:EF:BD": "Cisco Systems, Inc",
        "F0:24:08": "Talaris (Sweden) AB",
        "80:81:A5": "TONGQING COMMUNICATION EQUIPMENT (SHENZHEN) Co.,Ltd",
        "B4:82:FE": "ASKEY COMPUTER CORP",
        "30:7C:30": "RIM",
        "BC:4E:3C": "CORE STAFF CO., LTD.",
        "50:2A:8B": "Telekom Research and Development Sdn Bhd",
        "EC:43:E6": "AWCER Ltd.",
        "78:12:B8": "ORANTEK LIMITED",
        "98:BC:99": "Edeltech Co.,Ltd.",
        "F0:2F:D8": "Bi2-Vision",
        "54:42:49": "Sony Corporation",
        "90:47:16": "RORZE CORPORATION",
        "10:44:5A": "Shaanxi Hitech Electronic Co., LTD",
        "F4:76:26": "Viltechmeda UAB ",
        "0C:17:F1": "TELECSYS",
        "00:3A:9B": "Cisco Systems, Inc",
        "2C:34:27": "ERCO & GENER",
        "80:91:2A": "Lih Rong electronic Enterprise Co., Ltd.",
        "7C:2F:80": "Gigaset Communications GmbH",
        "10:B7:F6": "Plastoform Industries Ltd.",
        "44:8E:81": "VIG",
        "88:94:F9": "Gemicom Technology, Inc.",
        "50:2A:7E": "Smart electronic GmbH",
        "5C:87:78": "Cybertelbridge co.,ltd",
        "38:BB:23": "OzVision America LLC",
        "0C:84:11": "A.O. Smith Water Products",
        "E0:AB:FE": "Orb Networks, Inc.",
        "44:83:12": "Star-Net",
        "A0:5D:E7": "DIRECTV, Inc.",
        "08:76:18": "ViE Technologies Sdn. Bhd.",
        "D0:E4:0B": "Wearable Inc.",
        "74:7E:1A": "Red Embedded Design Limited",
        "14:A8:6B": "ShenZhen Telacom Science&Technology Co., Ltd",
        "0C:C3:A7": "Meritec",
        "DC:E2:AC": "Lumens Digital Optics Inc.",
        "98:D8:8C": "Nortel Networks",
        "78:19:2E": "NASCENT Technology",
        "48:EB:30": "ETERNA TECHNOLOGY, INC.",
        "4C:32:2D": "TELEDATA NETWORKS",
        "AC:86:7E": "Create New Technology (HK) Limited Company",
        "8C:59:8B": "C Technologies AB",
        "D4:4C:A7": "Informtekhnika & Communication, LLC",
        "A8:C2:22": "TM-Research Inc.",
        "00:3D:41": "Hatteland Computer AS",
        "CC:50:76": "Ocom Communications, Inc.",
        "4C:C4:52": "Shang Hai Tyd. Electon Technology Ltd.",
        "7C:CB:0D": "Antaira Technologies, LLC",
        "C0:1E:9B": "Pixavi AS",
        "80:3B:9A": "ghe-ces electronic ag",
        "74:32:56": "NT-ware Systemprg GmbH",
        "C4:E1:7C": "U2S co.",
        "20:BF:DB": "DVL",
        "20:41:5A": "Smarteh d.o.o.",
        "A4:DA:3F": "Bionics Corp.",
        "A0:40:25": "Actioncable, Inc.",
        "4C:4B:68": "Mobile Device, Inc. ",
        "20:12:57": "Most Lucky Trading Ltd",
        "E8:DA:AA": "VideoHome Technology Corp.",
        "64:7D:81": "YOKOTA INDUSTRIAL CO,.LTD",
        "7C:CF:CF": "Shanghai SEARI Intelligent System Co., Ltd",
        "68:AA:D2": "DATECS LTD.,",
        "A4:DE:50": "Total Walther GmbH",
        "1C:F0:61": "SCAPS GmbH",
        "A8:93:E6": "JIANGXI JINGGANGSHAN CKING COMMUNICATION TECHNOLOGY CO.,LTD",
        "C4:AA:A1": "SUMMIT DEVELOPMENT, spol.s r.o.",
        "30:32:D4": "Hanilstm Co., Ltd.",
        "E0:64:BB": "DigiView S.r.l.",
        "DC:33:50": "TechSAT GmbH",
        "F0:BC:C8": "MaxID (Pty) Ltd",
        "24:82:8A": "Prowave Technologies Ltd.",
        "68:CC:9C": "Mine Site Technologies",
        "14:6E:0A": "Private",
        "0C:E7:09": "Fox Crypto B.V.",
        "B4:B5:AF": "Minsung Electronics",
        "04:B3:B6": "Seamap (UK) Ltd",
        "00:27:0B": "Adura Technologies",
        "00:27:0D": "Cisco Systems, Inc",
        "00:27:1B": "Alec Sicherheitssysteme GmbH",
        "00:27:18": "Suzhou NEW SEAUNION Video Technology Co.,Ltd",
        "6C:0F:6A": "JDC Tech Co., Ltd.",
        "04:B4:66": "BSP Co., Ltd.",
        "D8:D6:7E": "GSK CNC EQUIPMENT CO.,LTD",
        "00:26:AE": "Wireless Measurement Ltd",
        "00:26:B1": "Navis Auto Motive Systems, Inc.",
        "00:26:AA": "Kenmec Mechanical Engineering Co., Ltd.",
        "00:26:D2": "Pcube Systems, Inc.",
        "00:26:CD": "PurpleComm, Inc.",
        "00:27:07": "Lift Complex DS, JSC",
        "00:26:D7": "KM Electornic Technology Co., Ltd.",
        "00:26:D0": "Semihalf",
        "00:26:FE": "MKD Technology Inc.",
        "00:26:A0": "moblic",
        "00:26:E5": "AEG Power Solutions",
        "00:26:E3": "DTI",
        "00:26:BC": "General Jack Technology Ltd.",
        "00:26:96": "NOOLIX Co., Ltd",
        "00:26:9A": "Carina System Co., Ltd.",
        "00:26:95": "ZT Group Int'l Inc",
        "00:26:93": "QVidium Technologies, Inc.",
        "00:26:65": "ProtectedLogic Corporation",
        "00:26:60": "Logiways",
        "00:26:70": "Cinch Connectors",
        "00:26:71": "AUTOVISION Co., Ltd",
        "00:26:48": "Emitech Corp.",
        "00:26:45": "Circontrol S.A.",
        "00:26:3E": "Trapeze Networks",
        "00:26:3C": "Bachmann Technology GmbH & Co. KG",
        "00:26:3D": "MIA Corporation",
        "00:26:78": "Logic Instrument SA",
        "00:26:77": "DEIF A/S",
        "00:26:8E": "Alta Solutions, Inc.",
        "00:26:88": "Juniper Networks",
        "00:25:DA": "Secura Key",
        "00:25:DB": "ATI Electronics(Shenzhen) Co., LTD",
        "00:25:D5": "Robonica (Pty) Ltd",
        "00:25:E2": "Everspring Industry Co., Ltd.",
        "00:25:E1": "SHANGHAI SEEYOO ELECTRONIC & TECHNOLOGY CO., LTD",
        "00:26:0E": "Ablaze Systems, LLC",
        "00:26:10": "Apacewave Technologies",
        "00:26:0D": "Mercury Systems, Inc.",
        "00:26:0A": "Cisco Systems, Inc",
        "00:26:32": "Instrumentation Technologies d.d.",
        "00:26:2E": "Chengdu Jiuzhou Electronic Technology Inc",
        "00:26:2C": "IKT Advanced Technologies s.r.o.",
        "00:26:29": "Juphoon System Software Inc.",
        "00:26:25": "MediaSputnik",
        "00:26:26": "Geophysical Survey Systems, Inc.",
        "00:25:CC": "Mobile Communications Korea Incorporated",
        "00:25:F9": "GMK electronic design GmbH",
        "00:25:F7": "Ansaldo STS USA",
        "00:26:1B": "LAUREL BANK MACHINES CO., LTD.",
        "00:26:14": "KTNF",
        "00:26:03": "Shenzhen Wistar Technology Co., Ltd",
        "00:25:A6": "Central Network Solution Co., Ltd.",
        "00:25:AA": "Beijing Soul Technology Co.,Ltd.",
        "00:25:88": "Genie Industries, Inc.",
        "00:25:80": "Equipson S.A.",
        "00:25:BD": "Italdata Ingegneria dell'Idea S.p.A.",
        "00:25:B7": "Costar  electronics, inc.,",
        "00:25:7D": "PointRed Telecom Private Ltd.",
        "00:25:A2": "Alta Definicion LINCEO S.L.",
        "00:25:6D": "Broadband Forum",
        "00:25:6C": "Azimut Production Association JSC",
        "00:25:63": "Luxtera Inc",
        "00:25:93": "DatNet Informatikai Kft.",
        "00:25:8E": "The Weather Channel",
        "00:25:A3": "Trimax Wireless, Inc.",
        "00:25:9C": "Cisco-Linksys, LLC",
        "00:25:C8": "S-Access GmbH",
        "00:25:C0": "ZillionTV Corporation",
        "00:25:1B": "Philips CareServant",
        "00:25:18": "Power PLUS Communications AG",
        "00:25:15": "SFR",
        "00:25:0D": "GZT Telkom-Telmor sp. z o.o.",
        "00:25:0E": "gt german telematics gmbh",
        "00:25:31": "Cloud Engines, Inc.",
        "00:25:2D": "Kiryung Electronics",
        "00:25:45": "Cisco Systems, Inc",
        "00:25:42": "Pittasoft",
        "00:25:36": "Oki Electric Industry Co., Ltd.",
        "00:25:41": "Maquet Critical Care AB",
        "00:25:2B": "Stirling Energy Systems",
        "00:25:24": "Lightcomm Technology Co., Ltd",
        "00:25:4E": "Vertex Wireless Co., Ltd.",
        "00:25:46": "Cisco Systems, Inc",
        "00:25:22": "ASRock Incorporation",
        "00:25:60": "Ibridge Networks & Communications Ltd.",
        "00:24:B8": "free alliance sdn bhd",
        "00:24:B3": "Graf-Syteco GmbH & Co. KG",
        "00:24:F6": "MIYOSHI ELECTRONICS CORPORATION",
        "00:24:F0": "Seanodes",
        "00:24:CB": "Autonet Mobile",
        "00:24:D1": "Thomson Inc.",
        "00:24:C9": "Broadband Solutions Group",
        "00:24:CA": "Tobii Technology AB",
        "00:25:08": "Maquet Cardiopulmonary AG",
        "00:24:FC": "QuoPin Co., Ltd.",
        "00:24:FB": "Private",
        "00:24:FA": "Hilger u. Kern GMBH",
        "00:24:D0": "Shenzhen SOGOOD Industry CO.,LTD.",
        "00:24:CC": "Fascinations Toys and Gifts, Inc.",
        "00:24:C7": "Mobilarm Ltd",
        "00:24:DF": "Digitalbox Europe GmbH",
        "00:24:45": "Adtran Inc",
        "00:24:3F": "Storwize, Inc.",
        "00:24:97": "Cisco Systems, Inc",
        "00:24:A3": "Sonim Technologies Inc",
        "00:24:AA": "Dycor Technologies Ltd.",
        "00:24:A9": "Ag Leader Technology",
        "00:24:A6": "TELESTAR DIGITAL GmbH",
        "00:24:9B": "Action Star Enterprise Co., Ltd.",
        "00:24:71": "Fusion MultiSystems dba Fusion-io",
        "00:24:74": "Autronica Fire And Securirty",
        "00:24:46": "MMB Research Inc.",
        "00:24:63": "Phybridge Inc",
        "00:24:72": "ReDriven Power Inc.",
        "00:24:1C": "FuGang Electronic (DG) Co.,Ltd",
        "00:24:19": "Private",
        "00:24:15": "Magnetic Autocontrol GmbH",
        "00:23:E7": "Hinke A/S",
        "00:23:E2": "SEA Signalisation",
        "00:24:25": "Shenzhenshi chuangzhicheng Technology Co.,Ltd",
        "00:24:27": "SSI COMPUTER CORP",
        "00:24:11": "PharmaSmart LLC",
        "00:24:0F": "Ishii Tool & Engineering Corporation",
        "00:23:FA": "RG Nets, Inc.",
        "00:23:F2": "TVLogic",
        "00:24:0A": "US Beverage Net",
        "00:24:07": "TELEM SAS",
        "00:24:40": "Halo Monitoring, Inc.",
        "00:23:CF": "CUMMINS-ALLISON CORP.",
        "00:23:C2": "SAMSUNG Electronics. Co. LTD",
        "00:23:C4": "Lux Lumen",
        "00:23:C5": "Radiation Safety and Control Services Inc",
        "00:23:C6": "SMC Corporation",
        "00:23:88": "V.T. Telematica S.p.a.",
        "00:23:83": "InMage Systems Inc",
        "00:23:81": "Lengda Technology(Xiamen) Co.,Ltd.",
        "00:23:BF": "Mainpine, Inc.",
        "00:23:B2": "Intelligent Mechatronic Systems Inc",
        "00:23:B5": "ORTANA LTD",
        "00:23:B9": "Airbus Defence and Space Deutschland GmbH",
        "00:23:BD": "Digital Ally, Inc.",
        "00:23:C9": "Sichuan Tianyi Information Science & Technology Stock CO.,LTD",
        "00:23:CE": "KITA DENSHI CORPORATION",
        "00:23:A9": "Beijing Detianquan Electromechanical Equipment Co., Ltd",
        "00:23:9B": "Elster Solutions, LLC",
        "00:23:7B": "WHDI LLC",
        "00:23:24": "G-PRO COMPUTER",
        "00:23:E0": "INO Therapeutics LLC",
        "00:23:90": "Algolware Corporation",
        "00:23:11": "Gloscom Co., Ltd.",
        "00:23:09": "Janam Technologies LLC",
        "00:23:04": "Cisco Systems, Inc",
        "00:23:5D": "Cisco Systems, Inc",
        "00:23:5C": "Aprius, Inc.",
        "00:23:52": "DATASENSOR S.p.A.",
        "00:23:2F": "Advanced Card Systems Ltd.",
        "00:23:53": "F E T Elettronica snc",
        "00:23:42": "Coffee Equipment Company",
        "00:23:37": "Global Star Solutions ULC",
        "00:23:19": "Sielox LLC",
        "00:23:6A": "SmartRG Inc",
        "00:23:31": "Nintendo Co., Ltd.",
        "00:23:35": "Linkflex Co.,Ltd",
        "00:23:25": "IOLAN Holding",
        "00:23:21": "Avitech International Corp",
        "00:23:70": "Snell",
        "00:22:B9": "Analogix Seminconductor, Inc",
        "00:22:B8": "Norcott",
        "00:22:B7": "GSS Grundig SAT-Systems GmbH",
        "00:22:B3": "Sei S.p.A.",
        "00:22:9C": "Verismo Networks Inc",
        "00:22:9A": "Lastar, Inc.",
        "00:22:EE": "Algo Communication Products Ltd",
        "00:22:EA": "Rustelcom Inc.",
        "00:22:F0": "3 Greens Aviation Limited",
        "00:22:EC": "IDEALBT TECHNOLOGY CORPORATION",
        "00:22:DD": "Protecta Electronics Ltd",
        "00:22:AB": "Shenzhen Turbosight Technology Ltd",
        "00:22:9B": "AverLogic Technologies, Inc.",
        "00:22:BE": "Cisco Systems, Inc",
        "00:22:BF": "SieAmp Group of Companies",
        "00:22:DB": "Translogic Corporation",
        "00:22:DA": "ANATEK, LLC",
        "00:22:F9": "Pollin Electronic GmbH",
        "00:22:C5": "INFORSON Co,Ltd.",
        "00:22:62": "BEP Marine",
        "00:22:6A": "Honeywell",
        "00:22:63": "Koos Technical Services, Inc.",
        "00:22:6C": "LinkSprite Technologies, Inc.",
        "00:22:5C": "Multimedia & Communication Technology",
        "00:22:84": "DESAY A&V SCIENCE AND TECHNOLOGY CO.,LTD",
        "00:22:86": "ASTRON",
        "00:22:82": "8086 Consultancy",
        "00:22:46": "Evoc Intelligent Technology Co.,Ltd.",
        "00:22:48": "Microsoft Corporation",
        "00:22:90": "Cisco Systems, Inc",
        "00:22:8A": "Teratronik elektronische systeme gmbh",
        "00:22:8E": "TV-NUMERIC",
        "00:22:54": "Bigelow Aerospace",
        "00:22:57": "3COM EUROPE LTD",
        "00:22:76": "Triple EYE B.V.",
        "00:22:74": "FamilyPhone AB",
        "00:22:36": "VECTOR SP. Z O.O.",
        "00:22:30": "FutureLogic Inc.",
        "00:22:2E": "maintech GmbH",
        "00:22:14": "RINNAI KOREA",
        "00:22:0B": "National Source Coding Center",
        "00:22:0C": "Cisco Systems, Inc",
        "00:21:EA": "Bystronic Laser AG",
        "00:21:FD": "LACROIX TRAFFIC S.A.U",
        "00:21:CD": "LiveTV",
        "00:21:D0": "Global Display Solutions Spa",
        "00:22:28": "Breeze Innovations Ltd.",
        "00:22:29": "Compumedics Ltd",
        "00:22:16": "SHIBAURA VENDING MACHINE CORPORATION",
        "00:21:E1": "Nortel Networks",
        "00:22:00": "IBM Corp",
        "00:21:C6": "CSJ Global, Inc.",
        "00:21:C3": "CORNELL Communications, Inc.",
        "00:21:C7": "Russound",
        "00:21:C1": "ABB Oy / Medium Voltage Products",
        "00:21:C0": "Mobile Appliance, Inc.",
        "00:21:BB": "Riken Keiki Co., Ltd.",
        "00:21:66": "NovAtel Inc.",
        "00:21:64": "Special Design Bureau for Seismic Instrumentation",
        "00:21:60": "Hidea Solutions Co. Ltd.",
        "00:21:B1": "DIGITAL SOLUTIONS LTD",
        "00:21:B0": "Tyco Telecommunications",
        "00:21:AD": "Nordic ID Oy",
        "00:21:7F": "Intraco Technology Pte Ltd",
        "00:21:7D": "PYXIS S.R.L.",
        "00:21:6F": "SymCom, Inc.",
        "00:21:A3": "Micromint",
        "00:21:A5": "ERLPhase Power Technologies Ltd.",
        "00:21:9D": "Adesys BV",
        "00:21:95": "GWD Media Limited",
        "00:21:88": "EMC Corporation",
        "00:21:1A": "LInTech Corporation",
        "00:21:16": "Transcon Electronic Systems, spol. s r. o.",
        "00:21:15": "PHYWE Systeme GmbH & Co. KG",
        "00:21:41": "RADLIVE",
        "00:21:40": "EN Technologies Inc.",
        "00:21:3D": "Cermetek Microelectronics, Inc.",
        "00:21:11": "Uniphone Inc.",
        "00:21:14": "Hylab Technology Inc.",
        "00:21:32": "Masterclock, Inc.",
        "00:21:31": "Blynke Inc.",
        "00:21:29": "Cisco-Linksys, LLC",
        "00:21:1D": "Dataline AB",
        "00:21:20": "Sequel Technologies",
        "00:21:52": "General Satellite Research & Development Limited",
        "00:21:58": "Style Flying Technology Co.",
        "00:21:48": "Kaco Solar Korea",
        "00:21:3C": "AliphCom",
        "00:1F:B5": "I/O Interconnect Inc.",
        "00:1F:E7": "Simet",
        "00:1F:DB": "Network Supply Corp.,",
        "00:1F:BF": "Fulhua Microelectronics Corp. Taiwan Branch",
        "00:1F:BE": "Shenzhen Mopnet Industrial Co.,Ltd",
        "00:1F:C2": "Jow Tong Technology Co Ltd",
        "00:1F:D2": "COMMTECH TECHNOLOGY MACAO COMMERCIAL OFFSHORE LTD.",
        "00:1F:B8": "Universal Remote Control, Inc.",
        "00:1F:D4": "4IPNET, INC.",
        "00:1F:CB": "NIW Solutions",
        "00:1F:F7": "Nakajima All Precision Co., Ltd.",
        "00:1F:EB": "Trio Datacom Pty Ltd",
        "00:1F:69": "Pingood Technology Co., Ltd.",
        "00:1F:4D": "Segnetics LLC",
        "00:1F:81": "Accel Semiconductor Corp",
        "00:1F:83": "Teleplan Technology Services Sdn Bhd",
        "00:1F:9B": "POSBRO",
        "00:1F:78": "Blue Fox Porini Textile",
        "00:1F:68": "Martinsson Elektronik AB",
        "00:1F:63": "JSC Goodwin-Europa",
        "00:1F:AD": "Brown Innovations, Inc",
        "00:1F:A6": "Stilo srl",
        "00:1F:97": "BERTANA srl",
        "00:1F:8C": "CCS Inc.",
        "00:1F:10": "TOLEDO DO BRASIL INDUSTRIA DE BALANCAS  LTDA",
        "00:1F:0F": "Select Engineered Systems",
        "00:1F:02": "Pixelmetrix Corporation Pte Ltd",
        "00:1E:FE": "LEVEL s.r.o.",
        "00:1F:1A": "Prominvest",
        "00:1F:18": "Hakusan.Mfg.Co,.Ltd",
        "00:1F:13": "S.& A.S. Ltd.",
        "00:1F:25": "MBS GmbH",
        "00:1F:27": "Cisco Systems, Inc",
        "00:1F:26": "Cisco Systems, Inc",
        "00:1E:EF": "Cantronic International Limited",
        "00:1E:DE": "BYD COMPANY LIMITED",
        "00:1E:DD": "WASKO S.A.",
        "00:1E:DB": "Giken Trastem Co., Ltd.",
        "00:1F:42": "Etherstack plc",
        "00:1F:35": "AIR802 LLC",
        "00:1F:34": "Lung Hwa Electronics Co., Ltd.",
        "00:1E:EB": "Talk-A-Phone Co.",
        "00:1E:6A": "Beijing Bluexon Technology Co.,Ltd",
        "00:1E:66": "RESOL Elektronische Regelungen GmbH",
        "00:1E:63": "Vibro-Meter SA",
        "00:1E:7F": "CBM of America",
        "00:1E:82": "SanDisk Corporation",
        "00:1E:B1": "Cryptsoft Pty Ltd",
        "00:1E:AF": "Ophir Optronics Ltd",
        "00:1E:AD": "Wingtech Group Limited",
        "00:1E:D1": "Keyprocessor B.V.",
        "00:1E:D0": "Ingespace",
        "00:1E:8E": "Hunkeler AG",
        "00:1E:87": "Realease Limited",
        "00:1E:CD": "KYLAND Technology Co. LTD",
        "00:1E:BF": "Haas Automation Inc.",
        "00:1E:BC": "WINTECH AUTOMATION CO.,LTD.",
        "00:1E:6F": "Magna-Power Electronics, Inc.",
        "00:1E:A1": "Brunata a/s",
        "00:1E:53": "Further Tech Co., LTD",
        "00:1E:4E": "DAKO EDV-Ingenieur- und Systemhaus GmbH",
        "00:1E:49": "Cisco Systems, Inc",
        "00:1E:28": "Lumexis Corporation",
        "00:1E:24": "Zhejiang Bell Technology Co.,ltd",
        "00:1E:20": "Intertain Inc.",
        "00:1E:1C": "SWS Australia Pty Limited",
        "00:1E:12": "Ecolab",
        "00:1E:16": "Keytronix",
        "00:1E:32": "Zensys",
        "00:1E:35": "Nintendo Co., Ltd.",
        "00:1E:2B": "Radio Systems Design, Inc.",
        "00:1E:42": "Teltonika",
        "00:1E:08": "Centec Networks Inc",
        "00:1D:FB": "NETCLEUS Systems Corporation",
        "00:1D:B9": "Wellspring Wireless",
        "00:1D:BB": "Dynamic System Electronics Corp.",
        "00:1D:B3": "HPN Supply Chain",
        "00:1D:B1": "Crescendo Networks",
        "00:1D:B4": "KUMHO ENG CO.,LTD",
        "00:1D:A4": "Hangzhou System Technology CO., LTD",
        "00:1D:9F": "MATT   R.P.Traczynscy Sp.J.",
        "00:1D:90": "EMCO Flow Systems",
        "00:1D:93": "Modacom",
        "00:1D:94": "Climax Technology Co., Ltd",
        "00:1D:8E": "Alereon, Inc.",
        "00:1D:DB": "C-BEL Corporation",
        "00:1D:E6": "Cisco Systems, Inc",
        "00:1D:E7": "Marine Sonic Technology, Ltd.",
        "00:1D:7B": "Ice Energy, Inc.",
        "00:1D:6C": "ClariPhy Communications, Inc.",
        "00:1D:C5": "Beijing Jiaxun Feihong Electricial Co., Ltd.",
        "00:1D:C6": "SNR Inc.",
        "00:1D:84": "Gateway, Inc.",
        "00:1D:85": "Call Direct Cellular Solutions",
        "00:1D:BF": "Radiient Technologies, Inc.",
        "00:1D:34": "SYRIS Technology Corp",
        "00:1D:32": "Longkay Communication & Technology (Shanghai) Co. Ltd",
        "00:1D:2A": "SHENZHEN BUL-TECH CO.,LTD.",
        "00:1D:2D": "Pylone, Inc.",
        "00:1D:5D": "Control Dynamics Pty. Ltd.",
        "00:1D:59": "Mitra Energy & Infrastructure",
        "00:1D:2B": "Wuhan Pont Technology CO. , LTD",
        "00:1D:22": "Foss Analytical A/S",
        "00:1D:23": "SENSUS ",
        "00:1D:3E": "SAKA TECHNO SCIENCE CO.,LTD",
        "00:1D:40": "Intel – GE Care Innovations LLC",
        "00:1D:57": "CAETEC Messtechnik",
        "00:1D:51": "Babcock & Wilcox Power Generation Group, Inc",
        "00:1D:4C": "Alcatel-Lucent",
        "00:1D:1A": "OvisLink S.A.",
        "00:1C:B7": "USC DigiArk Corporation",
        "00:1C:AF": "Plato Networks Inc.",
        "00:1C:B1": "Cisco Systems, Inc",
        "00:1C:FE": "Quartics Inc",
        "00:1D:0B": "Power Standards Lab",
        "00:1D:02": "Cybertech Telecom Development",
        "00:1C:E9": "Galaxy Technology Limited",
        "00:1C:EA": "Scientific-Atlanta, Inc",
        "00:1C:E7": "Rocon PLC Research Centre",
        "00:1C:DB": "CARPOINT CO.,LTD",
        "00:1C:D5": "ZeeVee, Inc.",
        "00:1C:BC": "CastGrabber, LLC",
        "00:1C:E4": "EleSy JSC",
        "00:1C:E2": "Attero Tech, LLC.",
        "00:1C:AA": "Bellon Pty Ltd",
        "00:1C:A0": "Production Resource Group, LLC",
        "00:1C:D3": "ZP Engineering SEL",
        "00:1C:CB": "Forth Corporation Public Company Limited",
        "00:1C:75": "Segnet Ltd.",
        "00:1C:74": "Syswan Technologies Inc.",
        "00:1C:68": "Anhui Sun Create Electronics Co., Ltd",
        "00:1C:66": "UCAMP CO.,LTD",
        "00:1C:98": "LUCKY TECHNOLOGY (HK) COMPANY LIMITED",
        "00:1C:81": "NextGen Venturi LTD",
        "00:1C:7A": "Perfectone Netware Company Ltd",
        "00:1C:53": "Synergy Lighting Controls",
        "00:1C:4D": "Aplix IP Holdings Corporation",
        "00:1C:92": "Tervela",
        "00:1C:8A": "Cirrascale Corporation",
        "00:1C:38": "Bio-Rad Laboratories, Inc.",
        "00:1C:30": "Mode Lighting (UK ) Ltd.",
        "00:1C:2E": "HPN Supply Chain",
        "00:1C:2A": "Envisacor Technologies Inc.",
        "00:1C:02": "Pano Logic",
        "00:1C:05": "Nonin Medical Inc.",
        "00:1C:06": "Siemens Numerical Control Ltd., Nanjing",
        "00:1B:EA": "Nintendo Co., Ltd.",
        "00:1B:E5": "802automation Limited",
        "00:1B:E4": "TOWNET SRL",
        "00:1C:04": "Airgain, Inc.",
        "00:1C:01": "ABB Oy Drives",
        "00:1B:FF": "Millennia Media inc.",
        "00:1B:F2": "KWORLD COMPUTER CO., LTD",
        "00:1B:F0": "Value Platforms Limited",
        "00:1C:1B": "Hyperstone GmbH",
        "00:1C:10": "Cisco-Linksys, LLC",
        "00:1B:D2": "ULTRA-X ASIA PACIFIC Inc.",
        "00:1B:8D": "Electronic Computer Systems, Inc.",
        "00:1B:86": "Bosch Access Systems GmbH",
        "00:1B:C2": "Integrated Control Technology Limitied",
        "00:1B:BB": "RFTech Co.,Ltd",
        "00:1B:AA": "XenICs nv",
        "00:1B:7C": "A & R Cambridge",
        "00:1B:5D": "Vololink Pty Ltd",
        "00:1B:5A": "Apollo Imaging Technologies, Inc.",
        "00:1B:56": "Tehuti Networks Ltd.",
        "00:1B:C6": "Strato Rechenzentrum AG",
        "00:1B:C4": "Ultratec, Inc.",
        "00:1B:A1": "Åmic AB",
        "00:1B:96": "General Sensing",
        "00:1A:EA": "Radio Terminal Systems Pty Ltd",
        "00:1A:DD": "PePWave Ltd",
        "00:1A:D6": "JIAGNSU AETNA ELECTRIC CO.,LTD",
        "00:1A:D4": "iPOX Technology Co., Ltd.",
        "00:1B:14": "Carex Lighting Equipment Factory",
        "00:1B:15": "Voxtel, Inc.",
        "00:1B:09": "Matrix Telecom Pvt. Ltd.",
        "00:1B:03": "Action Technology (SZ) Co., Ltd",
        "00:1A:FB": "Joby Inc.",
        "00:1A:FD": "EVOLIS",
        "00:1B:1E": "HART Communication Foundation",
        "00:1B:4C": "Signtech",
        "00:1A:D5": "KMC CHAIN INDUSTRIAL CO., LTD.",
        "00:1A:D0": "Albis Technologies AG",
        "00:1A:D3": "Vamp Ltd.",
        "00:1A:D8": "AlsterAero GmbH",
        "00:1A:DA": "Biz-2-Me Inc.",
        "00:1A:6F": "MI.TEL s.r.l.",
        "00:1A:71": "Diostech Co., Ltd.",
        "00:1A:69": "Wuhan Yangtze Optical Technology CO.,Ltd.",
        "00:1A:67": "Infinite QL Sdn Bhd",
        "00:1A:C3": "Scientific-Atlanta, Inc",
        "00:1A:BF": "TRUMPF Laser Marking Systems AG",
        "00:1A:B8": "Anseri Corporation",
        "00:1A:BC": "U4EA Technologies Ltd",
        "00:1A:CB": "Autocom Products Ltd",
        "00:1A:CF": "C.T. ELETTRONICA",
        "00:1A:A3": "DELORME",
        "00:1A:9B": "ADEC & Parter AG",
        "00:1A:9D": "Skipper Wireless, Inc.",
        "00:1A:85": "NV Michel Van de Wiele",
        "00:1A:8E": "3Way Networks Ltd",
        "00:1A:44": "JWTrading Co., Ltd",
        "00:1A:49": "Micro Vision Co.,LTD",
        "00:1A:3D": "Ajin Vision Co.,Ltd",
        "00:1A:41": "INOCOVA Co.,Ltd",
        "00:1A:33": "ASI Communications, Inc.",
        "00:1A:23": "Ice Qube, Inc",
        "00:1A:1D": "PChome Online Inc.",
        "00:1A:17": "Teak Technologies, Inc.",
        "00:1A:1C": "GT&T Engineering Pte Ltd",
        "00:1A:1F": "Coastal Environmental Systems",
        "00:1A:64": "IBM Corp",
        "00:1A:51": "Alfred Mann Foundation",
        "00:1A:55": "ACA-Digital Corporation",
        "00:19:E6": "TOYO MEDIC CO.,LTD.",
        "00:19:E2": "Juniper Networks",
        "00:19:E8": "Cisco Systems, Inc",
        "00:19:DF": "Thomson Inc.",
        "00:19:DD": "FEI-Zyfer, Inc.",
        "00:19:B2": "XYnetsoft Co.,Ltd",
        "00:19:A4": "Austar Technology (hang zhou) Co.,Ltd",
        "00:19:AA": "Cisco Systems, Inc",
        "00:19:B1": "Arrow7 Corporation",
        "00:19:B3": "Stanford Research Systems",
        "00:1A:0A": "Adaptive Micro-Ware Inc.",
        "00:1A:05": "OPTIBASE LTD",
        "00:19:D4": "ICX Technologies",
        "00:19:CF": "SALICRU, S.A.",
        "00:19:FC": "PT. Ufoakses Sukses Luarbiasa",
        "00:19:F4": "Convergens Oy Ltd",
        "00:19:96": "TurboChef Technologies Inc.",
        "00:19:97": "Soft Device Sdn Bhd",
        "00:19:98": "SATO CORPORATION",
        "00:19:9C": "CTRING",
        "00:19:46": "Cianet Industria e Comercio S/A",
        "00:19:49": "TENTEL  COMTECH CO., LTD.",
        "00:19:44": "Fossil Partners, L.P.",
        "00:19:71": "Guangzhou Unicomp Technology Co.,Ltd",
        "00:19:64": "Doorking Inc.",
        "00:19:76": "Xipher Technologies, LLC",
        "00:19:6C": "ETROVISION TECHNOLOGY",
        "00:19:67": "TELDAT Sp.J.",
        "00:19:52": "ACOGITO Co., Ltd",
        "00:19:8B": "Novera Optics Korea, Inc.",
        "00:19:61": "Blaupunkt  Embedded Systems GmbH",
        "00:19:42": "ON SOFTWARE INTERNATIONAL LIMITED",
        "00:19:3F": "RDI technology(Shenzhen) Co.,LTD",
        "00:19:41": "Pitney Bowes, Inc",
        "00:18:FD": "Optimal Technologies International Inc.",
        "00:18:F0": "JOYTOTO Co., Ltd.",
        "00:18:E9": "Numata Corporation",
        "00:19:08": "Duaxes Corporation",
        "00:19:0C": "Encore Electronics, Inc.",
        "00:19:19": "ASTEL Inc.",
        "00:19:2D": "Nokia Corporation",
        "00:18:EF": "Escape Communications, Inc.",
        "00:18:E6": "Computer Hardware Design SIA",
        "00:19:30": "Cisco Systems, Inc",
        "00:19:27": "ImCoSys Ltd",
        "00:18:F7": "Kameleon Technologies",
        "00:18:88": "GOTIVE a.s.",
        "00:18:8A": "Infinova LLC",
        "00:18:86": "EL-TECH, INC.",
        "00:18:87": "Metasystem SpA",
        "00:18:BE": "ANSA Corporation",
        "00:18:BA": "Cisco Systems, Inc",
        "00:18:B4": "Dawon Media Inc.",
        "00:18:B6": "S3C, Inc.",
        "00:18:A3": "ZIPPY TECHNOLOGY CORP.",
        "00:18:A0": "Cierma Ascenseurs",
        "00:18:93": "SHENZHEN PHOTON BROADBAND TECHNOLOGY CO.,LTD",
        "00:18:B1": "IBM Corp",
        "00:18:7B": "4NSYS Co. Ltd.",
        "00:18:7F": "ZODIANET",
        "00:18:7E": "RGB Spectrum",
        "00:18:9D": "Navcast Inc.",
        "00:18:D6": "Swirlnet A/S",
        "00:18:CD": "Erae Electronics Industry Co., Ltd",
        "00:18:DB": "EPL Technology Ltd",
        "00:18:C8": "ISONAS Inc.",
        "00:18:49": "nVent, Schroff GmbH",
        "00:18:46": "Crypto S.A.",
        "00:18:45": "Pulsar-Telecom LLC.",
        "00:18:1E": "GDX Technologies Ltd.",
        "00:18:1C": "Exterity Limited",
        "00:18:63": "Veritech Electronics Limited",
        "00:18:5A": "uControl, Inc.",
        "00:18:52": "StorLink Semiconductors, Inc.",
        "00:18:50": "Secfone Kft",
        "00:18:58": "TagMaster AB",
        "00:18:24": "Kimaldi Electronics, S.L.",
        "00:18:3D": "Vertex Link Corporation",
        "00:18:25": "Private",
        "00:18:79": "dSys",
        "00:18:03": "ArcSoft Shanghai Co. LTD",
        "00:17:EF": "IBM Corp",
        "00:17:F5": "LIG NEOPTEK",
        "00:17:CD": "CEC Wireless R&D Ltd.",
        "00:17:D0": "Opticom Communications, LLC",
        "00:17:C6": "Cross Match Technologies Inc",
        "00:17:FE": "TALOS SYSTEM INC.",
        "00:17:F8": "Motech Industries Inc.",
        "00:17:C3": "KTF Technologies Inc.",
        "00:17:B7": "Tonze Technology Co.",
        "00:17:AB": "Nintendo Co., Ltd.",
        "00:18:07": "Fanstel Corp.",
        "00:18:08": "SightLogix, Inc.",
        "00:17:CE": "Screen Service Spa",
        "00:17:DB": "CANKO TECHNOLOGIES INC.",
        "00:17:D6": "Bluechips Microhouse Co.,Ltd.",
        "00:17:87": "Brother, Brother & Sons ApS",
        "00:17:89": "Zenitron Corporation",
        "00:17:60": "Naito Densei Machida MFG.CO.,LTD",
        "00:17:61": "Private",
        "00:17:68": "Zinwave Ltd",
        "00:17:69": "Cymphonix Corp",
        "00:17:62": "Solar Technology, Inc.",
        "00:17:8F": "NINGBO YIDONG ELECTRONIC CO.,LTD.",
        "00:17:94": "Cisco Systems, Inc",
        "00:17:8A": "DARTS TECHNOLOGIES CORP.",
        "00:17:34": "ADC Telecommunications",
        "00:17:2E": "FXC Inc.",
        "00:17:2B": "Global Technologies Inc.",
        "00:17:72": "ASTRO Strobel Kommunikationssysteme GmbH",
        "00:17:3E": "LeucotronEquipamentos Ltda.",
        "00:17:98": "Azonic Technology Co., LTD",
        "00:17:47": "Trimble",
        "00:17:7A": "ASSA ABLOY AB",
        "00:16:F4": "Eidicom Co., Ltd.",
        "00:16:E7": "Dynamix Promotions Limited",
        "00:16:E5": "FORDLEY DEVELOPMENT LIMITED",
        "00:16:E6": "GIGA-BYTE TECHNOLOGY CO.,LTD.",
        "00:17:20": "Image Sensing Systems, Inc.",
        "00:17:1A": "Winegard Company",
        "00:16:C8": "Cisco Systems, Inc",
        "00:16:C4": "SiRF Technology, Inc.",
        "00:16:F3": "CAST Information Co., Ltd",
        "00:16:F5": "Dalian Golden Hualu Digital Technology Co.,Ltd",
        "00:16:F1": "OmniSense, LLC",
        "00:16:DD": "Gigabeam Corporation",
        "00:17:1C": "NT MicroSystems, Inc.",
        "00:17:16": "Qno Technology Inc.",
        "00:17:26": "m2c Electronic Technology Ltd.",
        "00:17:21": "FITRE S.p.A.",
        "00:16:F9": "CETRTA POT, d.o.o., Kranj",
        "00:17:0A": "INEW DIGITAL COMPANY",
        "00:16:BD": "ATI Industrial Automation",
        "00:16:C0": "Semtech Corporation",
        "00:16:C2": "Avtec Systems Inc",
        "00:16:BA": "WEATHERNEWS INC.",
        "00:16:B2": "DriveCam Inc",
        "00:16:B3": "Photonicbridges (China) Co., Ltd.",
        "00:16:AD": "BT-Links Company Limited",
        "00:16:6E": "Arbitron Inc.",
        "00:16:AF": "Shenzhen Union Networks Equipment Co.,Ltd.",
        "00:16:9E": "TV One Ltd",
        "00:16:6A": "TPS",
        "00:16:63": "KBT Mobile",
        "00:16:9F": "Vimtron Electronics Co., Ltd.",
        "00:16:9A": "Quadrics Ltd",
        "00:16:92": "Scientific-Atlanta, Inc.",
        "00:16:91": "Moser-Baer AG",
        "00:16:88": "ServerEngines LLC",
        "00:16:8B": "Paralan Corporation",
        "00:16:0A": "SWEEX Europe BV",
        "00:16:02": "CEYON TECHNOLOGY CO.,LTD.",
        "00:16:00": "CelleBrite Mobile Synchronization",
        "00:15:F4": "Eventide",
        "00:16:29": "Nivus GmbH",
        "00:16:21": "Colorado Vnet",
        "00:16:1A": "Dametric AB",
        "00:16:15": "Nittan Company, Limited",
        "00:16:17": "MSI",
        "00:16:2E": "Space Shuttle Hi-Tech Co., Ltd.",
        "00:16:2A": "Antik computers & communications s.r.o.",
        "00:16:56": "Nintendo Co., Ltd.",
        "00:16:51": "Exeo Systems",
        "00:16:10": "Carina Technology",
        "00:16:06": "Ideal Industries",
        "00:16:07": "Curves International Inc.",
        "00:16:54": "Flex-P Industries Sdn. Bhd.",
        "00:16:31": "Xteam",
        "00:16:4B": "Quorion Data Systems GmbH",
        "00:15:94": "BIXOLON CO.,LTD",
        "00:15:90": "Hectronic GmbH",
        "00:15:8C": "Liab ApS",
        "00:15:8F": "NTT Advanced Technology Corporation",
        "00:15:ED": "Fulcrum Microsystems, Inc.",
        "00:15:F0": "EGO BV",
        "00:15:EE": "Omnex Control Systems",
        "00:15:C8": "FlexiPanel Ltd",
        "00:15:C0": "DIGITAL TELEMEDIA CO.,LTD.",
        "00:15:C2": "3M Germany",
        "00:15:88": "Salutica Allied Solutions Sdn Bhd",
        "00:15:83": "IVT corporation",
        "00:15:85": "Aonvision Technolopy Corp.",
        "00:15:A5": "DCI Co., Ltd.",
        "00:15:B2": "Advanced Industrial Computer, Inc.",
        "00:15:DA": "IRITEL A.D.",
        "00:15:4A": "WANSHIH ELECTRONIC CO., LTD",
        "00:15:4C": "Saunders Electronics",
        "00:15:4D": "Netronome Systems, Inc.",
        "00:15:49": "Dixtal Biomedica Ind. Com. Ltda",
        "00:15:3D": "ELIM PRODUCT CO.",
        "00:15:44": "coM.s.a.t. AG",
        "00:15:39": "Technodrive srl",
        "00:15:31": "KOCOM",
        "00:15:35": "OTE Spa",
        "00:15:36": "Powertech co.,Ltd",
        "00:15:2B": "Cisco Systems, Inc",
        "00:15:2C": "Cisco Systems, Inc",
        "00:15:28": "Beacon Medical Products LLC d.b.a. BeaconMedaes",
        "00:15:27": "Balboa Instruments",
        "00:15:21": "Horoquartz",
        "00:15:20": "Radiocrafts AS",
        "00:15:66": "A-First Technology Co., Ltd.",
        "00:15:6B": "Perfisans Networks Corp.",
        "00:15:47": "AiZen Solutions Inc.",
        "00:15:79": "Lunatone Industrielle Elektronik GmbH",
        "00:14:D7": "Datastore Technology Corp",
        "00:14:DD": "Covergence Inc.",
        "00:14:D4": "K Technology Corporation",
        "00:14:CF": "INVISIO Communications",
        "00:14:BE": "Wink communication technology CO.LTD",
        "00:15:11": "Data Center Systems",
        "00:15:0E": "OPENBRAIN TECHNOLOGIES CO., LTD.",
        "00:15:0D": "Hoana Medical, Inc.",
        "00:15:1C": "LENECO",
        "00:15:19": "StoreAge Networking Technologies",
        "00:15:06": "Neo Photonics",
        "00:15:04": "GAME PLUS CO., LTD.",
        "00:15:05": "Actiontec Electronics, Inc",
        "00:14:FE": "Artech Electronics",
        "00:14:DE": "Sage Instruments Inc.",
        "00:14:DF": "HI-P Tech Corporation",
        "00:14:E6": "AIM Infrarotmodule GmbH",
        "00:14:F3": "ViXS Systems Inc",
        "00:14:7E": "InnerWireless",
        "00:14:7D": "Aeon Digital International",
        "00:14:76": "MultiCom Industries Limited",
        "00:14:73": "Bookham Inc",
        "00:14:89": "B15402100 - JANDEI, S.L.",
        "00:14:80": "Hitachi-LG Data Storage Korea, Inc",
        "00:14:B6": "Enswer Technology Inc.",
        "00:14:B2": "mCubelogics Corporation",
        "00:14:AE": "Wizlogics Co., Ltd.",
        "00:14:A6": "Teranetics, Inc.",
        "00:14:69": "Cisco Systems, Inc",
        "00:14:BA": "Carvers SA de CV",
        "00:14:8A": "Elin Ebg Traction Gmbh",
        "00:14:6E": "H. Stoll GmbH & Co. KG",
        "00:14:AA": "Ashly Audio, Inc.",
        "00:14:09": "MAGNETI MARELLI   S.E. S.p.A.",
        "00:14:0B": "FIRST INTERNATIONAL COMPUTER, INC.",
        "00:13:FD": "Nokia Danmark A/S",
        "00:14:00": "MINERVA KOREA CO., LTD",
        "00:13:FC": "SiCortex, Inc",
        "00:13:F6": "Cintech",
        "00:14:4F": "Oracle Corporation ",
        "00:14:56": "Edge Products",
        "00:14:50": "Heim Systems GmbH",
        "00:14:52": "CALCULEX,INC.",
        "00:14:42": "ATTO CORPORATION",
        "00:14:47": "BOAZ Inc.",
        "00:14:3E": "AirLink Communications, Inc.",
        "00:14:5D": "WJ Communications, Inc.",
        "00:14:3B": "Sensovation AG",
        "00:14:2D": "Toradex AG",
        "00:14:29": "V Center Technologies Co., Ltd.",
        "00:14:14": "Jumpnode Systems LLC.",
        "00:14:1E": "P.A. Semi, Inc.",
        "00:13:CB": "Zenitel Norway AS",
        "00:13:CF": "4Access Communications",
        "00:13:BE": "Virtual Conexions",
        "00:13:B9": "BM SPA",
        "00:13:AB": "Telemotive AG",
        "00:13:C9": "Beyond Achieve Enterprises Ltd.",
        "00:13:C6": "OpenGear, Inc",
        "00:13:F3": "Giga-byte Communications Inc.",
        "00:13:F4": "Psitek (Pty) Ltd",
        "00:13:AC": "Sunmyung Electronics Co., LTD",
        "00:13:A8": "Tanisys Technology",
        "00:13:DA": "Diskware Co., Ltd",
        "00:13:D8": "Princeton Instruments",
        "00:13:99": "STAC Corporation.",
        "00:13:E9": "VeriWave, Inc.",
        "00:13:56": "FLIR Radiation Inc",
        "00:13:5A": "Project T&E Limited",
        "00:13:61": "Biospace Co., Ltd.",
        "00:13:62": "ShinHeung Precision Co., Ltd.",
        "00:13:4F": "Rapidus Wireless Networks Inc.",
        "00:13:78": "Qsan Technology, Inc.",
        "00:13:7A": "Netvox Technology Co., Ltd.",
        "00:13:81": "CHIPS & Systems, Inc.",
        "00:13:79": "PONDER INFORMATION INDUSTRIES LTD.",
        "00:13:2C": "MAZ Brandenburg GmbH",
        "00:13:24": "Schneider Electric Ultra Terminal",
        "00:13:26": "ECM Systems Ltd",
        "00:13:27": "Data Acquisitions limited",
        "00:13:67": "Narayon. Co., Ltd.",
        "00:13:5C": "OnSite Systems, Inc.",
        "00:13:5F": "Cisco Systems, Inc",
        "00:13:3B": "Speed Dragon Multimedia Limited",
        "00:13:38": "FRESENIUS-VIAL",
        "00:13:2D": "iWise Communications",
        "00:13:74": "Atheros Communications, Inc.",
        "00:13:69": "Honda Electron Co., LED.",
        "00:13:42": "Vision Research, Inc.",
        "00:13:40": "AD.EL s.r.l.",
        "00:13:0C": "HF System Corporation",
        "00:13:0F": "EGEMEN Bilgisayar Muh San ve Tic LTD STI",
        "00:13:13": "GuangZhou Post & Telecom Equipment ltd",
        "00:12:CB": "CSS Inc.",
        "00:12:CE": "Advanced Cybernetics Group",
        "00:12:CA": "Mechatronic Brick Aps",
        "00:12:C7": "SECURAY Technologies Ltd.Co.",
        "00:12:CD": "ASEM SpA",
        "00:12:E8": "Fraunhofer IMS",
        "00:12:DD": "Shengqu Information Technology (Shanghai) Co., Ltd.",
        "00:13:1D": "Scanvaegt International A/S",
        "00:13:18": "DGSTATION Co., Ltd.",
        "00:13:1A": "Cisco Systems, Inc",
        "00:12:F4": "Belco International Co.,Ltd.",
        "00:12:F5": "Imarda New Zealand Limited",
        "00:12:DE": "Radio Components Sweden AB",
        "00:13:01": "IronGate S.L.",
        "00:12:F6": "MDK CO.,LTD.",
        "00:12:F1": "IFOTEC",
        "00:12:F8": "WNI Resources, LLC",
        "00:12:7C": "SWEGON AB",
        "00:12:78": "International Bar Code",
        "00:12:7A": "Sanyu Industry Co.,Ltd.",
        "00:12:68": "IPS d.o.o.",
        "00:12:AC": "ONTIMETEK INC.",
        "00:12:BC": "Echolab LLC",
        "00:12:BD": "Avantec Manufacturing Limited",
        "00:12:AB": "WiLife, Inc.",
        "00:12:9B": "E2S Electronic Engineering Solutions, S.L.",
        "00:12:98": "MICO ELECTRIC(SHENZHEN) LIMITED",
        "00:12:72": "Redux Communications Ltd.",
        "00:12:6A": "OPTOELECTRONICS Co., Ltd.",
        "00:12:C0": "HotLava Systems, Inc.",
        "00:12:B7": "PTW Freiburg",
        "00:12:A1": "BluePacket Communications Co., Ltd.",
        "00:12:06": "iQuest (NZ) Ltd",
        "00:12:07": "Head Strong International Limited",
        "00:12:09": "Fastrax Ltd",
        "00:12:0B": "Chinasys Technologies Limited",
        "00:12:05": "Terrasat Communications, Inc.",
        "00:12:38": "SetaBox Technology Co., Ltd.",
        "00:12:3C": "Second Rule LLC",
        "00:12:3E": "ERUNE technology Co., Ltd.",
        "00:12:54": "Spectra Technologies Holdings Company Ltd",
        "00:12:4F": "nVent",
        "00:12:21": "B.Braun Melsungen AG",
        "00:12:12": "PLUS  Corporation",
        "00:12:13": "Metrohm AG",
        "00:12:18": "ARUZE Corporation",
        "00:12:49": "Delta Elettronica S.p.A.",
        "00:12:4D": "Inducon BV",
        "00:12:66": "Swisscom Hospitality Services SA",
        "00:12:5E": "CAEN",
        "00:12:5D": "CyberNet Inc.",
        "00:12:23": "Pixim",
        "00:12:3A": "Posystech Inc., Co.",
        "00:12:34": "Camille Bauer",
        "00:11:E3": "Thomson, Inc.",
        "00:11:DC": "Glunz & Jensen",
        "00:11:96": "Actuality Systems, Inc.",
        "00:11:87": "Category Solutions, Inc",
        "00:11:90": "Digital Design Corporation",
        "00:11:C4": "Terminales de Telecomunicacion Terrestre, S.L.",
        "00:11:CB": "Jacobsons AB",
        "00:11:F7": "Shenzhen Forward Industry Co., Ltd",
        "00:11:D3": "NextGenTel Holding ASA",
        "00:11:AB": "TRUSTABLE TECHNOLOGY CO.,LTD.",
        "00:11:A5": "Fortuna Electronic Corp.",
        "00:11:3C": "Micronas GmbH",
        "00:11:31": "UNATECH. CO.,LTD",
        "00:11:27": "TASI, Inc",
        "00:11:2A": "Niko NV",
        "00:11:2B": "NetModule AG",
        "00:11:6F": "Netforyou Co., LTD.",
        "00:11:71": "DEXTER Communications, Inc.",
        "00:11:67": "Integrated System Solution Corp.",
        "00:11:6D": "American Time and Signal",
        "00:11:60": "ARTDIO Company Co., LTD",
        "00:11:54": "Webpro Technologies Inc.",
        "00:11:45": "ValuePoint Networks",
        "00:11:51": "Mykotronx",
        "00:11:4E": "690885 Ontario Inc.",
        "00:11:2D": "iPulse Systems",
        "00:11:7B": "Büchi  Labortechnik AG",
        "00:0F:EE": "XTec, Incorporated",
        "00:0F:E4": "Pantech Co.,Ltd",
        "00:0F:E7": "Lutron Electronics Co., Inc.",
        "00:0F:E6": "MBTech Systems, Inc.",
        "00:0F:DA": "YAZAKI CORPORATION",
        "00:0F:EF": "Thales e-Transactions GmbH",
        "00:0F:E9": "GW TECHNOLOGIES CO.,LTD.",
        "00:0F:E1": "ID DIGITAL CORPORATION",
        "00:0F:DF": "SOLOMON Technology Corp.",
        "00:0F:FE": "G-PRO COMPUTER",
        "00:11:0B": "Franklin Technology Systems",
        "00:11:05": "Sunplus Technology Co., Ltd.",
        "00:11:02": "Aurora Multimedia Corp.",
        "00:11:23": "Appointech, Inc.",
        "00:11:0F": "netplat,Inc.",
        "00:0F:D6": "Sarotech Co., Ltd",
        "00:11:15": "EPIN Technologies, Inc.",
        "00:0F:C7": "Dionica R&D Ltd.",
        "00:0F:64": "D&R Electronica Weesp BV",
        "00:0F:75": "First Silicon Solutions",
        "00:0F:7C": "ACTi Corporation",
        "00:0F:7A": "BeiJing NuQX Technology CO.,LTD",
        "00:0F:AD": "FMN communications GmbH",
        "00:0F:AB": "Kyushu Electronics Systems Inc.",
        "00:0F:AC": "IEEE 802.11",
        "00:0F:72": "Sandburst",
        "00:0F:B3": "Actiontec Electronics, Inc",
        "00:0F:9C": "Panduit Corp",
        "00:0F:C8": "Chantry Networks",
        "00:0F:BB": "Nokia Siemens Networks GmbH & Co. KG.",
        "00:0F:BC": "Onkey Technologies, Inc.",
        "00:0F:B6": "Europlex Technologies",
        "00:0F:B9": "Adaptive Instruments",
        "00:0F:98": "Avamax Co. Ltd.",
        "00:0F:97": "Avanex Corporation",
        "00:0F:96": "Telco Systems, Inc. ",
        "00:0F:8B": "Orion MultiSystems Inc",
        "00:0F:8C": "Gigawavetech Pte Ltd",
        "00:0F:38": "Netstar",
        "00:0F:3A": "HISHARP",
        "00:0F:30": "Raza Microelectronics Inc",
        "00:0F:53": "Solarflare Communications Inc.",
        "00:0F:51": "Azul Systems, Inc.",
        "00:0F:07": "Mangrove Systems, Inc.",
        "00:0F:00": "Legra Systems, Inc.",
        "00:0F:01": "DIGITALKS INC",
        "00:0F:03": "COM&C CO., LTD",
        "00:0F:34": "Cisco Systems, Inc",
        "00:0F:2E": "Megapower International Corp.",
        "00:0F:26": "WorldAccxx  LLC",
        "00:0F:45": "Stretch, Inc.",
        "00:0F:3B": "Fuji System Machines Co., Ltd.",
        "00:0F:37": "Xambala Incorporated",
        "00:0F:54": "Entrelogic Corporation",
        "00:0F:25": "AimValley B.V.",
        "00:0F:19": "Boston Scientific",
        "00:0F:10": "RDM Corporation",
        "00:0E:A8": "United Technologists Europe Limited",
        "00:0E:AA": "Scalent Systems, Inc.",
        "00:0E:AC": "MINTRON ENTERPRISE CO., LTD.",
        "00:0E:AE": "GAWELL TECHNOLOGIES CORP.",
        "00:0E:BA": "HANMI SEMICONDUCTOR CO., LTD.",
        "00:0E:BC": "Paragon Fidelity GmbH",
        "00:0E:C5": "Digital Multitools Inc",
        "00:0E:C7": "Motorola Korea",
        "00:0E:8B": "Astarte Technology Co, Ltd.",
        "00:0E:DF": "PLX Technology",
        "00:0E:E1": "ExtremeSpeed Inc.",
        "00:0E:D7": "Cisco Systems, Inc",
        "00:0E:D3": "Epicenter, Inc.",
        "00:0E:9D": "Tiscali UK Ltd",
        "00:0E:47": "NCI System Co.,Ltd.",
        "00:0E:46": "Niigata Seimitsu Co.,Ltd.",
        "00:0E:1F": "TCL Networks Equipment Co., Ltd.",
        "00:0E:26": "Gincom Technology Corp.",
        "00:0E:6C": "Device Drivers Limited",
        "00:0E:6B": "Janitza electronics GmbH",
        "00:0E:5F": "activ-net GmbH & Co. KG",
        "00:0E:57": "Iworld Networking, Inc.",
        "00:0E:67": "Eltis Microelectronics Ltd.",
        "00:0E:65": "TransCore",
        "00:0E:43": "G-Tek Electronics Sdn. Bhd.",
        "00:0E:44": "Digital 5, Inc.",
        "00:0E:74": "Solar Telecom. Tech",
        "00:0E:7A": "GemWon Communications Co., Ltd.",
        "00:0E:80": "Thomson Technology Inc",
        "00:0E:85": "Catalyst Enterprises, Inc.",
        "00:0E:32": "Kontron Medical",
        "00:0E:0B": "Netac Technology Co., Ltd.",
        "00:0E:11": "BDT Büro und Datentechnik GmbH & Co.KG ",
        "00:0D:F5": "Teletronics International Inc.",
        "00:0D:F7": "Space Dynamics Lab",
        "00:0D:EB": "CompXs Limited",
        "00:0D:EE": "Andrew RF Power Amplifier Group",
        "00:0D:EF": "Soc. Coop. Bilanciai",
        "00:0D:E7": "Snap-on OEM Group",
        "00:0D:C6": "DigiRose Technology Co., Ltd.",
        "00:0D:C1": "SafeWeb Inc",
        "00:0D:F0": "QCOM TECHNOLOGY INC.",
        "00:0D:E5": "Samsung Thales",
        "00:0D:C0": "Spagat AS",
        "00:0D:DD": "Profilo Telra Elektronik Sanayi ve Ticaret. A.Ş",
        "00:0D:F8": "ORGA Kartensysteme GmbH",
        "00:0E:16": "SouthWing S.L.",
        "00:0D:A7": "Private",
        "00:0D:AD": "Dataprobe, Inc.",
        "00:0D:AB": "Parker Hannifin GmbH Electromechanical Division Europe",
        "00:0D:A8": "Teletronics Technology Corporation",
        "00:0D:79": "Dynamic Solutions Co,.Ltd.",
        "00:0D:6D": "K-Tech Devices Corp.",
        "00:0D:AF": "Plexus Corp (UK) Ltd",
        "00:0D:B1": "Japan Network Service Co., Ltd.",
        "00:0D:83": "Sanmina-SCI Hungary  Ltd.",
        "00:0D:7F": "MIDAS  COMMUNICATION TECHNOLOGIES PTE LTD ( Foreign Branch)",
        "00:0D:75": "Kobian Pte Ltd - Taiwan Branch",
        "00:0D:78": "Engineering & Security",
        "00:0D:9E": "TOKUDEN OHIZUMI SEISAKUSYO Co.,Ltd.",
        "00:0D:A3": "Emerging Technologies Limited",
        "00:0D:A4": "DOSCH & AMAND SYSTEMS AG",
        "00:0D:9A": "INFOTEC LTD",
        "00:0D:6E": "K-Patents Oy",
        "00:0D:6A": "Redwood Technologies LTD",
        "00:0D:BA": "Océ Document Technologies GmbH",
        "00:0D:BD": "Cisco Systems, Inc",
        "00:0D:B5": "GLOBALSAT TECHNOLOGY CORPORATION",
        "00:0D:97": "ABB Inc./Tropos",
        "00:0D:96": "Vtera Technology Inc.",
        "00:0D:8B": "T&D Corporation",
        "00:0D:90": "Factum Electronics AB",
        "00:0D:85": "Tapwave, Inc.",
        "00:0D:82": "PHSNET",
        "00:0D:23": "Smart Solution, Inc",
        "00:0D:27": "MICROPLEX Printware AG",
        "00:0D:1B": "Kyoto Electronics Manufacturing Co., Ltd.",
        "00:0D:1D": "HIGH-TEK HARNESS ENT. CO., LTD.",
        "00:0D:02": "NEC Platforms, Ltd.",
        "00:0D:07": "Calrec Audio Ltd",
        "00:0D:40": "Verint Loronix Video Solutions",
        "00:0D:21": "WISCORE Inc.",
        "00:0D:09": "Yuehua(Zhuhai) Electronic CO. LTD",
        "00:0D:37": "WIPLUG",
        "00:0D:33": "Prediwave Corp.",
        "00:0D:2F": "AIN Comm.Tech.Co., LTD",
        "00:0D:5D": "Raritan Computer, Inc",
        "00:0D:63": "DENT Instruments, Inc.",
        "00:0D:66": "Cisco Systems, Inc",
        "00:0C:CD": "IEC - TC57",
        "00:0C:CB": "Design Combus Ltd",
        "00:0C:C9": "ILWOO DATA & TECHNOLOGY CO.,LTD",
        "00:0C:E9": "BLOOMBERG L.P.",
        "00:0C:EA": "aphona Kommunikationssysteme",
        "00:0C:DA": "FreeHand Systems, Inc.",
        "00:0C:F5": "InfoExpress",
        "00:0C:EE": "jp-embedded",
        "00:0C:AF": "TRI TERM CO.,LTD.",
        "00:0C:B3": "ROUND Co.,Ltd.",
        "00:0C:DD": "AOS technologies AG",
        "00:0C:A5": "Naman NZ LTd",
        "00:0C:A9": "Ebtron Inc.",
        "00:0C:FB": "Korea Network Systems",
        "00:0C:7A": "DaTARIUS Technologies GmbH",
        "00:0C:79": "Extel Communications P/L",
        "00:0C:75": "Oriental integrated electronics. LTD",
        "00:0C:5D": "CHIC TECHNOLOGY (CHINA) CORP.",
        "00:0C:4F": "UDTech Japan Corporation",
        "00:0C:62": "ABB AB, Cewe-Control ",
        "00:0C:4C": "Arcor AG&Co.",
        "00:0C:47": "SK Teletech(R&D Planning Team)",
        "00:0C:6D": "Edwards Ltd.",
        "00:0C:70": "ACC GmbH",
        "00:0C:6A": "MBARI",
        "00:0C:6B": "Kurz Industrie-Elektronik GmbH",
        "00:0C:9D": "UbeeAirWalk, Inc.",
        "00:0C:9F": "NKE Corporation",
        "00:0C:84": "Eazix, Inc.",
        "00:0C:85": "Cisco Systems, Inc",
        "00:0C:3F": "Cogent Defence & Security Networks,",
        "00:0C:30": "Cisco Systems, Inc",
        "00:0C:9A": "Hitech Electronics Corp.",
        "00:0C:91": "Riverhead Networks Inc.",
        "00:0B:DA": "EyeCross Co.,Inc.",
        "00:0B:D6": "Paxton Access Ltd",
        "00:0B:D4": "Beijing Wise Technology & Science Development Co.Ltd",
        "00:0C:1F": "Glimmerglass Networks",
        "00:0C:20": "Fi WIn, Inc.",
        "00:0C:15": "CyberPower Systems, Inc.",
        "00:0B:FF": "Berkeley Camera Engineering",
        "00:0C:16": "Concorde Microsystems Inc.",
        "00:0C:09": "Hitachi IE Systems Co., Ltd",
        "00:0B:E7": "COMFLUX TECHNOLOGY INC.",
        "00:0B:EC": "NIPPON ELECTRIC INSTRUMENT, INC.",
        "00:0C:02": "ABB Oy",
        "00:0B:71": "Litchfield Communications Inc.",
        "00:0B:74": "Kingwave Technology Co., Ltd.",
        "00:0B:73": "Kodeos Communications",
        "00:0B:76": "ET&T Technology Co. Ltd.",
        "00:0B:5E": "Audio Engineering Society Inc.",
        "00:0B:60": "Cisco Systems, Inc",
        "00:0B:65": "Sy.A.C. srl",
        "00:0B:5F": "Cisco Systems, Inc",
        "00:0B:61": "Friedrich Lütze GmbH & Co. KG",
        "00:0B:59": "ScriptPro, LLC",
        "00:0B:5C": "Newtech Co.,Ltd",
        "00:0B:7E": "SAGINOMIYA Seisakusho Inc.",
        "00:0B:80": "Lycium Networks",
        "00:0B:A7": "Maranti Networks",
        "00:0B:AA": "Aiphone co.,Ltd",
        "00:0B:A4": "Shiron Satellite Communications Ltd. (1996)",
        "00:0B:D0": "XiMeta Technology Americas Inc.",
        "00:0B:C5": "SMC Networks, Inc.",
        "00:0B:C6": "ISAC, Inc.",
        "00:0B:C1": "Bay Microsystems, Inc.",
        "00:0B:8B": "KERAJET, S.A.",
        "00:0B:89": "Top Global Technology, Ltd.",
        "00:0B:99": "SensAble Technologies, Inc.",
        "00:0B:9C": "TriBeam Technologies, Inc.",
        "00:0B:7C": "Telex Communications",
        "00:0B:83": "DATAWATT B.V.",
        "00:0B:20": "Hirata corporation",
        "00:0B:22": "Environmental Systems and Services",
        "00:0B:1B": "Systronix, Inc.",
        "00:0B:03": "Taekwang Industrial Co., Ltd",
        "00:0B:01": "DAIICHI ELECTRONICS CO., LTD.",
        "00:0B:3E": "BittWare, Inc",
        "00:0B:29": "LS(LG) Industrial Systems co.,Ltd",
        "00:0B:39": "Keisoku Giken Co.,Ltd.",
        "00:0B:33": "Vivato Technologies",
        "00:0B:05": "Pacific Broadband Networks",
        "00:0B:00": "FUJIAN START COMPUTER EQUIPMENT CO.,LTD",
        "00:0B:5B": "Rincon Research Corporation",
        "00:0A:F6": "Emerson Climate Technologies Retail Solutions, Inc.",
        "00:0B:11": "HIMEJI ABC TRADING CO.,LTD.",
        "00:0B:41": "Ing. Büro Dr. Beutlhauser",
        "00:0A:EA": "ADAM ELEKTRONIK LTD. ŞTI",
        "00:0A:E3": "YANG MEI TECHNOLOGY CO., LTD",
        "00:0A:DC": "RuggedCom Inc.",
        "00:0A:B7": "Cisco Systems, Inc",
        "00:0A:AD": "Stargames Corporation",
        "00:0A:B1": "GENETEC Corporation",
        "00:0A:B9": "Astera Technologies Corp.",
        "00:0A:90": "Bayside Interactive, Inc.",
        "00:0A:9D": "King Young Technology Co. Ltd.",
        "00:0A:A1": "V V S Limited",
        "00:0A:A4": "SHANGHAI SURVEILLANCE TECHNOLOGY CO,LTD",
        "00:0A:9E": "BroadWeb Corportation",
        "00:0A:E0": "Fujitsu Softek",
        "00:0A:8B": "Cisco Systems, Inc",
        "00:0A:88": "InCypher S.A.",
        "00:0A:BB": "Taiwan Secom Co,. Ltd",
        "00:0A:7C": "Tecton Ltd",
        "00:0A:6E": "Harmonic, Inc",
        "00:0A:6D": "EKS Elektronikservice GmbH",
        "00:0A:43": "Chunghwa Telecom Co., Ltd.",
        "00:0A:45": "Audio-Technica Corp.",
        "00:0A:35": "Xilinx",
        "00:0A:3B": "GCT Semiconductor, Inc",
        "00:0A:74": "Manticom Networks Inc.",
        "00:0A:6F": "ZyFLEX Technologies Inc",
        "00:0A:63": "DHD GmbH",
        "00:0A:2E": "MAPLE NETWORKS CO., LTD",
        "00:0A:2D": "Cabot Communications Limited",
        "00:0A:25": "CERAGON NETWORKS",
        "00:0A:21": "Integra Telecom Co. Ltd",
        "00:0A:1E": "Red-M Products Limited",
        "00:0A:4B": "DataPower Technology, Inc.",
        "00:0A:33": "Emulex Corporation",
        "00:0A:67": "OngCorp",
        "00:09:F9": "ART JAPAN CO., LTD.",
        "00:09:FC": "IPFLEX Inc.",
        "00:09:FD": "Ubinetics Limited",
        "00:09:F7": "SED, a division of Calian",
        "00:09:E2": "Sinbon Electronics Co., Ltd.",
        "00:09:DA": "Control Module Inc.",
        "00:09:D7": "DC Security Products",
        "00:09:D8": "Fält Communications AB",
        "00:0A:14": "TECO a.s.",
        "00:0A:0B": "Sealevel Systems, Inc.",
        "00:0A:10": "FAST media integrations AG",
        "00:09:DB": "eSpace",
        "00:09:D5": "Signal Communication, Inc.",
        "00:09:D3": "Western DataCom Co., Inc.",
        "00:09:BC": "Utility, Inc",
        "00:09:BE": "Mamiya-OP Co.,Ltd.",
        "00:09:E6": "Cyber Switching Inc.",
        "00:09:FB": "Philips Patient Monitoring",
        "00:09:8F": "Cetacean Networks",
        "00:09:87": "NISHI NIPPON ELECTRIC WIRE & CABLE CO.,LTD.",
        "00:09:89": "VividLogic Inc.",
        "00:09:86": "Metalink LTD.",
        "00:09:8C": "Option Wireless Sweden",
        "00:09:85": "Auto Telecom Company",
        "00:09:8D": "Velocity Semiconductor",
        "00:09:81": "Newport Networks",
        "00:09:55": "Young Generation International Corp.",
        "00:09:4A": "Homenet Communications",
        "00:09:4B": "FillFactory NV",
        "00:09:4D": "Braintree Communications Pty Ltd",
        "00:09:50": "Independent Storage Corporation",
        "00:09:54": "AMiT spol. s. r. o.",
        "00:09:92": "InterEpoch Technology,INC.",
        "00:09:95": "Castle Technology Ltd",
        "00:09:98": "Capinfo Company Limited",
        "00:09:B6": "Cisco Systems, Inc",
        "00:09:B3": "MCM Systems Ltd",
        "00:09:5C": "Philips Medical Systems - Cardiac and Monitoring Systems (CM",
        "00:09:58": "INTELNET S.A.",
        "00:09:A3": "Leadfly Techologies Corp. Ltd.",
        "00:09:A5": "HANSUNG ELETRONIC INDUSTRIES DEVELOPMENT CO., LTD",
        "00:09:62": "Sonitor Technologies AS",
        "00:09:5D": "Dialogue Technology Corp.",
        "00:09:9A": "ELMO COMPANY, LIMITED",
        "00:09:9C": "Naval Research Laboratory",
        "00:09:84": "MyCasa Network Inc.",
        "00:09:2B": "iQstor Networks, Inc.",
        "00:09:26": "YODA COMMUNICATIONS, INC.",
        "00:09:27": "TOYOKEIKI CO.,LTD.",
        "00:09:23": "Heaman System Co., Ltd",
        "00:09:1D": "Proteam Computer Corporation",
        "00:08:EB": "ROMWin Co.,Ltd.",
        "00:08:E8": "Excel Master Ltd.",
        "00:08:DC": "Wiznet",
        "00:08:DD": "Telena Communications, Inc.",
        "00:08:E1": "Barix AG",
        "00:09:09": "Telenor Connect A/S",
        "00:09:0A": "SnedFar Technology Co., Ltd.",
        "00:09:2C": "Hitpoint Inc.",
        "00:09:03": "Panasas, Inc",
        "00:09:07": "Chrysalis Development",
        "00:09:06": "Esteem Networks",
        "00:09:52": "Auerswald GmbH & Co. KG",
        "00:09:44": "Cisco Systems, Inc",
        "00:08:FB": "SonoSite, Inc.",
        "00:08:EE": "Logic Product Development",
        "00:09:17": "WEM Technology Inc",
        "00:08:81": "DIGITAL HANDS CO.,LTD.",
        "00:08:82": "SIGMA CORPORATION",
        "00:08:73": "DapTechnology B.V.",
        "00:08:7A": "Wipotec GmbH",
        "00:08:71": "NORTHDATA Co., Ltd.",
        "00:08:B2": "SHENZHEN COMPASS TECHNOLOGY DEVELOPMENT CO.,LTD",
        "00:08:B1": "ProQuent Systems",
        "00:08:AF": "Novatec Corporation",
        "00:08:A6": "Multiware & Image Co., Ltd.",
        "00:08:7E": "Bon Electro-Telecom Inc.",
        "00:08:80": "BroadTel Canada Communications inc.",
        "00:08:6D": "Missouri FreeNet",
        "00:08:D4": "IneoQuest Technologies, Inc",
        "00:08:D6": "HASSNET Inc.",
        "00:08:CE": "IPMobileNet Inc.",
        "00:08:C2": "Cisco Systems, Inc",
        "00:08:C0": "ASA SYSTEMS",
        "00:08:A3": "Cisco Systems, Inc",
        "00:08:9E": "Beijing Enter-Net co.LTD",
        "00:08:B4": "SYSPOL",
        "00:08:B3": "Fastwel",
        "00:08:8E": "Nihon Computer Co., Ltd.",
        "00:08:DA": "SofaWare Technologies Ltd.",
        "00:07:D5": "3e Technologies Int;., Inc.",
        "00:07:DB": "Kirana Networks, Inc.",
        "00:08:6A": "Securiton Gmbh",
        "00:08:63": "Entrisphere Inc.",
        "00:08:66": "DSX Access Systems, Inc.",
        "00:07:EF": "Lockheed Martin Tactical Systems",
        "00:07:F4": "Eletex Co., Ltd.",
        "00:07:DD": "Cradle Technologies",
        "00:08:1B": "Windigo Systems",
        "00:07:FF": "Gluon Networks",
        "00:07:F7": "Galtronics",
        "00:08:5F": "Picanol N.V.",
        "00:08:52": "Davolink Co. Inc.",
        "00:08:04": "ICA Inc.",
        "00:08:57": "Polaris Networks, Inc.",
        "00:07:8B": "Wegener Communications, Inc.",
        "00:07:83": "SynCom Network, Inc.",
        "00:07:87": "Idea System Co., Ltd.",
        "00:07:B9": "Ginganet Corporation",
        "00:04:7F": "Chr. Mayr GmbH & Co. KG",
        "00:04:7B": "Schlumberger",
        "00:07:B4": "Cisco Systems, Inc",
        "00:07:B3": "Cisco Systems, Inc",
        "00:07:B5": "Any One Wireless Ltd.",
        "00:07:85": "Cisco Systems, Inc",
        "00:07:75": "Valence Semiconductor, Inc.",
        "00:07:93": "Shin Satellite Public Company Limited",
        "00:07:96": "LSI Systems, Inc.",
        "00:07:7F": "J Communications Co., Ltd.",
        "00:07:71": "Embedded System Corporation",
        "00:07:70": "Ubiquoss Inc",
        "00:07:D1": "Spectrum Signal Processing Inc.",
        "00:07:A2": "Opteon Corporation",
        "00:06:F8": "The Boeing Company",
        "00:06:FB": "Hitachi Printing Solutions, Ltd.",
        "00:06:FC": "Fnet Co., Ltd.",
        "00:06:F4": "Prime Electronics & Satellitics Inc.",
        "00:07:38": "Young Technology Co., Ltd.",
        "00:07:29": "Kistler Instrumente AG",
        "00:07:2A": "Innovance Networks",
        "00:07:4A": "Carl Valentin GmbH",
        "00:07:3C": "Telecom Design",
        "00:07:36": "Data Video Technologies Co., Ltd.",
        "00:07:50": "Cisco Systems, Inc",
        "00:07:42": "Ormazabal",
        "00:07:4B": "Daihen Corporation",
        "00:07:64": "YoungWoo Telecom Co. Ltd.",
        "00:07:66": "Chou Chin Industrial Co., Ltd.",
        "00:07:61": "29530",
        "00:07:55": "Lafon",
        "00:07:59": "Boris Manufacturing Corp.",
        "00:07:51": "m-u-t AG",
        "00:07:19": "Mobiis Co., Ltd.",
        "00:07:0D": "Cisco Systems, Inc",
        "00:07:0E": "Cisco Systems, Inc",
        "00:07:0B": "Novabase SGPS, SA",
        "00:07:10": "Adax, Inc.",
        "00:06:E8": "Optical Network Testing, Inc.",
        "00:06:EE": "Shenyang Neu-era Information & Technology Stock Co., Ltd",
        "00:06:E2": "Ceemax Technology Co., Ltd.",
        "00:06:A5": "PINON Corp.",
        "00:06:9D": "Petards Ltd",
        "00:06:A8": "KC Technology, Inc.",
        "00:06:A0": "Mx Imaging",
        "00:06:BE": "Baumer Optronic GmbH",
        "00:06:BA": "Westwave Communications",
        "00:06:C4": "Piolink Inc.",
        "00:06:B5": "Source Photonics, Inc.",
        "00:06:8F": "Telemonitor, Inc.",
        "00:06:DA": "ITRAN Communications Ltd.",
        "00:06:D0": "Elgar Electronics Corp.",
        "00:06:CC": "JMI Electronics Co., Ltd.",
        "00:06:BF": "Accella Technologies Co., Ltd.",
        "00:06:90": "Euracom Communication GmbH",
        "00:06:E1": "Techno Trade s.a",
        "00:06:2E": "Aristos Logic Corp.",
        "00:06:24": "Gentner Communications Corp.",
        "00:06:25": "The Linksys Group, Inc.",
        "00:06:27": "Uniwide Technologies, Inc.",
        "00:06:2A": "Cisco Systems, Inc",
        "00:06:2C": "Bivio Networks",
        "00:06:21": "Hinox, Co., Ltd.",
        "00:06:4E": "Broad Net Technology Inc.",
        "00:06:2D": "TouchStar Technologies, L.L.C.",
        "00:06:46": "ShenZhen XunBao Network Technology Co Ltd",
        "00:06:4B": "Alexon Co., Ltd.",
        "00:06:3C": "Intrinsyc Software International Inc.",
        "00:06:30": "Adtranz Sweden",
        "00:06:37": "Toptrend-Meta Information (ShenZhen) Inc.",
        "00:06:1C": "Hoshino Metal Industries, Ltd.",
        "00:06:23": "MGE UPS Systems France",
        "00:06:0B": "Artesyn Embedded Technologies",
        "00:06:7E": "WinCom Systems, Inc.",
        "00:06:77": "SICK AG",
        "00:06:66": "Roving Networks",
        "00:06:67": "Tripp Lite",
        "00:06:4D": "Sencore",
        "00:06:60": "NADEX Co., Ltd.",
        "00:06:79": "Konami Corporation",
        "00:06:6C": "Robinson Corporation",
        "00:06:15": "Kimoto Electric Co., Ltd.",
        "00:06:0A": "Blue2space",
        "00:05:CE": "Prolink Microsystems Corporation",
        "00:05:C2": "Soronti, Inc.",
        "00:05:DF": "Electronic Innovation, Inc.",
        "00:05:DE": "Gi Fone Korea, Inc.",
        "00:05:E0": "Empirix Corp.",
        "00:05:D8": "Arescom, Inc.",
        "00:05:E4": "Red Lion Controls Inc.",
        "00:05:F2": "Power R, Inc.",
        "00:05:F3": "Webyn",
        "00:06:01": "Otanikeiki Co., Ltd.",
        "00:06:05": "Inncom International, Inc.",
        "00:05:FA": "IPOptical, Inc.",
        "00:05:E5": "Renishaw PLC",
        "00:05:F5": "Geospace Technologies",
        "00:05:FD": "PacketLight Networks Ltd.",
        "00:05:D4": "FutureSmart Networks, Inc.",
        "00:05:C4": "Telect, Inc.",
        "00:05:A3": "QEI, Inc.",
        "00:05:9E": "Zinwell Corporation",
        "00:05:A5": "KOTT",
        "00:05:B3": "Asahi-Engineering Co., Ltd.",
        "00:05:9D": "Daniel Computing Systems, Inc.",
        "00:05:A4": "Lucid Voice Ltd.",
        "00:05:63": "J-Works, Inc.",
        "00:05:57": "Agile TV Corporation",
        "00:05:5B": "Charles Industries, Ltd.",
        "00:05:54": "Rangestar Wireless",
        "00:05:53": "DVC Company, Inc.",
        "00:05:66": "Secui.com Corporation",
        "00:05:6C": "Hung Chang Co., Ltd.",
        "00:05:5F": "Cisco Systems, Inc",
        "00:05:5D": "D-LINK SYSTEMS, INC.",
        "00:05:61": "nac Image Technology, Inc.",
        "00:05:94": "HMS Industrial Networks",
        "00:05:6F": "Innomedia Technologies Pvt. Ltd.",
        "00:05:74": "Cisco Systems, Inc",
        "00:05:67": "Etymonic Design, Inc.",
        "00:05:65": "Tailyn Communication Company Ltd.",
        "00:05:8E": "Flextronics International GmbH & Co. Nfg. KG",
        "00:05:32": "Cisco Systems, Inc",
        "00:05:36": "Danam Communications, Inc.",
        "00:05:42": "Otari, Inc.",
        "00:05:37": "Nets Technology Co., Ltd.",
        "00:05:7C": "RCO Security AB",
        "00:05:83": "ImageCom Limited",
        "00:05:4B": "Eaton Automation AG",
        "00:04:C8": "LIBA Maschinenfabrik GmbH",
        "00:04:CC": "Peek Traffic B.V.",
        "00:04:BF": "VersaLogic Corp.",
        "00:04:C3": "CASTOR Informatique",
        "00:04:F6": "Amphus",
        "00:04:F4": "Infinite Electronics Inc.",
        "00:04:F1": "WhereNet",
        "00:05:21": "Control Microsystems",
        "00:05:23": "AVL List GmbH",
        "00:05:1F": "Taijin Media Co., Ltd.",
        "00:05:0C": "Network Photonics, Inc.",
        "00:04:EC": "Memobox SA",
        "00:04:E4": "Daeryung Ind., Inc.",
        "00:05:0A": "ICS Spa",
        "00:05:11": "Complementary Technologies Ltd",
        "00:05:06": "Reddo Networks AB",
        "00:04:E2": "SMC Networks, Inc.",
        "00:04:CB": "Tdsoft Communication, Ltd.",
        "00:05:26": "IPAS GmbH",
        "00:04:67": "Wuhan Research Institute of MII",
        "00:04:5A": "The Linksys Group, Inc.",
        "00:04:63": "Bosch Security Systems",
        "00:04:5C": "Mobiwave Pte Ltd",
        "00:04:53": "YottaYotta, Inc.",
        "00:04:50": "DMD Computers SRL",
        "00:04:43": "Agilent Technologies, Inc.",
        "00:04:49": "Mapletree Networks",
        "00:04:2F": "International Communications Products, Inc.",
        "00:04:29": "Pixord Corporation",
        "00:04:26": "Autosys",
        "00:04:B8": "Kumahira Co., Ltd.",
        "00:04:B5": "Equitrac Corporation",
        "00:04:B1": "Signal Technology, Inc.",
        "00:04:51": "Medrad, Inc.",
        "00:04:83": "Deltron Technology, Inc.",
        "00:04:41": "Half Dome Systems, Inc.",
        "00:04:A5": "Barco Projection Systems NV",
        "00:04:82": "Medialogic Corp.",
        "00:03:CA": "MTS Systems Corp.",
        "00:03:C7": "hopf Elektronik GmbH",
        "00:03:C2": "Solphone K.K.",
        "00:03:F3": "Dazzle Multimedia, Inc.",
        "00:03:EC": "ICG Research, Inc.",
        "00:03:E9": "Akara Canada, Inc.",
        "00:03:E5": "Hermstedt SG",
        "00:04:21": "Ocular Networks",
        "00:04:24": "TMC s.r.l.",
        "00:04:1D": "Corega of America",
        "00:04:1A": "Ines Test and Measurement GmbH & CoKG",
        "00:04:1E": "Shikoku Instrumentation Co., Ltd.",
        "00:04:13": "snom technology GmbH",
        "00:03:B4": "Macrotek International Corp.",
        "00:03:A6": "Traxit Technology, Inc.",
        "00:03:A4": "Imation Corp.",
        "00:03:AB": "Bridge Information Systems",
        "00:04:03": "Nexsi Corporation",
        "00:04:06": "Fa. Metabox AG",
        "00:03:F8": "SanCastle Technologies, Inc.",
        "00:03:FA": "TiMetra Networks",
        "00:03:C6": "ICUE Systems, Inc.",
        "00:03:BB": "Signal Communications Limited",
        "00:03:BE": "Netility",
        "00:03:DF": "Desana Systems",
        "00:03:DA": "Takamisawa Cybernetics Co., Ltd.",
        "00:03:D9": "Secheron SA",
        "00:03:FB": "ENEGATE Co.,Ltd.",
        "00:03:F6": "Allegro Networks, Inc.",
        "00:04:15": "Rasteme Systems Co., Ltd.",
        "00:03:98": "WISI",
        "00:03:95": "California Amplifier",
        "00:03:92": "Hyundai Teletek Co., Ltd.",
        "00:03:8E": "Atoga Systems, Inc.",
        "00:03:1A": "Beijing Broad Telecom Ltd., China",
        "00:03:5B": "BridgeWave Communications",
        "00:03:57": "Intervoice-Brite, Inc.",
        "00:03:7F": "Atheros Communications, Inc.",
        "00:02:F0": "AME Optimedia Technology Co., Ltd.",
        "00:03:9E": "Tera System Co., Ltd.",
        "00:03:97": "FireBrick Limited",
        "00:03:3F": "BigBand Networks, Ltd.",
        "00:03:2E": "Scope Information Management, Ltd.",
        "00:03:7C": "Coax Media",
        "00:03:68": "Embedone Co., Ltd.",
        "00:03:45": "Routrek Networks Corporation",
        "00:02:C8": "Technocom Communications Technology (pte) Ltd",
        "00:02:B8": "WHI KONSULT AB",
        "00:02:A9": "RACOM, s.r.o.",
        "00:02:BB": "Continuous Computing Corp",
        "00:02:BC": "LVL 7 Systems, Inc.",
        "00:03:0F": "Digital China (Shanghai) Networks Ltd.",
        "00:03:11": "Micro Technology Co., Ltd.",
        "00:03:0D": "Uniwill Computer Corp.",
        "00:03:09": "Texcel Technology PLC",
        "00:03:03": "JAMA Electronics Co., Ltd.",
        "00:03:05": "MSC Vertriebs GmbH",
        "00:02:FE": "Viditec, Inc.",
        "00:01:9F": "ReadyNet",
        "00:02:FF": "Handan BroadInfoCom",
        "00:02:F4": "PCTEL, Inc.",
        "00:02:E9": "CS Systemes De Securite - C3S",
        "00:02:E5": "Timeware Ltd.",
        "00:02:E0": "ETAS GmbH",
        "00:02:CE": "FoxJet, Inc.",
        "00:02:C3": "Arelnet Ltd.",
        "00:03:16": "Nobell Communications, Inc.",
        "00:03:29": "F3, Inc.",
        "00:03:21": "Reco Research Co., Ltd.",
        "00:02:F5": "VIVE Synergies, Inc.",
        "00:02:D5": "ACR",
        "00:02:AB": "CTC Union Technologies Co., Ltd.",
        "00:02:A4": "AddPac Technology Co., Ltd.",
        "00:02:A0": "Flatstack Ltd.",
        "00:02:B2": "Cablevision",
        "00:02:B7": "Watanabe Electric Industry Co., Ltd.",
        "00:02:AF": "TeleCruz Technology, Inc.",
        "00:02:A8": "Air Link Technology",
        "00:02:6A": "Cocess Telecom Co., Ltd.",
        "00:02:6C": "Philips CFT",
        "00:02:62": "Soyo Group Soyo Com Tech Co., Ltd",
        "00:02:65": "Virditech Co. Ltd.",
        "00:02:5B": "Cambridge Silicon Radio",
        "00:02:56": "Alpha Processor, Inc.",
        "00:02:59": "Tsann Kuen China (Shanghai)Enterprise Co., Ltd. IT Group",
        "00:02:94": "Tokyo Sokushin Co., Ltd.",
        "00:02:96": "Lectron Co,. Ltd.",
        "00:02:8E": "Rapid 5 Networks, Inc.",
        "00:02:4F": "IPM Datacom S.R.L.",
        "00:02:8A": "Ambit Microsystems Corporation",
        "00:01:FA": "HOROSCAS",
        "00:02:82": "ViaClix, Inc.",
        "00:02:85": "Riverstone Networks",
        "00:02:79": "Control Applications, Ltd.",
        "00:02:51": "Soma Networks, Inc.",
        "00:01:F5": "ERIM S.A.",
        "00:01:FF": "Data Direct Networks, Inc.",
        "00:01:FC": "Keyence Corporation",
        "00:01:FD": "Digital Voice Systems, Inc.",
        "00:02:10": "Fenecom",
        "00:02:0B": "Native Networks, Inc.",
        "00:02:18": "Advanced Scientific Corp",
        "00:01:EE": "Comtrol Europe, Ltd.",
        "00:01:F0": "Tridium, Inc.",
        "00:01:F1": "Innovative Concepts, Inc.",
        "00:01:E2": "Ando Electric Corporation",
        "00:02:2F": "P-Cube, Ltd.",
        "00:02:27": "ESD Electronic System Design GmbH",
        "00:02:1D": "Data General Communication Ltd.",
        "00:02:19": "Paralon Technologies",
        "00:02:03": "Woonsang Telecom, Inc.",
        "00:01:D3": "PAXCOMM, Inc.",
        "00:01:E1": "Kinpo Electronics, Inc.",
        "00:02:2C": "ABB Bomem, Inc.",
        "00:02:3C": "Creative Technology, Ltd.",
        "00:30:6C": "Hitex Holding GmbH",
        "00:30:8B": "Brix Networks",
        "00:01:77": "EDSL",
        "00:01:4D": "Shin Kin Enterprises Co., Ltd",
        "00:01:DA": "WINCOMM Corporation",
        "00:01:D2": "inXtron, Inc. ",
        "00:01:C6": "Quarry Technologies",
        "00:01:6E": "Conklin Corporation",
        "00:01:74": "CyberOptics Corporation",
        "00:01:5E": "BEST TECHNOLOGY CO., LTD.",
        "00:01:61": "Meta Machine Technology",
        "00:01:A1": "Mag-Tek, Inc.",
        "00:01:86": "Uwe Disch",
        "00:01:A6": "Scientific-Atlanta Arcodan A/S",
        "00:01:72": "TechnoLand Co., LTD.",
        "00:01:A0": "Infinilink Corporation",
        "00:01:96": "Cisco Systems, Inc",
        "00:01:99": "HeiSei Electronics",
        "00:01:8B": "NetLinks Co., Ltd.",
        "00:01:8D": "AudeSi Technologies",
        "00:01:9D": "E-Control Systems, Inc.",
        "00:01:CE": "Custom Micro Products, Ltd.",
        "00:01:BB": "Frequentis",
        "00:01:BC": "Brains Corporation",
        "00:01:C0": "CompuLab, Ltd.",
        "00:01:7C": "AG-E GmbH",
        "00:01:08": "AVLAB Technology, Inc.",
        "00:06:2B": "INTRASERVER TECHNOLOGY",
        "00:01:00": "EQUIP'TRANS",
        "00:B0:9D": "Point Grey Research Inc.",
        "00:01:10": "Gotham Networks",
        "00:01:12": "Shark Multimedia Inc.",
        "00:01:16": "Netspect Technologies, Inc.",
        "00:B0:6D": "Jones Futurex Inc.",
        "00:B0:94": "Alaris, Inc.",
        "00:30:F0": "Uniform Industrial Corp.",
        "00:01:3B": "BNA SYSTEMS",
        "00:01:34": "Selectron Systems AG",
        "00:01:39": "Point Multimedia Systems",
        "00:01:3E": "Ascom Tateco AB",
        "00:01:2E": "PC Partner Ltd.",
        "00:01:32": "Dranetz - BMI",
        "00:01:13": "OLYMPUS CORPORATION",
        "00:01:1E": "Precidia Technologies, Inc.",
        "00:01:55": "Promise Technology, Inc.",
        "00:30:94": "Cisco Systems, Inc",
        "00:30:8A": "NICOTRA SISTEMI S.P.A",
        "00:30:72": "Intellibyte Inc.",
        "00:30:40": "Cisco Systems, Inc",
        "00:30:32": "MagicRam, Inc.",
        "00:30:EA": "TeraForce Technology Corporation",
        "00:30:9B": "Smartware",
        "00:30:45": "Village Networks, Inc. (VNI)",
        "00:30:E5": "Amper Datos S.A.",
        "00:30:06": "SUPERPOWER COMPUTER",
        "00:30:38": "XCP, INC.",
        "00:30:79": "CQOS, INC.",
        "00:30:0C": "CONGRUENCY, LTD.",
        "00:30:4C": "APPIAN COMMUNICATIONS, INC.",
        "00:30:E8": "ENSIM CORP.",
        "00:30:C9": "LuxN, N",
        "00:30:28": "FASE Saldatura srl",
        "00:30:69": "IMPACCT TECHNOLOGY CORP.",
        "00:30:C3": "FLUECKIGER ELEKTRONIK AG",
        "00:30:5A": "TELGEN CORPORATION",
        "00:30:10": "VISIONETICS INTERNATIONAL",
        "00:30:D9": "DATACORE SOFTWARE CORP.",
        "00:30:26": "HeiTel Digital Video GmbH",
        "00:30:77": "ONPREM NETWORKS",
        "00:30:47": "NISSEI ELECTRIC CO., LTD.",
        "00:30:D4": "AAE Systems, Inc.",
        "00:D0:D7": "B2C2, INC.",
        "00:D0:73": "ACN ADVANCED COMMUNICATIONS",
        "00:D0:57": "ULTRAK, INC.",
        "00:30:AB": "DELTA NETWORKS, INC.",
        "00:30:49": "BRYANT TECHNOLOGY, LTD.",
        "00:30:6D": "LUCENT TECHNOLOGIES",
        "00:30:17": "BlueArc UK Ltd",
        "00:30:1C": "ALTVATER AIRDATA SYSTEMS",
        "00:30:80": "Cisco Systems, Inc",
        "00:30:F7": "RAMIX INC.",
        "00:30:D0": "Tellabs",
        "00:30:14": "DIVIO, INC.",
        "00:30:81": "ALTOS C&C",
        "00:D0:F0": "CONVISION TECHNOLOGY GMBH",
        "00:D0:10": "CONVERGENT NETWORKS, INC.",
        "00:D0:4B": "LA CIE GROUP S.A.",
        "00:D0:0E": "PLURIS, INC.",
        "00:D0:12": "GATEWORKS CORP.",
        "00:D0:4D": "DIV OF RESEARCH & STATISTICS",
        "00:D0:2E": "COMMUNICATION AUTOMATION CORP.",
        "00:D0:C5": "COMPUTATIONAL SYSTEMS, INC.",
        "00:D0:46": "DOLBY LABORATORIES, INC.",
        "00:D0:DE": "PHILIPS MULTIMEDIA NETWORK",
        "00:D0:0C": "SNIJDER MICRO SYSTEMS",
        "00:D0:17": "SYNTECH INFORMATION CO., LTD.",
        "00:D0:36": "TECHNOLOGY ATLANTA CORP.",
        "00:D0:E3": "ELE-CHEM ENGINEERING CO., LTD.",
        "00:D0:B6": "CRESCENT NETWORKS, INC.",
        "00:D0:C4": "TERATECH CORPORATION",
        "00:D0:61": "TREMON ENTERPRISES CO., LTD.",
        "00:D0:E5": "SOLIDUM SYSTEMS CORP.",
        "00:D0:45": "KVASER AB",
        "00:D0:04": "PENTACOM LTD.",
        "00:D0:05": "ZHS ZEITMANAGEMENTSYSTEME",
        "00:D0:D3": "Cisco Systems, Inc",
        "00:D0:26": "HIRSCHMANN AUSTRIA GMBH",
        "00:D0:DA": "TAICOM DATA SYSTEMS CO., LTD.",
        "00:D0:3C": "Vieo, Inc.",
        "00:D0:B4": "KATSUJIMA CO., LTD.",
        "00:D0:86": "FOVEON, INC.",
        "00:D0:A8": "NETWORK ENGINES, INC.",
        "00:D0:AB": "DELTAKABEL TELECOM CV",
        "00:D0:E8": "MAC SYSTEM CO., LTD.",
        "00:D0:6B": "SR TELECOM INC.",
        "00:D0:DC": "MODULAR MINING SYSTEMS, INC.",
        "00:D0:1E": "PINGTEL CORP.",
        "00:D0:CA": "Intrinsyc Software International Inc.",
        "00:D0:65": "TOKO ELECTRIC",
        "00:D0:9A": "FILANET CORPORATION",
        "00:D0:AE": "ORESIS COMMUNICATIONS, INC.",
        "00:D0:F2": "MONTEREY NETWORKS",
        "00:D0:14": "ROOT, INC.",
        "00:D0:23": "INFORTREND TECHNOLOGY, INC.",
        "00:D0:A2": "INTEGRATED DEVICE",
        "00:D0:34": "ORMEC SYSTEMS CORP.",
        "00:D0:8A": "PHOTRON USA",
        "00:D0:A7": "TOKYO SOKKI KENKYUJO CO., LTD.",
        "00:D0:1D": "FURUNO ELECTRIC CO., LTD.",
        "00:50:4C": "Galil Motion Control",
        "00:50:76": "IBM Corp",
        "00:50:D4": "JOOHONG INFORMATION &",
        "00:50:A6": "OPTRONICS",
        "00:50:A9": "MOLDAT WIRELESS TECHNOLGIES",
        "00:50:9B": "SWITCHCORE AB",
        "00:50:7E": "NEWER TECHNOLOGY",
        "00:50:CE": "LG INTERNATIONAL CORP.",
        "00:50:F7": "VENTURE MANUFACTURING (SINGAPORE) LTD.",
        "00:50:19": "SPRING TIDE NETWORKS, INC.",
        "00:50:FD": "VISIONCOMM CO., LTD.",
        "00:50:BF": "Metalligence Technology Corp.",
        "00:50:36": "NETCAM, LTD.",
        "00:50:DB": "CONTEMPORARY CONTROL",
        "00:50:7C": "VIDEOCON AG",
        "00:50:47": "Private",
        "00:D0:6C": "SHAREWAVE, INC.",
        "00:50:A7": "Cisco Systems, Inc",
        "00:50:55": "DOMS A/S",
        "00:50:72": "CORVIS CORPORATION",
        "00:D0:EE": "DICTAPHONE CORPORATION",
        "00:50:1B": "ABL CANADA, INC.",
        "00:90:57": "AANetcom, Inc.",
        "00:90:83": "TURBO COMMUNICATION, INC.",
        "00:90:3D": "BIOPAC SYSTEMS, INC.",
        "00:90:D7": "NetBoost Corp.",
        "00:50:83": "GILBARCO, INC.",
        "00:50:DC": "TAS TELEFONBAU A. SCHWABE GMBH & CO. KG",
        "00:50:08": "TIVA MICROCOMPUTER CORP. (TMC)",
        "00:50:52": "TIARA NETWORKS, INC.",
        "00:50:27": "GENICOM CORPORATION",
        "00:50:5A": "NETWORK ALCHEMY, INC.",
        "00:50:39": "MARINER NETWORKS",
        "00:50:64": "CAE ELECTRONICS",
        "00:50:B8": "INOVA COMPUTERS GMBH & CO. KG",
        "00:50:5B": "KAWASAKI LSI U.S.A., INC.",
        "00:50:CC": "Seagate Cloud Systems Inc",
        "00:50:16": "Molex Canada Ltd",
        "00:50:1F": "MRG SYSTEMS, LTD.",
        "00:50:43": "MARVELL SEMICONDUCTOR, INC.",
        "00:50:95": "PERACOM NETWORKS",
        "00:50:FA": "OXTEL, LTD.",
        "00:90:38": "FOUNTAIN TECHNOLOGIES, INC.",
        "00:90:B0": "VADEM",
        "00:90:EF": "INTEGRIX, INC.",
        "00:90:C5": "INTERNET MAGIC, INC.",
        "00:90:8C": "ETREND ELECTRONICS, INC.",
        "00:90:48": "ZEAL CORPORATION",
        "00:90:B9": "BERAN INSTRUMENTS LTD.",
        "00:90:C4": "JAVELIN SYSTEMS, INC.",
        "00:90:A5": "SPECTRA LOGIC",
        "00:90:A3": "Corecess Inc.",
        "00:90:82": "FORCE INSTITUTE",
        "00:90:00": "DIAMOND MULTIMEDIA",
        "00:90:6E": "PRAXON, INC.",
        "00:90:54": "INNOVATIVE SEMICONDUCTORS, INC",
        "00:90:61": "PACIFIC RESEARCH & ENGINEERING CORPORATION",
        "00:90:0B": "LANNER ELECTRONICS, INC.",
        "00:90:CE": "avateramedical Mechatronics GmbH",
        "00:90:07": "DOMEX TECHNOLOGY CORP.",
        "00:90:2D": "DATA ELECTRONICS (AUST.) PTY, LTD.",
        "00:90:D4": "BindView Development Corp.",
        "00:90:29": "CRYPTO AG",
        "00:90:DF": "MITSUBISHI CHEMICAL AMERICA, INC.",
        "00:90:C0": "K.J. LAW ENGINEERS, INC.",
        "00:90:1F": "ADTEC PRODUCTIONS, INC.",
        "00:90:24": "PIPELINKS, INC.",
        "00:90:3A": "NIHON MEDIA TOOL INC.",
        "00:90:B2": "AVICI SYSTEMS INC.",
        "00:90:B6": "FIBEX SYSTEMS",
        "00:90:63": "COHERENT COMMUNICATIONS SYSTEMS CORPORATION",
        "00:90:62": "ICP VORTEX COMPUTERSYSTEME GmbH",
        "00:10:D3": "GRIPS ELECTRONIC GMBH",
        "00:10:FB": "ZIDA TECHNOLOGIES LIMITED",
        "00:10:53": "COMPUTER TECHNOLOGY CORP.",
        "00:10:ED": "SUNDANCE TECHNOLOGY, INC.",
        "00:10:6C": "EDNT GmbH",
        "00:10:E9": "RAIDTEC LTD.",
        "00:10:03": "IMATRON, INC.",
        "00:10:71": "ADVANET INC.",
        "00:90:15": "CENTIGRAM COMMUNICATIONS CORP.",
        "00:90:95": "UNIVERSAL AVIONICS",
        "00:90:41": "APPLIED DIGITAL ACCESS",
        "00:90:5A": "DEARBORN GROUP, INC.",
        "00:90:11": "WAVTrace, Inc.",
        "00:90:65": "FINISAR CORPORATION",
        "00:90:23": "ZILOG INC.",
        "00:90:F6": "ESCALATE NETWORKS, INC.",
        "00:90:A8": "NineTiles Networks, Ltd.",
        "00:10:2A": "ZF MICROSYSTEMS, INC.",
        "00:10:E5": "SOLECTRON TEXAS",
        "00:10:9D": "CLARINET SYSTEMS, INC.",
        "00:10:0E": "MICRO LINEAR COPORATION",
        "00:90:EC": "PYRESCOM",
        "00:90:C3": "TOPIC SEMICONDUCTOR CORP.",
        "00:10:C8": "COMMUNICATIONS ELECTRONICS SECURITY GROUP",
        "00:10:F3": "Nexcom International Co., Ltd.",
        "00:10:86": "ATTO Technology, Inc.",
        "00:10:DF": "RISE COMPUTER INC.",
        "00:10:72": "GVN TECHNOLOGIES, INC.",
        "00:10:DA": "Kollmorgen Corp",
        "00:10:E4": "NSI CORPORATION",
        "00:10:7E": "BACHMANN ELECTRONIC GmbH",
        "00:10:A0": "INNOVEX TECHNOLOGIES, INC.",
        "00:10:16": "T.SQWARE",
        "00:10:90": "CIMETRICS, INC.",
        "00:10:F5": "AMHERST SYSTEMS, INC.",
        "00:10:3D": "PHASECOM, LTD.",
        "00:10:96": "TRACEWELL SYSTEMS, INC.",
        "00:10:82": "JNA TELECOMMUNICATIONS LIMITED",
        "00:10:98": "STARNET TECHNOLOGIES, INC.",
        "00:10:42": "Alacritech, Inc.",
        "00:10:68": "COMOS TELECOM",
        "00:10:EA": "ADEPT TECHNOLOGY",
        "00:10:AE": "SHINKO ELECTRIC INDUSTRIES CO.",
        "00:10:C4": "MEDIA GLOBAL LINKS CO., LTD.",
        "00:10:FE": "DIGITAL EQUIPMENT CORPORATION",
        "00:10:56": "SODICK CO., LTD.",
        "00:10:CD": "INTERFACE CONCEPT",
        "00:10:61": "HOSTLINK CORP.",
        "00:10:99": "InnoMedia, Inc.",
        "00:10:E1": "S.I. TECH, INC.",
        "00:10:BB": "DATA & INFORMATION TECHNOLOGY",
        "00:10:20": "Hand Held Products Inc",
        "00:10:3A": "DIAMOND NETWORK TECH",
        "00:10:04": "THE BRANTLEY COILE COMPANY,INC",
        "00:10:EF": "DBTEL INCORPORATED",
        "00:10:88": "AMERICAN NETWORKS INC.",
        "00:10:22": "SatCom Media Corporation",
        "00:10:76": "EUREM GmbH",
        "00:10:3F": "TOLLGRADE COMMUNICATIONS, INC.",
        "00:10:49": "ShoreTel, Inc",
        "00:10:5E": "Spirent plc, Service Assurance Broadband",
        "00:10:AF": "TAC SYSTEMS, INC.",
        "00:10:8C": "Fujitsu Services Ltd",
        "00:10:F7": "IRIICHI TECHNOLOGIES Inc.",
        "00:10:AB": "KOITO ELECTRIC INDUSTRIES, LTD.",
        "00:10:10": "INITIO CORPORATION",
        "00:10:F2": "ANTEC",
        "00:E0:07": "Avaya ECS Ltd",
        "00:10:BE": "MARCH NETWORKS CORPORATION",
        "00:10:58": "ArrowPoint Communications",
        "00:10:0F": "INDUSTRIAL CPU SYSTEMS",
        "00:10:BC": "Aastra Telecom",
        "00:E0:BF": "TORRENT NETWORKING TECHNOLOGIES CORP.",
        "00:E0:E3": "SK-ELEKTRONIK GMBH",
        "00:E0:C6": "LINK2IT, L.L.C.",
        "00:E0:E5": "CINCO NETWORKS, INC.",
        "00:E0:61": "EdgePoint Networks, Inc.",
        "00:E0:53": "CELLPORT LABS, INC.",
        "00:E0:D3": "DATENTECHNIK GmbH",
        "00:E0:43": "VitalCom",
        "00:E0:B3": "EtherWAN Systems, Inc.",
        "00:E0:ED": "SILICOM, LTD.",
        "00:E0:B8": "GATEWAY 2000",
        "00:E0:7C": "METTLER-TOLEDO, INC.",
        "00:E0:26": "Redlake MASD LLC",
        "00:E0:20": "TECNOMEN OY",
        "00:E0:0D": "RADIANT SYSTEMS",
        "00:E0:DC": "NEXWARE CORP.",
        "00:E0:37": "CENTURY CORPORATION",
        "00:E0:C2": "NECSY S.p.A.",
        "00:E0:FB": "LEIGHTRONIX, INC.",
        "00:E0:9B": "ENGAGE NETWORKS, INC.",
        "00:E0:45": "TOUCHWAVE, INC.",
        "00:E0:40": "DeskStation Technology, Inc.",
        "00:E0:1A": "COMTEC SYSTEMS. CO., LTD.",
        "00:E0:78": "BERKELEY NETWORKS",
        "00:E0:87": "LeCroy - Networking Productions Division",
        "00:E0:41": "CSPI",
        "00:E0:E2": "INNOVA CORP.",
        "00:E0:81": "TYAN COMPUTER CORP.",
        "00:E0:57": "HAN MICROTELECOM. CO., LTD.",
        "00:E0:BC": "SYMON COMMUNICATIONS, INC.",
        "00:E0:82": "ANERMA",
        "00:E0:77": "WEBGEAR, INC.",
        "00:E0:56": "HOLONTECH CORPORATION",
        "00:E0:31": "HAGIWARA ELECTRIC CO., LTD.",
        "00:E0:0B": "ROOFTOP COMMUNICATIONS CORP.",
        "00:E0:B2": "TELMAX COMMUNICATIONS CORP.",
        "00:E0:2F": "MCNS HOLDINGS, L.P.",
        "00:E0:7E": "WALT DISNEY IMAGINEERING",
        "00:E0:99": "SAMSON AG",
        "00:60:AE": "TRIO INFORMATION SYSTEMS AB",
        "00:60:53": "TOYODA MACHINE WORKS, LTD.",
        "00:60:56": "NETWORK TOOLS, INC.",
        "00:60:0C": "Eurotech Inc.",
        "00:60:1C": "TELXON CORPORATION",
        "00:60:5F": "NIPPON UNISOFT CORPORATION",
        "00:60:91": "FIRST PACIFIC NETWORKS, INC.",
        "00:60:1D": "LUCENT TECHNOLOGIES",
        "00:60:7B": "FORE SYSTEMS, INC.",
        "00:E0:6C": "Ultra Electronics Command & Control Systems",
        "00:E0:4A": "ZX Technologies, Inc",
        "00:60:C9": "ControlNet, Inc.",
        "00:E0:7A": "MIKRODIDAKT AB",
        "00:60:32": "I-CUBE, INC.",
        "00:60:33": "ACUITY IMAGING, INC.",
        "00:60:13": "NETSTAL MASCHINEN AG",
        "00:60:22": "VICOM SYSTEMS, INC.",
        "00:60:EE": "APOLLO",
        "00:60:D8": "ELMIC SYSTEMS, INC.",
        "00:60:EF": "FLYTECH TECHNOLOGY CO., LTD.",
        "00:60:85": "Storage Concepts",
        "00:60:11": "CRYSTAL SEMICONDUCTOR CORP.",
        "00:60:F5": "ICON WEST, INC.",
        "00:60:62": "TELESYNC, INC.",
        "00:60:E9": "ATOP TECHNOLOGIES, INC.",
        "00:60:43": "iDirect, INC.",
        "00:60:28": "MACROVISION CORPORATION",
        "00:60:F0": "JOHNSON & JOHNSON MEDICAL, INC",
        "00:60:E0": "AXIOM TECHNOLOGY CO., LTD.",
        "00:60:96": "T.S. MICROTECH INC.",
        "00:60:3A": "QUICK CONTROLS LTD.",
        "00:02:88": "GLOBAL VILLAGE COMMUNICATION",
        "00:60:34": "ROBERT BOSCH GmbH",
        "00:60:50": "INTERNIX INC.",
        "00:60:FA": "EDUCATIONAL TECHNOLOGY RESOURCES, INC.",
        "00:60:DA": "Red Lion Controls, LP",
        "00:60:E4": "COMPUSERVE, INC.",
        "00:60:8F": "TEKRAM TECHNOLOGY CO., LTD.",
        "00:60:C4": "SOLITON SYSTEMS K.K.",
        "00:A0:3C": "EG&G NUCLEAR INSTRUMENTS",
        "00:A0:C4": "CRISTIE ELECTRONICS LTD.",
        "00:A0:63": "JRL SYSTEMS, INC.",
        "00:A0:2C": "interWAVE Communications",
        "00:A0:F7": "V.I COMPUTER CORP.",
        "00:A0:90": "TimeStep Corporation",
        "00:A0:EA": "ETHERCOM CORP.",
        "00:A0:DC": "O.N. ELECTRONIC CO., LTD.",
        "00:A0:0B": "COMPUTEX CO., LTD.",
        "00:A0:E2": "Keisokugiken Corporation",
        "00:A0:33": "imc MeBsysteme GmbH",
        "00:A0:A9": "NAVTEL COMMUNICATIONS INC.",
        "00:A0:71": "VIDEO LOTTERY TECHNOLOGIES,INC",
        "00:60:00": "XYCOM INC.",
        "00:60:45": "PATHLIGHT TECHNOLOGIES",
        "00:A0:5D": "CS COMPUTER SYSTEME GmbH",
        "00:A0:61": "PURITAN BENNETT",
        "00:60:A6": "PARTICLE MEASURING SYSTEMS",
        "00:60:2A": "SYMICRON COMPUTER COMMUNICATIONS, LTD.",
        "00:A0:6D": "MANNESMANN TALLY CORPORATION",
        "00:A0:F6": "AutoGas Systems Inc.",
        "00:60:BE": "WEBTRONICS",
        "00:60:BF": "MACRAIGOR SYSTEMS, INC.",
        "00:60:80": "MICROTRONIX DATACOM LTD.",
        "00:A0:37": "Mindray DS USA, Inc.",
        "00:A0:4C": "INNOVATIVE SYSTEMS & TECHNOLOGIES, INC.",
        "00:A0:31": "HAZELTINE CORPORATION, MS 1-17",
        "00:A0:41": "INFICON",
        "00:A0:A7": "VORAX CORPORATION",
        "00:A0:7E": "AVID TECHNOLOGY, INC.",
        "00:A0:6F": "Color Sentinel Systems, LLC",
        "00:A0:C7": "TADIRAN TELECOMMUNICATIONS",
        "00:A0:1A": "BINAR ELEKTRONIK AB",
        "00:A0:88": "ESSENTIAL COMMUNICATIONS",
        "00:A0:C2": "R.A. SYSTEMS CO., LTD.",
        "00:A0:98": "NetApp",
        "00:A0:4B": "TFL LAN INC.",
        "00:A0:64": "KVB/ANALECT",
        "00:A0:3E": "ATM FORUM",
        "00:A0:1F": "TRICORD SYSTEMS, INC.",
        "00:A0:6C": "SHINDENGEN ELECTRIC MFG. CO., LTD.",
        "00:A0:DB": "FISHER & PAYKEL PRODUCTION",
        "00:A0:81": "ALCATEL DATA NETWORKS",
        "00:A0:B1": "FIRST VIRTUAL CORPORATION",
        "00:20:10": "JEOL SYSTEM TECHNOLOGY CO. LTD",
        "00:20:9F": "MERCURY COMPUTER SYSTEMS, INC.",
        "00:A0:73": "COM21, INC.",
        "00:A0:3A": "KUBOTEK CORPORATION",
        "00:A0:B2": "SHIMA SEIKI",
        "00:A0:8B": "ASTON ELECTRONIC DESIGNS LTD.",
        "00:A0:97": "JC INFORMATION SYSTEMS",
        "00:A0:27": "FIREPOWER SYSTEMS, INC.",
        "00:A0:46": "SCITEX CORP. LTD.",
        "00:A0:D4": "RADIOLAN,  INC.",
        "00:A0:92": "H. BOLLMANN MANUFACTURERS, LTD",
        "00:20:0D": "CARL ZEISS",
        "00:20:2D": "TAIYO CORPORATION",
        "00:20:91": "J125, NATIONAL SECURITY AGENCY",
        "00:20:BD": "NIOBRARA R & D CORPORATION",
        "00:20:54": "Sycamore Networks",
        "00:20:A7": "PAIRGAIN TECHNOLOGIES, INC.",
        "00:20:55": "ALTECH CO., LTD.",
        "00:20:0A": "SOURCE-COMM CORP.",
        "00:20:CF": "TEST & MEASUREMENT SYSTEMS INC",
        "00:20:B4": "TERMA ELEKTRONIK AS",
        "00:20:E4": "HSING TECH ENTERPRISE CO., LTD",
        "00:20:6C": "EVERGREEN TECHNOLOGY CORP.",
        "00:20:5E": "CASTLE ROCK, INC.",
        "00:20:12": "CAMTRONICS MEDICAL SYSTEMS",
        "00:20:75": "MOTOROLA COMMUNICATION ISRAEL",
        "00:20:A5": "API ENGINEERING",
        "00:20:64": "PROTEC MICROSYSTEMS, INC.",
        "00:20:33": "SYNAPSE TECHNOLOGIES, INC.",
        "00:20:CB": "PRETEC ELECTRONICS CORP.",
        "00:20:EB": "CINCINNATI MICROWAVE, INC.",
        "00:20:A0": "OA LABORATORY CO., LTD.",
        "00:20:E2": "INFORMATION RESOURCE ENGINEERING",
        "00:20:07": "SFA, INC.",
        "00:20:5C": "InterNet Systems of Florida, Inc.",
        "00:20:A2": "GALCOM NETWORKING LTD.",
        "00:20:31": "Tattile SRL ",
        "00:20:D0": "VERSALYNX CORPORATION",
        "00:20:B9": "METRICOM, INC.",
        "00:20:39": "SCINETS",
        "00:20:72": "WORKLINK INNOVATIONS",
        "00:20:EC": "TECHWARE SYSTEMS CORP.",
        "00:20:6E": "XACT, INC.",
        "00:20:F1": "ALTOS INDIA LIMITED",
        "00:20:41": "DATA NET",
        "00:20:76": "REUDO CORPORATION",
        "00:20:E8": "DATATREK CORPORATION",
        "00:20:C5": "EAGLE TECHNOLOGY",
        "00:20:09": "PACKARD BELL ELEC., INC.",
        "00:20:27": "MING FORTUNE INDUSTRY CO., LTD",
        "00:20:8A": "SONIX COMMUNICATIONS, LTD.",
        "00:20:D2": "RAD DATA COMMUNICATIONS, LTD.",
        "00:20:02": "SERITECH ENTERPRISE CO., LTD.",
        "00:20:4B": "AUTOCOMPUTER CO., LTD.",
        "00:20:EA": "EFFICIENT NETWORKS, INC.",
        "00:20:6A": "OSAKA COMPUTER CORP.",
        "00:20:DB": "XNET TECHNOLOGY, INC.",
        "00:20:BB": "ZAX CORPORATION",
        "00:20:A8": "SAST TECHNOLOGY CORP.",
        "00:20:45": "ION Networks, Inc.",
        "00:20:49": "COMTRON, INC.",
        "00:20:50": "KOREA COMPUTER INC.",
        "00:20:84": "OCE PRINTING SYSTEMS, GMBH",
        "00:20:8C": "GALAXY NETWORKS, INC.",
        "00:20:2C": "WELLTRONIX CO., LTD.",
        "00:20:21": "ALGORITHMS SOFTWARE PVT. LTD.",
        "00:C0:F9": "Artesyn Embedded Technologies",
        "00:C0:75": "XANTE CORPORATION",
        "00:1C:7C": "PERQ SYSTEMS CORPORATION",
        "00:C0:39": "Teridian Semiconductor Corporation",
        "00:C0:A9": "BARRON MCCANN LTD.",
        "00:C0:4B": "CREATIVE MICROSYSTEMS",
        "00:C0:B9": "FUNK SOFTWARE, INC.",
        "00:C0:15": "NEW MEDIA CORPORATION",
        "00:C0:83": "TRACE MOUNTAIN PRODUCTS, INC.",
        "00:C0:94": "VMX INC.",
        "00:C0:19": "LEAP TECHNOLOGY, INC.",
        "00:C0:CF": "IMATRAN VOIMA OY",
        "00:C0:7D": "RISC DEVELOPMENTS LTD.",
        "00:C0:43": "STRATACOM",
        "00:C0:B5": "CORPORATE NETWORK SYSTEMS,INC.",
        "00:C0:ED": "US ARMY ELECTRONIC",
        "00:C0:32": "I-CUBED LIMITED",
        "00:C0:A5": "DICKENS DATA SYSTEMS",
        "00:C0:EF": "ABIT CORPORATION",
        "00:C0:61": "SOLECTEK CORPORATION",
        "00:C0:AD": "MARBEN COMMUNICATION SYSTEMS",
        "00:C0:7F": "NUPON COMPUTING CORP.",
        "00:C0:57": "MYCO ELECTRONICS",
        "00:C0:56": "SOMELEC",
        "00:C0:27": "CIPHER SYSTEMS, INC.",
        "00:C0:5C": "ELONEX PLC",
        "00:C0:28": "JASCO CORPORATION",
        "00:C0:8D": "TRONIX PRODUCT DEVELOPMENT",
        "00:C0:2A": "OHKURA ELECTRIC CO., LTD.",
        "00:C0:FC": "ELASTIC REALITY, INC.",
        "00:C0:BB": "FORVAL CREATIVE, INC.",
        "00:C0:E0": "DSC COMMUNICATION CORP.",
        "00:C0:5B": "NETWORKS NORTHWEST, INC.",
        "00:C0:08": "SECO SRL",
        "00:C0:B7": "AMERICAN POWER CONVERSION CORP",
        "00:C0:D3": "OLYMPUS IMAGE SYSTEMS, INC.",
        "00:C0:E8": "PLEXCOM, INC.",
        "00:C0:DA": "NICE SYSTEMS LTD.",
        "00:C0:D1": "COMTREE TECHNOLOGY CORPORATION",
        "00:C0:38": "RASTER IMAGE PROCESSING SYSTEM",
        "00:40:9B": "HAL COMPUTER SYSTEMS INC.",
        "00:40:EB": "MARTIN MARIETTA CORPORATION",
        "00:40:BD": "STARLIGHT NETWORKS, INC.",
        "00:40:ED": "NETWORK CONTROLS INT'NATL INC.",
        "00:40:21": "RASTER GRAPHICS",
        "00:40:C1": "BIZERBA-WERKE WILHEIM KRAUT",
        "00:40:E1": "MARNER INTERNATIONAL, INC.",
        "00:40:FE": "SYMPLEX COMMUNICATIONS",
        "00:40:E5": "SYBUS CORPORATION",
        "00:40:A5": "CLINICOMP INTL.",
        "00:40:05": "ANI COMMUNICATIONS INC.",
        "00:40:D9": "AMERICAN MEGATRENDS INC.",
        "00:40:4C": "HYPERTEC PTY LTD.",
        "00:C0:30": "INTEGRATED ENGINEERING B. V.",
        "00:C0:A6": "EXICOM AUSTRALIA PTY. LTD",
        "00:C0:CB": "CONTROL TECHNOLOGY CORPORATION",
        "00:C0:EB": "SEH COMPUTERTECHNIK GMBH",
        "00:40:DB": "ADVANCED TECHNICAL SOLUTIONS",
        "00:C0:92": "MENNEN MEDICAL INC.",
        "00:C0:52": "BURR-BROWN",
        "00:40:0E": "MEMOTEC, INC.",
        "00:C0:3D": "WIESEMANN & THEIS GMBH",
        "00:40:C8": "MILAN TECHNOLOGY CORPORATION",
        "00:40:BA": "ALLIANT COMPUTER SYSTEMS CORP.",
        "00:40:38": "TALENT ELECTRIC INCORPORATED",
        "00:40:D8": "OCEAN OFFICE AUTOMATION LTD.",
        "00:40:88": "MOBIUS TECHNOLOGIES, INC.",
        "00:40:32": "DIGITAL COMMUNICATIONS",
        "00:40:C2": "APPLIED COMPUTING DEVICES",
        "00:40:D4": "GAGE TALKER CORP.",
        "00:40:CE": "NET-SOURCE, INC.",
        "00:40:62": "E-SYSTEMS, INC./GARLAND DIV.",
        "00:40:34": "BUSTEK CORPORATION",
        "00:40:1C": "AST RESEARCH, INC.",
        "00:40:0F": "DATACOM TECHNOLOGIES",
        "00:40:06": "SAMPO TECHNOLOGY CORPORATION",
        "00:80:AA": "MAXPEED",
        "00:C0:50": "TOYO DENKI SEIZO K.K.",
        "00:40:C6": "FIBERNET RESEARCH, INC.",
        "00:40:47": "WIND RIVER SYSTEMS",
        "00:40:50": "IRONICS, INCORPORATED",
        "00:80:92": "Silex Technology, Inc.",
        "00:80:93": "XYRON CORPORATION",
        "00:80:5A": "TULIP COMPUTERS INTERNAT'L B.V",
        "00:40:41": "FUJIKURA LTD.",
        "00:80:4E": "APEX COMPUTER COMPANY",
        "00:80:55": "FERMILAB",
        "00:80:2A": "TEST SYSTEMS & SIMULATIONS INC",
        "00:80:35": "TECHNOLOGY WORKS, INC.",
        "00:80:7E": "SOUTHERN PACIFIC LTD.",
        "00:80:EF": "RATIONAL",
        "00:80:F0": "Panasonic Communications Co., Ltd.",
        "00:80:1D": "INTEGRATED INFERENCE MACHINES",
        "00:80:75": "PARSYTEC GMBH",
        "00:80:51": "FIBERMUX",
        "00:80:C6": "NATIONAL DATACOMM CORPORATION",
        "00:80:C0": "PENRIL DATACOMM",
        "00:80:2E": "CASTLE ROCK COMPUTING",
        "00:80:F2": "RAYCOM SYSTEMS INC",
        "00:80:BD": "THE FURUKAWA ELECTRIC CO., LTD",
        "00:80:25": "Telit Wireless Solutions GmbH",
        "00:80:EA": "ADVA Optical Networking Ltd.",
        "00:00:1E": "TELSIST INDUSTRIA ELECTRONICA",
        "00:00:50": "RADISYS CORPORATION",
        "00:80:04": "ANTLOW COMMUNICATIONS, LTD.",
        "00:80:D0": "COMPUTER PERIPHERALS, INC.",
        "00:80:24": "KALPANA, INC.",
        "00:80:40": "JOHN FLUKE MANUFACTURING CO.",
        "00:80:21": "Alcatel Canada Inc.",
        "00:80:E8": "CUMULUS CORPORATIION",
        "00:80:69": "COMPUTONE SYSTEMS",
        "00:80:0D": "VOSSWINKEL F.U.",
        "00:80:D1": "KIMTRON CORPORATION",
        "00:80:42": "Artesyn Embedded Technologies",
        "00:80:9A": "NOVUS NETWORKS LTD",
        "00:80:00": "MULTITECH SYSTEMS, INC.",
        "00:80:ED": "IQ TECHNOLOGIES, INC.",
        "00:80:4A": "PRO-LOG",
        "00:00:66": "TALARIS SYSTEMS, INC.",
        "00:00:49": "APRICOT COMPUTERS, LTD",
        "00:00:FA": "MICROSAGE COMPUTER SYSTEMS INC",
        "00:00:D4": "PURE DATA LTD.",
        "00:00:19": "APPLIED DYNAMICS INTERNATIONAL",
        "00:00:15": "DATAPOINT CORPORATION",
        "00:00:1C": "BELL TECHNOLOGIES",
        "00:00:34": "NETWORK RESOURCES CORPORATION",
        "00:00:22": "VISUAL TECHNOLOGY INC.",
        "00:00:B5": "DATABILITY SOFTWARE SYS. INC.",
        "00:00:2F": "TIMEPLEX INC.",
        "00:00:B8": "SEIKOSHA CO., LTD.",
        "00:00:E6": "APTOR PRODUITS DE COMM INDUST",
        "00:00:84": "SUPERNET",
        "00:00:9A": "RC COMPUTER A/S",
        "00:00:27": "JAPAN RADIO COMPANY",
        "00:00:E8": "ACCTON TECHNOLOGY CORP.",
        "00:00:4B": "ICL DATA OY",
        "00:00:E0": "QUADRAM CORP.",
        "00:00:AB": "LOGIC MODELING CORPORATION",
        "00:80:AC": "IMLOGIX, DIVISION OF GENESYS",
        "00:00:4F": "LOGICRAFT, INC.",
        "00:00:6F": "Madge Ltd.",
        "00:00:78": "LABTAM LIMITED",
        "00:00:5A": "SysKonnect GmbH",
        "00:00:5B": "ELTEC ELEKTRONIK AG",
        "00:00:71": "ADRA SYSTEMS INC.",
        "00:00:73": "SIECOR CORPORATION",
        "00:00:B9": "MCDONNELL DOUGLAS COMPUTER SYS",
        "00:00:BF": "SYMMETRIC COMPUTER SYSTEMS",
        "00:00:2D": "CHROMATICS INC",
        "00:00:18": "WEBSTER COMPUTER CORPORATION",
        "00:00:C8": "ALTOS COMPUTER SYSTEMS",
        "00:00:D5": "MICROGNOSIS INTERNATIONAL",
        "00:00:3A": "CHYRON CORPORATION",
        "00:00:59": "Hellige GMBH",
        "00:00:69": "CONCORD COMMUNICATIONS INC",
        "00:00:E7": "Star Gate Technologies",
        "00:00:4D": "DCI CORPORATION",
        "00:00:23": "ABB INDUSTRIAL SYSTEMS AB",
        "00:00:BE": "THE NTI GROUP",
        "00:00:D9": "NIPPON TELEGRAPH & TELEPHONE",
        "00:00:80": "CRAY COMMUNICATIONS A/S",
        "08:00:2A": "MOSAIC TECHNOLOGIES INC.",
        "08:00:89": "Kinetics",
        "08:00:86": "KONICA MINOLTA HOLDINGS, INC.",
        "08:00:83": "Seiko Instruments Inc.",
        "08:00:61": "JAROGATE LTD.",
        "08:00:5F": "SABER TECHNOLOGY CORP.",
        "08:00:58": "SYSTEMS CONCEPTS",
        "08:00:49": "UNIVATION",
        "08:00:24": "10NET COMMUNICATIONS/DCA",
        "08:00:22": "NBI INC.",
        "08:00:20": "Oracle Corporation",
        "08:00:1F": "SHARP CORPORATION",
        "08:00:14": "EXCELAN",
        "AA:00:00": "DIGITAL EQUIPMENT CORPORATION",
        "AA:00:01": "DIGITAL EQUIPMENT CORPORATION",
        "AA:00:02": "DIGITAL EQUIPMENT CORPORATION",
        "00:00:07": "XEROX CORPORATION",
        "00:80:1F": "KRUPP ATLAS ELECTRONIK GMBH",
        "08:00:06": "SIEMENS AG",
        "04:E0:C4": "TRIUMPH-ADLER AG",
        "02:07:01": "RACAL-DATACOM",
        "08:00:13": "Exxon",
        "00:DD:08": "UNGERMANN-BASS INC.",
        "00:00:05": "XEROX CORPORATION",
        "02:1C:7C": "PERQ SYSTEMS CORPORATION",
        "08:00:65": "GENRAD INC.",
        "84:A9:EA": "Career Technologies USA",
        "00:00:09": "XEROX CORPORATION",
        "00:80:E9": "Madge Ltd.",
        "00:40:D6": "LOCAMATION B.V.",
        "08:00:4B": "Planning Research Corp.",
        "02:AA:3C": "OLIVETTI TELECOMM SPA (OLTECO)",
        "08:00:59": "A/S MYCRON",
        "08:00:08": "BOLT BERANEK AND NEWMAN INC.",
        "F4:74:88": "New H3C Technologies Co., Ltd",
        "FC:C2:33": "ASUSTek COMPUTER INC.",
        "40:11:75": "IEEE Registration Authority",
        "80:31:F0": "Samsung Electronics Co.,Ltd",
        "58:35:26": "DEEPLET TECHNOLOGY CORP",
        "34:B5:A3": "CIG SHANGHAI CO LTD",
        "6C:1D:EB": "u-blox AG",
        "28:52:F9": "Zhongxin Intelligent Times (Shenzhen) Co., Ltd.",
        "B8:F8:53": "Arcadyan Corporation",
        "E0:D0:83": "Samsung Electronics Co.,Ltd",
        "74:3C:18": "Taicang T&W Electronics",
        "4C:80:BA": "Wuhan Tianyu Information Industry Co., Ltd.",
        "8C:02:FA": "COMMANDO Networks Limited",
        "F0:26:4C": "Sigrist-Photometer AG",
        "D8:0B:9A": "Samsung Electronics Co.,Ltd",
        "AC:8D:34": "HUAWEI TECHNOLOGIES CO.,LTD",
        "64:52:99": "The Chamberlain Group, Inc",
        "F8:75:A4": "LCFC(HeFei) Electronics Technology co., ltd",
        "00:D2:B1": "TPV Display Technology (Xiamen) Co.,Ltd.",
        "C0:E4:34": "AzureWave Technology Inc.",
        "6C:71:0D": "Cisco Systems, Inc",
        "24:6F:8C": "Huawei Device Co., Ltd.",
        "1C:13:86": "Huawei Device Co., Ltd.",
        "BC:2E:F6": "Huawei Device Co., Ltd.",
        "44:55:C4": "Huawei Device Co., Ltd.",
        "00:08:29": "TOKYO ELECTRON DEVICE NAGASAKI LIMITED",
        "1C:44:55": "Sieb & Meyer AG",
        "F8:8A:5E": "Texas Instruments",
        "5C:E7:A0": "Nokia",
        "E0:1F:88": "Xiaomi Communications Co Ltd",
        "8C:DC:02": "zte corporation",
        "B4:BC:7C": "Texas Instruments",
        "E0:AA:B0": "SUNTAILI ENTERPRISE CO. LTD,",
        "68:39:43": "ittim",
        "10:C6:5E": "Adapt-IP",
        "7C:A7:B0": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
        "20:31:1C": "vivo Mobile Communication Co., Ltd.",
        "10:4F:58": "Aruba, a Hewlett Packard Enterprise Company",
        "B4:E8:42": "Hong Kong Bouffalo Lab Limited",
        "00:03:CB": "SystemGear Co., Ltd.",
        "F0:A7:B2": "FUTABA CORPORATION",
        "60:9B:2D": "JMACS Japan Co., Ltd.",
        "14:A3:2F": "Huawei Device Co., Ltd.",
        "04:D3:B5": "Huawei Device Co., Ltd.",
        "00:BB:1C": "Huawei Device Co., Ltd.",
        "80:AC:7C": "Sichuan AI-Link Technology Co., Ltd.",
        "DC:4B:FE": "Shenzhen Belon Technology CO.,LTD",
        "50:62:55": "IEEE Registration Authority",
        "58:D5:0A": "Murata Manufacturing Co., Ltd.",
        "88:A3:03": "Samsung Electronics Co.,Ltd",
        "FC:DE:90": "Samsung Electronics Co.,Ltd",
        "18:54:CF": "Samsung Electronics Co.,Ltd",
        "80:79:5D": "Infinix mobility limited",
        "E8:84:C6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "64:2C:AC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "08:CC:27": "Motorola Mobility LLC, a Lenovo Company",
        "04:D3:95": "Motorola Mobility LLC, a Lenovo Company",
        "E0:98:06": "Espressif Inc.",
        "F4:CF:A2": "Espressif Inc.",
        "F8:1E:6F": "EBG compleo GmbH",
        "F0:A3:5A": "Apple, Inc.",
        "60:83:73": "Apple, Inc.",
        "84:AD:8D": "Apple, Inc.",
        "74:42:8B": "Apple, Inc.",
        "14:91:38": "Amazon Technologies Inc.",
        "6C:41:0E": "Cisco Systems, Inc",
        "6C:31:0E": "Cisco Systems, Inc",
        "28:77:F1": "Apple, Inc.",
        "A8:E7:7D": "Texas Instruments",
        "DC:54:3D": "ITEL MOBILE LIMITED",
        "0C:84:47": "Fiberhome Telecommunication Technologies Co.,LTD",
        "9C:6B:72": "Realme Chongqing MobileTelecommunications Corp Ltd",
        "50:C6:AD": "Fiberhome Telecommunication Technologies Co.,LTD",
        "74:8A:28": "HMD Global Oy",
        "D4:24:93": "GW Technologies Co.,Ltd",
        "00:23:E6": "Innovation Farm, Inc.",
        "EC:A9:40": "ARRIS Group, Inc.",
        "FC:85:96": "Axonne Inc.",
        "5C:B4:E2": "Inspur Software Group Ltd.",
        "3C:51:0E": "Cisco Systems, Inc",
        "D8:AE:D0": "Shanghai Engineering Science & Technology Co.,LTD CGNPC",
        "E0:85:9A": "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD.",
        "0C:42:A1": "Mellanox Technologies, Inc.",
        "B4:7A:F1": "Hewlett Packard Enterprise",
        "34:9F:7B": "CANON INC.",
        "F4:D9:C6": "UNIONMAN TECHNOLOGY CO.,LTD",
        "34:F1:50": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "CC:52:89": "SHENZHEN OPTFOCUS TECHNOLOGY.,LTD",
        "CC:5D:78": "JTD Consulting",
        "BC:F9:F2": "TEKO",
        "00:0E:A4": "Quantum Corp.",
        "00:50:84": "Quantum Corp.",
        "80:9F:9B": "Sichuan AI-Link Technology Co., Ltd.",
        "A8:2B:CD": "HUAWEI TECHNOLOGIES CO.,LTD",
        "48:DC:2D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "AC:EB:51": "Universal Electronics, Inc.",
        "60:10:A2": "Crompton Instruments",
        "C4:B2:39": "Cisco Systems, Inc",
        "B0:A4:54": "Tripwire Inc.",
        "64:90:C1": "Beijing Xiaomi Mobile Software Co., Ltd",
        "CC:5C:DE": "China Mobile Group Device Co.,Ltd.",
        "60:CE:86": "Sercomm Corporation.",
        "4C:4F:EE": "OnePlus Technology (Shenzhen) Co., Ltd",
        "4C:E1:75": "Cisco Systems, Inc",
        "A8:24:B8": "Nokia",
        "90:55:DE": "Fiberhome Telecommunication Technologies Co.,LTD",
        "E8:91:0F": "Fiberhome Telecommunication Technologies Co.,LTD",
        "D0:05:E4": "Huawei Device Co., Ltd.",
        "30:AA:E4": "Huawei Device Co., Ltd.",
        "14:AB:56": "WUXI FUNIDE DIGITAL CO.,LTD",
        "E8:D8:D1": "HP Inc.",
        "28:CD:C4": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "00:0C:DF": "JAI Manufacturing",
        "2C:91:AB": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "80:7B:3E": "Samsung Electronics Co.,Ltd",
        "F8:F1:E6": "Samsung Electronics Co.,Ltd",
        "88:A9:B7": "Apple, Inc.",
        "EC:CE:D7": "Apple, Inc.",
        "48:EB:62": "Murata Manufacturing Co., Ltd.",
        "5C:E1:76": "Cisco Systems, Inc",
        "AC:90:85": "Apple, Inc.",
        "34:48:ED": "Dell Inc.",
        "3C:57:31": "Cisco Systems, Inc",
        "6C:55:E8": "Technicolor CH USA Inc.",
        "34:2F:BD": "Nintendo Co.,Ltd",
        "A0:2D:13": "AirTies Wireless Networks",
        "84:68:C8": "TOTOLINK TECHNOLOGY INT‘L LIMITED",
        "9C:28:F7": "Xiaomi Communications Co Ltd",
        "10:52:1C": "Espressif Inc.",
        "6C:42:AB": "Subscriber Networks, Inc.",
        "64:F6:F7": "Anhui Dynamic Power Co., Ltd.",
        "94:1C:56": "Actiontec Electronics, Inc",
        "D8:0B:CB": "Telink Semiconductor (Shanghai) Co., Ltd.",
        "F0:F0:A4": "Amazon Technologies Inc.",
        "C0:D6:82": "Arista Networks",
        "CC:2D:1B": "SFR",
        "80:E5:40": "ARRIS Group, Inc.",
        "00:0D:B4": "Stormshield",
        "2C:F0:5D": "Micro-Star INTL CO., LTD.",
        "94:3B:B0": "New H3C Technologies Co., Ltd",
        "90:43:E2": "Cornami, Inc",
        "80:30:49": "Liteon Technology Corporation",
        "E8:49:43": "YUGE Information technology Co. Ltd",
        "50:14:08": "AiNET",
        "28:9A:F7": "ADVA Optical Networking Ltd.",
        "B0:B1:94": "zte corporation",
        "10:C3:AB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "28:11:EC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E4:26:86": "DWnet Technologies(Suzhou) Corporation",
        "00:69:2D": "Sunnovo International Limited",
        "38:EB:47": "HUAWEI TECHNOLOGIES CO.,LTD",
        "0C:37:96": "BIZLINK TECHNOLOGY, INC.",
        "F4:03:2A": "Amazon Technologies Inc.",
        "14:77:40": "Huawei Device Co., Ltd.",
        "B4:15:7E": "Celona Inc.",
        "18:D9:8F": "Huawei Device Co., Ltd.",
        "64:5E:2C": "IRay Technology Co., Ltd.",
        "00:E0:EC": "CELESTICA INC.",
        "70:38:11": "Siemens Mobility Limited",
        "64:62:66": "IEEE Registration Authority",
        "48:7A:F6": "NCS ELECTRICAL SDN BHD",
        "48:6E:70": "Zhejiang Tmall Technology Co., Ltd.",
        "60:1D:9D": "Sichuan AI-Link Technology Co., Ltd.",
        "D8:5F:77": "Telink Semiconductor (Shanghai) Co., Ltd.",
        "2C:97:ED": "Sony Imaging Products & Solutions Inc.",
        "20:82:6A": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "B8:90:47": "Apple, Inc.",
        "90:9C:4A": "Apple, Inc.",
        "90:8C:43": "Apple, Inc.",
        "18:8A:6A": "AVPro Global Hldgs",
        "3C:7D:0A": "Apple, Inc.",
        "D4:8A:39": "Samsung Electronics Co.,Ltd",
        "E4:F3:C4": "Samsung Electronics Co.,Ltd",
        "9C:2F:4E": "zte corporation",
        "F0:10:90": "New H3C Technologies Co., Ltd",
        "08:BF:A0": "Samsung Electronics Co.,Ltd",
        "70:1F:3C": "Samsung Electronics Co.,Ltd",
        "20:50:E7": "AMPAK Technology,Inc.",
        "D8:A8:C8": "zte corporation",
        "38:22:E2": "HP Inc.",
        "08:C0:EB": "Mellanox Technologies, Inc.",
        "E4:E1:12": "Texas Instruments",
        "34:14:B5": "Texas Instruments",
        "D0:03:EB": "Texas Instruments",
        "94:DB:56": "Sony Home Entertainment&Sound Products Inc",
        "88:9E:68": "Technicolor CH USA Inc.",
        "64:09:AC": "TCT mobile ltd",
        "74:3A:EF": "Kaonmedia CO., LTD.",
        "18:9E:2C": "Huawei Device Co., Ltd.",
        "5C:55:78": "iryx corp",
        "4C:C5:3E": "Zyxel Communications Corporation",
        "90:56:FC": "TECNO MOBILE LIMITED",
        "B8:63:92": "GUANGDONG GENIUS TECHNOLOGY CO., LTD.",
        "68:B9:D3": "Shenzhen Trolink Technology CO, LTD",
        "B8:C6:AA": "Earda Technologies co Ltd",
        "54:AE:D0": "DASAN Networks, Inc. ",
        "10:70:FD": "Mellanox Technologies, Inc.",
        "38:F6:01": "Solid State Storage Technology Corporation",
        "40:DE:AD": "Juniper Networks",
        "40:F5:20": "Espressif Inc.",
        "78:AA:82": "New H3C Technologies Co., Ltd",
        "20:6C:8A": "Extreme Networks, Inc.",
        "34:85:84": "Extreme Networks, Inc.",
        "40:18:B1": "Extreme Networks, Inc.",
        "88:5B:DD": "Extreme Networks, Inc.",
        "98:ED:5C": "Tesla,Inc.",
        "C4:42:68": "CRESTRON ELECTRONICS, INC.",
        "54:71:DD": "Huawei Device Co., Ltd.",
        "E4:A7:49": "Palo Alto Networks",
        "84:D6:C5": "SolarEdge Technologies",
        "D8:91:36": "Dover Fueling Solutions",
        "C8:83:14": "Tempo Communications",
        "B8:E3:EE": "Universal Electronics, Inc.",
        "24:C8:D3": "McWane India Pvt Ltd",
        "60:54:64": "Eyedro Green Solutions Inc.",
        "FC:95:6A": "OCTAGON SYSTEMS CORP.",
        "40:B3:1E": "Universal Electronics, Inc.",
        "88:40:33": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E0:F6:B5": "Nintendo Co.,Ltd",
        "AC:7A:56": "Cisco Systems, Inc",
        "44:8D:BF": "Rhino Mobility LLC",
        "94:8A:C6": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "C0:A6:6D": "Inspur Group Co., Ltd.",
        "70:F0:96": "Cisco Systems, Inc",
        "00:20:A6": "Proxim Wireless",
        "58:50:ED": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "00:05:1E": "Brocade Communications Systems LLC",
        "98:8B:0A": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "BC:BA:C2": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "AC:CB:51": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "E0:D4:62": "Huawei Device Co., Ltd.",
        "90:98:38": "Huawei Device Co., Ltd.",
        "84:CC:A8": "Espressif Inc.",
        "C4:F5:7C": "Brocade Communications Systems LLC",
        "00:12:F2": "Brocade Communications Systems LLC",
        "6C:2F:8A": "Samsung Electronics Co.,Ltd",
        "F0:B0:22": "TOHO Electronics INC.",
        "98:7E:CA": "Inventus Power Eletronica do Brasil LTDA",
        "2C:9F:FB": "Wistron Neweb Corporation",
        "50:38:2F": "ASE Group Chung-Li",
        "0C:14:D2": "China Mobile Group Device Co.,Ltd.",
        "D4:F8:29": "Sagemcom Broadband SAS",
        "E0:62:34": "Texas Instruments",
        "70:8C:BB": "MIMODISPLAYKOREA",
        "B8:48:AA": "EM Microelectronic",
        "F8:57:2E": "Core Brands, LLC",
        "00:1C:91": "Gefen LLC",
        "24:4B:FE": "ASUSTek COMPUTER INC.",
        "7C:DD:E9": "ATOM tech Inc.",
        "F8:6B:D9": "Cisco Systems, Inc",
        "C0:14:FE": "Cisco Systems, Inc",
        "7C:AD:4F": "Cisco Systems, Inc",
        "08:31:A4": "Huawei Device Co., Ltd.",
        "A8:E9:78": "Huawei Device Co., Ltd.",
        "F8:2F:65": "Huawei Device Co., Ltd.",
        "28:B3:71": "Ruckus Wireless",
        "08:AC:C4": "FMTech",
        "DC:50:3A": "Nanjing Ticom Tech Co., Ltd.",
        "18:47:3D": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "D4:77:B2": "Netix Global B.V.",
        "70:B5:E8": "Dell Inc.",
        "94:25:33": "HUAWEI TECHNOLOGIES CO.,LTD",
        "60:56:61": "IXECLOUD Tech",
        "0C:59:9C": "Juniper Networks",
        "44:F4:E7": "Cohesity Inc",
        "70:69:79": "IEEE Registration Authority",
        "FC:60:9B": "New H3C Technologies Co., Ltd",
        "E8:A1:F8": "zte corporation",
        "98:A9:42": "Guangzhou Tozed Kangwei Intelligent Technology Co., LTD",
        "30:42:40": "zte corporation",
        "4C:21:13": "Nokia Shanghai Bell Co., Ltd.",
        "80:2D:BF": "Cisco Systems, Inc",
        "24:F1:50": "Guangzhou Qi'an Technology Co., Ltd.",
        "10:8B:6A": "Antailiye Technology Co.,Ltd",
        "14:C8:8B": "Apple, Inc.",
        "EC:26:51": "Apple, Inc.",
        "18:3E:EF": "Apple, Inc.",
        "60:7E:C9": "Apple, Inc.",
        "40:88:2F": "Extreme Networks, Inc.",
        "E4:3D:1A": "Broadcom Limited",
        "64:4C:36": "Intel Corporate",
        "48:89:E7": "Intel Corporate",
        "24:EE:9A": "Intel Corporate",
        "5C:87:9C": "Intel Corporate",
        "50:EB:71": "Intel Corporate",
        "0C:DD:24": "Intel Corporate",
        "94:B8:6D": "Intel Corporate",
        "20:16:B9": "Intel Corporate",
        "38:BA:F8": "Intel Corporate",
        "3C:6A:A7": "Intel Corporate",
        "34:E1:2D": "Intel Corporate",
        "00:BB:60": "Intel Corporate",
        "60:F6:77": "Intel Corporate",
        "A0:88:69": "Intel Corporate",
        "74:E5:F9": "Intel Corporate",
        "80:00:0B": "Intel Corporate",
        "34:41:5D": "Intel Corporate",
        "FC:77:74": "Intel Corporate",
        "98:2C:BC": "Intel Corporate",
        "3C:F0:11": "Intel Corporate",
        "28:7F:CF": "Intel Corporate",
        "80:32:53": "Intel Corporate",
        "D8:C0:A6": "AzureWave Technology Inc.",
        "9C:FC:E8": "Intel Corporate",
        "F8:AC:65": "Intel Corporate",
        "10:12:FB": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "F0:9B:B8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "BC:17:B8": "Intel Corporate",
        "B8:CB:29": "Dell Inc.",
        "44:BB:3B": "Google, Inc.",
        "14:C1:4E": "Google, Inc.",
        "8C:5E:BD": "Huawei Device Co., Ltd.",
        "2C:A0:42": "Huawei Device Co., Ltd.",
        "EC:C0:1B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "98:44:CE": "HUAWEI TECHNOLOGIES CO.,LTD",
        "CC:D0:83": "Aruba, a Hewlett Packard Enterprise Company",
        "C0:83:C9": "Huawei Device Co., Ltd.",
        "C0:1C:30": "Shenzhen WIFI-3L Technology Co.,Ltd",
        "D8:C6:78": "MitraStar Technology Corp.",
        "44:1C:7F": "Motorola Mobility LLC, a Lenovo Company",
        "00:B8:B6": "Motorola Mobility LLC, a Lenovo Company",
        "1C:E6:1D": "Samsung Electronics Co.,Ltd",
        "80:12:DF": "Shenzhen SuperElectron Technology Co.,Ltd.",
        "10:E7:7A": "STMicrolectronics International NV",
        "80:EA:07": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "BC:03:A7": "MFP MICHELIN",
        "90:76:9F": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "98:2F:F8": "Huawei Device Co., Ltd.",
        "40:DC:A5": "Huawei Device Co., Ltd.",
        "2C:6F:51": "Herospeed Digital Technology Limited",
        "04:A2:F3": "Fiberhome Telecommunication Technologies Co.,LTD",
        "CC:DB:93": "Cisco Systems, Inc",
        "54:48:E6": "Beijing Xiaomi Mobile Software Co., Ltd",
        "60:D4:E9": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "30:C5:0F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "28:68:D2": "HUAWEI TECHNOLOGIES CO.,LTD",
        "90:A9:35": "JWEntertainment",
        "1C:D6:BE": "Wistron Neweb Corporation",
        "28:D1:27": "Beijing Xiaomi Mobile Software Co., Ltd",
        "C8:68:DE": "Huawei Device Co., Ltd.",
        "D0:0D:F7": "Huawei Device Co., Ltd.",
        "48:05:E2": "Huawei Device Co., Ltd.",
        "F8:1B:04": "Zhong Shan City Richsound Electronic Industrial Ltd",
        "D8:8C:79": "Google, Inc.",
        "10:34:1B": "Spacelink",
        "30:A4:52": "Arrival Elements BV",
        "00:1E:68": "Quanta Computer Inc.",
        "00:23:8B": "Quanta Computer Inc.",
        "2C:60:0C": "Quanta Computer Inc.",
        "8C:C5:B4": "Sagemcom Broadband SAS",
        "00:0B:A2": "Sumitomo Electric Industries, Ltd",
        "00:08:F6": "Sumitomo Electric Industries, Ltd",
        "00:00:5F": "Sumitomo Electric Industries, Ltd",
        "18:EC:E7": "BUFFALO.INC",
        "F4:69:D5": "IEEE Registration Authority",
        "08:3A:F2": "Espressif Inc.",
        "74:3A:20": "New H3C Technologies Co., Ltd",
        "30:C9:AB": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "3C:1A:9E": "VitalThings AS",
        "C4:D7:38": "Huawei Device Co., Ltd.",
        "C8:84:A1": "Cisco Systems, Inc",
        "D8:77:8B": "Intelbras",
        "00:03:E8": "Wavesight Limited",
        "6C:BA:B8": "Sagemcom Broadband SAS",
        "E0:D4:64": "Intel Corporate",
        "C0:F6:C2": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D4:AF:F7": "Arista Networks",
        "60:07:7C": "Jala Group",
        "60:98:66": "Texas Instruments",
        "04:7E:23": "China Mobile IOT Company Limited",
        "14:CC:B3": "AO GK NATEKS",
        "DC:CD:2F": "Seiko Epson Corporation",
        "94:54:CE": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "38:8A:BE": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "68:93:20": "New H3C Technologies Co., Ltd",
        "54:84:DC": "zte corporation",
        "38:54:9B": "zte corporation",
        "08:42:96": "Mobile Technology Solutions LLC",
        "34:3E:A4": "Ring LLC",
        "04:C1:D8": "Huawei Device Co., Ltd.",
        "C8:BC:9C": "Huawei Device Co., Ltd.",
        "B0:FE:E5": "Huawei Device Co., Ltd.",
        "C8:17:39": "ITEL MOBILE LIMITED",
        "58:D0:61": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:EF:B6": "Edgecore Networks Corporation",
        "E8:74:C7": "Sentinhealth",
        "00:1C:7B": "Castlenet Technology Inc.",
        "E4:84:2B": "HANGZHOU SOFTEL OPTIC CO., LTD",
        "B8:D3:09": "Cox Communications, Inc",
        "94:02:6B": "Optictimes Co.,Ltd",
        "D4:6A:91": "SnapAV",
        "80:EE:25": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "44:87:DB": "Tymphany Acoustic Technology (Huizhou) Co.,  Ltd.",
        "D0:3D:52": "Ava Security Limited",
        "F4:90:EA": "Deciso B.V.",
        "64:D2:C4": "Apple, Inc.",
        "DC:52:85": "Apple, Inc.",
        "E8:81:52": "Apple, Inc.",
        "90:81:58": "Apple, Inc.",
        "B4:AD:A3": "Guangzhou Shiyuan Electronic Technology Company Limited",
        "64:23:15": "Huawei Device Co., Ltd.",
        "A4:C7:4B": "Huawei Device Co., Ltd.",
        "D0:D2:3C": "Apple, Inc.",
        "78:E3:DE": "Apple, Inc.",
        "18:FD:CB": "IEEE Registration Authority",
        "D4:48:2D": "Shenzhen Deejoy Lighting Technology Co.,Ltd.",
        "D8:F8:AF": "DAONTEC",
        "40:8C:4C": "Shenzhen MiaoMing  Intelligent Technology Co.,Ltd",
        "6C:AD:AD": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "CC:E0:DA": "Baidu Online Network Technology (Beijing) Co., Ltd",
        "14:1B:30": "Shenzhen Yipingfang Network Technology Co., Ltd.",
        "F4:6F:ED": "Fiberhome Telecommunication Technologies Co.,LTD",
        "94:B9:7E": "Espressif Inc.",
        "A8:30:1C": "Qingdao Intelligent&Precise Electronics Co.,Ltd.",
        "D8:F3:BC": "Liteon Technology Corporation",
        "B8:47:7A": "Dasan Electron Co., Ltd.",
        "7C:78:B2": "Wyze Labs Inc",
        "D8:37:3B": "Shenzhen Jingxun Software Telecommunication Technology Co.,Ltd",
        "6C:2D:24": "Zhen Shi Information Technology (Shanghai) Co., Ltd.",
        "B8:AE:1C": "Smart Cube., Ltd",
        "80:03:84": "Ruckus Wireless",
        "FC:69:8C": "ANDREAS STIHL AG & Co. KG",
        "00:23:A7": "Redpine Signals, Inc.",
        "44:CE:3A": "Jiangsu Huacun Electronic Technology Co., Ltd.",
        "9C:1E:A4": "Renesas Electronics (Penang) Sdn. Bhd.",
        "4C:EF:56": "Shenzhen Sundray Technologies Company Limited",
        "E4:C3:2A": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "90:9A:4A": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "BC:97:89": "Huawei Device Co., Ltd.",
        "AC:12:2F": "Fantasia Trading LLC",
        "FC:45:C3": "Texas Instruments",
        "AC:6A:A3": "Shenzhen Kertong Technology Co.,Ltd",
        "E8:4F:4B": "Shenzhen Delos Electronic Co., Ltd",
        "B0:4A:39": "Beijing Roborock Technology Co., Ltd.",
        "A4:F9:E4": "AirVine Scientific, Inc.",
        "F4:4F:D3": "shenzhen hemuwei technology co.,ltd",
        "68:45:71": "Huawei Device Co., Ltd.",
        "84:93:A0": "Huawei Device Co., Ltd.",
        "9C:8E:9C": "Huawei Device Co., Ltd.",
        "40:14:AD": "Huawei Device Co., Ltd.",
        "A8:74:84": "zte corporation",
        "E0:4B:A6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C8:B6:D3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "FC:8D:3D": "Leapfive Tech. Ltd.",
        "00:23:86": "IMI Hydronic Engineering international SA",
        "A0:69:74": "Honor Device Co., Ltd.",
        "C0:33:DA": "Shenzhen JRUN Technologies CO., LTD",
        "60:70:72": "SHENZHEN HONGDE SMART LINK TECHNOLOGY CO., LTD",
        "DC:B7:FC": "Alps Electric (Ireland) Ltd",
        "AC:FA:A5": "digitron",
        "78:C9:5E": "Midmark RTLS ",
        "20:CD:6E": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "08:93:56": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:07:89": "Allradio Co., Ltd",
        "6C:14:6E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "44:E9:68": "HUAWEI TECHNOLOGIES CO.,LTD",
        "DC:4A:9E": "IEEE Registration Authority",
        "E0:C3:77": "Samsung Electronics Co.,Ltd",
        "4C:FB:F4": "Optimal Audio Ltd",
        "64:03:7F": "Samsung Electronics Co.,Ltd",
        "B4:9D:02": "Samsung Electronics Co.,Ltd",
        "80:9F:F5": "Samsung Electronics Co.,Ltd",
        "64:79:24": "Huawei Device Co., Ltd.",
        "D8:CC:98": "Huawei Device Co., Ltd.",
        "B8:87:6E": "Yandex Services AG",
        "F8:6D:73": "Zengge Co., Limited",
        "58:86:94": "EFM Networks",
        "AC:37:28": "Taicang T&W Electronics",
        "BC:99:30": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E8:68:E7": "Espressif Inc.",
        "D0:BC:C1": "WEIFANG GOERTEK ELECTRONICS CO.,LTD",
        "6C:E8:74": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C4:69:F0": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C0:94:35": "ARRIS Group, Inc.",
        "18:B6:CC": "We Corporation Inc.",
        "30:A0:23": "ROCK PATH S.R.L",
        "E8:48:B8": "TP-Link Corporation Limited",
        "78:CB:2C": "Join Digital, Inc.",
        "30:9E:1D": "OHSUNG",
        "68:79:12": "IEEE Registration Authority",
        "EC:64:88": "Honor Device Co., Ltd.",
        "74:D6:CB": "New H3C Technologies Co., Ltd",
        "0C:3A:FA": "New H3C Technologies Co., Ltd",
        "28:3B:82": "D-Link International",
        "0C:B6:D2": "D-Link International",
        "60:BE:C4": "Apple, Inc.",
        "F8:B1:DD": "Apple, Inc.",
        "F8:66:5A": "Apple, Inc.",
        "A8:81:7E": "Apple, Inc.",
        "8C:47:6E": "IEEE Registration Authority",
        "48:70:1E": "Texas Instruments",
        "E8:C3:20": "Austco Marketing & Service (USA) ltd.",
        "AC:33:28": "Huawei Device Co., Ltd.",
        "00:23:06": "ALPSALPINE CO,.LTD",
        "00:24:33": "ALPSALPINE CO,.LTD",
        "9C:8D:7C": "ALPSALPINE CO,.LTD",
        "00:16:FE": "ALPSALPINE CO,.LTD",
        "00:19:C1": "ALPSALPINE CO,.LTD",
        "D4:76:A0": "Fortinet, Inc.",
        "80:B9:7A": "eero inc.",
        "BC:75:36": "ALPSALPINE CO,.LTD",
        "58:16:D7": "ALPSALPINE CO,.LTD",
        "E0:75:0A": "ALPSALPINE CO,.LTD",
        "E0:AE:5E": "ALPSALPINE CO,.LTD",
        "60:8D:26": "Arcadyan Corporation",
        "B4:EC:02": "ALPSALPINE CO,.LTD",
        "E4:27:61": "Honor Device Co., Ltd.",
        "8C:F3:19": "Siemens Industrial Automation Products Ltd., Chengdu",
        "1C:39:29": "OHSUNG",
        "C8:A4:0D": "Cooler Master Technology Inc",
        "38:42:0B": "Sonos, Inc.",
        "C8:3A:6B": "Roku, Inc",
        "A4:53:EE": "IEEE Registration Authority",
        "8C:49:62": "Roku, Inc",
        "E0:2E:3F": "Huawei Device Co., Ltd.",
        "C4:BF:60": "TECNO MOBILE LIMITED",
        "D0:40:EF": "Murata Manufacturing Co., Ltd.",
        "8C:8C:AA": "LCFC(HeFei) Electronics Technology co., ltd",
        "90:CC:DF": "Intel Corporate",
        "08:5B:D6": "Intel Corporate",
        "B4:0E:DE": "Intel Corporate",
        "E0:2B:E9": "Intel Corporate",
        "BC:9A:53": "Huawei Device Co., Ltd.",
        "DC:27:27": "Huawei Device Co., Ltd.",
        "F0:42:F5": "Huawei Device Co., Ltd.",
        "4C:11:54": "Mobiwire Mobiles (NingBo) Co., LTD",
        "C8:E2:65": "Intel Corporate",
        "8C:8D:28": "Intel Corporate",
        "D0:56:BF": "AMOSENSE",
        "B4:B5:B6": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "04:7A:0B": "Beijing Xiaomi Electronics Co., Ltd.",
        "90:0F:0C": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "F0:A2:25": "Amazon Technologies Inc.",
        "BC:9D:42": "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD.",
        "4C:75:25": "Espressif Inc.",
        "74:04:F0": "Mobiwire Mobiles (NingBo) Co., LTD",
        "24:0B:88": "Taicang T&W Electronics",
        "0C:93:8F": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "78:F9:B4": "Nokia Solutions and Networks GmbH & Co. KG",
        "60:A8:FE": "Nokia Solutions and Networks GmbH & Co. KG",
        "D8:EF:CD": "Nokia Solutions and Networks GmbH & Co. KG",
        "6C:F7:12": "Nokia Solutions and Networks GmbH & Co. KG",
        "EC:75:ED": "Citrix Systems, Inc.",
        "5C:BD:9A": "Huawei Device Co., Ltd.",
        "8C:DE:E6": "Samsung Electronics Co.,Ltd",
        "10:EC:81": "Samsung Electronics Co.,Ltd",
        "C4:5D:83": "Samsung Electronics Co.,Ltd",
        "5C:A4:A4": "Fiberhome Telecommunication Technologies Co.,LTD",
        "14:A3:B4": "Huawei Device Co., Ltd.",
        "9C:9C:1F": "Espressif Inc.",
        "D8:09:D6": "ZEXELON CO., LTD.",
        "E8:6D:E9": "HUAWEI TECHNOLOGIES CO.,LTD",
        "14:46:58": "HUAWEI TECHNOLOGIES CO.,LTD",
        "58:BE:72": "HUAWEI TECHNOLOGIES CO.,LTD",
        "10:8F:FE": "HUAWEI TECHNOLOGIES CO.,LTD",
        "BC:D7:CE": "China Mobile (Hangzhou) Information Technology Co., Ltd.",
        "9C:A5:70": "eero inc.",
        "A0:41:2D": "Lansen Systems AB",
        "C4:39:60": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "98:BE:DC": "Honor Device Co., Ltd.",
        "44:B6:BE": "Cisco Systems, Inc",
        "00:A0:FB": "Toray Engineering D Solutions Co., Ltd.",
        "70:61:BE": "Wistron Neweb Corporation",
        "34:8A:12": "Aruba, a Hewlett Packard Enterprise Company",
        "84:D3:43": "Calix Inc.",
        "D8:47:BB": "Huawei Device Co., Ltd.",
        "C4:14:11": "Apple, Inc.",
        "CC:C9:5D": "Apple, Inc.",
        "38:B5:D3": "SecuWorks",
        "34:31:8F": "Apple, Inc.",
        "44:6F:D8": "IEEE Registration Authority",
        "C8:94:02": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "7C:B9:4C": "Bouffalo Lab (Nanjing) Co., Ltd.",
        "DC:15:C8": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "6C:D6:30": "Rootous System Co.,Ltd",
        "B8:07:56": "Cisco Meraki",
        "C8:33:E5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:56:FE": "Cisco Meraki",
        "B8:44:AE": "TCT mobile ltd",
        "E4:F7:5B": "ARRIS Group, Inc.",
        "F8:79:0A": "ARRIS Group, Inc.",
        "0C:CF:89": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
        "0C:8C:69": "Shenzhen elink smart Co., ltd",
        "D8:BB:C1": "Micro-Star INTL CO., LTD.",
        "AC:5A:FC": "Intel Corporate",
        "1C:93:7C": "ARRIS Group, Inc.",
        "58:FC:20": "Altice Labs S.A.",
        "58:FD:20": "Systemhouse Solutions AB",
        "04:D6:F4": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "04:90:81": "Pensando Systems, Inc.",
        "4C:79:6E": "Intel Corporate",
        "98:AD:1D": "Huawei Device Co., Ltd.",
        "F8:AA:3F": "DWnet Technologies(Suzhou) Corporation",
        "00:68:2B": "Huawei Device Co., Ltd.",
        "F0:9E:4A": "Intel Corporate",
        "F0:77:C3": "Intel Corporate",
        "24:9A:D8": "YEALINK(XIAMEN) NETWORK TECHNOLOGY CO.,LTD.",
        "D8:5E:D3": "GIGA-BYTE TECHNOLOGY CO.,LTD.",
        "00:E4:21": "Sony Interactive Entertainment Inc.",
        "CC:DB:04": "DataRemote Inc.",
        "E8:9F:39": "Nokia",
        "34:73:5A": "Dell Inc.",
        "98:1A:35": "HUAWEI TECHNOLOGIES CO.,LTD",
        "80:34:28": "Microchip Technology Inc.",
        "28:EF:01": "Amazon Technologies Inc.",
        "B0:22:7A": "HP Inc.",
        "60:A7:51": "Huawei Device Co., Ltd.",
        "10:2B:41": "Samsung Electronics Co.,Ltd",
        "34:4A:C3": "HuNan ZiKun Information Technology CO., Ltd",
        "68:2D:83": "SHENZHEN DINGHE COMMUNICATION COMPANY",
        "A8:43:97": "Innogrit Corporation",
        "D8:CD:2C": "WUXI NEIHUA NETWORK TECHNOLOGY CO., LTD",
        "08:47:4C": "Nokia",
        "90:C1:19": "Nokia",
        "7C:F8:80": "Cisco Systems, Inc",
        "E4:05:F8": "Bytedance",
        "F8:45:C4": "Shenzhen Netforward Micro-Electronic Co., Ltd.",
        "78:10:53": "China Mobile Group Device Co.,Ltd.",
        "00:08:0C": "VDA Group S.p.a.",
        "D0:97:FE": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "84:3A:5B": "Inventec(Chongqing) Corporation",
        "54:49:DF": "Peloton Interactive, Inc",
        "18:2A:57": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:3E:95": "HUAWEI TECHNOLOGIES CO.,LTD",
        "48:12:58": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D8:EB:46": "Google, Inc.",
        "2C:17:E0": "SYSTEMES ET TECHNOLOGIES IDENTIFICATION (STid)",
        "CC:32:96": "Huawei Device Co., Ltd.",
        "98:CD:AC": "Espressif Inc.",
        "80:8A:F7": "Nanoleaf",
        "B0:3D:C2": "Wasp artificial intelligence(Shenzhen) Co.,ltd",
        "C8:4D:34": "LIONS Taiwan Technology Inc.",
        "44:6F:F8": "Dyson Limited",
        "6C:1B:3F": "MiraeSignal Co., Ltd",
        "28:AF:FD": "Cisco Systems, Inc",
        "9C:76:13": "Ring LLC",
        "44:9B:C1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "20:25:D2": "Fiberhome Telecommunication Technologies Co.,LTD",
        "28:F4:9B": "LEETEK",
        "18:42:D4": "Wuhan Hosan Telecommunication Technology Co.,Ltd",
        "A8:63:7D": "D-Link International",
        "2C:43:BE": "Sunnovo International Limited",
        "58:10:B7": "Infinix mobility limited",
        "B0:24:91": "Huawei Device Co., Ltd.",
        "98:75:1A": "Huawei Device Co., Ltd.",
        "1C:91:80": "Apple, Inc.",
        "4C:B9:10": "Apple, Inc.",
        "B4:89:01": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E0:92:5C": "Apple, Inc.",
        "EC:15:3D": "Beijing Yaxunhongda Technology Co., Ltd.",
        "D8:A3:5C": "Samsung Electronics Co.,Ltd",
        "C0:92:96": "zte corporation",
        "50:E2:4E": "zte corporation",
        "4C:77:66": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "78:E3:6D": "Espressif Inc.",
        "14:5A:FC": "Liteon Technology Corporation",
        "1C:A0:EF": "IEEE Registration Authority",
        "00:18:85": "Motorola Solutions Inc.",
        "D8:E7:2B": "NETSCOUT SYSTEMS INC",
        "18:BF:B3": "Samsung Electronics Co., Ltd., Memory Division",
        "2C:8D:B1": "Intel Corporate",
        "58:6C:25": "Intel Corporate",
        "08:2C:ED": "Technity Solutions Inc.",
        "34:86:5D": "Espressif Inc.",
        "B4:E3:F9": "Silicon Laboratories",
        "A4:9B:CD": "Cisco Systems, Inc",
        "04:27:28": "Microsoft Corporation",
        "20:66:CF": "FREEBOX SAS",
        "2C:C8:1B": "Routerboard.com",
        "88:E0:56": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D0:7D:33": "Huawei Device Co., Ltd.",
        "C0:E1:BE": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D0:35:E5": "EM Microelectronic",
        "90:96:F3": "BUFFALO.INC",
        "54:0E:58": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "5C:64:8E": "Zyxel Communications Corporation",
        "30:E3:96": "Huawei Device Co., Ltd.",
        "C4:A1:51": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "78:47:E3": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "EC:F8:EB": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "F0:92:B4": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "F4:4E:38": "Olibra LLC",
        "2C:63:73": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "A0:D7:22": "Samsung Electronics Co.,Ltd",
        "50:49:B0": "Samsung Electronics Co.,Ltd",
        "E8:05:DC": "Verifone Inc.",
        "10:7B:CE": "Nokia",
        "C8:05:9E": "Hefei Symboltek Co.,Ltd",
        "34:FC:A1": "Micronet union Technology(Chengdu)Co., Ltd.",
        "28:97:B8": "myenergi Ltd",
        "48:06:2B": "Private",
        "B0:A7:B9": "TP-Link Corporation Limited",
        "6C:5A:B0": "TP-Link Corporation Limited",
        "4C:F5:DC": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "60:E6:F0": "Wistron Neweb Corporation",
        "20:1F:3B": "Google, Inc.",
        "B8:25:B5": "Trakm8 Ltd",
        "20:D2:76": "ITEL MOBILE LIMITED",
        "08:A8:42": "Huawei Device Co., Ltd.",
        "C8:F5:D6": "IEEE Registration Authority",
        "40:58:99": "Logitech Far East",
        "8C:4D:EA": "Cerio Corporation",
        "04:B9:E3": "Samsung Electronics Co.,Ltd",
        "98:43:FA": "Intel Corporate",
        "94:AA:0A": "Fiberhome Telecommunication Technologies Co.,LTD",
        "7C:F4:62": "BEIJING HUAWOO TECHNOLOGIES CO.LTD",
        "C4:5E:5C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E8:5C:0A": "Cisco Systems, Inc",
        "2C:6D:C1": "Intel Corporate",
        "70:B9:50": "Texas Instruments",
        "D0:9F:D9": "IEEE Registration Authority",
        "54:C2:50": "Iskratel d.o.o.",
        "00:FA:B6": "Kontakt Micro-Location Sp z o.o.",
        "D0:17:69": "Murata Manufacturing Co., Ltd.",
        "A0:B0:86": "Hirschmann Automation and Control GmbH",
        "30:B3:46": "CJSC NORSI-TRANS",
        "20:C1:9B": "Intel Corporate",
        "A8:55:6A": "3S System Technology Inc.",
        "5C:E4:2A": "Intel Corporate",
        "18:74:E2": "IEEE Registration Authority",
        "F0:C8:14": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
        "CC:3A:DF": "Neptune Technology Group Inc.",
        "3C:62:F0": "Sercomm Corporation.",
        "98:3B:67": "DWnet Technologies(Suzhou) Corporation",
        "58:35:5D": "Huawei Device Co., Ltd.",
        "AC:7E:01": "Huawei Device Co., Ltd.",
        "6C:93:92": "BEKO Technologies GmbH",
        "FC:8A:3D": "zte corporation",
        "F8:F0:82": "NAGTECH LLC",
        "8C:1F:64": "IEEE Registration Authority",
        "08:5A:11": "D-Link International",
        "50:32:5F": "Silicon Laboratories",
        "F4:7B:09": "Intel Corporate",
        "E8:78:29": "IEEE Registration Authority",
        "EC:94:68": "META SYSTEM SPA ",
        "1C:41:90": "Universal Electronics, Inc.",
        "64:C4:03": "Quectel Wireless Solutions Co.,Ltd.",
        "A0:E4:53": "Sony Corporation",
        "30:A8:DB": "Sony Corporation",
        "84:8E:DF": "Sony Corporation",
        "58:48:22": "Sony Corporation",
        "C0:25:A5": "Dell Inc.",
        "B4:C8:10": "Umpi srl",
        "48:5A:67": "Shaanxi Ruixun Electronic Information Technology Co., Ltd",
        "18:00:2D": "Sony Corporation",
        "D0:51:62": "Sony Corporation",
        "90:C1:15": "Sony Corporation",
        "5C:B5:24": "Sony Corporation",
        "58:17:0C": "Sony Corporation",
        "44:D5:CC": "Amazon Technologies Inc.",
        "9C:5C:F9": "Sony Corporation",
        "84:C7:EA": "Sony Corporation",
        "38:78:62": "Sony Corporation",
        "00:25:E7": "Sony Corporation",
        "00:24:EF": "Sony Corporation",
        "00:16:B8": "Sony Corporation",
        "64:C3:94": "HUAWEI TECHNOLOGIES CO.,LTD",
        "94:5C:9A": "Apple, Inc.",
        "00:F3:9F": "Apple, Inc.",
        "30:39:A9": "Hongshan Information Science and Technology (HangZhou) Co.,Ltd.",
        "1C:57:3E": "Altice Labs S.A.",
        "D0:16:7C": "eero inc.",
        "A8:5B:36": "IEEE Registration Authority",
        "4C:77:CB": "Intel Corporate",
        "9C:6B:F0": "Shenzhen Yipingfang Network Technology Co., Ltd.",
        "44:95:3B": "RLTech India Private Limited",
        "84:14:4D": "Intel Corporate",
        "20:B8:68": "Motorola Mobility LLC, a Lenovo Company",
        "28:9C:6E": "Shanghai High-Flying Electronics  Technology Co., Ltd",
        "84:F7:03": "Espressif Inc.",
        "2C:11:65": "Silicon Laboratories",
        "B4:1C:AB": "ICR, inc.",
        "1C:2A:8B": "Nokia",
        "94:5A:FC": "Amazon Technologies Inc.",
        "BC:D7:D4": "Roku, Inc",
        "AC:0B:FB": "Espressif Inc.",
        "DC:ED:83": "Beijing Xiaomi Mobile Software Co., Ltd",
        "00:D7:6D": "Intel Corporate",
        "50:8E:49": "Xiaomi Communications Co Ltd",
        "8C:AA:CE": "Xiaomi Communications Co Ltd",
        "70:5F:A3": "Xiaomi Communications Co Ltd",
        "FC:D9:08": "Xiaomi Communications Co Ltd",
        "30:B0:37": "New H3C Technologies Co., Ltd",
        "FC:12:2C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "BC:33:29": "Sony Interactive Entertainment Inc.",
        "A8:89:40": "Huawei Device Co., Ltd.",
        "CC:31:2A": "HUIZHOU TCL COMMUNICATION ELECTRON CO.,LTD",
        "DC:B7:2E": "Xiaomi Communications Co Ltd",
        "38:B8:00": "Wistron Neweb Corporation",
        "6C:D1:E5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:0E:B8": "LG Electronics",
        "0C:0E:76": "D-Link International",
        "70:3E:97": "Iton Technology Corp.",
        "10:47:38": "Nokia Shanghai Bell Co., Ltd.",
        "6C:11:B3": "Wu Qi Technologies,Inc.",
        "A0:94:1A": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "1C:2C:E0": "Shanghai  Mountain View Silicon",
        "00:0C:EC": "Orolia USA",
        "08:FA:28": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F4:B1:9C": "AltoBeam (China) Inc.",
        "A8:D0:81": "Huawei Device Co., Ltd.",
        "74:0C:EE": "Huawei Device Co., Ltd.",
        "6C:B4:FD": "Huawei Device Co., Ltd.",
        "64:0E:9B": "ISHIDA MEDICAL CO., LTD.",
        "24:F6:03": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:CA:85": "NEC Corporation",
        "1C:9D:C2": "Espressif Inc.",
        "C4:EA:1D": "Technicolor Delivery Technologies Belgium NV",
        "A4:91:B1": "Technicolor Delivery Technologies Belgium NV",
        "D4:35:1D": "Technicolor Delivery Technologies Belgium NV",
        "EC:C1:AB": "Guangzhou Shiyuan Electronic Technology Company Limited",
        "18:FC:26": "Qorvo International Pte. Ltd.",
        "58:98:35": "Technicolor Delivery Technologies Belgium NV",
        "90:6A:94": "hangzhou huacheng network technology co., ltd",
        "10:0C:29": "Shenzhen NORCO lntelligent Technology Co.,Ltd",
        "28:36:13": "IEEE Registration Authority",
        "78:52:4A": "Optonic GmbH",
        "00:CE:30": "Express LUCK Industrial Ltd.",
        "C4:6E:33": "Zhong Ge Smart Technology Co., Ltd.",
        "5C:83:82": "Nokia",
        "74:32:C2": "KYOLIS",
        "0C:AA:EE": "Ansjer Electronics Co., Ltd.",
        "FC:A6:4C": "Alibaba cloud computing Co., Ltd",
        "E0:69:BA": "Cisco Systems, Inc",
        "24:36:DA": "Cisco Systems, Inc",
        "20:37:A5": "Apple, Inc.",
        "DC:B5:4F": "Apple, Inc.",
        "4C:EB:D6": "Espressif Inc.",
        "00:8A:76": "Apple, Inc.",
        "F4:23:9C": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
        "D8:A6:F0": "Wu Qi Technologies,Inc.",
        "08:E4:DF": "Shenzhen Sande Dacom Electronics Co., Ltd",
        "EC:7C:2C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "14:58:08": "Taicang T&W Electronics",
        "10:5A:17": "Tuya Smart Inc.",
        "B8:37:4A": "Apple, Inc.",
        "8C:3D:B1": "Beijing H-IoT Technology Co., Ltd.",
        "54:67:06": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "10:55:E4": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "C0:F5:35": "AMPAK Technology,Inc.",
        "C4:E5:32": "Arcadyan Corporation",
        "F8:B5:4D": "Intel Corporate",
        "64:01:FB": "Landis+Gyr GmbH",
        "20:7B:D2": "ASIX Electronics Corporation",
        "18:2D:F7": "JY COMPANY",
        "EC:2C:11": "CWD INNOVATION LIMITED",
        "F0:35:75": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "90:81:75": "Samsung Electronics Co.,Ltd",
        "30:74:67": "Samsung Electronics Co.,Ltd",
        "F0:CD:31": "Samsung Electronics Co.,Ltd",
        "38:A8:CD": "IEEE Registration Authority",
        "E4:44:E5": "Extreme Networks, Inc.",
        "54:52:84": "Huawei Device Co., Ltd.",
        "64:61:40": "Huawei Device Co., Ltd.",
        "C4:17:0E": "Huawei Device Co., Ltd.",
        "68:77:24": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "20:67:E0": "Shenzhen iComm Semiconductor CO.,LTD",
        "7C:83:34": "IEEE Registration Authority",
        "D0:C3:5A": "Jabil Circuit de Chihuahua",
        "84:B6:30": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "58:C7:AC": "New H3C Technologies Co., Ltd",
        "E4:C0:E2": "Sagemcom Broadband SAS",
        "D8:6C:5A": "HUMAX Co., Ltd.",
        "24:97:45": "HUAWEI TECHNOLOGIES CO.,LTD",
        "4C:3F:A7": "uGrid Network Inc.",
        "B8:98:AD": "Motorola Mobility LLC, a Lenovo Company",
        "94:FF:3C": "Fortinet, Inc.",
        "70:52:D8": "ITEL MOBILE LIMITED",
        "08:FA:79": "vivo Mobile Communication Co., Ltd.",
        "1C:AE:3E": "IEEE Registration Authority",
        "00:1D:5B": "Tecvan Informatica Ltda",
        "9C:2B:A6": "Ruijie Networks Co.,LTD",
        "94:14:57": "Shenzhen Sundray Technologies Company Limited",
        "64:B9:4E": "Dell Technologies",
        "EC:2B:EB": "Amazon Technologies Inc.",
        "54:47:E8": "Syrotech Networks. Ltd.",
        "3C:55:76": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "0C:CA:FB": "TPVision Europe B.V",
        "BC:57:29": "Shenzhen KKM Co., Ltd",
        "E4:82:10": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:F7:B9": "HUAWEI TECHNOLOGIES CO.,LTD",
        "18:53:45": "Nokia",
        "08:16:D5": "GOERTEK INC.",
        "1C:56:8E": "Zioncom Electronics (Shenzhen) Ltd.",
        "E0:1F:2B": "Nokia Solutions and Networks GmbH & Co. KG",
        "A0:82:22": "Qingdao Haier Technology Co.,Ltd",
        "28:56:3A": "Fiberhome Telecommunication Technologies Co.,LTD",
        "04:C4:61": "Murata Manufacturing Co., Ltd.",
        "AC:82:26": "Qingdao Haier Technology Co.,Ltd",
        "44:48:FF": "Qingdao Haier Technology Co.,Ltd",
        "A8:C2:66": "HUMAX Co., Ltd.",
        "F8:4E:17": "Sony Corporation",
        "54:0F:57": "Silicon Laboratories",
        "C8:CB:9E": "Intel Corporate",
        "D4:D7:CF": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "F4:E4:D7": "FUJIAN STAR-NET COMMUNICATION CO.,LTD",
        "E8:47:27": "Quectel Wireless Solutions Co.,Ltd.",
        "28:C5:38": "Apple, Inc.",
        "04:99:B9": "Apple, Inc.",
        "F8:4D:89": "Apple, Inc.",
        "78:02:8B": "Apple, Inc.",
        "BC:DB:09": "Cisco Meraki",
        "04:34:F6": "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd.",
        "14:01:9C": "Ubyon Inc.",
        "F8:95:22": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:B1:32": "HUAWEI TECHNOLOGIES CO.,LTD",
        "54:69:25": "PS INODIC CO., LTD.",
        "E8:B5:D0": "Dell Inc.",
        "E8:CB:ED": "Chipsea Technologies(Shenzhen) Corp.",
        "78:13:E0": "FUJIAN STAR-NET COMMUNICATION CO.,LTD",
        "48:61:EE": "Samsung Electronics Co.,Ltd",
        "A8:4B:4D": "Samsung Electronics Co.,Ltd",
        "60:07:C4": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "08:6F:48": "Shenzhen iComm Semiconductor CO.,LTD",
        "F4:F3:09": "Samsung Electronics Co.,Ltd",
        "78:57:B0": "GERTEC BRASIL LTDA",
        "C4:F1:22": "Nexar Ltd.",
        "64:BE:63": "STORDIS GmbH",
        "0C:C6:FD": "Xiaomi Communications Co Ltd",
        "50:DA:D6": "Xiaomi Communications Co Ltd",
        "18:B9:6E": "Dongguan Liesheng Electronic Co., Ltd.",
        "54:69:90": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D8:0A:60": "HUAWEI TECHNOLOGIES CO.,LTD",
        "3C:86:9A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "2C:27:68": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D0:78:80": "Fiberhome Telecommunication Technologies Co.,LTD",
        "14:CB:65": "Microsoft Corporation",
        "34:08:E1": "Texas Instruments",
        "50:58:B0": "Hunan Greatwall Computer System Co., Ltd.",
        "E0:6C:F6": "ESSENCORE limited",
        "78:C6:2B": "FUJIAN STAR-NET COMMUNICATION CO.,LTD",
        "D4:66:24": "Cisco Systems, Inc",
        "9C:90:19": "Beyless",
        "3C:E0:38": "Omnifi Inc.",
        "00:16:82": "OMS Motion",
        "D4:F9:8D": "Espressif Inc.",
        "04:CE:09": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "1C:86:9A": "Samsung Electronics Co.,Ltd",
        "D8:FB:D6": "Amazon Technologies Inc.",
        "9C:47:F9": "LJU Automatisierungstechnik GmbH",
        "70:A8:D3": "Intel Corporate",
        "2C:33:58": "Intel Corporate",
        "08:6A:E5": "Amazon Technologies Inc.",
        "A8:17:10": "Bouffalo Lab (Nanjing) Co., Ltd.",
        "20:62:96": "Shenzhen Malio Technology Co.,Ltd",
        "A0:80:69": "Intel Corporate",
        "A0:67:20": "China Dragon Technology Limited",
        "94:C9:B7": "IEEE Registration Authority",
        "E8:EE:CC": "Fantasia Trading LLC",
        "5C:16:C7": "Arista Networks",
        "4C:E0:DB": "Xiaomi Communications Co Ltd",
        "7C:33:F9": "HUAWEI TECHNOLOGIES CO.,LTD",
        "54:16:51": "Ruijie Networks Co.,LTD",
        "70:87:A7": "Murata Manufacturing Co., Ltd.",
        "AC:04:25": "ball-b GmbH Co KG",
        "04:BD:97": "Cisco Systems, Inc",
        "F0:3A:4B": "Bloombase, Inc.",
        "00:02:A3": "Hitachi Energy Switzerland Ltd",
        "38:F7:F1": "Huawei Device Co., Ltd.",
        "40:76:A9": "Huawei Device Co., Ltd.",
        "F4:38:C1": "Huawei Device Co., Ltd.",
        "28:EA:2D": "Apple, Inc.",
        "20:9B:E6": "Guangzhou Shiyuan Electronic Technology Company Limited",
        "B8:E6:0C": "Apple, Inc.",
        "48:35:2B": "Apple, Inc.",
        "4C:E6:C0": "Apple, Inc.",
        "38:88:A4": "Apple, Inc.",
        "44:DA:30": "Apple, Inc.",
        "84:16:0C": "Broadcom Limited",
        "74:E6:B8": "LG Electronics",
        "28:D0:F5": "Ruijie Networks Co.,LTD",
        "94:18:65": "NETGEAR",
        "C8:9B:D7": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "28:B1:33": "SHINEMAN(SHENZHEN) Tech. Cor., Ltd.",
        "D0:04:B0": "Samsung Electronics Co.,Ltd",
        "98:B0:8B": "Samsung Electronics Co.,Ltd",
        "A8:58:7C": "Shoogee GmbH & Co. KG",
        "9C:25:95": "Samsung Electronics Co.,Ltd",
        "90:F2:60": "Shenzhen Honesty Electronics Co.,Ltd.",
        "18:89:CF": "TECNO MOBILE LIMITED",
        "98:5F:4F": "Tongfang Computer Co.,Ltd.",
        "34:F8:6E": "Parker Hannifin Corporation",
        "0C:AE:BD": "Edifier International",
        "6C:D8:69": "Guangzhou Sat Infrared Co.,LTD",
        "38:1E:C7": "Chipsea Technologies(Shenzhen) Corp.",
        "08:92:04": "Dell Inc.",
        "40:67:9B": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "F0:A6:54": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "3C:CF:B4": "Telink Semiconductor (Shanghai) Co., Ltd.",
        "04:3C:E8": "Shenzhen SuperElectron Technology Co.,Ltd.",
        "A8:E6:21": "Amazon Technologies Inc.",
        "E8:31:CD": "Espressif Inc.",
        "88:D0:39": "Tonly Technology Co. Ltd ",
        "E8:F3:75": "Nokia",
        "10:37:11": "NORBIT ITS",
        "C0:88:6D": "Securosys SA",
        "24:81:3B": "Cisco Systems, Inc",
        "C4:09:B7": "Juniper Networks",
        "0C:B8:E8": "Renesas Electronics (Penang) Sdn. Bhd.",
        "EC:5C:84": "Murata Manufacturing Co., Ltd.",
        "BC:9B:5E": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "48:74:12": "OnePlus Technology (Shenzhen) Co., Ltd",
        "B0:F2:08": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "F0:B2:B9": "Intel Corporate",
        "A0:69:D9": "New H3C Technologies Co., Ltd",
        "20:FE:00": "Amazon Technologies Inc.",
        "F4:21:AE": "Shanghai Xiaodu Technology Limited",
        "F4:12:FA": "Espressif Inc.",
        "DC:99:FE": "Armatura LLC",
        "9C:F1:55": "Nokia",
        "E4:73:05": "Shenzhen INVT Electric CO.,Ltd",
        "B0:1B:4B": "Invisible Fun Studio Limited",
        "60:4F:5B": "Huawei Device Co., Ltd.",
        "14:DC:E2": "THALES AVS France",
        "78:FB:D8": "Apple, Inc.",
        "A4:C3:37": "Apple, Inc.",
        "B0:F1:D8": "Apple, Inc.",
        "D0:88:0C": "Apple, Inc.",
        "1C:57:DC": "Apple, Inc.",
        "74:74:46": "Google, Inc.",
        "78:20:A5": "Nintendo Co.,Ltd",
        "20:78:CD": "Apple, Inc.",
        "30:D5:3E": "Apple, Inc.",
        "50:23:A2": "Apple, Inc.",
        "98:69:8A": "Apple, Inc.",
        "50:46:AE": "MERCURY CORPORATION",
        "B0:99:D7": "Samsung Electronics Co.,Ltd",
        "90:EB:48": "Shanghai XinMiaoLink Technology Co., Ltd",
        "B4:B7:42": "Amazon Technologies Inc.",
        "78:A0:3F": "Amazon Technologies Inc.",
        "50:C1:F0": "NXP Semiconductor (Tianjin) LTD.",
        "F4:84:8D": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "58:11:22": "ASUSTek COMPUTER INC.",
        "60:BE:B4": "S-Bluetech co., limited",
        "90:DF:7D": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "A8:54:A2": "Heimgard Technologies AS",
        "74:2A:8A": "shenzhen worldelite electronics co., LTD",
        "BC:1D:89": "Motorola Mobility LLC, a Lenovo Company",
        "B8:7E:E5": "Intelbras",
        "94:AB:FE": "Nokia",
        "74:69:4A": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "78:15:2D": "UNION CHIP TECHNOLOGY LIMITED",
        "98:A9:2D": "New H3C Technologies Co., Ltd",
        "00:A5:54": "Intel Corporate",
        "0C:86:29": "IEEE Registration Authority",
        "50:DC:D0": "Observint Technologies, Inc.",
        "E0:03:6B": "Samsung Electronics Co.,Ltd",
        "18:69:D4": "Samsung Electronics Co.,Ltd",
        "D4:F0:EA": "Beijing Xiaomi Mobile Software Co., Ltd",
        "58:76:AC": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
        "80:69:1A": "Belkin International Inc.",
        "64:31:72": "ZHEJIANG HISING TECHNOLOGY CO.,LTD",
        "D0:FC:D0": "HUMAX Co., Ltd.",
        "20:FA:DB": "Huahao Kunpeng Technology (chengDu)  Co.,Ltd.",
        "0C:8B:95": "Espressif Inc.",
        "68:5E:1C": "Texas Instruments",
        "38:AB:41": "Texas Instruments",
        "CC:47:92": "ASIX Electronics Corporation",
        "E0:46:EE": "NETGEAR",
        "DC:BE:49": "ITEL MOBILE LIMITED",
        "9C:95:61": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "9C:4F:5F": "Google, Inc.",
        "A0:29:42": "Intel Corporate",
        "10:71:B3": "Zyxel Communications Corporation",
        "F0:D4:15": "Intel Corporate",
        "D4:D8:53": "Intel Corporate",
        "04:63:D0": "Huawei Device Co., Ltd.",
        "14:44:8F": "Edgecore Networks Corporation",
        "34:25:BE": "Amazon Technologies Inc.",
        "C0:ED:E5": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "10:A5:62": "Iton Technology Corp.",
        "D4:A3:EB": "Shenzhen iComm Semiconductor CO.,LTD",
        "9C:BF:CD": "HUAWEI TECHNOLOGIES CO.,LTD",
        "B8:9F:CC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "9C:E0:41": "Nokia",
        "78:34:86": "Nokia",
        "8C:76:3F": "ARRIS Group, Inc.",
        "28:12:93": "Honor Device Co., Ltd.",
        "C0:A9:38": "HUAWEI TECHNOLOGIES CO.,LTD",
        "5C:24:E2": "Suzhou Denbom Electronic S&T Co., Ltd",
        "64:98:9E": "TRINNOV AUDIO",
        "BC:C7:46": "Hon Hai Precision IND.CO.,LTD",
        "30:E8:E4": "Qorvo International Pte. Ltd.",
        "00:0D:A9": "INGETEAM",
        "30:E0:90": "Genevisio Ltd.",
        "FC:B9:7E": "GE Appliances",
        "88:03:4C": "WEIFANG GOERTEK ELECTRONICS CO.,LTD",
        "48:DC:9D": "Grandprint(Beijing) Technology Co., LTD.",
        "64:FD:96": "Sagemcom Broadband SAS",
        "C8:EB:EC": "Shenzhen YOUHUA Technology Co., Ltd",
        "04:7C:16": "Micro-Star INTL CO., LTD.",
        "94:C5:A6": "ITEL MOBILE LIMITED",
        "7C:EC:B1": "Apple, Inc.",
        "5C:E9:1E": "Apple, Inc.",
        "E0:D7:38": "WireStar Networks",
        "40:42:44": "Cisco Systems, Inc",
        "A8:B0:AE": "BizLink Special Cables Germany GmbH",
        "F0:B6:61": "eero inc.",
        "E0:6A:05": "Shenzhen YOUHUA Technology Co., Ltd",
        "48:57:D2": "Broadcom Limited",
        "9C:21:83": "Broadcom Limited",
        "24:1F:BD": "Extreme Networks, Inc.",
        "D8:34:EE": "SHURE INCORPORATED",
        "04:25:F0": "Nokia",
        "1C:BC:EC": "silex technology, Inc.",
        "40:3B:7B": "Huawei Device Co., Ltd.",
        "08:30:CE": "Fiberhome Telecommunication Technologies Co.,LTD",
        "90:CD:1F": "Quectel Wireless Solutions Co.,Ltd.",
        "90:23:5B": "Amazon Technologies Inc.",
        "14:13:0B": "Garmin International",
        "48:9B:E0": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "5C:FA:25": "Sagemcom Broadband SAS",
        "B0:A2:E7": "Shenzhen TINNO Mobile Technology Corp.",
        "A0:4C:5B": "Shenzhen TINNO Mobile Technology Corp.",
        "BC:41:01": "Shenzhen TINNO Mobile Technology Corp.",
        "18:D6:1C": "Shenzhen TINNO Mobile Technology Corp.",
        "74:97:79": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "34:CF:6C": "Hangzhou Taili wireless communication equipment Co.,Ltd",
        "F8:CD:C8": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "B0:28:5B": "JUHUA Technology Inc.",
        "C8:24:96": "Jiangsu Yinhe  Electronics Co.,Ltd.",
        "E0:F6:78": "Fiberhome Telecommunication Technologies Co.,LTD",
        "40:22:30": "Shenzhen SuperElectron Technology Co.,Ltd.",
        "14:5B:B9": "ConMet",
        "28:F7:D6": "Fiberhome Telecommunication Technologies Co.,LTD",
        "B8:B4:09": "Samsung Electronics Co.,Ltd",
        "24:18:C0": "E. Wehrle GmbH",
        "AC:83:F0": "Cobalt Digital Inc.",
        "AC:15:A2": "TP-Link Corporation Limited",
        "AC:DF:9F": "Arcadyan Corporation",
        "B8:59:C8": "70mai Co.,Ltd.",
        "A8:E2:07": "GOIP Global Services Pvt. Ltd.",
        "74:E7:98": "Juniper Networks",
        "D4:E2:2F": "Roku, Inc",
        "00:13:95": "congatec GmbH",
        "28:77:B1": "Tri plus grupa d.o.o.",
        "C4:3C:B0": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
        "3C:0B:4F": "Yandex Services AG",
        "4C:31:2D": "Sichuan AI-Link Technology Co., Ltd.",
        "40:5E:F6": "Samsung Electronics Co.,Ltd",
        "94:52:44": "Samsung Electronics Co.,Ltd",
        "9C:2E:7A": "Samsung Electronics Co.,Ltd",
        "7C:63:05": "Amazon Technologies Inc.",
        "04:4F:7A": "China Mobile Group Device Co.,Ltd.",
        "C0:4E:30": "Espressif Inc.",
        "AC:60:6F": "Nokia Shanghai Bell Co., Ltd.",
        "D8:7E:6F": "CASCINATION AG",
        "54:31:D4": "TGW Mechanics GmbH",
        "94:01:AC": "Wuhan Qianyang Iotian Technology Co., Ltd",
        "00:19:FB": "SKY UK LIMITED",
        "78:3E:53": "SKY UK LIMITED",
        "24:A7:DC": "SKY UK LIMITED",
        "E0:16:B1": "Advanced Design Technology co.,ltd.",
        "E4:B5:55": "Huawei Device Co., Ltd.",
        "C0:69:11": "Arista Networks",
        "2C:93:FB": "Sercomm France Sarl",
        "38:A6:CE": "SKY UK LIMITED",
        "68:EC:8A": "IKEA of Sweden AB",
        "48:02:AF": "Telit Communication s.p.a",
        "FC:C7:37": "Shaanxi Gangsion Electronic Technology Co., Ltd",
        "1C:46:D1": "SKY UK LIMITED",
        "00:3F:10": "Shenzhen GainStrong Technology Co., Ltd.",
        "88:22:B2": "Chipsea Technologies (Shenzhen) Corp.",
        "68:7A:64": "Intel Corporate",
        "BC:03:58": "Intel Corporate",
        "88:B8:63": "HISENSE VISUAL TECHNOLOGY CO.,LTD",
        "BC:69:CB": "Panasonic Electric Works Networks Co., Ltd.",
        "58:C5:7E": "Fiberhome Telecommunication Technologies Co.,LTD",
        "74:3A:F4": "Intel Corporate",
        "58:2B:0A": "Texas Instruments",
        "B4:46:6B": "REALTIMEID AS",
        "C4:EB:39": "Sagemcom Broadband SAS",
        "00:52:C8": "Made Studio Design Ltd.",
        "F0:C1:CE": "GoodWe Technologies CO., Ltd",
        "0C:91:92": "Intel Corporate",
        "48:AD:9A": "Intel Corporate",
        "68:65:B7": "Zhishang Chuanglian Technology Co., Ltd",
        "08:9D:F4": "Intel Corporate",
        "DC:46:28": "Intel Corporate",
        "90:6A:EB": "Microsoft Corporation",
        "E4:6A:35": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "20:04:F3": "Honor Device Co., Ltd.",
        "58:9A:3E": "Amazon Technologies Inc.",
        "E8:38:A0": "Vizio, Inc",
        "EC:C0:7A": "Laird Connectivity",
        "68:B9:C2": "Earda Technologies co Ltd",
        "C8:1E:C2": "ITEL MOBILE LIMITED",
        "38:E7:C0": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "68:83:CB": "Apple, Inc.",
        "FC:12:63": "ASKEY COMPUTER CORP",
        "58:30:5B": "Shanghai Junqian Sensing Technology Co.,LTD",
        "C0:71:AA": "ShenZhen OnMicro Electronics Co.,Ltd.",
        "9C:05:91": "Mellanox Technologies, Inc.",
        "70:9C:45": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:09:DF": "Vestel Elektronik San ve Tic. A.S.",
        "FC:07:36": "Huawei Device Co., Ltd.",
        "94:A0:7D": "Huawei Device Co., Ltd.",
        "5C:07:58": "Ufispace Co., LTD.",
        "DC:E6:50": "Extreme Networks, Inc.",
        "14:2D:79": "Fiberhome Telecommunication Technologies Co.,LTD",
        "DC:B7:AC": "Aruba, a Hewlett Packard Enterprise Company",
        "A0:31:31": "Procenne Digital Security",
        "84:F4:4C": "International Integrated Systems., Inc.",
        "CC:5E:F8": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "A4:9E:69": "Silicon Laboratories",
        "48:73:10": "Juniper Networks",
        "4C:FC:22": "SHANGHAI HI-TECH CONTROL SYSTEM CO.,LTD.",
        "40:33:06": "Taicang T&W Electronics",
        "00:0B:F8": "Infinera, Inc.",
        "7C:50:DA": "E.J Ward",
        "00:5C:C2": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "2C:F2:A5": "Sagemcom Broadband SAS",
        "E4:EC:E8": "Samsung Electronics Co.,Ltd",
        "C8:90:8A": "Samsung Electronics Co.,Ltd",
        "78:3E:A1": "Nokia Shanghai Bell Co., Ltd.",
        "B0:81:01": "Honor Device Co., Ltd.",
        "48:5D:ED": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "5C:FC:6E": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "30:B0:EA": "Shenzhen Chuangxin Internet Communication Technology Co., Ltd",
        "40:1A:58": "Wistron Neweb Corporation",
        "A4:1C:B4": "DFI Inc",
        "34:47:9A": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "7C:DC:CC": "BEIJING STARBLAZE TECHNOLOGY CO.,LTD",
        "70:B7:E4": "Broadcom Limited",
        "14:23:F2": "Broadcom Limited",
        "74:08:DE": "Fujian Landi Commercial Technology Co., Ltd.",
        "10:FC:33": "Huawei Device Co., Ltd.",
        "94:3C:96": "Sagemcom Broadband SAS",
        "94:AD:23": "Apple, Inc.",
        "20:A5:CB": "Apple, Inc.",
        "F4:21:CA": "Apple, Inc.",
        "3C:02:68": "Infinera, Inc.",
        "BC:89:A7": "Apple, Inc.",
        "04:04:B8": "China Hualu Panasonic AVC Networks Co., LTD.",
        "18:D6:DD": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E0:01:A6": "Edgecore Networks Corporation",
        "FC:18:03": "HUAWEI TECHNOLOGIES CO.,LTD",
        "68:96:2E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "CC:3D:D1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "40:C2:BA": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "F0:82:C0": "Silicon Laboratories",
        "80:BC:37": "Ruckus Wireless",
        "60:C7:BE": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "20:36:26": "TP-Link Corporation Limited",
        "54:C4:5B": "Arcadyan Corporation",
        "00:0B:3A": "PESA Inc.",
        "24:F0:D3": "Samsung Electronics Co.,Ltd",
        "58:20:71": "Samsung Electronics Co.,Ltd",
        "24:DC:0F": "Phytium Technology Co.,Ltd.",
        "68:49:92": "Cisco Meraki",
        "F8:5E:42": "Technicolor CH USA Inc.",
        "EC:93:7D": "Technicolor CH USA Inc.",
        "D4:E2:CB": "Technicolor CH USA Inc.",
        "F8:A4:FB": "Nanjing Decowell Automation Co.,LTD",
        "80:BE:AF": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "F8:9B:6E": "Nokia Solutions and Networks GmbH & Co. KG",
        "E0:C2:64": "Intel Corporate",
        "BC:D0:EB": "New H3C Technologies Co., Ltd",
        "60:58:01": "Shandong ZTop Microelectronics Co., Ltd.",
        "D8:63:0D": "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd.",
        "14:DC:51": "Xiamen Cheerzing IOT Technology Co.,Ltd.",
        "D4:BA:BA": "IEEE Registration Authority",
        "9C:D8:E3": "Wuhan Huazhong Numerical Control Co., Ltd",
        "F8:07:5D": "Huawei Device Co., Ltd.",
        "04:33:1F": "Huawei Device Co., Ltd.",
        "98:22:6E": "Amazon Technologies Inc.",
        "C4:AA:C4": "Zhejiang Dahua Technology Co., Ltd.",
        "64:DB:F7": "Nokia Shanghai Bell Co., Ltd.",
        "3C:A2:C3": "vivo Mobile Communication Co., Ltd.",
        "14:B3:A1": "Juniper Networks",
        "54:10:2E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "94:D5:4D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E4:D3:AA": "FCNT LMITED",
        "5C:47:5E": "Ring LLC",
        "38:A9:EA": "HK DAPU ELECTRONIC TECHNOLOGY CO., LIMITED",
        "24:E5:0F": "Google, Inc.",
        "70:28:04": "Realme Chongqing Mobile Telecommunications Corp.,Ltd.",
        "C0:91:B9": "Amazon Technologies Inc.",
        "94:D8:6B": "nass magnet Hungária Kft.",
        "14:61:A4": "Honor Device Co., Ltd.",
        "EC:84:B4": "CIG SHANGHAI CO LTD",
        "A4:81:7A": "CIG SHANGHAI CO LTD",
        "5C:21:67": "Rockwell Automation",
        "D0:96:86": "IEEE Registration Authority",
        "C4:E5:B1": "Suzhou PanKore Integrated Circuit Technology Co. Ltd.",
        "AC:C4:A9": "Fiberhome Telecommunication Technologies Co.,LTD",
        "7C:94:9F": "Shenzhen iComm Semiconductor CO.,LTD",
        "3C:2C:A6": "Beijing Xiaomi Electronics Co.,Ltd",
        "34:F2:23": "Fujian Newland Communication Science Technology Co.,Ltd.",
        "E0:75:26": "China Dragon Technology Limited",
        "04:B6:BE": "CIG SHANGHAI CO LTD",
        "E4:8E:10": "CIG SHANGHAI CO LTD",
        "94:BE:09": "China Mobile Group Device Co.,Ltd.",
        "E8:EF:22": "Siemens Numerical Control Ltd., Nanjing",
        "78:6C:84": "Amazon Technologies Inc.",
        "38:64:07": "Qingdao Intelligent&Precise Electronics Co.,Ltd.",
        "1C:63:A5": "securityplatform",
        "94:28:6F": "zte corporation",
        "40:0E:F3": "zte corporation",
        "D8:E8:44": "zte corporation",
        "C0:51:5C": "zte corporation",
        "9C:63:5B": "zte corporation",
        "74:3E:39": "YUSUR Technology Co., Ltd.",
        "B8:D4:BC": "zte corporation",
        "C4:EB:41": "Sagemcom Broadband SAS",
        "C4:EB:43": "Sagemcom Broadband SAS",
        "4C:74:A7": "IEEE Registration Authority",
        "54:C6:FF": "New H3C Technologies Co., Ltd",
        "F4:E9:75": "New H3C Technologies Co., Ltd",
        "D4:D4:DA": "Espressif Inc.",
        "04:03:12": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "84:60:82": "Hyperloop Technologies, Inc dba Virgin Hyperloop",
        "E8:AA:CB": "Samsung Electronics Co.,Ltd",
        "F0:4F:7C": "Amazon Technologies Inc.",
        "D4:3A:2C": "Google, Inc.",
        "E0:4B:41": "Hangzhou Beilian Low Carbon Technology Co., Ltd.",
        "88:B8:6F": "Infinix mobility limited",
        "28:0A:EE": "Renesas Electronics (Penang) Sdn. Bhd.",
        "4C:22:F3": "Arcadyan Corporation",
        "38:53:19": "34ED LLC DBA Centegix",
        "20:0C:86": "GX India Pvt Ltd",
        "70:AE:D5": "Apple, Inc.",
        "00:09:0F": "Fortinet, Inc.",
        "00:0C:E6": "Fortinet, Inc.",
        "C4:7B:80": "Protempis, LLC",
        "9C:88:24": "PetroCloud LLC",
        "54:D7:E3": "Aruba, a Hewlett Packard Enterprise Company",
        "5C:2F:AF": "HomeWizard B.V.",
        "78:30:F5": "TBT Inc.",
        "88:AF:7B": "Nanjing Powercore Tech Co.,Ltd",
        "8C:8E:0D": "zte corporation",
        "04:00:67": "Stanley Black & Decker",
        "E0:B9:8A": "Shenzhen Taike industrial automation company,Ltd",
        "A0:24:F9": "Chengdu InnovaTest Technology Co., Ltd",
        "70:47:77": "Ruckus Wireless",
        "FC:3F:A6": "eero inc.",
        "78:96:A3": "Extreme Networks, Inc.",
        "48:C1:EE": "Honor Device Co., Ltd.",
        "50:80:4A": "Quectel Wireless Solutions Co.,Ltd.",
        "A4:86:AE": "Quectel Wireless Solutions Co.,Ltd.",
        "CC:08:7B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "7C:64:6C": "LG Electronics",
        "00:03:27": "HMS Industrial Networks",
        "94:72:0F": "Guangdong Nanguang Photo&Video Systems Co., Ltd.",
        "64:68:76": "Edifier International",
        "60:15:21": "Redarc Electronics",
        "E4:26:D5": "Motorola Mobility LLC, a Lenovo Company",
        "28:E4:24": "New H3C Technologies Co., Ltd",
        "58:D3:91": "Quectel Wireless Solutions Co.,Ltd.",
        "A8:F8:C9": "NXP Semiconductor (Tianjin) LTD.",
        "60:56:99": "Marelli Morocco LLC SARL",
        "88:94:8E": "Max Weishaupt GmbH",
        "DC:B3:47": "SHENZHEN FAST TECHNOLOGIES CO.,LTD",
        "60:6E:41": "Barrot Technology Co.,LTD",
        "E4:9D:73": "Edgecore Networks Corporation",
        "60:29:2B": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "5C:64:F3": "sywinkey HongKong Co,. Limited?",
        "00:1E:43": "AISIN CORPORATION",
        "A8:EE:6D": "Fine Point-High Export",
        "4C:06:17": "Taicang T&W Electronics",
        "D4:9A:F6": "AzureWave Technology Inc.",
        "00:23:D5": "WAREMA Renkhoff SE",
        "44:EB:2E": "ALPSALPINE CO,.LTD",
        "04:7F:0E": "Barrot Technology Co.,LTD",
        "70:46:98": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:08:4D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "EC:AA:8F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:6B:14": "Barrot Technology Co.,LTD",
        "2C:18:09": "Apple, Inc.",
        "FC:47:D8": "Apple, Inc.",
        "90:AB:96": "Silicon Laboratories",
        "B0:4B:68": "NAKAYO Inc",
        "D8:34:1C": "GD Midea Air-Conditioning Equipment Co.,Ltd.",
        "54:51:DE": "Cisco Systems, Inc",
        "F4:33:1C": "Toast, Inc.",
        "04:32:01": "Broadcom Limited",
        "D8:AF:81": "AO ",
        "00:12:E0": "Codan Limited",
        "38:39:6C": "Huawei Device Co., Ltd.",
        "50:66:E5": "Huawei Device Co., Ltd.",
        "DC:77:94": "Huawei Device Co., Ltd.",
        "70:B6:51": "Eight Sleep",
        "DC:A3:13": "Shenzhen Changjin Communication Technology Co.,Ltd",
        "68:9A:21": "Fiberhome Telecommunication Technologies Co.,LTD",
        "7C:17:79": "EM Microelectronic",
        "90:CE:B8": "Texas Instruments",
        "AC:FC:82": "Shenzhen Sundray Technologies Company Limited",
        "CC:F8:26": "Samsung Electronics Co.,Ltd",
        "5C:22:DA": "Technicolor CH USA Inc.",
        "18:26:54": "Samsung Electronics Co.,Ltd",
        "70:5A:6F": "IEEE Registration Authority",
        "1C:67:60": "Phonesuite",
        "38:6F:6B": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "54:11:49": "vivo Mobile Communication Co., Ltd.",
        "70:7C:E3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "3C:6F:9B": "zte corporation",
        "90:52:BF": "Sichuan Tianyi Comheart Telecom Co.,LTD",
        "60:EF:AB": "Silicon Laboratories",
        "48:A9:8A": "Routerboard.com",
        "88:1E:59": "Onion Corporation",
        "2C:00:2A": "Shenzhen TINNO Mobile Technology Corp.",
        "E8:88:43": "Xiaomi Communications Co Ltd",
        "28:02:2E": "Apple, Inc.",
        "FC:9C:A7": "Apple, Inc.",
        "48:E1:5C": "Apple, Inc.",
        "74:15:F5": "Apple, Inc.",
        "88:C6:E8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "38:14:1B": "Secure Letter Inc.",
        "B4:61:E9": "Sichuan AI-Link Technology Co., Ltd.",
        "64:E2:04": "NTN Technical Service Corporation",
        "2C:98:11": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
        "9C:D1:D0": "Guangzhou Ronsuo Electronic Technology Co.,Ltd",
        "90:D6:89": "Huahao Fangzhou Technology Co.,Ltd",
        "3C:79:2B": "Dongguan Auklink TechnologyCo.,Ltd",
        "C0:8B:2A": "Cisco Systems, Inc",
        "2C:CA:75": "Robert Bosch GmbH AnP",
        "5C:94:62": "Shenzhen Jiuzhou Electric Co.,LTD",
        "E0:D8:C4": "Qingdao Intelligent&Precise Electronics Co.,Ltd.",
        "CC:D8:1F": "Maipu Communication Technology Co.,Ltd.",
        "D4:99:6C": "Juniper Networks",
        "E4:BC:AA": "Xiaomi Communications Co Ltd",
        "40:4C:CA": "Espressif Inc.",
        "BC:9E:2C": "China Mobile Group Device Co.,Ltd.",
        "54:5D:D9": "EDISTEC",
        "00:16:16": "BROWAN COMMUNICATIONS INCORPORATION",
        "C0:C7:0A": "Ruckus Wireless",
        "00:0E:51": "TECNA SpA",
        "5C:62:8B": "TP-Link Corporation Limited",
        "D4:3A:2F": "SHENZHEN MTC CO LTD",
        "14:AB:EC": "Aruba, a Hewlett Packard Enterprise Company",
        "9C:84:B6": "Shenzhen iComm Semiconductor CO.,LTD",
        "34:CA:81": "New H3C Intelligence Terminal Co., Ltd.",
        "C4:67:8B": "Alphabet Capital Sdn Bhd",
        "60:F0:4D": "Honor Device Co., Ltd.",
        "60:03:0C": "Shenzhen YOUHUA Technology Co., Ltd",
        "28:0C:2D": "QUALVISION TECHNOLOGY CO.,LTD",
        "88:67:DC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "40:41:0D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "5C:8B:6B": "Amazon Technologies Inc.",
        "48:81:D4": "Ruijie Networks Co.,LTD",
        "24:A4:3C": "Ubiquiti Inc",
        "44:D9:E7": "Ubiquiti Inc",
        "C0:61:3D": "BioIntelliSense, Inc.",
        "D0:21:F9": "Ubiquiti Inc",
        "70:A7:41": "Ubiquiti Inc",
        "18:14:AE": "Nokia",
        "04:18:D6": "Ubiquiti Inc",
        "00:14:91": "Daniels Electronics Ltd. dba Codan Radio Communications",
        "20:0B:C5": "Cisco Systems, Inc",
        "90:E9:5E": "Cisco Systems, Inc",
        "C8:2B:6B": "shenzhen worldelite electronics co., LTD",
        "30:4F:75": "DZS Inc.",
        "D0:96:FB": "DZS Inc.",
        "80:7C:62": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "20:29:B9": "Ikotek technology SH Co., Ltd",
        "28:57:BE": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "00:01:47": "DZS Inc.",
        "00:02:71": "DZS Inc.",
        "CC:47:40": "AzureWave Technology Inc.",
        "24:E8:E5": "Shenzhen Skyworth  Digital  Technology  CO., Ltd",
        "F8:D0:27": "Seiko Epson Corporation",
        "5C:66:6C": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "4C:4B:F9": "IEEE Registration Authority",
        "1C:EA:0B": "Edgecore Networks Corporation",
        "44:EF:BF": "China Dragon Technology Limited",
        "B8:1F:5E": "Apption Labs Limited",
        "D8:12:65": "CHONGQING FUGUI ELECTRONICS CO.,LTD.",
        "4C:B4:4A": "NANOWAVE Technologies Inc.",
        "04:8C:9A": "Huawei Device Co., Ltd.",
        "EC:3C:BB": "Huawei Device Co., Ltd.",
        "8C:3A:7E": "Universal Electronics, Inc.",
        "70:44:1C": "SHENZHEN KAIFA TECHNOLOGY CO.,LTD.",
        "B4:7C:59": "Jiangsu Hengxin Technology Co.,Ltd.",
        "30:0D:9E": "Ruijie Networks Co.,LTD",
        "EC:FA:5C": "Beijing Xiaomi Electronics Co., Ltd.",
        "F8:B4:6A": "Hewlett Packard",
        "BC:B0:E7": "HUAWEI TECHNOLOGIES CO.,LTD",
        "54:34:EF": "HUAWEI TECHNOLOGIES CO.,LTD",
        "88:D5:A8": "ITEL MOBILE LIMITED",
        "20:85:93": "IEEE Registration Authority",
        "AC:E3:42": "HUAWEI TECHNOLOGIES CO.,LTD",
        "90:17:C8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E4:92:2A": "DBG HOLDINGS LIMITED",
        "2C:64:1F": "Vizio, Inc",
        "20:77:59": "OPTICAL NETWORK VIDEO TECHNOLOGIES (SHENZHEN) CO., LTD.",
        "54:E7:D5": "Sun Cupid Technology (HK) LTD",
        "18:90:88": "eero inc.",
        "4C:56:DF": "Targus US LLC",
        "24:15:10": "IEEE Registration Authority",
        "6C:4D:51": "Shenzhen Ceres Technology Co., Ltd.",
        "88:9D:98": "Allied-telesisK.K.",
        "DC:F8:B9": "zte corporation",
        "18:BF:1C": "Jiangsu Huitong Group Co.,Ltd.",
        "AC:DE:48": "Private",
        "00:50:C7": "Private",
        "48:01:C5": "OnePlus Technology (Shenzhen) Co., Ltd",
        "B4:EE:25": "Shenzhen Belon Technology CO.,LTD",
        "C8:2B:96": "Espressif Inc.",
        "98:52:3D": "Sunitec Enterprise Co.,Ltd",
        "D0:15:A6": "Aruba, a Hewlett Packard Enterprise Company",
        "00:01:63": "Cisco Systems, Inc",
        "E0:00:84": "HUAWEI TECHNOLOGIES CO.,LTD",
        "2C:A8:9C": "Creatz inc.",
        "4C:DC:0D": "Coral Telecom Limited",
        "00:4E:01": "Dell Inc.",
        "C4:E1:A1": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "AC:C3:58": "Continental Automotive Czech Republic s.r.o.",
        "3C:EC:EF": "Super Micro Computer, Inc.",
        "18:55:E3": "Apple, Inc.",
        "E4:50:EB": "Apple, Inc.",
        "88:64:40": "Apple, Inc.",
        "60:70:C0": "Apple, Inc.",
        "F0:C3:71": "Apple, Inc.",
        "64:FF:0A": "Wistron Neweb Corporation",
        "F0:99:19": "Garmin International",
        "00:00:DE": "CETIA",
        "F4:3E:66": "Bee Computing (HK) Limited",
        "DC:39:6F": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "B4:C4:76": "Wuhan Maritime Communication Research Institute",
        "68:34:89": "LEA Professional",
        "B4:6C:47": "Panasonic Appliances Company",
        "44:42:2F": "TESTOP CO.,LTD.",
        "54:9C:27": "Plasma Cloud Limited",
        "D0:4E:50": "Mobiwire Mobiles (NingBo) Co., LTD",
        "94:BF:80": "zte corporation",
        "98:7A:14": "Microsoft Corporation",
        "C8:3D:DC": "Xiaomi Communications Co Ltd",
        "9C:3A:9A": "Shenzhen Sundray Technologies Company Limited",
        "B0:B5:E8": "Ruroc LTD",
        "04:D5:90": "Fortinet, Inc.",
        "54:15:89": "MCS Logic Inc.",
        "84:57:33": "Microsoft Corporation",
        "00:24:23": "AzureWave Technologies (Shanghai) Inc.",
        "8C:59:3C": "IEEE Registration Authority",
        "60:29:D5": "DAVOLINK Inc.",
        "50:97:44": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "58:F3:9C": "Cisco Systems, Inc",
        "C4:41:1E": "Belkin International Inc.",
        "00:AD:63": "Dedicated Micros Malta LTD",
        "E4:15:F6": "Texas Instruments",
        "AC:42:28": "Parta Networks",
        "F4:1D:6B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "7C:EC:9B": "Fuzhou Teraway Information Technology Co.,Ltd",
        "CC:90:70": "Cisco Systems, Inc",
        "28:41:C6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "38:01:18": "ULVAC,Inc.",
        "14:AD:CA": "China Mobile Iot Limited company",
        "80:91:33": "AzureWave Technology Inc.",
        "B4:F5:8E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C4:8F:C1": "DEEPTRACK S.L.U.",
        "F8:23:87": "Shenzhen Horn Audio Co.,Ltd.",
        "E8:28:C1": "Eltex Enterprise Ltd.",
        "78:D3:47": "Ericsson AB",
        "A4:A1:79": "Nanjing dianyan electric power automation co. LTD",
        "68:DB:67": "Nantong Coship Electronics Co., Ltd.",
        "18:19:D6": "Samsung Electronics Co.,Ltd",
        "BC:98:DF": "Motorola Mobility LLC, a Lenovo Company",
        "70:FC:8F": "FREEBOX SAS",
        "50:1B:32": "Taicang T&W Electronics",
        "98:0D:67": "Zyxel Communications Corporation",
        "00:02:D8": "BRECIS Communications Corporation",
        "B0:A6:F5": "Xaptum, Inc.",
        "AC:F5:E6": "Cisco Systems, Inc",
        "DC:B0:82": "Nokia",
        "F8:C3:97": "NZXT Corp. Ltd.",
        "70:DD:A8": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "4C:6F:9C": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "78:2C:29": "New H3C Technologies Co., Ltd",
        "BC:9F:E4": "Aruba, a Hewlett Packard Enterprise Company",
        "70:2E:80": "DIEHL Connectivity Solutions",
        "AC:A4:6E": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "C8:B4:22": "ASKEY COMPUTER CORP",
        "94:EE:9F": "HMD Global Oy",
        "DC:2A:A1": "MedHab LLC",
        "E4:F3:E8": "Shenzhen SuperElectron Technology Co.,Ltd.",
        "F4:32:3D": "Sichuan tianyi kanghe communications co., LTD",
        "F8:B7:97": "NEC Platforms, Ltd.",
        "B0:AA:D2": "Sichuan tianyi kanghe communications co., LTD",
        "10:93:97": "ARRIS Group, Inc.",
        "50:75:F1": "ARRIS Group, Inc.",
        "C4:65:16": "Hewlett Packard",
        "E4:1E:0A": "IEEE Registration Authority",
        "CC:A1:2B": "TCL King Electrical Appliances (Huizhou) Co., Ltd",
        "AC:00:D0": "zte corporation",
        "E8:C4:17": "Fiberhome Telecommunication Technologies Co.,LTD",
        "00:1E:A3": "Nokia Danmark A/S",
        "38:F3:2E": "Skullcandy",
        "98:1E:19": "Sagemcom Broadband SAS",
        "84:B8:66": "Beijing XiaoLu technology co. LTD",
        "18:BC:5A": "Zhejiang Tmall Technology Co., Ltd.",
        "C4:C1:38": "OWLink Technology Inc",
        "AC:37:C9": "RAID Incorporated",
        "20:58:69": "Ruckus Wireless",
        "CC:37:AB": "Edgecore Networks Corporation",
        "14:22:DB": "eero inc.",
        "C8:63:14": "IEEE Registration Authority",
        "24:31:54": "HUAWEI TECHNOLOGIES CO.,LTD",
        "2C:58:E8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "70:CD:91": "TERACOM TELEMATICA S.A",
        "2C:18:75": "Skyworth Digital Technology(Shenzhen) Co.,Ltd",
        "D0:6E:DE": "Sagemcom Broadband SAS",
        "18:39:9C": "Skorpios Technologies",
        "94:C2:BD": "TECNOBIT",
        "48:83:B4": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "84:B8:B8": "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd.",
        "D0:41:C9": "Fiberhome Telecommunication Technologies Co.,LTD",
        "E8:01:8D": "Fiberhome Telecommunication Technologies Co.,LTD",
        "10:A3:B8": "Iskratel d.o.o.",
        "E8:EC:A3": "Dongguan Liesheng Electronic Co.Ltd",
        "08:A6:BC": "Amazon Technologies Inc.",
        "70:1E:68": "Hanna Instruments, Inc.",
        "1C:B3:E9": "Shenzhen Zhongke United Communication Technology ",
        "8C:96:5F": "Shandong Zhongan Technology Co., Ltd.",
        "C0:07:4A": "Brita GmbH",
        "E8:B2:FE": "HUMAX Co., Ltd.",
        "80:FD:7A": "BLU Products Inc",
        "00:17:FA": "Microsoft Corporation",
        "94:16:25": "Apple, Inc.",
        "54:3B:30": "duagon AG",
        "B0:BB:8B": "WAVETEL TECHNOLOGY LIMITED",
        "34:A8:EB": "Apple, Inc.",
        "94:BF:C4": "Ruckus Wireless",
        "A4:83:E7": "Apple, Inc.",
        "F4:AF:E7": "Apple, Inc.",
        "AC:88:FD": "Apple, Inc.",
        "50:3E:7C": "LeiShen Intelligent  System Co.Ltd",
        "24:58:6E": "zte corporation",
        "B4:A3:05": "XIAMEN YAXON NETWORK CO., LTD.",
        "80:3E:48": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "24:3F:30": "Oxygen Broadband s.a.",
        "3C:91:80": "Liteon Technology Corporation",
        "20:32:6C": "Samsung Electronics Co.,Ltd",
        "64:89:F1": "Samsung Electronics Co.,Ltd",
        "20:34:FB": "Xiaomi Communications Co Ltd",
        "A8:9C:ED": "Xiaomi Communications Co Ltd",
        "6C:A6:04": "ARRIS Group, Inc.",
        "5C:F9:DD": "Dell Inc.",
        "D0:EC:35": "Cisco Systems, Inc",
        "BC:CF:4F": "Zyxel Communications Corporation",
        "C0:10:B1": "HMD Global Oy",
        "90:89:5F": "WEIFANG GOERTEK ELECTRONICS CO.,LTD",
        "48:D8:45": "Shenzhen Mainuoke Electronics Co., Ltd",
        "0C:E0:41": "iDruide",
        "B8:8F:B4": "JABIL CIRCUIT ITALIA S.R.L",
        "00:52:C2": "peiker acustic GmbH",
        "8C:53:D2": "China Mobile Group Device Co.,Ltd.",
        "D4:53:83": "Murata Manufacturing Co., Ltd.",
        "A0:42:46": "IT Telecom Co., Ltd.",
        "0C:F4:75": "Zliide Technologies ApS",
        "68:FF:7B": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "80:8F:1D": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "00:12:4E": "XAC AUTOMATION CORP.",
        "88:E0:34": "Shinwa industries(China) ltd.",
        "48:BD:0E": "Quanta Storage Inc.",
        "00:0F:69": "SEW Eurodrive GmbH & Co. KG",
        "E4:58:E7": "Samsung Electronics Co.,Ltd",
        "00:10:4A": "The Parvus Corporation",
        "D0:58:C0": "Qingdao Haier Multimedia Limited. ",
        "48:C3:B0": "Pharos Co.Ltd",
        "DC:58:BC": "Thomas-Krenn.AG",
        "00:10:25": "Grayhill, Inc",
        "38:21:C7": "Aruba, a Hewlett Packard Enterprise Company",
        "A4:5F:9B": "Nexell",
        "70:EA:1A": "Cisco Systems, Inc",
        "80:8A:8B": "vivo Mobile Communication Co., Ltd.",
        "98:44:B6": "INFRANOR SAS",
        "38:83:9A": "SHENZHEN RF-LINK TECHNOLOGY CO.,LTD.",
        "DC:67:23": "barox Kommunikation GmbH",
        "94:B4:0F": "Aruba, a Hewlett Packard Enterprise Company",
        "00:1A:1E": "Aruba, a Hewlett Packard Enterprise Company",
        "00:24:6C": "Aruba, a Hewlett Packard Enterprise Company",
        "20:1B:C9": "Juniper Networks",
        "C8:F6:C8": "Fiberhome Telecommunication Technologies Co.,LTD",
        "1C:3B:8F": "Selve GmbH & Co. KG",
        "E4:E7:49": "Hewlett Packard",
        "EC:C5:7F": "Suzhou Pairlink Network Technology",
        "38:C2:BA": "CCTV NEOTECH",
        "A0:F9:B7": "Ademco Smart Homes Technology(Tianjin)Co.,Ltd.",
        "A8:3C:CB": "ROSSMA",
        "88:6F:D4": "Dell Inc.",
        "CC:3F:EA": "BAE Systems, Inc",
        "4C:F2:BF": "Cambridge Industries(Group) Co.,Ltd.",
        "CC:9E:A2": "Amazon Technologies Inc.",
        "AC:43:30": "Versa Networks",
        "E8:5B:B7": "Ample Systems Inc.",
        "94:67:7E": "Belden India Private Limited",
        "AC:57:75": "HMD Global Oy",
        "D4:3A:2E": "SHENZHEN MTC CO LTD",
        "50:AD:92": "NX Technologies",
        "00:32:17": "Cisco Systems, Inc",
        "94:E0:D6": "China Dragon Technology Limited",
        "B4:A9:FC": "Quanta Computer Inc.",
        "6C:A9:36": "DisplayLink (UK) Ltd",
        "70:85:40": "Skyworth Digital Technology(Shenzhen) Co.,Ltd",
        "08:F1:EA": "Hewlett Packard Enterprise",
        "F0:0D:F5": "ACOMA Medical Industry Co,. Ltd.",
        "68:45:F1": "TOSHIBA CLIENT SOLUTIONS CO., LTD.",
        "78:B2:13": "DWnet Technologies(Suzhou) Corporation",
        "58:C2:32": "NEC Corporation",
        "38:1D:14": "Skydio Inc.",
        "7C:DB:98": "ASKEY COMPUTER CORP",
        "38:0B:3C": "Texas Instruments",
        "9C:8C:D8": "Hewlett Packard Enterprise",
        "A4:8C:C0": "JLG Industries, Inc.",
        "3C:28:6D": "Google, Inc.",
        "00:09:3A": "Molex CMS",
        "04:F9:D9": "Speaker Electronic(Jiashan) Co.,Ltd",
        "DC:08:0F": "Apple, Inc.",
        "F8:E9:4E": "Apple, Inc.",
        "EC:2C:E2": "Apple, Inc.",
        "40:BC:60": "Apple, Inc.",
        "E8:36:17": "Apple, Inc.",
        "9C:64:8B": "Apple, Inc.",
        "34:42:62": "Apple, Inc.",
        "14:D0:0D": "Apple, Inc.",
        "88:D2:11": "Eko Devices, Inc.",
        "B8:C2:27": "PSTec",
        "74:F7:37": "KCE",
        "48:A4:93": "TAIYO YUDEN CO.,LTD",
        "E8:2C:6D": "SmartRG, Inc.",
        "48:E6:95": "Insigma Inc",
        "B4:79:C8": "Ruckus Wireless",
        "B4:0B:78": "Brusa Elektronik AG",
        "C0:3D:D9": "MitraStar Technology Corp.",
        "2C:AA:8E": "Wyze Labs Inc",
        "70:3A:51": "Xiaomi Communications Co Ltd",
        "DC:48:B2": "Baraja Pty. Ltd.",
        "18:1E:95": "AuVerte",
        "0C:95:41": "CHIPSEA TECHNOLOGIES (SHENZHEN) CORP.",
        "3C:37:86": "NETGEAR",
        "48:35:2E": "Shenzhen Wolck Network Product Co.,LTD",
        "04:E5:98": "Xiaomi Communications Co Ltd",
        "B8:2C:A0": "Resideo",
        "6C:C7:EC": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "B0:33:A6": "Juniper Networks",
        "D8:96:85": "GoPro",
        "C0:BD:C8": "Samsung Electronics Co.,Ltd",
        "64:7B:CE": "Samsung Electronics Co.,Ltd",
        "A8:87:B3": "Samsung Electronics Co.,Ltd",
        "6C:00:6B": "Samsung Electronics Co.,Ltd",
        "00:10:60": "BILLIONTON SYSTEMS, INC.",
        "C4:D4:89": "JiangSu Joyque Information Industry Co.,Ltd",
        "B4:F9:49": "optilink networks pvt ltd",
        "E4:3C:80": "University of Oklahoma",
        "3C:2C:30": "Dell Inc.",
        "70:6D:15": "Cisco Systems, Inc",
        "A4:A1:E4": "Innotube, Inc.",
        "94:EA:EA": "TELLESCOM INDUSTRIA E COMERCIO EM TELECOMUNICACAO ",
        "1C:FD:08": "IEEE Registration Authority",
        "B8:59:9F": "Mellanox Technologies, Inc.",
        "30:13:89": "Siemens AG, Automations & Drives,",
        "98:D3:E7": "Netafim L",
        "F0:63:F9": "HUAWEI TECHNOLOGIES CO.,LTD",
        "7C:C3:85": "HUAWEI TECHNOLOGIES CO.,LTD",
        "90:0E:B3": "Shenzhen Amediatech Technology Co., Ltd.",
        "54:9F:AE": "iBASE Gaming Inc",
        "54:80:28": "Hewlett Packard Enterprise",
        "54:06:8B": "Ningbo Deli Kebei Technology Co.LTD",
        "60:CE:92": "The Refined Industry Company Limited",
        "10:5B:AD": "Mega Well Limited",
        "74:BF:C0": "CANON INC.",
        "C8:D9:D2": "Hewlett Packard",
        "24:FC:E5": "Samsung Electronics Co.,Ltd",
        "80:96:21": "Lenovo",
        "78:05:5F": "Shenzhen WYC Technology Co., Ltd.",
        "00:EA:BD": "Cisco Systems, Inc",
        "48:87:2D": "SHEN ZHEN DA XIA LONG QUE TECHNOLOGY CO.,LTD",
        "E8:1A:58": "TECHNOLOGIC SYSTEMS",
        "C0:BF:A7": "Juniper Networks",
        "F0:54:94": "Honeywell Connected Building",
        "5C:C9:99": "New H3C Technologies Co., Ltd",
        "B0:2A:43": "Google, Inc.",
        "C4:74:F8": "Hot Pepper, Inc.",
        "14:22:33": "Fiberhome Telecommunication Technologies Co.,LTD",
        "74:34:00": "MTG Co., Ltd.",
        "DC:37:57": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "00:50:99": "3COM EUROPE LTD",
        "04:BC:87": "Shenzhen JustLink Technology Co., LTD",
        "54:C3:3E": "Ciena Corporation",
        "EC:79:F2": "Startel",
        "BC:B2:2B": "EM-Tech",
        "D4:AB:82": "ARRIS Group, Inc.",
        "70:4F:B8": "ARRIS Group, Inc.",
        "00:60:EB": "FOURTHTRACK SYSTEMS",
        "18:62:E4": "Texas Instruments",
        "60:35:C0": "SFR",
        "C4:98:5C": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "30:A1:FA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:2E:90": "PALIT MICROSYSTEMS, LTD",
        "9C:AA:1B": "Microsoft Corporation",
        "A8:9A:93": "Sagemcom Broadband SAS",
        "00:1A:C5": "Keysight Technologies, Inc.",
        "00:20:1E": "NETQUEST CORPORATION",
        "64:62:8A": "evon GmbH",
        "04:15:D9": "Viwone",
        "EC:B3:13": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "B0:8B:CF": "Cisco Systems, Inc",
        "00:60:8C": "3COM",
        "00:A0:24": "3COM",
        "00:20:AF": "3COM",
        "00:10:4B": "3COM",
        "A8:5A:F3": "Shanghai Siflower Communication Technology Co., Ltd",
        "70:FD:46": "Samsung Electronics Co.,Ltd",
        "8C:83:E1": "Samsung Electronics Co.,Ltd",
        "88:9F:6F": "Samsung Electronics Co.,Ltd",
        "5C:63:C9": "Intellithings Ltd.",
        "0C:96:E6": "Cloud Network Technology (Samoa) Limited",
        "E0:0E:E1": "We Corporation Inc.",
        "00:0C:43": "Ralink Technology, Corp.",
        "8C:92:46": "Oerlikon Textile Gmbh&Co.KG",
        "00:0E:94": "Maas International BV",
        "48:98:CA": "Sichuan AI-Link Technology Co., Ltd.",
        "24:7E:51": "zte corporation",
        "E8:B5:41": "zte corporation",
        "0C:9D:92": "ASUSTek COMPUTER INC.",
        "98:8E:D4": "ITEL MOBILE LIMITED",
        "E8:A7:88": "XIAMEN LEELEN TECHNOLOGY CO., LTD",
        "58:2D:34": "Qingping Electronics (Suzhou) Co., Ltd",
        "20:DE:88": "IC Realtime LLC",
        "F4:06:8D": "devolo AG",
        "00:1A:31": "SCAN COIN AB",
        "00:1B:84": "Scan Engineering Telecom",
        "48:2C:A0": "Xiaomi Communications Co Ltd",
        "34:12:F9": "HUAWEI TECHNOLOGIES CO.,LTD",
        "BC:E2:65": "HUAWEI TECHNOLOGIES CO.,LTD",
        "4C:D1:A1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "88:BF:E4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "40:17:E2": "INTAI TECHNOLOGY CORP.",
        "0C:CB:85": "Motorola Mobility LLC, a Lenovo Company",
        "A4:E6:15": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD",
        "74:1F:79": "YOUNGKOOK ELECTRONICS CO.,LTD",
        "A0:93:51": "Cisco Systems, Inc",
        "98:03:9B": "Mellanox Technologies, Inc.",
        "20:89:84": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "B4:CE:FE": "James Czekaj",
        "F8:CC:6E": "DEPO Electronics Ltd",
        "F8:36:9B": "Texas Instruments",
        "88:AE:1D": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "B8:88:E3": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "28:9E:FC": "Sagemcom Broadband SAS",
        "00:C0:55": "MODULAR COMPUTING TECHNOLOGIES",
        "E4:1F:E9": "Dunkermotoren GmbH",
        "C4:51:8D": "Shenzhen YOUHUA Technology Co., Ltd",
        "48:68:34": "Silicon Motion, Inc.",
        "00:11:33": "Siemens AG Austria",
        "00:0B:23": "Siemens Home & Office Comm. Devices",
        "64:13:31": "Bosch Car Multimedia (Wuhu) Co. Ltd.",
        "18:3A:48": "VostroNet",
        "78:2F:17": "Xlab Co.,Ltd",
        "B0:02:7E": "MULLER SERVICES",
        "24:FA:F3": "Shanghai Flexem Technology Co.,Ltd.",
        "88:D2:BF": "German Autolabs",
        "20:16:3D": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "E0:73:5F": "NUCOM",
        "00:51:ED": "LG Innotek",
        "40:DC:9D": "HAJEN",
        "34:0A:98": "HUAWEI TECHNOLOGIES CO.,LTD",
        "64:6D:6C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C4:B8:B4": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F0:BC:C9": "PFU LIMITED",
        "48:75:83": "Intellion AG",
        "90:4C:81": "Hewlett Packard Enterprise",
        "8C:35:79": "QDIQO Sp. z o.o.",
        "38:C7:0A": "WiFiSong",
        "D8:76:0A": "Escort, Inc.",
        "5C:2E:D2": "ABC(XiSheng) Electronics Co.,Ltd",
        "FC:FB:FB": "Cisco Systems, Inc",
        "00:7E:95": "Cisco Systems, Inc",
        "9C:5A:44": "COMPAL INFORMATION (KUNSHAN) CO., LTD. ",
        "14:CA:A0": "Hu&Co",
        "08:D4:6A": "LG Electronics (Mobile Communications)",
        "00:10:17": "Bosch Access Systems GmbH",
        "F4:EE:14": "MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "6C:59:40": "MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "D0:25:16": "MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "1C:60:DE": "MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "D8:24:77": "Universal Electric Corporation",
        "00:90:7F": "WatchGuard Technologies, Inc.",
        "4C:5E:0C": "Routerboard.com",
        "D4:CA:6D": "Routerboard.com",
        "00:14:72": "China Broadband Wireless IP Standard group(ChinaBWIPS)",
        "80:B5:75": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A4:BE:2B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "68:E7:C2": "Samsung Electronics Co.,Ltd",
        "58:B1:0F": "Samsung Electronics Co.,Ltd",
        "40:06:A0": "Texas Instruments",
        "F8:2D:C0": "ARRIS Group, Inc.",
        "18:9C:27": "ARRIS Group, Inc.",
        "3C:F5:CC": "New H3C Technologies Co., Ltd",
        "D0:8A:91": "Technicolor CH USA Inc.",
        "28:11:A5": "Bose Corporation",
        "D8:F3:DB": "Post CH AG",
        "DC:B4:AC": "FLEXTRONICS MANUFACTURING(ZHUHAI)CO.,LTD.",
        "A4:92:CB": "Nokia",
        "C0:D2:F3": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "B8:83:03": "Hewlett Packard Enterprise",
        "20:3D:BD": "LG Innotek",
        "A4:53:85": "WEIFANG GOERTEK ELECTRONICS CO.,LTD",
        "00:40:2F": "XLNT DESIGNS INC.",
        "04:EC:BB": "Fiberhome Telecommunication Technologies Co.,LTD",
        "64:A2:F9": "OnePlus Technology (Shenzhen) Co., Ltd",
        "A8:7D:12": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D4:21:22": "Sercomm Corporation.",
        "00:C0:02": "Sercomm Corporation.",
        "BC:99:11": "Zyxel Communications Corporation",
        "28:02:45": "Konze System Technology Co.,Ltd.",
        "E4:8F:65": "Yelatma Instrument Making Enterprise, JSC",
        "00:00:A8": "Stratus Technologies",
        "00:04:FC": "Stratus Technologies",
        "3C:24:F0": "IEEE Registration Authority",
        "00:BB:3A": "Amazon Technologies Inc.",
        "0C:B3:4F": "Shenzhen Xiaoqi Intelligent Technology Co., Ltd.",
        "3C:F4:F9": "Moda-InnoChips",
        "94:19:3A": "Elvaco AB",
        "C0:81:35": "Ningbo Forfan technology Co., LTD",
        "84:0D:8E": "Espressif Inc.",
        "00:20:82": "ONEAC CORPORATION",
        "40:62:31": "GIFA",
        "FC:B7:F0": "Idaho National Laboratory",
        "2C:28:B7": "Hangzhou Ruiying technology co., LTD",
        "10:65:30": "Dell Inc.",
        "04:6B:1B": "SYSDINE Co., Ltd.",
        "B0:A3:7E": "QING DAO HAIER TELECOM CO.,LTD.",
        "3C:EA:F9": "JUBIXCOLTD",
        "58:DB:15": "TECNO MOBILE LIMITED",
        "50:50:CE": "Hangzhou Dianyixia Communication Technology Co. Ltd.",
        "FC:69:47": "Texas Instruments",
        "E0:7D:EA": "Texas Instruments",
        "DC:DE:4F": "Gionee Communication Equipment Co Ltd ",
        "4C:D0:CB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "50:5D:AC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E8:FA:F7": "Guangdong Uniteddata Holding Group Co., Ltd.",
        "94:9D:57": "Panasonic do Brasil Limitada",
        "88:D3:7B": "FirmTek, LLC",
        "1C:66:6D": "Hon Hai Precision Ind. Co.,Ltd.",
        "84:F3:EB": "Espressif Inc.",
        "00:1B:48": "Shenzhen Lantech Electronics Co., Ltd.",
        "00:25:0C": "Senet Inc",
        "0C:80:63": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "00:72:78": "Cisco Systems, Inc",
        "64:5A:ED": "Apple, Inc.",
        "C0:B6:58": "Apple, Inc.",
        "48:A9:1C": "Apple, Inc.",
        "50:BC:96": "Apple, Inc.",
        "FC:2A:9C": "Apple, Inc.",
        "68:2C:7B": "Cisco Systems, Inc",
        "44:1E:98": "Ruckus Wireless",
        "A0:56:F3": "Apple, Inc.",
        "54:99:63": "Apple, Inc.",
        "90:DD:5D": "Apple, Inc.",
        "DC:29:19": "AltoBeam (Xiamen) Technology Ltd, Co.",
        "88:5F:E8": "IEEE Registration Authority",
        "00:2F:D9": "Fiberhome Telecommunication Technologies Co.,LTD",
        "B4:CD:27": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C8:19:F7": "Samsung Electronics Co.,Ltd",
        "64:C3:D6": "Juniper Networks",
        "00:A0:21": "General Dynamics Mission Systems",
        "F0:AF:50": "Phantom Intelligence",
        "C4:2C:4F": "Qingdao Hisense Mobile Communication Technology Co,Ltd",
        "24:CA:CB": "Fiberhome Telecommunication Technologies Co.,LTD",
        "54:3E:64": "Fiberhome Telecommunication Technologies Co.,LTD",
        "64:02:CB": "ARRIS Group, Inc.",
        "F4:E1:1E": "Texas Instruments",
        "38:80:DF": "Motorola Mobility LLC, a Lenovo Company",
        "BC:6A:2F": "Henge Docks LLC",
        "0C:08:B4": "HUMAX Co., Ltd.",
        "00:27:05": "Sectronic",
        "48:BD:3D": "New H3C Technologies Co., Ltd",
        "18:4C:08": "Rockwell Automation",
        "DC:02:65": "Meditech Kft",
        "14:A7:2B": "currentoptronics Pvt.Ltd",
        "A4:DA:22": "IEEE Registration Authority",
        "3C:17:10": "Sagemcom Broadband SAS",
        "DC:72:9B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "90:94:97": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:02:9B": "Plexonics Technologies LImited",
        "90:03:72": "Longnan Junya Digital Technology Co. Ltd. ",
        "0C:C6:CC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:58:60": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E8:AB:F3": "HUAWEI TECHNOLOGIES CO.,LTD",
        "3C:DC:BC": "Samsung Electronics Co.,Ltd",
        "80:4E:70": "Samsung Electronics Co.,Ltd",
        "D4:E6:B7": "Samsung Electronics Co.,Ltd",
        "8C:4C:AD": "Evoluzn Inc.",
        "8C:F9:57": "RuiXingHengFang Network (Shenzhen) Co.,Ltd",
        "4C:77:6D": "Cisco Systems, Inc",
        "74:E1:82": "Texas Instruments",
        "44:9E:F9": "vivo Mobile Communication Co., Ltd.",
        "6C:C4:D5": "HMD Global Oy",
        "80:C5:48": "Shenzhen Zowee Technology Co.,Ltd",
        "10:C2:5A": "Technicolor CH USA Inc.",
        "E8:DE:FB": "MESOTIC SAS",
        "C4:00:AD": "Advantech Technology (CHINA) Co., Ltd.",
        "94:FE:9D": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "6C:B6:CA": "DIVUS GmbH",
        "04:D1:3A": "Xiaomi Communications Co Ltd",
        "4C:C2:06": "Somfy",
        "04:09:73": "Hewlett Packard Enterprise",
        "34:99:D7": "Universal Flow Monitors, Inc.",
        "0C:8B:D3": "ITEL MOBILE LIMITED",
        "C0:A8:F0": "Adamson Systems Engineering",
        "9C:43:1E": "IEEE Registration Authority",
        "00:24:AF": "Dish Technologies Corp",
        "28:2C:02": "IEEE Registration Authority",
        "FC:A1:83": "Amazon Technologies Inc.",
        "6C:2A:CB": "Paxton Access Ltd",
        "58:3B:D9": "Fiberhome Telecommunication Technologies Co.,LTD",
        "DC:A2:66": "Hon Hai Precision Ind. Co.,Ltd.",
        "C4:84:66": "Apple, Inc.",
        "34:7C:25": "Apple, Inc.",
        "CC:2D:B7": "Apple, Inc.",
        "BC:91:B5": "Infinix mobility limited",
        "28:2F:C2": "Automotive Data Solutions",
        "98:00:74": "Raisecom Technology CO., LTD",
        "18:C1:9D": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "0C:98:38": "Xiaomi Communications Co Ltd",
        "74:EA:CB": "New H3C Technologies Co., Ltd",
        "D4:1A:3F": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "D8:B1:22": "Juniper Networks",
        "B4:C7:99": "Extreme Networks, Inc.",
        "64:6E:6C": "Radio Datacom LLC",
        "E8:8E:60": "NSD Corporation",
        "00:0F:9B": "Ross Video Limited",
        "00:24:BA": "Texas Instruments",
        "60:51:2C": "TCT mobile ltd",
        "64:DB:81": "Syszone Co., Ltd.",
        "44:AD:19": "XINGFEI （H.K）LIMITED ",
        "38:AD:BE": "New H3C Technologies Co., Ltd",
        "5C:AD:76": "Shenzhen TCL New Technology Co., Ltd",
        "5C:86:5C": "Samsung Electronics Co.,Ltd",
        "04:F1:28": "HMD Global Oy",
        "04:B1:67": "Xiaomi Communications Co Ltd",
        "EC:83:50": "Microsoft Corporation",
        "D0:07:CA": "Juniper Networks",
        "1C:DF:52": "Texas Instruments",
        "30:C5:07": "ECI Telecom Ltd.",
        "C8:45:8F": "Wyler AG",
        "00:1B:B9": "Elitegroup Computer Systems Co.,Ltd.",
        "00:24:61": "Shin Wang Tech.",
        "0C:52:03": "AGM GROUP LIMITED",
        "2C:54:91": "Microsoft Corporation",
        "38:17:C3": "Hewlett Packard Enterprise",
        "00:1E:1D": "East Coast Datacom, Inc.",
        "78:46:C4": "DAEHAP HYPER-TECH",
        "5C:E2:8C": "Zyxel Communications Corporation",
        "E4:BD:4B": "zte corporation",
        "38:D7:CA": "7HUGS LABS",
        "00:01:44": "Dell EMC",
        "08:00:1B": "Dell EMC",
        "7C:01:0A": "Texas Instruments",
        "E4:2B:34": "Apple, Inc.",
        "3C:2E:F9": "Apple, Inc.",
        "A0:4E:A7": "Apple, Inc.",
        "F0:98:9D": "Apple, Inc.",
        "FC:D6:BD": "Robert Bosch GmbH",
        "70:1F:53": "Cisco Systems, Inc",
        "18:39:6E": "SUNSEA TELECOMMUNICATIONS CO.,LTD.",
        "EC:7D:11": "vivo Mobile Communication Co., Ltd.",
        "48:0E:EC": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "50:3E:AA": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "58:00:BB": "Juniper Networks",
        "48:BA:4E": "Hewlett Packard",
        "D8:08:31": "Samsung Electronics Co.,Ltd",
        "94:41:C1": "Mini-Cam Limited",
        "50:4E:DC": "Ping Communication",
        "08:67:4E": "Hisense broadband multimedia technology Co.,Ltd",
        "50:0F:80": "Cisco Systems, Inc",
        "10:F1:F2": "LG Electronics (Mobile Communications)",
        "8C:68:C8": "zte corporation",
        "EC:82:63": "zte corporation",
        "68:3C:7D": "Magic Intelligence Technology Limited",
        "0C:1C:20": "Kakao Corp",
        "24:F5:A2": "Belkin International Inc.",
        "74:BB:D3": "Shenzhen xeme Communication Co., Ltd.",
        "94:28:2E": "New H3C Technologies Co., Ltd",
        "98:F5:A9": "OHSUNG",
        "D8:9E:F3": "Dell Inc.",
        "38:4F:49": "Juniper Networks",
        "4C:BD:8F": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "EC:EB:B8": "Hewlett Packard Enterprise",
        "6C:B7:49": "HUAWEI TECHNOLOGIES CO.,LTD",
        "98:9C:57": "HUAWEI TECHNOLOGIES CO.,LTD",
        "18:52:82": "Fiberhome Telecommunication Technologies Co.,LTD",
        "8C:3C:4A": "NAKAYO Inc",
        "70:86:C1": "Texas Instruments",
        "F4:D7:B2": "LGS Innovations, LLC",
        "00:15:2A": "Nokia Corporation",
        "9C:4A:7B": "Nokia Corporation",
        "D8:61:62": "Wistron Neweb Corporation",
        "28:84:0E": "silicon valley immigration service ",
        "2C:D2:E7": "Nokia Corporation",
        "38:6E:A2": "vivo Mobile Communication Co., Ltd.",
        "98:2D:68": "Samsung Electronics Co., Ltd",
        "BC:2E:48": "ARRIS Group, Inc.",
        "60:8C:E6": "ARRIS Group, Inc.",
        "08:00:70": "Mitsubishi Precision Co.,LTd.",
        "44:4A:B0": "Zhejiang Moorgen Intelligence Technology Co., Ltd",
        "DC:6A:EA": "Infinix mobility limited",
        "C4:21:C8": "KYOCERA CORPORATION ",
        "80:73:9F": "KYOCERA CORPORATION ",
        "70:58:12": "Panasonic Corporation AVC Networks Company",
        "04:20:9A": "Panasonic Corporation AVC Networks Company",
        "34:00:8A": "IEEE Registration Authority",
        "A4:11:15": "Robert Bosch Engineering and Business Solutions pvt. Ltd.",
        "40:D6:3C": "Equitech Industrial(DongGuan)Co.,Ltd",
        "F4:F3:AA": "JBL GmbH & Co. KG",
        "90:50:CA": "Hitron Technologies. Inc",
        "40:99:22": "AzureWave Technology Inc.",
        "C0:6D:1A": "Tianjin Henxinhuifeng Technology Co.,Ltd.",
        "10:7B:44": "ASUSTek COMPUTER INC.",
        "84:25:3F": "silex technology, Inc.",
        "00:08:C9": "TechniSat Digital GmbH Daun",
        "D8:B1:2A": "Panasonic Mobile Communications Co.,Ltd.",
        "B0:19:C6": "Apple, Inc.",
        "38:66:F0": "Apple, Inc.",
        "00:80:09": "JUPITER SYSTEMS, INC.",
        "00:C0:64": "General Datacomm LLC",
        "E8:68:19": "HUAWEI TECHNOLOGIES CO.,LTD",
        "1C:AB:34": "New H3C Technologies Co., Ltd",
        "3C:78:43": "HUAWEI TECHNOLOGIES CO.,LTD",
        "5C:09:79": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E4:FB:5D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:01:CC": "Japan Total Design Communication Co., Ltd.",
        "00:30:C8": "GAD LINE, LTD.",
        "00:16:E0": "3Com Ltd",
        "D8:DE:CE": "ISUNG CO.,LTD",
        "70:3E:AC": "Apple, Inc.",
        "00:11:C0": "Aday Technology Inc",
        "00:05:F1": "Vrcom, Inc.",
        "AC:51:2C": "Infinix mobility limited",
        "30:99:35": "zte corporation",
        "0C:72:D9": "zte corporation",
        "10:62:D0": "Technicolor CH USA Inc.",
        "50:64:2B": "XIAOMI Electronics,CO.,LTD",
        "28:40:1A": "C8 MediSensors, Inc.",
        "30:C0:1B": "Shenzhen Jingxun Software Telecommunication Technology Co.,Ltd",
        "88:86:C2": "STABILO International GmbH",
        "08:A8:A1": "Cyclotronics Power Concepts, Inc",
        "F4:B5:20": "Biostar Microtech international corp.",
        "CC:2F:71": "Intel Corporate",
        "00:1C:C5": "3Com Ltd",
        "88:7A:31": "Velankani Electronics Pvt. Ltd.",
        "8C:0F:6F": "PEGATRON CORPORATION",
        "8C:25:05": "HUAWEI TECHNOLOGIES CO.,LTD",
        "8C:3B:AD": "NETGEAR",
        "64:CF:D9": "Texas Instruments",
        "74:7D:24": "Phicomm (Shanghai) Co., Ltd.",
        "D0:94:66": "Dell Inc.",
        "38:E5:95": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "BC:96:80": "SHENZHEN GONGJIN ELECTRONICS CO.,LT",
        "A4:7B:9D": "Espressif Inc.",
        "B8:F8:BE": "BLUECOM",
        "00:24:82": "Ruckus Wireless",
        "68:92:34": "Ruckus Wireless",
        "50:A7:33": "Ruckus Wireless",
        "2C:5D:93": "Ruckus Wireless",
        "38:FF:36": "Ruckus Wireless",
        "84:18:3A": "Ruckus Wireless",
        "24:C9:A1": "Ruckus Wireless",
        "7C:2E:DD": "Samsung Electronics Co.,Ltd",
        "3C:F7:A4": "Samsung Electronics Co.,Ltd",
        "10:30:34": "Cara Systems",
        "00:00:FE": "Annapolis Micro Systems, Inc.",
        "00:D0:1F": "Senetas Corporation Ltd",
        "64:47:E0": "Feitian Technologies Co., Ltd",
        "B4:4F:96": "Zhejiang Xinzailing Technology co., ltd",
        "4C:65:A8": "IEEE Registration Authority",
        "B0:DF:C1": "Tenda Technology Co.,Ltd.Dongguan branch",
        "9C:6F:52": "zte corporation",
        "E8:6D:65": "AUDIO MOBIL Elektronik GmbH",
        "70:6E:6D": "Cisco Systems, Inc",
        "60:47:62": "Beijing Sensoro Technology Co.,Ltd.",
        "BC:1C:81": "Sichuan iLink Technology Co., Ltd.",
        "90:0A:1A": "Taicang T&W Electronics",
        "50:6E:92": "Innocent Technology Co., Ltd.",
        "30:FE:31": "Nokia",
        "98:F2:B3": "Hewlett Packard Enterprise",
        "C4:57:1F": "June Life Inc",
        "88:6A:E3": "Alpha Networks Inc.",
        "1C:4D:70": "Intel Corporate",
        "D8:22:F4": "Avnet Silica",
        "34:8F:27": "Ruckus Wireless",
        "2C:9E:EC": "Jabil Circuit Penang",
        "00:1C:FA": "Alarm.com",
        "60:31:3B": "Sunnovo International Limited",
        "6C:B2:27": "Sony Video & Sound Products Inc.",
        "98:6F:60": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "00:0C:AB": "Commend International GmbH",
        "74:54:27": "SHENZHEN FAST TECHNOLOGIES CO.,LTD",
        "60:72:0B": "BLU Products Inc",
        "30:89:76": "DALIAN LAMBA TECHNOLOGY CO.,LTD",
        "2C:26:17": "Oculus VR, LLC",
        "34:D9:54": "WiBotic Inc.",
        "48:57:DD": "Facebook Inc",
        "48:7D:2E": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "B0:DA:F9": "ARRIS Group, Inc.",
        "18:35:D1": "ARRIS Group, Inc.",
        "C0:A5:DD": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "48:8D:36": "Arcadyan Corporation",
        "BC:D7:13": "Owl Labs",
        "E8:E1:E1": "Gemtek Technology Co., Ltd.",
        "28:07:0D": "GUANGZHOU WINSOUND INFORMATION TECHNOLOGY CO.,LTD.",
        "00:A3:D1": "Cisco Systems, Inc",
        "FC:4D:8C": "SHENZHEN PANTE ELECTRONICS TECHNOLOGY CO., LTD",
        "FC:06:ED": "M2Motive Technology Inc.",
        "F0:D4:F6": "Lars Thrane A/S",
        "F4:A9:97": "CANON INC.",
        "64:DF:E9": "ATEME",
        "10:C6:FC": "Garmin International",
        "AC:22:05": "Compal Broadband Networks, Inc.",
        "80:A0:36": "Shanghai MXCHIP Information Technology Co., Ltd.",
        "F0:74:85": "NGD Systems, Inc.",
        "40:5C:FD": "Dell Inc.",
        "20:F4:52": "Shanghai IUV Software Development Co. Ltd",
        "50:9A:4C": "Dell Inc.",
        "A0:09:4C": "CenturyLink",
        "B4:39:34": "Pen Generations, Inc.",
        "74:26:AC": "Cisco Systems, Inc",
        "B0:26:28": "Broadcom Limited",
        "98:74:DA": "Infinix mobility limited",
        "40:B4:F0": "Juniper Networks",
        "14:3F:27": "Noccela Oy",
        "10:58:87": "Fiberhome Telecommunication Technologies Co.,LTD",
        "70:4C:A5": "Fortinet, Inc.",
        "9C:06:1B": "Hangzhou H3C Technologies Co., Limited",
        "50:33:8B": "Texas Instruments",
        "E8:DE:8E": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
        "D8:D8:66": "SHENZHEN TOZED TECHNOLOGIES CO.,LTD.",
        "D8:C0:6A": "Hunantv.com Interactive Entertainment Media Co.,Ltd.",
        "AC:20:2E": "Hitron Technologies. Inc",
        "1C:5A:0B": "Tegile Systems",
        "04:6E:02": "OpenRTLS Group",
        "90:0E:83": "Monico Monitoring, Inc.",
        "60:14:66": "zte corporation",
        "68:54:ED": "Alcatel-Lucent",
        "68:02:35": "Konten Networks Inc.",
        "38:AC:3D": "Nephos Inc",
        "E0:37:BF": "Wistron Neweb Corporation",
        "E8:13:67": "AIRSOUND Inc.",
        "00:11:92": "Cisco Systems, Inc",
        "38:F1:35": "SensorTec-Canada",
        "AC:74:09": "Hangzhou H3C Technologies Co., Limited",
        "C4:9D:ED": "Microsoft Corporation",
        "98:A4:0E": "Snap, Inc.",
        "F4:03:43": "Hewlett Packard Enterprise",
        "F0:93:C5": "Garland Technology",
        "98:10:E8": "Apple, Inc.",
        "C0:D0:12": "Apple, Inc.",
        "BC:A9:20": "Apple, Inc.",
        "48:A1:95": "Apple, Inc.",
        "F8:03:77": "Apple, Inc.",
        "F4:96:34": "Intel Corporate",
        "10:7D:1A": "Dell Inc.",
        "70:AF:24": "TP Vision Belgium NV",
        "A4:11:63": "IEEE Registration Authority",
        "C4:D1:97": "Ventia Utility Services",
        "2C:86:D2": "Cisco Systems, Inc",
        "7C:E9:7C": "ITEL MOBILE LIMITED",
        "80:58:F8": "Motorola Mobility LLC, a Lenovo Company",
        "DC:A4:CA": "Apple, Inc.",
        "8C:8F:E9": "Apple, Inc.",
        "70:AF:25": "Nishiyama Industry Co.,LTD.",
        "E8:D1:1B": "ASKEY COMPUTER CORP",
        "98:00:C1": "GuangZhou CREATOR Technology Co.,Ltd.(CHINA)",
        "54:E1:AD": "LCFC(HeFei) Electronics Technology co., ltd",
        "98:D3:D2": "MEKRA Lang GmbH & Co. KG",
        "0C:5F:35": "Niagara Video Corporation",
        "F8:A3:4F": "zte corporation",
        "00:19:12": "Welcat Inc",
        "8C:78:D7": "SHENZHEN FAST TECHNOLOGIES CO.,LTD",
        "B8:EA:AA": "ICG NETWORKS CO.,ltd",
        "B8:F8:83": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "DC:FE:18": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "70:4F:57": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "B0:C4:6C": "Senseit",
        "00:02:A1": "World Wide Packets",
        "00:E0:22": "Analog Devices, Inc.",
        "14:B7:F8": "Technicolor CH USA Inc.",
        "90:3D:6B": "Zicon Technology Corp.",
        "B0:40:89": "Senient Systems LTD",
        "54:25:EA": "HUAWEI TECHNOLOGIES CO.,LTD",
        "3C:7F:6F": "Telechips, Inc.",
        "5C:BA:37": "Microsoft Corporation",
        "00:C0:C6": "PERSONAL MEDIA CORP.",
        "28:FE:CD": "Lemobile Information Technology (Beijing) Co., Ltd.",
        "C8:94:BB": "HUAWEI TECHNOLOGIES CO.,LTD",
        "10:B1:F8": "HUAWEI TECHNOLOGIES CO.,LTD",
        "08:9E:08": "Google, Inc.",
        "00:21:0D": "SAMSIN INNOTEC",
        "C8:73:24": "Sow Cheng Technology Co. Ltd.",
        "00:1F:16": "Wistron Corporation",
        "00:26:2D": "Wistron Corporation",
        "04:95:E6": "Tenda Technology Co.,Ltd.Dongguan branch",
        "50:E6:66": "Shenzhen Techtion Electronics Co., Ltd.",
        "00:16:D3": "Wistron Corporation",
        "4C:4E:03": "TCT mobile ltd",
        "90:17:11": "Hagenuk Marinekommunikation GmbH",
        "00:10:DE": "INTERNATIONAL DATACASTING CORPORATION",
        "C0:D9:F7": "ShanDong Domor Intelligent S&T CO.,Ltd",
        "00:60:8B": "ConferTech International",
        "70:2D:84": "i4C Innovations",
        "2C:20:0B": "Apple, Inc.",
        "88:66:A5": "Apple, Inc.",
        "00:02:77": "Cash Systemes Industrie",
        "CC:A2:19": "SHENZHEN ALONG INVESTMENT CO.,LTD",
        "4C:1A:3A": "PRIMA Research And Production Enterprise Ltd.",
        "14:B3:1F": "Dell Inc.",
        "AC:C1:EE": "Xiaomi Communications Co Ltd",
        "54:19:C8": "vivo Mobile Communication Co., Ltd.",
        "B0:B9:8A": "NETGEAR",
        "80:5A:04": "LG Electronics (Mobile Communications)",
        "8C:A5:A1": "Oregano Systems - Design & Consulting GmbH",
        "B8:EC:A3": "Zyxel Communications Corporation",
        "BC:83:85": "Microsoft Corporation",
        "00:14:38": "Hewlett Packard Enterprise",
        "E4:B0:05": "Beijing IQIYI Science & Technology Co., Ltd.",
        "00:00:48": "Seiko Epson Corporation",
        "B0:E8:92": "Seiko Epson Corporation",
        "AC:18:26": "Seiko Epson Corporation",
        "A4:EE:57": "Seiko Epson Corporation",
        "9C:AE:D3": "Seiko Epson Corporation",
        "70:7C:69": "Avaya Inc",
        "50:0B:91": "IEEE Registration Authority",
        "F8:46:1C": "Sony Interactive Entertainment Inc.",
        "70:4D:7B": "ASUSTek COMPUTER INC.",
        "64:A6:8F": "Zhongshan Readboy Electronics Co.,Ltd",
        "38:BC:01": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:1E:6B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "88:66:39": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:42:5A": "Cisco Systems, Inc",
        "18:DB:F2": "Dell Inc.",
        "18:F8:7A": "i3 International Inc.",
        "4C:26:E7": "Welgate Co., Ltd.",
        "00:60:41": "Yokogawa Digital Computer Corporation",
        "C8:16:A5": "Masimo Corporation",
        "0C:02:27": "Technicolor CH USA Inc.",
        "4C:11:BF": "Zhejiang Dahua Technology Co., Ltd.",
        "2C:59:8A": "LG Electronics (Mobile Communications)",
        "B0:52:16": "Hon Hai Precision Ind. Co.,Ltd.",
        "A0:E4:CB": "Zyxel Communications Corporation",
        "28:4E:D7": "OutSmart Power Systems, Inc.",
        "14:A7:8B": "Zhejiang Dahua Technology Co., Ltd.",
        "A0:B8:F8": "Amgen U.S.A. Inc.",
        "88:44:77": "HUAWEI TECHNOLOGIES CO.,LTD",
        "14:9D:09": "HUAWEI TECHNOLOGIES CO.,LTD",
        "68:69:75": "Angler Labs Inc",
        "20:D2:5F": "SmartCap Technologies",
        "E4:7D:BD": "Samsung Electronics Co.,Ltd",
        "9C:FB:D5": "vivo Mobile Communication Co., Ltd.",
        "18:F7:6B": "Zhejiang Winsight Technology CO.,LTD",
        "58:31:12": "DRUST",
        "9C:83:BF": "PRO-VISION, Inc.",
        "78:EF:4C": "Unetconvergence Co., Ltd.",
        "58:69:6C": "Ruijie Networks Co.,LTD",
        "48:D3:43": "ARRIS Group, Inc.",
        "00:C0:5A": "SEMAPHORE COMMUNICATIONS CORP.",
        "00:07:F9": "Sensaphone",
        "00:1C:B3": "Apple, Inc.",
        "40:71:83": "Juniper Networks",
        "C8:1B:5C": "BCTech",
        "5C:E3:0E": "ARRIS Group, Inc.",
        "1C:C0:E1": "IEEE Registration Authority",
        "00:1A:39": "Merten GmbH&CoKG",
        "00:B0:E1": "Cisco Systems, Inc",
        "00:50:93": "BOEING",
        "90:5C:44": "Compal Broadband Networks, Inc.",
        "E0:7C:13": "zte corporation",
        "F4:1F:88": "zte corporation",
        "14:ED:BB": "2Wire Inc",
        "18:E2:9F": "vivo Mobile Communication Co., Ltd.",
        "28:EE:52": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "70:79:90": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A0:4E:01": "CENTRAL ENGINEERING co.,ltd.",
        "28:CA:09": "ThyssenKrupp Elevators (Shanghai) Co.,Ltd",
        "84:25:19": "Samsung Electronics",
        "5C:24:43": "O-Sung Telecom Co., Ltd.",
        "24:92:0E": "Samsung Electronics Co.,Ltd",
        "FC:42:03": "Samsung Electronics Co.,Ltd",
        "A0:10:81": "Samsung Electronics Co.,Ltd",
        "3C:8B:CD": "Alcatel-Lucent Shanghai Bell Co., Ltd",
        "4C:F9:5D": "HUAWEI TECHNOLOGIES CO.,LTD",
        "84:21:F1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:F2:2C": "Shanghai B-star Technology Co.,Ltd.",
        "00:05:EE": "Vanderbilt International (SWE) AB ",
        "F0:79:60": "Apple, Inc.",
        "A0:D7:95": "Apple, Inc.",
        "00:90:E7": "HORSCH ELEKTRONIK AG",
        "E4:3E:D7": "Arcadyan Corporation",
        "54:54:CF": "PROBEDIGITAL CO.,LTD",
        "F8:63:3F": "Intel Corporate",
        "08:86:20": "TECNO MOBILE LIMITED",
        "F0:D5:BF": "Intel Corporate",
        "64:74:F6": "Shooter Detection Systems",
        "98:13:33": "zte corporation",
        "74:8A:69": "Korea Image Technology Co., Ltd",
        "BC:47:60": "Samsung Electronics Co.,Ltd",
        "04:18:0F": "Samsung Electronics Co.,Ltd",
        "20:13:E0": "Samsung Electronics Co.,Ltd",
        "00:25:66": "Samsung Electronics Co.,Ltd",
        "D0:DB:32": "Nokia Corporation",
        "E8:00:36": "Befs co,. ltd",
        "C0:9F:05": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "5C:49:79": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
        "C0:F9:45": "Toshiba Toko Meter Systems Co., LTD.",
        "70:F8:E7": "IEEE Registration Authority",
        "D4:2C:44": "Cisco Systems, Inc",
        "84:3D:C6": "Cisco Systems, Inc",
        "00:24:85": "ConteXtream Ltd",
        "28:FC:F6": "Shenzhen Xin KingBrand enterprises Co.,Ltd",
        "00:1F:58": "EMH Energiemesstechnik GmbH",
        "68:94:23": "Hon Hai Precision Ind. Co.,Ltd.",
        "84:4B:F5": "Hon Hai Precision Ind. Co.,Ltd.",
        "08:ED:B9": "Hon Hai Precision Ind. Co.,Ltd.",
        "3C:77:E6": "Hon Hai Precision Ind. Co.,Ltd.",
        "70:18:8B": "Hon Hai Precision Ind. Co.,Ltd.",
        "5C:6D:20": "Hon Hai Precision Ind. Co.,Ltd.",
        "5C:AC:4C": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:16:DF": "Lundinova AB",
        "00:1D:0C": "MobileCompia",
        "B8:8E:DF": "Zencheer Communication Technology Co., Ltd.",
        "DC:71:44": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "98:0C:82": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "A0:0B:BA": "SAMSUNG ELECTRO MECHANICS CO., LTD.",
        "60:6B:BD": "Samsung Electronics Co.,Ltd",
        "00:21:4C": "Samsung Electronics Co.,Ltd",
        "08:C6:B3": "QTECH LLC",
        "00:18:AF": "Samsung Electronics Co.,Ltd",
        "00:1E:E1": "Samsung Electronics Co.,Ltd",
        "00:16:6B": "Samsung Electronics Co.,Ltd",
        "00:00:F0": "Samsung Electronics Co.,Ltd",
        "8C:C8:CD": "Samsung Electronics Co.,Ltd",
        "A8:F2:74": "Samsung Electronics Co.,Ltd",
        "D4:87:D8": "Samsung Electronics Co.,Ltd",
        "18:46:17": "Samsung Electronics Co.,Ltd",
        "38:0A:94": "Samsung Electronics Co.,Ltd",
        "D0:DF:C7": "Samsung Electronics Co.,Ltd",
        "D0:C1:B1": "Samsung Electronics Co.,Ltd",
        "80:18:A7": "Samsung Electronics Co.,Ltd",
        "F4:7B:5E": "Samsung Electronics Co.,Ltd",
        "70:F9:27": "Samsung Electronics Co.,Ltd",
        "34:E7:1C": "Shenzhen YOUHUA Technology Co., Ltd",
        "88:6A:B1": "vivo Mobile Communication Co., Ltd.",
        "6C:1E:90": "Hansol Technics Co., Ltd.",
        "00:5A:13": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C4:50:06": "Samsung Electronics Co.,Ltd",
        "88:32:9B": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "14:49:E0": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "D0:25:44": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
        "BC:44:86": "Samsung Electronics Co.,Ltd",
        "20:D3:90": "Samsung Electronics Co.,Ltd",
        "94:01:C2": "Samsung Electronics Co.,Ltd",
        "50:FC:9F": "Samsung Electronics Co.,Ltd",
        "38:0B:40": "Samsung Electronics Co.,Ltd",
        "B8:FF:61": "Apple, Inc.",
        "94:61:24": "Pason Systems",
        "F0:72:8C": "Samsung Electronics Co.,Ltd",
        "34:AA:8B": "Samsung Electronics Co.,Ltd",
        "24:DB:ED": "Samsung Electronics Co.,Ltd",
        "C8:DE:51": "IntegraOptics",
        "98:F0:58": "Lynxspring, Incl.",
        "68:C4:4D": "Motorola Mobility LLC, a Lenovo Company",
        "40:0D:10": "ARRIS Group, Inc.",
        "94:3D:C9": "Asahi Net, Inc.",
        "44:04:44": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
        "00:17:7E": "Meshcom Technologies Inc.",
        "A0:04:60": "NETGEAR",
        "98:84:E3": "Texas Instruments",
        "38:D2:69": "Texas Instruments",
        "C8:FD:19": "Texas Instruments",
        "50:8C:B1": "Texas Instruments",
        "C4:F5:A5": "Kumalift Co., Ltd.",
        "70:B1:4E": "ARRIS Group, Inc.",
        "30:44:87": "Hefei Radio Communication Technology Co., Ltd ",
        "2C:9D:1E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:81:C4": "Cisco Systems, Inc",
        "58:E8:76": "IEEE Registration Authority",
        "D0:37:42": "Yulong Computer Telecommunication Scientific (Shenzhen) Co.,Ltd",
        "00:17:65": "Nortel Networks",
        "00:15:E8": "Nortel Networks",
        "00:15:9B": "Nortel Networks",
        "00:0F:06": "Nortel Networks",
        "84:B5:41": "Samsung Electronics Co.,Ltd",
        "00:6F:64": "Samsung Electronics Co.,Ltd",
        "DC:66:72": "Samsung Electronics Co.,Ltd",
        "EC:8E:B5": "Hewlett Packard",
        "70:AF:6A": "SHENZHEN FENGLIAN TECHNOLOGY CO., LTD.",
        "20:F5:43": "Hui Zhou Gaoshengda Technology Co.,LTD",
        "E0:DD:C0": "vivo Mobile Communication Co., Ltd.",
        "00:16:4D": "Alcatel-Lucent IPD",
        "00:1A:F0": "Alcatel-Lucent IPD",
        "38:52:1A": "Nokia",
        "00:1E:40": "Shanghai DareGlobal Technologies Co.,Ltd",
        "94:D7:23": "Shanghai DareGlobal Technologies Co.,Ltd",
        "C4:04:7B": "Shenzhen YOUHUA Technology Co., Ltd",
        "20:F4:1B": "Shenzhen Bilian electronic CO.,LTD",
        "FC:FA:F7": "Shanghai Baud Data Communication Co.,Ltd.",
        "D8:26:B9": "Guangdong Coagent Electronics S&amp;T Co.,Ltd.",
        "AC:9C:E4": "Alcatel-Lucent Shanghai Bell Co., Ltd",
        "00:23:3E": "Alcatel-Lucent IPD",
        "6C:BE:E9": "Alcatel-Lucent IPD",
        "00:15:40": "Nortel Networks",
        "00:1E:CA": "Nortel Networks",
        "00:13:0A": "Nortel Networks",
        "00:1F:0A": "Nortel Networks",
        "F8:E6:1A": "Samsung Electronics Co.,Ltd",
        "A0:91:C8": "zte corporation",
        "6C:A8:58": "Fiberhome Telecommunication Technologies Co.,LTD",
        "CC:2D:8C": "LG ELECTRONICS INC",
        "98:D6:F7": "LG Electronics (Mobile Communications)",
        "70:05:14": "LG Electronics (Mobile Communications)",
        "E8:92:A4": "LG Electronics (Mobile Communications)",
        "10:68:3F": "LG Electronics (Mobile Communications)",
        "40:B0:FA": "LG Electronics (Mobile Communications)",
        "00:25:E5": "LG Electronics (Mobile Communications)",
        "00:21:FB": "LG Electronics (Mobile Communications)",
        "34:FC:EF": "LG Electronics (Mobile Communications)",
        "BC:F5:AC": "LG Electronics (Mobile Communications)",
        "A8:4E:3F": "Hitron Technologies. Inc",
        "0C:48:85": "LG Electronics (Mobile Communications)",
        "00:22:A9": "LG Electronics (Mobile Communications)",
        "2C:6A:6F": "IEEE Registration Authority",
        "08:D8:33": "Shenzhen RF Technology Co., Ltd",
        "A4:60:32": "MRV Communications (Networks) LTD",
        "40:66:7A": "mediola - connected living AG",
        "68:A0:F6": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:0E:5C": "ARRIS Group, Inc.",
        "84:5D:D7": "Shenzhen Netcom Electronics Co.,Ltd",
        "00:B0:64": "Cisco Systems, Inc",
        "9C:2A:83": "Samsung Electronics Co.,Ltd",
        "C8:02:10": "LG Innotek",
        "A0:39:F7": "LG Electronics (Mobile Communications)",
        "1C:CA:E3": "IEEE Registration Authority",
        "E4:95:6E": "IEEE Registration Authority",
        "B4:37:D1": "IEEE Registration Authority",
        "00:55:DA": "IEEE Registration Authority",
        "78:C2:C0": "IEEE Registration Authority",
        "00:0E:E8": "Zioncom Electronics (Shenzhen) Ltd.",
        "00:C0:95": "ZNYX Networks, Inc.",
        "00:20:25": "CONTROL TECHNOLOGY, INC.",
        "00:1A:6B": "Universal Global Scientific Industrial Co., Ltd.",
        "00:16:41": "Universal Global Scientific Industrial Co., Ltd.",
        "00:10:C6": "Universal Global Scientific Industrial Co., Ltd.",
        "00:24:7E": "Universal Global Scientific Industrial Co., Ltd.",
        "00:DD:0A": "UNGERMANN-BASS INC.",
        "68:35:63": "SHENZHEN LIOWN ELECTRONICS CO.,LTD.",
        "00:40:72": "Applied Innovation Inc.",
        "00:19:38": "UMB Communications Co., Ltd.",
        "44:39:C4": "Universal Global Scientific Industrial Co., Ltd.",
        "40:2C:F4": "Universal Global Scientific Industrial Co., Ltd.",
        "00:1E:37": "Universal Global Scientific Industrial Co., Ltd.",
        "1C:57:D8": "Kraftway Corporation PLC",
        "00:23:18": "Toshiba",
        "B8:6B:23": "Toshiba",
        "00:08:F1": "Voltaire",
        "00:19:9D": "Vizio, Inc",
        "00:E0:8B": "QLogic Corporation",
        "D8:EB:97": "TRENDnet, Inc.",
        "00:1C:7E": "Toshiba",
        "00:25:17": "Venntis, LLC",
        "00:60:0F": "Westell Technologies Inc.",
        "00:18:3A": "Westell Technologies Inc.",
        "60:02:B4": "Wistron Neweb Corporation",
        "94:DF:4E": "Wistron InfoComm(Kunshan)Co.,Ltd.",
        "98:EE:CB": "Wistron Infocomm (Zhongshan) Corporation",
        "00:1B:FE": "Zavio Inc.",
        "54:10:EC": "Microchip Technology Inc.",
        "00:04:A3": "Microchip Technology Inc.",
        "78:9C:E7": "Shenzhen Aikede Technology Co., Ltd",
        "50:9F:3B": "OI ELECTRIC CO.,LTD",
        "44:6E:E5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "88:F7:C7": "Technicolor CH USA Inc.",
        "68:3E:34": "MEIZU Technology Co., Ltd.",
        "C8:77:8B": "Mercury Systems – Trusted Mission Solutions, Inc. ",
        "00:04:4B": "NVIDIA",
        "AC:9B:0A": "Sony Corporation",
        "10:4F:A8": "Sony Corporation",
        "00:0B:6B": "Wistron Neweb Corporation",
        "AC:04:0B": "Peloton Interactive, Inc",
        "48:FC:B6": "LAVA INTERNATIONAL(H.K) LIMITED",
        "B0:E2:35": "Xiaomi Communications Co Ltd",
        "40:C7:29": "Sagemcom Broadband SAS",
        "14:C9:13": "LG Electronics",
        "F8:A0:97": "ARRIS Group, Inc.",
        "FC:23:25": "EosTek (Shenzhen) Co., Ltd.",
        "FC:3D:93": "LONGCHEER TELECOMMUNICATION LIMITED",
        "D8:E0:B8": "BULAT LLC",
        "60:31:97": "Zyxel Communications Corporation",
        "58:8B:F3": "Zyxel Communications Corporation",
        "50:67:F0": "Zyxel Communications Corporation",
        "00:13:49": "Zyxel Communications Corporation",
        "E0:98:61": "Motorola Mobility LLC, a Lenovo Company",
        "9C:8E:CD": "Amcrest Technologies",
        "A0:09:ED": "Avaya Inc",
        "00:14:B4": "General Dynamics United Kingdom Ltd",
        "A0:B4:37": "GD Mission Systems",
        "8C:6D:50": "SHENZHEN MTC CO LTD",
        "00:F6:63": "Cisco Systems, Inc",
        "A0:60:90": "Samsung Electronics Co.,Ltd",
        "BC:76:5E": "Samsung Electronics Co.,Ltd",
        "E0:A8:B8": "Le Shi Zhi Xin Electronic Technology (Tianjin) Limited",
        "F4:5B:73": "Wanjiaan Interconnected Technology Co., Ltd",
        "B8:81:98": "Intel Corporate",
        "B0:D7:CC": "Tridonic GmbH & Co KG",
        "2C:DD:A3": "Point Grey Research Inc.",
        "00:80:9F": "ALE International",
        "48:C6:63": "GTO Access Systems LLC",
        "00:5F:86": "Cisco Systems, Inc",
        "38:1D:D9": "FN-LINK TECHNOLOGY LIMITED",
        "1C:B9:C4": "Ruckus Wireless",
        "8C:59:C3": "ADB Italia ",
        "B8:24:F0": "SOYO Technology Development Co., Ltd.",
        "D8:5B:2A": "Samsung Electronics Co.,Ltd",
        "FC:A8:9A": "Sunitec Enterprise Co.,Ltd",
        "1C:7B:23": "Qingdao Hisense Communications Co.,Ltd.",
        "00:0B:DE": "TELDIX GmbH",
        "CC:D3:1E": "IEEE Registration Authority",
        "34:B3:54": "HUAWEI TECHNOLOGIES CO.,LTD",
        "1C:6E:76": "Quarion Technology Inc",
        "90:C1:C6": "Apple, Inc.",
        "6C:0E:E6": "Chengdu Xiyida Electronic Technology Co,.Ltd",
        "CC:50:0A": "Fiberhome Telecommunication Technologies Co.,LTD",
        "D0:46:DC": "Southwest Research Institute",
        "70:A2:B3": "Apple, Inc.",
        "F4:0F:24": "Apple, Inc.",
        "4C:57:CA": "Apple, Inc.",
        "00:07:63": "Sunniwell Cyber Tech. Co., Ltd.",
        "00:62:EC": "Cisco Systems, Inc",
        "CC:16:7E": "Cisco Systems, Inc",
        "C4:6A:B7": "Xiaomi Communications Co Ltd",
        "00:0A:ED": "HARTING Electronics GmbH",
        "24:0A:11": "TCT mobile ltd",
        "D8:E5:6D": "TCT mobile ltd",
        "54:05:93": "WOORI ELEC Co.,Ltd",
        "C0:2F:F1": "Volta Networks",
        "E8:A7:F2": "sTraffic",
        "00:1F:20": "Logitech Europe SA",
        "74:1F:4A": "Hangzhou H3C Technologies Co., Limited",
        "E4:1D:2D": "Mellanox Technologies, Inc.",
        "0C:DA:41": "Hangzhou H3C Technologies Co., Limited",
        "74:25:8A": "Hangzhou H3C Technologies Co., Limited",
        "A0:B6:62": "Acutvista Innovation Co., Ltd.",
        "E4:2F:56": "OptoMET GmbH",
        "F8:DA:0C": "Hon Hai Precision Ind. Co.,Ltd.",
        "1C:1B:0D": "GIGA-BYTE TECHNOLOGY CO.,LTD.",
        "48:E9:F1": "Apple, Inc.",
        "90:38:09": "Ericsson AB",
        "00:A0:06": "IMAGE DATA PROCESSING SYSTEM GROUP",
        "C8:3F:26": "Microsoft Corporation",
        "34:97:F6": "ASUSTek COMPUTER INC.",
        "50:68:0A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:22:38": "LOGIPLUS",
        "00:0C:49": "Dangaard Telecom Denmark A/S",
        "00:08:B9": "Kaonmedia CO., LTD.",
        "60:B3:87": "Synergics Technologies GmbH",
        "A4:D8:CA": "HONG KONG WATER WORLD TECHNOLOGY CO. LIMITED",
        "80:19:FE": "JianLing Technology CO., LTD",
        "60:B4:F7": "Plume Design Inc",
        "48:7A:DA": "Hangzhou H3C Technologies Co., Limited",
        "00:1F:45": "Enterasys",
        "00:1E:90": "Elitegroup Computer Systems Co.,Ltd.",
        "00:22:B1": "Elbit Systems Ltd.",
        "00:00:B4": "Edimax Technology Co. Ltd.",
        "00:16:8F": "GN Netcom A/S",
        "00:0D:87": "Elitegroup Computer Systems Co.,Ltd.",
        "10:78:D2": "Elitegroup Computer Systems Co.,Ltd.",
        "00:21:97": "Elitegroup Computer Systems Co.,Ltd.",
        "E4:F3:F5": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
        "A0:8C:FD": "Hewlett Packard",
        "00:0E:03": "Emulex Corporation",
        "00:CA:E5": "Cisco Systems, Inc",
        "00:42:68": "Cisco Systems, Inc",
        "48:83:C7": "Sagemcom Broadband SAS",
        "40:16:3B": "Samsung Electronics Co.,Ltd",
        "44:65:0D": "Amazon Technologies Inc.",
        "D4:F2:07": "DIAODIAO(Beijing)Technology CO.,Ltd",
        "D4:AD:2D": "Fiberhome Telecommunication Technologies Co.,LTD",
        "F0:8C:FB": "Fiberhome Telecommunication Technologies Co.,LTD",
        "48:55:5F": "Fiberhome Telecommunication Technologies Co.,LTD",
        "FC:3F:7C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "38:4C:4F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "0C:BF:3F": "Shenzhen Lencotion Technology Co.,Ltd",
        "50:FF:99": "IEEE Registration Authority",
        "84:E3:23": "Green Wave Telecommunication SDN BHD",
        "70:5A:9E": "Technicolor CH USA Inc.",
        "04:A3:16": "Texas Instruments",
        "14:0C:5B": "PLNetworks",
        "00:17:06": "Techfaithwireless Communication Technology Limited.",
        "FC:08:4A": "FUJITSU LIMITED",
        "BC:98:89": "Fiberhome Telecommunication Technologies Co.,LTD",
        "24:61:5A": "China Mobile Group Device Co.,Ltd.",
        "40:5E:E1": "Shenzhen H&T Intelligent Control Co.,Ltd.",
        "00:25:78": "JSC Concern Sozvezdie",
        "30:B4:9E": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "C8:38:70": "Samsung Electronics Co.,Ltd",
        "1C:55:3A": "QianGua Corp.",
        "34:E7:0B": "HAN Networks Co., Ltd",
        "00:78:88": "Cisco Systems, Inc",
        "90:03:25": "HUAWEI TECHNOLOGIES CO.,LTD",
        "98:E7:F5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "08:5B:DA": "CliniCare LTD",
        "1C:C0:35": "PLANEX COMMUNICATIONS INC.",
        "34:54:3C": "TAKAOKA TOKO CO.,LTD.",
        "18:66:DA": "Dell Inc.",
        "58:32:77": "Reliance Communications LLC",
        "24:8A:07": "Mellanox Technologies, Inc.",
        "9C:9D:5D": "Raden Inc",
        "DC:4D:23": "MRV Comunications",
        "00:23:B3": "Lyyn AB",
        "40:2E:28": "MiXTelematics",
        "6C:8F:B5": "Microsoft Mobile Oy",
        "00:8E:73": "Cisco Systems, Inc",
        "00:15:C1": "Sony Interactive Entertainment Inc.",
        "A0:9D:91": "SoundBridge",
        "40:B6:88": "LEGIC Identsystems AG",
        "9C:D4:8B": "Innolux Technology Europe BV",
        "90:A6:2F": "NAVER",
        "C0:C5:22": "ARRIS Group, Inc.",
        "1C:9E:46": "Apple, Inc.",
        "C4:E5:10": "Mechatro, Inc.",
        "18:A6:F7": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "00:35:1A": "Cisco Systems, Inc",
        "00:AF:1F": "Cisco Systems, Inc",
        "80:38:96": "SHARP Corporation",
        "00:60:EC": "HERMARY OPTO ELECTRONICS INC.",
        "C0:CC:F8": "Apple, Inc.",
        "9C:4F:DA": "Apple, Inc.",
        "84:89:AD": "Apple, Inc.",
        "AC:3A:7A": "Roku, Inc.",
        "B8:3E:59": "Roku, Inc.",
        "DC:3A:5E": "Roku, Inc.",
        "00:1A:73": "Gemtek Technology Co., Ltd.",
        "00:90:4B": "Gemtek Technology Co., Ltd.",
        "00:1A:7F": "GCI Science & Technology Co.,LTD",
        "00:18:0F": "Nokia Danmark A/S",
        "C8:97:9F": "Nokia Corporation",
        "EC:F3:5B": "Nokia Corporation",
        "54:44:08": "Nokia Corporation",
        "3C:C2:43": "Nokia Corporation",
        "00:21:FC": "Nokia Danmark A/S",
        "00:1F:5D": "Nokia Danmark A/S",
        "00:1F:01": "Nokia Danmark A/S",
        "00:1B:EE": "Nokia Danmark A/S",
        "00:19:79": "Nokia Danmark A/S",
        "00:25:D0": "Nokia Danmark A/S",
        "00:24:D4": "FREEBOX SAS",
        "34:7E:39": "Nokia Danmark A/S",
        "00:50:7F": "DrayTek Corp.",
        "64:77:91": "Samsung Electronics Co.,Ltd",
        "9C:E6:E7": "Samsung Electronics Co.,Ltd",
        "9C:02:98": "Samsung Electronics Co.,Ltd",
        "28:98:7B": "Samsung Electronics Co.,Ltd",
        "54:FA:3E": "Samsung Electronics Co.,Ltd",
        "0C:89:10": "Samsung Electronics Co.,Ltd",
        "78:AB:BB": "Samsung Electronics Co.,Ltd",
        "D8:C4:E9": "Samsung Electronics Co.,Ltd",
        "BC:D1:1F": "Samsung Electronics Co.,Ltd",
        "F4:42:8F": "Samsung Electronics Co.,Ltd",
        "00:90:A2": "CyberTAN Technology Inc.",
        "00:90:D6": "Crystal Group, Inc.",
        "44:6D:6C": "Samsung Electronics Co.,Ltd",
        "00:F4:6F": "Samsung Electronics Co.,Ltd",
        "0C:71:5D": "Samsung Electronics Co.,Ltd",
        "9C:80:DF": "Arcadyan Technology Corporation",
        "00:23:08": "Arcadyan Technology Corporation",
        "88:03:55": "Arcadyan Technology Corporation",
        "34:BB:1F": "BlackBerry RTS",
        "40:6F:2A": "BlackBerry RTS",
        "7C:1C:F1": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:F5:57": "HUAWEI TECHNOLOGIES CO.,LTD",
        "E0:28:61": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D0:D0:4B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "48:00:31": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D4:76:EA": "zte corporation",
        "00:17:5A": "Cisco Systems, Inc",
        "08:96:D7": "AVM GmbH",
        "50:6A:03": "NETGEAR",
        "10:0D:7F": "NETGEAR",
        "50:4A:6E": "NETGEAR",
        "4C:09:D4": "Arcadyan Technology Corporation",
        "18:C0:86": "Broadcom",
        "00:10:18": "Broadcom",
        "C8:FF:28": "Liteon Technology Corporation",
        "B8:16:19": "ARRIS Group, Inc.",
        "B0:77:AC": "ARRIS Group, Inc.",
        "FC:B4:E6": "ASKEY COMPUTER CORP",
        "00:19:2C": "ARRIS Group, Inc.",
        "00:19:5E": "ARRIS Group, Inc.",
        "00:1A:1B": "ARRIS Group, Inc.",
        "00:1A:66": "ARRIS Group, Inc.",
        "00:1A:77": "ARRIS Group, Inc.",
        "64:ED:57": "ARRIS Group, Inc.",
        "A4:ED:4E": "ARRIS Group, Inc.",
        "00:21:1E": "ARRIS Group, Inc.",
        "00:21:80": "ARRIS Group, Inc.",
        "00:1B:DD": "ARRIS Group, Inc.",
        "00:1D:6B": "ARRIS Group, Inc.",
        "00:1D:BE": "ARRIS Group, Inc.",
        "00:12:C9": "ARRIS Group, Inc.",
        "00:23:A2": "ARRIS Group, Inc.",
        "00:23:ED": "ARRIS Group, Inc.",
        "00:1B:52": "ARRIS Group, Inc.",
        "00:1E:8D": "ARRIS Group, Inc.",
        "E0:46:9A": "NETGEAR",
        "30:46:9A": "NETGEAR",
        "00:24:93": "ARRIS Group, Inc.",
        "00:26:41": "ARRIS Group, Inc.",
        "00:15:D0": "ARRIS Group, Inc.",
        "00:15:96": "ARRIS Group, Inc.",
        "04:E6:76": "AMPAK Technology, Inc.",
        "00:22:F4": "AMPAK Technology, Inc.",
        "00:1D:BA": "Sony Corporation",
        "00:24:BE": "Sony Corporation",
        "0C:FE:45": "Sony Interactive Entertainment Inc.",
        "20:16:D8": "Liteon Technology Corporation",
        "F8:D0:AC": "Sony Interactive Entertainment Inc.",
        "20:E5:64": "ARRIS Group, Inc.",
        "90:B1:34": "ARRIS Group, Inc.",
        "40:B7:F3": "ARRIS Group, Inc.",
        "00:17:E2": "ARRIS Group, Inc.",
        "00:16:75": "ARRIS Group, Inc.",
        "00:0C:E5": "ARRIS Group, Inc.",
        "00:03:E0": "ARRIS Group, Inc.",
        "00:D0:C9": "ADVANTECH CO., LTD.",
        "64:87:D7": "ADB Broadband Italia",
        "E0:B2:F1": "FN-LINK TECHNOLOGY LIMITED",
        "0C:4C:39": "MitraStar Technology Corp.",
        "74:88:8B": "ADB Broadband Italia",
        "00:8C:54": "ADB Broadband Italia",
        "00:24:7B": "Actiontec Electronics, Inc",
        "00:04:E3": "Accton Technology Corp",
        "00:10:B5": "Accton Technology Corp",
        "00:19:74": "16063",
        "E8:61:7E": "Liteon Technology Corporation",
        "18:CF:5E": "Liteon Technology Corporation",
        "F0:27:2D": "Amazon Technologies Inc.",
        "84:D6:D0": "Amazon Technologies Inc.",
        "18:FE:34": "Espressif Inc.",
        "38:22:9D": "ADB Broadband Italia",
        "A4:52:6F": "ADB Broadband Italia",
        "60:5B:B4": "AzureWave Technology Inc.",
        "64:D9:54": "Taicang T&W Electronics",
        "5C:36:B8": "TCL King Electrical Appliances (Huizhou) Co., Ltd",
        "00:AA:01": "Intel Corporation",
        "98:5F:D3": "Microsoft Corporation",
        "00:DA:55": "Cisco Systems, Inc",
        "18:E3:BC": "TCT mobile ltd",
        "CC:1F:C4": "InVue",
        "00:AA:00": "Intel Corporation",
        "00:C2:C6": "Intel Corporate",
        "5C:D2:E4": "Intel Corporate",
        "28:B2:BD": "Intel Corporate",
        "00:22:43": "AzureWave Technology Inc.",
        "00:00:6E": "Artisoft Inc.",
        "44:87:23": "HOYA SERVICE CORPORATION",
        "D8:6C:02": "Huaqin Telecom Technology Co.,Ltd",
        "60:BE:B5": "Motorola Mobility LLC, a Lenovo Company",
        "F8:F1:B6": "Motorola Mobility LLC, a Lenovo Company",
        "3C:FD:FE": "Intel Corporate",
        "A4:C4:94": "Intel Corporate",
        "90:2E:1C": "Intel Corporate",
        "A4:34:D9": "Intel Corporate",
        "68:5D:43": "Intel Corporate",
        "A0:36:9F": "Intel Corporate",
        "64:D4:DA": "Intel Corporate",
        "40:25:C2": "Intel Corporate",
        "50:2D:A2": "Intel Corporate",
        "78:92:9C": "Intel Corporate",
        "84:3A:4B": "Intel Corporate",
        "5C:51:4F": "Intel Corporate",
        "A4:4E:31": "Intel Corporate",
        "4C:EB:42": "Intel Corporate",
        "F8:16:54": "Intel Corporate",
        "60:6C:66": "Intel Corporate",
        "4C:80:93": "Intel Corporate",
        "AC:72:89": "Intel Corporate",
        "44:85:00": "Intel Corporate",
        "0C:D2:92": "Intel Corporate",
        "DC:A9:71": "Intel Corporate",
        "58:94:6B": "Intel Corporate",
        "00:24:D7": "Intel Corporate",
        "00:24:D6": "Intel Corporate",
        "00:1D:E0": "Intel Corporate",
        "4C:79:BA": "Intel Corporate",
        "84:A6:C8": "Intel Corporate",
        "58:91:CF": "Intel Corporate",
        "0C:8B:FD": "Intel Corporate",
        "00:21:5C": "Intel Corporate",
        "00:21:6B": "Intel Corporate",
        "00:22:FB": "Intel Corporate",
        "00:15:17": "Intel Corporate",
        "A0:A8:CD": "Intel Corporate",
        "5C:C5:D4": "Intel Corporate",
        "00:1E:64": "Intel Corporate",
        "F4:F1:E1": "Motorola Mobility LLC, a Lenovo Company",
        "9C:D9:17": "Motorola Mobility LLC, a Lenovo Company",
        "90:68:C3": "Motorola Mobility LLC, a Lenovo Company",
        "3C:19:7D": "Ericsson AB",
        "B4:E1:0F": "Dell Inc.",
        "00:22:19": "Dell Inc.",
        "00:24:E8": "Dell Inc.",
        "B0:83:FE": "Dell Inc.",
        "34:17:EB": "Dell Inc.",
        "F8:BC:12": "Dell Inc.",
        "18:A9:9B": "Dell Inc.",
        "00:13:72": "Dell Inc.",
        "00:11:43": "Dell Inc.",
        "4C:76:25": "Dell Inc.",
        "44:A8:42": "Dell Inc.",
        "00:25:3C": "2Wire Inc",
        "34:EF:44": "2Wire Inc",
        "B0:E7:54": "2Wire Inc",
        "F0:1F:AF": "Dell Inc.",
        "00:18:8B": "Dell Inc.",
        "00:08:74": "Dell Inc.",
        "B8:E6:25": "2Wire Inc",
        "00:1D:5A": "2Wire Inc",
        "1C:44:19": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "5C:35:3B": "Compal Broadband Networks, Inc.",
        "28:FA:A0": "vivo Mobile Communication Co., Ltd.",
        "EC:DF:3A": "vivo Mobile Communication Co., Ltd.",
        "F4:29:81": "vivo Mobile Communication Co., Ltd.",
        "84:F6:FA": "Miovision Technologies Incorporated",
        "70:10:6F": "Hewlett Packard Enterprise",
        "F8:E7:1E": "Ruckus Wireless",
        "08:86:3B": "Belkin International Inc.",
        "24:7C:4C": "Herman Miller",
        "E4:6F:13": "D-Link International",
        "2C:56:DC": "ASUSTek COMPUTER INC.",
        "00:31:46": "Juniper Networks",
        "00:60:4C": "Sagemcom Broadband SAS",
        "00:1F:95": "Sagemcom Broadband SAS",
        "00:23:48": "Sagemcom Broadband SAS",
        "00:26:91": "Sagemcom Broadband SAS",
        "98:8B:5D": "Sagemcom Broadband SAS",
        "90:01:3B": "Sagemcom Broadband SAS",
        "7C:03:4C": "Sagemcom Broadband SAS",
        "6C:2E:85": "Sagemcom Broadband SAS",
        "94:FE:F4": "Sagemcom Broadband SAS",
        "34:B1:F7": "Texas Instruments",
        "2C:FD:37": "Blue Calypso, Inc.",
        "0C:61:27": "Actiontec Electronics, Inc",
        "3C:D9:2B": "Hewlett Packard",
        "78:DE:E4": "Texas Instruments",
        "00:18:33": "Texas Instruments",
        "00:18:34": "Texas Instruments",
        "00:17:E3": "Texas Instruments",
        "00:18:30": "Texas Instruments",
        "00:23:D4": "Texas Instruments",
        "BC:F6:85": "D-Link International",
        "78:54:2E": "D-Link International",
        "C4:A8:1D": "D-Link International",
        "00:21:91": "D-Link Corporation",
        "AC:F1:DF": "D-Link International",
        "C0:E4:22": "Texas Instruments",
        "D0:07:90": "Texas Instruments",
        "3C:7D:B1": "Texas Instruments",
        "F4:FC:32": "Texas Instruments",
        "90:D7:EB": "Texas Instruments",
        "00:17:E8": "Texas Instruments",
        "00:17:83": "Texas Instruments",
        "24:35:CC": "Zhongshan Scinan Internet of Things Co.,Ltd.",
        "2C:30:33": "NETGEAR",
        "CC:46:D6": "Cisco Systems, Inc",
        "00:41:D2": "Cisco Systems, Inc",
        "2C:AB:00": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A8:CA:7B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "04:BF:6D": "Zyxel Communications Corporation",
        "F8:8F:CA": "Google, Inc.",
        "38:98:D8": "MERITECH CO.,LTD",
        "94:86:CD": "SEOUL ELECTRONICS&TELECOM",
        "38:97:D6": "Hangzhou H3C Technologies Co., Limited",
        "1C:A7:70": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LTD",
        "44:19:B6": "Hangzhou Hikvision Digital Technology Co.,Ltd.",
        "68:DB:CA": "Apple, Inc.",
        "08:66:98": "Apple, Inc.",
        "BC:54:36": "Apple, Inc.",
        "04:4B:ED": "Apple, Inc.",
        "6C:8D:C1": "Apple, Inc.",
        "84:AC:FB": "Crouzet Automatismes",
        "7C:BB:8A": "Nintendo Co., Ltd.",
        "FC:FF:AA": "IEEE Registration Authority",
        "0C:D7:46": "Apple, Inc.",
        "60:A3:7D": "Apple, Inc.",
        "88:A2:5E": "Juniper Networks",
        "54:1E:56": "Juniper Networks",
        "88:96:B6": "Global Fire Equipment S.A.",
        "88:B8:D0": "Dongguan Koppo Electronic Co.,Ltd",
        "60:19:71": "ARRIS Group, Inc.",
        "F8:CA:B8": "Dell Inc.",
        "00:11:11": "Intel Corporation",
        "00:13:02": "Intel Corporate",
        "6C:CA:08": "ARRIS Group, Inc.",
        "78:71:9C": "ARRIS Group, Inc.",
        "D4:05:98": "ARRIS Group, Inc.",
        "E8:33:81": "ARRIS Group, Inc.",
        "8C:7F:3B": "ARRIS Group, Inc.",
        "5C:57:1A": "ARRIS Group, Inc.",
        "E8:89:2C": "ARRIS Group, Inc.",
        "94:87:7C": "ARRIS Group, Inc.",
        "40:70:09": "ARRIS Group, Inc.",
        "08:3E:0C": "ARRIS Group, Inc.",
        "3C:36:E4": "ARRIS Group, Inc.",
        "1C:1B:68": "ARRIS Group, Inc.",
        "00:04:23": "Intel Corporation",
        "20:73:55": "ARRIS Group, Inc.",
        "F8:ED:A5": "ARRIS Group, Inc.",
        "54:65:DE": "ARRIS Group, Inc.",
        "58:AC:78": "Cisco Systems, Inc",
        "78:0A:C7": "Baofeng TV Co., Ltd.",
        "00:0D:0B": "BUFFALO.INC",
        "00:1D:73": "BUFFALO.INC",
        "00:16:01": "BUFFALO.INC",
        "74:03:BD": "BUFFALO.INC",
        "B8:FC:9A": "Le Shi Zhi Xin Electronic Technology (Tianjin) Limited",
        "A4:5D:36": "Hewlett Packard",
        "F0:92:1C": "Hewlett Packard",
        "A0:48:1C": "Hewlett Packard",
        "A0:1D:48": "Hewlett Packard",
        "40:A8:F0": "Hewlett Packard",
        "88:51:FB": "Hewlett Packard",
        "08:2E:5F": "Hewlett Packard",
        "E4:11:5B": "Hewlett Packard",
        "28:92:4A": "Hewlett Packard",
        "28:80:23": "Hewlett Packard",
        "CC:3E:5F": "Hewlett Packard",
        "D8:9D:67": "Hewlett Packard",
        "00:14:C2": "Hewlett Packard",
        "00:80:5F": "Hewlett Packard",
        "00:18:FE": "Hewlett Packard",
        "00:1A:4B": "Hewlett Packard",
        "00:24:81": "Hewlett Packard",
        "00:0F:61": "Hewlett Packard",
        "48:0F:CF": "Hewlett Packard",
        "D4:0B:1A": "HTC Corporation",
        "94:53:30": "Hon Hai Precision Ind. Co.,Ltd.",
        "A0:8D:16": "HUAWEI TECHNOLOGIES CO.,LTD",
        "4C:D0:8A": "HUMAX Co., Ltd.",
        "CC:4E:EC": "HUMAX Co., Ltd.",
        "40:3D:EC": "HUMAX Co., Ltd.",
        "EC:4D:47": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C4:40:44": "RackTop Systems Inc.",
        "4C:A1:61": "Rain Bird Corporation",
        "8C:AB:8E": "Shanghai Feixun Communication Co.,Ltd.",
        "FC:64:BA": "Xiaomi Communications Co Ltd",
        "90:60:F1": "Apple, Inc.",
        "F8:D1:11": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "B0:48:7A": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "94:0C:6D": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "A4:51:6F": "Microsoft Mobile Oy",
        "54:27:58": "Motorola (Wuhan) Mobility Technologies Communication Co., Ltd.",
        "00:24:2B": "Hon Hai Precision Ind. Co.,Ltd.",
        "08:18:1A": "zte corporation",
        "00:1E:73": "zte corporation",
        "00:15:EB": "zte corporation",
        "00:1C:25": "Hon Hai Precision Ind. Co.,Ltd.",
        "00:19:7E": "Hon Hai Precision Ind. Co.,Ltd.",
        "90:FB:A6": "Hon Hai Precision Ind. Co.,Ltd.",
        "44:37:E6": "Hon Hai Precision Ind. Co.,Ltd.",
        "CC:AF:78": "Hon Hai Precision Ind. Co.,Ltd.",
        "F4:B7:E2": "Hon Hai Precision Ind. Co.,Ltd.",
        "64:70:02": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "10:FE:ED": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "64:56:01": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "F0:27:65": "Murata Manufacturing Co., Ltd.",
        "5C:F8:A1": "Murata Manufacturing Co., Ltd.",
        "44:A7:CF": "Murata Manufacturing Co., Ltd.",
        "00:13:E0": "Murata Manufacturing Co., Ltd.",
        "EC:26:CA": "TP-LINK TECHNOLOGIES CO.,LTD.",
        "94:71:AC": "TCT mobile ltd",
        "2C:08:8C": "HUMAX Co., Ltd.",
        "1C:99:4C": "Murata Manufacturing Co., Ltd.",
        "F4:55:9C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "80:B6:86": "HUAWEI TECHNOLOGIES CO.,LTD",
        "10:C6:1F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "CC:96:A0": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F8:01:13": "HUAWEI TECHNOLOGIES CO.,LTD",
        "A4:99:47": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C8:D1:5E": "HUAWEI TECHNOLOGIES CO.,LTD",
        "78:59:68": "Hon Hai Precision Ind. Co.,Ltd.",
        "C0:70:09": "HUAWEI TECHNOLOGIES CO.,LTD",
        "80:38:BC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C4:07:2F": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F4:8E:92": "HUAWEI TECHNOLOGIES CO.,LTD",
        "00:66:4B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "9C:C1:72": "HUAWEI TECHNOLOGIES CO.,LTD",
        "24:7F:3C": "HUAWEI TECHNOLOGIES CO.,LTD",
        "58:1F:28": "HUAWEI TECHNOLOGIES CO.,LTD",
        "EC:CB:30": "HUAWEI TECHNOLOGIES CO.,LTD",
        "F4:DC:F9": "HUAWEI TECHNOLOGIES CO.,LTD",
        "30:87:30": "HUAWEI TECHNOLOGIES CO.,LTD",
        "C0:57:BC": "Avaya Inc",
        "64:A7:DD": "Avaya Inc",
        "24:1F:A0": "HUAWEI TECHNOLOGIES CO.,LTD",
        "18:C5:8A": "HUAWEI TECHNOLOGIES CO.,LTD",
        "08:00:28": "Texas Instruments",
        "40:5F:C2": "Texas Instruments",
        "E0:E5:CF": "Texas Instruments",
        "68:DF:DD": "Xiaomi Communications Co Ltd",
        "70:54:F5": "HUAWEI TECHNOLOGIES CO.,LTD",
        "DC:D2:FC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "90:17:AC": "HUAWEI TECHNOLOGIES CO.,LTD",
        "34:CD:BE": "HUAWEI TECHNOLOGIES CO.,LTD",
        "D8:49:0B": "HUAWEI TECHNOLOGIES CO.,LTD",
        "44:32:2A": "Avaya Inc",
        "70:38:EE": "Avaya Inc",
        "70:30:18": "Avaya Inc",
        "9C:28:EF": "HUAWEI TECHNOLOGIES CO.,LTD",
        "EC:24:B8": "Texas Instruments",
        "7C:EC:79": "Texas Instruments",
        "68:9E:19": "Texas Instruments",
        "20:CD:39": "Texas Instruments",
        "B4:99:4C": "Texas Instruments",
        "A4:25:1B": "Avaya Inc",
        "64:6A:52": "Avaya Inc",
        "00:10:0B": "Cisco Systems, Inc",
        "00:17:3B": "Cisco Systems, Inc",
        "04:DA:D2": "Cisco Systems, Inc",
        "F0:29:29": "Cisco Systems, Inc",
        "20:BB:C0": "Cisco Systems, Inc",
        "4C:4E:35": "Cisco Systems, Inc",
        "98:FA:E3": "Xiaomi Communications Co Ltd",
        "F0:B4:29": "Xiaomi Communications Co Ltd",
        "00:50:80": "Cisco Systems, Inc",
        "00:50:73": "Cisco Systems, Inc",
        "00:90:0C": "Cisco Systems, Inc",
        "00:90:5F": "Cisco Systems, Inc",
        "00:E0:F7": "Cisco Systems, Inc",
        "00:1B:D7": "Cisco SPVTG",
        "00:60:83": "Cisco Systems, Inc",
        "00:60:09": "Cisco Systems, Inc",
        "00:06:7C": "Cisco Systems, Inc",
        "00:10:7B": "Cisco Systems, Inc",
        "00:50:E2": "Cisco Systems, Inc",
        "E4:D3:F1": "Cisco Systems, Inc",
        "84:78:AC": "Cisco Systems, Inc",
        "00:90:A6": "Cisco Systems, Inc",
        "00:90:86": "Cisco Systems, Inc",
        "00:24:8C": "ASUSTek COMPUTER INC.",
        "00:23:54": "ASUSTek COMPUTER INC.",
        "1C:87:2C": "ASUSTek COMPUTER INC.",
        "60:18:2E": "ShenZhen Protruly Electronic Ltd co.",
        "C4:14:3C": "Cisco Systems, Inc",
        "3C:08:F6": "Cisco Systems, Inc",
        "00:1E:8C": "ASUSTek COMPUTER INC.",
        "00:13:D4": "ASUSTek COMPUTER INC.",
        "20:CF:30": "ASUSTek COMPUTER INC.",
        "BC:16:65": "Cisco Systems, Inc",
        "F8:72:EA": "Cisco Systems, Inc",
        "D0:C7:89": "Cisco Systems, Inc",
        "F8:4F:57": "Cisco Systems, Inc",
        "50:1C:BF": "Cisco Systems, Inc",
        "B0:00:B4": "Cisco Systems, Inc",
        "54:4A:00": "Cisco Systems, Inc",
        "00:E1:6D": "Cisco Systems, Inc",
        "78:BA:F9": "Cisco Systems, Inc",
        "00:22:CE": "Cisco SPVTG",
        "E0:D1:73": "Cisco Systems, Inc",
        "E0:89:9D": "Cisco Systems, Inc",
        "C4:72:95": "Cisco Systems, Inc",
        "7C:69:F6": "Cisco Systems, Inc",
        "78:DA:6E": "Cisco Systems, Inc",
        "B8:78:2E": "Apple, Inc.",
        "00:05:02": "Apple, Inc.",
        "00:0A:95": "Apple, Inc.",
        "34:BD:C8": "Cisco Systems, Inc",
        "DC:EB:94": "Cisco Systems, Inc",
        "84:B5:17": "Cisco Systems, Inc",
        "1C:6E:4C": "Logistic Service & Engineering Co.,Ltd",
        "00:0F:66": "Cisco-Linksys, LLC",
        "24:37:4C": "Cisco SPVTG",
        "18:8B:9D": "Cisco Systems, Inc",
        "E4:AA:5D": "Cisco Systems, Inc",
        "F4:5F:D4": "Cisco SPVTG",
        "2C:AB:A4": "Cisco SPVTG",
        "00:26:4A": "Apple, Inc.",
        "04:1E:64": "Apple, Inc.",
        "00:11:24": "Apple, Inc.",
        "00:22:41": "Apple, Inc.",
        "7C:C5:37": "Apple, Inc.",
        "78:CA:39": "Apple, Inc.",
        "18:E7:F4": "Apple, Inc.",
        "70:CD:60": "Apple, Inc.",
        "8C:7B:9D": "Apple, Inc.",
        "D8:9E:3F": "Apple, Inc.",
        "B8:C7:5D": "Apple, Inc.",
        "0C:74:C2": "Apple, Inc.