import * as events from '@aws-cdk/aws-events';
import * as sns from '@aws-cdk/aws-sns';
/**
 * Customize the SNS Topic Event Target.
 *
 * @stability stable
 */
export interface SnsTopicProps {
    /**
     * The message to send to the topic.
     *
     * @default the entire EventBridge event
     * @stability stable
     */
    readonly message?: events.RuleTargetInput;
}
/**
 * Use an SNS topic as a target for Amazon EventBridge rules.
 *
 * @stability stable
 * @example
 *
 *    // publish to an SNS topic every time code is committed
 *    // to a CodeCommit repository
 *    repository.onCommit(new targets.SnsTopic(topic));
 */
export declare class SnsTopic implements events.IRuleTarget {
    readonly topic: sns.ITopic;
    private readonly props;
    /**
     * @stability stable
     */
    constructor(topic: sns.ITopic, props?: SnsTopicProps);
    /**
     * Returns a RuleTarget that can be used to trigger this SNS topic as a result from an EventBridge event.
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sns-permissions
     * @stability stable
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
