import * as events from '@aws-cdk/aws-events';
import * as logs from '@aws-cdk/aws-logs';
/**
 * Customize the CloudWatch LogGroup Event Target.
 *
 * @stability stable
 */
export interface LogGroupProps {
    /**
     * The event to send to the CloudWatch LogGroup.
     *
     * This will be the event logged into the CloudWatch LogGroup
     *
     * @default - the entire EventBridge event
     * @stability stable
     */
    readonly event?: events.RuleTargetInput;
}
/**
 * Use an AWS CloudWatch LogGroup as an event rule target.
 *
 * @stability stable
 */
export declare class CloudWatchLogGroup implements events.IRuleTarget {
    private readonly logGroup;
    private readonly props;
    /**
     * @stability stable
     */
    constructor(logGroup: logs.ILogGroup, props?: LogGroupProps);
    /**
     * Returns a RuleTarget that can be used to log an event into a CloudWatch LogGroup.
     *
     * @stability stable
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
