import * as events from '@aws-cdk/aws-events';
import * as kinesis from '@aws-cdk/aws-kinesis';
/**
 * Customize the Kinesis Stream Event Target.
 *
 * @stability stable
 */
export interface KinesisStreamProps {
    /**
     * Partition Key Path for records sent to this stream.
     *
     * @default - eventId as the partition key
     * @stability stable
     */
    readonly partitionKeyPath?: string;
    /**
     * The message to send to the stream.
     *
     * Must be a valid JSON text passed to the target stream.
     *
     * @default - the entire CloudWatch event
     * @stability stable
     */
    readonly message?: events.RuleTargetInput;
}
/**
 * Use a Kinesis Stream as a target for AWS CloudWatch event rules.
 *
 * @stability stable
 * @example
 *
 *    // put to a Kinesis stream every time code is committed
 *    // to a CodeCommit repository
 *    repository.onCommit(new targets.KinesisStream(stream));
 */
export declare class KinesisStream implements events.IRuleTarget {
    private readonly stream;
    private readonly props;
    /**
     * @stability stable
     */
    constructor(stream: kinesis.IStream, props?: KinesisStreamProps);
    /**
     * Returns a RuleTarget that can be used to trigger this Kinesis Stream as a result from a CloudWatch event.
     *
     * @stability stable
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
