import * as events from '@aws-cdk/aws-events';
import * as firehose from '@aws-cdk/aws-kinesisfirehose';
/**
 * Customize the Firehose Stream Event Target.
 *
 * @stability stable
 */
export interface KinesisFirehoseStreamProps {
    /**
     * The message to send to the stream.
     *
     * Must be a valid JSON text passed to the target stream.
     *
     * @default - the entire Event Bridge event
     * @stability stable
     */
    readonly message?: events.RuleTargetInput;
}
/**
 * Customize the Firehose Stream Event Target.
 *
 * @stability stable
 */
export declare class KinesisFirehoseStream implements events.IRuleTarget {
    private readonly stream;
    private readonly props;
    /**
     * @stability stable
     */
    constructor(stream: firehose.CfnDeliveryStream, props?: KinesisFirehoseStreamProps);
    /**
     * Returns a RuleTarget that can be used to trigger this Firehose Stream as a result from a Event Bridge event.
     *
     * @stability stable
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
