"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipeline = void 0;
const iam = require("@aws-cdk/aws-iam");
const util_1 = require("./util");
/**
 * Allows the pipeline to be used as an EventBridge rule target.
 *
 * @stability stable
 */
class CodePipeline {
    /**
     * @stability stable
     */
    constructor(pipeline, options = {}) {
        this.pipeline = pipeline;
        this.options = options;
    }
    /**
     * Returns the rule target specification.
     *
     * NOTE: Do not use the various `inputXxx` options. They can be set in a call to `addTarget`.
     *
     * @stability stable
     */
    bind(_rule, _id) {
        return {
            id: '',
            arn: this.pipeline.pipelineArn,
            role: this.options.eventRole || util_1.singletonEventRole(this.pipeline, [new iam.PolicyStatement({
                    resources: [this.pipeline.pipelineArn],
                    actions: ['codepipeline:StartPipelineExecution'],
                })]),
            targetResource: this.pipeline,
        };
    }
}
exports.CodePipeline = CodePipeline;
//# sourceMappingURL=data:application/json;base64,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