"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeBuildProject = void 0;
const iam = require("@aws-cdk/aws-iam");
const util_1 = require("./util");
/**
 * Start a CodeBuild build when an Amazon EventBridge rule is triggered.
 *
 * @stability stable
 */
class CodeBuildProject {
    /**
     * @stability stable
     */
    constructor(project, props = {}) {
        this.project = project;
        this.props = props;
    }
    /**
     * Allows using build projects as event rule targets.
     *
     * @stability stable
     */
    bind(_rule, _id) {
        return {
            id: '',
            arn: this.project.projectArn,
            role: this.props.eventRole || util_1.singletonEventRole(this.project, [
                new iam.PolicyStatement({
                    actions: ['codebuild:StartBuild'],
                    resources: [this.project.projectArn],
                }),
            ]),
            input: this.props.event,
            targetResource: this.project,
        };
    }
}
exports.CodeBuildProject = CodeBuildProject;
//# sourceMappingURL=data:application/json;base64,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