"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatchJob = void 0;
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const util_1 = require("./util");
/**
 * (experimental) Use an AWS Batch Job / Queue as an event rule target.
 *
 * @experimental
 */
class BatchJob {
    /**
     * @experimental
     */
    constructor(jobQueue, jobDefinition, props = {}) {
        this.jobQueue = jobQueue;
        this.jobDefinition = jobDefinition;
        this.props = props;
    }
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger queue this batch job as a result from an EventBridge event.
     *
     * @experimental
     */
    bind(rule, _id) {
        var _a;
        const batchParameters = {
            jobDefinition: this.jobDefinition.jobDefinitionArn,
            jobName: (_a = this.props.jobName) !== null && _a !== void 0 ? _a : core_1.Names.nodeUniqueId(rule.node),
            arrayProperties: this.props.size ? { size: this.props.size } : undefined,
            retryStrategy: this.props.attempts ? { attempts: this.props.attempts } : undefined,
        };
        return {
            id: '',
            arn: this.jobQueue.jobQueueArn,
            // When scoping resource-level access for job submission, you must provide both job queue and job definition resource types.
            // https://docs.aws.amazon.com/batch/latest/userguide/ExamplePolicies_BATCH.html#iam-example-restrict-job-def
            role: util_1.singletonEventRole(this.jobDefinition, [
                new iam.PolicyStatement({
                    actions: ['batch:SubmitJob'],
                    resources: [
                        this.jobDefinition.jobDefinitionArn,
                        this.jobQueue.jobQueueArn,
                    ],
                }),
            ]),
            input: this.props.event,
            targetResource: this.jobQueue,
            batchParameters,
        };
    }
}
exports.BatchJob = BatchJob;
//# sourceMappingURL=data:application/json;base64,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