# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['openeo_processes_dask',
 'openeo_processes_dask.process_implementations',
 'openeo_processes_dask.process_implementations.cubes',
 'openeo_processes_dask.process_implementations.experimental',
 'openeo_processes_dask.process_implementations.ml',
 'openeo_processes_dask.specs']

package_data = \
{'': ['*']}

extras_require = \
{'experimental': ['odc-algo==0.2.3'],
 'implementations': ['geopandas>=0.11.1,<1',
                     'xarray>=2022.11.0',
                     'dask[array]>=2022.11.1',
                     'rasterio>=1.3.4,<2.0.0',
                     'dask-geopandas>=0.2.0,<1',
                     'rioxarray>=0.12.0,<1',
                     'openeo-pg-parser-networkx>=2023.3.1',
                     'odc-geo>=0.3.2,<0.4.0'],
 'ml': ['xgboost>=1.5.1,<2.0.0']}

setup_kwargs = {
    'name': 'openeo-processes-dask',
    'version': '2023.3.1',
    'description': 'Python implementations of many OpenEO processes, dask-friendly by default.',
    'long_description': "# OpenEO Processes Dask\n\n![PyPI - Status](https://img.shields.io/pypi/status/openeo-processes-dask)\n![PyPI](https://img.shields.io/pypi/v/openeo-processes-dask)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/openeo-processes-dask)\n[![codecov](https://codecov.io/github/Open-EO/openeo-processes-dask/branch/main/graph/badge.svg?token=RA82MUN9RZ)](https://codecov.io/github/Open-EO/openeo-processes-dask)\n\n`openeo-processes-dask` is a collection of Python implementations of [OpenEO processes](https://processes.openeo.org/) based on the [xarray](https://github.com/pydata/xarray)/[dask](https://github.com/dask/dask) ecosystem. It is intended to be used alongside with [openeo-pg-parser-networkx](https://github.com/Open-EO/openeo-pg-parser-networkx), which handles the parsing and execution of [OpenEO process graphs](https://openeo.org/documentation/1.0/developers/api/reference.html#section/Processes/Process-Graphs). There you'll also find a tutorial on how to register process implementations from an arbitrary source (e.g. this repo) to the registry of available processes.\n\n## Installation\nInstall this project via pip:\n\n```\npip install openeo-processes-dask\n```\n\nNote that by default this only installs the json process specs. In order to install the actual implementations, add the `implementations` extra:\n\n```\npip install openeo-processes-dask[implementations]\n```\n\nA subset of process implementations with heavy or unstable dependencies are hidden behind these further build variants:\n- `openeo_processes_dask/process_implementations/ml`: `pip install openeo-processes-dask[ml]`\n- `openeo_processes_dask/process_implementations/experimental`: `pip install openeo-processes-dask[experimental]`\n\n## Development environment\nopeneo-processes-dask requires poetry >1.2, see their [docs](https://python-poetry.org/docs/#installation) for installation instructions.\n\nTo setup the python venv and install this project into it run:\n```\npoetry install --all-extras\n```\n\nTo add a new core dependency run:\n```\npoetry add some_new_dependency\n```\n\nTo add a new development dependency run:\n```\npoetry add some_new_dependency --group dev\n```\n\nTo run the test suite run:\n```\npoetry run python -m pytest\n```\n\nNote that you can also use the virtual environment that's generated by poetry as the kernel for the ipynb notebooks.\n\n### Pre-commit hooks\n\nThis repo makes use of [pre-commit](https://pre-commit.com/) hooks to enforce linting & a few sanity checks. In a fresh development setup, install the hooks using `poetry run pre-commit install`. These will then automatically be checked against your changes before making the commit.\n\n### Specs\nThe json specs for the individual processes are tracked as a git submodule in `openeo_processes_dask/specs/openeo-processes`.\nThe raw json for a specific process can be imported using `from openeo_processes_dask.specs import reduce_dimension`.\n\nTo bump these specs to a later version use:\n`git -C openeo_processes_dask/specs/openeo-processes checkout <tag>`\n`git add openeo_processes_dask/specs/openeo-processes`\n",
    'author': 'Lukas Weidenholzer',
    'author_email': 'lukas.weidenholzer@eodc.eu',
    'maintainer': 'EODC Staff',
    'maintainer_email': 'support@eodc.eu',
    'url': 'https://github.com/Open-EO/openeo-processes-dask',
    'packages': packages,
    'package_data': package_data,
    'extras_require': extras_require,
    'python_requires': '>=3.9,<3.11',
}


setup(**setup_kwargs)
