/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.common;

import ModelInterface.InterfaceMain;
import ModelInterface.MenuAdder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class RecentFilesList
implements MenuAdder {
    private static final RecentFilesList instance = new RecentFilesList();
    private final JMenu recentFilesMenu = new JMenu("Open Recent Files");
    private int recentFilesLength;
    private static final int MAX_TITLE_LENGTH = 40;

    private RecentFilesList() {
        InterfaceMain.getInstance().getFrame().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Control") && propertyChangeEvent.getNewValue().equals("ModelInterface")) {
                    RecentFilesList.this.doSetProperties();
                }
            }
        });
    }

    public static RecentFilesList getInstance() {
        return instance;
    }

    @Override
    public void addMenuItems(InterfaceMain.MenuManager menuManager) {
        Properties properties = InterfaceMain.getInstance().getProperties();
        try {
            String string = properties.getProperty("RecentFilesLength", "5");
            properties.setProperty("RecentFilesLength", string);
            this.recentFilesLength = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            this.recentFilesLength = 5;
        }
        for (int i = 1; i <= this.recentFilesLength; ++i) {
            String string = properties.getProperty("RecentFile" + i);
            String string2 = properties.getProperty("RecentFileTarget" + i);
            if (string == null || string2 == null) break;
            String[] stringArray = string.split(";");
            String[] stringArray2 = string2.split(";");
            if (stringArray.length < 1 || stringArray2.length != 2) continue;
            File[] fileArray = new File[stringArray.length];
            for (int j = 0; j < fileArray.length; ++j) {
                fileArray[j] = new File(stringArray[j]);
            }
            this.recentFilesMenu.add(new RecentFile(fileArray, stringArray2[0], stringArray2[1]));
        }
        menuManager.getSubMenuManager(0).addMenuItem(this.recentFilesMenu, 5);
    }

    private void doSetProperties() {
        Properties properties = InterfaceMain.getInstance().getProperties();
        Component[] componentArray = this.recentFilesMenu.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            RecentFile recentFile = (RecentFile)componentArray[i];
            properties.setProperty("RecentFile" + (i + 1), recentFile.getFilePaths());
            properties.setProperty("RecentFileTarget" + (i + 1), recentFile.getTargetName() + ";" + recentFile.getActionCommand());
        }
    }

    public void addFile(File[] fileArray, ActionListener actionListener, String string) {
        RecentFile recentFile = new RecentFile(fileArray, actionListener, string);
        int n = this.doesMenuContain(recentFile);
        if (n != -1) {
            this.recentFilesMenu.remove(n);
        } else if (this.recentFilesMenu.getItemCount() == this.recentFilesLength) {
            this.recentFilesMenu.remove(this.recentFilesLength - 1);
        }
        this.recentFilesMenu.insert(recentFile, 0);
    }

    private int doesMenuContain(JMenuItem jMenuItem) {
        for (int i = 0; i < this.recentFilesMenu.getItemCount(); ++i) {
            if (!this.recentFilesMenu.getItem(i).equals(jMenuItem)) continue;
            return i;
        }
        return -1;
    }

    private static void showNoOpenError(String string) {
        InterfaceMain.getInstance().showMessageDialog(string, "Could Not Open File Error", 0);
    }

    private static String createTitle(String string, String string2) {
        int n = 40 - string.length() - 4;
        if (string2.length() <= n) {
            return string + ": " + string2;
        }
        return string + ": .." + string2.substring(string2.length() - n - 1, string2.length());
    }

    public class RecentFile
    extends JMenuItem
    implements ActionListener {
        private final File[] files;
        private final String targetName;
        private final String actionCommand;

        public RecentFile(File[] fileArray, String string, String string2) {
            super(RecentFilesList.createTitle(string2, fileArray[0].getAbsolutePath()));
            this.files = fileArray;
            this.targetName = string;
            this.actionCommand = string2;
            this.addActionListener(this);
            this.setToolTipText(fileArray[0].getAbsolutePath());
        }

        public RecentFile(File[] fileArray, ActionListener actionListener, String string) {
            super(string + ": " + fileArray[0].getName());
            this.files = fileArray;
            this.targetName = actionListener.getClass().getName();
            this.actionCommand = string;
            this.addActionListener(this);
            this.setToolTipText(fileArray[0].getAbsolutePath());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (File file : this.files) {
                if (file.exists()) continue;
                System.out.println("Does not exist anymore");
                RecentFilesList.showNoOpenError("The file no longer exists.");
                return;
            }
            ActionEvent actionEvent2 = new ActionEvent(this, actionEvent.getID(), this.actionCommand);
            try {
                MenuAdder noSuchMethodException = InterfaceMain.getInstance().getMenuAdder(this.targetName);
                noSuchMethodException.getClass().getMethod("actionPerformed", ActionEvent.class).invoke((Object)noSuchMethodException, actionEvent2);
            }
            catch (NoSuchMethodException illegalAccessException) {
                RecentFilesList.showNoOpenError("Could not find target to open.");
                illegalAccessException.printStackTrace();
            }
            catch (IllegalAccessException invocationTargetException) {
                RecentFilesList.showNoOpenError("Could not find target to open.");
                invocationTargetException.printStackTrace();
            }
            catch (InvocationTargetException nullPointerException) {
                RecentFilesList.showNoOpenError("Could not find target to open.");
                nullPointerException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
                RecentFilesList.showNoOpenError("Could not find target to open.");
                nullPointerException.printStackTrace();
            }
        }

        public File[] getFiles() {
            return this.files;
        }

        public String getFilePaths() {
            StringBuilder stringBuilder = new StringBuilder();
            for (File file : this.files) {
                stringBuilder.append(file.getAbsolutePath()).append(";");
            }
            return stringBuilder.toString();
        }

        public String getTargetName() {
            return this.targetName;
        }

        @Override
        public String getActionCommand() {
            return this.actionCommand;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof RecentFile)) {
                return false;
            }
            RecentFile recentFile = (RecentFile)object;
            if (this.files.length != recentFile.files.length) {
                return false;
            }
            for (int i = 0; i < this.files.length; ++i) {
                if (this.files[i].equals(recentFile.files[i])) continue;
                return false;
            }
            return this.targetName.equals(recentFile.targetName) && this.actionCommand.equals(recentFile.actionCommand);
        }

        public int hashCode() {
            return this.files.hashCode() ^ this.targetName.hashCode() ^ this.actionCommand.hashCode();
        }
    }
}

