/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.csvconv;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HeaderEntity {
    private String name;
    private Map<String, String> attributes = new HashMap<String, String>();
    private boolean readData = false;
    private boolean readAttr = false;
    private boolean hasSpecificAttrVal = false;

    public HeaderEntity(String string) throws Exception {
        this.parseHeaderStr(string);
    }

    private void parseHeaderStr(String string) throws Exception {
        if (string.startsWith("@")) {
            string = string.substring(1);
        }
        if (string.startsWith("+")) {
            this.readData = true;
            string = string.substring(1);
        }
        if (string.startsWith("{")) {
            int n = string.indexOf(125);
            String[] stringArray = string.substring(1, n).split(";");
            string = string.substring(n + 1);
            for (String string2 : stringArray) {
                n = string2.indexOf(61);
                if (n == -1) {
                    this.readData = false;
                    this.readAttr = true;
                    this.attributes.put(string2.trim(), null);
                    continue;
                }
                this.hasSpecificAttrVal = true;
                this.attributes.put(string2.substring(0, n).trim(), string2.substring(n + 1));
            }
        }
        if (string.matches("[\\+\\{\\}@=;]")) {
            throw new Exception("Invalid header " + string + " found invalid characters after parsing");
        }
        this.name = string.trim();
    }

    public String getName() {
        return this.name;
    }

    public boolean willRead() {
        return this.readData || this.readAttr;
    }

    public boolean doesSpecifyAttrValue() {
        return this.hasSpecificAttrVal;
    }

    public Set<String> getAttrNames() {
        return this.attributes.keySet();
    }

    public Node doCreate(Document document, String string, Element element) {
        Element element2 = element == null ? document.createElement(this.name) : element;
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            String string2 = entry.getValue();
            if (string2 == null) {
                string2 = string;
            }
            element2.setAttribute(entry.getKey(), string2);
        }
        if (this.readData) {
            element2.setTextContent(string);
        }
        return element2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HeaderEntity)) {
            return false;
        }
        HeaderEntity headerEntity = (HeaderEntity)object;
        return this.name.equals(headerEntity.name) && this.attributes.equals(headerEntity.attributes) && this.readData == headerEntity.readData && this.readAttr == headerEntity.readAttr && this.hasSpecificAttrVal == headerEntity.hasSpecificAttrVal;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.attributes.hashCode() ^ Boolean.valueOf(this.readData).hashCode() ^ Boolean.valueOf(this.readAttr).hashCode() ^ Boolean.valueOf(this.hasSpecificAttrVal).hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.readData || this.readAttr) {
            stringBuilder.append("+");
        }
        if (!this.attributes.isEmpty()) {
            stringBuilder.append("{");
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                stringBuilder.append(entry.getKey());
                if (entry.getValue() != null) {
                    stringBuilder.append("=").append(entry.getValue());
                }
                stringBuilder.append(";");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1).append("}");
        }
        return stringBuilder.append(this.name).toString();
    }
}

