/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.csvconv;

import ModelInterface.ModelGUI2.csvconv.DOMTreeBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class CSVToXMLMain {
    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            // empty if block
        }
        try {
            if (stringArray.length == 1) {
                System.out.println("Running batch file: " + stringArray[0]);
                CSVToXMLMain.runFromBatch(new File(stringArray[0]));
            } else if (stringArray.length >= 3) {
                File file = new File(stringArray[stringArray.length - 1]);
                File file2 = new File(stringArray[stringArray.length - 2]);
                File[] fileArray = new File[stringArray.length - 2];
                boolean bl = false;
                for (int i = 0; i < stringArray.length - 2; ++i) {
                    if (stringArray[i].equals("-")) {
                        if (bl) {
                            throw new Exception("STDIN input flag has already been set.");
                        }
                        fileArray[i] = null;
                        continue;
                    }
                    fileArray[i] = new File(stringArray[i]);
                }
                Document document = CSVToXMLMain.runCSVConversion(fileArray, file2, null);
                CSVToXMLMain.writeFile(file, document);
            } else {
                System.err.println("Usage: CSVToXMLMain <CSV file> [<CSV file> ..] <header file> <output XML file>");
                System.err.println("   or: CSVToXMLMain <batch file>");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static Document runCSVConversion(File[] fileArray, File file, JFrame jFrame) {
        String string = null;
        int n = 0;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        DOMTreeBuilder dOMTreeBuilder = new DOMTreeBuilder();
        try {
            StringTokenizer stringTokenizer;
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            bufferedReader.readLine();
            String string2 = bufferedReader.readLine().trim();
            while (string2 != null && string2.length() > 0 && string2.charAt(0) == '$') {
                stringTokenizer = new StringTokenizer(string2, ",", false);
                string = stringTokenizer.nextToken();
                string2 = string2.substring(string.length() + 1).trim();
                hashMap.put(string, string2);
                string2 = bufferedReader.readLine();
                if (string2 == null) continue;
                string2.trim();
            }
            while (string2 != null) {
                block33: {
                    if (!string2.equals("")) {
                        stringTokenizer = new StringTokenizer(string2, ",", false);
                        string = stringTokenizer.nextToken();
                        string2 = string2.substring(string.length() + 1);
                        try {
                            string2 = string2.replaceAll("[,][\\s]*[,]", "");
                            if (string2.endsWith(",")) {
                                string2 = string2.substring(0, string2.length() - 1);
                            }
                            n = 0;
                            while ((n = string2.indexOf(36)) != -1) {
                                int n2;
                                for (n2 = n; n2 < string2.length() && string2.charAt(n2) != ','; ++n2) {
                                }
                                String string3 = string2.substring(n, n2);
                                if (hashMap.containsKey(string3)) {
                                    string2 = string2.replaceAll("\\" + string3, (String)hashMap.get(string3));
                                    continue;
                                }
                                System.out.println("***Couldn't find replacement for " + string3 + "!***");
                                if (jFrame == null) continue;
                                JOptionPane.showMessageDialog(jFrame, "Couldn't find replacement for " + string3, "Warning", 2);
                            }
                            hashMap2.put(string, string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("*** Hashtable file formatted incorrectly ***" + numberFormatException);
                            if (jFrame == null) break block33;
                            JOptionPane.showMessageDialog(jFrame, "Hashtable file formatted incorrectly\n" + numberFormatException, "Exception", 0);
                        }
                    }
                }
                if ((string2 = bufferedReader.readLine()) == null) continue;
                string2.trim();
            }
            for (int i = 0; i < fileArray.length; ++i) {
                InputStream inputStream = fileArray[i] != null ? new FileInputStream(fileArray[i]) : System.in;
                BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream));
                string2 = bufferedReader2.readLine().trim();
                while (string2 != null) {
                    while (string2 != null && !string2.startsWith("INPUT_TABLE")) {
                        string2 = bufferedReader2.readLine();
                    }
                    if (string2 == null) break;
                    bufferedReader2.readLine();
                    string2 = bufferedReader2.readLine().trim();
                    stringTokenizer = new StringTokenizer(string2, ",", false);
                    string = stringTokenizer.nextToken();
                    String string4 = (String)hashMap2.get(string);
                    if (stringTokenizer.hasMoreTokens() && string4 != null) {
                        String string5 = stringTokenizer.nextToken();
                        String[] stringArray = string5.split("/");
                        if (stringArray.length != 4) {
                            throw new Exception("Expecting 4 infinite nesting params, got: " + stringArray.length);
                        }
                        String string6 = stringArray[0];
                        String string7 = stringArray[1];
                        int n3 = Integer.parseInt(stringArray[2]);
                        boolean bl = Boolean.parseBoolean(stringArray[3]);
                        if (n3 < 1) {
                            throw new Exception("At least 1 level of nesting must be requested to generate additional levels.");
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        int n4 = 0;
                        while (n4 < n3 - 1) {
                            stringBuffer.append(string7).append(n4).append("/+{name}").append(string7).append(++n4).append(",");
                        }
                        if (stringBuffer.length() > 0) {
                            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                        }
                        String string8 = string7 + n4 + "/+{name}";
                        string8 = bl ? string8 + string7 + (n4 + 1) : string8 + string6;
                        String[] stringArray2 = string4.split(",");
                        ArrayList<String> arrayList = new ArrayList<String>(stringArray2.length);
                        String[] stringArray3 = stringArray2;
                        int n5 = stringArray3.length;
                        for (int j = 0; j < n5; ++j) {
                            String string9 = stringArray3[j];
                            arrayList.add(string9.trim());
                        }
                        boolean bl2 = false;
                        for (n5 = 0; n5 < arrayList.size() && !bl2; ++n5) {
                            if (!((String)arrayList.get(n5)).matches("^.*?/.+?" + string6 + "$")) continue;
                            String string10 = (String)arrayList.get(n5);
                            arrayList.set(n5, string8);
                            string10 = string10.replaceFirst(string6, string7 + "0");
                            if (stringBuffer.length() > 0) {
                                string10 = string10 + ",";
                            }
                            stringBuffer.insert(0, string10);
                            bl2 = true;
                        }
                        if (!bl2) {
                            throw new Exception("Couldn't find " + string6 + " child tag to substitute.");
                        }
                        bl2 = stringBuffer.length() == 0;
                        for (n5 = arrayList.size() - 1; n5 >= 0 && !bl2; --n5) {
                            if (!((String)arrayList.get(n5)).matches("^.*?/\\+.*$")) continue;
                            arrayList.add(n5 + 1, stringBuffer.toString());
                            bl2 = true;
                        }
                        if (!bl2) {
                            throw new Exception("Couldn't find any table read columns.");
                        }
                        if (bl) {
                            for (n5 = 0; n5 < arrayList.size(); ++n5) {
                                if (!((String)arrayList.get(n5)).matches("^" + string6 + "/.*$")) continue;
                                arrayList.set(n5, ((String)arrayList.get(n5)).replaceFirst("^" + string6, string7 + (n4 + 1)));
                            }
                        }
                        string4 = String.join((CharSequence)",", arrayList);
                    }
                    if (string4 != null) {
                        dOMTreeBuilder.setHeader(string4);
                        bufferedReader2.readLine();
                        bufferedReader2.readLine();
                        string2 = bufferedReader2.readLine();
                        if (string2 != null) {
                            string2.trim();
                        }
                        while (string2 != null && !string2.equals("") && string2.charAt(0) != ',') {
                            stringTokenizer = new StringTokenizer(string2, ",", false);
                            int n6 = stringTokenizer.countTokens();
                            ArrayList<String> arrayList = new ArrayList<String>(n6);
                            for (int j = 0; j < n6; ++j) {
                                arrayList.add(j, stringTokenizer.nextToken().trim());
                            }
                            dOMTreeBuilder.addToTree(arrayList);
                            arrayList.clear();
                            string2 = bufferedReader2.readLine();
                            if (string2 == null) continue;
                            string2.trim();
                        }
                    } else {
                        System.out.println("***Warning: skipping table: " + string + "!***");
                    }
                    if ((string2 = bufferedReader2.readLine()) == null) continue;
                    string2.trim();
                }
                inputStream.close();
            }
            return dOMTreeBuilder.getDoc();
        }
        catch (Exception exception) {
            System.out.println("intValueStr " + string);
            System.out.println("Exception thrown while trying to read csv and header files: " + exception);
            exception.printStackTrace();
            if (jFrame != null) {
                JOptionPane.showMessageDialog(jFrame, "Exception thrown while trying to read csv and header files\n" + exception, "Exception", 0);
            }
            return null;
        }
    }

    public static boolean writeFile(File file, Document document) {
        try {
            DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)dOMImplementationRegistry.getDOMImplementation("XML 3.0"));
            LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
            LSOutput lSOutput = dOMImplementationLS.createLSOutput();
            lSOutput.setByteStream(new FileOutputStream(file));
            DOMConfiguration dOMConfiguration = lSSerializer.getDomConfig();
            boolean bl = Boolean.parseBoolean(System.getProperty("ModelInterface.pretty-print", "true"));
            dOMConfiguration.setParameter("format-pretty-print", bl);
            lSSerializer.write(document, lSOutput);
        }
        catch (Exception exception) {
            System.err.println("Error outputing tree: " + exception);
            return false;
        }
        return true;
    }

    private static void runFromBatch(File file) throws Exception {
        URI uRI = file.toURI();
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(uRI.getPath());
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("class") && ((Element)node).getAttribute("name").equals("ModelInterface.ModelGUI2.InputViewer")) {
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    String string;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || (string = ((Element)node2).getAttribute("name")) == null) continue;
                    if (string.equals("CSV file")) {
                        Node node3;
                        File file2 = null;
                        File file3 = null;
                        ArrayList<File> arrayList = new ArrayList<File>();
                        NodeList nodeList3 = node2.getChildNodes();
                        for (int k = 0; k < nodeList3.getLength(); ++k) {
                            node3 = nodeList3.item(k);
                            if (node3.getNodeType() != 1) continue;
                            File file4 = new File(node3.getTextContent());
                            if (node3.getNodeName().equals("headerFile")) {
                                file2 = file4;
                                continue;
                            }
                            if (node3.getNodeName().equals("outFile")) {
                                file3 = file4;
                                continue;
                            }
                            if (node3.getNodeName().equals("csvFile")) {
                                arrayList.add(file4);
                                continue;
                            }
                            System.out.println("Unknown tag while parsing CSV file command: " + node3.getNodeName());
                        }
                        File[] fileArray = new File[arrayList.size()];
                        fileArray = arrayList.toArray(fileArray);
                        node3 = CSVToXMLMain.runCSVConversion(fileArray, file2, null);
                        CSVToXMLMain.writeFile(file3, (Document)node3);
                        continue;
                    }
                    System.out.println("Invalid command: " + string + ", only CSV file can be run in this mode");
                }
                continue;
            }
            System.out.println("Invalid class, only ModelInterface.ModelGUI2.InputViewer can be run in this mode");
        }
    }
}

