/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2;

import ModelInterface.InterfaceMain;
import ModelInterface.ModelGUI2.TabCloseIcon;
import ModelInterface.ModelGUI2.queries.QueryGenerator;
import ModelInterface.ModelGUI2.tables.BaseTableModel;
import ModelInterface.ModelGUI2.tables.ComboTableModel;
import ModelInterface.ModelGUI2.tables.CopyPaste;
import ModelInterface.ModelGUI2.tables.MultiTableModel;
import ModelInterface.ModelGUI2.xmldb.DbProcInterrupt;
import ModelInterface.ModelGUI2.xmldb.QueryBinding;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.jfree.chart.JFreeChart;

public class QueryResultsPanel
extends JPanel {
    Thread runThread;
    DbProcInterrupt context = null;
    private static final long serialVersionUID = 1L;

    public QueryResultsPanel(final QueryGenerator queryGenerator, final QueryBinding queryBinding, final Object[] objectArray, final Object[] objectArray2, final TabCloseIcon tabCloseIcon) {
        this.initializeWaiting();
        this.context = new DbProcInterrupt();
        final QueryResultsPanel queryResultsPanel = this;
        this.runThread = new Thread(){

            @Override
            public void run() {
                JComponent jComponent = null;
                String string = null;
                try {
                    jComponent = queryGenerator.isGroup() && queryBinding == null ? QueryResultsPanel.this.createGroupTableContent(queryGenerator, objectArray, objectArray2) : QueryResultsPanel.this.createSingleTableContent(queryGenerator, queryBinding, objectArray, objectArray2);
                }
                catch (Exception exception) {
                    string = exception.getMessage();
                }
                if (this.isInterrupted()) {
                    return;
                }
                QueryResultsPanel.this.removeAll();
                tabCloseIcon.finishedLoading();
                if (jComponent == null) {
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new BoxLayout(jPanel, 0));
                    jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    jPanel.add(new JLabel(string));
                    QueryResultsPanel.this.add(jPanel);
                } else {
                    QueryResultsPanel.this.setLayout(new BoxLayout(queryResultsPanel, 0));
                    QueryResultsPanel.this.add(jComponent);
                }
                QueryResultsPanel.this.revalidate();
            }
        };
        this.runThread.start();
    }

    public void killThread() {
        this.context.interrupt();
        this.runThread.interrupt();
    }

    public void killThreadAndWait() {
        this.killThread();
        try {
            this.runThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void initializeWaiting() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add(new JLabel("Waiting for results. Close to terminate"));
        this.add(jPanel);
    }

    private JComponent createGroupTableContent(QueryGenerator queryGenerator, Object[] objectArray, Object[] objectArray2) throws Exception {
        MultiTableModel multiTableModel = new MultiTableModel(queryGenerator, objectArray, objectArray2, this.context);
        JTable jTable = new JTable(multiTableModel);
        jTable.setCellSelectionEnabled(true);
        jTable.getColumnModel().getColumn(0).setCellRenderer(multiTableModel.getCellRenderer(0, 0));
        jTable.getColumnModel().getColumn(0).setCellEditor(multiTableModel.getCellEditor(0, 0));
        InterfaceMain.getInstance().fireProperty("Query", null, multiTableModel);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.getViewport().setBackground(this.getBackground());
        return jScrollPane;
    }

    private JComponent createSingleTableContent(QueryGenerator queryGenerator, QueryBinding queryBinding, Object[] objectArray, Object[] objectArray2) throws Exception {
        Object object;
        Serializable serializable;
        Object object2;
        ComboTableModel comboTableModel = new ComboTableModel(queryGenerator, objectArray, objectArray2, queryBinding, this.context);
        JTable jTable = comboTableModel.getAsSortedTable();
        new CopyPaste(jTable);
        jTable.setAutoResizeMode(0);
        jTable.setCellSelectionEnabled(true);
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            if (jTable.getColumnName(i).equals("")) {
                tableColumn.setPreferredWidth(75);
                continue;
            }
            tableColumn.setPreferredWidth(jTable.getColumnName(i).length() * 5 + 30);
        }
        JLabel jLabel = new JLabel();
        try {
            object2 = ((BaseTableModel)comboTableModel).createChart(0, 0);
            serializable = comboTableModel.getChartDimensions((JFreeChart)object2);
            object = object2.createBufferedImage((int)serializable.getWidth(), (int)serializable.getHeight());
            jLabel.setIcon(new ImageIcon((Image)object));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            jLabel.setText("Cannot Create Chart");
        }
        object2 = new JSplitPane();
        serializable = new JScrollPane(jTable);
        ((JSplitPane)object2).setLeftComponent((Component)serializable);
        object = new JScrollPane(jLabel);
        ((JScrollPane)object).getViewport().setBackground(jLabel.getBackground());
        ((JSplitPane)object2).setRightComponent((Component)object);
        ((Component)object2).addComponentListener(new ComponentListener((JSplitPane)object2, (JScrollPane)object){
            final /* synthetic */ JSplitPane val$sp;
            final /* synthetic */ JScrollPane val$chartScrollPane;
            {
                this.val$sp = jSplitPane;
                this.val$chartScrollPane = jScrollPane;
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                this.val$sp.setDividerLocation(this.val$sp.getWidth() - (int)this.val$chartScrollPane.getPreferredSize().getWidth() - (int)this.val$chartScrollPane.getVerticalScrollBar().getSize().getWidth() - this.val$sp.getDividerSize() - 2);
                this.val$sp.removeComponentListener(this);
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        int n = (int)jLabel.getMinimumSize().getWidth();
        InterfaceMain interfaceMain = InterfaceMain.getInstance();
        JFrame jFrame = interfaceMain.getFrame();
        ((JSplitPane)object2).setDividerLocation(jFrame.getWidth() - n - ((JSplitPane)object2).getDividerSize() - 2);
        interfaceMain.fireProperty("Query", null, comboTableModel);
        return object2;
    }
}

