/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2;

import ModelInterface.BatchRunner;
import ModelInterface.ConfigurationEditor.guihelpers.XMLFileFilter;
import ModelInterface.InterfaceMain;
import ModelInterface.MenuAdder;
import ModelInterface.ModelGUI2.BatchWindow;
import ModelInterface.ModelGUI2.ParseFilter;
import ModelInterface.ModelGUI2.QueryResultsPanel;
import ModelInterface.ModelGUI2.QueryTransferHandler;
import ModelInterface.ModelGUI2.QueryTreeModel;
import ModelInterface.ModelGUI2.ScenarioListItem;
import ModelInterface.ModelGUI2.TabCloseIcon;
import ModelInterface.ModelGUI2.XMLFilter;
import ModelInterface.ModelGUI2.queries.QueryGenerator;
import ModelInterface.ModelGUI2.queries.SingleQueryExtension;
import ModelInterface.ModelGUI2.tables.BaseTableModel;
import ModelInterface.ModelGUI2.tables.TableSorter;
import ModelInterface.ModelGUI2.tables.TableTransferHandler;
import ModelInterface.ModelGUI2.undo.RenameScenarioUndoableEdit;
import ModelInterface.ModelGUI2.xmldb.QueryBinding;
import ModelInterface.ModelGUI2.xmldb.XMLDB;
import ModelInterface.common.DataPair;
import ModelInterface.common.FileChooser;
import ModelInterface.common.FileChooserFactory;
import ModelInterface.common.RecentFilesList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.basex.api.dom.BXDoc;
import org.basex.api.dom.BXNode;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSParserFilter;
import org.w3c.dom.ls.LSSerializer;

public class DbViewer
implements ActionListener,
MenuAdder,
BatchRunner {
    private Document queriesDoc;
    private static String controlStr = "DbViewer";
    private JTable jTable;
    private DOMImplementationLS implls;
    protected Vector<ScenarioListItem> scns;
    protected JList scnList;
    protected JList regionList;
    protected Vector regions;
    protected BaseTableModel bt;
    protected JScrollPane jsp;
    protected QueryTreeModel queries;
    private JTabbedPane tablesTabs = new JTabbedPane();
    private JSplitPane scenarioRegionSplit;
    private JSplitPane queriesSplit;
    private JSplitPane tableCreatorSplit;
    public static final String SCENARIO_LIST_NAME = "scenario list";
    public static final String REGION_LIST_NAME = "region list";

    public DbViewer() {
        final InterfaceMain interfaceMain = InterfaceMain.getInstance();
        final JFrame jFrame = interfaceMain.getFrame();
        final DbViewer dbViewer = this;
        try {
            DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
            this.implls = (DOMImplementationLS)((Object)dOMImplementationRegistry.getDOMImplementation("XML 3.0"));
            if (this.implls == null) {
                System.out.println("Could not find a DOM3 Load-Save compliant parser.");
                InterfaceMain.getInstance().showMessageDialog("Could not find a DOM3 Load-Save compliant parser.", "Initialization Error", 0);
                return;
            }
        }
        catch (Exception exception) {
            System.err.println("Couldn't initialize DOMImplementation: " + exception);
            InterfaceMain.getInstance().showMessageDialog("Couldn't initialize DOMImplementation\n" + exception, "Initialization Error", 0);
            exception.printStackTrace();
        }
        if (jFrame == null) {
            return;
        }
        jFrame.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Control")) {
                    Properties properties;
                    if (propertyChangeEvent.getOldValue().equals(controlStr) || propertyChangeEvent.getOldValue().equals(controlStr + "Same")) {
                        for (int i = 0; i < DbViewer.this.tablesTabs.getTabCount(); ++i) {
                            ((QueryResultsPanel)DbViewer.this.tablesTabs.getComponentAt(i)).killThreadAndWait();
                        }
                        if (DbViewer.this.queries.hasChanges() && InterfaceMain.getInstance().showConfirmDialog("The Queries have been modified.  Do you want to save them?", "Confirm Save Queries", 0, 3, 0) == 0) {
                            DbViewer.this.writeQueries();
                        }
                        properties = interfaceMain.getProperties();
                        properties.setProperty("scenarioRegionSplit", String.valueOf(DbViewer.this.scenarioRegionSplit.getDividerLocation()));
                        properties.setProperty("queriesSplit", String.valueOf(DbViewer.this.queriesSplit.getDividerLocation()));
                        properties.setProperty("tableCreatorSplit", String.valueOf(DbViewer.this.tableCreatorSplit.getDividerLocation()));
                        interfaceMain.getUndoManager().discardAllEdits();
                        interfaceMain.refreshUndoRedo();
                        interfaceMain.getSaveMenu().removeActionListener(dbViewer);
                        interfaceMain.getSaveAsMenu().removeActionListener(dbViewer);
                        interfaceMain.getSaveAsMenu().setEnabled(false);
                        interfaceMain.getSaveMenu().setEnabled(false);
                        jFrame.getContentPane().removeAll();
                        XMLDB.closeDatabase();
                    }
                    if (propertyChangeEvent.getNewValue().equals(controlStr)) {
                        Object object;
                        File file;
                        properties = interfaceMain.getProperties();
                        String string = properties.getProperty("queryFile", null);
                        File file2 = file = string != null ? new File(string) : null;
                        if (file == null || !file.exists()) {
                            object = FileChooserFactory.getFileChooser();
                            XMLFilter xMLFilter = new XMLFilter();
                            File[] fileArray = object.doFilePrompt(jFrame, "Could not find query file.  Please select one.", 0, new File(interfaceMain.getProperties().getProperty("lastDirectory", ".")), xMLFilter);
                            if (fileArray == null && fileArray.length > 0) {
                                string = "Main_queries.xml";
                                file = new File(string);
                            } else {
                                file = fileArray[0];
                                string = file.getAbsolutePath();
                            }
                            properties.setProperty("queryFile", string);
                        }
                        DbViewer.this.scenarioRegionSplit = new JSplitPane(1, true);
                        DbViewer.this.scenarioRegionSplit.setResizeWeight(0.5);
                        DbViewer.this.queriesSplit = new JSplitPane(1, true);
                        DbViewer.this.queriesSplit.setResizeWeight(0.5);
                        DbViewer.this.tableCreatorSplit = new JSplitPane(0, false);
                        try {
                            object = properties.getProperty("scenarioRegionSplit");
                            if (object != null) {
                                DbViewer.this.scenarioRegionSplit.setDividerLocation(Integer.valueOf((String)object));
                            }
                            if ((object = properties.getProperty("queriesSplit")) != null) {
                                DbViewer.this.queriesSplit.setDividerLocation(Integer.valueOf((String)object));
                            }
                            if ((object = properties.getProperty("tableCreatorSplit")) != null) {
                                DbViewer.this.tableCreatorSplit.setDividerLocation(Integer.valueOf((String)object));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid split location preference: " + numberFormatException);
                        }
                        interfaceMain.getSaveMenu().addActionListener(dbViewer);
                        interfaceMain.getSaveAsMenu().addActionListener(dbViewer);
                        interfaceMain.getSaveAsMenu().setEnabled(true);
                        DbViewer.this.queriesDoc = DbViewer.this.readQueries(file);
                    }
                }
            }
        });
    }

    private JMenuItem makeMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    @Override
    public void addMenuItems(InterfaceMain.MenuManager menuManager) {
        final InterfaceMain interfaceMain = InterfaceMain.getInstance();
        JFrame jFrame = interfaceMain.getFrame();
        JMenuItem jMenuItem = new JMenuItem("DB Open");
        jMenuItem.addActionListener(this);
        menuManager.getSubMenuManager(0).getSubMenuManager(5).addMenuItem(jMenuItem, 30);
        final JMenuItem jMenuItem2 = this.makeMenuItem("Manage DB");
        menuManager.getSubMenuManager(0).addMenuItem(jMenuItem2, 10);
        jMenuItem2.setEnabled(false);
        final DbViewer dbViewer = this;
        jFrame.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Control")) {
                    JMenuItem jMenuItem;
                    if (propertyChangeEvent.getOldValue().equals(controlStr) || propertyChangeEvent.getOldValue().equals(controlStr + "Same")) {
                        jMenuItem2.setEnabled(false);
                        jMenuItem = interfaceMain.getBatchMenu();
                        jMenuItem.removeActionListener(dbViewer);
                        jMenuItem.addActionListener(interfaceMain);
                    }
                    if (propertyChangeEvent.getNewValue().equals(controlStr)) {
                        jMenuItem2.setEnabled(true);
                        jMenuItem = interfaceMain.getBatchMenu();
                        jMenuItem.removeActionListener(interfaceMain);
                        jMenuItem.addActionListener(dbViewer);
                    }
                }
            }
        });
        final JMenuItem jMenuItem3 = this.makeMenuItem("Export / Print");
        menuManager.getSubMenuManager(0).addMenuItem(jMenuItem3, 20);
        menuManager.getSubMenuManager(0).addSeparator(20);
        jMenuItem3.setEnabled(false);
        jFrame.addPropertyChangeListener(new PropertyChangeListener(){
            private int numQueries = 0;

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Control")) {
                    if (propertyChangeEvent.getOldValue().equals(controlStr) || propertyChangeEvent.getOldValue().equals(controlStr + "Same")) {
                        jMenuItem3.setEnabled(false);
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("Query") && propertyChangeEvent.getOldValue() == null) {
                    jMenuItem3.setEnabled(true);
                    ++this.numQueries;
                } else if (propertyChangeEvent.getPropertyName().equals("Query") && propertyChangeEvent.getNewValue() == null && --this.numQueries == 0) {
                    jMenuItem3.setEnabled(false);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        InterfaceMain interfaceMain = InterfaceMain.getInstance();
        JFrame jFrame = interfaceMain.getFrame();
        if (actionEvent.getActionCommand().equals("DB Open")) {
            File[] fileArray;
            if (actionEvent.getSource() instanceof RecentFilesList.RecentFile) {
                fileArray = ((RecentFilesList.RecentFile)actionEvent.getSource()).getFiles();
            } else {
                FileFilter fileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return "Directory for a BaseX DB";
                    }
                };
                FileChooser fileChooser = FileChooserFactory.getFileChooser();
                fileArray = fileChooser.doFilePrompt(jFrame, "Choose XML Database", 0, new File(interfaceMain.getProperties().getProperty("lastDirectory", ".")), fileFilter, this, "DB Open");
            }
            if (fileArray != null) {
                interfaceMain.fireControlChange(controlStr);
                this.doOpenDB(fileArray[0]);
            }
        } else if (actionEvent.getActionCommand().equals("Manage DB")) {
            this.manageDB();
        } else if (actionEvent.getActionCommand().equals("Batch File")) {
            FileChooser fileChooser = FileChooserFactory.getFileChooser();
            XMLFilter xMLFilter = new XMLFilter();
            File[] fileArray = fileChooser.doFilePrompt(jFrame, "Open batch Query File", 0, new File(interfaceMain.getProperties().getProperty("lastDirectory", ".")), xMLFilter);
            if (fileArray == null) {
                return;
            }
            interfaceMain.getProperties().setProperty("lastDirectory", fileArray[0].getParent());
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().toLowerCase().endsWith(".xls") || file.getName().toLowerCase().endsWith(".csv") || file.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "Microsoft Excel File(*.xls) or CSV (*.csv)";
                }
            };
            File[] fileArray2 = fileChooser.doFilePrompt(jFrame, "Select Where to Save Output", 1, new File(interfaceMain.getProperties().getProperty("lastDirectory", ".")), fileFilter);
            if (fileArray2 == null) {
                return;
            }
            for (int i = 0; i < fileArray2.length; ++i) {
                if (fileArray2[i].getName().endsWith(".xls") || fileArray2[i].getName().endsWith(".csv")) continue;
                fileArray2[i] = new File(fileArray2[i].getAbsolutePath() + ".xls");
            }
            interfaceMain.getProperties().setProperty("lastDirectory", fileArray2[0].getParent());
            this.batchQuery(fileArray[0], fileArray2[0]);
        } else if (actionEvent.getActionCommand().equals("Export / Print")) {
            this.createReport();
        } else if (actionEvent.getActionCommand().equals("Save")) {
            this.writeQueries();
        } else if (actionEvent.getActionCommand().equals("Save As")) {
            XMLFilter xMLFilter = new XMLFilter();
            FileChooser fileChooser = FileChooserFactory.getFileChooser();
            File[] fileArray = fileChooser.doFilePrompt(jFrame, null, 1, new File(interfaceMain.getProperties().getProperty("queryFile", ".")), xMLFilter);
            if (fileArray != null) {
                File file = fileArray[0];
                if (file.getName().indexOf(46) == -1 && !file.getAbsolutePath().endsWith(".xml")) {
                    file = new File(file.getAbsolutePath() + ".xml");
                }
                if (!file.exists() || InterfaceMain.getInstance().showConfirmDialog("Overwrite existing file?", "Confirm Overwrite", 0, 3, 0) == 0) {
                    interfaceMain.getProperties().setProperty("queryFile", file.getAbsolutePath());
                    this.writeQueries();
                }
            }
        }
    }

    private void doOpenDB(File file) {
        InterfaceMain interfaceMain = InterfaceMain.getInstance();
        JFrame jFrame = interfaceMain.getFrame();
        interfaceMain.getProperties().setProperty("lastDirectory", file.getParent());
        jFrame.getGlassPane().setVisible(true);
        try {
            XMLDB.openDatabase(file.getAbsolutePath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            jFrame.getGlassPane().setVisible(false);
            InterfaceMain.getInstance().showMessageDialog("Could not open the xml database.", "DB Open Error", 0);
            return;
        }
        this.tablesTabs.setTransferHandler(new TableTransferHandler());
        TabDragListener tabDragListener = new TabDragListener();
        this.tablesTabs.addMouseListener(tabDragListener);
        this.tablesTabs.addMouseMotionListener(tabDragListener);
        this.createTableSelector();
        jFrame.setTitle("[" + file + "] - ModelInterface");
    }

    public static Vector<ScenarioListItem> getScenarios() {
        return DbViewer.getScenarios(XMLDB.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<ScenarioListItem> getScenarios(XMLDB xMLDB) {
        Vector<ScenarioListItem> vector = new Vector<ScenarioListItem>();
        try (QueryProcessor queryProcessor = xMLDB.createQuery("/scenario", null, null, null);){
            ANode aNode;
            Iter iter = queryProcessor.iter();
            while ((aNode = (ANode)iter.next()) != null) {
                BXNode bXNode = BXNode.get((ANode)aNode);
                BXDoc bXDoc = new BXDoc(aNode.parent());
                String string = "";
                try {
                    string = new File(new URI(bXDoc.getDocumentURI())).getName();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Map<String, String> map = XMLDB.getAttrMap((Node)bXNode);
                vector.add(new ScenarioListItem(string, map.get("name"), map.get("date")));
            }
        }
        return vector;
    }

    public void resetScenarioList() {
        this.scns = DbViewer.getScenarios();
        this.scnList.setListData(this.scns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getRegions() {
        Vector<String> vector = new Vector<String>(1, 0);
        vector.add("distinct-values");
        Vector<Object> vector2 = new Vector<Object>();
        try (QueryProcessor queryProcessor = XMLDB.getInstance().createQuery("/scenario/world/*[@type = 'region']/@name", vector, null, null);){
            Item item;
            Iter iter = queryProcessor.iter();
            while ((item = iter.next()) != null) {
                vector2.add(item.toJava());
            }
        }
        vector2.add("Global");
        return vector2;
    }

    protected QueryTreeModel getQueries() {
        return new QueryTreeModel(this.queriesDoc.getDocumentElement());
    }

    protected void createTableSelector() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.scns = DbViewer.getScenarios();
        this.regions = this.getRegions();
        this.queries = this.getQueries();
        this.scnList = new JList<ScenarioListItem>(this.scns);
        this.scnList.setName(SCENARIO_LIST_NAME);
        this.regionList = new JList(this.regions);
        this.regionList.setName(REGION_LIST_NAME);
        final ImageIcon imageIcon = new ImageIcon(TabCloseIcon.class.getResource("icons/group-query.png"));
        final ImageIcon imageIcon2 = new ImageIcon(TabCloseIcon.class.getResource("icons/single-query.png"));
        final JTree jTree = new JTree(this.queries);
        jTree.setTransferHandler(new QueryTransferHandler(this.queriesDoc, this.implls));
        jTree.setDragEnabled(true);
        jTree.getSelectionModel().setSelectionMode(4);
        jTree.setSelectionRow(0);
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
        ToolTipManager.sharedInstance().registerComponent(jTree);
        jTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (object instanceof QueryGenerator) {
                    this.setToolTipText(DbViewer.this.createCommentTooltip(new TreePath(object)));
                    this.setIcon(imageIcon);
                } else if (object instanceof SingleQueryExtension.SingleQueryValue) {
                    Object[] objectArray = new Object[]{"root", ((SingleQueryExtension.SingleQueryValue)object).getParent(), object};
                    this.setToolTipText(DbViewer.this.createCommentTooltip(new TreePath(objectArray)));
                    this.setIcon(imageIcon2);
                }
                return this;
            }
        });
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("Scenario");
        jPanel.add(jLabel);
        JScrollPane jScrollPane = new JScrollPane(this.scnList);
        jScrollPane.setPreferredSize(new Dimension(150, 150));
        jPanel.add(jScrollPane);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.scenarioRegionSplit.setLeftComponent(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jLabel = new JLabel("Regions");
        jPanel.add(jLabel);
        jScrollPane = new JScrollPane(this.regionList);
        jScrollPane.setPreferredSize(new Dimension(150, 150));
        jPanel.add(jScrollPane);
        this.scenarioRegionSplit.setRightComponent(jPanel);
        jPanel2.add(this.scenarioRegionSplit);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jLabel = new JLabel("Queries");
        jPanel.add(jLabel);
        jScrollPane = new JScrollPane(jTree);
        jScrollPane.setPreferredSize(new Dimension(150, 100));
        jPanel.add(jScrollPane);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        final JButton jButton = new JButton("Create");
        final JButton jButton2 = new JButton("Remove");
        final JButton jButton3 = new JButton("Run Query");
        final JButton jButton4 = new JButton("Edit");
        JButton jButton5 = new JButton("Update Single Queries");
        jButton4.setEnabled(false);
        jButton3.setEnabled(false);
        jPanel3.add(jButton3);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(jButton5);
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton4);
        jPanel.add(jPanel3);
        this.queriesSplit.setLeftComponent(this.scenarioRegionSplit);
        this.queriesSplit.setRightComponent(jPanel);
        jPanel2.add(this.queriesSplit);
        this.tableCreatorSplit.setLeftComponent(jPanel2);
        this.tableCreatorSplit.setRightComponent(this.tablesTabs);
        if (this.scns.size() != 0) {
            this.scnList.setSelectedIndex(this.scns.size() - 1);
            this.scnList.ensureIndexIsVisible(this.scns.size() - 1);
        }
        if (this.regions.size() != 0) {
            this.regionList.setSelectedIndex(0);
        }
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                boolean bl = true;
                boolean bl2 = true;
                boolean bl3 = true;
                boolean bl4 = true;
                if (jTree.getSelectionPaths() != null) {
                    for (TreePath treePath : jTree.getSelectionPaths()) {
                        Object object = treePath.getLastPathComponent();
                        if (object instanceof QueryGenerator) {
                            SingleQueryExtension singleQueryExtension;
                            if (((QueryGenerator)object).hasSingleQueryExtension() || (singleQueryExtension = ((QueryGenerator)object).getSingleQueryExtension()) == null) continue;
                            jTree.addTreeSelectionListener(singleQueryExtension);
                            DbViewer.this.scnList.addListSelectionListener(singleQueryExtension);
                            DbViewer.this.regionList.addListSelectionListener(singleQueryExtension);
                            Object[] objectArray = DbViewer.this.scnList.getSelectedValues();
                            ScenarioListItem[] scenarioListItemArray = new ScenarioListItem[objectArray.length];
                            System.arraycopy(objectArray, 0, scenarioListItemArray, 0, objectArray.length);
                            Object[] objectArray2 = DbViewer.this.regionList.getSelectedValues();
                            String[] stringArray = new String[objectArray2.length];
                            System.arraycopy(objectArray2, 0, stringArray, 0, objectArray2.length);
                            singleQueryExtension.setSelection(scenarioListItemArray, stringArray);
                            singleQueryExtension.valueChanged(treeSelectionEvent);
                            continue;
                        }
                        if (object instanceof SingleQueryExtension.SingleQueryValue) {
                            bl = false;
                            if (!((SingleQueryExtension.SingleQueryValue)object).canExecute()) {
                                bl2 = false;
                            }
                            bl3 = false;
                            bl4 = false;
                            continue;
                        }
                        bl = false;
                        bl2 = false;
                    }
                }
                jButton4.setEnabled(bl);
                jButton3.setEnabled(bl2);
                jButton.setEnabled(bl3);
                jButton2.setEnabled(bl4);
            }
        });
        this.queries.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                if (!(treeModelEvent.getChildren()[0] instanceof SingleQueryExtension.SingleQueryValue)) {
                    TreePath treePath = treeModelEvent.getTreePath().pathByAddingChild(treeModelEvent.getChildren()[0]);
                    jTree.setSelectionPath(treePath);
                    jTree.scrollPathToVisible(treePath);
                }
            }

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jTree.getSelectionCount() != 1) {
                    InterfaceMain.getInstance().showMessageDialog("Please select one Query or Query Group before creating", "Create Query Error", 0);
                    return;
                }
                QueryGenerator queryGenerator = new QueryGenerator();
                if (queryGenerator.getXPath().equals("")) {
                    return;
                }
                if (queryGenerator.getXPath().equals("Query Group")) {
                    DbViewer.this.queries.add(jTree.getSelectionPath(), queryGenerator.toString());
                } else {
                    DbViewer.this.queries.add(jTree.getSelectionPath(), queryGenerator);
                }
                jTree.updateUI();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jTree.getSelectionCount() == 0) {
                    InterfaceMain.getInstance().showMessageDialog("Please select a Query or Query Group to Remove", "Query Remove Error", 0);
                } else {
                    TreePath[] treePathArray = jTree.getSelectionPaths();
                    for (int i = 0; i < treePathArray.length; ++i) {
                        DbViewer.this.queries.remove(treePathArray[i]);
                    }
                    jTree.updateUI();
                }
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = DbViewer.this.scnList.getSelectedIndices();
                int[] nArray2 = DbViewer.this.regionList.getSelectedIndices();
                if (nArray.length == 0) {
                    InterfaceMain.getInstance().showMessageDialog("Please select Scenarios to run the query against", "Run Query Error", 0);
                } else if (nArray2.length == 0) {
                    InterfaceMain.getInstance().showMessageDialog("Please select Regions to run the query against", "Run Query Error", 0);
                } else if (jTree.getSelectionCount() == 0) {
                    InterfaceMain.getInstance().showMessageDialog("Please select a query to run", "Run Query Error", 0);
                } else {
                    TreePath[] treePathArray = jTree.getSelectionPaths();
                    boolean bl = false;
                    for (int i = 0; i < treePathArray.length; ++i) {
                        try {
                            QueryGenerator queryGenerator = null;
                            QueryBinding queryBinding = null;
                            if (treePathArray[i].getLastPathComponent() instanceof QueryGenerator) {
                                queryGenerator = (QueryGenerator)treePathArray[i].getLastPathComponent();
                            } else {
                                queryBinding = ((SingleQueryExtension.SingleQueryValue)treePathArray[i].getLastPathComponent()).getAsQueryBinding();
                                queryGenerator = (QueryGenerator)treePathArray[i].getParentPath().getLastPathComponent();
                            }
                            TabCloseIcon tabCloseIcon = new TabCloseIcon(DbViewer.this.tablesTabs);
                            QueryResultsPanel queryResultsPanel = new QueryResultsPanel(queryGenerator, queryBinding, DbViewer.this.scnList.getSelectedValues(), DbViewer.this.regionList.getSelectedValues(), tabCloseIcon);
                            DbViewer.this.tablesTabs.addTab(queryGenerator.toString(), tabCloseIcon, queryResultsPanel, DbViewer.this.createCommentTooltip(treePathArray[i]));
                            if (bl) continue;
                            DbViewer.this.tablesTabs.setSelectedIndex(DbViewer.this.tablesTabs.getTabCount() - 1);
                            bl = true;
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            System.out.println("Warning: Caught " + classCastException + " likely a QueryGroup was in the selection");
                        }
                    }
                }
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jTree.getSelectionCount() == 0) {
                    InterfaceMain.getInstance().showMessageDialog("Please select a query to edit", "Edit Query Error", 0);
                } else {
                    TreePath[] treePathArray = jTree.getSelectionPaths();
                    for (int i = 0; i < treePathArray.length; ++i) {
                        DbViewer.this.queries.doEdit(treePathArray[i]);
                    }
                }
            }
        });
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTree.setSelectionRow(0);
                ArrayList<QueryGenerator> arrayList = new ArrayList<QueryGenerator>();
                for (int i = 0; i < jTree.getRowCount(); ++i) {
                    TreePath treePath = jTree.getPathForRow(i);
                    if (!(treePath.getLastPathComponent() instanceof QueryGenerator)) continue;
                    arrayList.add((QueryGenerator)treePath.getLastPathComponent());
                }
                DbViewer.this.createAndShowGetSingleQueries(arrayList, DbViewer.this.scns, DbViewer.this.regions);
            }
        });
        JFrame jFrame = InterfaceMain.getInstance().getFrame();
        Container container = jFrame.getContentPane();
        container.add(this.tableCreatorSplit);
        jFrame.getGlassPane().setVisible(false);
        jFrame.setVisible(true);
    }

    private void manageDB() {
        final InterfaceMain interfaceMain = InterfaceMain.getInstance();
        final JFrame jFrame = interfaceMain.getFrame();
        final JDialog jDialog = new JDialog(jFrame, "Manage Database", true);
        jDialog.getGlassPane().addMouseListener(new MouseAdapter(){});
        jDialog.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        final DbViewer dbViewer = this;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Add");
        final JButton jButton2 = new JButton("Remove");
        final JButton jButton3 = new JButton("Rename");
        final JButton jButton4 = new JButton("Export");
        JButton jButton5 = new JButton("Done");
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Container container = jDialog.getContentPane();
        jButton2.setEnabled(false);
        jButton3.setEnabled(false);
        jButton4.setEnabled(false);
        final JList<ScenarioListItem> jList = new JList<ScenarioListItem>(this.scns);
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (jList.getSelectedIndex() == -1) {
                    jButton2.setEnabled(false);
                    jButton3.setEnabled(false);
                    jButton4.setEnabled(false);
                } else {
                    jButton2.setEnabled(true);
                    jButton3.setEnabled(true);
                    jButton4.setEnabled(true);
                }
            }
        });
        final DirtyBit dirtyBit = new DirtyBit();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileChooser fileChooser = FileChooserFactory.getFileChooser();
                XMLFilter xMLFilter = new XMLFilter();
                final File[] fileArray = fileChooser.doFilePrompt(jFrame, "Open XML File", 0, new File(interfaceMain.getProperties().getProperty("lastDirectory", ".")), xMLFilter);
                if (fileArray != null) {
                    dirtyBit.setDirty();
                    interfaceMain.getProperties().setProperty("lastDirectory", fileArray[0].getParent());
                    final JProgressBar jProgressBar = new JProgressBar(0, fileArray.length);
                    final JDialog jDialog = XMLDB.createProgressBarGUI(jProgressBar, "Adding Runs", "Importing runs into the database");
                    final Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            jProgressBar.setValue(jProgressBar.getValue() + 1);
                        }
                    };
                    jDialog.setVisible(true);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < fileArray.length; ++i) {
                                XMLDB.getInstance().addFile(fileArray[i].getAbsolutePath());
                                SwingUtilities.invokeLater(runnable);
                            }
                            DbViewer.this.scns = DbViewer.getScenarios();
                            jList.setListData(DbViewer.this.scns);
                            jDialog.setVisible(false);
                        }
                    }).start();
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = jList.getSelectedValues();
                jDialog.getGlassPane().setVisible(true);
                for (int i = 0; i < objectArray.length; ++i) {
                    dirtyBit.setDirty();
                    XMLDB.getInstance().removeDoc(((ScenarioListItem)objectArray[i]).getDocName());
                }
                DbViewer.this.scns = DbViewer.getScenarios();
                jList.setListData(DbViewer.this.scns);
                jDialog.getGlassPane().setVisible(false);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                JComponent jComponent;
                Object object2;
                Object[] objectArray = jList.getSelectedValues();
                if (objectArray.length == 0) {
                    return;
                }
                JDialog jDialog = new JDialog(jFrame, "Rename Scenarios", true);
                jDialog.setResizable(false);
                ArrayList<JTextField> arrayList = new ArrayList<JTextField>(objectArray.length);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 1));
                Component component = Box.createVerticalStrut(5);
                for (int i = 0; i < objectArray.length; ++i) {
                    object2 = (ScenarioListItem)objectArray[i];
                    jComponent = new JPanel();
                    jComponent.setLayout(new BoxLayout(jComponent, 0));
                    object = new JLabel("<html>Rename <b>" + ((ScenarioListItem)object2).getScnName() + "</b> on <b>" + ((ScenarioListItem)object2).getScnDate() + "</b> to:</html>");
                    JTextField jTextField = new JTextField(((ScenarioListItem)object2).getScnName(), 20);
                    jTextField.setMaximumSize(jTextField.getPreferredSize());
                    arrayList.add(jTextField);
                    jComponent.add((Component)object);
                    jComponent.add(Box.createHorizontalGlue());
                    jPanel.add(jComponent);
                    jComponent = new JPanel();
                    jComponent.setLayout(new BoxLayout(jComponent, 0));
                    jComponent.add(jTextField);
                    jComponent.add(Box.createHorizontalGlue());
                    jPanel.add(jComponent);
                    jPanel.add(component);
                }
                JPanel jPanel2 = new JPanel();
                object2 = new JButton("  OK  ");
                jComponent = new JButton("Cancel");
                jPanel2.setLayout(new BoxLayout(jPanel2, 0));
                jPanel2.add(Box.createHorizontalGlue());
                jPanel2.add((Component)object2);
                jPanel2.add(jComponent);
                object = new ActionListener((JButton)object2, objectArray, arrayList, jDialog){
                    final /* synthetic */ JButton val$renameOK;
                    final /* synthetic */ Object[] val$renameList;
                    final /* synthetic */ List val$renameBoxes;
                    final /* synthetic */ JDialog val$renameScenarioDialog;
                    {
                        this.val$renameOK = jButton;
                        this.val$renameList = objectArray;
                        this.val$renameBoxes = list;
                        this.val$renameScenarioDialog = jDialog;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getSource() == this.val$renameOK) {
                            for (int i = 0; i < this.val$renameList.length; ++i) {
                                ScenarioListItem scenarioListItem = (ScenarioListItem)this.val$renameList[i];
                                String string = ((JTextField)this.val$renameBoxes.get(i)).getText();
                                if (scenarioListItem.getScnName().equals(string)) continue;
                                RenameScenarioUndoableEdit renameScenarioUndoableEdit = new RenameScenarioUndoableEdit(dbViewer, scenarioListItem, string);
                                InterfaceMain.getInstance().getUndoManager().addEdit(renameScenarioUndoableEdit);
                                InterfaceMain.getInstance().refreshUndoRedo();
                            }
                        }
                        jList.setListData(DbViewer.this.scns);
                        this.val$renameScenarioDialog.dispose();
                    }
                };
                ((AbstractButton)object2).addActionListener((ActionListener)object);
                ((AbstractButton)jComponent).addActionListener((ActionListener)object);
                jPanel.add(jPanel2);
                jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
                jDialog.getContentPane().add(jPanel);
                jDialog.pack();
                jDialog.setVisible(true);
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                FileFilter fileFilter;
                boolean bl;
                final Object[] objectArray = jList.getSelectedValues();
                boolean bl2 = bl = objectArray.length == 1;
                if (bl) {
                    fileFilter = new XMLFileFilter();
                    string = "Save As XML";
                } else {
                    fileFilter = new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isDirectory();
                        }

                        @Override
                        public String getDescription() {
                            return "Directory to export into";
                        }
                    };
                    string = "Select Export Directory";
                }
                FileChooser fileChooser = FileChooserFactory.getFileChooser();
                final File[] fileArray = fileChooser.doFilePrompt(jFrame, string, 1, new File(interfaceMain.getProperties().getProperty("lastDirectory", ".")), fileFilter);
                if (bl && !fileArray[0].getName().endsWith(".xml")) {
                    fileArray[0] = new File(fileArray[0].getParentFile(), fileArray[0].getName() + ".xml");
                }
                if (fileArray == null) {
                    return;
                }
                final JProgressBar jProgressBar = new JProgressBar(0, objectArray.length);
                final JDialog jDialog = XMLDB.createProgressBarGUI(jProgressBar, "Exporting Runs", "Exporting runs from the database");
                final Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        jProgressBar.setValue(jProgressBar.getValue() + 1);
                    }
                };
                jDialog.setVisible(true);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        boolean bl2 = true;
                        for (int i = 0; i < objectArray.length; ++i) {
                            File file;
                            ScenarioListItem scenarioListItem = (ScenarioListItem)objectArray[i];
                            if (bl) {
                                file = fileArray[0];
                            } else {
                                String string = scenarioListItem.getScnName() + "_" + scenarioListItem.getScnDate().replaceAll(":", "_") + ".xml";
                                file = new File(fileArray[0], string);
                            }
                            bl2 = bl2 && XMLDB.getInstance().exportDoc(scenarioListItem.getDocName(), file);
                            SwingUtilities.invokeLater(runnable);
                        }
                        jDialog.setVisible(false);
                        if (bl2) {
                            InterfaceMain.getInstance().showMessageDialog("Scenario export succeeded.", "Scenario Export", 1);
                        } else {
                            InterfaceMain.getInstance().showMessageDialog("Scenario export failed.", null, 0);
                        }
                    }
                }).start();
            }
        });
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (dirtyBit.isDirty()) {
                    DbViewer.this.scnList.setListData(DbViewer.this.scns);
                    DbViewer.this.regions = DbViewer.this.getRegions();
                    DbViewer.this.regionList.setListData(DbViewer.this.regions);
                }
                jDialog.setVisible(false);
            }
        });
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(jButton);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(jButton2);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(jButton3);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(jButton4);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(jButton5);
        jPanel2.add(Box.createHorizontalGlue());
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        jPanel.add(new JLabel("Scenarios in Database:"));
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        container.add((Component)jPanel, "First");
        container.add((Component)jPanel2, "Last");
        jDialog.pack();
        jDialog.setVisible(true);
    }

    public void createReport() {
        if (this.tablesTabs.getTabCount() == 0) {
            return;
        }
        throw new UnsupportedOperationException("This feature is currently disabled.");
    }

    protected void batchQuery(File file, File file2) {
        NodeList nodeList;
        JFrame jFrame = InterfaceMain.getInstance().getFrame();
        Vector<ScenarioListItem> vector = DbViewer.getScenarios();
        Properties properties = InterfaceMain.getInstance().getProperties();
        int n = Runtime.getRuntime().availableProcessors();
        int n2 = Integer.valueOf(properties.getProperty("coresToUse", Integer.toString(2)));
        properties.setProperty("coresToUse", Integer.toString(n2));
        final JList<ScenarioListItem> jList = new JList<ScenarioListItem>(vector);
        final JDialog jDialog = new JDialog(jFrame, "Select Scenarios to Run", true);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JCheckBox jCheckBox = new JCheckBox("Place all results in different sheets", Boolean.parseBoolean(properties.getProperty("batchQueryResultsInDifferentSheets", "false")));
        JCheckBox jCheckBox2 = new JCheckBox("Include charts with results", Boolean.parseBoolean(properties.getProperty("batchQueryIncludeCharts", "true")));
        JCheckBox jCheckBox3 = new JCheckBox("Split runs into different sheets", Boolean.parseBoolean(properties.getProperty("batchQuerySplitRunsInDifferentSheets", "false")));
        final JButton jButton = new JButton("Ok");
        jButton.setEnabled(false);
        JButton jButton2 = new JButton("Cancel");
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Container container = jDialog.getContentPane();
        JCheckBox jCheckBox4 = new JCheckBox("Overwrite selected file if it exists", Boolean.parseBoolean(properties.getProperty("batchQueryReplaceResults", "false")));
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (jList.isSelectionEmpty()) {
                    jButton.setEnabled(false);
                } else {
                    jButton.setEnabled(true);
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jList.clearSelection();
                jDialog.dispose();
            }
        });
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(jButton2);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        jPanel.add(new JLabel("Select Scenarios:"));
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jScrollPane);
        jPanel.add(jCheckBox);
        jPanel.add(jCheckBox4);
        jPanel.add(jCheckBox2);
        jPanel.add(jCheckBox3);
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        container.add((Component)jPanel, "First");
        container.add((Component)jPanel2, "Last");
        jDialog.pack();
        jDialog.setVisible(true);
        if (jList.isSelectionEmpty()) {
            return;
        }
        properties.setProperty("batchQueryResultsInDifferentSheets", Boolean.toString(jCheckBox.isSelected()));
        properties.setProperty("batchQueryIncludeCharts", Boolean.toString(jCheckBox2.isSelected()));
        properties.setProperty("batchQuerySplitRunsInDifferentSheets", Boolean.toString(jCheckBox3.isSelected()));
        properties.setProperty("batchQueryReplaceResults", Boolean.toString(jCheckBox4.isSelected()));
        Document document = this.readQueries(file);
        try {
            nodeList = (NodeList)XPathFactory.newInstance().newXPath().evaluate("/queries/node()", document, XPathConstants.NODESET);
        }
        catch (Exception exception) {
            InterfaceMain.getInstance().showMessageDialog("Could not find queries to run in batch file:\n" + file, "Batch Query Error", 0);
            exception.printStackTrace();
            return;
        }
        int n3 = nodeList.getLength();
        if (n3 == 0) {
            InterfaceMain.getInstance().showMessageDialog("Could not find queries to run in batch file:\n" + file, "Batch Query Error", 0);
            return;
        }
        Vector<Object[]> vector2 = new Vector<Object[]>();
        if (!jCheckBox3.isSelected()) {
            vector2.add(jList.getSelectedValues());
        } else {
            for (Object object : jList.getSelectedValues()) {
                Object[] objectArray = new Object[]{object};
                vector2.add(objectArray);
            }
        }
        Vector vector3 = new Vector(this.regions);
        vector3.remove("Global");
        BatchWindow batchWindow = new BatchWindow(file2, vector2, vector3, jCheckBox.isSelected(), jCheckBox2.isSelected(), n3, nodeList, jCheckBox4.isSelected(), n2);
    }

    public boolean writeFile(File file, Document document) {
        LSSerializer lSSerializer = this.implls.createLSSerializer();
        DOMConfiguration dOMConfiguration = lSSerializer.getDomConfig();
        boolean bl = Boolean.parseBoolean(System.getProperty("ModelInterface.pretty-print", "true"));
        dOMConfiguration.setParameter("format-pretty-print", bl);
        try {
            LSOutput lSOutput = this.implls.createLSOutput();
            lSOutput.setByteStream(new FileOutputStream(file));
            lSSerializer.write(document, lSOutput);
        }
        catch (Exception exception) {
            System.err.println("Error outputing tree: " + exception);
            return false;
        }
        return true;
    }

    public Document readQueries(File file) {
        if (file.exists()) {
            LSInput lSInput = this.implls.createLSInput();
            try {
                lSInput.setByteStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            LSParser lSParser = this.implls.createLSParser((short)1, null);
            lSParser.setFilter(new ParseFilter());
            return lSParser.parse(lSInput);
        }
        return ((DOMImplementation)((Object)this.implls)).createDocument("", "queries", null);
    }

    public void filterNodes(Node node, LSParserFilter lSParserFilter) {
        Node node2 = node.getFirstChild();
        int n = lSParserFilter.getWhatToShow();
        while (node2 != null) {
            boolean bl;
            Node node3 = node2.getNextSibling();
            switch (node2.getNodeType()) {
                case 2: {
                    bl = (n & 2) != 0;
                    break;
                }
                case 8: {
                    bl = (n & 0x80) != 0;
                    break;
                }
                case 1: {
                    bl = (n & 1) != 0;
                    break;
                }
                case 3: {
                    bl = (n & 4) != 0;
                    break;
                }
                default: {
                    boolean bl2 = bl = (n & 0xFFFFFFFF) != 0;
                }
            }
            if (bl && lSParserFilter.acceptNode(node2) == 2) {
                node.removeChild(node2);
            } else {
                this.filterNodes(node2, lSParserFilter);
            }
            node2 = node3;
        }
    }

    private void writeQueries() {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation().createDocument(null, "queries", null);
            this.queries.getAsNode(document);
            this.writeFile(new File(InterfaceMain.getInstance().getProperties().getProperty("queryFile")), document);
            this.queries.resetChanges();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    public static BaseTableModel getTableModelFromComponent(Component component) {
        try {
            Component component2 = ((QueryResultsPanel)component).getComponent(0);
            if (component2 instanceof JPanel) {
                return null;
            }
            if (component2 instanceof JSplitPane) {
                return (BaseTableModel)((TableSorter)((JTable)((JScrollPane)((JSplitPane)component2).getLeftComponent()).getViewport().getView()).getModel()).getTableModel();
            }
            return (BaseTableModel)((JTable)((JScrollPane)component2).getViewport().getView()).getModel();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            return null;
        }
    }

    public static JTable getJTableFromComponent(Component component) {
        try {
            QueryResultsPanel queryResultsPanel = (QueryResultsPanel)component;
            Component component2 = queryResultsPanel.getComponent(0);
            if (component2 instanceof JPanel) {
                return null;
            }
            if (component2 instanceof JSplitPane) {
                return (JTable)((JScrollPane)((JSplitPane)component2).getLeftComponent()).getViewport().getView();
            }
            return (JTable)((JScrollPane)component2).getViewport().getView();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            return null;
        }
    }

    private String createCommentTooltip(TreePath treePath) {
        QueryGenerator queryGenerator = treePath.getLastPathComponent() instanceof QueryGenerator ? (QueryGenerator)treePath.getLastPathComponent() : (QueryGenerator)treePath.getParentPath().getLastPathComponent();
        StringBuilder stringBuilder = new StringBuilder("<html><table cellpadding=\"2\"><tr><td>");
        for (int i = 1; i < treePath.getPathCount() - 1; ++i) {
            stringBuilder.append(treePath.getPathComponent(i)).append(":<br>");
        }
        stringBuilder.append(treePath.getLastPathComponent()).append("<br><br>Comments:<br>").append(queryGenerator.getComments()).append("</td></tr></table></html>");
        return stringBuilder.toString();
    }

    private void createAndShowGetSingleQueries(List<QueryGenerator> list, List<ScenarioListItem> list2, List<String> list3) {
        JFrame jFrame = InterfaceMain.getInstance().getFrame();
        final JDialog jDialog = new JDialog(jFrame, "Update Single Query Cache", true);
        JTabbedPane jTabbedPane = new JTabbedPane();
        final ScenarioListItem[] scenarioListItemArray = new ScenarioListItem[list2.size()];
        final String[] stringArray = new String[list3.size()];
        final QueryGenerator[] queryGeneratorArray = new QueryGenerator[list.size()];
        list2.toArray(scenarioListItemArray);
        list3.toArray(stringArray);
        list.toArray(queryGeneratorArray);
        final JList<ScenarioListItem> jList = new JList<ScenarioListItem>(scenarioListItemArray);
        final JList<String> jList2 = new JList<String>(stringArray);
        final JList<QueryGenerator> jList3 = new JList<QueryGenerator>(queryGeneratorArray);
        final JButton jButton = new JButton("Scan");
        JButton jButton2 = new JButton("Cancel");
        JPanel jPanel = new JPanel();
        final Component component = Box.createRigidArea(new Dimension(20, 10));
        final JProgressBar jProgressBar = new JProgressBar(0, list.size());
        final JLabel jLabel = new JLabel("Label");
        final Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        jProgressBar.setValue(jProgressBar.getValue() + 1);
                    }
                };
                int[] nArray = jList.getSelectedIndices();
                ScenarioListItem[] scenarioListItemArray2 = new ScenarioListItem[nArray.length];
                int n = 0;
                for (int queryProcessor : nArray) {
                    scenarioListItemArray2[n++] = scenarioListItemArray[queryProcessor];
                }
                nArray = jList2.getSelectedIndices();
                String[] stringArray2 = new String[nArray.length];
                n = 0;
                for (int aNode : nArray) {
                    stringArray2[n++] = stringArray[aNode];
                }
                nArray = jList3.getSelectedIndices();
                Object object = new ArrayList(nArray.length);
                for (int iter : nArray) {
                    object.add(queryGeneratorArray[iter]);
                }
                jProgressBar.setMaximum(nArray.length);
                Object object2 = XMLDB.getInstance();
                ANode aNode = null;
                try (QueryProcessor queryProcessor = ((XMLDB)object2).createQuery("/singleQueryListCache", null, null, null);){
                    Iter iter = queryProcessor.iter();
                    aNode = (ANode)iter.next();
                    if (aNode == null) {
                        ((XMLDB)object2).addFile("cache.xml", "<singleQueryListCache />");
                        queryProcessor = ((XMLDB)object2).createQuery("/singleQueryListCache", null, null, null);
                        iter = queryProcessor.iter();
                        aNode = (ANode)iter.next();
                    }
                }
                boolean bl = aNode == null;
                Iterator iterator = object.iterator();
                while (iterator.hasNext() && !bl) {
                    QueryGenerator queryGenerator = (QueryGenerator)iterator.next();
                    jLabel.setText("Scanning " + queryGenerator.toString());
                    SingleQueryExtension singleQueryExtension = queryGenerator.getSingleQueryExtension();
                    if (singleQueryExtension != null) {
                        singleQueryExtension.createSingleQueryListCache(aNode, scenarioListItemArray2, stringArray2);
                    }
                    SwingUtilities.invokeLater(runnable);
                    bl = Thread.interrupted();
                }
                jDialog.setVisible(false);
            }
        });
        jList.setSelectionInterval(0, scenarioListItemArray.length - 1);
        jList2.setSelectionInterval(0, stringArray.length - 1);
        jList3.setSelectionInterval(0, queryGeneratorArray.length - 1);
        jTabbedPane.addTab("Scenarios", new JScrollPane(jList));
        jTabbedPane.addTab("Regions", new JScrollPane(jList2));
        jTabbedPane.addTab("Queries", new JScrollPane(jList3));
        jTabbedPane.setPreferredSize(new Dimension(400, 400));
        final JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(jLabel);
        jPanel2.add(Box.createHorizontalGlue());
        final JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(jButton);
        jPanel3.add(component);
        jPanel3.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (thread.isAlive()) {
                    int[] nArray;
                    jLabel.setText("Canceling Scan");
                    thread.interrupt();
                    for (int n : nArray = jList3.getSelectedIndices()) {
                        queryGeneratorArray[n].getSingleQueryExtension().interruptGatherThread();
                    }
                } else {
                    jDialog.setVisible(false);
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setEnabled(false);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 1));
                jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                jPanel.add(jProgressBar);
                jPanel.add(jPanel2);
                jPanel.add(Box.createHorizontalStrut(300));
                jPanel.add(Box.createVerticalGlue());
                jPanel.add(new JSeparator(0));
                jPanel.add(component);
                jPanel.add(jPanel3);
                thread.start();
                jDialog.setContentPane(jPanel);
                jDialog.pack();
            }
        });
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add(jTabbedPane);
        jPanel.add(component);
        jPanel.add(new JSeparator(0));
        jPanel.add(component);
        jPanel.add(jPanel3);
        jDialog.setSize(400, 400);
        jDialog.setResizable(false);
        jDialog.setContentPane(jPanel);
        jDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runBatch(Node node) {
        Properties properties = InterfaceMain.getInstance().getProperties();
        int n = Runtime.getRuntime().availableProcessors();
        int n2 = Integer.valueOf(properties.getProperty("coresToUse", Integer.toString(2)));
        properties.setProperty("coresToUse", Integer.toString(n2));
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || (string = ((Element)node2).getAttribute("name")) == null) continue;
            if (string.equals("XMLDB Batch File")) {
                Object object;
                File file = null;
                Object object2 = null;
                File file2 = null;
                String string2 = null;
                boolean bl = false;
                ArrayList<DataPair<String, String>> arrayList = new ArrayList<DataPair<String, String>>();
                boolean bl2 = Boolean.parseBoolean(properties.getProperty("batchQueryResultsInDifferentSheets", "false"));
                boolean bl3 = Boolean.parseBoolean(properties.getProperty("batchQueryIncludeCharts", "true"));
                boolean bl4 = Boolean.parseBoolean(properties.getProperty("batchQuerySplitRunsInDifferentSheets", "false"));
                boolean bl5 = Boolean.parseBoolean(properties.getProperty("batchQueryReplaceResults", "false"));
                int n3 = n2;
                NodeList nodeList2 = node2.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    object = nodeList2.item(j);
                    if (object.getNodeType() != 1) continue;
                    if (object.getNodeName().equals("queryFile")) {
                        file = new File(object.getTextContent());
                        continue;
                    }
                    if (object.getNodeName().equals("queries")) {
                        object2 = object;
                        continue;
                    }
                    if (object.getNodeName().equals("outFile")) {
                        file2 = new File(object.getTextContent());
                        continue;
                    }
                    if (object.getNodeName().equals("xmldbLocation")) {
                        string2 = object.getTextContent();
                        continue;
                    }
                    if (object.getNodeName().equals("scenario")) {
                        arrayList.add(new DataPair<String, String>(((Element)object).getAttribute("name"), ((Element)object).getAttribute("date")));
                        continue;
                    }
                    if (object.getNodeName().equals("batchQueryResultsInDifferentSheets")) {
                        bl2 = Boolean.parseBoolean(object.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (object.getNodeName().equals("batchQueryIncludeCharts")) {
                        bl3 = Boolean.parseBoolean(object.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (object.getNodeName().equals("batchQuerySplitRunsInDifferentSheets")) {
                        bl4 = Boolean.parseBoolean(object.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (object.getNodeName().equals("batchQueryReplaceResults")) {
                        bl5 = Boolean.parseBoolean(object.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (object.getNodeName().equals("coresToUse")) {
                        n3 = Integer.parseInt(object.getFirstChild().getNodeValue());
                        continue;
                    }
                    System.out.println("Unknown tag: " + object.getNodeName());
                }
                try {
                    Object object3;
                    Object object4;
                    Object object5;
                    if (file == null && object2 == null || file2 == null || string2 == null) {
                        throw new Exception("Not enough information provided to run batch query.");
                    }
                    if (XMLDB.getInstance() == null) {
                        XMLDB.openDatabase(string2);
                        bl = true;
                    }
                    Vector<ScenarioListItem> vector = DbViewer.getScenarios();
                    object = new Vector();
                    if (arrayList.isEmpty() && !vector.isEmpty()) {
                        ((Vector)object).add(vector.lastElement());
                    } else {
                        for (DataPair dataPair : arrayList) {
                            object5 = (String)dataPair.getKey();
                            object4 = (String)dataPair.getValue();
                            if (object4 == "") {
                                object4 = null;
                            }
                            if ((object3 = ScenarioListItem.findClosestScenario(vector, (String)object5, (String)object4)) == null) continue;
                            ((Vector)object).add(object3);
                        }
                    }
                    if (((Vector)object).isEmpty()) {
                        throw new Exception("Could not find scenarios to run.");
                    }
                    if (file != null && object2 != null) {
                        throw new Exception("Setting both a queryFile and inline queries is not allowed.");
                    }
                    if (file != null) {
                        object2 = this.readQueries(file).getDocumentElement();
                    } else {
                        this.filterNodes((Node)object2, new ParseFilter());
                    }
                    NodeList nodeList3 = (NodeList)XPathFactory.newInstance().newXPath().evaluate("./aQuery", object2, XPathConstants.NODESET);
                    int n4 = nodeList3.getLength();
                    if (n4 == 0) {
                        throw new Exception("Could not find queries to run.");
                    }
                    object5 = new Vector();
                    if (!bl4) {
                        ((Vector)object5).add(((Vector)object).toArray());
                    } else {
                        object4 = ((Vector)object).iterator();
                        while (object4.hasNext()) {
                            object3 = new Object[]{object4.next()};
                            ((Vector)object5).add(object3);
                        }
                    }
                    object4 = this.getRegions();
                    ((Vector)object4).remove("Global");
                    object3 = new BatchWindow(file2, (Vector<Object[]>)object5, (Vector<String>)object4, bl2, bl3, n4, nodeList3, bl5, n3);
                    if (object3 == null) continue;
                    ((BatchWindow)object3).waitForFinish();
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                finally {
                    if (bl) {
                        XMLDB.closeDatabase();
                    }
                }
            }
            System.out.println("Unknown command: " + string);
        }
    }

    private class TabDragListener
    implements MouseListener,
    MouseMotionListener {
        MouseEvent firstMouseEvent = null;

        private TabDragListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (DbViewer.this.tablesTabs.getTabCount() > 0 && DbViewer.this.tablesTabs.getBoundsAt(DbViewer.this.tablesTabs.getSelectedIndex()).contains(mouseEvent.getPoint())) {
                this.firstMouseEvent = mouseEvent;
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.firstMouseEvent != null && DbViewer.this.tablesTabs.getTabCount() > 0 && DbViewer.this.tablesTabs.getBoundsAt(DbViewer.this.tablesTabs.getSelectedIndex()).contains(mouseEvent.getPoint())) {
                mouseEvent.consume();
                int n = 1;
                int n2 = Math.abs(mouseEvent.getX() - this.firstMouseEvent.getX());
                int n3 = Math.abs(mouseEvent.getY() - this.firstMouseEvent.getY());
                if (n2 > 5 || n3 > 5) {
                    JComponent jComponent = (JComponent)mouseEvent.getSource();
                    DbViewer.this.tablesTabs.getTransferHandler().exportAsDrag(DbViewer.this.tablesTabs, this.firstMouseEvent, n);
                    this.firstMouseEvent = null;
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class DirtyBit {
        private boolean mIsDirty = false;

        public void setDirty() {
            this.mIsDirty = true;
        }

        public boolean isDirty() {
            return this.mIsDirty;
        }
    }
}

