/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2;

import ModelInterface.InterfaceMain;
import ModelInterface.ModelGUI2.DOMmodel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;
import org.w3c.dom.Node;

public class DOMTreeCellEditor
implements TreeCellEditor {
    ArrayList<CellEditorListener> listeners;
    JTextField tf = new JTextField(40);
    Node initEditVal;

    public DOMTreeCellEditor() {
        this.tf.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.tf.getActionMap().put("check", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DOMTreeCellEditor.this.tf.postActionEvent();
                DOMTreeCellEditor.this.stopCellEditing();
            }
        });
        this.listeners = new ArrayList();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        Object object = ((JTree)eventObject.getSource()).getLastSelectedPathComponent();
        if (object == null) {
            return false;
        }
        Node node = ((DOMmodel.DOMNodeAdapter)object).getNode();
        return node.getNodeType() == 3 || node.getNodeType() == 1;
    }

    @Override
    public Object getCellEditorValue() {
        return this.tf.getText();
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
        this.resetEditor();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.add(cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.remove(cellEditorListener);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.initEditVal = ((DOMmodel.DOMNodeAdapter)object).getNode();
        this.tf.setText(((DOMmodel.DOMNodeAdapter)object).toEditString());
        return this.tf;
    }

    @Override
    public boolean stopCellEditing() {
        String string = (String)this.getCellEditorValue();
        if (this.initEditVal.getNodeType() != 3 && this.initEditVal.getNodeType() == 1 && !string.matches("^\\s*[\\w\\-_]+\\s*(?:,\\s*[\\w\\-_]+\\s*=\\s*\"[^\"]+\"\\s*)*\\s*$")) {
            int n = InterfaceMain.getInstance().showConfirmDialog("Node names and attributes must be specified in the format:\nNodeName[, AttrName=\"AttrValue\"]..", "Invalid Format", 0, 0, 0);
            if (n == 1) {
                this.cancelCellEditing();
                return true;
            }
            return false;
        }
        this.fireEditingStopped();
        this.resetEditor();
        return true;
    }

    private void resetEditor() {
        this.tf.setText("");
        this.initEditVal = null;
    }

    private void fireEditingCanceled() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator<CellEditorListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().editingCanceled(changeEvent);
        }
    }

    private void fireEditingStopped() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator<CellEditorListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().editingStopped(changeEvent);
        }
    }
}

