/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.DMsource;

import ModelInterface.BatchRunner;
import ModelInterface.InterfaceMain;
import ModelInterface.MenuAdder;
import ModelInterface.ModelGUI2.XMLFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DMViewer
implements ActionListener,
MenuAdder,
BatchRunner {
    public static String controlStr = "DMViewer";
    private JFrame parentFrame;
    private File currFile;
    private JPanel pane;
    private JTextArea textArea;
    private JTextField dataSetField;
    private XMLFilter xmlFilter = new XMLFilter();

    public DMViewer() {
        this.parentFrame = InterfaceMain.getInstance().getFrame();
        this.parentFrame.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Control")) {
                    if (propertyChangeEvent.getOldValue().equals(controlStr) || propertyChangeEvent.getOldValue().equals(controlStr + "Same")) {
                        DMViewer.this.parentFrame.getContentPane().removeAll();
                    }
                    if (propertyChangeEvent.getNewValue().equals(controlStr)) {
                        DMViewer.this.setupPane();
                    }
                }
            }
        });
    }

    @Override
    public void addMenuItems(InterfaceMain.MenuManager menuManager) {
        JMenuItem jMenuItem = new JMenuItem("DM Command file");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        jMenuItem.addActionListener(this);
        menuManager.getSubMenuManager(0).getSubMenuManager(5).addMenuItem(jMenuItem, 10);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        String string = actionEvent.getActionCommand();
        if (string.equals("DM Command file")) {
            bl = this.openDMFile();
            if (bl) {
                this.displayFile();
                this.parentFrame.setTitle("[" + this.currFile + "] - ModelInterface");
            }
        } else if (string.equals("Run")) {
            int n = JOptionPane.showConfirmDialog(this.parentFrame, "Are you sure you want to run the DataManipulator now?", "Run DataManipulator?", 0, -1);
            if (n == 1) {
                return;
            }
            this.writeFile();
            this.runDataManipulator();
        } else if (string.equals("FindDataSet")) {
            this.findDataSet();
        }
    }

    private boolean openDMFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Open XML Command File");
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(new File(InterfaceMain.getInstance().getProperties().getProperty("lastDirectory", ".")));
        jFileChooser.setFileFilter(this.xmlFilter);
        int n = jFileChooser.showOpenDialog(this.parentFrame);
        if (n == 1) {
            return false;
        }
        if (n != 0) {
            return false;
        }
        InterfaceMain.getInstance().fireControlChange(controlStr);
        this.currFile = jFileChooser.getSelectedFile();
        InterfaceMain.getInstance().getProperties().setProperty("lastDirectory", jFileChooser.getCurrentDirectory().toString());
        return true;
    }

    private void findDataSet() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Open XML Data File");
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(new File(InterfaceMain.getInstance().getProperties().getProperty("lastDirectory", ".")));
        jFileChooser.setFileFilter(this.xmlFilter);
        int n = jFileChooser.showOpenDialog(this.parentFrame);
        if (n == 1) {
            return;
        }
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        this.dataSetField.setText(file.getPath());
        InterfaceMain.getInstance().getProperties().setProperty("lastDirectory", jFileChooser.getCurrentDirectory().toString());
    }

    private void displayFile() {
        if (this.currFile == null) {
            return;
        }
        try {
            int n = 0;
            String string = "";
            FileReader fileReader = new FileReader(this.currFile);
            while ((n = fileReader.read()) != -1) {
                char c = (char)n;
                string = string + c;
            }
            fileReader.close();
            this.textArea.setText(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("The file " + this.currFile.getName() + " does not exist, how I dont know.");
        }
        catch (IOException iOException) {
            System.out.println("Encountered an error while attempting to read from " + this.currFile.getName() + ".");
        }
    }

    private void setupPane() {
        this.pane = new JPanel();
        SpringLayout springLayout = new SpringLayout();
        this.pane.setLayout(springLayout);
        JLabel jLabel = new JLabel("Data Set:");
        springLayout.putConstraint("West", (Component)jLabel, 10, "West", (Component)this.pane);
        springLayout.putConstraint("North", (Component)jLabel, 12, "North", (Component)this.pane);
        this.dataSetField = new JTextField(40);
        this.dataSetField.setMaximumSize(this.dataSetField.getPreferredSize());
        springLayout.putConstraint("West", (Component)this.dataSetField, 5, "East", (Component)jLabel);
        springLayout.putConstraint("North", (Component)this.dataSetField, 10, "North", (Component)this.pane);
        JButton jButton = new JButton("Find Data Set");
        jButton.setActionCommand("FindDataSet");
        jButton.addActionListener(this);
        springLayout.putConstraint("West", (Component)jButton, 10, "East", (Component)this.dataSetField);
        springLayout.putConstraint("North", (Component)jButton, 8, "North", (Component)this.pane);
        JLabel jLabel2 = new JLabel("Command File:");
        springLayout.putConstraint("North", (Component)jLabel2, 10, "South", (Component)jButton);
        springLayout.putConstraint("West", (Component)jLabel2, 10, "West", (Component)this.pane);
        JButton jButton2 = new JButton("Run");
        jButton2.setActionCommand("Run");
        jButton2.addActionListener(this);
        springLayout.putConstraint("North", (Component)jButton2, 5, "South", (Component)jButton);
        springLayout.putConstraint("East", (Component)jButton2, -10, "East", (Component)this.pane);
        this.textArea = new JTextArea(25, 80);
        JScrollPane jScrollPane = new JScrollPane(this.textArea, 22, 30);
        this.textArea.setEditable(true);
        this.textArea.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        springLayout.putConstraint("West", (Component)jScrollPane, 10, "West", (Component)this.pane);
        springLayout.putConstraint("North", (Component)jScrollPane, 5, "South", (Component)jButton2);
        springLayout.putConstraint("East", (Component)this.pane, 10, "East", (Component)jScrollPane);
        springLayout.putConstraint("South", (Component)this.pane, 10, "South", (Component)jScrollPane);
        this.pane.add(jLabel);
        this.pane.add(this.dataSetField);
        this.pane.add(jButton);
        this.pane.add(jLabel2);
        this.pane.add(jButton2);
        this.pane.add(jScrollPane);
        this.parentFrame.setContentPane(this.pane);
        this.parentFrame.pack();
    }

    private void writeFile() {
        if (this.currFile == null) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(this.currFile);
            fileWriter.write(this.textArea.getText());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Encountered an error while attempting to write to " + this.currFile.getName() + ".");
        }
    }

    private void runDataManipulator() {
        try {
            String string = this.dataSetField.getText();
            Logger logger = Logger.getLogger("DataManipulation");
            logger.setLevel(Level.parse("WARNING"));
            logger.setUseParentHandlers(false);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.WARNING);
            logger.addHandler(consoleHandler);
            try {
                FileHandler fileHandler = new FileHandler("DMLog.log");
                fileHandler.setLevel(Level.ALL);
                fileHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(fileHandler);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            String string2 = "regionDef.xml";
            String string3 = this.currFile.getName();
            logger.log(Level.INFO, "creating ManipulationDriver to run datamanipulation");
            throw new UnsupportedOperationException("This feature is not available in this version.");
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            JOptionPane.showMessageDialog(this.parentFrame, "Data Manipulator requires a dataset to run.", "DataManipulator Error", -1);
            return;
        }
    }

    @Override
    public void runBatch(Node node) {
        Logger logger = Logger.getLogger("DataManipulation");
        logger.setLevel(Level.parse("WARNING"));
        logger.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.WARNING);
        logger.addHandler(consoleHandler);
        try {
            FileHandler fileHandler = new FileHandler("DMLog.log");
            fileHandler.setLevel(Level.ALL);
            fileHandler.setFormatter(new SimpleFormatter());
            logger.addHandler(fileHandler);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        NodeList nodeList = node.getChildNodes();
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string4 = ((Element)node2).getNodeName();
            if (string4.equals("data")) {
                string = ((Element)node2).getAttribute("file");
                continue;
            }
            if (string4.equals("region")) {
                string2 = ((Element)node2).getAttribute("file");
                continue;
            }
            if (string4.equals("command")) {
                string3 = ((Element)node2).getAttribute("file");
                continue;
            }
            if (string4.equals("log")) {
                logger.setLevel(Level.parse(((Element)node2).getAttribute("level")));
                continue;
            }
            logger.warning("Unreckognized command: " + string4);
        }
        if (string != null && string2 != null && string3 != null) {
            throw new UnsupportedOperationException("This feature is not available in this version.");
        }
        logger.severe("Not enough information to run data manipulator");
    }
}

