/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.utils;

import ModelInterface.ConfigurationEditor.configurationeditor.ConfigurationEditor;
import ModelInterface.ConfigurationEditor.utils.Messages;
import ModelInterface.InterfaceMain;
import ModelInterface.common.FileChooser;
import ModelInterface.common.FileChooserFactory;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public final class FileUtils {
    static Properties sProperties = new Properties();
    static boolean sPropertiesInitialized = false;

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDirty(Document document) {
        Document document2 = document;
        synchronized (document2) {
            return document.getDocumentElement().getAttribute("needs-save").length() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getDocumentFile(Document document) {
        Document document2 = document;
        synchronized (document2) {
            String string = document.getDocumentURI();
            if (string == null) {
                return null;
            }
            try {
                URI uRI = new URI(string);
                return new File(uRI.getPath());
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.global.log(Level.SEVERE, "Failed to convert the document path into a URI.");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDocumentFile(Document document, File file) {
        Document document2 = document;
        synchronized (document2) {
            if (file == null) {
                document.setDocumentURI(null);
            } else {
                document.setDocumentURI(file.toURI().toString());
            }
        }
    }

    public static File[] getSelectedFiles(JFileChooser jFileChooser) {
        File[] fileArray = jFileChooser.getSelectedFiles();
        if (fileArray.length == 0) {
            fileArray = new File[]{jFileChooser.getSelectedFile()};
        }
        return fileArray;
    }

    public static String getExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        String string2 = null;
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getInitializedProperties(Component component) {
        Properties properties = sProperties;
        synchronized (properties) {
            if (!sPropertiesInitialized) {
                sProperties = InterfaceMain.getInstance().getProperties();
                sPropertiesInitialized = true;
            }
            return sProperties;
        }
    }

    public static boolean askForSave(ConfigurationEditor configurationEditor) {
        if (configurationEditor.getDocument() != null && FileUtils.isDirty(configurationEditor.getDocument())) {
            String string = Messages.getString("FileUtils.25");
            int n = JOptionPane.showConfirmDialog(configurationEditor, string, Messages.getString("FileUtils.26"), 1);
            if (n == 0) {
                configurationEditor.dispatchSave();
            } else if (n == 2) {
                return false;
            }
        }
        return true;
    }

    public static File selectFile(Component component, FileFilter fileFilter, String string, boolean bl) {
        Properties properties = FileUtils.getInitializedProperties(component);
        String string2 = string == null || string.equals("") ? properties.getProperty("lastDirectory") : string;
        FileChooser fileChooser = FileChooserFactory.getFileChooser();
        File[] fileArray = fileChooser.doFilePrompt(component, null, bl ? 1 : 0, new File(string2), fileFilter);
        if (fileArray != null) {
            properties.setProperty("lastDirectory", fileArray[0].getAbsolutePath());
            return fileArray[0];
        }
        return null;
    }

    public static Document loadDocument(File file, String string) {
        Object object;
        if (!file.exists()) {
            String string2 = Messages.getString("BatchFileEditor.3");
            String string3 = Messages.getString("BatchFileEditor.4");
            Logger.global.log(Level.SEVERE, string2);
            InterfaceMain.getInstance().showMessageDialog(string2, string3, 0);
            return null;
        }
        URI uRI = file.toURI();
        Document document = null;
        try {
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(uRI.getPath());
        }
        catch (Exception exception) {
            Logger.global.log(Level.SEVERE, exception.getStackTrace().toString());
            String string4 = Messages.getString("LoadAction.1") + exception.getMessage() + ".";
            String string5 = Messages.getString("LoadAction.3");
            InterfaceMain.getInstance().showMessageDialog(string4, string5, 0);
            return null;
        }
        if (string != null && !document.getDocumentElement().getNodeName().equals(string)) {
            object = Messages.getString("LoadAction.5");
            String string6 = Messages.getString("LoadAction.6");
            Logger.global.log(Level.SEVERE, string6);
            InterfaceMain.getInstance().showMessageDialog(string6, (String)object, 0);
            return null;
        }
        return document;
    }

    public static Document createDocument(Component component, File file, String string) {
        if (file != null && file.exists()) {
            String string2 = Messages.getString("ConfigurationEditor.147");
            String string3 = Messages.getString("ConfigurationEditor.148");
            JOptionPane.showMessageDialog(component, string2, string3, 0);
            return null;
        }
        DOMImplementation dOMImplementation = null;
        try {
            dOMImplementation = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.global.log(Level.SEVERE, "Failed to create DOM implementation necessary to create the document.");
            return null;
        }
        Document document = dOMImplementation.createDocument(null, string, null);
        FileUtils.setDocumentFile(document, file);
        return document;
    }
}

