/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.guihelpers;

import ModelInterface.ConfigurationEditor.guihelpers.NewNodeDialog;
import ModelInterface.ConfigurationEditor.utils.DOMUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PopupMenuCreatorMouseAdapter
extends MouseAdapter {
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        JTree jTree = (JTree)mouseEvent.getSource();
        TreePath treePath = jTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        jTree.setSelectionPath(treePath);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.createPopupMenu(mouseEvent);
        }
    }

    private void createPopupMenu(MouseEvent mouseEvent) {
        JTree jTree = (JTree)mouseEvent.getSource();
        Node node = (Node)jTree.getSelectionPath().getLastPathComponent();
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (node == null || node.equals(node.getOwnerDocument().getDocumentElement())) {
            JMenuItem jMenuItem = new JMenuItem("No Options Currently Available");
            jMenuItem.setEnabled(false);
            jPopupMenu.add(jMenuItem);
        } else if (jTree.getModel().isLeaf(node)) {
            JMenuItem jMenuItem = new JMenuItem("Edit Value...");
            jMenuItem.setMnemonic(86);
            jMenuItem.addActionListener(new EditValueClicked(node, jTree));
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Edit Name...");
            jMenuItem.setMnemonic(78);
            jMenuItem.addActionListener(new EditNameClicked(node, jTree));
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Delete Item");
            jMenuItem.setMnemonic(68);
            jMenuItem.addActionListener(new DeleteItemClicked(node, jTree));
            jPopupMenu.add(jMenuItem);
        } else {
            JMenuItem jMenuItem = new JMenuItem("Add New Value...");
            jMenuItem.setMnemonic(86);
            jMenuItem.addActionListener(new AddItemClicked(node, jTree));
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
    }

    private final class DeleteItemClicked
    implements ActionListener {
        private final transient JTree mTree;
        private final transient Node mNode;

        public DeleteItemClicked(Node node, JTree jTree) {
            this.mNode = node;
            this.mTree = jTree;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Node node = (Node)this.mTree.getSelectionPath().getParentPath().getLastPathComponent();
            assert (node != null);
            int n = this.mTree.getModel().getIndexOfChild(node, this.mNode);
            node.removeChild(node.getChildNodes().item(n));
            this.mTree.getModel().valueForPathChanged(this.mTree.getSelectionPath().getParentPath(), node);
        }
    }

    private final class EditValueClicked
    implements ActionListener {
        private final transient JTree mTree;
        private final transient Node mNode;

        public EditValueClicked(Node node, JTree jTree) {
            this.mNode = node;
            this.mTree = jTree;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.mNode.getTextContent();
            String string2 = (String)JOptionPane.showInputDialog((Component)actionEvent.getSource(), "Please enter a new value: ", "Change a Value", 3, null, null, string);
            if (string2 != null) {
                this.mNode.setTextContent(string2);
                this.mTree.getModel().valueForPathChanged(this.mTree.getSelectionPath(), this.mNode);
            }
        }
    }

    private final class EditNameClicked
    implements ActionListener {
        private final transient Node mNode;
        private final transient JTree mTree;

        public EditNameClicked(Node node, JTree jTree) {
            this.mNode = node;
            this.mTree = jTree;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = DOMUtils.getNameAttrValue(this.mNode);
            String string2 = (String)JOptionPane.showInputDialog((Component)actionEvent.getSource(), "Please enter a new name: ", "Change a Name", 3, null, null, string);
            if (string2 != null) {
                DOMUtils.setNameAttrValue(this.mNode, string2);
                this.mTree.getModel().valueForPathChanged(this.mTree.getSelectionPath(), this.mNode);
            }
        }
    }

    private final class AddItemClicked
    implements ActionListener {
        private final transient JTree mTree;
        private final transient Node mNode;

        public AddItemClicked(Node node, JTree jTree) {
            this.mNode = node;
            this.mTree = jTree;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NewNodeDialog newNodeDialog = new NewNodeDialog(null, this.mNode.getOwnerDocument());
            newNodeDialog.setVisible(true);
            Node node = (Node)newNodeDialog.getSelectedValue();
            if (node != null) {
                boolean bl = false;
                NodeList nodeList = this.mNode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    if (!DOMUtils.getNameAttrValue(node).equals(DOMUtils.getNameAttrValue(nodeList.item(i)))) continue;
                    bl = true;
                    int n = JOptionPane.showConfirmDialog((Component)actionEvent.getSource(), "A value with this name already exists, would you like to replace it?", "Replace existing value?", 0);
                    if (n == 0) {
                        this.mNode.replaceChild(node, nodeList.item(i));
                        continue;
                    }
                    return;
                }
                if (!bl) {
                    this.mNode.appendChild(node);
                }
                this.mTree.getModel().valueForPathChanged(this.mTree.getSelectionPath(), node);
            }
        }
    }
}

