/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.guicomponents;

import ModelInterface.ConfigurationEditor.guihelpers.TreeNodeWrapper;
import ModelInterface.ConfigurationEditor.utils.DOMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Node;

public class DOMTreeModel
implements TreeModel {
    private final transient Node mRoot;
    private final transient ArrayList<TreeModelListener> mListeners;
    private final transient Map<Node, Object> mWrappers;
    private final transient String mLeafName;

    public DOMTreeModel(Node node, String string) {
        this.mRoot = node;
        this.mLeafName = string;
        this.mWrappers = new HashMap<Node, Object>();
        this.mListeners = new ArrayList();
    }

    @Override
    public Object getRoot() {
        return this.getOrCreateWrapper(this.mRoot);
    }

    @Override
    public Object getChild(Object object, int n) {
        int n2 = DOMUtils.getDOMIndexForListIndex((Node)object, n);
        if (n2 == -1) {
            return null;
        }
        return this.getOrCreateWrapper(((Node)object).getChildNodes().item(n2));
    }

    @Override
    public int getChildCount(Object object) {
        return DOMUtils.getNumberOfElementChildren((Node)object);
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((Node)object).getNodeName().equals(this.mLeafName);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        Node node;
        Node node2 = (Node)treePath.getLastPathComponent();
        if (node2.isSameNode(node = (Node)this.getOrCreateWrapper((Node)object))) {
            int n = DOMUtils.getListIndexOfObject(node.getParentNode(), node);
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, treePath, new int[]{n}, new Object[]{this.getOrCreateWrapper(node)}));
        } else {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)node2, treePath));
        }
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return DOMUtils.getDOMIndexOfObject((Node)object, object2);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.mListeners.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.mListeners.remove(treeModelListener);
    }

    private Object getOrCreateWrapper(Node node) {
        Object object = this.mWrappers.get(node);
        if (object == null) {
            object = TreeNodeWrapper.createProxy(node);
            this.mWrappers.put(node, object);
        }
        return object;
    }

    private void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).treeNodesChanged(treeModelEvent);
        }
    }

    private void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).treeStructureChanged(treeModelEvent);
        }
    }
}

