/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.guicomponents;

import ModelInterface.ConfigurationEditor.guicomponents.DOMListModel;
import ModelInterface.ConfigurationEditor.guihelpers.ButtonSetEnabler;
import ModelInterface.ConfigurationEditor.guihelpers.XMLFileFilter;
import ModelInterface.ConfigurationEditor.utils.FileUtils;
import ModelInterface.ConfigurationEditor.utils.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.w3c.dom.Document;

public class DOMListPanel
extends JPanel {
    private static final long serialVersionUID = 216029089953286071L;
    private final transient String mPanelLabel;
    private final transient String mElementName;
    private final transient String mContainerName;
    private final transient boolean mLeafChildren;
    private transient JList mList = null;

    public DOMListPanel(String string, String string2, String string3, boolean bl) {
        super(new GridBagLayout());
        assert (string != null);
        this.mElementName = string;
        this.mContainerName = string2;
        this.mPanelLabel = string3;
        this.mLeafChildren = bl;
        this.editorInitialize();
    }

    public void setDocument(Document document) {
        ((DOMListModel)this.getList(null).getModel()).setDocument(document);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            component.setEnabled(bl);
        }
    }

    private final void editorInitialize() {
        this.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        JLabel jLabel = new JLabel(this.mPanelLabel);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        ButtonSetEnabler buttonSetEnabler = new ButtonSetEnabler();
        JList jList = this.getList(buttonSetEnabler);
        this.add((Component)this.createListScrollPane(jList), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.createUpButton(buttonSetEnabler), gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.createDownButton(buttonSetEnabler), gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.createAddButton(buttonSetEnabler), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.createDeleteButton(buttonSetEnabler), gridBagConstraints);
    }

    public final JList getList(ButtonSetEnabler buttonSetEnabler) {
        if (this.mList == null) {
            this.mList = new JList();
            this.mList.setSelectionMode(0);
            this.mList.setToolTipText(Messages.getString("DOMListPanel.0"));
            this.mList.setModel(this.createListModel(this.mList, buttonSetEnabler));
            this.mList.addListSelectionListener(buttonSetEnabler);
        }
        return this.mList;
    }

    private final ListModel createListModel(JList jList, ButtonSetEnabler buttonSetEnabler) {
        DOMListModel dOMListModel = new DOMListModel(jList, this.mContainerName, this.mElementName, this.mLeafChildren);
        dOMListModel.addListDataListener(buttonSetEnabler);
        return dOMListModel;
    }

    private final JScrollPane createListScrollPane(JList jList) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(100, 200));
        jScrollPane.setViewportView(jList);
        return jScrollPane;
    }

    private final JButton createAddButton(ButtonSetEnabler buttonSetEnabler) {
        JButton jButton = new JButton(Messages.getString("DOMListPanel.1"));
        jButton.setToolTipText(Messages.getString("DOMListPanel.2"));
        jButton.setPreferredSize(new Dimension(80, 25));
        buttonSetEnabler.addControlledButton(jButton, ButtonSetEnabler.ButtonType.ADD);
        if (this.mLeafChildren) {
            jButton.addActionListener(new AddFileButtonActionListener());
        } else {
            jButton.addActionListener(new AddItemButtonActionListener());
        }
        return jButton;
    }

    private final JButton createDeleteButton(ButtonSetEnabler buttonSetEnabler) {
        JButton jButton = new JButton(Messages.getString("DOMListPanel.4"));
        jButton.setToolTipText(Messages.getString("DOMListPanel.3"));
        jButton.setPreferredSize(new Dimension(80, 25));
        buttonSetEnabler.addControlledButton(jButton, ButtonSetEnabler.ButtonType.DELETE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DOMListModel dOMListModel = (DOMListModel)DOMListPanel.this.mList.getModel();
                dOMListModel.removeElement(DOMListPanel.this.mList.getSelectedValue());
                DOMListPanel.this.mList.setSelectedIndex(dOMListModel.getSize() - 1);
            }
        });
        return jButton;
    }

    private final JButton createUpButton(ButtonSetEnabler buttonSetEnabler) {
        JButton jButton = new JButton(Messages.getString("DOMListPanel.5"));
        jButton.setToolTipText(Messages.getString("DOMListPanel.6"));
        jButton.setPreferredSize(new Dimension(70, 25));
        buttonSetEnabler.addControlledButton(jButton, ButtonSetEnabler.ButtonType.UP);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DOMListModel dOMListModel = (DOMListModel)DOMListPanel.this.mList.getModel();
                int n = dOMListModel.moveElementBack(DOMListPanel.this.mList.getSelectedValue());
                DOMListPanel.this.mList.setSelectedIndex(n);
            }
        });
        return jButton;
    }

    private final JButton createDownButton(ButtonSetEnabler buttonSetEnabler) {
        JButton jButton = new JButton(Messages.getString("DOMListPanel.7"));
        jButton.setToolTipText(Messages.getString("DOMListPanel.8"));
        jButton.setPreferredSize(new Dimension(70, 25));
        buttonSetEnabler.addControlledButton(jButton, ButtonSetEnabler.ButtonType.DOWN);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DOMListModel dOMListModel = (DOMListModel)DOMListPanel.this.mList.getModel();
                int n = dOMListModel.moveElementForward(DOMListPanel.this.mList.getSelectedValue());
                DOMListPanel.this.mList.setSelectedIndex(n);
            }
        });
        return jButton;
    }

    private final class AddFileButtonActionListener
    implements ActionListener {
        private AddFileButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new XMLFileFilter());
            jFileChooser.setMultiSelectionEnabled(true);
            int n = jFileChooser.showOpenDialog(DOMListPanel.this.getTopLevelAncestor());
            if (n == 0) {
                File[] fileArray = FileUtils.getSelectedFiles(jFileChooser);
                DOMListModel dOMListModel = (DOMListModel)DOMListPanel.this.mList.getModel();
                for (int i = 0; i < fileArray.length; ++i) {
                    try {
                        String string = fileArray[i].getCanonicalPath();
                        if (dOMListModel.contains(string)) {
                            String string2 = Messages.getString("DOMListPanel.13");
                            String string3 = Messages.getString("DOMListPanel.14");
                            JOptionPane.showMessageDialog(DOMListPanel.this.getTopLevelAncestor(), string3, string2, 0);
                            continue;
                        }
                        dOMListModel.addElement(string);
                        continue;
                    }
                    catch (IOException iOException) {
                        Logger.global.throwing("actionPerformed", "AddFileButtonActionListener", iOException);
                    }
                }
                DOMListPanel.this.mList.setSelectedIndex(dOMListModel.getSize() - 1);
            }
        }
    }

    private final class AddItemButtonActionListener
    implements ActionListener {
        private AddItemButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = Messages.getString("DOMListPanel.9");
            String string2 = JOptionPane.showInputDialog(DOMListPanel.this.getTopLevelAncestor(), string, Messages.getString("DOMListPanel.10"), -1);
            DOMListModel dOMListModel = (DOMListModel)DOMListPanel.this.mList.getModel();
            if (dOMListModel.contains(string2)) {
                String string3 = Messages.getString("DOMListPanel.11");
                String string4 = Messages.getString("DOMListPanel.12");
                JOptionPane.showMessageDialog(DOMListPanel.this.getTopLevelAncestor(), string4, string3, 0);
            } else {
                dOMListModel.addElement(string2);
            }
            DOMListPanel.this.mList.setSelectedIndex(dOMListModel.getSize() - 1);
        }
    }
}

