/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.guicomponents;

import ModelInterface.ConfigurationEditor.utils.DOMUtils;
import ModelInterface.ConfigurationEditor.utils.Messages;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DOMButtonModel
extends DefaultButtonModel
implements ButtonModel,
ItemListener,
PropertyChangeListener {
    private static final long serialVersionUID = -4448518797574448977L;
    private final transient String mParentXPath;
    private final transient String mElementName;
    private final transient String mItemName;
    private transient String mParentName = null;
    private final transient boolean mParentHasName;
    private transient Document mDocument = null;

    public DOMButtonModel(Document document, String string, String string2, String string3, boolean bl) {
        this.mDocument = document;
        this.mParentXPath = string;
        this.mElementName = string2;
        this.mItemName = string3;
        this.mParentHasName = bl;
    }

    @Override
    public boolean isSelected() {
        if (!this.isValidState()) {
            return false;
        }
        Node node = DOMUtils.getResultNodeFromQuery(this.mDocument, this.getXPath());
        if (node == null) {
            Logger.global.log(Level.INFO, Messages.getString("DOMButtonModel.1") + this.mItemName);
            return false;
        }
        return DOMUtils.isTextContentTrue(node);
    }

    @Override
    public void setArmed(boolean bl) {
        if (bl) {
            String string;
            if (!this.isValidState()) {
                return;
            }
            Node node = DOMUtils.getResultNodeFromQuery(this.mDocument, this.getXPath());
            boolean bl2 = false;
            if (node == null) {
                node = DOMUtils.addNodesForXPath(this.mDocument, this.getXPath());
            } else {
                bl2 = DOMUtils.isTextContentTrue(node);
            }
            String string2 = string = bl2 ? "0" : "1";
            if (node == null) {
                Logger.global.log(Level.SEVERE, Messages.getString("DOMButtonModel.4"));
            } else {
                node.setTextContent(string);
            }
        }
        super.setArmed(bl);
    }

    private boolean isValidState() {
        if (this.mDocument == null) {
            return false;
        }
        return !this.mParentHasName || this.mParentName != null && !this.mParentName.equals("");
    }

    private String getXPath() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mParentXPath != null) {
            stringBuilder.append(this.mParentXPath);
        }
        if (this.mParentHasName && this.mParentName != null && !this.mParentName.equals("")) {
            stringBuilder.append("[@name='").append(this.mParentName).append("']");
        }
        stringBuilder.append("/").append(this.mElementName);
        if (!this.mParentHasName && this.mItemName != null && !this.mItemName.equals("")) {
            stringBuilder.append("[@name='").append(this.mItemName).append("']");
        }
        return stringBuilder.toString();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.mParentName = itemEvent.getItem().toString();
            this.setEnabled(this.mParentName != null && !this.mParentName.equals(""));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("document-replaced")) {
            this.mDocument = (Document)propertyChangeEvent.getNewValue();
            this.setEnabled(this.mDocument != null);
        } else {
            Logger.global.log(Level.WARNING, "Property change listener added for the wrong property change.");
        }
    }
}

