/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.basex.build.csv.CsvParserOptions;
import org.basex.build.html.HtmlOptions;
import org.basex.build.html.HtmlParser;
import org.basex.build.json.JsonParserOptions;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.BufferInput;
import org.basex.io.in.NewlineInput;
import org.basex.io.in.TextInput;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.io.parse.json.JsonConverter;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.list.ANodeList;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.http.HttpText;
import org.basex.util.http.MediaType;
import org.basex.util.list.ByteList;

public final class HttpPayload {
    private final ItemList payloads;
    private final InputStream input;
    private final InputInfo info;
    private final MainOptions options;

    public HttpPayload(InputStream input, boolean body, InputInfo info, MainOptions options) {
        this.input = input;
        this.info = info;
        this.options = options;
        this.payloads = body ? new ItemList() : null;
    }

    FElem parse(MediaType type, boolean error, String encoding) throws IOException, QueryException {
        FElem body;
        if (type.isMultipart()) {
            byte[] boundary = this.boundary(type);
            body = new FElem(HttpText.Q_MULTIPART).add("boundary", boundary);
            ANodeList parts = new ANodeList();
            this.extractParts(Token.concat(HttpText.DASHES, boundary), parts);
            for (ANode node : parts) {
                body.add(node);
            }
        } else {
            body = new FElem(HttpText.Q_BODY);
            if (this.payloads != null) {
                InputStream in = "gzip".equals(encoding) ? new GZIPInputStream(this.input) : this.input;
                byte[] pl = (type.isXML() || type.isText() ? new NewlineInput(in).encoding(type.parameters().get("charset")) : BufferInput.get(in)).content();
                Value value = Empty.VALUE;
                try {
                    value = this.parse(pl, type);
                }
                catch (QueryException ex) {
                    if (!error) {
                        throw ex;
                    }
                    Util.debug(ex);
                }
                this.payloads.add(value);
            }
        }
        return body.add(SerializerOptions.MEDIA_TYPE.name(), type.type());
    }

    Value payloads() {
        return this.payloads.value();
    }

    private Value parse(byte[] payload, MediaType type) throws QueryException {
        try {
            return payload.length == 0 ? Empty.VALUE : HttpPayload.value(new IOContent(payload), this.options, type);
        }
        catch (IOException ex) {
            throw QueryError.HC_PARSE_X.get(this.info, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractParts(byte[] sep, ANodeList parts) throws IOException, QueryException {
        try {
            byte[] l;
            do {
                if ((l = this.readLine()) != null) continue;
                throw QueryError.HC_REQ_X.get(this.info, "No body specified for http:part");
            } while (!Token.eq(sep, l));
            while (this.extractPart(sep, Token.concat(sep, HttpText.DASHES), parts)) {
            }
        }
        finally {
            this.input.close();
        }
    }

    private boolean extractPart(byte[] sep, byte[] end, ANodeList parts) throws IOException, QueryException {
        byte[] line = this.readLine();
        if (line == null || Token.eq(line, end)) {
            return false;
        }
        MediaType type = MediaType.TEXT_PLAIN;
        boolean base64 = false;
        byte[] l = line;
        while (l != null && l.length > 0) {
            int pos = Token.indexOf(l, 58);
            if (pos > 0) {
                String key = Token.string(Token.substring(l, 0, pos));
                String val = Token.string(Token.trim(Token.substring(l, pos + 1)));
                if (key.equalsIgnoreCase("Content-Type")) {
                    type = new MediaType(val);
                } else if (key.equalsIgnoreCase("Content-Transfer-Encoding")) {
                    base64 = val.equals("base64");
                }
                if (!val.isEmpty() && parts != null) {
                    parts.add(new FElem(HttpText.Q_HEADER).add("name", key).add("value", val));
                }
            }
            l = this.readLine();
        }
        if (parts != null) {
            parts.add(new FElem(HttpText.Q_BODY).add(SerializerOptions.MEDIA_TYPE.name(), type.toString()));
        }
        ByteList bl = new ByteList();
        while ((line = this.readLine()) != null && !Token.eq(line, sep)) {
            if (Token.eq(line, end)) {
                while (this.readLine() != null) {
                }
                break;
            }
            if (!bl.isEmpty()) {
                bl.add(HttpText.CRLF);
            }
            bl.add(line);
        }
        if (this.payloads != null) {
            String encoding = type.parameters().get("charset");
            byte[] part = new TextInput(bl.finish()).encoding(encoding).content();
            this.payloads.add(this.parse(base64 ? Base64.decode(part) : part, type));
        }
        return true;
    }

    private byte[] readLine() throws IOException {
        int b;
        ByteList bl = new ByteList();
        while ((b = this.input.read()) != -1) {
            while (b == 13) {
                b = this.input.read();
                if (b == 10) {
                    return bl.finish();
                }
                bl.add(13);
                if (b != -1) continue;
                return bl.finish();
            }
            bl.add(b);
        }
        return bl.isEmpty() ? null : bl.finish();
    }

    private byte[] boundary(MediaType type) throws QueryException {
        String b = type.parameters().get("boundary");
        if (b == null) {
            throw QueryError.HC_REQ_X.get(this.info, "No separation boundary specified");
        }
        return Token.token(b);
    }

    public HashMap<String, Value> multiForm(MediaType type) throws IOException, QueryException {
        byte[] line;
        byte[] bound = Token.concat(HttpText.DASHES, this.boundary(type));
        byte[] last = Token.concat(bound, HttpText.DASHES);
        HashMap<String, Value> data = new HashMap<String, Value>();
        ByteList cont = new ByteList();
        int lines = -1;
        String name = "";
        String filename = null;
        while ((line = this.readLine()) != null) {
            if (lines >= 0) {
                if (Token.startsWith(line, bound)) {
                    Value value = data.get(name);
                    if (filename != null) {
                        XQMap map = value instanceof XQMap ? (XQMap)value : XQMap.EMPTY;
                        Str file = Str.get(filename);
                        B64 contents = B64.get(cont.next());
                        Value files = ((ItemList)((Object)new ItemList().add(map.get(file, this.info)).add(contents))).value();
                        value = map.put(file, files, this.info);
                    } else {
                        Str v = Str.get(cont.next());
                        Value value2 = value = value == null ? v : ((ItemList)((Object)new ItemList().add(value).add(v))).value();
                    }
                    if (!name.isEmpty()) {
                        data.put(name, value);
                    }
                    lines = -1;
                    if (!Token.eq(line, last)) continue;
                    break;
                }
                if (lines++ > 0) {
                    cont.add(HttpText.CRLF);
                }
                cont.add(line);
                continue;
            }
            if (Token.startsWith(Token.lc(line), HttpText.CONTENT_DISPOSITION)) {
                name = Token.contains(line, Token.token("name=")) ? Token.string(line).replaceAll("^.*?name=\"|\".*", "").replaceAll("\\[]", "") : null;
                filename = Token.contains(line, Token.token("filename=")) ? Token.string(line).replaceAll("^.*filename=\"|\"$", "") : null;
                continue;
            }
            if (line.length != 0) continue;
            lines = 0;
        }
        return data;
    }

    public static Value value(IO input, MainOptions options, MediaType type) throws IOException, QueryException {
        if (type.isJSON()) {
            JsonParserOptions opts = new JsonParserOptions(options.get(MainOptions.JSONPARSER));
            opts.assign(type);
            return JsonConverter.get(opts).convert(input);
        }
        if (type.isCSV()) {
            CsvParserOptions opts = new CsvParserOptions(options.get(MainOptions.CSVPARSER));
            opts.assign(type);
            return CsvConverter.get(opts).convert(input);
        }
        if (type.is(MediaType.TEXT_HTML)) {
            HtmlOptions opts = new HtmlOptions(options.get(MainOptions.HTMLPARSER));
            opts.assign(type);
            return new DBNode(new HtmlParser(input, options, opts));
        }
        if (type.is(MediaType.APPLICATION_X_WWW_FORM_URLENCODED)) {
            String encoding = type.parameters().get("charset");
            if (encoding == null) {
                encoding = "UTF-8";
            }
            return Str.get(URLDecoder.decode(Token.string(input.read()), encoding));
        }
        if (type.isXML()) {
            return new DBNode(input);
        }
        if (type.isText()) {
            return Str.get(new NewlineInput(input).content());
        }
        if (type.isMultipart()) {
            try (InputStream is = input.inputStream();){
                HttpPayload hp = new HttpPayload(is, true, null, options);
                hp.extractParts(Token.concat(HttpText.DASHES, hp.boundary(type)), null);
                Value value = hp.payloads();
                return value;
            }
        }
        return B64.get(input.read());
    }
}

