/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.jar.Attributes;
import org.basex.io.IOFile;
import org.basex.util.JarManifest;
import org.basex.util.Strings;
import org.basex.util.Util;
import org.basex.util.options.Option;

public final class Prop {
    public static final String NAME = "BaseX";
    public static final String VERSION = Prop.version("9.5");
    public static final String PROJECT = "BaseX".toLowerCase(Locale.ENGLISH);
    public static final String NL = System.getProperty("line.separator");
    public static final String ENCODING = System.getProperty("file.encoding");
    private static final String OS = System.getProperty("os.name");
    public static final boolean MAC = OS.startsWith("Mac");
    public static final boolean WIN = OS.startsWith("Windows");
    public static final boolean CASE = !MAC && !WIN;
    public static final String JAVA = System.getProperty("java.specification.version");
    public static final boolean JAVA8 = JAVA.equalsIgnoreCase("1.8");
    public static final String DBPREFIX = "org.basex.";
    public static final String PATH = "org.basex.path";
    public static final URL LOCATION = Prop.location();
    public static final String TEMPDIR = Prop.dir(System.getProperty("java.io.tmpdir"));
    public static final String HOMEDIR;
    private static final Map<String, String> OPTIONS;
    public static String language;
    public static boolean langkeys;
    public static boolean langright;
    public static boolean debug;
    public static boolean gui;

    private Prop() {
    }

    private static String configDir(String dir) {
        if (dir != null) {
            String home = ".basexhome";
            IOFile file = new IOFile(dir, ".basexhome");
            if (file.exists() || new IOFile(dir, ".basex").exists()) {
                return dir;
            }
        }
        return null;
    }

    private static String applicationDir(URL location) {
        try {
            if (location != null) {
                return new IOFile(Paths.get(location.toURI()).toString()).dir();
            }
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
        return null;
    }

    private static String dir(String path) {
        return path.isEmpty() || Strings.endsWith(path, '/') || Strings.endsWith(path, '\\') ? path : path + File.separator;
    }

    private static URL location() {
        CodeSource cs;
        ProtectionDomain pd = Prop.class.getProtectionDomain();
        if (pd != null && (cs = pd.getCodeSource()) != null) {
            return cs.getLocation();
        }
        return null;
    }

    private static String version(String devVersion) {
        String version = JarManifest.get(Attributes.Name.IMPLEMENTATION_VERSION);
        if (version == null) {
            return devVersion;
        }
        if (!version.contains("-SNAPSHOT")) {
            return version;
        }
        StringBuilder result = new StringBuilder(version.replace("-SNAPSHOT", " beta"));
        String revision = JarManifest.get("Implementation-Build");
        if (revision != null) {
            result.append(' ').append((Object)revision);
        }
        return result.toString();
    }

    public static void put(Option<?> option, String value) {
        Prop.put(Prop.key(option), value);
    }

    public static void put(String name, String value) {
        OPTIONS.put(name, value);
    }

    public static void clear() {
        OPTIONS.clear();
    }

    public static String get(String name) {
        String value = System.getProperty(name);
        return value != null ? value : OPTIONS.get(name);
    }

    public static Set<Map.Entry<String, String>> entries() {
        HashMap<String, String> entries = new HashMap<String, String>(OPTIONS);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> entries.put(key.toString(), value.toString())));
        return entries.entrySet();
    }

    public static void setSystem(String name, String value) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }

    private static String key(Option<?> option) {
        return DBPREFIX + option.name().toLowerCase(Locale.ENGLISH);
    }

    static {
        OPTIONS = new ConcurrentHashMap<String, String>();
        String homedir = System.getProperty(PATH);
        if (homedir == null) {
            homedir = Prop.configDir(System.getProperty("user.dir"));
        }
        if (homedir == null) {
            homedir = Prop.configDir(Prop.applicationDir(LOCATION));
        }
        if (homedir == null) {
            String home = WIN ? null : System.getenv("HOME");
            homedir = Prop.dir(home != null ? home : System.getProperty("user.home")) + PROJECT;
        }
        HOMEDIR = Prop.dir(homedir);
        language = "English";
    }
}

