/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq.tree;

import java.util.Arrays;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.NodeLike;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.tree.PartialLeafNode;
import org.basex.util.Array;
import org.basex.util.Util;

final class LeafNode
implements Node<Item, Item> {
    final Item[] values;

    LeafNode(Item[] values) {
        this.values = values;
        assert (values.length >= 8 && values.length <= 15);
    }

    @Override
    public long size() {
        return this.values.length;
    }

    public LeafNode reverse() {
        int n = this.values.length;
        Item[] out = new Item[n];
        for (int i = 0; i < n; ++i) {
            out[i] = this.values[n - 1 - i];
        }
        return new LeafNode(out);
    }

    @Override
    public boolean insert(Node<Item, Item>[] siblings, long pos, Item val) {
        int p = (int)pos;
        int n = this.values.length;
        Item[] vals = new Item[n + 1];
        Array.copy(this.values, p, vals);
        vals[p] = val;
        Array.copy(this.values, p, n - p, vals, p + 1);
        if (n < 15) {
            siblings[1] = new LeafNode(vals);
            return false;
        }
        LeafNode left = (LeafNode)siblings[0];
        if (left != null && left.values.length < 15) {
            Item[] lvals = left.values;
            int l = lvals.length;
            int diff = 15 - l;
            int move = (diff + 1) / 2;
            Item[] newLeft = new Item[l + move];
            Item[] newRight = new Item[n + 1 - move];
            Array.copy(lvals, l, newLeft);
            Array.copyFromStart(vals, move, newLeft, l);
            Array.copyToStart(vals, move, newRight.length, newRight);
            siblings[0] = new LeafNode(newLeft);
            siblings[1] = new LeafNode(newRight);
            return false;
        }
        LeafNode right = (LeafNode)siblings[2];
        if (right != null && right.values.length < 15) {
            Item[] rvals = right.values;
            int r = rvals.length;
            int diff = 15 - r;
            int move = (diff + 1) / 2;
            int l = n + 1 - move;
            Item[] newLeft = new Item[l];
            Item[] newRight = new Item[r + move];
            Array.copy(vals, l, newLeft);
            Array.copyToStart(vals, l, move, newRight);
            Array.copyFromStart(rvals, r, newRight, move);
            siblings[1] = new LeafNode(newLeft);
            siblings[2] = new LeafNode(newRight);
            return false;
        }
        int l = vals.length / 2;
        int r = vals.length - l;
        Item[] newLeft = new Item[l];
        Item[] newRight = new Item[r];
        Array.copy(vals, l, newLeft);
        Array.copyToStart(vals, l, r, newRight);
        siblings[3] = siblings[2];
        siblings[1] = new LeafNode(newLeft);
        siblings[2] = new LeafNode(newRight);
        return true;
    }

    public LeafNode set(long pos, Item val) {
        Item[] vals = (Item[])this.values.clone();
        vals[(int)pos] = val;
        return new LeafNode(vals);
    }

    @Override
    public NodeLike<Item, Item>[] remove(Node<Item, Item> left, Node<Item, Item> right, long pos) {
        int p = (int)pos;
        int n = this.values.length;
        NodeLike[] out = new NodeLike[]{left, null, right};
        if (n > 8) {
            Item[] vals = new Item[n - 1];
            Array.copy(this.values, p, vals);
            Array.copy(this.values, p + 1, n - 1 - p, vals, p);
            out[1] = new LeafNode(vals);
            return out;
        }
        LeafNode leftLeaf = (LeafNode)left;
        if (leftLeaf != null && leftLeaf.arity() > 8) {
            Item[] lvals = leftLeaf.values;
            int l = lvals.length;
            int diff = l - 8;
            int move = (diff + 1) / 2;
            int ll = l - move;
            int rl = n - 1 + move;
            Item[] newLeft = new Item[ll];
            Item[] newRight = new Item[rl];
            Array.copy(lvals, ll, newLeft);
            Array.copyToStart(lvals, ll, move, newRight);
            Array.copyFromStart(this.values, p, newRight, move);
            Array.copy(this.values, p + 1, n - 1 - p, newRight, move + p);
            out[0] = new LeafNode(newLeft);
            out[1] = new LeafNode(newRight);
            return out;
        }
        LeafNode rightLeaf = (LeafNode)right;
        if (rightLeaf != null && rightLeaf.arity() > 8) {
            Item[] rvals = rightLeaf.values;
            int r = rvals.length;
            int diff = r - 8;
            int move = (diff + 1) / 2;
            int ll = n - 1 + move;
            int rl = r - move;
            Item[] newLeft = new Item[ll];
            Item[] newRight = new Item[rl];
            Array.copy(this.values, p, newLeft);
            Array.copy(this.values, p + 1, n - 1 - p, newLeft, p);
            Array.copyFromStart(rvals, move, newLeft, n - 1);
            Array.copyToStart(rvals, move, rl, newRight);
            out[1] = new LeafNode(newLeft);
            out[2] = new LeafNode(newRight);
            return out;
        }
        if (left != null) {
            Item[] lvals = ((LeafNode)left).values;
            int l = lvals.length;
            int r = this.values.length;
            Item[] vals = new Item[l + r - 1];
            Array.copy(lvals, l, vals);
            Array.copyFromStart(this.values, p, vals, l);
            Array.copy(this.values, p + 1, r - 1 - p, vals, l + p);
            out[0] = new LeafNode(vals);
            return out;
        }
        if (right != null) {
            Item[] rvals = ((LeafNode)right).values;
            int l = this.values.length;
            int r = rvals.length;
            Item[] vals = new Item[l - 1 + r];
            Array.copy(this.values, p, vals);
            Array.copy(this.values, p + 1, l - 1 - p, vals, p);
            Array.copyFromStart(rvals, r, vals, l - 1);
            out[2] = new LeafNode(vals);
            return out;
        }
        Item[] vals = new Item[n - 1];
        Array.copy(this.values, p, vals);
        Array.copy(this.values, p + 1, n - 1 - p, vals, p);
        out[1] = new PartialLeafNode(vals);
        return out;
    }

    @Override
    public int append(NodeLike<Item, Item>[] nodes, int pos) {
        if (pos == 0) {
            nodes[0] = this;
            return 1;
        }
        NodeLike<Item, Item> left = nodes[pos - 1];
        if (!(left instanceof PartialLeafNode)) {
            nodes[pos] = this;
            return pos + 1;
        }
        Item[] ls = ((PartialLeafNode)left).elems;
        int l = ls.length;
        Item[] rs = this.values;
        int r = rs.length;
        int n = l + r;
        if (n <= 15) {
            Item[] vals = new Item[n];
            Array.copy(ls, l, vals);
            Array.copyFromStart(rs, r, vals, l);
            nodes[pos - 1] = new LeafNode(vals);
            return pos;
        }
        int ll = n / 2;
        int rl = n - ll;
        int move = r - rl;
        Item[] newLeft = new Item[ll];
        Item[] newRight = new Item[rl];
        Array.copy(ls, l, newLeft);
        Array.copyFromStart(rs, move, newLeft, l);
        Array.copyToStart(rs, move, rl, newRight);
        nodes[pos - 1] = new LeafNode(newLeft);
        nodes[pos] = new LeafNode(newRight);
        return pos + 1;
    }

    @Override
    public NodeLike<Item, Item> slice(long off, long size) {
        int p = (int)off;
        int n = (int)size;
        Item[] out = new Item[n];
        Array.copyToStart(this.values, p, n, out);
        return n < 8 ? new PartialLeafNode(out) : new LeafNode(out);
    }

    @Override
    public long checkInvariants() {
        if (this.values.length < 8 || this.values.length > 15) {
            throw new AssertionError((Object)("Wrong " + Util.className(this) + " size: " + this.values.length));
        }
        return this.values.length;
    }

    @Override
    public int arity() {
        return this.values.length;
    }

    @Override
    public Item getSub(int index) {
        return this.values[index];
    }

    public String toString() {
        return Util.className(this) + '(' + this.size() + ')' + Arrays.toString(this.values);
    }
}

