/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import java.util.HashMap;
import java.util.function.IntConsumer;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ExprList;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.XQData;
import org.basex.query.value.map.MergeDuplicates;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class XQMap
extends XQData {
    public static final XQMap EMPTY = new XQMap(TrieNode.EMPTY);
    static final int BITS = 5;
    private final TrieNode root;

    private XQMap(TrieNode root) {
        super(SeqType.MAP);
        this.root = root;
    }

    @Override
    public QNm paramName(int pos) {
        return new QNm("key", "");
    }

    @Override
    public void refineType(Expr expr) {
        if (this.root.size != 0) {
            super.refineType(expr);
        }
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) throws QueryException {
        this.root.cache(lazy, ii);
    }

    public XQMap delete(Item key, InputInfo ii) throws QueryException {
        TrieNode del = this.root.delete(key.hash(ii), key, 0, ii);
        return del == this.root ? this : (del == null ? EMPTY : new XQMap(del));
    }

    @Override
    public Value get(Item key, InputInfo ii) throws QueryException {
        Value value = this.root.get(key.hash(ii), key, 0, ii);
        return value == null ? Empty.VALUE : value;
    }

    public boolean contains(Item key, InputInfo ii) throws QueryException {
        return this.root.contains(key.hash(ii), key, 0, ii);
    }

    public XQMap addAll(XQMap map, MergeDuplicates merge, QueryContext qc, InputInfo ii) throws QueryException {
        if (map == EMPTY) {
            return this;
        }
        TrieNode upd = this.root.addAll(map.root, 0, merge, qc, ii);
        return upd == map.root ? map : new XQMap(upd);
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.FIATOM_X.get(ii, this.type);
    }

    @Override
    public Item atomItem(QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.FIATOM_X.get(ii, this.type);
    }

    @Override
    public Item materialize(QueryContext qc, boolean copy) {
        return this.root.materialized() ? this : null;
    }

    @Override
    public boolean instanceOf(Type tp) {
        SeqType dt;
        if (this.type.instanceOf(tp)) {
            return true;
        }
        if (!(tp instanceof FuncType) || tp instanceof ArrayType) {
            return false;
        }
        FuncType ft = (FuncType)tp;
        if (ft.argTypes.length != 1 || !ft.argTypes[0].instanceOf(SeqType.ANY_ATOMIC_TYPE_O)) {
            return false;
        }
        AtomType kt = null;
        if (ft instanceof MapType && (kt = ((MapType)ft).keyType()) == AtomType.ANY_ATOMIC_TYPE) {
            kt = null;
        }
        if ((dt = ft.declType).eq(SeqType.ITEM_ZM)) {
            dt = null;
        }
        return kt == null && dt == null || this.root.instanceOf(kt, dt);
    }

    public XQMap put(Item key, Value value, InputInfo ii) throws QueryException {
        TrieNode ins = this.root.put(key.hash(ii), key, value, 0, ii);
        return ins == this.root ? this : new XQMap(ins);
    }

    public int mapSize() {
        return this.root.size;
    }

    public Value keys() {
        ItemList items = new ItemList(this.root.size);
        this.root.keys(items);
        return items.value();
    }

    public void values(ValueBuilder vb) {
        this.root.values(vb);
    }

    public Value forEach(FItem func, QueryContext qc, InputInfo ii) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc);
        this.root.forEach(vb, func, qc, ii);
        return vb.value();
    }

    @Override
    public boolean deep(Item item, Collation coll, InputInfo ii) throws QueryException {
        if (item instanceof FuncItem) {
            throw QueryError.FICMP_X.get(ii, this.type);
        }
        if (item instanceof XQMap) {
            return this.root.deep(((XQMap)item).root, coll, ii);
        }
        return false;
    }

    @Override
    public HashMap<Object, Object> toJava() throws QueryException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Item key : this.keys()) {
            map.put(key.toJava(), this.get(key, null).toJava());
        }
        return map;
    }

    @Override
    public int hash(InputInfo ii) throws QueryException {
        return this.root.hash(ii);
    }

    @Override
    public void string(boolean indent, TokenBuilder tb, int level, InputInfo ii) throws QueryException {
        tb.add("map{");
        int c = 0;
        IntConsumer addWS = lvl -> {
            for (int l = 0; l < lvl; ++l) {
                tb.add("  ");
            }
        };
        for (Item key : this.keys()) {
            Value value;
            boolean par;
            if (c++ > 0) {
                tb.add(44);
            }
            if (indent) {
                tb.add(10);
                addWS.accept(level + 1);
            }
            tb.add(key).add(58);
            if (indent) {
                tb.add(32);
            }
            boolean bl = par = (value = this.get(key, ii)).size() != 1L;
            if (par) {
                tb.add(40);
            }
            int cc = 0;
            for (Item item : value) {
                if (cc++ > 0) {
                    tb.add(44);
                    if (indent) {
                        tb.add(32);
                    }
                }
                if (item instanceof XQMap) {
                    ((XQMap)item).string(indent, tb, level + 1, ii);
                    continue;
                }
                if (item instanceof XQArray) {
                    ((XQArray)item).string(indent, tb, level, ii);
                    continue;
                }
                tb.add(item);
            }
            if (!par) continue;
            tb.add(41);
        }
        if (indent) {
            tb.add(10);
            addWS.accept(level);
        }
        tb.add(125);
    }

    @Override
    public String description() {
        return "map";
    }

    @Override
    public void plan(QueryPlan plan) {
        try {
            int size = this.mapSize();
            Value keys = this.keys();
            ExprList list = new ExprList();
            int max = Math.min(size, 5);
            for (long i = 0L; i < (long)max; ++i) {
                Item key = keys.itemAt(i);
                ((ExprList)((Object)list.add(key))).add(this.get(key, null));
            }
            plan.add(plan.create(this, "entries", size), new ExprInfo[0]);
        }
        catch (QueryException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    @Override
    public void plan(QueryString qs) {
        qs.token("map").brace(this.root.append(new StringBuilder()).toString().replaceAll(", $", ""));
    }
}

