/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class Dec
extends ANum {
    public static final BigDecimal BD_MAXLONG = BigDecimal.valueOf(Long.MAX_VALUE);
    public static final BigDecimal BD_1000000 = BigDecimal.valueOf(1000000L);
    public static final BigDecimal BD_864000 = BigDecimal.valueOf(86400L);
    public static final BigDecimal BD_146097 = BigDecimal.valueOf(146097L);
    public static final BigDecimal BD_36525 = BigDecimal.valueOf(36525L);
    public static final BigDecimal BD_36524 = BigDecimal.valueOf(36524L);
    public static final BigDecimal BD_3600 = BigDecimal.valueOf(3600L);
    public static final BigDecimal BD_1461 = BigDecimal.valueOf(1461L);
    public static final BigDecimal BD_1000 = BigDecimal.valueOf(1000L);
    public static final BigDecimal BD_366 = BigDecimal.valueOf(366L);
    public static final BigDecimal BD_365 = BigDecimal.valueOf(365L);
    public static final BigDecimal BD_153 = BigDecimal.valueOf(153L);
    public static final BigDecimal BD_100 = BigDecimal.valueOf(100L);
    public static final BigDecimal BD_60 = BigDecimal.valueOf(60L);
    public static final BigDecimal BD_5 = BigDecimal.valueOf(5L);
    public static final BigDecimal BD_4 = BigDecimal.valueOf(4L);
    public static final BigDecimal BD_2 = BigDecimal.valueOf(2L);
    public static final Dec ZERO = new Dec(BigDecimal.ZERO);
    public static final Dec ONE = new Dec(BigDecimal.ONE);
    private final BigDecimal value;

    private Dec(BigDecimal value) {
        super(AtomType.DECIMAL);
        this.value = value;
    }

    public static Dec get(BigDecimal value) {
        return value.signum() == 0 ? ZERO : new Dec(value);
    }

    @Override
    public byte[] string() {
        return Token.chopNumber(Token.token(this.value.toPlainString()));
    }

    @Override
    public boolean bool(InputInfo ii) {
        return this.value.signum() != 0;
    }

    @Override
    public long itr() {
        return this.value.longValue();
    }

    @Override
    public float flt() {
        return this.value.floatValue();
    }

    @Override
    public double dbl() {
        return this.value.doubleValue();
    }

    @Override
    public BigDecimal dec(InputInfo ii) {
        return this.value;
    }

    @Override
    public Dec abs() {
        return this.value.signum() == -1 ? Dec.get(this.value.negate()) : this;
    }

    @Override
    public Dec ceiling() {
        return Dec.get(this.value.setScale(0, RoundingMode.CEILING));
    }

    @Override
    public Dec floor() {
        return Dec.get(this.value.setScale(0, RoundingMode.FLOOR));
    }

    @Override
    public Dec round(int scale, boolean even) {
        int s = this.value.signum();
        return s == 0 ? this : Dec.get(this.value.setScale(scale, even ? RoundingMode.HALF_EVEN : (s == 1 ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN)));
    }

    @Override
    public boolean eq(Item item, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
        Type t = item.type;
        return t.isUntyped() ? this.dbl() == item.dbl(ii) : (t == AtomType.DOUBLE || t == AtomType.FLOAT ? item.eq(this, coll, sc, ii) : this.value.compareTo(item.dec(ii)) == 0);
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo ii) throws QueryException {
        double d = item.dbl(ii);
        return d == Double.NEGATIVE_INFINITY ? -1 : (d == Double.POSITIVE_INFINITY ? 1 : (Double.isNaN(d) ? Integer.MIN_VALUE : this.value.compareTo(item.dec(ii))));
    }

    @Override
    public Object toJava() {
        return this.value;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Dec && this.value.compareTo(((Dec)obj).value) == 0;
    }

    public static BigDecimal parse(Item item, InputInfo ii) throws QueryException {
        byte[] value = item.string(ii);
        try {
            if (!Token.contains(value, 101) && !Token.contains(value, 69)) {
                return new BigDecimal(Token.string(value).trim());
            }
        }
        catch (NumberFormatException ex) {
            Util.debug(ex);
        }
        throw AtomType.DECIMAL.castError(item, ii);
    }
}

