/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.util.Arrays;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public class B64
extends Bin {
    public static final B64 EMPTY = new B64(new byte[0]);
    private static final B64[] B64S;

    B64() {
        super(null, AtomType.BASE64_BINARY);
    }

    public static B64 get(byte value) {
        return B64S[value & 0xFF];
    }

    public static B64 get(byte[] value) {
        return value.length == 1 ? B64.get(value[0]) : new B64(value);
    }

    public static B64 get(Bin bin, InputInfo ii) throws QueryException {
        return B64.get(bin.binary(ii));
    }

    public static B64 get(byte[] value, InputInfo ii) throws QueryException {
        return B64.get(B64.parse(value, ii));
    }

    private B64(byte[] data) {
        super(data, AtomType.BASE64_BINARY);
    }

    @Override
    public byte[] string(InputInfo ii) throws QueryException {
        return Base64.encode(this.binary(ii));
    }

    @Override
    public final boolean eq(Item item, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
        byte[] bin = item instanceof Bin ? ((Bin)item).binary(ii) : B64.parse(item, ii);
        return Token.eq(this.binary(ii), bin);
    }

    @Override
    public final int diff(Item item, Collation coll, InputInfo ii) throws QueryException {
        byte[] bin = item instanceof Bin ? ((Bin)item).binary(ii) : B64.parse(item, ii);
        return Token.diff(this.binary(ii), bin);
    }

    public static byte[] parse(Item item, InputInfo ii) throws QueryException {
        try {
            return Base64.decode(item.string(ii));
        }
        catch (IllegalArgumentException ex) {
            throw AtomType.BASE64_BINARY.castError(item, ii);
        }
    }

    public static byte[] parse(byte[] value, InputInfo ii) throws QueryException {
        try {
            return Base64.decode(value);
        }
        catch (IllegalArgumentException ex) {
            throw AtomType.BASE64_BINARY.castError(value, ii);
        }
    }

    @Override
    public void plan(QueryString qs) {
        TokenBuilder tb = new TokenBuilder().add(34);
        if (this.data.length > 128) {
            tb.add(Base64.encode(Arrays.copyOf(this.data, 128))).add("...");
        } else {
            tb.add(Base64.encode(this.data));
        }
        qs.token(tb.add(34).finish());
    }

    static {
        int nl = 256;
        B64S = new B64[256];
        for (int n = 0; n < 256; ++n) {
            B64.B64S[n] = new B64(new byte[]{(byte)n});
        }
    }
}

