/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.hash;

import java.util.Arrays;
import java.util.Iterator;
import org.basex.query.QueryException;
import org.basex.query.util.hash.ItemSet;
import org.basex.query.value.item.Item;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.InputInfo;
import org.basex.util.hash.ASet;

public final class HashItemSet
extends ASet
implements ItemSet {
    private final boolean eq;
    private Item[] keys;
    private int[] hash;

    public HashItemSet(boolean eq) {
        super(8L);
        this.eq = eq;
        this.keys = new Item[this.capacity()];
        this.hash = new int[this.capacity()];
    }

    @Override
    public boolean add(Item item, InputInfo ii) throws QueryException {
        return this.index(item, ii) >= 0;
    }

    public boolean contains(Item item, InputInfo ii) throws QueryException {
        return this.id(item, ii) > 0;
    }

    public int id(Item item, InputInfo ii) throws QueryException {
        int b = item.hash(ii) & this.capacity() - 1;
        int id = this.buckets[b];
        while (id != 0) {
            if (this.eq ? this.keys[id].eq(item, null, null, ii) : this.keys[id].equiv(item, null, ii)) {
                return id;
            }
            id = this.next[id];
        }
        return 0;
    }

    private int index(Item item, InputInfo ii) throws QueryException {
        this.checkSize();
        int h = item.hash(ii);
        int b = h & this.capacity() - 1;
        int id = this.buckets[b];
        while (id != 0) {
            if (this.eq ? this.keys[id].eq(item, null, null, ii) : this.keys[id].equiv(item, null, ii)) {
                return -id;
            }
            id = this.next[id];
        }
        int s = this.size++;
        this.next[s] = this.buckets[b];
        this.keys[s] = item;
        this.hash[s] = h;
        this.buckets[b] = s;
        return s;
    }

    @Override
    protected int hash(int id) {
        return this.hash[id];
    }

    @Override
    protected void rehash(int newSize) {
        this.keys = Array.copy(this.keys, new Item[newSize]);
        this.hash = Arrays.copyOf(this.hash, newSize);
    }

    @Override
    public Iterator<Item> iterator() {
        return new ArrayIterator<Item>(this.keys, 1, this.size);
    }

    public String toString() {
        return this.toString(this.keys);
    }
}

