/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Calc;
import org.basex.query.util.format.FormatUtil;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.TokenParser;
import org.basex.util.hash.IntSet;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class DecFormatter
extends FormatUtil {
    private final byte[] digits;
    private final byte[] actives;
    public final int zero;
    public byte[] inf = Token.token("Infinity");
    public byte[] nan = Token.token("NaN");
    public int pattern = 59;
    public int decimal = 46;
    public int exponent = 101;
    public int grouping = 44;
    public int optional = 35;
    public int minus = 45;
    public int percent = 37;
    public int permille = 8240;

    public DecFormatter(TokenMap map, InputInfo info) throws QueryException {
        int z = 48;
        if (map != null) {
            for (byte[] key : map) {
                String k = Token.string(key);
                byte[] v = map.get(key);
                if (k.equals("infinity")) {
                    this.inf = v;
                    continue;
                }
                if (k.equals("NaN")) {
                    this.nan = v;
                    continue;
                }
                if (v.length != 0 && Token.cl(v, 0) == v.length) {
                    int cp = Token.cp(v, 0);
                    switch (k) {
                        case "decimal-separator": {
                            this.decimal = cp;
                            break;
                        }
                        case "grouping-separator": {
                            this.grouping = cp;
                            break;
                        }
                        case "exponent-separator": {
                            this.exponent = cp;
                            break;
                        }
                        case "pattern-separator": {
                            this.pattern = cp;
                            break;
                        }
                        case "minus-sign": {
                            this.minus = cp;
                            break;
                        }
                        case "digit": {
                            this.optional = cp;
                            break;
                        }
                        case "percent": {
                            this.percent = cp;
                            break;
                        }
                        case "per-mille": {
                            this.permille = cp;
                            break;
                        }
                        case "zero-digit": {
                            z = DecFormatter.zeroes(cp);
                            if (z == -1) {
                                throw QueryError.INVDECFORM_X_X.get(info, k, v);
                            }
                            if (z == cp) break;
                            throw QueryError.INVDECZERO_X.get(info, Character.valueOf((char)cp));
                        }
                    }
                    continue;
                }
                throw QueryError.INVDECSINGLE_X_X.get(info, k, v);
            }
        }
        this.zero = z;
        IntSet is = new IntSet();
        for (int i = 0; i < 10; ++i) {
            is.add(this.zero + i);
        }
        int[] ss = new int[]{this.decimal, this.grouping, this.exponent, this.percent, this.permille, this.optional, this.pattern};
        for (Object s : (String)ss) {
            if (is.add((int)s)) continue;
            throw QueryError.DUPLDECFORM_X.get(info, Character.valueOf((char)s));
        }
        TokenBuilder tb = new TokenBuilder();
        for (int i = 0; i < 10; ++i) {
            tb.add(this.zero + i);
        }
        this.digits = tb.toArray();
        this.actives = tb.add(this.decimal).add(this.exponent).add(this.grouping).add(this.optional).finish();
    }

    public byte[] format(ANum number, byte[] picture, InputInfo ii) throws QueryException {
        byte[][] patterns;
        TokenList tl = new TokenList();
        byte[] pic = picture;
        int i = Token.indexOf(pic, this.pattern);
        if (i != -1) {
            tl.add(Token.substring(pic, 0, i));
            pic = Token.substring(pic, i + Token.cl(pic, i));
            if (Token.contains(pic, this.pattern)) {
                throw QueryError.PICNUM_X.get(ii, new Object[]{picture});
            }
        }
        if (!this.checkSyntax(patterns = (byte[][])((TokenList)tl.add(pic)).finish())) {
            throw QueryError.PICNUM_X.get(ii, new Object[]{picture});
        }
        Picture[] pics = this.analyze(patterns);
        return this.format(number, pics, ii);
    }

    private boolean checkSyntax(byte[][] patterns) {
        for (byte[] pt : patterns) {
            int cl;
            boolean frac = false;
            boolean act = false;
            boolean expAct = false;
            boolean exp = false;
            boolean digMant = false;
            boolean optInt = false;
            boolean optFrac = false;
            boolean per = false;
            int last = 0;
            int pl = pt.length;
            for (int i = 0; i < pl; i += cl) {
                int ch = DecFormatter.ch(pt, i);
                cl = Token.cl(pt, i);
                boolean digit = Token.contains(this.digits, ch);
                boolean active = Token.contains(this.actives, ch);
                boolean expon = false;
                if (ch == this.decimal) {
                    if (frac) {
                        return false;
                    }
                    frac = true;
                } else if (ch == this.grouping) {
                    if (i == 0 && frac || last == this.decimal || (i + cl < pl ? DecFormatter.ch(pt, i + cl) == this.decimal : !frac)) {
                        return false;
                    }
                    if (last == this.grouping) {
                        return false;
                    }
                } else if (ch == this.exponent) {
                    if (act && this.containsActive(pt, i + cl)) {
                        if (exp) {
                            return false;
                        }
                        expon = true;
                    } else {
                        active = false;
                    }
                } else if (ch == this.percent || ch == this.permille) {
                    if (per) {
                        return false;
                    }
                    per = true;
                } else if (ch == this.optional) {
                    if (frac) {
                        optFrac = true;
                    } else {
                        if (digMant) {
                            return false;
                        }
                        optInt = true;
                    }
                } else if (digit && !exp) {
                    if (optFrac) {
                        return false;
                    }
                    digMant = true;
                }
                if (active) {
                    if (exp) {
                        if (!digit) {
                            return false;
                        }
                        expAct = true;
                    }
                    act = true;
                } else if (act && this.containsActive(pt, i + cl)) {
                    return false;
                }
                last = ch;
                if (!expon) continue;
                exp = true;
            }
            if (!(optInt || optFrac || digMant)) {
                return false;
            }
            if (per && exp) {
                return false;
            }
            if (!exp || expAct) continue;
            return false;
        }
        return true;
    }

    private Picture[] analyze(byte[][] patterns) {
        int picL = patterns.length;
        Picture[] pics = new Picture[picL];
        for (int p = 0; p < picL; ++p) {
            int cl;
            byte[] pt = patterns[p];
            Picture pic = new Picture();
            boolean frac = false;
            boolean act = false;
            boolean exp = false;
            int optInt = 0;
            int optFrac = 0;
            int pl = pt.length;
            for (int i = 0; i < pl; i += cl) {
                int ch = DecFormatter.ch(pt, i);
                cl = Token.cl(pt, i);
                boolean active = Token.contains(this.actives, ch);
                if (ch == this.decimal) {
                    frac = true;
                    act = false;
                } else if (ch == this.optional) {
                    if (frac) {
                        ++optFrac;
                    } else {
                        ++optInt;
                    }
                } else if (ch == this.exponent) {
                    if (act && this.containsActive(pt, i + cl)) {
                        exp = true;
                    } else {
                        active = false;
                    }
                } else if (ch == this.grouping) {
                    if (!frac) {
                        pic.groupInt.add(pic.minInt + optInt);
                    }
                } else if (Token.contains(this.digits, ch)) {
                    if (exp) {
                        pic.minExp++;
                    } else if (frac) {
                        pic.minFrac++;
                    } else {
                        pic.minInt++;
                    }
                }
                if (active) {
                    act = true;
                    continue;
                }
                pic.pc = pic.pc | ch == this.percent;
                pic.pm = pic.pm | ch == this.permille;
                (frac || act ? pic.suffix : pic.prefix).add(ch);
            }
            IntList ipgp = pic.groupInt;
            int igl = ipgp.size();
            for (int g = 0; g < igl; ++g) {
                ipgp.set(g, pic.minInt + optInt - ipgp.get(g));
            }
            if (igl > 1) {
                boolean reg = true;
                int i = ipgp.get(igl - 1);
                for (int g = igl - 2; g >= 0; --g) {
                    reg &= i * igl == ipgp.get(g);
                }
                if (reg) {
                    pic.groupInt.reset();
                    pic.groupInt.add(i);
                }
            }
            pic.scaling = pic.minInt;
            pic.maxFrac = optFrac + pic.minFrac;
            if (pic.minInt == 0 && pic.maxFrac == 0) {
                if (exp) {
                    pic.minFrac = 1;
                    pic.maxFrac = 1;
                } else {
                    pic.minInt = 1;
                }
            }
            if (exp && pic.minInt == 0 && optInt > 0) {
                pic.minInt = 1;
            }
            if (pic.minInt == 0 && pic.minFrac == 0) {
                pic.minFrac = 1;
            }
            pics[p] = pic;
        }
        return pics;
    }

    private boolean containsActive(byte[] pt, int i) {
        int pl = pt.length;
        for (int p = i; p < pl; p += Token.cl(pt, p)) {
            if (!Token.contains(this.actives, DecFormatter.ch(pt, p))) continue;
            return true;
        }
        return false;
    }

    private byte[] format(ANum item, Picture[] pics, InputInfo ii) throws QueryException {
        String s;
        double d = item.dbl(ii);
        if (Double.isNaN(d)) {
            return this.nan;
        }
        boolean neg = d < 0.0 || d == 0.0 && Double.doubleToLongBits(d) == Long.MIN_VALUE;
        Picture pic = pics[neg && pics.length == 2 ? 1 : 0];
        IntList res = new IntList();
        IntList intgr = new IntList();
        IntList fract = new IntList();
        int exp = 0;
        ANum num = item;
        if (pic.pc) {
            num = (ANum)Calc.MULT.eval(num, Int.get(100L), ii);
        }
        if (pic.pm) {
            num = (ANum)Calc.MULT.eval(num, Int.get(1000L), ii);
        }
        if (Double.isInfinite(num.dbl(ii))) {
            intgr.add(new TokenParser(this.inf).toArray());
        } else {
            int i;
            int fl;
            int il;
            int i2;
            if (pic.minExp != 0 && d != 0.0) {
                BigDecimal dec = num.dec(ii).abs().stripTrailingZeros();
                int scl = 0;
                if (dec.compareTo(BigDecimal.ONE) >= 0) {
                    scl = dec.setScale(0, RoundingMode.HALF_DOWN).precision();
                } else {
                    while (dec.compareTo(BigDecimal.ONE) < 0) {
                        dec = dec.multiply(BigDecimal.TEN);
                        --scl;
                    }
                    ++scl;
                }
                exp = scl - pic.scaling;
                if (exp != 0) {
                    BigDecimal n = BigDecimal.TEN.pow(Math.abs(exp));
                    num = (ANum)Calc.MULT.eval(num, Dec.get(exp > 0 ? BigDecimal.ONE.divide(n, MathContext.DECIMAL64) : n), ii);
                }
            }
            if (Strings.startsWith(s = ((num = num.round(pic.maxFrac, true).abs()) instanceof Dbl || num instanceof Flt ? Dec.get(BigDecimal.valueOf(num.dbl(ii))) : num).toString(), '0')) {
                s = s.substring(1);
            }
            int fracSep = s.indexOf(46);
            int sl = s.length();
            for (i2 = il = fracSep == -1 ? sl : fracSep; i2 < pic.minInt; ++i2) {
                intgr.add(this.zero);
            }
            for (i2 = 0; i2 < il; ++i2) {
                intgr.add(this.zero + s.charAt(i2) - 48);
            }
            int gil = pic.groupInt.size();
            if (gil == 1 && pic.groupInt.get(0) > 0) {
                for (int i3 = intgr.size() - 1; i3 > 0; --i3) {
                    if (i3 % pic.groupInt.get(0) != 0) continue;
                    intgr.insert(intgr.size() - i3, this.grouping);
                }
            } else {
                for (int g = 0; g < gil; ++g) {
                    int pos = intgr.size() - pic.groupInt.get(g);
                    if (pos <= 0) continue;
                    intgr.insert(pos, this.grouping);
                }
            }
            int n = fl = fracSep == -1 ? 0 : sl - il - 1;
            if (fl != 0) {
                for (i = fracSep + 1; i < sl; ++i) {
                    fract.add(this.zero + s.charAt(i) - 48);
                }
            }
            for (i = fl; i < pic.minFrac; ++i) {
                fract.add(this.zero);
            }
            int ul = fract.size();
            for (int p = pic.groupFrac.size() - 1; p >= 0; --p) {
                int pos = pic.groupFrac.get(p);
                if (pos >= ul) continue;
                fract.insert(pos, this.grouping);
            }
        }
        if (neg && pics.length != 2) {
            res.add(this.minus);
        }
        res.add(pic.prefix.toArray()).add(intgr.finish());
        if (!fract.isEmpty()) {
            res.add(this.decimal).add(fract.finish());
        }
        if (pic.minExp != 0) {
            int sl;
            int i;
            res.add(this.exponent);
            if (exp < 0) {
                res.add(this.minus);
            }
            s = Integer.toString(Math.abs(exp));
            for (i = sl = s.length(); i < pic.minExp; ++i) {
                res.add(this.zero);
            }
            for (i = 0; i < sl; ++i) {
                res.add(this.zero + s.charAt(i) - 48);
            }
        }
        res.add(pic.suffix.toArray());
        TokenBuilder tb = new TokenBuilder(res.size());
        for (int r : res.finish()) {
            tb.add(r);
        }
        return tb.finish();
    }

    private static final class Picture {
        private final IntList prefix = new IntList();
        private final IntList suffix = new IntList();
        private final IntList groupInt = new IntList();
        private final IntList groupFrac = new IntList();
        private int scaling;
        private int minInt;
        private int minFrac;
        private int maxFrac;
        private int minExp;
        private boolean pc;
        private boolean pm;

        private Picture() {
        }
    }
}

