/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.collation;

import java.util.HashMap;
import org.basex.core.BaseXException;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.util.collation.BaseXCollationOptions;
import org.basex.query.util.collation.CollationOptions;
import org.basex.query.util.collation.NoCaseCollation;
import org.basex.query.util.collation.UCAOptions;
import org.basex.query.value.item.Uri;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.options.Options;

public abstract class Collation {
    private static final byte[] NOCASE = Token.token("http://www.w3.org/2005/xpath-functions/collation/html-ascii-case-insensitive");
    private static final byte[] UCA = Token.token("http://www.w3.org/2013/collation/UCA");
    private static final byte[] URL = Token.token(QueryText.BASEX_URL + "/collation");
    private byte[] uri = Token.EMPTY;

    public static Collation get(byte[] uri, QueryContext qc, StaticContext sc, InputInfo ii, QueryError err) throws QueryException {
        Collation coll;
        byte[] url;
        if (uri == null) {
            return sc.collation;
        }
        Uri u = Uri.uri(uri);
        if (!u.isValid()) {
            throw QueryError.INVURI_X.get(ii, new Object[]{uri});
        }
        byte[] byArray = u.isAbsolute() ? uri : (url = Token.startsWith(uri, 63) ? Token.concat(URL, uri) : sc.baseURI().resolve(u, ii).string());
        if (Token.eq(QueryText.COLLATION_URI, url)) {
            return null;
        }
        if (qc.collations == null) {
            qc.collations = new TokenObjMap();
        }
        if ((coll = qc.collations.get(url)) == null) {
            coll = Collation.get(url, ii, err);
            qc.collations.put(url, coll);
        }
        return coll;
    }

    private static Collation get(byte[] uri, InputInfo ii, QueryError err) throws QueryException {
        if (Token.eq(NOCASE, uri)) {
            return new NoCaseCollation();
        }
        int q = Token.indexOf(uri, 63);
        byte[] base = q == -1 ? uri : Token.substring(uri, 0, q);
        HashMap<String, String> args = Collation.args(q == -1 ? "" : Token.string(Token.replace(Token.substring(uri, q + 1), 38, 59)));
        CollationOptions opts = null;
        if (Token.eq(URL, base)) {
            opts = new BaseXCollationOptions(false);
        } else if (Token.eq(UCA, base)) {
            if (UCAOptions.ACTIVE) {
                opts = new UCAOptions();
            } else if (!Options.YesNo.NO.toString().equals(args.get(UCAOptions.FALLBACK.name()))) {
                opts = new BaseXCollationOptions(true);
            }
        }
        if (opts == null) {
            throw err.get(ii, new Object[]{Util.inf("Unknown collation '%'", new Object[]{uri})});
        }
        try {
            Collation coll = ((CollationOptions)opts).get(args);
            coll.uri = uri;
            return coll;
        }
        catch (IllegalArgumentException | BaseXException ex) {
            throw err.get(ii, ex.getMessage());
        }
    }

    private static HashMap<String, String> args(String args) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String option : Strings.split(args, ';')) {
            String[] kv = Strings.split(option, '=', 2);
            map.put(kv[0], kv.length == 2 ? kv[1] : "");
        }
        return map;
    }

    public final boolean contains(byte[] string, byte[] sub, InputInfo ii) throws QueryException {
        return this.indexOf(Token.string(string), Token.string(sub), Mode.INDEX_OF, ii) != -1;
    }

    public final boolean startsWith(byte[] string, byte[] sub, InputInfo ii) throws QueryException {
        return this.indexOf(Token.string(string), Token.string(sub), Mode.STARTS_WITH, ii) != -1;
    }

    public final boolean endsWith(byte[] string, byte[] sub, InputInfo ii) throws QueryException {
        return this.indexOf(Token.string(string), Token.string(sub), Mode.ENDS_WITH, ii) != -1;
    }

    public final byte[] after(byte[] string, byte[] sub, InputInfo ii) throws QueryException {
        String st = Token.string(string);
        int i = this.indexOf(st, Token.string(sub), Mode.INDEX_AFTER, ii);
        return i == -1 ? Token.EMPTY : Token.token(st.substring(i));
    }

    public final byte[] before(byte[] string, byte[] sub, InputInfo ii) throws QueryException {
        String st = Token.string(string);
        int i = this.indexOf(st, Token.string(sub), Mode.INDEX_OF, ii);
        return i == -1 ? Token.EMPTY : Token.token(st.substring(0, i));
    }

    public final byte[] uri() {
        return this.uri;
    }

    public abstract int compare(byte[] var1, byte[] var2);

    protected abstract int indexOf(String var1, String var2, Mode var3, InputInfo var4) throws QueryException;

    protected static enum Mode {
        INDEX_OF,
        INDEX_AFTER,
        STARTS_WITH,
        ENDS_WITH;

    }
}

