/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.util.ArrayList;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.DataFTBuilder;
import org.basex.query.util.ft.FTPosData;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.Token;

public final class DataBuilder {
    private final QueryContext qc;
    private final MemData data;
    private DataFTBuilder ftbuilder;

    public DataBuilder(MemData data, QueryContext qc) {
        this.data = data;
        this.qc = qc;
    }

    public DataBuilder ftpos(byte[] name, FTPosData pos, int len) {
        this.ftbuilder = new DataFTBuilder(pos, len, this.data.elemNames.put(name));
        return this;
    }

    public void build(ANode node) {
        this.build((ANodeList)((Object)new ANodeList().add(node)));
    }

    public void build(ANodeList nodes) {
        this.data.meta.update();
        int next = this.data.meta.size;
        for (ANode node : nodes) {
            next = this.addNode(node, next, -1);
        }
    }

    private int addNode(ANode node, int pre, int par) {
        if (this.qc != null) {
            this.qc.checkStop();
        }
        switch (node.nodeType()) {
            case DOCUMENT_NODE: {
                return this.addDoc(node, pre);
            }
            case ELEMENT: {
                return this.addElem(node, pre, par);
            }
            case TEXT: {
                return this.addText(node, pre, par);
            }
            case ATTRIBUTE: {
                return this.addAttr(node, pre, par);
            }
            case COMMENT: {
                return this.addComm(node, pre, par);
            }
        }
        return this.addPI(node, pre, par);
    }

    private int addDoc(ANode node, int pre) {
        int size = DataBuilder.size(node, false);
        this.data.doc(size, node.baseURI());
        int last = this.data.meta.size;
        this.data.insert(last);
        int next = pre + 1;
        for (ANode child : node.childIter()) {
            next = this.addNode(child, next, pre);
        }
        if (size != next - pre) {
            this.data.size(last, 0, next - pre);
        }
        return next;
    }

    private int addAttr(ANode node, int pre, int par) {
        int last = this.data.meta.size;
        QNm qname = node.qname();
        byte[] prefix = qname.prefix();
        byte[] uri = qname.uri();
        int uriId = uri.length == 0 || Token.eq(prefix, Token.XML) ? 0 : (par == -1 ? this.data.nspaces.add(last, prefix, uri, this.data) : this.data.nspaces.uriId(uri));
        int nameId = this.data.attrNames.put(qname.string());
        this.data.attr(pre - par, nameId, node.string(), uriId);
        this.data.insert(last);
        return pre + 1;
    }

    private int addText(ANode node, int pre, int par) {
        ArrayList<DataFTBuilder.DataFTMarker> marks;
        int dist = pre - par;
        ArrayList<DataFTBuilder.DataFTMarker> arrayList = marks = this.ftbuilder != null ? this.ftbuilder.build(node) : null;
        if (marks == null) {
            this.addText(node.string(), dist);
            return pre + 1;
        }
        int uriId = this.data.nspaces.uriIdForPrefix(Token.EMPTY, true);
        int ts = marks.size();
        for (DataFTBuilder.DataFTMarker marker : marks) {
            if (marker.mark) {
                this.data.elem(dist++, this.ftbuilder.name(), 1, 2, uriId, false);
                this.data.insert(this.data.meta.size);
                ++ts;
            }
            this.addText(marker.token, marker.mark ? 1 : dist);
            ++dist;
        }
        return pre + ts;
    }

    private void addText(byte[] text, int dist) {
        this.data.text(dist, text, 2);
        this.data.insert(this.data.meta.size);
    }

    private int addPI(ANode node, int pre, int par) {
        byte[] value = Token.trim(Token.concat(node.name(), Token.SPACE, node.string()));
        this.data.text(pre - par, value, 5);
        this.data.insert(this.data.meta.size);
        return pre + 1;
    }

    private int addComm(ANode node, int pre, int par) {
        this.data.text(pre - par, node.string(), 4);
        this.data.insert(this.data.meta.size);
        return pre + 1;
    }

    private int addElem(ANode node, int pre, int par) {
        int last = this.data.meta.size;
        Atts ns = par == -1 ? node.nsScope(null) : node.namespaces();
        this.data.nspaces.open(last, ns);
        QNm qname = node.qname();
        int size = DataBuilder.size(node, false);
        int asize = DataBuilder.size(node, true);
        int nameId = this.data.elemNames.put(qname.string());
        int uriId = this.data.nspaces.uriId(qname.uri());
        this.data.elem(pre - par, nameId, asize, size, uriId, !ns.isEmpty());
        this.data.insert(last);
        int cPre = pre + 1;
        for (ANode attr : node.attributeIter()) {
            cPre = this.addAttr(attr, cPre, pre);
        }
        for (ANode child : node.childIter()) {
            cPre = this.addNode(child, cPre, pre);
        }
        this.data.nspaces.close(last);
        if (size != cPre - pre) {
            this.data.size(last, 1, cPre - pre);
        }
        return cPre;
    }

    private static int size(ANode node, boolean att) {
        if (node instanceof DBNode) {
            DBNode dbnode = (DBNode)node;
            Data data = dbnode.data();
            int kind = node.kind();
            int pre = dbnode.pre();
            return att ? data.attSize(pre, kind) : data.size(pre, kind);
        }
        int size = 1;
        BasicNodeIter iter = node.attributeIter();
        while (iter.next() != null) {
            ++size;
        }
        if (!att) {
            for (ANode child : node.childIter()) {
                size += DataBuilder.size(child, false);
            }
        }
        return size;
    }

    public static ANode stripNS(ANode node, byte[] ns, Context ctx) {
        if (node.type != NodeType.ELEMENT && node.type != NodeType.DOCUMENT_NODE) {
            return node;
        }
        MemData data = new MemData(ctx.options);
        DataBuilder db = new DataBuilder(data, null);
        db.build(node);
        boolean del = true;
        for (int pre = 0; pre < data.meta.size; ++pre) {
            byte[] uri;
            int kind = data.kind(pre);
            if (kind != 1 && kind != 3 || (uri = data.nspaces.uri(data.uriId(pre, kind))) == null || !Token.eq(uri, ns)) continue;
            byte[] nm = data.name(pre, kind);
            if (Token.prefix(nm).length == 0) {
                if (kind != 1) continue;
                data.update(pre, 1, nm, Token.EMPTY);
                data.nsFlag(pre, false);
                continue;
            }
            del = false;
        }
        if (del) {
            data.nspaces.delete(ns);
        }
        return new DBNode(data);
    }
}

