/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.db;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.MainOptions;
import org.basex.core.cmd.Optimize;
import org.basex.core.cmd.OptimizeAll;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DBOptions;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.db.DBUpdate;
import org.basex.util.InputInfo;
import org.basex.util.ft.Language;
import org.basex.util.options.Option;
import org.basex.util.options.Options;

public final class DBOptimize
extends DBUpdate {
    private final DBOptions options;
    private final QueryContext qc;
    private boolean all;

    public DBOptimize(Data data, boolean all, Options opts, QueryContext qc, InputInfo info) throws QueryException {
        super(UpdateType.DBOPTIMIZE, data, info);
        this.all = all;
        this.qc = qc;
        ArrayList supported = new ArrayList();
        for (Option<?> option : DBOptions.INDEXING) {
            if (!all && option == MainOptions.UPDINDEX) continue;
            supported.add(option);
        }
        this.options = new DBOptions(opts, supported, info);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void apply() throws QueryException {
        MainOptions opts = new MainOptions(this.qc.context.options, true);
        MetaData meta = this.data.meta;
        this.options.assignIfAbsent(MainOptions.TEXTINDEX, meta.createtext);
        this.options.assignIfAbsent(MainOptions.ATTRINDEX, meta.createattr);
        this.options.assignIfAbsent(MainOptions.TOKENINDEX, meta.createtoken);
        this.options.assignIfAbsent(MainOptions.FTINDEX, meta.createft);
        this.options.assignIfAbsent(MainOptions.TEXTINCLUDE, meta.textinclude);
        this.options.assignIfAbsent(MainOptions.ATTRINCLUDE, meta.attrinclude);
        this.options.assignIfAbsent(MainOptions.TOKENINCLUDE, meta.tokeninclude);
        this.options.assignIfAbsent(MainOptions.FTINCLUDE, meta.ftinclude);
        this.options.assignIfAbsent(MainOptions.SPLITSIZE, meta.splitsize);
        this.options.assignIfAbsent(MainOptions.UPDINDEX, meta.updindex);
        this.options.assignIfAbsent(MainOptions.AUTOOPTIMIZE, meta.autooptimize);
        this.options.assignTo(opts);
        meta.createtext = opts.get(MainOptions.TEXTINDEX);
        meta.createattr = opts.get(MainOptions.ATTRINDEX);
        meta.createtoken = opts.get(MainOptions.TOKENINDEX);
        meta.createft = opts.get(MainOptions.FTINDEX);
        meta.updindex = opts.get(MainOptions.UPDINDEX);
        meta.autooptimize = opts.get(MainOptions.AUTOOPTIMIZE);
        meta.splitsize = opts.get(MainOptions.SPLITSIZE);
        int maxcats = opts.get(MainOptions.MAXCATS);
        int maxlen = opts.get(MainOptions.MAXLEN);
        String textinclude = opts.get(MainOptions.TEXTINCLUDE);
        String attrinclude = opts.get(MainOptions.ATTRINCLUDE);
        String tokeninclude = opts.get(MainOptions.TOKENINCLUDE);
        boolean rebuild = maxlen != meta.maxlen;
        boolean rebuildText = !meta.textinclude.equals(textinclude) || rebuild;
        boolean rebuildAttr = !meta.attrinclude.equals(attrinclude) || rebuild;
        boolean rebuildToken = !meta.tokeninclude.equals(tokeninclude);
        meta.textinclude = textinclude;
        meta.attrinclude = attrinclude;
        meta.tokeninclude = tokeninclude;
        meta.maxcats = maxcats;
        meta.maxlen = maxlen;
        String ftinclude = opts.get(MainOptions.FTINCLUDE);
        boolean stemming = opts.get(MainOptions.STEMMING);
        boolean casesens = opts.get(MainOptions.CASESENS);
        boolean diacritics = opts.get(MainOptions.DIACRITICS);
        Language language = Language.get(opts);
        String stopwords = opts.get(MainOptions.STOPWORDS);
        boolean rebuildFt = !meta.ftinclude.equals(ftinclude) || rebuild || stemming != meta.stemming || casesens != meta.casesens || diacritics != meta.diacritics || !language.equals(meta.language) || !stopwords.equals(meta.stopwords);
        meta.ftinclude = ftinclude;
        meta.stemming = stemming;
        meta.casesens = casesens;
        meta.diacritics = diacritics;
        meta.language = language;
        meta.stopwords = stopwords;
        try {
            if (this.all) {
                OptimizeAll.optimizeAll(this.data, this.qc.context, opts, null);
            } else {
                Optimize.optimize(this.data, rebuildText, rebuildAttr, rebuildToken, rebuildFt, null);
            }
        }
        catch (IOException ex) {
            throw QueryError.UPDBERROR_X.get(this.info, ex);
        }
        if (this.all) {
            this.qc.resources.remove(meta.name);
        }
    }

    @Override
    public void merge(Update update) {
        this.all |= ((DBOptimize)update).all;
    }

    @Override
    public int size() {
        return 1;
    }
}

