/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.iter.Iter;
import org.basex.query.up.Updates;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Transform
extends Arr {
    private final Let[] copies;

    public Transform(InputInfo info, Let[] copies, Expr mod, Expr rtrn) {
        super(info, SeqType.ITEM_ZM, mod, rtrn);
        this.copies = copies;
    }

    @Override
    public void checkUp() throws QueryException {
        for (Let copy : this.copies) {
            copy.checkUp();
        }
        Expr modify = this.exprs[0];
        modify.checkUp();
        if (!modify.vacuous() && !modify.has(Flag.UPD)) {
            throw QueryError.UPMODIFY.get(this.info, new Object[0]);
        }
        this.exprs[1].checkUp();
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        for (Let copy : this.copies) {
            copy.expr = copy.expr.compile(cc);
        }
        return super.compile(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        for (Let copy : this.copies) {
            copy.exprType.assign(copy.expr);
        }
        SeqType st = this.exprs[1].seqType();
        this.exprType.assign(st.type, st.occ);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value value(QueryContext qc) throws QueryException {
        Updates updates;
        Updates tmp = qc.updates();
        qc.updates = updates = new Updates(true);
        try {
            for (Let copy : this.copies) {
                Iter iter = copy.expr.iter(qc);
                Item item = iter.next();
                if (!(item instanceof ANode)) {
                    throw QueryError.UPSINGLE_X_X.get(copy.info, copy.var.name, item == null ? Empty.VALUE : item);
                }
                Item i2 = iter.next();
                if (i2 != null) {
                    throw QueryError.UPSINGLE_X_X.get(copy.info, copy.var.name, ValueBuilder.concat(item, i2, qc));
                }
                item = ((ANode)item).copy(qc);
                qc.set(copy.var, item);
                updates.addData(item.data());
            }
            if (!this.exprs[0].value(qc).isEmpty()) {
                throw QueryError.UPMODIFY.get(this.info, new Object[0]);
            }
            updates.prepare(qc);
            updates.apply(qc);
        }
        finally {
            qc.updates = tmp;
        }
        return this.exprs[1].value(qc);
    }

    @Override
    public boolean has(Flag ... flags) {
        for (Let copy : this.copies) {
            if (!copy.has(flags)) continue;
            return true;
        }
        if (Flag.CNS.in(flags) || Flag.UPD.in(flags) && this.exprs[1].has(Flag.UPD)) {
            return true;
        }
        Flag[] flgs = Flag.UPD.remove(flags);
        return flgs.length != 0 && super.has(flgs);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        for (Let copy : this.copies) {
            if (copy.inlineable(ic)) continue;
            return false;
        }
        return super.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.sum(var, this.copies).plus(super.count(var));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        boolean a = ic.inline(this.copies);
        boolean b = ic.inline(this.exprs);
        return a || b ? this.optimize(ic.cc) : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Transform(this.info, (Let[])Transform.copyAll((CompileContext)cc, vm, (Expr[])this.copies), this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm)));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return Transform.visitAll(visitor, this.copies) && super.accept(visitor);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (Let copy : this.copies) {
            size += copy.exprSize();
        }
        for (Expr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Transform && Array.equals(this.copies, ((Transform)obj).copies) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.copies, this.exprs});
    }

    @Override
    public void plan(QueryString qs) {
        qs.token("copy");
        boolean more = false;
        for (Let copy : this.copies) {
            if (more) {
                qs.token(", ");
            } else {
                more = true;
            }
            qs.token(copy.var.id()).token(":=").token(copy.expr);
        }
        qs.token("modify").token(this.exprs[0]).token("return").token(this.exprs[1]);
    }
}

