/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.xslt;

import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import org.basex.query.func.StandardFunc;
import org.basex.util.Reflect;

abstract class XsltFn
extends StandardFunc {
    static final ConcurrentHashMap<String, Templates> MAP = new ConcurrentHashMap();
    static final String[] SAXON = new String[]{"com.saxonica.config.EnterpriseTransformerFactory", "com.saxonica.config.ProfessionalTransformerFactory", "net.sf.saxon.TransformerFactoryImpl"};
    static final String PROCESSOR;
    static final String VERSION;

    XsltFn() {
    }

    static {
        String processor = "Java";
        String version = "1.0";
        String fac = TransformerFactory.class.getName();
        String impl = System.getProperty(fac);
        if (impl != null) {
            processor = "unknown";
            version = "unknown";
        } else {
            for (String saxon : SAXON) {
                Object xsl;
                if (Reflect.find(saxon) == null) continue;
                processor = "Saxon";
                System.setProperty(fac, saxon);
                Class<?> vrsn = Reflect.find("net.sf.saxon.Version");
                Object se = Reflect.get(Reflect.field(vrsn, "softwareEdition"), null);
                if (se != null) {
                    processor = processor + " " + se;
                }
                version = (xsl = Reflect.invoke(Reflect.method(vrsn, "getXSLVersionString", new Class[0]), null, new Object[0])) != null ? xsl.toString() : "3.0";
                break;
            }
        }
        PROCESSOR = processor;
        VERSION = version;
    }
}

