/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.util;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;

public final class UtilMapEntries
extends StandardFunc {
    private static final Str KEY = Str.get("key");
    private static final Str VALUE = Str.get("value");

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final XQMap map = this.toMap(this.exprs[0], qc);
        return new Iter(){
            final Iter keys;
            {
                this.keys = map.keys().iter();
            }

            @Override
            public XQMap next() throws QueryException {
                Item key = this.keys.next();
                return key != null ? UtilMapEntries.this.entry(map, key) : null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        XQMap map = this.toMap(this.exprs[0], qc);
        ValueBuilder vb = new ValueBuilder(qc);
        for (Item key : map.keys()) {
            vb.add(this.entry(map, key));
        }
        return vb.value(this);
    }

    private XQMap entry(XQMap map, Item key) throws QueryException {
        return XQMap.EMPTY.put(KEY, key, this.info).put(VALUE, map.get(key, this.info), this.info);
    }

    @Override
    protected Expr opt(CompileContext cc) {
        FuncType ft = this.exprs[0].funcType();
        if (ft instanceof MapType) {
            MapType mt = (MapType)ft;
            SeqType dt = ft.declType.union(mt.keyType().seqType()).with(Occ.ZERO_OR_MORE);
            this.exprType.assign(MapType.get(AtomType.STRING, dt));
        }
        return this;
    }
}

